# Generated by generate_python_ctypes.py.
import os, platform, sys
from ctypes import *
from ctypes.util import *
import re


# If we won't specify the correct allegro version al_install_system will fail
if 'ALLEGRO5_VERSION' not in os.environ:
    raise ValueError('You must specify allegro5 version you are using (format 5.x.x)')

v = os.environ['ALLEGRO5_VERSION']
m = re.match(r'5\.(\d+)\.(\d)+', v)
if not m:
    raise ValueError('ALLEGRO5_VERSION must follow the format 5.x.x')

ALLEGRO_WIP_VERSION = int(m.group(2))
ALLEGRO_SUB_VERSION = int(m.group(1))

if 'ALLEGRO5_DLL' not in os.environ:
    advise = ''
    bits = sizeof(c_voidp) * 8

    if os.name == 'nt':
        file = {32: 'allegro-i686-w64-mingw32-gcc-10.2.0-posix-dwarf-dynamic-5.x.x.x.zip',
                64: 'allegro-x86_64-w64-mingw32-gcc-10.2.0-posix-seh-dynamic-5.x.x.x.zip'}[bits]
        advise = f'Since you are on windows and your python interpreter is {bits}-bits, '+ \
                 f'you should download {file} ' + \
                 f'from https://github.com/liballeg/allegro5/releases/'
    if not advise:
        advise = "Please read https://github.com/liballeg/allegro_wiki/wiki/Quickstart if you haven't downloaded them yet\n"

    raise AttributeError("You have to specify a directory which contains allegro5 binaries by setting up " +  \
                         "os.environ['ALLEGRO5_DLL']\n" + \
                         advise)

_dir = os.environ['ALLEGRO5_DLL']
if not os.path.isdir(_dir):
    raise FileNotFoundError(f'{_dir} is not a valid directory')

# You must adjust this function to point ctypes to the A5 DLLs you are
# distributing.
_dlls = []
def _add_dll(path):
    try:
        # RTLD_GLOBAL is required under OSX for some reason (?)
        _dlls.append(CDLL(path, RTLD_GLOBAL))
    except OSError as e:
        # No need to fail here, might just be one of the addons.
        sys.stderr.write(f'Failed to load {path}')

if os.name == "mac":
    _dll_ext = ".dylib"
elif os.name == "nt":
    _dll_ext = ".dll"
elif os.name == "posix":
    if platform.mac_ver()[0]:
        _dll_ext = ".dylib"
    else:
        _dll_ext = ".so"
else:
    raise OSError('Unknown operating system')

files =[]
for file in os.listdir(_dir):
    if os.path.splitext(file)[1] == _dll_ext and 'debug' not in file:
        files.append(file)

# there is no need to load other dlls if directory contains a monolith
m = list(filter(lambda x: 'monolith' in x, files))
if m:
    _add_dll(os.path.join(_dir, m[0]))
else:
    [_add_dll(os.path.join(_dir, file)) for file in files]

if not _dlls:
    raise FileNotFoundError("No valid dll found in the specified dlls directory")

# We don't have information ready which A5 function is in which DLL,
# so we just try them all.
def _dll(func, ret, params):
    for dll in _dlls:
        try:
            f = dll[func]
            f.restype = ret
            f.argtypes = params
            if ret is _AL_UTF8String:
                # ctypes cannot do parameter conversion of the return type for us
                f.restype = c_char_p
                if sys.version_info[0] > 2: return lambda *x: f(*x).decode("utf8")
            return f
        except AttributeError: pass
    #sys.stderr.write("Cannot find function " + func + "\n")
    return lambda *args: None

# In Python3, all Python strings are unicode so we have to convert to
# UTF8 byte strings before passing to Allegro.
if sys.version_info[0] > 2:
    class _AL_UTF8String:
        def from_param(x):
            return x.encode("utf8")
else:
    _AL_UTF8String = c_char_p

if sizeof(c_voidp)*8 == 64:
    pass

ALLEGRO_ACC_ALPHA_SIZE = 11
ALLEGRO_ACC_BLUE_SIZE = 10
ALLEGRO_ACC_GREEN_SIZE = 9
ALLEGRO_ACC_RED_SIZE = 8
ALLEGRO_ADD = 0
ALLEGRO_ALIGN_CENTER = 1
ALLEGRO_ALIGN_CENTRE = 1
ALLEGRO_ALIGN_INTEGER = 4
ALLEGRO_ALIGN_LEFT = 0
ALLEGRO_ALIGN_RIGHT = 2
ALLEGRO_ALPHA = 2
ALLEGRO_ALPHA_FUNCTION = 20
ALLEGRO_ALPHA_SHIFT = 7
ALLEGRO_ALPHA_SIZE = 3
ALLEGRO_ALPHA_TEST = 16
ALLEGRO_ALPHA_TEST_VALUE = 21
ALLEGRO_AUDIO_DEPTH_FLOAT32 = 3
ALLEGRO_AUDIO_DEPTH_INT16 = 1
ALLEGRO_AUDIO_DEPTH_INT24 = 2
ALLEGRO_AUDIO_DEPTH_INT8 = 0
ALLEGRO_AUDIO_DEPTH_UINT16 = 9
ALLEGRO_AUDIO_DEPTH_UINT24 = 10
ALLEGRO_AUDIO_DEPTH_UINT8 = 8
ALLEGRO_AUDIO_DEPTH_UNSIGNED = 8
ALLEGRO_AUTO_CONVERT_BITMAPS = 31
ALLEGRO_AUX_BUFFERS = 13
ALLEGRO_BLUE_SHIFT = 6
ALLEGRO_BLUE_SIZE = 2
ALLEGRO_CAN_DRAW_INTO_BITMAP = 29
ALLEGRO_CHANNEL_CONF_1 = 16
ALLEGRO_CHANNEL_CONF_2 = 32
ALLEGRO_CHANNEL_CONF_3 = 48
ALLEGRO_CHANNEL_CONF_4 = 64
ALLEGRO_CHANNEL_CONF_5_1 = 81
ALLEGRO_CHANNEL_CONF_6_1 = 97
ALLEGRO_CHANNEL_CONF_7_1 = 113
ALLEGRO_COLOR_SIZE = 14
ALLEGRO_COMPATIBLE_DISPLAY = 24
ALLEGRO_CONST_COLOR = 8
ALLEGRO_CONVERT_BITMAP = 4096
ALLEGRO_DATE = 20210307
ALLEGRO_DEFAULT_DISPLAY_ADAPTER = -1
ALLEGRO_DEPTH_FUNCTION = 19
ALLEGRO_DEPTH_SIZE = 15
ALLEGRO_DEPTH_TEST = 18
ALLEGRO_DESKTOP_OPENGL = 0
ALLEGRO_DEST_COLOR = 5
ALLEGRO_DEST_MINUS_SRC = 2
ALLEGRO_DIRECT3D_INTERNAL = 8
ALLEGRO_DISPLAY_OPTIONS_COUNT = 35
ALLEGRO_DISPLAY_ORIENTATION_0_DEGREES = 1
ALLEGRO_DISPLAY_ORIENTATION_180_DEGREES = 4
ALLEGRO_DISPLAY_ORIENTATION_270_DEGREES = 8
ALLEGRO_DISPLAY_ORIENTATION_90_DEGREES = 2
ALLEGRO_DISPLAY_ORIENTATION_ALL = 15
ALLEGRO_DISPLAY_ORIENTATION_FACE_DOWN = 32
ALLEGRO_DISPLAY_ORIENTATION_FACE_UP = 16
ALLEGRO_DISPLAY_ORIENTATION_LANDSCAPE = 10
ALLEGRO_DISPLAY_ORIENTATION_PORTRAIT = 5
ALLEGRO_DISPLAY_ORIENTATION_UNKNOWN = 0
ALLEGRO_DONTCARE = 0
ALLEGRO_EVENT_AUDIO_STREAM_FINISHED = 514
ALLEGRO_EVENT_AUDIO_STREAM_FRAGMENT = 513
ALLEGRO_EVENT_DISPLAY_CLOSE = 42
ALLEGRO_EVENT_DISPLAY_CONNECTED = 60
ALLEGRO_EVENT_DISPLAY_DISCONNECTED = 61
ALLEGRO_EVENT_DISPLAY_EXPOSE = 40
ALLEGRO_EVENT_DISPLAY_FOUND = 44
ALLEGRO_EVENT_DISPLAY_HALT_DRAWING = 48
ALLEGRO_EVENT_DISPLAY_LOST = 43
ALLEGRO_EVENT_DISPLAY_ORIENTATION = 47
ALLEGRO_EVENT_DISPLAY_RESIZE = 41
ALLEGRO_EVENT_DISPLAY_RESUME_DRAWING = 49
ALLEGRO_EVENT_DISPLAY_SWITCH_IN = 45
ALLEGRO_EVENT_DISPLAY_SWITCH_OUT = 46
ALLEGRO_EVENT_JOYSTICK_AXIS = 1
ALLEGRO_EVENT_JOYSTICK_BUTTON_DOWN = 2
ALLEGRO_EVENT_JOYSTICK_BUTTON_UP = 3
ALLEGRO_EVENT_JOYSTICK_CONFIGURATION = 4
ALLEGRO_EVENT_KEY_CHAR = 11
ALLEGRO_EVENT_KEY_DOWN = 10
ALLEGRO_EVENT_KEY_UP = 12
ALLEGRO_EVENT_MENU_CLICK = 601
ALLEGRO_EVENT_MOUSE_AXES = 20
ALLEGRO_EVENT_MOUSE_BUTTON_DOWN = 21
ALLEGRO_EVENT_MOUSE_BUTTON_UP = 22
ALLEGRO_EVENT_MOUSE_ENTER_DISPLAY = 23
ALLEGRO_EVENT_MOUSE_LEAVE_DISPLAY = 24
ALLEGRO_EVENT_MOUSE_WARPED = 25
ALLEGRO_EVENT_NATIVE_DIALOG_CLOSE = 600
ALLEGRO_EVENT_TIMER = 30
ALLEGRO_EVENT_TOUCH_BEGIN = 50
ALLEGRO_EVENT_TOUCH_CANCEL = 53
ALLEGRO_EVENT_TOUCH_END = 51
ALLEGRO_EVENT_TOUCH_MOVE = 52
ALLEGRO_EVENT_VIDEO_FINISHED = 551
ALLEGRO_EVENT_VIDEO_FRAME_SHOW = 550
ALLEGRO_EXENAME_PATH = 6
ALLEGRO_FILECHOOSER_FILE_MUST_EXIST = 1
ALLEGRO_FILECHOOSER_FOLDER = 4
ALLEGRO_FILECHOOSER_MULTIPLE = 32
ALLEGRO_FILECHOOSER_PICTURES = 8
ALLEGRO_FILECHOOSER_SAVE = 2
ALLEGRO_FILECHOOSER_SHOW_HIDDEN = 16
ALLEGRO_FILEMODE_EXECUTE = 4
ALLEGRO_FILEMODE_HIDDEN = 8
ALLEGRO_FILEMODE_ISDIR = 32
ALLEGRO_FILEMODE_ISFILE = 16
ALLEGRO_FILEMODE_READ = 1
ALLEGRO_FILEMODE_WRITE = 2
ALLEGRO_FLIP_HORIZONTAL = 1
ALLEGRO_FLIP_VERTICAL = 2
ALLEGRO_FLOAT_COLOR = 20
ALLEGRO_FLOAT_DEPTH = 21
ALLEGRO_FORCE_LOCKING = 4
ALLEGRO_FOR_EACH_FS_ENTRY_ERROR = -1
ALLEGRO_FOR_EACH_FS_ENTRY_OK = 0
ALLEGRO_FOR_EACH_FS_ENTRY_SKIP = 1
ALLEGRO_FOR_EACH_FS_ENTRY_STOP = 2
ALLEGRO_FRAMELESS = 32
ALLEGRO_FULLSCREEN = 2
ALLEGRO_FULLSCREEN_WINDOW = 512
ALLEGRO_GENERATE_EXPOSE_EVENTS = 64
ALLEGRO_GREEN_SHIFT = 5
ALLEGRO_GREEN_SIZE = 1
ALLEGRO_GTK_TOPLEVEL_INTERNAL = 4096
ALLEGRO_INVERSE_ALPHA = 3
ALLEGRO_INVERSE_CONST_COLOR = 9
ALLEGRO_INVERSE_DEST_COLOR = 7
ALLEGRO_INVERSE_SRC_COLOR = 6
ALLEGRO_JOYFLAG_ANALOGUE = 2
ALLEGRO_JOYFLAG_DIGITAL = 1
ALLEGRO_KEEP_BITMAP_FORMAT = 2
ALLEGRO_KEEP_INDEX = 2048
ALLEGRO_KEYMOD_ACCENT1 = 4096
ALLEGRO_KEYMOD_ACCENT2 = 8192
ALLEGRO_KEYMOD_ACCENT3 = 16384
ALLEGRO_KEYMOD_ACCENT4 = 32768
ALLEGRO_KEYMOD_ALT = 4
ALLEGRO_KEYMOD_ALTGR = 64
ALLEGRO_KEYMOD_CAPSLOCK = 1024
ALLEGRO_KEYMOD_COMMAND = 128
ALLEGRO_KEYMOD_CTRL = 2
ALLEGRO_KEYMOD_INALTSEQ = 2048
ALLEGRO_KEYMOD_LWIN = 8
ALLEGRO_KEYMOD_MENU = 32
ALLEGRO_KEYMOD_NUMLOCK = 512
ALLEGRO_KEYMOD_RWIN = 16
ALLEGRO_KEYMOD_SCROLLLOCK = 256
ALLEGRO_KEYMOD_SHIFT = 1
ALLEGRO_KEY_0 = 27
ALLEGRO_KEY_1 = 28
ALLEGRO_KEY_2 = 29
ALLEGRO_KEY_3 = 30
ALLEGRO_KEY_4 = 31
ALLEGRO_KEY_5 = 32
ALLEGRO_KEY_6 = 33
ALLEGRO_KEY_7 = 34
ALLEGRO_KEY_8 = 35
ALLEGRO_KEY_9 = 36
ALLEGRO_KEY_A = 1
ALLEGRO_KEY_ABNT_C1 = 94
ALLEGRO_KEY_ALT = 219
ALLEGRO_KEY_ALTGR = 220
ALLEGRO_KEY_AT = 99
ALLEGRO_KEY_B = 2
ALLEGRO_KEY_BACK = 107
ALLEGRO_KEY_BACKQUOTE = 104
ALLEGRO_KEY_BACKSLASH = 70
ALLEGRO_KEY_BACKSLASH2 = 71
ALLEGRO_KEY_BACKSPACE = 63
ALLEGRO_KEY_BUTTON_A = 124
ALLEGRO_KEY_BUTTON_B = 125
ALLEGRO_KEY_BUTTON_L1 = 120
ALLEGRO_KEY_BUTTON_L2 = 122
ALLEGRO_KEY_BUTTON_R1 = 121
ALLEGRO_KEY_BUTTON_R2 = 123
ALLEGRO_KEY_BUTTON_X = 112
ALLEGRO_KEY_BUTTON_Y = 113
ALLEGRO_KEY_C = 3
ALLEGRO_KEY_CAPSLOCK = 226
ALLEGRO_KEY_CIRCUMFLEX = 100
ALLEGRO_KEY_CLOSEBRACE = 66
ALLEGRO_KEY_COLON2 = 101
ALLEGRO_KEY_COMMA = 72
ALLEGRO_KEY_COMMAND = 106
ALLEGRO_KEY_CONVERT = 97
ALLEGRO_KEY_D = 4
ALLEGRO_KEY_DELETE = 77
ALLEGRO_KEY_DOWN = 85
ALLEGRO_KEY_DPAD_CENTER = 111
ALLEGRO_KEY_DPAD_DOWN = 115
ALLEGRO_KEY_DPAD_LEFT = 116
ALLEGRO_KEY_DPAD_RIGHT = 117
ALLEGRO_KEY_DPAD_UP = 114
ALLEGRO_KEY_E = 5
ALLEGRO_KEY_END = 79
ALLEGRO_KEY_ENTER = 67
ALLEGRO_KEY_EQUALS = 62
ALLEGRO_KEY_ESCAPE = 59
ALLEGRO_KEY_F = 6
ALLEGRO_KEY_F1 = 47
ALLEGRO_KEY_F10 = 56
ALLEGRO_KEY_F11 = 57
ALLEGRO_KEY_F12 = 58
ALLEGRO_KEY_F2 = 48
ALLEGRO_KEY_F3 = 49
ALLEGRO_KEY_F4 = 50
ALLEGRO_KEY_F5 = 51
ALLEGRO_KEY_F6 = 52
ALLEGRO_KEY_F7 = 53
ALLEGRO_KEY_F8 = 54
ALLEGRO_KEY_F9 = 55
ALLEGRO_KEY_FULLSTOP = 73
ALLEGRO_KEY_G = 7
ALLEGRO_KEY_H = 8
ALLEGRO_KEY_HOME = 78
ALLEGRO_KEY_I = 9
ALLEGRO_KEY_INSERT = 76
ALLEGRO_KEY_J = 10
ALLEGRO_KEY_K = 11
ALLEGRO_KEY_KANA = 96
ALLEGRO_KEY_KANJI = 102
ALLEGRO_KEY_L = 12
ALLEGRO_KEY_LCTRL = 217
ALLEGRO_KEY_LEFT = 82
ALLEGRO_KEY_LSHIFT = 215
ALLEGRO_KEY_LWIN = 221
ALLEGRO_KEY_M = 13
ALLEGRO_KEY_MAX = 227
ALLEGRO_KEY_MENU = 223
ALLEGRO_KEY_MINUS = 61
ALLEGRO_KEY_MODIFIERS = 215
ALLEGRO_KEY_N = 14
ALLEGRO_KEY_NOCONVERT = 98
ALLEGRO_KEY_NUMLOCK = 225
ALLEGRO_KEY_O = 15
ALLEGRO_KEY_OPENBRACE = 65
ALLEGRO_KEY_P = 16
ALLEGRO_KEY_PAD_0 = 37
ALLEGRO_KEY_PAD_1 = 38
ALLEGRO_KEY_PAD_2 = 39
ALLEGRO_KEY_PAD_3 = 40
ALLEGRO_KEY_PAD_4 = 41
ALLEGRO_KEY_PAD_5 = 42
ALLEGRO_KEY_PAD_6 = 43
ALLEGRO_KEY_PAD_7 = 44
ALLEGRO_KEY_PAD_8 = 45
ALLEGRO_KEY_PAD_9 = 46
ALLEGRO_KEY_PAD_ASTERISK = 87
ALLEGRO_KEY_PAD_DELETE = 90
ALLEGRO_KEY_PAD_ENTER = 91
ALLEGRO_KEY_PAD_EQUALS = 103
ALLEGRO_KEY_PAD_MINUS = 88
ALLEGRO_KEY_PAD_PLUS = 89
ALLEGRO_KEY_PAD_SLASH = 86
ALLEGRO_KEY_PAUSE = 93
ALLEGRO_KEY_PGDN = 81
ALLEGRO_KEY_PGUP = 80
ALLEGRO_KEY_PRINTSCREEN = 92
ALLEGRO_KEY_Q = 17
ALLEGRO_KEY_QUOTE = 69
ALLEGRO_KEY_R = 18
ALLEGRO_KEY_RCTRL = 218
ALLEGRO_KEY_RIGHT = 83
ALLEGRO_KEY_RSHIFT = 216
ALLEGRO_KEY_RWIN = 222
ALLEGRO_KEY_S = 19
ALLEGRO_KEY_SCROLLLOCK = 224
ALLEGRO_KEY_SEARCH = 110
ALLEGRO_KEY_SELECT = 118
ALLEGRO_KEY_SEMICOLON = 68
ALLEGRO_KEY_SEMICOLON2 = 105
ALLEGRO_KEY_SLASH = 74
ALLEGRO_KEY_SPACE = 75
ALLEGRO_KEY_START = 119
ALLEGRO_KEY_T = 20
ALLEGRO_KEY_TAB = 64
ALLEGRO_KEY_THUMBL = 126
ALLEGRO_KEY_THUMBR = 127
ALLEGRO_KEY_TILDE = 60
ALLEGRO_KEY_U = 21
ALLEGRO_KEY_UNKNOWN = 128
ALLEGRO_KEY_UP = 84
ALLEGRO_KEY_V = 22
ALLEGRO_KEY_VOLUME_DOWN = 109
ALLEGRO_KEY_VOLUME_UP = 108
ALLEGRO_KEY_W = 23
ALLEGRO_KEY_X = 24
ALLEGRO_KEY_Y = 25
ALLEGRO_KEY_YEN = 95
ALLEGRO_KEY_Z = 26
ALLEGRO_LAST_PATH = 7
ALLEGRO_LINE_CAP_CLOSED = 4
ALLEGRO_LINE_CAP_NONE = 0
ALLEGRO_LINE_CAP_ROUND = 2
ALLEGRO_LINE_CAP_SQUARE = 1
ALLEGRO_LINE_CAP_TRIANGLE = 3
ALLEGRO_LINE_JOIN_BEVEL = 1
ALLEGRO_LINE_JOIN_MITER = 3
ALLEGRO_LINE_JOIN_MITRE = 3
ALLEGRO_LINE_JOIN_NONE = 0
ALLEGRO_LINE_JOIN_ROUND = 2
ALLEGRO_LOCK_READONLY = 1
ALLEGRO_LOCK_READWRITE = 0
ALLEGRO_LOCK_WRITEONLY = 2
ALLEGRO_MAG_LINEAR = 128
ALLEGRO_MASK_ALPHA = 8
ALLEGRO_MASK_BLUE = 4
ALLEGRO_MASK_DEPTH = 16
ALLEGRO_MASK_GREEN = 2
ALLEGRO_MASK_RED = 1
ALLEGRO_MASK_RGB = 7
ALLEGRO_MASK_RGBA = 15
ALLEGRO_MAXIMIZED = 8192
ALLEGRO_MAX_BITMAP_SIZE = 27
ALLEGRO_MAX_CHANNELS = 8
ALLEGRO_MEMORY_BITMAP = 1
ALLEGRO_MENU_ITEM_CHECKBOX = 1
ALLEGRO_MENU_ITEM_CHECKED = 2
ALLEGRO_MENU_ITEM_DISABLED = 4
ALLEGRO_MENU_ITEM_ENABLED = 0
ALLEGRO_MESSAGEBOX_ERROR = 2
ALLEGRO_MESSAGEBOX_OK_CANCEL = 4
ALLEGRO_MESSAGEBOX_QUESTION = 16
ALLEGRO_MESSAGEBOX_WARN = 1
ALLEGRO_MESSAGEBOX_YES_NO = 8
ALLEGRO_MINIMIZED = 1024
ALLEGRO_MIN_LINEAR = 64
ALLEGRO_MIPMAP = 256
ALLEGRO_MIXER_QUALITY_CUBIC = 274
ALLEGRO_MIXER_QUALITY_LINEAR = 273
ALLEGRO_MIXER_QUALITY_POINT = 272
ALLEGRO_MOUSE_MAX_EXTRA_AXES = 4
ALLEGRO_NEW_WINDOW_TITLE_MAX_SIZE = 255
ALLEGRO_NOFRAME = 32
ALLEGRO_NO_KERNING = -1
ALLEGRO_NO_PREMULTIPLIED_ALPHA = 512
ALLEGRO_NO_PRESERVE_TEXTURE = 8
ALLEGRO_NUM_BLEND_MODES = 10
ALLEGRO_NUM_BLEND_OPERATIONS = 3
ALLEGRO_NUM_PIXEL_FORMATS = 31
ALLEGRO_NUM_SYSTEM_MOUSE_CURSORS = 20
ALLEGRO_ONE = 1
ALLEGRO_OPENGL = 4
ALLEGRO_OPENGL_3_0 = 128
ALLEGRO_OPENGL_ES = 1
ALLEGRO_OPENGL_ES_PROFILE = 16384
ALLEGRO_OPENGL_FORWARD_COMPATIBLE = 256
ALLEGRO_OPENGL_MAJOR_VERSION = 33
ALLEGRO_OPENGL_MINOR_VERSION = 34
ALLEGRO_PI = 3.141592653589793
ALLEGRO_PIXEL_FORMAT_ABGR_8888 = 17
ALLEGRO_PIXEL_FORMAT_ABGR_8888_LE = 25
ALLEGRO_PIXEL_FORMAT_ABGR_F32 = 24
ALLEGRO_PIXEL_FORMAT_ANY = 0
ALLEGRO_PIXEL_FORMAT_ANY_15_NO_ALPHA = 3
ALLEGRO_PIXEL_FORMAT_ANY_16_NO_ALPHA = 4
ALLEGRO_PIXEL_FORMAT_ANY_16_WITH_ALPHA = 5
ALLEGRO_PIXEL_FORMAT_ANY_24_NO_ALPHA = 6
ALLEGRO_PIXEL_FORMAT_ANY_32_NO_ALPHA = 7
ALLEGRO_PIXEL_FORMAT_ANY_32_WITH_ALPHA = 8
ALLEGRO_PIXEL_FORMAT_ANY_NO_ALPHA = 1
ALLEGRO_PIXEL_FORMAT_ANY_WITH_ALPHA = 2
ALLEGRO_PIXEL_FORMAT_ARGB_1555 = 16
ALLEGRO_PIXEL_FORMAT_ARGB_4444 = 11
ALLEGRO_PIXEL_FORMAT_ARGB_8888 = 9
ALLEGRO_PIXEL_FORMAT_BGR_555 = 21
ALLEGRO_PIXEL_FORMAT_BGR_565 = 20
ALLEGRO_PIXEL_FORMAT_BGR_888 = 19
ALLEGRO_PIXEL_FORMAT_COMPRESSED_RGBA_DXT1 = 28
ALLEGRO_PIXEL_FORMAT_COMPRESSED_RGBA_DXT3 = 29
ALLEGRO_PIXEL_FORMAT_COMPRESSED_RGBA_DXT5 = 30
ALLEGRO_PIXEL_FORMAT_RGBA_4444 = 26
ALLEGRO_PIXEL_FORMAT_RGBA_5551 = 15
ALLEGRO_PIXEL_FORMAT_RGBA_8888 = 10
ALLEGRO_PIXEL_FORMAT_RGBX_8888 = 22
ALLEGRO_PIXEL_FORMAT_RGB_555 = 14
ALLEGRO_PIXEL_FORMAT_RGB_565 = 13
ALLEGRO_PIXEL_FORMAT_RGB_888 = 12
ALLEGRO_PIXEL_FORMAT_SINGLE_CHANNEL_8 = 27
ALLEGRO_PIXEL_FORMAT_XBGR_8888 = 18
ALLEGRO_PIXEL_FORMAT_XRGB_8888 = 23
ALLEGRO_PIXEL_SHADER = 2
ALLEGRO_PLAYMODE_BIDIR = 258
ALLEGRO_PLAYMODE_LOOP = 257
ALLEGRO_PLAYMODE_ONCE = 256
ALLEGRO_PRIM_ATTR_NUM = 15
ALLEGRO_PRIM_BUFFER_DYNAMIC = 4
ALLEGRO_PRIM_BUFFER_READWRITE = 8
ALLEGRO_PRIM_BUFFER_STATIC = 2
ALLEGRO_PRIM_BUFFER_STREAM = 1
ALLEGRO_PRIM_COLOR_ATTR = 2
ALLEGRO_PRIM_FLOAT_1 = 3
ALLEGRO_PRIM_FLOAT_2 = 0
ALLEGRO_PRIM_FLOAT_3 = 1
ALLEGRO_PRIM_FLOAT_4 = 4
ALLEGRO_PRIM_HALF_FLOAT_2 = 12
ALLEGRO_PRIM_HALF_FLOAT_4 = 13
ALLEGRO_PRIM_LINE_LIST = 0
ALLEGRO_PRIM_LINE_LOOP = 2
ALLEGRO_PRIM_LINE_STRIP = 1
ALLEGRO_PRIM_MAX_USER_ATTR = 10
ALLEGRO_PRIM_NORMALIZED_SHORT_2 = 8
ALLEGRO_PRIM_NORMALIZED_SHORT_4 = 9
ALLEGRO_PRIM_NORMALIZED_UBYTE_4 = 7
ALLEGRO_PRIM_NORMALIZED_USHORT_2 = 10
ALLEGRO_PRIM_NORMALIZED_USHORT_4 = 11
ALLEGRO_PRIM_NUM_TYPES = 7
ALLEGRO_PRIM_POINT_LIST = 6
ALLEGRO_PRIM_POSITION = 1
ALLEGRO_PRIM_QUALITY = 10
ALLEGRO_PRIM_SHORT_2 = 2
ALLEGRO_PRIM_SHORT_4 = 6
ALLEGRO_PRIM_TEX_COORD = 3
ALLEGRO_PRIM_TEX_COORD_PIXEL = 4
ALLEGRO_PRIM_TRIANGLE_FAN = 5
ALLEGRO_PRIM_TRIANGLE_LIST = 3
ALLEGRO_PRIM_TRIANGLE_STRIP = 4
ALLEGRO_PRIM_UBYTE_4 = 5
ALLEGRO_PRIM_USER_ATTR = 5
ALLEGRO_PROGRAMMABLE_PIPELINE = 2048
ALLEGRO_RED_SHIFT = 4
ALLEGRO_RED_SIZE = 0
ALLEGRO_RELEASE_NUMBER = 0
ALLEGRO_RENDER_ALWAYS = 1
ALLEGRO_RENDER_EQUAL = 3
ALLEGRO_RENDER_GREATER = 5
ALLEGRO_RENDER_GREATER_EQUAL = 7
ALLEGRO_RENDER_LESS = 2
ALLEGRO_RENDER_LESS_EQUAL = 4
ALLEGRO_RENDER_METHOD = 19
ALLEGRO_RENDER_NEVER = 0
ALLEGRO_RENDER_NOT_EQUAL = 6
ALLEGRO_REQUIRE = 1
ALLEGRO_RESIZABLE = 16
ALLEGRO_RESOURCES_PATH = 0
ALLEGRO_SAMPLES = 18
ALLEGRO_SAMPLE_BUFFERS = 17
ALLEGRO_SEEK_CUR = 1
ALLEGRO_SEEK_END = 2
ALLEGRO_SEEK_SET = 0
ALLEGRO_SHADER_AUTO = 0
ALLEGRO_SHADER_GLSL = 1
ALLEGRO_SHADER_HLSL = 2
ALLEGRO_SINGLE_BUFFER = 22
ALLEGRO_SRC_COLOR = 4
ALLEGRO_SRC_MINUS_DEST = 1
ALLEGRO_STATE_ALL = 65535
ALLEGRO_STATE_BITMAP = 10
ALLEGRO_STATE_BLENDER = 16
ALLEGRO_STATE_DISPLAY = 4
ALLEGRO_STATE_NEW_BITMAP_PARAMETERS = 2
ALLEGRO_STATE_NEW_DISPLAY_PARAMETERS = 1
ALLEGRO_STATE_NEW_FILE_INTERFACE = 32
ALLEGRO_STATE_PROJECTION_TRANSFORM = 256
ALLEGRO_STATE_TARGET_BITMAP = 8
ALLEGRO_STATE_TRANSFORM = 64
ALLEGRO_STENCIL_SIZE = 16
ALLEGRO_STEREO = 12
ALLEGRO_SUGGEST = 2
ALLEGRO_SUPPORTED_ORIENTATIONS = 32
ALLEGRO_SUPPORT_NPOT_BITMAP = 28
ALLEGRO_SUPPORT_SEPARATE_ALPHA = 30
ALLEGRO_SWAP_METHOD = 23
ALLEGRO_SYSTEM_ID_ANDROID = 1095648338
ALLEGRO_SYSTEM_ID_GP2XWIZ = 1464424992
ALLEGRO_SYSTEM_ID_IPHONE = 1229998159
ALLEGRO_SYSTEM_ID_MACOSX = 1330862112
ALLEGRO_SYSTEM_ID_RASPBERRYPI = 1380012880
ALLEGRO_SYSTEM_ID_SDL = 1396984882
ALLEGRO_SYSTEM_ID_UNKNOWN = 0
ALLEGRO_SYSTEM_ID_WINDOWS = 1464421956
ALLEGRO_SYSTEM_ID_XGLX = 1481067608
ALLEGRO_SYSTEM_MOUSE_CURSOR_ALT_SELECT = 18
ALLEGRO_SYSTEM_MOUSE_CURSOR_ARROW = 2
ALLEGRO_SYSTEM_MOUSE_CURSOR_BUSY = 3
ALLEGRO_SYSTEM_MOUSE_CURSOR_DEFAULT = 1
ALLEGRO_SYSTEM_MOUSE_CURSOR_EDIT = 5
ALLEGRO_SYSTEM_MOUSE_CURSOR_LINK = 17
ALLEGRO_SYSTEM_MOUSE_CURSOR_MOVE = 6
ALLEGRO_SYSTEM_MOUSE_CURSOR_NONE = 0
ALLEGRO_SYSTEM_MOUSE_CURSOR_PRECISION = 16
ALLEGRO_SYSTEM_MOUSE_CURSOR_PROGRESS = 15
ALLEGRO_SYSTEM_MOUSE_CURSOR_QUESTION = 4
ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_E = 10
ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_N = 7
ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_NE = 14
ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_NW = 11
ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_S = 9
ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_SE = 13
ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_SW = 12
ALLEGRO_SYSTEM_MOUSE_CURSOR_RESIZE_W = 8
ALLEGRO_SYSTEM_MOUSE_CURSOR_UNAVAILABLE = 19
ALLEGRO_TEMP_PATH = 1
ALLEGRO_TEXTLOG_MONOSPACE = 2
ALLEGRO_TEXTLOG_NO_CLOSE = 1
ALLEGRO_TOUCH_INPUT_MAX_TOUCH_COUNT = 16
ALLEGRO_TTF_MONOCHROME = 2
ALLEGRO_TTF_NO_AUTOHINT = 4
ALLEGRO_TTF_NO_KERNING = 1
ALLEGRO_UNSTABLE_BIT = 0
ALLEGRO_UPDATE_DISPLAY_REGION = 25
ALLEGRO_USER_DATA_PATH = 2
ALLEGRO_USER_DOCUMENTS_PATH = 5
ALLEGRO_USER_HOME_PATH = 3
ALLEGRO_USER_SETTINGS_PATH = 4
ALLEGRO_VERSION = 5
ALLEGRO_VERTEX_CACHE_SIZE = 256
ALLEGRO_VERTEX_SHADER = 1
ALLEGRO_VIDEO_BITMAP = 1024
ALLEGRO_VIDEO_POSITION_ACTUAL = 0
ALLEGRO_VIDEO_POSITION_AUDIO_DECODE = 2
ALLEGRO_VIDEO_POSITION_VIDEO_DECODE = 1
ALLEGRO_VSYNC = 26
ALLEGRO_WINDOWED = 1
ALLEGRO_WRITE_MASK = 17
ALLEGRO_ZERO = 0
_ALLEGRO_ALPHA_TEST = 16
_ALLEGRO_EVENT_VIDEO_SEEK = 552
_ALLEGRO_INTERNAL_OPENGL = 32
_ALLEGRO_KEEP_BITMAP_FORMAT = 2
_ALLEGRO_NO_PREMULTIPLIED_ALPHA = 512
_ALLEGRO_PLAYMODE_STREAM_ONCE = 259
_ALLEGRO_PLAYMODE_STREAM_ONEDIR = 260
_ALLEGRO_PRIM_MAX_USER_ATTR = 10
_KCM_STREAM_FEEDER_QUIT_EVENT_TYPE = 512
ALLEGRO_AUDIO_DEPTH = c_long
ALLEGRO_AUDIO_EVENT_TYPE = c_long
ALLEGRO_BLEND_MODE = c_long
ALLEGRO_BLEND_OPERATIONS = c_long
ALLEGRO_CHANNEL_CONF = c_long
ALLEGRO_DISPLAY_OPTIONS = c_long
ALLEGRO_DISPLAY_ORIENTATION = c_long
ALLEGRO_EVENT_TYPE = c_ulong
ALLEGRO_FILE_MODE = c_long
ALLEGRO_FOR_EACH_FS_ENTRY_RESULT = c_long
ALLEGRO_IIO_FS_LOADER_FUNCTION = c_void_p
ALLEGRO_IIO_FS_SAVER_FUNCTION = c_void_p
ALLEGRO_IIO_IDENTIFIER_FUNCTION = c_void_p
ALLEGRO_IIO_LOADER_FUNCTION = c_void_p
ALLEGRO_IIO_SAVER_FUNCTION = c_void_p
ALLEGRO_JOYFLAGS = c_long
ALLEGRO_LINE_CAP = c_long
ALLEGRO_LINE_JOIN = c_long
ALLEGRO_MIXER_QUALITY = c_long
ALLEGRO_OPENGL_VARIANT = c_long
ALLEGRO_PIXEL_FORMAT = c_long
ALLEGRO_PLAYMODE = c_long
ALLEGRO_PRIM_ATTR = c_long
ALLEGRO_PRIM_BUFFER_FLAGS = c_long
ALLEGRO_PRIM_STORAGE = c_long
ALLEGRO_PRIM_TYPE = c_long
ALLEGRO_RENDER_FUNCTION = c_long
ALLEGRO_RENDER_STATE = c_long
ALLEGRO_SEEK = c_long
ALLEGRO_SHADER_PLATFORM = c_long
ALLEGRO_SHADER_TYPE = c_long
ALLEGRO_STATE_FLAGS = c_long
ALLEGRO_SYSTEM_ID = c_long
ALLEGRO_SYSTEM_MOUSE_CURSOR = c_long
ALLEGRO_VIDEO_EVENT_TYPE = c_long
ALLEGRO_VIDEO_POSITION_TYPE = c_long
ALLEGRO_WRITE_MASK_FLAGS = c_long
class ALLEGRO_ANY_EVENT(Structure):
    _fields_ = [
    ("type", c_ulong),
    ("source", c_void_p),
    ("timestamp", c_double),
    ]
LP_ALLEGRO_ANY_EVENT = POINTER(ALLEGRO_ANY_EVENT)
class ALLEGRO_AUDIO_STREAM(Structure):
    pass
LP_ALLEGRO_AUDIO_STREAM = POINTER(ALLEGRO_AUDIO_STREAM)
class ALLEGRO_BITMAP(Structure):
    pass
LP_ALLEGRO_BITMAP = POINTER(ALLEGRO_BITMAP)
class ALLEGRO_COLOR(Structure):
    _fields_ = [
    ("r", c_float),
    ("g", c_float),
    ("b", c_float),
    ("a", c_float),
    ]
LP_ALLEGRO_COLOR = POINTER(ALLEGRO_COLOR)
class ALLEGRO_COND(Structure):
    pass
LP_ALLEGRO_COND = POINTER(ALLEGRO_COND)
class ALLEGRO_CONFIG(Structure):
    pass
LP_ALLEGRO_CONFIG = POINTER(ALLEGRO_CONFIG)
class ALLEGRO_CONFIG_ENTRY(Structure):
    pass
LP_ALLEGRO_CONFIG_ENTRY = POINTER(ALLEGRO_CONFIG_ENTRY)
class ALLEGRO_CONFIG_SECTION(Structure):
    pass
LP_ALLEGRO_CONFIG_SECTION = POINTER(ALLEGRO_CONFIG_SECTION)
class ALLEGRO_DISPLAY(Structure):
    pass
LP_ALLEGRO_DISPLAY = POINTER(ALLEGRO_DISPLAY)
class ALLEGRO_DISPLAY_EVENT(Structure):
    _fields_ = [
    ("type", c_ulong),
    ("source", c_void_p),
    ("timestamp", c_double),
    ("x", c_long),
    ("y", c_long),
    ("width", c_long),
    ("height", c_long),
    ("orientation", c_long),
    ]
LP_ALLEGRO_DISPLAY_EVENT = POINTER(ALLEGRO_DISPLAY_EVENT)
class ALLEGRO_DISPLAY_MODE(Structure):
    _fields_ = [
    ("width", c_long),
    ("height", c_long),
    ("format", c_long),
    ("refresh_rate", c_long),
    ]
LP_ALLEGRO_DISPLAY_MODE = POINTER(ALLEGRO_DISPLAY_MODE)
class ALLEGRO_EVENT_QUEUE(Structure):
    pass
LP_ALLEGRO_EVENT_QUEUE = POINTER(ALLEGRO_EVENT_QUEUE)
class ALLEGRO_EVENT_SOURCE(Structure):
    _fields_ = [
    ("__pad", c_long * 32),
    ]
LP_ALLEGRO_EVENT_SOURCE = POINTER(ALLEGRO_EVENT_SOURCE)
class ALLEGRO_FILE(Structure):
    pass
LP_ALLEGRO_FILE = POINTER(ALLEGRO_FILE)
class ALLEGRO_FILECHOOSER(Structure):
    pass
LP_ALLEGRO_FILECHOOSER = POINTER(ALLEGRO_FILECHOOSER)
class ALLEGRO_FILE_INTERFACE(Structure):
    _fields_ = [
    ("fi_fopen", c_void_p),
    ("fi_fclose", c_void_p),
    ("fi_fread", c_void_p),
    ("fi_fwrite", c_void_p),
    ("fi_fflush", c_void_p),
    ("fi_ftell", c_void_p),
    ("fi_fseek", c_void_p),
    ("fi_feof", c_void_p),
    ("fi_ferror", c_void_p),
    ("fi_ferrmsg", c_void_p),
    ("fi_fclearerr", c_void_p),
    ("fi_fungetc", c_void_p),
    ("fi_fsize", c_void_p),
    ]
LP_ALLEGRO_FILE_INTERFACE = POINTER(ALLEGRO_FILE_INTERFACE)
class ALLEGRO_FONT(Structure):
    pass
LP_ALLEGRO_FONT = POINTER(ALLEGRO_FONT)
class ALLEGRO_FS_ENTRY(Structure):
    _fields_ = [
    ("vtable", c_void_p),
    ]
LP_ALLEGRO_FS_ENTRY = POINTER(ALLEGRO_FS_ENTRY)
class ALLEGRO_FS_INTERFACE(Structure):
    _fields_ = [
    ("fs_create_entry", c_void_p),
    ("fs_destroy_entry", c_void_p),
    ("fs_entry_name", c_void_p),
    ("fs_update_entry", c_void_p),
    ("fs_entry_mode", c_void_p),
    ("fs_entry_atime", c_void_p),
    ("fs_entry_mtime", c_void_p),
    ("fs_entry_ctime", c_void_p),
    ("fs_entry_size", c_void_p),
    ("fs_entry_exists", c_void_p),
    ("fs_remove_entry", c_void_p),
    ("fs_open_directory", c_void_p),
    ("fs_read_directory", c_void_p),
    ("fs_close_directory", c_void_p),
    ("fs_filename_exists", c_void_p),
    ("fs_remove_filename", c_void_p),
    ("fs_get_current_directory", c_void_p),
    ("fs_change_directory", c_void_p),
    ("fs_make_directory", c_void_p),
    ("fs_open_file", c_void_p),
    ]
LP_ALLEGRO_FS_INTERFACE = POINTER(ALLEGRO_FS_INTERFACE)
class ALLEGRO_INDEX_BUFFER(Structure):
    pass
LP_ALLEGRO_INDEX_BUFFER = POINTER(ALLEGRO_INDEX_BUFFER)
class ALLEGRO_JOYSTICK(Structure):
    pass
LP_ALLEGRO_JOYSTICK = POINTER(ALLEGRO_JOYSTICK)
class ALLEGRO_JOYSTICK_EVENT(Structure):
    _fields_ = [
    ("type", c_ulong),
    ("source", c_void_p),
    ("timestamp", c_double),
    ("id", c_void_p),
    ("stick", c_long),
    ("axis", c_long),
    ("pos", c_float),
    ("button", c_long),
    ]
LP_ALLEGRO_JOYSTICK_EVENT = POINTER(ALLEGRO_JOYSTICK_EVENT)
class ALLEGRO_JOYSTICK_STATE(Structure):
    _fields_ = [
    ("stick", c_float * 3),
    ("button", c_long * 32),
    ]
LP_ALLEGRO_JOYSTICK_STATE = POINTER(ALLEGRO_JOYSTICK_STATE)
class ALLEGRO_KEYBOARD(Structure):
    pass
LP_ALLEGRO_KEYBOARD = POINTER(ALLEGRO_KEYBOARD)
class ALLEGRO_KEYBOARD_EVENT(Structure):
    _fields_ = [
    ("type", c_ulong),
    ("source", c_void_p),
    ("timestamp", c_double),
    ("display", c_void_p),
    ("keycode", c_long),
    ("unichar", c_long),
    ("modifiers", c_ulong),
    ("repeat", c_bool),
    ]
LP_ALLEGRO_KEYBOARD_EVENT = POINTER(ALLEGRO_KEYBOARD_EVENT)
class ALLEGRO_KEYBOARD_STATE(Structure):
    _fields_ = [
    ("display", c_void_p),
    ("__key_down__internal__", c_ulong * ((ALLEGRO_KEY_MAX + 31) // 32)),
    ]
LP_ALLEGRO_KEYBOARD_STATE = POINTER(ALLEGRO_KEYBOARD_STATE)
class ALLEGRO_LOCKED_REGION(Structure):
    _fields_ = [
    ("data", c_void_p),
    ("format", c_long),
    ("pitch", c_long),
    ("pixel_size", c_long),
    ]
LP_ALLEGRO_LOCKED_REGION = POINTER(ALLEGRO_LOCKED_REGION)
class ALLEGRO_MEMORY_INTERFACE(Structure):
    _fields_ = [
    ("mi_malloc", c_void_p),
    ("mi_free", c_void_p),
    ("mi_realloc", c_void_p),
    ("mi_calloc", c_void_p),
    ]
LP_ALLEGRO_MEMORY_INTERFACE = POINTER(ALLEGRO_MEMORY_INTERFACE)
class ALLEGRO_MENU(Structure):
    pass
LP_ALLEGRO_MENU = POINTER(ALLEGRO_MENU)
class ALLEGRO_MENU_INFO(Structure):
    _fields_ = [
    ("caption", c_void_p),
    ("id", c_ushort),
    ("flags", c_long),
    ("icon", c_void_p),
    ]
LP_ALLEGRO_MENU_INFO = POINTER(ALLEGRO_MENU_INFO)
class ALLEGRO_MIXER(Structure):
    pass
LP_ALLEGRO_MIXER = POINTER(ALLEGRO_MIXER)
class ALLEGRO_MONITOR_INFO(Structure):
    _fields_ = [
    ("x1", c_long),
    ("y1", c_long),
    ("x2", c_long),
    ("y2", c_long),
    ]
LP_ALLEGRO_MONITOR_INFO = POINTER(ALLEGRO_MONITOR_INFO)
class ALLEGRO_MOUSE(Structure):
    pass
LP_ALLEGRO_MOUSE = POINTER(ALLEGRO_MOUSE)
class ALLEGRO_MOUSE_CURSOR(Structure):
    pass
LP_ALLEGRO_MOUSE_CURSOR = POINTER(ALLEGRO_MOUSE_CURSOR)
class ALLEGRO_MOUSE_EVENT(Structure):
    _fields_ = [
    ("type", c_ulong),
    ("source", c_void_p),
    ("timestamp", c_double),
    ("display", c_void_p),
    ("x", c_long),
    ("y", c_long),
    ("z", c_long),
    ("w", c_long),
    ("dx", c_long),
    ("dy", c_long),
    ("dz", c_long),
    ("dw", c_long),
    ("button", c_ulong),
    ("pressure", c_float),
    ]
LP_ALLEGRO_MOUSE_EVENT = POINTER(ALLEGRO_MOUSE_EVENT)
class ALLEGRO_MOUSE_STATE(Structure):
    _fields_ = [
    ("x", c_long),
    ("y", c_long),
    ("z", c_long),
    ("w", c_long),
    ("more_axes", c_long * 4),
    ("buttons", c_long),
    ("pressure", c_float),
    ("display", c_void_p),
    ]
LP_ALLEGRO_MOUSE_STATE = POINTER(ALLEGRO_MOUSE_STATE)
class ALLEGRO_MUTEX(Structure):
    pass
LP_ALLEGRO_MUTEX = POINTER(ALLEGRO_MUTEX)
class ALLEGRO_OGL_EXT_LIST(Structure):
    pass
LP_ALLEGRO_OGL_EXT_LIST = POINTER(ALLEGRO_OGL_EXT_LIST)
class ALLEGRO_PATH(Structure):
    pass
LP_ALLEGRO_PATH = POINTER(ALLEGRO_PATH)
class ALLEGRO_SAMPLE(Structure):
    pass
LP_ALLEGRO_SAMPLE = POINTER(ALLEGRO_SAMPLE)
class ALLEGRO_SAMPLE_ID(Structure):
    _fields_ = [
    ("_index", c_long),
    ("_id", c_long),
    ]
LP_ALLEGRO_SAMPLE_ID = POINTER(ALLEGRO_SAMPLE_ID)
class ALLEGRO_SAMPLE_INSTANCE(Structure):
    pass
LP_ALLEGRO_SAMPLE_INSTANCE = POINTER(ALLEGRO_SAMPLE_INSTANCE)
class ALLEGRO_SHADER(Structure):
    pass
LP_ALLEGRO_SHADER = POINTER(ALLEGRO_SHADER)
class ALLEGRO_STATE(Structure):
    _fields_ = [
    ("_tls", c_byte * 1024),
    ]
LP_ALLEGRO_STATE = POINTER(ALLEGRO_STATE)
class ALLEGRO_SYSTEM(Structure):
    pass
LP_ALLEGRO_SYSTEM = POINTER(ALLEGRO_SYSTEM)
class ALLEGRO_TEXTLOG(Structure):
    pass
LP_ALLEGRO_TEXTLOG = POINTER(ALLEGRO_TEXTLOG)
class ALLEGRO_THREAD(Structure):
    pass
LP_ALLEGRO_THREAD = POINTER(ALLEGRO_THREAD)
class ALLEGRO_TIMEOUT(Structure):
    _fields_ = [
    ("__pad1__", c_ulonglong),
    ("__pad2__", c_ulonglong),
    ]
LP_ALLEGRO_TIMEOUT = POINTER(ALLEGRO_TIMEOUT)
class ALLEGRO_TIMER(Structure):
    pass
LP_ALLEGRO_TIMER = POINTER(ALLEGRO_TIMER)
class ALLEGRO_TIMER_EVENT(Structure):
    _fields_ = [
    ("type", c_ulong),
    ("source", c_void_p),
    ("timestamp", c_double),
    ("count", c_longlong),
    ("error", c_double),
    ]
LP_ALLEGRO_TIMER_EVENT = POINTER(ALLEGRO_TIMER_EVENT)
class ALLEGRO_TOUCH_EVENT(Structure):
    _fields_ = [
    ("type", c_ulong),
    ("source", c_void_p),
    ("timestamp", c_double),
    ("display", c_void_p),
    ("id", c_long),
    ("x", c_float),
    ("y", c_float),
    ("dx", c_float),
    ("dy", c_float),
    ("primary", c_bool),
    ]
LP_ALLEGRO_TOUCH_EVENT = POINTER(ALLEGRO_TOUCH_EVENT)
class ALLEGRO_TOUCH_INPUT(Structure):
    pass
LP_ALLEGRO_TOUCH_INPUT = POINTER(ALLEGRO_TOUCH_INPUT)
class ALLEGRO_TOUCH_STATE(Structure):
    _fields_ = [
    ("id", c_long),
    ("x", c_float),
    ("y", c_float),
    ("dx", c_float),
    ("dy", c_float),
    ("primary", c_bool),
    ("display", c_void_p),
    ]
LP_ALLEGRO_TOUCH_STATE = POINTER(ALLEGRO_TOUCH_STATE)
class ALLEGRO_TRANSFORM(Structure):
    _fields_ = [
    ("m", c_float * 4 * 4),
    ]
LP_ALLEGRO_TRANSFORM = POINTER(ALLEGRO_TRANSFORM)
class ALLEGRO_USER_EVENT(Structure):
    _fields_ = [
    ("type", c_ulong),
    ("source", c_void_p),
    ("timestamp", c_double),
    ("__internal__descr", c_void_p),
    ("data1", c_void_p),
    ("data2", c_void_p),
    ("data3", c_void_p),
    ("data4", c_void_p),
    ]
LP_ALLEGRO_USER_EVENT = POINTER(ALLEGRO_USER_EVENT)
class ALLEGRO_USTR(Structure):
    pass
LP_ALLEGRO_USTR = POINTER(ALLEGRO_USTR)
class ALLEGRO_USTR_INFO(Structure):
    pass
LP_ALLEGRO_USTR_INFO = POINTER(ALLEGRO_USTR_INFO)
class ALLEGRO_VERTEX(Structure):
    _fields_ = [
    ("x", c_float),
    ("y", c_float),
    ("z", c_float),
    ("u", c_float),
    ("v", c_float),
    ("color", ALLEGRO_COLOR),
    ]
LP_ALLEGRO_VERTEX = POINTER(ALLEGRO_VERTEX)
class ALLEGRO_VERTEX_BUFFER(Structure):
    pass
LP_ALLEGRO_VERTEX_BUFFER = POINTER(ALLEGRO_VERTEX_BUFFER)
class ALLEGRO_VERTEX_DECL(Structure):
    pass
LP_ALLEGRO_VERTEX_DECL = POINTER(ALLEGRO_VERTEX_DECL)
class ALLEGRO_VERTEX_ELEMENT(Structure):
    _fields_ = [
    ("attribute", c_long),
    ("storage", c_long),
    ("offset", c_long),
    ]
LP_ALLEGRO_VERTEX_ELEMENT = POINTER(ALLEGRO_VERTEX_ELEMENT)
class ALLEGRO_VIDEO(Structure):
    pass
LP_ALLEGRO_VIDEO = POINTER(ALLEGRO_VIDEO)
class ALLEGRO_VOICE(Structure):
    pass
LP_ALLEGRO_VOICE = POINTER(ALLEGRO_VOICE)
class ALLEGRO_EVENT(Union):
    _fields_ = [
    ("type", c_ulong),
    ("any", ALLEGRO_ANY_EVENT),
    ("display", ALLEGRO_DISPLAY_EVENT),
    ("joystick", ALLEGRO_JOYSTICK_EVENT),
    ("keyboard", ALLEGRO_KEYBOARD_EVENT),
    ("mouse", ALLEGRO_MOUSE_EVENT),
    ("timer", ALLEGRO_TIMER_EVENT),
    ("touch", ALLEGRO_TOUCH_EVENT),
    ("user", ALLEGRO_USER_EVENT),
    ]
LP_ALLEGRO_EVENT = POINTER(ALLEGRO_EVENT)
class ALLEGRO_TOUCH_INPUT_STATE(Structure):
    _fields_ = [
    ("touches", ALLEGRO_TOUCH_STATE * 16),
    ]
LP_ALLEGRO_TOUCH_INPUT_STATE = POINTER(ALLEGRO_TOUCH_INPUT_STATE)
al_acknowledge_drawing_halt = _dll("al_acknowledge_drawing_halt", c_long, [LP_ALLEGRO_DISPLAY])
al_acknowledge_drawing_resume = _dll("al_acknowledge_drawing_resume", c_long, [LP_ALLEGRO_DISPLAY])
al_acknowledge_resize = _dll("al_acknowledge_resize", c_bool, [LP_ALLEGRO_DISPLAY])
al_add_config_comment = _dll("al_add_config_comment", c_long, [LP_ALLEGRO_CONFIG, _AL_UTF8String, _AL_UTF8String])
al_add_config_section = _dll("al_add_config_section", c_long, [LP_ALLEGRO_CONFIG, _AL_UTF8String])
al_add_new_bitmap_flag = _dll("al_add_new_bitmap_flag", c_long, [c_long])
al_add_timer_count = _dll("al_add_timer_count", c_long, [LP_ALLEGRO_TIMER, c_longlong])
al_append_menu_item = _dll("al_append_menu_item", c_long, [LP_ALLEGRO_MENU, _AL_UTF8String, c_ushort, c_long, LP_ALLEGRO_BITMAP, LP_ALLEGRO_MENU])
al_append_native_text_log = _dll("al_append_native_text_log", c_long, [LP_ALLEGRO_TEXTLOG, _AL_UTF8String])
al_append_path_component = _dll("al_append_path_component", c_long, [LP_ALLEGRO_PATH, _AL_UTF8String])
al_apply_window_constraints = _dll("al_apply_window_constraints", c_long, [LP_ALLEGRO_DISPLAY, c_bool])
al_attach_audio_stream_to_mixer = _dll("al_attach_audio_stream_to_mixer", c_bool, [LP_ALLEGRO_AUDIO_STREAM, LP_ALLEGRO_MIXER])
al_attach_audio_stream_to_voice = _dll("al_attach_audio_stream_to_voice", c_bool, [LP_ALLEGRO_AUDIO_STREAM, LP_ALLEGRO_VOICE])
al_attach_mixer_to_mixer = _dll("al_attach_mixer_to_mixer", c_bool, [LP_ALLEGRO_MIXER, LP_ALLEGRO_MIXER])
al_attach_mixer_to_voice = _dll("al_attach_mixer_to_voice", c_bool, [LP_ALLEGRO_MIXER, LP_ALLEGRO_VOICE])
al_attach_sample_instance_to_mixer = _dll("al_attach_sample_instance_to_mixer", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE, LP_ALLEGRO_MIXER])
al_attach_sample_instance_to_voice = _dll("al_attach_sample_instance_to_voice", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE, LP_ALLEGRO_VOICE])
al_attach_shader_source = _dll("al_attach_shader_source", c_bool, [LP_ALLEGRO_SHADER, c_long, _AL_UTF8String])
al_attach_shader_source_file = _dll("al_attach_shader_source_file", c_bool, [LP_ALLEGRO_SHADER, c_long, _AL_UTF8String])
al_broadcast_cond = _dll("al_broadcast_cond", c_long, [LP_ALLEGRO_COND])
al_build_camera_transform = _dll("al_build_camera_transform", c_long, [LP_ALLEGRO_TRANSFORM, c_float, c_float, c_float, c_float, c_float, c_float, c_float, c_float, c_float])
al_build_menu = _dll("al_build_menu", LP_ALLEGRO_MENU, [LP_ALLEGRO_MENU_INFO])
al_build_shader = _dll("al_build_shader", c_bool, [LP_ALLEGRO_SHADER])
al_build_transform = _dll("al_build_transform", c_long, [LP_ALLEGRO_TRANSFORM, c_float, c_float, c_float, c_float, c_float])
al_calculate_arc = _dll("al_calculate_arc", c_long, [c_void_p, c_long, c_float, c_float, c_float, c_float, c_float, c_float, c_float, c_long])
al_calculate_ribbon = _dll("al_calculate_ribbon", c_long, [c_void_p, c_long, c_void_p, c_long, c_float, c_long])
al_calculate_spline = _dll("al_calculate_spline", c_long, [c_void_p, c_long, c_void_p, c_float, c_long])
al_calloc_with_context = _dll("al_calloc_with_context", c_void_p, [c_ulong, c_ulong, c_long, _AL_UTF8String, _AL_UTF8String])
al_change_directory = _dll("al_change_directory", c_bool, [_AL_UTF8String])
al_check_inverse = _dll("al_check_inverse", c_long, [LP_ALLEGRO_TRANSFORM, c_float])
al_clear_depth_buffer = _dll("al_clear_depth_buffer", c_long, [c_float])
al_clear_to_color = _dll("al_clear_to_color", c_long, [ALLEGRO_COLOR])
al_clipboard_has_text = _dll("al_clipboard_has_text", c_bool, [LP_ALLEGRO_DISPLAY])
al_clone_bitmap = _dll("al_clone_bitmap", LP_ALLEGRO_BITMAP, [LP_ALLEGRO_BITMAP])
al_clone_menu = _dll("al_clone_menu", LP_ALLEGRO_MENU, [LP_ALLEGRO_MENU])
al_clone_menu_for_popup = _dll("al_clone_menu_for_popup", LP_ALLEGRO_MENU, [LP_ALLEGRO_MENU])
al_clone_path = _dll("al_clone_path", LP_ALLEGRO_PATH, [LP_ALLEGRO_PATH])
al_close_directory = _dll("al_close_directory", c_bool, [LP_ALLEGRO_FS_ENTRY])
al_close_native_text_log = _dll("al_close_native_text_log", c_long, [LP_ALLEGRO_TEXTLOG])
al_close_video = _dll("al_close_video", c_long, [LP_ALLEGRO_VIDEO])
al_color_cmyk = _dll("al_color_cmyk", ALLEGRO_COLOR, [c_float, c_float, c_float, c_float])
al_color_cmyk_to_rgb = _dll("al_color_cmyk_to_rgb", c_long, [c_float, c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_distance_ciede2000 = _dll("al_color_distance_ciede2000", c_double, [ALLEGRO_COLOR, ALLEGRO_COLOR])
al_color_hsl = _dll("al_color_hsl", ALLEGRO_COLOR, [c_float, c_float, c_float])
al_color_hsl_to_rgb = _dll("al_color_hsl_to_rgb", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_hsv = _dll("al_color_hsv", ALLEGRO_COLOR, [c_float, c_float, c_float])
al_color_hsv_to_rgb = _dll("al_color_hsv_to_rgb", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_html = _dll("al_color_html", ALLEGRO_COLOR, [_AL_UTF8String])
al_color_html_to_rgb = _dll("al_color_html_to_rgb", c_bool, [_AL_UTF8String, c_void_p, c_void_p, c_void_p])
al_color_lab = _dll("al_color_lab", ALLEGRO_COLOR, [c_float, c_float, c_float])
al_color_lab_to_rgb = _dll("al_color_lab_to_rgb", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_lch = _dll("al_color_lch", ALLEGRO_COLOR, [c_float, c_float, c_float])
al_color_lch_to_rgb = _dll("al_color_lch_to_rgb", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_name = _dll("al_color_name", ALLEGRO_COLOR, [_AL_UTF8String])
al_color_name_to_rgb = _dll("al_color_name_to_rgb", c_bool, [_AL_UTF8String, c_void_p, c_void_p, c_void_p])
al_color_rgb_to_cmyk = _dll("al_color_rgb_to_cmyk", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p, c_void_p])
al_color_rgb_to_hsl = _dll("al_color_rgb_to_hsl", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_rgb_to_hsv = _dll("al_color_rgb_to_hsv", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_rgb_to_html = _dll("al_color_rgb_to_html", c_long, [c_float, c_float, c_float, _AL_UTF8String])
al_color_rgb_to_lab = _dll("al_color_rgb_to_lab", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_rgb_to_lch = _dll("al_color_rgb_to_lch", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_rgb_to_name = _dll("al_color_rgb_to_name", _AL_UTF8String, [c_float, c_float, c_float])
al_color_rgb_to_xyy = _dll("al_color_rgb_to_xyy", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_rgb_to_xyz = _dll("al_color_rgb_to_xyz", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_rgb_to_yuv = _dll("al_color_rgb_to_yuv", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_xyy = _dll("al_color_xyy", ALLEGRO_COLOR, [c_float, c_float, c_float])
al_color_xyy_to_rgb = _dll("al_color_xyy_to_rgb", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_xyz = _dll("al_color_xyz", ALLEGRO_COLOR, [c_float, c_float, c_float])
al_color_xyz_to_rgb = _dll("al_color_xyz_to_rgb", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_color_yuv = _dll("al_color_yuv", ALLEGRO_COLOR, [c_float, c_float, c_float])
al_color_yuv_to_rgb = _dll("al_color_yuv_to_rgb", c_long, [c_float, c_float, c_float, c_void_p, c_void_p, c_void_p])
al_compose_transform = _dll("al_compose_transform", c_long, [LP_ALLEGRO_TRANSFORM, LP_ALLEGRO_TRANSFORM])
al_convert_bitmap = _dll("al_convert_bitmap", c_long, [LP_ALLEGRO_BITMAP])
al_convert_mask_to_alpha = _dll("al_convert_mask_to_alpha", c_long, [LP_ALLEGRO_BITMAP, ALLEGRO_COLOR])
al_convert_memory_bitmaps = _dll("al_convert_memory_bitmaps", c_long, [])
al_copy_transform = _dll("al_copy_transform", c_long, [LP_ALLEGRO_TRANSFORM, LP_ALLEGRO_TRANSFORM])
al_create_audio_stream = _dll("al_create_audio_stream", LP_ALLEGRO_AUDIO_STREAM, [c_ulong, c_ulong, c_ulong, c_long, c_long])
al_create_bitmap = _dll("al_create_bitmap", LP_ALLEGRO_BITMAP, [c_long, c_long])
al_create_builtin_font = _dll("al_create_builtin_font", LP_ALLEGRO_FONT, [])
al_create_cond = _dll("al_create_cond", LP_ALLEGRO_COND, [])
al_create_config = _dll("al_create_config", LP_ALLEGRO_CONFIG, [])
al_create_display = _dll("al_create_display", LP_ALLEGRO_DISPLAY, [c_long, c_long])
al_create_event_queue = _dll("al_create_event_queue", LP_ALLEGRO_EVENT_QUEUE, [])
al_create_file_handle = _dll("al_create_file_handle", LP_ALLEGRO_FILE, [LP_ALLEGRO_FILE_INTERFACE, c_void_p])
al_create_fs_entry = _dll("al_create_fs_entry", LP_ALLEGRO_FS_ENTRY, [_AL_UTF8String])
al_create_index_buffer = _dll("al_create_index_buffer", LP_ALLEGRO_INDEX_BUFFER, [c_long, c_void_p, c_long, c_long])
al_create_menu = _dll("al_create_menu", LP_ALLEGRO_MENU, [])
al_create_mixer = _dll("al_create_mixer", LP_ALLEGRO_MIXER, [c_ulong, c_long, c_long])
al_create_mouse_cursor = _dll("al_create_mouse_cursor", LP_ALLEGRO_MOUSE_CURSOR, [LP_ALLEGRO_BITMAP, c_long, c_long])
al_create_mutex = _dll("al_create_mutex", LP_ALLEGRO_MUTEX, [])
al_create_mutex_recursive = _dll("al_create_mutex_recursive", LP_ALLEGRO_MUTEX, [])
al_create_native_file_dialog = _dll("al_create_native_file_dialog", LP_ALLEGRO_FILECHOOSER, [_AL_UTF8String, _AL_UTF8String, _AL_UTF8String, c_long])
al_create_path = _dll("al_create_path", LP_ALLEGRO_PATH, [_AL_UTF8String])
al_create_path_for_directory = _dll("al_create_path_for_directory", LP_ALLEGRO_PATH, [_AL_UTF8String])
al_create_popup_menu = _dll("al_create_popup_menu", LP_ALLEGRO_MENU, [])
al_create_sample = _dll("al_create_sample", LP_ALLEGRO_SAMPLE, [c_void_p, c_ulong, c_ulong, c_long, c_long, c_bool])
al_create_sample_instance = _dll("al_create_sample_instance", LP_ALLEGRO_SAMPLE_INSTANCE, [LP_ALLEGRO_SAMPLE])
al_create_shader = _dll("al_create_shader", LP_ALLEGRO_SHADER, [c_long])
al_create_sub_bitmap = _dll("al_create_sub_bitmap", LP_ALLEGRO_BITMAP, [LP_ALLEGRO_BITMAP, c_long, c_long, c_long, c_long])
al_create_thread = _dll("al_create_thread", LP_ALLEGRO_THREAD, [c_void_p, c_void_p])
al_create_timer = _dll("al_create_timer", LP_ALLEGRO_TIMER, [c_double])
al_create_vertex_buffer = _dll("al_create_vertex_buffer", LP_ALLEGRO_VERTEX_BUFFER, [LP_ALLEGRO_VERTEX_DECL, c_void_p, c_long, c_long])
al_create_vertex_decl = _dll("al_create_vertex_decl", LP_ALLEGRO_VERTEX_DECL, [LP_ALLEGRO_VERTEX_ELEMENT, c_long])
al_create_voice = _dll("al_create_voice", LP_ALLEGRO_VOICE, [c_ulong, c_long, c_long])
al_cstr = _dll("al_cstr", _AL_UTF8String, [LP_ALLEGRO_USTR])
al_cstr_dup = _dll("al_cstr_dup", _AL_UTF8String, [LP_ALLEGRO_USTR])
al_destroy_audio_stream = _dll("al_destroy_audio_stream", c_long, [LP_ALLEGRO_AUDIO_STREAM])
al_destroy_bitmap = _dll("al_destroy_bitmap", c_long, [LP_ALLEGRO_BITMAP])
al_destroy_cond = _dll("al_destroy_cond", c_long, [LP_ALLEGRO_COND])
al_destroy_config = _dll("al_destroy_config", c_long, [LP_ALLEGRO_CONFIG])
al_destroy_display = _dll("al_destroy_display", c_long, [LP_ALLEGRO_DISPLAY])
al_destroy_event_queue = _dll("al_destroy_event_queue", c_long, [c_void_p])
al_destroy_font = _dll("al_destroy_font", c_long, [LP_ALLEGRO_FONT])
al_destroy_fs_entry = _dll("al_destroy_fs_entry", c_long, [LP_ALLEGRO_FS_ENTRY])
al_destroy_index_buffer = _dll("al_destroy_index_buffer", c_long, [LP_ALLEGRO_INDEX_BUFFER])
al_destroy_menu = _dll("al_destroy_menu", c_long, [LP_ALLEGRO_MENU])
al_destroy_mixer = _dll("al_destroy_mixer", c_long, [LP_ALLEGRO_MIXER])
al_destroy_mouse_cursor = _dll("al_destroy_mouse_cursor", c_long, [c_void_p])
al_destroy_mutex = _dll("al_destroy_mutex", c_long, [LP_ALLEGRO_MUTEX])
al_destroy_native_file_dialog = _dll("al_destroy_native_file_dialog", c_long, [LP_ALLEGRO_FILECHOOSER])
al_destroy_path = _dll("al_destroy_path", c_long, [LP_ALLEGRO_PATH])
al_destroy_sample = _dll("al_destroy_sample", c_long, [LP_ALLEGRO_SAMPLE])
al_destroy_sample_instance = _dll("al_destroy_sample_instance", c_long, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_destroy_shader = _dll("al_destroy_shader", c_long, [LP_ALLEGRO_SHADER])
al_destroy_thread = _dll("al_destroy_thread", c_long, [LP_ALLEGRO_THREAD])
al_destroy_timer = _dll("al_destroy_timer", c_long, [LP_ALLEGRO_TIMER])
al_destroy_user_event_source = _dll("al_destroy_user_event_source", c_long, [c_void_p])
al_destroy_vertex_buffer = _dll("al_destroy_vertex_buffer", c_long, [LP_ALLEGRO_VERTEX_BUFFER])
al_destroy_vertex_decl = _dll("al_destroy_vertex_decl", c_long, [LP_ALLEGRO_VERTEX_DECL])
al_destroy_voice = _dll("al_destroy_voice", c_long, [LP_ALLEGRO_VOICE])
al_detach_audio_stream = _dll("al_detach_audio_stream", c_bool, [LP_ALLEGRO_AUDIO_STREAM])
al_detach_mixer = _dll("al_detach_mixer", c_bool, [LP_ALLEGRO_MIXER])
al_detach_sample_instance = _dll("al_detach_sample_instance", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_detach_voice = _dll("al_detach_voice", c_long, [LP_ALLEGRO_VOICE])
al_disable_menu_event_source = _dll("al_disable_menu_event_source", c_long, [LP_ALLEGRO_MENU])
al_do_multiline_text = _dll("al_do_multiline_text", c_long, [LP_ALLEGRO_FONT, c_float, _AL_UTF8String, c_void_p, c_void_p])
al_do_multiline_ustr = _dll("al_do_multiline_ustr", c_long, [LP_ALLEGRO_FONT, c_float, LP_ALLEGRO_USTR, c_void_p, c_void_p])
al_drain_audio_stream = _dll("al_drain_audio_stream", c_long, [LP_ALLEGRO_AUDIO_STREAM])
al_draw_arc = _dll("al_draw_arc", c_long, [c_float, c_float, c_float, c_float, c_float, ALLEGRO_COLOR, c_float])
al_draw_bitmap = _dll("al_draw_bitmap", c_long, [LP_ALLEGRO_BITMAP, c_float, c_float, c_long])
al_draw_bitmap_region = _dll("al_draw_bitmap_region", c_long, [LP_ALLEGRO_BITMAP, c_float, c_float, c_float, c_float, c_float, c_float, c_long])
al_draw_circle = _dll("al_draw_circle", c_long, [c_float, c_float, c_float, ALLEGRO_COLOR, c_float])
al_draw_ellipse = _dll("al_draw_ellipse", c_long, [c_float, c_float, c_float, c_float, ALLEGRO_COLOR, c_float])
al_draw_elliptical_arc = _dll("al_draw_elliptical_arc", c_long, [c_float, c_float, c_float, c_float, c_float, c_float, ALLEGRO_COLOR, c_float])
al_draw_filled_circle = _dll("al_draw_filled_circle", c_long, [c_float, c_float, c_float, ALLEGRO_COLOR])
al_draw_filled_ellipse = _dll("al_draw_filled_ellipse", c_long, [c_float, c_float, c_float, c_float, ALLEGRO_COLOR])
al_draw_filled_pieslice = _dll("al_draw_filled_pieslice", c_long, [c_float, c_float, c_float, c_float, c_float, ALLEGRO_COLOR])
al_draw_filled_polygon = _dll("al_draw_filled_polygon", c_long, [c_void_p, c_long, ALLEGRO_COLOR])
al_draw_filled_polygon_with_holes = _dll("al_draw_filled_polygon_with_holes", c_long, [c_void_p, c_void_p, ALLEGRO_COLOR])
al_draw_filled_rectangle = _dll("al_draw_filled_rectangle", c_long, [c_float, c_float, c_float, c_float, ALLEGRO_COLOR])
al_draw_filled_rounded_rectangle = _dll("al_draw_filled_rounded_rectangle", c_long, [c_float, c_float, c_float, c_float, c_float, c_float, ALLEGRO_COLOR])
al_draw_filled_triangle = _dll("al_draw_filled_triangle", c_long, [c_float, c_float, c_float, c_float, c_float, c_float, ALLEGRO_COLOR])
al_draw_glyph = _dll("al_draw_glyph", c_long, [LP_ALLEGRO_FONT, ALLEGRO_COLOR, c_float, c_float, c_long])
al_draw_indexed_buffer = _dll("al_draw_indexed_buffer", c_long, [LP_ALLEGRO_VERTEX_BUFFER, LP_ALLEGRO_BITMAP, LP_ALLEGRO_INDEX_BUFFER, c_long, c_long, c_long])
al_draw_indexed_prim = _dll("al_draw_indexed_prim", c_long, [c_void_p, LP_ALLEGRO_VERTEX_DECL, LP_ALLEGRO_BITMAP, c_void_p, c_long, c_long])
al_draw_justified_text = _dll("al_draw_justified_text", c_long, [LP_ALLEGRO_FONT, ALLEGRO_COLOR, c_float, c_float, c_float, c_float, c_long, _AL_UTF8String])
al_draw_justified_textf = _dll("al_draw_justified_textf", c_long, [LP_ALLEGRO_FONT, ALLEGRO_COLOR, c_float, c_float, c_float, c_float, c_long, _AL_UTF8String, c_void_p])
al_draw_justified_ustr = _dll("al_draw_justified_ustr", c_long, [LP_ALLEGRO_FONT, ALLEGRO_COLOR, c_float, c_float, c_float, c_float, c_long, LP_ALLEGRO_USTR])
al_draw_line = _dll("al_draw_line", c_long, [c_float, c_float, c_float, c_float, ALLEGRO_COLOR, c_float])
al_draw_multiline_text = _dll("al_draw_multiline_text", c_long, [LP_ALLEGRO_FONT, ALLEGRO_COLOR, c_float, c_float, c_float, c_float, c_long, _AL_UTF8String])
al_draw_multiline_textf = _dll("al_draw_multiline_textf", c_long, [LP_ALLEGRO_FONT, ALLEGRO_COLOR, c_float, c_float, c_float, c_float, c_long, _AL_UTF8String])
al_draw_multiline_ustr = _dll("al_draw_multiline_ustr", c_long, [LP_ALLEGRO_FONT, ALLEGRO_COLOR, c_float, c_float, c_float, c_float, c_long, LP_ALLEGRO_USTR])
al_draw_pieslice = _dll("al_draw_pieslice", c_long, [c_float, c_float, c_float, c_float, c_float, ALLEGRO_COLOR, c_float])
al_draw_pixel = _dll("al_draw_pixel", c_long, [c_float, c_float, ALLEGRO_COLOR])
al_draw_polygon = _dll("al_draw_polygon", c_long, [c_void_p, c_long, c_long, ALLEGRO_COLOR, c_float, c_float])
al_draw_polyline = _dll("al_draw_polyline", c_long, [c_void_p, c_long, c_long, c_long, c_long, ALLEGRO_COLOR, c_float, c_float])
al_draw_prim = _dll("al_draw_prim", c_long, [c_void_p, LP_ALLEGRO_VERTEX_DECL, LP_ALLEGRO_BITMAP, c_long, c_long, c_long])
al_draw_rectangle = _dll("al_draw_rectangle", c_long, [c_float, c_float, c_float, c_float, ALLEGRO_COLOR, c_float])
al_draw_ribbon = _dll("al_draw_ribbon", c_long, [c_void_p, c_long, ALLEGRO_COLOR, c_float, c_long])
al_draw_rotated_bitmap = _dll("al_draw_rotated_bitmap", c_long, [LP_ALLEGRO_BITMAP, c_float, c_float, c_float, c_float, c_float, c_long])
al_draw_rounded_rectangle = _dll("al_draw_rounded_rectangle", c_long, [c_float, c_float, c_float, c_float, c_float, c_float, ALLEGRO_COLOR, c_float])
al_draw_scaled_bitmap = _dll("al_draw_scaled_bitmap", c_long, [LP_ALLEGRO_BITMAP, c_float, c_float, c_float, c_float, c_float, c_float, c_float, c_float, c_long])
al_draw_scaled_rotated_bitmap = _dll("al_draw_scaled_rotated_bitmap", c_long, [LP_ALLEGRO_BITMAP, c_float, c_float, c_float, c_float, c_float, c_float, c_float, c_long])
al_draw_soft_line = _dll("al_draw_soft_line", c_long, [LP_ALLEGRO_VERTEX, LP_ALLEGRO_VERTEX, c_void_p, c_void_p, c_void_p, c_void_p])
al_draw_soft_triangle = _dll("al_draw_soft_triangle", c_long, [LP_ALLEGRO_VERTEX, LP_ALLEGRO_VERTEX, LP_ALLEGRO_VERTEX, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p])
al_draw_spline = _dll("al_draw_spline", c_long, [c_void_p, ALLEGRO_COLOR, c_float])
al_draw_text = _dll("al_draw_text", c_long, [LP_ALLEGRO_FONT, ALLEGRO_COLOR, c_float, c_float, c_long, _AL_UTF8String])
al_draw_textf = _dll("al_draw_textf", c_long, [LP_ALLEGRO_FONT, ALLEGRO_COLOR, c_float, c_float, c_long, _AL_UTF8String, c_void_p])
al_draw_tinted_bitmap = _dll("al_draw_tinted_bitmap", c_long, [LP_ALLEGRO_BITMAP, ALLEGRO_COLOR, c_float, c_float, c_long])
al_draw_tinted_bitmap_region = _dll("al_draw_tinted_bitmap_region", c_long, [LP_ALLEGRO_BITMAP, ALLEGRO_COLOR, c_float, c_float, c_float, c_float, c_float, c_float, c_long])
al_draw_tinted_rotated_bitmap = _dll("al_draw_tinted_rotated_bitmap", c_long, [LP_ALLEGRO_BITMAP, ALLEGRO_COLOR, c_float, c_float, c_float, c_float, c_float, c_long])
al_draw_tinted_scaled_bitmap = _dll("al_draw_tinted_scaled_bitmap", c_long, [LP_ALLEGRO_BITMAP, ALLEGRO_COLOR, c_float, c_float, c_float, c_float, c_float, c_float, c_float, c_float, c_long])
al_draw_tinted_scaled_rotated_bitmap = _dll("al_draw_tinted_scaled_rotated_bitmap", c_long, [LP_ALLEGRO_BITMAP, ALLEGRO_COLOR, c_float, c_float, c_float, c_float, c_float, c_float, c_float, c_long])
al_draw_tinted_scaled_rotated_bitmap_region = _dll("al_draw_tinted_scaled_rotated_bitmap_region", c_long, [LP_ALLEGRO_BITMAP, c_float, c_float, c_float, c_float, ALLEGRO_COLOR, c_float, c_float, c_float, c_float, c_float, c_float, c_float, c_long])
al_draw_triangle = _dll("al_draw_triangle", c_long, [c_float, c_float, c_float, c_float, c_float, c_float, ALLEGRO_COLOR, c_float])
al_draw_ustr = _dll("al_draw_ustr", c_long, [LP_ALLEGRO_FONT, ALLEGRO_COLOR, c_float, c_float, c_long, LP_ALLEGRO_USTR])
al_draw_vertex_buffer = _dll("al_draw_vertex_buffer", c_long, [LP_ALLEGRO_VERTEX_BUFFER, LP_ALLEGRO_BITMAP, c_long, c_long, c_long])
al_drop_next_event = _dll("al_drop_next_event", c_bool, [c_void_p])
al_drop_path_tail = _dll("al_drop_path_tail", c_long, [LP_ALLEGRO_PATH])
al_emit_user_event = _dll("al_emit_user_event", c_bool, [c_void_p, c_void_p, c_void_p])
al_enable_menu_event_source = _dll("al_enable_menu_event_source", LP_ALLEGRO_EVENT_SOURCE, [LP_ALLEGRO_MENU])
al_fclearerr = _dll("al_fclearerr", c_long, [LP_ALLEGRO_FILE])
al_fclose = _dll("al_fclose", c_bool, [LP_ALLEGRO_FILE])
al_feof = _dll("al_feof", c_bool, [LP_ALLEGRO_FILE])
al_ferrmsg = _dll("al_ferrmsg", _AL_UTF8String, [LP_ALLEGRO_FILE])
al_ferror = _dll("al_ferror", c_long, [LP_ALLEGRO_FILE])
al_fflush = _dll("al_fflush", c_bool, [LP_ALLEGRO_FILE])
al_fget_ustr = _dll("al_fget_ustr", LP_ALLEGRO_USTR, [LP_ALLEGRO_FILE])
al_fgetc = _dll("al_fgetc", c_long, [LP_ALLEGRO_FILE])
al_fgets = _dll("al_fgets", _AL_UTF8String, [LP_ALLEGRO_FILE, _AL_UTF8String, c_ulong])
al_filename_exists = _dll("al_filename_exists", c_bool, [_AL_UTF8String])
al_fill_silence = _dll("al_fill_silence", c_long, [c_void_p, c_ulong, c_long, c_long])
al_find_menu = _dll("al_find_menu", LP_ALLEGRO_MENU, [LP_ALLEGRO_MENU, c_ushort])
al_find_menu_item = _dll("al_find_menu_item", c_bool, [LP_ALLEGRO_MENU, c_ushort, c_void_p, c_void_p])
al_fixatan = _dll("al_fixatan", c_long, [c_long])
al_fixatan2 = _dll("al_fixatan2", c_long, [c_long, c_long])
al_fixhypot = _dll("al_fixhypot", c_long, [c_long, c_long])
al_fixsqrt = _dll("al_fixsqrt", c_long, [c_long])
al_flip_display = _dll("al_flip_display", c_long, [])
al_flush_event_queue = _dll("al_flush_event_queue", c_long, [c_void_p])
al_fopen = _dll("al_fopen", LP_ALLEGRO_FILE, [_AL_UTF8String, _AL_UTF8String])
al_fopen_fd = _dll("al_fopen_fd", LP_ALLEGRO_FILE, [c_long, _AL_UTF8String])
al_fopen_interface = _dll("al_fopen_interface", LP_ALLEGRO_FILE, [LP_ALLEGRO_FILE_INTERFACE, _AL_UTF8String, _AL_UTF8String])
al_fopen_slice = _dll("al_fopen_slice", LP_ALLEGRO_FILE, [LP_ALLEGRO_FILE, c_ulong, _AL_UTF8String])
al_for_each_fs_entry = _dll("al_for_each_fs_entry", c_long, [LP_ALLEGRO_FS_ENTRY, c_void_p, c_void_p])
al_fprintf = _dll("al_fprintf", c_long, [LP_ALLEGRO_FILE, _AL_UTF8String])
al_fputc = _dll("al_fputc", c_long, [LP_ALLEGRO_FILE, c_long])
al_fputs = _dll("al_fputs", c_long, [LP_ALLEGRO_FILE, _AL_UTF8String])
al_fread = _dll("al_fread", c_ulong, [LP_ALLEGRO_FILE, c_void_p, c_ulong])
al_fread16be = _dll("al_fread16be", c_short, [LP_ALLEGRO_FILE])
al_fread16le = _dll("al_fread16le", c_short, [LP_ALLEGRO_FILE])
al_fread32be = _dll("al_fread32be", c_long, [LP_ALLEGRO_FILE])
al_fread32le = _dll("al_fread32le", c_long, [LP_ALLEGRO_FILE])
al_free_with_context = _dll("al_free_with_context", c_long, [c_void_p, c_long, _AL_UTF8String, _AL_UTF8String])
al_fs_entry_exists = _dll("al_fs_entry_exists", c_bool, [LP_ALLEGRO_FS_ENTRY])
al_fseek = _dll("al_fseek", c_bool, [LP_ALLEGRO_FILE, c_longlong, c_long])
al_fsize = _dll("al_fsize", c_longlong, [LP_ALLEGRO_FILE])
al_ftell = _dll("al_ftell", c_longlong, [LP_ALLEGRO_FILE])
al_fungetc = _dll("al_fungetc", c_long, [LP_ALLEGRO_FILE, c_long])
al_fwrite = _dll("al_fwrite", c_ulong, [LP_ALLEGRO_FILE, c_void_p, c_ulong])
al_fwrite16be = _dll("al_fwrite16be", c_ulong, [LP_ALLEGRO_FILE, c_short])
al_fwrite16le = _dll("al_fwrite16le", c_ulong, [LP_ALLEGRO_FILE, c_short])
al_fwrite32be = _dll("al_fwrite32be", c_ulong, [LP_ALLEGRO_FILE, c_long])
al_fwrite32le = _dll("al_fwrite32le", c_ulong, [LP_ALLEGRO_FILE, c_long])
al_get_allegro_acodec_version = _dll("al_get_allegro_acodec_version", c_ulong, [])
al_get_allegro_audio_version = _dll("al_get_allegro_audio_version", c_ulong, [])
al_get_allegro_color_version = _dll("al_get_allegro_color_version", c_ulong, [])
al_get_allegro_font_version = _dll("al_get_allegro_font_version", c_ulong, [])
al_get_allegro_image_version = _dll("al_get_allegro_image_version", c_ulong, [])
al_get_allegro_memfile_version = _dll("al_get_allegro_memfile_version", c_ulong, [])
al_get_allegro_native_dialog_version = _dll("al_get_allegro_native_dialog_version", c_ulong, [])
al_get_allegro_physfs_version = _dll("al_get_allegro_physfs_version", c_ulong, [])
al_get_allegro_primitives_version = _dll("al_get_allegro_primitives_version", c_ulong, [])
al_get_allegro_ttf_version = _dll("al_get_allegro_ttf_version", c_ulong, [])
al_get_allegro_version = _dll("al_get_allegro_version", c_ulong, [])
al_get_allegro_video_version = _dll("al_get_allegro_video_version", c_ulong, [])
al_get_app_name = _dll("al_get_app_name", _AL_UTF8String, [])
al_get_audio_depth_size = _dll("al_get_audio_depth_size", c_ulong, [c_long])
al_get_audio_stream_attached = _dll("al_get_audio_stream_attached", c_bool, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_channels = _dll("al_get_audio_stream_channels", c_long, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_depth = _dll("al_get_audio_stream_depth", c_long, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_event_source = _dll("al_get_audio_stream_event_source", LP_ALLEGRO_EVENT_SOURCE, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_fragment = _dll("al_get_audio_stream_fragment", c_void_p, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_fragments = _dll("al_get_audio_stream_fragments", c_ulong, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_frequency = _dll("al_get_audio_stream_frequency", c_ulong, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_gain = _dll("al_get_audio_stream_gain", c_float, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_length = _dll("al_get_audio_stream_length", c_ulong, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_length_secs = _dll("al_get_audio_stream_length_secs", c_double, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_pan = _dll("al_get_audio_stream_pan", c_float, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_played_samples = _dll("al_get_audio_stream_played_samples", c_ulonglong, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_playing = _dll("al_get_audio_stream_playing", c_bool, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_playmode = _dll("al_get_audio_stream_playmode", c_long, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_position_secs = _dll("al_get_audio_stream_position_secs", c_double, [LP_ALLEGRO_AUDIO_STREAM])
al_get_audio_stream_speed = _dll("al_get_audio_stream_speed", c_float, [LP_ALLEGRO_AUDIO_STREAM])
al_get_available_audio_stream_fragments = _dll("al_get_available_audio_stream_fragments", c_ulong, [LP_ALLEGRO_AUDIO_STREAM])
al_get_backbuffer = _dll("al_get_backbuffer", LP_ALLEGRO_BITMAP, [LP_ALLEGRO_DISPLAY])
al_get_bitmap_flags = _dll("al_get_bitmap_flags", c_long, [LP_ALLEGRO_BITMAP])
al_get_bitmap_format = _dll("al_get_bitmap_format", c_long, [LP_ALLEGRO_BITMAP])
al_get_bitmap_height = _dll("al_get_bitmap_height", c_long, [LP_ALLEGRO_BITMAP])
al_get_bitmap_width = _dll("al_get_bitmap_width", c_long, [LP_ALLEGRO_BITMAP])
al_get_bitmap_x = _dll("al_get_bitmap_x", c_long, [LP_ALLEGRO_BITMAP])
al_get_bitmap_y = _dll("al_get_bitmap_y", c_long, [LP_ALLEGRO_BITMAP])
al_get_blend_color = _dll("al_get_blend_color", ALLEGRO_COLOR, [])
al_get_blender = _dll("al_get_blender", c_long, [c_void_p, c_void_p, c_void_p])
al_get_channel_count = _dll("al_get_channel_count", c_ulong, [c_long])
al_get_clipboard_text = _dll("al_get_clipboard_text", _AL_UTF8String, [LP_ALLEGRO_DISPLAY])
al_get_clipping_rectangle = _dll("al_get_clipping_rectangle", c_long, [c_void_p, c_void_p, c_void_p, c_void_p])
al_get_config_value = _dll("al_get_config_value", _AL_UTF8String, [LP_ALLEGRO_CONFIG, _AL_UTF8String, _AL_UTF8String])
al_get_cpu_count = _dll("al_get_cpu_count", c_long, [])
al_get_current_directory = _dll("al_get_current_directory", _AL_UTF8String, [])
al_get_current_display = _dll("al_get_current_display", LP_ALLEGRO_DISPLAY, [])
al_get_current_inverse_transform = _dll("al_get_current_inverse_transform", LP_ALLEGRO_TRANSFORM, [])
al_get_current_projection_transform = _dll("al_get_current_projection_transform", LP_ALLEGRO_TRANSFORM, [])
al_get_current_transform = _dll("al_get_current_transform", LP_ALLEGRO_TRANSFORM, [])
al_get_default_menu_event_source = _dll("al_get_default_menu_event_source", LP_ALLEGRO_EVENT_SOURCE, [])
al_get_default_mixer = _dll("al_get_default_mixer", LP_ALLEGRO_MIXER, [])
al_get_default_shader_source = _dll("al_get_default_shader_source", _AL_UTF8String, [c_long, c_long])
al_get_default_voice = _dll("al_get_default_voice", LP_ALLEGRO_VOICE, [])
al_get_display_event_source = _dll("al_get_display_event_source", LP_ALLEGRO_EVENT_SOURCE, [LP_ALLEGRO_DISPLAY])
al_get_display_flags = _dll("al_get_display_flags", c_long, [LP_ALLEGRO_DISPLAY])
al_get_display_format = _dll("al_get_display_format", c_long, [LP_ALLEGRO_DISPLAY])
al_get_display_height = _dll("al_get_display_height", c_long, [LP_ALLEGRO_DISPLAY])
al_get_display_menu = _dll("al_get_display_menu", LP_ALLEGRO_MENU, [LP_ALLEGRO_DISPLAY])
al_get_display_mode = _dll("al_get_display_mode", LP_ALLEGRO_DISPLAY_MODE, [c_long, LP_ALLEGRO_DISPLAY_MODE])
al_get_display_option = _dll("al_get_display_option", c_long, [LP_ALLEGRO_DISPLAY, c_long])
al_get_display_orientation = _dll("al_get_display_orientation", c_long, [LP_ALLEGRO_DISPLAY])
al_get_display_refresh_rate = _dll("al_get_display_refresh_rate", c_long, [LP_ALLEGRO_DISPLAY])
al_get_display_width = _dll("al_get_display_width", c_long, [LP_ALLEGRO_DISPLAY])
al_get_errno = _dll("al_get_errno", c_long, [])
al_get_event_source_data = _dll("al_get_event_source_data", c_void_p, [c_void_p])
al_get_fallback_font = _dll("al_get_fallback_font", LP_ALLEGRO_FONT, [LP_ALLEGRO_FONT])
al_get_file_userdata = _dll("al_get_file_userdata", c_void_p, [LP_ALLEGRO_FILE])
al_get_first_config_entry = _dll("al_get_first_config_entry", _AL_UTF8String, [LP_ALLEGRO_CONFIG, _AL_UTF8String, c_void_p])
al_get_first_config_section = _dll("al_get_first_config_section", _AL_UTF8String, [LP_ALLEGRO_CONFIG, c_void_p])
al_get_font_ascent = _dll("al_get_font_ascent", c_long, [LP_ALLEGRO_FONT])
al_get_font_descent = _dll("al_get_font_descent", c_long, [LP_ALLEGRO_FONT])
al_get_font_line_height = _dll("al_get_font_line_height", c_long, [LP_ALLEGRO_FONT])
al_get_font_ranges = _dll("al_get_font_ranges", c_long, [LP_ALLEGRO_FONT, c_long, c_void_p])
al_get_fs_entry_atime = _dll("al_get_fs_entry_atime", c_longlong, [LP_ALLEGRO_FS_ENTRY])
al_get_fs_entry_ctime = _dll("al_get_fs_entry_ctime", c_longlong, [LP_ALLEGRO_FS_ENTRY])
al_get_fs_entry_mode = _dll("al_get_fs_entry_mode", c_ulong, [LP_ALLEGRO_FS_ENTRY])
al_get_fs_entry_mtime = _dll("al_get_fs_entry_mtime", c_longlong, [LP_ALLEGRO_FS_ENTRY])
al_get_fs_entry_name = _dll("al_get_fs_entry_name", _AL_UTF8String, [LP_ALLEGRO_FS_ENTRY])
al_get_fs_entry_size = _dll("al_get_fs_entry_size", c_longlong, [LP_ALLEGRO_FS_ENTRY])
al_get_fs_interface = _dll("al_get_fs_interface", LP_ALLEGRO_FS_INTERFACE, [])
al_get_glyph_advance = _dll("al_get_glyph_advance", c_long, [LP_ALLEGRO_FONT, c_long, c_long])
al_get_glyph_dimensions = _dll("al_get_glyph_dimensions", c_bool, [LP_ALLEGRO_FONT, c_long, c_void_p, c_void_p, c_void_p, c_void_p])
al_get_glyph_width = _dll("al_get_glyph_width", c_long, [LP_ALLEGRO_FONT, c_long])
al_get_index_buffer_size = _dll("al_get_index_buffer_size", c_long, [LP_ALLEGRO_INDEX_BUFFER])
al_get_joystick = _dll("al_get_joystick", LP_ALLEGRO_JOYSTICK, [c_long])
al_get_joystick_active = _dll("al_get_joystick_active", c_bool, [c_void_p])
al_get_joystick_axis_name = _dll("al_get_joystick_axis_name", _AL_UTF8String, [c_void_p, c_long, c_long])
al_get_joystick_button_name = _dll("al_get_joystick_button_name", _AL_UTF8String, [c_void_p, c_long])
al_get_joystick_event_source = _dll("al_get_joystick_event_source", LP_ALLEGRO_EVENT_SOURCE, [])
al_get_joystick_name = _dll("al_get_joystick_name", _AL_UTF8String, [c_void_p])
al_get_joystick_num_axes = _dll("al_get_joystick_num_axes", c_long, [c_void_p, c_long])
al_get_joystick_num_buttons = _dll("al_get_joystick_num_buttons", c_long, [c_void_p])
al_get_joystick_num_sticks = _dll("al_get_joystick_num_sticks", c_long, [c_void_p])
al_get_joystick_state = _dll("al_get_joystick_state", c_long, [c_void_p, LP_ALLEGRO_JOYSTICK_STATE])
al_get_joystick_stick_flags = _dll("al_get_joystick_stick_flags", c_long, [c_void_p, c_long])
al_get_joystick_stick_name = _dll("al_get_joystick_stick_name", _AL_UTF8String, [c_void_p, c_long])
al_get_keyboard_event_source = _dll("al_get_keyboard_event_source", LP_ALLEGRO_EVENT_SOURCE, [])
al_get_keyboard_state = _dll("al_get_keyboard_state", c_long, [LP_ALLEGRO_KEYBOARD_STATE])
al_get_menu_item_caption = _dll("al_get_menu_item_caption", _AL_UTF8String, [LP_ALLEGRO_MENU, c_long])
al_get_menu_item_flags = _dll("al_get_menu_item_flags", c_long, [LP_ALLEGRO_MENU, c_long])
al_get_menu_item_icon = _dll("al_get_menu_item_icon", LP_ALLEGRO_BITMAP, [LP_ALLEGRO_MENU, c_long])
al_get_mixer_attached = _dll("al_get_mixer_attached", c_bool, [LP_ALLEGRO_MIXER])
al_get_mixer_channels = _dll("al_get_mixer_channels", c_long, [LP_ALLEGRO_MIXER])
al_get_mixer_depth = _dll("al_get_mixer_depth", c_long, [LP_ALLEGRO_MIXER])
al_get_mixer_frequency = _dll("al_get_mixer_frequency", c_ulong, [LP_ALLEGRO_MIXER])
al_get_mixer_gain = _dll("al_get_mixer_gain", c_float, [LP_ALLEGRO_MIXER])
al_get_mixer_playing = _dll("al_get_mixer_playing", c_bool, [LP_ALLEGRO_MIXER])
al_get_mixer_quality = _dll("al_get_mixer_quality", c_long, [LP_ALLEGRO_MIXER])
al_get_monitor_dpi = _dll("al_get_monitor_dpi", c_long, [c_long])
al_get_monitor_info = _dll("al_get_monitor_info", c_bool, [c_long, LP_ALLEGRO_MONITOR_INFO])
al_get_mouse_cursor_position = _dll("al_get_mouse_cursor_position", c_bool, [c_void_p, c_void_p])
al_get_mouse_event_source = _dll("al_get_mouse_event_source", LP_ALLEGRO_EVENT_SOURCE, [])
al_get_mouse_num_axes = _dll("al_get_mouse_num_axes", c_ulong, [])
al_get_mouse_num_buttons = _dll("al_get_mouse_num_buttons", c_ulong, [])
al_get_mouse_state = _dll("al_get_mouse_state", c_long, [LP_ALLEGRO_MOUSE_STATE])
al_get_mouse_state_axis = _dll("al_get_mouse_state_axis", c_long, [LP_ALLEGRO_MOUSE_STATE, c_long])
al_get_mouse_wheel_precision = _dll("al_get_mouse_wheel_precision", c_long, [])
al_get_native_file_dialog_count = _dll("al_get_native_file_dialog_count", c_long, [LP_ALLEGRO_FILECHOOSER])
al_get_native_file_dialog_path = _dll("al_get_native_file_dialog_path", _AL_UTF8String, [LP_ALLEGRO_FILECHOOSER, c_ulong])
al_get_native_text_log_event_source = _dll("al_get_native_text_log_event_source", LP_ALLEGRO_EVENT_SOURCE, [LP_ALLEGRO_TEXTLOG])
al_get_new_bitmap_flags = _dll("al_get_new_bitmap_flags", c_long, [])
al_get_new_bitmap_format = _dll("al_get_new_bitmap_format", c_long, [])
al_get_new_display_adapter = _dll("al_get_new_display_adapter", c_long, [])
al_get_new_display_flags = _dll("al_get_new_display_flags", c_long, [])
al_get_new_display_option = _dll("al_get_new_display_option", c_long, [c_long, c_void_p])
al_get_new_display_refresh_rate = _dll("al_get_new_display_refresh_rate", c_long, [])
al_get_new_file_interface = _dll("al_get_new_file_interface", LP_ALLEGRO_FILE_INTERFACE, [])
al_get_new_window_position = _dll("al_get_new_window_position", c_long, [c_void_p, c_void_p])
al_get_new_window_title = _dll("al_get_new_window_title", _AL_UTF8String, [])
al_get_next_config_entry = _dll("al_get_next_config_entry", _AL_UTF8String, [c_void_p])
al_get_next_config_section = _dll("al_get_next_config_section", _AL_UTF8String, [c_void_p])
al_get_next_event = _dll("al_get_next_event", c_bool, [c_void_p, LP_ALLEGRO_EVENT])
al_get_num_display_modes = _dll("al_get_num_display_modes", c_long, [])
al_get_num_joysticks = _dll("al_get_num_joysticks", c_long, [])
al_get_num_video_adapters = _dll("al_get_num_video_adapters", c_long, [])
al_get_opengl_extension_list = _dll("al_get_opengl_extension_list", LP_ALLEGRO_OGL_EXT_LIST, [])
al_get_opengl_fbo = _dll("al_get_opengl_fbo", c_ulong, [LP_ALLEGRO_BITMAP])
al_get_opengl_proc_address = _dll("al_get_opengl_proc_address", c_void_p, [_AL_UTF8String])
al_get_opengl_program_object = _dll("al_get_opengl_program_object", c_ulong, [LP_ALLEGRO_SHADER])
al_get_opengl_texture = _dll("al_get_opengl_texture", c_ulong, [LP_ALLEGRO_BITMAP])
al_get_opengl_texture_position = _dll("al_get_opengl_texture_position", c_long, [LP_ALLEGRO_BITMAP, c_void_p, c_void_p])
al_get_opengl_texture_size = _dll("al_get_opengl_texture_size", c_bool, [LP_ALLEGRO_BITMAP, c_void_p, c_void_p])
al_get_opengl_variant = _dll("al_get_opengl_variant", c_long, [])
al_get_opengl_version = _dll("al_get_opengl_version", c_ulong, [])
al_get_org_name = _dll("al_get_org_name", _AL_UTF8String, [])
al_get_parent_bitmap = _dll("al_get_parent_bitmap", LP_ALLEGRO_BITMAP, [LP_ALLEGRO_BITMAP])
al_get_path_basename = _dll("al_get_path_basename", _AL_UTF8String, [LP_ALLEGRO_PATH])
al_get_path_component = _dll("al_get_path_component", _AL_UTF8String, [LP_ALLEGRO_PATH, c_long])
al_get_path_drive = _dll("al_get_path_drive", _AL_UTF8String, [LP_ALLEGRO_PATH])
al_get_path_extension = _dll("al_get_path_extension", _AL_UTF8String, [LP_ALLEGRO_PATH])
al_get_path_filename = _dll("al_get_path_filename", _AL_UTF8String, [LP_ALLEGRO_PATH])
al_get_path_num_components = _dll("al_get_path_num_components", c_long, [LP_ALLEGRO_PATH])
al_get_path_tail = _dll("al_get_path_tail", _AL_UTF8String, [LP_ALLEGRO_PATH])
al_get_pixel = _dll("al_get_pixel", ALLEGRO_COLOR, [LP_ALLEGRO_BITMAP, c_long, c_long])
al_get_pixel_block_height = _dll("al_get_pixel_block_height", c_long, [c_long])
al_get_pixel_block_size = _dll("al_get_pixel_block_size", c_long, [c_long])
al_get_pixel_block_width = _dll("al_get_pixel_block_width", c_long, [c_long])
al_get_pixel_format_bits = _dll("al_get_pixel_format_bits", c_long, [c_long])
al_get_pixel_size = _dll("al_get_pixel_size", c_long, [c_long])
al_get_ram_size = _dll("al_get_ram_size", c_long, [])
al_get_sample = _dll("al_get_sample", LP_ALLEGRO_SAMPLE, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_channels = _dll("al_get_sample_channels", c_long, [LP_ALLEGRO_SAMPLE])
al_get_sample_data = _dll("al_get_sample_data", c_void_p, [LP_ALLEGRO_SAMPLE])
al_get_sample_depth = _dll("al_get_sample_depth", c_long, [LP_ALLEGRO_SAMPLE])
al_get_sample_frequency = _dll("al_get_sample_frequency", c_ulong, [LP_ALLEGRO_SAMPLE])
al_get_sample_instance_attached = _dll("al_get_sample_instance_attached", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_instance_channels = _dll("al_get_sample_instance_channels", c_long, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_instance_depth = _dll("al_get_sample_instance_depth", c_long, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_instance_frequency = _dll("al_get_sample_instance_frequency", c_ulong, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_instance_gain = _dll("al_get_sample_instance_gain", c_float, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_instance_length = _dll("al_get_sample_instance_length", c_ulong, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_instance_pan = _dll("al_get_sample_instance_pan", c_float, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_instance_playing = _dll("al_get_sample_instance_playing", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_instance_playmode = _dll("al_get_sample_instance_playmode", c_long, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_instance_position = _dll("al_get_sample_instance_position", c_ulong, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_instance_speed = _dll("al_get_sample_instance_speed", c_float, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_instance_time = _dll("al_get_sample_instance_time", c_float, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_get_sample_length = _dll("al_get_sample_length", c_ulong, [LP_ALLEGRO_SAMPLE])
al_get_separate_blender = _dll("al_get_separate_blender", c_long, [c_void_p, c_void_p, c_void_p, c_void_p, c_void_p, c_void_p])
al_get_shader_log = _dll("al_get_shader_log", _AL_UTF8String, [LP_ALLEGRO_SHADER])
al_get_shader_platform = _dll("al_get_shader_platform", c_long, [LP_ALLEGRO_SHADER])
al_get_standard_path = _dll("al_get_standard_path", LP_ALLEGRO_PATH, [c_long])
al_get_system_config = _dll("al_get_system_config", LP_ALLEGRO_CONFIG, [])
al_get_system_driver = _dll("al_get_system_driver", LP_ALLEGRO_SYSTEM, [])
al_get_system_id = _dll("al_get_system_id", c_long, [])
al_get_target_bitmap = _dll("al_get_target_bitmap", LP_ALLEGRO_BITMAP, [])
al_get_text_dimensions = _dll("al_get_text_dimensions", c_long, [LP_ALLEGRO_FONT, _AL_UTF8String, c_void_p, c_void_p, c_void_p, c_void_p])
al_get_text_width = _dll("al_get_text_width", c_long, [LP_ALLEGRO_FONT, _AL_UTF8String])
al_get_thread_should_stop = _dll("al_get_thread_should_stop", c_bool, [LP_ALLEGRO_THREAD])
al_get_time = _dll("al_get_time", c_double, [])
al_get_timer_count = _dll("al_get_timer_count", c_longlong, [LP_ALLEGRO_TIMER])
al_get_timer_event_source = _dll("al_get_timer_event_source", LP_ALLEGRO_EVENT_SOURCE, [LP_ALLEGRO_TIMER])
al_get_timer_speed = _dll("al_get_timer_speed", c_double, [LP_ALLEGRO_TIMER])
al_get_timer_started = _dll("al_get_timer_started", c_bool, [LP_ALLEGRO_TIMER])
al_get_touch_input_event_source = _dll("al_get_touch_input_event_source", LP_ALLEGRO_EVENT_SOURCE, [])
al_get_touch_input_state = _dll("al_get_touch_input_state", c_long, [LP_ALLEGRO_TOUCH_INPUT_STATE])
al_get_ustr_dimensions = _dll("al_get_ustr_dimensions", c_long, [LP_ALLEGRO_FONT, LP_ALLEGRO_USTR, c_void_p, c_void_p, c_void_p, c_void_p])
al_get_ustr_width = _dll("al_get_ustr_width", c_long, [LP_ALLEGRO_FONT, LP_ALLEGRO_USTR])
al_get_vertex_buffer_size = _dll("al_get_vertex_buffer_size", c_long, [LP_ALLEGRO_VERTEX_BUFFER])
al_get_video_audio_rate = _dll("al_get_video_audio_rate", c_double, [LP_ALLEGRO_VIDEO])
al_get_video_event_source = _dll("al_get_video_event_source", LP_ALLEGRO_EVENT_SOURCE, [LP_ALLEGRO_VIDEO])
al_get_video_fps = _dll("al_get_video_fps", c_double, [LP_ALLEGRO_VIDEO])
al_get_video_frame = _dll("al_get_video_frame", LP_ALLEGRO_BITMAP, [LP_ALLEGRO_VIDEO])
al_get_video_position = _dll("al_get_video_position", c_double, [LP_ALLEGRO_VIDEO, c_long])
al_get_video_scaled_height = _dll("al_get_video_scaled_height", c_float, [LP_ALLEGRO_VIDEO])
al_get_video_scaled_width = _dll("al_get_video_scaled_width", c_float, [LP_ALLEGRO_VIDEO])
al_get_voice_channels = _dll("al_get_voice_channels", c_long, [LP_ALLEGRO_VOICE])
al_get_voice_depth = _dll("al_get_voice_depth", c_long, [LP_ALLEGRO_VOICE])
al_get_voice_frequency = _dll("al_get_voice_frequency", c_ulong, [LP_ALLEGRO_VOICE])
al_get_voice_playing = _dll("al_get_voice_playing", c_bool, [LP_ALLEGRO_VOICE])
al_get_voice_position = _dll("al_get_voice_position", c_ulong, [LP_ALLEGRO_VOICE])
al_get_win_window_handle = _dll("al_get_win_window_handle", c_void_p, [LP_ALLEGRO_DISPLAY])
al_get_window_constraints = _dll("al_get_window_constraints", c_bool, [LP_ALLEGRO_DISPLAY, c_void_p, c_void_p, c_void_p, c_void_p])
al_get_window_position = _dll("al_get_window_position", c_long, [LP_ALLEGRO_DISPLAY, c_void_p, c_void_p])
al_grab_font_from_bitmap = _dll("al_grab_font_from_bitmap", LP_ALLEGRO_FONT, [LP_ALLEGRO_BITMAP, c_long, c_void_p])
al_grab_mouse = _dll("al_grab_mouse", c_bool, [LP_ALLEGRO_DISPLAY])
al_have_opengl_extension = _dll("al_have_opengl_extension", c_bool, [_AL_UTF8String])
al_hide_mouse_cursor = _dll("al_hide_mouse_cursor", c_bool, [LP_ALLEGRO_DISPLAY])
al_hold_bitmap_drawing = _dll("al_hold_bitmap_drawing", c_long, [c_bool])
al_horizontal_shear_transform = _dll("al_horizontal_shear_transform", c_long, [LP_ALLEGRO_TRANSFORM, c_float])
al_identify_bitmap = _dll("al_identify_bitmap", _AL_UTF8String, [_AL_UTF8String])
al_identify_bitmap_f = _dll("al_identify_bitmap_f", _AL_UTF8String, [LP_ALLEGRO_FILE])
al_identity_transform = _dll("al_identity_transform", c_long, [LP_ALLEGRO_TRANSFORM])
al_inhibit_screensaver = _dll("al_inhibit_screensaver", c_bool, [c_bool])
al_init_acodec_addon = _dll("al_init_acodec_addon", c_bool, [])
al_init_font_addon = _dll("al_init_font_addon", c_bool, [])
al_init_image_addon = _dll("al_init_image_addon", c_bool, [])
al_init_native_dialog_addon = _dll("al_init_native_dialog_addon", c_bool, [])
al_init_primitives_addon = _dll("al_init_primitives_addon", c_bool, [])
al_init_timeout = _dll("al_init_timeout", c_long, [LP_ALLEGRO_TIMEOUT, c_double])
al_init_ttf_addon = _dll("al_init_ttf_addon", c_bool, [])
al_init_user_event_source = _dll("al_init_user_event_source", c_long, [c_void_p])
al_init_video_addon = _dll("al_init_video_addon", c_bool, [])
al_insert_menu_item = _dll("al_insert_menu_item", c_long, [LP_ALLEGRO_MENU, c_long, _AL_UTF8String, c_ushort, c_long, LP_ALLEGRO_BITMAP, LP_ALLEGRO_MENU])
al_insert_path_component = _dll("al_insert_path_component", c_long, [LP_ALLEGRO_PATH, c_long, _AL_UTF8String])
al_install_audio = _dll("al_install_audio", c_bool, [])
al_install_joystick = _dll("al_install_joystick", c_bool, [])
al_install_keyboard = _dll("al_install_keyboard", c_bool, [])
al_install_mouse = _dll("al_install_mouse", c_bool, [])
al_install_system = _dll("al_install_system", c_bool, [c_long, c_void_p])
al_install_touch_input = _dll("al_install_touch_input", c_bool, [])
al_invert_transform = _dll("al_invert_transform", c_long, [LP_ALLEGRO_TRANSFORM])
al_is_acodec_addon_initialized = _dll("al_is_acodec_addon_initialized", c_bool, [])
al_is_audio_installed = _dll("al_is_audio_installed", c_bool, [])
al_is_bitmap_drawing_held = _dll("al_is_bitmap_drawing_held", c_bool, [])
al_is_bitmap_locked = _dll("al_is_bitmap_locked", c_bool, [LP_ALLEGRO_BITMAP])
al_is_color_valid = _dll("al_is_color_valid", c_bool, [ALLEGRO_COLOR])
al_is_compatible_bitmap = _dll("al_is_compatible_bitmap", c_bool, [LP_ALLEGRO_BITMAP])
al_is_event_queue_empty = _dll("al_is_event_queue_empty", c_bool, [c_void_p])
al_is_event_queue_paused = _dll("al_is_event_queue_paused", c_bool, [c_void_p])
al_is_event_source_registered = _dll("al_is_event_source_registered", c_bool, [c_void_p, c_void_p])
al_is_font_addon_initialized = _dll("al_is_font_addon_initialized", c_bool, [])
al_is_image_addon_initialized = _dll("al_is_image_addon_initialized", c_bool, [])
al_is_joystick_installed = _dll("al_is_joystick_installed", c_bool, [])
al_is_keyboard_installed = _dll("al_is_keyboard_installed", c_bool, [])
al_is_mouse_installed = _dll("al_is_mouse_installed", c_bool, [])
al_is_native_dialog_addon_initialized = _dll("al_is_native_dialog_addon_initialized", c_bool, [])
al_is_primitives_addon_initialized = _dll("al_is_primitives_addon_initialized", c_bool, [])
al_is_sub_bitmap = _dll("al_is_sub_bitmap", c_bool, [LP_ALLEGRO_BITMAP])
al_is_system_installed = _dll("al_is_system_installed", c_bool, [])
al_is_touch_input_installed = _dll("al_is_touch_input_installed", c_bool, [])
al_is_ttf_addon_initialized = _dll("al_is_ttf_addon_initialized", c_bool, [])
al_is_video_addon_initialized = _dll("al_is_video_addon_initialized", c_bool, [])
al_is_video_playing = _dll("al_is_video_playing", c_bool, [LP_ALLEGRO_VIDEO])
al_join_paths = _dll("al_join_paths", c_bool, [LP_ALLEGRO_PATH, LP_ALLEGRO_PATH])
al_join_thread = _dll("al_join_thread", c_long, [LP_ALLEGRO_THREAD, c_void_p])
al_key_down = _dll("al_key_down", c_bool, [c_void_p, c_long])
al_keycode_to_name = _dll("al_keycode_to_name", _AL_UTF8String, [c_long])
al_load_audio_stream = _dll("al_load_audio_stream", LP_ALLEGRO_AUDIO_STREAM, [_AL_UTF8String, c_ulong, c_ulong])
al_load_audio_stream_f = _dll("al_load_audio_stream_f", LP_ALLEGRO_AUDIO_STREAM, [LP_ALLEGRO_FILE, _AL_UTF8String, c_ulong, c_ulong])
al_load_bitmap = _dll("al_load_bitmap", LP_ALLEGRO_BITMAP, [_AL_UTF8String])
al_load_bitmap_f = _dll("al_load_bitmap_f", LP_ALLEGRO_BITMAP, [LP_ALLEGRO_FILE, _AL_UTF8String])
al_load_bitmap_flags = _dll("al_load_bitmap_flags", LP_ALLEGRO_BITMAP, [_AL_UTF8String, c_long])
al_load_bitmap_flags_f = _dll("al_load_bitmap_flags_f", LP_ALLEGRO_BITMAP, [LP_ALLEGRO_FILE, _AL_UTF8String, c_long])
al_load_bitmap_font = _dll("al_load_bitmap_font", LP_ALLEGRO_FONT, [_AL_UTF8String])
al_load_bitmap_font_flags = _dll("al_load_bitmap_font_flags", LP_ALLEGRO_FONT, [_AL_UTF8String, c_long])
al_load_config_file = _dll("al_load_config_file", LP_ALLEGRO_CONFIG, [_AL_UTF8String])
al_load_config_file_f = _dll("al_load_config_file_f", LP_ALLEGRO_CONFIG, [LP_ALLEGRO_FILE])
al_load_font = _dll("al_load_font", LP_ALLEGRO_FONT, [_AL_UTF8String, c_long, c_long])
al_load_sample = _dll("al_load_sample", LP_ALLEGRO_SAMPLE, [_AL_UTF8String])
al_load_sample_f = _dll("al_load_sample_f", LP_ALLEGRO_SAMPLE, [LP_ALLEGRO_FILE, _AL_UTF8String])
al_load_ttf_font = _dll("al_load_ttf_font", LP_ALLEGRO_FONT, [_AL_UTF8String, c_long, c_long])
al_load_ttf_font_f = _dll("al_load_ttf_font_f", LP_ALLEGRO_FONT, [LP_ALLEGRO_FILE, _AL_UTF8String, c_long, c_long])
al_load_ttf_font_stretch = _dll("al_load_ttf_font_stretch", LP_ALLEGRO_FONT, [_AL_UTF8String, c_long, c_long, c_long])
al_load_ttf_font_stretch_f = _dll("al_load_ttf_font_stretch_f", LP_ALLEGRO_FONT, [LP_ALLEGRO_FILE, _AL_UTF8String, c_long, c_long, c_long])
al_lock_bitmap = _dll("al_lock_bitmap", LP_ALLEGRO_LOCKED_REGION, [LP_ALLEGRO_BITMAP, c_long, c_long])
al_lock_bitmap_blocked = _dll("al_lock_bitmap_blocked", LP_ALLEGRO_LOCKED_REGION, [LP_ALLEGRO_BITMAP, c_long])
al_lock_bitmap_region = _dll("al_lock_bitmap_region", LP_ALLEGRO_LOCKED_REGION, [LP_ALLEGRO_BITMAP, c_long, c_long, c_long, c_long, c_long, c_long])
al_lock_bitmap_region_blocked = _dll("al_lock_bitmap_region_blocked", LP_ALLEGRO_LOCKED_REGION, [LP_ALLEGRO_BITMAP, c_long, c_long, c_long, c_long, c_long])
al_lock_index_buffer = _dll("al_lock_index_buffer", c_void_p, [LP_ALLEGRO_INDEX_BUFFER, c_long, c_long, c_long])
al_lock_mutex = _dll("al_lock_mutex", c_long, [LP_ALLEGRO_MUTEX])
al_lock_vertex_buffer = _dll("al_lock_vertex_buffer", c_void_p, [LP_ALLEGRO_VERTEX_BUFFER, c_long, c_long, c_long])
al_make_directory = _dll("al_make_directory", c_bool, [_AL_UTF8String])
al_make_path_canonical = _dll("al_make_path_canonical", c_bool, [LP_ALLEGRO_PATH])
al_make_temp_file = _dll("al_make_temp_file", LP_ALLEGRO_FILE, [_AL_UTF8String, c_void_p])
al_malloc_with_context = _dll("al_malloc_with_context", c_void_p, [c_ulong, c_long, _AL_UTF8String, _AL_UTF8String])
al_map_rgb = _dll("al_map_rgb", ALLEGRO_COLOR, [c_ubyte, c_ubyte, c_ubyte])
al_map_rgb_f = _dll("al_map_rgb_f", ALLEGRO_COLOR, [c_float, c_float, c_float])
al_map_rgba = _dll("al_map_rgba", ALLEGRO_COLOR, [c_ubyte, c_ubyte, c_ubyte, c_ubyte])
al_map_rgba_f = _dll("al_map_rgba_f", ALLEGRO_COLOR, [c_float, c_float, c_float, c_float])
al_merge_config = _dll("al_merge_config", LP_ALLEGRO_CONFIG, [LP_ALLEGRO_CONFIG, LP_ALLEGRO_CONFIG])
al_merge_config_into = _dll("al_merge_config_into", c_long, [LP_ALLEGRO_CONFIG, LP_ALLEGRO_CONFIG])
al_mouse_button_down = _dll("al_mouse_button_down", c_bool, [LP_ALLEGRO_MOUSE_STATE, c_long])
al_open_directory = _dll("al_open_directory", c_bool, [LP_ALLEGRO_FS_ENTRY])
al_open_fs_entry = _dll("al_open_fs_entry", LP_ALLEGRO_FILE, [LP_ALLEGRO_FS_ENTRY, _AL_UTF8String])
al_open_memfile = _dll("al_open_memfile", LP_ALLEGRO_FILE, [c_void_p, c_longlong, _AL_UTF8String])
al_open_native_text_log = _dll("al_open_native_text_log", LP_ALLEGRO_TEXTLOG, [_AL_UTF8String, c_long])
al_open_video = _dll("al_open_video", LP_ALLEGRO_VIDEO, [_AL_UTF8String])
al_orthographic_transform = _dll("al_orthographic_transform", c_long, [LP_ALLEGRO_TRANSFORM, c_float, c_float, c_float, c_float, c_float, c_float])
al_path_cstr = _dll("al_path_cstr", _AL_UTF8String, [LP_ALLEGRO_PATH, c_byte])
al_path_ustr = _dll("al_path_ustr", LP_ALLEGRO_USTR, [LP_ALLEGRO_PATH, c_byte])
al_pause_event_queue = _dll("al_pause_event_queue", c_long, [c_void_p, c_bool])
al_peek_next_event = _dll("al_peek_next_event", c_bool, [c_void_p, LP_ALLEGRO_EVENT])
al_perspective_transform = _dll("al_perspective_transform", c_long, [LP_ALLEGRO_TRANSFORM, c_float, c_float, c_float, c_float, c_float, c_float])
al_play_sample = _dll("al_play_sample", c_bool, [LP_ALLEGRO_SAMPLE, c_float, c_float, c_float, c_long, LP_ALLEGRO_SAMPLE_ID])
al_play_sample_instance = _dll("al_play_sample_instance", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_popup_menu = _dll("al_popup_menu", c_bool, [LP_ALLEGRO_MENU, LP_ALLEGRO_DISPLAY])
al_premul_rgba = _dll("al_premul_rgba", ALLEGRO_COLOR, [c_ubyte, c_ubyte, c_ubyte, c_ubyte])
al_premul_rgba_f = _dll("al_premul_rgba_f", ALLEGRO_COLOR, [c_float, c_float, c_float, c_float])
al_put_blended_pixel = _dll("al_put_blended_pixel", c_long, [c_long, c_long, ALLEGRO_COLOR])
al_put_pixel = _dll("al_put_pixel", c_long, [c_long, c_long, ALLEGRO_COLOR])
al_read_directory = _dll("al_read_directory", LP_ALLEGRO_FS_ENTRY, [LP_ALLEGRO_FS_ENTRY])
al_realloc_with_context = _dll("al_realloc_with_context", c_void_p, [c_void_p, c_ulong, c_long, _AL_UTF8String, _AL_UTF8String])
al_rebase_path = _dll("al_rebase_path", c_bool, [LP_ALLEGRO_PATH, LP_ALLEGRO_PATH])
al_reconfigure_joysticks = _dll("al_reconfigure_joysticks", c_bool, [])
al_ref_buffer = _dll("al_ref_buffer", LP_ALLEGRO_USTR, [LP_ALLEGRO_USTR_INFO, _AL_UTF8String, c_ulong])
al_ref_cstr = _dll("al_ref_cstr", LP_ALLEGRO_USTR, [LP_ALLEGRO_USTR_INFO, _AL_UTF8String])
al_ref_ustr = _dll("al_ref_ustr", LP_ALLEGRO_USTR, [LP_ALLEGRO_USTR_INFO, LP_ALLEGRO_USTR, c_long, c_long])
al_register_assert_handler = _dll("al_register_assert_handler", c_long, [c_void_p])
al_register_audio_stream_loader = _dll("al_register_audio_stream_loader", c_bool, [_AL_UTF8String, c_void_p])
al_register_audio_stream_loader_f = _dll("al_register_audio_stream_loader_f", c_bool, [_AL_UTF8String, c_void_p])
al_register_bitmap_identifier = _dll("al_register_bitmap_identifier", c_bool, [_AL_UTF8String, c_void_p])
al_register_bitmap_loader = _dll("al_register_bitmap_loader", c_bool, [_AL_UTF8String, c_void_p])
al_register_bitmap_loader_f = _dll("al_register_bitmap_loader_f", c_bool, [_AL_UTF8String, c_void_p])
al_register_bitmap_saver = _dll("al_register_bitmap_saver", c_bool, [_AL_UTF8String, c_void_p])
al_register_bitmap_saver_f = _dll("al_register_bitmap_saver_f", c_bool, [_AL_UTF8String, c_void_p])
al_register_event_source = _dll("al_register_event_source", c_long, [c_void_p, c_void_p])
al_register_font_loader = _dll("al_register_font_loader", c_bool, [_AL_UTF8String, c_void_p])
al_register_sample_loader = _dll("al_register_sample_loader", c_bool, [_AL_UTF8String, c_void_p])
al_register_sample_loader_f = _dll("al_register_sample_loader_f", c_bool, [_AL_UTF8String, c_void_p])
al_register_sample_saver = _dll("al_register_sample_saver", c_bool, [_AL_UTF8String, c_void_p])
al_register_sample_saver_f = _dll("al_register_sample_saver_f", c_bool, [_AL_UTF8String, c_void_p])
al_register_trace_handler = _dll("al_register_trace_handler", c_long, [c_void_p])
al_release_joystick = _dll("al_release_joystick", c_long, [c_void_p])
al_remove_config_key = _dll("al_remove_config_key", c_bool, [LP_ALLEGRO_CONFIG, _AL_UTF8String, _AL_UTF8String])
al_remove_config_section = _dll("al_remove_config_section", c_bool, [LP_ALLEGRO_CONFIG, _AL_UTF8String])
al_remove_display_menu = _dll("al_remove_display_menu", LP_ALLEGRO_MENU, [LP_ALLEGRO_DISPLAY])
al_remove_filename = _dll("al_remove_filename", c_bool, [_AL_UTF8String])
al_remove_fs_entry = _dll("al_remove_fs_entry", c_bool, [LP_ALLEGRO_FS_ENTRY])
al_remove_menu_item = _dll("al_remove_menu_item", c_bool, [LP_ALLEGRO_MENU, c_long])
al_remove_opengl_fbo = _dll("al_remove_opengl_fbo", c_long, [LP_ALLEGRO_BITMAP])
al_remove_path_component = _dll("al_remove_path_component", c_long, [LP_ALLEGRO_PATH, c_long])
al_reparent_bitmap = _dll("al_reparent_bitmap", c_long, [LP_ALLEGRO_BITMAP, LP_ALLEGRO_BITMAP, c_long, c_long, c_long, c_long])
al_replace_path_component = _dll("al_replace_path_component", c_long, [LP_ALLEGRO_PATH, c_long, _AL_UTF8String])
al_reserve_samples = _dll("al_reserve_samples", c_bool, [c_long])
al_reset_clipping_rectangle = _dll("al_reset_clipping_rectangle", c_long, [])
al_reset_new_display_options = _dll("al_reset_new_display_options", c_long, [])
al_resize_display = _dll("al_resize_display", c_bool, [LP_ALLEGRO_DISPLAY, c_long, c_long])
al_rest = _dll("al_rest", c_long, [c_double])
al_restore_default_mixer = _dll("al_restore_default_mixer", c_bool, [])
al_restore_state = _dll("al_restore_state", c_long, [LP_ALLEGRO_STATE])
al_resume_timer = _dll("al_resume_timer", c_long, [LP_ALLEGRO_TIMER])
al_rewind_audio_stream = _dll("al_rewind_audio_stream", c_bool, [LP_ALLEGRO_AUDIO_STREAM])
al_rotate_transform = _dll("al_rotate_transform", c_long, [LP_ALLEGRO_TRANSFORM, c_float])
al_rotate_transform_3d = _dll("al_rotate_transform_3d", c_long, [LP_ALLEGRO_TRANSFORM, c_float, c_float, c_float, c_float])
al_run_detached_thread = _dll("al_run_detached_thread", c_long, [c_void_p, c_void_p])
al_run_main = _dll("al_run_main", c_long, [c_long, c_void_p, c_void_p])
al_save_bitmap = _dll("al_save_bitmap", c_bool, [_AL_UTF8String, LP_ALLEGRO_BITMAP])
al_save_bitmap_f = _dll("al_save_bitmap_f", c_bool, [LP_ALLEGRO_FILE, _AL_UTF8String, LP_ALLEGRO_BITMAP])
al_save_config_file = _dll("al_save_config_file", c_bool, [_AL_UTF8String, LP_ALLEGRO_CONFIG])
al_save_config_file_f = _dll("al_save_config_file_f", c_bool, [LP_ALLEGRO_FILE, LP_ALLEGRO_CONFIG])
al_save_sample = _dll("al_save_sample", c_bool, [_AL_UTF8String, LP_ALLEGRO_SAMPLE])
al_save_sample_f = _dll("al_save_sample_f", c_bool, [LP_ALLEGRO_FILE, _AL_UTF8String, LP_ALLEGRO_SAMPLE])
al_scale_transform = _dll("al_scale_transform", c_long, [LP_ALLEGRO_TRANSFORM, c_float, c_float])
al_scale_transform_3d = _dll("al_scale_transform_3d", c_long, [LP_ALLEGRO_TRANSFORM, c_float, c_float, c_float])
al_seek_audio_stream_secs = _dll("al_seek_audio_stream_secs", c_bool, [LP_ALLEGRO_AUDIO_STREAM, c_double])
al_seek_video = _dll("al_seek_video", c_bool, [LP_ALLEGRO_VIDEO, c_double])
al_set_app_name = _dll("al_set_app_name", c_long, [_AL_UTF8String])
al_set_audio_stream_fragment = _dll("al_set_audio_stream_fragment", c_bool, [LP_ALLEGRO_AUDIO_STREAM, c_void_p])
al_set_audio_stream_gain = _dll("al_set_audio_stream_gain", c_bool, [LP_ALLEGRO_AUDIO_STREAM, c_float])
al_set_audio_stream_loop_secs = _dll("al_set_audio_stream_loop_secs", c_bool, [LP_ALLEGRO_AUDIO_STREAM, c_double, c_double])
al_set_audio_stream_pan = _dll("al_set_audio_stream_pan", c_bool, [LP_ALLEGRO_AUDIO_STREAM, c_float])
al_set_audio_stream_playing = _dll("al_set_audio_stream_playing", c_bool, [LP_ALLEGRO_AUDIO_STREAM, c_bool])
al_set_audio_stream_playmode = _dll("al_set_audio_stream_playmode", c_bool, [LP_ALLEGRO_AUDIO_STREAM, c_long])
al_set_audio_stream_speed = _dll("al_set_audio_stream_speed", c_bool, [LP_ALLEGRO_AUDIO_STREAM, c_float])
al_set_blend_color = _dll("al_set_blend_color", c_long, [ALLEGRO_COLOR])
al_set_blender = _dll("al_set_blender", c_long, [c_long, c_long, c_long])
al_set_clipboard_text = _dll("al_set_clipboard_text", c_bool, [LP_ALLEGRO_DISPLAY, _AL_UTF8String])
al_set_clipping_rectangle = _dll("al_set_clipping_rectangle", c_long, [c_long, c_long, c_long, c_long])
al_set_config_value = _dll("al_set_config_value", c_long, [LP_ALLEGRO_CONFIG, _AL_UTF8String, _AL_UTF8String, _AL_UTF8String])
al_set_current_opengl_context = _dll("al_set_current_opengl_context", c_long, [LP_ALLEGRO_DISPLAY])
al_set_default_mixer = _dll("al_set_default_mixer", c_bool, [LP_ALLEGRO_MIXER])
al_set_default_voice = _dll("al_set_default_voice", c_long, [LP_ALLEGRO_VOICE])
al_set_display_flag = _dll("al_set_display_flag", c_bool, [LP_ALLEGRO_DISPLAY, c_long, c_bool])
al_set_display_icon = _dll("al_set_display_icon", c_long, [LP_ALLEGRO_DISPLAY, LP_ALLEGRO_BITMAP])
al_set_display_icons = _dll("al_set_display_icons", c_long, [LP_ALLEGRO_DISPLAY, c_long, c_void_p])
al_set_display_menu = _dll("al_set_display_menu", c_bool, [LP_ALLEGRO_DISPLAY, LP_ALLEGRO_MENU])
al_set_display_option = _dll("al_set_display_option", c_long, [LP_ALLEGRO_DISPLAY, c_long, c_long])
al_set_errno = _dll("al_set_errno", c_long, [c_long])
al_set_event_source_data = _dll("al_set_event_source_data", c_long, [c_void_p, c_void_p])
al_set_exe_name = _dll("al_set_exe_name", c_long, [_AL_UTF8String])
al_set_fallback_font = _dll("al_set_fallback_font", c_long, [LP_ALLEGRO_FONT, LP_ALLEGRO_FONT])
al_set_fs_interface = _dll("al_set_fs_interface", c_long, [LP_ALLEGRO_FS_INTERFACE])
al_set_keyboard_leds = _dll("al_set_keyboard_leds", c_bool, [c_long])
al_set_memory_interface = _dll("al_set_memory_interface", c_long, [LP_ALLEGRO_MEMORY_INTERFACE])
al_set_menu_item_caption = _dll("al_set_menu_item_caption", c_long, [LP_ALLEGRO_MENU, c_long, _AL_UTF8String])
al_set_menu_item_flags = _dll("al_set_menu_item_flags", c_long, [LP_ALLEGRO_MENU, c_long, c_long])
al_set_menu_item_icon = _dll("al_set_menu_item_icon", c_long, [LP_ALLEGRO_MENU, c_long, LP_ALLEGRO_BITMAP])
al_set_mixer_frequency = _dll("al_set_mixer_frequency", c_bool, [LP_ALLEGRO_MIXER, c_ulong])
al_set_mixer_gain = _dll("al_set_mixer_gain", c_bool, [LP_ALLEGRO_MIXER, c_float])
al_set_mixer_playing = _dll("al_set_mixer_playing", c_bool, [LP_ALLEGRO_MIXER, c_bool])
al_set_mixer_postprocess_callback = _dll("al_set_mixer_postprocess_callback", c_bool, [LP_ALLEGRO_MIXER, c_void_p, c_void_p])
al_set_mixer_quality = _dll("al_set_mixer_quality", c_bool, [LP_ALLEGRO_MIXER, c_long])
al_set_mouse_axis = _dll("al_set_mouse_axis", c_bool, [c_long, c_long])
al_set_mouse_cursor = _dll("al_set_mouse_cursor", c_bool, [LP_ALLEGRO_DISPLAY, LP_ALLEGRO_MOUSE_CURSOR])
al_set_mouse_w = _dll("al_set_mouse_w", c_bool, [c_long])
al_set_mouse_wheel_precision = _dll("al_set_mouse_wheel_precision", c_long, [c_long])
al_set_mouse_xy = _dll("al_set_mouse_xy", c_bool, [LP_ALLEGRO_DISPLAY, c_long, c_long])
al_set_mouse_z = _dll("al_set_mouse_z", c_bool, [c_long])
al_set_new_bitmap_flags = _dll("al_set_new_bitmap_flags", c_long, [c_long])
al_set_new_bitmap_format = _dll("al_set_new_bitmap_format", c_long, [c_long])
al_set_new_display_adapter = _dll("al_set_new_display_adapter", c_long, [c_long])
al_set_new_display_flags = _dll("al_set_new_display_flags", c_long, [c_long])
al_set_new_display_option = _dll("al_set_new_display_option", c_long, [c_long, c_long, c_long])
al_set_new_display_refresh_rate = _dll("al_set_new_display_refresh_rate", c_long, [c_long])
al_set_new_file_interface = _dll("al_set_new_file_interface", c_long, [LP_ALLEGRO_FILE_INTERFACE])
al_set_new_window_position = _dll("al_set_new_window_position", c_long, [c_long, c_long])
al_set_new_window_title = _dll("al_set_new_window_title", c_long, [_AL_UTF8String])
al_set_org_name = _dll("al_set_org_name", c_long, [_AL_UTF8String])
al_set_path_drive = _dll("al_set_path_drive", c_long, [LP_ALLEGRO_PATH, _AL_UTF8String])
al_set_path_extension = _dll("al_set_path_extension", c_bool, [LP_ALLEGRO_PATH, _AL_UTF8String])
al_set_path_filename = _dll("al_set_path_filename", c_long, [LP_ALLEGRO_PATH, _AL_UTF8String])
al_set_physfs_file_interface = _dll("al_set_physfs_file_interface", c_long, [])
al_set_render_state = _dll("al_set_render_state", c_long, [c_long, c_long])
al_set_sample = _dll("al_set_sample", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE, LP_ALLEGRO_SAMPLE])
al_set_sample_instance_gain = _dll("al_set_sample_instance_gain", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE, c_float])
al_set_sample_instance_length = _dll("al_set_sample_instance_length", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE, c_ulong])
al_set_sample_instance_pan = _dll("al_set_sample_instance_pan", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE, c_float])
al_set_sample_instance_playing = _dll("al_set_sample_instance_playing", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE, c_bool])
al_set_sample_instance_playmode = _dll("al_set_sample_instance_playmode", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE, c_long])
al_set_sample_instance_position = _dll("al_set_sample_instance_position", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE, c_ulong])
al_set_sample_instance_speed = _dll("al_set_sample_instance_speed", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE, c_float])
al_set_separate_blender = _dll("al_set_separate_blender", c_long, [c_long, c_long, c_long, c_long, c_long, c_long])
al_set_shader_bool = _dll("al_set_shader_bool", c_bool, [_AL_UTF8String, c_bool])
al_set_shader_float = _dll("al_set_shader_float", c_bool, [_AL_UTF8String, c_float])
al_set_shader_float_vector = _dll("al_set_shader_float_vector", c_bool, [_AL_UTF8String, c_long, c_void_p, c_long])
al_set_shader_int = _dll("al_set_shader_int", c_bool, [_AL_UTF8String, c_long])
al_set_shader_int_vector = _dll("al_set_shader_int_vector", c_bool, [_AL_UTF8String, c_long, c_void_p, c_long])
al_set_shader_matrix = _dll("al_set_shader_matrix", c_bool, [_AL_UTF8String, LP_ALLEGRO_TRANSFORM])
al_set_shader_sampler = _dll("al_set_shader_sampler", c_bool, [_AL_UTF8String, LP_ALLEGRO_BITMAP, c_long])
al_set_standard_file_interface = _dll("al_set_standard_file_interface", c_long, [])
al_set_standard_fs_interface = _dll("al_set_standard_fs_interface", c_long, [])
al_set_system_mouse_cursor = _dll("al_set_system_mouse_cursor", c_bool, [LP_ALLEGRO_DISPLAY, c_long])
al_set_target_backbuffer = _dll("al_set_target_backbuffer", c_long, [LP_ALLEGRO_DISPLAY])
al_set_target_bitmap = _dll("al_set_target_bitmap", c_long, [LP_ALLEGRO_BITMAP])
al_set_thread_should_stop = _dll("al_set_thread_should_stop", c_long, [LP_ALLEGRO_THREAD])
al_set_timer_count = _dll("al_set_timer_count", c_long, [LP_ALLEGRO_TIMER, c_longlong])
al_set_timer_speed = _dll("al_set_timer_speed", c_long, [LP_ALLEGRO_TIMER, c_double])
al_set_video_playing = _dll("al_set_video_playing", c_long, [LP_ALLEGRO_VIDEO, c_bool])
al_set_voice_playing = _dll("al_set_voice_playing", c_bool, [LP_ALLEGRO_VOICE, c_bool])
al_set_voice_position = _dll("al_set_voice_position", c_bool, [LP_ALLEGRO_VOICE, c_ulong])
al_set_window_constraints = _dll("al_set_window_constraints", c_bool, [LP_ALLEGRO_DISPLAY, c_long, c_long, c_long, c_long])
al_set_window_position = _dll("al_set_window_position", c_long, [LP_ALLEGRO_DISPLAY, c_long, c_long])
al_set_window_title = _dll("al_set_window_title", c_long, [LP_ALLEGRO_DISPLAY, _AL_UTF8String])
al_show_mouse_cursor = _dll("al_show_mouse_cursor", c_bool, [LP_ALLEGRO_DISPLAY])
al_show_native_file_dialog = _dll("al_show_native_file_dialog", c_bool, [LP_ALLEGRO_DISPLAY, LP_ALLEGRO_FILECHOOSER])
al_show_native_message_box = _dll("al_show_native_message_box", c_long, [LP_ALLEGRO_DISPLAY, _AL_UTF8String, _AL_UTF8String, _AL_UTF8String, _AL_UTF8String, c_long])
al_shutdown_font_addon = _dll("al_shutdown_font_addon", c_long, [])
al_shutdown_image_addon = _dll("al_shutdown_image_addon", c_long, [])
al_shutdown_native_dialog_addon = _dll("al_shutdown_native_dialog_addon", c_long, [])
al_shutdown_primitives_addon = _dll("al_shutdown_primitives_addon", c_long, [])
al_shutdown_ttf_addon = _dll("al_shutdown_ttf_addon", c_long, [])
al_shutdown_video_addon = _dll("al_shutdown_video_addon", c_long, [])
al_signal_cond = _dll("al_signal_cond", c_long, [LP_ALLEGRO_COND])
al_start_thread = _dll("al_start_thread", c_long, [LP_ALLEGRO_THREAD])
al_start_timer = _dll("al_start_timer", c_long, [LP_ALLEGRO_TIMER])
al_start_video = _dll("al_start_video", c_long, [LP_ALLEGRO_VIDEO, LP_ALLEGRO_MIXER])
al_start_video_with_voice = _dll("al_start_video_with_voice", c_long, [LP_ALLEGRO_VIDEO, LP_ALLEGRO_VOICE])
al_stop_sample = _dll("al_stop_sample", c_long, [LP_ALLEGRO_SAMPLE_ID])
al_stop_sample_instance = _dll("al_stop_sample_instance", c_bool, [LP_ALLEGRO_SAMPLE_INSTANCE])
al_stop_samples = _dll("al_stop_samples", c_long, [])
al_stop_timer = _dll("al_stop_timer", c_long, [LP_ALLEGRO_TIMER])
al_store_state = _dll("al_store_state", c_long, [LP_ALLEGRO_STATE, c_long])
al_transform_coordinates = _dll("al_transform_coordinates", c_long, [LP_ALLEGRO_TRANSFORM, c_void_p, c_void_p])
al_transform_coordinates_3d = _dll("al_transform_coordinates_3d", c_long, [LP_ALLEGRO_TRANSFORM, c_void_p, c_void_p, c_void_p])
al_transform_coordinates_3d_projective = _dll("al_transform_coordinates_3d_projective", c_long, [LP_ALLEGRO_TRANSFORM, c_void_p, c_void_p, c_void_p])
al_transform_coordinates_4d = _dll("al_transform_coordinates_4d", c_long, [LP_ALLEGRO_TRANSFORM, c_void_p, c_void_p, c_void_p, c_void_p])
al_translate_transform = _dll("al_translate_transform", c_long, [LP_ALLEGRO_TRANSFORM, c_float, c_float])
al_translate_transform_3d = _dll("al_translate_transform_3d", c_long, [LP_ALLEGRO_TRANSFORM, c_float, c_float, c_float])
al_transpose_transform = _dll("al_transpose_transform", c_long, [LP_ALLEGRO_TRANSFORM])
al_triangulate_polygon = _dll("al_triangulate_polygon", c_bool, [c_void_p, c_ulong, c_void_p, c_void_p, c_void_p])
al_ungrab_mouse = _dll("al_ungrab_mouse", c_bool, [])
al_uninstall_audio = _dll("al_uninstall_audio", c_long, [])
al_uninstall_joystick = _dll("al_uninstall_joystick", c_long, [])
al_uninstall_keyboard = _dll("al_uninstall_keyboard", c_long, [])
al_uninstall_mouse = _dll("al_uninstall_mouse", c_long, [])
al_uninstall_system = _dll("al_uninstall_system", c_long, [])
al_uninstall_touch_input = _dll("al_uninstall_touch_input", c_long, [])
al_unlock_bitmap = _dll("al_unlock_bitmap", c_long, [LP_ALLEGRO_BITMAP])
al_unlock_index_buffer = _dll("al_unlock_index_buffer", c_long, [LP_ALLEGRO_INDEX_BUFFER])
al_unlock_mutex = _dll("al_unlock_mutex", c_long, [LP_ALLEGRO_MUTEX])
al_unlock_vertex_buffer = _dll("al_unlock_vertex_buffer", c_long, [LP_ALLEGRO_VERTEX_BUFFER])
al_unmap_rgb = _dll("al_unmap_rgb", c_long, [ALLEGRO_COLOR, c_void_p, c_void_p, c_void_p])
al_unmap_rgb_f = _dll("al_unmap_rgb_f", c_long, [ALLEGRO_COLOR, c_void_p, c_void_p, c_void_p])
al_unmap_rgba = _dll("al_unmap_rgba", c_long, [ALLEGRO_COLOR, c_void_p, c_void_p, c_void_p, c_void_p])
al_unmap_rgba_f = _dll("al_unmap_rgba_f", c_long, [ALLEGRO_COLOR, c_void_p, c_void_p, c_void_p, c_void_p])
al_unref_user_event = _dll("al_unref_user_event", c_long, [c_void_p])
al_unregister_event_source = _dll("al_unregister_event_source", c_long, [c_void_p, c_void_p])
al_update_display_region = _dll("al_update_display_region", c_long, [c_long, c_long, c_long, c_long])
al_update_fs_entry = _dll("al_update_fs_entry", c_bool, [LP_ALLEGRO_FS_ENTRY])
al_use_projection_transform = _dll("al_use_projection_transform", c_long, [LP_ALLEGRO_TRANSFORM])
al_use_shader = _dll("al_use_shader", c_bool, [LP_ALLEGRO_SHADER])
al_use_transform = _dll("al_use_transform", c_long, [LP_ALLEGRO_TRANSFORM])
al_ustr_append = _dll("al_ustr_append", c_bool, [LP_ALLEGRO_USTR, LP_ALLEGRO_USTR])
al_ustr_append_chr = _dll("al_ustr_append_chr", c_ulong, [LP_ALLEGRO_USTR, c_long])
al_ustr_append_cstr = _dll("al_ustr_append_cstr", c_bool, [LP_ALLEGRO_USTR, _AL_UTF8String])
al_ustr_appendf = _dll("al_ustr_appendf", c_bool, [LP_ALLEGRO_USTR, _AL_UTF8String, c_void_p])
al_ustr_assign = _dll("al_ustr_assign", c_bool, [LP_ALLEGRO_USTR, LP_ALLEGRO_USTR])
al_ustr_assign_cstr = _dll("al_ustr_assign_cstr", c_bool, [LP_ALLEGRO_USTR, _AL_UTF8String])
al_ustr_assign_substr = _dll("al_ustr_assign_substr", c_bool, [LP_ALLEGRO_USTR, LP_ALLEGRO_USTR, c_long, c_long])
al_ustr_compare = _dll("al_ustr_compare", c_long, [LP_ALLEGRO_USTR, LP_ALLEGRO_USTR])
al_ustr_dup = _dll("al_ustr_dup", LP_ALLEGRO_USTR, [LP_ALLEGRO_USTR])
al_ustr_dup_substr = _dll("al_ustr_dup_substr", LP_ALLEGRO_USTR, [LP_ALLEGRO_USTR, c_long, c_long])
al_ustr_empty_string = _dll("al_ustr_empty_string", LP_ALLEGRO_USTR, [])
al_ustr_encode_utf16 = _dll("al_ustr_encode_utf16", c_ulong, [LP_ALLEGRO_USTR, c_void_p, c_ulong])
al_ustr_equal = _dll("al_ustr_equal", c_bool, [LP_ALLEGRO_USTR, LP_ALLEGRO_USTR])
al_ustr_find_chr = _dll("al_ustr_find_chr", c_long, [LP_ALLEGRO_USTR, c_long, c_long])
al_ustr_find_cset = _dll("al_ustr_find_cset", c_long, [LP_ALLEGRO_USTR, c_long, LP_ALLEGRO_USTR])
al_ustr_find_cset_cstr = _dll("al_ustr_find_cset_cstr", c_long, [LP_ALLEGRO_USTR, c_long, _AL_UTF8String])
al_ustr_find_cstr = _dll("al_ustr_find_cstr", c_long, [LP_ALLEGRO_USTR, c_long, _AL_UTF8String])
al_ustr_find_replace = _dll("al_ustr_find_replace", c_bool, [LP_ALLEGRO_USTR, c_long, LP_ALLEGRO_USTR, LP_ALLEGRO_USTR])
al_ustr_find_replace_cstr = _dll("al_ustr_find_replace_cstr", c_bool, [LP_ALLEGRO_USTR, c_long, _AL_UTF8String, _AL_UTF8String])
al_ustr_find_set = _dll("al_ustr_find_set", c_long, [LP_ALLEGRO_USTR, c_long, LP_ALLEGRO_USTR])
al_ustr_find_set_cstr = _dll("al_ustr_find_set_cstr", c_long, [LP_ALLEGRO_USTR, c_long, _AL_UTF8String])
al_ustr_find_str = _dll("al_ustr_find_str", c_long, [LP_ALLEGRO_USTR, c_long, LP_ALLEGRO_USTR])
al_ustr_free = _dll("al_ustr_free", c_long, [LP_ALLEGRO_USTR])
al_ustr_get = _dll("al_ustr_get", c_long, [LP_ALLEGRO_USTR, c_long])
al_ustr_get_next = _dll("al_ustr_get_next", c_long, [LP_ALLEGRO_USTR, c_void_p])
al_ustr_has_prefix = _dll("al_ustr_has_prefix", c_bool, [LP_ALLEGRO_USTR, LP_ALLEGRO_USTR])
al_ustr_has_prefix_cstr = _dll("al_ustr_has_prefix_cstr", c_bool, [LP_ALLEGRO_USTR, _AL_UTF8String])
al_ustr_has_suffix = _dll("al_ustr_has_suffix", c_bool, [LP_ALLEGRO_USTR, LP_ALLEGRO_USTR])
al_ustr_has_suffix_cstr = _dll("al_ustr_has_suffix_cstr", c_bool, [LP_ALLEGRO_USTR, _AL_UTF8String])
al_ustr_insert = _dll("al_ustr_insert", c_bool, [LP_ALLEGRO_USTR, c_long, LP_ALLEGRO_USTR])
al_ustr_insert_chr = _dll("al_ustr_insert_chr", c_ulong, [LP_ALLEGRO_USTR, c_long, c_long])
al_ustr_insert_cstr = _dll("al_ustr_insert_cstr", c_bool, [LP_ALLEGRO_USTR, c_long, _AL_UTF8String])
al_ustr_length = _dll("al_ustr_length", c_ulong, [LP_ALLEGRO_USTR])
al_ustr_ltrim_ws = _dll("al_ustr_ltrim_ws", c_bool, [LP_ALLEGRO_USTR])
al_ustr_ncompare = _dll("al_ustr_ncompare", c_long, [LP_ALLEGRO_USTR, LP_ALLEGRO_USTR, c_long])
al_ustr_new = _dll("al_ustr_new", LP_ALLEGRO_USTR, [_AL_UTF8String])
al_ustr_new_from_buffer = _dll("al_ustr_new_from_buffer", LP_ALLEGRO_USTR, [_AL_UTF8String, c_ulong])
al_ustr_new_from_utf16 = _dll("al_ustr_new_from_utf16", LP_ALLEGRO_USTR, [c_void_p])
al_ustr_newf = _dll("al_ustr_newf", LP_ALLEGRO_USTR, [_AL_UTF8String, c_void_p])
al_ustr_next = _dll("al_ustr_next", c_bool, [LP_ALLEGRO_USTR, c_void_p])
al_ustr_offset = _dll("al_ustr_offset", c_long, [LP_ALLEGRO_USTR, c_long])
al_ustr_prev = _dll("al_ustr_prev", c_bool, [LP_ALLEGRO_USTR, c_void_p])
al_ustr_prev_get = _dll("al_ustr_prev_get", c_long, [LP_ALLEGRO_USTR, c_void_p])
al_ustr_remove_chr = _dll("al_ustr_remove_chr", c_bool, [LP_ALLEGRO_USTR, c_long])
al_ustr_remove_range = _dll("al_ustr_remove_range", c_bool, [LP_ALLEGRO_USTR, c_long, c_long])
al_ustr_replace_range = _dll("al_ustr_replace_range", c_bool, [LP_ALLEGRO_USTR, c_long, c_long, LP_ALLEGRO_USTR])
al_ustr_rfind_chr = _dll("al_ustr_rfind_chr", c_long, [LP_ALLEGRO_USTR, c_long, c_long])
al_ustr_rfind_cstr = _dll("al_ustr_rfind_cstr", c_long, [LP_ALLEGRO_USTR, c_long, _AL_UTF8String])
al_ustr_rfind_str = _dll("al_ustr_rfind_str", c_long, [LP_ALLEGRO_USTR, c_long, LP_ALLEGRO_USTR])
al_ustr_rtrim_ws = _dll("al_ustr_rtrim_ws", c_bool, [LP_ALLEGRO_USTR])
al_ustr_set_chr = _dll("al_ustr_set_chr", c_ulong, [LP_ALLEGRO_USTR, c_long, c_long])
al_ustr_size = _dll("al_ustr_size", c_ulong, [LP_ALLEGRO_USTR])
al_ustr_size_utf16 = _dll("al_ustr_size_utf16", c_ulong, [LP_ALLEGRO_USTR])
al_ustr_to_buffer = _dll("al_ustr_to_buffer", c_long, [LP_ALLEGRO_USTR, _AL_UTF8String, c_long])
al_ustr_trim_ws = _dll("al_ustr_trim_ws", c_bool, [LP_ALLEGRO_USTR])
al_ustr_truncate = _dll("al_ustr_truncate", c_bool, [LP_ALLEGRO_USTR, c_long])
al_ustr_vappendf = _dll("al_ustr_vappendf", c_bool, [LP_ALLEGRO_USTR, _AL_UTF8String, c_void_p])
al_utf16_encode = _dll("al_utf16_encode", c_ulong, [c_void_p, c_long])
al_utf16_width = _dll("al_utf16_width", c_ulong, [c_long])
al_utf8_encode = _dll("al_utf8_encode", c_ulong, [c_void_p, c_long])
al_utf8_width = _dll("al_utf8_width", c_ulong, [c_long])
al_vertical_shear_transform = _dll("al_vertical_shear_transform", c_long, [LP_ALLEGRO_TRANSFORM, c_float])
al_vfprintf = _dll("al_vfprintf", c_long, [LP_ALLEGRO_FILE, _AL_UTF8String, c_void_p])
al_wait_cond = _dll("al_wait_cond", c_long, [LP_ALLEGRO_COND, LP_ALLEGRO_MUTEX])
al_wait_cond_until = _dll("al_wait_cond_until", c_long, [LP_ALLEGRO_COND, LP_ALLEGRO_MUTEX, LP_ALLEGRO_TIMEOUT])
al_wait_for_event = _dll("al_wait_for_event", c_long, [c_void_p, LP_ALLEGRO_EVENT])
al_wait_for_event_timed = _dll("al_wait_for_event_timed", c_bool, [c_void_p, LP_ALLEGRO_EVENT, c_float])
al_wait_for_event_until = _dll("al_wait_for_event_until", c_bool, [LP_ALLEGRO_EVENT_QUEUE, LP_ALLEGRO_EVENT, LP_ALLEGRO_TIMEOUT])
al_wait_for_vsync = _dll("al_wait_for_vsync", c_bool, [])
al_win_add_window_callback = _dll("al_win_add_window_callback", c_bool, [LP_ALLEGRO_DISPLAY, c_void_p, c_void_p])
al_win_remove_window_callback = _dll("al_win_remove_window_callback", c_bool, [LP_ALLEGRO_DISPLAY, c_void_p, c_void_p])

ALLEGRO_VERSION_INT = \
    ((ALLEGRO_VERSION << 24) | (ALLEGRO_SUB_VERSION << 16) | \
    (ALLEGRO_WIP_VERSION << 8) | ALLEGRO_RELEASE_NUMBER)

al_current_time = al_get_time
al_event_queue_is_empty = al_is_event_queue_empty
atexit = CDLL('msvcrt').atexit
al_init = lambda: al_install_system(ALLEGRO_VERSION_INT, atexit)
AL_ID = lambda a, b: (((a)<<24) | ((b)<<16) | ((c)<<8) | (d)) 
ALLEGRO_EVENT_TYPE_IS_USER = lambda t: ((t) >= 512)
ALLEGRO_GET_EVENT_TYPE = AL_ID
ALLEGRO_USECS_TO_SECS = lambda x: ((x) / 1000000.0)
ALLEGRO_MSECS_TO_SECS = lambda x: ((x) / 1000.0)
ALLEGRO_BPS_TO_SECS = lambda x: (1.0 / (x))
ALLEGRO_BPM_TO_SECS = lambda x: (60.0 / (x))

# work around bug http://gcc.gnu.org/bugzilla/show_bug.cgi?id=36834
if os.name == "nt":
    def al_map_rgba_f(r, g, b, a): return ALLEGRO_COLOR(r, g, b, a)
    def al_map_rgb_f(r, g, b): return ALLEGRO_COLOR(r, g, b, 1)
    def al_map_rgba(r, g, b, a):
        return ALLEGRO_COLOR(r / 255.0, g / 255.0, b / 255.0, a / 255.0)
    def al_map_rgb(r, g, b):
        return ALLEGRO_COLOR(r / 255.0, g / 255.0, b / 255.0, 1)
    
def al_main(real_main, *args):
    def python_callback(argc, argv):
        real_main(*args)
        return 0
    cb = CFUNCTYPE(c_int, c_int, c_void_p)(python_callback)
    al_run_main(0, 0, cb);
