/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xpath.expr;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.javarosa.xpath.XPathUnsupportedException;
import org.javarosa.xpath.expr.Encoding;

public enum DigestAlgorithm {
    MD5("MD5"),
    SHA1("SHA-1"),
    SHA256("SHA-256"),
    SHA384("SHA-384"),
    SHA512("SHA-512");

    private final String name;

    private DigestAlgorithm(String name) {
        this.name = name;
    }

    private MessageDigest getDigestInstance() {
        try {
            return MessageDigest.getInstance(this.name);
        }
        catch (NoSuchAlgorithmException e) {
            throw new XPathUnsupportedException("digest(..., '" + this.name + "', ...)");
        }
    }

    static DigestAlgorithm from(String name) {
        try {
            return DigestAlgorithm.valueOf(name.toUpperCase().replaceAll("-", ""));
        }
        catch (IllegalArgumentException ex) {
            throw new XPathUnsupportedException("digest(..., '" + name + "', ...)");
        }
    }

    public String digest(String payload, Encoding encoding) {
        return encoding.encode(this.digest(payload));
    }

    public byte[] digest(String payload) {
        return this.getDigestInstance().digest(this.uncheckedGetUtf8Bytes(payload));
    }

    private byte[] uncheckedGetUtf8Bytes(String payload) {
        try {
            return payload.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("The function digest failed to use UTF-8 encoding");
        }
    }
}

