/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.xform.parse;

import java.util.HashSet;
import java.util.Stack;
import org.javarosa.core.util.CacheTable;
import org.javarosa.xform.parse.ElementChildDeleter;
import org.kxml2.kdom.Element;

class XmlTextConsolidator {
    XmlTextConsolidator() {
    }

    static void consolidateText(CacheTable<String> stringCache, Element rootElement) {
        Stack<Element> q = new Stack<Element>();
        q.push(rootElement);
        while (!q.isEmpty()) {
            Element e = (Element)q.pop();
            HashSet<Integer> removeIndexes = new HashSet<Integer>();
            String accumulator = "";
            for (int i = 0; i < e.getChildCount(); ++i) {
                int type = e.getType(i);
                if (type == 4) {
                    accumulator = accumulator + e.getText(i);
                    removeIndexes.add(i);
                    continue;
                }
                if (type == 2) {
                    q.add(e.getElement(i));
                }
                if (XmlTextConsolidator.nonBlank(accumulator)) {
                    e.addChild(i++, 4, XmlTextConsolidator.maybeInternedString(stringCache, accumulator));
                }
                accumulator = "";
            }
            if (XmlTextConsolidator.nonBlank(accumulator)) {
                e.addChild(4, XmlTextConsolidator.maybeInternedString(stringCache, accumulator));
            }
            ElementChildDeleter.delete(e, removeIndexes);
        }
    }

    private static boolean nonBlank(String s) {
        return !s.trim().isEmpty();
    }

    private static String maybeInternedString(CacheTable<String> stringCache, String accumulate) {
        return stringCache == null ? accumulate : stringCache.intern(accumulate);
    }
}

