/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.services.storage;

import java.util.HashMap;
import java.util.Iterator;
import org.javarosa.core.services.ProgramFlow;
import org.javarosa.core.services.storage.IStorageFactory;
import org.javarosa.core.services.storage.IStorageUtility;
import org.javarosa.core.services.storage.WrappingStorageUtility;
import org.javarosa.core.util.externalizable.Externalizable;

public class StorageManager {
    private static HashMap<String, IStorageUtility<? extends Externalizable>> storageRegistry = new HashMap();
    private static IStorageFactory storageFactory;

    public static void setStorageFactory(IStorageFactory fact) {
        StorageManager.setStorageFactory(fact, false);
    }

    public static void setStorageFactory(IStorageFactory fact, boolean mustWork) {
        if (storageFactory == null) {
            storageFactory = fact;
        } else if (mustWork) {
            ProgramFlow.die("A Storage Factory had already been set when storage factory " + fact.getClass().getName() + " attempted to become the only storage factory", new RuntimeException("Duplicate Storage Factory set"));
        }
    }

    public static void registerStorage(String key, Class type) {
        StorageManager.registerStorage(key, key, type);
    }

    public static void registerStorage(String storageKey, String storageName, Class type) {
        if (storageFactory == null) {
            throw new RuntimeException("No storage factory has been set; I don't know what kind of storage utility to create. Either set a storage factory, or register your StorageUtilitys directly.");
        }
        StorageManager.registerStorage(storageKey, storageFactory.newStorage(storageName, type));
    }

    public static void registerStorage(String key, IStorageUtility<? extends Externalizable> storage) {
        storageRegistry.put(key, storage);
    }

    public static void registerWrappedStorage(String key, String storeName, WrappingStorageUtility.SerializationWrapper wrapper) {
        StorageManager.registerStorage(key, new WrappingStorageUtility(storeName, wrapper, storageFactory));
    }

    public static IStorageUtility<? extends Externalizable> getStorage(String key) {
        if (storageRegistry.containsKey(key)) {
            return storageRegistry.get(key);
        }
        throw new RuntimeException("No storage utility has been registered to handle \"" + key + "\"; you must register one first with StorageManager.registerStorage()");
    }

    public static void repairAll() {
        for (IStorageUtility<? extends Externalizable> storageUtility : storageRegistry.values()) {
            storageUtility.repair();
        }
    }

    public static String[] listRegisteredUtilities() {
        String[] returnVal = new String[storageRegistry.size()];
        int i = 0;
        Iterator<String> iterator = storageRegistry.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            returnVal[i] = key = iterator.next();
            ++i;
        }
        return returnVal;
    }

    public static void halt() {
        for (IStorageUtility<? extends Externalizable> storageUtility : storageRegistry.values()) {
            storageUtility.close();
        }
    }
}

