/*
 * Decompiled with CFR 0.152.
 */
package org.javarosa.core.model.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import org.javarosa.core.model.data.IAnswerData;
import org.javarosa.core.model.data.UncastData;
import org.javarosa.core.model.utils.DateUtils;
import org.javarosa.core.util.externalizable.ExtUtil;
import org.javarosa.core.util.externalizable.PrototypeFactory;

public class DateData
implements IAnswerData {
    private Date d;
    boolean init = false;

    public DateData() {
    }

    public DateData(Date d) {
        this.setValue(d);
    }

    private void init() {
        if (!this.init) {
            this.d = DateUtils.roundDate(this.d);
            this.init = true;
        }
    }

    @Override
    public IAnswerData clone() {
        this.init();
        return new DateData(new Date(this.d.getTime()));
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            throw new NullPointerException("Attempt to set an IAnswerData class to null.");
        }
        this.d = (Date)o;
        this.init = false;
    }

    @Override
    public Object getValue() {
        this.init();
        return new Date(this.d.getTime());
    }

    @Override
    public String getDisplayText() {
        this.init();
        return DateUtils.formatDate(this.d, 2);
    }

    @Override
    public void readExternal(DataInputStream in, PrototypeFactory pf) throws IOException {
        this.init();
        this.setValue(ExtUtil.readDate(in));
    }

    @Override
    public void writeExternal(DataOutputStream out) throws IOException {
        this.init();
        ExtUtil.writeDate(out, this.d);
    }

    @Override
    public UncastData uncast() {
        this.init();
        return new UncastData(DateUtils.formatDate(this.d, 1));
    }

    @Override
    public DateData cast(UncastData data) throws IllegalArgumentException {
        Date ret = DateUtils.parseDate(data.value);
        if (ret != null) {
            return new DateData(ret);
        }
        throw new IllegalArgumentException("Invalid cast of data [" + data.value + "] to type Date");
    }

    public String toString() {
        return "StringData{d='" + DateUtils.formatDate(this.d, 1) + "'}";
    }
}

