/*! 
* DevExtreme (Gauges)
* Version: 14.1.7
* Build date: Sep 22, 2014
*
* Copyright (c) 2012 - 2014 Developer Express Inc. ALL RIGHTS RESERVED
* EULA: https://www.devexpress.com/Support/EULAs/DevExtreme.xml
*/
"use strict";if(!DevExpress.MOD_VIZ_GAUGES){if(!DevExpress.MOD_VIZ_CORE)throw Error("Required module is not referenced: viz-core");(function(n){n.viz.gauges={__internals:{circularNeedles:{},circularMarkers:{},linearNeedles:{},linearMarkers:{}}}})(DevExpress),function(n,t,i){var r=n.viz.gauges.__internals,f=r.circularNeedles,o=r.circularMarkers,e=r.linearNeedles,s=r.linearMarkers,u=window.String,a=n.utils.isString;n.viz.gauges.__factory={createCircularValueIndicator:function(n){var t=f.RectangleNeedle;switch(u(n).toLowerCase()){case"rectangleneedle":case"rectangle":t=f.RectangleNeedle;break;case"triangleneedle":case"triangle":t=f.TriangleNeedle;break;case"twocolorneedle":case"twocolorrectangle":t=f.TwoColorRectangleNeedle;break;case"rangebar":t=r.CircularRangeBar}return new t},createLinearValueIndicator:function(n){var t=r.LinearRangeBar;switch(u(n).toLowerCase()){case"rectangle":t=e.RectangleNeedle;break;case"rhombus":t=e.RhombusNeedle;break;case"circle":t=e.CircleNeedle;break;case"rangebar":t=r.LinearRangeBar}return new t},createCircularSubvalueIndicator:function(n){var t=o.TriangleMarker;switch(u(n).toLowerCase()){case"trianglemarker":case"triangle":t=o.TriangleMarker;break;case"textcloud":t=o.TextCloudMarker}return new t},createLinearSubvalueIndicator:function(n){var t=s.TriangleMarker;switch(u(n).toLowerCase()){case"trianglemarker":case"triangle":t=s.TriangleMarker;break;case"textcloud":t=s.TextCloudMarker}return new t},createCircularValueIndicatorInHardMode:function(n){var t=null;switch(u(n).toLowerCase()){case"rectangleneedle":t=f.RectangleNeedle;break;case"triangleneedle":t=f.TriangleNeedle;break;case"twocolorneedle":t=f.TwoColorRectangleNeedle;break;case"rangebar":t=r.CircularRangeBar;break;case"trianglemarker":t=o.TriangleMarker;break;case"textcloud":t=o.TextCloudMarker}return t?new t:null},createLinearValueIndicatorInHardMode:function(n){var t=null;switch(u(n).toLowerCase()){case"rectangle":t=e.RectangleNeedle;break;case"rhombus":t=e.RhombusNeedle;break;case"circle":t=e.CircleNeedle;break;case"rangebar":t=r.LinearRangeBar;break;case"trianglemarker":t=s.TriangleMarker;break;case"textcloud":t=s.TextCloudMarker}return t?new t:null},createCircularNeedle:function(n){switch(u(n).toLowerCase()){case"rectangleneedle":case"rectangle":return new f.RectangleNeedle;case"twocolorneedle":case"twocolorrectangle":return new f.TwoColorRectangleNeedle;case"triangleneedle":case"triangle":return new f.TriangleNeedle;case"rangebar":return new r.CircularRangeBar}return i},createLinearNeedle:function(n){switch(u(n).toLowerCase()){case"rectangle":return new e.RectangleNeedle;case"rhombus":return new e.RhombusNeedle;case"circle":return new e.CircleNeedle;case"rangebar":return new r.LinearRangeBar}return i},createCircularMarker:function(n){switch(u(n).toLowerCase()){case"trianglemarker":case"triangle":return new o.TriangleMarker;case"textcloud":return new o.TextCloudMarker}return i},createLinearMarker:function(n){switch(u(n).toLowerCase()){case"trianglemarker":case"triangle":return new s.TriangleMarker;case"textcloud":return new s.TextCloudMarker}return i},createCircularRangeBar:function(n){return new r.CircularRangeBar(n)},createLinearRangeBar:function(n){return new r.LinearRangeBar(n)},createCircularScale:function(n){return new r.CircularScale(n)},createLinearScale:function(n){return new r.LinearScale(n)},createCircularRangeContainer:function(n){return new r.CircularRangeContainer(n)},createLinearRangeContainer:function(n){return new r.LinearRangeContainer(n)},createTitle:function(n){return new r.Title(n)},createIndicator:function(){return r.Indicator&&new r.Indicator||null},createLayoutManager:function(){return new r.LayoutManager},createThemeManager:function(n){return new r.ThemeManager(n)},createTracker:function(n){return new r.Tracker(n)}};var h=n.utils.isFunction,u=window.String,c=t.extend,l=n.formatHelper;r.formatValue=function(n,t,i){var r,f;return(t=t||{},r=l.format(n,t.format,t.precision),h(t.customizeText))?(f=c({value:n,valueText:r},i),u(t.customizeText.call(f,f))):r},r.getSampleText=function(n,t){var i=r.formatValue(n.getDomainStart(),t),u=r.formatValue(n.getDomainEnd(),t);return i.length>=u.length?i:u}}(DevExpress,jQuery),function(n,t,i){function h(n,t){var i=0,r=t.length-1,e=t[i]-t[r]<0,u,f=-1;for(t[i]===n&&(f=i),t[r]===n&&(f=r);f<0&&i<=r;)u=~~((i+r)/2),t[u]===n?f=u:t[u]-n<0===e?i=u+1:r=u-1;return f}function tt(n,t){return n-t}function it(n,t){return t-n}function rt(n,t){var i,r,f;return n>t&&(f=t,t=n,n=f),i=0<=n&&n<=180?u(90-n):u(270-n),i=n<90&&90<t||n<270&&270<t?0:i,r=0<t&&t<180?u(90-t):u(270-t),i<r?i:r}var r=Number,y=String,p=isFinite,o=Math.min,f=Math.max,u=Math.abs,w=Math.atan,b=Math.acos,c=Math.ceil,k=n.utils.isFunction,d=n.utils.isArray,l=n.utils.getCosAndSin,a=n.utils.normalizeAngle,g=n.utils.convertAngleToRendererSpace,e=t.map,nt=n.formatHelper,v=n.viz.core.tickProvider,s=Math.PI/180;n.viz.gauges.__internals.BaseScale=n.Class.inherit({ctor:function(n){var t=this;t._renderer=n.renderer,t._container=n.container,t._translator=n.translator,t._root=t._renderer.createGroup({"class":"dxg-scale"}),t._majorTicks=t._renderer.createGroup({"class":"dxg-major-ticks"}),t._minorTicks=t._renderer.createGroup({"class":"dxg-minor-ticks"}),t._labels=t._renderer.createGroup({"class":"dxg-labels"})},dispose:function(){var n=this;return n._renderer=n._container=n._renderer=n._root=n._majorTicks=n._minorTicks=n._labels=null,n},clean:function(){var n=this;return n._root.detach(),n._majorTicks.detach().clear(),n._minorTicks.detach().clear(),n._labels.detach().clear(),n._majorTicksEnabled=n._minorTicksEnabled=n._labelsEnabled=n._options=n.enabled=null,n},render:function(n){var t=this;return t._options=n,t._processOptions(n),(t._majorTicksEnabled||t._minorTicksEnabled||t._labelsEnabled)&&(t.enabled=!0,t._root.append(t._container),t._majorTicksEnabled&&t._majorTicks.append(t._root),t._minorTicksEnabled&&t._minorTicks.append(t._root),t._labelsEnabled&&(t._labels.append(t._root),t._measureText())),t},_processOptions:function(n){var t=this;t._majorTicksEnabled=n.majorTick.visible&&n.majorTick.length>0&&n.majorTick.width>0,t._minorTicksEnabled=n.minorTick.visible&&n.minorTick.length>0&&n.minorTick.width>0,t._labelsEnabled=n.label.visible&&r(n.label.indentFromTick)!==0,t._setupOrientation()},_getSampleText:function(){for(var n=this,f=n._translator.getDomain(),c=[],t,e=0,o="",s=v.getTicks({min:f[0],max:f[1],tickInterval:n._options.majorTick.tickInterval>0?r(n._options.majorTick.tickInterval):i,screenDelta:n._options.approximateScreenDelta,gridSpacingFactor:n._getGridSpacingFactor().majorTicks}),u=0,h=s.length;u<h;++u)t=n._formatValue(s[u]),t.length>e&&(o=t)&&(e=t.length);return o},_measureText:function(){var n=this,i=n._getSampleText(),r=n._renderer.createText(i,0,0,{font:n._options.label.font}).append(n._labels),t=r.getBBox();r.remove(),n._textVerticalOffset=-t.y-t.height/2,n._textWidth=t.width,n._textHeight=t.height,n._textLength=i.length},_formatValue:function(n){var i=this._options.label,t=nt.format(n,i.format,i.precision);return k(i.customizeText)&&(t={value:n,valueText:t},t=y(i.customizeText.call(t,t))),t},_setupOrientation:null,_getCustomValues:function(n,t){var u=this._translator,i=[];return d(n)&&(i=e(n,function(n){return p(u.translate(n))?r(n):null}).sort(t),i=e(i,function(n,t){return n!==i[t-1]?n:null})),i},_generateTicks:function(n){var t=this,u={tickInterval:t._options.majorTick.tickInterval>0?r(t._options.majorTick.tickInterval):i,gridSpacingFactor:t._getGridSpacingFactor().majorTicks,numberMultipliers:[1,2,5]},f={tickInterval:t._options.minorTick.tickInterval>0?r(t._options.minorTick.tickInterval):i,gridSpacingFactor:t._getGridSpacingFactor().minorTicks,numberMultipliers:[1,2,5]};return t._options.majorTick.useTicksAutoArrangement&&(u.useTicksAutoArrangement=!0,u.renderer=t._renderer,u.translator=t._translator,u.getCustomAutoArrangementStep=function(i){return t._getCuttingFactor(i.length,{width:t._textWidth,height:t._textHeight},n)}),v.getFullTicks(t._translator.getDomain()[0],t._translator.getDomain()[1],t._getScreenDelta(n),u,f)},_getTicks:function(n){var t=this,f=t._translator.getDomain()[0]<t._translator.getDomain()[1]?tt:it,s=t._generateTicks(n),o=t._options.majorTick.showCalculatedTicks?s.majorTicks:[],i=t._getCustomValues(t._options.majorTick.customTickValues,f),r,u,c;return i=e(i,function(n){return h(n,o)===-1?n:null}),r=t._options.minorTick.showCalculatedTicks?s.minorTicks:[],r=e(r,function(n){return h(n,i)===-1?n:null}),u=t._getCustomValues(t._options.minorTick.customTickValues,f),c=o.concat(r,i).sort(f),u=e(u,function(n){return h(n,c)===-1?n:null}),{major:e(o.concat(i),function(n){return{value:n,position:t._translator.translate(n)}}),minor:e(r.concat(u),function(n){return{value:n,position:t._translator.translate(n)}})}},_createMajorTicks:function(n,t){var i=this,f,u,e,o;if(i._majorTicks.clear().applySettings({fill:i._options.majorTick.color}),f=i._getTickPoints(r(i._options.majorTick.length),r(i._options.majorTick.width),t),f)for(u=0,e=n.length,i._options.hideFirstTick&&++u,i._options.hideLastTick&&--e;u<e;++u)o=i._renderer.createArea(f),i._moveTick(o,n[u],t),o.append(i._majorTicks)},_createMinorTicks:function(n,t){var i=this,f,u,o,e;if(i._minorTicks.clear().applySettings({fill:i._options.minorTick.color}),f=i._getTickPoints(r(i._options.minorTick.length),r(i._options.minorTick.width),t),f)for(u=0,o=n.length;u<o;++u)e=i._renderer.createArea(f),i._moveTick(e,n[u],t),e.append(i._minorTicks)},_createLabels:function(n,t){var i=this,f=r(i._options.label.indentFromTick),e,u,o,s,h;if(i._labels.clear().applySettings({align:i._getLabelAlign(f),font:i._options.label.font}),e=i._getLabelPosition(i._majorTicksEnabled?r(i._options.majorTick.length):0,f,t),e)for(u=0,o=n.length,i._options.hideFirstLabel&&++u,i._options.hideLastLabel&&--o;u<o;++u)h=i._formatValue(n[u].value),s=i._getLabelOptions(h,e,f,n[u],t),i._renderer.createText(h,s.x,s.y+i._textVerticalOffset).append(i._labels)},resize:function(n){var t=this,i=t._getTicks(n);return t._majorTicksEnabled&&t._createMajorTicks(i.major,n),t._minorTicksEnabled&&t._createMinorTicks(i.minor,n),t._labelsEnabled&&t._createLabels(i.major,n),t}}),n.viz.gauges.__internals.CircularScale=n.viz.gauges.__internals.BaseScale.inherit({_getGridSpacingFactor:function(){return{majorTicks:17,minorTicks:5}},_getScreenDelta:function(n){return(this._translator.getCodomainStart()-this._translator.getCodomainEnd())*n.radius*s},_getCuttingFactor:function(n,t,i){var e=this,ft=e._options,g=e._translator.getCodomainStart(),nt=e._translator.getCodomainEnd(),h=e._getLabelPosition(e._majorTicksEnabled?r(e._options.majorTick.length):0,r(e._options.label.indentFromTick),i),v=rt(a(g),a(nt)),y=l(v),tt=(g-nt)/n,p,k,it,d,o,ut=1;return it=(y.sin*h+t.width)/(y.cos*h),k=u(v-w(it)/s),o=y.cos-t.height/h,d=-1>o||o>1?90:u(v-b(o)/s),p=k<d?k:d,tt<p&&(ut=c(p/tt)),f(1,ut)},_setupOrientation:function(){var n=this;n._inner=n._outer=0;switch(n._options.orientation){case"inside":n._inner=1;break;case"center":n._inner=n._outer=.5;break;default:n._outer=1}},_getTickPoints:function(n,t,i){var f=i.x-t/2,e=i.x+t/2,r=i.y-i.radius-n*this._outer,u=i.y-i.radius+n*this._inner;return r>0&&u>0?[f,r,e,r,e,u,f,u]:null},_moveTick:function(n,t,i){n.rotate(g(t.position),i.x,i.y)},_getLabelPosition:function(n,t,i){var r=i.radius+n*(t>=0?this._outer:-this._inner)+t;return r>0?r:null},_getLabelAlign:function(){return"center"},_getLabelOptions:function(n,t,i,r,u){var f=l(r.position),e=u.x+f.cos*t,o=u.y-f.sin*t,s=f.cos*(n.length/this._textLength)*this._textWidth/2,h=f.sin*this._textHeight/2;return i>0?(e+=s,o-=h):(e-=s,o+=h),{x:e,y:o}},measure:function(n){var t=this,i={min:n.radius,max:n.radius};return t._majorTicksEnabled&&(i.min=o(i.min,n.radius-t._inner*t._options.majorTick.length),i.max=f(i.max,n.radius+t._outer*t._options.majorTick.length)),t._minorTicksEnabled&&(i.min=o(i.min,n.radius-t._inner*t._options.minorTick.length),i.max=f(i.max,n.radius+t._outer*t._options.minorTick.length)),t._labelsEnabled&&(t._options.label.indentFromTick>0?(i.horizontalOffset=r(t._options.label.indentFromTick)+t._textWidth,i.verticalOffset=r(t._options.label.indentFromTick)+t._textHeight):(i.horizontalOffset=i.verticalOffset=0,i.min-=-r(t._options.label.indentFromTick)+f(t._textWidth,t._textHeight)),i.inverseHorizontalOffset=t._textWidth/2,i.inverseVerticalOffset=t._textHeight/2),i}}),n.viz.gauges.__internals.LinearScale=n.viz.gauges.__internals.BaseScale.inherit({_getGridSpacingFactor:function(){return{majorTicks:25,minorTicks:5}},_getScreenDelta:function(){return u(this._translator.getCodomainEnd()-this._translator.getCodomainStart())},_getCuttingFactor:function(n,t){var r=this,e=r.vertical?t.height:t.width,o=u(r._translator.getCodomainEnd()-r._translator.getCodomainStart());return f(1,c(n*e/(o+e)))},_setupOrientation:function(){var n=this;if(n.vertical=n._options.vertical,n._inner=n._outer=0,n.vertical)switch(n._options.horizontalOrientation){case"left":n._inner=1;break;case"center":n._inner=n._outer=.5;break;default:n._outer=1}else switch(n._options.verticalOrientation){case"top":n._inner=1;break;case"middle":n._inner=n._outer=.5;break;default:n._outer=1}},_getTickPoints:function(n,t,i){var r=this,u,f,e,o;return r.vertical?(u=i.x-n*r._inner,f=i.x+n*r._outer,e=-t/2,o=+t/2):(u=-t/2,f=+t/2,e=i.y-n*r._inner,o=i.y+n*r._outer),[u,e,f,e,f,o,u,o]},_moveTick:function(n,t){var r=0,u=0;this.vertical?u=t.position:r=t.position,n.move(r,u)},_getLabelPosition:function(n,t,i){var r=n*(t>=0?this._outer:-this._inner)+t;return r+=this.vertical?i.x:i.y+(t>=0?1:-1)*this._textVerticalOffset},_getLabelAlign:function(n){return this.vertical?n>0?"left":"right":"center"},_getLabelOptions:function(n,t,i,r){var f,e;return this.vertical?(f=t,e=r.position):(f=r.position,e=t),{x:f,y:e}},measure:function(n){var t=this,u=n[t.vertical?"x":"y"],i={min:u,max:u};return t._majorTicksEnabled&&(i.min=o(i.min,u-t._inner*t._options.majorTick.length),i.max=f(i.max,u+t._outer*t._options.majorTick.length)),t._minorTicksEnabled&&(i.min=o(i.min,u-t._inner*t._options.minorTick.length),i.max=f(i.max,u+t._outer*t._options.minorTick.length)),t._labelsEnabled&&(t._options.label.indentFromTick>0?i.max+=+r(t._options.label.indentFromTick)+t[t.vertical?"_textWidth":"_textHeight"]:i.min-=-r(t._options.label.indentFromTick)+t[t.vertical?"_textWidth":"_textHeight"],i.indent=t[t.vertical?"_textHeight":"_textWidth"]/2),i}})}(DevExpress,jQuery),function(n,t,i){var r=isFinite,u=Number,f=t.extend;n.viz.gauges.__internals.BaseIndicator=n.Class.inherit({setup:function(n){var t=this;return t._renderer=n.renderer,t._translator=n.translator,t._owner=n.owner,t._tracker=n.tracker,t._className=n.className,t._options={},t._rootElement=t._createRoot(),t._trackerElement=t._createTracker(),t},dispose:function(){var n=this;return n._renderer=n._owner=n._translator=n._tracker=n._options=n._rootElement=n._trackerElement=null,n},_setupAnimation:function(){var n=this;n._options.animation&&(n._animation={step:function(t){n._actualValue=n._animation.start+n._animation.delta*t,n._actualPosition=n._translator.translate(n._actualValue),n._move()},duration:n._options.animation.duration>0?u(n._options.animation.duration):0,easing:n._options.animation.easing})},_runAnimation:function(n){var i=this,t=i._animation;t.start=i._actualValue,t.delta=n-i._actualValue,i._rootElement.animate({_:0},{step:t.step,duration:t.duration,easing:t.easing})},_createRoot:function(){return this._renderer.createGroup({"class":this._className})},_createTracker:function(){return this._renderer.createArea()},_getTrackerSettings:function(){},clean:function(){var n=this;return n._animation&&n._rootElement.stopAnimation(),n._rootElement.detach(),n._rootElement.clear(),n._clear(),n._tracker.detach(n._trackerElement),n._options=n.enabled=n._animation=null,n},render:function(n){var t=this;return t.type=n.type,t._options=n,t._actualValue=t._currentValue=t._translator.adjust(t._options.currentValue),t.enabled=t._isEnabled(),t.enabled&&(t._setupAnimation(),t._rootElement.applySettings({fill:t._options.color}).append(t._owner),t._tracker.attach(t._trackerElement,t,t._trackerInfo)),t},resize:function(n){var t=this;return t._rootElement.clear(),t._clear(),t.visible=t._isVisible(n),t.visible&&(f(t._options,n),t._actualPosition=t._translator.translate(t._actualValue),t._render(),t._trackerElement.applySettings(t._getTrackerSettings()),t._move()),t},value:function(n,t){var u=this,f;return n!==i?(f=u._translator.adjust(n),u._currentValue!==f&&r(f)&&(u._currentValue=f,u.visible&&(u._animation&&!t?u._runAnimation(f):(u._actualValue=f,u._actualPosition=u._translator.translate(f),u._move()))),u):u._currentValue},_isEnabled:null,_isVisible:null,_render:null,_clear:null,_move:null})}(DevExpress,jQuery),function(n){var i=n.viz.core.TextCloud,r=n.viz.gauges.__internals.formatValue,u=n.viz.gauges.__internals.getSampleText;n.viz.gauges.__internals.BaseTextCloudMarker=n.viz.gauges.__internals.BaseIndicator.inherit({_move:function(){var n=this,u,t=new i,f=n._getTextCloudOptions();n._text.applySettings({text:r(n._actualValue,n._options.text)}),u=n._text.getBBox(),t.setup({x:f.x,y:f.y,textWidth:u.width,textHeight:u.height,horMargin:n._options.horizontalOffset,verMargin:n._options.verticalOffset,tailLength:n._options.arrowLength,type:f.type}),n._text.applySettings({x:t.cx(),y:t.cy()+n._textVerticalOffset}),n._cloud.applySettings({points:t.points()}),n._trackerElement&&n._trackerElement.applySettings({points:t.points()})},_measureText:function(){var n=this,i,r,t;n._textVerticalOffset||(i=n._createRoot().append(n._owner),r=n._renderer.createText(u(n._translator,n._options.text),0,0,{align:"center",font:n._options.text.font}).append(i),t=r.getBBox(),i.remove(),n._textVerticalOffset=-t.y-t.height/2,n._textWidth=t.width,n._textHeight=t.height,n._textFullWidth=n._textWidth+2*n._options.horizontalOffset,n._textFullHeight=n._textHeight+2*n._options.verticalOffset)},_render:function(){var n=this;n._measureText(),n._cloud=n._cloud||n._renderer.createArea().append(n._rootElement),n._text=n._text||n._renderer.createText().append(n._rootElement),n._text.applySettings({align:"center",font:n._options.text.font})},_clear:function(){delete this._cloud,delete this._text},getTooltipParameters:function(){var n=this._getTextCloudOptions();return{x:n.x,y:n.y,value:this._currentValue,color:this._options.color}}})}(DevExpress),function(n,t){var r=t.extend,u=n.viz.gauges.__internals.formatValue,f=n.viz.gauges.__internals.getSampleText;n.viz.gauges.__internals.BaseRangeBar=n.viz.gauges.__internals.BaseIndicator.inherit({_measureText:function(){var n=this,i,r,t;n._hasText=n._isTextVisible(),n._hasText&&!n._textVerticalOffset&&(i=n._createRoot().append(n._owner),r=n._renderer.createText(f(n._translator,n._options.text),0,0,{"class":"dxg-text",align:"center",font:n._options.text.font}).append(i),t=r.getBBox(),i.remove(),n._textVerticalOffset=-t.y-t.height/2,n._textWidth=t.width,n._textHeight=t.height)},_move:function(){var n=this;n._updateBarItemsPositions(),n._hasText&&(n._text.applySettings({text:u(n._actualValue,n._options.text)}),n._updateTextPosition(),n._updateLinePosition())},_updateBarItems:function(){var n=this,r=n._options,t,i;n._setBarSides(),n._startPosition=n._translator.translate(n._translator.getDomainStart()),n._endPosition=n._translator.translate(n._translator.getDomainEnd()),n._basePosition=n._translator.translate(r.baseValue),n._space=n._getSpace(),t=r.backgroundColor||"none",t!=="none"&&n._space>0?i=r.containerBackgroundColor||"none":(n._space=0,i="none"),n._backItem1.applySettings({fill:t}),n._backItem2.applySettings({fill:t}),n._spaceItem1.applySettings({fill:i}),n._spaceItem2.applySettings({fill:i})},_getSpace:function(){return 0},_updateTextItems:function(){var n=this;n._hasText?(n._line=n._line||n._renderer.createPath([],{"class":"dxg-main-bar"}).append(n._rootElement),n._text=n._text||n._renderer.createText("",0,0,{"class":"dxg-text"}).append(n._rootElement),n._text.applySettings({align:n._getTextAlign(),font:n._getFontOptions()}),n._setTextItemsSides()):(n._line&&(n._line.remove(),delete n._line),n._text&&(n._text.remove(),delete n._text))},_isTextVisible:function(){return!1},_getTextAlign:function(){return"center"},_getFontOptions:function(){var t=this._options,n=t.text.font;return n&&n.color||(n=r({},n,{color:t.color})),n},_updateBarItemsPositions:function(){var n=this,t=n._getPositions();n._backItem1.applySettings(n._buildItemSettings(t.start,t.back1)),n._backItem2.applySettings(n._buildItemSettings(t.back2,t.end)),n._spaceItem1.applySettings(n._buildItemSettings(t.back1,t.main1)),n._spaceItem2.applySettings(n._buildItemSettings(t.main2,t.back2)),n._mainItem.applySettings(n._buildItemSettings(t.main1,t.main2)),n._trackerElement&&n._trackerElement.applySettings(n._buildItemSettings(t.main1,t.main2))},_render:function(){var n=this;n._measureText(),n._backItem1||(n._backItem1=n._createBarItem(),n._backItem1.applySettings({"class":"dxg-back-bar"})),n._backItem2||(n._backItem2=n._createBarItem(),n._backItem2.applySettings({"class":"dxg-back-bar"})),n._spaceItem1||(n._spaceItem1=n._createBarItem(),n._spaceItem1.applySettings({"class":"dxg-space-bar"})),n._spaceItem2||(n._spaceItem2=n._createBarItem(),n._spaceItem2.applySettings({"class":"dxg-space-bar"})),n._mainItem||(n._mainItem=n._createBarItem(),n._mainItem.applySettings({"class":"dxg-main-bar"})),n._updateBarItems(),n._updateTextItems()},_clear:function(){var n=this;delete n._backItem1,delete n._backItem2,delete n._spaceItem1,delete n._spaceItem2,delete n._mainItem,delete n._hasText,delete n._line,delete n._text},getTooltipParameters:function(){var n=this._getTooltipPosition();return{x:n.x,y:n.y,value:this._currentValue,color:this._options.color,offset:0}}})}(DevExpress,jQuery),function(n){var r=n.viz.gauges.__internals.circularNeedles,i=Number;r.SimpleIndicator=n.viz.gauges.__internals.BaseIndicator.inherit({_move:function(){var t=this,i=t._options,r=n.utils.convertAngleToRendererSpace(t._actualPosition);t._rootElement.rotate(r,i.x,i.y),t._trackerElement&&t._trackerElement.rotate(r,i.x,i.y)},_isEnabled:function(){return this._options.width>0},_isVisible:function(n){return n.radius-i(this._options.indentFromCenter)>0},_getTrackerSettings:function(){var n=this._options,u=n.x,f=n.y-(n.radius+i(n.indentFromCenter))/2,t=n.width/2,r=(n.radius-i(n.indentFromCenter))/2;return t>10||(t=10),r>10||(r=10),{points:[u-t,f-r,u-t,f+r,u+t,f+r,u+t,f-r]}},_renderSpindle:function(){var n=this,t=n._options,r;t.spindleSize>0&&(r=i(t.spindleGapSize)||0,r>0&&(r=r<=t.spindleSize?r:i(t.spindleSize)),n._spindleOuter=n._spindleOuter||n._renderer.createCircle().append(n._rootElement),n._spindleInner=n._spindleInner||n._renderer.createCircle().append(n._rootElement),n._spindleOuter.applySettings({"class":"dxg-spindle-border",cx:t.x,cy:t.y,r:t.spindleSize/2}),n._spindleInner.applySettings({"class":"dxg-spindle-hole",cx:t.x,cy:t.y,r:r/2,fill:t.containerBackgroundColor}))},_render:function(){var n=this;n._renderPointer(),n._renderSpindle()},_clearSpindle:function(){delete this._spindleOuter,delete this._spindleInner},_clearPointer:function(){delete this._element},_clear:function(){this._clearPointer(),this._clearSpindle()},measure:function(n){var t={max:n.radius};return this._options.indentFromCenter<0&&(t.inverseHorizontalOffset=t.inverseVerticalOffset=-i(this._options.indentFromCenter)),t},getTooltipParameters:function(){var t=this._options,r=n.utils.getCosAndSin(this._actualPosition),u=(t.radius+i(t.indentFromCenter))/2;return{x:t.x+r.cos*u,y:t.y-r.sin*u,value:this._currentValue,color:t.color,offset:t.width/2}}}),r.RectangleNeedle=r.SimpleIndicator.inherit({_renderPointer:function(){var t=this,n=t._options,u=n.y-n.radius,f=n.y-i(n.indentFromCenter),r=n.x-n.width/2,e=r+i(n.width);t._element=t._element||t._renderer.createArea().append(t._rootElement),t._element.applySettings({points:[r,f,r,u,e,u,e,f]})}}),r.TriangleNeedle=r.SimpleIndicator.inherit({_renderPointer:function(){var t=this,n=t._options,u=n.y-n.radius,r=n.y-i(n.indentFromCenter),f=n.x-n.width/2,e=n.x+n.width/2;t._element=t._element||t._renderer.createArea().append(t._rootElement),t._element.applySettings({points:[f,r,n.x,u,e,r]})}}),r.TwoColorRectangleNeedle=r.SimpleIndicator.inherit({_renderPointer:function(){var n=this,t=n._options,f=t.x-t.width/2,e=t.x+t.width/2,o=t.y-t.radius,s=t.y-i(t.indentFromCenter),h=i(t.secondFraction)||0,r,u;h>=1?r=u=s:h<=0?r=u=r:(u=o+(s-o)*h,r=u+t.space),n._firstElement=n._firstElement||n._renderer.createArea().append(n._rootElement),n._spaceElement=n._spaceElement||n._renderer.createArea().append(n._rootElement),n._secondElement=n._secondElement||n._renderer.createArea().append(n._rootElement),n._firstElement.applySettings({points:[f,s,f,r,e,r,e,s]}),n._spaceElement.applySettings({points:[f,r,f,u,e,u,e,r],"class":"dxg-hole",fill:t.containerBackgroundColor}),n._secondElement.applySettings({points:[f,u,f,o,e,o,e,u],"class":"dxg-part",fill:t.secondColor})},_clearPointer:function(){delete this._firstElement,delete this._secondElement,delete this._spaceElement}})}(DevExpress),function(n){var i=n.viz.gauges.__internals.linearNeedles,r=Number;i.SimpleIndicator=n.viz.gauges.__internals.BaseIndicator.inherit({_move:function(){var n=this,t=n._actualPosition-n._zeroPosition;n._rootElement.move(n.vertical?0:t,n.vertical?t:0),n._trackerElement&&n._trackerElement.move(n.vertical?0:t,n.vertical?t:0)},_isEnabled:function(){return this.vertical=this._options.vertical,this._options.length>0&&this._options.width>0},_isVisible:function(){return!0},_getTrackerSettings:function(){var n=this._options,r,u,f,e,t=n.width/2,i=n.length/2,o=this._zeroPosition;return t>10||(t=10),i>10||(i=10),this.vertical?(r=n.x-i,u=n.x+i,f=o+t,e=o-t):(r=o-t,u=o+t,f=n.y+i,e=n.y-i),{points:[r,f,r,e,u,e,u,f]}},_render:function(){var n=this;n._zeroPosition=n._translator.getCodomainStart()},_clear:function(){delete this._element},measure:function(n){var t=this.vertical?n.x:n.y;return{min:t-this._options.length/2,max:t+this._options.length/2}},getTooltipParameters:function(){var n=this,t=n._options,r=n._actualPosition,i={x:r,y:r,value:n._currentValue,color:t.color,offset:t.width/2};return n.vertical?i.x=t.x:i.y=t.y,i}}),i.RectangleNeedle=i.SimpleIndicator.inherit({_render:function(){var t=this,n=t._options,i,r,u,f,e;t.callBase(),i=t._zeroPosition,t.vertical?(r=n.x-n.length/2,u=n.x+n.length/2,f=i+n.width/2,e=i-n.width/2):(r=i-n.width/2,u=i+n.width/2,f=n.y+n.length/2,e=n.y-n.length/2),t._element=t._element||t._renderer.createArea().append(t._rootElement),t._element.applySettings({points:[r,f,r,e,u,e,u,f]})}}),i.RhombusNeedle=i.SimpleIndicator.inherit({_render:function(){var n=this,t=n._options,i,r,u,f;n.callBase(),n.vertical?(i=t.x,r=n._zeroPosition,u=t.length/2||0,f=t.width/2||0):(i=n._zeroPosition,r=t.y,u=t.width/2||0,f=t.length/2||0),n._element=n._element||n._renderer.createArea().append(n._rootElement),n._element.applySettings({points:[i-u,r,i,r-f,i+u,r,i,r+f]})}}),i.CircleNeedle=i.SimpleIndicator.inherit({_render:function(){var n=this,t=n._options,i,r,u;n.callBase(),n.vertical?(i=t.x,r=n._zeroPosition):(i=n._zeroPosition,r=t.y),u=t.length/2||0,n._element=n._element||n._renderer.createCircle().append(n._rootElement),n._element.applySettings({cx:i,cy:r,r:u})}})}(DevExpress),function(n){var r=n.viz.gauges.__internals.circularMarkers,i=Number;r.TriangleMarker=n.viz.gauges.__internals.circularNeedles.SimpleIndicator.inherit({_isEnabled:function(){return this._options.length>0&&this._options.width>0},_isVisible:function(n){return n.radius>0},_render:function(){var t=this,n=t._options,u=n.x,f=n.y-n.radius,e=n.width/2||0,o=f-i(n.length),r;t._element=t._element||t._renderer.createArea().append(t._rootElement),r={points:[u,f,u-e,o,u+e,o],stroke:"none",strokeWidth:0},n.space>0&&(r.strokeWidth=Math.min(n.space,n.width/4)||0,r.stroke=r.strokeWidth>0?n.containerBackgroundColor||"none":"none"),t._element.applySettings(r)},_clear:function(){delete this._element},_getTrackerSettings:function(){var n=this._options,r=n.x,u=n.y-n.radius-n.length/2,t=n.width/2,i=n.length/2;return t>10||(t=10),i>10||(i=10),{points:[r-t,u-i,r-t,u+i,r+t,u+i,r+t,u-i]}},measure:function(n){return{min:n.radius,max:n.radius+i(this._options.length)}},getTooltipParameters:function(){var t=this._options,r=n.utils.getCosAndSin(this._actualPosition),u=t.radius+t.length/2,i=this.callBase();return i.x=t.x+r.cos*u,i.y=t.y-r.sin*u,i.offset=t.length/2,i}}),r.TextCloudMarker=n.viz.gauges.__internals.BaseTextCloudMarker.inherit({_isEnabled:function(){return!0},_isVisible:function(n){return n.radius>0},_getTextCloudOptions:function(){var t=this,r=n.utils.getCosAndSin(t._actualPosition),i=n.utils.normalizeAngle(t._actualPosition);return{x:t._options.x+r.cos*t._options.radius,y:t._options.y-r.sin*t._options.radius,type:i>270?"left-top":i>180?"top-right":i>90?"right-bottom":"bottom-left"}},measure:function(n){var t=this;return t._measureText(),{min:n.radius,max:n.radius,horizontalOffset:t._textFullWidth+(i(t._options.arrowLength)||0),verticalOffset:t._textFullHeight+(i(t._options.arrowLength)||0)}}})}(DevExpress),function(n){var u=n.viz.gauges.__internals.linearMarkers,i=Number,r=String;u.TriangleMarker=n.viz.gauges.__internals.linearNeedles.SimpleIndicator.inherit({_isEnabled:function(){var n=this;return n.vertical=n._options.vertical,n._inverted=n.vertical?r(n._options.horizontalOrientation).toLowerCase()==="right":r(n._options.verticalOrientation).toLowerCase()==="bottom",n._options.length>0&&n._options.width>0},_isVisible:function(){return!0},_render:function(){var t=this,n=t._options,r,e,u,o,f={stroke:"none",strokeWidth:0};t.callBase(),t.vertical?(r=n.x,u=t._zeroPosition,e=r+i(t._inverted?n.length:-n.length),f.points=[r,u,e,u-n.width/2,e,u+n.width/2]):(u=n.y,r=t._zeroPosition,o=u+i(t._inverted?n.length:-n.length),f.points=[r,u,r-n.width/2,o,r+n.width/2,o]),n.space>0&&(f.strokeWidth=Math.min(n.space,n.width/4)||0,f.stroke=f.strokeWidth>0?n.containerBackgroundColor||"none":"none"),t._element=t._element||t._renderer.createArea().append(t._rootElement),t._element.applySettings(f)},_getTrackerSettings:function(){var n=this,s=n._options,f=s.width/2,e=i(s.length),t,r,u,o,h;return f>10||(f=10),e>20||(e=20),n.vertical?(t=r=s.x,r=t+(n._inverted?e:-e),u=n._zeroPosition+f,o=n._zeroPosition-f,h=[t,u,r,u,r,o,t,o]):(u=s.y,o=u+(n._inverted?e:-e),t=n._zeroPosition-f,r=n._zeroPosition+f,h=[t,u,t,o,r,o,r,u]),{points:h}},measure:function(n){var u=this,f=i(u._options.length),t,r;return u.vertical?(t=r=n.x,u._inverted?r=t+f:t=r-f):(t=r=n.y,u._inverted?r=t+f:t=r-f),{min:t,max:r,indent:u._options.width/2}},getTooltipParameters:function(){var n=this,i=n._options,r=(n._inverted?i.length:-i.length)/2,t=n.callBase();return n.vertical?t.x+=r:t.y+=r,t.offset=i.length/2,t}}),u.TextCloudMarker=n.viz.gauges.__internals.BaseTextCloudMarker.inherit({_isEnabled:function(){var n=this;return n.vertical=n._options.vertical,n._inverted=n.vertical?r(n._options.horizontalOrientation).toLowerCase()==="right":r(n._options.verticalOrientation).toLowerCase()==="bottom",!0},_isVisible:function(){return!0},_getTextCloudOptions:function(){var n=this,i=n._actualPosition,r=n._actualPosition,t;return n.vertical?(i=n._options.x,t=n._inverted?"top-left":"top-right"):(r=n._options.y,t=n._inverted?"right-top":"right-bottom"),{x:i,y:r,type:t}},measure:function(n){var t=this,r,u,f=i(t._options.arrowLength)||0,e;return t._measureText(),t.vertical?(e=t._textFullHeight,t._inverted?(r=n.x,u=n.x+f+t._textFullWidth):(r=n.x-f-t._textFullWidth,u=n.x)):(e=t._textFullWidth,t._inverted?(r=n.y,u=n.y+f+t._textFullHeight):(r=n.y-f-t._textFullHeight,u=n.y)),{min:r,max:u,indent:e}}})}(DevExpress),function(n){var i=Number,r=n.utils.getCosAndSin,u=n.utils.convertAngleToRendererSpace,f=Math.max,e=Math.min;n.viz.gauges.__internals.CircularRangeBar=n.viz.gauges.__internals.BaseRangeBar.inherit({_isEnabled:function(){return this._options.size>0},_isVisible:function(n){return n.radius-i(this._options.size)>0},_createBarItem:function(){return this._renderer.createArc().append(this._rootElement)},_createTracker:function(){return this._renderer.createArc()},_setBarSides:function(){var n=this;n._maxSide=n._options.radius,n._minSide=n._maxSide-i(n._options.size)},_getSpace:function(){var n=this._options;return n.space>0?n.space*180/n.radius/Math.PI:0},_isTextVisible:function(){var n=this._options.text||{};return n.indent>0},_setTextItemsSides:function(){var n=this,t=n._options;n._lineFrom=t.y-t.radius,n._lineTo=n._lineFrom-i(t.text.indent),n._textRadius=t.radius+i(t.text.indent)},_getPositions:function(){var n=this,r=n._basePosition,u=n._actualPosition,t,i;return r>=u?(t=r,i=u):(t=u,i=r),{start:n._startPosition,end:n._endPosition,main1:t,main2:i,back1:e(t+n._space,n._startPosition),back2:f(i-n._space,n._endPosition)}},_buildItemSettings:function(n,t){var i=this;return{x:i._options.x,y:i._options.y,innerRadius:i._minSide,outerRadius:i._maxSide,startAngle:t,endAngle:n}},_updateTextPosition:function(){var n=this,t=r(n._actualPosition),i=n._options.x+n._textRadius*t.cos,u=n._options.y-n._textRadius*t.sin;i+=t.cos*n._textWidth*.6,u-=t.sin*n._textHeight*.6,n._text.applySettings({x:i,y:u+n._textVerticalOffset})},_updateLinePosition:function(){var n=this,t=n._options.x,i,r;n._basePosition>n._actualPosition?(i=t-2,r=t):n._basePosition<n._actualPosition?(i=t,r=t+2):(i=t-1,r=t+1),n._line.applySettings({points:[i,n._lineFrom,i,n._lineTo,r,n._lineTo,r,n._lineFrom]}),n._line.rotate(u(n._actualPosition),t,n._options.y)},_getTooltipPosition:function(){var n=this,t=r((n._basePosition+n._actualPosition)/2),i=(n._minSide+n._maxSide)/2;return{x:n._options.x+t.cos*i,y:n._options.y-t.sin*i}},measure:function(n){var t=this,r={min:n.radius-i(t._options.size),max:n.radius};return t._measureText(),t._hasText&&(r.max+=i(t._options.text.indent),r.horizontalOffset=t._textWidth,r.verticalOffset=t._textHeight),r}})}(DevExpress),function(n){var i=Number,r=String;n.viz.gauges.__internals.LinearRangeBar=n.viz.gauges.__internals.BaseRangeBar.inherit({_isEnabled:function(){var n=this;return n.vertical=n._options.vertical,n._inverted=n.vertical?r(n._options.horizontalOrientation).toLowerCase()==="right":r(n._options.verticalOrientation).toLowerCase()==="bottom",n._options.size>0},_isVisible:function(){return!0},_createBarItem:function(){return this._renderer.createArea().append(this._rootElement)},_createTracker:function(){return this._renderer.createArea()},_setBarSides:function(){var t=this,n=t._options,f=i(n.size),r,u;t.vertical?t._inverted?(r=n.x,u=n.x+f):(r=n.x-f,u=n.x):t._inverted?(r=n.y,u=n.y+f):(r=n.y-f,u=n.y),t._minSide=r,t._maxSide=u,t._minBound=r,t._maxBound=u},_getSpace:function(){var n=this._options;return n.space>0?i(n.space):0},_isTextVisible:function(){var n=this._options.text||{};return n.indent>0||n.indent<0},_getTextAlign:function(){return this.vertical?this._options.text.indent>0?"left":"right":"center"},_setTextItemsSides:function(){var n=this,t=i(n._options.text.indent);t>0?(n._lineStart=n._maxSide,n._lineEnd=n._maxSide+t,n._textPosition=n._lineEnd+(n.vertical?2:n._textHeight/2),n._maxBound=n._textPosition+(n.vertical?n._textWidth:n._textHeight/2)):t<0&&(n._lineStart=n._minSide,n._lineEnd=n._minSide+t,n._textPosition=n._lineEnd-(n.vertical?2:n._textHeight/2),n._minBound=n._textPosition-(n.vertical?n._textWidth:n._textHeight/2))},_getPositions:function(){var i=this,c=i._options,s=i._startPosition,h=i._endPosition,f=i._space,r=i._basePosition,u=i._actualPosition,n,t,e,o;return s<h?(r<u?(n=r,t=u):(n=u,t=r),e=n-f,o=t+f):(r>u?(n=r,t=u):(n=u,t=r),e=n+f,o=t-f),{start:s,end:h,main1:n,main2:t,back1:e,back2:o}},_buildItemSettings:function(n,t){var u=this,i=u._minSide,r=u._maxSide,f=u.vertical?[i,n,i,t,r,t,r,n]:[n,i,n,r,t,r,t,i];return{points:f}},_updateTextPosition:function(){var n=this;n._text.applySettings(n.vertical?{x:n._textPosition,y:n._actualPosition+n._textVerticalOffset}:{x:n._actualPosition,y:n._textPosition+n._textVerticalOffset})},_updateLinePosition:function(){var n=this,t=n._actualPosition,i,r,u;n.vertical?(n._basePosition>=t?(i=t,r=t+2):(i=t-2,r=t),u=[n._lineStart,i,n._lineStart,r,n._lineEnd,r,n._lineEnd,i]):(n._basePosition<=t?(i=t-2,r=t):(i=t,r=t+2),u=[i,n._lineStart,i,n._lineEnd,r,n._lineEnd,r,n._lineStart]),n._line.applySettings({points:u})},_getTooltipPosition:function(){var n=this,i=(n._minSide+n._maxSide)/2,r=(n._basePosition+n._actualPosition)/2,t={};return t=n.vertical?{x:i,y:r}:{x:r,y:i}},measure:function(n){var t=this,e=i(t._options.size),f=i(t._options.text.indent),r,u,o;return t._measureText(),t.vertical?(r=u=n.x,t._inverted?u=u+e:r=r-e,t._hasText&&(o=t._textHeight/2,f>0&&(u+=f+t._textWidth),f<0&&(r+=f-t._textWidth))):(r=u=n.y,t._inverted?u=u+e:r=r-e,t._hasText&&(o=t._textWidth/2,f>0&&(u+=f+t._textHeight),f<0&&(r+=f-t._textHeight))),{min:r,max:u,indent:o}}})}(DevExpress),function(n,t,i){function v(n,t,i,r){var u;return i>n&&r<t?u=[{start:n,end:i},{start:r,end:t}]:i>=t||r<=n?u=[{start:n,end:t}]:i<=n&&r>=t?u=[]:i>n?u=[{start:n,end:i}]:r<t&&(u=[{start:r,end:t}]),u}function y(n,t,i,r){var u;return i<n&&r>t?u=[{start:n,end:i},{start:r,end:t}]:i<=t||r>=n?u=[{start:n,end:t}]:i>=n&&r<=t?u=[]:i<n?u=[{start:n,end:i}]:r>t&&(u=[{start:r,end:t}]),u}function p(n,t,i){return t-n>=i}function w(n,t,i){return n-t>=i}var r=Number,f=String,e=Math.max,c=Math.abs,o=n.utils.isString,s=n.utils.isArray,h=isFinite,u=t.each,l=t.map,a=n.viz.core.Palette;n.viz.gauges.__internals.BaseRangeContainer=n.Class.inherit({ctor:function(n){var t=this;t._renderer=n.renderer,t._container=n.container,t._translator=n.translator,t._root=t._renderer.createGroup({"class":"dxg-range-container"})},dispose:function(){var n=this;n._renderer=n._container=n._translator=n._root=null},clean:function(){return this._root.detach().clear(),this._options=this.enabled=null,this},_getRanges:function(){var it=this,n=it._options,k=it._translator,d=k.getDomain()[0],rt=k.getDomain()[1],e=rt-d,et=e>=0?p:w,ut=e>=0?v:y,nt=[],t=[],g=[{start:d,end:rt}],ot=c(e)/1e4,st=new a(n.palette,{type:"indicatingSet",theme:n.themeName}),ht=o(n.backgroundColor)?n.backgroundColor:"none",f=n.width||{},b=r(f>0?f:f.start),tt=r(f>0?f:f.end),ft=tt-b;return n.ranges!==i&&!s(n.ranges)?null:b>=0&&tt>=0&&b+tt>0?(nt=l(s(n.ranges)?n.ranges:[],function(n,t){n=n||{};var i=k.adjust(n.startValue),r=k.adjust(n.endValue);return h(i)&&h(r)&&et(i,r,ot)?{start:i,end:r,color:n.color,classIndex:t}:null}),u(nt,function(n,t){var i=st.getNextColor();t.color=o(t.color)&&t.color||i||"none",t.className="dxg-range dxg-range-"+t.classIndex,delete t.classIndex}),u(nt,function(n,i){for(var r,e,u,o=[],h=[],f=0,s=t.length;f<s;++f)u=t[f],e=ut(u.start,u.end,i.start,i.end),(r=e[0])&&(r.color=u.color)&&(r.className=u.className)&&o.push(r),(r=e[1])&&(r.color=u.color)&&(r.className=u.className)&&o.push(r);for(o.push(i),t=o,f=0,s=g.length;f<s;++f)u=g[f],e=ut(u.start,u.end,i.start,i.end),(r=e[0])&&h.push(r),(r=e[1])&&h.push(r);g=h}),u(g,function(n,i){i.color=ht,i.className="dxg-range dxg-background-range",t.push(i)}),u(t,function(n,t){t.startWidth=(t.start-d)/e*ft+b,t.endWidth=(t.end-d)/e*ft+b}),t):null},render:function(n){var t=this;return t._options=n,t._processOptions(),t._ranges=t._getRanges(),t._ranges&&(t.enabled=!0,t._root.append(t._container)),t},resize:function(n){var t=this;return t._root.clear(),t._isVisible(n)&&u(t._ranges,function(i,r){t._createRange(r,n).applySettings({fill:r.color,"class":r.className}).append(t._root)}),t},_processOptions:null,_isVisible:null,_createRange:null}),n.viz.gauges.__internals.CircularRangeContainer=n.viz.gauges.__internals.BaseRangeContainer.inherit({_processOptions:function(){var n=this;n._inner=n._outer=0;switch(f(n._options.orientation).toLowerCase()){case"inside":n._inner=1;break;case"center":n._inner=n._outer=.5;break;default:n._outer=1}},_isVisible:function(n){var t=this._options.width;return t=r(t)||e(r(t.start),r(t.end)),n.radius-this._inner*t>0},_createRange:function(n,t){var i=this,r=(n.startWidth+n.endWidth)/2;return i._renderer.createArc(t.x,t.y,t.radius+i._outer*r,t.radius-i._inner*r,i._translator.translate(n.end),i._translator.translate(n.start))},measure:function(n){var t=this._options.width;return t=r(t)||e(r(t.start),r(t.end)),{min:n.radius-this._inner*t,max:n.radius+this._outer*t}}}),n.viz.gauges.__internals.LinearRangeContainer=n.viz.gauges.__internals.BaseRangeContainer.inherit({_processOptions:function(){var n=this;if(n.vertical=n._options.vertical,n._inner=n._outer=0,n.vertical)switch(f(n._options.horizontalOrientation).toLowerCase()){case"left":n._inner=1;break;case"center":n._inner=n._outer=.5;break;default:n._outer=1}else switch(f(n._options.verticalOrientation).toLowerCase()){case"top":n._inner=1;break;case"middle":n._inner=n._outer=.5;break;default:n._outer=1}},_isVisible:function(){return!0},_createRange:function(n,t){var i=this,r=i._inner,u=i._outer,f=i._translator.translate(n.start),e=i._translator.translate(n.end),o;return o=i.vertical?[t.x-n.startWidth*r,f,t.x-n.endWidth*r,e,t.x+n.endWidth*u,e,t.x+n.startWidth*u,f]:[f,t.y+n.startWidth*u,f,t.y-n.startWidth*r,e,t.y-n.endWidth*r,e,t.y+n.endWidth*u],i._renderer.createArea(o)},measure:function(n){var i={},t;return i.min=i.max=n[this.vertical?"x":"y"],t=this._options.width,t=r(t)||e(r(t.start),r(t.end)),i.min-=this._inner*t,i.max+=this._outer*t,i}})}(DevExpress,jQuery),function(n,t){var r=n.utils.isString,u=Math.max,f=t.extend;n.viz.gauges.__internals.Title=n.Class.inherit({ctor:function(n){this._renderer=n.renderer,this._container=n.container},dispose:function(){return this._renderer=this._container=null,this},clean:function(){var n=this;return n._root&&(n._root.detach().clear(),n._root=n._layout=null),n},render:function(n,t){var i=this,l=r(n.text)&&n.text.length>0,a=r(t.text)&&t.text.length>0;if(!l&&!a)return i;i._root=i._renderer.createGroup({"class":"dxg-title"}).append(i._container);var e=l?i._renderer.createText(n.text,0,0,{align:"center",font:n.font}).append(i._root):null,o=a?i._renderer.createText(t.text,0,0,{align:"center",font:t.font}).append(i._root):null,s=e?e.getBBox():{},h=o?o.getBBox():{},c=0;return e&&(c+=-s.y,e.applySettings({x:0,y:c})),o&&(c+=-h.y,o.applySettings({x:0,y:c})),i._layout=f({width:u(s.width||0,h.width||0),height:e&&o?-s.y+h.height:s.height||h.height},n.layout),i},getLayoutOptions:function(){return this._layout},locate:function(n,t){return this._root.applySettings({translateX:n+this._layout.width/2,translateY:t}),this}})}(DevExpress,jQuery),function(n,t){var r=t.extend;n.viz.gauges.__internals.Tooltip=n.viz.core.Tooltip.inherit({ctor:function(n){var t=this;t._container=n.container,t._tracker=n.tracker,t._root=n.renderer.createGroup({"class":"dxg-tooltip"}),t.callBase(null,t._root,n.renderer),t._setTrackerCallbacks()},dispose:function(){var n=this;return n._container=n._tracker=n._root=null,n._shadow?n.callBase.apply(n,arguments):n},_setTrackerCallbacks:function(){function t(t,i){var u=t.getTooltipParameters(),f=r({value:u.value,valueText:n.formatValue(u.value),color:u.color},i);return n.prepare(f,{x:u.x,y:u.y,offset:u.offset})}function i(){return n.show()}function u(){return n.hide()}var n=this;n._tracker.setCallbacks({"tooltip-prepare":t,"tooltip-show":i,"tooltip-hide":u})},clean:function(){return this._root.detach(),this},render:function(n,t){var i=this;return n.canvasWidth=t.width,n.canvasHeight=t.height,n.text={"class":"dxg-text"},i.update(n),i._tracker.setTooltipState(i.enabled()),i.enabled()&&i._root.append(i._container),i}})}(DevExpress,jQuery),function(n,t){function o(n){if(n.position){var t=r(n.position).toLowerCase().split("-");n.verticalAlignment=t[0],n.horizontalAlignment=t[1]}}var f=Number,r=String,s=Math.min,u=Math.max,e=t.each;n.viz.gauges.__internals.LayoutManager=n.Class.inherit({setRect:function(n){return this._currentRect=n.clone(),this},getRect:function(){return this._currentRect.clone()},beginLayout:function(n){return this._rootRect=n.clone(),this._currentRect=n.clone(),this._cache=[],this},applyLayout:function(n){var t=n.getLayoutOptions(),i,e;if(!t)return this;i=this._currentRect,e=f(t.overlay)||0,o(t);switch(r(t.verticalAlignment).toLowerCase()){case"bottom":i.bottom-=u(t.height-e,0);break;default:i.top+=u(t.height-e,0)}return this._cache.push({target:n,options:t}),this},endLayout:function(){var n=this,i=n._rootRect,t=n._currentRect;return e(n._cache,function(n,e){var o=e.options,s,c,h=f(o.overlay)||0;switch(r(o.verticalAlignment).toLowerCase()){case"bottom":c=t.bottom-h,t.bottom+=u(o.height-h,0);break;default:c=t.top-o.height+h,t.top-=u(o.height-h,0)}switch(r(o.horizontalAlignment).toLowerCase()){case"left":s=i.left;break;case"right":s=i.right-o.width;break;default:s=i.horizontalMiddle()-o.width/2}e.target.locate(s,c)}),n._cache=null,n},selectRectByAspectRatio:function(n,t){var i=this._currentRect.clone(),f,r=0,u=0;return t=t||{},n>0&&(i.left+=t.left||0,i.right-=t.right||0,i.top+=t.top||0,i.bottom-=t.bottom||0,i.width()>0&&i.height()>0?(f=i.height()/i.width(),f>1?n<f?r=i.width():u=i.height():n>f?u=i.height():r=i.width(),r>0||(r=u/n),u>0||(u=r*n),r=(i.width()-r)/2,u=(i.height()-u)/2,i.left+=r,i.right-=r,i.top+=u,i.bottom-=u):(i.left=i.right=i.horizontalMiddle(),i.top=i.bottom=i.verticalMiddle())),i},selectRectBySizes:function(n,t){var i=this._currentRect.clone(),r;return t=t||{},n&&(i.left+=t.left||0,i.right-=t.right||0,i.top+=t.top||0,i.bottom-=t.bottom||0,n.width>0&&(r=(i.width()-n.width)/2,r>0&&(i.left+=r,i.right-=r)),n.height>0&&(r=(i.height()-n.height)/2,r>0&&(i.top+=r,i.bottom-=r))),i}})}(DevExpress,jQuery),function(n,t){var r=t.extend;n.viz.gauges.__internals.ThemeManager=n.viz.core.BaseThemeManager.inherit({_themeSection:"gauge",_initializeTheme:function(){var n=this,t;n._subTheme&&(t=r(!0,{},n._theme[n._subTheme],n._theme),r(!0,n._theme,t)),n._initializeFont(n._theme.scale.label.font),n._initializeFont(n._theme.valueIndicator.rangebar.text.font),n._initializeFont(n._theme.subvalueIndicator.textcloud.text.font),n._initializeFont(n._theme.valueIndicators.rangebar.text.font),n._initializeFont(n._theme.valueIndicators.textcloud.text.font),n._initializeFont(n._theme.title.font),n._initializeFont(n._theme.subtitle.font),n._initializeFont(n._theme.tooltip.font),n._initializeFont(n._theme.indicator.text.font),n._initializeFont(n._theme.loadingIndicator.font)}})}(DevExpress,jQuery),function(n,t,i){function u(n){return e(n)?{text:n}:n||{}}var f=Number,h=n.utils.isNumber,e=n.utils.isString,o=n.utils.getAppropriateFormat,r=t.extend,s=t.each;n.viz.gauges.__internals.BaseGauge=n.viz.core.BaseWidget.inherit({_init:function(){var n=this;n.callBase.apply(n,arguments),n._renderer=n._factory.createRenderer({width:1,height:1,pathModified:n.option("pathModified"),rtl:n.option("rtlEnabled")}),n._root=n._renderer.getRoot(),n._root.applySettings({"class":"dxg "+n._rootClass}),n._translator=n._factory.createTranslator(),n._themeManager=n._factory.createThemeManager(),n._tracker=n._factory.createTracker({renderer:n._renderer,container:n._root}),n._layoutManager=n._factory.createLayoutManager(),n._tooltip=n._factory.createTooltip({renderer:n._renderer,container:n._root,tracker:n._tracker}),n._title=n._factory.createTitle({renderer:n._renderer,container:n._root}),n._deltaIndicator=n._factory.createDeltaIndicator({renderer:n._renderer,container:n._root}),n._setupDomain(),n._themeManager.setTheme(n.option("theme"))},_dispose:function(){var n=this;n.callBase.apply(n,arguments),n._renderer.dispose(),n._themeManager.dispose(),n._tracker.dispose(),n._title.dispose(),n._deltaIndicator&&n._deltaIndicator.dispose(),n._tooltip.dispose(),n._disposeLoadIndicator(),n._renderer=n._root=n._translator=n._themeManager=n._tracker=n._layoutManager=n._title=n._tooltip=null},_refresh:function(){var n=this,t=n.callBase;n._endLoading(function(){t.call(n)})},_clean:function(){this._cleanCore()},_render:function(){var n=this;n._setupCodomain(),n._setupAnimationSettings(),n._calculateSize()&&n._checkDomain()&&(n._renderer.draw(n._element()[0]),n._setupDefaultFormat(),n._renderCore()),n._drawn()},_cleanCore:function(){var n=this;n._tooltip.clean(),n._title.clean(),n._deltaIndicator&&n._deltaIndicator.clean(),n._tracker.deactivate(),n._cleanContent()},_renderCore:function(){var n=this;n._title.render(r(!0,{},n._themeManager.theme().title,u(n.option("title"))),r(!0,{},n._themeManager.theme().subtitle,u(n.option("subtitle")))),n._deltaIndicator&&n._deltaIndicator.render(r(!0,{},n._themeManager.theme().indicator,n.option("indicator"))),n._layoutManager.beginLayout(n._rootRect),s([n._deltaIndicator,n._title],function(t,i){i&&n._layoutManager.applyLayout(i)}),n._mainRect=n._layoutManager.getRect(),n._renderContent(),n._layoutManager.endLayout(),n._tooltip.render(r(!0,{},n._themeManager.theme().tooltip,n.option("tooltip")),{width:n._width,height:n._height}),n._tracker.activate(),n._updateLoadIndicator(i,n._width,n._height),n._noAnimation=null},_resize:function(){var n=this;n._calculateSize()&&(n._resizing=n._noAnimation=!0,n._cleanCore(),n._renderCore(),n._resizing=null)},render:function(n){return n&&n.animate!==i&&!n.animate&&(this._noAnimation=!0),this._refresh(),this},showLoadingIndicator:function(){this._showLoadIndicator(this._getLoadIndicatorOption(),{width:this._width,height:this._height})},_getLoadIndicatorOption:function(){return r(!0,{},this._themeManager.theme().loadingIndicator,this.option("loadingIndicator"))},_optionChanged:function(n,t){var r=this;switch(n){case"theme":r._themeManager.setTheme(t),r._invalidate();break;case"startValue":case"endValue":r._setupDomain(),r._invalidate();break;default:r.callBase.apply(r,arguments)}},_calculateSize:function(){var n=this;return n._calculateSizeCore(),n._width!==0&&n._height!==0&&n._element().is(":visible")?(n._renderer.resize(n._width,n._height),!0):(n._incidentOccured("W2001",[n.NAME]),!1)},_checkDomain:function(){var n=this,t=n._translator.getDomain(),i=isFinite(1/(t[1]-t[0]));return i||n._incidentOccured("W2301"),i},_setupAnimationSettings:function(){var t=this,n=t.option("animation");t._animationSettings=null,(n===i||n)&&(n===i&&(n={enabled:t.option("animationEnabled"),duration:t.option("animationDuration")}),n=r({enabled:!0,duration:1e3,easing:"easeOutCubic"},n),n.enabled&&n.duration>0&&(t._animationSettings={duration:f(n.duration),easing:n.easing})),t._containerBackgroundColor=t.option("containerBackgroundColor")||t._themeManager.theme().containerBackgroundColor},_setupDefaultFormat:function(){var n=this._translator.getDomain();this._defaultFormatOptions=o(n[0],n[1],this._getApproximateScreenRange())},_setupDomain:null,_calculateSizeCore:null,_cleanContent:null,_renderContent:null,_setupCodomain:null,_getApproximateScreenRange:null,_factory:{createRenderer:n.viz.core.CoreFactory.createRenderer,createTranslator:function(){return new n.viz.core.Translator1D},createTracker:function(t){return new n.viz.gauges.__internals.Tracker(t)},createLayoutManager:function(){return new n.viz.gauges.__internals.LayoutManager},createTitle:function(t){return new n.viz.gauges.__internals.Title(t)},createDeltaIndicator:function(t){return n.viz.gauges.__internals.DeltaIndicator?new n.viz.gauges.__internals.DeltaIndicator(t):null},createTooltip:function(t){return new n.viz.gauges.__internals.Tooltip(t)}}})}(DevExpress,jQuery),function(n,t,i){function v(n){return n.value}function o(n,t,i){for(var o=n[t],u=e(i)?s(i,v):[],r=0,h=u.length,f=[];r<h;++r)f.push(n._processValue(u[r],o[r]));n[t]=f}function d(n){n.value=n.subvalues=k,n._setupValue=n._setupSubvalues=n._updateValueIndicator=n._updateSubvalueIndicators=null}function tt(n){n._needleValues=s(n.option("needles")||[],v),n._markerValues=s(n.option("markers")||[],v),n._rangeBarValues=s(n.option("rangeBars")||[],v),n._needles=[],n._markers=[],n._rangeBars=[],n._setupValueState=function(){var n=this;o(n,"_needleValues",n.option("needles")),o(n,"_markerValues",n.option("markers")),o(n,"_rangeBarValues",n.option("rangeBars"))},n._handleValueChanged=function(n,t){var u=this,r=!1;switch(n){case"needles":o(u,"_needleValues",t),r=!0;break;case"markers":o(u,"_markerValues",t),r=!0;break;case"rangeBars":o(u,"_rangeBarValues",t),r=!0}return r&&u._invalidate(),r},n._updateActiveElements=function(){var n=this;r(n._needles,function(t,i){i.value(n._needleValues[i._index],n._noAnimation)}),r(n._markers,function(t,i){i.value(n._markerValues[i._index],n._noAnimation)}),r(n._rangeBars,function(t,i){i.value(n._rangeBarValues[i._index],n._noAnimation)}),n._resizing||n.hideLoadingIndicator()},n._prepareValueIndicators=function(){return ut(this)},n._disposeValueIndicators=function(){var n=this;r([].concat(n._needles,n._markers,n._rangeBars),function(n,t){t.dispose()}),n._needles=n._markers=n._rangeBars=null},n._cleanValueIndicators=function(){r([].concat(this._needles,this._markers,this._rangeBars),function(n,t){t.clean()})},n.needleValue=function(n,t){return y(this,this._needles,this._needleValues,n,t)},n.markerValue=function(n,t){return y(this,this._markers,this._markerValues,n,t)},n.rangeBarValue=function(n,t){return y(this,this._rangeBars,this._rangeBarValues,n,t)}}function it(n){n._indicatorValues=[],n._valueIndicators=[],n._setupValueState=function(){o(this,"_indicatorValues",this.option("valueIndicators"))},n._handleValueChagned=function(n,t){return n==="valueIndicators"?(o(this,"_indicatorValues",t),this._invalidate(),!0):!1},n._updateActiveElements=function(){var n=this;r(n._valueIndicators,function(t,i){i.value(n._indicatorValues[i._index],n._noAnimation)}),n._resizing||n.hideLoadingIndicator()},n._prepareValueIndicators=function(){return rt(this)},n._disposeValueIndicators=function(){r(this._valueIndicators,function(n,t){t.dispose()}),this._valueIndicators=null},n._cleanValueIndicators=function(){r(this._valueIndicators,function(n,t){t.clean()})},n.indicatorValue=function(n,t){return y(this,this._valueIndicators,this._indicatorValues,n,t)}}function rt(n){for(var h=n._valueIndicators||[],u=n.option("valueIndicators"),o=[],t=0,i=e(u)?u.length:0;t<i;++t)o.push(u[t]);for(i=h.length;t<i;++t)o.push(null);var s=n._themeManager.theme().valueIndicators,l={renderer:n._renderer,owner:n._root,translator:n._translator,tracker:n._tracker},c=[];return r(o,function(t,i){var r=h[t],u,e;if(!i){r&&r.dispose();return}u=a(i.type||s._type).toLowerCase(),r&&u!==r.type&&(r.dispose(),r=null),r||(r=n._createValueIndicatorInHardMode(u),r&&r.setup(l)),r&&(e=f(!0,{},s._default,s[u],i,{type:u,animation:n._animationSettings,containerBackgroundColor:n._containerBackgroundColor}),n._updateIndicatorSettings(e),r.render(e),r._index=t,r._trackerInfo={index:t},c.push(r))}),n._valueIndicators=c}function ut(n){var t=w(n,"_rangeBars","_createRangeBar",{user:n.option("rangeBars"),common:n.option("commonRangeBarSettings"),theme:n._themeManager.theme().valueIndicator,preset:{},type:"rangebar",className:"dxg-value-indicator"}),i=w(n,"_needles","_createNeedle",{user:n.option("needles"),common:n.option("commonNeedleSettings"),theme:n._themeManager.theme().valueIndicator,preset:n._getPreset().commonNeedleSettings,className:"dxg-value-indicator"}),r=w(n,"_markers","_createMarker",{user:n.option("markers"),common:n.option("commonMarkerSettings"),theme:n._themeManager.theme().subvalueIndicator,preset:n._getPreset().commonMarkerSettings,className:"dxg-subvalue-indicator"}),u=n._prepareObsoleteSpindle&&n._prepareObsoleteSpindle();return[].concat(t,i,r,[u])}function w(n,t,i,u){for(var v=n[t],h=[],o=0,s=e(u.user)?u.user.length:0;o<s;++o)h.push(u.user[o]);for(s=v.length;o<s;++o)h.push(null);var c=u.theme,p=u.preset,y=u.common||{},w={renderer:n._renderer,owner:n._root,translator:n._translator,tracker:n._tracker,className:u.className},l=[];return r(h,function(t,r){var e=v[t],o,s;if(!r){e&&e.dispose();return}o=a(r.type||y.type||p.type||c.type).toLowerCase(),e&&e.type!==o&&(e.dispose(),e=null),e||(e=n[i](o),e.setup(w)),e&&(o=u.type||o,s=f(!0,{},c._default,c[o],y,r),s.spindleSize=null,s.animation=n._animationSettings,s.containerBackgroundColor=n._containerBackgroundColor,n._updateIndicatorSettings(s),e.render(s),e._index=t,e._trackerInfo={index:t},l.push(e))}),n[t]=l,l}function y(n,t,r,u,f){return f!==i?(r[u]!==i&&(r[u]=n._processValue(f,r[u]),t[u]&&t[u].value(r[u]),n._resizing||n.hideLoadingIndicator()),n):r[u]}function ft(n,t){if(n===t)return!0;if(e(n)&&e(t)&&n.length===t.length){for(var i=0,r=n.length;i<r;++i)if(nt(n[i]-t[i])>1e-8)return!1;return!0}return!1}var b=n.viz.core.Rectangle,g=n.utils.isDefined,e=n.utils.isArray,h=n.utils.isNumber,p=isFinite,u=Number,a=String,nt=Math.abs,f=t.extend,r=t.each,s=t.map,k=t.noop,c="value",l="subvalues";n.viz.gauges.Gauge=n.viz.gauges.__internals.BaseGauge.inherit({_init:function(){var n=this;n.__value=n.option(c),n.__subvalues=n.option(l),e(n.__subvalues)||(n.__subvalues=h(n.__subvalues)?[n.__subvalues]:null),n._selectMode(),n.callBase.apply(n,arguments),n._scale=n._createScale({renderer:n._renderer,container:n._root,translator:n._translator}),n._rangeContainer=n._createRangeContainer({renderer:n._renderer,container:n._root,translator:n._translator})},_dispose:function(){var n=this;n.callBase.apply(n,arguments),n._scale.dispose(),n._rangeContainer.dispose(),n._disposeValueIndicators(),n._scale=n._rangeContainer=null},_disposeValueIndicators:function(){var n=this;n._valueIndicator&&n._valueIndicator.dispose(),n._subvalueIndicatorsSet&&n._subvalueIndicatorsSet.dispose(),n._valueIndicator=n._subvalueIndicatorsSet=null},_selectMode:function(){var n=this;n.option(c)===i&&n.option(l)===i&&(n.option("needles")!==i||n.option("markers")!==i||n.option("rangeBars")!==i?(d(n),tt(n)):n.option("valueIndicators")!==i&&(d(n),it(n)))},_setupDomain:function(){var n=this,r=n.option("scale")||{},t=n.option("startValue"),i=n.option("endValue");t=h(t)?u(t):h(r.startValue)?u(r.startValue):0,i=h(i)?u(i):h(r.endValue)?u(r.endValue):100,n._baseValue=t<i?t:i,n._translator.setDomain(t,i),n._setupValueState()},_setupValueState:function(){this._setupValue(),this.__subvalues!==null&&this._setupSubvalues()},_calculateSizeCore:function(){var n=this,i=n.option("size")||{},t=n.option("margin")||{};if(u(i.width)===0||u(i.height)===0)n._width=n._height=0,n._rootRect=new b;else{var r=i.width>0?u(i.width):n._element().width()||n._getDefaultContainerSize().width,f=i.height>0?u(i.height):n._element().height()||n._getDefaultContainerSize().height,e=t.left>0?u(t.left):0,o=t.right>0?u(t.right):0,s=t.top>0?u(t.top):0,h=t.bottom>0?u(t.bottom):0;e+o>=r&&(e=o=0),s+h>=f&&(s=h=0),n._width=r,n._height=f,n._rootRect=new b({left:e,top:s,right:r-o,bottom:f-h})}},_cleanContent:function(){var n=this;n._rangeContainer.clean(),n._scale.clean(),n._cleanValueIndicators()},_renderContent:function(){var n=this,t;n._rangeContainer.render(f(!0,{},n._themeManager.theme().rangeContainer,n.option("rangeContainer"),{themeName:n._themeManager.themeName(),vertical:n._area.vertical})),n._scale.render(f(!0,{},n._themeManager.theme().scale,n.option("scale"),{approximateScreenDelta:n._getApproximateScreenRange(),offset:0,vertical:n._area.vertical})),t=n._prepareValueIndicators(),t=s([n._scale,n._rangeContainer].concat(t),function(n){return n&&n.enabled?n:null}),n._applyMainLayout(t),r(t,function(t,i){n._updateElementPosition(i)}),n._updateActiveElements()},_updateIndicatorSettings:function(n){var t=this;n.currentValue=n.baseValue=p(t._translator.translate(n.baseValue))?u(n.baseValue):t._baseValue,n.vertical=t._area.vertical,!n.text||n.text.format||n.text.precision||(n.text.format=t._defaultFormatOptions.format,n.text.precision=t._defaultFormatOptions.precision)},_prepareValueIndicatorSettings:function(){var n=this,i=n.option("valueIndicator")||{},t=f(!0,{},n._themeManager.theme().valueIndicator),r=a(i.type||t.type).toLowerCase();n._valueIndicatorSettings=f(!0,t._default,t[r],i,{type:r,animation:n._animationSettings,containerBackgroundColor:n._containerBackgroundColor}),n._updateIndicatorSettings(n._valueIndicatorSettings)},_prepareSubvalueIndicatorSettings:function(){var n=this,i=n.option("subvalueIndicator")||{},t=f(!0,{},n._themeManager.theme().subvalueIndicator),r=a(i.type||t.type).toLowerCase();n._subvalueIndicatorSettings=f(!0,t._default,t[r],i,{type:r,animation:n._animationSettings,containerBackgroundColor:n._containerBackgroundColor}),n._updateIndicatorSettings(n._subvalueIndicatorSettings)},_cleanValueIndicators:function(){this._valueIndicator&&this._valueIndicator.clean(),this._subvalueIndicatorsSet&&this._subvalueIndicatorsSet.clean()},_prepareValueIndicators:function(){var n=this;return n._prepareValueIndicator(),n.__subvalues!==null&&n._prepareSubvalueIndicators(),[n._valueIndicator,n._subvalueIndicatorsSet]},_updateActiveElements:function(){this._updateValueIndicator(),this._updateSubvalueIndicators()},_prepareValueIndicator:function(){var n=this,t=n._valueIndicator,i;n._prepareValueIndicatorSettings(),t&&n._valueIndicatorType!==n._valueIndicatorSettings.type&&t.dispose()&&(t=null),n._valueIndicatorType=n._valueIndicatorSettings.type,t||(t=n._valueIndicator=n._createValueIndicator(n._valueIndicatorType),t&&(t.setup({renderer:n._renderer,translator:n._translator,owner:n._root,tracker:n._tracker,className:"dxg-value-indicator"}),t._trackerInfo={type:"value-indicator"})),t.render(n._valueIndicatorSettings)},_prepareSubvalueIndicators:function(){var t=this,i=t._subvalueIndicatorsSet,r;i||(i=t._subvalueIndicatorsSet=new n.viz.gauges.__internals.ValueIndicatorsSet({renderer:t._renderer,translator:t._translator,owner:t._root,tracker:t._tracker,className:"dxg-subvalue-indicators",indicatorClassName:"dxg-subvalue-indicator",trackerType:"subvalue-indicator",createIndicator:function(){return t._createSubvalueIndicator(t._subvalueIndicatorType)}})),t._prepareSubvalueIndicatorSettings(),r=t._subvalueIndicatorSettings.type!==t._subvalueIndicatorType,t._subvalueIndicatorType=t._subvalueIndicatorSettings.type,t._createSubvalueIndicator(t._subvalueIndicatorType)&&i.render(t._subvalueIndicatorSettings,r)},_processValue:function(n,t){var r=this._translator.adjust(n!==i?n:this.__value);return p(r)?r:t},_setupValue:function(n){this.__value=this._processValue(n,this.__value)},_setupSubvalues:function(n){var r=n===i?this.__subvalues:e(n)?n:h(n)?[n]:null;if(r!==null){for(var t=0,f=r.length,u=[];t<f;++t)u.push(this._processValue(r[t],this.__subvalues[t]));this.__subvalues=u}},_updateValueIndicator:function(){var n=this;n._valueIndicator&&n._valueIndicator.value(n.__value,n._noAnimation),n._resizing||n.hideLoadingIndicator()},_updateSubvalueIndicators:function(){var n=this;n._subvalueIndicatorsSet&&n._subvalueIndicatorsSet.values(n.__subvalues,n._noAnimation),n._resizing||n.hideLoadingIndicator()},value:function(n){var t=this;return n!==i?(t._setupValue(n),t._updateValueIndicator(),t.option(c,t.__value),t):t.__value},subvalues:function(n){var t=this;return n!==i?(t.__subvalues!==null&&(t._setupSubvalues(n),t._updateSubvalueIndicators(),t.option(l,t.__subvalues)),t):t.__subvalues!==null?t.__subvalues.slice():i},_handleValueChanged:function(n,t){var r=this;switch(n){case c:return r._setupValue(t),r._updateValueIndicator(),r.option(c,r.__value),!0;case l:return r.__subvalues!==null?(r._setupSubvalues(t),r._updateSubvalueIndicators(),r.option(l,r.__subvalues),!0):!1;default:return!1}},_optionChanged:function(n,t,i){var r=this;if(!r._handleValueChanged(n,t,i))switch(n){case"scale":r._setupDomain(),r._invalidate();break;default:r.callBase.apply(r,arguments)}},_optionValuesEqual:function(n,t,i){switch(n){case c:return t===i;case l:return ft(t,i);default:return this.callBase.apply(this,arguments)}},_getDefaultContainerSize:null,_applyMainLayout:null,_updateElementPosition:null,_createScale:null,_createRangeContainer:null,_createValueIndicator:null,_createSubvalueIndicator:null,_getApproximateScreenRange:null}),n.viz.gauges.Gauge.prototype._factory=n.utils.clone(n.viz.gauges.__internals.BaseGauge.prototype._factory),n.viz.gauges.Gauge.prototype._factory.createThemeManager=function(){return new n.viz.gauges.__internals.ThemeManager},n.viz.gauges.__internals.ValueIndicatorsSet=n.Class.inherit({ctor:function(n){var t=this;t._parameters=n,t._createIndicator=t._parameters.createIndicator||k,t._root=t._parameters.renderer.createGroup({"class":t._parameters.className}),t._indicatorParameters=t._indicatorParameters||{renderer:t._parameters.renderer,translator:t._parameters.translator,owner:t._root,tracker:t._parameters.tracker,className:t._parameters.indicatorClassName},t._indicators=[]},dispose:function(){var n=this;return r(n._indicators,function(n,t){t.dispose()}),n._parameters=n._createIndicator=n._root=n._options=n._indicators=n._colorPalette=n._palette=null,n},clean:function(){var n=this;return n._root.detach(),n._sample&&n._sample.clean().dispose(),r(n._indicators,function(n,t){t.clean()}),n._sample=n._options=n._palette=null,n},render:function(t,i){var r=this;return r._options=t,r._sample=r._createIndicator(),r._sample&&r._sample.setup(r._indicatorParameters).render(t),r.enabled=r._sample&&r._sample.enabled,r._palette=g(t.palette)?new n.viz.core.Palette(t.palette):null,r.enabled&&(r._root.append(r._parameters.owner),r._generatePalette(r._indicators.length),r._indicators=s(r._indicators,function(n,t){return i&&(n.dispose(),n=r._createIndicator(),n.setup(r._indicatorParameters),n._trackerInfo={type:r._parameters.trackerType,index:t}),n.render(r._getIndicatorOptions(t)),n})),r},resize:function(n){var t=this;return t._layout=n,r(t._indicators,function(t,i){i.resize(n)}),t},measure:function(n){return this._sample.measure(n)},_getIndicatorOptions:function(n){var t=this._options;return this._colorPalette&&(t=f({},t,{color:this._colorPalette[n]})),t},_generatePalette:function(n){var t=this,i=null,r;if(t._palette)for(i=[],t._palette.reset(),r=0;r<n;++r)i.push(t._palette.getNextColor());t._colorPalette=i},_adjustIndicatorsCount:function(n){var t=this,r=t._indicators,i,f,o,u,e=r.length,s=t._parameters.palette;if(e>n){for(i=n,f=e;i<f;++i)r[i].clean().dispose();t._indicators=r.slice(0,n),t._generatePalette(r.length)}else if(e<n)for(t._generatePalette(n),i=e,f=n;i<f;++i)u=t._createIndicator(),u.setup(t._indicatorParameters),u._trackerInfo={type:t._parameters.trackerType,index:i},u.render(t._getIndicatorOptions(i)).resize(t._layout),r.push(u)},values:function(n,t){var u=this;if(u.enabled)return n!==i?(e(n)||(n=p(n)?[Number(n)]:null),n&&(u._adjustIndicatorsCount(n.length),r(u._indicators,function(i,r){r.value(n[i],t)})),u):s(u._indicators,function(n){return n.value()})}})}(DevExpress,jQuery),function(n,t,i){function y(n,t){var s=c(n),h=c(t),i=s.cos,u=s.sin,e=h.cos,o=h.sin;return{left:u<=0&&o>=0||u<=0&&o<=0&&i<=e||u>=0&&o>=0&&i>=e?-1:f(i,e,0),right:u>=0&&o<=0||u>=0&&o>=0&&i>=e||u<=0&&o<=0&&i<=e?1:r(i,e,0),up:i<=0&&e>=0||i<=0&&e<=0&&u>=o||i>=0&&e>=0&&u<=o?-1:-r(u,o,0),down:i>=0&&e<=0||i>=0&&e>=0&&u<=o||i<=0&&e<=0&&u>=o?1:-f(u,o,0)}}var u=n.viz.gauges.__factory,s=window.isFinite,e=window.Number,h=n.utils.normalizeAngle,c=n.utils.getCosAndSin,l=Math.abs,r=Math.max,f=Math.min,o=Math.round,p=Array.prototype.slice,w=t.extend,a=t.each,v=Math.PI;n.viz.gauges.CircularGauge=n.viz.gauges.Gauge.inherit({_rootClass:"dxg-circular-gauge",_selectMode:function(){this.callBase.apply(this,arguments),typeof this.indicatorValue=="function"&&(this._createValueIndicatorInHardMode=function(n){return u.createCircularValueIndicatorInHardMode(n)})},_setupCodomain:function(){var u=this,r=u.option("geometry")||{},t=r.startAngle,n=r.endAngle,f;t=s(t)?h(t):225,n=s(n)?h(n):-45,l(t-n)<1?(n-=360,f={left:-1,up:-1,right:1,down:1}):(t<n&&(n-=360),f=y(t,n)),u._area={x:0,y:0,radius:100,startCoord:t,endCoord:n,scaleRadius:r.scaleRadius>0?e(r.scaleRadius):i,sides:f},u._translator.setCodomain(t,n)},_measureMainElements:function(n){var c=this,t=0,o=Infinity,i=0,u=0,s=0,h=0;return a(n,function(n,l){var a=l.measure({radius:c._area.radius-(e(l._options.offset)||0)});a.min>0&&(o=f(o,a.min)),a.max>0&&(t=r(t,a.max)),a.horizontalOffset>0&&(i=r(i,a.max+a.horizontalOffset)),a.verticalOffset>0&&(u=r(u,a.max+a.verticalOffset)),a.inverseHorizontalOffset>0&&(s=r(s,a.inverseHorizontalOffset)),a.inverseVerticalOffset>0&&(h=r(h,a.inverseVerticalOffset))}),i=r(i-t,0),u=r(u-t,0),{minRadius:o,maxRadius:t,horizontalMargin:i,verticalMargin:u,inverseHorizontalMargin:s,inverseVerticalMargin:h}},_applyMainLayout:function(n){var h=this,r=h._measureMainElements(n),u=h._area,t=u.sides,e={left:(t.left<-.1?r.horizontalMargin:r.inverseHorizontalMargin)||0,right:(t.right>.1?r.horizontalMargin:r.inverseHorizontalMargin)||0,top:(t.up<-.1?r.verticalMargin:r.inverseVerticalMargin)||0,bottom:(t.down>.1?r.verticalMargin:r.inverseVerticalMargin)||0},i=h._layoutManager.selectRectByAspectRatio((t.down-t.up)/(t.right-t.left),e),s=f(i.width()/(t.right-t.left),i.height()/(t.down-t.up)),l,a,c=(r.maxRadius-u.radius+u.scaleRadius)/s;0<c&&c<1&&(i=i.scale(c),s*=c),s=s-r.maxRadius+u.radius,l=i.left-i.width()*t.left/(t.right-t.left),a=i.top-i.height()*t.up/(t.down-t.up),u.x=o(l),u.y=o(a),u.radius=s,i.left-=e.left,i.right+=e.right,i.top-=e.top,i.bottom+=e.bottom,h._layoutManager.setRect(i)},_updateElementPosition:function(n){n.resize({x:this._area.x,y:this._area.y,radius:o(this._area.radius-(e(n._options.offset)||0))})},_createScale:function(n){return u.createCircularScale(n)},_createRangeContainer:function(n){return u.createCircularRangeContainer(n)},_createValueIndicator:function(n){return u.createCircularValueIndicator(n)},_createSubvalueIndicator:function(n){return u.createCircularSubvalueIndicator(n)},_getApproximateScreenRange:function(){var i=this,n=i._area,t=f(i._width/(n.sides.right-n.sides.left),i._height/(n.sides.down-n.sides.up));return t>n.totalRadius&&(t=n.totalRadius),t=.8*t,-i._translator.getCodomainRange()*t*v/180},_getDefaultContainerSize:function(){return{width:300,height:300}},_getPreset:function(){var t=this.option("preset"),n;return n=t==="preset2"?{commonNeedleSettings:{type:"twocolorrectangle"},commonMarkerSettings:{type:"triangle"}}:t==="preset3"?{commonNeedleSettings:{type:"rectangle"},commonMarkerSettings:{type:"triangle"}}:{commonNeedleSettings:{type:"rectangle"},commonMarkerSettings:{type:"textcloud"}}},_createNeedle:function(n){return u.createCircularNeedle(n)},_createMarker:function(n){return u.createCircularMarker(n)},_createRangeBar:function(){return u.createCircularRangeBar()},_prepareObsoleteSpindle:function(){var n=this,t=n.option("spindle")||{},f=n._needles&&("visible"in t?!!t.visible:!0),u,i,r,e;return f&&(u=n._themeManager.theme().valueIndicator._default,i=t.size||u.spindleSize,f=i>0),f?(r=t.gapSize||u.spindleGapSize,e=t.color||u.color,r=r<=i?r:i,n._spindle=n._spindle||n._renderer.createGroup({"class":"dxg-value-indicator"}),n._spindle.append(n._root),n._spindleOuter=n._spindleOuter||n._renderer.createCircle(0,0,0,{"class":"dxg-spindle-border",stroke:"none",strokeWidth:0}).append(n._spindle),n._spindleInner=n._spindleInner||n._renderer.createCircle(0,0,0,{"class":"dxg-spindle-hole",stroke:"none",strokeWidth:0}).append(n._spindle),n._spindleOuter.applySettings({cx:n._area.x,cy:n._area.y,r:i/2,fill:e}),n._spindleInner.applySettings({cx:n._area.x,cy:n._area.y,r:r/2,fill:n._containerBackgroundColor}),{enabled:!0,_options:{offset:0},measure:function(){return{}},resize:function(t){return n._spindleOuter.applySettings({cx:t.x,cy:t.y}),n._spindleInner.applySettings({cx:t.x,cy:t.y}),n}}):(n._spindle&&n._spindle.remove(),delete n._spindle,delete n._spindleOuter,delete n._spindleInner,null)}}),n.viz.gauges.CircularGauge.prototype._factory=n.utils.clone(n.viz.gauges.__internals.BaseGauge.prototype._factory),n.viz.gauges.CircularGauge.prototype._factory.createThemeManager=function(){var t=new n.viz.gauges.__internals.ThemeManager;return t._subTheme="_circular",t}}(DevExpress,jQuery),function(n,t,i){var r=n.viz.gauges.__factory,o=String,u=Number,e=Math.max,s=Math.min,f=Math.round,c=Array.prototype.slice,l=t.extend,h=t.each;n.viz.gauges.LinearGauge=n.viz.gauges.Gauge.inherit({_rootClass:"dxg-linear-gauge",_selectMode:function(){this.callBase.apply(this,arguments),typeof this.indicatorValue=="function"&&(this._createValueIndicatorInHardMode=function(n){return r.createLinearValueIndicatorInHardMode(n)})},_setupCodomain:function(){var n=this,t=n.option("geometry")||{},r=o(t.orientation).toLowerCase()==="vertical";n._area={vertical:r,x:0,y:0,startCoord:-100,endCoord:100,scaleSize:t.scaleSize>0?u(t.scaleSize):i},n._scale.vertical=r,n._rangeContainer.vertical=r},_measureMainElements:function(n){var f=this,t=1e3,i=0,r=0;return h(n,function(n,o){var h=o.measure({x:f._area.x+(u(o._options.offset)||0),y:f._area.y+(u(o._options.offset)||0)});i=e(i,h.max),t=s(t,h.min),h.indent>0&&(r=e(r,h.indent))}),{minBound:t,maxBound:i,indent:r}},_applyMainLayout:function(n){var u=this,t=u._measureMainElements(n),i=u._area,r,e,o=i.scaleSize+2*t.indent;i.vertical?(r=u._layoutManager.selectRectBySizes({width:t.maxBound-t.minBound,height:o}),e=r.horizontalMiddle()-(t.minBound+t.maxBound)/2,i.startCoord=r.bottom-t.indent,i.endCoord=r.top+t.indent,i.x=f(i.x+e)):(r=u._layoutManager.selectRectBySizes({height:t.maxBound-t.minBound,width:o}),e=r.verticalMiddle()-(t.minBound+t.maxBound)/2,i.startCoord=r.left+t.indent,i.endCoord=r.right-t.indent,i.y=f(i.y+e)),u._translator.setCodomain(i.startCoord,i.endCoord),u._layoutManager.setRect(r)},_updateElementPosition:function(n){n.resize({x:f(this._area.x+(u(n._options.offset)||0)),y:f(this._area.y+(u(n._options.offset)||0))})},_createScale:function(n){return r.createLinearScale(n)},_createRangeContainer:function(n){return r.createLinearRangeContainer(n)},_createValueIndicator:function(n){return r.createLinearValueIndicator(n)},_createSubvalueIndicator:function(n){return r.createLinearSubvalueIndicator(n)},_getApproximateScreenRange:function(){var t=this,i=t._area,n=i.vertical?t._height:t._width;return n>i.totalSize&&(n=i.totalSize),n=n*.8},_getDefaultContainerSize:function(){var n=this.option("geometry")||{};return n.orientation==="vertical"?{width:100,height:300}:{width:300,height:100}},_getPreset:function(){var t=this.option("preset"),n;return n=t==="preset2"?{commonNeedleSettings:{type:"rhombus"},commonMarkerSettings:{type:"triangle"}}:{commonNeedleSettings:{type:"circle"},commonMarkerSettings:{type:"textcloud"}}},_createNeedle:function(n){return r.createLinearNeedle(n)},_createMarker:function(n){return r.createLinearMarker(n)},_createRangeBar:function(){return r.createLinearRangeBar()}}),n.viz.gauges.LinearGauge.prototype._factory=n.utils.clone(n.viz.gauges.__internals.BaseGauge.prototype._factory),n.viz.gauges.LinearGauge.prototype._factory.createThemeManager=function(){var t=new n.viz.gauges.__internals.ThemeManager;return t._subTheme="_linear",t}}(DevExpress,jQuery),function(n,t,i){function y(n,t){var i=this;i._context=t,i._background=t.renderer.createArc().append(t.group),i._background.applySettings({fill:t.backgroundColor}),i._bar=t.renderer.createArc().append(t.group),t.textEnabled&&(i._line=t.renderer.createPath([],{strokeWidth:t.lineWidth}).append(t.group),i._text=t.renderer.createText("",0,0,t.textOptions).append(t.group)),i._tracker=t.renderer.createArc(),t.tracker.attach(i._tracker,i,{index:n}),i._index=n,i._angle=t.baseAngle,i._settings={x:t.x,y:t.y,startAngle:t.baseAngle,endAngle:t.baseAngle}}function p(n,t,i){n.startAngle=t<i?t:i,n.endAngle=t<i?i:t}function h(n,t){return b(n-t)<.0001}function rt(n,t){if(n===t)return!0;if(s(n)&&s(t)&&n.length===t.length){for(var i=0,r=n.length;i<r;++i)if(!h(n[i],t[i]))return!1;return!0}return!1}var w=Math.PI,r=window.Number,f=window.isFinite,b=Math.abs,e=Math.round,k=Math.floor,o=Math.min,c=Math.max,s=n.utils.isArray,d=n.utils.convertAngleToRendererSpace,l=n.utils.getCosAndSin,g=t.noop,u=t.extend,nt=n.viz.gauges.__internals.getSampleText,tt=n.viz.gauges.__internals.formatValue,a=n.viz.core.Rectangle,it=n.viz.core.Palette,v;n.viz.gauges.BarGauge=n.viz.gauges.__internals.BaseGauge.inherit({_rootClass:"dxbg-bar-gauge",_init:function(){var n=this;n.callBase.apply(n,arguments),n._barsGroup=n._renderer.createGroup({"class":"dxbg-bars"}),n._values=[],n._context={renderer:n._renderer,translator:n._translator,tracker:n._tracker,group:n._barsGroup},n._animateStep=function(t){for(var r=n._bars,i=0,u=r.length;i<u;++i)r[i].animate(t)},n._animateComplete=function(){for(var i=n._bars,t=0,r=i.length;t<r;++t)i[t].endAnimation()}},_dispose:function(){var n=this;n.callBase.apply(n,arguments),n._barsGroup=n._values=n._context=n._animateStep=n._animateComplete=null},_setupDomain:function(){var n=this,t=n.option("startValue"),i=n.option("endValue");f(t)||(t=0),f(i)||(i=100),n._translator.setDomain(t,i),n._baseValue=n._translator.adjust(n.option("baseValue")),f(n._baseValue)||(n._baseValue=t<i?t:i)},_calculateSizeCore:function(){var n=this,t=n.option("size")||{};r(t.width)===0||r(t.height)===0?(n._width=n._height=0,n._rootRect=new a):(n._width=t.width>0?r(t.width):n._element().width()||300,n._height=t.height>0?r(t.height):n._element().height()||300,n._rootRect=new a({left:0,top:0,right:n._width,bottom:n._height}))},_setupCodomain:n.viz.gauges.CircularGauge.prototype._setupCodomain,_getApproximateScreenRange:function(){var n=this,t=n._area.sides,i=n._width/(t.right-t.left),r=n._height/(t.down-t.up),u=i<r?i:r;return-n._translator.getCodomainRange()*u*w/180},_setupAnimationSettings:function(){this.callBase(),this._animationSettings&&u(this._animationSettings,{step:this._animateStep,complete:this._animateComplete})},_cleanContent:function(){var n=this,t,i;for(n._barsGroup.detach(),n._animationSettings&&n._barsGroup.stopAnimation(),t=0,i=n._bars?n._bars.length:0;t<i;++t)n._bars[t].dispose();n._palette=n._bars=null},_renderContent:function(){var t=this,f=t.option("label"),o,e;t._barsGroup.append(t._root),t._context.textEnabled=f===i||f&&(!("visible"in f)||f.visible),t._context.textEnabled&&(t._context.textColor=f&&f.font&&f.font.color||null,f=u(!0,{},t._themeManager.theme().label,f),t._context.formatOptions={format:f.format!==i||f.precision!==i?f.format:t._defaultFormatOptions.format,precision:f.format!==i||f.precision!==i?f.precision:t._defaultFormatOptions.precision,customizeText:f.customizeText},t._context.textOptions={font:u({},t._themeManager.theme().label.font,f.font,{color:null}),align:"center"},t._textIndent=f.indent>0?r(f.indent):0,t._context.lineWidth=f.connectorWidth>0?r(f.connectorWidth):0,t._context.lineColor=f.connectorColor||null,o=t._renderer.createText(nt(t._translator,t._context.formatOptions),0,0,t._context.textOptions).append(t._barsGroup),e=o.getBBox(),o.detach(),t._context.textVerticalOffset=-e.y-e.height/2,t._context.textWidth=e.width,t._context.textHeight=e.height),n.viz.gauges.CircularGauge.prototype._applyMainLayout.call(t),t._renderBars()},_measureMainElements:function(){var n={maxRadius:this._area.radius};return this._context.textEnabled&&(n.horizontalMargin=this._context.textWidth,n.verticalMargin=this._context.textHeight),n},_renderBars:function(){var n=this,t=u({},n._themeManager.theme(),n.option()),f,i;n._palette=new it(t.palette,{stepHighlight:50,theme:n._themeManager.themeName()}),f=t.relativeInnerRadius>0&&t.relativeInnerRadius<1?r(t.relativeInnerRadius):.1,i=n._area.radius,n._context.textEnabled&&(n._textIndent=e(o(n._textIndent,i/2)),i-=n._textIndent),n._outerRadius=e(i),n._innerRadius=e(i*f),n._barSpacing=t.barSpacing>0?r(t.barSpacing):0,u(n._context,{backgroundColor:t.backgroundColor,x:n._area.x,y:n._area.y,startAngle:n._area.startCoord,endAngle:n._area.endCoord,baseAngle:n._translator.translate(n._baseValue)}),n._bars=[],n._updateValues(n.option("values"))},_arrangeBars:function(n){var t=this,i=t._outerRadius-t._innerRadius,u,f,e,r;for(t._context.barSize=n>0?c((i-(n-1)*t._barSpacing)/n,1):0,u=n>1?c(o((i-n*t._context.barSize)/(n-1),t._barSpacing),0):0,f=o(k((i+u)/t._context.barSize),n),t._setBarsCount(f),i=t._outerRadius,t._context.textRadius=i+t._textIndent,t._palette.reset(),e=t._context.barSize+u,r=0;r<f;++r,i-=e)t._bars[r].arrange({radius:i,color:t._palette.getNextColor()})},_setBarsCount:function(n){var t=this,i,r;if(t._bars.length>n){for(i=n,r=t._bars.length;i<r;++i)t._bars[i].dispose();t._bars.splice(n,r-n)}else if(t._bars.length<n)for(i=t._bars.length,r=n;i<r;++i)t._bars.push(new y(i,t._context));t._bars.length>0?t._dummyBackground&&(t._dummyBackground.detach(),t._dummyBackground=null):(t._dummyBackground||(t._dummyBackground=t._renderer.createArc().append(t._barsGroup)),t._dummyBackground.applySettings({x:t._context.x,y:t._context.y,outerRadius:t._outerRadius,innerRadius:t._innerRadius,startAngle:t._context.endAngle,endAngle:t._context.startAngle,fill:t._context.backgroundColor}))},_updateBars:function(){for(var t=this,n=0,i=t._bars.length;n<i;++n)t._bars[n].setValue(t._values[n])},_animateBars:function(){var n=this,t=0,i=n._bars.length;if(i>0){for(;t<i;++t)n._bars[t].beginAnimation(n._values[t]);n._barsGroup.animate({_:0},n._animationSettings)}},_updateValues:function(n){var i=this,e=s(n)&&n||f(n)&&[n]||[],r=0,o=e.length,u;for(i._values=[];r<o;++r)u=i._translator.adjust(e[r]),f(u)&&i._values.push(u);i._animationSettings&&i._barsGroup.stopAnimation(),i._bars&&(i._arrangeBars(i._values.length),i._animationSettings&&!i._noAnimation?i._animateBars():i._updateBars()),i._resizing||(i.option("values",i._values),i.hideLoadingIndicator())},values:function(n){return n!==i?(this._updateValues(n),this):this._values.slice(0)},_optionChanged:function(n,t){switch(n){case"values":this._updateValues(t);break;default:this.callBase.apply(this,arguments)}},_optionValuesEqual:function(n,t,i){switch(n){case"values":return rt(t,i);default:return this.callBase.apply(this,arguments)}}}),v=n.viz.gauges.__internals.ThemeManager.inherit({_themeSection:"barGauge",_initializeTheme:function(){var n=this;n._initializeFont(n._theme.label.font),n._initializeFont(n._theme.title.font),n._initializeFont(n._theme.tooltip.font),n._initializeFont(n._theme.loadingIndicator.font)}}),n.viz.gauges.BarGauge.prototype._factory=n.utils.clone(n.viz.gauges.__internals.BaseGauge.prototype._factory),n.viz.gauges.BarGauge.prototype._factory.createThemeManager=function(){return new v},u(y.prototype,{dispose:function(){var n=this;return n._background.detach(),n._bar.detach(),n._context.textEnabled&&(n._line.detach(),n._text.detach()),n._context.tracker.detach(n._tracker),n._context=n._settings=n._background=n._bar=n._line=n._text=n._tracker=null,n},arrange:function(n){var t=this;return t._settings.outerRadius=n.radius,t._settings.innerRadius=n.radius-t._context.barSize,t._background.applySettings(u({},t._settings,{startAngle:t._context.endAngle,endAngle:t._context.startAngle})),t._bar.applySettings(t._settings),t._tracker.applySettings(t._settings),t._color=n.color,t._bar.applySettings({fill:n.color}),t._context.textEnabled&&(t._line.applySettings({points:[t._context.x,t._context.y-t._settings.innerRadius,t._context.x,t._context.y-t._context.textRadius],stroke:t._context.lineColor||n.color}),t._text.applySettings({font:{color:t._context.textColor||n.color}})),t},getTooltipParameters:function(){var n=this,t=l((n._angle+n._context.baseAngle)/2);return{x:e(n._context.x+(n._settings.outerRadius+n._settings.innerRadius)/2*t.cos),y:e(n._context.y-(n._settings.outerRadius+n._settings.innerRadius)/2*t.sin),offset:0,color:n._color,value:n._value}},setAngle:function(n){var t=this,i;return t._angle=n,p(t._settings,t._context.baseAngle,t._angle),t._bar.applySettings(t._settings),t._tracker.applySettings(t._settings),t._context.textEnabled&&(t._line.rotate(d(t._angle),t._context.x,t._context.y),i=l(t._angle),t._text.applySettings({text:tt(t._value,t._context.formatOptions,{index:t._index}),x:t._context.x+(t._context.textRadius+t._context.textWidth*.6)*i.cos,y:t._context.y-(t._context.textRadius+t._context.textHeight*.6)*i.sin+t._context.textVerticalOffset})),t},setValue:function(n){return this._value=n,this.setAngle(this._context.translator.translate(n))},beginAnimation:function(n){var t=this,i;t._value=n,i=t._context.translator.translate(n),h(t._angle,i)?t.animate=g:(t._start=t._angle,t._delta=i-t._angle,t._tracker.applySettings({visibility:"hidden"}),t._context.textEnabled&&(t._line.applySettings({visibility:"hidden"}),t._text.applySettings({visibility:"hidden"})))},animate:function(n){var t=this;t._angle=t._start+t._delta*n,p(t._settings,t._context.baseAngle,t._angle),t._bar.applySettings(t._settings)},endAnimation:function(){var n=this;n._delta!==i?h(n._angle,n._start+n._delta)&&(n._tracker.applySettings({visibility:null}),n._context.textEnabled&&(n._line.applySettings({visibility:null}),n._text.applySettings({visibility:null})),n.setAngle(n._angle)):delete n.animate,delete n._start,delete n._delta}}),n.registerComponent("dxBarGauge",n.viz.gauges.BarGauge)}(DevExpress,jQuery),function(n,t){function y(n){var t=n.data.tracker;t._x=n.pageX,t._y=n.pageY;t._element.off(e).on(e,n.data);t._showTooltip(n,h)}function p(n){var t=n.data.tracker;(t._showTooltipTimeout&&s(n.pageX-t._x)>4||s(n.pageY-t._y)>4)&&(t._x=n.pageX,t._y=n.pageY,t._showTooltip(n,h))}function w(n){var t=n.data.tracker;t._element.off(e),t._hideTooltip(a)}function b(n){n.preventDefault();var t=r;t&&t!==n.data.tracker&&t._hideTooltip(f),t=r=n.data.tracker,t._showTooltip(n,v),t._touch=!0}function k(){var t=r;t&&(t._touch||(t._hideTooltip(f),r=null),t._touch=null)}function d(){var t=r;t&&t._showTooltipTimeout&&(t._hideTooltip(f),r=null)}var o=window.setTimeout,u=window.clearTimeout,g=t.extend,s=Math.abs,h=300,a=300,v=400,f=300,r;n.viz.gauges.__internals.Tracker=n.Class.inherit({ctor:function(n){var t=this;t._container=n.container,t._element=n.renderer.createGroup({"class":"dxg-tracker",stroke:"none",strokeWidth:0,fill:"#000000",opacity:.0001}),t._showTooltipCallback=function(){t._showTooltipTimeout=null;var n=t._tooltipEvent.target;t._targetEvent=null,t._tooltipTarget!==n&&(t._tooltipTarget=n,t._callbacks["tooltip-show"]())},t._hideTooltipCallback=function(){t._hideTooltipTimeout=null,t._targetEvent=null,t._tooltipTarget&&(t._callbacks["tooltip-hide"](),t._tooltipTarget=null)},t._dispose=function(){t._showTooltipCallback=t._hideTooltipCallback=t._dispose=null}},dispose:function(){var n=this;return n._dispose(),n.deactivate(),n._element.off(),n._container=n._element=n._context=n._callbacks=null,n},activate:function(){return this._element.append(this._container),this},deactivate:function(){return this._element.detach(),this._element.clear(),this},attach:function(n,t,i){return n.data({target:t,info:i}),n.append(this._element),this},detach:function(n){return n.detach(),n.removeData(),this},setTooltipState:function(n){var t=this,i;if(t._element.off(c).off(l),n){i={tracker:t};t._element.on(c,i).on(l,i)}return t},setCallbacks:function(n){return this._callbacks=n,this},_showTooltip:function(n,i){var r=this,f=t(n.target).data();(r._tooltipTarget===n.target||r._callbacks["tooltip-prepare"](f.target,f.info))&&(u(r._hideTooltipTimeout),r._hideTooltipTimeout=null,u(r._showTooltipTimeout),r._tooltipEvent=n,r._showTooltipTimeout=o(r._showTooltipCallback,i))},_hideTooltip:function(n){var t=this;u(t._showTooltipTimeout),t._showTooltipTimeout=null,u(t._hideTooltipTimeout),t._hideTooltipTimeout=o(t._hideTooltipCallback,n)}});var c={"mouseover.gauge-tooltip":y,"mouseout.gauge-tooltip":w},e={"mousemove.gauge-tooltip":p},l={"touchstart.gauge-tooltip":b};r=null;t(window.document).on({"touchstart.gauge-tooltip":k,"touchend.gauge-tooltip":d})}(DevExpress,jQuery),function(n){n.registerComponent("dxCircularGauge",n.viz.gauges.CircularGauge)}(DevExpress),function(n){n.registerComponent("dxLinearGauge",n.viz.gauges.LinearGauge)}(DevExpress),DevExpress.MOD_VIZ_GAUGES=!0}