'''
hersheydata.py

Version 2.0.2, dated July 31, 2016.

Originally prepared in 2011 by Windell H. Oskay, www.evilmadscientist.com
Updated, 2016 by Windell H. Oskay, www.evilmadscientist.com

Contents adapted from emergent.unpythonic.net/software/hershey
 by way of "Hershey Fonts in SVG" by Marty McGuire
 http://www.thingiverse.com/thing:6168 

Modified and expanded in May, 2016 by Sheldon B. Michaels to include
additional engraving fonts, created from modern sources (the "EMS" series), 
and to allow additional precision in the specification of vectors.  
The new engraving fonts are all based on fonts which are licensed
under the SIL Open Font License. 
shel at shel dot net

-------------------------------------------------------------------
The Hershey Fonts are a set of vector fonts with a liberal license. 

USE RESTRICTION:
	This distribution of the Hershey Fonts may be used by anyone for
	any purpose, commercial or otherwise, providing that:
		1. The following acknowledgements must be distributed with
			the font data:
			- The Hershey Fonts were originally created by Dr.
				A. V. Hershey while working at the U. S.
				National Bureau of Standards.
			- The format of the Font data in this distribution
				was originally created by
					James Hurt
					Cognition, Inc.
					900 Technology Park Drive
					Billerica, MA 01821
					(mit-eddie!ci-dandelion!hurt)
		2. The font data in this distribution may be converted into
			any other format *EXCEPT* the format distributed by
			the U.S. NTIS (which organization holds the rights
			to the distribution and use of the font data in that
			particular format). Not that anybody would really
			*want* to use their format... each point is described
			in eight bytes as "xxx yyy:", where xxx and yyy are
			the coordinate values as ASCII numbers.
-------------------------------------------------------------------

Modern Engraving Fonts: EMS Series

These derivative fonts are licensed under the SIL Open Font License
( http://scripts.sil.org/OFL ). These derivative fonts have been
renamed to distinguish them from their sources. Links are provided
where possible to the designer or foundry and to the entry in
Google's list of open source fonts.


Engraving font name: 	EMS Allure	
A derivative of: 		Allura
Designer: 				Rob Leuschke, TypeSETit
Link:					http://www.typesetit.com
Google font page: 		https://fonts.google.com/specimen/Allura 

Engraving font name: 	EMS Bird	
A derivative of: 		Bilbo
Designer: 				Rob Leuschke, TypeSETit
Link:					http://www.typesetit.com
Google font page: 		https://fonts.google.com/specimen/Bilbo

Engraving font name: 	EMS Bird Swash Caps	
A derivative of: 		Bilbo Swash Caps
Designer: 				Rob Leuschke, TypeSETit
Link:					http://www.typesetit.com
Google font page: 		https://fonts.google.com/specimen/Bilbo+Swash+Caps

Engraving font name: 	EMS Brush	
A derivative of: 		Alex Brush
Designer: 				Rob Leuschke, TypeSETit
Link:					http://www.typesetit.com
Google font page: 		https://fonts.google.com/specimen/Alex+Brush 

Engraving font name: 	EMS Capitol	
A derivative of: 		Sacramento
Designer: 				Brian J. Bonislawsky, Astigmatic One Eye Typographic Institute 
Link:					http://www.astigmatic.com
Google font page: 		https://fonts.google.com/specimen/Sacramento 

Engraving font name: 	EMS Casual Hand	
A derivative of: 		Covered By Your Grace
Designer: 				Kimberly Geswein, Kimberly Geswein Fonts
Link: 					http://www.kimberlygeswein.com/
Google font page: 		https://fonts.google.com/specimen/Covered+By+Your+Grace 

Engraving font name: 	EMS Decorous Script
A derivative of: 		Petit Formal Script
Designer: 				Impallari Type
Google font page: 		https://fonts.google.com/specimen/Petit+Formal+Script

Engraving font name: 	EMS Delight	
A derivative of: 		Delius
Designer: 				Natalia Raices
Google font page: 		https://fonts.google.com/specimen/Delius 

Engraving font name: 	EMS Delight Swash Caps	
A derivative of: 		Delius Swash Caps
Designer: 				Natalia Raices
Google font page: 		https://fonts.google.com/specimen/Delius+Swash+Caps

Engraving font name: 	EMS Elfin
A derivative of: 		Mountains of Christmas
Designer: 				Crystal Kluge, Tart Workshop
Link: 					http://www.tartworkshop.com
Google font page: 		https://fonts.google.com/specimen/Mountains+of+Christmas 
Note: 					SIL OFL per metadata; Google cites Apache License, version 2.0

Engraving font name: 	EMS Felix
A derivative of: 		Felipa
Designer: 				Fontstage
Link: 					https://twitter.com/fontstage
Google font page: 		https://fonts.google.com/specimen/Felipa

Engraving font name: 	EMS Herculean
A derivative of: 		Poiret One
Designer: 				Denis Masharov
Link: 					https://www.myfonts.com/foundry/Denis_Masharov/
Google font page: 		https://fonts.google.com/specimen/Poiret+One 

Engraving font name: 	EMS Invite
A derivative of: 		Tangerine
Designer: 				Toshi Omagari
Link: 					http://tosche.net/about
Google font page: 		https://fonts.google.com/specimen/Tangerine 

Engraving font name: 	EMS League
A derivative of: 		League Script
Designer: 				Haley Fiege, the League of Moveable Type
Link: 					https://www.theleagueofmoveabletype.com
Google font page: 		https://fonts.google.com/specimen/League+Script 

Engraving font name: 	EMS Little Princess
A derivative of: 		Princess Sofia
Designer: 				Crystal Kluge, Tart Workshop
Link: 					http://www.tartworkshop.com
Google font page: 		https://fonts.google.com/specimen/Princess+Sofia 

Engraving font name: 	EMS Misty Night
A derivative of: 		Foglihten No03
Designer: 				Grzegorz L, GLUK fonts
Link: 					http://www.glukfonts.pl
FontSquirrel page: 		https://www.fontsquirrel.com/fonts/foglihten 

Engraving font name: 	EMS Neato
A derivative of: 		Bad Script
Designer: 				Roman Shchyukin, Gaslight
Link: 					https://www.myfonts.com/foundry/Gaslight/
Google font page: 		https://fonts.google.com/specimen/Bad+Script

Engraving font name: 	EMS Nixish
A derivative of: 		Nixie One
Designer: 				Jovanny Lemonad
Link: 					http://jovanny.ru
Google font page: 		https://fonts.google.com/specimen/Nixie+One

Engraving font name: 	EMS Nixish Italic
A derivative of: 		Nixie One
Designer: 				Jovanny Lemonad
Link: 					http://jovanny.ru
Google font page: 		https://fonts.google.com/specimen/Nixie+One

Engraving font name: 	EMS Osmotron
A derivative of: 		Orbitron (Regular)
Designer: 				Matt McInerney, the League of Moveable Type
Link: 					https://www.theleagueofmoveabletype.com
Google font page: 		https://fonts.google.com/specimen/Orbitron

Engraving font name: 	EMS Pancakes
A derivative of: 		Short Stack
Designer: 				James Grieshaber, Typeco
Link: 					http://www.typeco.com
Google font page: 		https://fonts.google.com/specimen/Short+Stack

Engraving font name: 	EMS Pepita
A derivative of: 		Pecita
Designer: 				Philippe Cochy
Link: 					http://pecita.eu/police-en.php
FontSquirrel page: 		https://www.fontsquirrel.com/fonts/Pecita

Engraving font name: 	EMS Qwandry
A derivative of: 		Qwigley
Designer: 				Rob Leuschke, TypeSETit
Link:					http://www.typesetit.com
Google font page: 		https://fonts.google.com/specimen/Qwigley

Engraving font name: 	EMS Readability
A derivative of: 		Source Sans Pro-Light
Designer: 				Paul D. Hunt, Adobe
Link:					http://www.adobe.com
Google font page: 		https://fonts.google.com/specimen/Source+Sans+Pro

Engraving font name: 	EMS Readability Italic
A derivative of: 		Source Sans Pro-Light
Designer: 				Paul D. Hunt, Adobe
Link:					http://www.adobe.com
Google font page: 		https://fonts.google.com/specimen/Source+Sans+Pro

Engraving font name: 	EMS Society
A derivative of: 		Mrs Saint Delafield
Designer: 				Alejandro Paul, Sudtipos
Link: 					http://www.sudtipos.com
Google font page: 		https://fonts.google.com/specimen/Mrs+Saint+Delafield

Engraving font name: 	EMS Swiss
A derivative of: 		Italianno
Designer: 				Rob Leuschke, TypeSETit
Link:					http://www.typesetit.com
Google font page: 		https://fonts.google.com/specimen/Italianno 

Engraving font name: 	EMS Tech
A derivative of: 		Architects Daughter
Designer: 				Kimberly Geswein, Kimberly Geswein Fonts
Link: 					http://www.kimberlygeswein.com/			
Google font page: 		https://fonts.google.com/specimen/Architects+Daughter


-------------------------------------------------------------------

'''

astrology = ["-8 8","-12 12 M -8 -10 L -4 -8 L -2 -6 L -1 -3 L -1 0 L -2 3 L -4 5 L -8 7 M -8 -10 L -5 -9 L -3 -8 L -1 -6 L 0 -3 M 0 0 L -1 3 L -3 5 L -5 6 L -8 7 M 8 -10 L 5 -9 L 3 -8 L 1 -6 L 0 -3 M 0 0 L 1 3 L 3 5 L 5 6 L 8 7 M 8 -10 L 4 -8 L 2 -6 L 1 -3 L 1 0 L 2 3 L 4 5 L 8 7 M -9 -2 L 9 -2 M -9 -1 L 9 -1","-9 9 M -4 -12 L -5 -11 L -5 -5 M -4 -11 L -5 -5 M -4 -12 L -3 -11 L -5 -5 M 5 -12 L 4 -11 L 4 -5 M 5 -11 L 4 -5 M 5 -12 L 6 -11 L 4 -5","-13 14 M -1 -12 L -4 -11 L -7 -9 L -9 -6 L -10 -3 L -10 0 L -9 3 L -7 6 L -4 8 L -1 9 L 2 9 L 5 8 L 8 6 L 10 3 L 11 0 L 11 -3 L 10 -6 L 8 -9 L 5 -11 L 2 -12 L -1 -12 M 0 -3 L -1 -2 L -1 -1 L 0 0 L 1 0 L 2 -1 L 2 -2 L 1 -3 L 0 -3 M 0 -2 L 0 -1 L 1 -1 L 1 -2 L 0 -2","-8 9 M -2 -12 L -4 -11 L -3 -9 L -1 -8 M -2 -12 L -3 -11 L -3 -9 M 3 -12 L 5 -11 L 4 -9 L 2 -8 M 3 -12 L 4 -11 L 4 -9 M -1 -8 L -3 -7 L -4 -6 L -5 -4 L -5 -1 L -4 1 L -3 2 L -1 3 L 2 3 L 4 2 L 5 1 L 6 -1 L 6 -4 L 5 -6 L 4 -7 L 2 -8 L -1 -8 M 0 3 L 0 9 M 1 3 L 1 9 M -4 6 L 5 6","-9 10 M 0 -12 L -3 -11 L -5 -9 L -6 -6 L -6 -5 L -5 -2 L -3 0 L 0 1 L 1 1 L 4 0 L 6 -2 L 7 -5 L 7 -6 L 6 -9 L 4 -11 L 1 -12 L 0 -12 M 0 1 L 0 9 M 1 1 L 1 9 M -4 5 L 5 5","-14 14 M -2 -12 L -5 -11 L -8 -9 L -10 -6 L -11 -3 L -11 1 L -10 4 L -8 7 L -5 9 L -2 10 L 2 10 L 5 9 L 8 7 L 10 4 L 11 1 L 11 -3 L 10 -6 L 8 -9 L 5 -11 L 2 -12 L -2 -12 M 0 -12 L 0 10 M -11 -1 L 11 -1","-11 14 M -2 -5 L -5 -4 L -7 -2 L -8 1 L -8 2 L -7 5 L -5 7 L -2 8 L -1 8 L 2 7 L 4 5 L 5 2 L 5 1 L 4 -2 L 2 -4 L -1 -5 L -2 -5 M 11 -11 L 5 -11 L 9 -10 L 3 -4 M 11 -11 L 11 -5 L 10 -9 L 4 -3 M 10 -10 L 4 -4","-7 7 M 4 -16 L 2 -14 L 0 -11 L -2 -7 L -3 -2 L -3 2 L -2 7 L 0 11 L 2 14 L 4 16 M 2 -14 L 0 -10 L -1 -7 L -2 -2 L -2 2 L -1 7 L 0 10 L 2 14","-7 7 M -4 -16 L -2 -14 L 0 -11 L 2 -7 L 3 -2 L 3 2 L 2 7 L 0 11 L -2 14 L -4 16 M -2 -14 L 0 -10 L 1 -7 L 2 -2 L 2 2 L 1 7 L 0 10 L -2 14","-12 10 M -9 -9 L -8 -11 L -6 -12 L -3 -12 L -1 -11 L 0 -9 L 0 -6 L -1 -3 L -2 -1 L -4 1 L -7 3 M -3 -12 L -2 -11 L -1 -9 L -1 -5 L -2 -2 L -4 1 M 4 -12 L 2 9 M 5 -12 L 1 9 M -7 3 L 7 3","-9 10 M -5 -12 L -5 3 M -4 -12 L -5 -1 M -5 -1 L -4 -3 L -3 -4 L -1 -5 L 2 -5 L 5 -4 L 6 -2 L 6 0 L 5 2 L 3 4 M 2 -5 L 4 -4 L 5 -2 L 5 0 L 2 6 L 2 8 L 3 9 L 5 9 L 7 7 M -7 -12 L -4 -12","-4 4 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-9 10 M 0 -4 L -3 -3 L -5 -1 L -6 2 L -6 3 L -5 6 L -3 8 L 0 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 M 0 -10 L -4 -8 L 0 -12 L 0 -4 M 1 -10 L 5 -8 L 1 -12 L 1 -4 M 0 1 L -1 2 L -1 3 L 0 4 L 1 4 L 2 3 L 2 2 L 1 1 L 0 1 M 0 2 L 0 3 L 1 3 L 1 2 L 0 2","-4 4 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-11 12 M -1 -10 L 0 -12 L 0 9 M 2 -10 L 1 -12 L 1 9 M -8 -10 L -7 -12 L -7 -5 L -6 -2 L -4 0 L -1 1 L 0 1 M -5 -10 L -6 -12 L -6 -4 L -5 -1 M 9 -10 L 8 -12 L 8 -5 L 7 -2 L 5 0 L 2 1 L 1 1 M 6 -10 L 7 -12 L 7 -4 L 6 -1 M -4 5 L 5 5","-10 11 M 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 8 -4 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 2 -12 M -1 -10 L -3 -8 L -4 -6 L -5 -3 L -6 1 L -6 5 L -5 7 M 2 7 L 4 5 L 5 3 L 6 0 L 7 -4 L 7 -8 L 6 -10 M 2 -12 L 0 -11 L -2 -8 L -3 -6 L -4 -3 L -5 1 L -5 6 L -4 8 L -3 9 M -1 9 L 1 8 L 3 5 L 4 3 L 5 0 L 6 -4 L 6 -9 L 5 -11 L 4 -12","-10 11 M 2 -8 L -3 9 L -1 9 M 5 -12 L 3 -8 L -2 9 M 5 -12 L -1 9 M 5 -12 L 2 -9 L -1 -7 L -3 -6 M 2 -8 L 0 -7 L -3 -6","-10 11 M -3 -7 L -3 -8 L -2 -8 L -2 -6 L -4 -6 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 4 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 5 -3 L -5 3 L -7 5 L -9 9 M 6 -11 L 7 -9 L 7 -7 L 6 -5 L 4 -3 L 1 -1 M 4 -12 L 5 -11 L 6 -9 L 6 -7 L 5 -5 L 3 -3 L -5 3 M -8 7 L -7 6 L -5 6 L 0 7 L 5 7 L 6 6 M -5 6 L 0 8 L 5 8 M -5 6 L 0 9 L 3 9 L 5 8 L 6 6 L 6 5","-10 11 M -3 -7 L -3 -8 L -2 -8 L -2 -6 L -4 -6 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 4 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 6 -4 L 4 -3 L 1 -2 M 6 -11 L 7 -9 L 7 -7 L 6 -5 L 5 -4 M 4 -12 L 5 -11 L 6 -9 L 6 -7 L 5 -5 L 3 -3 L 1 -2 M -1 -2 L 1 -2 L 4 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 3 8 L 0 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 3 L -6 3 L -6 5 L -7 5 L -7 4 M 4 0 L 5 2 L 5 5 L 4 7 M 1 -2 L 3 -1 L 4 1 L 4 5 L 3 7 L 2 8 L 0 9","-10 11 M 5 -8 L 0 9 L 2 9 M 8 -12 L 6 -8 L 1 9 M 8 -12 L 2 9 M 8 -12 L -8 3 L 8 3","-10 11 M -1 -12 L -6 -2 M -1 -12 L 9 -12 M -1 -11 L 7 -11 M -2 -10 L 3 -10 L 7 -11 L 9 -12 M -6 -2 L -5 -3 L -2 -4 L 1 -4 L 4 -3 L 5 -2 L 6 0 L 6 3 L 5 6 L 3 8 L -1 9 L -4 9 L -6 8 L -7 7 L -8 5 L -8 3 L -6 3 L -6 5 L -7 5 L -7 4 M 4 -2 L 5 0 L 5 3 L 4 6 L 2 8 M 1 -4 L 3 -3 L 4 -1 L 4 3 L 3 6 L 1 8 L -1 9","-10 11 M 7 -8 L 7 -9 L 6 -9 L 6 -7 L 8 -7 L 8 -9 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -3 9 L 0 9 L 3 8 L 5 6 L 6 4 L 6 1 L 5 -1 L 4 -2 L 2 -3 L -1 -3 L -3 -2 L -4 -1 L -5 1 M -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 5 L -5 7 M 4 6 L 5 4 L 5 1 L 4 -1 M 2 -12 L 0 -11 L -2 -8 L -3 -6 L -4 -3 L -5 1 L -5 6 L -4 8 L -3 9 M 0 9 L 2 8 L 3 7 L 4 4 L 4 0 L 3 -2 L 2 -3","-10 11 M -4 -12 L -6 -6 M 9 -12 L 8 -9 L 6 -6 L 2 -1 L 0 2 L -1 5 L -2 9 M 0 1 L -2 5 L -3 9 M 6 -6 L 0 0 L -2 3 L -3 5 L -4 9 L -2 9 M -5 -9 L -2 -12 L 0 -12 L 5 -9 M -3 -11 L 0 -11 L 5 -9 M -5 -9 L -3 -10 L 0 -10 L 5 -9 L 7 -9 L 8 -10 L 9 -12","-10 11 M 1 -12 L -2 -11 L -3 -10 L -4 -8 L -4 -5 L -3 -3 L -1 -2 L 2 -2 L 5 -3 L 7 -4 L 8 -6 L 8 -9 L 7 -11 L 5 -12 L 1 -12 M 3 -12 L -2 -11 M -2 -10 L -3 -8 L -3 -4 L -2 -3 M -3 -3 L 0 -2 M 1 -2 L 5 -3 M 6 -4 L 7 -6 L 7 -9 L 6 -11 M 7 -11 L 3 -12 M 1 -12 L -1 -10 L -2 -8 L -2 -4 L -1 -2 M 2 -2 L 4 -3 L 5 -4 L 6 -6 L 6 -10 L 5 -12 M -1 -2 L -5 -1 L -7 1 L -8 3 L -8 6 L -7 8 L -4 9 L 0 9 L 4 8 L 5 7 L 6 5 L 6 2 L 5 0 L 4 -1 L 2 -2 M 0 -2 L -5 -1 M -4 -1 L -6 1 L -7 3 L -7 6 L -6 8 M -7 8 L -2 9 L 4 8 M 4 7 L 5 5 L 5 2 L 4 0 M 4 -1 L 1 -2 M -1 -2 L -3 -1 L -5 1 L -6 3 L -6 6 L -5 8 L -4 9 M 0 9 L 2 8 L 3 7 L 4 5 L 4 1 L 3 -1 L 2 -2","-10 11 M 6 -4 L 5 -2 L 4 -1 L 2 0 L -1 0 L -3 -1 L -4 -2 L -5 -4 L -5 -7 L -4 -9 L -2 -11 L 1 -12 L 4 -12 L 6 -11 L 7 -10 L 8 -7 L 8 -4 L 7 0 L 6 3 L 4 6 L 2 8 L -1 9 L -4 9 L -6 8 L -7 6 L -7 4 L -5 4 L -5 6 L -6 6 L -6 5 M -3 -2 L -4 -4 L -4 -7 L -3 -9 M 6 -10 L 7 -8 L 7 -4 L 6 0 L 5 3 L 3 6 M -1 0 L -2 -1 L -3 -3 L -3 -7 L -2 -10 L -1 -11 L 1 -12 M 4 -12 L 5 -11 L 6 -9 L 6 -4 L 5 0 L 4 3 L 3 5 L 1 8 L -1 9","-11 11 M -6 -12 L -6 9 M -5 -12 L -5 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -5 L 7 -3 L 6 -2 L 3 -1 L -5 -1 M 3 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -5 L 6 -3 L 5 -2 L 3 -1 M -9 9 L 7 9 L 7 4 L 6 9","-10 9 M 7 -11 L 3 -11 L -1 -10 L -4 -8 L -6 -5 L -7 -2 L -7 1 L -6 4 L -4 7 L -1 9 L 3 10 L 7 10 M 7 -11 L 4 -10 L 1 -8 L -1 -5 L -2 -2 L -2 1 L -1 4 L 1 7 L 4 9 L 7 10","-12 13 M -3 -1 L -5 -1 L -7 0 L -8 1 L -9 3 L -9 5 L -8 7 L -7 8 L -5 9 L -3 9 L -1 8 L 0 7 L 1 5 L 1 3 L 0 1 L -1 0 L -3 -1 M 1 -10 L -2 -1 M 8 -8 L 0 0 M 10 -1 L 1 2","-10 10 M -3 -7 L 3 7 M 3 -7 L -3 7 M -7 -3 L 7 3 M 7 -3 L -7 3","-12 12 M -4 4 L -6 3 L -7 3 L -9 4 L -10 6 L -10 7 L -9 9 L -7 10 L -6 10 L -4 9 L -3 7 L -3 6 L -4 4 L -7 0 L -8 -3 L -8 -5 L -7 -8 L -5 -10 L -2 -11 L 2 -11 L 5 -10 L 7 -8 L 8 -5 L 8 -3 L 7 0 L 4 4 L 3 6 L 3 7 L 4 9 L 6 10 L 7 10 L 9 9 L 10 7 L 10 6 L 9 4 L 7 3 L 6 3 L 4 4 M -8 -5 L -7 -7 L -5 -9 L -2 -10 L 2 -10 L 5 -9 L 7 -7 L 8 -5","-12 12 M -4 -5 L -6 -4 L -7 -4 L -9 -5 L -10 -7 L -10 -8 L -9 -10 L -7 -11 L -6 -11 L -4 -10 L -3 -8 L -3 -7 L -4 -5 L -7 -1 L -8 2 L -8 4 L -7 7 L -5 9 L -2 10 L 2 10 L 5 9 L 7 7 L 8 4 L 8 2 L 7 -1 L 4 -5 L 3 -7 L 3 -8 L 4 -10 L 6 -11 L 7 -11 L 9 -10 L 10 -8 L 10 -7 L 9 -5 L 7 -4 L 6 -4 L 4 -5 M -8 4 L -7 6 L -5 8 L -2 9 L 2 9 L 5 8 L 7 6 L 8 4","-12 13 M -8 -5 L -9 -6 L -9 -8 L -8 -10 L -6 -11 L -4 -11 L -2 -10 L -1 -9 L 0 -7 L 1 -2 M -9 -8 L -7 -10 L -5 -10 L -3 -9 L -2 -8 L -1 -6 L 0 -2 L 0 9 M 9 -5 L 10 -6 L 10 -8 L 9 -10 L 7 -11 L 5 -11 L 3 -10 L 2 -9 L 1 -7 L 0 -2 M 10 -8 L 8 -10 L 6 -10 L 4 -9 L 3 -8 L 2 -6 L 1 -2 L 1 9","-10 10 M 0 -12 L -7 8 M -1 -9 L 5 9 M 0 -9 L 6 9 M 0 -12 L 7 9 M -5 3 L 4 3 M -9 9 L -3 9 M 2 9 L 9 9 M -7 8 L -8 9 M -7 8 L -5 9 M 5 8 L 3 9 M 5 7 L 4 9 M 6 7 L 8 9","-11 11 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -6 L 7 -4 L 6 -3 L 3 -2 M 6 -10 L 7 -8 L 7 -6 L 6 -4 M 3 -12 L 5 -11 L 6 -9 L 6 -5 L 5 -3 L 3 -2 M -4 -2 L 3 -2 L 6 -1 L 7 0 L 8 2 L 8 5 L 7 7 L 6 8 L 3 9 L -9 9 M 6 0 L 7 2 L 7 5 L 6 7 M 3 -2 L 5 -1 L 6 1 L 6 6 L 5 8 L 3 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9","-11 10 M 6 -9 L 7 -12 L 7 -6 L 6 -9 L 4 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -1 9 L 2 9 L 4 8 L 6 6 L 7 4 M -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 M -1 -12 L -3 -11 L -5 -8 L -6 -4 L -6 1 L -5 5 L -3 8 L -1 9","-11 11 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -7 L 8 -4 L 8 1 L 7 4 L 6 6 L 4 8 L 1 9 L -9 9 M 5 -9 L 6 -7 L 7 -4 L 7 1 L 6 4 L 5 6 M 1 -12 L 3 -11 L 5 -8 L 6 -4 L 6 1 L 5 5 L 3 8 L 1 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9","-11 10 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 7 -12 L 7 -6 M -4 -2 L 2 -2 M 2 -6 L 2 2 M -9 9 L 7 9 L 7 3 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M 2 -12 L 7 -11 M 4 -12 L 7 -10 M 5 -12 L 7 -9 M 6 -12 L 7 -6 M 2 -6 L 1 -2 L 2 2 M 2 -4 L 0 -2 L 2 0 M 2 -3 L -2 -2 L 2 -1 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9 M 2 9 L 7 8 M 4 9 L 7 7 M 5 9 L 7 6 M 6 9 L 7 3","-11 9 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 7 -12 L 7 -6 M -4 -2 L 2 -2 M 2 -6 L 2 2 M -9 9 L -1 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M 2 -12 L 7 -11 M 4 -12 L 7 -10 M 5 -12 L 7 -9 M 6 -12 L 7 -6 M 2 -6 L 1 -2 L 2 2 M 2 -4 L 0 -2 L 2 0 M 2 -3 L -2 -2 L 2 -1 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9","-11 12 M 6 -9 L 7 -12 L 7 -6 L 6 -9 L 4 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -1 9 L 2 9 L 4 8 L 6 8 L 7 9 L 7 1 M -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 M -1 -12 L -3 -11 L -5 -8 L -6 -4 L -6 1 L -5 5 L -3 8 L -1 9 M 6 2 L 6 7 M 5 1 L 5 7 L 4 8 M 2 1 L 10 1 M 3 1 L 5 2 M 4 1 L 5 3 M 8 1 L 7 3 M 9 1 L 7 2","-12 12 M -7 -12 L -7 9 M -6 -11 L -6 8 M -5 -12 L -5 9 M 5 -12 L 5 9 M 6 -11 L 6 8 M 7 -12 L 7 9 M -10 -12 L -2 -12 M 2 -12 L 10 -12 M -5 -2 L 5 -2 M -10 9 L -2 9 M 2 9 L 10 9 M -9 -12 L -7 -11 M -8 -12 L -7 -10 M -4 -12 L -5 -10 M -3 -12 L -5 -11 M 3 -12 L 5 -11 M 4 -12 L 5 -10 M 8 -12 L 7 -10 M 9 -12 L 7 -11 M -7 8 L -9 9 M -7 7 L -8 9 M -5 7 L -4 9 M -5 8 L -3 9 M 5 8 L 3 9 M 5 7 L 4 9 M 7 7 L 8 9 M 7 8 L 9 9","-6 6 M -1 -12 L -1 9 M 0 -11 L 0 8 M 1 -12 L 1 9 M -4 -12 L 4 -12 M -4 9 L 4 9 M -3 -12 L -1 -11 M -2 -12 L -1 -10 M 2 -12 L 1 -10 M 3 -12 L 1 -11 M -1 8 L -3 9 M -1 7 L -2 9 M 1 7 L 2 9 M 1 8 L 3 9","-8 8 M 1 -12 L 1 5 L 0 8 L -1 9 M 2 -11 L 2 5 L 1 8 M 3 -12 L 3 5 L 2 8 L -1 9 L -3 9 L -5 8 L -6 6 L -6 4 L -5 3 L -4 3 L -3 4 L -3 5 L -4 6 L -5 6 M -5 4 L -5 5 L -4 5 L -4 4 L -5 4 M -2 -12 L 6 -12 M -1 -12 L 1 -11 M 0 -12 L 1 -10 M 4 -12 L 3 -10 M 5 -12 L 3 -11","-12 10 M -7 -12 L -7 9 M -6 -11 L -6 8 M -5 -12 L -5 9 M 6 -11 L -5 0 M -2 -2 L 5 9 M -1 -2 L 6 9 M -1 -4 L 7 9 M -10 -12 L -2 -12 M 3 -12 L 9 -12 M -10 9 L -2 9 M 2 9 L 9 9 M -9 -12 L -7 -11 M -8 -12 L -7 -10 M -4 -12 L -5 -10 M -3 -12 L -5 -11 M 5 -12 L 6 -11 M 8 -12 L 6 -11 M -7 8 L -9 9 M -7 7 L -8 9 M -5 7 L -4 9 M -5 8 L -3 9 M 5 7 L 3 9 M 5 7 L 8 9","-9 9 M -4 -12 L -4 9 M -3 -11 L -3 8 M -2 -12 L -2 9 M -7 -12 L 1 -12 M -7 9 L 8 9 L 8 3 M -6 -12 L -4 -11 M -5 -12 L -4 -10 M -1 -12 L -2 -10 M 0 -12 L -2 -11 M -4 8 L -6 9 M -4 7 L -5 9 M -2 7 L -1 9 M -2 8 L 0 9 M 3 9 L 8 8 M 5 9 L 8 7 M 6 9 L 8 6 M 7 9 L 8 3","-13 13 M -8 -12 L -8 8 M -8 -12 L -1 9 M -7 -12 L -1 6 M -6 -12 L 0 6 M 6 -12 L -1 9 M 6 -12 L 6 9 M 7 -11 L 7 8 M 8 -12 L 8 9 M -11 -12 L -6 -12 M 6 -12 L 11 -12 M -11 9 L -5 9 M 3 9 L 11 9 M -10 -12 L -8 -11 M 9 -12 L 8 -10 M 10 -12 L 8 -11 M -8 8 L -10 9 M -8 8 L -6 9 M 6 8 L 4 9 M 6 7 L 5 9 M 8 7 L 9 9 M 8 8 L 10 9","-12 12 M -7 -12 L -7 8 M -7 -12 L 7 9 M -6 -12 L 6 6 M -5 -12 L 7 6 M 7 -11 L 7 9 M -10 -12 L -5 -12 M 4 -12 L 10 -12 M -10 9 L -4 9 M -9 -12 L -7 -11 M 5 -12 L 7 -11 M 9 -12 L 7 -11 M -7 8 L -9 9 M -7 8 L -5 9","-11 11 M -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -3 L -8 0 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 4 L 8 0 L 8 -3 L 7 -7 L 6 -9 L 4 -11 L 1 -12 L -1 -12 M -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 M 5 6 L 6 4 L 7 1 L 7 -4 L 6 -7 L 5 -9 M -1 -12 L -3 -11 L -5 -8 L -6 -4 L -6 1 L -5 5 L -3 8 L -1 9 M 1 9 L 3 8 L 5 5 L 6 1 L 6 -4 L 5 -8 L 3 -11 L 1 -12","-11 11 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -5 L 7 -3 L 6 -2 L 3 -1 L -4 -1 M 6 -10 L 7 -8 L 7 -5 L 6 -3 M 3 -12 L 5 -11 L 6 -9 L 6 -4 L 5 -2 L 3 -1 M -9 9 L -1 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9","-11 11 M -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -3 L -8 0 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 4 L 8 0 L 8 -3 L 7 -7 L 6 -9 L 4 -11 L 1 -12 L -1 -12 M -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 M 5 6 L 6 4 L 7 1 L 7 -4 L 6 -7 L 5 -9 M -1 -12 L -3 -11 L -5 -8 L -6 -4 L -6 1 L -5 5 L -3 8 L -1 9 M 1 9 L 3 8 L 5 5 L 6 1 L 6 -4 L 5 -8 L 3 -11 L 1 -12 M -4 6 L -3 4 L -1 3 L 0 3 L 2 4 L 3 6 L 4 12 L 5 14 L 7 14 L 8 12 L 8 10 M 4 10 L 5 12 L 6 13 L 7 13 M 3 6 L 5 11 L 6 12 L 7 12 L 8 11","-11 11 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -6 L 7 -4 L 6 -3 L 3 -2 L -4 -2 M 6 -10 L 7 -8 L 7 -6 L 6 -4 M 3 -12 L 5 -11 L 6 -9 L 6 -5 L 5 -3 L 3 -2 M 0 -2 L 2 -1 L 3 1 L 5 7 L 6 9 L 8 9 L 9 7 L 9 5 M 5 5 L 6 7 L 7 8 L 8 8 M 2 -1 L 3 0 L 6 6 L 7 7 L 8 7 L 9 6 M -9 9 L -1 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9","-10 10 M 6 -9 L 7 -12 L 7 -6 L 6 -9 L 4 -11 L 1 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -6 L -6 -4 L -3 -2 L 3 0 L 5 1 L 6 3 L 6 6 L 5 8 M -6 -6 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 2 M -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 3 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -1 9 L -4 8 L -6 6 L -7 3 L -7 9 L -6 6","-10 10 M -8 -12 L -8 -6 M -1 -12 L -1 9 M 0 -11 L 0 8 M 1 -12 L 1 9 M 8 -12 L 8 -6 M -8 -12 L 8 -12 M -4 9 L 4 9 M -7 -12 L -8 -6 M -6 -12 L -8 -9 M -5 -12 L -8 -10 M -3 -12 L -8 -11 M 3 -12 L 8 -11 M 5 -12 L 8 -10 M 6 -12 L 8 -9 M 7 -12 L 8 -6 M -1 8 L -3 9 M -1 7 L -2 9 M 1 7 L 2 9 M 1 8 L 3 9","-12 12 M -7 -12 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 -11 M -6 -11 L -6 4 L -5 6 M -5 -12 L -5 4 L -4 7 L -3 8 L -1 9 M -10 -12 L -2 -12 M 4 -12 L 10 -12 M -9 -12 L -7 -11 M -8 -12 L -7 -10 M -4 -12 L -5 -10 M -3 -12 L -5 -11 M 5 -12 L 7 -11 M 9 -12 L 7 -11","-10 10 M -7 -12 L 0 9 M -6 -12 L 0 6 L 0 9 M -5 -12 L 1 6 M 7 -11 L 0 9 M -9 -12 L -2 -12 M 3 -12 L 9 -12 M -8 -12 L -6 -10 M -4 -12 L -5 -10 M -3 -12 L -5 -11 M 5 -12 L 7 -11 M 8 -12 L 7 -11","-12 12 M -8 -12 L -4 9 M -7 -12 L -4 4 L -4 9 M -6 -12 L -3 4 M 0 -12 L -3 4 L -4 9 M 0 -12 L 4 9 M 1 -12 L 4 4 L 4 9 M 2 -12 L 5 4 M 8 -11 L 5 4 L 4 9 M -11 -12 L -3 -12 M 0 -12 L 2 -12 M 5 -12 L 11 -12 M -10 -12 L -7 -11 M -9 -12 L -7 -10 M -5 -12 L -6 -10 M -4 -12 L -6 -11 M 6 -12 L 8 -11 M 10 -12 L 8 -11","-10 10 M -7 -12 L 5 9 M -6 -12 L 6 9 M -5 -12 L 7 9 M 6 -11 L -6 8 M -9 -12 L -2 -12 M 3 -12 L 9 -12 M -9 9 L -3 9 M 2 9 L 9 9 M -8 -12 L -5 -10 M -4 -12 L -5 -10 M -3 -12 L -5 -11 M 4 -12 L 6 -11 M 8 -12 L 6 -11 M -6 8 L -8 9 M -6 8 L -4 9 M 5 8 L 3 9 M 5 7 L 4 9 M 5 7 L 8 9","-11 11 M -8 -12 L -1 -1 L -1 9 M -7 -12 L 0 -1 L 0 8 M -6 -12 L 1 -1 L 1 9 M 7 -11 L 1 -1 M -10 -12 L -3 -12 M 4 -12 L 10 -12 M -4 9 L 4 9 M -9 -12 L -7 -11 M -4 -12 L -6 -11 M 5 -12 L 7 -11 M 9 -12 L 7 -11 M -1 8 L -3 9 M -1 7 L -2 9 M 1 7 L 2 9 M 1 8 L 3 9","-10 10 M 7 -12 L -7 -12 L -7 -6 M 5 -12 L -7 9 M 6 -12 L -6 9 M 7 -12 L -5 9 M -7 9 L 7 9 L 7 3 M -6 -12 L -7 -6 M -5 -12 L -7 -9 M -4 -12 L -7 -10 M -2 -12 L -7 -11 M 2 9 L 7 8 M 4 9 L 7 7 M 5 9 L 7 6 M 6 9 L 7 3","-12 12 M -9 -11 L -8 -7 L -7 -5 L -5 -3 L -2 -2 L 2 -2 L 5 -3 L 7 -5 L 8 -7 L 9 -11 M -9 -11 L -8 -8 L -7 -6 L -5 -4 L -2 -3 L 2 -3 L 5 -4 L 7 -6 L 8 -8 L 9 -11 M -2 -3 L -4 -2 L -5 -1 L -6 1 L -6 4 L -5 6 L -3 8 L -1 9 L 1 9 L 3 8 L 5 6 L 6 4 L 6 1 L 5 -1 L 4 -2 L 2 -3 M -2 -2 L -4 -1 L -5 1 L -5 4 L -4 7 M 4 7 L 5 4 L 5 1 L 4 -1 L 2 -2","-7 7 M -7 -12 L 7 12","-12 12 M -5 -8 L -5 4 M -4 -7 L -4 3 M 4 -7 L 4 3 M 5 -8 L 5 4 M -9 -11 L -7 -9 L -5 -8 L -2 -7 L 2 -7 L 5 -8 L 7 -9 L 9 -11 M -9 7 L -7 5 L -5 4 L -2 3 L 2 3 L 5 4 L 7 5 L 9 7","-12 12 M 9 -9 L -6 -9 L -8 -8 L -9 -6 L -9 -4 L -8 -2 L -6 -1 L -4 -1 L -2 -2 L -1 -4 L -1 -6 L -2 -8 L 9 -8 M -9 -5 L -8 -3 L -7 -2 L -5 -1 M -1 -5 L -2 -7 L -3 -8 L -5 -9 M -9 6 L 6 6 L 8 5 L 9 3 L 9 1 L 8 -1 L 6 -2 L 4 -2 L 2 -1 L 1 1 L 1 3 L 2 5 L -9 5 M 9 2 L 8 0 L 7 -1 L 5 -2 M 1 2 L 2 4 L 3 5 L 5 6","-12 11 M -3 3 L -5 2 L -6 2 L -8 3 L -9 5 L -9 6 L -8 8 L -6 9 L -5 9 L -3 8 L -2 6 L -2 5 L -3 3 L -8 -2 L -9 -4 L -9 -7 L -8 -9 L -6 -10 L -3 -11 L 1 -11 L 5 -10 L 7 -8 L 8 -6 L 8 -3 L 7 0 L 4 3 L 3 5 L 3 7 L 4 9 L 6 9 L 7 8 L 8 6 M -5 1 L -7 -2 L -8 -4 L -8 -7 L -7 -9 L -6 -10 M 1 -11 L 4 -10 L 6 -8 L 7 -6 L 7 -3 L 6 0 L 4 3","-11 13 M -10 -7 L -7 -10 L -5 -7 L -5 4 M -8 -9 L -6 -6 L -6 4 M -5 -7 L -2 -10 L 0 -7 L 0 3 M -3 -9 L -1 -6 L -1 3 M 0 -7 L 3 -10 L 5 -7 L 5 9 M 2 -9 L 4 -6 L 4 9 M 5 -7 L 8 -10 L 9 -8 L 10 -5 L 10 -2 L 9 1 L 8 3 L 6 5 L 3 7 L -2 9 M 7 -9 L 8 -8 L 9 -5 L 9 -2 L 8 1 L 7 3 L 5 5 L 2 7 L -2 9","-11 11 M 5 -5 L 3 2 L 3 6 L 4 8 L 5 9 L 7 9 L 9 7 L 10 5 M 6 -5 L 4 2 L 4 8 M 5 -5 L 7 -5 L 5 2 L 4 6 M 3 2 L 3 -1 L 2 -4 L 0 -5 L -2 -5 L -5 -4 L -7 -1 L -8 2 L -8 4 L -7 7 L -6 8 L -4 9 L -2 9 L 0 8 L 1 7 L 2 5 L 3 2 M -4 -4 L -6 -1 L -7 2 L -7 5 L -6 7 M -2 -5 L -4 -3 L -5 -1 L -6 2 L -6 5 L -5 8 L -4 9","-9 10 M -2 -12 L -4 -5 L -5 1 L -5 5 L -4 7 L -3 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 2 L 7 0 L 6 -3 L 5 -4 L 3 -5 L 1 -5 L -1 -4 L -2 -3 L -3 -1 L -4 2 M -1 -12 L -3 -5 L -4 -1 L -4 5 L -3 8 M 4 7 L 5 5 L 6 2 L 6 -1 L 5 -3 M -5 -12 L 0 -12 L -2 -5 L -4 2 M 1 9 L 3 7 L 4 5 L 5 2 L 5 -1 L 4 -4 L 3 -5 M -4 -12 L -1 -11 M -3 -12 L -2 -10","-9 9 M 5 -1 L 5 -2 L 4 -2 L 4 0 L 6 0 L 6 -2 L 5 -4 L 3 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 4 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 5 M -3 -3 L -4 -1 L -5 2 L -5 5 L -4 7 M 0 -5 L -2 -3 L -3 -1 L -4 2 L -4 5 L -3 8 L -2 9","-11 11 M 7 -12 L 4 -1 L 3 3 L 3 6 L 4 8 L 5 9 L 7 9 L 9 7 L 10 5 M 8 -12 L 5 -1 L 4 3 L 4 8 M 4 -12 L 9 -12 L 5 2 L 4 6 M 3 2 L 3 -1 L 2 -4 L 0 -5 L -2 -5 L -5 -4 L -7 -1 L -8 2 L -8 4 L -7 7 L -6 8 L -4 9 L -2 9 L 0 8 L 1 7 L 2 5 L 3 2 M -5 -3 L -6 -1 L -7 2 L -7 5 L -6 7 M -2 -5 L -4 -3 L -5 -1 L -6 2 L -6 5 L -5 8 L -4 9 M 5 -12 L 8 -11 M 6 -12 L 7 -10","-9 9 M -5 4 L -1 3 L 2 2 L 5 0 L 6 -2 L 5 -4 L 3 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 4 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 6 M -3 -3 L -4 -1 L -5 2 L -5 5 L -4 7 M 0 -5 L -2 -3 L -3 -1 L -4 2 L -4 5 L -3 8 L -2 9","-8 8 M 8 -10 L 8 -11 L 7 -11 L 7 -9 L 9 -9 L 9 -11 L 8 -12 L 6 -12 L 4 -11 L 2 -9 L 1 -7 L 0 -4 L -1 0 L -3 9 L -4 12 L -5 14 L -7 16 M 2 -8 L 1 -5 L 0 0 L -2 9 L -3 12 M 6 -12 L 4 -10 L 3 -8 L 2 -5 L 1 0 L -1 8 L -2 11 L -3 13 L -5 15 L -7 16 L -9 16 L -10 15 L -10 13 L -8 13 L -8 15 L -9 15 L -9 14 M -4 -5 L 7 -5","-10 11 M 6 -5 L 2 9 L 1 12 L -1 15 L -3 16 M 7 -5 L 3 9 L 1 13 M 6 -5 L 8 -5 L 4 9 L 2 13 L 0 15 L -3 16 L -6 16 L -8 15 L -9 14 L -9 12 L -7 12 L -7 14 L -8 14 L -8 13 M 4 2 L 4 -1 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 2 7 L 3 5 L 4 2 M -4 -3 L -5 -1 L -6 2 L -6 5 L -5 7 M -1 -5 L -3 -3 L -4 -1 L -5 2 L -5 5 L -4 8 L -3 9","-11 11 M -3 -12 L -9 9 L -7 9 M -2 -12 L -8 9 M -6 -12 L -1 -12 L -7 9 M -5 2 L -3 -2 L -1 -4 L 1 -5 L 3 -5 L 5 -4 L 6 -2 L 6 1 L 4 6 M 5 -4 L 5 0 L 4 4 L 4 8 M 5 -2 L 3 3 L 3 6 L 4 8 L 5 9 L 7 9 L 9 7 L 10 5 M -5 -12 L -2 -11 M -4 -12 L -3 -10","-7 6 M 1 -12 L 1 -10 L 3 -10 L 3 -12 L 1 -12 M 2 -12 L 2 -10 M 1 -11 L 3 -11 M -6 -1 L -5 -3 L -3 -5 L -1 -5 L 0 -4 L 1 -2 L 1 1 L -1 6 M 0 -4 L 0 0 L -1 4 L -1 8 M 0 -2 L -2 3 L -2 6 L -1 8 L 0 9 L 2 9 L 4 7 L 5 5","-7 6 M 3 -12 L 3 -10 L 5 -10 L 5 -12 L 3 -12 M 4 -12 L 4 -10 M 3 -11 L 5 -11 M -5 -1 L -4 -3 L -2 -5 L 0 -5 L 1 -4 L 2 -2 L 2 1 L 0 8 L -1 11 L -2 13 L -4 15 L -6 16 L -8 16 L -9 15 L -9 13 L -7 13 L -7 15 L -8 15 L -8 14 M 1 -4 L 1 1 L -1 8 L -2 11 L -3 13 M 1 -2 L 0 2 L -2 9 L -3 12 L -4 14 L -6 16","-11 11 M -3 -12 L -9 9 L -7 9 M -2 -12 L -8 9 M -6 -12 L -1 -12 L -7 9 M 7 -3 L 7 -4 L 6 -4 L 6 -2 L 8 -2 L 8 -4 L 7 -5 L 5 -5 L 3 -4 L -1 0 L -3 1 M -5 1 L -3 1 L -1 2 L 0 3 L 2 7 L 3 8 L 5 8 M -1 3 L 1 7 L 2 8 M -3 1 L -2 2 L 0 8 L 1 9 L 3 9 L 5 8 L 7 5 M -5 -12 L -2 -11 M -4 -12 L -3 -10","-6 6 M 2 -12 L -1 -1 L -2 3 L -2 6 L -1 8 L 0 9 L 2 9 L 4 7 L 5 5 M 3 -12 L 0 -1 L -1 3 L -1 8 M -1 -12 L 4 -12 L 0 2 L -1 6 M 0 -12 L 3 -11 M 1 -12 L 2 -10","-18 17 M -17 -1 L -16 -3 L -14 -5 L -12 -5 L -11 -4 L -10 -2 L -10 1 L -12 9 M -11 -4 L -11 1 L -13 9 M -11 -2 L -12 2 L -14 9 L -12 9 M -10 1 L -8 -2 L -6 -4 L -4 -5 L -2 -5 L 0 -4 L 1 -2 L 1 1 L -1 9 M 0 -4 L 0 1 L -2 9 M 0 -2 L -1 2 L -3 9 L -1 9 M 1 1 L 3 -2 L 5 -4 L 7 -5 L 9 -5 L 11 -4 L 12 -2 L 12 1 L 10 6 M 11 -4 L 11 0 L 10 4 L 10 8 M 11 -2 L 9 3 L 9 6 L 10 8 L 11 9 L 13 9 L 15 7 L 16 5","-12 12 M -11 -1 L -10 -3 L -8 -5 L -6 -5 L -5 -4 L -4 -2 L -4 1 L -6 9 M -5 -4 L -5 1 L -7 9 M -5 -2 L -6 2 L -8 9 L -6 9 M -4 1 L -2 -2 L 0 -4 L 2 -5 L 4 -5 L 6 -4 L 7 -2 L 7 1 L 5 6 M 6 -4 L 6 0 L 5 4 L 5 8 M 6 -2 L 4 3 L 4 6 L 5 8 L 6 9 L 8 9 L 10 7 L 11 5","-10 10 M -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 4 L -6 7 L -5 8 L -2 9 L 1 9 L 4 8 L 6 5 L 7 2 L 7 0 L 6 -3 L 5 -4 L 2 -5 L -1 -5 M -4 -3 L -5 -1 L -6 2 L -6 5 L -5 7 M 4 7 L 5 5 L 6 2 L 6 -1 L 5 -3 M -1 -5 L -3 -3 L -4 -1 L -5 2 L -5 5 L -4 8 L -2 9 M 1 9 L 3 7 L 4 5 L 5 2 L 5 -1 L 4 -4 L 2 -5","-11 11 M -10 -1 L -9 -3 L -7 -5 L -5 -5 L -4 -4 L -3 -2 L -3 1 L -4 5 L -7 16 M -4 -4 L -4 1 L -5 5 L -8 16 M -4 -2 L -5 2 L -9 16 M -3 2 L -2 -1 L -1 -3 L 0 -4 L 2 -5 L 4 -5 L 6 -4 L 7 -3 L 8 0 L 8 2 L 7 5 L 5 8 L 2 9 L 0 9 L -2 8 L -3 5 L -3 2 M 6 -3 L 7 -1 L 7 2 L 6 5 L 5 7 M 4 -5 L 5 -4 L 6 -1 L 6 2 L 5 5 L 4 7 L 2 9 M -12 16 L -4 16 M -8 15 L -11 16 M -8 14 L -10 16 M -7 14 L -6 16 M -8 15 L -5 16","-11 10 M 5 -5 L -1 16 M 6 -5 L 0 16 M 5 -5 L 7 -5 L 1 16 M 3 2 L 3 -1 L 2 -4 L 0 -5 L -2 -5 L -5 -4 L -7 -1 L -8 2 L -8 4 L -7 7 L -6 8 L -4 9 L -2 9 L 0 8 L 1 7 L 2 5 L 3 2 M -5 -3 L -6 -1 L -7 2 L -7 5 L -6 7 M -2 -5 L -4 -3 L -5 -1 L -6 2 L -6 5 L -5 8 L -4 9 M -4 16 L 4 16 M 0 15 L -3 16 M 0 14 L -2 16 M 1 14 L 2 16 M 0 15 L 3 16","-9 9 M -8 -1 L -7 -3 L -5 -5 L -3 -5 L -2 -4 L -1 -2 L -1 2 L -3 9 M -2 -4 L -2 2 L -4 9 M -2 -2 L -3 2 L -5 9 L -3 9 M 7 -3 L 7 -4 L 6 -4 L 6 -2 L 8 -2 L 8 -4 L 7 -5 L 5 -5 L 3 -4 L 1 -2 L -1 2","-8 9 M 6 -2 L 6 -3 L 5 -3 L 5 -1 L 7 -1 L 7 -3 L 6 -4 L 3 -5 L 0 -5 L -3 -4 L -4 -3 L -4 -1 L -3 1 L -1 2 L 2 3 L 4 4 L 5 6 M -3 -4 L -4 -1 M -3 0 L -1 1 L 2 2 L 4 3 M 5 4 L 4 8 M -4 -3 L -3 -1 L -1 0 L 2 1 L 4 2 L 5 4 L 5 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -6 5 L -4 5 L -4 7 L -5 7 L -5 6","-7 7 M 2 -12 L -1 -1 L -2 3 L -2 6 L -1 8 L 0 9 L 2 9 L 4 7 L 5 5 M 3 -12 L 0 -1 L -1 3 L -1 8 M 2 -12 L 4 -12 L 0 2 L -1 6 M -4 -5 L 6 -5","-12 12 M -11 -1 L -10 -3 L -8 -5 L -6 -5 L -5 -4 L -4 -2 L -4 1 L -6 6 M -5 -4 L -5 0 L -6 4 L -6 8 M -5 -2 L -7 3 L -7 6 L -6 8 L -4 9 L -2 9 L 0 8 L 2 6 L 4 3 M 6 -5 L 4 3 L 4 6 L 5 8 L 6 9 L 8 9 L 10 7 L 11 5 M 7 -5 L 5 3 L 5 8 M 6 -5 L 8 -5 L 6 2 L 5 6","-10 10 M -9 -1 L -8 -3 L -6 -5 L -4 -5 L -3 -4 L -2 -2 L -2 1 L -4 6 M -3 -4 L -3 0 L -4 4 L -4 8 M -3 -2 L -5 3 L -5 6 L -4 8 L -2 9 L 0 9 L 2 8 L 4 6 L 6 3 L 7 -1 L 7 -5 L 6 -5 L 6 -4 L 7 -2","-15 15 M -14 -1 L -13 -3 L -11 -5 L -9 -5 L -8 -4 L -7 -2 L -7 1 L -9 6 M -8 -4 L -8 0 L -9 4 L -9 8 M -8 -2 L -10 3 L -10 6 L -9 8 L -7 9 L -5 9 L -3 8 L -1 6 L 0 3 M 2 -5 L 0 3 L 0 6 L 1 8 L 3 9 L 5 9 L 7 8 L 9 6 L 11 3 L 12 -1 L 12 -5 L 11 -5 L 11 -4 L 12 -2 M 3 -5 L 1 3 L 1 8 M 2 -5 L 4 -5 L 2 2 L 1 6","-11 11 M -8 -1 L -6 -4 L -4 -5 L -2 -5 L 0 -4 L 1 -2 L 1 0 M -2 -5 L -1 -4 L -1 0 L -2 4 L -3 6 L -5 8 L -7 9 L -9 9 L -10 8 L -10 6 L -8 6 L -8 8 L -9 8 L -9 7 M 0 -3 L 0 0 L -1 4 L -1 7 M 8 -3 L 8 -4 L 7 -4 L 7 -2 L 9 -2 L 9 -4 L 8 -5 L 6 -5 L 4 -4 L 2 -2 L 1 0 L 0 4 L 0 8 L 1 9 M -2 4 L -2 6 L -1 8 L 1 9 L 3 9 L 5 8 L 7 5","-11 11 M -10 -1 L -9 -3 L -7 -5 L -5 -5 L -4 -4 L -3 -2 L -3 1 L -5 6 M -4 -4 L -4 0 L -5 4 L -5 8 M -4 -2 L -6 3 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 3 6 L 5 2 M 7 -5 L 3 9 L 2 12 L 0 15 L -2 16 M 8 -5 L 4 9 L 2 13 M 7 -5 L 9 -5 L 5 9 L 3 13 L 1 15 L -2 16 L -5 16 L -7 15 L -8 14 L -8 12 L -6 12 L -6 14 L -7 14 L -7 13","-10 10 M 7 -5 L 6 -3 L 4 -1 L -4 5 L -6 7 L -7 9 M 6 -3 L -3 -3 L -5 -2 L -6 0 M 4 -3 L 0 -4 L -3 -4 L -4 -3 M 4 -3 L 0 -5 L -3 -5 L -5 -3 L -6 0 M -6 7 L 3 7 L 5 6 L 6 4 M -4 7 L 0 8 L 3 8 L 4 7 M -4 7 L 0 9 L 3 9 L 5 7 L 6 4","-12 13 M -11 -6 L -8 -9 L -5 -6 L -5 6 M -9 -8 L -6 -5 L -6 6 M -5 -6 L -2 -9 L 1 -6 L 1 6 M -3 -8 L 0 -5 L 0 6 M 1 -6 L 4 -9 L 7 -6 L 7 5 L 9 7 M 3 -8 L 6 -5 L 6 6 L 8 8 L 11 5","-11 11 M 8 -9 L -8 7 M 8 -9 L 5 -8 L -1 -8 M 6 -7 L 3 -7 L -1 -8 M 8 -9 L 7 -6 L 7 0 M 6 -7 L 6 -4 L 7 0 M -1 0 L -8 0 M -2 1 L -5 1 L -8 0 M -1 0 L -1 7 M -2 1 L -2 4 L -1 7","-12 12 M -10 -3 L -8 -7 L -3 3 M -8 -5 L -3 5 L 0 -2 L 5 -2 L 8 -3 L 9 -5 L 9 -7 L 8 -9 L 6 -10 L 5 -10 L 3 -9 L 2 -7 L 2 -5 L 3 -2 L 4 0 L 5 3 L 5 6 L 3 8 M 5 -10 L 4 -9 L 3 -7 L 3 -5 L 5 -1 L 6 2 L 6 5 L 5 7 L 3 8","-12 12 M -9 -3 L -6 -6 L -2 -4 M -7 -5 L -3 -3 L 0 -6 L 3 -4 M -1 -5 L 2 -3 L 5 -6 L 7 -4 M 4 -5 L 6 -3 L 9 -6 M -9 3 L -6 0 L -2 2 M -7 1 L -3 3 L 0 0 L 3 2 M -1 1 L 2 3 L 5 0 L 7 2 M 4 1 L 6 3 L 9 0","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3"]
cursive = ["-8 8","-5 5 M 0 -12 L 0 2 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-8 8 M -4 -12 L -4 -5 M 4 -12 L 4 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 10 M -2 -16 L -2 13 M 2 -16 L 2 13 M 7 -9 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 1 L 7 3 L 7 6 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-13 13 M 10 -3 L 10 -4 L 9 -5 L 8 -5 L 7 -4 L 6 -2 L 4 3 L 2 6 L 0 8 L -2 9 L -6 9 L -8 8 L -9 7 L -10 5 L -10 3 L -9 1 L -8 0 L -1 -4 L 0 -5 L 1 -7 L 1 -9 L 0 -11 L -2 -12 L -4 -11 L -5 -9 L -5 -7 L -4 -4 L -2 -1 L 3 6 L 5 8 L 7 9 L 9 9 L 10 8 L 10 7","-2 2 M 0 -5 L 0 -1","-7 7 M 4 -16 L 2 -14 L 0 -11 L -2 -7 L -3 -2 L -3 2 L -2 7 L 0 11 L 2 14 L 4 16","-7 7 M -4 -16 L -2 -14 L 0 -11 L 2 -7 L 3 -2 L 3 2 L 2 7 L 0 11 L -2 14 L -4 16","-8 8 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-13 13 M 0 -9 L 0 9 M -9 0 L 9 0","-4 4 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-13 13 M -9 0 L 9 0","-4 4 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-11 11 M 9 -16 L -9 16","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12","-10 10 M -4 -8 L -2 -9 L 1 -12 L 1 9","-10 10 M -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 3 -1 L -7 9 L 7 9","-10 10 M -5 -12 L 6 -12 L 0 -4 L 3 -4 L 5 -3 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 3 -12 L -7 2 L 8 2 M 3 -12 L 3 9","-10 10 M 5 -12 L -5 -12 L -6 -3 L -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 6 -9 L 5 -11 L 2 -12 L 0 -12 L -3 -11 L -5 -8 L -6 -3 L -6 2 L -5 6 L -3 8 L 0 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 L -3 -3 L -5 -1 L -6 2","-10 10 M 7 -12 L -3 9 M -7 -12 L 7 -12","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 1 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 2 L -6 0 L -4 -2 L -1 -3 L 3 -4 L 5 -5 L 6 -7 L 6 -9 L 5 -11 L 2 -12 L -2 -12","-10 10 M 6 -5 L 5 -2 L 3 0 L 0 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 0 -12 L 3 -11 L 5 -9 L 6 -5 L 6 0 L 5 5 L 3 8 L 0 9 L -2 9 L -5 8 L -6 6","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-12 12 M 8 -9 L -8 0 L 8 9","-13 13 M -9 -3 L 9 -3 M -9 3 L 9 3","-12 12 M -8 -9 L 8 0 L -8 9","-9 9 M -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 4 -3 L 0 -1 L 0 2 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-11 9 M -11 9 L -9 8 L -6 5 L -3 1 L 1 -6 L 4 -12 L 4 9 L 3 6 L 1 3 L -1 1 L -4 -1 L -6 -1 L -7 0 L -7 2 L -6 4 L -4 6 L -1 8 L 2 9 L 7 9","-12 11 M 1 -10 L 2 -9 L 2 -6 L 1 -2 L 0 1 L -1 3 L -3 6 L -5 8 L -7 9 L -8 9 L -9 8 L -9 5 L -8 0 L -7 -3 L -6 -5 L -4 -8 L -2 -10 L 0 -11 L 3 -12 L 6 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -5 L 7 -4 L 5 -3 L 2 -2 M 1 -2 L 2 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 3 9 L 0 9 L -2 8 L -3 6","-10 10 M 2 -6 L 2 -5 L 3 -4 L 5 -4 L 7 -5 L 8 -7 L 8 -9 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -4 L -7 0 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 2 8 L 4 6 L 5 4","-11 12 M 2 -12 L 0 -11 L -1 -9 L -2 -5 L -3 1 L -4 4 L -5 6 L -7 8 L -9 9 L -11 9 L -12 8 L -12 6 L -11 5 L -9 5 L -7 6 L -5 8 L -2 9 L 1 9 L 4 8 L 6 6 L 8 2 L 9 -3 L 9 -7 L 8 -10 L 7 -11 L 5 -12 L 2 -12 L 0 -10 L 0 -8 L 1 -5 L 3 -2 L 5 0 L 8 2 L 10 3","-10 10 M 4 -8 L 4 -7 L 5 -6 L 7 -6 L 8 -7 L 8 -9 L 7 -11 L 4 -12 L 0 -12 L -3 -11 L -4 -9 L -4 -6 L -3 -4 L -2 -3 L 1 -2 L -2 -2 L -5 -1 L -6 0 L -7 2 L -7 5 L -6 7 L -5 8 L -2 9 L 1 9 L 4 8 L 6 6 L 7 4","-10 10 M 0 -6 L -2 -6 L -4 -7 L -5 -9 L -4 -11 L -1 -12 L 2 -12 L 6 -11 L 9 -11 L 11 -12 M 6 -11 L 4 -4 L 2 2 L 0 6 L -2 8 L -4 9 L -6 9 L -8 8 L -9 6 L -9 4 L -8 3 L -6 3 L -4 4 M -1 -2 L 8 -2","-11 12 M -11 9 L -9 8 L -5 4 L -2 -1 L -1 -4 L 0 -8 L 0 -11 L -1 -12 L -2 -12 L -3 -11 L -4 -9 L -4 -6 L -3 -4 L -1 -3 L 3 -3 L 6 -4 L 7 -5 L 8 -7 L 8 -1 L 7 4 L 6 6 L 4 8 L 1 9 L -3 9 L -6 8 L -8 6 L -9 4 L -9 2","-12 12 M -5 -5 L -7 -6 L -8 -8 L -8 -9 L -7 -11 L -5 -12 L -4 -12 L -2 -11 L -1 -9 L -1 -7 L -2 -3 L -4 3 L -6 7 L -8 9 L -10 9 L -11 8 L -11 6 M -5 0 L 4 -3 L 6 -4 L 9 -6 L 11 -8 L 12 -10 L 12 -11 L 11 -12 L 10 -12 L 8 -10 L 6 -6 L 4 0 L 3 5 L 3 8 L 4 9 L 5 9 L 7 8 L 8 7 L 10 4","-9 8 M 5 4 L 3 2 L 1 -1 L 0 -3 L -1 -6 L -1 -9 L 0 -11 L 1 -12 L 3 -12 L 4 -11 L 5 -9 L 5 -6 L 4 -1 L 2 4 L 1 6 L -1 8 L -3 9 L -5 9 L -7 8 L -8 6 L -8 4 L -7 3 L -5 3 L -3 4","-8 7 M 2 12 L 0 9 L -2 4 L -3 -2 L -3 -8 L -2 -11 L 0 -12 L 2 -12 L 3 -11 L 4 -8 L 4 -5 L 3 0 L 0 9 L -2 15 L -3 18 L -4 20 L -6 21 L -7 20 L -7 18 L -6 15 L -4 12 L -2 10 L 1 8 L 5 6","-12 12 M -5 -5 L -7 -6 L -8 -8 L -8 -9 L -7 -11 L -5 -12 L -4 -12 L -2 -11 L -1 -9 L -1 -7 L -2 -3 L -4 3 L -6 7 L -8 9 L -10 9 L -11 8 L -11 6 M 12 -9 L 12 -11 L 11 -12 L 10 -12 L 8 -11 L 6 -9 L 4 -6 L 2 -4 L 0 -3 L -2 -3 M 0 -3 L 1 -1 L 1 6 L 2 8 L 3 9 L 4 9 L 6 8 L 7 7 L 9 4","-9 10 M -5 0 L -3 0 L 1 -1 L 4 -3 L 6 -5 L 7 -7 L 7 -10 L 6 -12 L 4 -12 L 3 -11 L 2 -9 L 1 -4 L 0 1 L -1 4 L -2 6 L -4 8 L -6 9 L -8 9 L -9 8 L -9 6 L -8 5 L -6 5 L -4 6 L -1 8 L 2 9 L 4 9 L 7 8 L 9 6","-18 15 M -13 -5 L -15 -6 L -16 -8 L -16 -9 L -15 -11 L -13 -12 L -12 -12 L -10 -11 L -9 -9 L -9 -7 L -10 -2 L -11 2 L -13 9 M -11 2 L -8 -6 L -6 -10 L -5 -11 L -3 -12 L -2 -12 L 0 -11 L 1 -9 L 1 -7 L 0 -2 L -1 2 L -3 9 M -1 2 L 2 -6 L 4 -10 L 5 -11 L 7 -12 L 8 -12 L 10 -11 L 11 -9 L 11 -7 L 10 -2 L 8 5 L 8 8 L 9 9 L 10 9 L 12 8 L 13 7 L 15 4","-13 11 M -8 -5 L -10 -6 L -11 -8 L -11 -9 L -10 -11 L -8 -12 L -7 -12 L -5 -11 L -4 -9 L -4 -7 L -5 -2 L -6 2 L -8 9 M -6 2 L -3 -6 L -1 -10 L 0 -11 L 2 -12 L 4 -12 L 6 -11 L 7 -9 L 7 -7 L 6 -2 L 4 5 L 4 8 L 5 9 L 6 9 L 8 8 L 9 7 L 11 4","-10 11 M 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -4 L -7 0 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 1 L 8 -3 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 2 -12 L 0 -10 L 0 -7 L 1 -4 L 3 -1 L 5 1 L 8 3 L 10 4","-12 13 M 1 -10 L 2 -9 L 2 -6 L 1 -2 L 0 1 L -1 3 L -3 6 L -5 8 L -7 9 L -8 9 L -9 8 L -9 5 L -8 0 L -7 -3 L -6 -5 L -4 -8 L -2 -10 L 0 -11 L 3 -12 L 8 -12 L 10 -11 L 11 -10 L 12 -8 L 12 -5 L 11 -3 L 10 -2 L 8 -1 L 5 -1 L 3 -2 L 2 -3","-10 12 M 3 -6 L 2 -4 L 1 -3 L -1 -2 L -3 -2 L -4 -4 L -4 -6 L -3 -9 L -1 -11 L 2 -12 L 5 -12 L 7 -11 L 8 -9 L 8 -5 L 7 -2 L 5 1 L 1 5 L -2 7 L -4 8 L -7 9 L -9 9 L -10 8 L -10 6 L -9 5 L -7 5 L -5 6 L -2 8 L 1 9 L 4 9 L 7 8 L 9 6","-12 13 M 1 -10 L 2 -9 L 2 -6 L 1 -2 L 0 1 L -1 3 L -3 6 L -5 8 L -7 9 L -8 9 L -9 8 L -9 5 L -8 0 L -7 -3 L -6 -5 L -4 -8 L -2 -10 L 0 -11 L 3 -12 L 7 -12 L 9 -11 L 10 -10 L 11 -8 L 11 -5 L 10 -3 L 9 -2 L 7 -1 L 4 -1 L 1 -2 L 2 -1 L 3 1 L 3 6 L 4 8 L 6 9 L 8 8 L 9 7 L 11 4","-10 10 M -10 9 L -8 8 L -6 6 L -3 2 L -1 -1 L 1 -5 L 2 -8 L 2 -11 L 1 -12 L 0 -12 L -1 -11 L -2 -9 L -2 -7 L -1 -5 L 1 -3 L 4 -1 L 6 1 L 7 3 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6 L -8 4 L -8 2","-10 9 M 0 -6 L -2 -6 L -4 -7 L -5 -9 L -4 -11 L -1 -12 L 2 -12 L 6 -11 L 9 -11 L 11 -12 M 6 -11 L 4 -4 L 2 2 L 0 6 L -2 8 L -4 9 L -6 9 L -8 8 L -9 6 L -9 4 L -8 3 L -6 3 L -4 4","-13 11 M -8 -5 L -10 -6 L -11 -8 L -11 -9 L -10 -11 L -8 -12 L -7 -12 L -5 -11 L -4 -9 L -4 -7 L -5 -3 L -6 0 L -7 4 L -7 6 L -6 8 L -4 9 L -2 9 L 0 8 L 1 7 L 3 3 L 6 -5 L 8 -12 M 6 -5 L 5 -1 L 4 5 L 4 8 L 5 9 L 6 9 L 8 8 L 9 7 L 11 4","-12 11 M -7 -5 L -9 -6 L -10 -8 L -10 -9 L -9 -11 L -7 -12 L -6 -12 L -4 -11 L -3 -9 L -3 -7 L -4 -3 L -5 0 L -6 4 L -6 7 L -5 9 L -3 9 L -1 8 L 2 5 L 4 2 L 6 -2 L 7 -5 L 8 -9 L 8 -11 L 7 -12 L 6 -12 L 5 -11 L 4 -9 L 4 -7 L 5 -4 L 7 -2 L 9 -1","-15 13 M -10 -5 L -12 -6 L -13 -8 L -13 -9 L -12 -11 L -10 -12 L -9 -12 L -7 -11 L -6 -9 L -6 -6 L -7 9 M 3 -12 L -7 9 M 3 -12 L 1 9 M 15 -12 L 13 -11 L 10 -8 L 7 -4 L 4 2 L 1 9","-12 12 M -4 -6 L -6 -6 L -7 -7 L -7 -9 L -6 -11 L -4 -12 L -2 -12 L 0 -11 L 1 -9 L 1 -6 L -1 3 L -1 6 L 0 8 L 2 9 L 4 9 L 6 8 L 7 6 L 7 4 L 6 3 L 4 3 M 11 -9 L 11 -11 L 10 -12 L 8 -12 L 6 -11 L 4 -9 L 2 -6 L -2 3 L -4 6 L -6 8 L -8 9 L -10 9 L -11 8 L -11 6","-12 11 M -7 -5 L -9 -6 L -10 -8 L -10 -9 L -9 -11 L -7 -12 L -6 -12 L -4 -11 L -3 -9 L -3 -7 L -4 -3 L -5 0 L -6 4 L -6 6 L -5 8 L -4 9 L -2 9 L 0 8 L 2 6 L 4 3 L 5 1 L 7 -5 M 9 -12 L 7 -5 L 4 5 L 2 11 L 0 16 L -2 20 L -4 21 L -5 20 L -5 18 L -4 15 L -2 12 L 1 9 L 4 7 L 9 4","-10 11 M 3 -6 L 2 -4 L 1 -3 L -1 -2 L -3 -2 L -4 -4 L -4 -6 L -3 -9 L -1 -11 L 2 -12 L 5 -12 L 7 -11 L 8 -9 L 8 -5 L 7 -2 L 5 2 L 2 5 L -2 8 L -4 9 L -7 9 L -8 8 L -8 6 L -7 5 L -4 5 L -2 6 L -1 7 L 0 9 L 0 12 L -1 15 L -2 17 L -4 20 L -6 21 L -7 20 L -7 18 L -6 15 L -4 12 L -1 9 L 2 7 L 8 4","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-8 8 M 0 -14 L -8 0 M 0 -14 L 8 0","-11 9 M -11 16 L 9 16","-4 4 M 1 -7 L -1 -5 L -1 -3 L 0 -2 L 1 -3 L 0 -4 L -1 -3","-6 10 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 6 L 4 0 L 3 5 L 3 8 L 4 9 L 5 9 L 7 8 L 8 7 L 10 4","-5 9 M -5 4 L -3 1 L 0 -4 L 1 -6 L 2 -9 L 2 -11 L 1 -12 L -1 -11 L -2 -9 L -3 -5 L -4 2 L -4 8 L -3 9 L -2 9 L 0 8 L 2 6 L 3 3 L 3 0 L 4 4 L 5 5 L 7 5 L 9 4","-5 6 M 2 2 L 2 1 L 1 0 L -1 0 L -3 1 L -4 2 L -5 4 L -5 6 L -4 8 L -2 9 L 1 9 L 4 7 L 6 4","-6 10 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 6 L 8 -12 M 4 0 L 3 5 L 3 8 L 4 9 L 5 9 L 7 8 L 8 7 L 10 4","-4 6 M -3 7 L -1 6 L 0 5 L 1 3 L 1 1 L 0 0 L -1 0 L -3 1 L -4 3 L -4 6 L -3 8 L -1 9 L 1 9 L 3 8 L 4 7 L 6 4","-3 5 M -3 4 L 1 -1 L 3 -4 L 4 -6 L 5 -9 L 5 -11 L 4 -12 L 2 -11 L 1 -9 L -1 -1 L -4 8 L -7 15 L -8 18 L -8 20 L -7 21 L -5 20 L -4 17 L -3 8 L -2 9 L 0 9 L 2 8 L 3 7 L 5 4","-6 9 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 7 M 4 0 L 2 7 L -2 18 L -3 20 L -5 21 L -6 20 L -6 18 L -5 15 L -2 12 L 1 10 L 3 9 L 6 7 L 9 4","-5 10 M -5 4 L -3 1 L 0 -4 L 1 -6 L 2 -9 L 2 -11 L 1 -12 L -1 -11 L -2 -9 L -3 -5 L -4 1 L -5 9 M -5 9 L -4 6 L -3 4 L -1 1 L 1 0 L 3 0 L 4 1 L 4 3 L 3 6 L 3 8 L 4 9 L 5 9 L 7 8 L 8 7 L 10 4","-2 5 M 1 -5 L 1 -4 L 2 -4 L 2 -5 L 1 -5 M -2 4 L 0 0 L -2 6 L -2 8 L -1 9 L 0 9 L 2 8 L 3 7 L 5 4","-2 5 M 1 -5 L 1 -4 L 2 -4 L 2 -5 L 1 -5 M -2 4 L 0 0 L -6 18 L -7 20 L -9 21 L -10 20 L -10 18 L -9 15 L -6 12 L -3 10 L -1 9 L 2 7 L 5 4","-5 9 M -5 4 L -3 1 L 0 -4 L 1 -6 L 2 -9 L 2 -11 L 1 -12 L -1 -11 L -2 -9 L -3 -5 L -4 1 L -5 9 M -5 9 L -4 6 L -3 4 L -1 1 L 1 0 L 3 0 L 4 1 L 4 3 L 2 4 L -1 4 M -1 4 L 1 5 L 2 8 L 3 9 L 4 9 L 6 8 L 7 7 L 9 4","-3 5 M -3 4 L -1 1 L 2 -4 L 3 -6 L 4 -9 L 4 -11 L 3 -12 L 1 -11 L 0 -9 L -1 -5 L -2 2 L -2 8 L -1 9 L 0 9 L 2 8 L 3 7 L 5 4","-13 12 M -13 4 L -11 1 L -9 0 L -8 1 L -8 2 L -9 6 L -10 9 M -9 6 L -8 4 L -6 1 L -4 0 L -2 0 L -1 1 L -1 2 L -2 6 L -3 9 M -2 6 L -1 4 L 1 1 L 3 0 L 5 0 L 6 1 L 6 3 L 5 6 L 5 8 L 6 9 L 7 9 L 9 8 L 10 7 L 12 4","-8 10 M -8 4 L -6 1 L -4 0 L -3 1 L -3 2 L -4 6 L -5 9 M -4 6 L -3 4 L -1 1 L 1 0 L 3 0 L 4 1 L 4 3 L 3 6 L 3 8 L 4 9 L 5 9 L 7 8 L 8 7 L 10 4","-6 8 M 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 7 L 3 5 L 3 3 L 2 1 L 0 0 L -1 1 L -1 3 L 0 5 L 2 6 L 5 6 L 7 5 L 8 4","-7 8 M -7 4 L -5 1 L -4 -1 L -5 3 L -11 21 M -5 3 L -4 1 L -2 0 L 0 0 L 2 1 L 3 3 L 3 5 L 2 7 L 1 8 L -1 9 M -5 8 L -3 9 L 0 9 L 3 8 L 5 7 L 8 4","-6 9 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 M 4 0 L 3 3 L 1 8 L -2 15 L -3 18 L -3 20 L -2 21 L 0 20 L 1 17 L 1 10 L 3 9 L 6 7 L 9 4","-5 8 M -5 4 L -3 1 L -2 -1 L -2 1 L 1 1 L 2 2 L 2 4 L 1 7 L 1 8 L 2 9 L 3 9 L 5 8 L 6 7 L 8 4","-4 7 M -4 4 L -2 1 L -1 -1 L -1 1 L 1 4 L 2 6 L 2 8 L 0 9 M -4 8 L -2 9 L 2 9 L 4 8 L 5 7 L 7 4","-3 6 M -3 4 L -1 1 L 1 -3 M 4 -12 L -2 6 L -2 8 L -1 9 L 1 9 L 3 8 L 4 7 L 6 4 M -2 -4 L 5 -4","-6 9 M -6 4 L -4 0 L -6 6 L -6 8 L -5 9 L -3 9 L -1 8 L 1 6 L 3 3 M 4 0 L 2 6 L 2 8 L 3 9 L 4 9 L 6 8 L 7 7 L 9 4","-6 9 M -6 4 L -4 0 L -5 5 L -5 8 L -4 9 L -3 9 L 0 8 L 2 6 L 3 3 L 3 0 M 3 0 L 4 4 L 5 5 L 7 5 L 9 4","-9 12 M -6 0 L -8 2 L -9 5 L -9 7 L -8 9 L -6 9 L -4 8 L -2 6 M 0 0 L -2 6 L -2 8 L -1 9 L 1 9 L 3 8 L 5 6 L 6 3 L 6 0 M 6 0 L 7 4 L 8 5 L 10 5 L 12 4","-8 8 M -8 4 L -6 1 L -4 0 L -2 0 L -1 1 L -1 8 L 0 9 L 3 9 L 6 7 L 8 4 M 5 1 L 4 0 L 2 0 L 1 1 L -3 8 L -4 9 L -6 9 L -7 8","-6 9 M -6 4 L -4 0 L -6 6 L -6 8 L -5 9 L -3 9 L -1 8 L 1 6 L 3 3 M 4 0 L -2 18 L -3 20 L -5 21 L -6 20 L -6 18 L -5 15 L -2 12 L 1 10 L 3 9 L 6 7 L 9 4","-6 8 M -6 4 L -4 1 L -2 0 L 0 0 L 2 2 L 2 4 L 1 6 L -1 8 L -4 9 L -2 10 L -1 12 L -1 15 L -2 18 L -3 20 L -5 21 L -6 20 L -6 18 L -5 15 L -2 12 L 1 10 L 5 7 L 8 4","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
cyrillic = ["-8 8","-5 5 M 0 -12 L -1 -10 L 0 2 L 1 -10 L 0 -12 M 0 -10 L 0 -4 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-8 8 M -4 -12 L -5 -5 M -3 -12 L -5 -5 M 4 -12 L 3 -5 M 5 -12 L 3 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-15 15 M -10 -12 L -10 9 M -9 -12 L -9 9 M -13 -12 L -6 -12 M -9 -2 L -2 -2 L 1 -1 L 2 0 L 3 2 L 3 5 L 2 7 L 1 8 L -2 9 L -13 9 M -2 -2 L 0 -1 L 1 0 L 2 2 L 2 5 L 1 7 L 0 8 L -2 9 M 9 -12 L 9 9 M 10 -12 L 10 9 M 6 -12 L 13 -12 M 6 9 L 13 9","-11 11 M -6 -5 L -6 9 M -5 -5 L -5 9 M 5 -5 L 5 9 M 6 -5 L 6 9 M -9 -5 L -2 -5 M 2 -5 L 9 -5 M -9 9 L 9 9 L 9 14 L 8 9","-13 13 M -8 -5 L -8 9 M -7 -5 L -7 9 M -11 -5 L -4 -5 M -7 2 L -3 2 L 0 3 L 1 5 L 1 6 L 0 8 L -3 9 L -11 9 M -3 2 L -1 3 L 0 5 L 0 6 L -1 8 L -3 9 M 7 -5 L 7 9 M 8 -5 L 8 9 M 4 -5 L 11 -5 M 4 9 L 11 9","-4 4 M 0 -12 L -1 -5 M 1 -12 L -1 -5","-7 7 M 3 -16 L 1 -14 L -1 -11 L -3 -7 L -4 -2 L -4 2 L -3 7 L -1 11 L 1 14 L 3 16 L 4 16 M 3 -16 L 4 -16 L 2 -14 L 0 -11 L -2 -7 L -3 -2 L -3 2 L -2 7 L 0 11 L 2 14 L 4 16","-7 7 M -4 -16 L -2 -14 L 0 -11 L 2 -7 L 3 -2 L 3 2 L 2 7 L 0 11 L -2 14 L -4 16 L -3 16 M -4 -16 L -3 -16 L -1 -14 L 1 -11 L 3 -7 L 4 -2 L 4 2 L 3 7 L 1 11 L -1 14 L -3 16","-8 8 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-13 13 M 0 -9 L 0 9 M -9 0 L 9 0","-4 4 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-13 13 M -9 0 L 9 0","-4 4 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-11 11 M 9 -16 L -9 16","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12 M -1 -12 L -3 -11 L -4 -10 L -5 -8 L -6 -3 L -6 0 L -5 5 L -4 7 L -3 8 L -1 9 M 1 9 L 3 8 L 4 7 L 5 5 L 6 0 L 6 -3 L 5 -8 L 4 -10 L 3 -11 L 1 -12","-10 10 M -4 -8 L -2 -9 L 1 -12 L 1 9 M 0 -11 L 0 9 M -4 9 L 5 9","-10 10 M -6 -8 L -5 -7 L -6 -6 L -7 -7 L -7 -8 L -6 -10 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 3 -2 L -2 0 L -4 1 L -6 3 L -7 6 L -7 9 M 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 2 -2 L -2 0 M -7 7 L -6 6 L -4 6 L 1 8 L 4 8 L 6 7 L 7 6 M -4 6 L 1 9 L 5 9 L 6 8 L 7 6 L 7 4","-10 10 M -6 -8 L -5 -7 L -6 -6 L -7 -7 L -7 -8 L -6 -10 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -9 L 6 -6 L 5 -4 L 2 -3 L -1 -3 M 2 -12 L 4 -11 L 5 -9 L 5 -6 L 4 -4 L 2 -3 M 2 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 4 L -6 5 M 5 -1 L 6 2 L 6 5 L 5 7 L 4 8 L 2 9","-10 10 M 2 -10 L 2 9 M 3 -12 L 3 9 M 3 -12 L -8 3 L 8 3 M -1 9 L 6 9","-10 10 M -5 -12 L -7 -2 M -7 -2 L -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 4 L -6 5 M 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 M -5 -12 L 5 -12 M -5 -11 L 0 -11 L 5 -12","-10 10 M 5 -9 L 4 -8 L 5 -7 L 6 -8 L 6 -9 L 5 -11 L 3 -12 L 0 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -3 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 L -3 -3 L -5 -1 L -6 2 M 0 -12 L -2 -11 L -4 -9 L -5 -7 L -6 -3 L -6 3 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 3 L 6 2 L 5 -1 L 3 -3 L 1 -4","-10 10 M -7 -12 L -7 -6 M -7 -8 L -6 -10 L -4 -12 L -2 -12 L 3 -9 L 5 -9 L 6 -10 L 7 -12 M -6 -10 L -4 -11 L -2 -11 L 3 -9 M 7 -12 L 7 -9 L 6 -6 L 2 -1 L 1 1 L 0 4 L 0 9 M 6 -6 L 1 -1 L 0 1 L -1 4 L -1 9","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -6 L -5 -4 L -2 -3 L 2 -3 L 5 -4 L 6 -6 L 6 -9 L 5 -11 L 2 -12 L -2 -12 M -2 -12 L -4 -11 L -5 -9 L -5 -6 L -4 -4 L -2 -3 M 2 -3 L 4 -4 L 5 -6 L 5 -9 L 4 -11 L 2 -12 M -2 -3 L -5 -2 L -6 -1 L -7 1 L -7 5 L -6 7 L -5 8 L -2 9 L 2 9 L 5 8 L 6 7 L 7 5 L 7 1 L 6 -1 L 5 -2 L 2 -3 M -2 -3 L -4 -2 L -5 -1 L -6 1 L -6 5 L -5 7 L -4 8 L -2 9 M 2 9 L 4 8 L 5 7 L 6 5 L 6 1 L 5 -1 L 4 -2 L 2 -3","-10 10 M 6 -5 L 5 -2 L 3 0 L 0 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -6 L 7 0 L 6 4 L 5 6 L 3 8 L 0 9 L -3 9 L -5 8 L -6 6 L -6 5 L -5 4 L -4 5 L -5 6 M -1 1 L -3 0 L -5 -2 L -6 -5 L -6 -6 L -5 -9 L -3 -11 L -1 -12 M 1 -12 L 3 -11 L 5 -9 L 6 -6 L 6 0 L 5 4 L 4 6 L 2 8 L 0 9","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-12 12 M 8 -9 L -8 0 L 8 9","-13 13 M -9 -3 L 9 -3 M -9 3 L 9 3","-12 12 M -8 -9 L 8 0 L -8 9","-9 9 M -5 -8 L -4 -7 L -5 -6 L -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 1 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 4 -3 L 0 -1 L 0 2 M 1 -12 L 3 -11 L 4 -10 L 5 -8 L 5 -6 L 4 -4 L 2 -2 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-10 10 M 0 -12 L -7 9 M 0 -12 L 7 9 M 0 -9 L 6 9 M -5 3 L 4 3 M -9 9 L -3 9 M 3 9 L 9 9","-11 11 M -6 -12 L -6 9 M -5 -12 L -5 9 M -9 -12 L 7 -12 L 7 -6 L 6 -12 M -5 -2 L 3 -2 L 6 -1 L 7 0 L 8 2 L 8 5 L 7 7 L 6 8 L 3 9 L -9 9 M 3 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 3 9","-10 11 M -6 -9 L -7 -12 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -7 L 8 -4 L 8 1 L 7 4 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 4 L -6 5 M 1 -12 L 3 -11 L 5 -9 L 6 -7 L 7 -4 L 7 1 L 6 4 L 5 6 L 3 8 L 1 9 M -2 -2 L 7 -2","-12 12 M -4 -12 L -4 -6 L -5 2 L -6 6 L -7 8 L -8 9 M 6 -12 L 6 9 M 7 -12 L 7 9 M -7 -12 L 10 -12 M -11 9 L 10 9 M -11 9 L -11 16 M -10 9 L -11 16 M 9 9 L 10 16 M 10 9 L 10 16","-12 12 M -7 -12 L -7 9 M -6 -12 L -6 9 M 6 -12 L 6 9 M 7 -12 L 7 9 M -10 -12 L -3 -12 M 3 -12 L 10 -12 M 6 -10 L -6 7 M -10 9 L -3 9 M 3 9 L 10 9","-12 13 M 0 -12 L 0 9 M 1 -12 L 1 9 M -3 -12 L 4 -12 M -2 -9 L -6 -8 L -8 -6 L -9 -3 L -9 0 L -8 3 L -6 5 L -2 6 L 3 6 L 7 5 L 9 3 L 10 0 L 10 -3 L 9 -6 L 7 -8 L 3 -9 L -2 -9 M -2 -9 L -5 -8 L -7 -6 L -8 -3 L -8 0 L -7 3 L -5 5 L -2 6 M 3 6 L 6 5 L 8 3 L 9 0 L 9 -3 L 8 -6 L 6 -8 L 3 -9 M -3 9 L 4 9","-9 9 M -4 -12 L -4 9 M -3 -12 L -3 9 M -7 -12 L 8 -12 L 8 -6 L 7 -12 M -7 9 L 0 9","-15 16 M 0 -12 L 0 9 M 1 -12 L 1 9 M -3 -12 L 4 -12 M -11 -11 L -10 -10 L -11 -9 L -12 -10 L -12 -11 L -11 -12 L -10 -12 L -9 -11 L -8 -9 L -7 -5 L -6 -3 L -4 -2 L 5 -2 L 7 -3 L 8 -5 L 9 -9 L 10 -11 L 11 -12 L 12 -12 L 13 -11 L 13 -10 L 12 -9 L 11 -10 L 12 -11 M -4 -2 L -6 -1 L -7 1 L -8 6 L -9 8 L -10 9 M -4 -2 L -5 -1 L -6 1 L -7 6 L -8 8 L -9 9 L -11 9 L -12 8 L -13 6 M 5 -2 L 7 -1 L 8 1 L 9 6 L 10 8 L 11 9 M 5 -2 L 6 -1 L 7 1 L 8 6 L 9 8 L 10 9 L 12 9 L 13 8 L 14 6 M -3 9 L 4 9","-12 12 M -7 -12 L -7 9 M -6 -12 L -6 9 M 6 -12 L 6 9 M 7 -12 L 7 9 M -10 -12 L -3 -12 M 3 -12 L 10 -12 M 6 -10 L -6 7 M -10 9 L -3 9 M 3 9 L 10 9","-12 11 M -7 -12 L -7 -1 L -6 1 L -3 2 L 0 2 L 3 1 L 5 -1 M -6 -12 L -6 -1 L -5 1 L -3 2 M 5 -12 L 5 9 M 6 -12 L 6 9 M -10 -12 L -3 -12 M 2 -12 L 9 -12 M 2 9 L 9 9","-12 12 M -7 -12 L -7 9 M -6 -12 L -6 9 M -10 -12 L -3 -12 M -6 -2 L 1 -2 L 3 -3 L 4 -5 L 5 -9 L 6 -11 L 7 -12 L 8 -12 L 9 -11 L 9 -10 L 8 -9 L 7 -10 L 8 -11 M 1 -2 L 3 -1 L 4 1 L 5 6 L 6 8 L 7 9 M 1 -2 L 2 -1 L 3 1 L 4 6 L 5 8 L 6 9 L 8 9 L 9 8 L 10 6 M -10 9 L -3 9","-13 12 M -5 -12 L -5 -6 L -6 2 L -7 6 L -8 8 L -9 9 L -10 9 L -11 8 L -11 7 L -10 6 L -9 7 L -10 8 M 6 -12 L 6 9 M 7 -12 L 7 9 M -8 -12 L 10 -12 M 3 9 L 10 9","-12 13 M -7 -12 L -7 9 M -6 -12 L 0 6 M -7 -12 L 0 9 M 7 -12 L 0 9 M 7 -12 L 7 9 M 8 -12 L 8 9 M -10 -12 L -6 -12 M 7 -12 L 11 -12 M -10 9 L -4 9 M 4 9 L 11 9","-12 12 M -7 -12 L -7 9 M -6 -12 L -6 9 M 6 -12 L 6 9 M 7 -12 L 7 9 M -10 -12 L -3 -12 M 3 -12 L 10 -12 M -6 -2 L 6 -2 M -10 9 L -3 9 M 3 9 L 10 9","-11 11 M -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -3 L -8 0 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 4 L 8 0 L 8 -3 L 7 -7 L 6 -9 L 4 -11 L 1 -12 L -1 -12 M -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -3 L -7 0 L -6 4 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 4 L 7 0 L 7 -3 L 6 -7 L 5 -9 L 3 -11 L 1 -12","-12 12 M -7 -12 L -7 9 M -6 -12 L -6 9 M 6 -12 L 6 9 M 7 -12 L 7 9 M -10 -12 L 10 -12 M -10 9 L -3 9 M 3 9 L 10 9","-16 17 M -11 -12 L -11 9 M -10 -12 L -10 9 M 0 -12 L 0 9 M 1 -12 L 1 9 M 11 -12 L 11 9 M 12 -12 L 12 9 M -14 -12 L -7 -12 M -3 -12 L 4 -12 M 8 -12 L 15 -12 M -14 9 L 15 9","-11 11 M -6 -12 L -6 9 M -5 -12 L -5 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -5 L 7 -3 L 6 -2 L 3 -1 L -5 -1 M 3 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -5 L 6 -3 L 5 -2 L 3 -1 M -9 9 L -2 9","-11 10 M 6 -9 L 7 -6 L 7 -12 L 6 -9 L 4 -11 L 1 -12 L -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 4 M -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 L -3 8 L -1 9","-9 10 M 0 -12 L 0 9 M 1 -12 L 1 9 M -6 -12 L -7 -6 L -7 -12 L 8 -12 L 8 -6 L 7 -12 M -3 9 L 4 9","-15 16 M -10 -12 L -10 9 M -9 -12 L -9 9 M -13 -12 L -6 -12 M -13 9 L -6 9 M 4 -12 L 1 -11 L -1 -9 L -2 -7 L -3 -3 L -3 0 L -2 4 L -1 6 L 1 8 L 4 9 L 6 9 L 9 8 L 11 6 L 12 4 L 13 0 L 13 -3 L 12 -7 L 11 -9 L 9 -11 L 6 -12 L 4 -12 M 4 -12 L 2 -11 L 0 -9 L -1 -7 L -2 -3 L -2 0 L -1 4 L 0 6 L 2 8 L 4 9 M 6 9 L 8 8 L 10 6 L 11 4 L 12 0 L 12 -3 L 11 -7 L 10 -9 L 8 -11 L 6 -12 M -9 -2 L -3 -2","-11 11 M -6 -12 L -6 9 M -5 -12 L -5 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -6 L 7 -4 L 6 -3 L 3 -2 M 3 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 3 -2 M -5 -2 L 3 -2 L 6 -1 L 7 0 L 8 2 L 8 5 L 7 7 L 6 8 L 3 9 L -9 9 M 3 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 3 9","-16 17 M -11 -12 L -11 9 M -10 -12 L -10 9 M 0 -12 L 0 9 M 1 -12 L 1 9 M 11 -12 L 11 9 M 12 -12 L 12 9 M -14 -12 L -7 -12 M -3 -12 L 4 -12 M 8 -12 L 15 -12 M -14 9 L 15 9 M 14 9 L 15 16 M 15 9 L 15 16","-10 10 M -7 -12 L 6 9 M -6 -12 L 7 9 M 7 -12 L -7 9 M -9 -12 L -3 -12 M 3 -12 L 9 -12 M -9 9 L -3 9 M 3 9 L 9 9","-10 11 M -7 -12 L 0 4 M -6 -12 L 1 4 M 8 -12 L 1 4 L -1 7 L -2 8 L -4 9 L -5 9 L -6 8 L -6 7 L -5 6 L -4 7 L -5 8 M -9 -12 L -3 -12 M 4 -12 L 10 -12","-10 10 M -6 -9 L -7 -12 L -7 -6 L -6 -9 L -4 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -9 L 6 -6 L 5 -4 L 2 -3 L -1 -3 M 2 -12 L 4 -11 L 5 -9 L 5 -6 L 4 -4 L 2 -3 M 2 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -3 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 4 L -6 5 M 5 -1 L 6 2 L 6 5 L 5 7 L 4 8 L 2 9","-11 10 M -6 -12 L -6 9 M -5 -12 L -5 9 M 1 -6 L 1 2 M -9 -12 L 7 -12 L 7 -6 L 6 -12 M -5 -2 L 1 -2 M -9 9 L 7 9 L 7 3 L 6 9","-7 7 M -7 -12 L 7 12","-12 14 M -2 -12 L -2 9 M -1 -12 L -1 9 M -9 -12 L -10 -6 L -10 -12 L 2 -12 M -1 -2 L 6 -2 L 9 -1 L 10 0 L 11 2 L 11 5 L 10 7 L 9 8 L 6 9 L -5 9 M 6 -2 L 8 -1 L 9 0 L 10 2 L 10 5 L 9 7 L 8 8 L 6 9","-11 11 M 5 -12 L 5 9 M 6 -12 L 6 9 M 9 -12 L -3 -12 L -6 -11 L -7 -10 L -8 -8 L -8 -6 L -7 -4 L -6 -3 L -3 -2 L 5 -2 M -3 -12 L -5 -11 L -6 -10 L -7 -8 L -7 -6 L -6 -4 L -5 -3 L -3 -2 M 0 -2 L -2 -1 L -3 0 L -6 7 L -7 8 L -8 8 L -9 7 M -2 -1 L -3 1 L -5 8 L -6 9 L -8 9 L -9 7 L -9 6 M 2 9 L 9 9","-10 11 M -5 -12 L -5 9 M -4 -12 L -4 9 M -8 -12 L -1 -12 M -4 -2 L 3 -2 L 6 -1 L 7 0 L 8 2 L 8 5 L 7 7 L 6 8 L 3 9 L -8 9 M 3 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 3 9","-12 12 M -7 -12 L -7 9 M -6 -12 L -6 9 M 6 -12 L 6 9 M 7 -12 L 7 9 M -10 -12 L -3 -12 M 3 -12 L 10 -12 M -10 9 L 10 9 M 9 9 L 10 16 M 10 9 L 10 16","-9 11 M -4 -3 L -4 -2 L -5 -2 L -5 -3 L -4 -4 L -2 -5 L 2 -5 L 4 -4 L 5 -3 L 6 -1 L 6 6 L 7 8 L 8 9 M 5 -3 L 5 6 L 6 8 L 8 9 L 9 9 M 5 -1 L 4 0 L -2 1 L -5 2 L -6 4 L -6 6 L -5 8 L -2 9 L 1 9 L 3 8 L 5 6 M -2 1 L -4 2 L -5 4 L -5 6 L -4 8 L -2 9","-10 10 M 6 -12 L 5 -11 L -1 -9 L -4 -7 L -6 -4 L -7 -1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 1 L 6 -2 L 4 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -2 L -7 1 M 6 -12 L 5 -10 L 3 -9 L -1 -8 L -4 -6 L -6 -4 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 3 L 6 1 L 5 -2 L 3 -4 L 1 -5","-10 11 M -6 -9 L -7 -12 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -7 L 8 -4 L 8 1 L 7 4 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 4 L -6 5 M 1 -12 L 3 -11 L 5 -9 L 6 -7 L 7 -4 L 7 1 L 6 4 L 5 6 L 3 8 L 1 9 M -2 -2 L 7 -2","-12 11 M -4 -5 L -4 -1 L -5 5 L -6 8 L -7 9 M 5 -5 L 5 9 M 6 -5 L 6 9 M -7 -5 L 9 -5 M -9 9 L -10 14 L -10 9 L 9 9 L 9 14 L 8 9","-11 11 M -6 -5 L -6 9 M -5 -5 L -5 9 M 5 -5 L 5 9 M 6 -5 L 6 9 M -9 -5 L -2 -5 M 2 -5 L 9 -5 M -9 9 L -2 9 M 2 9 L 9 9 M 5 -4 L -5 8 M -3 -11 L -3 -12 L -4 -12 L -4 -11 L -3 -9 L -1 -8 L 1 -8 L 3 -9 L 4 -11","-10 11 M 0 -12 L 0 16 M 1 -12 L 1 16 M -3 -12 L 1 -12 M 0 -2 L -1 -4 L -2 -5 L -4 -5 L -6 -4 L -7 -1 L -7 5 L -6 8 L -4 9 L -2 9 L -1 8 L 0 6 M -4 -5 L -5 -4 L -6 -1 L -6 5 L -5 8 L -4 9 M 5 -5 L 6 -4 L 7 -1 L 7 5 L 6 8 L 5 9 M 1 -2 L 2 -4 L 3 -5 L 5 -5 L 7 -4 L 8 -1 L 8 5 L 7 8 L 5 9 L 3 9 L 2 8 L 1 6 M -3 16 L 4 16","-10 8 M -5 -5 L -5 9 M -4 -5 L -4 9 M -8 -5 L 6 -5 L 6 0 L 5 -5 M -8 9 L -1 9","-13 14 M 0 -5 L 0 9 M 1 -5 L 1 9 M -3 -5 L 4 -5 M -8 -4 L -9 -3 L -10 -4 L -9 -5 L -8 -5 L -7 -4 L -5 0 L -4 1 L -2 2 L 3 2 L 5 1 L 6 0 L 8 -4 L 9 -5 L 10 -5 L 11 -4 L 10 -3 L 9 -4 M -2 2 L -4 3 L -5 4 L -7 8 L -8 9 M -2 2 L -4 4 L -6 8 L -7 9 L -9 9 L -10 8 L -11 6 M 3 2 L 5 3 L 6 4 L 8 8 L 9 9 M 3 2 L 5 4 L 7 8 L 8 9 L 10 9 L 11 8 L 12 6 M -3 9 L 4 9","-11 11 M -6 -5 L -6 9 M -5 -5 L -5 9 M 5 -5 L 5 9 M 6 -5 L 6 9 M -9 -5 L -2 -5 M 2 -5 L 9 -5 M -9 9 L -2 9 M 2 9 L 9 9 M 5 -4 L -5 8","-11 11 M -6 -5 L -6 2 L -5 4 L -2 5 L 0 5 L 3 4 L 5 2 M -5 -5 L -5 2 L -4 4 L -2 5 M 5 -5 L 5 9 M 6 -5 L 6 9 M -9 -5 L -2 -5 M 2 -5 L 9 -5 M 2 9 L 9 9","-10 10 M -5 -5 L -5 9 M -4 -5 L -4 9 M -8 -5 L -1 -5 M -4 2 L -2 2 L 1 1 L 2 0 L 4 -4 L 5 -5 L 6 -5 L 7 -4 L 6 -3 L 5 -4 M -2 2 L 1 3 L 2 4 L 4 8 L 5 9 M -2 2 L 0 3 L 1 4 L 3 8 L 4 9 L 6 9 L 7 8 L 8 6 M -8 9 L -1 9","-11 11 M -4 -5 L -4 -1 L -5 5 L -6 8 L -7 9 L -8 9 L -9 8 L -8 7 L -7 8 M 5 -5 L 5 9 M 6 -5 L 6 9 M -7 -5 L 9 -5 M 2 9 L 9 9","-11 12 M -6 -5 L -6 9 M -6 -5 L 0 9 M -5 -5 L 0 7 M 6 -5 L 0 9 M 6 -5 L 6 9 M 7 -5 L 7 9 M -9 -5 L -5 -5 M 6 -5 L 10 -5 M -9 9 L -3 9 M 3 9 L 10 9","-11 11 M -6 -5 L -6 9 M -5 -5 L -5 9 M 5 -5 L 5 9 M 6 -5 L 6 9 M -9 -5 L -2 -5 M 2 -5 L 9 -5 M -5 2 L 5 2 M -9 9 L -2 9 M 2 9 L 9 9","-10 10 M -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 1 L 6 -2 L 4 -4 L 1 -5 L -1 -5 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 3 L 6 1 L 5 -2 L 3 -4 L 1 -5","-11 11 M -6 -5 L -6 9 M -5 -5 L -5 9 M 5 -5 L 5 9 M 6 -5 L 6 9 M -9 -5 L 9 -5 M -9 9 L -2 9 M 2 9 L 9 9","-15 16 M -10 -5 L -10 9 M -9 -5 L -9 9 M 0 -5 L 0 9 M 1 -5 L 1 9 M 10 -5 L 10 9 M 11 -5 L 11 9 M -13 -5 L -6 -5 M -3 -5 L 4 -5 M 7 -5 L 14 -5 M -13 9 L 14 9","-11 10 M -6 -5 L -6 16 M -5 -5 L -5 16 M -5 -2 L -3 -4 L -1 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -1 9 L -3 8 L -5 6 M 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 M -9 -5 L -5 -5 M -9 16 L -2 16","-10 9 M 5 -2 L 4 -1 L 5 0 L 6 -1 L 6 -2 L 4 -4 L 2 -5 L -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9","-9 10 M 0 -5 L 0 9 M 1 -5 L 1 9 M -5 -5 L -6 0 L -6 -5 L 7 -5 L 7 0 L 6 -5 M -3 9 L 4 9","-14 15 M -9 -5 L -9 9 M -8 -5 L -8 9 M -12 -5 L -5 -5 M -12 9 L -5 9 M 4 -5 L 1 -4 L -1 -2 L -2 1 L -2 3 L -1 6 L 1 8 L 4 9 L 6 9 L 9 8 L 11 6 L 12 3 L 12 1 L 11 -2 L 9 -4 L 6 -5 L 4 -5 M 4 -5 L 2 -4 L 0 -2 L -1 1 L -1 3 L 0 6 L 2 8 L 4 9 M 6 9 L 8 8 L 10 6 L 11 3 L 11 1 L 10 -2 L 8 -4 L 6 -5 M -8 2 L -2 2","-10 10 M -5 -5 L -5 9 M -4 -5 L -4 9 M -8 -5 L 3 -5 L 6 -4 L 7 -2 L 7 -1 L 6 1 L 3 2 M 3 -5 L 5 -4 L 6 -2 L 6 -1 L 5 1 L 3 2 M -4 2 L 3 2 L 6 3 L 7 5 L 7 6 L 6 8 L 3 9 L -8 9 M 3 2 L 5 3 L 6 5 L 6 6 L 5 8 L 3 9","-15 16 M -10 -5 L -10 9 M -9 -5 L -9 9 M 0 -5 L 0 9 M 1 -5 L 1 9 M 10 -5 L 10 9 M 11 -5 L 11 9 M -13 -5 L -6 -5 M -3 -5 L 4 -5 M 7 -5 L 14 -5 M -13 9 L 14 9 L 14 14 L 13 9","-10 10 M -6 -5 L 5 9 M -5 -5 L 6 9 M 6 -5 L -6 9 M -8 -5 L -2 -5 M 2 -5 L 8 -5 M -8 9 L -2 9 M 2 9 L 8 9","-9 9 M -6 -5 L 0 9 M -5 -5 L 0 7 M 6 -5 L 0 9 L -2 13 L -4 15 L -6 16 L -7 16 L -8 15 L -7 14 L -6 15 M -8 -5 L -2 -5 M 2 -5 L 8 -5","-9 9 M -5 -3 L -6 -5 L -6 -1 L -5 -3 L -4 -4 L -2 -5 L 2 -5 L 5 -4 L 6 -2 L 6 -1 L 5 1 L 2 2 M 2 -5 L 4 -4 L 5 -2 L 5 -1 L 4 1 L 2 2 M -1 2 L 2 2 L 5 3 L 6 5 L 6 6 L 5 8 L 2 9 L -2 9 L -5 8 L -6 6 L -6 5 L -5 4 L -4 5 L -5 6 M 2 2 L 4 3 L 5 5 L 5 6 L 4 8 L 2 9","-10 9 M -6 1 L 6 1 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 M 5 1 L 5 -2 L 4 -4 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9","-10 11 M -1 -5 L -1 9 M 0 -5 L 0 9 M -6 -5 L -7 0 L -7 -5 L 3 -5 M 0 2 L 4 2 L 7 3 L 8 5 L 8 6 L 7 8 L 4 9 L -4 9 M 4 2 L 6 3 L 7 5 L 7 6 L 6 8 L 4 9","-11 10 M 4 -5 L 4 9 M 5 -5 L 5 9 M 8 -5 L -3 -5 L -6 -4 L -7 -2 L -7 -1 L -6 1 L -3 2 L 4 2 M -3 -5 L -5 -4 L -6 -2 L -6 -1 L -5 1 L -3 2 M 2 2 L -1 3 L -2 4 L -4 8 L -5 9 M 2 2 L 0 3 L -1 4 L -3 8 L -4 9 L -6 9 L -7 8 L -8 6 M 1 9 L 8 9","-8 9 M -3 -5 L -3 9 M -2 -5 L -2 9 M -6 -5 L 1 -5 M -2 2 L 2 2 L 5 3 L 6 5 L 6 6 L 5 8 L 2 9 L -6 9 M 2 2 L 4 3 L 5 5 L 5 6 L 4 8 L 2 9","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3"]
futural = ["-8 8","-5 5 M 0 -12 L 0 2 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-8 8 M -4 -12 L -4 -5 M 4 -12 L 4 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 10 M -2 -16 L -2 13 M 2 -16 L 2 13 M 7 -9 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 1 L 7 3 L 7 6 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-13 13 M 10 -3 L 10 -4 L 9 -5 L 8 -5 L 7 -4 L 6 -2 L 4 3 L 2 6 L 0 8 L -2 9 L -6 9 L -8 8 L -9 7 L -10 5 L -10 3 L -9 1 L -8 0 L -1 -4 L 0 -5 L 1 -7 L 1 -9 L 0 -11 L -2 -12 L -4 -11 L -5 -9 L -5 -7 L -4 -4 L -2 -1 L 3 6 L 5 8 L 7 9 L 9 9 L 10 8 L 10 7","-5 5 M 0 -10 L -1 -11 L 0 -12 L 1 -11 L 1 -9 L 0 -7 L -1 -6","-7 7 M 4 -16 L 2 -14 L 0 -11 L -2 -7 L -3 -2 L -3 2 L -2 7 L 0 11 L 2 14 L 4 16","-7 7 M -4 -16 L -2 -14 L 0 -11 L 2 -7 L 3 -2 L 3 2 L 2 7 L 0 11 L -2 14 L -4 16","-8 8 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-13 13 M 0 -9 L 0 9 M -9 0 L 9 0","-4 4 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-13 13 M -9 0 L 9 0","-4 4 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-11 11 M 9 -16 L -9 16","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12","-10 10 M -4 -8 L -2 -9 L 1 -12 L 1 9","-10 10 M -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 3 -1 L -7 9 L 7 9","-10 10 M -5 -12 L 6 -12 L 0 -4 L 3 -4 L 5 -3 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 3 -12 L -7 2 L 8 2 M 3 -12 L 3 9","-10 10 M 5 -12 L -5 -12 L -6 -3 L -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 6 -9 L 5 -11 L 2 -12 L 0 -12 L -3 -11 L -5 -8 L -6 -3 L -6 2 L -5 6 L -3 8 L 0 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 L -3 -3 L -5 -1 L -6 2","-10 10 M 7 -12 L -3 9 M -7 -12 L 7 -12","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 1 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 2 L -6 0 L -4 -2 L -1 -3 L 3 -4 L 5 -5 L 6 -7 L 6 -9 L 5 -11 L 2 -12 L -2 -12","-10 10 M 6 -5 L 5 -2 L 3 0 L 0 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 0 -12 L 3 -11 L 5 -9 L 6 -5 L 6 0 L 5 5 L 3 8 L 0 9 L -2 9 L -5 8 L -6 6","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-12 12 M 8 -9 L -8 0 L 8 9","-13 13 M -9 -3 L 9 -3 M -9 3 L 9 3","-12 12 M -8 -9 L 8 0 L -8 9","-9 9 M -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 4 -3 L 0 -1 L 0 2 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-9 9 M 0 -12 L -8 9 M 0 -12 L 8 9 M -5 2 L 5 2","-11 10 M -7 -12 L -7 9 M -7 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 2 -2 M -7 -2 L 2 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -7 9","-10 11 M 8 -7 L 7 -9 L 5 -11 L 3 -12 L -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 L -3 8 L -1 9 L 3 9 L 5 8 L 7 6 L 8 4","-11 10 M -7 -12 L -7 9 M -7 -12 L 0 -12 L 3 -11 L 5 -9 L 6 -7 L 7 -4 L 7 1 L 6 4 L 5 6 L 3 8 L 0 9 L -7 9","-10 9 M -6 -12 L -6 9 M -6 -12 L 7 -12 M -6 -2 L 2 -2 M -6 9 L 7 9","-10 8 M -6 -12 L -6 9 M -6 -12 L 7 -12 M -6 -2 L 2 -2","-10 11 M 8 -7 L 7 -9 L 5 -11 L 3 -12 L -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 L -3 8 L -1 9 L 3 9 L 5 8 L 7 6 L 8 4 L 8 1 M 3 1 L 8 1","-11 11 M -7 -12 L -7 9 M 7 -12 L 7 9 M -7 -2 L 7 -2","-4 4 M 0 -12 L 0 9","-8 8 M 4 -12 L 4 4 L 3 7 L 2 8 L 0 9 L -2 9 L -4 8 L -5 7 L -6 4 L -6 2","-11 10 M -7 -12 L -7 9 M 7 -12 L -7 2 M -2 -3 L 7 9","-10 7 M -6 -12 L -6 9 M -6 9 L 6 9","-12 12 M -8 -12 L -8 9 M -8 -12 L 0 9 M 8 -12 L 0 9 M 8 -12 L 8 9","-11 11 M -7 -12 L -7 9 M -7 -12 L 7 9 M 7 -12 L 7 9","-11 11 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -2 9 L 2 9 L 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11 L 2 -12 L -2 -12","-11 10 M -7 -12 L -7 9 M -7 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -5 L 6 -3 L 5 -2 L 2 -1 L -7 -1","-11 11 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -2 9 L 2 9 L 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11 L 2 -12 L -2 -12 M 1 5 L 7 11","-11 10 M -7 -12 L -7 9 M -7 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 2 -2 L -7 -2 M 0 -2 L 7 9","-10 10 M 7 -9 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 1 L 7 3 L 7 6 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6","-8 8 M 0 -12 L 0 9 M -7 -12 L 7 -12","-11 11 M -7 -12 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 -12","-9 9 M -8 -12 L 0 9 M 8 -12 L 0 9","-12 12 M -10 -12 L -5 9 M 0 -12 L -5 9 M 0 -12 L 5 9 M 10 -12 L 5 9","-10 10 M -7 -12 L 7 9 M 7 -12 L -7 9","-9 9 M -8 -12 L 0 -2 L 0 9 M 8 -12 L 0 -2","-10 10 M 7 -12 L -7 9 M -7 -12 L 7 -12 M -7 9 L 7 9","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-8 8 M 0 -14 L -8 0 M 0 -14 L 8 0","-9 9 M -9 16 L 9 16","-4 4 M 1 -7 L -1 -5 L -1 -3 L 0 -2 L 1 -3 L 0 -4 L -1 -3","-9 10 M 6 -5 L 6 9 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-10 9 M -6 -12 L -6 9 M -6 -2 L -4 -4 L -2 -5 L 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 L -2 9 L -4 8 L -6 6","-9 9 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-9 10 M 6 -12 L 6 9 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-9 9 M -6 1 L 6 1 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-5 7 M 5 -12 L 3 -12 L 1 -11 L 0 -8 L 0 9 M -3 -5 L 4 -5","-9 10 M 6 -5 L 6 11 L 5 14 L 4 15 L 2 16 L -1 16 L -3 15 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-9 10 M -5 -12 L -5 9 M -5 -1 L -2 -4 L 0 -5 L 3 -5 L 5 -4 L 6 -1 L 6 9","-4 4 M -1 -12 L 0 -11 L 1 -12 L 0 -13 L -1 -12 M 0 -5 L 0 9","-5 5 M 0 -12 L 1 -11 L 2 -12 L 1 -13 L 0 -12 M 1 -5 L 1 12 L 0 15 L -2 16 L -4 16","-9 8 M -5 -12 L -5 9 M 5 -5 L -5 5 M -1 1 L 6 9","-4 4 M 0 -12 L 0 9","-15 15 M -11 -5 L -11 9 M -11 -1 L -8 -4 L -6 -5 L -3 -5 L -1 -4 L 0 -1 L 0 9 M 0 -1 L 3 -4 L 5 -5 L 8 -5 L 10 -4 L 11 -1 L 11 9","-9 10 M -5 -5 L -5 9 M -5 -1 L -2 -4 L 0 -5 L 3 -5 L 5 -4 L 6 -1 L 6 9","-9 10 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6 L 7 3 L 7 1 L 6 -2 L 4 -4 L 2 -5 L -1 -5","-10 9 M -6 -5 L -6 16 M -6 -2 L -4 -4 L -2 -5 L 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 L -2 9 L -4 8 L -6 6","-9 10 M 6 -5 L 6 16 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-7 6 M -3 -5 L -3 9 M -3 1 L -2 -2 L 0 -4 L 2 -5 L 5 -5","-8 9 M 6 -2 L 5 -4 L 2 -5 L -1 -5 L -4 -4 L -5 -2 L -4 0 L -2 1 L 3 2 L 5 3 L 6 5 L 6 6 L 5 8 L 2 9 L -1 9 L -4 8 L -5 6","-5 7 M 0 -12 L 0 5 L 1 8 L 3 9 L 5 9 M -3 -5 L 4 -5","-9 10 M -5 -5 L -5 5 L -4 8 L -2 9 L 1 9 L 3 8 L 6 5 M 6 -5 L 6 9","-8 8 M -6 -5 L 0 9 M 6 -5 L 0 9","-11 11 M -8 -5 L -4 9 M 0 -5 L -4 9 M 0 -5 L 4 9 M 8 -5 L 4 9","-8 9 M -5 -5 L 6 9 M 6 -5 L -5 9","-8 8 M -6 -5 L 0 9 M 6 -5 L 0 9 L -2 13 L -4 15 L -6 16 L -7 16","-8 9 M 6 -5 L -5 9 M -5 -5 L 6 -5 M -5 9 L 6 9","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
EMSAllure = ["-8 8","0 11.4 M 20.8 -12.1 L 19.5 -9.8 L 16.1 -2.5 L 14.1 2.2 M 13.2 7.0 L 12.5 7.7","0 9.6 M 12.0 -8.4 L 11.5 -3.8 M 16.4 -8.4 L 15.7 -3.7","0 29.4 M 22.0 -14.6 L 14.3 7.7 M 31.0 -14.4 L 23.6 7.8 M 12.0 -5.9 L 35.2 -6.0 M 9.4 2.9 L 32.9 2.9","0 18.8 M 20.8 -3.8 L 23.2 -5.7 L 24.2 -7.9 L 23.7 -9.6 L 22.3 -10.3 L 19.4 -10.3 L 15.5 -9.3 L 13.0 -7.3 L 12.1 -5.5 L 11.9 -4.4 L 12.1 -2.9 L 16.8 2.7 L 17.7 4.2 L 16.9 5.3 L 15.1 5.8 L 13.5 5.6 L 11.8 5.3 L 11.0 4.9 M 22.7 -11.9 L 21.8 -11.1 L 16.6 -2.4 L 11.0 8.6","0 17.4 M 15.0 -11.6 L 12.8 -10.7 L 11.1 -8.7 L 11.1 -6.2 L 12.3 -5.1 L 14.2 -5.3 L 15.7 -6.7 L 16.7 -8.3 L 16.8 -10.1 L 16.4 -11.1 L 15.5 -11.5 L 17.6 -10.8 L 22.1 -11.0 L 24.1 -12.0 L 22.0 -9.2 L 15.7 .1 L 10.8 8.4 M 18.7 2.6 L 17.3 4.8 L 17.1 7.1 L 18.4 8.3 L 19.8 8.3 L 21.7 6.9 L 22.7 5.4 L 23.0 2.6 L 22.0 1.6 L 20.2 1.5 L 18.7 2.6","0 26.3 M 28.1 -11.9 L 27.2 -11.5 L 26.2 -9.9 L 25.7 -8.8 L 25.7 -7.5 M 26.4 -10.7 L 25.2 -12.0 L 23.5 -12.9 L 20.4 -12.6 L 17.9 -11.7 L 16.9 -9.0 L 17.7 -6.5 L 19.2 -4.0 L 21.3 -1.8 L 17.7 -1.4 L 14.2 -1.0 L 11.1 1.4 L 9.8 4.4 L 10.8 7.1 L 12.8 8.9 L 16.1 9.5 L 19.9 9.1 L 23.3 8.2 L 26.1 6.7 L 28.0 4.5 L 29.2 2.2 L 29.5 .1 L 29.3 -1.2 L 28.7 -2.9 M 32.1 -6.6 L 32.1 -5.7 L 31.1 -4.6 L 27.1 -2.1 L 24.0 -.8 L 21.2 .6 L 19.8 2.9 L 19.9 4.1 L 20.8 5.5","0 5.5 M 12.1 -8.5 L 11.5 -3.7","0 14.2 M 24.9 -12.7 L 18.3 -9.2 L 13.7 -5.1 L 11.3 -1.0 L 9.8 4.1 L 9.6 8.4 L 10.2 12.1 L 11.1 14.1","0 19.6 M 20.8 -12.7 L 22.6 -8.6 L 22.5 -2.5 L 20.3 4.0 L 16.8 8.7 L 13.4 11.4 L 10.3 12.9 L 7.4 14.0","0 24.2 M 16.5 -10.1 L 16.7 -10.0 L 21.7 .7 M 23.5 -10.6 L 14.9 .4 M 26.6 -4.9 L 12.7 -4.6","0 23.2 M 12.2 1.3 L 27.6 1.3 M 22.8 -4.7 L 16.9 8.5","0 6.7 M 12.3 7.2 L 12.9 8.3 L 12.2 9.3 L 9.9 12.7","0 14.1 M 14.1 1.5 L 21.3 1.3","0 7.1 M 13.6 7.0 L 13.1 7.8","0 17.9 M 24.3 -11.8 L 17.0 -2.3 L 13.0 3.2 L 9.8 8.3","0 21.0 M 23.8 -9.5 L 22.7 -10.3 L 19.9 -10.4 L 18.3 -9.7 L 15.0 -7.5 L 13.2 -5.7 L 11.7 -3.3 L 10.5 .6 L 10.3 3.8 L 11.6 7.0 L 13.8 8.5 L 16.3 9.2 L 19.1 8.7 L 22.4 7.0 L 25.5 3.9 L 27.3 .5 L 28.3 -3.2 L 28.3 -6.2 L 27.5 -8.7 L 25.9 -10.3 L 24.2 -11.6 L 22.5 -12.1 L 20.1 -12.2","0 12.0 M 14.4 -5.3 L 17.3 -7.6 L 19.0 -9.7 L 20.3 -11.5 L 21.2 -11.5 L 18.1 -4.6 L 15.1 2.3 L 13.9 5.8 L 13.6 7.8 M 9.2 8.7 L 11.2 8.0 L 13.2 8.0 L 15.5 7.8 L 18.0 7.9","0 22.3 M 15.3 -6.6 L 15.2 -6.9 L 15.2 -8.0 L 18.1 -10.1 L 20.8 -11.0 L 24.0 -11.4 L 27.2 -10.7 L 28.7 -9.6 L 29.6 -7.2 L 28.6 -4.7 L 26.1 -2.0 L 22.8 .6 L 20.1 2.5 L 17.3 4.3 L 15.3 5.4 L 14.4 5.9 L 12.9 6.9 L 12.3 7.5 L 10.8 8.5 L 10.8 7.5 L 11.6 6.4 L 12.8 6.0 L 14.9 6.1 L 17.1 6.9 L 18.5 7.8 L 21.8 9.1 L 25.3 9.2 L 27.1 8.4 L 28.6 7.2 L 29.0 6.3","0 21.1 M 16.6 -6.8 L 17.1 -9.0 L 19.2 -10.6 L 21.9 -11.3 L 24.2 -11.4 L 26.7 -10.8 L 28.2 -8.9 L 28.3 -6.8 L 27.7 -5.6 L 26.3 -4.4 L 25.2 -3.5 L 22.9 -3.0 L 20.5 -2.6 L 18.9 -2.0 L 18.5 -2.3 L 18.3 -3.2 L 20.7 -3.0 L 24.3 -2.3 L 26.0 -1.7 L 27.0 -.2 L 27.3 2.4 L 26.6 4.4 L 24.7 6.5 L 22.6 8.0 L 20.2 9.0 L 16.0 9.6 L 13.7 9.3 L 12.3 8.4 L 11.4 6.7 L 11.7 5.5 L 12.2 4.8","0 17.7 M 16.7 9.2 L 17.5 6.0 L 19.2 1.1 L 22.3 -5.7 L 25.0 -11.2 L 20.8 -7.7 L 16.6 -4.4 L 12.3 -1.8 L 10.2 .0 L 8.9 1.9 L 10.6 1.0 L 11.8 .5 L 14.8 .5 L 17.3 .6 L 19.6 1.1 L 22.0 1.1 L 24.6 .1 L 25.8 -.7 L 26.6 -1.7","0 20.4 M 19.1 -10.3 L 16.0 -5.6 L 14.2 -2.5 L 16.0 -3.6 L 18.9 -4.6 L 21.3 -4.7 L 23.6 -4.2 L 25.6 -3.0 L 26.4 -1.2 L 26.4 .9 L 25.6 3.2 L 23.5 5.8 L 21.0 7.4 L 18.0 8.6 L 15.1 9.1 L 12.7 9.1 L 10.6 8.7 L 9.1 8.0 L 8.2 6.5 L 7.9 4.9 L 8.5 4.1 M 17.9 -10.5 L 22.4 -10.8 L 27.1 -11.0 L 29.7 -10.8","0 19.1 M 26.5 -7.1 L 26.6 -9.3 L 25.6 -10.8 L 23.3 -11.2 L 19.7 -10.5 L 15.8 -7.5 L 13.6 -4.7 L 11.8 -.9 L 10.9 3.1 L 11.2 5.9 L 12.8 8.0 L 15.2 8.8 L 17.7 8.8 L 19.6 7.9 L 21.9 6.1 L 23.4 4.1 L 24.2 1.0 L 23.7 -1.3 L 21.9 -2.6 L 19.7 -2.8 L 17.6 -2.4 L 16.2 -1.2","0 15.9 M 12.5 -7.1 L 13.7 -9.8 L 15.6 -11.0 L 19.1 -11.2 L 23.2 -10.7 L 25.6 -10.6 L 27.3 -10.4 L 28.6 -11.1 L 22.8 -4.9 L 18.3 .7 L 15.0 4.6 L 13.0 8.0 L 12.6 8.2","0 18.8 M 21.2 -12.0 L 17.5 -10.4 L 15.2 -8.0 L 15.4 -5.6 L 16.2 -3.9 L 18.3 -2.9 L 20.4 -2.9 L 22.8 -2.1 L 24.3 .1 L 24.2 2.8 L 23.1 4.4 L 19.9 6.6 L 17.1 8.2 L 14.5 8.5 L 12.0 8.3 L 10.2 7.3 L 9.8 4.8 L 11.2 2.2 L 14.4 -.2 L 22.4 -4.6 L 24.9 -5.9 L 26.6 -7.3 L 27.2 -9.7 L 26.4 -11.4 L 24.6 -12.2 L 21.2 -12.0","0 19.2 M 20.7 -1.4 L 19.1 -.3 L 16.7 .0 L 14.2 -.8 L 13.0 -2.4 L 13.0 -5.4 L 14.4 -8.5 L 16.6 -10.4 L 18.5 -11.4 L 21.8 -11.9 L 24.4 -11.0 L 26.1 -8.7 L 26.5 -6.3 L 25.8 -2.7 L 24.8 .0 L 22.8 3.2 L 20.4 5.5 L 18.0 7.4 L 16.2 8.3 L 14.0 8.7 L 12.3 8.7 L 10.5 7.3 L 10.1 6.2 L 10.2 4.0","0 7.8 M 15.2 1.0 L 14.8 1.7 M 13.4 7.0 L 13.0 7.7","0 7.1 M 15.0 1.0 L 14.5 1.7 M 12.2 7.1 L 12.8 7.7 L 12.7 8.4 L 12.2 9.3 L 10.0 12.2","0 14.3 M 21.4 -8.8 L 12.2 .2 L 14.3 3.1 L 15.6 4.8 L 17.0 7.1","0 20.5 M 15.0 -1.1 L 27.2 -1.4 M 13.6 4.6 L 15.0 4.1 L 26.4 4.2","0 15.0 M 17.0 -8.6 L 19.4 -4.9 L 21.4 -2.9 L 18.3 .1 L 14.5 3.8 L 11.7 6.5","0 17.9 M 13.4 -8.8 L 13.8 -10.1 L 14.5 -10.8 L 16.8 -12.1 L 18.8 -13.1 L 22.1 -13.0 L 23.9 -11.7 L 24.8 -8.8 L 23.8 -6.1 L 22.4 -4.1 L 20.5 -2.6 L 19.0 -1.7 L 16.8 .1 L 15.8 1.5 L 15.4 2.5 M 13.1 7.2 L 12.4 8.0","0 28.4 M 28.1 -7.4 L 25.2 -8.5 L 21.1 -6.9 L 18.0 -4.6 L 16.0 -2.3 L 14.9 -.3 L 14.8 1.5 L 15.6 2.6 L 16.9 3.1 L 18.8 2.6 L 20.5 1.0 L 23.3 -1.8 L 26.6 -5.7 L 27.3 -5.7 L 25.8 -2.7 L 25.1 -.5 L 24.9 2.2 L 25.8 3.2 L 28.0 3.0 L 30.6 .9 L 32.8 -2.4 L 34.0 -5.2 L 34.3 -8.6 L 33.1 -11.6 L 29.9 -13.6 L 26.1 -14.0 L 21.9 -13.5 L 17.4 -11.5 L 13.2 -8.2 L 10.7 -4.9 L 8.9 .0 L 9.2 3.6 L 10.3 5.9 L 13.2 8.4 L 17.2 9.5 L 22.0 9.4 L 27.1 8.1 L 27.4 7.9 L 31.7 5.1 L 34.0 2.6 L 34.9 .8 L 35.1 -.9 L 34.9 -3.0","0 33.7 M 8.7 7.7 L 9.3 9.5 L 11.1 10.8 L 13.9 11.1 L 17.7 9.8 L 21.9 6.5 L 25.8 2.5 L 30.0 -2.4 L 32.4 -5.7 L 34.8 -8.7 L 37.0 -11.2 L 38.8 -13.2 L 39.4 -13.4 L 36.8 -9.1 L 34.3 -2.0 L 32.9 3.0 L 32.8 5.9 L 33.6 8.4 L 35.0 8.9 L 37.9 7.3 L 40.3 5.0 L 41.7 3.3 M 13.1 3.9 L 13.2 1.2 L 14.3 -.6 L 16.9 -1.5 L 19.3 -1.6 L 23.0 -.9 L 25.3 -.4 L 29.7 .1 L 34.8 .7 L 37.6 .7 L 38.5 .3 L 39.4 -.3","0 27.3 M 12.0 -1.4 L 9.7 -2.7 L 9.1 -4.3 L 9.8 -7.2 L 12.7 -9.5 L 19.4 -12.6 L 26.4 -13.6 L 31.1 -13.5 L 33.8 -12.5 L 35.0 -10.9 L 34.9 -8.8 L 34.0 -7.5 L 32.4 -6.2 L 28.0 -4.8 L 25.8 -4.5 L 23.9 -4.2 L 22.6 -4.0 L 26.2 -1.3 L 29.1 1.2 L 30.2 4.0 L 29.7 6.7 L 28.2 8.6 L 25.9 10.2 L 22.9 10.4 L 20.9 10.4 L 19.1 9.8 L 18.2 8.0 L 17.8 6.4 L 15.6 8.0 L 14.1 9.0 L 13.7 8.2 L 14.9 4.3 L 19.3 -3.9 L 20.8 -7.2 L 22.3 -8.8 L 24.2 -9.2 L 25.4 -9.1","0 21.9 M 18.4 -2.5 L 21.8 -2.8 L 25.7 -5.0 L 28.6 -7.7 L 29.9 -10.3 L 29.3 -12.6 L 26.9 -13.6 L 20.9 -12.0 L 16.9 -9.3 L 12.5 -4.3 L 10.3 .1 L 9.4 4.8 L 10.9 8.2 L 15.0 10.0 L 20.0 9.5 L 24.1 7.9 L 27.9 5.4 L 30.2 3.0","0 32.8 M 29.7 -8.6 L 26.3 -7.1 L 24.0 -3.8 L 23.4 -1.6 L 21.3 3.1 L 20.1 5.6 L 18.6 8.7 L 17.4 10.4 L 16.5 10.2 L 15.5 8.0 L 15.4 5.4 L 15.8 2.4 L 16.4 4.4 L 20.9 7.9 L 25.2 9.3 L 32.1 8.2 L 36.4 5.4 L 40.0 2.0 L 41.8 -2.8 L 41.4 -7.9 L 39.2 -10.9 L 35.3 -12.6 L 28.3 -13.4 L 22.1 -12.3 L 17.3 -10.5 L 13.9 -8.4 L 12.0 -5.6 L 11.7 -3.2 L 13.0 -1.2 L 15.0 -.3","0 27.0 M 30.0 -9.4 L 30.2 -7.0 L 27.7 -12.0 L 24.9 -13.8 L 21.7 -13.4 L 19.3 -10.7 L 19.4 -7.7 L 20.6 -4.6 L 21.9 -2.8 L 23.1 -1.2 L 25.0 -.7 L 25.1 -1.7 L 23.8 -2.1 L 20.4 -2.0 L 14.7 -1.2 L 10.3 2.1 L 8.9 5.6 L 10.4 8.7 L 14.4 10.6 L 19.1 10.5 L 24.8 9.7 L 29.4 7.8 L 33.0 5.4 L 34.5 3.3 L 34.7 2.5 L 34.6 1.0","0 19.8 M 25.4 -9.3 L 22.8 -8.5 L 20.7 -6.2 L 19.5 -3.2 L 17.8 -.4 L 15.9 3.6 L 14.2 6.6 L 14.0 8.2 L 14.6 9.0 L 16.1 8.7 L 17.0 7.5 L 17.5 6.9 M 11.3 -2.8 L 9.8 -3.8 L 8.8 -6.1 L 10.4 -9.7 L 13.6 -11.7 L 20.0 -12.9 L 25.3 -12.4 L 29.0 -11.9 L 31.5 -11.9 L 34.1 -11.8 L 35.3 -12.5 L 34.8 -12.6 L 32.5 -10.2 L 31.8 -8.6 L 31.9 -7.1 M 16.3 -.8 L 15.2 -.1 L 27.1 -1.5","0 30.2 M 35.2 -11.3 L 33.8 -13.1 L 32.2 -13.8 L 28.7 -13.8 L 23.4 -12.5 L 19.4 -10.3 L 15.6 -7.4 L 13.3 -4.3 L 11.8 -1.7 L 11.1 1.2 L 11.5 3.9 L 13.0 6.0 L 15.8 7.6 L 19.3 8.0 L 24.0 6.7 L 27.4 4.5 L 31.2 1.6 L 32.9 .0 L 33.6 -.9 L 35.5 -2.2 L 36.1 -2.8 L 35.1 -2.5 L 33.4 .4 L 30.5 10.3 L 27.2 15.6 L 23.8 20.2 L 20.6 21.9 L 17.6 22.1 L 16.2 20.9 L 16.2 18.6 L 17.4 16.0 L 20.6 12.7 L 24.7 10.0 L 28.3 8.1 L 32.2 6.8 L 33.2 6.6 L 35.9 6.1","0 29.8 M 18.2 -8.1 L 18.6 -8.1 L 21.7 -9.8 L 23.2 -11.7 L 24.3 -13.2 L 23.1 -9.7 M 23.1 -9.7 L 19.3 .9 L 15.7 7.2 L 12.5 11.3 L 9.2 13.0 L 7.4 13.0 L 5.1 12.0 L 4.9 11.3 M 38.8 -12.6 L 36.1 -11.4 L 34.7 -9.0 L 33.1 -5.2 L 31.6 -1.7 L 30.1 2.3 L 29.1 5.6 L 29.4 7.7 L 30.3 8.7 L 32.1 8.8 L 34.2 7.2 L 36.6 4.8 L 37.8 3.2 M 10.3 2.7 L 10.0 -.3 L 11.6 -2.2 L 16.5 -2.8 L 19.0 -2.4 L 23.0 -1.9 L 28.5 -.7 L 33.1 -.2 L 35.4 -.7 L 36.0 -1.2","0 17.4 M 24.9 -13.0 L 22.0 -4.1 L 19.6 1.9 L 17.9 5.0 L 16.0 7.4 L 14.3 8.1 L 12.1 8.4 L 9.3 8.2 L 8.8 7.4 L 9.7 6.7 L 11.1 7.7 L 12.7 8.0 L 23.2 7.8 M 16.4 -5.3 L 14.6 -7.6 L 15.4 -10.1 L 17.8 -12.1 L 21.5 -12.7 L 25.6 -12.5 L 28.0 -12.4 L 30.1 -11.6","0 21.8 M 29.4 -13.7 L 28.5 -12.8 L 27.0 -9.6 L 24.9 -3.7 L 22.6 2.6 L 19.4 7.7 L 17.2 10.1 L 13.6 12.0 L 10.7 11.3 L 9.9 8.7 L 11.6 5.5 L 15.8 1.3 L 18.8 -.6 L 22.6 -2.3 L 25.8 -3.2 L 28.8 -3.8 M 17.5 -4.9 L 15.9 -6.1 L 15.7 -9.0 L 17.4 -11.1 L 21.6 -12.4 L 25.6 -12.7 L 29.2 -12.2 L 30.7 -11.5","0 24.1 M 13.2 -7.9 L 17.1 -9.8 L 19.6 -13.2 L 15.6 -2.4 L 13.9 2.4 L 12.5 4.8 L 10.3 8.0 L 8.2 10.6 L 5.0 12.8 L 2.3 13.1 L .8 12.6 L -.3 10.8 M 33.0 -13.2 L 26.9 -9.5 L 21.1 -4.8 L 16.5 -.3 L 13.6 3.3 M 18.4 -3.8 L 20.1 3.0 L 22.8 7.7 L 25.8 9.3 L 27.9 8.9 L 28.8 7.4 L 28.4 6.7 L 27.9 5.9","0 19.6 M 16.3 5.0 L 16.6 5.0 L 22.5 2.6 L 27.7 -1.7 L 30.8 -7.2 L 31.3 -10.8 M 31.5 -10.8 L 30.3 -13.3 L 28.2 -13.9 L 24.8 -12.6 L 22.0 -9.0 L 20.0 -2.7 L 16.9 6.2 L 15.8 9.2 L 14.6 11.2 L 13.6 12.4 L 13.0 12.8 M 12.9 6.4 L 9.2 7.4 L 9.6 6.4 L 13.3 7.7 L 18.6 11.4 L 22.8 13.8 L 27.5 15.7 L 32.8 15.4 L 35.0 13.8 L 35.6 12.8 L 35.7 10.8","0 42.9 M 16.1 -8.0 L 18.6 -9.1 L 19.9 -10.2 L 21.0 -11.5 L 21.9 -13.0 L 22.6 -13.2 L 20.6 -7.8 L 18.1 -1.0 L 15.5 4.3 L 13.1 8.4 L 11.0 10.3 L 9.0 10.9 L 7.8 9.5 L 8.4 7.5 L 12.0 3.1 L 16.9 -2.3 L 23.2 -8.2 L 27.1 -10.5 L 29.6 -11.1 L 31.9 -10.2 L 33.0 -7.3 L 32.5 -1.0 L 31.9 3.0 L 30.8 6.6 L 31.6 6.4 L 33.9 2.7 L 39.5 -5.7 L 41.9 -9.1 L 44.1 -10.7 L 45.7 -10.5 L 46.3 -9.7 L 46.7 -8.1 L 45.5 -4.6 L 44.3 -2.1 L 42.9 .9 L 42.2 3.3 L 42.2 5.8 L 43.4 8.3 L 46.5 7.8 L 49.8 4.9 L 50.9 3.2","0 29.6 M 1.7 10.2 L 2.3 11.9 L 4.1 13.0 L 6.9 12.4 L 10.2 10.1 L 13.1 5.6 L 15.8 .4 L 17.7 -4.7 L 19.2 -8.8 L 20.1 -11.9 L 20.4 -1.4 L 21.1 3.0 L 23.2 7.9 L 25.1 9.6 L 27.2 10.1 L 29.4 9.0 L 32.2 4.9 L 34.0 .3 L 35.2 -6.0 L 35.4 -9.7 L 35.0 -11.5 L 34.3 -13.5 L 35.8 -11.4 L 36.7 -10.2 L 37.5 -9.6 L 38.4 -9.1 M 14.0 -7.3 L 14.4 -7.4 L 17.2 -8.7 L 18.3 -9.9 L 19.4 -11.9 M 14.0 -7.3 L 14.4 -7.4 L 17.2 -8.7 L 18.3 -9.9 L 19.4 -11.9","0 27.0 M 10.2 -1.4 L 10.2 -1.6 L 11.8 -6.6 L 14.9 -10.0 L 19.6 -12.6 L 23.1 -13.7 L 26.5 -13.6 L 29.7 -13.1 L 32.4 -10.9 L 33.7 -7.7 L 34.1 -5.4 L 33.6 -1.3 L 32.1 2.7 L 29.2 6.5 L 26.2 9.0 L 23.2 10.4 L 18.2 10.7 L 14.7 9.0 L 12.7 4.9 L 13.1 -.4 L 14.8 -3.7 L 17.5 -6.9 L 20.2 -8.3 L 22.3 -9.3 L 23.6 -9.3 L 25.0 -9.1","0 20.3 M 25.0 -9.3 L 23.0 -8.8 L 21.3 -7.7 L 20.0 -6.2 L 19.5 -4.2 L 18.7 -2.5 L 16.8 .6 L 15.3 3.5 L 14.4 5.9 L 14.1 7.0 L 13.9 8.0 L 14.4 9.0 L 15.5 8.6 L 16.7 7.2 M 12.2 -2.4 L 10.3 -3.5 L 9.7 -5.7 L 10.4 -8.3 L 13.2 -10.4 L 16.3 -11.9 L 19.3 -12.8 L 23.3 -13.3 L 28.8 -13.0 L 32.5 -11.6 L 34.5 -9.9 L 34.7 -7.6 L 33.6 -5.0 L 31.8 -3.0 L 29.3 -1.8 L 25.0 -.4 L 20.9 .3 L 18.5 .7 L 15.8 .4","0 25.4 M 31.2 -13.7 L 33.6 -12.6 L 34.9 -10.3 L 34.8 -5.7 L 33.1 -.1 L 29.5 5.1 L 25.9 7.9 L 23.2 9.1 L 19.7 9.8 L 15.7 9.1 L 12.6 7.3 L 10.7 3.7 L 10.6 -2.2 L 12.7 -7.3 L 15.8 -10.5 L 18.4 -12.2 L 21.2 -13.7 L 24.2 -14.5 L 27.2 -14.0 L 29.5 -12.5 L 30.7 -9.9 L 30.8 -5.9 L 30.2 -2.3 L 28.0 1.4 L 25.3 4.2 L 22.9 5.7 L 21.2 6.3 L 17.7 7.5 L 16.3 7.0 L 16.5 6.3 L 18.4 6.5 L 21.6 8.0 L 24.8 10.2 L 28.2 12.4 L 32.3 14.8 L 37.5 15.8 M 37.4 15.8 L 41.9 15.0 L 43.3 13.2 L 43.4 12.3 L 43.3 10.2","0 20.3 M 24.8 -9.2 L 22.3 -8.9 L 20.3 -6.9 L 19.8 -4.9 L 18.3 -1.6 L 15.6 2.7 L 13.9 6.3 L 13.5 7.9 L 14.1 8.9 L 15.3 8.4 L 16.0 7.8 L 16.2 7.6 M 11.6 -2.7 L 9.9 -4.3 L 9.7 -6.7 L 10.7 -8.8 L 14.1 -11.2 L 17.7 -12.3 L 21.9 -13.1 L 26.7 -13.0 L 30.3 -12.6 L 33.5 -10.6 L 34.8 -8.0 L 34.0 -5.2 L 30.5 -2.6 L 26.6 -1.2 L 22.7 .0 L 19.6 .1 L 15.4 -.3 L 15.3 -1.0 L 18.9 1.7 L 21.1 5.3 L 24.8 9.7 L 28.9 12.7 L 33.2 14.6 L 37.0 14.6 L 39.0 13.4 L 39.8 12.2 L 40.0 11.1","0 22.4 M 31.0 -9.4 L 31.9 -10.7 L 31.9 -12.2 L 30.1 -13.5 L 25.5 -12.9 L 20.1 -11.2 L 17.5 -8.7 L 17.4 -6.4 L 20.5 -4.9 L 25.4 -3.4 L 28.6 -1.7 L 29.9 .2 L 29.7 1.9 L 28.6 3.6 L 25.6 5.9 L 20.8 7.9 L 14.3 9.2 L 11.0 8.7 L 9.9 7.5 L 9.6 4.9 L 10.7 2.6 L 12.7 .9 L 15.0 -.3 L 18.3 -1.3","0 17.6 M 10.8 -3.0 L 9.3 -4.5 L 8.9 -6.9 L 10.2 -9.8 L 12.6 -11.5 L 15.3 -12.5 L 18.1 -12.9 L 23.8 -12.8 L 29.3 -12.1 L 34.6 -12.0 L 36.3 -12.4 L 35.2 -12.9 L 32.6 -9.4 L 32.3 -8.1 L 32.1 -6.4 L 32.6 -5.7 M 25.8 -9.1 L 23.3 -8.1 L 21.4 -6.1 L 19.3 -2.2 L 16.6 2.5 L 14.7 6.9 L 14.7 8.2 L 15.3 9.0 L 16.3 8.3 L 17.5 7.0","0 21.3 M 9.3 -6.1 L 9.6 -6.3 L 12.3 -7.5 L 14.3 -9.1 L 16.4 -11.0 L 16.9 -12.0 L 17.9 -12.0 L 15.6 -8.7 L 12.3 -1.5 L 10.7 2.0 L 10.1 5.3 L 10.8 8.0 L 13.1 8.7 L 16.1 7.7 L 19.9 5.1 L 25.0 .2 L 28.7 -4.3 L 31.3 -8.4 L 32.6 -11.5 L 32.4 -13.5 L 31.1 -14.2 L 29.5 -13.6 L 27.9 -12.7 L 26.4 -10.1 L 25.3 -6.8 L 24.2 -2.4 L 23.1 3.1 L 22.4 7.5 L 22.5 10.8 L 23.0 13.4 L 23.7 14.7 L 24.8 15.2 L 25.8 15.3 L 26.7 14.8","0 23.4 M 10.7 -5.4 L 9.0 -7.8 L 9.8 -10.4 L 11.3 -11.5 L 15.0 -12.2 L 18.6 -12.5 L 21.4 -12.5 L 23.2 -11.8 L 23.9 -11.6 M 19.5 -13.8 L 19.7 -9.6 L 18.5 -6.3 L 17.2 -4.0 L 15.7 -.2 L 14.2 3.7 L 13.5 6.4 L 13.6 9.3 L 14.9 10.2 L 17.8 10.2 L 21.7 8.0 L 25.9 4.1 L 30.5 -1.9 L 33.9 -7.1 L 35.8 -10.0 L 37.4 -12.0 L 38.8 -13.1 L 40.2 -14.0 L 40.8 -14.0","0 38.3 M 11.2 -5.1 L 10.1 -6.1 L 9.3 -8.3 L 10.5 -10.5 L 13.6 -12.0 L 17.4 -12.6 L 21.4 -12.5 L 23.6 -12.1 L 24.5 -11.7 M 22.2 -13.5 L 21.3 -9.8 L 19.4 -6.9 L 16.0 -2.2 L 13.3 2.1 L 11.9 4.4 L 10.7 6.9 L 10.3 8.8 L 10.5 10.2 L 11.0 10.8 L 12.1 11.1 L 13.7 10.9 L 16.4 9.9 L 19.4 8.1 L 21.5 6.3 L 24.7 3.7 L 27.6 .5 L 30.7 -3.5 L 31.6 -5.9 L 31.9 -7.8 L 31.6 -9.6 L 30.5 -9.1 L 30.1 -7.1 L 30.2 -4.2 L 30.0 -.5 L 30.8 3.4 L 32.2 6.1 L 34.0 7.7 L 36.8 8.9 L 38.8 8.6 L 40.3 8.0 L 42.4 5.0 L 43.8 1.9 L 44.5 -1.3 L 44.8 -3.3 L 44.4 -7.4 L 43.4 -10.0 L 41.3 -11.6 L 39.0 -12.2 L 37.5 -12.0 L 36.8 -11.4","0 25.6 M 11.1 -5.5 L 9.5 -6.6 L 9.1 -8.6 L 9.8 -10.7 L 12.3 -12.1 L 15.2 -12.8 L 17.5 -13.1 L 21.0 -12.7 L 23.0 -12.4 L 23.9 -12.1 L 24.4 -12.0 M 22.3 -13.2 L 21.6 -8.8 L 22.0 -4.0 L 22.7 .0 L 24.5 4.3 L 26.7 7.3 L 28.7 8.5 L 31.3 7.4 L 33.6 5.4 L 34.9 4.0 M 33.7 -13.1 L 31.1 -9.5 L 27.1 -4.3 L 23.9 -.1 L 20.1 3.5 L 16.7 7.0 L 13.3 9.5 L 10.0 11.8 L 5.8 13.2 L 2.9 12.8 L 1.2 12.2 L .5 10.9 L .4 10.3","0 19.9 M 9.9 -6.3 L 10.1 -6.4 L 12.8 -7.6 L 15.2 -9.5 L 17.0 -11.5 L 17.8 -12.1 L 18.1 -12.2 L 16.3 -8.6 L 13.5 -3.5 L 11.2 1.7 L 10.8 4.1 L 10.6 6.6 L 11.7 8.5 L 14.0 8.5 L 16.4 7.3 L 19.6 4.4 L 21.8 2.0 L 23.7 -.7 L 26.2 -4.2 L 27.9 -7.2 L 28.7 -9.6 L 30.0 -11.6 L 31.7 -12.4 L 33.1 -12.6 L 30.7 -11.1 L 29.1 -9.3 L 27.5 -3.7 L 25.7 2.5 L 23.5 9.2 L 21.9 12.6 L 20.0 15.7 L 18.4 18.0 L 16.4 20.0 L 13.7 21.7 L 11.2 22.1 L 10.0 21.7 L 9.1 20.1 L 9.2 18.4 L 10.2 16.4 L 12.4 13.8 L 15.5 10.9 L 19.5 8.7 L 22.2 7.7 L 27.1 6.1 L 28.0 6.1","0 19.9 M 13.6 -8.6 L 13.3 -10.4 L 14.7 -12.0 L 17.1 -13.0 L 21.1 -13.2 L 24.9 -12.9 L 27.9 -12.4 L 30.4 -11.6 L 32.3 -11.1 L 34.0 -11.6 L 35.1 -12.2 L 35.5 -13.3 L 34.5 -13.5 L 33.1 -12.7 L 31.9 -11.5 L 27.9 -8.1 L 23.5 -3.7 L 20.5 -.2 L 18.6 1.9 L 16.2 4.3 L 14.2 5.7 L 12.4 7.0 L 10.8 7.8 L 9.6 8.1 L 9.0 7.3 L 9.5 6.7 L 11.0 7.3 L 13.6 8.3 L 16.7 10.6 L 21.0 13.3 L 25.3 15.5 L 30.3 15.5 L 32.7 14.3 L 33.8 12.1 L 33.6 11.2 L 33.4 10.3 M 16.6 -1.8 L 16.5 -1.2 L 28.7 -1.8","0 16.7 M 27.1 -11.7 L 23.1 -11.7 L 19.1 -5.9 L 14.7 1.5 L 12.0 6.6 L 11.2 8.6 L 15.4 8.6","0 12.1 M 10.4 -11.7 L 13.7 -5.2 L 15.8 .2 L 17.2 3.9 L 18.8 8.1","0 16.2 M 22.6 -11.8 L 26.6 -11.6 L 24.2 -6.1 L 20.5 .2 L 17.9 4.3 L 14.9 8.6 L 10.7 8.4","0 25.1 M 14.9 -12.0 L 21.0 -15.3 L 24.4 -11.9","0 22.5 M 8.1 10.1 L 30.4 10.1","0 12.9 M 11.3 -7.6 L 15.4 -5.1","0 16.7 M 24.7 3.2 L 23.5 4.8 L 21.9 6.5 L 19.5 8.0 L 17.6 8.4 L 16.7 7.0 L 17.1 4.5 L 18.4 .3 L 17.8 1.3 L 14.6 4.4 L 11.2 7.2 L 8.4 8.4 L 7.0 6.9 L 7.2 4.1 L 10.1 .7 L 13.7 -1.5 L 16.3 -2.3 L 18.9 -2.3 L 19.3 -1.9","0 13.2 M 8.0 3.2 L 10.5 1.0 L 13.2 -1.4 L 16.4 -3.9 L 18.9 -6.1 L 21.5 -9.5 L 22.2 -12.4 L 20.8 -13.9 L 18.0 -12.6 L 15.2 -8.9 L 12.1 -2.4 L 10.2 2.6 L 9.9 6.7 L 10.2 7.3 L 10.6 4.4 L 13.2 1.3 L 16.9 -1.0 L 19.6 -1.6 L 20.6 -.4 L 20.7 1.0 L 19.4 3.2 L 18.1 5.2 L 15.0 7.7 L 13.3 8.4 L 8.6 9.3","0 11.0 M 16.7 -.7 L 16.6 -2.1 L 15.3 -2.6 L 12.2 -1.4 L 8.5 2.4 L 7.5 3.6 L 6.7 5.5 L 6.9 6.9 L 7.5 8.2 L 10.8 8.5 L 14.9 7.2 L 17.5 5.1 L 19.0 3.2","0 12.1 M 19.4 -.9 L 18.6 -2.3 L 17.2 -2.7 L 13.8 -1.6 L 10.5 .6 L 7.8 3.4 L 7.0 5.6 L 7.2 7.4 L 9.4 8.5 L 11.5 7.0 L 14.6 4.3 L 17.8 1.0 L 21.3 -1.6 L 25.9 -5.5 L 30.2 -9.8 L 31.0 -12.2 L 30.9 -13.5 L 29.3 -13.9 L 26.8 -12.7 L 25.2 -11.1 L 23.0 -7.6 L 21.3 -4.5 L 18.3 2.1 L 16.8 6.9 L 16.4 10.4 L 17.2 12.1 L 18.6 12.6 L 19.8 12.2","0 11.0 M 11.1 3.6 L 13.7 2.3 L 15.9 1.1 L 17.0 -.7 L 16.6 -2.1 L 14.7 -2.3 L 11.0 -.1 L 9.5 1.0 L 7.9 2.9 L 6.9 4.6 L 6.7 6.2 L 7.4 7.6 L 10.0 8.7 L 14.4 7.6 L 15.8 6.4 L 17.8 4.7 L 19.0 3.2","0 10.6 M 5.5 20.6 L 7.1 19.2 L 9.3 12.0 L 12.3 4.1 L 15.3 -2.7 L 17.8 -7.4 L 19.4 -10.6 L 22.3 -13.1 L 23.8 -13.8 L 25.6 -13.1 L 25.1 -10.0 L 21.9 -5.1 L 18.2 -1.2 L 16.0 .7 L 14.5 2.0 L 12.7 2.9 L 9.8 3.2 L 9.9 2.4 L 15.6 2.5 L 18.7 2.1","0 14.9 M 18.7 -2.1 L 15.2 -2.2 L 11.2 -.1 L 8.5 2.5 L 7.2 3.8 L 6.5 5.5 L 7.1 7.2 L 8.4 8.4 L 11.9 6.8 L 14.6 4.0 L 17.4 1.0 L 18.1 .3 L 19.1 .3 L 14.2 11.7 L 10.1 19.5 L 8.3 21.1 L 6.7 22.0 L 5.3 22.2 L 3.7 21.1 L 4.3 17.9 L 6.5 16.0 L 9.7 13.2 L 11.7 11.8 L 17.2 8.3 L 20.7 5.5 L 22.9 3.2","0 17.8 M 8.0 3.2 L 12.6 -1.0 L 19.9 -6.3 L 23.2 -10.2 L 23.9 -13.3 L 21.5 -13.8 L 19.3 -12.0 L 17.1 -9.6 L 14.7 -5.5 L 12.2 -.8 L 9.4 8.0 L 12.5 4.3 L 15.1 1.0 L 18.1 -1.0 L 19.4 -1.6 L 20.1 -.9 L 19.8 .7 L 18.2 3.2 L 17.3 6.6 L 18.0 8.4 L 20.1 8.4 L 22.1 7.0 L 24.3 4.9 L 25.8 3.2","0 7.9 M 8.0 3.2 L 10.2 1.5 L 10.9 -1.4 L 7.8 6.3 L 8.4 8.3 L 10.7 8.8 L 13.2 6.8 L 14.8 4.9 L 15.9 3.2 M 12.9 -6.1 L 12.0 -4.9","0 8.2 M 8.0 3.2 L 11.1 -.1 L 12.3 -.9 L 12.6 -.5 L 6.4 13.6 L 3.5 18.8 L 1.3 21.4 L -.7 22.2 L -2.6 21.9 L -3.3 20.2 L -2.4 18.1 L 1.0 14.8 L 6.8 10.9 L 10.8 8.0 L 13.8 5.6 L 16.2 3.2 M 15.5 -6.3 L 14.3 -5.1 L 14.9 -4.6","0 11.3 M 8.0 3.2 L 10.0 1.0 L 12.1 -1.7 M 11.3 -2.3 L 14.0 -2.3 L 17.6 -4.6 L 21.1 -8.2 L 22.9 -10.9 L 23.3 -13.1 L 21.9 -14.1 L 19.1 -13.1 L 16.9 -10.6 L 14.8 -6.8 L 13.0 -3.5 L 9.6 4.6 L 8.4 8.6 L 9.8 7.3 L 12.6 3.5 L 15.8 .0 L 18.2 -1.9 L 19.8 -2.0 M 13.4 1.1 L 14.9 7.6 L 17.2 11.7 L 20.5 13.7 L 22.6 13.7 L 23.5 12.8 L 23.6 12.2 L 23.5 11.1","0 8.3 M 8.2 3.4 L 11.9 .6 L 16.6 -4.6 L 20.0 -9.7 L 21.5 -12.0 L 21.1 -13.5 L 18.9 -13.8 L 16.7 -12.4 L 13.7 -7.9 L 10.3 -1.8 L 8.1 2.7 L 7.4 6.3 L 8.3 8.2 L 10.4 8.4 L 12.8 7.3 L 15.2 4.8 L 16.3 3.2","0 21.8 M 8.0 3.2 L 10.5 .9 L 11.4 -1.2 L 7.9 8.1 L 10.2 5.7 L 14.3 1.0 L 16.4 -.8 L 17.9 -1.7 L 18.6 -1.8 L 18.8 -.9 L 18.4 .3 L 15.6 5.6 L 19.1 2.8 L 21.8 .7 L 24.6 -.3 L 23.2 1.7 L 21.7 6.0 L 22.1 7.8 L 24.0 8.4 L 26.8 6.8 L 29.8 3.2","0 18.4 M 13.7 -1.4 L 10.3 8.2 L 14.8 3.1 L 17.6 .1 L 19.6 -1.1 L 21.1 -1.7 L 21.5 -.9 L 19.5 2.8 L 18.2 5.8 L 18.3 7.5 L 19.4 8.5 L 21.3 8.2 L 23.3 6.8 L 25.3 4.8 L 26.4 3.2","0 12.4 M 15.2 -1.7 L 13.5 -2.6 L 11.1 -1.0 L 8.8 1.6 L 7.7 3.9 L 7.2 6.6 L 9.4 8.7 L 12.2 7.7 L 14.8 5.5 L 16.3 2.4 L 16.6 1.2 L 16.6 .0 L 16.0 .0 M 14.3 4.0 L 14.8 5.8 L 15.8 6.7 L 17.1 6.6 L 18.4 5.5 L 20.4 3.2","0 11.3 M 9.8 -2.4 L 6.7 7.2 L 3.4 15.1 L 1.8 20.1 L .9 20.7 L 6.1 7.8 L 7.6 8.6 L 11.7 7.0 L 15.6 4.7 L 17.2 1.8 L 17.5 -.5 L 16.2 -2.0 L 13.4 -1.2 L 11.3 .3 L 9.5 2.7 L 8.2 4.3 L 6.1 8.0","0 17.2 M 19.3 -1.6 L 16.1 -2.4 L 11.8 -.3 L 7.9 3.3 L 7.1 5.2 L 7.3 6.8 L 8.0 8.1 L 10.1 8.2 L 12.8 6.6 L 14.9 4.1 L 19.0 .0 L 22.4 -4.2 L 20.8 -3.9 L 17.1 6.1 L 13.4 15.5 L 13.1 20.1 L 14.1 21.8 L 16.8 21.8 L 17.9 20.3 L 18.3 16.9 L 17.9 12.5 L 16.8 7.9 L 19.2 8.1 L 22.1 6.5 L 24.1 4.7 L 25.1 3.2","0 11.7 M 8.0 3.2 L 10.1 -.1 L 13.9 -5.7 L 10.5 -3.4 L 10.5 -2.6 L 10.9 -2.3 L 17.2 -2.2 L 13.6 2.2 L 11.6 5.8 L 12.1 8.3 L 14.9 8.1 L 18.4 4.8 L 19.7 3.2","0 9.6 M 8.0 3.2 L 9.3 2.1 L 10.1 .7 L 11.1 -1.4 L 12.7 -3.5 L 16.9 -5.2 L 18.3 -5.4 L 19.9 -5.1 L 20.1 -4.1 L 19.9 -3.1 L 19.4 -2.6 M 10.7 .3 L 11.3 1.6 L 14.1 3.2 L 15.3 4.7 L 15.2 6.2 L 13.8 7.9 L 11.5 9.2 L 10.0 9.9 L 8.2 10.0 L 7.9 9.6 L 7.9 8.5 L 8.5 7.9","0 9.2 M 8.0 3.2 L 9.6 1.9 L 10.7 .7 L 12.5 -1.7 L 14.8 -5.5 L 15.9 -7.2 L 14.8 -7.4 L 9.3 4.2 L 8.8 6.9 L 9.6 8.3 L 12.1 8.1 L 15.1 5.5 L 17.2 3.2 M 10.7 -2.0 L 17.2 -2.3","0 15.7 M 10.5 -.8 L 8.4 2.1 L 7.3 5.1 L 7.2 7.2 L 8.7 8.1 L 11.5 7.3 L 13.6 4.6 L 16.2 1.4 L 18.3 -2.2 L 19.3 -1.9 L 15.8 3.8 L 15.5 5.9 L 15.4 7.3 L 17.1 8.3 L 19.2 7.7 L 22.1 5.2 L 23.7 3.2","0 10.2 M 8.0 3.2 L 10.8 .3 L 11.3 -.9 L 11.2 -1.7 L 10.1 -2.3 L 9.0 -2.3 M 10.3 -1.6 L 9.9 3.6 L 9.0 6.3 L 9.0 8.7 L 13.0 3.1 L 16.1 -.5 L 19.1 -3.1 L 21.8 -4.7 L 23.2 -4.3","0 17.6 M 11.2 -2.0 L 8.6 1.8 L 7.2 5.2 L 7.0 6.8 L 7.4 8.0 L 8.9 8.4 L 10.8 7.7 L 12.8 5.4 L 15.2 1.8 L 16.5 -.2 L 17.4 -.1 L 15.5 3.4 L 15.2 6.3 L 16.1 8.0 L 17.9 8.5 L 21.4 6.4 L 24.9 2.5 L 26.5 -.9 L 26.5 -2.7 L 25.8 -4.4 L 24.1 -4.8","0 15.5 M 8.0 3.2 L 10.9 -.7 L 13.0 -1.2 L 13.5 .2 L 14.0 2.6 L 14.7 5.3 L 15.4 7.7 L 17.6 8.6 L 19.8 7.7 L 21.6 5.8 L 23.5 3.2 M 21.7 -2.0 L 20.5 -1.9 L 16.2 1.5 L 12.5 4.7 L 8.9 8.8 L 6.4 12.2 L 5.9 13.2 L 5.3 14.8","0 15.5 M 11.8 -.9 L 9.1 1.6 L 8.0 3.1 L 7.5 4.8 L 7.3 6.3 L 7.8 7.5 L 9.4 8.0 L 11.2 7.5 L 14.6 4.2 L 17.9 .2 L 19.6 -1.6 L 20.7 -1.5 L 17.7 4.6 L 14.8 12.1 L 12.4 16.3 L 9.9 20.0 L 8.1 21.6 L 4.7 21.5 L 3.7 20.0 L 5.1 17.0 L 8.5 14.3 L 12.9 11.1 L 17.4 8.7 L 21.9 5.1 L 23.5 3.2","0 17.5 M 10.1 2.6 L 11.7 .2 L 13.6 -1.5 L 15.8 -1.8 L 18.6 -1.0 L 21.2 -.4 L 23.2 -1.1 L 23.5 -1.8 L 22.7 -2.3 L 21.6 -1.6 L 19.8 .1 L 13.0 6.3 L 10.9 8.3 L 9.1 8.7 L 8.6 7.8 L 9.6 6.9 L 11.1 6.9 L 12.7 7.7 L 16.0 9.5 L 19.0 9.6 L 21.2 8.1 L 23.9 5.3 L 25.5 3.2","0 15.5 M 22.7 -12.2 L 18.5 -11.4 L 16.4 -8.3 L 16.2 -5.1 L 15.0 -3.2 L 13.2 -2.7 L 11.0 -2.5 L 13.0 -1.4 L 13.9 .3 L 12.9 2.4 L 11.4 4.0 L 10.1 6.7 L 11.3 9.1 L 12.6 9.6 L 14.0 9.9","0 9.4 M 13.2 -12.7 L 13.0 9.9","0 17.7 M 20.8 -12.4 L 23.2 -12.1 L 24.3 -10.9 L 24.0 -9.0 L 22.7 -7.2 L 21.6 -5.1 L 20.7 -3.2 L 22.3 -2.5 L 24.3 -2.3 L 20.9 -1.0 L 19.3 .3 L 18.6 1.8 L 18.3 4.4 L 17.1 6.6 L 14.1 9.6 L 12.8 9.9 L 9.9 10.0","0 15.6 M 14.1 -5.7 L 15.2 -6.8 L 16.8 -6.8 L 19.2 -6.0 L 21.2 -5.2 L 21.9 -5.9 L 22.4 -6.3","0 13.2 M 14.2 -15.9 L 13.1 -14.3 L 13.0 -12.8 L 14.4 -11.5 L 17.1 -10.8 L 19.2 -12.3 L 19.3 -15.4 L 18.0 -16.5 L 17.0 -16.7 L 15.5 -16.8 L 14.2 -15.9"]
EMSBird = ["-8 8","0 8.4 M 19.1 -14.1 L 19.9 -14.0 L 15.8 -6.3 L 13.5 -.8 L 13.4 .6 L 13.5 1.2 M 11.5 6.1 L 10.9 7.3","0 13.3 M 14.8 -12.3 L 15.1 -10.6 L 13.6 -8.1 L 11.6 -6.2 M 19.0 -12.3 L 19.3 -10.6 L 17.8 -8.1 L 15.8 -6.2","0 25.0 M 20.4 -9.5 L 14.9 5.8 M 27.5 -9.5 L 21.8 6.0 M 10.9 1.1 L 28.6 1.2 M 13.2 -5.1 L 31.5 -5.2","0 21.5 M 24.5 -6.8 L 24.5 -8.0 L 23.7 -9.1 L 22.1 -9.3 L 20.4 -9.3 L 18.2 -8.5 L 16.5 -7.5 L 15.2 -6.4 L 14.6 -4.6 L 15.4 -2.6 L 16.9 -1.5 L 20.3 -.4 L 21.8 .8 L 22.5 2.3 L 22.4 3.7 L 21.4 5.0 L 18.9 6.6 L 17.0 7.4 L 14.7 7.6 L 13.5 7.6 L 12.7 7.1 L 12.1 6.0 M 23.1 -13.2 L 15.1 9.8 L 14.6 11.5 L 14.6 12.4 L 14.9 13.5","0 19.6 M 15.4 -11.1 L 13.3 -9.0 L 11.7 -6.6 L 11.1 -4.7 L 11.6 -3.2 L 12.9 -3.4 L 14.8 -4.3 L 16.4 -6.1 L 17.4 -8.0 L 17.7 -9.1 L 18.1 -10.1 L 18.2 -11.3 L 17.8 -11.9 L 16.9 -12.1 L 16.1 -11.8 L 18.0 -9.6 L 19.1 -9.6 L 22.6 -10.5 L 26.2 -11.5 L 17.4 -.5 L 12.9 5.9 L 11.8 8.1 L 11.4 9.2 L 11.4 10.4 L 11.6 10.5 M 21.5 1.6 L 19.0 4.0 L 17.4 6.5 L 16.8 8.1 L 17.1 9.4 L 18.4 9.9 L 20.1 8.9 L 21.9 6.7 L 23.0 5.2 L 23.5 4.1 L 23.8 2.7 L 23.9 1.6 L 23.2 1.1 L 21.9 1.4 L 22.2 2.5 L 23.6 3.1 L 24.2 3.2","0 28.2 M 26.2 -5.5 L 26.6 -5.7 L 28.9 -6.5 L 30.5 -7.9 L 31.5 -9.3 L 31.6 -10.3 L 31.1 -11.5 L 30.3 -12.4 L 28.4 -13.0 L 26.4 -13.0 L 21.9 -12.4 L 17.5 -10.9 L 15.4 -9.4 L 13.7 -7.3 L 13.2 -5.5 L 13.4 -3.8 L 14.9 -3.0 L 16.6 -2.7 L 18.3 -2.8 L 20.8 -3.1 L 16.4 -1.6 L 14.1 -.3 L 12.3 1.6 L 11.2 3.8 L 11.2 5.7 L 12.4 7.1 L 14.7 8.3 L 18.5 8.4 L 22.6 7.6 L 25.8 5.9 L 28.2 3.7 L 28.8 1.3 L 28.4 -.7 L 27.7 -1.2 L 26.8 -1.8 M 21.7 1.0 L 21.7 -.2 L 22.8 -1.6 L 23.8 -2.1 L 25.8 -2.1 L 28.6 -1.5 L 30.9 -.9 L 32.8 -.5 L 33.9 -.5 L 35.0 -.9","0 6.6 M 15.9 -9.9 L 16.6 -10.2 L 16.6 -8.7 L 15.6 -6.5 L 14.5 -5.3 L 13.4 -4.4","0 8.7 M 21.8 -14.1 L 19.4 -13.9 L 15.5 -12.3 L 11.9 -9.4 L 9.5 -5.9 L 8.2 -2.7 L 7.5 2.2 L 7.8 5.3 L 8.8 8.3 L 10.3 9.3 L 10.8 9.5","0 12.5 M 14.9 -14.4 L 17.7 -13.9 L 19.5 -12.4 L 20.4 -10.1 L 20.1 -6.3 L 18.9 -2.8 L 16.9 .9 L 14.7 3.7 L 11.9 6.6 L 9.5 8.3 L 6.9 8.9","0 6.5 M 8.8 -13.5 L 13.1 -10.9 M 11.1 -14.6 L 11.1 -9.8 M 13.2 -13.6 L 9.0 -11.0","0 12.4 M 15.7 -2.0 L 12.9 7.3 M 10.4 2.2 L 18.9 2.1","0 6.4 M 11.4 7.0 L 12.4 6.3 L 11.7 8.8 L 10.4 10.9 L 8.6 12.8","0 9.4 M 9.7 2.5 L 9.1 3.2 L 15.2 3.0","0 7.9 M 12.9 6.1 L 12.0 6.9 L 12.5 7.5 L 12.9 6.1 L 12.9 6.1","0 19.9 M 26.4 -15.0 L 20.9 -8.4 L 16.8 -3.0 L 13.5 1.8 L 10.9 5.8 L 9.3 8.6 L 8.8 9.9 L 9.0 11.1 L 9.2 11.5","0 10.6 M 11.4 8.0 L 13.0 7.8 L 15.0 5.9 L 16.2 3.5 L 16.9 1.0 L 17.2 -1.7 L 16.9 -3.6 L 15.6 -4.3 L 13.9 -3.9 L 11.9 -1.7 L 10.6 .7 L 10.0 3.3 L 9.9 5.6 L 10.2 7.4 L 11.4 8.0","0 8.9 M 10.5 7.8 L 15.0 -4.5 L 13.4 -2.8 L 11.3 -1.3 L 9.3 -.1","0 13.1 M 13.0 -3.9 L 10.7 -2.0 L 13.6 -3.4 L 16.5 -4.2 L 18.6 -4.3 L 19.8 -3.4 L 19.7 -1.6 L 18.0 .8 L 14.9 3.6 L 11.3 5.9 L 9.4 6.6 L 8.5 7.3 L 8.6 7.7 L 11.7 6.9 L 15.2 6.2 L 18.0 6.0 L 19.4 6.3 L 19.8 6.8 L 19.8 7.7 L 19.3 8.6","0 16.2 M 15.8 -3.8 L 13.7 -2.1 L 16.6 -3.4 L 19.6 -4.4 L 21.7 -4.2 L 22.6 -3.4 L 22.7 -1.8 L 21.7 -.5 L 19.7 .9 L 17.1 1.8 L 14.2 2.3 L 17.0 2.0 L 19.3 2.1 L 21.1 2.7 L 22.3 4.5 L 22.2 7.0 L 21.0 9.5 L 18.9 11.4 L 16.1 12.9 L 12.9 13.5 L 10.4 13.2 L 8.4 11.6 L 8.1 9.5 L 9.2 7.7 L 11.0 6.6 L 12.8 6.4","0 14.9 M 16.9 11.1 L 16.7 12.2 L 16.0 13.2 L 18.4 5.9 L 20.3 .6 L 22.4 -4.4 L 17.3 -.1 L 12.1 4.3 L 8.2 7.3 L 11.0 6.8 L 14.2 6.5 L 17.2 6.3 L 19.8 6.1 L 21.2 6.3 L 22.0 6.7 L 21.9 7.4 L 21.5 8.6","0 15.7 M 13.6 6.4 L 11.1 7.1 L 9.6 8.7 L 9.5 10.9 L 10.8 12.3 L 13.0 12.9 L 16.3 12.6 L 19.2 11.3 L 21.4 9.0 L 22.2 6.1 L 21.9 4.0 L 20.2 2.4 L 18.2 1.8 L 15.8 2.1 L 13.9 2.6 L 16.4 -3.5 L 16.2 -3.5 L 20.0 -4.2 L 22.9 -4.4 L 24.6 -4.2 L 25.4 -3.8 L 25.4 -3.2 L 25.0 -2.0","0 18.7 M 25.0 -11.5 L 23.1 -10.0 L 19.6 -7.7 L 15.6 -4.3 L 12.4 -.5 L 10.9 2.1 L 10.5 4.4 L 11.0 6.3 L 12.4 7.4 L 15.4 7.3 L 18.6 6.2 L 21.7 3.8 L 23.6 1.3 L 24.5 -.9 L 24.2 -2.5 L 23.2 -3.4 L 21.0 -3.2 L 18.5 -1.9 L 16.4 .5 L 14.9 2.8 L 14.5 4.1 L 14.3 6.0","0 13.7 M 9.9 -4.2 L 8.9 -.3 L 9.6 -1.5 L 10.6 -2.9 L 11.9 -3.8 L 14.2 -4.0 L 17.1 -3.7 L 21.0 -3.3 L 21.7 -3.9 L 16.3 1.2 L 13.3 4.4 L 11.1 7.5 L 10.0 9.8 L 9.1 12.1 L 9.1 13.7","0 13.5 M 21.3 -6.6 L 21.6 -7.6 L 21.1 -8.8 L 19.6 -9.5 L 17.6 -9.4 L 15.3 -8.7 L 13.7 -7.5 L 12.8 -5.3 L 13.4 -3.2 L 14.9 -1.5 L 17.1 -.1 L 18.9 1.6 L 19.8 3.4 L 19.3 5.0 L 17.3 6.7 L 15.0 7.8 L 12.4 8.2 L 10.2 7.6 L 9.4 6.5 L 9.5 4.4 L 11.0 2.3 L 12.9 .8 L 18.0 -2.4 L 20.7 -3.9 L 22.8 -5.9 L 23.8 -7.8 L 24.1 -9.7","0 16.9 M 11.6 7.4 L 10.5 8.0 L 10.1 8.8 L 11.7 7.8 L 14.3 5.8 L 17.4 3.6 L 20.3 .6 L 22.4 -2.4 L 23.3 -5.0 L 23.7 -7.3 L 23.3 -9.0 L 20.6 -10.2 L 17.7 -9.7 L 14.2 -8.3 L 11.5 -5.9 L 10.6 -4.0 L 10.4 -2.2 L 10.9 -.7 L 12.6 .0 L 14.6 -.2 L 17.7 -1.8 L 19.8 -4.0 L 21.2 -6.3 L 21.4 -8.1","0 6.5 M 13.8 -3.6 L 12.9 -2.6 L 13.4 -1.8 M 12.3 3.3 L 11.5 4.4 L 11.9 5.1","0 6.5 M 14.1 -.1 L 13.2 1.0 L 13.4 1.7 M 11.3 7.2 L 12.3 6.3 L 11.9 8.6 L 10.7 10.5 L 9.3 12.1","0 10.4 M 14.9 -6.5 L 11.3 -1.4 L 15.0 2.9","0 13.1 M 12.7 -.3 L 11.9 .5 L 15.9 .5 L 18.5 .1 M 12.7 2.4 L 11.9 3.2 L 15.9 3.2 L 18.5 2.8","0 10.2 M 10.8 -6.3 L 13.6 -3.1 L 14.5 -2.4 L 10.9 2.9","0 15.2 M 14.4 -6.3 L 13.2 -6.7 L 12.9 -7.9 L 13.1 -9.1 L 13.9 -10.4 L 15.4 -11.7 L 17.5 -12.7 L 19.8 -13.4 L 21.6 -13.5 L 23.4 -13.2 L 24.5 -12.5 L 25.1 -11.8 L 25.3 -10.1 L 25.1 -8.9 L 23.5 -6.4 L 22.0 -5.1 L 18.8 -3.0 L 15.9 -1.2 L 14.9 -.3 L 14.0 .8 L 13.7 2.0 L 13.9 2.3 M 13.0 5.8 L 12.1 6.9 L 12.5 7.6","0 29.3 M 15.7 -13.4 L 17.8 -13.4 L 20.6 -13.4 L 24.4 -12.6 L 27.2 -12.1 L 30.3 -10.6 L 32.3 -8.9 L 33.9 -6.5 L 34.5 -4.3 L 34.5 -2.9 L 34.0 -1.1 L 32.9 1.2 L 30.5 3.6 L 28.2 5.1 L 24.8 6.6 L 21.5 7.3 L 17.9 7.2 L 15.2 6.3 L 13.0 4.0 L 11.6 1.0 L 11.3 -2.0 L 12.6 -6.5 L 14.6 -9.2 L 17.8 -11.8 L 19.9 -13.0 L 22.5 -13.9 L 25.8 -14.3 L 28.0 -14.6 L 30.9 -14.3 L 33.2 -12.9 L 34.1 -11.4 L 34.2 -10.2 L 34.0 -8.6 L 33.2 -6.3 L 32.4 -4.5 L 30.2 -1.2 L 28.9 .3 L 27.4 1.7 L 26.0 2.9 L 24.7 3.3 L 23.7 3.1 L 23.5 2.3 L 24.0 -.1 L 25.2 -4.6 L 26.2 -6.4 L 27.2 -7.7 L 27.3 -8.4 L 26.6 -8.3 L 26.1 -6.7 L 25.5 -4.8 L 23.4 -2.2 L 21.7 -.2 L 20.3 1.5 L 18.4 2.9 L 17.6 2.8 L 17.5 1.1 L 18.9 -3.1 L 20.1 -5.4 L 21.7 -7.6 L 22.6 -8.3 L 23.7 -8.6 L 24.7 -8.6 L 26.6 -8.2","0 20.2 M 9.4 7.7 L 9.4 7.7 L 10.8 3.2 L 12.8 -1.1 L 15.7 -5.7 L 18.0 -8.8 L 20.3 -11.5 L 21.7 -12.9 L 22.4 -13.5 L 22.5 -14.0 L 22.0 -14.3 L 21.6 -13.9 L 22.7 -12.0 L 24.3 -6.3 L 25.1 -1.0 L 25.6 4.1 L 25.9 7.3 M 10.9 -1.7 L 26.3 -1.8","0 20.0 M 11.2 -13.6 L 16.6 -13.2 L 20.6 -11.9 L 23.0 -10.2 L 23.6 -8.1 L 22.5 -5.4 L 19.7 -3.4 L 17.1 -2.5 L 14.4 -2.1 L 12.0 -2.0 L 17.5 -2.3 L 22.2 -2.1 L 24.8 -1.4 L 26.6 .5 L 26.7 3.1 L 24.7 5.3 L 21.7 7.0 L 16.7 7.9 L 10.8 7.5 L 12.0 7.5 L 12.0 8.2 L 11.9 2.5 L 12.0 -4.3 L 13.1 -9.8 L 14.1 -14.6 L 14.5 -14.8","0 22.4 M 26.9 -8.6 L 27.1 -8.7 L 27.6 -9.6 L 27.3 -11.7 L 25.3 -13.3 L 22.6 -13.7 L 18.4 -13.3 L 14.9 -11.3 L 12.3 -8.6 L 10.4 -4.2 L 10.0 -.3 L 10.9 4.1 L 13.1 6.3 L 16.1 7.9 L 19.5 8.3 L 23.2 7.7 L 26.4 6.2 L 27.9 5.2 L 29.0 3.8 L 29.0 3.3","0 24.0 M 11.4 -13.2 L 12.3 -13.4 L 16.2 -13.4 L 20.7 -13.0 L 24.0 -12.2 L 26.8 -10.9 L 29.1 -9.1 L 30.8 -6.6 L 31.2 -3.5 L 30.0 -.1 L 27.8 2.9 L 24.7 5.1 L 20.0 7.0 L 15.8 7.8 L 13.3 7.6 L 11.7 7.0 L 11.6 3.3 L 12.1 -3.7 L 13.0 -8.9 L 14.2 -14.7 L 14.7 -15.1","0 18.9 M 14.8 -14.9 L 13.6 -11.4 L 12.5 -4.9 L 11.9 1.9 L 11.7 7.3 L 10.8 7.2 L 24.2 7.2 L 24.6 6.8 M 11.2 -3.1 L 22.1 -3.2 M 11.3 -13.5 L 11.9 -13.4 L 24.6 -13.4 L 24.7 -12.7","0 15.5 M 10.9 6.3 L 11.2 7.4 L 10.6 7.5 L 10.9 1.7 L 11.7 -5.4 L 12.7 -10.4 L 13.7 -14.6 L 14.3 -15.0 M 10.8 -13.6 L 24.1 -13.2 L 24.1 -12.5 M 10.4 -3.2 L 21.5 -3.2","0 24.4 M 28.6 -8.4 L 29.3 -9.5 L 29.3 -11.2 L 27.7 -12.8 L 25.0 -13.5 L 21.3 -13.5 L 16.2 -11.8 L 12.8 -8.7 L 10.8 -5.0 L 10.1 -1.2 L 10.7 2.6 L 12.3 5.5 L 15.2 7.5 L 18.9 8.3 L 22.2 8.0 L 25.5 6.8 L 27.4 5.2 L 28.9 3.6 L 29.4 2.0 L 29.8 -.9 L 29.0 3.8 L 28.8 5.9 L 28.6 7.9 M 21.7 -1.0 L 31.8 -.9","0 19.4 M 14.4 -13.3 L 12.7 -9.2 L 11.5 -2.2 L 11.2 2.3 L 11.0 7.5 M 10.7 -2.9 L 26.2 -2.9 M 27.1 -13.1 L 26.2 -10.1 L 25.1 -4.3 L 24.5 1.7 L 24.2 7.7","0 14.5 M 12.8 -13.4 L 22.5 -13.3 M 17.9 -14.1 L 15.9 -6.4 L 15.1 2.3 L 14.6 7.8 M 10.0 7.3 L 19.6 7.3","0 15.0 M 9.3 3.1 L 11.1 6.6 L 13.4 8.3 L 15.4 8.0 L 16.8 5.2 L 17.5 -.8 L 18.5 -8.7 L 19.0 -13.0 L 19.8 -14.2 M 14.5 -13.3 L 14.7 -13.3 L 23.6 -13.3","0 20.6 M 13.3 -11.4 L 13.6 -12.9 L 14.4 -13.5 L 13.0 -9.1 L 11.9 -1.8 L 11.4 2.8 L 11.1 7.6 M 28.5 -14.6 L 28.3 -13.7 L 24.3 -9.8 L 19.6 -6.3 L 16.0 -4.1 L 14.0 -3.5 L 12.3 -3.3 L 10.8 -3.3 L 13.7 -.5 L 16.5 2.6 L 19.3 5.2 L 22.1 7.3 L 24.7 8.1 L 26.0 7.5 L 26.8 5.5 L 26.7 2.7","0 19.2 M 13.4 -11.1 L 14.0 -12.6 L 15.3 -13.4 L 14.0 -11.1 L 13.0 -5.3 L 12.2 1.3 L 11.7 8.0 L 11.7 7.5 L 10.9 7.3 L 22.8 7.5 L 24.0 7.5 L 25.0 6.9","0 24.0 M 10.0 7.7 L 10.4 2.8 L 11.3 -1.7 L 12.2 -5.9 L 13.5 -9.8 L 15.4 -13.3 L 14.1 -13.3 L 13.5 -12.6 L 13.7 -10.0 L 14.1 -6.8 L 14.7 -3.1 L 16.9 1.2 L 19.0 2.5 L 21.7 1.4 L 24.2 -1.0 L 26.5 -4.2 L 28.3 -7.3 L 29.7 -9.5 L 30.2 -11.8 L 30.7 -13.2 L 29.2 -12.5 L 29.1 -10.2 L 29.0 -5.6 L 28.6 -.6 L 28.6 3.6 L 28.5 7.3 L 29.0 7.7","0 20.1 M 10.9 7.1 L 11.3 1.2 L 12.2 -4.1 L 13.1 -8.8 L 13.7 -10.8 L 14.4 -12.2 L 14.9 -13.0 L 14.8 -13.4 L 13.9 -12.9 L 13.6 -11.9 L 14.4 -10.7 L 14.9 -8.8 L 17.8 -5.1 L 20.2 -2.7 L 22.5 -.2 L 24.5 1.7 L 25.3 3.2 L 25.8 4.6 L 25.8 6.3 L 25.6 7.4 L 25.3 7.6 L 25.4 5.5 L 25.5 2.6 L 26.2 -3.5 L 27.1 -9.0 L 27.6 -12.2 L 28.4 -13.2","0 25.1 M 12.0 -9.8 L 15.4 -11.4 L 19.5 -12.4 L 23.2 -12.3 L 26.1 -12.1 L 29.1 -10.7 L 31.6 -8.1 L 32.1 -4.9 L 31.4 -.4 L 29.8 2.9 L 26.8 5.8 L 22.1 8.0 L 17.7 8.2 L 13.9 6.9 L 11.3 4.1 L 10.2 .2 L 10.9 -4.6 L 12.3 -7.6 L 14.2 -10.0 L 17.1 -13.0 L 20.4 -14.7 L 23.7 -15.5 L 25.7 -14.7 L 25.3 -13.7 L 24.2 -11.6","0 16.0 M 11.1 7.5 L 11.3 1.2 L 11.9 -3.6 L 12.9 -9.0 L 13.4 -12.0 L 14.1 -14.6 L 14.7 -14.8 M 11.3 -13.7 L 11.5 -13.7 L 16.8 -13.4 L 19.9 -12.6 L 22.7 -10.8 L 23.6 -8.3 L 22.4 -5.3 L 20.3 -3.3 L 17.5 -2.1 L 14.7 -1.9 L 11.8 -2.0","0 25.1 M 12.0 -9.8 L 12.2 -9.8 L 15.5 -11.4 L 18.8 -12.3 L 22.0 -12.5 L 25.5 -12.2 L 28.9 -11.1 L 30.9 -8.9 L 32.1 -5.6 L 31.9 -1.7 L 30.1 2.7 L 26.9 5.8 L 23.7 7.4 L 20.3 8.2 L 15.4 7.6 L 12.2 5.2 L 10.3 .8 L 10.8 -3.9 L 12.3 -7.5 L 14.7 -10.6 L 17.3 -13.0 L 20.3 -14.6 L 23.5 -15.4 L 25.0 -15.3 L 25.7 -14.7 L 25.5 -13.9 L 25.0 -12.5 L 24.3 -11.5 M 15.3 4.4 L 16.6 3.4 L 18.1 3.4 L 19.7 4.5 L 20.9 6.0 L 21.8 7.5 L 23.5 10.2 L 25.1 12.9 L 27.7 15.1 L 29.9 15.7 L 31.9 15.1 L 32.7 14.3 L 33.1 12.6","0 19.1 M 11.0 7.5 L 11.2 2.0 L 11.9 -3.3 L 13.0 -9.4 L 14.1 -14.2 L 14.6 -14.8 M 11.4 -13.6 L 16.8 -13.3 L 20.7 -12.3 L 22.8 -11.2 L 23.8 -9.4 L 23.7 -7.1 L 22.3 -4.9 L 19.9 -2.8 L 17.4 -2.1 L 14.9 -1.9 L 12.5 -1.8 L 10.9 -2.3 L 14.4 1.0 L 17.8 4.3 L 20.5 6.6 L 23.2 8.1 L 24.8 8.2 L 25.6 7.3 L 26.1 5.4 L 26.1 2.9","0 16.0 M 9.6 5.4 L 9.9 6.8 L 11.2 7.8 L 13.4 8.2 L 16.9 7.3 L 19.4 6.2 L 21.0 4.7 L 22.0 2.8 L 22.1 1.5 L 21.8 .3 L 20.5 -.7 L 16.8 -2.1 L 13.2 -4.0 L 11.5 -6.1 L 11.3 -8.5 L 12.6 -10.5 L 15.4 -12.6 L 18.4 -13.7 L 21.1 -13.7 L 22.6 -13.1 L 23.3 -11.8 L 23.0 -9.9","0 18.4 M 15.6 7.6 L 15.8 3.9 L 16.2 -1.9 L 17.1 -7.2 L 17.9 -11.5 L 18.0 -12.8 L 18.9 -13.6 M 9.5 -13.3 L 26.8 -13.3","0 18.5 M 12.0 -11.4 L 13.2 -13.3 L 14.2 -13.7 L 12.2 -9.4 L 11.0 -5.0 L 10.3 .4 L 10.6 4.7 L 11.5 6.4 L 13.6 7.2 L 16.0 6.2 L 18.4 3.7 L 20.8 .7 L 23.6 -3.7 L 25.1 -7.2 L 26.2 -10.4 L 27.1 -13.3 L 26.2 -13.0 L 25.6 -12.2 L 25.0 -6.8 L 24.3 -1.2 L 23.8 3.6 L 23.6 7.6","0 17.1 M 11.1 -11.4 L 11.6 -13.0 L 12.9 -14.2 L 12.0 -11.8 L 11.0 -7.1 L 10.8 -2.7 L 10.8 1.5 L 11.6 5.1 L 12.6 6.7 L 13.9 7.3 L 15.5 7.0 L 17.4 5.3 L 19.2 3.2 L 21.1 .3 L 23.0 -3.4 L 24.5 -7.4 L 25.6 -11.6 L 26.1 -13.4 L 26.0 -15.3","0 27.9 M 12.1 -11.2 L 12.9 -13.3 L 14.3 -14.1 L 12.8 -11.5 L 11.3 -7.0 L 10.7 -2.4 L 10.3 1.5 L 10.4 4.3 L 11.3 6.5 L 12.8 7.2 L 14.3 7.0 L 15.6 6.1 L 17.7 4.0 L 19.4 1.5 L 21.3 -2.0 L 22.3 -4.2 L 23.6 -8.6 L 24.4 -11.0 L 25.1 -12.5 L 24.4 -12.5 L 23.6 -11.6 L 23.7 -10.8 L 23.6 -9.1 L 22.9 -4.7 L 22.6 -.5 L 23.0 3.7 L 24.1 6.5 L 26.1 7.3 L 28.3 6.2 L 30.9 2.9 L 32.8 -.5 L 34.4 -4.9 L 35.7 -8.7 L 36.4 -11.5 L 36.1 -14.0","0 22.1 M 8.0 8.1 L 10.5 4.5 L 13.7 1.0 L 17.0 -2.3 L 20.8 -5.6 L 24.3 -9.0 L 26.3 -11.4 L 26.9 -12.7 L 27.0 -13.7 M 15.2 -13.5 L 14.0 -13.5 L 13.5 -12.6 L 14.4 -9.9 L 15.8 -5.6 L 18.1 -.1 L 20.7 4.5 L 22.7 7.2 L 23.9 7.7 L 25.1 7.5 L 26.5 6.4 L 27.6 4.8 L 28.8 1.7","0 14.6 M 10.5 -13.3 L 9.5 -13.0 L 9.6 -11.6 L 11.1 -6.8 L 12.8 -2.6 L 13.2 -1.3 L 12.5 2.9 L 11.7 5.4 L 11.0 6.9 L 11.4 7.0 L 12.3 5.3 L 12.2 4.3 M 13.2 -1.7 L 13.4 -1.7 L 16.7 -4.6 L 20.4 -8.5 L 22.3 -11.1 L 23.6 -13.7","0 18.4 M 13.1 -11.4 L 12.3 -12.5 L 14.6 -13.2 L 18.0 -13.4 L 21.3 -13.4 L 24.7 -13.2 L 25.5 -12.7 L 25.4 -11.5 L 23.6 -9.8 L 18.5 -4.4 L 14.7 -.6 L 11.2 3.2 L 9.5 5.4 L 8.8 6.4 L 9.2 7.3 L 13.0 6.6 L 17.2 6.0 L 22.3 5.7 L 24.3 6.1 L 24.9 6.5 L 24.9 7.5 L 24.2 8.5","0 19.2 M 25.7 -14.3 L 21.2 -14.2 L 20.3 -13.7 L 16.6 -8.8 L 13.9 -3.8 L 11.2 1.1 L 10.0 3.7 L 9.2 5.9 L 9.1 7.3 L 9.9 7.9 L 11.4 8.0 L 15.8 8.0","0 19.8 M 9.7 -14.6 L 14.2 -9.3 L 17.9 -4.4 L 21.1 -.1 L 24.5 4.8 L 25.9 7.0 L 26.7 8.7 L 27.3 10.0 L 27.3 10.7","0 18.1 M 18.7 -14.2 L 22.8 -14.3 L 25.2 -13.9 L 25.4 -13.1 L 24.7 -10.9 L 22.3 -5.9 L 19.9 -1.2 L 17.2 3.3 L 14.8 6.9 L 13.6 7.9 L 12.5 8.3 L 8.7 8.2","0 11.0 M 9.6 -7.3 L 13.2 -9.9 L 16.6 -7.5","0 11.1 M 8.3 8.4 L 18.5 8.4","0 11.6 M 10.8 -11.2 L 15.9 -8.2","0 10.9 M 17.7 -3.6 L 15.3 -4.1 L 13.5 -3.9 L 11.1 -.8 L 10.0 1.4 L 9.0 4.0 L 8.5 6.0 L 8.6 7.1 L 9.1 7.6 L 10.6 6.7 L 12.6 4.7 L 14.5 2.3 L 15.8 .6 L 16.8 -1.6 L 17.3 -2.8 L 17.7 -3.9 L 18.1 -4.1 L 17.9 -3.1 L 16.5 -.6 L 15.5 2.8 L 14.9 5.3 L 14.7 6.8 L 14.9 7.4 L 15.4 7.5 L 16.5 7.1 L 17.6 6.2 L 18.8 4.9","0 9.5 M 15.6 -13.1 L 15.0 -11.9 L 12.9 -5.6 L 10.9 .1 L 9.8 3.0 L 9.2 4.5 L 9.2 6.3 L 10.0 7.9 L 11.7 7.7 L 12.9 7.1 L 14.3 5.9 L 15.6 3.2 L 16.3 1.6 L 17.0 -.7 L 17.2 -2.4 L 17.2 -3.4 L 17.0 -4.0 L 15.9 -3.6 L 14.5 -2.3 L 12.7 .1 L 11.4 1.7 L 10.4 3.2 L 9.6 4.8 L 9.0 7.0 L 8.5 7.4 L 8.2 6.6 L 8.8 5.1 L 11.1 3.7 L 13.4 2.2 L 15.9 .6 L 18.0 -.3","0 7.5 M 15.8 -1.5 L 16.2 -2.7 L 15.9 -3.5 L 15.2 -4.0 L 13.5 -3.7 L 11.9 -2.5 L 10.2 .4 L 9.1 2.9 L 8.7 5.6 L 8.8 7.2 L 9.8 7.8 L 11.7 7.6 L 13.4 6.5 L 14.5 5.3 L 15.3 4.2","0 11.1 M 18.7 -3.3 L 15.9 -3.9 L 14.4 -3.9 L 12.7 -3.0 L 11.0 -.4 L 9.8 1.9 L 9.0 4.3 L 8.7 5.7 L 8.7 7.0 L 9.0 7.4 L 10.0 7.1 L 12.2 5.0 L 14.3 2.4 L 15.8 .7 L 17.8 -4.0 L 20.3 -10.9 L 20.2 -11.4 L 20.9 -13.1 L 21.2 -13.2 L 18.4 -4.8 L 16.4 .2 L 15.5 3.4 L 14.7 5.8 L 14.7 7.1 L 15.5 7.4 L 17.0 6.7 L 17.9 5.8 L 18.7 5.1","0 8.2 M 9.3 .9 L 11.7 1.3 L 14.2 1.2 L 15.4 .6 L 16.0 -.1 L 16.1 -1.5 L 15.7 -2.9 L 15.0 -3.6 L 13.8 -3.7 L 12.5 -3.0 L 11.2 -.8 L 9.9 2.2 L 9.3 4.2 L 9.1 6.0 L 9.5 7.6 L 10.6 8.0 L 11.9 7.6 L 13.5 6.4 L 14.9 4.5","0 6.9 M 20.7 -12.8 L 20.5 -13.4 L 18.5 -13.6 L 16.8 -13.0 L 15.2 -10.5 L 9.3 9.3 L 8.6 10.9 L 7.7 12.8 L 6.8 13.8 L 5.1 14.7 L 3.8 14.7 L 2.4 13.6 L 2.2 12.1 L 2.2 11.1 M 9.9 -3.9 L 17.5 -4.2","0 9.6 M 16.1 -3.5 L 14.2 -4.1 L 12.0 -2.1 L 11.0 .0 L 10.2 2.6 L 10.2 4.7 L 12.1 5.4 L 13.7 4.8 L 15.4 2.8 L 16.3 1.0 L 16.7 -.8 L 16.5 -1.7 L 16.3 -2.4 L 16.1 -4.7 L 16.8 -5.0 L 16.9 -2.6 L 17.8 -1.7 M 9.8 6.9 L 13.0 9.6 L 14.6 12.9 L 14.9 16.0 L 13.3 17.6 L 9.6 19.1 L 7.0 19.3 L 5.6 18.1 L 6.4 15.0 L 8.1 11.8 L 10.3 8.8","0 10.1 M 13.7 -9.3 L 15.2 -11.9 L 15.9 -12.5 L 12.4 -3.4 L 10.1 4.0 L 8.7 7.6 L 10.1 5.5 L 12.0 2.2 L 14.3 -1.3 L 16.2 -3.1 L 17.2 -3.8 L 18.2 -4.4 L 18.5 -4.1 L 16.8 -1.3 L 15.0 2.8 L 13.7 6.1 L 13.3 8.1 L 13.7 9.1 L 14.0 9.3 L 14.7 9.0 L 15.3 8.7","0 5.4 M 11.2 -1.1 L 12.4 -3.3 L 12.7 -3.8 L 13.4 -4.3 L 11.1 .6 L 10.3 3.2 L 9.4 5.8 L 8.9 7.4 L 9.1 7.6 L 10.4 7.3 L 12.5 6.0 M 15.6 -10.0 L 13.9 -8.4 L 13.7 -7.5","0 6.5 M 12.4 -1.4 L 13.2 -3.7 L 14.1 -4.3 L 11.5 3.4 L 9.8 9.9 L 9.1 12.9 L 8.0 14.9 L 6.7 16.1 L 5.7 16.6 L 4.6 16.7 L 3.5 16.0 L 2.7 14.9 L 2.7 12.6 M 16.2 -10.2 L 14.2 -8.7 L 14.3 -7.6","0 8.7 M 13.7 -9.4 L 15.1 -12.0 L 15.6 -12.4 L 13.0 -5.6 L 11.0 .0 L 9.5 5.0 L 8.8 7.6 L 8.2 8.3 M 18.9 -4.4 L 15.5 -1.9 L 12.9 .9 L 11.4 2.1 L 10.4 2.5 L 10.7 1.2 L 11.8 2.1 L 13.2 5.3 L 14.1 6.7 L 15.8 8.4","0 5.8 M 13.8 -9.5 L 14.5 -11.4 L 15.2 -12.2 L 15.8 -12.5 L 12.7 -4.3 L 10.6 2.2 L 9.4 6.2 L 9.1 7.3 L 9.4 7.5 L 11.2 6.6 L 12.7 5.9","0 15.9 M 11.3 -1.4 L 12.4 -3.8 L 13.0 -4.2 L 10.8 1.2 L 8.4 7.7 L 10.6 4.4 L 12.9 .9 L 14.6 -1.6 L 16.0 -3.0 L 17.8 -4.5 L 19.0 -4.7 L 18.5 -3.4 L 16.7 -.1 L 15.3 3.8 L 14.7 6.6 L 14.6 7.6 L 15.3 7.2 L 16.6 4.0 L 18.5 .7 L 20.3 -1.5 L 22.2 -3.0 L 23.6 -4.1 L 24.1 -4.4 L 25.2 -4.6 L 24.1 -2.9 L 22.4 1.1 L 20.7 4.8 L 20.1 7.2 L 20.0 8.4 L 20.1 8.9 L 20.9 9.2 L 22.1 8.4","0 10.5 M 11.1 -1.3 L 12.1 -3.5 L 12.9 -4.1 L 10.0 3.1 L 8.3 7.9 L 9.6 5.8 L 12.8 1.0 L 15.0 -2.0 L 16.7 -3.9 L 18.4 -4.8 L 18.9 -4.8 L 17.0 -1.2 L 15.3 3.2 L 14.5 6.0 L 14.3 8.0 L 14.7 8.8 L 15.3 8.8 L 16.2 8.2","0 8.4 M 15.6 -3.4 L 14.1 -4.1 L 12.0 -2.6 L 10.8 -.1 L 9.8 2.4 L 9.2 4.2 L 9.1 6.5 L 9.4 7.6 L 10.3 8.2 L 11.7 8.0 L 13.5 6.3 L 15.0 4.3 L 15.6 2.3 L 16.0 .6 L 15.9 -.9 L 16.0 -2.9 L 15.3 -4.7 L 14.8 -5.0 L 15.1 -3.0 L 16.4 -1.4 L 17.5 -1.4","0 9.8 M 13.3 -5.6 L 12.7 -4.8 L 6.6 13.9 L 6.2 15.2 L 6.1 16.5 L 6.8 15.3 M 11.5 -4.0 L 13.5 -3.7 L 15.0 -2.1 L 15.9 .5 L 16.2 2.9 L 16.1 5.8 L 14.3 7.5 L 12.4 8.0 L 11.4 7.9 L 10.4 7.4 L 9.3 6.7 L 8.8 5.9 L 9.3 5.1 L 11.5 3.6 L 14.2 2.1 L 16.8 1.1 L 18.7 .6","0 10.3 M 18.2 -3.8 L 16.2 -4.3 L 13.9 -3.3 L 11.7 -.1 L 9.9 3.3 L 9.1 6.0 L 9.1 7.0 L 9.3 7.4 L 10.3 7.2 L 12.3 5.8 L 14.5 3.5 L 16.2 1.3 L 17.3 -.2 L 18.1 -1.9 L 18.7 -3.4 L 19.2 -3.9 L 19.5 -3.6 L 19.4 -2.5 L 18.6 -1.6 L 17.9 -.7 L 15.8 4.5 L 13.7 10.3 L 12.9 13.6 L 12.9 14.4 L 13.4 15.0 L 14.3 14.6 L 17.4 12.3","0 8.8 M 10.3 -1.5 L 11.5 -3.7 L 12.5 -4.6 L 10.6 -.2 L 9.7 4.2 L 9.3 6.7 L 8.9 7.4 L 8.6 7.4 L 8.7 6.6 L 11.3 2.4 L 13.9 -1.5 L 15.5 -3.3 L 16.7 -4.1 L 17.5 -4.1 L 17.7 -3.4 L 16.7 -1.3","0 8.4 M 15.5 -.7 L 16.6 -2.5 L 16.6 -3.8 L 15.8 -4.0 L 13.5 -3.4 L 11.4 -2.2 L 10.2 -.9 L 9.6 .1 L 10.2 1.1 L 12.1 2.7 L 13.7 3.7 L 14.1 4.4 L 14.2 5.1 L 13.9 5.9 L 13.0 6.9 L 10.9 7.7 L 8.7 8.1","0 7.6 M 13.5 -6.0 L 14.4 -8.4 L 15.5 -9.1 L 12.8 -2.0 L 10.8 4.8 L 10.4 6.8 L 10.6 7.7 L 11.6 7.4 L 12.5 7.0 L 14.7 5.2 M 10.5 -3.9 L 18.0 -4.1","0 11.0 M 11.4 -1.6 L 12.3 -3.7 L 13.1 -4.2 L 9.6 5.0 L 9.1 6.6 L 8.9 7.4 L 10.5 6.6 L 13.0 4.2 L 15.5 1.1 L 16.3 -.1 L 17.9 -1.7 L 18.9 -4.3 L 17.7 -3.1 L 17.4 -1.3 L 16.8 1.6 L 15.3 6.4 L 15.0 8.5 L 14.2 9.6 L 13.6 9.7 L 16.6 7.4 L 18.5 6.1","0 11.5 M 10.8 -.5 L 10.9 -2.8 L 11.8 -3.5 L 10.8 5.8 L 10.6 6.8 L 10.0 8.0 L 13.5 5.3 L 16.3 1.9 L 17.9 -1.4 L 18.4 -2.5 L 18.7 -4.7 L 17.8 -3.3","0 16.4 M 8.8 -3.0 L 10.0 -3.9 L 10.6 -3.8 L 11.1 -1.7 L 11.3 1.1 L 11.4 2.6 L 10.8 4.9 L 10.0 7.0 L 9.8 7.5 L 10.4 8.0 L 11.0 5.0 L 13.5 .7 L 15.3 -2.3 L 16.1 -3.3 L 16.7 -3.9 L 17.6 -3.0 L 18.4 .3 L 18.9 2.9 L 19.2 5.5 L 19.0 7.4 L 20.2 5.5 L 21.9 2.6 L 23.6 -.7 L 24.2 -2.3 L 24.7 -3.6 L 24.7 -4.8 L 24.5 -5.0 L 24.3 -4.3","0 10.3 M 10.8 -2.7 L 12.2 -3.1 L 13.0 -3.6 L 13.7 -1.9 L 15.0 2.2 L 15.8 6.3 L 16.4 8.0 L 16.3 8.6 M 19.6 -3.6 L 19.5 -3.9 L 17.1 -1.6 L 13.4 2.4 L 10.6 5.8 L 8.6 8.2 L 7.4 9.8 L 6.8 11.1","0 10.6 M 9.8 -2.5 L 10.4 -3.3 L 11.7 -.2 L 11.8 2.5 L 11.8 6.2 L 11.5 9.0 M 18.0 -3.8 L 19.4 -4.3 L 18.9 -3.1 L 17.3 .0 L 15.3 2.8 L 13.2 5.8 L 9.9 10.2 L 7.5 13.8 L 6.2 15.8 L 5.7 17.5 L 5.8 18.6","0 10.5 M 11.2 -2.0 L 11.8 -3.2 L 12.7 -3.8 L 15.4 -3.8 L 17.4 -3.7 L 18.2 -3.7 L 18.4 -3.3 L 18.0 -2.7 L 15.8 -1.0 L 12.8 2.3 L 9.5 5.6 L 8.6 6.5 L 8.5 7.3 L 9.4 7.7 L 14.1 7.6 L 15.9 7.6 L 17.3 7.1 L 17.1 7.8","0 10.7 M 21.7 -12.9 L 19.0 -12.5 L 17.2 -11.1 L 16.0 -8.6 L 15.7 -5.9 L 14.4 -3.3 L 13.4 -2.0 L 11.6 -1.1 L 10.7 -.9 L 9.4 -1.0 L 11.4 -.7 L 12.5 .4 L 13.0 1.3 L 12.5 4.5 L 11.5 7.8 L 11.4 10.3 L 11.9 11.3 L 13.4 12.0 L 14.6 11.9","0 6.8 M 12.3 -11.0 L 11.7 -11.9 L 12.1 -6.6 L 11.9 1.6 L 11.7 6.0 L 11.7 8.9 L 11.3 10.5","0 13.8 M 15.8 -13.0 L 17.2 -13.0 L 18.1 -12.8 L 19.1 -12.2 L 19.5 -10.6 L 18.9 -8.0 L 17.8 -4.9 L 17.6 -3.0 L 18.1 -1.6 L 18.9 -1.0 L 19.5 -.5 L 20.0 -.2 L 21.1 -.2 L 18.6 .1 L 16.9 1.1 L 15.5 3.2 L 14.8 6.1 L 14.3 8.4 L 13.0 10.5 L 11.8 11.3 L 10.2 11.7 L 9.1 11.9","0 12.0 M 11.0 -6.9 L 12.0 -7.7 L 12.8 -8.0 L 14.1 -7.6 L 15.4 -7.1 L 16.6 -7.3 L 17.5 -7.6 L 17.8 -8.0","0 9.1 M 12.7 -8.2 L 11.2 -7.6 L 10.6 -6.7 L 10.1 -5.4 L 10.5 -4.0 L 11.3 -3.2 L 12.9 -2.8 L 14.5 -3.3 L 15.4 -4.7 L 15.5 -6.1 L 14.9 -7.3 L 14.1 -7.9 L 13.5 -8.1 L 12.7 -8.2"]
EMSBirdSwashCaps = ["-8 8","0 9.4 M 19.4 -14.5 L 20.2 -14.3 L 16.1 -6.5 L 13.7 -.8 L 13.5 .7 L 13.7 1.3 M 11.6 6.3 L 10.9 7.6","0 13.7 M 15.0 -12.6 L 15.4 -10.9 L 13.8 -8.3 L 11.7 -6.3 M 19.3 -12.6 L 19.7 -10.9 L 18.1 -8.3 L 16.0 -6.3","0 27.5 M 21.3 -9.7 L 15.7 6.0 M 28.6 -9.7 L 22.7 6.3 M 11.6 1.2 L 29.7 1.3 M 13.9 -5.2 L 32.7 -5.3","0 22.8 M 25.7 -6.9 L 25.7 -8.2 L 24.9 -9.3 L 23.2 -9.5 L 21.4 -9.5 L 19.1 -8.7 L 17.4 -7.6 L 16.1 -6.5 L 15.4 -4.7 L 16.3 -2.6 L 17.9 -1.5 L 21.3 -.3 L 22.9 .9 L 23.6 2.4 L 23.5 3.9 L 22.4 5.3 L 19.9 6.9 L 17.9 7.7 L 15.5 7.9 L 14.3 7.9 L 13.5 7.4 L 12.9 6.3 M 24.2 -13.5 L 16.0 10.1 L 15.4 11.9 L 15.4 12.8 L 15.7 14.0","0 20.2 M 15.6 -11.3 L 13.5 -9.2 L 11.8 -6.7 L 11.2 -4.7 L 11.7 -3.2 L 13.1 -3.4 L 15.0 -4.3 L 16.7 -6.2 L 17.6 -8.2 L 18.0 -9.3 L 18.4 -10.3 L 18.5 -11.6 L 18.1 -12.1 L 17.2 -12.4 L 16.3 -12.0 L 18.3 -9.8 L 19.4 -9.8 L 23.0 -10.7 L 26.7 -11.7 L 17.7 -.5 L 13.0 6.1 L 11.9 8.4 L 11.5 9.6 L 11.5 10.8 L 11.7 10.9 M 21.9 1.7 L 19.3 4.2 L 17.6 6.8 L 17.1 8.4 L 17.4 9.7 L 18.7 10.3 L 20.5 9.3 L 22.4 7.0 L 23.5 5.4 L 23.9 4.3 L 24.2 2.9 L 24.3 1.7 L 23.6 1.2 L 22.4 1.5 L 22.6 2.7 L 24.0 3.3 L 24.6 3.4","0 32.0 M 28.4 -5.6 L 28.8 -5.8 L 31.1 -6.6 L 32.8 -8.0 L 33.8 -9.5 L 33.9 -10.6 L 33.4 -11.8 L 32.5 -12.7 L 30.6 -13.3 L 28.5 -13.3 L 23.9 -12.7 L 19.4 -11.2 L 17.3 -9.6 L 15.5 -7.5 L 15.0 -5.6 L 15.2 -3.9 L 16.7 -3.0 L 18.4 -2.7 L 20.2 -2.8 L 22.8 -3.1 L 18.3 -1.6 L 15.9 -.2 L 14.0 1.7 L 12.9 4.0 L 12.9 5.9 L 14.1 7.4 L 16.6 8.6 L 20.4 8.7 L 24.7 7.9 L 28.0 6.1 L 30.4 3.9 L 31.0 1.4 L 30.6 -.6 L 29.9 -1.2 L 29.0 -1.8 M 23.7 1.1 L 23.7 -.2 L 24.9 -1.6 L 25.9 -2.1 L 28.0 -2.1 L 30.8 -1.5 L 33.2 -.9 L 35.1 -.5 L 36.3 -.5 L 37.4 -.9","0 6.8 M 16.1 -10.1 L 16.9 -10.5 L 16.9 -8.9 L 15.8 -6.6 L 14.7 -5.4 L 13.5 -4.4","0 9.0 M 22.2 -14.4 L 19.7 -14.3 L 15.7 -12.6 L 12.0 -9.6 L 9.6 -6.0 L 8.2 -2.7 L 7.5 2.4 L 7.8 5.6 L 8.9 8.6 L 10.4 9.7 L 10.8 9.8","0 12.8 M 15.1 -14.7 L 18.0 -14.3 L 19.8 -12.7 L 20.7 -10.3 L 20.4 -6.4 L 19.3 -2.8 L 17.1 1.0 L 14.9 3.9 L 12.0 6.9 L 9.6 8.6 L 6.9 9.3","0 6.7 M 8.9 -13.9 L 13.3 -11.2 M 11.1 -15.0 L 11.2 -10.0 M 13.4 -13.9 L 9.0 -11.3","0 12.8 M 15.9 -2.0 L 13.0 7.5 M 10.5 2.4 L 19.3 2.3","0 6.6 M 11.5 7.2 L 12.5 6.6 L 11.9 9.1 L 10.4 11.3 L 8.6 13.2","0 9.6 M 9.7 2.7 L 9.2 3.4 L 15.4 3.1","0 8.2 M 13.0 6.4 L 12.1 7.2 L 12.6 7.8 L 13.0 6.4 L 13.0 6.4","0 20.5 M 26.9 -15.4 L 21.3 -8.6 L 17.1 -3.0 L 13.7 2.0 L 11.0 6.0 L 9.3 8.9 L 8.8 10.3 L 9.0 11.5 L 9.2 11.9","0 19.0 M 25.7 -10.1 L 24.8 -10.4 L 23.7 -10.6 L 21.2 -9.9 L 18.9 -8.9 L 15.7 -6.4 L 13.4 -4.2 L 11.8 -2.0 L 10.3 .8 L 9.6 3.1 L 9.4 5.5 L 9.8 7.0 L 10.8 8.0 L 12.3 8.1 L 15.3 7.5 L 18.3 6.0 L 21.9 3.3 L 24.5 .3 L 25.6 -1.8 L 26.3 -4.4 L 26.2 -6.4 L 25.9 -7.7 L 24.8 -8.8 L 24.2 -9.4 L 23.5 -9.7 L 22.8 -9.9 L 21.9 -10.1 L 20.4 -10.1","0 9.9 M 14.2 -5.6 L 16.8 -6.7 L 18.4 -7.9 L 20.0 -9.3 L 20.5 -9.5 L 17.8 -4.7 L 15.2 -.4 L 11.3 6.5 M 8.5 7.9 L 11.1 6.9 L 13.5 6.3 L 16.3 6.1","0 21.2 M 15.6 -4.9 L 17.6 -6.3 L 20.2 -7.9 L 22.7 -8.8 L 25.6 -9.1 L 27.1 -8.7 L 27.9 -7.9 L 27.8 -6.0 L 26.9 -4.3 L 25.1 -2.2 L 22.7 .0 L 20.0 1.9 L 17.5 3.4 L 15.0 4.7 L 12.1 6.4 L 10.7 7.1 L 9.5 7.6 L 8.7 7.5 L 9.2 6.6 L 10.7 6.0 L 11.9 5.8 L 13.1 5.7 L 15.5 6.4 L 18.7 7.2 L 21.5 8.1 L 24.4 8.1 L 26.0 7.4 L 26.6 6.5 L 26.8 5.5 L 26.6 4.8 L 25.4 4.0","0 20.6 M 20.6 -8.9 L 18.6 -7.2 L 21.8 -8.8 L 24.6 -9.3 L 26.5 -9.4 L 27.6 -8.6 L 27.8 -7.1 L 27.0 -6.0 L 25.6 -4.4 L 23.8 -3.7 L 22.9 -3.4 L 20.2 -2.7 L 18.9 -2.3 L 18.3 -2.6 L 18.6 -2.9 L 22.8 -2.8 L 23.9 -2.7 L 26.1 -1.8 L 27.0 .6 L 26.5 2.9 L 25.0 4.7 L 22.5 6.5 L 19.9 7.4 L 17.1 7.9 L 13.8 8.0 L 11.2 7.1 L 10.1 6.0 L 9.6 4.7 L 9.7 3.4 L 10.4 2.3 L 11.2 1.4 L 12.2 .7 L 13.7 .4 L 15.0 .1","0 16.3 M 26.2 -1.8 L 26.6 -.6 L 26.1 .2 L 24.5 .8 L 23.0 .7 L 21.6 .7 L 18.2 -.4 L 16.9 -.7 L 15.2 -.9 L 13.3 -.7 L 11.4 -.2 L 9.6 .4 L 13.0 -1.8 L 17.3 -3.9 L 20.7 -5.9 L 23.5 -7.7 L 25.6 -9.2 L 26.5 -9.9 L 26.6 -9.9 L 22.1 -3.9 L 20.0 -.7 L 18.5 1.9 L 17.2 4.0 L 16.8 4.8 L 16.6 6.7 M 12.3 8.3 L 14.2 7.5 L 15.8 6.9 L 17.7 6.5 L 19.5 6.5 L 20.2 6.5","0 20.8 M 18.7 -6.9 L 14.2 -1.5 L 16.9 -2.8 L 19.1 -3.6 L 21.6 -3.8 L 23.2 -3.8 L 25.4 -3.0 L 26.4 -2.0 L 26.3 -.3 L 25.6 2.2 L 24.4 4.0 L 22.0 6.0 L 19.6 7.4 L 16.4 8.3 L 12.6 8.7 L 9.9 7.8 L 8.8 6.8 L 8.5 5.6 L 8.8 4.7 L 9.8 3.6 L 10.7 2.7 M 18.0 -8.1 L 19.5 -8.8 L 21.5 -9.1 L 23.7 -8.6 L 25.7 -8.1 L 27.1 -7.8 L 28.5 -7.6 L 30.0 -7.8 L 31.1 -8.3 L 31.7 -8.8 L 31.9 -9.6","0 18.9 M 24.9 -9.2 L 27.4 -9.0 L 28.2 -8.7 L 22.3 -7.0 L 17.4 -4.7 L 14.6 -2.8 L 11.5 .3 L 10.1 2.4 L 9.4 4.8 L 9.6 6.5 L 11.4 8.0 L 14.2 8.3 L 16.8 8.0 L 20.6 6.7 L 23.2 5.1 L 24.0 3.3 L 24.0 2.3 L 23.5 1.7 L 21.9 1.3 L 19.6 1.5 L 17.2 2.4 L 15.8 3.5 L 14.6 5.0 L 14.3 5.6 L 14.3 6.6","0 14.0 M 12.0 -9.1 L 11.6 -6.3 L 12.6 -8.6 L 14.8 -9.9 L 18.0 -10.2 L 19.9 -10.1 L 22.2 -9.4 L 24.6 -9.2 L 25.9 -9.2 L 27.1 -9.9 L 23.5 -6.9 L 20.5 -4.3 L 17.3 -1.6 L 15.2 .7 L 13.8 2.6 L 12.3 5.0 L 11.7 6.6 L 11.7 7.5 L 11.7 8.0","0 17.8 M 25.4 -6.6 L 25.9 -7.4 L 26.1 -8.9 L 24.9 -9.8 L 22.5 -9.9 L 20.1 -9.4 L 18.1 -8.4 L 17.0 -7.1 L 16.7 -6.0 L 17.2 -5.1 L 18.7 -3.9 L 20.9 -2.9 L 22.6 -1.9 L 23.6 -1.0 L 24.4 .6 L 24.0 2.2 L 22.5 4.1 L 20.3 5.6 L 17.0 7.1 L 13.5 8.1 L 10.7 8.3 L 8.8 6.9 L 8.8 4.9 L 10.6 2.0 L 13.0 -.2 L 15.5 -1.9 L 17.1 -2.9 L 18.9 -3.7 L 21.1 -4.9 L 24.0 -6.1 L 26.7 -6.9 L 28.3 -7.4","0 12.5 M 24.4 -9.5 L 20.4 -9.3 L 17.6 -8.5 L 13.7 -7.0 L 11.7 -5.4 L 10.6 -3.7 L 10.6 -2.1 L 12.0 -1.4 L 14.4 -2.0 L 16.5 -3.2 L 18.6 -4.3 L 20.6 -5.4 L 24.3 -8.2 L 24.9 -8.2 L 20.8 -4.2 L 17.4 -.6 L 15.3 2.0 L 13.9 4.4 L 12.5 6.9 L 11.8 9.5 L 11.8 10.9 L 11.8 11.9 L 12.3 12.1","0 6.6 M 14.0 -3.7 L 13.0 -2.6 L 13.5 -1.8 M 12.4 3.5 L 11.6 4.6 L 12.0 5.3","0 6.7 M 14.3 .0 L 13.3 1.1 L 13.6 1.8 M 11.4 7.5 L 12.4 6.6 L 12.0 8.9 L 10.8 10.9 L 9.4 12.5","0 10.7 M 15.1 -6.6 L 11.4 -1.4 L 15.2 3.0","0 13.5 M 12.8 -.3 L 12.0 .6 L 16.2 .6 L 18.8 .2 M 12.8 2.5 L 12.0 3.4 L 16.2 3.4 L 18.8 3.0","0 10.5 M 10.9 -6.4 L 13.7 -3.2 L 14.7 -2.4 L 10.9 3.1","0 15.7 M 14.6 -6.4 L 13.4 -6.8 L 13.0 -8.1 L 13.2 -9.3 L 14.1 -10.7 L 15.6 -12.0 L 17.7 -13.0 L 20.1 -13.7 L 22.0 -13.8 L 23.8 -13.6 L 25.0 -12.8 L 25.6 -12.1 L 25.9 -10.3 L 25.6 -9.1 L 24.0 -6.5 L 22.5 -5.2 L 19.1 -3.0 L 16.2 -1.2 L 15.1 -.3 L 14.2 .9 L 13.9 2.1 L 14.1 2.4 M 13.1 6.0 L 12.2 7.1 L 12.7 7.9","0 30.2 M 16.0 -13.7 L 18.1 -13.7 L 21.0 -13.7 L 24.9 -12.9 L 27.8 -12.3 L 30.9 -10.9 L 33.0 -9.1 L 34.7 -6.7 L 35.3 -4.3 L 35.3 -2.9 L 34.8 -1.1 L 33.7 1.3 L 31.2 3.7 L 28.8 5.3 L 25.3 6.9 L 21.9 7.6 L 18.2 7.5 L 15.4 6.5 L 13.2 4.2 L 11.7 1.1 L 11.5 -2.0 L 12.7 -6.7 L 14.8 -9.4 L 18.1 -12.1 L 20.3 -13.3 L 22.9 -14.2 L 26.3 -14.7 L 28.6 -15.0 L 31.6 -14.6 L 33.9 -13.2 L 34.9 -11.6 L 34.9 -10.4 L 34.8 -8.8 L 33.9 -6.4 L 33.1 -4.5 L 30.9 -1.2 L 29.5 .4 L 28.0 1.9 L 26.5 3.0 L 25.2 3.5 L 24.1 3.3 L 24.0 2.5 L 24.5 .0 L 25.7 -4.7 L 26.7 -6.5 L 27.8 -7.9 L 27.9 -8.6 L 27.2 -8.5 L 26.6 -6.8 L 26.0 -4.9 L 23.9 -2.2 L 22.1 -.1 L 20.7 1.6 L 18.7 3.1 L 17.9 3.0 L 17.8 1.2 L 19.2 -3.2 L 20.5 -5.5 L 22.1 -7.7 L 23.0 -8.5 L 24.1 -8.8 L 25.3 -8.8 L 27.2 -8.3","0 20.9 M 25.0 -14.2 L 20.9 -10.0 L 16.8 -5.8 L 12.7 -.4 L 10.2 3.7 L 8.6 8.6 L 8.7 11.4 L 8.7 13.1 L 9.5 14.0 M 23.1 -14.6 L 24.7 -9.5 L 25.0 -3.2 L 25.0 3.8 L 25.0 7.5 M 23.1 9.6 L 25.6 7.2 L 28.1 5.8 M 9.2 -1.8 L 27.3 -2.0","0 29.5 M 13.0 -1.6 L 12.9 -.6 L 10.3 -3.1 L 8.6 -6.6 L 8.7 -10.0 L 10.6 -12.8 L 13.4 -14.0 L 17.1 -14.4 L 21.3 -13.9 L 26.4 -13.1 L 30.2 -11.6 L 33.7 -9.2 L 34.5 -7.0 L 34.3 -5.5 L 33.3 -4.2 L 31.3 -2.9 L 27.1 -1.4 L 20.5 -.4 L 26.3 -.9 L 30.0 -.4 L 33.9 1.1 L 35.9 3.1 L 36.0 5.2 L 34.8 7.1 L 33.0 8.7 L 30.1 9.8 L 26.1 10.1 L 22.2 9.8 L 18.9 9.1 L 16.0 7.7 L 15.6 7.2 M 26.6 -15.3 L 23.0 -8.6 L 20.7 -2.2 L 19.1 2.9 L 18.4 5.9 L 18.2 7.9 L 18.3 10.3","0 25.7 M 31.6 -14.9 L 31.6 -13.9 L 31.1 -12.7 L 30.5 -10.8 L 30.1 -8.8 L 31.3 -8.8 L 31.4 -10.0 L 31.4 -11.4 L 29.8 -13.6 L 27.5 -14.4 L 25.2 -14.6 L 21.4 -14.1 L 16.9 -11.6 L 13.7 -8.6 L 11.4 -5.7 L 9.5 -1.3 L 9.4 2.6 L 10.7 5.5 L 13.6 8.7 L 17.1 10.1 L 22.3 10.1 L 27.8 8.4 L 30.4 6.7 L 32.1 5.1 L 32.8 3.9","0 31.3 M 9.3 -2.8 L 7.6 -4.0 L 6.9 -5.7 L 7.4 -7.3 L 11.3 -9.7 L 14.4 -10.8 L 19.3 -12.0 L 23.2 -12.4 L 27.0 -12.0 L 31.1 -11.3 L 33.9 -10.0 L 36.4 -8.0 L 37.9 -5.2 L 38.1 -1.8 L 36.3 2.1 L 32.8 5.4 L 28.9 7.5 L 25.7 8.5 L 23.7 9.0 L 21.8 8.9 L 20.4 8.8 L 19.1 8.2 L 18.6 7.6 L 17.9 6.4 L 16.1 8.5 L 16.3 4.9 L 17.1 -.3 L 18.9 -6.3 L 20.2 -9.5 L 22.3 -13.7 L 23.1 -14.8","0 31.8 M 31.1 -11.9 L 30.2 -13.0 L 29.5 -13.1 L 28.1 -9.3 L 26.5 -4.7 L 23.9 2.7 L 22.8 4.6 L 21.9 6.4 L 20.3 7.7 L 18.8 8.9 L 16.8 9.8 L 14.5 10.2 L 12.9 10.3 L 10.8 9.6 L 9.8 8.6 L 9.2 7.3 L 9.8 5.9 L 11.1 5.1 L 13.0 4.9 L 16.5 5.5 L 20.0 6.7 L 24.8 9.0 L 29.6 10.7 L 33.7 11.0 L 36.0 10.5 L 37.7 9.0 L 38.7 7.5 L 38.6 5.8 L 38.2 4.8 L 37.5 3.9 M 16.7 -.1 L 13.7 -1.8 L 10.8 -3.9 L 8.6 -6.5 L 7.5 -8.9 L 7.4 -11.4 L 8.6 -12.8 L 10.4 -13.5 L 13.4 -13.9 L 16.9 -13.4 L 21.3 -12.6 L 25.3 -11.5 L 27.8 -10.8 L 32.3 -9.3 L 35.5 -8.7 L 37.4 -8.7 L 38.8 -8.8 L 39.9 -9.1 L 40.3 -9.5 M 21.7 -2.5 L 33.3 -2.6","0 25.2 M 32.5 -11.8 L 31.9 -12.8 L 31.4 -13.3 L 30.7 -12.8 L 26.8 -1.0 L 25.2 4.1 L 23.9 6.9 L 22.4 9.2 L 21.0 10.7 L 19.6 11.6 L 17.8 12.3 L 16.1 12.3 L 14.5 11.8 L 12.4 10.5 L 11.1 8.4 L 10.5 6.2 L 10.4 4.2 M 18.3 .6 L 15.4 -.9 L 12.5 -3.3 L 9.8 -7.2 L 8.9 -10.5 L 9.2 -12.8 L 11.1 -14.3 L 13.8 -14.9 L 18.0 -14.7 L 21.8 -13.7 L 25.5 -12.4 L 31.8 -9.8 L 34.8 -8.9 L 36.8 -8.5 L 38.3 -8.8 L 38.8 -9.4 M 21.9 -2.2 L 33.5 -2.3","0 28.9 M 32.2 -9.3 L 32.9 -11.3 L 31.0 -13.1 L 28.2 -13.7 L 21.8 -13.2 L 16.8 -11.2 L 13.0 -7.8 L 10.6 -4.7 L 9.5 -1.4 L 9.1 2.0 L 10.4 5.1 L 12.4 7.6 L 16.7 9.0 L 22.2 8.8 L 26.2 7.1 L 29.3 5.0 L 31.2 2.5 L 33.0 -.9 L 31.9 4.0 L 30.0 9.4 L 28.3 13.0 L 27.1 14.9 L 24.8 17.4 L 22.1 19.2 L 19.2 20.1 L 16.4 19.4 L 15.1 18.7 L 14.2 17.5 M 23.0 -2.0 L 22.1 -1.2 L 36.4 -1.3","0 32.6 M 17.6 .9 L 13.7 -1.5 L 11.5 -3.5 L 9.7 -6.1 L 8.5 -8.8 L 8.2 -11.4 L 9.3 -13.5 L 12.0 -14.8 L 15.8 -14.7 L 19.6 -14.1 L 31.0 -9.9 L 32.6 -9.9 L 33.5 -10.3 M 29.3 -10.3 L 24.1 4.8 L 22.8 7.5 L 20.6 10.4 L 18.2 12.0 L 16.2 12.6 L 13.9 12.3 L 11.7 11.0 L 10.3 9.0 L 9.5 6.9 L 9.2 4.4 M 40.1 -9.4 L 41.4 -11.6 L 38.4 -2.8 L 36.2 4.5 L 35.3 7.4 L 34.8 9.6 L 34.9 10.9 L 35.9 11.1 L 37.5 9.9 L 38.6 8.6 M 23.3 .1 L 40.1 .0","0 16.2 M 23.0 -12.5 L 21.8 -7.7 L 19.9 -2.5 L 17.9 2.1 L 15.9 6.2 L 14.5 7.9 L 13.6 8.9 L 12.2 9.6 L 10.7 9.8 L 8.8 9.1 L 8.7 8.1 L 9.2 7.1 L 10.1 6.7 L 11.6 6.9 L 18.9 9.5 L 21.4 9.8 L 22.7 9.5 L 23.4 8.9 L 23.6 8.1 L 23.5 7.2 L 23.2 6.6 M 16.1 -7.6 L 14.4 -9.3 L 14.1 -11.3 L 14.7 -12.6 L 16.2 -13.4 L 18.9 -13.3 L 21.4 -12.8 L 25.1 -12.2 L 26.7 -12.3 L 27.7 -12.6 L 27.9 -12.8","0 20.8 M 30.1 -12.2 L 30.1 -12.0 L 27.9 -4.9 L 25.3 2.4 L 23.0 7.4 L 21.3 10.9 L 19.7 13.4 L 18.2 14.9 L 16.0 16.2 L 13.8 16.4 L 12.0 15.6 L 9.7 12.9 L 8.9 11.0 L 8.5 9.4 L 8.6 7.9 M 22.0 -5.8 L 18.8 -7.8 L 17.4 -9.7 L 17.0 -12.1 L 18.4 -13.7 L 21.2 -13.9 L 24.8 -13.2 L 27.3 -12.9 L 32.3 -11.9 L 33.4 -12.2 L 34.4 -12.6","0 32.3 M 29.4 -10.3 L 28.1 -6.1 L 26.6 -1.8 L 25.1 3.0 L 23.4 6.7 L 21.4 9.7 L 19.4 11.6 L 17.7 12.5 L 15.7 12.5 L 13.9 12.0 L 11.6 10.5 L 10.2 7.9 L 9.7 5.7 L 9.7 4.2 M 17.4 .8 L 13.9 -1.4 L 10.2 -5.4 L 8.5 -8.9 L 8.4 -12.7 L 11.5 -14.4 L 15.8 -14.7 L 20.9 -13.7 L 25.8 -11.8 L 31.4 -9.8 L 32.6 -9.8 L 33.2 -10.0 L 33.5 -10.3 M 41.8 -11.6 L 41.8 -10.9 L 37.6 -7.0 L 33.9 -4.4 L 30.4 -2.2 L 28.4 -1.0 L 25.3 -.2 L 23.7 .1 L 27.6 4.1 L 33.3 9.3 L 36.2 11.4 L 37.9 11.8 L 39.4 10.4 L 39.7 9.1 L 39.8 7.2 L 39.7 5.9","0 27.2 M 28.9 -12.0 L 27.9 -12.2 L 27.0 -10.9 L 24.2 -3.5 L 22.3 1.5 L 20.5 5.4 L 19.6 6.7 L 18.0 8.4 L 16.9 9.1 L 15.7 9.8 L 14.4 10.0 L 12.0 10.0 L 9.7 8.9 L 9.1 8.1 L 9.1 6.5 L 10.6 5.5 L 11.6 5.2 L 15.2 5.9 L 18.3 7.0 L 25.4 10.2 L 28.8 11.0 M 28.9 11.0 L 31.2 10.5 L 33.3 9.3 L 34.3 7.7 L 33.9 5.7 L 33.5 4.6 M 18.3 -6.8 L 17.9 -4.9 L 18.7 -3.1 L 20.0 -1.8 L 22.6 -1.1 L 25.5 -1.5 L 27.6 -3.0 L 29.5 -4.9 L 30.8 -7.0 L 31.5 -9.4 L 32.0 -11.7 L 32.0 -14.1 L 31.5 -14.4","0 32.9 M 14.8 -3.2 L 11.2 -5.0 L 10.0 -6.5 L 9.0 -8.4 L 9.2 -10.7 L 10.8 -12.9 L 13.5 -13.6 L 17.4 -13.2 L 22.5 -12.6 L 23.9 -11.8 M 11.3 15.1 L 10.8 12.8 L 12.5 7.7 L 14.7 2.3 L 18.7 -4.7 L 22.1 -10.1 L 24.0 -11.9 L 23.0 -6.2 L 22.2 -.8 L 22.4 4.6 L 23.4 6.5 L 25.0 7.0 L 27.4 5.2 L 30.5 1.8 L 33.1 -2.2 L 36.3 -7.0 L 38.7 -11.4 L 39.0 -6.5 L 38.6 -2.3 L 37.8 1.4 L 36.4 5.0 L 35.0 8.9 L 34.5 10.5 L 33.8 11.0 L 33.0 10.9 L 33.5 10.3 L 36.8 8.3 L 38.4 7.2 L 39.4 6.6","0 33.0 M 20.8 -5.5 L 17.6 -7.3 L 15.7 -9.4 L 15.2 -11.4 L 15.7 -13.3 L 17.1 -13.8 L 19.4 -14.1 L 21.9 -13.9 L 30.0 -11.9 M 28.4 -12.3 L 25.3 -1.8 L 22.7 4.4 L 20.4 8.3 L 18.4 10.4 L 15.3 11.7 L 13.8 11.7 L 12.0 10.8 L 10.0 8.6 L 9.0 6.1 L 9.0 3.7 M 29.5 -9.8 L 30.3 -.9 L 31.8 5.5 L 33.0 7.8 L 33.7 8.6 L 34.7 9.1 L 35.7 8.0 L 36.4 6.5 L 37.7 3.4 L 38.6 .3 L 39.2 -3.0 L 39.5 -6.8 L 39.8 -11.4 M 38.4 -14.1 L 39.1 -11.9 L 40.6 -9.6 L 41.8 -8.1 L 42.4 -7.4","0 27.3 M 19.1 -6.7 L 22.4 -8.6 L 24.5 -10.4 L 26.0 -11.9 L 26.9 -13.8 L 26.5 -14.6 L 25.0 -15.1 L 21.2 -14.6 L 17.0 -12.4 L 13.4 -9.3 L 11.0 -5.7 L 9.3 -1.4 L 8.8 2.0 L 9.8 5.7 L 13.0 8.8 L 17.0 10.0 L 20.9 9.7 L 25.7 8.3 L 30.0 5.4 L 33.3 1.1 L 34.0 -3.1 L 33.5 -7.2 L 31.0 -10.3 L 28.1 -11.6 L 23.4 -12.2 L 18.6 -11.8 L 14.0 -10.7 L 9.6 -8.9","0 29.0 M 28.7 -11.9 L 25.3 -1.7 L 21.6 6.8 L 18.8 10.7 L 16.6 12.5 L 14.7 13.0 L 12.8 12.6 L 11.1 11.5 L 9.8 9.9 L 8.7 7.6 L 8.3 5.8 L 8.4 4.4 M 17.8 -3.8 L 15.3 -6.1 L 14.3 -7.7 L 14.6 -10.0 L 16.3 -11.5 L 20.0 -13.1 L 25.6 -13.9 L 29.6 -13.9 L 33.4 -13.2 L 36.6 -11.8 L 38.9 -9.4 L 39.6 -7.1 L 38.9 -5.3 L 37.7 -3.8 L 35.3 -2.2 L 32.4 -1.2 L 27.7 -.5 L 23.5 -.5","0 27.1 M 18.8 -6.5 L 22.2 -8.7 L 24.7 -10.9 L 25.7 -12.0 L 26.5 -13.4 L 26.6 -14.4 L 25.6 -14.9 L 23.1 -15.0 L 19.3 -13.7 L 15.3 -11.3 L 11.8 -7.3 L 9.5 -3.4 L 8.8 .1 L 8.8 3.5 L 10.0 6.1 L 12.0 8.6 L 15.8 10.1 L 19.9 10.0 L 25.2 8.5 L 29.9 5.1 L 32.8 1.7 L 33.8 -2.2 L 33.7 -5.8 L 32.2 -8.9 L 29.8 -11.0 L 27.3 -11.7 L 24.0 -12.0 L 19.8 -11.9 L 17.1 -11.3 L 12.9 -10.3 L 10.0 -8.9 M 8.0 14.1 L 8.7 12.0 L 9.8 11.3 L 11.4 11.0 L 14.6 12.0 L 17.7 13.1 L 22.5 15.7 L 26.7 16.8 L 29.2 16.9 L 31.6 16.1 L 32.6 15.1 L 33.3 13.5 L 33.3 12.3 L 32.6 10.8","0 32.3 M 28.7 -11.8 L 26.6 -4.8 L 24.1 1.4 L 21.7 6.9 L 18.8 10.8 L 16.8 12.4 L 14.5 13.1 L 12.2 12.3 L 9.9 10.0 L 8.9 7.7 L 8.4 6.0 L 8.3 4.7 M 17.8 -3.9 L 15.3 -6.1 L 14.4 -8.3 L 15.6 -11.0 L 18.8 -12.7 L 23.7 -13.9 L 28.5 -13.9 L 32.8 -13.4 L 35.2 -12.8 L 38.1 -10.8 L 39.5 -8.7 L 39.4 -6.1 L 38.5 -4.4 L 36.5 -2.9 L 33.9 -1.8 L 31.0 -1.1 L 27.7 -.6 L 26.5 -.4 L 23.9 -1.1 L 26.8 2.9 L 31.1 7.4 L 33.7 9.8 L 35.7 11.2 L 37.7 11.6 L 39.2 10.8 L 39.7 9.3 L 39.9 7.4 L 39.9 6.2","0 15.6 M 24.4 -6.2 L 26.4 -6.7 L 28.4 -7.7 L 29.9 -9.8 L 30.0 -11.9 L 29.1 -13.9 L 27.0 -15.0 L 23.7 -15.3 L 19.7 -14.6 L 15.6 -13.1 L 12.4 -11.2 L 9.4 -8.1 L 8.4 -4.0 L 9.2 -1.2 L 11.7 1.0 L 18.4 3.0 L 21.0 3.9 L 21.9 5.5 L 21.4 7.4 L 18.4 9.5 L 15.1 10.6 L 11.3 10.8 L 9.5 10.0 L 9.0 8.4","0 23.8 M 32.4 -12.1 L 31.6 -13.2 L 30.7 -12.9 L 28.0 -4.4 L 26.4 1.1 L 24.4 5.5 L 22.5 8.9 L 20.1 11.2 L 18.7 12.1 L 16.7 12.3 L 13.6 11.5 L 11.4 9.2 L 10.4 6.7 L 10.2 4.5 M 17.9 .6 L 14.7 -1.0 L 11.8 -3.9 L 9.5 -7.6 L 8.6 -9.6 L 9.0 -12.3 L 11.5 -14.2 L 14.9 -14.8 L 19.6 -14.2 L 24.8 -12.8 L 33.4 -9.2 L 35.5 -8.6 L 37.9 -8.4 L 38.2 -8.9 L 38.7 -9.4","0 30.8 M 18.5 -.1 L 16.7 2.0 L 14.4 3.1 L 12.1 3.3 L 10.3 2.5 L 9.2 .9 L 9.1 -1.7 L 9.8 -4.4 L 10.9 -6.6 L 13.7 -9.9 L 18.2 -12.7 L 22.2 -13.6 L 25.0 -13.9 L 26.8 -12.8 L 26.9 -11.2 L 26.1 -8.9 L 23.3 -1.9 L 20.6 3.7 L 20.0 6.2 L 20.0 7.7 L 20.4 8.4 L 21.7 8.5 L 22.6 8.0 L 25.5 6.0 L 29.2 2.3 L 32.4 -1.5 L 35.1 -5.1 L 37.2 -8.3 L 39.3 -11.9 L 39.8 -12.5 L 40.2 -12.1 L 37.0 -4.4 L 34.8 2.4 L 33.8 5.5 L 33.5 7.2 L 33.5 8.4 L 33.8 9.1 L 34.8 9.0 L 36.1 8.6 L 37.2 7.9 L 37.8 7.4","0 24.2 M 13.1 -3.2 L 11.0 -3.7 L 9.7 -5.1 L 8.9 -7.7 L 9.1 -10.5 L 9.9 -12.3 L 11.6 -13.9 L 13.7 -14.8 L 16.9 -15.1 L 18.5 -14.8 L 20.7 -13.7 L 22.3 -12.0 L 23.1 -9.8 L 23.7 -7.4 L 24.0 -3.7 L 24.1 -1.2 L 23.9 1.4 L 23.6 4.2 L 23.5 5.2 L 23.3 7.2 L 22.8 8.0 L 22.2 7.9 L 23.2 6.5 L 24.4 5.2 L 27.4 .1 L 30.2 -4.1 L 33.1 -8.3 L 34.8 -10.4 L 37.6 -13.5 L 39.3 -14.8 L 39.9 -15.1 L 41.0 -15.2","0 40.1 M 17.9 .2 L 16.1 .8 L 13.5 .8 L 10.7 -.7 L 9.6 -2.1 L 9.1 -4.7 L 9.7 -7.3 L 11.3 -9.8 L 14.1 -12.0 L 17.7 -13.5 L 20.4 -14.5 L 23.7 -15.2 L 25.9 -15.0 L 27.7 -14.0 L 28.6 -12.6 L 28.8 -10.9 L 29.0 -8.7 L 27.9 -4.0 L 25.5 2.8 L 24.4 6.8 L 23.7 8.8 L 23.4 9.6 L 23.5 10.4 L 24.2 9.8 L 25.5 7.5 L 28.0 4.2 L 30.8 .5 L 33.4 -2.7 L 35.8 -5.1 L 37.9 -7.5 L 38.3 -8.0 L 38.7 -7.7 L 37.2 -2.7 L 35.9 3.3 L 35.7 6.9 L 36.3 9.0 L 37.5 9.7 L 38.8 9.2 L 40.7 8.0 L 43.3 5.5 L 46.0 2.0 L 48.4 -2.1 L 49.7 -5.8 L 50.3 -8.5 L 50.3 -10.6 L 50.0 -12.4 L 49.6 -13.3 L 49.2 -13.6 L 48.0 -14.1","0 24.9 M 10.0 -4.2 L 8.8 -5.1 L 8.4 -7.2 L 8.4 -9.4 L 9.3 -11.7 L 10.6 -13.4 L 12.0 -14.5 L 13.9 -14.9 L 15.7 -14.3 L 17.2 -13.1 L 18.4 -11.3 L 21.8 -1.7 L 24.0 2.5 L 25.8 5.4 L 27.0 7.1 L 28.2 8.0 L 29.4 8.2 L 30.5 7.8 L 31.2 7.2 L 31.8 6.3 L 32.2 5.7 L 32.3 4.6 M 32.9 -14.1 L 32.2 -11.9 L 30.1 -9.7 L 27.8 -7.8 L 24.6 -5.3 L 20.1 -1.4 L 16.7 1.6 L 13.7 4.7 L 11.1 7.7 L 9.5 9.5 L 8.5 11.4","0 32.7 M 20.0 -.5 L 17.9 1.5 L 14.3 3.0 L 11.0 2.0 L 9.6 -.5 L 10.4 -3.7 L 12.4 -7.6 L 15.9 -10.8 L 19.0 -13.1 L 22.8 -14.6 L 27.2 -14.9 L 28.6 -13.7 L 28.5 -11.8 L 26.9 -6.7 L 24.5 -2.2 L 22.5 2.2 L 21.5 5.1 L 21.0 7.9 L 22.0 8.4 L 23.2 8.3 L 25.9 6.7 L 29.9 2.7 L 33.1 -.8 L 36.0 -4.0 L 38.8 -7.9 L 39.7 -9.3 L 41.3 -13.0 L 42.0 -13.7 L 42.2 -12.5 L 39.8 -4.3 L 37.0 2.8 L 33.9 8.5 L 30.6 13.7 L 27.1 17.8 L 23.7 20.1 L 21.2 21.4 L 18.7 21.2 L 15.9 19.7 L 15.3 18.5 L 15.5 16.2","0 22.6 M 14.2 -12.1 L 13.1 -13.2 L 14.4 -13.7 L 19.4 -14.1 L 25.2 -14.1 L 28.2 -14.0 L 29.2 -13.9 L 29.5 -13.4 L 29.1 -12.2 L 22.7 -5.9 L 17.0 -.9 L 13.7 2.1 L 10.3 6.0 L 9.1 7.7 L 9.0 8.9 L 10.7 9.1 L 16.1 8.3 L 20.9 8.1 L 24.1 7.8 L 27.3 8.1 L 28.3 8.4 L 28.3 9.2 L 27.5 10.7","0 19.7 M 26.3 -15.0 L 21.6 -14.8 L 20.7 -14.3 L 16.9 -9.3 L 14.1 -4.1 L 11.3 .9 L 10.0 3.6 L 9.2 5.8 L 9.1 7.3 L 10.0 7.9 L 11.5 8.0 L 16.1 8.0","0 20.3 M 9.8 -15.3 L 14.4 -9.8 L 18.2 -4.8 L 21.5 -.3 L 25.0 4.7 L 26.5 7.0 L 27.2 8.8 L 27.8 10.0 L 27.9 10.8","0 18.6 M 19.0 -14.8 L 23.3 -14.9 L 25.7 -14.5 L 25.9 -13.7 L 25.2 -11.5 L 22.8 -6.3 L 20.3 -1.5 L 17.5 3.2 L 15.0 6.9 L 13.8 7.9 L 12.6 8.3 L 8.7 8.2","0 11.4 M 9.7 -7.8 L 13.4 -10.5 L 16.9 -8.0","0 11.4 M 8.3 8.4 L 18.8 8.4","0 11.9 M 10.9 -11.7 L 16.2 -8.7","0 11.2 M 18.0 -4.0 L 15.5 -4.5 L 13.6 -4.2 L 11.1 -1.1 L 10.1 1.2 L 9.0 3.9 L 8.5 5.9 L 8.7 7.1 L 9.2 7.6 L 10.7 6.6 L 12.8 4.6 L 14.7 2.1 L 16.0 .4 L 17.0 -1.9 L 17.6 -3.1 L 18.0 -4.3 L 18.4 -4.4 L 18.2 -3.5 L 16.8 -.9 L 15.7 2.7 L 15.1 5.2 L 14.9 6.7 L 15.1 7.4 L 15.6 7.5 L 16.7 7.1 L 17.9 6.1 L 19.2 4.8","0 9.8 M 15.8 -13.7 L 15.2 -12.4 L 13.0 -6.0 L 11.0 -.1 L 9.8 2.9 L 9.3 4.4 L 9.2 6.2 L 10.1 7.9 L 11.8 7.7 L 13.1 7.1 L 14.5 5.9 L 15.9 3.1 L 16.6 1.4 L 17.2 -1.0 L 17.5 -2.7 L 17.5 -3.8 L 17.3 -4.4 L 16.2 -3.9 L 14.7 -2.6 L 12.8 -.2 L 11.5 1.5 L 10.4 3.0 L 9.7 4.7 L 9.1 7.0 L 8.6 7.3 L 8.2 6.5 L 8.8 5.1 L 11.1 3.6 L 13.5 2.0 L 16.1 .4 L 18.3 -.6","0 7.8 M 16.0 -1.8 L 16.4 -3.0 L 16.2 -3.9 L 15.4 -4.3 L 13.7 -4.1 L 12.0 -2.8 L 10.3 .1 L 9.1 2.7 L 8.7 5.6 L 8.9 7.2 L 9.9 7.8 L 11.8 7.6 L 13.5 6.4 L 14.6 5.2 L 15.5 4.1","0 11.4 M 19.0 -3.6 L 16.2 -4.3 L 14.6 -4.3 L 12.8 -3.3 L 11.1 -.6 L 9.8 1.7 L 9.0 4.2 L 8.7 5.7 L 8.7 7.0 L 9.0 7.3 L 10.1 7.1 L 12.4 4.9 L 14.5 2.2 L 16.0 .5 L 18.1 -4.4 L 20.6 -11.4 L 20.5 -12.0 L 21.3 -13.7 L 21.6 -13.8 L 18.7 -5.2 L 16.7 .0 L 15.7 3.3 L 14.9 5.7 L 14.9 7.1 L 15.8 7.4 L 17.2 6.6 L 18.2 5.8 L 19.0 5.0","0 8.4 M 9.4 .7 L 11.8 1.1 L 14.4 1.0 L 15.6 .3 L 16.3 -.3 L 16.3 -1.8 L 15.9 -3.2 L 15.2 -3.9 L 14.0 -4.0 L 12.6 -3.4 L 11.3 -1.1 L 9.9 2.1 L 9.3 4.1 L 9.1 5.9 L 9.5 7.6 L 10.7 8.0 L 12.1 7.5 L 13.6 6.3 L 15.1 4.4","0 7.1 M 21.1 -13.4 L 20.8 -14.0 L 18.8 -14.3 L 17.1 -13.6 L 15.4 -11.1 L 9.4 9.4 L 8.6 11.0 L 7.7 12.9 L 6.8 13.9 L 5.0 14.9 L 3.7 14.9 L 2.2 13.8 L 2.0 12.2 L 2.0 11.2 M 10.0 -4.2 L 17.8 -4.5","0 9.9 M 16.4 -3.8 L 14.4 -4.5 L 12.1 -2.4 L 11.1 -.2 L 10.3 2.5 L 10.3 4.6 L 12.3 5.4 L 13.9 4.7 L 15.6 2.7 L 16.6 .8 L 16.9 -1.0 L 16.8 -2.0 L 16.6 -2.7 L 16.4 -5.1 L 17.1 -5.4 L 17.1 -2.9 L 18.0 -2.0 M 9.9 6.9 L 13.1 9.6 L 14.8 13.1 L 15.1 16.3 L 13.4 17.9 L 9.6 19.4 L 7.0 19.7 L 5.5 18.4 L 6.4 15.2 L 8.1 11.9 L 10.4 8.9","0 10.4 M 13.9 -9.8 L 15.4 -12.5 L 16.2 -13.1 L 12.5 -3.7 L 10.2 3.9 L 8.7 7.6 L 10.2 5.5 L 12.1 2.0 L 14.5 -1.5 L 16.5 -3.4 L 17.4 -4.2 L 18.5 -4.8 L 18.8 -4.5 L 17.1 -1.6 L 15.2 2.7 L 13.8 6.1 L 13.5 8.1 L 13.8 9.1 L 14.2 9.3 L 14.9 9.0 L 15.5 8.7","0 5.5 M 11.3 -1.4 L 12.5 -3.6 L 12.8 -4.2 L 13.6 -4.7 L 11.2 .4 L 10.3 3.1 L 9.5 5.8 L 8.9 7.3 L 9.1 7.6 L 10.4 7.2 L 12.6 5.9 M 15.9 -10.5 L 14.1 -8.9 L 13.9 -8.0","0 6.7 M 12.5 -1.7 L 13.4 -4.0 L 14.3 -4.6 L 11.6 3.3 L 9.8 10.0 L 9.1 13.0 L 8.0 15.1 L 6.6 16.4 L 5.7 16.9 L 4.5 16.9 L 3.4 16.2 L 2.5 15.1 L 2.5 12.7 M 16.4 -10.7 L 14.3 -9.2 L 14.5 -8.1","0 9.0 M 13.9 -9.9 L 15.3 -12.6 L 15.9 -13.0 L 13.1 -6.0 L 11.1 -.2 L 9.5 4.9 L 8.9 7.6 L 8.2 8.3 M 19.2 -4.8 L 15.7 -2.2 L 13.0 .7 L 11.5 1.9 L 10.4 2.4 L 10.8 1.0 L 11.9 1.9 L 13.3 5.2 L 14.3 6.7 L 16.1 8.4","0 6.0 M 14.0 -10.0 L 14.7 -12.0 L 15.4 -12.8 L 16.0 -13.1 L 12.8 -4.6 L 10.7 2.0 L 9.4 6.2 L 9.1 7.3 L 9.4 7.5 L 11.3 6.6 L 12.8 5.8","0 16.4 M 11.4 -1.7 L 12.5 -4.1 L 13.2 -4.6 L 10.8 1.0 L 8.4 7.7 L 10.6 4.3 L 13.0 .7 L 14.8 -1.9 L 16.3 -3.4 L 18.1 -4.8 L 19.4 -5.0 L 18.8 -3.8 L 17.0 -.4 L 15.5 3.7 L 14.9 6.6 L 14.8 7.6 L 15.5 7.2 L 16.8 3.9 L 18.8 .5 L 20.7 -1.7 L 22.6 -3.4 L 24.1 -4.5 L 24.6 -4.7 L 25.7 -4.9 L 24.6 -3.2 L 22.9 .9 L 21.1 4.7 L 20.4 7.2 L 20.4 8.4 L 20.4 9.0 L 21.3 9.2 L 22.6 8.4","0 10.8 M 11.2 -1.5 L 12.2 -3.8 L 13.0 -4.5 L 10.1 3.0 L 8.3 7.9 L 9.7 5.7 L 13.0 .8 L 15.2 -2.3 L 17.0 -4.2 L 18.7 -5.2 L 19.3 -5.2 L 17.2 -1.5 L 15.6 3.1 L 14.7 6.0 L 14.5 8.0 L 14.9 8.8 L 15.5 8.8 L 16.5 8.2","0 8.7 M 15.9 -3.8 L 14.3 -4.5 L 12.1 -2.9 L 10.9 -.3 L 9.8 2.2 L 9.2 4.1 L 9.1 6.5 L 9.5 7.6 L 10.4 8.3 L 11.8 8.0 L 13.7 6.3 L 15.2 4.2 L 15.9 2.2 L 16.3 .4 L 16.1 -1.1 L 16.2 -3.2 L 15.6 -5.0 L 15.0 -5.4 L 15.3 -3.3 L 16.7 -1.7 L 17.8 -1.7","0 10.1 M 13.4 -6.0 L 12.8 -5.2 L 6.6 14.0 L 6.2 15.4 L 6.1 16.7 L 6.8 15.5 M 11.6 -4.4 L 13.6 -4.1 L 15.2 -2.4 L 16.1 .3 L 16.4 2.7 L 16.3 5.7 L 14.5 7.5 L 12.6 8.0 L 11.5 7.9 L 10.5 7.4 L 9.4 6.6 L 8.9 5.8 L 9.3 5.0 L 11.6 3.5 L 14.3 1.9 L 17.1 .9 L 19.0 .3","0 10.6 M 18.5 -4.1 L 16.4 -4.7 L 14.1 -3.6 L 11.8 -.4 L 9.9 3.1 L 9.1 5.9 L 9.1 7.0 L 9.3 7.4 L 10.3 7.2 L 12.4 5.7 L 14.6 3.4 L 16.5 1.1 L 17.6 -.5 L 18.4 -2.2 L 19.0 -3.7 L 19.6 -4.3 L 19.9 -3.9 L 19.7 -2.8 L 18.9 -1.9 L 18.2 -.9 L 16.1 4.4 L 13.8 10.4 L 13.0 13.8 L 13.0 14.6 L 13.5 15.2 L 14.5 14.8 L 17.6 12.4","0 9.1 M 10.4 -1.8 L 11.6 -4.1 L 12.7 -4.9 L 10.7 -.4 L 9.7 4.1 L 9.4 6.6 L 9.0 7.4 L 8.6 7.4 L 8.7 6.6 L 11.4 2.3 L 14.1 -1.7 L 15.7 -3.7 L 17.0 -4.5 L 17.8 -4.5 L 18.0 -3.7 L 17.0 -1.6","0 8.6 M 15.7 -.9 L 16.8 -2.8 L 16.9 -4.2 L 16.1 -4.3 L 13.7 -3.8 L 11.5 -2.5 L 10.2 -1.2 L 9.7 -.1 L 10.3 .9 L 12.2 2.5 L 13.9 3.6 L 14.3 4.3 L 14.4 5.1 L 14.1 5.9 L 13.1 6.8 L 11.0 7.7 L 8.7 8.1","0 7.8 M 13.6 -6.4 L 14.6 -8.9 L 15.7 -9.6 L 12.9 -2.3 L 10.8 4.8 L 10.4 6.8 L 10.6 7.7 L 11.7 7.3 L 12.7 7.0 L 14.9 5.1 M 10.6 -4.3 L 18.3 -4.5","0 11.3 M 11.5 -1.9 L 12.4 -4.1 L 13.3 -4.6 L 9.7 4.9 L 9.1 6.6 L 8.9 7.4 L 10.6 6.6 L 13.2 4.0 L 15.7 .9 L 16.5 -.4 L 18.1 -2.0 L 19.3 -4.7 L 18.0 -3.5 L 17.6 -1.5 L 17.0 1.4 L 15.5 6.3 L 15.2 8.5 L 14.3 9.6 L 13.7 9.7 L 16.9 7.3 L 18.8 6.1","0 11.8 M 10.9 -.8 L 11.0 -3.1 L 11.9 -3.8 L 10.9 5.7 L 10.7 6.7 L 10.0 8.0 L 13.6 5.3 L 16.5 1.7 L 18.2 -1.7 L 18.7 -2.8 L 19.1 -5.1 L 18.1 -3.7","0 16.8 M 8.8 -3.3 L 10.1 -4.3 L 10.6 -4.2 L 11.2 -2.0 L 11.4 .9 L 11.5 2.5 L 10.8 4.8 L 10.1 7.0 L 9.9 7.5 L 10.4 8.0 L 11.1 4.9 L 13.6 .5 L 15.5 -2.6 L 16.3 -3.6 L 16.9 -4.3 L 17.8 -3.4 L 18.7 .1 L 19.3 2.8 L 19.5 5.4 L 19.4 7.4 L 20.5 5.5 L 22.3 2.4 L 24.1 -1.0 L 24.7 -2.6 L 25.2 -3.9 L 25.2 -5.2 L 25.0 -5.4 L 24.8 -4.7","0 10.6 M 10.9 -3.0 L 12.4 -3.4 L 13.2 -4.0 L 13.9 -2.2 L 15.2 2.1 L 16.1 6.2 L 16.7 8.0 L 16.6 8.6 M 20.0 -3.9 L 19.8 -4.3 L 17.3 -1.9 L 13.5 2.2 L 10.6 5.7 L 8.6 8.3 L 7.4 9.8 L 6.7 11.2","0 10.9 M 9.8 -2.8 L 10.5 -3.6 L 11.8 -.4 L 11.9 2.3 L 11.9 6.1 L 11.6 9.1 M 18.3 -4.2 L 19.7 -4.6 L 19.3 -3.4 L 17.6 -.3 L 15.5 2.6 L 13.3 5.7 L 10.0 10.2 L 7.4 14.0 L 6.2 16.1 L 5.7 17.8 L 5.8 18.9","0 10.8 M 11.3 -2.3 L 11.9 -3.6 L 12.8 -4.1 L 15.6 -4.2 L 17.6 -4.1 L 18.5 -4.0 L 18.7 -3.6 L 18.3 -3.0 L 16.0 -1.3 L 13.0 2.1 L 9.5 5.6 L 8.7 6.5 L 8.6 7.3 L 9.4 7.7 L 14.3 7.6 L 16.1 7.5 L 17.6 7.1 L 17.4 7.8","0 11.0 M 22.1 -13.5 L 19.4 -13.1 L 17.5 -11.7 L 16.3 -9.1 L 15.9 -6.3 L 14.6 -3.7 L 13.5 -2.3 L 11.7 -1.4 L 10.8 -1.2 L 9.5 -1.2 L 11.5 -1.0 L 12.6 .1 L 13.1 1.1 L 12.7 4.4 L 11.6 7.8 L 11.5 10.4 L 12.0 11.4 L 13.5 12.1 L 14.8 12.0","0 7.0 M 12.4 -11.6 L 11.8 -12.5 L 12.2 -7.1 L 12.0 1.4 L 11.9 6.0 L 11.8 9.0 L 11.4 10.6","0 14.2 M 16.0 -13.6 L 17.5 -13.6 L 18.4 -13.4 L 19.4 -12.8 L 19.8 -11.2 L 19.3 -8.5 L 18.1 -5.3 L 17.9 -3.3 L 18.4 -1.9 L 19.2 -1.3 L 19.8 -.7 L 20.4 -.4 L 21.5 -.4 L 18.9 -.1 L 17.2 .9 L 15.7 3.1 L 15.0 6.0 L 14.5 8.4 L 13.2 10.5 L 11.9 11.4 L 10.2 11.8 L 9.1 12.0","0 10.2 M 9.0 -7.3 L 9.9 -8.1 L 10.8 -8.5 L 12.2 -8.0 L 13.5 -7.5 L 14.7 -7.7 L 15.6 -8.1 L 15.9 -8.5","0 9.4 M 12.9 -8.7 L 11.3 -8.1 L 10.6 -7.1 L 10.2 -5.8 L 10.6 -4.4 L 11.4 -3.5 L 13.1 -3.1 L 14.6 -3.7 L 15.6 -5.1 L 15.7 -6.5 L 15.1 -7.7 L 14.3 -8.3 L 13.7 -8.5 L 12.9 -8.7"]
EMSBrush = ["-8 8","0 11.7 M 22.6 -9.8 L 19.1 -5.8 L 17.0 -2.7 L 15.8 -.7 L 15.0 .8 L 14.7 2.1 M 12.6 5.7 L 12.6 6.9 L 13.7 7.0 L 13.9 5.8 L 12.6 5.7","0 13.4 M 14.0 -9.6 L 13.3 -10.0 L 14.0 -10.6 L 14.8 -9.7 L 14.7 -8.0 L 12.7 -5.9 M 18.3 -9.6 L 17.5 -10.0 L 18.2 -10.6 L 19.0 -9.7 L 18.9 -8.0 L 16.9 -5.9","0 32.3 M 22.9 -17.0 L 14.8 5.3 M 32.6 -16.7 L 24.5 5.2 M 9.3 -1.9 L 34.8 -1.9 M 13.0 -10.4 L 37.7 -10.5","0 22.5 M 10.6 -7.4 L 9.3 -6.1 L 9.4 -3.9 L 10.7 -2.5 L 12.2 -1.4 L 15.5 -.8 L 19.3 -1.0 L 21.9 -1.9 L 24.9 -4.0 L 25.7 -6.0 L 25.7 -7.0 L 25.2 -7.9 L 23.9 -8.5 L 19.2 -9.5 L 17.4 -10.4 L 16.8 -12.0 L 17.4 -13.5 L 19.3 -15.0 L 21.6 -16.0 L 23.9 -16.2 L 26.8 -16.1 L 28.3 -15.6 L 28.9 -14.6 L 29.1 -13.0 L 28.2 -12.1 L 27.0 -12.0 M 28.9 -20.5 L 21.4 -11.5 L 17.0 -5.5 L 13.3 -.3 L 11.5 2.6 L 10.8 5.6 L 10.6 6.8","0 29.0 M 20.8 -19.5 L 17.5 -17.1 L 15.2 -14.3 L 13.9 -11.9 L 13.3 -9.5 L 14.2 -7.9 L 16.2 -8.0 L 19.3 -10.3 L 21.7 -13.3 L 22.6 -15.2 L 22.8 -17.7 L 22.7 -19.3 L 21.7 -20.2 L 21.1 -20.0 L 21.2 -18.5 L 22.0 -16.8 L 24.3 -16.8 L 27.4 -17.5 L 34.3 -19.5 L 27.7 -11.5 L 20.4 -1.9 L 16.5 3.8 L 14.5 7.9 L 13.9 8.9 L 14.0 11.2 M 30.9 1.4 L 30.1 -1.1 L 28.8 -2.0 L 24.7 1.2 L 22.5 4.4 L 21.3 7.0 L 21.4 9.2 L 22.4 10.3 L 23.8 10.2 L 26.9 7.9 L 29.5 4.7 L 30.9 1.4","0 31.1 M 30.7 -13.5 L 32.5 -13.9 L 33.7 -15.6 L 33.7 -16.8 L 32.4 -17.9 L 29.4 -18.3 L 26.5 -17.7 L 23.6 -16.4 L 22.1 -15.6 L 20.4 -13.4 L 20.2 -11.9 L 20.6 -10.2 L 21.9 -8.7 L 23.6 -7.8 L 24.9 -7.9 L 25.8 -8.3 L 25.9 -9.2 L 25.2 -9.8 L 23.0 -10.0 L 21.9 -9.4 L 19.1 -8.8 L 16.0 -7.0 L 13.2 -5.0 L 11.5 -2.9 L 10.5 -.9 L 10.3 .8 L 10.7 2.3 L 12.2 3.7 L 14.2 4.5 L 18.7 4.9 L 23.5 3.7 L 27.2 1.6 L 29.0 -.3 L 30.0 -1.9 L 30.3 -3.8 L 30.1 -4.9 L 28.9 -6.2 M 37.7 -10.1 L 37.0 -8.2 L 34.5 -7.3 L 31.2 -6.5 L 26.6 -5.9 L 22.0 -4.0 L 18.9 -1.3 L 17.4 1.4 L 16.7 4.2 L 16.4 6.6 L 17.2 9.6 L 19.7 11.6 L 22.7 12.8 L 24.6 12.4 L 25.7 11.6 L 26.4 10.0","0 10.0 M 15.9 -8.1 L 15.3 -8.5 L 16.1 -9.2 L 17.0 -8.2 L 16.3 -6.0 L 14.5 -3.9","0 15.8 M 32.8 -22.0 L 25.5 -20.1 L 19.4 -16.8 L 14.3 -12.1 L 11.3 -7.3 L 9.9 -3.1 L 9.6 2.2 L 10.8 5.0 L 13.3 7.5 L 14.8 8.3 L 16.8 8.4","0 26.9 M 10.0 8.6 L 15.0 7.5 L 19.4 5.6 L 24.3 2.4 L 27.5 -.8 L 30.3 -4.3 L 32.4 -8.6 L 33.3 -12.0 L 33.2 -16.0 L 31.1 -19.6 L 28.6 -21.3 L 26.1 -21.8","0 15.2 M 14.9 -1.7 L 16.7 -11.0 M 11.8 -3.4 L 19.9 -9.2 M 11.2 -6.3 L 20.4 -6.4 M 13.1 -10.0 L 19.0 -2.6","0 17.7 M 18.0 -8.9 L 17.1 -3.7 L 16.8 -1.6 L 15.0 3.9 M 10.4 -1.9 L 22.4 -2.0","0 8.8 M 13.2 6.7 L 12.5 6.1 L 13.9 5.6 L 13.9 7.5 L 13.4 8.7 L 11.7 10.4","0 12.4 M 9.5 -1.9 L 18.3 -2.2","0 10.0 M 12.6 6.0 L 13.0 6.8 L 14.2 6.9 L 14.2 5.9 L 12.6 6.0","0 25.5 M 10.6 12.1 L 10.2 10.9 L 10.7 8.7 L 12.6 4.9 L 15.0 1.1 L 19.0 -4.2 L 22.2 -8.6 L 25.2 -12.4 L 29.0 -17.1 L 30.8 -19.3","0 23.5 M 33.2 -17.0 L 29.7 -17.5 L 26.0 -16.5 L 21.6 -13.8 L 16.8 -9.6 L 13.8 -6.0 L 11.9 -2.0 L 10.9 1.6 L 11.0 5.2 L 12.0 6.8 L 14.7 7.6 L 19.5 6.6 L 23.6 4.6 L 28.1 1.3 L 31.6 -3.1 L 33.5 -6.8 L 33.9 -11.1 L 33.8 -12.8 L 33.1 -14.5 L 31.4 -15.9 L 29.3 -16.9 L 26.0 -17.0","0 15.4 M 17.4 -10.7 L 21.1 -12.5 L 23.9 -14.1 L 25.8 -15.9 L 26.2 -16.1 L 13.9 5.6 L 9.7 7.3 L 13.9 5.6 L 16.4 5.0 L 20.3 5.0","0 27.2 M 19.0 -10.0 L 24.1 -13.2 L 29.2 -15.2 L 32.3 -15.8 L 34.6 -15.5 L 35.7 -13.6 L 35.3 -11.0 L 33.7 -8.3 L 31.2 -5.5 L 27.3 -2.2 L 18.5 3.3 L 15.5 5.0 L 12.6 6.5 L 10.7 7.1 L 9.5 7.0 L 9.8 6.0 L 11.0 5.1 L 13.0 4.7 L 14.3 4.8 L 18.4 5.8 L 24.9 8.1 L 28.7 9.0 L 32.0 8.6 L 33.9 7.4 L 35.0 5.9 L 35.0 4.3 L 32.3 2.5","0 29.7 M 27.1 -15.0 L 24.6 -12.9 L 29.9 -15.1 L 33.5 -16.0 L 36.3 -15.3 L 36.9 -13.6 L 36.6 -11.8 L 35.4 -10.1 L 32.6 -8.5 L 30.1 -7.3 L 27.5 -7.0 L 24.6 -6.3 L 24.6 -6.9 L 31.3 -6.7 L 33.9 -6.2 L 35.8 -4.4 L 36.0 -2.4 L 34.3 .9 L 31.8 3.7 L 28.6 5.4 L 24.3 7.0 L 18.6 7.4 L 14.1 6.8 L 11.9 5.4 L 10.8 3.6 L 11.0 1.4 L 13.3 -1.1 L 16.8 -2.5 L 18.8 -3.2","0 23.5 M 22.1 10.0 L 21.4 8.4 L 21.6 5.3 L 22.8 1.6 L 24.6 -2.1 L 27.6 -6.9 L 30.7 -11.7 L 34.5 -16.8 L 29.2 -12.5 L 10.8 .4 L 10.0 .2 L 10.1 -.5 L 12.3 -1.0 L 14.7 -1.5 L 17.1 -1.6 L 19.4 -1.4 L 21.7 -.8 L 25.6 .3 L 28.3 1.1 L 31.1 1.1 L 32.3 .4 L 33.1 -1.0 L 33.1 -3.0","0 27.9 M 10.3 -.1 L 8.5 2.4 L 8.6 4.6 L 10.5 6.4 L 14.2 7.5 L 18.0 7.1 L 21.2 6.1 L 24.6 4.4 L 28.8 1.4 L 31.3 -1.7 L 32.4 -4.9 L 32.1 -7.0 L 30.8 -8.5 L 27.8 -9.3 L 24.6 -9.3 L 20.9 -8.7 L 15.5 -6.2 L 20.9 -12.7 M 21.0 -15.3 L 22.2 -16.1 L 25.0 -16.5 L 27.5 -16.3 L 30.4 -15.6 L 34.5 -14.9 L 37.1 -14.9 L 38.7 -15.5 L 39.4 -16.3 L 39.6 -17.4","0 25.8 M 17.9 5.6 L 18.9 3.2 L 21.8 .4 L 25.3 -1.3 L 28.5 -1.7 L 30.7 -.9 L 31.2 .6 L 30.5 2.9 L 27.9 4.9 L 24.6 6.7 L 19.5 7.7 L 16.7 7.9 L 14.8 7.5 L 12.6 6.7 L 11.4 4.2 L 11.8 1.1 L 14.2 -3.3 L 18.4 -7.4 L 24.2 -10.7 L 32.2 -14.3 L 36.4 -15.5 L 32.6 -15.6","0 20.8 M 14.1 7.6 L 14.3 4.5 L 16.3 1.1 L 19.2 -2.9 L 23.2 -7.0 L 28.3 -11.3 L 35.1 -16.7 L 33.2 -15.1 L 29.2 -16.3 L 25.1 -17.0 L 20.5 -17.1 L 17.7 -16.4 L 15.4 -14.8 L 14.1 -11.9 L 14.5 -13.8 L 14.7 -15.7","0 25.1 M 33.0 -13.5 L 33.2 -14.9 L 32.0 -16.3 L 28.5 -16.8 L 24.7 -15.9 L 22.2 -14.5 L 20.7 -12.5 L 20.6 -10.9 L 22.0 -9.5 L 24.0 -8.5 L 26.6 -7.4 L 29.7 -5.7 L 30.8 -4.1 L 31.3 -2.2 L 30.6 .0 L 28.9 1.5 L 26.0 3.9 L 22.5 5.7 L 17.9 7.4 L 14.7 7.8 L 12.5 7.7 L 10.4 6.5 L 9.7 4.2 L 10.5 1.9 L 13.7 -1.6 L 18.7 -5.7 L 22.8 -8.2 L 29.7 -11.1 L 31.9 -12.1 L 36.6 -13.6","0 18.8 M 31.7 -16.5 L 25.2 -15.7 L 19.8 -13.9 L 15.1 -11.4 L 13.3 -9.2 L 12.6 -7.0 L 13.4 -5.1 L 16.7 -5.6 L 20.7 -7.3 L 24.9 -10.0 L 28.6 -12.5 L 31.6 -14.8 L 32.2 -14.6 L 26.0 -8.5 L 20.8 -2.8 L 16.9 3.1 L 15.2 7.0 L 14.5 9.5 L 14.5 11.7 L 15.5 13.2","0 10.7 M 14.9 -1.8 L 14.8 -.8 L 16.1 -.8 L 16.2 -1.7 L 14.9 -1.8 M 13.4 5.9 L 13.5 6.8 L 14.5 6.8 L 14.7 5.9 L 13.4 5.9","0 10.5 M 14.6 -2.0 L 14.6 -.8 L 15.7 -.7 L 15.9 -1.9 L 14.6 -2.0 M 13.9 6.6 L 13.2 6.1 L 14.3 5.6 L 14.7 7.5 L 13.5 9.3 L 12.5 10.3","0 13.9 M 17.1 -9.3 L 12.8 -3.3 L 17.2 1.4","0 17.4 M 11.9 -6.7 L 24.6 -7.1 M 10.4 -1.9 L 23.6 -2.3","0 14.0 M 12.8 -9.0 L 17.2 -4.5 L 12.9 1.8","0 17.5 M 16.6 -5.3 L 15.1 -4.2 L 13.6 -4.4 L 12.7 -5.3 L 12.7 -7.5 L 13.9 -9.0 L 15.8 -10.2 L 18.4 -11.0 L 21.5 -10.8 L 23.4 -10.4 L 24.7 -9.1 L 25.0 -6.9 L 24.2 -5.0 L 22.1 -3.4 L 19.5 -1.9 L 17.4 -.5 L 15.8 1.0 L 15.0 2.5 M 13.1 6.0 L 13.0 7.0 L 14.2 7.2 L 14.4 6.1 L 13.1 6.0","0 34.9 M 28.3 -12.0 L 26.3 -12.5 L 23.6 -11.2 L 20.2 -8.6 L 18.0 -6.3 L 16.9 -4.3 L 16.4 -2.2 L 16.9 -.9 L 18.3 -.1 L 20.3 -.7 L 22.5 -2.6 L 24.5 -4.7 L 29.2 -10.9 L 30.2 -10.6 L 26.5 -5.6 L 25.4 -3.1 L 25.3 -1.8 L 26.1 -.6 L 27.5 -.4 L 29.6 -1.6 L 33.8 -5.1 L 37.4 -9.1 L 40.1 -12.9 L 40.4 -16.0 L 39.7 -17.9 L 37.5 -19.7 L 34.7 -20.5 L 29.9 -20.1 L 25.9 -18.9 L 21.0 -16.5 L 16.9 -13.5 L 13.9 -10.2 L 11.5 -6.2 L 10.4 -2.0 L 10.7 1.8 L 12.5 4.6 L 15.4 6.0 L 20.3 6.1 L 26.0 4.8 L 30.3 2.5 L 33.9 -.2 L 37.2 -3.6 L 38.9 -6.6 L 39.3 -9.6 L 39.1 -12.2 L 37.0 -14.8 L 34.2 -16.3 L 31.3 -17.2 L 27.6 -17.0","0 41.7 M 28.3 -4.1 L 30.2 -6.9 L 31.0 -9.9 L 30.3 -12.0 L 28.7 -12.9 L 25.9 -12.9 L 21.4 -11.2 L 16.5 -7.4 L 13.2 -3.2 L 10.8 .7 L 9.6 4.3 L 9.9 8.1 L 11.8 10.7 L 15.2 11.8 L 18.2 11.3 L 22.7 9.1 L 28.9 4.9 L 34.5 .1 L 44.1 -9.4 L 49.4 -15.0 L 51.1 -16.7 L 52.2 -17.4 L 51.9 -15.5 L 48.0 -9.6 L 45.9 -5.8 L 43.6 -1.9 L 42.1 2.3 L 41.3 5.1 L 41.0 7.2 L 41.0 8.4 L 41.6 9.1 L 42.6 9.4 L 43.5 9.1 L 44.3 8.4 M 32.7 -3.1 L 33.1 -3.1 L 34.6 -3.5 L 48.8 -3.3","0 34.2 M 15.4 -5.9 L 14.0 -7.8 L 14.5 -10.3 L 16.3 -12.9 L 20.4 -15.7 L 24.9 -17.5 L 30.6 -18.5 L 35.4 -18.5 L 38.6 -18.0 L 42.0 -16.1 L 43.4 -13.5 L 42.9 -10.6 L 41.9 -8.3 L 39.3 -6.8 L 36.4 -6.1 L 31.7 -5.7 L 29.3 -5.8 L 29.4 -6.5 L 34.5 -4.9 L 36.4 -3.8 L 37.9 -1.3 L 38.1 1.1 L 36.9 3.9 L 35.0 5.9 L 32.3 7.4 L 29.0 8.6 L 25.4 8.9 L 23.0 8.7 L 20.9 8.1 L 19.2 6.3 L 18.3 5.0 L 17.3 2.9 L 15.9 -1.6 L 15.5 -2.1 L 14.4 -2.3 L 12.9 -1.1 L 11.5 1.5 L 10.5 4.0 L 10.3 5.8 L 10.6 7.3 L 11.5 8.2 L 13.4 7.7 L 15.6 5.7 L 19.8 1.7 L 24.2 -3.7 L 29.8 -10.7 L 32.7 -13.6 L 34.2 -14.6 L 35.4 -14.6","0 29.9 M 27.9 -11.4 L 25.6 -9.4 L 25.1 -7.8 L 25.2 -6.6 L 26.2 -5.1 L 28.2 -4.0 L 31.1 -3.9 L 33.9 -4.5 L 36.9 -6.6 L 38.9 -9.2 L 39.6 -11.5 L 39.5 -13.7 L 38.3 -15.9 L 36.2 -17.1 L 33.7 -17.8 L 30.2 -17.7 L 24.0 -15.7 L 20.2 -13.5 L 16.1 -9.9 L 13.0 -5.7 L 11.6 -1.9 L 11.0 2.8 L 12.0 5.9 L 14.1 8.2 L 18.9 9.6 L 23.3 9.2 L 25.8 8.5 L 30.1 6.4 L 32.7 4.6 L 34.7 2.6","0 38.1 M 14.7 -6.1 L 14.2 -7.8 L 14.9 -10.1 L 17.8 -13.3 L 21.8 -15.4 L 25.6 -16.6 L 30.2 -17.0 L 35.2 -16.6 L 38.7 -15.7 L 41.8 -13.1 L 43.7 -9.8 L 44.2 -5.4 L 43.4 -1.7 L 41.5 1.5 L 39.0 4.3 L 35.9 6.7 L 31.7 8.4 L 26.3 9.3 L 23.0 9.4 L 20.9 9.1 L 18.6 8.1 L 17.1 6.8 L 15.7 4.7 L 14.6 1.9 L 14.2 -.8 L 14.0 -1.8 L 13.2 -1.5 L 11.5 1.1 L 10.4 4.1 L 10.1 6.1 L 10.4 8.1 L 11.4 8.8 L 12.8 8.3 L 15.1 6.7 L 19.5 2.2 L 25.2 -4.9 L 28.6 -9.2 L 32.3 -12.8 L 33.6 -13.6 L 34.7 -13.6","0 28.2 M 22.5 5.9 L 21.7 5.1 L 21.7 2.6 L 23.7 -.3 L 26.2 -2.0 L 28.7 -3.1 L 31.4 -3.3 L 33.4 -2.0 L 33.8 .1 L 33.2 2.8 L 29.8 6.6 L 25.9 8.8 L 22.3 9.9 L 16.2 10.2 L 12.4 9.2 L 10.2 7.7 L 9.0 5.3 L 9.0 3.3 L 10.4 .6 L 12.9 -2.2 L 16.0 -4.4 L 20.0 -6.3 L 22.9 -7.3 L 25.8 -8.0 L 28.1 -8.3 L 30.2 -7.8 L 30.9 -7.1 L 30.9 -6.6 L 29.8 -5.4 L 27.7 -5.1 L 25.7 -5.6 L 23.8 -6.5 L 21.9 -7.7 L 21.2 -9.6 L 21.1 -11.8 L 22.9 -14.5 L 25.9 -16.3 L 29.2 -17.8 L 32.5 -18.4 L 36.0 -18.0 L 37.6 -17.0 L 38.0 -15.1 L 37.0 -13.4 L 36.1 -12.8 L 34.5 -12.7","0 26.4 M 21.4 -5.8 L 21.1 -4.0 L 19.4 -2.0 L 17.8 -.1 L 15.4 .9 L 13.0 1.0 L 11.0 .9 L 9.1 -.9 L 9.2 -4.2 L 10.7 -7.5 L 14.3 -11.4 L 18.7 -14.6 L 23.8 -17.0 L 27.9 -18.1 L 31.7 -18.3 L 34.7 -17.8 L 36.3 -15.9 L 36.4 -14.4 L 35.6 -11.9 L 21.0 7.6 L 19.3 9.8 L 20.1 10.1 M 22.9 -1.8 L 34.0 -1.9","0 34.0 M 29.7 -12.1 L 29.7 -9.4 L 31.2 -7.8 L 33.5 -7.3 L 36.8 -8.6 L 39.2 -10.0 L 40.5 -12.3 L 40.4 -14.2 L 37.5 -16.5 L 32.5 -17.0 L 25.2 -15.2 L 18.1 -11.4 L 13.9 -7.9 L 11.2 -4.8 L 9.5 -1.9 L 8.9 1.0 L 8.8 3.1 L 10.7 6.5 L 14.1 8.1 L 19.1 8.5 L 24.1 7.4 L 28.1 5.6 L 32.2 3.1 L 35.7 .0 L 37.8 -2.6 L 38.1 -3.5 L 38.8 -3.6 L 29.0 12.4 M 24.1 -2.7 L 27.3 -3.7 L 31.1 -4.1 L 44.2 -4.2","0 39.1 M 21.5 -9.5 L 21.9 -8.9 L 21.8 -5.4 L 20.2 -2.8 L 18.4 -1.1 L 16.2 -.1 L 13.9 -.1 L 11.7 -1.0 L 10.5 -4.3 L 11.8 -10.2 L 14.5 -13.7 L 19.2 -17.4 L 23.4 -19.2 L 26.6 -20.1 L 31.8 -19.9 L 33.9 -19.4 L 35.2 -16.9 L 34.9 -14.4 L 33.0 -10.8 L 20.8 9.0 M 17.7 2.2 L 20.1 .3 L 22.7 -.3 L 27.8 -.1 L 32.5 .5 L 37.7 .4 L 41.3 .1 L 43.6 -.6 M 58.1 -21.1 L 53.4 -17.6 L 49.1 -13.0 L 45.2 -8.1 L 42.2 -3.3 L 39.1 1.7 L 37.8 5.4 L 37.5 7.8 L 37.7 9.0 L 38.9 9.8 L 40.4 9.6 L 41.0 9.2 L 42.7 8.0","0 24.5 M 14.0 -1.6 L 13.4 .6 L 14.0 2.2 L 15.8 3.1 L 18.4 2.3 L 20.0 .5 L 21.8 -1.9 L 22.6 -4.3 L 22.6 -7.6 L 22.1 -8.5 L 19.5 -9.6 L 16.0 -8.6 L 13.5 -6.4 L 11.2 -1.9 L 10.5 .7 L 10.3 4.1 L 11.2 6.7 L 12.2 8.4 L 15.6 9.9 L 19.0 8.8 L 22.6 6.4 L 25.6 2.6 L 29.1 -2.6 L 32.2 -8.1 L 34.8 -11.6 L 37.8 -14.5 L 39.9 -16.1 L 42.0 -16.3 L 42.9 -16.3 L 41.9 -17.9 L 38.9 -19.4 L 33.8 -19.3 L 28.4 -16.3 L 26.3 -13.2 L 25.7 -10.5 L 26.4 -7.9 L 28.3 -6.0 L 32.5 -4.9 L 35.5 -5.4 L 37.1 -6.3 L 37.6 -7.2 L 37.6 -8.7","0 34.0 M 26.0 3.6 L 27.2 1.5 L 27.7 -1.0 L 27.2 -2.4 L 26.0 -4.0 L 23.3 -4.6 L 20.8 -4.4 L 17.1 -2.7 L 13.7 .4 L 11.6 4.2 L 11.5 7.5 L 12.4 9.9 L 14.2 11.8 L 17.5 12.2 L 21.2 11.7 L 25.4 10.1 L 29.6 7.4 L 34.2 2.7 L 38.2 -2.5 L 42.7 -9.7 L 45.0 -13.9 L 46.8 -17.7 L 46.9 -19.6 M 34.8 -11.7 L 33.5 -13.7 L 33.9 -15.7 L 35.8 -17.5 L 39.0 -18.6 L 42.7 -19.3 L 45.7 -19.3 L 48.8 -18.6 L 50.8 -18.1 L 52.2 -17.2 L 52.5 -16.1","0 38.1 M 23.6 -3.6 L 23.6 -4.2 L 23.0 -5.0 L 20.5 -5.6 L 17.4 -5.1 L 14.0 -3.1 L 11.6 -.3 L 10.5 2.6 L 10.3 5.8 L 12.3 9.0 L 16.3 10.0 L 21.0 8.7 L 24.9 6.2 L 28.0 3.2 L 30.4 .7 L 34.0 -4.3 L 36.9 -9.1 L 39.5 -14.0 L 40.6 -16.1 L 41.3 -18.1 L 41.4 -19.2 L 40.7 -19.3 L 36.2 -17.5 L 32.5 -15.4 L 30.5 -13.3 L 29.4 -11.8 L 29.2 -10.4 L 29.6 -9.8 L 30.6 -9.7 L 31.7 -9.7 M 53.4 8.8 L 53.3 10.3 L 52.1 11.8 L 49.7 12.0 L 47.1 11.4 L 44.5 9.5 L 40.6 5.4 L 36.9 -.4 L 35.0 -4.9 L 34.5 -6.2 L 33.3 -6.9 L 32.2 -6.8 L 30.9 -5.8 L 30.2 -4.7 L 30.1 -2.6 L 30.8 -1.5 L 32.2 -.8 L 34.3 -1.2 L 37.2 -3.0 L 43.8 -7.9 L 50.9 -13.4 L 56.9 -17.4 L 62.1 -20.0 L 65.8 -20.9 L 68.4 -21.1 L 70.2 -20.8 L 70.8 -20.3","0 27.7 M 24.2 -10.0 L 22.9 -10.7 L 20.9 -10.0 L 19.8 -8.7 L 19.3 -6.6 L 20.1 -4.3 L 22.5 -2.8 L 25.2 -1.5 L 28.8 -1.9 L 34.7 -4.6 L 38.8 -8.6 L 41.6 -13.4 L 42.1 -16.9 L 40.8 -18.6 L 39.0 -19.1 L 35.6 -17.8 L 31.0 -13.2 L 27.8 -8.3 L 18.7 3.8 L 15.7 7.0 L 13.3 8.7 L 10.5 8.6 L 9.5 6.6 L 10.0 3.0 L 11.2 .3 L 12.8 -1.8 L 13.5 -2.2 L 18.4 6.1 L 23.4 9.8 L 27.9 11.1 L 32.4 11.0 L 34.8 9.9 L 35.8 8.6 L 35.9 7.0","0 46.5 M 23.2 -2.3 L 23.0 .1 L 21.0 2.1 L 18.8 3.8 L 15.2 4.4 L 12.6 3.7 L 10.7 1.6 L 10.1 -1.1 L 11.1 -6.2 L 13.9 -10.1 L 17.2 -13.1 L 20.7 -15.5 L 25.9 -17.4 L 29.7 -17.9 L 33.0 -17.0 L 34.2 -14.3 L 33.5 -10.9 L 30.9 -4.9 L 27.4 .3 L 22.4 8.3 L 23.2 8.3 L 31.2 -2.9 L 36.1 -8.8 L 42.1 -14.4 L 44.1 -15.5 L 45.7 -15.4 L 46.0 -14.6 L 45.1 -12.1 L 41.1 -4.2 L 34.5 7.3 L 40.2 .3 L 47.0 -6.9 L 57.8 -16.1 L 58.6 -15.4 L 57.7 -13.8 L 52.4 -7.4 L 47.8 .1 L 45.8 4.2 L 45.2 7.2 L 45.8 9.4 L 47.4 9.5 L 50.8 8.0","0 38.3 M 22.0 -1.6 L 22.3 1.1 L 20.5 3.2 L 17.6 4.9 L 14.9 5.3 L 12.1 5.0 L 10.3 3.6 L 9.5 -.4 L 10.5 -4.4 L 13.6 -8.7 L 16.9 -11.6 L 20.3 -14.0 L 23.5 -15.5 L 27.5 -16.5 L 30.8 -16.3 L 33.0 -14.8 L 32.9 -10.5 L 30.7 -5.0 L 26.7 1.2 L 21.7 9.3 L 22.7 9.4 L 24.3 5.6 L 29.7 -.7 L 36.5 -6.7 L 42.1 -10.7 L 49.9 -14.5 L 51.1 -13.6 L 49.6 -11.7 L 45.6 -7.1 L 40.4 .5 L 38.2 5.7 L 37.8 8.6 L 37.9 10.2 L 38.5 11.0 L 40.1 10.5 L 43.4 8.9","0 31.9 M 31.8 -1.0 L 32.1 -1.0 L 37.0 -5.2 L 39.5 -8.1 L 40.7 -11.0 L 40.5 -14.3 L 37.0 -16.9 L 32.2 -17.3 L 26.5 -16.1 L 20.9 -13.1 L 15.6 -8.6 L 12.6 -4.1 L 10.7 .8 L 10.7 5.0 L 12.6 7.8 L 15.3 9.4 L 21.9 9.3 L 27.6 7.3 L 33.5 3.4 L 38.4 -1.2 L 39.7 -5.7 L 39.0 -9.6 L 36.1 -12.5 L 32.8 -13.7 L 28.3 -13.9","0 43.5 M 23.0 3.3 L 24.2 1.5 L 24.6 -.4 L 23.3 -2.6 L 20.4 -3.2 L 17.5 -3.0 L 14.3 -.7 L 11.7 2.2 L 11.0 4.8 L 11.2 8.0 L 13.4 10.7 L 17.9 11.4 L 22.9 10.0 L 26.3 7.3 L 30.6 1.9 L 36.8 -8.4 L 40.4 -17.0 M 26.8 -9.4 L 23.9 -7.9 L 21.0 -7.6 L 18.3 -7.8 L 16.9 -9.1 L 16.7 -11.0 L 18.7 -13.0 L 22.4 -14.6 L 28.0 -16.1 L 36.2 -16.8 L 39.6 -16.9 L 46.0 -16.0 L 50.5 -14.9 L 54.3 -12.6 L 55.0 -9.9 L 54.2 -7.7 L 51.7 -5.0 L 47.3 -2.4 L 42.4 -1.0 L 38.8 -.8 L 34.3 -1.2","0 32.5 M 31.4 -.9 L 35.6 -3.8 L 38.5 -6.7 L 40.2 -9.6 L 40.8 -12.3 L 39.9 -14.7 L 37.3 -16.7 L 32.3 -17.1 L 26.0 -15.9 L 19.1 -11.9 L 13.9 -6.8 L 11.8 -2.8 L 10.6 .7 L 10.8 4.2 L 11.7 7.1 L 13.3 8.6 L 17.2 9.6 L 21.6 9.3 L 27.6 7.4 L 33.5 3.5 L 37.9 -.8 L 39.6 -5.4 L 39.1 -9.2 L 36.5 -12.1 L 33.7 -13.6 L 31.2 -14.0 L 27.6 -13.6 M 12.4 10.4 L 12.6 7.8 L 14.1 5.2 L 16.2 4.4 L 19.4 5.4 L 33.6 14.2 L 36.5 15.2 L 38.4 14.5 L 39.0 13.6 L 38.8 12.0","0 30.7 M 10.6 1.8 L 7.4 5.7 L 7.1 8.0 L 7.8 9.3 L 9.6 10.3 L 11.8 9.9 L 15.5 8.0 L 19.9 4.0 L 30.5 -8.9 L 32.6 -11.1 L 33.8 -11.6 L 34.7 -11.6 L 34.9 -11.1 M 22.3 -7.7 L 21.5 -6.3 L 18.6 -4.1 L 15.3 -3.1 L 13.9 -3.1 L 12.6 -3.6 L 12.2 -6.0 L 14.2 -9.7 L 17.5 -12.6 L 22.9 -15.2 L 29.5 -16.6 L 34.8 -16.6 L 39.2 -15.6 L 42.0 -13.5 L 43.1 -11.1 L 43.1 -9.3 L 41.7 -7.1 L 39.1 -5.4 L 34.6 -4.2 L 30.3 -3.9 L 25.9 -4.3 L 24.2 -4.3 L 23.7 -5.1 L 24.5 -5.8 L 25.8 -5.4 L 26.8 -1.7 L 29.4 7.4 L 31.2 10.0 L 33.2 11.0 L 34.6 10.9 L 35.8 10.2 L 37.2 7.2","0 30.6 M 19.7 11.0 L 17.0 9.9 L 15.2 8.2 L 13.4 5.4 L 12.7 2.7 L 12.4 .3 L 12.1 -1.1 L 11.1 -1.7 L 10.1 -1.5 L 9.1 -.3 L 8.6 .6 L 9.0 3.7 L 10.6 6.3 L 13.0 8.4 L 15.8 9.1 L 23.7 9.3 L 29.6 7.3 L 33.5 4.9 L 35.7 1.6 L 35.8 -.6 L 35.1 -2.0 L 33.6 -3.2 L 29.4 -4.1 L 24.3 -5.3 L 21.5 -7.1 L 20.8 -8.6 L 20.8 -10.4 L 22.6 -12.8 L 25.7 -14.7 L 30.2 -16.3 L 34.4 -16.4 L 38.4 -16.1 L 40.2 -15.2 L 41.1 -13.5 L 41.3 -11.7 L 40.7 -10.3 L 39.5 -9.4 L 36.8 -9.1","0 27.6 M 14.2 .4 L 14.6 1.7 L 16.4 2.3 L 19.9 .8 L 23.3 -1.9 L 24.9 -4.1 L 26.2 -6.7 L 26.3 -9.0 L 25.1 -10.1 L 22.3 -10.5 L 18.8 -8.9 L 15.1 -6.0 L 12.5 -2.6 L 11.0 1.4 L 10.1 5.6 L 11.1 9.4 L 12.9 10.7 L 15.4 11.3 L 19.0 10.1 L 21.8 8.0 L 25.3 4.0 L 29.0 -1.5 L 33.5 -8.0 L 36.1 -10.7 L 37.8 -12.1 L 39.1 -12.2 L 40.4 -12.0 M 50.1 -17.2 L 50.7 -15.5 L 50.0 -14.1 L 48.4 -13.4 L 46.4 -13.2 L 44.2 -13.5 L 41.1 -14.8 L 31.0 -19.2 L 28.2 -19.7 L 23.9 -20.0 L 18.7 -19.0 L 13.0 -15.6 L 10.6 -11.9 L 10.3 -7.9 L 10.9 -5.4 L 12.6 -3.9 L 15.3 -2.9 L 18.8 -2.6","0 33.2 M 20.1 .3 L 16.5 2.9 L 13.5 3.8 L 10.4 3.0 L 9.7 .4 L 10.7 -3.6 L 14.2 -8.1 L 18.7 -12.2 L 23.5 -15.6 L 27.5 -17.3 L 30.8 -18.1 L 34.2 -17.8 L 35.4 -16.9 L 35.3 -15.1 L 32.8 -11.2 L 24.7 .4 L 22.2 4.4 L 21.6 6.4 L 21.7 7.2 L 22.7 7.6 L 24.1 7.4 L 26.3 6.1 L 31.8 1.5 L 41.0 -8.2 L 45.3 -13.5 L 46.0 -13.6 L 46.4 -13.0 L 43.9 -10.0 L 37.7 -1.1 L 34.2 5.3 L 33.5 7.2 L 34.2 7.6 L 36.5 6.5 L 38.6 4.5","0 28.2 M 20.0 -3.2 L 20.0 -.9 L 18.6 1.1 L 16.1 2.6 L 14.2 2.9 L 11.0 1.6 L 8.7 -1.5 L 8.6 -5.6 L 10.3 -9.8 L 13.8 -14.3 L 18.2 -16.8 L 22.1 -18.1 L 26.3 -17.8 L 28.6 -16.7 L 30.1 -14.2 L 30.2 -10.9 L 28.9 -6.4 L 24.0 5.0 L 22.6 9.3 L 24.9 8.0 L 27.2 5.6 L 40.0 -9.4 L 44.6 -14.0 L 48.6 -17.1 L 52.2 -18.9 L 53.9 -19.3 L 56.0 -18.7","0 45.6 M 20.6 -1.7 L 17.8 .5 L 15.1 1.2 L 12.1 1.2 L 10.2 -.3 L 10.6 -3.3 L 13.2 -7.5 L 17.3 -11.4 L 21.9 -14.4 L 27.2 -16.8 L 30.5 -17.1 L 32.0 -16.7 L 32.9 -15.3 L 32.7 -13.5 L 30.7 -9.6 L 28.1 -5.3 L 17.6 9.6 L 17.2 11.2 L 18.4 10.7 L 22.3 6.1 L 28.5 -1.3 L 35.2 -7.4 L 39.9 -11.1 L 40.8 -11.4 L 41.3 -11.1 L 40.0 -9.8 L 37.0 -4.9 L 34.1 1.5 L 33.3 4.3 L 33.1 7.3 L 33.9 8.9 L 37.0 9.5 L 40.7 8.4 L 44.9 5.0 L 49.8 -.1 L 53.5 -6.3 L 55.0 -9.7 L 55.1 -12.1 L 54.9 -13.6 L 53.9 -15.5 L 52.9 -16.2 L 52.1 -15.5 L 52.2 -14.6 L 54.4 -13.6 L 55.9 -13.7 L 57.8 -14.4","0 27.8 M 6.4 -1.3 L 4.3 2.2 L 3.7 5.4 L 3.9 8.1 L 6.1 9.7 L 9.6 9.6 L 15.5 6.4 L 23.7 .6 L 41.0 -14.1 L 44.8 -17.0 L 47.1 -18.2 L 49.7 -18.4 M 19.8 -2.8 L 17.5 -1.6 L 14.9 -1.9 L 13.7 -3.3 L 13.5 -6.0 L 15.1 -9.8 L 17.3 -12.4 L 20.7 -15.4 L 24.0 -17.0 L 26.8 -17.4 L 29.4 -17.0 L 31.1 -14.7 L 31.6 -11.8 L 31.0 -7.4 L 28.3 4.2 L 27.8 6.2 L 28.0 7.7 L 29.1 8.3 L 30.8 7.4 L 35.8 2.5","0 36.0 M 21.5 -2.7 L 17.3 .3 L 13.4 .8 L 11.0 -.3 L 10.3 -4.7 L 12.5 -9.4 L 16.5 -13.0 L 21.5 -16.0 L 27.2 -18.0 L 30.7 -18.3 L 32.8 -17.2 L 33.3 -14.9 L 31.8 -12.2 L 23.3 -1.1 L 21.5 2.1 L 21.1 4.0 L 21.3 6.4 L 23.2 6.8 L 25.7 5.3 L 29.0 2.6 L 41.0 -9.2 L 43.2 -12.7 L 44.0 -13.4 L 44.8 -13.6 L 30.7 10.8 L 27.3 14.9 L 23.8 16.8 L 21.1 17.0 L 19.6 16.3 L 18.4 13.9","0 30.5 M 16.7 -10.2 L 17.0 -13.1 L 19.9 -15.0 L 25.2 -16.2 L 31.7 -15.7 L 35.9 -15.7 L 39.1 -14.9 L 42.8 -14.2 L 45.1 -14.3 L 45.1 -15.0 M 42.4 -16.3 L 25.3 -5.9 L 17.2 .0 L 9.5 7.0 L 8.9 7.4 L 7.3 7.6 L 7.1 6.6 L 11.7 7.2 L 16.9 6.5 L 25.2 5.9 L 29.4 6.3 L 33.0 7.1 L 34.2 8.0 L 34.5 9.6 L 33.8 11.0","0 24.2 M 30.5 -20.1 L 25.0 -19.9 L 21.1 -16.0 L 13.6 -3.4 L 11.4 2.6 L 10.6 6.2 L 11.5 7.3 L 18.0 7.7","0 23.6 M 10.7 -19.3 L 19.6 -8.5 L 26.7 1.6 L 30.0 6.3 L 31.0 9.1 L 31.6 10.7 L 31.3 11.7","0 23.0 M 22.6 -20.2 L 28.8 -20.0 L 30.0 -19.3 L 30.2 -18.3 L 27.9 -10.9 L 24.7 -4.2 L 20.9 1.9 L 17.3 6.5 L 15.7 7.4 L 10.4 7.5","0 15.9 M 12.0 -5.9 L 16.5 -9.5 L 21.3 -5.9","0 33.0 M 9.2 9.3 L 39.3 9.3","0 10.4 M 10.7 -7.6 L 14.7 -4.6","0 15.2 M 19.5 -2.7 L 19.6 -4.4 L 18.0 -5.4 L 14.6 -4.2 L 10.5 -1.2 L 8.2 1.9 L 7.4 4.0 L 7.6 5.8 L 8.6 7.2 L 10.5 6.8 L 12.8 5.0 L 15.4 2.4 L 20.4 -3.5 L 16.1 3.0 L 16.2 5.7 L 17.3 6.9 L 19.0 6.4 L 21.6 4.3 L 23.2 2.4","0 13.7 M 17.5 -10.3 L 9.5 -.9 L 7.5 3.5 L 7.6 6.1 L 9.2 7.1 L 11.9 5.8 L 14.6 2.8 L 15.9 .7 L 17.4 -1.9 L 17.6 -3.8 L 16.8 -4.2 L 15.8 -3.0 L 15.9 -.6 L 17.6 1.7 L 19.4 3.3 L 20.8 3.2 L 21.7 2.4","0 10.2 M 15.5 -1.2 L 16.5 -1.8 L 17.0 -3.0 L 16.7 -4.2 L 15.3 -4.4 L 12.8 -3.3 L 10.1 -.6 L 8.3 1.7 L 7.3 4.0 L 7.4 5.9 L 8.5 7.7 L 12.0 7.5 L 15.6 4.9 L 18.2 2.4","0 17.3 M 19.6 -4.0 L 17.5 -5.4 L 13.9 -3.9 L 11.3 -1.8 L 8.7 1.2 L 7.3 3.5 L 7.1 6.1 L 8.7 7.3 L 10.3 7.1 L 13.1 4.9 L 15.7 1.7 L 21.7 -6.5 L 25.0 -10.7 L 25.9 -10.8 L 23.9 -8.2 L 17.3 .2 L 16.4 2.1 L 16.1 4.4 L 16.6 6.6 L 18.1 7.1 L 20.1 6.7 L 22.3 5.2 L 24.6 3.2 L 25.3 2.4","0 10.1 M 8.6 2.2 L 10.8 2.6 L 14.7 .7 L 17.0 -1.4 L 17.6 -2.7 L 17.2 -4.0 L 15.4 -4.3 L 11.2 -1.9 L 8.3 1.5 L 7.2 4.4 L 7.8 6.9 L 10.5 7.6 L 14.4 5.7 L 18.1 2.4","0 11.5 M -.5 12.8 L 1.1 14.9 L 3.7 15.1 L 6.2 13.1 L 9.3 9.4 L 13.0 1.9 L 16.9 -6.8 L 19.8 -11.8 L 21.9 -13.0 L 23.2 -12.8 L 24.5 -11.9 M 11.4 -4.5 L 17.1 -4.2 L 21.7 -4.6","0 14.1 M 3.4 12.8 L 5.1 14.8 L 8.0 14.8 L 11.1 12.5 L 15.2 6.3 L 18.4 .6 L 20.8 -3.3 L 19.8 -3.1 L 14.6 3.3 L 11.6 5.9 L 9.6 7.2 L 7.7 6.1 L 7.2 4.2 L 8.5 1.1 L 11.5 -2.2 L 14.9 -4.6 L 17.1 -5.4 L 18.6 -5.6 L 19.6 -4.9 L 20.0 -3.8","0 13.6 M 17.3 -11.3 L 11.8 -4.2 L 5.4 6.9 L 9.5 2.0 L 13.3 -1.0 L 16.0 -2.9 L 18.9 -4.2 L 19.7 -4.0 L 17.3 -.6 L 15.4 2.3 L 14.7 4.1 L 14.7 5.7 L 15.4 6.5 L 16.6 6.9 L 21.6 2.4","0 8.0 M 12.3 -3.4 L 8.8 .7 L 6.9 4.7 L 6.9 6.9 L 8.9 7.8 L 12.9 5.6 L 16.0 2.4 M 14.8 -7.8 L 14.9 -6.7 L 15.9 -6.9 L 15.9 -7.5 L 14.8 -7.8","0 8.7 M 8.0 2.4 L 12.1 -2.5 L 13.5 -3.4 L 12.2 .4 L 7.9 8.2 L 4.8 12.2 L 3.0 14.2 L 1.2 15.2 L -.5 15.0 L -2.1 14.1 L -2.2 13.9 M 15.0 -7.8 L 15.0 -6.7 L 16.0 -6.7 L 16.3 -7.7 L 16.3 -7.7 L 16.3 -7.7 L 13.7 -8.0 L 12.4 -8.1 L 15.0 -7.8","0 14.2 M 18.0 -11.5 L 14.4 -7.4 L 10.9 -2.7 L 8.5 1.5 L 7.0 4.3 L 6.0 6.6 L 10.6 -1.7 L 14.4 -4.2 L 17.9 -5.7 L 20.7 -4.9 L 21.2 -2.9 L 20.7 -1.4 L 18.2 .2 L 16.4 1.1 L 12.5 1.3 L 9.9 1.1 L 11.0 4.1 L 12.7 6.6 L 14.1 7.5 L 16.5 7.1 L 18.4 5.9 L 22.2 2.4","0 8.6 M 17.2 -11.1 L 10.2 -1.7 L 7.3 3.6 L 7.1 5.9 L 8.7 7.2 L 11.8 6.9 L 14.8 4.3 L 16.6 2.4","0 24.7 M 8.0 2.4 L 10.9 -.4 L 13.8 -4.2 L 8.9 5.7 L 9.1 6.5 L 13.0 1.9 L 16.8 -1.6 L 19.9 -4.2 L 21.8 -4.7 L 21.4 -3.3 L 17.2 6.3 L 19.4 3.1 L 22.6 -.6 L 25.8 -2.6 L 28.3 -4.1 L 30.0 -4.4 L 26.2 .9 L 24.9 4.0 L 25.4 6.4 L 27.4 6.4 L 30.9 4.3 L 32.8 2.4","0 15.7 M 8.0 2.4 L 9.1 1.3 L 13.9 -4.2 L 10.6 1.6 L 9.0 4.9 L 9.0 6.7 L 10.6 5.2 L 14.3 .8 L 17.7 -2.3 L 20.3 -4.3 L 21.8 -4.6 L 22.4 -4.3 L 19.9 -1.2 L 17.3 2.8 L 16.6 5.6 L 17.4 7.0 L 19.2 6.9 L 22.1 4.3 L 23.6 2.4","0 10.8 M 16.7 -4.0 L 16.5 -.5 L 14.7 2.7 L 11.8 5.9 L 9.4 7.2 L 7.8 6.7 L 7.1 4.3 L 8.8 .7 L 10.8 -1.9 L 13.4 -4.1 L 15.4 -5.1 L 16.4 -4.6 L 15.4 -4.3 L 15.7 -2.7 L 17.1 -1.8 L 19.3 -2.8","0 13.6 M 11.2 -1.0 L 14.5 -3.3 L 17.2 -4.0 L 19.1 -3.7 L 20.3 -2.0 L 20.2 -.4 L 19.2 1.7 L 17.2 4.3 L 14.0 6.2 L 11.2 7.1 L 8.9 6.8 L 7.6 6.1 L 6.9 4.8 L 8.4 2.1 L 13.2 -3.7 L 6.6 4.0 L 3.8 9.0 L 3.0 11.2 L 3.1 13.0 L 3.9 14.5","0 13.0 M 19.4 -1.5 L 14.0 3.9 L 9.9 6.5 L 7.6 6.9 L 6.7 6.2 L 6.8 3.8 L 9.4 .8 L 12.6 -1.5 L 16.5 -3.0 L 18.0 -3.3 L 18.9 -3.2 L 19.0 -2.0 L 13.1 5.5 L 11.3 9.3 L 10.0 11.9 L 9.8 15.0 L 11.1 16.8 L 12.7 16.4 L 14.3 14.8 L 15.8 12.0 L 16.3 9.5 L 15.7 8.1 L 15.0 7.7 L 12.6 7.3","0 15.4 M 8.0 2.4 L 11.9 -2.2 L 14.2 -5.1 L 15.3 -6.7 L 15.6 -7.7 L 15.1 -7.9 L 14.1 -6.9 L 13.6 -5.7 L 13.8 -4.3 L 14.8 -3.2 L 16.6 -3.3 L 18.5 -4.2 L 15.2 -.3 L 13.8 2.9 L 13.5 5.4 L 14.3 7.0 L 16.2 7.2 L 19.4 6.0 L 21.7 4.1 L 23.4 2.4","0 13.7 M 8.0 2.4 L 12.2 -1.9 L 18.5 -7.7 L 19.1 -7.7 L 18.2 -6.5 L 17.4 -5.1 L 16.7 -.1 L 15.9 3.8 L 15.2 5.2 L 14.3 6.3 L 11.8 6.6 L 10.5 6.1 L 9.3 4.8 L 8.6 1.8 L 9.3 4.9 L 10.4 6.0 L 12.8 6.5 L 14.8 6.1 L 17.4 5.4 L 20.4 3.8 L 23.1 1.1","0 10.7 M 14.9 -8.1 L 9.3 -.4 L 7.6 3.3 L 7.2 6.0 L 8.4 7.3 L 10.8 7.3 L 13.3 6.3 L 16.1 4.9 L 18.7 2.4 M 8.6 -4.4 L 14.5 -4.5 L 20.6 -4.9","0 16.6 M 8.0 2.4 L 10.1 .6 L 13.5 -3.5 L 14.5 -4.1 L 11.1 .8 L 8.7 4.9 L 8.5 6.2 L 9.1 7.1 L 10.7 7.4 L 12.2 6.5 L 14.5 4.3 L 22.3 -4.1 L 22.9 -4.3 L 23.0 -3.5 L 17.5 3.1 L 16.9 5.4 L 17.3 6.8 L 18.9 7.3 L 20.5 6.3 L 23.5 3.6 L 24.6 2.4","0 11.0 M 10.6 -4.2 L 7.1 4.6 L 7.3 6.0 L 8.0 6.9 L 13.5 3.2 L 16.8 .2 L 18.8 -2.8 L 19.3 -4.6 L 19.1 -6.0 L 18.7 -6.8 L 17.3 -7.7","0 16.4 M 11.6 -4.3 L 8.3 1.5 L 6.7 6.1 L 6.9 6.6 L 9.1 4.5 L 12.3 .7 L 15.3 -2.7 L 17.1 -4.2 L 17.7 -3.9 L 14.8 .4 L 14.1 2.9 L 14.6 5.4 L 15.6 6.6 L 17.7 6.7 L 19.7 5.6 L 21.7 3.3 L 22.9 .7 L 23.4 -1.5 L 23.6 -3.2 L 22.9 -4.3","0 16.8 M 8.0 2.4 L 11.5 -1.9 L 14.1 -5.4 L 15.0 -6.3 L 15.9 -6.6 L 15.6 1.4 L 15.9 5.5 L 16.4 6.9 L 17.4 7.4 L 18.9 7.4 L 22.4 4.9 L 24.8 2.4 M 7.1 10.9 L 10.3 6.5 L 12.8 3.4 L 15.0 1.1 L 18.3 -2.1 L 23.6 -6.5 L 25.5 -8.0","0 13.8 M 13.0 -3.5 L 8.7 1.4 L 6.7 4.4 L 6.4 5.8 L 7.2 6.6 L 8.5 6.7 L 10.5 5.8 L 14.9 2.2 L 19.5 -1.3 L 21.1 -3.1 L 17.6 3.0 L 14.6 9.0 L 11.5 13.3 L 9.7 14.6 L 7.6 15.2 L 6.4 14.6 L 4.9 13.2","0 19.2 M 15.2 -1.3 L 14.5 -2.2 L 14.5 -3.8 L 16.9 -4.8 L 20.3 -4.1 L 23.1 -3.1 L 25.1 -2.5 L 25.4 -2.5 L 25.7 -3.3 L 24.7 -3.9 L 24.0 -3.8 L 22.6 -3.0 L 20.7 -1.6 L 15.6 3.8 L 14.3 5.4 L 13.2 6.1 L 11.8 6.5 L 10.7 5.8 L 10.7 4.7 L 11.1 3.7 L 12.5 3.5 L 15.1 5.8 L 17.2 7.2 L 20.2 7.7 L 22.8 7.3 L 24.6 6.3 L 25.1 5.1 L 25.1 3.8","0 14.1 M 21.9 -17.2 L 19.0 -16.5 L 17.2 -14.0 L 16.7 -10.8 L 16.1 -7.6 L 15.3 -5.2 L 13.9 -4.1 L 12.6 -3.4 L 10.1 -3.2 L 13.0 -2.1 L 14.2 -.9 L 14.1 .8 L 13.2 6.3 L 12.8 9.3 L 13.0 10.8 L 14.5 11.9 L 16.7 12.1","0 9.6 M 13.7 -16.3 L 14.0 -8.0 L 13.2 -.2 L 12.5 5.4 L 11.9 8.6 L 11.3 11.0","0 18.8 M 19.2 -17.0 L 21.5 -17.0 L 22.8 -16.2 L 22.9 -14.7 L 22.1 -11.4 L 20.7 -7.4 L 20.4 -5.5 L 20.8 -4.2 L 22.5 -2.9 L 24.5 -2.5 L 21.9 -2.1 L 19.2 .0 L 17.9 2.5 L 16.6 6.9 L 15.5 9.7 L 13.8 11.3 L 10.3 12.0","0 13.4 M 11.2 -8.9 L 12.8 -9.8 L 14.3 -9.6 L 15.8 -8.9 L 16.9 -8.7 L 18.1 -9.1 L 18.8 -9.7","0 12.5 M 14.5 -11.5 L 12.6 -10.9 L 11.6 -8.6 L 12.5 -6.3 L 14.5 -5.5 L 17.0 -6.4 L 17.8 -8.5 L 16.8 -10.9 L 14.5 -11.5"]
EMSCapitol = ["-8 8","0 11.5 M 14.4 -22.0 L 13.6 1.8 M 13.0 6.6 L 13.1 7.4 L 14.0 7.4 L 14.0 6.6 L 13.0 6.6","0 8.6 M 11.0 -21.8 L 10.5 -17.0 M 14.3 -22.3 L 13.6 -17.4","0 18.5 M 19.5 -13.7 L 14.6 2.2 M 23.4 -14.7 L 18.2 3.2 M 15.3 -9.2 L 24.7 -9.2 M 13.7 -3.6 L 23.4 -3.6","0 29.9 M 27.9 -21.6 L 27.6 -15.6 M 36.1 -11.0 L 35.9 -12.9 L 34.0 -14.6 L 32.1 -15.1 L 29.6 -15.5 L 25.7 -15.1 L 23.5 -14.5 L 21.1 -13.4 L 19.1 -11.8 L 18.6 -9.7 L 19.3 -8.0 L 20.9 -7.0 L 25.5 -6.0 L 29.6 -5.5 L 31.9 -5.0 L 33.5 -3.7 L 33.1 -2.2 L 31.9 -.6 L 28.7 .0 L 26.0 .1 L 23.1 -.4 L 21.5 -1.2 M 26.7 .2 L 26.7 6.6","0 28.3 M 17.8 -17.2 L 14.4 -15.8 L 13.1 -13.0 L 13.1 -10.6 L 14.8 -8.5 L 17.8 -7.4 L 20.5 -8.2 L 22.2 -10.5 L 22.5 -13.7 L 21.3 -15.6 L 19.9 -17.0 L 17.8 -17.2 M 29.7 -5.4 L 26.4 -4.0 L 25.0 -1.1 L 25.1 1.2 L 26.8 3.4 L 29.7 4.5 L 32.5 3.6 L 34.2 1.3 L 34.5 -1.8 L 33.2 -3.7 L 31.9 -5.1 L 29.7 -5.4 M 31.6 -16.7 L 15.8 4.5","0 33.1 M 24.8 -9.4 L 26.7 -8.3 L 29.1 -8.9 L 29.8 -11.1 L 28.8 -12.9 L 27.0 -13.8 L 24.1 -13.8 L 21.0 -13.2 L 18.4 -10.6 L 18.1 -8.0 L 18.7 -6.3 L 20.4 -5.3 L 22.9 -4.4 L 18.9 -4.1 L 16.3 -2.9 L 14.5 .0 L 14.6 3.7 L 16.6 5.9 L 20.4 6.9 L 25.3 6.2 L 28.3 4.2 L 30.3 2.2 L 30.6 .4 L 30.4 -2.0 M 26.2 -1.7 L 38.6 -2.5","0 5.4 M 11.1 -22.2 L 10.5 -17.4","0 15.2 M 22.3 -25.3 L 18.7 -22.3 L 15.1 -17.0 L 13.2 -12.9 L 12.1 -7.4 L 12.1 -2.0 L 13.4 2.3 L 15.6 7.7 L 19.2 11.5","0 15.1 M 11.5 -25.2 L 14.6 -22.5 L 16.4 -19.2 L 18.1 -14.6 L 18.6 -10.7 L 18.8 -7.7 L 18.3 -2.9 L 17.4 .9 L 15.4 4.6 L 13.1 7.6 L 9.2 11.4","0 12.0 M 13.9 -22.3 L 14.0 -18.6 L 17.5 -19.6 M 14.0 -18.6 L 16.3 -14.9 M 11.2 -15.5 L 14.0 -18.4 L 10.4 -20.2","0 15.9 M 16.3 -10.9 L 15.8 -.4 M 10.4 -5.3 L 21.6 -5.9","0 7.7 M 11.7 6.7 L 11.3 9.4 L 9.9 11.4","0 15.9 M 14.2 .4 L 20.8 .1","0 7.9 M 11.4 6.5 L 11.5 7.3 L 12.3 7.3 L 12.3 6.6 L 11.4 6.5","0 21.3 M 27.2 -22.1 L 9.9 7.3","0 33.2 M 24.4 -22.3 L 18.4 -20.8 L 13.5 -17.1 L 10.9 -11.9 L 9.9 -6.5 L 10.6 -1.7 L 13.7 3.3 L 16.7 5.8 L 20.9 7.8 L 26.0 8.1 L 32.1 5.8 L 37.2 .4 L 39.2 -5.1 L 38.8 -10.2 L 36.7 -15.4 L 34.3 -18.4 L 31.0 -20.4 L 27.6 -21.9 L 24.4 -22.3","0 14.3 M 10.0 -9.3 L 13.9 -12.5 L 16.6 -15.3 L 18.5 -17.6 L 19.5 -19.9 L 19.5 -21.7 L 18.7 -22.3 L 18.3 -21.2 L 18.3 7.3","0 34.1 M 13.6 -9.1 L 12.5 -11.6 L 12.5 -14.7 L 13.9 -18.4 L 16.9 -21.2 L 20.6 -22.8 L 26.2 -23.2 L 31.2 -21.5 L 34.6 -17.9 L 35.6 -13.9 L 35.3 -9.9 L 33.5 -5.2 L 31.3 -2.2 L 28.1 .8 L 26.1 2.2 L 20.1 5.5 L 15.6 6.8 L 11.2 7.0 L 9.4 6.2 L 8.8 4.4 L 10.0 2.5 L 13.1 2.3 L 17.1 3.1 L 25.1 5.3 L 30.7 7.0 L 36.2 7.1 L 40.3 6.3 L 42.6 5.0 L 44.4 3.3","0 26.0 M 10.7 -16.4 L 13.5 -19.3 L 17.1 -21.4 L 21.0 -22.3 L 24.6 -22.0 L 28.0 -20.5 L 29.6 -18.1 L 30.1 -15.6 L 28.9 -12.2 L 26.3 -9.8 L 22.8 -7.8 L 19.5 -7.1 L 16.9 -7.1 L 15.5 -7.4 L 15.1 -8.2 L 17.2 -9.0 L 19.6 -8.9 L 21.3 -8.5 L 24.4 -8.1 L 28.7 -6.2 L 31.5 -3.2 L 32.1 .6 L 30.8 4.6 L 27.8 7.0 L 23.6 8.5 L 18.7 8.8 L 13.5 7.4 L 9.6 4.8","0 34.7 M 32.2 7.8 L 32.5 -19.5 L 32.9 -22.3 L 33.5 -23.5 L 34.4 -23.7 L 35.0 -22.7 L 34.5 -21.5 L 31.0 -17.9 L 26.5 -13.4 L 22.9 -10.4 L 18.1 -6.4 L 13.9 -3.6 L 9.7 -1.0 L 21.6 -1.7 L 31.5 -2.0 L 41.3 -1.7","0 27.9 M 31.0 -22.2 L 23.3 -21.4 L 12.5 -21.5 L 12.1 -7.4 L 16.0 -8.8 L 21.6 -9.3 L 26.3 -8.7 L 30.2 -6.9 L 33.2 -4.0 L 33.6 .8 L 32.6 4.0 L 29.9 6.7 L 25.4 8.5 L 21.2 9.3 L 16.0 8.9 L 13.2 8.3 L 10.4 7.3 L 8.6 6.0","0 31.3 M 29.4 -23.6 L 23.6 -22.6 L 19.8 -21.2 L 15.8 -17.9 L 13.1 -14.2 L 10.9 -9.5 L 10.2 -4.4 L 11.0 -.1 L 13.4 3.4 L 17.5 6.4 L 21.4 7.6 L 26.2 7.6 L 30.7 6.4 L 33.9 4.5 L 36.7 .6 L 37.3 -3.6 L 36.7 -6.4 L 34.3 -9.3 L 31.1 -11.1 L 26.9 -11.7 L 21.8 -10.7 L 18.4 -9.0 L 15.9 -6.7 L 14.6 -3.3","0 27.9 M 8.9 -21.4 L 15.8 -20.3 L 21.9 -20.1 L 26.6 -20.1 L 30.4 -20.2 L 35.0 -21.4 L 29.0 -15.4 L 23.7 -9.0 L 20.2 -4.1 L 16.6 1.5 L 13.8 7.3","0 28.3 M 21.7 -23.3 L 17.6 -22.4 L 14.5 -20.4 L 13.2 -17.7 L 13.0 -15.1 L 15.3 -12.2 L 18.0 -10.7 L 25.6 -8.1 L 29.3 -6.7 L 32.3 -4.8 L 34.1 -2.0 L 34.1 2.7 L 31.8 5.5 L 28.3 7.1 L 24.5 7.9 L 20.7 8.3 L 15.2 7.5 L 11.6 5.3 L 9.9 2.3 L 10.2 -1.5 L 11.9 -4.1 L 15.3 -6.2 L 25.6 -10.9 L 29.4 -13.0 L 31.3 -15.8 L 31.3 -18.3 L 30.1 -20.7 L 26.9 -22.8 L 24.5 -23.4 L 21.7 -23.3","0 31.2 M 33.1 -11.7 L 30.2 -6.7 L 27.0 -4.6 L 22.8 -3.3 L 17.0 -3.7 L 13.1 -5.7 L 10.9 -8.4 L 10.1 -13.4 L 12.7 -18.8 L 17.4 -21.6 L 23.9 -22.7 L 29.4 -21.6 L 34.3 -18.0 L 37.1 -13.1 L 36.7 -8.0 L 35.7 -3.3 L 32.7 1.6 L 28.8 5.1 L 25.4 7.3 L 23.0 8.1 L 18.4 8.8","0 9.7 M 12.4 6.4 L 12.5 7.1 L 13.4 7.1 L 13.4 6.4 L 12.4 6.4 M 12.4 -2.0 L 12.4 -1.2 L 13.3 -1.2 L 13.3 -2.0 L 12.4 -2.0","0 10.0 M 12.9 6.5 L 12.8 8.5 L 12.2 10.0 L 11.0 11.6 M 12.5 -2.1 L 12.5 -1.3 L 13.4 -1.3 L 13.4 -2.0 L 12.5 -2.1","0 16.0 M 21.2 -13.5 L 19.0 -10.9 L 16.2 -9.0 L 14.2 -7.4 L 11.2 -5.5 L 14.5 -3.3 L 18.2 -.7 L 21.1 1.1","0 15.8 M 10.4 -7.9 L 21.0 -8.2 M 10.3 -2.8 L 21.0 -3.0","0 15.8 M 10.5 -13.5 L 14.1 -10.0 L 17.4 -7.4 L 20.8 -5.5 L 17.3 -3.2 L 14.2 -1.2 L 10.7 1.0","0 33.7 M 21.3 -9.5 L 18.7 -8.5 L 16.2 -8.4 L 13.1 -9.5 L 10.6 -11.9 L 9.9 -15.5 L 11.0 -18.8 L 14.3 -21.5 L 19.4 -23.0 L 24.9 -23.3 L 30.4 -22.3 L 35.6 -20.2 L 38.7 -16.9 L 39.6 -13.3 L 39.0 -9.9 L 37.7 -7.8 L 34.9 -6.2 L 28.2 -3.2 L 25.5 -1.5 L 23.8 -.3 L 22.7 .7 L 22.5 1.8 M 21.5 6.6 L 21.6 7.4 L 22.4 7.4 L 22.4 6.6 L 21.5 6.6","0 29.1 M 27.4 -4.8 L 25.7 -5.7 L 23.3 -5.5 L 21.1 -4.1 L 19.4 -1.1 L 19.4 1.7 L 20.6 3.0 L 23.1 3.6 L 25.2 1.5 L 25.9 -.1 L 26.3 -1.6 L 26.6 1.3 L 27.8 3.0 L 29.7 3.5 L 31.9 2.9 L 33.7 -.1 L 34.3 -3.9 L 33.4 -7.1 L 31.0 -9.7 L 28.7 -10.9 L 25.5 -11.7 L 20.9 -11.3 L 16.9 -9.4 L 13.8 -4.8 L 12.8 -.8 L 13.2 2.9 L 14.8 5.9 L 17.9 8.3 L 21.4 9.7 L 25.0 9.4","0 45.8 M 6.7 4.9 L 11.5 7.3 L 17.3 7.7 L 22.9 6.0 L 27.8 3.3 L 32.9 -1.6 L 39.4 -9.0 L 48.0 -22.8 L 47.2 -19.9 L 46.9 -12.0 L 47.1 -.6 L 47.6 3.7 L 48.7 7.5 M 15.1 -11.6 L 13.3 -9.4 L 13.1 -6.0 L 16.1 -3.2 L 23.1 -2.0 L 31.9 -2.2 L 53.9 -4.8","0 50.0 M 46.4 -24.0 L 44.2 -21.4 L 41.4 -17.2 L 38.7 -10.3 L 36.3 -3.8 L 33.9 .1 L 29.7 4.2 L 25.3 6.7 L 20.4 7.4 L 15.4 6.6 L 11.8 4.1 L 9.9 -.4 L 11.2 -6.8 L 15.5 -13.0 L 20.9 -17.6 L 26.2 -20.1 L 31.1 -21.7 L 38.6 -22.7 L 44.4 -22.3 L 49.4 -20.6 L 51.9 -18.7 L 53.1 -16.7 L 53.1 -13.5 L 52.0 -10.4 L 49.3 -8.7 L 44.4 -6.9 L 41.8 -6.4 L 39.1 -6.2 L 37.2 -6.2 L 36.1 -6.7 L 36.3 -7.6 L 39.4 -7.7 L 42.8 -7.6 L 46.0 -7.1 L 49.9 -5.7 L 53.8 -2.7 L 54.7 .3 L 53.7 3.8 L 49.8 6.6 L 45.7 7.4 L 40.5 7.4 L 34.9 6.0","0 36.7 M 25.7 -15.1 L 24.3 -13.3 L 23.9 -10.7 L 24.7 -7.6 L 28.2 -6.0 L 32.3 -6.0 L 36.6 -7.5 L 39.3 -10.1 L 41.0 -13.7 L 40.1 -17.7 L 36.6 -20.6 L 32.2 -22.3 L 26.9 -22.3 L 20.7 -21.1 L 16.4 -18.5 L 12.4 -14.3 L 10.2 -9.2 L 9.9 -3.8 L 11.8 .9 L 14.8 3.9 L 19.3 6.4 L 24.9 7.8 L 31.0 7.2 L 36.5 5.0 L 39.5 2.9 L 42.5 -.8","0 44.3 M 17.4 -6.4 L 15.2 -7.2 L 12.5 -9.9 L 11.6 -13.1 L 12.2 -16.5 L 15.5 -20.3 L 19.6 -21.9 L 25.2 -22.8 L 31.0 -22.6 L 35.9 -21.7 L 40.7 -19.8 L 44.7 -17.2 L 48.2 -12.9 L 50.0 -7.8 L 49.3 -.8 L 45.5 4.3 L 40.4 6.9 L 36.3 7.5 L 30.6 6.7 L 26.5 4.8 L 19.7 1.3 L 15.9 .2 L 12.3 .7 L 10.1 2.7 L 9.8 4.4 L 11.8 6.2 L 15.1 7.3 L 18.1 6.6 L 21.9 4.9 L 24.5 2.5 L 26.6 -1.7 L 27.4 -7.6 L 28.2 -11.7 L 29.6 -14.9 L 30.7 -16.6 L 32.4 -17.5","0 35.8 M 36.1 -17.4 L 33.8 -20.4 L 31.4 -21.8 L 27.7 -23.0 L 22.8 -22.9 L 19.3 -21.9 L 15.5 -19.2 L 14.5 -15.7 L 15.4 -12.1 L 17.7 -9.7 L 21.3 -8.4 L 24.7 -8.1 L 27.3 -8.2 L 28.7 -8.9 L 28.8 -10.0 L 28.1 -10.8 L 25.4 -11.0 L 22.3 -10.8 L 19.1 -10.5 L 15.4 -9.2 L 11.6 -5.9 L 10.4 -3.5 L 10.4 -1.2 L 11.1 2.7 L 14.1 5.4 L 18.8 7.5 L 23.0 7.7 L 29.6 7.4 L 35.2 5.3 L 38.3 3.1 L 40.1 1.4 L 41.9 -1.7","0 47.0 M 11.8 -9.4 L 10.0 -10.9 L 9.0 -14.3 L 9.7 -18.1 L 13.5 -20.8 L 18.1 -21.5 L 22.9 -21.2 L 28.1 -20.5 L 38.6 -18.1 L 43.5 -17.2 L 48.8 -16.4 L 53.4 -16.5 L 57.2 -17.0 L 59.8 -18.7 L 60.5 -20.9 L 59.7 -22.5 L 56.3 -23.2 L 52.9 -22.8 L 49.8 -21.0 L 47.7 -19.1 L 46.9 -17.9 L 45.8 -14.4 L 45.4 -10.2 L 45.5 -6.4 L 44.9 -1.4 L 43.1 2.7 L 39.5 5.9 L 33.7 7.5 L 28.2 7.4 L 22.9 5.7 L 19.9 3.5 L 18.5 1.5 L 17.1 -1.0 M 34.4 -6.8 L 42.7 -7.6 L 47.0 -7.4 L 51.0 -7.5 L 53.8 -7.5","0 37.6 M 43.9 -12.8 L 43.0 -16.6 L 41.0 -19.8 L 37.9 -21.9 L 32.0 -23.1 L 26.0 -22.3 L 21.6 -20.1 L 15.8 -15.6 L 13.3 -12.3 L 11.0 -7.4 L 10.5 -2.4 L 11.0 1.7 L 12.9 4.6 L 15.4 6.5 L 21.4 7.5 L 27.1 5.7 L 30.9 3.3 L 34.3 .2 L 38.0 -4.6 L 39.6 -6.9 L 40.6 -8.9 L 41.2 -10.7 L 40.5 -11.8 L 39.5 -10.8 L 39.1 -8.6 L 39.4 -2.9 L 39.9 1.8 L 40.8 8.1 L 40.0 14.9 L 38.6 19.8 L 36.2 22.3 L 33.7 23.1 L 30.5 22.1 L 28.6 19.5 L 29.3 15.4 L 32.1 10.9 L 34.6 8.3 L 38.4 5.5 L 42.9 3.2","0 51.2 M 11.5 -9.9 L 9.7 -11.3 L 8.6 -13.7 L 9.0 -16.1 L 10.9 -18.9 L 14.3 -20.5 L 17.8 -20.7 L 22.3 -19.9 L 29.3 -18.7 L 32.0 -18.4 L 35.2 -19.3 L 37.8 -20.5 L 38.9 -22.3 L 39.3 -23.4 L 39.0 -24.1 L 37.9 -24.2 L 36.4 -22.8 L 35.5 -21.1 L 34.6 -17.7 L 34.2 -11.2 L 34.0 -5.9 L 31.9 2.0 L 27.1 6.4 L 20.1 7.6 L 14.8 6.2 L 12.4 4.8 L 10.3 2.5 M 60.8 -21.0 L 59.3 -21.5 L 56.9 -20.8 L 54.4 -17.6 L 53.4 -13.5 L 52.6 -7.1 L 52.5 -2.8 L 53.1 1.1 L 53.6 3.9 L 55.3 7.9 M 28.5 -6.6 L 35.8 -6.9 L 43.8 -7.2 L 53.4 -7.2 L 58.6 -7.0","0 27.4 M 26.3 -6.6 L 24.0 -7.1 L 22.5 -8.6 L 21.5 -10.2 L 21.5 -12.3 L 22.3 -14.0 L 23.8 -15.6 L 28.7 -17.9 L 32.1 -19.7 L 33.7 -20.7 L 35.2 -22.5 L 35.4 -24.0 L 34.9 -24.7 L 33.7 -24.4 L 33.3 -23.4 L 32.8 -21.2 L 32.1 -17.0 L 31.9 -7.0 L 30.6 -.2 L 28.6 4.3 L 25.3 6.5 L 20.7 8.0 L 16.2 8.1 L 11.9 6.3 L 9.5 3.9 L 8.9 .6 L 10.1 -2.9 L 12.1 -4.6 L 14.7 -5.7 L 17.7 -5.8","0 24.5 M 18.1 -3.6 L 16.1 -3.9 L 13.5 -4.8 L 11.7 -6.6 L 11.1 -8.8 L 11.3 -11.8 L 12.5 -13.9 L 15.0 -15.7 L 20.6 -17.5 L 25.4 -19.1 L 28.6 -20.7 L 31.4 -22.9 L 32.6 -24.1 L 32.6 -25.4 L 32.3 -25.8 L 31.0 -25.6 L 29.9 -24.2 L 29.4 -23.0 L 27.9 -17.6 L 27.4 -14.5 L 27.2 -9.5 L 27.6 -3.1 L 27.6 2.0 L 27.5 7.0 L 26.5 11.8 L 25.1 16.2 L 23.2 19.3 L 21.2 20.9 L 17.7 21.6 L 14.8 20.8 L 12.7 18.4 L 11.8 13.5 L 13.7 8.3 L 19.0 2.9 L 23.7 -.2 L 29.5 -2.8","0 50.0 M 14.9 -9.9 L 13.3 -10.4 L 11.6 -12.4 L 11.2 -15.2 L 12.4 -18.3 L 15.6 -20.7 L 18.9 -20.9 L 23.6 -20.7 L 28.0 -20.3 L 31.6 -20.3 L 33.9 -21.0 L 34.9 -22.3 L 35.0 -23.0 L 33.9 -23.3 L 32.7 -23.2 L 31.4 -22.4 L 30.1 -20.7 L 28.7 -18.7 L 27.8 -15.3 L 27.6 -10.1 L 27.3 -4.6 L 26.4 .6 L 25.0 3.6 L 22.4 6.2 L 20.2 7.1 L 17.3 7.4 L 13.5 7.1 L 10.9 6.3 L 8.9 4.7 M 54.5 -23.7 L 51.6 -23.1 L 48.4 -20.5 L 45.9 -16.9 L 43.5 -13.7 L 40.9 -10.4 L 39.0 -8.8 L 36.1 -7.1 L 34.1 -6.6 L 30.8 -5.9 L 28.3 -6.0 L 26.8 -6.4 L 26.4 -7.4 L 29.2 -8.2 L 32.8 -7.4 L 36.0 -5.5 L 39.0 -2.3 L 42.2 .8 L 44.6 3.6 L 47.4 6.1 L 50.4 7.4 L 52.8 6.9 L 55.0 5.7 L 56.3 4.3","0 38.9 M 37.3 -13.9 L 38.6 -15.6 L 39.1 -18.6 L 38.4 -20.7 L 36.3 -22.3 L 33.4 -23.1 L 29.3 -22.2 L 26.7 -20.2 L 25.0 -16.0 L 24.6 -10.0 L 24.6 -3.6 L 24.4 -.3 L 22.7 3.1 L 21.3 4.8 L 18.2 6.4 L 13.8 7.4 L 9.2 6.7 L 7.2 4.4 L 8.0 1.2 L 11.1 -1.3 L 15.1 -1.4 L 19.1 -.6 L 23.7 1.4 L 28.6 4.1 L 33.0 6.4 L 37.9 7.1 L 42.1 6.4 L 43.7 5.2 L 45.4 3.7","0 57.5 M 24.2 -5.4 L 21.5 -7.5 L 18.3 -8.0 L 14.4 -7.6 L 10.6 -5.0 L 9.2 -1.4 L 10.0 2.2 L 12.2 4.9 L 16.5 7.0 L 21.4 7.4 L 26.0 6.2 L 29.7 4.1 L 33.2 -.6 L 36.2 -5.8 L 38.3 -10.9 L 40.0 -16.5 M 40.1 -16.5 L 40.7 -19.9 L 40.4 -22.1 L 39.5 -22.6 L 38.7 -21.4 L 39.2 -17.6 L 41.8 -5.8 L 44.6 6.0 L 47.1 .2 L 51.2 -9.1 L 56.1 -17.8 L 59.0 -22.0 L 60.7 -24.2 L 59.3 -20.4 L 57.5 -13.9 L 57.1 -9.2 L 57.0 -4.5 L 57.3 .1 L 58.8 3.9 L 60.9 6.0 L 62.3 6.8 L 64.1 7.1","0 48.7 M 25.8 -4.1 L 22.9 -7.0 L 19.2 -8.1 L 14.8 -7.5 L 11.5 -5.5 L 9.7 -2.7 L 9.3 .1 L 11.0 4.3 L 15.5 6.6 L 22.1 7.0 L 27.2 5.3 L 31.8 1.9 L 33.9 -.1 L 36.9 -5.8 L 38.4 -12.0 L 39.6 -17.1 L 39.7 -22.1 L 50.0 6.8 L 50.8 .7 L 51.7 -6.4 L 52.9 -13.0 L 54.7 -18.6 L 57.1 -22.3 L 59.5 -23.9 L 60.9 -24.4 L 63.4 -24.5","0 33.6 M 18.7 -20.6 L 14.9 -17.7 L 12.0 -13.9 L 10.3 -9.3 L 10.1 -4.6 L 11.5 .8 L 13.8 3.9 L 16.8 6.1 L 21.8 7.4 L 27.6 6.9 L 31.8 5.1 L 35.4 1.5 L 37.7 -3.2 L 38.4 -6.7 L 38.8 -10.2 L 38.7 -13.8 L 36.4 -19.4 L 33.2 -21.7 L 28.1 -23.0 L 24.7 -22.0 L 21.8 -19.3 L 20.8 -15.1 L 21.8 -11.7 L 24.8 -8.7 L 29.7 -6.9 L 33.8 -7.1 L 37.4 -8.0 L 40.6 -9.9 L 42.8 -11.9","0 40.4 M 24.9 -5.7 L 22.5 -4.0 L 17.7 -3.4 L 13.9 -4.4 L 11.7 -6.4 L 10.6 -10.4 L 11.8 -14.6 L 14.5 -18.3 L 17.9 -20.5 L 23.5 -22.6 L 29.2 -23.5 L 35.6 -23.7 L 42.2 -21.9 L 45.4 -19.1 L 46.7 -15.3 L 46.9 -12.0 L 46.2 -9.2 L 44.5 -6.9 L 42.5 -5.3 L 40.4 -4.3 L 36.8 -3.5 L 34.4 -3.4 M 35.1 -17.6 L 33.4 -15.8 L 31.9 -13.9 L 31.3 -10.8 L 31.0 -6.8 L 31.0 -2.8 L 30.8 .7 L 29.1 4.5 L 27.1 6.7 L 24.6 7.6 L 22.3 7.8 L 19.7 7.5 L 17.1 6.0 L 14.5 3.7","0 36.4 M 20.0 2.0 L 17.1 .5 L 13.8 -2.7 L 12.0 -6.9 L 11.8 -11.6 L 13.8 -16.7 L 17.6 -20.2 L 20.8 -22.1 L 25.6 -23.1 L 31.2 -22.9 L 36.8 -20.3 L 39.4 -17.3 L 41.2 -13.2 L 41.3 -7.6 L 39.5 -2.9 L 37.1 -.1 L 33.2 2.8 L 28.3 5.4 L 24.1 6.4 L 20.6 6.9 L 15.3 6.7 L 12.0 5.5 L 10.9 4.1 L 11.2 1.8 L 13.5 .1 L 15.3 -.3 L 18.6 -.5 L 23.7 .5 L 28.2 2.5 L 34.7 6.5 L 39.4 9.7 L 43.1 10.9 L 47.3 11.1 L 50.9 10.1","0 43.7 M 24.7 -5.7 L 23.3 -4.5 L 20.9 -3.7 L 18.3 -3.4 L 15.7 -3.6 L 13.9 -4.4 L 11.2 -7.2 L 10.8 -11.1 L 12.0 -15.1 L 14.0 -17.7 L 20.0 -21.5 L 24.9 -22.9 L 29.4 -23.7 L 33.9 -23.8 L 38.6 -23.0 L 42.2 -21.9 L 44.2 -20.3 L 45.7 -18.1 L 46.4 -15.6 L 46.1 -13.5 L 45.0 -11.0 L 43.8 -9.3 L 41.7 -7.6 L 37.4 -6.2 L 35.2 -5.5 L 32.5 -5.3 L 30.4 -5.6 L 29.4 -6.2 L 29.5 -7.4 L 32.0 -7.9 L 34.4 -8.3 L 37.9 -7.2 L 40.4 -5.7 L 42.1 -3.2 L 43.2 1.3 L 43.3 4.3 L 43.9 6.9 L 46.2 8.0 L 49.1 7.3 L 50.9 5.4 L 52.4 3.5 L 53.3 1.1 M 35.0 -17.7 L 32.8 -15.4 L 31.6 -12.0 L 30.9 -8.5 L 31.1 -2.7 L 30.7 .5 L 30.0 2.9 L 27.8 6.1 L 25.5 7.4 L 22.7 7.9 L 19.9 7.6 L 17.3 6.4 L 15.9 5.4 L 14.5 3.7","0 35.4 M 45.7 -14.8 L 45.6 -17.8 L 43.5 -20.7 L 37.9 -22.9 L 33.0 -23.5 L 26.2 -23.3 L 20.4 -22.1 L 15.7 -19.8 L 13.5 -18.0 L 11.5 -15.2 L 10.8 -13.0 L 11.2 -10.9 L 12.2 -8.8 L 15.2 -6.8 L 17.8 -5.8 L 23.9 -4.8 L 35.7 -3.6 L 38.1 -2.8 L 39.9 -1.5 L 40.5 .8 L 40.0 3.2 L 38.1 5.3 L 35.6 6.5 L 31.3 7.4 L 27.4 7.5 L 22.9 6.9 L 19.4 6.1 L 17.1 4.9","0 37.9 M 44.9 -21.3 L 43.0 -19.9 L 40.6 -16.2 L 39.5 -11.8 L 39.2 -2.2 L 38.7 .8 L 37.0 4.3 L 34.1 7.1 L 31.6 7.9 L 28.1 7.9 L 24.8 6.8 L 22.2 5.1 L 20.3 2.7 M 24.6 -14.6 L 23.3 -11.7 L 20.8 -9.6 L 17.5 -8.5 L 13.9 -8.8 L 10.5 -11.1 L 9.5 -14.5 L 10.3 -18.9 L 13.1 -22.0 L 16.4 -23.6 L 22.1 -23.7 L 27.8 -22.3 L 36.5 -19.8 L 41.4 -18.4 L 46.3 -17.8 L 51.0 -18.6 L 54.1 -19.8 L 55.8 -21.4","0 42.8 M 14.5 -7.6 L 12.1 -8.6 L 10.4 -10.8 L 9.9 -14.9 L 12.2 -19.5 L 16.4 -21.9 L 20.1 -22.3 L 22.7 -22.1 L 25.3 -20.2 L 26.3 -17.9 L 26.6 -14.8 L 26.0 -11.1 L 25.2 -6.6 L 24.3 -3.3 L 23.9 .8 L 24.0 4.1 L 25.3 6.2 L 27.2 7.8 L 29.5 8.1 L 31.6 7.6 L 34.6 5.7 L 37.0 2.4 L 38.7 -.6 L 40.7 -4.8 L 42.3 -10.4 L 43.6 -15.8 L 44.7 -21.2 L 42.7 -6.0 L 42.1 -1.6 L 42.0 2.2 L 42.5 5.7 L 44.2 7.6 L 45.9 8.2 L 48.2 7.5 L 50.0 5.8 L 51.6 3.2 L 52.2 1.1","0 44.7 M 22.6 -8.6 L 20.1 -7.1 L 16.4 -6.6 L 12.9 -8.3 L 10.9 -10.8 L 10.7 -14.9 L 12.2 -18.4 L 16.0 -21.3 L 19.6 -22.1 L 24.9 -21.8 L 29.0 -20.2 L 31.8 -17.2 L 33.6 -13.7 L 34.9 -9.5 L 35.3 -5.3 L 35.4 .0 L 35.7 4.1 L 35.4 8.0 L 40.4 3.9 L 45.7 -2.0 L 49.1 -6.8 L 51.4 -11.5 L 52.7 -15.7 L 52.9 -19.8 L 52.4 -23.5 L 50.8 -26.3 L 49.4 -27.7 L 48.2 -28.2 L 46.3 -28.2","0 60.4 M 23.5 -5.3 L 21.1 -4.1 L 17.6 -3.4 L 14.6 -4.3 L 12.2 -6.2 L 10.4 -10.2 L 11.0 -14.6 L 13.0 -17.9 L 16.5 -20.3 L 22.1 -20.9 L 26.7 -18.8 L 29.5 -15.3 L 30.9 -9.7 L 31.7 -3.4 L 31.7 1.1 L 31.6 8.0 L 47.2 -20.9 L 46.1 -13.1 L 45.6 -6.0 L 45.9 .1 L 47.0 3.9 L 48.5 6.2 L 51.1 7.4 L 54.1 7.6 L 57.4 6.0 L 60.2 2.9 L 63.0 -2.1 L 65.0 -7.6 L 66.5 -13.4 L 66.8 -18.7 L 65.6 -23.0 L 63.6 -25.8","0 42.5 M 21.1 -9.3 L 19.4 -7.9 L 17.4 -7.0 L 14.8 -6.9 L 12.4 -7.9 L 10.8 -10.2 L 10.4 -13.6 L 11.5 -17.4 L 14.4 -20.8 L 17.6 -22.3 L 20.8 -23.0 L 25.2 -22.4 L 29.5 -20.0 L 33.0 -14.4 L 36.7 -5.6 L 40.1 2.0 L 42.8 5.1 L 44.9 6.4 L 46.7 6.9 L 48.6 7.3 M 51.3 -24.3 L 46.8 -18.6 L 41.6 -12.3 L 37.4 -7.8 L 33.5 -4.2 L 26.9 1.8 L 19.2 8.1","0 44.0 M 16.6 -2.6 L 12.9 -4.3 L 11.0 -7.8 L 10.3 -13.1 L 12.2 -17.8 L 15.7 -21.4 L 19.2 -22.6 L 23.9 -22.0 L 26.6 -20.5 L 28.6 -16.0 L 28.1 -10.4 L 26.3 -2.4 L 25.8 2.7 L 26.9 5.5 L 29.3 7.8 L 32.5 8.0 L 34.9 7.3 L 37.6 4.8 L 39.7 1.4 L 42.4 -3.3 L 43.8 -8.0 L 46.4 -17.7 L 44.4 -2.3 L 44.6 5.3 L 44.7 12.3 L 44.8 16.5 L 44.2 19.3 L 43.1 21.8 L 41.0 24.0 L 39.2 24.4 L 36.0 23.3 L 34.4 19.2 L 36.5 14.3 L 39.0 11.4 L 41.5 9.7 L 44.7 8.4 L 46.6 7.3 L 51.0 6.2","0 39.3 M 22.3 -11.5 L 20.0 -9.8 L 17.0 -9.4 L 13.9 -9.7 L 11.3 -11.5 L 10.2 -13.2 L 9.9 -16.2 L 11.2 -19.6 L 12.8 -21.3 L 15.1 -22.5 L 20.2 -23.2 L 24.6 -22.6 L 30.5 -21.5 L 35.6 -20.6 L 41.9 -19.8 L 44.7 -19.4 L 46.4 -19.6 L 14.5 6.9 L 14.7 7.7 L 20.1 6.5 L 26.8 6.0 L 32.5 6.0 L 39.3 6.2 L 45.7 7.1","0 15.0 M 20.9 -26.6 L 20.1 -26.1 L 17.6 -25.8 L 13.9 -25.5 L 13.7 -19.3 L 13.4 -8.7 L 13.1 -.8 L 12.8 5.7 L 12.9 11.9 L 13.2 11.9 L 14.7 11.4 L 16.4 11.1 L 18.0 11.1","0 21.3 M 9.9 -22.1 L 27.2 7.5","0 14.9 M 12.6 -25.5 L 15.1 -25.6 L 17.9 -26.3 L 17.7 -19.8 L 16.8 11.1 L 14.4 11.1 L 12.1 11.4 L 10.0 12.0","0 13.1 M 10.9 -17.4 L 14.5 -22.2 L 18.3 -17.2","0 12.9 M 8.7 11.0 L 20.2 11.1","0 10.6 M 11.7 -8.9 L 15.2 -5.7","0 14.8 M 16.7 -1.2 L 15.6 -1.9 L 12.8 -2.0 L 10.0 .3 L 8.9 3.4 L 10.0 6.6 L 11.5 7.1 L 12.7 6.8 L 14.5 5.5 L 15.3 3.7 L 15.7 2.3 L 16.3 5.5 L 18.2 7.1 L 19.9 6.9 L 21.7 5.5 L 23.2 3.6 L 24.2 1.4","0 16.3 M 10.1 1.5 L 12.0 -3.6 L 13.9 -8.5 L 15.2 -14.6 L 15.2 -18.9 L 14.3 -22.1 L 13.6 -22.6 L 12.6 -22.8 L 11.3 -21.9 L 10.1 -19.0 L 9.5 -14.7 L 9.4 -9.9 L 9.5 -4.3 L 9.9 1.0 L 10.7 4.6 L 11.6 6.5 L 13.5 7.8 L 16.1 6.9 L 17.5 5.5 L 18.2 3.3 L 18.2 .6 L 16.8 -1.6 L 16.0 -2.0 L 14.2 -2.1 L 13.6 -.8 L 13.8 1.0 L 14.6 1.9 M 18.1 3.7 L 20.6 5.4 L 22.9 5.5 L 24.3 4.1 L 25.9 1.5","0 12.5 M 15.1 .8 L 15.6 -.2 L 15.1 -2.0 L 13.7 -2.8 L 12.1 -2.4 L 9.9 .4 L 9.6 4.1 L 10.8 6.7 L 13.8 7.8 L 16.6 7.2 L 19.1 5.2 L 20.9 3.1 L 21.6 1.5","0 15.9 M 14.1 -2.2 L 11.3 -1.0 L 9.3 2.7 L 9.4 5.1 L 11.2 6.9 L 13.4 6.5 L 15.0 3.9 L 17.6 -2.0 L 19.5 -8.3 L 20.4 -13.0 L 20.3 -18.6 L 19.8 -19.6 L 18.8 -20.2 L 17.6 -19.8 L 16.3 -17.7 L 15.5 -13.9 L 15.3 -9.5 L 15.6 -3.9 L 16.3 2.5 L 17.2 4.6 L 18.3 6.2 L 19.5 7.0 L 21.8 6.7 L 22.7 5.8 L 24.5 3.5 L 25.6 1.2","0 11.0 M 10.4 4.6 L 12.5 3.6 L 14.3 1.1 L 14.3 -1.0 L 13.5 -2.2 L 11.6 -2.2 L 10.2 -1.0 L 9.6 1.7 L 9.7 4.1 L 11.7 6.7 L 14.4 7.5 L 17.4 6.2 L 19.3 4.0 L 20.4 1.3","0 9.7 M 10.2 -.1 L 12.6 -5.0 L 13.9 -8.9 L 15.0 -13.6 L 15.3 -17.9 L 15.1 -20.4 L 14.4 -22.0 L 13.4 -22.6 L 11.8 -22.3 L 10.7 -20.2 L 10.1 -15.6 L 9.8 -10.4 L 9.4 20.4 L 9.8 23.1 L 10.3 25.7 L 11.3 26.8 L 12.9 27.3 L 13.9 26.6 L 15.0 23.9 L 15.1 19.9 L 15.0 18.0 L 13.9 14.8 L 12.5 12.1 L 11.8 11.3 L 9.7 9.7 L 13.5 7.6 L 16.2 5.5 L 17.9 3.4 L 19.1 1.4","0 13.0 M 16.6 -1.2 L 14.7 -2.2 L 12.3 -1.7 L 10.1 .6 L 9.0 3.4 L 9.6 5.8 L 11.0 6.9 L 12.8 6.9 L 14.6 5.3 L 15.4 3.5 L 15.7 2.0 L 15.8 20.3 L 15.4 23.3 L 15.0 26.3 L 14.0 28.3 L 12.6 29.6 L 10.3 29.2 L 9.6 27.3 L 9.6 24.4 L 11.2 19.3 L 12.9 15.6 L 14.5 13.1 L 18.0 8.7 L 20.0 5.8 L 22.5 1.5","0 16.2 M 10.0 .0 L 12.2 -4.4 L 14.1 -8.2 L 15.0 -12.9 L 15.3 -17.0 L 15.0 -19.7 L 14.2 -22.3 L 13.1 -22.7 L 11.8 -22.1 L 10.6 -20.1 L 9.9 -17.0 L 9.6 -9.4 L 9.6 5.7 L 9.6 6.6 L 10.5 7.1 L 11.1 6.0 L 12.8 2.9 L 15.0 -.8 L 16.7 -1.7 L 17.5 -1.7 L 18.4 -.4 L 18.2 1.1 L 18.0 5.3 L 18.8 6.7 L 20.6 7.2 L 22.9 5.8 L 24.4 3.4 L 25.6 1.3","0 9.2 M 10.3 -2.7 L 10.0 5.0 L 10.9 6.9 L 12.6 7.7 L 14.8 6.9 L 16.0 5.7 L 17.3 3.8 L 18.1 2.6 L 18.8 1.4 M 10.6 -10.7 L 9.5 -10.4 L 8.6 -9.1 L 9.7 -7.5 L 11.1 -7.4 L 12.3 -8.3 L 12.5 -9.7 L 12.0 -10.5 L 10.6 -10.7","0 7.1 M 10.0 -3.0 L 9.6 1.8 L 9.6 8.8 L 9.6 14.9 L 9.6 20.5 L 9.3 23.6 L 8.2 26.2 L 6.4 27.5 L 3.9 26.8 L 3.1 24.6 L 2.9 22.1 L 4.6 17.0 L 7.2 13.0 L 10.8 8.8 L 14.0 5.3 L 15.8 2.9 L 16.7 1.3 M 10.5 -10.7 L 9.4 -10.4 L 8.6 -9.1 L 9.6 -7.5 L 11.0 -7.4 L 12.2 -8.3 L 12.4 -9.7 L 11.9 -10.5 L 10.5 -10.7","0 15.1 M 9.9 -21.4 L 9.7 7.4 L 11.3 3.6 L 12.9 .0 L 15.2 -2.2 L 16.6 -2.5 L 18.2 -1.3 L 18.2 .6 L 17.8 1.9 L 16.1 3.3 L 14.7 4.1 L 13.3 4.4 L 13.8 6.2 L 16.0 7.4 L 17.7 7.4 L 19.9 6.7 L 22.2 5.0 L 23.3 3.4 L 24.5 1.3","0 10.8 M 10.3 -.1 L 12.3 -3.6 L 14.5 -9.4 L 15.4 -13.2 L 15.8 -17.2 L 15.7 -20.2 L 15.2 -21.6 L 14.2 -22.5 L 13.0 -22.6 L 11.5 -20.7 L 10.3 -16.3 L 9.6 -9.9 L 9.6 -4.2 L 10.3 2.2 L 11.4 5.5 L 13.8 7.3 L 15.9 6.9 L 18.0 5.1 L 20.1 1.5","0 27.9 M 9.5 1.1 L 11.2 -1.8 L 12.3 -2.7 L 13.0 -2.7 L 13.5 -.8 L 12.9 6.6 L 13.4 7.3 L 14.8 5.0 L 16.6 1.7 L 18.1 -.3 L 19.1 -1.4 L 20.1 -1.7 L 21.2 -1.3 L 21.2 .1 L 21.3 7.1 L 22.4 6.3 L 24.0 2.7 L 25.4 .0 L 27.0 -1.3 L 28.2 -1.7 L 29.1 -1.4 L 29.6 .7 L 29.3 4.6 L 29.9 6.5 L 31.3 7.3 L 33.4 6.5 L 34.6 5.5 L 35.8 3.9 L 37.2 1.4","0 19.4 M 9.5 1.2 L 10.7 -1.5 L 11.5 -2.7 L 12.5 -2.9 L 13.3 -2.0 L 13.2 .6 L 12.7 6.7 L 13.7 7.1 L 14.4 5.5 L 16.4 1.7 L 17.7 -.5 L 18.9 -1.4 L 20.0 -1.6 L 20.9 -1.5 L 21.1 -.1 L 21.1 5.5 L 22.1 6.8 L 23.5 6.9 L 24.9 6.4 L 26.2 5.2 L 27.6 3.2 L 28.6 1.2","0 13.6 M 12.2 -1.5 L 10.2 .1 L 9.2 2.0 L 9.0 4.4 L 10.2 6.4 L 12.5 7.5 L 14.5 7.1 L 16.2 5.7 L 17.0 4.0 L 17.6 1.7 L 17.4 -.1 L 16.7 -1.5 L 15.9 -2.2 L 14.4 -1.8 L 13.9 .2 L 14.8 2.4 L 16.0 3.7 L 18.8 4.6 L 21.3 3.5 L 22.1 2.7 L 23.0 1.3","0 15.0 M 9.3 1.2 L 10.8 -2.0 L 10.8 -5.0 L 10.6 15.1 L 10.0 21.0 L 10.1 22.9 L 9.0 26.2 L 8.0 27.7 L 6.9 28.2 L 5.6 28.0 L 4.7 26.8 L 4.5 23.8 L 5.3 18.6 L 7.2 13.0 L 8.5 9.0 L 10.9 4.4 L 13.3 .4 L 14.8 -1.8 L 16.6 -2.2 L 18.1 -.9 L 18.7 1.5 L 18.1 4.1 L 17.3 5.6 L 16.1 6.4 L 15.1 6.7 L 14.2 6.7 L 12.4 5.6 L 16.3 7.8 L 19.9 7.1 L 21.9 5.4 L 23.6 3.3 L 24.4 1.3","0 13.2 M 16.9 -1.1 L 15.7 -2.2 L 12.2 -1.8 L 10.1 .4 L 9.2 3.9 L 10.1 6.4 L 12.4 7.1 L 14.5 5.8 L 15.7 3.7 L 16.2 1.3 L 15.3 19.5 L 15.7 25.4 L 16.0 27.7 L 17.4 29.4 L 19.3 29.4 L 20.0 28.2 L 20.5 26.7 L 20.7 23.0 L 19.5 18.1 L 18.3 14.6 L 17.4 13.2 L 15.7 11.5 L 18.1 8.9 L 20.1 5.7 L 22.7 1.4","0 13.4 M 9.6 1.3 L 10.4 -1.0 L 10.6 -3.2 L 10.0 -5.0 L 9.4 -5.2 L 8.2 -4.3 L 8.0 -2.9 L 8.9 -2.0 L 12.0 -2.1 L 13.5 -2.1 L 14.4 -1.2 L 13.9 1.5 L 13.7 5.0 L 15.4 6.7 L 17.0 7.3 L 19.3 6.3 L 22.7 1.5","0 10.9 M 9.7 1.0 L 11.0 -1.4 L 11.7 -3.6 L 11.7 -4.6 L 10.8 -5.2 L 10.5 -4.5 L 11.5 -1.4 L 13.1 1.2 L 13.8 3.3 L 14.0 5.1 L 12.8 6.2 L 11.3 6.9 L 9.7 6.7 L 9.1 6.0 L 13.6 8.0 L 17.4 6.5 L 19.8 3.4 L 20.6 1.5","0 10.1 M 9.9 1.1 L 11.5 -2.1 L 13.0 -7.6 L 13.6 -11.8 L 13.4 -15.2 L 12.5 -17.1 L 11.9 -17.4 L 10.6 -16.5 L 9.8 -15.1 L 9.0 -9.7 L 8.8 -5.2 L 9.2 -.3 L 10.2 3.5 L 11.3 5.5 L 13.1 6.9 L 15.1 6.9 L 16.5 6.2 L 17.4 4.8 L 19.6 1.6 M 1.0 -13.9 L 24.7 -13.8","0 15.2 M 11.1 -2.1 L 9.9 .6 L 9.3 4.5 L 10.9 6.9 L 12.7 6.9 L 14.5 5.6 L 15.6 4.1 L 16.6 1.0 L 16.4 -1.6 L 16.0 4.3 L 17.0 5.9 L 18.5 7.0 L 21.1 6.4 L 22.6 5.1 L 24.7 1.3","0 14.3 M 9.8 -2.0 L 9.3 1.3 L 10.2 4.8 L 11.7 6.9 L 13.3 7.0 L 14.9 4.8 L 16.3 2.0 L 16.6 -.1 L 16.6 -3.0 L 18.0 .7 L 19.6 2.5 L 21.5 2.9 L 22.9 2.5 L 23.6 1.4","0 20.3 M 11.2 -2.1 L 9.8 .3 L 9.7 3.2 L 9.9 5.5 L 11.7 7.1 L 14.0 6.3 L 15.1 5.3 L 15.9 4.1 L 16.3 2.9 L 16.5 -1.4 L 16.7 5.0 L 17.3 6.3 L 19.1 6.9 L 21.5 6.4 L 22.4 4.8 L 22.9 2.8 L 22.7 -2.7 L 24.0 .8 L 25.9 2.5 L 27.6 3.1 L 28.9 2.4 L 29.6 1.5","0 16.0 M 9.5 1.1 L 11.8 -3.3 L 13.2 1.3 L 14.6 4.3 L 16.1 6.0 L 18.7 7.4 L 21.5 6.9 L 23.2 5.3 L 24.4 3.2 L 25.4 1.3 M 20.7 -5.0 L 17.2 -.2 L 15.3 2.5 L 13.2 6.2 L 12.4 7.8","0 13.3 M 10.7 -2.0 L 9.6 1.4 L 9.3 4.9 L 10.7 6.9 L 12.9 6.8 L 14.4 5.3 L 15.5 3.6 L 16.4 -.4 L 15.8 8.7 L 15.6 14.0 L 15.8 19.0 L 15.1 23.1 L 13.5 26.2 L 11.2 26.8 L 10.0 25.6 L 9.6 22.4 L 10.7 18.3 L 12.6 13.9 L 14.8 10.9 L 18.1 7.1 L 20.2 5.2 L 22.7 1.3","0 15.6 M 9.5 1.3 L 11.1 -1.7 L 13.5 -3.5 L 16.6 -3.6 L 17.9 -2.0 L 18.0 .8 L 16.2 3.8 L 14.4 5.7 L 13.3 6.7 L 12.5 6.7 L 12.3 6.1 L 13.4 5.2 L 15.3 5.0 L 17.3 6.4 L 18.0 9.7 L 18.2 15.6 L 17.5 20.5 L 16.8 23.2 L 15.2 25.2 L 14.0 25.8 L 12.9 25.3 L 11.9 24.0 L 11.8 20.8 L 13.1 16.7 L 15.4 13.0 L 19.3 8.5 L 21.9 5.5 L 23.5 3.9 L 24.9 1.5","0 17.7 M 23.7 -24.1 L 21.4 -25.1 L 19.0 -24.5 L 16.8 -22.3 L 16.1 -19.3 L 16.3 -15.4 L 17.0 -12.3 L 17.0 -9.1 L 16.0 -7.8 L 14.8 -7.4 L 12.5 -7.4 L 15.7 -5.4 L 16.9 -3.2 L 17.0 -.3 L 16.0 3.8 L 15.2 7.1 L 15.6 9.7 L 17.2 10.4 L 18.0 10.4 L 19.1 9.5","0 10.8 M 12.8 -23.5 L 13.4 -8.6 L 13.4 10.2","0 17.8 M 14.4 -24.1 L 16.1 -25.0 L 17.9 -24.7 L 18.7 -22.8 L 17.7 -18.4 L 16.5 -13.7 L 16.5 -11.1 L 17.8 -9.0 L 19.3 -8.1 L 21.0 -7.6 L 19.3 -7.3 L 17.6 -6.7 L 16.5 -5.5 L 16.6 -2.6 L 17.7 2.2 L 17.5 5.7 L 16.6 7.9 L 15.4 9.5 L 13.0 10.2 L 11.4 10.3 L 10.0 9.7","0 15.9 M 10.3 -4.1 L 10.4 -5.8 L 11.2 -7.9 L 12.6 -8.6 L 14.1 -8.5 L 15.4 -7.3 L 17.1 -4.8 L 19.4 -3.5 L 21.1 -4.5 L 21.8 -5.7 L 21.8 -7.4 L 21.1 -8.5","0 7.3 M 10.5 -22.2 L 9.5 -20.9 L 9.4 -19.2 L 10.6 -17.7 L 12.8 -17.6 L 14.4 -18.7 L 14.7 -20.9 L 13.8 -22.2 L 12.1 -22.8 L 10.8 -22.3 L 10.5 -22.2"]
EMSCasualHand = ["-8 8","0 3.1 M 11.6 -20.8 L 11.5 -5.6 M 10.9 6.0 L 10.9 7.2 L 12.1 7.2 L 12.1 6.1 L 10.9 6.0","0 8.8 M 12.7 -18.0 L 12.4 -10.7 L 12.6 -9.6 M 16.1 -18.6 L 16.6 -17.1 L 17.2 -9.0","0 15.8 M 15.1 -16.7 L 15.5 -6.3 L 16.3 -.7 M 19.3 -18.4 L 19.3 -8.2 L 20.3 -1.2 M 11.0 -9.3 L 21.9 -14.7 M 12.6 -4.2 L 16.9 -6.5 L 24.7 -11.4","0 11.8 M 17.7 6.6 L 16.2 -3.2 L 16.0 -16.7 L 16.8 -26.4 M 20.1 -19.8 L 16.6 -18.5 L 12.9 -14.4 L 11.3 -11.2 L 11.5 -10.1 L 13.5 -9.1 L 17.9 -9.3 L 20.5 -8.7 L 21.1 -7.2 L 19.2 -4.4 L 16.3 -2.5 L 15.3 -1.9 L 13.9 -1.9","0 15.0 M 20.1 -1.8 L 19.1 .3 L 19.6 3.1 L 20.9 3.8 L 23.0 2.1 L 23.3 -.4 L 23.0 -2.6 L 21.7 -2.9 L 17.2 -.3 L 14.5 1.5 L 12.7 3.9 L 11.8 6.0 L 21.9 -21.6 L 20.0 -18.6 L 17.0 -15.9 L 14.2 -14.3 L 11.8 -12.9 L 10.3 -13.8 L 10.3 -16.7 L 11.3 -18.9 L 13.4 -19.7 L 14.5 -19.1 L 14.8 -17.2 L 14.6 -16.0 L 13.9 -14.3","0 12.2 M 17.1 8.8 L 16.8 5.0 M 20.2 .3 L 16.2 -.5 L 13.9 -2.5 L 12.4 -4.8 L 13.6 -6.1 L 18.9 -6.6 L 15.5 -9.2 L 13.2 -10.8 L 13.3 -11.8 L 16.3 -12.3 L 19.6 -12.4 M 16.0 -16.7 L 15.7 -19.9","0 3.7 M 11.5 -9.6 L 12.0 -16.1","0 8.6 M 15.7 7.0 L 12.2 4.4 L 11.4 -2.3 L 13.1 -11.2 L 15.1 -16.4 L 17.1 -18.8","0 8.8 M 11.5 7.0 L 15.8 1.4 L 17.7 -5.1 L 17.7 -11.5 L 16.6 -18.5 L 14.4 -21.7","0 15.9 M 17.7 3.7 L 17.8 -10.5 M 13.0 1.4 L 23.9 -7.1 M 11.1 -1.4 L 24.6 -4.4 M 13.0 -6.5 L 23.5 2.5","0 15.9 M 17.5 3.4 L 17.8 -10.3 M 11.1 -1.4 L 13.0 -1.5 L 24.2 -4.2","0 3.5 M 12.2 3.4 L 11.4 9.9","0 14.3 M 12.7 -2.1 L 23.5 -3.1","0 3.8 M 11.2 5.9 L 11.2 7.1 L 12.4 7.1 L 12.4 6.0 L 11.2 5.9","0 9.2 M 11.6 8.9 L 18.5 -27.4","0 11.6 M 12.6 -7.5 L 11.8 2.2 L 12.7 5.7 L 15.1 6.8 L 17.9 5.4 L 19.9 .9 L 20.2 -5.5 L 19.6 -9.0 L 17.5 -11.7 L 14.2 -11.4 L 12.6 -7.5","0 4.1 M 11.8 6.3 L 11.6 -3.1 L 12.5 -13.5","0 16.9 M 11.9 -5.5 L 12.2 -5.6 L 16.0 -8.8 L 18.9 -10.3 L 20.3 -10.2 L 20.8 -8.1 L 19.7 -3.5 L 17.5 1.2 L 14.4 6.1 L 19.1 4.0 L 23.1 2.1 L 26.1 1.5","0 14.2 M 17.0 6.5 L 18.1 6.6 L 21.4 3.9 L 22.8 -.4 L 22.3 -3.8 L 19.3 -4.7 L 14.7 -2.5 L 13.8 -2.4 L 14.5 -3.9 L 18.9 -10.2 L 19.9 -11.9 L 19.1 -12.5 L 14.7 -11.1 L 11.1 -9.1","0 14.7 M 20.1 6.8 L 19.1 -4.6 L 19.1 -13.8 L 11.7 -2.4 L 16.9 -3.1 L 23.4 -4.9","0 15.2 M 15.2 6.5 L 18.9 2.7 L 20.8 -.6 L 20.4 -2.3 L 18.5 -2.5 L 15.3 -.8 L 12.8 .9 L 12.0 1.3 L 11.8 -.6 L 13.1 -9.8 L 13.0 -8.4 L 23.9 -10.1","0 11.3 M 13.5 11.0 L 14.0 6.4 L 16.6 1.7 L 19.0 -.8 L 20.1 -.8 L 20.2 .6 L 19.3 4.2 L 17.0 6.1 L 15.2 6.3 L 13.0 5.5 L 11.7 3.1 L 12.1 -1.9 L 15.3 -12.4","0 12.8 M 18.6 6.8 L 18.9 .1 L 20.0 -8.6 L 21.0 -14.3 L 15.1 -12.5 L 11.2 -12.2","0 11.1 M 16.9 6.8 L 19.3 5.4 L 20.0 3.2 L 19.3 .2 L 16.6 -2.5 L 13.2 -5.3 L 11.2 -8.1 L 11.6 -10.3 L 14.5 -12.4 L 16.6 -12.8 L 18.7 -11.7 L 18.4 -8.8 L 17.7 -6.3 L 15.2 -.6 L 14.2 2.2 L 14.1 4.9 L 15.6 6.6 L 16.9 6.8","0 11.4 M 18.3 6.5 L 20.0 -15.4 L 19.1 -15.6 L 15.9 -11.2 L 14.1 -8.8 L 12.0 -9.2 L 11.6 -12.2 L 13.5 -16.4 L 16.1 -18.3 L 17.5 -18.5 L 18.5 -17.2 L 18.7 -15.0","0 3.6 M 11.1 -6.7 L 11.1 -5.5 L 12.4 -5.6 L 12.4 -6.7 L 11.1 -6.7 M 11.2 1.4 L 11.2 2.6 L 12.4 2.5 L 12.4 1.5 L 11.2 1.4","0 4.2 M 11.7 -2.2 L 11.7 -1.0 L 12.9 -1.0 L 12.9 -2.1 L 11.7 -2.2 M 11.8 5.3 L 12.0 8.6 L 10.1 15.7","0 16.3 M 20.7 -11.5 L 15.9 -3.9 L 11.7 1.7 L 21.5 2.1 L 23.1 2.3 L 25.0 3.2","0 14.6 M 11.1 -3.4 L 23.2 -6.4 M 13.3 1.7 L 13.7 1.7 L 22.9 -1.9","0 15.3 M 15.2 3.7 L 16.6 2.5 L 24.0 -7.6 L 11.7 -12.6","0 13.4 M 17.4 5.6 L 17.4 6.8 L 18.6 6.7 L 18.6 5.7 L 17.4 5.6 M 16.3 -1.7 L 14.9 -2.8 L 16.6 -5.9 L 19.5 -9.8 L 21.3 -13.2 L 21.4 -14.8 L 20.7 -15.6 L 18.7 -15.7 L 14.5 -14.1 L 11.5 -11.9","0 27.8 M 23.9 -7.8 L 23.0 -8.8 L 20.8 -8.2 L 17.8 -5.3 L 16.3 -2.3 L 16.6 -.5 L 17.9 -.3 L 20.4 -2.5 L 21.8 -4.5 L 23.5 -6.9 L 23.2 -3.1 L 24.5 -.8 L 26.8 -1.1 L 27.7 -2.7 L 28.1 -7.7 L 27.6 -13.5 L 26.3 -16.2 L 24.3 -17.0 L 21.8 -16.4 L 16.9 -11.4 L 13.4 -5.3 L 11.6 .2 L 13.0 4.2 L 16.9 6.7 L 22.6 6.7 L 32.5 2.4 L 35.5 .7 L 37.1 -.8","0 18.8 M 11.8 6.7 L 12.9 -7.2 L 14.9 -19.2 L 16.0 -19.3 L 21.6 -3.9 L 24.6 2.3 M 12.5 .1 L 21.4 -5.0 L 27.9 -8.5","0 18.4 M 11.7 -8.4 L 16.5 -12.9 L 20.6 -14.9 L 21.7 -14.5 L 21.9 -12.9 L 20.2 -10.2 L 18.5 -7.3 L 14.5 -4.5 L 18.3 -7.0 L 22.5 -8.0 L 25.9 -7.1 L 27.4 -5.2 L 27.0 -3.0 L 24.7 .2 L 17.2 6.2 L 15.5 6.5 L 14.8 3.5 L 13.7 -16.4","0 15.6 M 21.0 -13.8 L 18.6 -15.3 L 16.7 -15.5 L 14.3 -13.5 L 12.9 -8.4 L 12.0 -1.4 L 11.7 4.4 L 13.3 6.8 L 16.2 5.9 L 19.9 1.9 L 22.1 -1.3 L 23.6 -5.3","0 18.6 M 11.0 -11.9 L 11.4 -12.1 L 16.7 -14.2 L 22.7 -14.5 L 26.0 -12.6 L 27.5 -8.1 L 26.7 -4.4 L 23.3 -.1 L 17.0 6.7 L 16.3 6.8 L 16.2 -16.6","0 14.8 M 23.8 -4.4 L 19.2 .7 L 16.9 4.7 L 14.9 6.3 L 13.9 6.2 L 13.2 1.9 L 12.4 -14.6 L 23.2 -19.1 M 20.8 -10.4 L 11.8 -3.2","0 15.4 M 14.3 7.0 L 12.1 -13.3 L 12.5 -11.1 L 21.4 -15.8 M 24.6 -7.7 L 16.5 -3.2 L 11.7 -2.2","0 18.3 M 23.3 -14.2 L 20.3 -13.4 L 16.8 -9.6 L 13.3 -5.4 L 12.0 -2.3 L 11.4 1.6 L 13.1 5.0 L 15.9 6.1 L 19.1 5.0 L 20.6 2.6 L 23.5 -2.6 L 24.6 -4.8 L 24.3 1.1 L 24.7 6.1 L 24.7 9.6 L 25.5 11.3 M 18.7 -4.3 L 21.7 -4.2 L 24.2 -5.1 L 26.7 -6.5","0 12.9 M 12.8 5.5 L 11.8 -16.8 M 11.3 -3.4 L 15.8 -3.6 L 21.1 -5.3 M 19.3 -21.9 L 20.3 -16.2 L 20.7 -9.7 L 20.5 -1.1 L 20.5 3.6 L 20.6 5.1 L 20.8 5.9","0 4.6 M 12.8 6.7 L 12.0 -13.5","0 11.1 M 10.9 -1.7 L 18.1 6.4 L 18.8 6.5 L 18.9 -17.2","0 21.6 M 14.6 6.8 L 11.9 -15.8 M 22.9 -15.6 L 21.8 -11.8 L 19.6 -7.7 L 16.4 -4.1 L 12.3 .9 L 16.1 .6 L 21.3 -.2 L 30.8 -.5","0 15.8 M 12.1 -17.0 L 12.2 5.4 L 13.5 6.0 L 20.2 3.1 L 24.9 1.2","0 21.3 M 12.0 6.5 L 12.0 -15.5 L 21.1 -.2 L 24.1 -11.9 L 26.7 -19.3 L 27.3 -15.4 L 28.2 -3.5 L 29.5 4.0","0 16.3 M 11.9 6.4 L 12.2 -15.7 L 12.2 -13.5 L 24.3 3.6 L 23.1 -1.3 L 21.7 -15.2 L 21.6 -21.2","0 11.1 M 15.2 6.6 L 15.8 6.3 L 18.9 4.0 L 19.8 .8 L 19.2 -9.8 L 18.3 -14.7 L 17.3 -16.6 L 15.5 -16.8 L 13.6 -15.0 L 12.0 -11.1 L 11.6 -4.7 L 11.7 -.5 L 12.3 3.5 L 13.2 5.2 L 15.2 6.6","0 19.4 M 17.6 6.8 L 16.4 -5.8 L 16.1 -18.2 L 16.2 -15.8 L 12.0 -11.8 L 20.6 -18.9 L 24.8 -20.3 L 28.5 -19.7 L 30.1 -17.6 L 28.7 -13.8 L 24.9 -10.5 L 16.5 -4.4","0 18.5 M 15.4 -14.0 L 12.8 -5.7 L 11.6 1.4 L 12.9 5.4 L 15.1 6.1 L 18.3 3.7 L 20.9 -2.7 L 21.4 -9.4 L 20.8 -11.9 L 19.1 -12.9 L 16.6 -11.7 L 13.9 -8.3 M 18.5 -.8 L 30.8 11.6","0 28.5 M 14.5 6.6 L 13.0 -15.4 L 13.3 -11.0 L 11.4 -8.8 L 19.0 -15.8 L 23.2 -17.5 L 25.8 -17.3 L 27.1 -15.6 L 26.0 -12.6 L 23.0 -9.4 L 13.2 -2.5 L 17.9 -1.4 L 28.6 -.8 L 37.5 .0","0 19.9 M 17.5 6.8 L 22.8 4.6 L 27.1 1.8 L 28.7 .1 L 28.9 -1.0 L 27.5 -2.3 L 16.0 -3.8 L 13.0 -4.5 L 11.7 -5.6 L 11.8 -7.5 L 13.5 -9.6 L 23.8 -13.0","0 16.4 M 21.0 6.8 L 19.4 -10.4 L 18.3 -15.6 L 18.7 -14.0 L 11.0 -12.0 L 18.9 -14.0 L 27.6 -16.1","0 14.8 M 13.5 -8.8 L 12.8 -.2 L 12.8 4.0 L 13.3 6.3 L 15.2 7.4 L 16.7 6.4 L 19.2 3.8 L 20.9 1.0 L 22.3 -2.4 L 22.3 -11.7 L 22.3 1.5 L 22.9 7.1 L 23.4 10.1 L 24.0 12.0","0 19.4 M 11.2 -12.9 L 21.1 2.7 L 21.7 3.4 L 22.0 6.3 L 23.1 -.6 L 26.9 -14.3","0 18.2 M 11.1 -13.5 L 11.7 -12.8 L 16.4 2.3 L 17.3 -8.8 L 18.5 -13.8 L 20.7 -4.8 L 24.6 6.2 L 24.7 -4.6 L 26.2 -14.3 L 27.0 -19.0","0 16.9 M 13.5 5.8 L 18.0 -4.6 L 20.5 -13.9 M 11.7 -10.2 L 17.2 -1.5 L 25.2 6.4","0 15.3 M 19.9 8.2 L 23.4 -16.9 M 21.5 -4.0 L 15.9 -7.3 L 11.7 -11.8","0 27.9 M 11.4 -8.8 L 11.9 -8.8 L 14.0 -8.8 L 24.4 -10.2 L 20.4 -4.0 L 14.0 6.3 L 23.8 5.2 L 34.5 3.6 L 36.2 3.8","0 14.9 M 23.7 6.9 L 13.5 10.9 L 12.9 10.3 L 13.0 -6.7 L 11.8 -20.3 L 19.9 -23.6","0 20.3 M 11.6 -26.4 L 29.2 6.3","0 14.7 M 15.8 9.2 L 18.3 8.6 L 23.4 8.2 L 20.1 -24.6 L 11.1 -23.9","0 12.8 M 12.1 -18.5 L 15.8 -24.8 L 20.5 -18.9","0 21.8 M 11.8 6.6 L 30.6 2.8","0 8.1 M 13.8 -19.6 L 17.4 -16.4","0 14.0 M 20.4 -10.1 L 19.0 -5.4 L 15.7 .7 L 13.3 3.6 L 12.2 4.0 L 11.9 .0 L 13.7 -7.9 L 16.6 -11.4 L 19.1 -12.8 L 20.1 -12.6 L 22.2 6.4","0 13.2 M 12.1 -20.4 L 12.7 -18.3 L 13.3 6.5 L 18.1 1.3 L 20.9 -3.9 L 22.4 -7.8 L 21.4 -10.1 L 19.1 -10.7 L 15.4 -8.8 L 11.7 -5.6","0 12.8 M 18.0 -3.0 L 17.8 -6.9 L 16.7 -7.7 L 14.6 -6.1 L 12.4 -1.6 L 11.9 2.6 L 12.9 5.6 L 14.6 6.8 L 16.8 6.1 L 19.2 3.5 L 21.2 .3","0 14.1 M 21.0 -4.6 L 19.1 -6.7 L 15.8 -5.8 L 12.6 -1.8 L 11.6 1.0 L 11.4 4.0 L 12.7 6.1 L 15.5 5.4 L 19.3 1.5 L 20.8 -1.4 L 21.2 -3.6 L 20.3 -13.8 L 20.3 -19.8 L 20.4 -13.2 L 21.6 -.6 L 23.3 12.2","0 16.2 M 11.2 -.4 L 14.4 -1.7 L 17.5 -3.8 L 19.3 -5.7 L 19.3 -7.2 L 17.9 -8.6 L 15.9 -8.5 L 13.9 -5.1 L 12.5 2.3 L 12.6 5.1 L 13.4 6.5 L 15.4 6.0 L 25.0 -3.3","0 9.7 M 16.3 7.0 L 13.0 -3.5 L 11.0 -1.9 L 17.7 -7.1 L 21.7 -9.1 L 17.6 -7.1 L 12.9 -3.5 L 12.3 -9.5 L 12.6 -17.9 L 13.8 -19.9 L 15.3 -20.4 L 16.8 -20.4","0 14.8 M 21.2 -7.7 L 19.5 -8.8 L 16.9 -7.6 L 14.1 -3.5 L 12.0 .7 L 11.4 4.3 L 12.4 6.0 L 15.3 4.7 L 18.6 .7 L 20.4 -2.3 L 21.5 -7.3 L 22.7 6.0 L 23.9 14.8 L 23.5 18.5 L 21.3 21.0 L 18.5 21.7 L 13.6 21.3","0 13.8 M 12.0 -20.2 L 13.4 6.5 L 14.0 .1 L 16.6 -4.2 L 19.0 -6.8 L 21.1 -6.9 L 21.9 -5.9 L 22.5 -2.2 L 22.3 6.3","0 5.6 M 13.5 6.4 L 12.1 -10.4 M 10.9 -21.7 L 12.0 -20.5 L 12.7 -21.5 L 10.9 -21.7","0 6.2 M 5.8 13.8 L 8.1 15.5 L 10.6 15.8 L 12.7 14.8 L 14.7 11.7 L 14.7 6.8 L 13.4 -10.1 M 10.5 -20.7 L 12.0 -19.5 L 12.4 -20.1 L 10.8 -20.6","0 14.4 M 12.6 9.0 L 12.4 -18.1 M 23.3 -.1 L 12.0 -1.9 L 21.6 -12.8","0 4.5 M 12.2 6.4 L 11.9 -18.3","0 20.7 M 12.2 -8.6 L 12.5 -6.9 L 13.3 6.3 L 15.3 -1.7 L 17.6 -6.3 L 19.6 -9.2 L 21.3 5.3 L 23.5 -2.7 L 25.2 -6.7 L 26.2 -8.8 L 27.0 -6.0 L 29.6 5.8","0 14.8 M 12.2 -10.3 L 12.0 6.1 L 15.9 -4.8 L 17.4 -8.4 L 18.3 -9.4 L 18.9 -8.8 L 20.6 -1.6 L 22.2 4.9 L 23.1 6.5","0 11.7 M 13.0 -7.3 L 11.6 1.5 L 12.7 5.7 L 15.7 6.3 L 17.9 4.6 L 20.0 1.8 L 20.4 -1.9 L 19.3 -4.7 L 17.8 -6.5 L 15.9 -6.1 L 13.7 -4.3 L 12.2 -1.7","0 15.3 M 13.7 17.4 L 12.8 -6.7 L 12.8 -3.5 L 11.0 -.8 L 15.5 -6.4 L 20.0 -8.9 L 23.1 -8.8 L 23.7 -6.5 L 22.9 -3.6 L 20.7 .2 L 17.2 3.8 L 13.4 6.5","0 13.8 M 22.1 -7.5 L 19.9 -1.9 L 16.8 3.4 L 14.3 5.7 L 12.4 5.5 L 11.3 2.8 L 11.9 -1.1 L 13.8 -4.2 L 16.8 -7.1 L 19.1 -8.1 L 21.5 -8.3 L 21.4 1.5 L 21.3 11.8 L 22.0 18.9","0 12.8 M 13.7 6.6 L 13.4 5.2 L 12.2 -10.1 L 12.8 -1.7 L 16.2 -6.5 L 19.0 -9.8 L 21.4 -11.7","0 14.8 M 17.7 6.7 L 21.9 1.3 L 23.0 -.4 L 22.9 -1.2 L 21.5 -1.6 L 16.6 -.3 L 14.1 -.4 L 12.6 -.6 L 12.0 -1.3 L 13.0 -3.3 L 16.8 -6.6 L 19.7 -8.1 L 22.0 -8.4","0 15.8 M 16.8 6.3 L 15.6 -6.3 L 11.5 -4.4 L 24.5 -9.5 L 15.6 -6.1 L 14.9 -19.9","0 12.2 M 12.1 -8.4 L 11.5 -2.2 L 11.4 2.8 L 12.9 6.1 L 15.2 6.6 L 16.4 5.2 L 17.8 2.7 L 19.4 -2.6 L 20.0 -9.1 L 20.1 8.1","0 13.8 M 11.6 -8.1 L 17.7 5.7 L 22.1 -9.5","0 18.2 M 11.7 -9.1 L 12.2 -7.8 L 16.7 5.8 L 19.1 -6.1 L 23.1 4.1 L 24.3 5.5 L 26.8 -9.3","0 15.2 M 13.3 11.3 L 20.6 -10.2 M 11.8 -6.2 L 19.7 1.6 L 24.2 5.6","0 11.5 M 11.4 -3.2 L 19.6 6.5 L 19.5 -8.2 L 19.6 19.7","0 27.8 M 11.8 -8.0 L 13.3 -7.6 L 19.1 -9.5 L 21.2 -9.8 L 23.1 -9.0 L 23.1 -8.2 L 16.6 5.9 L 17.1 6.3 L 23.3 3.7 L 29.5 1.6 L 36.1 -.1","0 13.7 M 21.7 7.2 L 19.5 9.7 L 18.0 9.7 L 17.3 8.0 L 17.7 .0 L 17.4 -5.3 L 16.6 -7.2 L 15.2 -8.1 L 11.8 -6.3 L 14.8 -7.9 L 15.3 -9.3 L 14.7 -14.3 L 14.8 -19.8 L 16.9 -24.1 L 19.5 -26.2 L 22.1 -26.5","0 5.1 M 13.6 6.4 L 12.8 4.3 L 12.2 -22.9 L 12.0 -27.1","0 10.2 M 11.7 11.3 L 15.2 10.1 L 17.9 7.0 L 18.9 4.2 L 18.0 2.1 L 15.0 .2 L 12.8 -1.4 L 12.8 -3.0 L 14.2 -4.8 L 15.8 -5.6 L 13.3 -6.5 L 13.5 -8.4 L 15.5 -13.8 L 16.7 -17.9 L 16.5 -20.4 L 14.9 -22.8 L 13.4 -23.4 L 11.7 -23.1","0 14.3 M 11.9 -11.8 L 13.8 -15.6 L 14.7 -15.9 L 15.7 -14.8 L 18.2 -12.0 L 19.4 -12.3 L 21.3 -15.0","0 9.8 M 13.1 -14.4 L 12.0 -12.6 L 11.9 -11.1 L 13.7 -9.9 L 15.8 -10.5 L 17.0 -11.3 L 17.9 -13.2 L 17.0 -14.7 L 15.1 -15.3 L 13.1 -14.4"]
EMSDecorousScript = ["-8 8","0 9.0 M 25.1 -14.2 L 16.2 3.0 M 14.4 6.3 L 13.6 6.6 L 13.6 7.2 L 14.3 7.5 L 14.8 6.8 L 14.4 6.3","0 6.0 M 22.5 -14.2 L 22.3 -13.1 L 21.7 -11.6 L 21.0 -10.5 L 20.3 -9.6 M 25.6 -14.2 L 25.3 -13.1 L 24.8 -11.6 L 24.1 -10.5 L 23.4 -9.6","0 16.9 M 24.5 -10.2 L 14.9 7.8 M 30.3 -10.2 L 20.7 7.8 M 18.1 -4.5 L 31.0 -4.5 M 14.2 2.5 L 27.2 2.5","0 15.6 M 16.6 -.2 L 15.8 -.2 L 14.7 1.0 L 14.2 2.7 L 14.1 4.7 L 14.9 6.3 L 16.0 7.4 L 18.1 7.6 L 16.8 10.2 L 18.0 7.7 L 20.1 7.4 L 21.9 6.7 L 23.7 5.3 L 24.9 3.4 L 25.4 1.5 L 25.0 -.6 L 23.9 -2.5 L 23.0 -4.1 L 22.9 -6.5 L 23.9 -8.9 L 25.7 -10.6 L 27.8 -11.2 L 29.0 -11.3 L 30.1 -13.6 L 29.1 -11.3 L 30.2 -11.1 L 31.0 -10.2 L 31.6 -9.2 L 31.4 -7.3 L 30.4 -5.2","0 27.0 M 18.2 10.1 L 37.0 -12.4 M 25.7 -10.5 L 23.6 -10.6 L 21.4 -9.7 L 19.4 -8.2 L 18.1 -6.7 L 16.8 -4.6 L 16.1 -2.3 L 16.1 -.6 L 16.6 .9 L 17.9 1.6 L 19.5 1.4 L 21.5 .6 L 23.5 -.8 L 25.3 -3.2 L 26.5 -5.4 L 27.1 -7.6 L 27.0 -9.3 L 26.4 -10.2 L 25.7 -10.5 M 38.9 -4.5 L 36.8 -4.6 L 34.6 -3.7 L 32.6 -2.1 L 31.4 -.7 L 30.1 1.4 L 29.4 3.8 L 29.4 5.4 L 29.9 6.9 L 31.1 7.6 L 32.8 7.4 L 34.8 6.6 L 36.7 5.2 L 38.6 2.8 L 39.8 .6 L 40.4 -1.6 L 40.2 -3.3 L 39.6 -4.1 L 38.9 -4.5","0 21.9 M 30.2 -7.5 L 32.0 -8.4 L 33.2 -10.1 L 33.2 -11.8 L 31.0 -13.1 L 28.1 -12.8 L 26.0 -11.6 L 24.6 -10.1 L 24.2 -8.3 L 24.4 -6.8 L 24.8 -6.0 L 25.2 -5.5 L 26.5 -5.3 L 24.5 -5.1 L 21.6 -4.0 L 19.5 -2.5 L 17.8 -.4 L 17.1 1.7 L 17.0 3.8 L 17.5 5.5 L 18.9 7.2 L 20.9 7.8 L 23.2 7.4 L 25.3 6.6 L 27.0 5.0 L 28.2 3.3 L 28.8 1.8 L 29.1 .5 L 29.1 -.7 L 28.4 -2.3 M 23.1 .5 L 23.5 -.7 L 24.4 -1.7 L 25.6 -2.3 L 27.1 -2.5 L 29.1 -2.2 L 30.4 -1.6 L 32.1 -1.7 L 33.7 -2.5 L 34.8 -3.8 L 35.6 -5.1","0 2.9 M 20.8 -14.3 L 20.6 -13.1 L 20.0 -11.6 L 19.3 -10.5 L 18.6 -9.6","0 12.2 M 16.6 7.9 L 15.6 6.3 L 14.7 3.9 L 14.5 1.4 L 14.7 -.8 L 15.9 -4.3 L 17.2 -6.8 L 19.3 -9.2 L 21.3 -11.1 L 23.5 -12.5 L 25.5 -13.4 L 27.1 -13.9 L 28.3 -14.0","0 12.5 M 25.0 -13.9 L 26.0 -12.2 L 26.9 -9.9 L 27.0 -7.4 L 26.8 -5.1 L 25.6 -1.6 L 24.3 .8 L 22.3 3.2 L 20.2 5.2 L 18.1 6.5 L 16.1 7.4 L 14.4 7.9 L 13.2 8.1","0 9.1 M 19.2 -3.2 L 20.7 -12.0 M 23.8 -10.0 L 15.9 -5.1 M 16.8 -10.2 L 23.0 -5.2","0 10.0 M 19.9 -5.2 L 18.3 4.0 M 14.7 -.6 L 23.7 -.6","0 5.3 M 14.0 7.4 L 13.3 7.1 L 13.3 6.5 L 14.1 6.2 L 14.5 6.7 L 14.4 7.7 L 14.1 8.7 L 13.2 9.6 L 12.5 10.0 L 11.8 10.1","0 12.9 M 16.5 -.6 L 24.4 -.6","0 5.4 M 14.3 6.2 L 13.5 6.5 L 13.5 7.1 L 14.2 7.4 L 14.7 6.7 L 14.3 6.2","0 9.2 M 12.9 10.2 L 25.1 -12.5","0 16.4 M 19.5 8.2 L 21.7 7.8 L 24.2 6.1 L 26.1 4.1 L 28.3 1.0 L 30.0 -2.1 L 31.0 -4.9 L 31.5 -7.4 L 31.4 -8.6 L 30.5 -10.0 L 29.3 -10.6 L 27.3 -10.5 L 24.7 -9.4 L 22.5 -7.6 L 20.4 -4.7 L 18.7 -1.7 L 17.7 .8 L 16.8 3.6 L 16.7 5.6 L 17.2 7.2 L 18.3 8.0 L 19.5 8.2","0 13.8 M 17.6 -4.5 L 19.6 -4.7 L 22.0 -5.9 L 24.3 -7.2 L 26.0 -8.7 L 28.2 -10.6 L 18.4 7.6","0 15.1 M 18.0 -5.4 L 18.6 -7.1 L 19.9 -8.6 L 21.6 -10.0 L 23.3 -10.5 L 25.2 -10.8 L 27.2 -10.2 L 28.5 -9.1 L 28.9 -7.5 L 28.5 -5.8 L 27.1 -3.4 L 24.5 -1.4 L 20.2 1.5 L 17.9 2.9 L 15.7 4.6 L 14.8 5.8 L 14.2 6.9 L 25.6 6.9","0 16.0 M 16.9 1.6 L 15.9 3.0 L 15.4 4.3 L 15.6 6.1 L 16.8 7.5 L 18.7 8.1 L 20.5 8.2 L 22.7 7.4 L 25.1 5.5 L 26.3 3.4 L 26.6 1.7 L 26.2 -.3 L 25.2 -1.4 L 24.0 -2.2 L 22.8 -2.1 L 24.9 -2.5 L 27.3 -3.6 L 28.7 -5.5 L 29.2 -7.4 L 29.1 -9.1 L 27.6 -10.3 L 25.0 -10.5 L 23.0 -10.0 L 21.3 -8.7 L 20.3 -7.1","0 15.9 M 21.0 10.1 L 32.3 -10.6 L 14.5 4.3 L 28.0 4.3","0 14.3 M 12.8 6.1 L 14.1 7.4 L 16.3 8.2 L 18.6 8.1 L 20.8 7.4 L 23.5 5.6 L 25.0 3.8 L 26.0 1.9 L 26.0 -.1 L 25.4 -1.9 L 23.3 -3.3 L 21.2 -3.8 L 19.3 -3.8 L 22.7 -10.1 L 29.8 -10.1","0 16.9 M 18.6 -.2 L 20.3 -2.3 L 22.6 -3.7 L 24.9 -4.2 L 26.9 -3.8 L 28.3 -2.8 L 28.9 -1.4 L 29.1 .2 L 28.7 2.3 L 27.7 4.3 L 26.4 5.8 L 24.0 7.4 L 21.6 8.1 L 20.1 8.2 L 18.2 7.2 L 17.2 5.2 L 17.3 2.9 L 17.9 .9 L 19.6 -2.6 L 21.1 -5.2 L 22.9 -7.6 L 25.1 -9.9 L 27.6 -11.4 L 30.2 -12.2 L 32.0 -12.2 L 33.7 -12.0 L 34.4 -11.7","0 14.8 M 14.2 10.4 L 31.6 -10.0 L 20.7 -10.0","0 15.2 M 18.9 8.1 L 21.0 7.8 L 23.5 6.4 L 24.9 4.8 L 25.6 2.4 L 25.3 .0 L 24.2 -1.9 L 22.8 -3.9 L 21.8 -6.0 L 21.6 -8.3 L 23.0 -10.6 L 25.0 -12.0 L 27.1 -12.6 L 29.5 -12.4 L 30.7 -11.1 L 30.8 -9.3 L 29.8 -7.5 L 28.2 -5.9 L 26.0 -4.3 L 21.3 -2.2 L 19.0 -1.0 L 17.1 .5 L 15.6 2.2 L 15.0 4.3 L 15.2 6.2 L 16.6 7.7 L 17.5 8.1 L 18.9 8.1","0 16.7 M 13.3 9.4 L 16.1 9.8 L 19.6 9.1 L 22.4 7.5 L 25.1 4.7 L 27.4 1.7 L 29.1 -1.6 L 30.1 -4.4 L 30.3 -7.4 L 29.6 -9.5 L 28.0 -10.6 L 26.0 -10.8 L 23.5 -9.9 L 21.2 -8.0 L 19.7 -5.8 L 18.8 -3.8 L 18.8 -1.3 L 19.5 .4 L 21.4 1.6 L 23.8 1.7 L 25.7 1.0 L 27.8 -.6 L 28.9 -2.0 L 30.0 -3.8","0 7.7 M 14.3 6.1 L 13.5 6.5 L 13.5 7.1 L 14.2 7.4 L 14.7 6.7 L 14.3 6.1 M 20.8 -6.1 L 20.0 -5.7 L 20.0 -5.1 L 20.7 -4.8 L 21.2 -5.5 L 20.8 -6.1","0 7.7 M 20.8 -6.2 L 20.1 -5.8 L 20.1 -5.2 L 20.7 -4.9 L 21.3 -5.6 L 20.8 -6.2 M 123.5 6.3 L 122.7 6.7 L 122.7 7.3 L 123.4 7.6 L 123.9 6.9 L 123.5 6.3 M 14.1 7.4 L 13.5 7.1 L 13.5 6.5 L 14.2 6.1 L 14.7 6.7 L 14.6 7.7 L 14.3 8.6 L 13.3 9.5 L 12.6 10.0 L 11.9 10.1","0 11.6 M 21.3 4.0 L 15.2 -.7 L 26.5 -5.8","0 14.0 M 14.5 2.5 L 24.9 2.5 M 17.0 -2.4 L 27.5 -2.4","0 12.1 M 13.8 3.9 L 25.2 -1.2 L 18.9 -5.8","0 13.9 M 16.2 2.9 L 17.5 1.0 L 19.8 -1.2 L 23.1 -3.8 L 25.9 -6.3 L 27.6 -8.0 L 28.1 -10.4 L 27.6 -12.8 L 25.7 -13.9 L 23.2 -14.0 L 20.9 -12.9 L 19.3 -11.2 L 18.6 -9.1 L 19.2 -7.7 L 20.6 -6.7","0 24.3 M 28.6 8.8 L 26.7 9.8 L 23.4 10.0 L 19.9 9.7 L 17.7 8.1 L 16.3 5.2 L 16.2 1.8 L 17.2 -1.4 L 19.3 -4.9 L 22.0 -7.8 L 25.5 -9.6 L 29.2 -10.5 L 32.4 -10.0 L 34.8 -8.3 L 35.8 -5.5 L 35.4 -2.3 L 34.1 .9 L 32.7 2.7 L 31.0 4.3 L 28.7 5.1 L 27.2 4.6 L 27.2 2.3 L 28.3 .0 L 29.4 -2.1 L 29.4 -3.8 L 28.3 -4.9 L 26.3 -4.4 L 24.1 -2.7 L 22.1 .0 L 21.1 1.9 L 20.9 3.9 L 21.5 5.0 L 23.4 4.7 L 25.0 3.5 L 26.0 2.3 L 28.4 -.1 L 30.9 -4.8","0 27.1 M 17.5 .2 L 15.9 .4 L 14.2 1.9 L 13.6 3.1 L 13.0 5.0 L 13.4 7.3 L 14.8 8.3 L 16.7 8.3 L 18.8 7.5 L 21.3 5.4 L 23.9 2.1 L 26.6 -1.8 L 28.6 -4.9 L 30.6 -8.0 L 32.1 -10.4 L 34.0 -12.4 L 35.6 -13.2 L 37.1 -13.1 L 37.9 -12.3 L 37.7 -10.7 L 36.3 -7.3 L 33.6 -2.3 L 27.0 -2.3 L 33.6 -2.3 L 32.4 .3 L 31.1 3.0 L 30.3 4.7 L 30.2 6.4 L 30.7 7.5 L 31.9 8.2 L 33.9 7.9 L 36.3 6.5 L 38.4 4.3 L 40.4 1.9 L 41.4 .5","0 25.1 M 22.7 6.8 L 23.9 7.9 L 26.0 8.3 L 28.5 7.4 L 30.5 6.1 L 32.1 4.5 L 33.0 2.6 L 33.5 1.0 L 33.5 -.8 L 32.7 -2.3 L 31.8 -3.0 L 30.0 -3.7 L 31.5 -3.7 L 34.1 -4.8 L 35.9 -6.4 L 37.3 -8.4 L 37.7 -10.3 L 36.9 -12.0 L 35.3 -13.1 L 32.7 -13.1 L 30.2 -12.8 L 27.1 -11.8 L 24.1 -10.2 L 22.1 -8.9 L 19.7 -6.9 L 17.3 -4.2 L 15.6 -1.9 L 14.3 .9 L 13.4 3.3 L 13.2 5.3 L 13.3 7.1 L 14.7 8.0 L 16.4 8.2 L 19.0 7.3 L 22.1 4.2 L 24.6 .3 L 27.6 -5.0 L 29.8 -8.6 L 31.3 -10.6 L 32.9 -11.9 L 34.6 -12.6","0 14.9 M 29.3 .5 L 28.5 1.7 L 27.0 3.6 L 25.2 5.2 L 23.4 6.7 L 21.3 7.7 L 18.8 8.2 L 16.0 7.7 L 14.1 5.2 L 14.1 1.4 L 15.8 -2.7 L 17.9 -6.2 L 20.5 -9.1 L 23.6 -11.5 L 26.0 -12.8 L 28.1 -13.1 L 30.2 -12.7 L 30.9 -11.4 L 30.4 -9.1 L 29.4 -7.8 L 27.7 -6.5","0 28.2 M 19.6 -1.4 L 18.7 -2.5 L 18.4 -4.6 L 19.3 -7.1 L 21.0 -9.6 L 22.9 -11.1 L 25.4 -12.3 L 27.4 -12.9 L 29.9 -13.1 L 32.3 -13.0 L 34.9 -12.4 L 36.8 -11.5 L 38.4 -9.8 L 39.0 -7.5 L 38.9 -4.9 L 37.9 -1.4 L 36.3 1.4 L 34.5 3.7 L 32.3 5.6 L 29.9 7.1 L 26.8 8.0 L 24.4 8.1 L 22.1 7.8 L 19.7 6.8 L 18.0 6.2 L 15.5 5.7 L 13.9 5.9 L 12.8 6.7 L 12.7 7.8 L 13.5 8.3 L 15.5 8.3 L 17.6 7.6 L 19.8 6.7 L 22.6 3.6 L 25.2 -.2 L 27.6 -4.6 L 29.8 -8.3 L 31.7 -10.5 L 33.1 -11.8 L 34.5 -12.4","0 14.7 M 29.2 .5 L 27.5 2.6 L 26.0 4.4 L 24.3 5.8 L 22.5 6.9 L 20.1 7.8 L 18.0 8.2 L 16.0 7.8 L 14.4 6.7 L 13.8 4.8 L 14.1 2.7 L 14.9 .5 L 16.7 -1.6 L 18.7 -3.0 L 20.4 -3.8 L 22.0 -4.1 L 23.1 -4.1 L 22.0 -4.2 L 21.0 -5.6 L 20.9 -7.4 L 21.8 -9.5 L 23.3 -11.3 L 25.4 -12.7 L 27.5 -13.2 L 29.3 -12.8 L 30.3 -11.8 L 30.4 -10.4 L 29.3 -8.5 L 28.7 -7.5 L 27.5 -6.6","0 21.0 M 15.4 1.8 L 14.5 2.3 L 13.4 4.0 L 13.0 5.1 L 13.5 7.2 L 15.0 8.0 L 16.9 8.5 L 19.7 7.6 L 22.2 5.7 L 24.0 3.6 L 26.1 .7 L 27.9 -2.9 L 23.5 -2.9 L 32.8 -2.9 L 27.9 -2.9 L 29.0 -4.8 L 30.7 -7.6 L 32.1 -9.6 L 33.6 -11.3 L 35.4 -12.6 L 37.6 -13.3 L 38.8 -13.7 L 40.5 -13.3 L 40.4 -12.2 L 38.3 -11.5 L 36.9 -11.5 L 34.4 -11.6 L 30.7 -12.3 L 28.4 -12.8 L 25.4 -12.9 L 22.9 -12.6 L 20.5 -11.4 L 19.5 -9.9 L 19.4 -8.1 L 20.7 -6.9 L 22.5 -6.7 L 24.4 -7.1 L 25.6 -7.6","0 22.2 M 32.3 -6.8 L 33.7 -8.7 L 34.4 -10.8 L 33.9 -12.5 L 31.3 -13.3 L 28.8 -12.9 L 26.3 -11.9 L 23.4 -9.9 L 21.1 -7.5 L 19.1 -4.7 L 18.1 -2.1 L 17.7 .8 L 18.1 3.2 L 19.7 4.5 L 22.0 4.4 L 24.2 3.2 L 26.7 1.4 L 28.7 -.5 L 30.2 -2.3 L 26.0 5.0 L 23.7 8.3 L 21.1 11.4 L 18.9 13.3 L 16.8 14.3 L 14.0 14.5 L 12.3 13.9 L 11.5 12.4 L 12.2 10.6 L 13.7 9.7 L 15.6 8.7 L 18.7 8.1 L 20.8 7.8 L 25.3 7.4 L 29.5 6.7 L 32.3 5.3 L 34.5 3.4 L 35.7 1.8 L 36.6 .5","0 28.5 M 21.3 -8.2 L 21.5 -10.1 L 22.3 -11.6 L 24.1 -12.8 L 26.3 -12.9 L 28.3 -12.3 L 30.3 -12.1 L 32.1 -12.3 L 34.0 -12.5 L 34.9 -13.0 L 32.6 -11.6 L 30.5 -9.7 L 28.6 -6.5 L 26.8 -2.9 L 24.7 .7 L 22.6 3.9 L 20.4 6.5 L 18.0 8.0 L 15.7 8.3 L 13.8 7.5 L 12.9 5.6 L 13.4 3.7 L 15.0 1.9 L 17.5 .6 L 20.6 -.3 L 24.1 -1.0 L 29.2 -1.8 L 33.7 -3.1 L 37.7 -4.7 L 41.0 -6.3 L 43.9 -8.2 L 45.6 -9.7 L 46.5 -11.5 L 46.3 -12.5 L 45.2 -13.3 L 42.6 -12.6 L 40.2 -10.8 L 37.8 -8.4 L 35.8 -6.0 L 33.8 -2.7 L 32.2 1.0 L 31.5 4.1 L 31.5 6.4 L 32.1 7.7 L 33.2 8.3 L 34.9 8.1 L 36.9 7.2 L 38.9 5.3 L 40.8 3.2 L 42.9 .5","0 19.3 M 15.4 2.0 L 14.2 2.5 L 13.4 3.9 L 13.1 5.6 L 13.7 7.3 L 15.4 8.1 L 17.3 8.3 L 19.8 7.6 L 21.9 6.2 L 24.0 3.9 L 27.0 -.9 L 29.3 -5.2 L 31.4 -8.4 L 32.9 -10.6 L 34.4 -11.9 L 36.5 -13.0 L 35.2 -12.4 L 32.7 -12.2 L 30.8 -12.2 L 27.8 -12.8 L 26.0 -12.8 L 23.9 -11.9 L 22.9 -10.2 L 22.8 -8.2","0 22.3 M 25.0 -8.1 L 25.1 -10.0 L 26.0 -11.8 L 27.9 -12.8 L 29.8 -12.9 L 31.8 -12.3 L 34.0 -12.1 L 36.6 -12.3 L 38.9 -13.1 L 36.7 -12.0 L 34.5 -9.9 L 32.7 -7.1 L 30.9 -4.0 L 29.5 -1.3 L 27.8 1.4 L 26.2 4.4 L 23.9 8.0 L 22.0 10.3 L 20.3 12.2 L 17.9 13.7 L 15.6 14.4 L 13.6 14.5 L 11.9 13.7 L 11.8 11.6 L 13.1 10.0 L 15.2 8.9 L 18.6 8.1 L 21.2 7.8 L 26.0 7.5 L 29.7 6.6 L 32.4 5.2 L 34.7 3.0 L 36.6 .5","0 28.1 M 15.4 1.9 L 14.1 2.4 L 13.5 3.4 L 13.0 4.8 L 13.2 6.3 L 13.6 7.2 L 14.7 8.0 L 16.2 8.3 L 18.0 8.1 L 20.2 7.2 L 22.6 5.3 L 24.9 2.5 L 27.4 -1.8 L 29.3 -5.3 L 31.2 -8.3 L 32.8 -10.5 L 34.0 -11.6 L 34.8 -12.4 L 36.4 -13.0 L 34.7 -12.4 L 32.9 -12.2 L 30.4 -12.2 L 28.3 -12.9 L 26.5 -12.8 L 25.0 -12.5 L 23.6 -11.5 L 22.7 -10.0 L 22.7 -8.2 M 46.3 -13.0 L 44.6 -13.1 L 43.0 -12.7 L 41.4 -11.8 L 40.0 -10.0 L 38.6 -8.4 L 36.9 -6.5 L 35.4 -4.9 L 34.0 -4.0 L 32.6 -3.4 L 31.7 -3.6 L 33.1 -2.7 L 33.9 -1.9 L 33.9 -1.0 L 33.7 .2 L 32.2 3.4 L 31.5 5.0 L 31.3 6.5 L 32.6 7.9 L 34.8 8.1 L 36.8 7.4 L 39.4 4.8 L 42.7 .4","0 22.8 M 33.1 -5.2 L 34.6 -6.7 L 36.3 -8.5 L 37.4 -10.6 L 37.4 -12.1 L 36.9 -13.0 L 35.4 -13.1 L 33.1 -12.1 L 31.2 -10.2 L 29.5 -7.6 L 27.5 -4.3 L 25.8 -1.3 L 23.5 2.4 L 22.0 4.6 L 20.5 6.3 L 19.1 7.4 L 16.7 8.2 L 14.7 8.4 L 12.5 7.6 L 12.9 6.2 L 14.3 5.6 L 16.0 5.6 L 18.1 6.1 L 20.9 7.2 L 23.5 8.0 L 26.5 8.4 L 28.9 7.9 L 31.6 6.7 L 34.1 4.5 L 35.7 2.8 L 37.3 .5","0 30.0 M 15.1 -7.1 L 16.9 -9.4 L 18.9 -11.8 L 21.2 -13.1 L 22.5 -13.1 L 23.5 -12.2 L 23.3 -10.2 L 22.5 -8.0 L 14.0 7.6 L 22.6 -7.4 L 24.6 -9.7 L 26.3 -11.7 L 27.8 -12.8 L 29.5 -13.1 L 31.1 -12.9 L 32.1 -11.8 L 32.4 -10.3 L 31.6 -7.9 L 23.1 7.8 L 31.0 -6.5 L 32.9 -8.4 L 34.6 -10.5 L 35.8 -11.8 L 37.2 -12.8 L 38.9 -13.2 L 40.3 -13.0 L 41.1 -12.2 L 41.4 -10.3 L 40.0 -7.1 L 35.2 .8 L 33.7 4.4 L 33.3 6.0 L 33.6 7.2 L 34.8 8.2 L 36.3 8.3 L 38.2 7.5 L 40.1 5.8 L 42.4 3.2 L 44.5 .5","0 22.5 M 15.1 -7.0 L 16.5 -9.1 L 18.1 -11.2 L 19.8 -12.7 L 21.8 -13.1 L 23.1 -12.4 L 23.0 -10.6 L 22.5 -8.4 L 21.1 -5.5 L 13.8 7.6 L 21.7 -6.1 L 23.5 -7.8 L 25.4 -10.2 L 27.0 -11.6 L 28.7 -12.8 L 30.4 -13.0 L 32.1 -12.7 L 32.9 -11.7 L 32.9 -9.7 L 32.0 -7.4 L 28.5 -1.3 L 26.3 2.8 L 25.6 4.5 L 25.4 5.8 L 25.5 7.1 L 26.3 7.9 L 28.2 8.1 L 30.3 7.5 L 32.6 5.5 L 34.6 3.2 L 36.6 .5","0 21.3 M 19.6 8.1 L 22.1 7.5 L 24.6 6.0 L 27.0 4.0 L 29.2 1.3 L 31.2 -1.6 L 32.4 -4.5 L 33.3 -7.1 L 33.5 -9.5 L 33.3 -11.4 L 32.1 -12.7 L 30.1 -13.1 L 27.9 -12.9 L 25.7 -11.9 L 23.5 -10.6 L 20.5 -7.6 L 18.7 -5.1 L 17.1 -2.3 L 16.2 .1 L 15.6 3.0 L 15.6 4.9 L 16.4 7.1 L 18.0 8.1 L 19.6 8.1","0 22.9 M 29.1 -2.3 L 31.3 -2.8 L 34.1 -4.2 L 36.2 -6.1 L 37.3 -8.3 L 37.7 -10.4 L 36.8 -12.3 L 35.4 -13.1 L 33.3 -13.2 L 29.8 -12.8 L 26.7 -11.6 L 23.4 -9.9 L 20.5 -7.6 L 17.8 -4.8 L 16.0 -2.2 L 14.7 -.1 L 13.9 1.9 L 13.4 3.8 L 13.3 5.4 L 13.4 7.0 L 14.2 7.9 L 15.8 8.4 L 17.7 8.0 L 19.7 6.8 L 21.7 5.0 L 24.0 1.4 L 25.9 -1.9 L 28.4 -6.2 L 30.3 -9.1 L 32.0 -10.9 L 33.3 -11.8 L 34.3 -12.5","0 23.8 M 24.9 5.3 L 23.6 6.2 L 22.2 6.6 L 20.9 6.7 L 19.3 6.3 L 18.4 4.8 L 18.3 2.3 L 19.3 -.9 L 21.5 -5.6 L 24.0 -8.7 L 27.1 -11.2 L 30.0 -12.8 L 32.6 -13.2 L 34.3 -12.9 L 35.6 -11.8 L 36.1 -10.4 L 36.2 -8.2 L 35.5 -5.6 L 33.9 -2.1 L 32.1 .7 L 30.4 2.9 L 28.4 5.1 L 26.2 6.9 L 23.2 9.0 L 20.3 10.5 L 17.6 11.8 L 15.2 12.1 L 12.8 12.0 L 11.7 11.1 L 12.6 9.7 L 13.8 9.3 L 15.3 9.3 L 17.2 9.8 L 18.9 10.5 L 21.2 11.4 L 24.2 12.1 L 26.7 12.1 L 29.1 11.3 L 30.8 10.1 L 32.8 8.4","0 26.9 M 34.4 -12.5 L 32.4 -11.4 L 30.8 -10.0 L 29.2 -7.8 L 27.8 -4.9 L 25.7 -1.4 L 24.1 1.5 L 22.0 4.3 L 20.5 6.1 L 18.3 7.6 L 16.0 8.2 L 14.0 7.8 L 13.0 5.7 L 13.5 2.8 L 14.5 .2 L 16.4 -3.0 L 18.8 -5.8 L 21.5 -8.5 L 25.2 -10.9 L 28.2 -12.4 L 32.1 -13.0 L 34.1 -13.0 L 36.0 -12.8 L 37.2 -11.6 L 37.8 -10.0 L 37.4 -8.2 L 35.8 -6.3 L 34.1 -4.7 L 32.4 -3.9 L 31.6 -3.6 L 30.5 -3.6 L 30.2 -3.5 L 31.8 -2.7 L 32.3 -1.9 L 32.5 -.4 L 31.2 2.0 L 30.0 4.7 L 29.9 6.2 L 30.6 7.3 L 32.1 8.2 L 34.2 8.0 L 36.1 6.6 L 38.7 3.8 L 41.4 .5","0 18.4 M 15.7 .3 L 15.1 .4 L 13.8 1.9 L 13.3 3.3 L 13.3 4.7 L 14.3 6.5 L 15.6 7.8 L 18.0 8.4 L 20.5 7.8 L 23.3 6.5 L 25.3 3.9 L 25.9 1.5 L 25.6 -1.1 L 24.3 -4.1 L 24.0 -6.7 L 24.5 -9.6 L 26.1 -11.6 L 28.5 -13.1 L 30.5 -13.1 L 32.1 -12.7 L 33.2 -11.8 L 33.6 -10.2 L 32.9 -8.7 L 31.9 -7.1","0 19.9 M 15.5 1.8 L 14.5 2.4 L 13.5 3.9 L 13.2 5.7 L 13.5 6.8 L 14.8 8.0 L 16.8 8.4 L 19.0 8.1 L 21.3 6.8 L 23.6 4.1 L 26.1 .7 L 28.9 -4.3 L 30.8 -7.6 L 32.1 -9.4 L 33.8 -11.4 L 35.2 -12.6 L 37.3 -13.6 L 39.3 -13.8 L 40.6 -13.7 L 41.0 -13.1 L 40.5 -12.4 L 39.7 -11.9 L 37.9 -11.3 L 36.4 -11.3 L 33.2 -11.9 L 29.1 -12.6 L 26.0 -12.9 L 23.0 -12.7 L 20.9 -11.8 L 19.6 -10.2 L 19.4 -8.7 L 20.1 -7.5 L 21.6 -6.7 L 23.4 -6.9 L 24.4 -7.1 L 25.6 -7.6","0 21.4 M 15.0 -6.9 L 16.0 -8.5 L 17.6 -10.6 L 19.3 -12.2 L 20.6 -13.1 L 21.9 -13.2 L 23.2 -12.6 L 23.4 -10.9 L 21.9 -7.5 L 19.2 -2.9 L 16.7 1.7 L 15.4 4.6 L 15.3 6.2 L 15.9 7.5 L 16.9 8.1 L 18.4 8.1 L 20.1 7.5 L 22.4 5.3 L 24.6 2.4 L 26.8 -.2 L 28.5 -2.7 L 34.2 -13.0 L 25.3 3.6 L 24.9 5.3 L 25.0 6.7 L 25.7 7.8 L 27.2 8.2 L 29.0 7.8 L 31.6 5.9 L 34.0 3.2 L 35.9 .5","0 18.2 M 15.2 -6.8 L 16.5 -9.1 L 18.4 -11.3 L 20.0 -12.8 L 22.0 -13.3 L 23.5 -12.8 L 23.5 -11.3 L 23.0 -9.2 L 19.0 -2.5 L 16.8 1.4 L 15.8 3.4 L 15.4 5.3 L 15.3 6.2 L 15.8 7.4 L 16.8 8.1 L 18.1 8.1 L 19.6 7.5 L 21.6 6.4 L 23.6 4.2 L 26.7 .6 L 28.9 -2.8 L 30.6 -6.0 L 32.2 -9.5 L 32.6 -12.2 L 32.4 -14.2","0 27.8 M 15.1 -7.1 L 16.5 -9.2 L 18.5 -11.6 L 20.1 -12.8 L 22.1 -13.2 L 23.1 -12.5 L 23.3 -11.1 L 22.7 -9.3 L 20.1 -4.5 L 17.3 .3 L 15.5 3.9 L 15.1 5.5 L 15.2 6.7 L 16.0 7.8 L 17.4 8.3 L 19.3 7.6 L 21.6 5.8 L 24.0 3.4 L 26.4 .8 L 33.0 -11.3 L 25.3 2.7 L 24.7 4.6 L 24.9 6.1 L 25.4 7.6 L 27.3 8.1 L 29.1 7.6 L 31.4 6.3 L 34.3 3.4 L 37.0 -.2 L 39.3 -3.9 L 41.2 -7.6 L 42.4 -11.1 L 42.5 -13.0 L 42.1 -14.2","0 22.5 M 12.7 9.4 L 13.2 7.6 L 14.3 6.1 L 16.2 4.1 L 18.9 1.8 L 21.5 -.1 L 26.5 -2.9 L 29.2 -4.4 L 32.3 -7.1 L 35.2 -9.9 L 36.7 -12.2 L 37.1 -13.3 M 18.2 -10.1 L 19.3 -11.5 L 20.9 -12.8 L 22.4 -13.1 L 23.8 -12.9 L 25.1 -11.7 L 25.5 -10.1 L 25.5 -8.1 L 24.1 3.3 L 24.1 6.2 L 25.1 7.7 L 27.0 8.3 L 29.6 7.6 L 32.4 5.7 L 35.1 3.0 L 37.1 .5","0 22.4 M 16.7 -6.8 L 18.0 -8.9 L 19.6 -11.0 L 21.3 -12.4 L 22.7 -13.1 L 24.4 -13.0 L 25.2 -12.3 L 25.1 -10.5 L 23.9 -7.6 L 21.1 -3.2 L 19.8 -1.0 L 18.9 1.6 L 19.2 3.2 L 20.9 4.6 L 22.9 4.2 L 25.1 2.6 L 27.3 .4 L 29.3 -2.0 L 32.6 -7.1 L 35.5 -12.1 L 26.0 5.0 L 24.0 8.2 L 22.2 10.4 L 20.2 12.3 L 18.1 13.8 L 16.1 14.5 L 14.1 14.6 L 12.8 14.3 L 11.6 12.9 L 11.6 11.5 L 13.0 9.9 L 15.0 9.0 L 18.9 8.1 L 22.2 7.7 L 26.4 7.3 L 30.1 6.6 L 33.3 4.6 L 35.0 2.7 L 36.8 .5","0 19.2 M 17.0 -7.0 L 18.6 -9.3 L 20.5 -11.6 L 22.1 -12.7 L 23.1 -12.9 L 24.3 -12.6 L 25.7 -11.9 L 27.0 -11.3 L 28.3 -11.1 L 29.8 -11.3 L 31.9 -12.0 L 34.1 -12.7 L 24.7 -3.2 L 20.0 -3.2 L 29.3 -3.2 L 24.7 -3.2 L 14.0 7.7 L 15.7 6.1 L 17.1 5.8 L 18.7 5.9 L 20.0 6.3 L 22.0 7.2 L 23.6 7.4 L 25.1 7.8 L 26.6 7.5 L 28.3 6.4 L 30.5 4.2 L 32.5 1.9 L 33.6 .5","0 14.4 M 17.3 10.2 L 13.0 10.1 L 26.1 -13.9 L 30.5 -13.9","0 9.2 M 16.9 -12.6 L 21.1 10.2","0 14.4 M 12.6 10.1 L 17.0 10.1 L 30.0 -14.0 L 25.8 -14.0","0 11.3 M 14.8 1.0 L 20.3 -4.3 L 24.3 1.2","0 14.5 M 11.8 8.5 L 23.8 8.7","0 4.2 M 17.1 -13.9 L 17.3 -13.0 L 18.0 -11.8 L 19.7 -10.1","0 18.9 M 25.4 -1.8 L 26.2 -4.1 L 26.2 -6.4 L 25.1 -7.5 L 22.2 -7.4 L 18.6 -5.2 L 16.2 -2.8 L 14.7 .1 L 13.5 2.2 L 12.8 5.2 L 13.0 6.8 L 14.6 8.0 L 17.2 7.2 L 20.4 4.5 L 23.3 1.3 L 26.2 -3.1 L 28.5 -7.1 L 22.9 2.9 L 22.3 5.2 L 22.5 6.8 L 23.8 8.0 L 25.8 7.7 L 28.3 6.3 L 31.3 3.0 L 33.4 .5","0 15.7 M 22.5 -14.5 L 14.4 .7 L 13.2 2.8 L 12.3 4.9 L 12.3 6.1 L 13.1 7.4 L 15.2 8.0 L 18.5 6.7 L 21.9 3.9 L 24.3 .3 L 26.1 -3.6 L 26.3 -5.9 L 25.5 -7.5 L 23.9 -7.6 L 21.8 -6.9 L 19.9 -5.2 L 17.7 -3.0 L 14.9 -.1","0 13.2 M 24.2 -5.8 L 24.5 -5.3 L 25.3 -5.6 L 25.5 -6.3 L 25.3 -7.1 L 24.0 -7.8 L 21.4 -7.4 L 19.2 -6.0 L 16.9 -3.8 L 15.0 -.8 L 13.8 1.6 L 13.4 4.2 L 13.7 6.3 L 14.9 7.6 L 16.5 8.0 L 18.9 7.8 L 21.3 6.7 L 23.7 5.0 L 25.9 2.5 L 27.7 .5","0 18.9 M 25.6 -2.5 L 26.0 -4.9 L 25.7 -6.9 L 24.6 -7.8 L 22.3 -7.5 L 19.4 -5.9 L 17.2 -3.7 L 15.4 -1.5 L 13.9 1.1 L 13.0 3.8 L 12.8 6.0 L 13.4 7.4 L 15.0 8.0 L 17.6 6.9 L 20.4 4.5 L 22.8 1.7 L 26.6 -4.0 L 32.3 -14.5 L 24.0 .7 L 23.1 2.7 L 22.4 4.0 L 22.3 5.7 L 22.9 7.2 L 24.4 7.9 L 26.3 7.6 L 28.8 5.9 L 31.0 3.5 L 33.3 .5","0 13.6 M 15.2 .5 L 18.1 -.4 L 21.2 -1.2 L 23.3 -2.2 L 25.0 -3.7 L 25.7 -5.8 L 25.1 -7.4 L 22.6 -7.9 L 19.3 -6.2 L 16.4 -2.8 L 14.6 .7 L 13.6 3.9 L 13.9 6.3 L 15.5 7.8 L 18.1 7.9 L 21.3 6.8 L 24.4 4.4 L 26.1 2.6 L 27.7 .5","0 9.3 M 6.9 14.4 L 18.7 -7.5 L 23.5 -7.5 L 14.6 -7.5 L 18.6 -7.5 L 21.3 -11.9 L 22.8 -13.3 L 24.1 -14.1 L 25.8 -14.4 L 27.0 -14.2 L 27.8 -13.3 L 27.8 -12.7 L 27.5 -12.0 L 26.5 -11.9 L 26.5 -12.4 L 26.9 -12.6","0 17.0 M 9.9 12.0 L 10.4 11.6 L 9.9 11.2 L 9.2 11.8 L 8.9 12.8 L 10.2 14.4 L 12.5 14.8 L 15.5 14.1 L 17.4 12.6 L 20.3 8.3 L 24.6 .1 L 26.1 -3.7 L 26.1 -5.8 L 25.7 -7.3 L 23.9 -7.8 L 21.1 -6.9 L 19.0 -5.5 L 16.9 -3.4 L 15.1 -.7 L 13.9 1.5 L 13.1 3.8 L 12.8 5.5 L 13.1 7.0 L 14.1 7.8 L 15.6 7.8 L 17.7 6.8 L 20.2 4.7 L 22.1 2.5 L 25.7 -2.1 L 28.6 -7.4","0 18.2 M 22.3 -14.5 L 10.3 7.7 L 15.5 -1.0 L 17.8 -3.2 L 20.2 -5.7 L 21.9 -7.1 L 24.0 -7.6 L 25.6 -7.4 L 26.6 -6.4 L 26.6 -4.5 L 25.6 -2.5 L 23.1 1.9 L 21.7 4.8 L 21.7 5.9 L 22.0 7.2 L 23.4 7.9 L 25.0 7.7 L 27.2 6.7 L 30.2 3.8 L 32.7 .5","0 9.0 M 20.7 -11.9 L 20.1 -11.6 L 20.2 -10.7 L 21.0 -10.8 L 21.4 -11.5 L 20.7 -11.9 M 18.5 -7.3 L 13.5 2.1 L 12.6 4.1 L 12.2 5.4 L 12.5 6.7 L 13.4 7.7 L 15.5 7.8 L 17.7 6.7 L 20.4 4.4 L 21.7 2.8 L 23.3 .5","0 7.1 M 3.7 12.4 L 4.2 11.7 L 3.5 11.5 L 2.8 12.6 L 2.7 13.8 L 3.3 14.6 L 4.9 14.7 L 6.2 14.0 L 8.2 11.8 L 10.3 8.2 L 18.6 -7.3 M 20.6 -12.1 L 20.1 -11.5 L 20.1 -10.6 L 20.8 -10.7 L 21.4 -11.3 L 20.6 -12.1","0 17.2 M 22.4 -14.6 L 10.3 7.6 L 14.8 -.1 L 17.8 -3.3 L 20.1 -6.0 L 21.1 -6.6 L 22.7 -7.6 L 24.2 -8.0 L 25.7 -7.8 L 26.5 -6.8 L 26.4 -5.2 L 25.8 -3.7 L 24.6 -2.4 L 22.3 -1.3 L 19.5 -.3 L 20.9 .0 L 21.9 .6 L 22.3 1.9 L 21.6 3.4 L 20.5 5.7 L 20.7 6.8 L 21.6 7.6 L 23.2 7.9 L 25.3 7.3 L 28.1 5.0 L 29.9 2.8 L 31.7 .5","0 8.9 M 22.4 -14.6 L 13.3 2.3 L 12.5 3.9 L 12.2 5.3 L 12.5 6.3 L 13.3 7.5 L 14.9 7.8 L 17.0 7.2 L 18.9 5.8 L 21.5 2.9 L 23.4 .5","0 27.5 M 18.6 -7.4 L 10.6 7.6 L 14.8 -.1 L 17.2 -2.4 L 20.2 -5.8 L 23.1 -7.6 L 24.9 -7.8 L 26.0 -7.2 L 26.5 -5.8 L 26.2 -3.8 L 25.6 -2.1 L 20.2 7.6 L 25.4 -1.2 L 27.8 -3.7 L 30.2 -6.6 L 32.0 -7.6 L 33.8 -8.0 L 35.6 -7.4 L 36.0 -5.8 L 36.0 -4.1 L 33.6 .0 L 31.9 3.2 L 31.0 5.3 L 31.2 6.9 L 32.7 8.0 L 34.9 7.7 L 37.8 5.8 L 39.9 3.6 L 42.2 .5","0 18.6 M 18.7 -7.4 L 10.4 7.7 L 14.8 .4 L 17.0 -2.2 L 18.9 -4.4 L 21.0 -6.3 L 23.2 -7.6 L 25.1 -7.6 L 26.2 -7.1 L 26.9 -5.6 L 26.1 -3.1 L 24.0 .6 L 22.5 3.3 L 21.8 5.4 L 22.2 6.9 L 23.3 7.8 L 25.2 7.8 L 27.3 6.7 L 29.7 4.5 L 31.4 2.5 L 33.0 .5","0 15.1 M 15.7 7.8 L 17.9 7.3 L 21.0 5.4 L 24.0 1.9 L 25.8 -1.9 L 26.5 -4.9 L 25.9 -6.9 L 24.4 -7.8 L 22.3 -7.8 L 19.7 -6.4 L 17.5 -4.5 L 15.6 -2.2 L 14.4 .4 L 13.6 2.7 L 13.2 5.1 L 13.7 6.9 L 14.5 7.6 L 15.7 7.8","0 15.6 M 6.8 14.6 L 14.9 -.4 L 17.6 -2.8 L 20.8 -6.2 L 22.8 -7.5 L 24.7 -7.7 L 26.1 -7.0 L 26.6 -4.8 L 25.6 -2.1 L 23.6 1.8 L 22.1 3.9 L 19.6 6.2 L 17.7 7.2 L 16.1 7.7 L 14.9 7.9 L 13.7 7.8 L 13.0 6.8 L 13.0 5.3 L 13.3 3.3 L 15.0 -.6 L 18.8 -7.6","0 17.0 M 16.5 14.8 L 26.0 -2.5 L 26.0 -5.5 L 25.9 -7.0 L 24.7 -7.8 L 22.9 -7.8 L 20.8 -6.7 L 18.1 -4.4 L 15.6 -1.3 L 14.0 1.7 L 13.2 3.9 L 13.2 6.3 L 13.9 7.6 L 15.5 7.9 L 18.1 6.4 L 20.4 4.3 L 22.3 2.3 L 25.9 -2.1 L 28.6 -7.5","0 11.5 M 18.6 -7.4 L 10.5 7.6 L 14.9 .0 L 17.6 -2.8 L 19.6 -5.0 L 21.4 -6.8 L 23.1 -7.6 L 24.4 -7.8 L 25.0 -7.3 L 25.2 -6.5 L 24.9 -5.4 L 24.0 -5.1 L 23.7 -5.4 L 24.3 -6.1","0 13.3 M 14.0 .5 L 16.6 -2.4 L 20.7 -7.1 L 22.5 -8.4 L 24.0 -9.5 L 24.0 -10.5 L 22.5 -10.8 L 21.6 -9.5 L 21.5 -8.3 L 21.4 -3.4 L 21.6 .8 L 20.9 3.3 L 18.9 6.2 L 16.7 7.5 L 14.8 7.9 L 13.0 7.3 L 12.0 5.6 L 12.4 3.1 L 13.2 1.8 L 14.5 .5 L 15.1 .1 L 15.4 .9 L 14.9 1.5 L 14.6 1.0","0 9.7 M 20.3 -10.7 L 18.7 -7.4 L 23.5 -7.4 L 14.2 -7.4 L 18.7 -7.4 L 13.5 1.9 L 12.6 4.4 L 12.5 6.7 L 14.5 8.1 L 16.8 7.6 L 19.4 6.1 L 22.2 3.0 L 24.0 .5","0 18.7 M 18.7 -7.4 L 13.0 3.3 L 12.3 4.9 L 12.4 6.3 L 12.8 7.3 L 14.2 8.0 L 15.6 7.7 L 18.0 6.6 L 19.9 4.6 L 21.6 2.9 L 23.7 .9 L 25.0 -.9 L 28.3 -7.2 L 22.5 3.8 L 22.1 5.3 L 22.1 6.5 L 22.7 7.4 L 23.8 7.8 L 25.3 7.8 L 26.9 7.2 L 29.6 4.9 L 31.5 2.8 L 33.2 .5","0 14.1 M 18.6 -7.3 L 13.3 2.0 L 12.5 4.5 L 12.4 6.5 L 13.1 7.6 L 14.5 7.9 L 16.6 7.4 L 19.1 5.7 L 21.7 3.2 L 23.3 .6 L 24.7 -2.6 L 25.1 -5.3 L 25.3 -6.5 L 25.0 -7.4","0 21.9 M 18.6 -7.3 L 12.7 3.6 L 12.3 5.1 L 12.3 6.5 L 12.9 7.5 L 14.0 8.0 L 15.5 7.7 L 17.6 6.7 L 19.2 5.2 L 20.6 3.8 L 22.3 1.8 L 27.4 -7.3 L 21.3 4.2 L 21.0 5.8 L 21.3 7.1 L 22.2 7.8 L 23.4 7.9 L 25.0 7.3 L 26.7 6.2 L 28.9 4.1 L 30.8 1.3 L 32.1 -1.2 L 33.0 -4.0 L 33.4 -5.6 L 33.1 -7.3","0 20.0 M 13.8 6.1 L 14.6 6.1 L 14.7 5.3 L 14.0 5.1 L 13.2 6.1 L 13.3 7.2 L 14.9 8.1 L 17.1 7.4 L 19.3 5.2 L 21.7 2.1 L 24.4 -2.4 L 26.4 -4.9 L 28.1 -6.6 L 29.9 -7.6 L 31.2 -7.8 L 32.2 -7.4 L 32.7 -7.0 L 32.8 -6.2 L 32.5 -5.4 L 32.0 -5.2 L 31.6 -5.3 L 31.8 -6.0 L 32.2 -5.9 M 13.8 .2 L 16.8 -3.7 L 18.6 -5.9 L 20.4 -7.4 L 22.2 -7.8 L 23.3 -7.1 L 23.8 -5.8 L 23.5 -2.9 L 22.0 2.6 L 21.7 5.4 L 22.2 7.1 L 24.3 7.9 L 26.2 7.5 L 28.6 6.5 L 31.3 4.1 L 33.1 2.0 L 34.1 .5","0 17.0 M 18.5 -7.3 L 13.5 2.1 L 12.5 4.8 L 12.4 6.6 L 13.1 7.5 L 14.4 8.0 L 16.3 7.5 L 18.3 6.2 L 21.0 3.6 L 24.2 -.1 L 25.6 -2.0 L 28.5 -7.3 L 21.3 5.9 L 19.2 9.6 L 17.5 12.1 L 15.9 13.7 L 14.0 14.5 L 11.9 14.7 L 10.1 14.5 L 9.0 13.3 L 8.9 11.8 L 9.6 11.2 L 10.4 11.8 L 10.1 12.3","0 17.5 M 13.4 .4 L 17.2 -4.2 L 19.3 -6.5 L 20.2 -7.1 L 21.1 -7.5 L 22.0 -7.3 L 24.2 -6.2 L 25.6 -5.6 L 27.6 -5.9 L 28.6 -6.2 L 30.6 -7.3 L 13.4 7.8 L 15.5 6.1 L 17.2 5.8 L 19.2 6.3 L 20.4 6.9 L 21.8 7.6 L 23.8 7.7 L 25.9 7.2 L 29.4 3.9 L 32.1 .5","0 11.9 M 15.1 10.0 L 14.0 10.0 L 13.2 9.6 L 13.1 8.6 L 13.7 6.9 L 16.5 2.8 L 17.7 .5 L 18.1 -.7 L 18.0 -1.8 L 17.8 -2.9 L 18.4 -3.1 L 19.7 -3.9 L 21.4 -6.5 L 23.7 -11.4 L 24.4 -12.9 L 25.0 -13.6 L 25.8 -13.9 L 26.6 -13.8 L 27.5 -13.2","0 5.3 M 15.3 8.1 L 19.0 -12.7","0 11.7 M 12.7 9.5 L 13.8 9.9 L 15.3 9.9 L 16.5 8.7 L 17.3 6.1 L 18.8 2.9 L 19.7 1.2 L 21.1 -.2 L 22.2 -.5 L 22.7 -.8 L 22.5 -2.7 L 22.8 -4.3 L 24.1 -6.7 L 26.6 -10.5 L 27.5 -12.1 L 27.3 -13.2 L 26.6 -13.7 L 25.5 -13.8","0 13.2 M 13.5 2.1 L 14.5 .2 L 16.5 -1.6 L 18.3 -1.4 L 22.9 1.3 L 24.0 1.5 L 25.5 .9 L 26.5 -.2 L 27.6 -1.7","0 8.2 M 20.2 -8.0 L 21.5 -8.4 L 22.8 -9.5 L 23.3 -10.7 L 23.3 -12.2 L 22.5 -13.1 L 21.4 -13.6 L 19.7 -13.3 L 18.6 -12.5 L 17.9 -11.5 L 17.6 -10.3 L 17.9 -9.0 L 18.8 -8.2 L 20.2 -8.0"]
EMSDelight = ["-8 8","0 6.3 M 13.8 -13.6 L 13.8 1.8 M 13.3 6.5 L 13.2 7.9 L 14.2 7.8 L 14.2 6.5 L 13.3 6.5","0 9.4 M 13.2 -12.1 L 13.2 -6.7 M 17.8 -12.2 L 17.8 -6.8","0 22.6 M 20.4 -11.9 L 16.6 7.9 M 27.5 -11.7 L 23.6 8.0 M 12.6 1.1 L 30.2 1.1 M 13.8 -5.6 L 31.4 -5.5","0 15.4 M 23.2 -10.1 L 21.8 -11.0 L 19.8 -11.6 L 17.5 -11.5 L 14.8 -10.3 L 13.9 -8.3 L 14.4 -6.2 L 16.2 -4.5 L 19.5 -2.3 L 22.0 -.7 L 24.0 1.7 L 23.9 4.5 L 22.4 6.9 L 19.0 7.8 L 15.7 7.6 L 12.9 6.0 M 18.7 -14.3 L 18.7 10.7","0 22.6 M 18.3 -10.6 L 19.3 -8.5 L 19.3 -6.1 L 18.2 -4.2 L 16.2 -3.4 L 14.1 -3.7 L 12.6 -5.7 L 12.6 -8.0 L 13.5 -10.5 L 15.2 -11.6 L 17.2 -11.5 L 19.2 -10.2 L 21.0 -9.1 L 23.0 -9.3 L 25.0 -9.7 L 26.3 -11.2 L 26.6 -12.3 L 26.3 -13.1 L 25.7 -12.8 L 25.3 -11.5 L 24.9 -9.1 L 18.7 7.9 M 28.1 -.4 L 26.2 .1 L 25.0 2.2 L 24.6 4.0 L 25.0 6.1 L 26.5 7.6 L 28.3 7.9 L 29.9 7.3 L 31.0 6.0 L 31.5 3.8 L 31.2 1.7 L 30.4 .4 L 29.0 -.3 L 28.3 -.4","0 21.4 M 21.4 -11.2 L 19.7 -12.2 L 17.9 -12.6 L 15.7 -11.9 L 14.2 -10.4 L 14.1 -9.0 L 14.5 -6.9 L 15.9 -5.4 L 17.2 -4.6 L 18.9 -4.3 L 19.4 -4.6 L 19.0 -4.9 L 17.0 -4.7 L 15.1 -3.5 L 13.2 -1.3 L 12.6 1.6 L 13.1 4.6 L 14.8 6.4 L 17.9 7.8 L 21.2 7.3 L 23.8 5.5 L 24.8 3.2 L 24.7 1.6 L 24.5 .1 L 23.6 -.8 L 21.7 -1.2 L 20.4 -.5 L 23.5 -1.1 L 26.3 -1.0 L 29.0 -1.7 L 30.7 -3.2 L 30.8 -5.7 L 30.2 -7.5 L 28.7 -8.5 L 27.1 -9.2","0 4.6 M 13.1 -12.1 L 13.1 -6.7","0 8.1 M 17.7 -13.0 L 15.1 -9.3 L 13.5 -5.0 L 12.7 -.7 L 12.7 3.2 L 13.5 6.6 L 14.9 10.9 L 17.4 14.4","0 8.1 M 12.1 -13.1 L 14.6 -9.1 L 16.3 -3.4 L 16.9 2.1 L 16.4 5.9 L 15.3 9.6 L 13.0 13.4 L 12.4 14.1","0 11.4 M 12.9 -7.1 L 19.9 -11.0 M 13.0 -11.1 L 20.1 -7.1 M 16.5 -5.0 L 16.4 -13.1","0 14.5 M 12.6 .7 L 23.7 .7 M 18.1 -4.9 L 18.1 6.5","0 5.3 M 13.7 6.4 L 12.9 6.5 L 13.4 9.7 L 12.2 11.9","0 11.7 M 12.9 .7 L 20.2 .7","0 5.3 M 12.9 6.4 L 12.8 7.4 L 13.6 7.5 L 13.7 6.5 L 12.9 6.4","0 9.7 M 18.3 -13.2 L 13.0 11.8","0 18.4 M 20.0 -11.6 L 17.4 -11.0 L 15.0 -8.7 L 13.4 -5.0 L 13.2 -2.6 L 13.5 .8 L 14.1 3.3 L 15.2 5.0 L 16.8 6.7 L 18.4 7.7 L 20.8 7.7 L 23.2 6.7 L 25.5 4.1 L 26.7 .5 L 26.5 -3.9 L 25.9 -6.9 L 24.6 -9.0 L 23.4 -10.4 L 22.2 -11.2 L 20.0 -11.6","0 10.6 M 11.8 -4.6 L 17.6 -11.7 L 17.6 7.5","0 15.3 M 13.3 -8.6 L 14.8 -10.4 L 16.9 -11.3 L 19.4 -11.5 L 21.1 -10.8 L 22.6 -9.2 L 23.1 -7.5 L 22.8 -5.4 L 21.7 -3.8 L 13.2 6.0 L 12.9 6.6 L 12.9 7.3 L 24.1 7.4","0 15.9 M 13.4 -11.2 L 23.1 -11.2 L 23.2 -10.6 L 16.5 -2.8 L 15.3 -2.3 L 15.3 -2.7 L 16.0 -3.5 L 17.6 -3.8 L 20.1 -3.6 L 22.7 -2.0 L 24.1 .7 L 23.8 4.0 L 22.1 6.6 L 19.4 8.0 L 16.2 7.6 L 14.5 6.7 L 13.0 5.2","0 16.0 M 22.0 7.5 L 21.9 -11.6 L 20.3 -10.5 L 12.1 .3 L 12.8 .7 L 25.3 .6","0 16.0 M 23.5 -11.3 L 13.7 -11.0 L 14.1 -8.0 L 14.0 -5.4 L 13.8 -2.1 L 15.9 -3.5 L 18.5 -4.4 L 20.9 -4.1 L 23.0 -2.7 L 24.5 .3 L 24.2 3.2 L 23.3 5.5 L 20.9 7.6 L 17.6 7.7 L 15.3 6.8 L 13.0 4.3","0 16.0 M 23.7 -11.3 L 19.8 -10.9 L 16.1 -8.4 L 13.6 -3.8 L 13.1 .4 L 14.0 4.6 L 16.5 7.4 L 20.6 7.8 L 23.4 5.9 L 24.8 2.7 L 24.1 -1.1 L 21.9 -3.4 L 19.0 -4.0 L 16.8 -3.4 L 15.6 -2.1 L 13.8 -.5","0 13.6 M 12.2 -11.3 L 22.8 -11.2 L 22.7 -10.2 L 15.2 6.7 L 15.2 7.6","0 16.3 M 18.8 -11.7 L 16.1 -11.1 L 14.4 -8.9 L 14.3 -6.8 L 16.2 -4.8 L 22.3 -1.4 L 24.0 .4 L 24.6 3.2 L 23.8 5.5 L 21.9 7.4 L 19.1 8.1 L 16.8 7.6 L 14.6 6.1 L 13.2 3.9 L 13.3 1.4 L 15.0 -.9 L 21.6 -4.8 L 23.5 -6.9 L 23.5 -9.3 L 22.0 -10.9 L 20.9 -11.4 L 18.8 -11.7","0 16.4 M 13.8 7.5 L 16.3 7.5 L 19.6 6.0 L 22.2 3.5 L 23.7 .5 L 24.2 -1.8 L 24.4 -4.5 L 24.0 -7.9 L 22.6 -10.1 L 20.7 -11.5 L 18.1 -11.8 L 15.4 -10.6 L 13.4 -8.1 L 12.9 -4.8 L 13.9 -2.2 L 16.1 -.1 L 19.0 .1 L 21.6 -.8 L 22.9 -2.5 L 24.2 -4.9","0 5.9 M 13.4 -5.3 L 13.6 -4.0 L 14.1 -4.1 L 14.1 -5.2 L 13.4 -5.3 M 13.2 6.4 L 13.1 7.7 L 14.0 7.7 L 14.0 6.3 L 13.2 6.4","0 6.2 M 13.5 -5.5 L 13.3 -4.0 L 14.2 -4.1 L 14.4 -5.4 L 13.5 -5.5 M 13.5 7.4 L 13.6 6.4 L 14.6 6.5 L 14.5 7.7 L 13.9 9.2 L 12.6 11.9","0 15.0 M 23.2 -5.7 L 12.5 -.3 L 23.2 5.4","0 16.6 M 13.3 -1.4 L 24.5 -1.4 M 13.1 2.8 L 24.6 2.8","0 15.0 M 13.4 -5.7 L 24.0 -.6 L 23.9 -.2 L 13.4 5.1","0 12.3 M 12.7 -11.0 L 14.2 -12.4 L 16.6 -13.0 L 18.8 -12.5 L 20.1 -11.1 L 21.0 -9.0 L 21.0 -7.2 L 19.4 -5.0 L 17.3 -2.8 L 16.3 -1.5 L 15.8 -.1 L 15.9 1.5 M 15.4 6.5 L 15.4 7.7 L 16.4 7.6 L 16.3 6.4 L 15.4 6.5","0 28.4 M 29.9 -2.8 L 26.7 -4.8 L 23.7 -4.8 L 20.7 -2.8 L 19.6 .0 L 19.4 2.6 L 20.0 5.0 L 21.9 7.0 L 24.5 7.7 L 27.2 6.3 L 28.8 3.8 L 29.7 1.6 L 29.8 -4.8 L 29.6 4.4 L 30.2 6.5 L 31.6 7.5 L 33.2 7.6 L 35.2 6.5 L 36.5 4.5 L 37.0 2.1 L 36.9 -1.2 L 36.5 -3.4 L 35.4 -5.9 L 33.8 -8.1 L 31.6 -9.9 L 27.8 -11.4 L 24.3 -11.6 L 20.0 -10.3 L 16.3 -7.3 L 14.1 -4.0 L 13.0 .0 L 13.1 4.0 L 13.8 7.1 L 15.8 10.4 L 18.7 13.0 L 22.5 14.1 L 25.9 14.0 L 28.7 13.0 L 30.7 11.7","0 17.9 M 12.1 7.8 L 19.7 -13.0 L 27.1 7.6 M 12.1 -.1 L 27.1 -.1","0 19.0 M 13.1 -11.7 L 15.8 -13.4 L 20.9 -13.5 L 24.5 -12.0 L 26.2 -9.4 L 25.4 -6.2 L 23.6 -4.3 L 21.2 -3.3 L 18.4 -2.8 L 15.8 -3.1 L 15.0 -3.7 L 17.1 -4.1 L 21.0 -3.8 L 25.4 -2.4 L 27.3 .6 L 27.2 4.5 L 24.0 7.2 L 19.5 8.0 L 16.5 7.9 L 13.4 6.7 M 15.0 -13.0 L 15.0 7.3","0 19.4 M 28.0 5.2 L 26.5 6.6 L 24.7 7.5 L 21.8 7.9 L 18.3 6.9 L 15.5 4.7 L 13.8 1.8 L 13.2 -1.3 L 13.4 -4.6 L 14.0 -7.5 L 16.1 -10.8 L 18.9 -12.7 L 21.5 -13.2 L 23.5 -13.3 L 25.3 -12.8 L 26.6 -12.0 L 27.5 -11.3","0 20.5 M 15.0 7.2 L 14.9 -12.6 L 13.4 -12.1 L 16.1 -12.8 L 19.7 -12.8 L 22.8 -12.0 L 25.5 -10.1 L 27.6 -6.7 L 28.3 -3.0 L 27.8 .8 L 26.0 4.1 L 23.0 6.4 L 19.9 7.5 L 16.8 7.7 L 14.1 7.2 L 12.7 6.5","0 16.5 M 25.4 -12.9 L 14.2 -12.9 L 14.8 -12.9 L 14.8 7.5 L 25.6 7.5 M 12.3 -3.5 L 24.0 -3.5","0 16.1 M 25.4 -12.9 L 14.1 -12.9 L 14.7 -12.9 L 14.7 7.8 M 12.4 -3.5 L 23.4 -3.5","0 20.8 M 28.1 -10.4 L 26.3 -11.9 L 23.5 -13.0 L 20.1 -13.0 L 16.7 -11.2 L 14.1 -7.4 L 13.0 -2.9 L 13.5 .8 L 14.9 3.8 L 17.2 6.5 L 20.9 8.0 L 23.9 7.5 L 26.4 6.0 L 28.4 3.4 L 29.0 .9 L 29.0 -.9 L 29.0 -2.3 L 20.3 -2.3","0 20.1 M 14.6 -13.0 L 14.6 7.7 M 27.2 -13.1 L 27.2 7.7 M 12.1 -3.4 L 29.5 -3.5","0 12.1 M 12.2 -12.9 L 21.3 -12.9 L 16.7 -12.9 L 16.7 7.4 L 11.7 7.4 L 21.2 7.4","0 15.0 M 15.2 -13.1 L 24.3 -13.1 L 21.8 -13.1 L 21.8 2.7 L 21.4 4.5 L 20.2 6.1 L 18.8 7.6 L 16.8 7.8 L 15.0 7.6 L 13.5 6.8 L 12.3 5.6","0 17.5 M 14.3 -13.1 L 14.3 7.7 M 24.9 -13.5 L 23.7 -9.1 L 21.9 -5.6 L 19.6 -3.1 L 17.4 -2.5 L 15.4 -2.7 L 14.3 -3.3 L 16.9 -3.9 L 18.3 -4.0 L 19.5 -3.3 L 20.7 -1.5 L 25.8 6.9 L 26.6 7.6 L 27.3 7.6","0 15.6 M 14.4 -13.6 L 14.4 7.6 L 24.8 7.6","0 23.3 M 14.4 7.9 L 14.4 -13.0 L 22.5 3.8 L 30.4 -13.0 L 30.4 8.0","0 19.8 M 14.3 7.9 L 14.4 -13.1 L 26.4 7.9 L 26.6 7.6 L 26.5 -13.1","0 21.8 M 13.3 -6.3 L 12.7 -2.9 L 13.1 .3 L 14.5 3.6 L 17.3 6.4 L 21.0 7.7 L 25.0 7.3 L 27.7 5.7 L 30.0 2.5 L 30.8 -1.1 L 30.8 -4.7 L 29.9 -8.1 L 28.6 -10.7 L 26.9 -12.2 L 24.3 -13.1 L 21.3 -13.4 L 18.2 -12.6 L 15.6 -10.4 L 13.3 -6.3","0 17.3 M 14.8 7.6 L 14.8 -12.7 L 17.7 -13.5 L 21.7 -13.1 L 24.7 -11.6 L 26.3 -8.4 L 26.2 -5.3 L 25.0 -3.2 L 22.4 -1.7 L 19.4 -1.2 L 14.8 -1.8","0 21.3 M 25.0 6.7 L 23.1 7.6 L 19.5 7.6 L 15.9 5.4 L 13.6 1.2 L 12.9 -3.2 L 13.8 -8.0 L 16.6 -11.7 L 20.2 -13.4 L 24.1 -13.0 L 27.8 -10.1 L 29.3 -6.1 L 29.9 -1.1 L 28.3 3.6 L 24.8 6.4 L 22.1 2.1 L 28.0 11.8","0 18.3 M 14.7 7.7 L 14.9 -12.7 L 13.1 -11.9 L 15.8 -13.0 L 18.3 -13.4 L 21.5 -13.4 L 24.2 -11.8 L 25.7 -9.5 L 26.1 -6.9 L 24.8 -4.2 L 23.1 -2.6 L 21.7 -2.0 L 18.6 -2.6 L 15.1 -2.0 L 17.9 -1.5 L 21.4 -1.9 L 22.4 1.1 L 24.3 4.5 L 26.0 7.0 L 26.7 7.5 L 27.8 7.4","0 15.4 M 12.5 5.2 L 14.3 6.5 L 17.0 7.6 L 20.3 7.4 L 22.8 5.8 L 24.2 3.9 L 24.3 1.0 L 22.6 -1.3 L 20.8 -2.8 L 17.7 -4.4 L 15.1 -6.1 L 13.7 -7.5 L 13.4 -9.8 L 14.3 -11.7 L 17.0 -13.0 L 19.7 -13.1 L 21.4 -12.5 L 23.1 -11.3","0 14.9 M 11.3 -13.0 L 11.5 -13.0 L 24.4 -13.0 L 18.1 -13.0 L 18.1 7.9","0 19.3 M 14.1 -13.4 L 14.1 2.2 L 14.9 4.7 L 16.4 6.6 L 19.1 7.9 L 22.4 7.8 L 25.0 5.9 L 26.0 3.1 L 26.6 .9 L 26.6 -13.3","0 18.0 M 26.9 -13.3 L 19.9 7.9 L 11.9 -13.1","0 26.1 M 12.0 -13.5 L 18.7 7.8 L 23.7 -7.0 L 28.8 8.0 L 35.5 -13.6","0 17.5 M 12.2 -13.0 L 13.3 -13.1 L 14.6 -11.3 L 25.5 6.8 L 26.5 7.8 L 27.5 7.6 M 12.1 7.9 L 25.7 -13.3","0 16.0 M 12.0 -13.3 L 19.0 -1.9 L 19.0 8.0 L 19.0 -1.8 L 25.9 -13.3","0 16.1 M 12.3 -13.0 L 24.6 -13.0 L 12.4 7.3 L 25.3 7.3","0 9.5 M 19.1 -12.9 L 13.9 -12.9 L 13.9 13.8 L 19.1 13.8","0 9.7 M 13.0 -13.3 L 18.3 11.9","0 9.2 M 12.0 -12.7 L 17.2 -12.7 L 17.2 13.7 L 11.9 13.7","0 14.3 M 12.5 -3.5 L 17.8 -12.8 L 23.5 -3.3","0 15.8 M 12.4 13.8 L 24.6 13.8","0 7.5 M 13.3 -12.9 L 14.1 -11.4 L 15.8 -9.8","0 15.8 M 23.3 -3.6 L 21.3 -5.0 L 18.6 -6.0 L 15.6 -5.0 L 13.3 -2.0 L 12.7 .5 L 13.1 3.5 L 14.5 6.5 L 17.3 7.5 L 20.3 6.6 L 22.1 4.5 L 23.3 2.1 L 23.4 -5.6 L 23.4 5.9 L 23.7 7.0 L 24.2 7.4 L 24.9 7.4","0 15.3 M 13.4 -13.1 L 13.7 1.5 L 13.3 7.5 L 14.4 -2.2 L 17.1 -5.0 L 20.2 -5.7 L 22.4 -4.6 L 23.7 -1.9 L 23.9 2.1 L 22.9 5.5 L 21.2 6.9 L 17.9 7.6 L 15.6 6.7 L 14.6 5.7 L 14.0 4.1","0 14.2 M 23.3 -4.2 L 21.3 -5.6 L 18.4 -5.9 L 15.9 -5.1 L 13.8 -2.9 L 12.9 -.4 L 13.2 3.4 L 15.1 6.3 L 17.8 7.8 L 20.3 7.8 L 23.4 6.1","0 16.5 M 25.9 7.4 L 24.9 7.3 L 24.1 6.4 L 23.8 4.2 L 23.9 -2.8 L 21.6 -5.0 L 18.8 -5.8 L 16.0 -5.0 L 13.8 -3.1 L 12.8 -.2 L 12.9 2.4 L 13.4 4.5 L 15.3 6.8 L 17.9 7.7 L 20.2 6.9 L 22.2 4.9 L 23.1 3.4 L 23.8 1.3 L 24.2 -12.9","0 15.1 M 11.7 .1 L 15.5 1.1 L 19.5 1.4 L 22.1 .6 L 23.8 -1.6 L 23.4 -3.4 L 21.9 -5.2 L 18.8 -5.9 L 16.2 -5.0 L 14.4 -2.6 L 13.5 -.7 L 13.5 2.4 L 14.3 5.0 L 16.9 7.3 L 19.2 7.8 L 21.4 7.6 L 23.8 6.0","0 8.5 M 12.1 11.3 L 13.9 9.2 L 14.5 8.1 L 14.2 -9.3 L 14.8 -11.5 L 15.8 -12.7 L 16.9 -13.1 L 17.8 -13.0 L 19.4 -12.2 M 11.5 -5.5 L 18.6 -5.5","0 15.5 M 23.5 -3.1 L 20.8 -5.3 L 17.6 -5.7 L 14.9 -4.3 L 13.0 -1.6 L 12.7 2.1 L 13.6 5.3 L 15.1 7.1 L 17.4 7.7 L 19.3 7.1 L 21.1 5.7 L 22.5 3.5 L 23.5 1.0 L 23.5 -5.6 L 23.6 8.2 L 23.0 10.3 L 21.6 12.6 L 19.4 14.0 L 17.3 14.2 L 15.6 13.8 L 13.5 13.0","0 16.1 M 13.5 -12.9 L 13.8 7.6 L 13.3 7.0 L 14.3 -1.1 L 15.9 -3.6 L 17.9 -5.3 L 20.2 -5.9 L 21.9 -5.1 L 23.3 -4.1 L 23.7 -1.2 L 23.6 .3 L 23.6 6.5 L 24.2 7.3 L 25.4 7.5","0 5.6 M 13.7 -5.9 L 13.7 7.7 M 13.0 -12.0 L 13.0 -10.7 L 14.0 -10.6 L 13.9 -12.0 L 13.0 -12.0","0 5.7 M 13.5 -5.9 L 13.5 9.9 L 12.6 11.5 L 11.3 13.0 M 13.1 -11.7 L 13.2 -10.3 L 14.0 -10.5 L 14.1 -11.7 L 13.1 -11.7","0 14.1 M 13.4 -13.0 L 13.7 -5.3 L 13.6 1.3 L 13.4 7.7 L 13.6 -1.3 L 17.3 -4.8 L 20.3 -5.8 L 22.7 -3.9 L 22.4 -1.1 L 20.7 .2 L 19.2 1.3 L 17.7 1.7 L 16.9 1.3 L 16.8 .6 L 17.7 .7 L 18.5 1.6 L 21.6 6.4 L 22.4 7.6 L 23.3 7.5","0 5.9 M 13.7 -12.9 L 13.7 7.7","0 24.6 M 13.5 -5.5 L 13.9 6.8 L 13.6 7.7 L 13.2 7.4 L 13.6 1.4 L 15.2 -3.0 L 18.2 -5.8 L 21.3 -5.3 L 22.9 -2.9 L 23.3 -.9 L 23.6 7.2 L 23.0 8.0 L 22.7 7.7 L 23.6 -1.1 L 25.3 -3.9 L 28.0 -5.7 L 31.0 -4.9 L 32.4 -2.3 L 32.5 2.0 L 32.4 6.3 L 32.9 7.5 L 33.9 7.5","0 16.4 M 13.6 -5.7 L 14.1 7.5 L 13.4 7.7 L 13.2 6.6 L 14.1 -.7 L 16.6 -4.3 L 18.9 -5.7 L 21.7 -5.3 L 23.4 -3.4 L 24.0 -.4 L 23.8 6.5 L 24.3 7.4 L 25.1 7.4","0 15.7 M 18.7 -5.9 L 16.0 -5.4 L 13.5 -2.8 L 12.6 1.2 L 13.6 4.8 L 16.3 7.2 L 19.3 7.9 L 22.5 6.1 L 24.3 2.3 L 24.1 -1.6 L 22.2 -4.7 L 20.5 -5.6 L 18.7 -5.9","0 16.2 M 13.4 -5.4 L 14.0 3.8 L 14.3 13.4 L 13.3 14.0 L 14.0 1.9 L 14.4 -1.6 L 17.5 -5.0 L 20.7 -5.7 L 23.4 -4.3 L 24.8 -.4 L 24.3 3.5 L 22.7 6.4 L 20.1 7.5 L 17.2 7.5 L 13.9 5.5","0 15.2 M 23.1 -5.3 L 23.1 -.1 L 22.1 4.2 L 18.6 7.6 L 14.7 7.2 L 12.1 2.6 L 13.3 -2.8 L 16.4 -5.7 L 20.1 -5.7 L 22.9 -3.3 L 23.2 14.1","0 10.9 M 13.5 -5.4 L 13.5 7.4 L 13.5 -.8 L 16.2 -4.2 L 18.1 -5.7 L 19.6 -5.7 L 20.6 -4.8","0 12.7 M 21.2 -4.5 L 18.1 -5.9 L 15.4 -5.5 L 13.5 -3.3 L 14.2 -1.1 L 18.0 .6 L 21.3 2.4 L 21.9 4.4 L 20.7 6.6 L 17.3 7.7 L 14.1 6.9 L 12.7 5.6","0 9.1 M 14.6 -10.1 L 14.7 6.2 L 15.2 7.4 L 16.6 7.6 L 18.6 6.8 M 11.5 -5.4 L 18.5 -5.3","0 16.5 M 13.6 -5.6 L 13.7 -.6 L 13.7 3.7 L 14.7 6.4 L 17.1 7.7 L 19.4 7.4 L 21.8 5.0 L 23.5 2.3 L 23.4 -5.7 L 23.9 -5.9 L 24.0 -1.3 L 23.6 3.7 L 23.9 6.0 L 24.5 7.6 L 25.5 7.6","0 13.6 M 11.6 -5.8 L 16.8 7.5 L 17.6 7.6 L 22.6 -5.6","0 22.4 M 12.2 -5.7 L 16.6 7.6 L 17.4 7.6 L 21.9 -5.2 L 22.4 -5.1 L 26.5 7.4 L 26.9 7.4 L 31.7 -5.7","0 13.6 M 11.9 -5.7 L 13.2 -5.4 L 21.9 7.1 L 22.9 7.7 M 12.3 7.8 L 22.0 -5.9","0 15.9 M 13.4 -5.5 L 13.6 -4.7 L 13.8 4.4 L 14.7 6.4 L 16.5 7.7 L 18.7 7.7 L 21.4 5.6 L 22.9 3.5 L 23.8 .7 L 24.1 -5.5 L 23.9 -5.8 L 23.4 -5.3 L 23.8 8.6 L 22.9 11.6 L 20.8 13.4 L 18.9 14.2 L 15.9 14.0 L 13.2 12.8","0 13.3 M 12.8 -5.4 L 22.3 -5.4 L 12.6 7.4 L 23.0 7.4","0 8.1 M 16.8 -13.0 L 15.4 -12.4 L 15.2 -11.1 L 15.5 -3.6 L 15.1 -1.8 L 14.0 .4 L 12.5 1.7 L 11.6 1.5 L 11.4 .5 L 12.4 .0 L 13.6 .4 L 14.7 1.8 L 15.2 3.9 L 15.0 10.4 L 15.2 13.2 L 16.6 14.2","0 5.6 M 13.4 -14.4 L 13.4 15.5","0 8.1 M 12.5 -12.9 L 14.1 -12.4 L 14.5 -11.6 L 14.6 -9.5 L 14.3 -3.0 L 14.9 -1.4 L 15.8 .2 L 17.0 1.6 L 18.2 1.3 L 18.1 .2 L 17.0 -.1 L 15.5 .8 L 14.7 2.5 L 14.4 3.6 L 14.7 12.5 L 14.0 13.7 L 12.9 13.9","0 15.3 M 13.3 1.2 L 14.4 .3 L 15.7 -.3 L 17.6 -.2 L 19.3 .3 L 21.0 1.2 L 22.7 1.1 L 24.4 -.1","0 9.0 M 15.0 -11.9 L 13.3 -10.9 L 12.6 -8.4 L 13.1 -5.9 L 15.2 -4.7 L 17.6 -6.1 L 17.9 -8.8 L 17.0 -11.2 L 15.0 -11.9"]
EMSDelightSwashCaps = ["-8 8","0 6.3 M 13.8 -13.6 L 13.8 1.8 M 13.3 6.5 L 13.2 7.9 L 14.2 7.8 L 14.2 6.5 L 13.3 6.5","0 9.4 M 13.2 -12.1 L 13.2 -6.7 M 17.8 -12.2 L 17.8 -6.8","0 22.6 M 20.4 -11.9 L 16.6 7.9 M 27.5 -11.7 L 23.6 8.0 M 12.6 1.1 L 30.2 1.1 M 13.8 -5.6 L 31.4 -5.5","0 15.4 M 23.2 -10.1 L 21.8 -11.0 L 19.8 -11.6 L 17.5 -11.5 L 14.8 -10.3 L 13.9 -8.3 L 14.4 -6.2 L 16.2 -4.5 L 19.5 -2.3 L 22.0 -.7 L 24.0 1.7 L 23.9 4.5 L 22.4 6.9 L 19.0 7.8 L 15.7 7.6 L 12.9 6.0 M 18.7 -14.3 L 18.7 10.7","0 22.6 M 18.3 -10.6 L 19.3 -8.5 L 19.3 -6.1 L 18.2 -4.2 L 16.2 -3.4 L 14.1 -3.7 L 12.6 -5.7 L 12.6 -8.0 L 13.5 -10.5 L 15.2 -11.6 L 17.2 -11.5 L 19.2 -10.2 L 21.0 -9.1 L 23.0 -9.3 L 25.0 -9.7 L 26.3 -11.2 L 26.6 -12.3 L 26.3 -13.1 L 25.7 -12.8 L 25.3 -11.5 L 24.9 -9.1 L 18.7 7.9 M 28.1 -.4 L 26.2 .1 L 25.0 2.2 L 24.6 4.0 L 25.0 6.1 L 26.5 7.6 L 28.3 7.9 L 29.9 7.3 L 31.0 6.0 L 31.5 3.8 L 31.2 1.7 L 30.4 .4 L 29.0 -.3 L 28.3 -.4","0 21.4 M 21.4 -11.2 L 19.7 -12.2 L 17.9 -12.6 L 15.7 -11.9 L 14.2 -10.4 L 14.1 -9.0 L 14.5 -6.9 L 15.9 -5.4 L 17.2 -4.6 L 18.9 -4.3 L 19.4 -4.6 L 19.0 -4.9 L 17.0 -4.7 L 15.1 -3.5 L 13.2 -1.3 L 12.6 1.6 L 13.1 4.6 L 14.8 6.4 L 17.9 7.8 L 21.2 7.3 L 23.8 5.5 L 24.8 3.2 L 24.7 1.6 L 24.5 .1 L 23.6 -.8 L 21.7 -1.2 L 20.4 -.5 L 23.5 -1.1 L 26.3 -1.0 L 29.0 -1.7 L 30.7 -3.2 L 30.8 -5.7 L 30.2 -7.5 L 28.7 -8.5 L 27.1 -9.2","0 4.6 M 13.1 -12.1 L 13.1 -6.7","0 8.1 M 17.7 -13.0 L 15.1 -9.3 L 13.5 -5.0 L 12.7 -.7 L 12.7 3.2 L 13.5 6.6 L 14.9 10.9 L 17.4 14.4","0 8.1 M 12.1 -13.1 L 14.6 -9.1 L 16.3 -3.4 L 16.9 2.1 L 16.4 5.9 L 15.3 9.6 L 13.0 13.4 L 12.4 14.1","0 11.4 M 12.9 -7.1 L 19.9 -11.0 M 13.0 -11.1 L 20.1 -7.1 M 16.5 -5.0 L 16.4 -13.1","0 14.5 M 12.6 .7 L 23.7 .7 M 18.1 -4.9 L 18.1 6.5","0 5.3 M 13.7 6.4 L 12.9 6.5 L 13.4 9.7 L 12.2 11.9","0 11.7 M 12.9 .7 L 20.2 .7","0 5.3 M 12.9 6.4 L 12.8 7.4 L 13.6 7.5 L 13.7 6.5 L 12.9 6.4","0 9.7 M 18.3 -13.2 L 13.0 11.8","0 18.4 M 20.0 -11.6 L 17.4 -11.0 L 15.0 -8.7 L 13.4 -5.0 L 13.2 -2.6 L 13.5 .8 L 14.1 3.3 L 15.2 5.0 L 16.8 6.7 L 18.4 7.7 L 20.8 7.7 L 23.2 6.7 L 25.5 4.1 L 26.7 .5 L 26.5 -3.9 L 25.9 -6.9 L 24.6 -9.0 L 23.4 -10.4 L 22.2 -11.2 L 20.0 -11.6","0 10.6 M 11.8 -4.6 L 17.6 -11.7 L 17.6 7.5","0 15.3 M 13.3 -8.6 L 14.8 -10.4 L 16.9 -11.3 L 19.4 -11.5 L 21.1 -10.8 L 22.6 -9.2 L 23.1 -7.5 L 22.8 -5.4 L 21.7 -3.8 L 13.2 6.0 L 12.9 6.6 L 12.9 7.3 L 24.1 7.4","0 15.9 M 13.4 -11.2 L 23.1 -11.2 L 23.2 -10.6 L 16.5 -2.8 L 15.3 -2.3 L 15.3 -2.7 L 16.0 -3.5 L 17.6 -3.8 L 20.1 -3.6 L 22.7 -2.0 L 24.1 .7 L 23.8 4.0 L 22.1 6.6 L 19.4 8.0 L 16.2 7.6 L 14.5 6.7 L 13.0 5.2","0 16.0 M 22.0 7.5 L 21.9 -11.6 L 20.3 -10.5 L 12.1 .3 L 12.8 .7 L 25.3 .6","0 16.0 M 23.5 -11.3 L 13.7 -11.0 L 14.1 -8.0 L 14.0 -5.4 L 13.8 -2.1 L 15.9 -3.5 L 18.5 -4.4 L 20.9 -4.1 L 23.0 -2.7 L 24.5 .3 L 24.2 3.2 L 23.3 5.5 L 20.9 7.6 L 17.6 7.7 L 15.3 6.8 L 13.0 4.3","0 16.0 M 23.7 -11.3 L 19.8 -10.9 L 16.1 -8.4 L 13.6 -3.8 L 13.1 .4 L 14.0 4.6 L 16.5 7.4 L 20.6 7.8 L 23.4 5.9 L 24.8 2.7 L 24.1 -1.1 L 21.9 -3.4 L 19.0 -4.0 L 16.8 -3.4 L 15.6 -2.1 L 13.8 -.5","0 13.6 M 12.2 -11.3 L 22.8 -11.2 L 22.7 -10.2 L 15.2 6.7 L 15.2 7.6","0 16.3 M 18.8 -11.7 L 16.1 -11.1 L 14.4 -8.9 L 14.3 -6.8 L 16.2 -4.8 L 22.3 -1.4 L 24.0 .4 L 24.6 3.2 L 23.8 5.5 L 21.9 7.4 L 19.1 8.1 L 16.8 7.6 L 14.6 6.1 L 13.2 3.9 L 13.3 1.4 L 15.0 -.9 L 21.6 -4.8 L 23.5 -6.9 L 23.5 -9.3 L 22.0 -10.9 L 20.9 -11.4 L 18.8 -11.7","0 16.4 M 13.8 7.5 L 16.3 7.5 L 19.6 6.0 L 22.2 3.5 L 23.7 .5 L 24.2 -1.8 L 24.4 -4.5 L 24.0 -7.9 L 22.6 -10.1 L 20.7 -11.5 L 18.1 -11.8 L 15.4 -10.6 L 13.4 -8.1 L 12.9 -4.8 L 13.9 -2.2 L 16.1 -.1 L 19.0 .1 L 21.6 -.8 L 22.9 -2.5 L 24.2 -4.9","0 5.9 M 13.4 -5.3 L 13.6 -4.0 L 14.1 -4.1 L 14.1 -5.2 L 13.4 -5.3 M 13.2 6.4 L 13.1 7.7 L 14.0 7.7 L 14.0 6.3 L 13.2 6.4","0 6.2 M 13.5 -5.5 L 13.3 -4.0 L 14.2 -4.1 L 14.4 -5.4 L 13.5 -5.5 M 13.5 7.4 L 13.6 6.4 L 14.6 6.5 L 14.5 7.7 L 13.9 9.2 L 12.6 11.9","0 15.0 M 23.2 -5.7 L 12.5 -.3 L 23.2 5.4","0 16.6 M 13.3 -1.4 L 24.5 -1.4 M 13.1 2.8 L 24.6 2.8","0 15.0 M 13.4 -5.7 L 24.0 -.6 L 23.9 -.2 L 13.4 5.1","0 12.3 M 12.7 -11.0 L 14.2 -12.4 L 16.6 -13.0 L 18.8 -12.5 L 20.1 -11.1 L 21.0 -9.0 L 21.0 -7.2 L 19.4 -5.0 L 17.3 -2.8 L 16.3 -1.5 L 15.8 -.1 L 15.9 1.5 M 15.4 6.5 L 15.4 7.7 L 16.4 7.6 L 16.3 6.4 L 15.4 6.5","0 28.4 M 29.9 -2.8 L 26.7 -4.8 L 23.7 -4.8 L 20.7 -2.8 L 19.6 .0 L 19.4 2.6 L 20.0 5.0 L 21.9 7.0 L 24.5 7.7 L 27.2 6.3 L 28.8 3.8 L 29.7 1.6 L 29.8 -4.8 L 29.6 4.4 L 30.2 6.5 L 31.6 7.5 L 33.2 7.6 L 35.2 6.5 L 36.5 4.5 L 37.0 2.1 L 36.9 -1.2 L 36.5 -3.4 L 35.4 -5.9 L 33.8 -8.1 L 31.6 -9.9 L 27.8 -11.4 L 24.3 -11.6 L 20.0 -10.3 L 16.3 -7.3 L 14.1 -4.0 L 13.0 .0 L 13.1 4.0 L 13.8 7.1 L 15.8 10.4 L 18.7 13.0 L 22.5 14.1 L 25.9 14.0 L 28.7 13.0 L 30.7 11.7","0 22.9 M 31.2 .5 L 28.1 -.7 L 23.3 -.9 L 19.9 -.7 L 16.7 .3 L 14.4 1.6 L 13.1 3.1 L 12.2 5.0 L 12.4 6.5 L 13.0 7.5 L 14.8 8.0 L 16.8 6.5 L 18.0 3.7 L 23.5 -12.6 L 24.6 -12.6 L 31.4 7.3 L 32.1 7.6","0 20.9 M 12.3 5.0 L 12.6 5.1 L 15.7 6.8 L 19.2 7.7 L 23.3 7.6 L 26.8 6.0 L 28.8 4.0 L 29.4 2.4 L 29.4 .3 L 28.3 -1.9 L 25.9 -3.8 L 22.8 -5.0 L 19.5 -5.3 L 16.7 -5.3 L 14.4 -4.8 L 13.1 -3.8 L 13.1 -2.7 L 14.3 -1.5 L 16.2 -1.3 L 19.1 -1.6 L 22.4 -2.6 L 24.5 -3.8 L 27.1 -6.4 L 27.9 -8.1 L 27.8 -9.4 L 26.7 -11.5 L 24.5 -12.7 L 21.3 -13.1 L 19.2 -12.9 L 17.4 -12.4 L 16.8 -11.7 L 17.1 4.0","0 19.4 M 22.8 -9.3 L 22.1 -7.8 L 22.3 -5.9 L 23.9 -4.7 L 25.9 -4.8 L 27.4 -6.0 L 27.9 -8.1 L 27.1 -10.3 L 26.1 -11.7 L 24.1 -12.8 L 21.5 -13.2 L 18.9 -12.7 L 16.1 -10.8 L 14.0 -7.5 L 13.4 -4.6 L 13.2 -1.3 L 13.8 1.8 L 15.5 4.7 L 18.3 6.9 L 21.8 7.9 L 24.7 7.5 L 26.5 6.6 L 28.0 5.2","0 23.6 M 18.3 2.5 L 18.2 -12.6 L 16.7 -12.1 L 19.5 -12.8 L 23.0 -12.8 L 26.1 -12.0 L 28.8 -10.1 L 30.9 -6.7 L 31.6 -3.0 L 31.1 .8 L 29.3 4.1 L 26.3 6.4 L 23.2 7.5 L 20.1 7.7 L 16.9 7.0 L 14.2 5.0 L 12.9 2.0 L 13.5 -1.0 L 15.6 -3.6 L 17.6 -4.3 L 19.3 -4.3 L 21.0 -4.0 L 23.4 -1.9","0 17.9 M 25.6 -11.1 L 23.0 -12.6 L 19.9 -13.2 L 16.8 -12.0 L 15.3 -10.2 L 14.9 -7.5 L 16.0 -5.2 L 18.0 -3.3 L 20.7 -2.6 L 22.7 -2.8 L 23.5 -3.6 L 23.6 -4.3 L 23.5 -4.9 L 22.4 -5.6 L 20.6 -5.7 L 19.3 -5.6 L 17.6 -4.7 L 15.5 -3.5 L 13.5 -1.1 L 13.0 1.9 L 14.0 4.6 L 16.5 6.9 L 20.6 7.8 L 25.0 6.9 L 27.4 5.0","0 17.9 M 16.5 7.6 L 16.6 -10.7 L 16.0 -12.4 L 15.3 -13.2 L 14.4 -13.8 L 12.9 -13.4 L 12.3 -12.0 L 12.5 -10.8 L 13.5 -10.1 L 15.1 -9.8 L 18.0 -9.5 L 20.9 -9.9 L 23.8 -10.9 L 26.2 -12.0 L 27.9 -13.3 M 14.6 -3.2 L 18.2 -2.5 L 20.4 -2.3 L 24.7 -3.2","0 22.0 M 27.8 -10.4 L 26.1 -11.9 L 23.2 -13.0 L 19.9 -13.0 L 16.5 -11.2 L 13.8 -7.4 L 12.7 -2.9 L 13.3 .8 L 14.6 3.8 L 17.0 6.5 L 20.7 8.0 L 23.7 7.5 L 26.2 6.0 L 28.1 3.4 L 28.8 .9 L 28.9 -.9 L 28.3 -2.3 L 26.3 -3.5 L 22.8 -3.9 L 21.2 -2.9 L 20.7 -1.8 L 21.0 -.7 L 22.6 -.3 L 25.0 -.3 L 27.3 -.7 L 29.9 -1.8 L 31.8 -3.0","0 20.1 M 14.6 -13.0 L 14.6 7.7 M 27.2 -13.1 L 27.2 7.7 M 12.5 -3.4 L 15.6 -2.0 L 19.1 -1.7 L 22.9 -2.2 L 25.3 -3.3 L 26.9 -4.6","0 16.7 M 14.1 -13.1 L 16.5 -12.1 L 20.5 -12.1 L 25.5 -13.1 L 23.5 -12.7 L 23.4 2.0 L 22.9 4.1 L 21.6 6.2 L 19.7 7.5 L 17.3 7.9 L 15.6 7.5 L 13.8 6.3 L 12.6 4.5 L 12.6 2.4 L 13.8 .1 L 16.2 -.5 L 17.6 .0 L 18.5 .5 L 18.8 2.3 L 18.5 3.8","0 16.0 M 13.7 -12.9 L 16.4 -12.1 L 20.1 -12.2 L 25.1 -13.0 L 22.7 -12.5 L 22.9 8.5 L 22.4 10.3 L 21.5 12.0 L 20.2 13.2 L 18.2 14.3 L 16.2 14.4 L 14.3 13.8 L 12.8 12.5 L 12.0 10.4 L 12.0 7.9 L 13.6 5.4 L 15.5 4.6 L 17.1 5.1 L 18.2 6.1 L 18.7 6.7 L 18.7 7.7 L 18.4 8.7 L 18.2 9.1","0 19.9 M 16.2 -13.1 L 16.2 7.7 M 26.8 -12.8 L 26.0 -9.2 L 23.9 -5.4 L 21.8 -2.7 L 19.8 -1.2 L 16.8 -.8 L 15.1 -.9 L 13.5 -1.7 L 12.5 -2.9 L 12.6 -4.4 L 13.4 -5.1 L 14.8 -5.7 L 17.1 -5.9 L 19.0 -5.4 L 20.2 -4.5 L 21.0 -3.6 L 22.8 -.3 L 27.9 8.7 L 28.5 9.4 L 29.5 9.4","0 17.4 M 15.0 -13.0 L 15.6 -5.6 L 15.6 -1.1 L 15.5 3.5 L 15.2 5.0 L 14.8 6.4 L 14.2 7.4 L 13.3 7.5 L 12.7 7.2 L 12.7 6.7 L 13.0 6.3 L 13.9 6.5 L 15.0 6.6 L 18.7 7.6 L 22.6 7.4 L 25.1 6.3 L 26.4 4.6 L 26.6 3.2 L 25.8 1.7 L 24.5 1.1 L 22.9 1.1 L 22.0 1.7 L 21.8 2.9","0 28.1 M 15.4 1.5 L 13.5 1.8 L 12.3 4.1 L 12.9 6.5 L 15.3 7.6 L 17.1 6.7 L 18.4 4.8 L 18.7 3.2 L 18.9 -12.4 L 26.8 3.8 L 34.3 -13.0 L 34.7 5.3 L 35.1 6.4 L 35.4 6.9 L 36.6 7.2","0 24.8 M 15.6 1.6 L 14.5 1.3 L 12.9 2.6 L 12.3 3.9 L 12.3 4.9 L 12.9 6.3 L 14.2 7.2 L 15.8 7.2 L 17.4 6.3 L 18.1 4.6 L 18.7 1.9 L 18.7 -5.4 L 18.2 -12.8 L 30.0 7.4 L 29.9 3.2 L 29.7 -2.5 L 29.6 -7.5 L 30.0 -10.1 L 30.7 -11.8 L 32.0 -12.9 L 33.4 -13.0 L 34.5 -12.1","0 22.9 M 13.7 -6.3 L 13.0 -2.9 L 13.1 .3 L 14.9 3.6 L 17.6 6.4 L 21.4 7.7 L 25.3 7.3 L 28.0 5.7 L 30.4 2.5 L 31.2 -1.1 L 31.1 -4.7 L 30.2 -8.1 L 29.0 -10.7 L 27.2 -12.2 L 24.6 -13.1 L 21.8 -12.7 L 19.1 -10.7 L 17.1 -7.6 L 16.4 -4.4 L 16.5 -1.3 L 17.2 1.1","0 19.4 M 17.0 7.6 L 17.0 -12.0 L 19.8 -12.7 L 23.6 -12.4 L 26.5 -10.8 L 28.3 -8.4 L 28.2 -5.4 L 27.2 -3.0 L 25.6 -1.3 L 23.6 -.2 L 21.1 .3 L 19.1 .6 L 16.8 .4 L 15.1 -.2 L 13.2 -1.7 L 12.3 -3.8 L 12.9 -5.8 L 14.5 -6.9 L 16.3 -7.4 L 17.7 -7.5 L 19.0 -7.2 L 20.3 -6.4 L 21.8 -4.8","0 23.3 M 13.5 -7.1 L 13.1 -1.7 L 14.3 2.6 L 16.8 5.5 L 19.6 7.3 L 23.7 7.7 L 27.1 6.7 L 30.0 3.8 L 31.3 .6 L 31.8 -4.5 L 30.4 -8.6 L 28.1 -11.5 L 25.8 -12.8 L 22.8 -13.0 L 19.9 -11.9 L 17.5 -9.0 L 16.3 -6.0 L 16.3 -2.1 L 17.5 1.2 M 23.7 2.3 L 29.8 11.3","0 20.7 M 16.4 7.5 L 16.4 -12.1 L 18.8 -13.0 L 22.5 -12.9 L 25.8 -11.3 L 27.0 -9.0 L 27.3 -6.3 L 26.4 -4.0 L 24.8 -2.2 L 22.8 -1.0 L 20.2 .1 L 17.8 .1 L 14.6 -.2 L 12.9 -1.4 L 12.7 -3.0 L 13.5 -4.3 L 14.8 -4.9 L 16.8 -5.0 L 19.1 -4.4 L 20.8 -3.1 L 28.0 8.5 L 28.7 9.3 L 30.0 9.3","0 16.0 M 17.2 3.4 L 17.7 2.4 L 17.8 1.3 L 16.9 .3 L 15.4 .1 L 13.4 1.0 L 12.5 3.3 L 13.1 5.2 L 14.9 6.5 L 17.6 7.6 L 20.9 7.4 L 23.4 5.8 L 24.9 3.9 L 24.9 1.0 L 23.2 -1.3 L 21.4 -2.8 L 18.3 -4.4 L 15.7 -6.1 L 14.3 -7.5 L 14.0 -9.8 L 14.9 -11.7 L 17.6 -13.0 L 20.3 -13.1 L 22.0 -12.5 L 23.8 -11.3","0 17.7 M 12.0 -13.0 L 15.2 -11.5 L 18.9 -10.9 L 21.9 -10.6 L 25.1 -11.0 L 26.6 -11.7 L 26.9 -12.7 L 26.8 -13.4 L 25.7 -14.1 L 23.1 -14.1 L 20.7 -13.2 L 19.6 -12.2 L 18.9 -10.7 L 18.6 -2.9 L 18.6 7.6","0 22.3 M 13.5 -7.6 L 12.5 -8.5 L 12.0 -10.0 L 12.7 -12.0 L 14.4 -12.8 L 16.4 -12.7 L 17.3 -11.5 L 17.9 -9.8 L 15.8 2.1 L 16.2 4.2 L 17.6 6.4 L 19.5 7.7 L 21.9 7.8 L 24.0 6.5 L 25.8 3.9 L 27.3 .8 L 28.1 -2.0 L 28.1 -12.6 L 28.8 -12.8 L 28.0 -1.6 L 28.4 1.3 L 29.0 4.0 L 29.3 5.8 L 30.0 7.6 L 31.4 7.7","0 20.6 M 14.0 -8.5 L 12.2 -9.5 L 11.8 -11.4 L 13.4 -13.0 L 15.9 -12.8 L 17.0 -10.8 L 17.3 -8.3 L 17.5 1.5 L 18.1 5.0 L 19.7 7.1 L 21.3 7.9 L 22.8 7.4 L 23.9 5.8 L 24.6 4.4 L 29.8 -12.6","0 30.1 M 14.0 -8.4 L 12.5 -9.5 L 12.1 -11.3 L 13.2 -12.8 L 15.4 -12.9 L 16.9 -12.1 L 17.6 -10.4 L 17.6 1.7 L 18.0 3.7 L 18.9 6.0 L 20.0 7.4 L 21.1 7.6 L 22.3 7.5 L 23.6 6.5 L 24.9 4.7 L 25.9 2.7 L 26.5 -.8 L 26.8 -8.2 L 26.3 -8.5 L 26.6 1.6 L 27.4 3.8 L 28.8 6.4 L 30.4 7.4 L 32.2 7.3 L 33.6 6.0 L 34.6 3.4 L 34.9 1.1 L 34.9 -9.6 L 35.3 -11.7 L 36.8 -13.0 L 38.2 -13.1 L 39.0 -12.8 L 40.0 -12.1","0 21.3 M 14.2 -8.8 L 13.3 -8.9 L 12.4 -10.0 L 12.1 -11.2 L 13.2 -12.8 L 14.9 -13.0 L 16.7 -11.8 L 18.4 -9.4 L 25.2 5.4 L 26.9 7.4 L 29.0 7.8 L 30.0 6.8 L 30.4 5.8 L 30.2 4.3 L 29.3 3.4 L 28.2 3.4 M 27.1 -12.9 L 19.7 -.4 L 14.4 7.2","0 16.2 M 11.7 -13.0 L 13.5 -6.9 L 15.2 -4.0 L 17.1 -2.2 L 18.9 -1.9 L 20.8 -2.6 L 23.1 -5.1 L 24.9 -8.0 L 25.6 -10.7 L 25.8 -12.3 L 24.7 -13.1 L 23.3 -12.8 L 22.2 -11.4 L 20.9 -8.2 L 20.4 -4.4 L 19.7 -.5 L 19.7 5.0 L 20.0 9.7","0 17.4 M 13.1 -13.1 L 16.7 -12.1 L 19.7 -12.4 L 24.5 -13.0 L 24.5 -11.7 L 13.9 6.2 L 13.5 7.3 L 12.5 7.7 L 12.0 7.3 L 12.0 6.6 L 12.9 6.0 L 13.9 6.0 L 15.6 6.6 L 20.4 7.8 L 23.8 7.4 L 26.4 5.8 L 26.7 3.8 L 26.3 2.2 L 25.2 1.2 L 23.3 .9 L 22.0 1.7 L 21.7 3.0 L 21.9 4.2","0 9.5 M 19.1 -12.9 L 13.9 -12.9 L 13.9 13.8 L 19.1 13.8","0 9.7 M 13.0 -13.3 L 18.3 11.9","0 9.2 M 12.0 -12.7 L 17.2 -12.7 L 17.2 13.7 L 11.9 13.7","0 14.3 M 12.5 -3.5 L 17.8 -12.8 L 23.5 -3.3","0 15.8 M 12.4 13.8 L 24.6 13.8","0 7.5 M 13.3 -12.9 L 14.1 -11.4 L 15.8 -9.8","0 15.8 M 23.3 -3.6 L 21.3 -5.0 L 18.6 -6.0 L 15.6 -5.0 L 13.3 -2.0 L 12.7 .5 L 13.1 3.5 L 14.5 6.5 L 17.3 7.5 L 20.3 6.6 L 22.1 4.5 L 23.3 2.1 L 23.4 -5.6 L 23.4 5.9 L 23.7 7.0 L 24.2 7.4 L 24.9 7.4","0 15.3 M 13.4 -13.1 L 13.7 1.5 L 13.3 7.5 L 14.4 -2.2 L 17.1 -5.0 L 20.2 -5.7 L 22.4 -4.6 L 23.7 -1.9 L 23.9 2.1 L 22.9 5.5 L 21.2 6.9 L 17.9 7.6 L 15.6 6.7 L 14.6 5.7 L 14.0 4.1","0 14.2 M 23.3 -4.2 L 21.3 -5.6 L 18.4 -5.9 L 15.9 -5.1 L 13.8 -2.9 L 12.9 -.4 L 13.2 3.4 L 15.1 6.3 L 17.8 7.8 L 20.3 7.8 L 23.4 6.1","0 16.5 M 25.9 7.4 L 24.9 7.3 L 24.1 6.4 L 23.8 4.2 L 23.9 -2.8 L 21.6 -5.0 L 18.8 -5.8 L 16.0 -5.0 L 13.8 -3.1 L 12.8 -.2 L 12.9 2.4 L 13.4 4.5 L 15.3 6.8 L 17.9 7.7 L 20.2 6.9 L 22.2 4.9 L 23.1 3.4 L 23.8 1.3 L 24.2 -12.9","0 15.1 M 11.7 .1 L 15.5 1.1 L 19.5 1.4 L 22.1 .6 L 23.8 -1.6 L 23.4 -3.4 L 21.9 -5.2 L 18.8 -5.9 L 16.2 -5.0 L 14.4 -2.6 L 13.5 -.7 L 13.5 2.4 L 14.3 5.0 L 16.9 7.3 L 19.2 7.8 L 21.4 7.6 L 23.8 6.0","0 8.5 M 12.1 11.3 L 13.9 9.2 L 14.5 8.1 L 14.2 -9.3 L 14.8 -11.5 L 15.8 -12.7 L 16.9 -13.1 L 17.8 -13.0 L 19.4 -12.2 M 11.5 -5.5 L 18.6 -5.5","0 15.5 M 23.5 -3.1 L 20.8 -5.3 L 17.6 -5.7 L 14.9 -4.3 L 13.0 -1.6 L 12.7 2.1 L 13.6 5.3 L 15.1 7.1 L 17.4 7.7 L 19.3 7.1 L 21.1 5.7 L 22.5 3.5 L 23.5 1.0 L 23.5 -5.6 L 23.6 8.2 L 23.0 10.3 L 21.6 12.6 L 19.4 14.0 L 17.3 14.2 L 15.6 13.8 L 13.5 13.0","0 16.1 M 13.5 -12.9 L 13.8 7.6 L 13.3 7.0 L 14.3 -1.1 L 15.9 -3.6 L 17.9 -5.3 L 20.2 -5.9 L 21.9 -5.1 L 23.3 -4.1 L 23.7 -1.2 L 23.6 .3 L 23.6 6.5 L 24.2 7.3 L 25.4 7.5","0 5.6 M 13.7 -5.9 L 13.7 7.7 M 13.0 -12.0 L 13.0 -10.7 L 14.0 -10.6 L 13.9 -12.0 L 13.0 -12.0","0 5.7 M 13.5 -5.9 L 13.5 9.9 L 12.6 11.5 L 11.3 13.0 M 13.1 -11.7 L 13.2 -10.3 L 14.0 -10.5 L 14.1 -11.7 L 13.1 -11.7","0 14.1 M 13.4 -13.0 L 13.7 -5.3 L 13.6 1.3 L 13.4 7.7 L 13.6 -1.3 L 17.3 -4.8 L 20.3 -5.8 L 22.7 -3.9 L 22.4 -1.1 L 20.7 .2 L 19.2 1.3 L 17.7 1.7 L 16.9 1.3 L 16.8 .6 L 17.7 .7 L 18.5 1.6 L 21.6 6.4 L 22.4 7.6 L 23.3 7.5","0 5.9 M 13.7 -12.9 L 13.7 7.7","0 24.6 M 13.5 -5.5 L 13.9 6.8 L 13.6 7.7 L 13.2 7.4 L 13.6 1.4 L 15.2 -3.0 L 18.2 -5.8 L 21.3 -5.3 L 22.9 -2.9 L 23.3 -.9 L 23.6 7.2 L 23.0 8.0 L 22.7 7.7 L 23.6 -1.1 L 25.3 -3.9 L 28.0 -5.7 L 31.0 -4.9 L 32.4 -2.3 L 32.5 2.0 L 32.4 6.3 L 32.9 7.5 L 33.9 7.5","0 16.0 M 13.6 -5.7 L 14.1 7.5 L 13.4 7.7 L 13.2 6.6 L 14.1 -.7 L 16.6 -4.3 L 18.9 -5.7 L 21.7 -5.3 L 23.4 -3.4 L 24.0 -.4 L 23.8 6.5 L 24.3 7.4 L 25.1 7.4","0 15.7 M 18.7 -5.9 L 16.0 -5.4 L 13.5 -2.8 L 12.6 1.2 L 13.6 4.8 L 16.3 7.2 L 19.3 7.9 L 22.5 6.1 L 24.3 2.3 L 24.1 -1.6 L 22.2 -4.7 L 20.5 -5.6 L 18.7 -5.9","0 15.8 M 13.0 -5.4 L 13.6 3.8 L 13.9 13.4 L 12.9 14.0 L 13.6 1.9 L 14.0 -1.6 L 17.2 -5.0 L 20.4 -5.7 L 23.0 -4.3 L 24.5 -.4 L 23.9 3.5 L 22.4 6.4 L 19.7 7.5 L 16.8 7.5 L 13.5 5.5","0 15.2 M 23.1 -5.3 L 23.1 -.1 L 22.1 4.2 L 18.6 7.6 L 14.7 7.2 L 12.1 2.6 L 13.3 -2.8 L 16.4 -5.7 L 20.1 -5.7 L 22.9 -3.3 L 23.2 14.1","0 10.9 M 13.5 -5.4 L 13.5 7.4 L 13.5 -.8 L 16.2 -4.2 L 18.1 -5.7 L 19.6 -5.7 L 20.6 -4.8","0 12.3 M 20.7 -4.5 L 17.7 -5.9 L 15.0 -5.5 L 13.0 -3.3 L 13.7 -1.1 L 17.6 .6 L 20.9 2.4 L 21.4 4.4 L 20.2 6.6 L 16.9 7.7 L 13.7 6.9 L 12.3 5.6","0 9.1 M 14.6 -10.1 L 14.7 6.2 L 15.2 7.4 L 16.6 7.6 L 18.6 6.8 M 11.5 -5.4 L 18.5 -5.3","0 16.5 M 13.6 -5.6 L 13.7 -.6 L 13.7 3.7 L 14.7 6.4 L 17.1 7.7 L 19.4 7.4 L 21.8 5.0 L 23.5 2.3 L 23.4 -5.7 L 23.9 -5.9 L 24.0 -1.3 L 23.6 3.7 L 23.9 6.0 L 24.5 7.6 L 25.5 7.6","0 13.6 M 12.0 -5.8 L 17.1 7.5 L 17.9 7.6 L 23.0 -5.6","0 22.2 M 12.2 -5.7 L 16.6 7.6 L 17.4 7.6 L 21.8 -5.2 L 22.3 -5.1 L 26.4 7.4 L 26.9 7.4 L 31.7 -5.7","0 13.6 M 11.9 -5.7 L 13.2 -5.4 L 21.9 7.1 L 22.9 7.7 M 12.3 7.8 L 22.0 -5.9","0 15.9 M 13.4 -5.5 L 13.6 -4.7 L 13.8 4.4 L 14.7 6.4 L 16.5 7.7 L 18.7 7.7 L 21.4 5.6 L 22.9 3.5 L 23.8 .7 L 24.1 -5.5 L 23.9 -5.8 L 23.4 -5.3 L 23.8 8.6 L 22.9 11.6 L 20.8 13.4 L 18.9 14.2 L 15.9 14.0 L 13.2 12.8","0 13.0 M 12.5 -5.4 L 22.0 -5.4 L 12.3 7.4 L 22.7 7.4","0 8.1 M 16.8 -13.0 L 15.4 -12.4 L 15.2 -11.1 L 15.5 -3.6 L 15.1 -1.8 L 14.0 .4 L 12.5 1.7 L 11.6 1.5 L 11.4 .5 L 12.4 .0 L 13.6 .4 L 14.7 1.8 L 15.2 3.9 L 15.0 10.4 L 15.2 13.2 L 16.6 14.2","0 5.6 M 13.4 -14.4 L 13.4 15.5","0 8.1 M 12.5 -12.9 L 14.1 -12.4 L 14.5 -11.6 L 14.6 -9.5 L 14.3 -3.0 L 14.9 -1.4 L 15.8 .2 L 17.0 1.6 L 18.2 1.3 L 18.1 .2 L 17.0 -.1 L 15.5 .8 L 14.7 2.5 L 14.4 3.6 L 14.7 12.5 L 14.0 13.7 L 12.9 13.9","0 15.3 M 12.9 1.2 L 14.0 .3 L 15.4 -.3 L 17.2 -.2 L 18.9 .3 L 20.7 1.2 L 22.3 1.1 L 24.0 -.1","0 9.0 M 15.0 -11.9 L 13.3 -10.9 L 12.6 -8.4 L 13.1 -5.9 L 15.2 -4.7 L 17.6 -6.1 L 17.9 -8.8 L 17.0 -11.2 L 15.0 -11.9"]
EMSElfin = ["-8 8","0 7.5 M 12.6 -13.6 L 13.1 -11.5 L 12.8 -.5 M 12.3 5.4 L 12.1 6.9 L 13.4 6.9 L 13.7 5.4 L 12.3 5.4","0 9.6 M 12.0 -14.1 L 12.3 -13.3 L 12.3 -8.9 M 16.4 -14.1 L 16.4 -10.3 L 15.9 -8.9","0 19.9 M 14.0 3.8 L 15.9 -3.0 L 18.0 -10.6 L 18.4 -13.4 M 25.1 -13.7 L 24.3 -11.5 L 20.0 4.5 M 26.8 -1.3 L 21.7 -1.0 L 16.1 -1.0 L 11.1 -.3 M 11.7 -7.2 L 18.2 -7.7 L 23.8 -7.5 L 26.7 -7.8 L 27.5 -7.8","0 13.0 M 16.3 7.5 L 16.2 -8.6 L 15.9 -10.5 L 15.4 -12.7 L 15.4 -14.7 M 19.3 -8.9 L 19.2 -9.9 L 16.3 -12.2 L 14.8 -12.3 L 13.4 -11.6 L 12.3 -10.4 L 12.0 -8.8 L 12.7 -7.0 L 15.2 -4.4 L 18.2 -1.9 L 19.7 .2 L 19.7 2.1 L 18.2 3.8 L 16.9 4.5 L 15.4 4.7 L 13.8 4.6 L 12.2 3.0 L 11.4 1.6 L 11.5 .6","0 17.9 M 14.5 5.1 L 20.3 -9.0 L 22.0 -12.3 L 18.2 -11.4 L 15.4 -10.7 L 13.6 -10.7 L 12.8 -11.0 L 11.5 -9.9 L 11.0 -7.3 L 11.2 -5.3 L 12.3 -4.0 L 13.5 -4.2 L 14.8 -5.7 L 14.9 -8.1 L 14.7 -9.5 L 14.1 -10.5 M 23.3 -3.5 L 21.9 -2.7 L 21.0 -.7 L 20.6 1.0 L 20.8 3.0 L 21.4 4.1 L 22.8 4.4 L 23.9 3.9 L 25.0 1.9 L 25.4 -.3 L 25.1 -2.1 L 24.7 -2.9 L 23.3 -3.5","0 23.1 M 20.3 -11.8 L 19.9 -10.2 L 19.6 -9.1 L 20.0 -8.6 L 19.0 -10.0 L 17.7 -10.4 L 16.6 -10.1 L 15.6 -9.5 L 15.4 -8.2 L 15.6 -7.3 L 16.4 -6.4 L 18.0 -6.1 L 17.1 -6.5 L 14.6 -5.5 L 12.5 -3.8 L 11.9 -2.1 L 11.6 1.2 L 12.8 4.0 L 15.0 5.6 L 17.3 6.2 L 19.9 6.1 L 22.2 5.1 L 23.8 3.1 L 24.1 1.5 L 23.5 -.1 L 21.9 -2.2 M 16.7 .3 L 17.1 -.9 L 18.3 -1.7 L 20.2 -2.2 L 22.9 -2.6 L 25.1 -3.1 L 28.0 -3.9 L 30.0 -5.2 L 31.0 -6.8 L 30.6 -8.3 L 29.9 -9.0 L 28.8 -9.4 L 27.4 -9.0","0 5.2 M 11.7 -15.5 L 11.7 -8.7","0 9.4 M 17.0 10.0 L 14.5 6.6 L 12.7 2.6 L 11.9 -1.5 L 11.7 -5.7 L 12.2 -9.7 L 13.7 -13.2 L 15.6 -15.2 L 17.5 -16.4","0 9.0 M 11.5 9.2 L 13.5 6.5 L 15.0 3.2 L 15.8 .1 L 15.9 -3.1 L 15.9 -6.9 L 15.0 -10.3 L 13.6 -13.0 L 11.5 -15.9 L 10.4 -17.3","0 13.6 M 16.4 -2.4 L 16.6 -15.3 M 11.4 -4.1 L 20.7 -12.7 M 11.3 -12.7 L 18.9 -5.9 L 20.3 -4.1","0 17.2 M 18.3 4.4 L 18.5 4.4 L 17.7 -9.4 M 11.2 -1.9 L 14.9 -1.9 L 19.8 -2.2 L 22.5 -2.6 L 24.8 -2.9","0 6.7 M 13.0 6.2 L 11.8 6.2 L 12.0 4.7 L 13.4 4.8 L 13.5 7.6 L 12.0 10.0","0 13.1 M 12.2 -.2 L 12.4 -.2 L 15.3 -.8 L 17.3 -.6 L 19.3 -1.1","0 6.4 M 12.0 4.9 L 11.8 6.4 L 13.2 6.4 L 13.4 5.0 L 12.0 4.9","0 9.8 M 11.7 5.3 L 15.2 -6.6 L 16.6 -13.0","0 12.5 M 15.5 -.1 L 17.0 -.1 L 18.9 -1.3 L 20.1 -3.9 L 20.1 -5.6 L 18.4 -8.0 L 16.3 -9.2 L 14.1 -9.2 L 12.7 -7.9 L 12.1 -6.2 L 12.0 -4.0 L 12.7 -2.0 L 13.5 -.8 L 15.6 .0","0 11.4 M 16.9 5.9 L 17.2 -11.6 L 17.5 -10.2 L 15.6 -8.9 L 13.9 -7.8 L 12.2 -7.2 L 10.3 -7.1","0 13.4 M 14.1 -8.8 L 14.6 -7.7 L 14.0 -6.3 L 12.7 -5.8 L 11.6 -6.3 L 11.1 -8.1 L 11.2 -10.6 L 13.0 -13.3 L 15.3 -14.1 L 17.4 -13.4 L 18.7 -11.3 L 18.9 -9.0 L 18.5 -5.9 L 17.2 -1.7 L 15.5 1.8 L 14.0 4.3 L 13.0 6.1 L 21.5 5.2","0 12.9 M 15.1 2.0 L 14.6 .7 L 12.6 .8 L 11.4 1.5 L 10.9 3.4 L 11.3 5.1 L 12.8 6.5 L 14.9 6.7 L 17.4 5.1 L 18.6 2.6 L 18.8 -.1 L 18.1 -3.1 L 17.0 -4.7 L 15.5 -5.6 L 14.1 -5.5 L 13.5 -5.2 L 12.8 -4.4 L 14.8 -6.3 L 18.1 -10.2 L 20.3 -12.6 L 16.6 -12.5 L 13.5 -12.7","0 13.1 M 20.9 2.8 L 10.7 4.8 L 15.1 -6.2 L 17.1 -12.9 M 17.9 -7.7 L 17.9 1.9 L 18.0 6.8 L 17.9 10.1","0 12.3 M 14.3 4.0 L 14.0 3.2 L 13.0 3.2 L 11.9 4.0 L 11.9 5.9 L 13.0 7.5 L 15.4 7.6 L 18.0 5.9 L 19.0 3.6 L 19.3 1.4 L 18.3 -.6 L 16.7 -2.7 L 15.5 -3.0 L 14.0 -2.4 L 13.0 -1.6 L 12.3 -.6 L 12.0 .5 L 12.3 -5.9 L 12.4 -7.4 L 12.1 -11.3 L 15.0 -10.9 L 18.4 -11.3","0 14.5 M 14.6 6.4 L 14.9 3.7 L 16.3 1.6 L 18.0 1.1 L 19.9 2.7 L 20.4 4.8 L 19.6 6.5 L 18.3 7.4 L 16.0 7.4 L 14.0 5.6 L 12.3 2.3 L 12.0 -1.9 L 13.1 -5.9 L 15.4 -8.7 L 17.5 -10.4 L 19.3 -10.6 L 21.0 -10.1 L 22.7 -9.0","0 13.1 M 12.7 8.1 L 18.0 -6.3 L 19.5 -9.4 L 20.5 -10.6 L 21.3 -11.2 L 17.0 -10.8 L 13.0 -10.5 L 10.7 -11.0 M 13.6 -4.4 L 20.4 -3.2","0 14.0 M 15.9 6.5 L 19.0 5.5 L 20.0 4.5 L 20.3 3.6 L 21.2 3.0 L 21.2 1.7 L 21.8 .2 L 20.9 -3.0 L 19.4 -5.2 L 18.3 -6.4 L 17.0 -6.5 L 15.3 -6.5 L 14.4 -7.8 L 14.4 -9.9 L 15.9 -11.6 L 17.6 -11.6 L 19.3 -10.8 L 20.2 -9.4 L 20.3 -7.6 L 19.5 -6.7 L 18.2 -6.2 L 15.2 -6.2 L 13.6 -5.0 L 12.2 -2.7 L 11.9 -.5 L 12.0 2.0 L 12.6 3.9 L 13.7 5.6 L 15.9 6.5","0 13.9 M 11.6 3.8 L 11.8 3.8 L 12.4 5.4 L 14.3 6.2 L 17.0 5.2 L 19.3 2.9 L 20.4 -.8 L 20.1 -5.6 L 18.0 -9.4 L 17.0 -10.6 L 15.7 -11.1 L 13.8 -10.5 L 12.7 -9.0 L 12.1 -7.3 L 12.5 -5.2 L 13.6 -4.0 L 15.2 -3.7 L 16.9 -4.4 L 18.0 -5.5 L 18.9 -7.9","0 7.8 M 12.4 -5.8 L 12.2 -4.3 L 13.6 -4.3 L 13.8 -5.7 L 12.4 -5.8 M 12.6 4.9 L 12.4 6.4 L 13.8 6.4 L 14.0 4.9 L 12.6 4.9","0 8.1 M 13.0 -5.3 L 12.8 -3.9 L 14.1 -3.9 L 14.4 -5.3 L 13.0 -5.3 M 135.2 7.1 L 135.1 8.6 L 136.4 8.6 L 136.6 7.1 L 135.2 7.1 M 13.5 6.3 L 12.3 6.3 L 12.5 4.9 L 13.9 4.9 L 14.0 7.8 L 12.5 10.1","0 17.2 M 23.3 5.4 L 11.4 1.2 L 23.9 -6.4","0 18.7 M 12.2 2.6 L 20.8 2.8 L 24.6 2.6 M 24.3 -3.2 L 20.7 -2.8 L 16.1 -3.0 L 12.6 -3.2","0 18.0 M 12.1 -4.9 L 18.0 -2.5 L 22.7 -1.0 L 25.4 .1 L 20.7 2.3 L 15.4 4.5 L 12.6 5.5","0 12.3 M 13.6 -.6 L 14.1 -8.3 L 14.3 -6.8 L 15.4 -6.6 L 18.0 -8.4 L 19.2 -12.2 L 18.7 -15.4 L 17.3 -17.5 L 15.3 -18.4 L 13.0 -17.3 L 12.1 -16.4 L 11.7 -15.5 L 11.6 -13.6 L 11.2 -12.4 L 11.9 -11.4 L 13.1 -12.1 L 13.3 -13.4","0 21.9 M 25.4 5.8 L 20.6 6.6 L 16.6 5.7 L 13.1 1.6 L 12.4 -4.2 L 14.9 -9.4 L 18.2 -12.3 L 21.7 -13.1 L 25.0 -12.2 L 27.5 -10.1 L 29.4 -7.4 L 29.7 -5.0 L 28.2 -2.0 L 26.6 -.2 L 24.6 .7 L 23.7 .0 L 22.9 -1.5 L 22.9 -3.8 L 23.1 -5.6 L 22.4 -6.8 L 21.3 -7.2 L 20.0 -6.3 L 19.1 -4.3 L 18.6 -2.9 L 18.6 -1.2 L 18.8 .0 L 19.4 .6 L 20.2 .2 L 21.0 -1.1 L 23.0 -4.1","0 18.9 M 9.3 9.8 L 11.8 9.7 L 13.8 10.2 L 11.7 9.7 L 16.4 -9.4 L 18.2 -13.9 L 18.4 -14.7 L 21.6 -5.3 L 24.6 3.1 L 25.1 5.2 L 12.8 5.2 L 25.0 5.1 L 26.6 10.3 L 24.2 10.8 L 28.6 10.1","0 15.6 M 12.5 8.0 L 17.0 6.3 L 20.2 4.1 L 21.0 2.4 L 20.8 .7 L 19.7 -.9 L 18.7 -1.9 L 17.2 -2.3 L 14.0 -1.7 L 17.3 -2.4 L 20.7 -4.6 L 22.4 -7.2 L 22.9 -9.9 L 22.6 -12.6 L 21.6 -14.7 L 19.3 -16.6 L 16.7 -17.5 L 13.5 -17.3 L 9.2 -17.0 L 12.8 -17.0 L 14.3 7.6","0 22.2 M 30.1 2.5 L 28.1 4.8 L 25.3 6.4 L 22.5 6.7 L 19.2 6.3 L 15.8 4.4 L 13.7 1.9 L 12.0 -1.9 L 11.9 -6.0 L 13.6 -10.9 L 16.4 -14.3 L 19.6 -15.6 L 22.8 -16.2 L 25.9 -15.8 L 29.2 -13.7 L 29.6 -15.7 L 29.0 -13.7 L 29.3 -11.6","0 19.6 M 9.7 -17.6 L 13.4 -17.8 L 18.3 -17.3 L 22.1 -15.7 L 24.7 -12.6 L 26.0 -9.2 L 26.5 -5.7 L 25.5 -2.3 L 23.0 .9 L 20.0 3.0 L 17.1 4.5 L 12.9 5.2 L 15.8 4.9 L 14.5 -13.0 L 14.1 -17.7","0 16.1 M 23.8 5.7 L 23.7 8.6 L 23.8 7.4 L 13.1 7.6 L 11.4 8.0 L 13.5 7.6 L 13.3 .3 L 16.6 .1 L 20.1 .3 L 20.7 -1.5 L 20.3 1.6 L 20.1 .4 L 15.7 .0 L 13.3 .1 L 13.5 -8.2 L 13.2 -15.5 L 11.4 -15.7 L 13.7 -15.3 L 18.8 -15.3 L 23.9 -15.3 L 23.8 -13.3 L 24.1 -17.6","0 15.7 M 13.4 8.5 L 15.8 7.8 L 16.6 7.8 L 15.4 7.7 L 14.9 .9 L 21.5 .3 L 21.7 2.0 L 21.5 -.6 L 21.5 .3 L 14.9 .9 L 13.6 -14.6 L 13.6 -14.0 L 10.0 -14.1 L 17.4 -14.2 L 23.2 -14.3 L 23.2 -16.0 L 23.3 -12.0 L 23.5 -11.3","0 16.9 M 23.2 -16.5 L 23.0 -13.5 L 23.1 -14.4 L 23.6 -14.2 L 22.5 -14.7 L 21.1 -15.7 L 18.4 -16.0 L 16.1 -15.0 L 13.8 -12.5 L 12.4 -8.3 L 12.3 -4.1 L 12.5 .1 L 14.4 3.0 L 16.9 4.1 L 20.2 3.2 L 22.1 1.1 L 23.1 -1.9 L 23.3 -7.5 L 24.7 -7.3 L 19.6 -7.5","0 19.2 M 12.1 7.7 L 14.8 6.7 L 13.6 7.2 L 13.2 -1.2 L 11.9 -15.0 L 10.4 -14.7 L 11.9 -14.9 L 13.1 -15.3 M 25.0 8.5 L 24.2 8.7 L 21.5 9.0 L 23.0 8.8 L 24.4 -7.0 L 24.9 -11.9 L 25.8 -16.1 L 27.2 -16.1 L 24.3 -16.3 M 23.7 .6 L 13.4 .4","0 9.2 M 12.4 7.3 L 15.3 6.4 L 17.5 6.3 L 15.2 6.2 L 13.7 -3.8 L 13.2 -13.8 L 14.9 -14.1 L 15.7 -13.9 L 14.7 -14.1 L 10.3 -13.2","0 13.5 M 12.4 6.2 L 11.1 5.8 L 9.4 6.9 L 8.8 8.8 L 10.2 11.3 L 13.0 11.9 L 16.2 11.1 L 18.6 8.8 L 19.8 5.8 L 19.8 2.5 L 18.8 -3.4 L 16.6 -14.8 L 14.1 -14.0 L 19.6 -15.5","0 21.1 M 12.4 9.5 L 15.7 8.6 L 14.3 9.0 L 13.8 -2.4 L 13.3 -6.2 L 13.0 -14.9 L 14.9 -15.2 L 10.4 -14.6 M 28.6 -14.0 L 24.8 -14.4 L 26.6 -14.1 L 22.8 -9.9 L 19.0 -5.2 L 15.6 -2.0 L 14.2 -1.6 L 16.7 -2.4 L 19.1 -2.5 L 20.8 -1.6 L 22.1 .4 L 23.4 2.6 L 25.9 6.2 L 27.8 7.6 L 29.7 7.2 L 30.9 5.9 L 31.1 5.1 L 30.5 3.6 L 29.6 2.8 L 28.7 3.4","0 13.0 M 21.2 5.7 L 20.5 9.6 L 20.8 8.0 L 16.7 7.6 L 12.7 7.6 L 10.6 8.0 L 12.8 7.6 L 12.8 -6.3 L 12.7 -11.2 L 12.9 -16.6 L 11.5 -16.6 L 14.4 -16.7","0 29.2 M 9.3 6.6 L 14.1 6.1 L 12.6 6.2 L 14.5 -10.5 L 15.1 -18.5 L 21.1 .7 L 26.5 -6.7 L 29.3 -11.0 L 31.1 -14.5 L 32.7 -17.8 L 32.9 -19.1 L 32.4 -14.5 L 33.2 -7.8 L 33.9 -1.2 L 34.7 6.2 L 38.3 5.5 L 32.1 6.7","0 17.9 M 10.8 8.2 L 15.8 7.4 L 13.6 7.6 L 13.3 -3.0 L 12.9 -6.6 L 12.9 -14.5 L 17.6 -5.3 L 23.3 3.6 L 23.6 -7.2 L 24.0 -12.6 L 24.9 -16.8 L 27.0 -16.6 L 22.9 -17.0","0 20.6 M 22.0 -14.4 L 20.4 -15.1 L 16.0 -13.7 L 13.2 -10.5 L 11.9 -5.9 L 12.2 -1.4 L 14.2 2.0 L 17.9 3.8 L 21.7 3.6 L 25.5 .8 L 26.9 -1.4 L 27.9 -4.1 L 27.8 -7.3 L 26.7 -10.9 L 25.4 -13.1 L 23.8 -14.3 L 22.1 -14.4","0 14.9 M 12.2 7.3 L 15.9 6.8 L 14.0 7.1 L 14.4 -10.1 L 14.0 -12.3 L 13.6 -14.8 L 12.4 -16.4 L 9.7 -16.4 L 16.9 -16.2 L 19.5 -15.3 L 21.5 -13.1 L 22.5 -10.5 L 22.4 -7.8 L 21.7 -5.5 L 19.2 -3.4 L 16.4 -2.8 L 14.4 -2.8","0 21.1 M 24.2 5.3 L 26.9 2.0 L 27.1 .9 L 27.8 -.3 L 28.1 -2.8 L 27.2 -6.9 L 26.4 -9.1 L 24.2 -11.0 L 23.0 -11.1 L 21.1 -11.9 L 16.1 -10.5 L 13.3 -7.1 L 12.3 -3.9 L 12.0 .2 L 13.1 3.6 L 14.8 5.4 L 17.3 6.9 L 20.4 7.1 L 22.3 6.5 L 24.0 5.1 L 21.5 2.1 L 29.2 10.3 L 31.4 10.7 L 32.5 9.7 L 32.7 8.7 L 32.4 7.6 L 31.6 6.8 L 30.6 6.7 L 30.5 7.3","0 20.0 M 12.6 10.6 L 16.6 9.7 L 14.7 10.2 L 14.4 -1.7 L 14.0 -7.3 L 14.7 -14.9 L 10.1 -14.0 L 17.0 -15.1 L 21.3 -15.0 L 23.3 -13.8 L 24.8 -11.6 L 25.0 -9.2 L 24.6 -6.9 L 22.8 -5.0 L 20.4 -3.8 L 18.3 -3.1 L 14.5 -2.9 L 19.8 -3.1 L 21.3 -2.1 L 22.7 .5 L 24.1 4.4 L 25.3 8.5 L 27.0 11.5 L 28.9 12.4 L 31.0 11.8 L 32.1 10.8 L 32.1 9.3 L 31.7 8.1 L 30.5 7.0 L 29.6 7.4 L 29.3 8.1","0 13.5 M 14.9 3.1 L 14.6 1.6 L 12.8 .8 L 11.0 1.5 L 10.3 3.6 L 10.8 5.4 L 12.2 7.3 L 14.5 8.2 L 17.4 6.9 L 19.5 4.4 L 20.1 2.2 L 19.9 .2 L 17.9 -3.7 L 14.6 -8.8 L 13.5 -11.4 L 13.5 -14.1 L 14.9 -16.2 L 15.8 -16.9 L 17.3 -17.1 L 18.7 -16.4 L 20.7 -14.5 L 21.5 -15.8 L 19.6 -12.1","0 17.8 M 17.0 8.6 L 21.7 8.1 L 19.6 8.3 L 18.5 -13.4 L 25.5 -13.6 L 25.6 -12.5 L 25.5 -13.6 L 26.0 -15.7 L 25.5 -13.6 L 10.8 -12.9 L 11.0 -15.3 L 10.9 -12.7 L 10.6 -10.7","0 18.4 M 10.2 -17.0 L 14.4 -17.6 L 12.2 -17.2 L 13.0 -7.2 L 14.0 .7 L 15.4 3.6 L 17.8 4.4 L 20.1 3.8 L 22.1 2.4 L 23.9 -1.2 L 24.5 -4.5 L 24.4 -16.5 L 22.7 -16.6 L 26.3 -16.8","0 17.7 M 10.8 -14.2 L 13.1 -14.7 L 11.8 -14.5 L 14.9 -5.9 L 16.8 2.1 L 17.7 5.9 L 18.9 2.5 L 19.7 .7 L 21.5 -6.1 L 22.5 -9.4 L 23.7 -12.8 L 25.5 -16.4 L 23.6 -16.7 L 25.4 -16.3 L 27.8 -16.4","0 25.1 M 10.4 -13.8 L 13.0 -14.1 L 14.9 -14.7 L 12.4 -14.0 L 14.0 -6.9 L 14.5 -3.4 L 15.9 2.3 L 16.1 4.8 L 17.3 .6 L 18.5 -2.1 L 20.0 -8.7 L 20.3 -10.5 L 21.0 -11.7 L 21.3 -13.0 L 21.9 -9.6 L 23.5 -3.4 L 26.4 7.1 L 27.5 1.1 L 28.7 -4.1 L 28.7 -5.9 L 29.5 -7.7 L 30.5 -9.9 L 30.7 -13.0 L 31.7 -16.7 L 29.8 -16.6 L 34.4 -16.5","0 19.3 M 9.9 7.9 L 13.7 7.6 L 11.9 7.7 L 21.8 -8.0 L 22.9 -10.4 L 26.8 -16.1 L 28.4 -16.0 L 24.5 -16.4 M 10.2 -15.6 L 15.3 -16.5 L 13.1 -16.1 L 14.1 -11.6 L 16.5 -6.1 L 19.4 -.1 L 21.6 4.5 L 22.2 6.2 L 24.4 8.4 L 25.7 9.0 L 27.6 8.8 L 28.6 7.9 L 28.8 6.2 L 28.0 5.2 L 27.1 5.3","0 18.8 M 10.7 -16.7 L 13.7 -17.4 L 12.1 -17.0 L 14.9 -10.4 L 16.1 -7.7 L 18.5 -4.3 L 18.0 8.9 L 16.4 9.0 L 15.0 9.2 L 18.0 8.9 L 20.3 9.0 M 18.4 -4.4 L 22.8 -10.8 L 24.2 -13.4 L 26.9 -18.0 L 24.8 -18.5 L 28.7 -17.5 L 29.0 -17.3","0 16.4 M 10.3 -10.6 L 10.7 -14.4 L 10.7 -13.7 L 17.2 -14.1 L 24.4 -14.4 L 23.6 -14.4 L 21.7 -12.0 L 17.9 -4.6 L 15.4 -5.2 L 18.0 -4.6 L 20.5 -4.5 L 17.9 -4.5 L 13.9 4.7 L 12.0 8.0 L 23.2 6.6 L 23.3 4.8 L 23.2 8.1","0 10.0 M 18.1 8.8 L 14.3 9.1 L 14.3 3.2 L 13.1 -3.4 L 12.7 -8.7 L 12.7 -15.8 L 17.2 -15.9","0 11.1 M 18.5 4.8 L 14.8 -3.0 L 13.7 -6.9 L 11.6 -11.8","0 8.0 M 11.0 10.5 L 13.1 10.4 L 13.5 10.0 L 13.6 -5.3 L 13.9 -14.9 L 11.2 -14.8","0 12.2 M 11.1 -.9 L 15.2 -14.1 L 17.2 -8.3 L 18.9 -1.7","0 15.6 M 11.0 7.5 L 23.2 7.6","0 6.7 M 10.6 -18.2 L 14.8 -15.0","0 12.3 M 12.0 -4.1 L 11.5 -6.1 L 12.4 -7.6 L 14.4 -8.9 L 17.0 -8.3 L 18.4 -6.1 L 18.8 -3.4 L 18.9 .7 L 18.4 2.3 L 16.4 3.7 L 14.3 4.8 L 12.4 5.1 L 10.9 4.2 L 10.8 2.0 L 11.6 .6 L 13.8 .0 L 16.6 .0 L 17.4 .2 L 18.6 1.5 L 19.0 2.8 L 19.1 4.8 L 19.1 7.0 L 19.2 7.8 L 20.3 8.0 L 20.9 8.0 L 21.6 8.0 L 22.4 7.6","0 15.0 M 9.4 -18.7 L 14.2 -19.1 L 11.9 -18.8 L 13.0 7.3 L 15.9 8.2 L 18.9 7.6 L 21.4 5.2 L 22.3 2.8 L 22.0 .2 L 21.0 -1.7 L 19.2 -2.9 L 16.3 -2.3 L 14.6 -.9 L 13.5 .8 L 12.8 2.6 L 13.2 8.2 L 11.7 8.6 L 11.0 9.0","0 12.5 M 18.8 -2.9 L 19.6 -7.5 L 19.3 -5.8 L 17.5 -7.1 L 15.7 -7.4 L 13.4 -6.2 L 12.0 -3.1 L 11.6 -.1 L 12.4 2.3 L 14.5 4.5 L 17.1 4.8 L 18.7 4.0 L 19.3 3.3","0 14.4 M 22.8 7.1 L 20.4 7.3 L 19.1 7.7 L 20.4 7.2 L 20.4 -.6 L 20.0 -4.0 L 19.1 -5.1 L 17.2 -5.3 L 14.8 -4.6 L 13.1 -2.8 L 11.9 -.1 L 11.7 2.6 L 12.3 4.6 L 13.8 6.0 L 15.3 6.0 L 17.4 4.4 L 18.6 2.7 L 19.6 .2 L 20.2 -3.1 L 20.9 -19.2 L 17.2 -18.9","0 11.0 M 18.5 5.6 L 17.3 7.3 L 15.1 8.0 L 12.8 6.5 L 11.8 2.6 L 12.1 -1.9 L 13.6 -5.8 L 14.7 -6.5 L 16.2 -6.3 L 17.3 -5.2 L 18.7 -1.7 L 15.5 -1.5 L 12.2 -1.4","0 9.2 M 11.5 13.7 L 17.5 12.6 L 14.6 13.0 L 13.7 1.5 L 13.5 -5.7 L 16.7 -5.8 L 17.6 -6.2 L 15.9 -5.8 L 11.5 -5.7 L 11.1 -5.8 L 13.7 -5.7 L 13.9 -12.2 L 14.4 -15.7 L 15.5 -17.6 L 17.6 -18.6 L 19.8 -18.7 L 21.7 -17.4 L 22.5 -16.3 L 22.6 -15.5","0 13.4 M 16.7 .1 L 18.4 -1.4 L 19.4 -4.0 L 19.8 -4.4 L 22.2 -5.3 L 19.5 -4.4 L 18.0 -6.4 L 16.1 -7.8 L 14.9 -7.9 L 12.3 -6.2 L 11.3 -3.2 L 12.0 -.9 L 13.4 .2 L 14.8 .4 L 15.9 .2 L 17.1 -.1 L 17.5 3.4 L 17.5 6.5 L 19.6 8.4 L 20.9 10.1 L 21.5 13.0 L 21.4 14.9 L 19.0 17.3 L 15.4 18.8 L 11.8 18.5 L 9.2 16.7 L 7.9 14.0 L 8.4 10.3 L 9.7 8.0 L 11.1 6.5 L 13.9 5.6 L 15.6 5.7 L 17.5 6.5","0 14.2 M 10.8 8.7 L 15.3 7.4 L 13.1 8.1 L 12.3 -8.6 L 11.9 -19.3 L 12.6 -19.5 L 11.9 -19.1 L 10.0 -19.1 M 12.6 -3.0 L 14.4 -5.3 L 16.9 -6.5 L 18.6 -6.1 L 19.7 -4.6 L 20.3 -1.6 L 20.5 1.0 L 20.6 7.6 L 18.7 8.1 L 22.8 7.2","0 8.2 M 10.5 5.4 L 10.6 5.4 L 15.7 4.8 L 13.3 5.0 L 13.7 -6.8 L 11.5 -6.8 M 12.2 -15.1 L 12.2 -13.9 L 13.5 -13.7 L 13.5 -15.1 L 12.2 -15.1","0 8.4 M 9.7 14.0 L 8.4 13.9 L 7.5 15.2 L 7.9 17.1 L 9.8 18.3 L 12.4 17.7 L 14.9 14.9 L 15.3 11.9 L 14.6 .3 L 14.8 -6.8 L 12.7 -6.1 L 10.3 -5.6 M 13.3 -15.1 L 12.4 -14.5 L 13.7 -13.7 L 15.2 -14.5 L 13.3 -15.1","0 14.6 M 10.7 7.9 L 15.2 7.0 L 13.0 7.4 L 12.4 -10.0 L 12.5 -21.3 L 14.6 -21.8 L 10.3 -21.1 M 22.9 -8.3 L 19.8 -8.5 L 20.9 -7.7 L 18.6 -5.5 L 13.1 -1.7 L 16.3 -3.6 L 19.4 2.4 L 21.3 6.5 L 23.5 9.9 L 25.1 10.4 L 26.8 9.7 L 27.7 8.3 L 27.4 6.6 L 26.4 6.0 L 25.7 6.1 L 25.4 6.7","0 7.1 M 10.9 11.1 L 11.2 11.1 L 15.2 9.5 L 13.1 10.4 L 12.4 -7.5 L 12.8 -17.1 L 14.5 -17.6 L 12.5 -16.8 L 10.7 -16.8","0 23.5 M 11.9 8.3 L 13.8 7.6 L 16.3 7.2 L 13.7 7.6 L 13.6 -1.5 L 12.9 -7.2 L 14.3 -7.6 L 10.5 -6.8 L 13.0 -7.2 L 13.9 -.3 L 15.7 -3.9 L 18.8 -6.2 L 20.3 -6.4 L 21.1 -5.3 L 21.5 -1.2 L 21.5 2.1 L 22.5 -2.3 L 24.6 -5.8 L 26.8 -7.6 L 28.5 -7.8 L 29.3 -5.7 L 29.6 -1.4 L 29.4 5.9 L 27.2 6.7 L 32.1 5.6","0 16.2 M 10.9 8.6 L 15.1 8.0 L 13.3 8.2 L 13.2 1.9 L 13.7 -3.1 L 13.9 -8.7 L 13.0 -9.3 L 10.5 -9.1 M 13.7 -2.5 L 16.8 -6.0 L 19.3 -7.3 L 21.0 -6.1 L 22.2 -4.2 L 22.5 -1.9 L 22.6 3.5 L 21.3 3.8 L 24.4 3.2","0 13.8 M 17.6 -8.0 L 15.7 -8.4 L 13.1 -7.5 L 12.0 -5.4 L 12.1 -2.5 L 13.2 -.6 L 15.8 .7 L 19.2 -.4 L 20.6 -2.9 L 20.7 -5.9 L 19.5 -7.5 L 17.9 -7.5","0 15.8 M 12.2 18.1 L 15.6 17.6 L 16.8 17.2 L 15.0 17.6 L 14.5 10.6 L 13.0 .6 L 12.9 -4.7 L 14.8 -8.1 L 18.5 -10.0 L 21.6 -8.9 L 22.8 -5.7 L 22.3 -2.3 L 20.8 .1 L 17.9 1.1 L 15.7 .5 L 13.7 -1.3 L 12.9 -4.3 L 12.5 -9.0 L 12.5 -12.2 L 13.8 -12.7 L 10.4 -11.6","0 15.3 M 22.3 -11.3 L 21.2 -4.5 L 19.8 -2.3 L 17.9 -.8 L 15.3 -.4 L 13.0 -1.7 L 11.9 -3.9 L 12.1 -7.1 L 14.6 -9.1 L 17.1 -9.4 L 19.6 -7.8 L 20.8 -6.3 L 20.9 -2.6 L 20.8 2.9 L 19.6 15.5 L 20.3 13.1 L 22.8 10.7 L 23.9 8.6","0 13.1 M 11.9 7.8 L 14.2 7.1 L 16.0 6.6 L 13.6 7.3 L 13.0 1.4 L 13.0 -3.8 L 12.6 -8.6 L 10.5 -8.2 L 12.6 -8.5 L 13.4 -3.2 L 15.1 -6.4 L 17.8 -8.6 L 19.7 -9.1 L 20.7 -8.2 L 21.3 -7.1 L 21.0 -5.7 L 20.4 -5.1 L 19.5 -5.1","0 10.8 M 12.1 7.8 L 11.3 6.7 L 10.2 6.7 L 9.3 8.0 L 9.8 10.3 L 11.1 11.7 L 13.5 12.0 L 15.7 10.8 L 17.0 9.0 L 17.2 5.8 L 15.6 1.4 L 13.3 -3.5 L 12.7 -7.3 L 14.1 -10.0 L 16.2 -10.6 L 17.7 -10.1 L 18.5 -9.1 L 19.5 -10.2 L 17.4 -6.9","0 11.1 M 17.4 4.4 L 18.5 3.4 L 19.7 4.0 L 19.9 5.4 L 19.3 7.1 L 17.2 8.1 L 15.4 7.8 L 13.8 5.8 L 13.6 1.8 L 13.2 -7.7 L 10.8 -7.3 L 16.2 -8.0 L 13.2 -7.7 L 13.0 -13.8","0 16.1 M 10.6 -9.3 L 13.9 -9.3 L 12.8 -9.0 L 12.4 -2.4 L 12.4 1.5 L 13.3 3.3 L 14.2 4.4 L 14.9 4.5 L 16.2 2.8 L 17.4 1.4 L 17.7 -.3 L 20.0 -3.8 L 21.2 -6.2 L 21.6 -8.6 L 21.7 .2 L 22.1 5.7 L 20.7 6.2 L 22.2 5.7 L 24.5 5.4","0 15.4 M 10.0 -8.9 L 12.5 -9.7 L 11.7 -9.3 L 16.6 5.4 L 19.7 -.6 L 20.9 -4.4 L 22.8 -9.2 L 21.0 -9.1 L 25.0 -9.1","0 21.5 M 9.4 -9.1 L 11.8 -9.5 L 13.3 -10.1 L 11.4 -9.4 L 14.5 1.7 L 14.9 5.4 L 15.8 1.9 L 16.4 -1.1 L 18.5 -6.1 L 18.9 -7.2 L 19.4 -4.5 L 21.6 2.3 L 22.5 5.4 L 23.0 6.5 L 23.8 6.2 L 25.0 2.0 L 26.7 -3.1 L 27.3 -4.7 L 27.9 -8.0 L 26.5 -8.8 L 28.0 -8.0 L 30.0 -8.2 L 30.7 -8.6","0 15.8 M 9.9 -7.3 L 10.0 -7.5 L 13.0 -8.0 L 11.8 -7.7 L 17.5 2.8 L 20.9 7.7 L 22.6 9.5 L 24.1 9.8 L 25.1 9.2 L 25.4 8.4 L 25.6 7.5 L 25.0 6.3 L 24.1 6.6 M 9.4 10.0 L 9.7 10.0 L 13.3 9.8 L 11.5 9.8 L 16.6 1.0 L 22.6 -9.1 L 20.9 -9.7 L 24.3 -8.7","0 14.5 M 9.8 13.3 L 8.9 12.2 L 7.1 12.2 L 6.0 13.8 L 5.7 15.9 L 7.2 17.7 L 9.7 17.7 L 13.0 16.1 L 15.9 11.1 L 18.7 4.3 L 20.4 -1.4 L 22.3 -5.7 M 18.1 5.5 L 11.7 -5.1 L 12.8 -5.3 L 9.7 -4.8","0 13.5 M 11.2 -4.4 L 11.2 -7.8 L 11.3 -6.6 L 20.5 -8.0 L 18.1 -3.8 L 15.7 1.3 L 13.4 1.0 L 15.7 1.3 L 18.7 1.0 L 15.7 1.4 L 11.9 8.7 L 20.9 9.3 L 21.4 7.3 L 20.8 9.4 L 21.0 11.5","0 10.8 M 18.5 9.8 L 16.5 10.3 L 14.5 9.5 L 13.7 6.8 L 13.9 .6 L 12.7 -2.0 L 11.7 -3.0 L 10.5 -3.4 L 10.1 -3.0 L 11.7 -3.0 L 14.0 -3.8 L 15.2 -6.5 L 15.1 -11.1 L 15.9 -16.0 L 16.6 -17.4 L 18.1 -17.9 L 19.4 -17.7","0 7.2 M 13.0 5.9 L 13.0 -4.3 L 12.7 -11.9 L 12.5 -12.6","0 10.3 M 11.6 10.4 L 12.1 10.5 L 13.5 10.0 L 15.2 8.2 L 15.2 4.6 L 15.6 -.1 L 16.2 -2.0 L 17.6 -2.7 L 18.7 -3.0 L 16.3 -2.5 L 15.0 -3.8 L 14.5 -5.6 L 14.9 -11.6 L 14.2 -15.1 L 13.3 -16.7 L 12.6 -17.3 L 11.2 -17.6 L 10.2 -17.0","0 19.6 M 11.6 -.2 L 13.3 -2.1 L 15.1 -3.0 L 17.5 -2.3 L 20.1 -1.1 L 22.8 -.3 L 24.7 -1.1 L 26.4 -2.4","0 7.6 M 12.4 -12.7 L 11.3 -12.1 L 11.0 -10.8 L 11.6 -9.5 L 12.4 -8.8 L 13.6 -8.7 L 14.4 -9.4 L 14.5 -10.3 L 15.1 -11.1 L 14.7 -12.1 L 13.7 -12.8 L 12.4 -12.7"]
EMSFelix = ["-8 8","0 15.3 M 17.9 -16.1 L 17.3 -10.5 L 15.9 -4.1 L 14.9 .3 L 14.0 2.7 M 13.3 5.7 L 12.3 6.7 L 13.2 8.0 L 14.2 6.9 L 13.3 5.7","0 15.1 M 13.9 -16.9 L 12.6 -11.5 M 19.0 -17.1 L 17.9 -11.3","0 23.1 M 16.0 8.9 L 18.5 -9.5 M 23.6 -9.5 L 21.2 9.0 M 26.3 2.8 L 13.1 2.7 M 13.1 -4.4 L 26.9 -4.4","0 14.7 M 17.7 -5.7 L 18.0 -6.1 L 15.3 -6.1 L 15.8 -9.8 L 15.3 -6.3 L 13.1 -5.7 L 11.8 -4.5 L 11.4 -3.1 L 12.5 -1.3 L 13.9 .1 L 15.6 2.2 L 16.7 4.1 L 16.8 5.4 L 16.0 6.6 L 14.6 7.2 L 13.4 7.4 L 12.9 11.7 L 13.4 7.4 L 11.5 7.4 L 10.2 6.7","0 28.1 M 12.6 7.5 L 17.5 1.7 L 23.2 -5.8 L 29.6 -14.7 M 15.9 -14.3 L 13.6 -13.2 L 12.3 -11.1 L 11.9 -9.0 L 12.7 -6.7 L 14.3 -5.4 L 16.3 -5.8 L 18.9 -7.7 L 19.7 -10.0 L 19.6 -12.1 L 18.7 -13.5 L 17.8 -14.2 L 15.9 -14.3 M 27.7 -1.6 L 25.2 -.3 L 23.9 2.1 L 23.7 4.2 L 24.4 6.3 L 26.4 7.3 L 29.0 6.6 L 30.8 4.7 L 31.7 2.3 L 31.1 .0 L 29.7 -1.3 L 27.7 -1.6","0 25.4 M 20.9 4.6 L 18.7 6.7 L 17.2 7.6 L 14.5 6.9 L 12.7 4.4 L 12.0 .6 L 12.5 -3.8 L 14.5 -8.5 L 17.2 -11.7 L 20.4 -13.2 L 22.0 -12.7 L 22.3 -11.2 L 21.3 -9.4 L 19.6 -7.8 L 17.8 -6.6 L 13.5 -4.4 L 16.0 -5.5 L 18.8 -5.8 L 22.9 -5.8 L 26.6 -6.0 L 28.4 -5.8 L 23.6 -5.9 L 22.4 -2.2 L 22.0 .5 L 21.7 3.5 L 22.3 6.0 L 23.5 7.6 L 24.2 8.1 L 26.5 6.2 L 29.1 3.3 L 32.4 -.8","0 10.8 M 14.7 -17.2 L 13.4 -11.4","0 17.1 M 21.0 -15.6 L 17.6 -11.8 L 15.8 -8.4 L 14.4 -3.7 L 14.2 1.4 L 14.8 5.0 L 16.0 7.5 L 18.5 10.3","0 15.9 M 13.9 -15.5 L 16.4 -12.4 L 17.9 -8.7 L 18.3 -4.6 L 17.5 .4 L 15.9 4.8 L 14.0 7.4 L 11.0 10.3","0 18.7 M 16.5 -5.2 L 18.4 -13.9 M 13.1 -7.4 L 21.7 -11.8 M 14.3 -12.6 L 20.3 -7.0","0 22.9 M 12.2 -1.2 L 25.7 -1.2 M 19.0 -8.0 L 19.0 5.7","0 12.7 M 14.1 7.9 L 12.5 6.3 L 13.6 5.1 L 15.1 6.7 L 14.2 8.9 L 12.7 11.2","0 16.3 M 12.0 -1.3 L 16.5 -1.4 L 19.9 -2.1","0 12.7 M 13.9 5.0 L 12.8 6.1 L 14.0 7.4 L 15.1 6.4 L 13.9 5.0","0 17.5 M 21.6 -15.6 L 17.0 -2.7 L 12.1 9.4","0 20.1 M 18.1 -6.6 L 14.6 -5.2 L 12.5 -2.2 L 11.6 .8 L 11.9 4.2 L 13.2 6.9 L 16.1 7.6 L 19.7 6.2 L 22.1 3.3 L 23.1 -.4 L 22.8 -4.0 L 21.3 -6.1 L 19.6 -6.6 L 18.1 -6.6","0 13.9 M 11.8 -3.7 L 15.9 -6.7 L 13.7 7.6","0 17.4 M 11.9 -4.8 L 14.4 -6.0 L 17.1 -6.4 L 19.0 -5.5 L 19.5 -3.1 L 18.6 -.3 L 16.2 2.6 L 13.3 5.3 L 10.5 7.6 L 13.2 7.6 L 17.9 7.4 L 19.2 7.5 L 19.9 7.4 L 21.3 6.5","0 17.0 M 11.7 -4.6 L 14.3 -5.9 L 17.2 -6.1 L 18.5 -4.9 L 19.1 -2.9 L 18.4 -.9 L 16.8 .7 L 14.9 2.0 L 17.0 2.2 L 18.5 3.3 L 19.1 5.1 L 18.9 7.1 L 17.9 8.8 L 16.1 10.4 L 13.6 10.7 L 11.0 10.3 L 9.0 9.5","0 18.0 M 16.8 11.9 L 19.6 -6.6 L 17.1 -3.6 L 14.9 .6 L 11.8 4.3 L 9.8 7.1 L 17.4 7.1 L 20.0 6.9 L 22.2 6.3","0 18.5 M 10.6 10.6 L 14.2 11.8 L 17.2 11.7 L 19.6 10.0 L 20.5 7.0 L 20.4 4.5 L 19.0 2.9 L 16.6 2.3 L 14.8 2.9 L 12.8 3.5 L 14.2 -5.1 L 15.4 -6.1 L 21.4 -6.0","0 19.2 M 14.2 -.7 L 16.2 -1.8 L 18.5 -2.1 L 20.4 -1.3 L 21.2 .3 L 21.4 2.7 L 20.7 4.8 L 19.0 7.0 L 16.5 7.8 L 13.8 7.1 L 12.4 5.6 L 11.6 2.7 L 12.0 -.8 L 13.4 -4.3 L 15.6 -7.3 L 18.4 -9.2 L 21.2 -10.0 L 23.6 -9.8","0 16.9 M 13.9 11.5 L 15.7 5.2 L 18.1 -.2 L 20.0 -3.7 L 21.0 -5.8 L 16.5 -5.7 L 12.0 -6.2","0 18.9 M 16.2 7.4 L 13.4 6.3 L 12.5 5.2 L 12.2 3.2 L 13.6 .2 L 19.1 -4.4 L 21.0 -7.0 L 21.4 -9.3 L 19.8 -10.6 L 17.1 -10.3 L 15.1 -9.1 L 14.1 -7.2 L 15.2 -4.5 L 19.3 -1.0 L 21.2 1.2 L 21.6 3.6 L 20.3 6.0 L 18.5 7.1 L 16.2 7.4","0 19.2 M 11.7 10.6 L 15.1 10.0 L 18.1 8.2 L 20.2 5.9 L 21.1 2.6 L 21.6 -.2 L 21.3 -3.1 L 20.3 -5.2 L 18.0 -6.6 L 14.7 -6.0 L 12.6 -4.1 L 11.5 -1.4 L 11.9 1.2 L 13.5 3.0 L 16.3 3.3 L 17.8 2.9 L 18.9 2.0","0 13.5 M 14.5 -6.1 L 13.3 -4.7 L 14.5 -3.4 L 15.7 -4.6 L 14.5 -6.1 M 13.4 5.3 L 12.2 6.5 L 13.4 7.6 L 14.4 6.6 L 13.4 5.3","0 13.5 M 14.3 -5.8 L 13.2 -4.7 L 14.3 -3.6 L 15.3 -4.6 L 14.3 -5.8 M 13.6 7.9 L 12.1 6.4 L 13.3 5.2 L 14.6 6.6 L 13.9 8.4 L 11.9 11.0","0 24.6 M 25.8 -5.2 L 19.6 -2.7 L 14.2 .5 L 21.1 4.6 L 26.4 7.1","0 22.7 M 12.9 -2.0 L 26.3 -2.0 M 11.7 3.8 L 25.3 3.8","0 23.0 M 12.7 7.0 L 18.5 4.2 L 24.6 .6 L 19.5 -2.5 L 13.2 -5.2","0 17.7 M 14.3 5.5 L 13.2 6.6 L 14.6 8.0 L 15.6 7.0 L 14.3 5.5 M 13.7 2.4 L 13.3 .0 L 14.2 -2.3 L 16.5 -4.7 L 18.9 -6.9 L 20.6 -9.1 L 21.5 -11.9 L 21.1 -14.0 L 19.7 -15.3 L 17.3 -15.2 L 15.4 -14.1","0 27.1 M 31.2 6.1 L 28.2 8.5 L 24.4 9.9 L 19.3 9.4 L 15.0 6.9 L 12.7 3.2 L 12.9 -3.0 L 14.6 -6.7 L 17.5 -9.9 L 21.6 -11.8 L 27.1 -11.9 L 30.6 -10.2 L 32.6 -6.2 L 32.3 -1.7 L 30.1 1.7 L 27.3 3.3 L 24.2 3.6 L 26.1 -5.8 L 24.6 -2.4 L 22.8 .1 L 20.1 2.2 L 18.7 2.9 L 18.7 .0 L 19.6 -3.5 L 21.6 -5.6 L 24.0 -5.9 L 26.1 -5.7","0 24.4 M 8.6 7.7 L 11.3 7.7 L 12.8 7.0 L 14.5 5.4 L 24.7 -13.0 L 19.2 -13.0 L 15.8 -11.7 L 13.8 -9.5 L 13.1 -7.4 L 12.9 -4.9 M 25.1 -13.1 L 24.7 -1.0 L 18.3 -1.0 L 24.7 -1.0 L 24.8 3.9 L 25.2 6.4 L 26.2 7.6 L 27.0 7.8 L 29.1 6.7","0 22.2 M 10.6 -2.9 L 11.2 -6.5 L 12.5 -9.5 L 15.0 -11.7 L 18.0 -12.9 L 21.2 -13.1 L 24.0 -12.8 L 26.6 -11.6 L 27.3 -9.3 L 26.9 -7.6 L 25.7 -5.6 L 24.0 -4.4 L 22.4 -4.0 L 21.8 -4.1 L 24.3 -3.7 L 26.4 -2.5 L 27.4 -.6 L 27.2 2.1 L 26.0 4.3 L 23.8 6.1 L 21.3 7.1 L 14.8 7.2 L 13.9 7.6 L 15.5 5.8 L 16.7 3.5 L 19.6 -12.8","0 18.8 M 25.3 -12.3 L 22.3 -13.2 L 17.7 -11.8 L 14.7 -8.1 L 12.9 -4.4 L 12.1 -1.0 L 12.2 2.2 L 13.8 5.6 L 15.5 7.4 L 18.3 7.8 L 20.1 6.7 L 22.6 4.5","0 22.1 M 11.4 -3.2 L 11.8 -6.9 L 14.1 -10.7 L 17.1 -12.4 L 20.2 -13.2 L 24.0 -13.0 L 27.1 -11.8 L 29.3 -8.5 L 29.6 -4.6 L 28.7 -.5 L 26.9 2.7 L 24.5 5.5 L 21.9 6.7 L 19.7 7.3 L 14.9 7.1 L 14.2 7.4 L 15.5 6.2 L 16.9 3.7 L 19.9 -12.8","0 21.5 M 10.4 -4.8 L 11.1 -9.0 L 12.1 -10.6 L 13.7 -12.1 L 15.9 -12.9 L 27.0 -12.9 L 18.9 -12.9 L 17.8 -8.4 L 17.2 -4.2 L 24.2 -4.2 L 17.1 -4.2 L 16.5 .2 L 15.9 3.4 L 14.8 5.7 L 14.2 6.8 L 13.0 7.7 L 14.4 7.0 L 23.7 7.1 L 25.6 5.9","0 20.5 M 12.1 7.7 L 14.9 7.6 L 16.5 6.6 L 17.6 4.4 L 19.0 -4.1 L 25.5 -4.1 L 19.0 -4.1 L 20.5 -13.1 L 28.5 -13.1 L 19.4 -13.1 L 16.7 -12.7 L 15.0 -11.7 L 13.4 -10.3 L 12.4 -8.0 L 12.4 -6.6 L 12.5 -5.0","0 19.1 M 26.1 -13.0 L 22.2 -13.7 L 18.6 -12.8 L 15.3 -10.2 L 13.3 -7.0 L 11.7 -3.4 L 11.3 .0 L 11.8 4.1 L 13.5 6.6 L 15.8 7.6 L 18.4 7.0 L 20.7 5.1 L 22.1 3.6 M 19.4 -3.7 L 23.6 -3.7 L 22.8 -1.4 L 21.7 5.7 L 20.9 8.3 L 19.7 10.5 L 18.5 12.2 L 17.4 13.3 L 23.7 13.3","0 25.3 M 9.3 -4.7 L 9.2 -7.3 L 10.1 -9.7 L 11.7 -11.7 L 13.6 -12.7 L 15.3 -13.0 L 18.8 -13.1 L 19.4 -13.3 L 18.6 -12.5 L 17.7 -9.3 L 16.8 -2.6 L 16.0 3.4 L 15.0 5.7 L 13.7 7.2 L 12.2 7.8 L 10.1 7.6 M 25.9 -13.1 L 30.3 -13.1 L 29.5 -12.8 L 28.4 -8.5 L 27.9 -4.0 L 17.3 -4.0 L 27.8 -4.0 L 27.3 -.5 L 26.8 2.5 L 26.3 4.2 L 25.9 5.2 L 25.0 6.4 L 23.7 7.6 L 24.4 7.2 L 28.6 7.2 L 30.8 5.7","0 14.5 M 8.9 -4.7 L 8.9 -7.3 L 10.0 -9.9 L 11.8 -11.9 L 14.0 -13.0 L 16.1 -13.1 L 18.8 -13.2 L 18.2 -13.0 L 17.2 -9.1 L 16.1 -3.1 L 15.4 1.8 L 14.9 4.2 L 14.0 5.7 L 12.9 7.0 L 12.0 8.0 L 13.0 7.2 L 18.0 7.3 L 19.8 5.8","0 14.3 M 6.9 11.4 L 9.0 12.8 L 11.7 13.2 L 14.4 11.3 L 15.8 8.2 L 18.8 -10.6 L 19.3 -12.2 L 20.2 -13.4 L 19.7 -13.0 L 15.3 -12.9 L 12.6 -11.5 L 11.1 -9.4 L 10.6 -7.7 L 10.5 -4.8","0 25.0 M 9.6 -4.8 L 9.7 -7.8 L 11.5 -11.3 L 14.1 -13.0 L 16.4 -13.2 L 19.7 -13.2 L 19.2 -12.8 L 17.8 -8.2 L 16.9 -.9 L 15.8 5.0 L 14.9 6.6 L 13.7 7.6 L 12.0 7.9 L 10.2 7.7 M 29.4 -12.5 L 27.6 -12.9 L 25.6 -12.5 L 22.7 -10.5 L 21.0 -7.5 L 20.5 -5.0 L 20.5 -2.8 L 23.8 3.2 L 29.2 10.8","0 17.2 M 22.7 -12.3 L 20.4 -13.4 L 18.2 -12.9 L 15.9 -11.0 L 14.7 -8.8 L 13.6 -.3 L 13.0 4.0 L 12.3 5.3 L 9.8 7.6 L 11.3 7.0 L 13.5 7.3 L 16.3 9.1 L 19.5 11.4 L 23.0 13.0 L 25.6 13.1 L 27.1 11.7","0 31.3 M 10.4 -4.8 L 10.7 -7.9 L 12.1 -10.9 L 14.1 -12.4 L 16.3 -13.0 L 19.2 -13.1 L 22.7 -12.9 M 8.7 7.7 L 11.4 7.7 L 13.8 6.5 L 14.9 5.2 L 22.2 -12.9 L 23.0 -12.7 L 22.8 6.5 L 25.1 1.7 L 27.7 -4.2 L 30.1 -8.8 L 31.4 -11.0 L 33.6 -13.0 L 33.2 -10.6 L 32.6 -3.5 L 32.5 1.7 L 32.9 7.6 L 35.4 6.0","0 23.1 M 10.0 -4.9 L 10.4 -8.0 L 11.6 -10.8 L 13.5 -12.5 L 15.8 -13.1 L 20.1 -13.1 M 11.0 7.2 L 13.5 7.2 L 14.9 6.4 L 16.1 4.6 L 16.6 2.1 L 17.3 -2.0 L 19.2 -13.1 L 20.2 -13.0 L 22.0 -7.8 L 26.3 5.6 L 26.6 6.5 L 26.2 7.7 L 27.3 5.7 L 28.0 3.0 L 30.1 -8.6 L 30.4 -11.0 L 31.3 -13.1 L 31.9 -13.5 L 30.6 -13.1 L 27.1 -13.1","0 16.4 M 15.0 7.3 L 13.4 6.7 L 12.3 5.7 L 10.7 2.7 L 10.5 -1.2 L 11.5 -5.2 L 13.1 -8.1 L 15.1 -10.4 L 16.9 -12.1 L 19.3 -13.0 L 21.3 -11.9 L 23.1 -8.8 L 23.5 -4.6 L 22.9 -1.1 L 21.6 1.9 L 19.3 4.8 L 17.3 6.4 L 15.0 7.3","0 17.4 M 8.6 -3.7 L 9.2 -7.8 L 11.2 -10.5 L 14.4 -12.5 L 17.1 -13.1 L 20.1 -13.2 L 23.1 -12.6 L 25.1 -11.0 L 25.8 -8.4 L 24.8 -5.7 L 22.5 -3.5 L 20.9 -3.1 L 19.7 -3.2 M 17.9 -13.1 L 16.7 -9.7 L 16.0 -4.3 L 14.4 3.8 L 13.9 5.3 L 13.0 6.7 L 11.3 7.9 L 12.3 7.4 L 17.0 7.3 L 18.8 6.3","0 19.3 M 13.1 .6 L 11.5 -.8 L 10.6 -4.2 L 11.5 -7.8 L 13.0 -10.1 L 15.3 -12.1 L 18.0 -12.8 L 20.1 -13.0 L 22.5 -11.6 L 23.8 -9.0 L 24.1 -6.2 L 23.6 -2.5 L 22.3 .1 L 19.6 3.3 L 17.4 5.1 L 15.2 6.3 L 13.0 6.8 L 9.4 6.9 L 10.0 6.6 L 14.3 7.1 L 16.8 8.4 L 19.2 9.7 L 21.2 10.3 L 23.7 9.9 L 25.8 8.8","0 21.7 M 19.3 6.1 L 17.4 7.2 L 13.6 7.0 L 12.7 7.6 L 13.8 6.3 L 15.4 4.1 L 18.0 -10.9 L 18.7 -13.0 M 9.4 -3.3 L 9.6 -6.2 L 11.1 -9.5 L 13.2 -11.6 L 15.7 -12.7 L 18.4 -13.0 L 20.7 -13.1 L 23.8 -12.6 L 25.6 -11.4 L 26.6 -9.1 L 26.3 -7.0 L 24.9 -5.1 L 23.2 -3.9 L 21.7 -3.6 L 19.7 -3.6 L 22.6 1.4 L 26.5 7.3 L 29.4 10.9","0 16.0 M 9.9 6.5 L 12.4 7.6 L 16.4 7.4 L 18.0 6.0 L 19.2 4.1 L 19.7 1.7 L 19.2 -.5 L 14.1 -7.3 L 13.5 -9.4 L 14.1 -11.7 L 15.9 -12.8 L 17.9 -13.4 L 20.2 -13.2 L 22.5 -12.7","0 19.6 M 9.1 -4.9 L 9.1 -7.5 L 10.2 -10.1 L 11.8 -11.9 L 13.7 -12.9 L 26.8 -12.9 L 19.4 -12.9 L 18.5 -9.5 L 17.6 -2.3 L 16.6 3.3 L 15.3 5.9 L 14.5 6.9 L 13.1 7.8 L 14.2 7.4 L 19.0 7.2 L 20.7 6.0","0 25.8 M 9.1 -4.7 L 9.1 -7.4 L 10.1 -9.9 L 11.9 -12.1 L 13.6 -12.9 L 17.5 -13.0 L 19.1 -13.1 L 18.6 -12.9 L 17.3 -8.8 L 16.4 -2.0 L 15.8 3.5 L 16.5 6.3 L 17.6 7.2 L 19.3 7.2 L 21.2 6.0 L 23.3 3.0 L 24.7 .6 L 26.0 -1.8 L 26.5 -2.7 L 28.5 -12.6 L 29.1 -13.1 L 28.5 -12.5 L 26.1 -1.0 L 25.7 3.3 L 26.0 5.4 L 27.0 6.9 L 28.0 7.1 L 29.3 7.2 L 30.5 6.0","0 22.5 M 8.5 -4.7 L 8.9 -7.6 L 10.2 -10.6 L 12.4 -12.3 L 14.8 -13.0 L 16.9 -12.7 L 18.0 -10.7 L 18.8 -7.4 L 19.1 -3.5 L 19.2 .4 L 19.3 4.0 L 19.1 7.3 L 21.6 2.8 L 24.5 -2.6 L 27.6 -8.8 L 28.9 -12.0 L 28.4 -12.8 L 26.3 -12.8","0 30.8 M 9.1 -4.8 L 9.6 -7.7 L 11.1 -10.8 L 13.8 -12.7 L 16.2 -13.1 L 17.8 -12.3 L 19.0 -10.0 L 19.6 -7.0 L 19.6 4.2 L 19.4 7.0 L 21.1 3.9 L 24.0 -1.5 L 26.6 -7.9 L 28.0 -11.2 L 29.4 -12.2 L 28.3 -10.7 L 27.9 -6.9 L 28.0 -1.4 L 29.0 7.1 L 31.8 1.9 L 34.0 -2.5 L 36.0 -7.0 L 37.0 -10.0 L 37.2 -11.8 L 36.7 -12.5 L 34.8 -12.5","0 25.5 M 9.1 7.2 L 12.1 7.3 L 14.0 6.4 L 16.5 4.1 L 19.4 .0 L 23.8 -7.4 L 26.3 -11.3 L 27.6 -12.7 L 28.6 -13.1 L 30.2 -13.1 L 31.6 -12.6 M 11.4 -6.1 L 11.6 -8.3 L 12.6 -10.8 L 14.0 -12.5 L 16.3 -13.1 L 17.8 -13.2 L 18.9 -11.8 L 19.7 -10.3 L 22.4 .8 L 24.5 6.0 L 25.6 7.3 L 26.7 7.8 L 28.2 7.1 L 30.2 5.6","0 22.2 M 9.3 -6.4 L 9.8 -9.3 L 10.9 -11.7 L 12.3 -13.0 L 14.7 -13.1 L 16.0 -11.8 L 17.2 -8.2 L 18.2 -4.8 L 19.4 -.3 L 20.5 3.2 M 25.6 -12.6 L 27.9 -12.5 L 28.3 -11.7 L 27.3 -9.2 L 21.1 2.1 L 18.1 7.4 L 15.2 11.0 L 13.4 12.3 L 11.8 12.4 L 8.5 10.6","0 22.5 M 12.0 -7.5 L 12.0 -9.4 L 13.1 -11.9 L 14.2 -13.2 L 16.8 -13.7 L 18.9 -13.2 L 21.2 -12.6 L 23.3 -12.2 L 25.4 -12.2 L 26.9 -13.0 L 25.0 -11.2 L 20.3 -5.0 L 16.5 -.2 L 13.8 2.8 L 9.9 6.0 L 10.6 5.8 L 13.1 6.0 L 15.4 7.2 L 21.6 11.0 L 24.3 11.7 L 25.9 11.4 L 27.7 9.3","0 17.0 M 22.1 -15.7 L 17.5 -15.7 L 14.0 10.4 L 18.6 10.3","0 18.8 M 12.4 -15.2 L 17.1 -.1 L 20.5 9.4","0 16.8 M 14.4 -15.7 L 18.8 -15.7 L 15.3 10.2 L 10.9 10.4","0 24.5 M 12.4 -1.8 L 20.0 -11.5 L 26.8 -1.7","0 23.2 M 12.4 8.8 L 27.1 8.8","0 16.7 M 13.3 -13.8 L 15.4 -13.0 L 16.7 -11.9 L 18.6 -9.7","0 13.1 M 16.6 -5.5 L 13.1 -5.7 L 10.6 -4.6 L 8.8 -1.4 L 8.1 2.7 L 8.1 5.9 L 8.4 7.5 L 10.3 5.6 L 13.0 1.8 L 14.7 -1.0 L 16.0 -3.7 L 16.6 -5.1 L 15.2 1.1 L 14.5 4.2 L 14.3 5.9 L 14.1 7.6 L 16.1 6.3 L 19.6 2.1 L 21.1 .0","0 12.1 M 16.0 -16.1 L 13.3 -15.8 L 10.8 -13.7 L 9.6 -11.0 L 8.1 2.1 L 7.7 5.0 L 7.5 6.6 L 7.9 7.9 L 9.9 7.6 L 13.1 5.4 L 14.7 1.9 L 15.4 -1.2 L 15.5 -3.9 L 15.3 -6.1 L 12.6 -3.4 L 9.8 .6 L 7.8 4.9","0 9.8 M 15.6 -5.8 L 14.3 -6.5 L 12.2 -6.1 L 9.9 -3.6 L 9.0 -1.6 L 8.2 .5 L 8.1 2.9 L 8.3 5.2 L 9.0 6.9 L 10.4 8.2 L 12.7 6.1 L 15.2 3.4 L 17.8 -.1","0 13.0 M 23.1 -15.9 L 20.7 -15.9 L 18.5 -14.6 L 17.2 -12.4 L 16.5 -9.4 L 16.0 -5.7 L 15.7 -3.7 L 14.2 -.8 L 12.1 2.9 L 10.1 5.7 L 8.0 7.6 L 7.6 3.9 L 8.1 -.5 L 9.3 -3.3 L 10.3 -4.7 L 11.8 -5.5 L 13.4 -5.9 L 15.0 -5.7 L 15.7 -4.9 L 15.3 -1.2 L 14.9 3.2 L 14.0 7.8 L 16.3 6.0 L 19.0 2.7 L 21.1 -.1","0 9.2 M 8.1 1.2 L 10.3 -.2 L 13.0 -2.9 L 14.0 -4.3 L 14.3 -5.8 L 13.7 -6.4 L 12.4 -6.5 L 10.3 -5.1 L 8.7 -2.8 L 7.8 .6 L 7.4 3.3 L 7.9 5.5 L 9.0 7.1 L 10.0 8.1 L 13.4 4.6 L 15.6 2.1 L 17.1 -.1","0 7.4 M 3.7 13.5 L 5.5 13.7 L 7.4 13.0 L 9.2 11.0 L 9.9 8.7 L 11.0 .3 L 11.7 -5.7 L 9.2 -5.7 L 15.9 -6.0 L 11.7 -5.8 L 12.0 -8.7 L 12.6 -11.8 L 14.1 -14.5 L 15.5 -15.8 L 17.3 -16.2 L 18.0 -16.1 L 19.3 -15.8","0 10.6 M 6.0 13.3 L 6.3 13.3 L 9.1 13.4 L 11.2 12.8 L 12.5 11.5 L 13.7 8.6 L 15.5 -5.8 L 12.1 -5.9 L 10.4 -5.0 L 8.8 -3.1 L 8.0 -.3 L 7.5 2.5 L 7.3 3.9 L 7.3 5.4 L 7.5 7.5 L 9.3 6.1 L 11.6 3.0 L 13.4 .4 L 14.6 -2.4 L 15.5 -4.6","0 12.6 M 15.8 -16.1 L 13.7 -16.1 L 11.8 -15.2 L 9.7 -12.4 L 9.2 -9.3 L 8.6 -5.5 L 8.0 -.9 L 7.5 2.8 L 6.7 7.3 L 8.3 3.6 L 10.6 -.4 L 12.9 -3.7 L 14.7 -5.6 L 15.5 -5.8 L 15.8 -4.1 L 14.9 -.1 L 14.1 3.6 L 13.6 5.8 L 13.3 8.0 L 16.2 5.5 L 19.1 2.1 L 20.5 -.1","0 6.2 M 6.9 -4.2 L 8.5 -5.7 L 9.3 -6.1 L 7.9 2.3 L 7.3 5.2 L 7.3 7.6 L 9.7 5.5 L 11.6 3.4 L 14.3 -.1 M 10.1 -12.2 L 10.1 -10.5 L 9.8 -10.2","0 4.1 M .4 13.4 L 3.1 13.3 L 5.1 11.8 L 6.3 9.8 L 7.1 6.6 L 7.9 2.0 L 8.4 -2.3 L 8.9 -6.3 L 7.2 -5.1 L 6.5 -4.3 M 10.3 -12.4 L 10.0 -11.2 L 9.5 -10.7","0 13.2 M 16.1 -16.0 L 13.9 -16.0 L 11.8 -14.9 L 10.2 -13.0 L 9.4 -10.3 L 7.0 7.7 L 8.7 .2 L 10.9 -3.7 L 12.5 -5.6 L 14.4 -6.4 L 15.7 -6.4 L 16.3 -5.7 L 16.2 -4.0 L 14.9 -2.2 L 13.6 -1.0 L 11.4 .3 L 14.3 7.7 L 17.1 5.1 L 19.3 2.6 L 21.2 -.1","0 6.1 M 16.0 -15.9 L 14.5 -16.2 L 12.2 -15.3 L 10.2 -12.9 L 9.5 -9.9 L 7.3 4.6 L 7.0 7.9 L 9.4 5.8 L 12.5 2.1 L 14.1 -.1","0 18.3 M 6.4 -4.5 L 8.9 -6.4 L 8.4 -2.6 L 7.7 1.6 L 7.2 5.2 L 6.9 7.0 L 8.9 2.6 L 10.9 -1.3 L 12.8 -4.1 L 14.4 -5.8 L 15.2 -6.1 L 15.7 -5.5 L 15.0 -2.4 L 13.9 3.0 L 13.0 7.7 L 14.0 4.4 L 15.7 1.0 L 18.0 -2.6 L 19.7 -5.1 L 21.1 -6.2 L 21.8 -5.8 L 20.8 -.7 L 19.8 3.5 L 19.3 6.1 L 19.2 7.9 L 22.0 5.5 L 24.3 2.7 L 26.3 -.1","0 14.2 M 7.9 -4.4 L 9.8 -6.0 L 10.7 -6.6 L 10.2 -4.2 L 9.6 .0 L 9.0 2.9 L 8.6 5.6 L 8.4 7.3 L 8.5 7.8 L 8.4 5.7 L 10.5 2.8 L 12.1 -.3 L 13.9 -2.9 L 15.8 -5.1 L 16.8 -6.3 L 17.3 -6.3 L 17.6 -4.2 L 16.8 -.3 L 16.1 2.7 L 15.5 5.0 L 15.0 7.9 L 16.8 6.4 L 19.4 3.7 L 20.8 1.7 L 22.2 -.1","0 10.0 M 9.7 7.9 L 10.1 7.9 L 11.9 7.0 L 13.6 5.1 L 15.1 2.3 L 15.9 -.6 L 15.7 -3.4 L 14.8 -4.9 L 14.1 -6.3 L 11.1 -4.9 L 9.2 -2.4 L 7.9 .4 L 7.7 2.9 L 8.1 5.4 L 8.7 6.6 L 9.7 7.9","0 9.2 M 6.6 -4.6 L 9.1 -6.4 L 6.5 10.6 L 5.7 13.1 L 2.7 15.2 L 8.3 12.2 M 8.0 2.7 L 8.3 2.5 L 9.2 -.6 L 11.3 -3.5 L 13.2 -5.5 L 14.3 -6.3 L 14.8 -3.5 L 14.7 -.6 L 14.0 2.5 L 13.0 5.2 L 11.8 6.9 L 10.2 7.5 L 8.9 7.3 L 8.1 6.7 L 7.3 5.4","0 9.5 M 17.0 -6.3 L 15.5 -4.1 L 13.9 -.5 L 11.5 3.8 L 10.0 5.8 L 7.9 7.6 L 7.5 3.6 L 8.2 -.9 L 9.2 -3.4 L 10.7 -5.2 L 13.4 -6.0 L 15.3 -6.1 L 16.3 -5.8 L 14.3 5.0 L 13.1 12.1 L 12.5 13.4 L 9.7 15.3 L 15.3 12.4","0 7.3 M 6.4 -4.3 L 8.2 -5.8 L 9.2 -6.5 L 8.2 -1.1 L 7.4 3.8 L 7.3 6.2 L 7.3 7.2 L 8.2 4.0 L 9.6 .9 L 10.8 -2.3 L 12.3 -4.8 L 13.1 -5.8 L 14.2 -6.3 L 15.5 -6.2","0 10.1 M 16.3 -5.8 L 14.4 -6.7 L 12.8 -6.4 L 11.2 -5.2 L 10.6 -3.7 L 11.2 -1.8 L 12.7 .0 L 14.0 1.8 L 14.8 3.6 L 14.7 5.2 L 13.5 6.7 L 11.8 7.7 L 10.4 8.1 L 8.6 7.3","0 5.8 M 8.9 -8.0 L 8.8 -6.1 L 6.5 -5.9 L 8.8 -6.2 L 13.0 -6.3 L 8.8 -6.2 L 8.2 -.7 L 7.6 3.0 L 7.0 5.2 L 6.3 7.9 L 8.6 6.0 L 11.5 2.8 L 13.6 -.1","0 12.5 M 6.5 -4.6 L 8.6 -6.1 L 9.2 -6.5 L 8.3 -2.5 L 7.9 1.3 L 7.6 3.6 L 7.6 6.5 L 7.6 7.6 L 9.3 6.0 L 11.6 3.0 L 13.1 .2 L 14.7 -3.0 L 16.1 -6.2 L 15.1 -2.2 L 14.3 1.9 L 13.8 5.3 L 13.6 7.7 L 16.0 5.7 L 18.3 2.9 L 20.6 -.1","0 8.0 M 5.1 -4.4 L 5.2 -4.4 L 6.5 -5.8 L 7.9 -6.5 L 8.2 4.3 L 8.5 7.0 L 10.0 5.2 L 11.6 2.3 L 13.0 -1.1 L 13.6 -3.0 L 14.0 -6.5","0 13.0 M 4.9 -4.5 L 6.5 -5.9 L 7.7 -6.5 L 8.1 -6.2 L 7.9 3.0 L 8.1 6.6 L 8.2 7.4 L 10.1 5.0 L 11.6 2.1 L 12.8 -1.1 L 13.4 -2.4 L 14.7 -6.5 L 13.9 -5.7 L 14.2 5.0 L 14.4 7.2 L 16.2 5.2 L 17.8 2.2 L 19.1 -.9 L 19.8 -3.3 L 20.1 -5.8 L 19.9 -6.5","0 13.6 M 9.9 -4.5 L 11.5 -5.8 L 12.8 -6.5 L 17.4 7.8 L 19.0 6.9 L 20.0 5.7 M 8.9 7.5 L 10.4 7.3 L 11.2 6.6 L 12.3 5.2 L 16.0 -.7 L 18.2 -4.8 L 19.3 -5.8 L 20.9 -6.1","0 9.0 M 6.4 -4.6 L 6.7 -4.7 L 8.2 -5.8 L 9.2 -6.5 L 8.2 -.9 L 7.6 4.2 L 7.9 7.3 L 10.4 4.6 L 12.5 1.3 L 14.0 -1.5 L 16.0 -6.0 L 15.0 -1.3 L 14.1 5.4 L 13.3 9.8 L 12.4 11.8 L 11.2 12.9 L 9.4 13.5 L 6.1 13.2","0 12.4 M 10.8 -4.4 L 12.9 -5.8 L 14.2 -6.0 L 16.8 -5.7 L 18.6 -5.7 L 9.2 7.8 L 11.2 7.0 L 13.8 7.2 L 16.5 7.7 L 17.6 7.9 L 18.9 6.9","0 15.6 M 20.8 -15.8 L 18.5 -14.8 L 17.2 -12.5 L 16.6 -8.8 L 16.3 -5.5 L 15.7 -3.7 L 15.0 -3.3 L 13.4 -2.8 L 14.6 -2.1 L 16.0 -.6 L 16.0 1.4 L 14.9 5.7 L 14.5 8.5 L 15.0 10.1 L 16.6 11.3","0 12.2 M 13.6 -17.6 L 13.6 13.3","0 15.2 M 14.5 -15.8 L 16.5 -14.7 L 16.9 -13.5 L 16.7 -10.4 L 16.3 -7.6 L 16.2 -5.1 L 16.5 -3.7 L 17.4 -3.1 L 18.4 -2.6 L 16.9 -2.1 L 15.7 -1.1 L 14.9 .8 L 14.6 3.9 L 14.6 6.9 L 14.3 9.0 L 13.3 10.3 L 11.9 11.4 L 11.2 11.5","0 26.2 M 12.7 .4 L 15.1 -.9 L 17.3 -1.4 L 19.7 -.9 L 22.3 -.1 L 24.2 .6 L 26.4 .7 L 28.8 -.4","0 15.8 M 16.1 -5.9 L 13.9 -6.2 L 12.0 -8.2 L 11.8 -10.8 L 13.1 -13.1 L 15.2 -14.0 L 17.6 -13.5 L 19.1 -11.6 L 19.3 -9.3 L 18.3 -7.0 L 16.1 -5.9"]
EMSHerculean = ["-8 8","0 7.8 M 11.9 -12.9 L 11.9 4.8","0 9.1 M 11.2 -14.5 L 11.2 -10.2 M 14.1 -14.5 L 14.1 -10.2","0 20.6 M 10.8 7.6 L 19.9 -12.9 M 17.0 7.6 L 26.1 -12.9 M 9.5 -5.7 L 27.0 -5.7 M 9.5 -.5 L 27.0 -.5","0 15.9 M 15.7 9.6 L 15.7 -14.6 M 9.9 5.1 L 11.6 6.7 L 13.6 7.7 L 15.3 8.0 L 17.5 7.6 L 19.8 6.2 L 21.3 3.9 L 21.6 1.8 L 21.1 -.8 L 19.6 -2.3 L 17.6 -3.4 L 15.5 -4.5 L 13.5 -5.4 L 11.9 -6.8 L 11.2 -8.3 L 11.5 -10.5 L 12.6 -11.9 L 14.2 -12.9 L 15.9 -13.2 L 17.5 -12.9 L 18.8 -12.3 L 19.8 -11.4","0 20.8 M 10.3 7.6 L 25.8 -13.0 M 13.9 -13.2 L 12.1 -12.8 L 10.7 -11.7 L 9.8 -10.1 L 9.7 -8.5 L 10.2 -7.0 L 11.3 -5.7 L 12.8 -4.9 L 14.6 -4.8 L 16.5 -5.6 L 17.7 -6.9 L 18.1 -8.6 L 18.0 -10.2 L 17.3 -11.5 L 16.3 -12.5 L 15.3 -13.1 L 13.9 -13.2 M 23.1 -.6 L 21.3 -.1 L 19.9 1.0 L 19.0 2.5 L 18.9 4.1 L 19.4 5.6 L 20.5 7.0 L 22.1 7.8 L 23.8 7.9 L 25.7 7.1 L 26.9 5.7 L 27.3 4.1 L 27.2 2.5 L 26.5 1.2 L 25.5 .1 L 24.5 -.4 L 23.1 -.6","0 21.2 M 19.9 -11.6 L 18.8 -12.7 L 17.1 -13.3 L 15.3 -13.0 L 13.9 -12.0 L 12.9 -10.7 L 12.8 -9.1 L 13.2 -7.6 L 14.0 -6.6 L 15.1 -5.9 L 15.8 -5.4 L 16.7 -5.4 L 15.8 -5.4 L 14.1 -4.9 L 12.5 -3.9 L 11.3 -2.5 L 10.4 -.9 L 10.1 .7 L 10.1 2.2 L 10.6 3.8 L 11.6 5.3 L 12.7 6.5 L 14.3 7.5 L 16.0 8.0 L 18.4 7.9 L 20.6 6.9 L 21.8 5.9 L 22.7 4.6 L 23.4 3.5 L 23.7 2.6 L 23.7 7.7 L 23.7 -5.5 L 19.7 -5.5 L 27.8 -5.5","0 6.6 M 11.4 -14.7 L 11.4 -10.4","0 11.0 M 17.2 9.7 L 15.1 7.5 L 13.2 4.5 L 12.2 1.9 L 11.7 -.7 L 11.7 -4.1 L 12.2 -7.0 L 13.8 -10.5 L 15.1 -12.4 L 17.3 -14.5","0 10.7 M 9.4 9.7 L 11.5 7.5 L 13.4 4.5 L 14.4 1.9 L 15.0 -.7 L 14.9 -4.0 L 14.4 -7.0 L 12.8 -10.5 L 11.5 -12.4 L 9.3 -14.4","0 10.4 M 13.2 -12.8 L 13.2 -6.5 M 10.8 -7.3 L 15.6 -12.1 M 9.9 -9.7 L 16.2 -9.6 M 10.7 -12.1 L 15.6 -7.3","0 11.0 M 13.5 .6 L 13.5 -7.4 M 9.4 -3.4 L 17.7 -3.4","0 5.4 M 11.1 7.7 L 10.2 7.7 L 10.2 6.9 L 11.1 6.9 L 11.1 8.0 L 10.7 9.2","0 12.6 M 10.1 -3.4 L 18.3 -3.4","0 5.4 M 11.1 7.7 L 10.2 7.7 L 10.2 6.9 L 11.1 6.9 L 11.1 7.7","0 19.6 M 10.0 7.9 L 25.5 -13.1","0 25.8 M 10.3 -2.9 L 10.9 -6.6 L 12.9 -9.6 L 15.3 -11.7 L 18.7 -13.2 L 22.0 -13.3 L 24.9 -12.6 L 27.5 -11.0 L 29.6 -8.8 L 31.2 -5.6 L 31.4 -1.7 L 30.5 2.0 L 28.7 4.6 L 25.1 7.2 L 21.4 8.1 L 17.2 7.5 L 13.4 5.0 L 11.0 1.3 L 10.2 -1.5 L 10.3 -2.9","0 8.2 M 12.9 7.6 L 12.9 -12.8 L 9.5 -12.8","0 19.3 M 10.0 -5.5 L 10.2 -7.7 L 11.2 -9.7 L 12.8 -11.5 L 14.8 -12.8 L 17.0 -13.1 L 19.1 -13.1 L 21.4 -12.2 L 22.9 -10.9 L 24.5 -8.7 L 25.0 -6.0 L 24.8 -3.9 L 23.8 -1.6 L 22.2 .2 L 20.1 2.0 L 11.0 7.6 L 25.0 7.6","0 18.1 M 10.1 1.2 L 10.3 3.4 L 11.3 5.1 L 12.6 6.6 L 14.5 7.6 L 16.8 7.9 L 19.3 7.5 L 21.6 6.1 L 23.1 4.3 L 23.7 2.1 L 23.6 -.5 L 22.7 -2.5 L 21.3 -4.1 L 20.2 -4.8 L 21.2 -6.0 L 21.8 -7.6 L 21.7 -9.7 L 21.0 -11.3 L 19.8 -12.3 L 18.0 -13.1 L 15.8 -13.2 L 14.3 -12.4 L 13.2 -11.4 L 12.4 -10.3 L 12.0 -9.3 L 12.0 -8.8","0 15.4 M 19.4 7.7 L 19.4 -12.0 L 10.0 4.9 L 22.0 4.9","0 20.0 M 10.5 2.7 L 11.6 4.7 L 13.2 6.4 L 15.2 7.5 L 17.5 7.9 L 20.3 7.6 L 22.7 6.2 L 24.4 4.2 L 25.5 1.4 L 25.4 -1.0 L 24.4 -3.6 L 22.8 -5.6 L 21.0 -6.8 L 18.7 -7.4 L 16.1 -7.3 L 14.0 -6.4 L 12.6 -5.3 L 11.5 -4.1 L 12.3 -12.9 L 23.1 -12.9","0 19.3 M 19.2 -13.1 L 11.4 -4.0 L 10.3 -1.6 L 10.0 .8 L 10.6 3.0 L 11.8 5.1 L 13.3 6.5 L 15.3 7.6 L 17.3 8.0 L 19.6 7.7 L 21.8 6.7 L 23.9 5.0 L 25.1 2.5 L 25.3 .1 L 24.9 -2.3 L 23.6 -4.5 L 22.4 -5.7 L 20.7 -6.8 L 18.4 -7.4 L 15.9 -7.2 L 14.0 -6.4 L 12.7 -5.5","0 16.6 M 12.0 7.7 L 22.7 -12.9 L 9.7 -12.9","0 17.5 M 17.1 8.0 L 18.7 7.7 L 20.6 6.9 L 22.2 5.4 L 23.2 3.5 L 23.6 1.6 L 23.4 -.4 L 22.5 -2.4 L 21.3 -3.8 L 19.6 -4.9 L 17.9 -5.4 L 15.4 -5.5 L 14.3 -6.3 L 13.1 -7.6 L 12.7 -9.0 L 12.9 -10.7 L 13.8 -12.1 L 15.2 -13.0 L 16.6 -13.3 L 18.1 -13.0 L 19.4 -12.1 L 20.3 -11.0 L 20.7 -9.4 L 20.5 -8.2 L 19.9 -7.0 L 18.9 -6.1 L 18.0 -5.6 L 16.9 -5.5 L 15.0 -5.3 L 13.2 -4.6 L 11.8 -3.4 L 10.8 -1.9 L 10.2 -.4 L 10.0 1.1 L 10.2 2.6 L 10.7 4.3 L 11.7 5.7 L 13.1 6.9 L 14.5 7.6 L 16.0 8.0 L 17.1 8.0","0 19.3 M 16.1 7.8 L 23.7 -1.1 L 24.9 -3.3 L 25.2 -5.8 L 24.8 -8.3 L 23.7 -10.3 L 21.7 -12.1 L 19.8 -13.0 L 16.7 -13.2 L 14.0 -12.5 L 12.1 -10.9 L 10.5 -8.7 L 10.0 -6.6 L 10.1 -4.4 L 10.7 -2.5 L 12.0 -.6 L 13.7 1.0 L 16.0 1.9 L 18.1 2.1 L 20.8 1.4 L 22.4 .3 L 23.3 -.6","0 8.2 M 12.5 .1 L 11.6 .1 L 11.6 -.7 L 12.5 -.7 L 12.5 .1 M 12.5 7.7 L 11.6 7.7 L 11.6 6.9 L 12.5 6.9 L 12.5 7.7","0 8.3 M 12.6 7.7 L 11.7 7.7 L 11.7 6.9 L 12.6 6.9 L 12.6 8.0 L 12.2 9.2 M 12.6 .1 L 11.7 .1 L 11.7 -.7 L 12.6 -.7 L 12.6 .1","0 13.1 M 19.6 .9 L 11.0 -4.2 L 19.6 -9.2","0 12.9 M 10.5 -1.9 L 18.7 -1.9 M 10.5 -5.5 L 18.7 -5.5","0 13.2 M 10.9 .9 L 19.5 -4.2 L 10.9 -9.3","0 19.6 M 17.4 5.0 L 17.4 .3 L 19.5 .0 L 21.5 -1.1 L 22.8 -2.4 L 23.9 -4.6 L 24.2 -6.7 L 23.9 -8.8 L 22.7 -10.7 L 21.0 -12.3 L 18.8 -13.1 L 16.1 -13.2 L 13.8 -12.5 L 11.8 -10.9 L 10.9 -9.2 L 10.4 -6.8 M 17.8 7.7 L 16.9 7.7 L 16.9 6.9 L 17.8 6.9 L 17.8 7.7","0 26.4 M 21.1 8.0 L 24.0 7.7 L 26.4 6.6 L 28.5 5.0 L 30.4 2.7 L 31.5 -.2 L 31.8 -2.6 L 31.4 -5.7 L 30.1 -8.4 L 27.9 -10.8 L 24.7 -12.8 L 21.1 -13.3 L 18.1 -12.9 L 15.3 -11.5 L 12.5 -8.7 L 11.1 -6.3 L 10.5 -2.9 L 10.7 -.2 L 12.0 2.7 L 13.9 5.0 L 16.4 6.9 L 18.6 7.8 L 21.1 8.0 M 27.3 3.3 L 27.3 -4.8 L 25.9 -6.8 L 23.4 -8.6 L 21.1 -8.9 L 18.8 -8.5 L 16.8 -7.2 L 15.5 -5.3 L 15.0 -3.3 L 15.0 -1.5 L 15.6 .4 L 17.2 2.2 L 19.1 3.4 L 21.5 3.7 L 24.3 2.9 L 26.2 1.3 L 27.0 -.2 L 27.3 -1.2","0 24.2 M 10.1 7.6 L 20.1 -12.8 L 30.1 7.5 L 26.1 -.6 L 14.1 -.6","0 12.6 M 11.3 7.6 L 11.3 -13.0 L 12.3 -13.0 L 13.6 -12.5 L 14.6 -11.8 L 15.4 -10.8 L 15.6 -9.9 L 15.7 -8.7 L 15.2 -7.5 L 14.3 -6.4 L 13.4 -5.7 L 12.4 -5.5 L 11.3 -5.5 L 12.4 -5.5 L 13.8 -5.2 L 15.0 -4.7 L 16.1 -4.0 L 17.0 -3.0 L 17.8 -1.9 L 18.2 -.7 L 18.5 .7 L 18.3 2.1 L 17.9 3.8 L 17.1 5.0 L 16.0 6.1 L 14.6 7.0 L 13.3 7.5 L 12.0 7.6 L 11.3 7.6","0 21.1 M 26.6 6.3 L 23.8 7.6 L 21.5 7.9 L 17.9 7.5 L 15.2 6.1 L 13.0 4.1 L 11.2 1.4 L 10.4 -1.2 L 10.4 -3.6 L 11.1 -6.8 L 12.3 -8.9 L 13.9 -10.5 L 15.7 -11.9 L 18.1 -13.0 L 20.7 -13.4 L 22.9 -13.2 L 24.9 -12.6 L 26.7 -11.7","0 16.2 M 14.7 7.3 L 17.3 6.2 L 19.4 4.2 L 21.1 1.5 L 21.9 -1.1 L 21.9 -3.6 L 21.2 -6.7 L 20.1 -8.8 L 18.6 -10.5 L 16.8 -11.9 L 14.5 -12.7 L 12.6 -13.0 L 11.3 -12.9 L 11.3 7.6 L 13.1 7.6 L 14.7 7.3","0 11.9 M 18.3 7.5 L 11.3 7.5 L 11.3 -.5 L 17.0 -.5 L 11.3 -.5 L 11.3 -12.9 L 18.2 -12.9","0 11.9 M 11.3 7.6 L 11.3 -.5 L 17.1 -.5 L 11.3 -.5 L 11.3 -12.9 L 18.2 -12.9","0 21.2 M 26.4 -11.8 L 24.9 -12.6 L 22.8 -13.1 L 20.6 -13.4 L 17.9 -12.9 L 15.6 -11.9 L 13.8 -10.5 L 12.2 -8.8 L 11.0 -6.7 L 10.3 -3.6 L 10.3 -1.1 L 11.1 1.5 L 12.8 4.2 L 15.1 6.2 L 17.7 7.5 L 21.4 7.9 L 23.7 7.6 L 26.4 6.4 L 26.4 -.6 L 19.2 -.6","0 22.1 M 11.3 -13.1 L 11.3 7.6 L 11.3 -.5 L 26.8 -.5 L 26.8 7.6 L 26.8 -13.1","0 6.6 M 11.4 7.6 L 11.4 -13.0","0 14.7 M 9.5 6.4 L 10.7 7.3 L 11.8 7.8 L 13.1 8.0 L 14.7 8.0 L 16.5 7.3 L 17.8 6.3 L 18.7 4.9 L 19.2 3.6 L 19.4 2.4 L 19.4 -12.9 L 14.0 -12.9","0 17.8 M 11.3 7.6 L 11.3 -13.0 M 21.0 -13.1 L 11.5 -4.8 L 23.5 7.6","0 11.6 M 11.3 -13.0 L 11.3 7.6 L 18.0 7.6","0 27.4 M 11.3 7.6 L 11.3 -12.9 L 11.9 -12.9 L 21.7 7.3 L 31.8 -12.9 L 32.2 -12.9 L 32.2 7.5","0 22.4 M 11.2 7.5 L 11.2 -12.3 L 27.0 7.2 L 27.0 -12.8","0 26.1 M 26.6 6.4 L 23.9 7.6 L 21.5 8.0 L 17.9 7.5 L 15.3 6.2 L 13.0 4.2 L 11.3 1.5 L 10.5 -1.1 L 10.4 -3.6 L 11.2 -6.7 L 12.3 -8.8 L 13.9 -10.5 L 15.7 -11.9 L 18.1 -12.9 L 20.8 -13.3 L 23.0 -13.1 L 25.0 -12.5 L 26.7 -11.6 L 28.2 -10.6 L 29.7 -8.8 L 31.1 -6.4 L 31.7 -3.8 L 31.5 -.7 L 30.5 2.2 L 29.0 4.4 L 26.6 6.4","0 12.3 M 11.3 7.6 L 11.3 -12.9 L 13.5 -12.8 L 15.4 -11.9 L 16.8 -10.7 L 17.9 -9.0 L 18.4 -6.7 L 18.1 -4.7 L 16.9 -2.5 L 15.1 -.9 L 13.2 -.2 L 11.4 -.2","0 26.1 M 22.5 1.4 L 29.2 8.1 M 26.6 6.4 L 23.8 7.6 L 21.5 8.0 L 17.8 7.5 L 15.2 6.2 L 12.9 4.2 L 11.2 1.5 L 10.4 -1.1 L 10.3 -3.5 L 11.1 -6.7 L 12.3 -8.8 L 13.9 -10.4 L 15.7 -11.9 L 18.0 -12.9 L 20.7 -13.3 L 22.9 -13.1 L 24.9 -12.5 L 26.7 -11.6 L 28.1 -10.6 L 29.6 -8.8 L 31.0 -6.4 L 31.6 -3.8 L 31.5 -.7 L 30.5 2.2 L 28.9 4.4 L 26.6 6.4","0 13.1 M 11.2 7.6 L 11.2 -12.8 L 12.9 -12.8 L 14.8 -12.3 L 16.5 -11.0 L 17.8 -9.3 L 18.4 -7.9 L 18.5 -6.1 L 18.2 -4.6 L 17.3 -3.0 L 16.2 -1.5 L 14.4 -.6 L 12.8 -.1 L 11.2 .0 L 11.4 .4 L 18.5 7.6","0 15.7 M 10.0 5.1 L 11.3 6.5 L 12.6 7.4 L 14.1 8.0 L 15.8 8.0 L 17.7 7.7 L 19.8 6.4 L 21.1 4.3 L 21.2 1.7 L 20.7 -.3 L 19.5 -1.8 L 17.4 -3.3 L 15.0 -4.7 L 13.4 -5.9 L 12.0 -7.3 L 11.3 -8.7 L 11.3 -10.6 L 12.1 -12.0 L 13.6 -13.1 L 15.5 -13.3 L 17.3 -12.9 L 18.5 -12.2 L 19.1 -11.4","0 13.1 M 14.6 7.6 L 14.6 -12.9 L 9.5 -12.9 L 19.6 -12.9","0 18.5 M 11.3 -13.0 L 11.3 2.9 L 11.9 4.9 L 13.1 6.4 L 14.7 7.5 L 16.4 8.0 L 18.3 8.0 L 20.4 7.2 L 22.4 5.1 L 22.9 3.7 L 23.1 2.8 L 23.1 -13.0","0 23.7 M 9.8 -13.1 L 19.9 7.4 L 29.9 -13.0","0 30.4 M 9.9 -13.0 L 18.6 7.2 L 27.6 -13.0 M 18.9 -13.0 L 27.7 7.3 L 36.7 -13.1","0 15.0 M 9.9 7.6 L 20.0 -13.0 M 11.0 -13.0 L 21.1 7.6","0 16.6 M 9.9 -13.0 L 16.3 -.8 L 16.3 7.6 L 16.3 -.8 L 22.4 -13.0","0 13.5 M 9.4 -12.9 L 19.1 -12.9 L 9.7 7.5 L 19.6 7.5","0 7.3 M 14.0 10.0 L 11.1 10.0 L 11.1 -14.7 L 14.1 -14.7","0 19.9 M 10.1 -13.0 L 25.5 7.6","0 7.6 M 9.5 9.9 L 12.4 9.9 L 12.4 -14.8 L 9.4 -14.8","0 10.7 M 9.7 -7.7 L 13.1 -10.9 L 16.5 -7.7","0 11.5 M 9.6 7.6 L 17.9 7.6","0 7.2 M 10.0 -10.1 L 13.3 -7.3","0 17.5 M 22.8 1.3 L 22.7 -.1 L 21.5 -2.1 L 19.6 -3.9 L 17.1 -4.7 L 14.5 -4.4 L 12.4 -3.2 L 10.9 -1.4 L 10.1 .5 L 10.2 2.7 L 11.0 4.9 L 12.4 6.5 L 14.7 7.7 L 16.9 7.9 L 19.8 7.0 L 21.5 5.3 L 22.5 3.6 L 22.9 2.1 L 22.9 -4.5 L 22.9 7.6","0 17.9 M 11.0 1.3 L 11.1 -.1 L 12.2 -2.1 L 14.2 -3.9 L 16.7 -4.8 L 19.2 -4.4 L 21.4 -3.2 L 22.9 -1.4 L 23.6 .5 L 23.6 2.7 L 22.8 4.9 L 21.4 6.5 L 19.1 7.7 L 16.9 7.9 L 14.0 7.0 L 12.3 5.3 L 11.3 3.5 L 10.9 2.1 L 10.9 -12.7 L 10.9 7.6","0 14.7 M 21.3 5.8 L 20.2 6.7 L 18.2 7.8 L 16.1 8.1 L 14.2 7.7 L 11.9 6.3 L 10.7 4.5 L 10.0 1.9 L 10.2 -.2 L 11.7 -2.6 L 13.8 -4.2 L 16.0 -4.7 L 18.3 -4.4 L 20.1 -3.6 L 21.2 -2.5","0 17.8 M 22.6 1.3 L 22.5 -.1 L 21.4 -2.1 L 19.5 -3.9 L 17.0 -4.8 L 14.4 -4.4 L 12.3 -3.2 L 10.8 -1.4 L 10.0 .5 L 10.1 2.7 L 10.8 4.9 L 12.3 6.5 L 14.5 7.7 L 16.8 7.9 L 19.7 7.0 L 21.4 5.3 L 22.4 3.5 L 22.7 2.1 L 22.7 -12.7 L 22.7 7.5","0 15.3 M 12.2 6.0 L 21.1 -2.7 L 19.6 -4.1 L 17.7 -4.7 L 15.5 -4.6 L 13.5 -3.9 L 11.6 -2.4 L 10.5 -.5 L 10.2 1.7 L 10.5 3.6 L 11.3 5.0 L 12.7 6.5 L 14.0 7.4 L 15.2 7.9 L 16.7 8.1 L 18.8 7.6 L 20.5 6.6 L 21.4 5.7","0 8.4 M 10.8 7.6 L 10.8 2.7 L 14.9 2.7 L 10.8 2.7 L 10.8 -5.7 L 11.3 -7.5 L 12.3 -8.7 L 13.5 -9.3 L 14.9 -9.6","0 17.8 M 22.7 1.4 L 22.6 .0 L 21.5 -2.0 L 19.6 -3.9 L 17.1 -4.7 L 14.5 -4.3 L 12.3 -3.1 L 10.9 -1.4 L 10.1 .6 L 10.1 2.8 L 10.9 4.9 L 12.4 6.5 L 14.6 7.8 L 16.8 8.0 L 19.7 7.1 L 21.5 5.4 L 22.5 3.6 L 22.8 2.2 L 22.8 -4.5 L 22.8 7.6 L 22.4 9.5 L 21.7 11.0 L 20.4 12.3 L 18.5 13.3 L 16.4 13.6 L 14.2 13.1 L 12.5 12.1 L 11.3 11.0","0 15.9 M 10.9 -13.0 L 10.9 7.5 L 10.9 -1.0 L 12.3 -3.0 L 14.3 -4.5 L 16.2 -4.8 L 18.1 -4.5 L 19.7 -3.5 L 20.8 -2.1 L 21.5 .0 L 21.5 7.5","0 6.3 M 11.2 7.6 L 11.2 -4.4 M 10.9 -8.3 L 11.0 -9.0 L 11.7 -9.0 L 11.7 -8.3 L 10.9 -8.3","0 8.3 M 12.9 -4.4 L 12.9 10.0 L 12.2 11.4 L 11.4 12.2 L 10.1 13.0 L 8.9 13.2 M 12.6 -8.3 L 12.6 -9.0 L 13.3 -9.0 L 13.3 -8.3 L 12.6 -8.3","0 12.6 M 10.9 7.6 L 10.9 -13.0 M 16.7 -4.6 L 11.1 .3 L 18.0 7.6","0 8.4 M 10.8 -13.0 L 10.8 4.1 L 11.1 5.4 L 12.1 6.5 L 12.9 7.3 L 14.0 7.8 L 14.8 7.8","0 22.7 M 10.8 7.5 L 10.8 -4.5 L 10.8 -2.0 L 12.1 -3.4 L 13.7 -4.5 L 15.3 -4.9 L 16.8 -4.5 L 18.2 -3.4 L 18.9 -2.3 L 19.3 -1.2 L 19.3 7.6 L 19.3 -1.4 L 19.9 -2.8 L 21.2 -4.1 L 23.4 -4.8 L 25.2 -4.6 L 26.7 -3.5 L 27.6 -1.8 L 27.6 7.5","0 16.2 M 10.5 7.6 L 10.5 -4.5 L 10.5 -1.0 L 11.6 -2.7 L 13.2 -4.1 L 15.0 -4.7 L 16.7 -4.8 L 18.4 -4.2 L 19.7 -2.9 L 20.8 -1.4 L 21.1 .2 L 21.1 7.6","0 16.9 M 10.1 1.4 L 10.7 -1.0 L 12.2 -3.1 L 14.1 -4.3 L 15.9 -4.7 L 17.9 -4.6 L 19.7 -3.8 L 21.5 -2.4 L 22.6 -.2 L 22.7 2.4 L 22.2 4.5 L 20.7 6.3 L 18.6 7.7 L 16.7 8.0 L 14.7 7.7 L 12.8 6.7 L 11.2 5.1 L 10.2 3.0 L 10.1 1.4","0 17.5 M 10.9 2.0 L 11.0 3.4 L 12.1 5.4 L 14.1 7.2 L 16.6 8.0 L 19.1 7.6 L 21.3 6.5 L 22.8 4.7 L 23.5 2.7 L 23.5 .6 L 22.7 -1.6 L 21.3 -3.2 L 19.0 -4.4 L 16.8 -4.7 L 13.9 -3.7 L 12.2 -2.0 L 11.2 -.3 L 10.8 1.2 L 10.8 13.3 L 10.8 -4.3","0 17.4 M 22.6 1.9 L 22.5 3.3 L 21.4 5.3 L 19.5 7.1 L 17.0 8.0 L 14.4 7.6 L 12.3 6.4 L 10.8 4.6 L 10.0 2.7 L 10.1 .5 L 10.8 -1.7 L 12.3 -3.3 L 14.5 -4.5 L 16.8 -4.7 L 19.7 -3.8 L 21.4 -2.1 L 22.4 -.3 L 22.7 1.1 L 22.7 13.2 L 22.7 -4.3","0 11.3 M 10.8 7.6 L 10.8 -4.4 L 10.8 -2.0 L 11.9 -3.3 L 12.9 -4.1 L 14.3 -4.7 L 15.5 -4.7 L 16.6 -4.5 L 17.4 -4.1 L 17.8 -3.8","0 11.2 M 9.7 6.2 L 10.7 7.2 L 12.1 7.9 L 13.3 8.0 L 14.8 7.6 L 16.0 6.7 L 16.8 5.5 L 17.0 4.4 L 16.7 3.0 L 15.9 1.9 L 14.6 1.1 L 13.1 .1 L 11.6 -.9 L 10.9 -2.0 L 10.9 -3.4 L 11.7 -4.5 L 12.9 -4.8 L 14.0 -4.7 L 14.7 -4.4 L 15.2 -3.9","0 8.2 M 14.6 7.8 L 13.4 7.6 L 12.2 6.9 L 11.2 5.9 L 10.6 4.6 L 10.5 3.2 L 10.5 -4.3 L 14.5 -4.3 L 10.5 -4.3 L 10.5 -9.5","0 15.6 M 21.2 -4.6 L 21.2 7.6 L 21.2 4.0 L 20.2 5.7 L 18.5 7.2 L 16.4 8.0 L 14.0 7.7 L 12.1 6.4 L 11.1 5.0 L 10.6 3.3 L 10.6 2.1 L 10.6 -4.4","0 15.6 M 10.1 -4.5 L 15.8 7.3 L 21.5 -4.6","0 20.8 M 10.0 -4.5 L 15.6 7.4 L 21.2 -4.5 M 15.8 -4.6 L 21.4 7.4 L 26.8 -4.4","0 13.4 M 9.7 7.6 L 17.8 -4.6 M 11.2 -4.6 L 19.3 7.6","0 15.9 M 10.5 -4.5 L 10.5 2.9 L 10.8 4.3 L 11.8 6.1 L 13.6 7.5 L 15.5 8.0 L 17.3 7.9 L 19.2 6.7 L 20.5 5.2 L 21.2 3.7 L 21.2 -4.5 L 21.2 8.2 L 20.6 10.1 L 19.5 11.6 L 18.0 12.7 L 16.3 13.3 L 14.6 13.3 L 12.7 12.5 L 11.6 11.7 L 11.0 11.0","0 11.6 M 10.5 -4.4 L 17.4 -4.4 L 10.2 7.6 L 18.0 7.6","0 8.5 M 15.2 9.6 L 14.1 8.7 L 13.3 7.6 L 12.7 6.0 L 12.7 .1 L 12.3 -1.3 L 11.4 -2.3 L 10.6 -2.6 L 11.9 -3.5 L 12.7 -4.6 L 12.9 -5.7 L 12.9 -11.3 L 13.1 -12.3 L 13.8 -13.4 L 14.5 -14.2 L 15.1 -14.7","0 6.6 M 11.3 7.6 L 11.3 -12.9","0 8.8 M 9.4 9.6 L 10.6 8.7 L 11.3 7.6 L 11.9 6.1 L 11.9 .1 L 12.3 -1.2 L 13.3 -2.2 L 14.0 -2.6 L 12.7 -3.4 L 12.0 -4.6 L 11.8 -5.6 L 11.8 -11.2 L 11.5 -12.2 L 10.9 -13.4 L 10.1 -14.2 L 9.5 -14.6","0 16.7 M 11.2 -2.1 L 12.2 -3.1 L 13.4 -3.5 L 14.7 -3.3 L 16.2 -2.6 L 17.4 -1.9 L 18.8 -1.4 L 20.0 -1.3 L 21.0 -2.0 L 21.5 -2.6","0 6.7 M 9.6 -11.1 L 9.9 -12.2 L 10.9 -13.0 L 12.0 -13.0 L 12.9 -12.2 L 13.2 -11.1 L 12.9 -10.0 L 11.8 -9.3 L 10.6 -9.5 L 10.0 -10.1 L 9.6 -11.1"]
EMSInvite = ["-8 8","0 9.1 M 22.4 -15.6 L 15.2 2.0 M 14.2 5.6 L 13.1 7.2","0 10.3 M 16.2 -10.0 L 12.3 -4.5 M 20.5 -9.8 L 16.7 -4.6","0 13.4 M 17.7 -5.9 L 16.2 -4.0 L 14.6 -.4 L 11.7 7.8 M 22.5 -5.9 L 20.6 -3.5 L 19.0 -.9 L 15.7 7.6 M 12.7 -2.2 L 22.9 -2.5 M 10.9 2.6 L 20.6 2.5","0 13.1 M 20.7 -2.8 L 21.1 -4.3 L 20.4 -5.0 L 18.7 -5.7 L 16.5 -5.3 L 15.2 -4.1 L 15.0 -2.4 L 15.8 -.6 L 17.5 1.3 L 18.5 3.0 L 18.8 4.2 L 18.4 5.8 L 17.1 7.1 L 15.2 7.7 L 13.8 7.7 L 12.1 7.4 L 11.1 6.5 L 10.8 5.8 L 12.0 3.7 M 20.7 -8.7 L 12.3 10.7","0 17.7 M 11.1 10.7 L 25.0 -8.5 M 14.9 -5.4 L 12.9 -4.8 L 11.3 -3.1 L 10.7 -1.2 L 10.6 .5 L 11.7 1.9 L 13.4 1.9 L 15.3 .6 L 16.3 -1.2 L 16.8 -3.1 L 16.5 -4.6 L 16.1 -5.1 L 14.9 -5.4 M 23.4 .2 L 21.9 .4 L 20.3 1.7 L 19.5 3.2 L 19.3 5.1 L 19.6 6.7 L 20.8 7.6 L 22.1 7.4 L 23.4 6.5 L 24.7 4.8 L 25.4 2.3 L 25.0 .7 L 24.5 .3 L 23.4 .2","0 23.6 M 31.4 5.7 L 29.8 7.1 L 26.9 7.5 L 24.1 6.6 L 21.3 4.4 L 19.4 1.7 L 18.2 -1.6 L 17.2 -6.0 L 17.3 -9.3 L 18.7 -11.9 L 20.3 -12.8 L 21.7 -12.7 L 22.4 -11.9 L 22.6 -10.2 L 22.3 -8.7 L 21.7 -7.3 L 20.6 -5.8 L 19.5 -4.8 L 16.5 -3.0 L 14.5 -1.8 L 12.4 .2 L 11.4 2.4 L 11.8 4.4 L 12.7 6.1 L 15.1 7.3 L 18.1 7.4 L 20.4 6.3 L 23.0 3.8 L 24.9 .8 L 27.1 -1.6 L 28.9 -2.6 L 30.8 -2.8 L 31.6 -2.2 L 32.1 -1.3","0 6.1 M 16.4 -10.0 L 12.4 -4.6","0 12.1 M 24.0 -20.5 L 20.0 -15.6 L 16.8 -8.8 L 15.2 -2.6 L 14.6 3.7 L 14.8 8.4 L 15.8 12.2","0 13.1 M 19.5 -20.2 L 20.6 -14.6 L 20.3 -7.4 L 18.9 -.6 L 16.4 5.5 L 14.1 9.1 L 11.1 12.2","0 9.1 M 15.5 -10.0 L 14.3 -6.4 L 18.1 -7.5 M 11.5 -7.3 L 14.3 -6.6 L 12.0 -3.4 M 16.4 -3.4 L 14.2 -6.6","0 14.0 M 18.1 -3.0 L 15.0 6.1 M 12.3 1.6 L 21.1 1.4","0 5.9 M 11.9 6.3 L 13.0 5.8 L 12.8 7.8 L 11.4 10.2 L 10.4 11.3","0 11.7 M 11.5 1.3 L 18.6 .8","0 5.6 M 12.2 6.1 L 11.5 7.1","0 10.0 M 26.0 -20.2 L 9.1 9.3","0 16.5 M 20.6 -5.4 L 16.7 -4.3 L 14.1 -1.9 L 12.9 1.9 L 13.2 4.6 L 14.5 6.7 L 16.7 7.4 L 19.5 6.8 L 21.5 5.4 L 23.8 2.0 L 24.3 -1.5 L 23.7 -3.5 L 22.3 -4.9 L 20.6 -5.4","0 9.0 M 12.9 -3.7 L 15.1 -4.1 L 17.4 -5.1 L 19.3 -6.6 L 17.3 -4.3 L 13.7 3.4 L 12.2 7.8","0 13.0 M 13.3 -1.7 L 14.3 -3.7 L 16.4 -5.2 L 18.5 -5.4 L 19.8 -4.9 L 20.8 -3.4 L 20.8 -1.8 L 20.1 .0 L 18.4 2.0 L 16.9 3.2 L 10.2 7.6 L 11.8 6.4 L 13.0 6.3 L 15.0 7.0 L 17.0 7.3 L 18.9 7.1 L 20.1 6.5 L 20.6 5.9","0 12.2 M 13.6 -3.8 L 15.6 -5.3 L 18.4 -5.5 L 20.2 -4.1 L 20.6 -1.5 L 19.2 .3 L 17.1 1.7 L 12.8 3.3 L 15.1 2.9 L 17.3 3.6 L 18.8 5.2 L 19.2 7.5 L 18.8 10.2 L 17.4 12.0 L 14.5 14.1 L 11.0 15.0 L 8.8 14.7 L 7.8 13.9 L 7.5 13.0","0 17.0 M 18.5 7.9 L 21.3 -1.0 L 24.5 -7.5 L 26.1 -10.8 L 29.2 -14.2 L 21.9 -8.8 L 16.4 -3.8 L 11.9 .9 L 13.7 .6 L 16.5 1.0 L 20.5 1.5 L 22.8 1.8 L 25.4 1.1 L 26.3 .0","0 11.9 M 6.5 12.7 L 8.1 14.2 L 10.6 14.5 L 13.6 13.4 L 15.7 11.9 L 17.3 9.4 L 17.8 7.2 L 17.6 4.8 L 16.7 3.3 L 15.3 2.2 L 13.4 1.0 L 13.5 -.4 L 14.3 -3.0 L 15.4 -5.2 L 20.6 -5.2 L 21.0 -5.2 L 21.8 -5.8","0 13.7 M 29.0 -11.4 L 27.4 -13.4 L 24.6 -13.6 L 21.3 -12.3 L 18.4 -10.0 L 16.1 -7.0 L 14.4 -3.7 L 13.2 -.3 L 12.7 2.9 L 13.1 5.6 L 14.5 7.2 L 16.5 7.4 L 19.7 5.2 L 21.3 2.8 L 22.0 -.5 L 21.5 -2.8 L 20.1 -4.2 L 17.7 -4.3 L 15.8 -3.2 L 14.6 -1.9 L 13.1 1.2","0 15.7 M 13.2 -.7 L 14.3 -3.3 L 15.2 -4.7 L 17.1 -5.2 L 20.7 -5.0 L 23.0 -4.6 L 24.4 -4.4 L 25.9 -5.3 L 22.4 .2 L 17.8 5.8 L 13.3 11.3 L 10.8 14.5 L 9.9 15.2","0 14.1 M 16.3 7.4 L 18.5 6.9 L 20.7 5.4 L 22.0 3.1 L 22.1 .6 L 21.2 -1.4 L 19.8 -3.2 L 17.3 -6.4 L 16.6 -8.3 L 17.0 -10.7 L 17.9 -12.1 L 19.8 -12.8 L 22.3 -12.7 L 24.1 -11.3 L 24.5 -8.8 L 23.8 -6.9 L 21.8 -5.4 L 15.6 -2.5 L 12.9 -.4 L 11.6 2.7 L 12.2 5.6 L 14.1 7.4 L 16.3 7.4","0 14.3 M 7.9 13.2 L 9.6 14.4 L 12.7 14.2 L 15.3 12.8 L 18.6 9.6 L 20.6 5.5 L 21.4 2.2 L 21.7 -1.1 L 21.5 -3.4 L 20.3 -4.8 L 17.4 -5.3 L 15.3 -4.5 L 13.5 -2.3 L 12.3 .6 L 12.2 3.9 L 13.6 6.2 L 15.8 6.7 L 18.2 5.7 L 20.1 3.3 L 21.5 .2","0 7.3 M 14.6 -2.6 L 13.4 -1.2 L 15.0 -2.1 M 11.8 5.7 L 10.7 7.4 L 12.3 6.1","0 7.7 M 15.3 -2.8 L 13.9 -1.4 L 15.2 -1.9 M 12.2 6.0 L 12.7 5.9 L 12.5 8.1 L 11.8 9.7 L 9.9 11.5","0 14.3 M 22.4 -1.8 L 12.9 1.7 L 20.2 5.3","0 13.8 M 12.7 -.3 L 22.0 -.3 M 11.4 3.2 L 20.5 3.3","0 14.3 M 13.8 -1.9 L 21.1 1.5 L 11.4 4.9","0 13.3 M 13.4 5.8 L 12.7 7.5 L 14.1 6.2 M 16.9 2.1 L 15.6 2.2 L 15.2 1.4 L 15.7 -.2 L 17.0 -1.8 L 20.8 -4.2 L 24.1 -6.3 L 25.9 -9.0 L 26.2 -11.4 L 25.5 -13.5 L 23.8 -14.6 L 21.1 -14.6 L 18.7 -13.5 L 17.3 -11.3","0 22.6 M 28.1 7.2 L 26.5 9.1 L 24.1 10.6 L 20.5 11.2 L 17.8 10.5 L 15.0 9.1 L 13.0 6.0 L 12.5 1.0 L 13.8 -3.2 L 16.1 -5.8 L 18.3 -7.2 L 22.0 -8.2 L 25.1 -7.8 L 27.3 -6.6 L 29.4 -3.1 L 29.5 -.1 L 28.4 3.3 L 26.6 4.9 L 24.3 5.8 L 23.2 5.5 L 22.6 4.5 L 22.7 2.5 L 22.9 .9 L 25.6 -3.1 L 24.5 -1.7 L 23.5 -2.7 L 22.4 -2.9 L 21.1 -2.7 L 19.6 -2.1 L 18.1 -.1 L 17.4 2.3 L 17.5 4.1 L 18.6 5.2 L 20.2 4.4 L 24.2 -1.3","0 45.9 M 14.1 -2.5 L 12.7 .3 L 12.9 3.3 L 15.1 6.2 L 18.5 7.2 L 23.3 6.7 L 27.6 4.9 L 31.9 2.3 L 35.2 -.7 L 42.7 -8.5 L 47.8 -13.5 L 51.4 -16.5 L 54.1 -18.0 L 53.4 -16.6 L 51.5 -13.7 L 49.9 -10.7 L 48.5 -5.6 L 47.8 -.9 L 47.5 3.4 L 48.6 6.3 L 49.7 6.9 L 51.3 6.8 L 53.1 5.5 L 54.3 4.1 M 30.9 -11.9 L 31.9 -15.4 L 34.2 -18.3 L 37.2 -20.1 L 42.2 -20.2 L 47.8 -19.4 L 53.6 -17.7 M 33.5 -4.4 L 48.4 -4.8","0 29.1 M 17.9 -14.2 L 20.6 -17.7 L 25.1 -19.9 L 30.2 -20.4 L 34.0 -19.7 L 36.7 -17.5 L 38.0 -14.0 L 37.0 -10.8 L 35.4 -9.4 L 33.2 -8.5 L 29.6 -8.6 L 33.1 -7.3 L 36.0 -4.4 L 36.7 -1.0 L 36.1 2.8 L 33.9 5.8 L 29.8 7.5 L 25.5 7.6 L 21.1 7.1 L 16.6 5.3 L 11.9 2.1 L 14.5 3.1 L 17.3 2.7 L 19.8 1.2 L 22.2 -2.3 L 26.3 -14.6 L 28.7 -18.5 L 30.3 -20.0 L 31.4 -20.9 L 34.4 -22.3","0 25.7 M 36.8 -15.4 L 37.5 -17.9 L 37.1 -19.0 L 34.7 -20.0 L 30.6 -20.7 L 23.7 -19.2 L 19.7 -17.0 L 16.4 -13.2 L 14.3 -7.8 L 13.8 -3.0 L 15.1 2.6 L 18.8 6.2 L 22.1 7.5 L 26.1 7.8 L 29.3 7.3 L 31.3 6.8 L 32.7 4.5 L 34.2 .1","0 36.6 M 17.1 -12.9 L 18.3 -16.4 L 21.9 -19.4 L 26.5 -20.5 L 32.0 -19.6 L 36.0 -17.9 L 40.1 -14.2 L 43.2 -9.4 L 44.7 -4.4 L 44.4 .7 L 42.1 4.5 L 39.3 6.4 L 34.9 7.5 L 29.0 6.8 L 24.3 5.4 L 19.1 3.9 L 16.5 3.4 L 13.8 3.9 L 12.1 5.4 L 11.8 6.8 L 14.8 7.6 L 19.2 6.8 L 21.2 5.8 L 23.8 3.9 L 26.1 .2 L 28.5 -4.6 L 30.6 -11.9 L 33.1 -16.3 L 35.3 -19.0 L 37.2 -20.2 L 39.9 -21.3","0 23.2 M 33.2 -15.7 L 33.7 -17.5 L 33.4 -19.2 L 31.7 -20.0 L 27.7 -20.5 L 24.0 -19.7 L 21.2 -16.4 L 21.3 -12.8 L 23.6 -11.0 L 25.7 -10.3 L 22.4 -9.8 L 17.4 -8.0 L 14.7 -4.8 L 13.4 .2 L 14.7 4.8 L 18.1 7.5 L 22.9 7.6 L 26.9 6.6 L 28.4 6.0 L 29.5 4.7 L 30.8 .5","0 28.8 M 14.4 -2.7 L 12.3 .2 L 12.4 3.5 L 14.7 6.6 L 17.7 7.4 L 21.9 7.1 L 24.8 6.2 L 27.7 4.1 L 30.7 .4 L 32.8 -4.0 L 35.0 -11.1 L 36.3 -14.7 L 37.5 -16.7 L 39.0 -18.2 L 41.0 -19.4 L 46.0 -18.9 L 36.2 -20.0 L 30.2 -20.1 L 25.3 -18.7 L 22.8 -16.5 L 21.7 -14.1 M 24.6 -5.8 L 24.8 -5.8 L 29.6 -6.5 L 32.5 -6.7 L 38.9 -6.7","0 26.0 M 11.1 3.8 L 9.0 6.2 L 8.3 9.5 L 9.3 13.1 L 12.6 15.4 L 17.2 16.0 L 23.4 13.9 L 27.7 10.3 L 30.9 4.8 L 33.2 -2.2 L 31.0 1.2 L 28.5 3.0 L 25.1 3.8 L 22.0 3.4 L 19.4 1.1 L 18.9 -3.8 L 20.9 -10.3 L 23.6 -14.6 L 28.4 -18.6 L 32.8 -20.5 L 37.5 -20.5 L 39.6 -19.0 L 39.8 -16.9 L 38.2 -13.6","0 39.6 M 22.6 -11.7 L 22.4 -15.1 L 24.0 -18.2 L 27.2 -19.9 L 31.5 -20.4 L 34.9 -20.0 L 37.7 -19.3 L 35.1 -17.2 L 33.9 -15.2 L 32.0 -9.8 L 29.4 -1.8 L 26.6 3.1 L 23.1 6.3 L 19.5 7.5 L 16.0 7.8 L 13.3 6.3 L 12.3 4.1 L 13.0 1.3 L 15.9 -1.8 L 19.6 -3.5 L 24.4 -4.3 L 28.0 -4.4 L 34.5 -4.4 L 41.7 -3.0 L 46.4 -1.9 M 61.0 -18.9 L 61.4 -20.4 L 60.5 -21.7 L 58.3 -21.8 L 55.8 -21.0 L 52.7 -18.9 L 49.9 -15.7 L 46.6 -10.1 L 44.4 -4.7 L 42.8 1.0 L 42.2 5.1 L 42.7 7.1 L 44.3 7.3 L 46.2 5.9 L 48.0 3.7","0 25.7 M 15.7 -.8 L 12.9 2.2 L 12.8 4.7 L 15.0 6.6 L 19.0 7.4 L 23.4 6.7 L 26.9 4.9 L 30.1 2.0 L 32.5 -1.9 L 34.6 -7.4 L 35.7 -11.6 L 36.9 -15.1 L 38.7 -17.8 L 42.2 -20.5 L 37.5 -19.6 L 32.4 -16.9 L 28.7 -13.2 L 26.4 -8.9 L 26.2 -4.3 L 27.7 -1.0 L 30.7 .2 L 32.9 .2 L 33.6 -.5","0 29.2 M 21.5 -.3 L 16.5 1.7 L 12.6 4.6 L 10.3 8.4 L 10.1 11.8 L 11.2 14.4 L 14.1 15.7 L 17.8 15.8 L 22.2 14.9 L 26.6 12.3 L 30.9 7.8 L 34.0 3.1 L 37.4 -4.9 L 39.3 -12.0 L 40.3 -15.4 L 41.6 -17.3 L 45.5 -20.2 L 39.3 -19.1 L 35.6 -16.8 L 32.1 -13.4 L 30.0 -9.4 L 29.5 -5.5 L 30.5 -1.8 L 32.5 -.2 L 36.2 .1 L 37.8 -.7","0 42.8 M 15.1 -2.6 L 13.0 -.6 L 12.2 2.6 L 13.0 5.3 L 15.9 7.2 L 21.0 7.3 L 25.6 5.8 L 28.3 3.7 L 30.6 .5 L 32.0 -2.4 L 34.2 -11.9 L 35.7 -15.7 L 37.1 -17.6 L 39.5 -19.4 L 33.4 -20.6 L 28.0 -20.0 L 23.2 -16.8 L 21.2 -13.6 L 20.7 -11.0 L 21.1 -7.3 M 53.4 -16.7 L 53.6 -16.9 L 53.3 -19.6 L 51.9 -20.2 L 49.7 -19.6 L 45.7 -17.6 L 41.3 -13.9 L 38.8 -11.1 L 36.3 -8.0 L 37.7 -3.2 L 39.5 1.8 L 42.4 5.7 L 46.4 7.5 L 48.8 7.0 L 50.4 5.3","0 29.9 M 40.8 -14.5 L 41.3 -17.6 L 40.6 -19.4 L 38.2 -20.4 L 35.7 -19.6 L 32.9 -18.0 L 30.3 -14.6 L 28.3 -10.4 L 26.8 -5.4 L 24.6 1.1 L 22.7 3.6 L 19.8 6.7 L 14.9 7.7 L 12.2 7.0 L 11.1 6.0 L 11.5 3.9 L 14.1 2.5 L 16.7 2.4 L 19.9 3.6 L 23.7 5.6 L 27.5 7.2 L 30.9 7.6 L 34.6 6.7 L 36.7 5.4 L 38.0 3.4","0 55.6 M 15.7 -6.1 L 13.1 -2.8 L 13.0 1.9 L 15.6 5.1 L 19.7 7.2 L 25.2 6.8 L 29.2 5.1 L 33.8 2.1 L 38.8 -2.8 L 42.8 -7.5 L 50.1 -17.7 M 50.8 -17.8 L 50.8 -17.8 M 64.2 3.9 L 61.7 6.5 L 59.5 7.3 L 58.0 5.9 L 57.6 3.9 L 57.4 -1.6 L 59.3 -9.0 L 61.7 -13.7 L 64.1 -17.6 L 67.5 -21.3 L 61.4 -16.3 L 55.4 -10.5 L 47.7 -.9 L 43.0 6.9 L 44.6 -1.6 L 46.8 -9.2 L 50.0 -17.6 M 27.5 -12.2 L 28.7 -16.5 L 31.9 -19.4 L 35.9 -20.3 L 39.2 -20.4 L 43.7 -19.6 L 46.8 -18.8 L 50.2 -17.7","0 45.5 M 14.5 -4.4 L 13.2 -2.0 L 12.7 1.8 L 14.0 4.4 L 16.4 6.2 L 21.2 7.1 L 25.6 6.1 L 29.3 3.7 L 31.9 .7 L 34.6 -3.0 L 36.2 -7.5 L 37.6 -11.3 L 39.0 -19.3 M 24.0 -16.5 L 26.6 -19.4 L 29.7 -20.3 L 33.9 -19.7 L 36.8 -18.3 L 39.8 -15.9 L 42.2 -12.8 L 44.9 -8.8 L 46.6 -5.5 L 48.9 -.1 L 50.0 3.4 L 50.7 6.7 L 51.5 1.3 L 53.2 -5.8 L 55.9 -12.0 L 59.1 -17.1 L 62.0 -20.0 L 64.6 -20.7 L 66.3 -19.9 L 66.8 -18.5 L 67.1 -17.0","0 27.9 M 17.7 5.9 L 17.9 5.9 L 23.1 7.5 L 27.8 6.7 L 32.5 4.0 L 36.2 -1.2 L 37.9 -6.2 L 38.4 -10.7 L 37.3 -15.6 L 34.0 -18.9 L 29.8 -20.2 L 24.3 -19.1 L 20.2 -17.1 L 16.7 -13.0 L 14.5 -8.6 L 13.5 -4.1 L 13.8 -.1 L 15.2 3.4 L 17.7 5.9","0 35.8 M 15.2 -4.0 L 12.8 -1.7 L 12.7 2.1 L 13.8 5.1 L 16.9 7.1 L 21.3 7.4 L 25.6 6.1 L 29.4 2.5 L 31.6 -1.5 L 33.7 -6.4 L 35.4 -12.3 L 36.7 -15.6 L 39.2 -19.7 L 40.2 -20.7 L 43.4 -22.4 M 24.7 -11.4 L 25.0 -11.4 L 25.9 -14.0 L 27.5 -16.4 L 30.1 -18.4 L 34.8 -20.1 L 39.0 -20.3 L 42.8 -19.9 L 46.0 -17.4 L 47.9 -14.0 L 48.0 -9.6 L 46.2 -5.7 L 43.2 -3.2 L 39.2 -2.6 L 35.2 -3.2 L 32.1 -5.1 L 30.9 -8.0","0 26.1 M 22.0 .8 L 21.7 .9 L 19.5 1.5 L 16.8 .1 L 14.9 -3.5 L 15.2 -8.0 L 16.1 -12.0 L 18.6 -16.0 L 21.4 -18.5 L 24.1 -19.9 L 28.5 -20.7 L 32.1 -19.6 L 35.1 -16.5 L 36.1 -13.0 L 36.1 -8.0 L 34.5 -3.5 L 31.9 .3 L 28.1 3.5 L 23.9 5.6 L 20.1 6.6 L 13.2 6.4 L 14.2 5.9 L 20.3 8.4 L 25.5 11.1 L 31.5 13.9 L 36.6 15.0 L 39.3 14.6 L 41.5 13.5 L 43.3 12.0","0 39.1 M 15.1 -2.6 L 12.8 -.2 L 12.3 3.6 L 14.1 6.5 L 16.4 7.4 L 18.5 7.5 L 23.3 6.3 L 26.8 3.7 L 29.3 -.3 L 31.8 -5.4 L 32.9 -9.1 L 34.3 -13.9 L 36.5 -18.8 L 38.1 -20.2 L 39.0 -21.1 L 41.5 -22.4 M 24.1 -14.0 L 24.4 -14.2 L 26.9 -16.9 L 30.6 -19.0 L 35.4 -20.4 L 40.2 -20.4 L 43.7 -18.7 L 45.6 -14.3 L 45.4 -10.8 L 42.9 -7.7 L 41.0 -6.7 L 38.8 -6.2 L 35.8 -6.4 L 37.1 -.1 L 39.5 5.2 L 42.9 7.3 L 45.4 7.4 L 46.8 6.6 L 48.4 4.9","0 22.2 M 14.4 -1.9 L 12.8 -.1 L 12.2 3.1 L 13.9 6.2 L 17.4 7.5 L 21.6 7.7 L 25.3 6.6 L 27.7 5.0 L 29.3 2.0 L 29.2 -2.1 L 27.5 -5.4 L 23.3 -11.7 L 22.4 -14.6 L 23.0 -17.5 L 25.5 -19.7 L 28.9 -20.5 L 31.5 -19.4 L 32.2 -17.0 L 31.7 -14.6","0 26.6 M 13.7 -.9 L 12.3 .8 L 12.3 4.0 L 13.4 5.9 L 16.6 7.3 L 21.0 7.2 L 24.8 5.9 L 27.8 3.7 L 30.6 .1 L 32.5 -4.8 L 34.2 -9.7 L 35.5 -12.3 L 37.4 -15.1 L 39.2 -16.8 L 40.3 -17.4 L 41.4 -18.0 L 42.2 -18.6 L 45.0 -17.7 L 35.8 -19.9 L 29.8 -20.3 L 24.5 -19.6 L 20.4 -16.8 L 18.5 -14.3 L 17.9 -11.5 L 17.9 -9.7","0 34.6 M 13.5 -6.3 L 13.2 -10.9 L 14.8 -15.2 L 16.5 -17.6 L 19.8 -19.4 L 24.4 -20.3 L 27.9 -19.9 L 31.1 -19.1 L 26.8 -14.6 L 23.0 -9.1 L 21.0 -3.7 L 20.3 2.1 L 21.7 6.4 L 24.8 7.6 L 29.7 5.5 L 34.3 1.0 L 38.7 -5.8 L 44.0 -16.0 L 45.5 -19.6 L 46.6 -19.9 L 43.5 -14.0 L 40.9 -8.1 L 39.2 -2.6 L 38.5 1.7 L 38.3 4.7 L 39.1 7.0 L 41.3 6.8 L 42.4 6.1 L 44.3 4.3","0 30.6 M 12.9 -9.7 L 14.3 -14.1 L 16.3 -17.3 L 19.5 -19.7 L 22.9 -20.2 L 26.4 -18.6 L 28.2 -15.6 L 29.4 -11.8 L 29.5 -7.3 L 29.3 -2.3 L 28.6 1.9 L 26.7 7.1 L 37.6 -3.4 L 41.4 -8.5 L 42.9 -12.2 L 42.9 -15.9 L 42.3 -18.2 L 40.9 -19.7 L 39.5 -20.2 L 37.8 -19.7 L 36.4 -18.0","0 37.6 M 12.8 -11.2 L 14.0 -16.3 L 16.5 -19.3 L 20.4 -20.8 L 23.8 -19.9 L 26.4 -17.1 L 27.3 -13.0 L 27.3 -8.3 L 26.7 -4.4 L 25.9 -.3 L 25.2 2.3 L 23.5 7.0 L 27.4 -1.2 L 32.1 -9.3 L 35.7 -14.2 L 39.3 -18.1 L 36.0 -14.3 L 35.5 -12.6 L 35.7 -4.5 L 36.1 .9 L 35.9 6.9 L 38.0 4.7 L 42.3 -.5 L 46.7 -5.9 L 49.6 -10.8 L 50.5 -14.5 L 50.5 -18.4 L 50.1 -19.5 L 49.2 -20.1 L 47.7 -20.0 L 46.5 -17.7","0 37.2 M 14.7 .2 L 13.2 2.9 L 12.6 5.3 L 14.7 7.1 L 18.9 7.2 L 22.2 5.2 L 25.3 2.4 L 28.0 -1.2 L 34.0 -11.1 L 38.1 -16.3 L 41.6 -18.8 L 44.3 -20.0 L 46.0 -20.4 L 47.3 -19.8 L 47.4 -18.2 L 46.9 -14.9 M 23.8 -15.4 L 25.9 -18.9 L 27.6 -19.9 L 29.0 -19.5 L 29.7 -17.7 L 30.3 -14.3 L 31.1 -8.9 L 33.1 -1.4 L 35.9 3.9 L 39.1 6.9 L 42.4 7.4 L 44.7 5.4 L 45.9 3.7","0 30.5 M 23.9 -17.4 L 26.6 -19.7 L 28.3 -20.2 L 30.0 -19.2 L 29.8 -16.5 L 28.9 -13.6 L 27.6 -9.7 L 26.8 -6.1 L 26.1 -3.0 L 26.5 -.6 L 28.3 1.3 L 31.8 .6 L 34.8 -1.4 L 38.5 -5.7 L 41.7 -9.5 L 47.5 -20.0 L 48.3 -20.0 L 40.2 -5.1 L 36.1 1.7 L 33.0 5.6 L 28.8 9.5 L 23.1 12.4 L 16.0 12.5 L 12.3 10.0 L 10.9 6.7 L 11.4 1.9 L 13.8 -1.5 L 16.5 -3.3 L 19.2 -3.6","0 28.8 M 21.6 -13.7 L 22.9 -17.2 L 24.6 -19.1 L 27.5 -20.0 L 29.2 -20.0 L 33.5 -19.6 L 39.4 -18.1 L 40.8 -19.4 L 13.0 7.5 L 15.3 5.5 L 16.5 5.3 L 20.4 6.5 L 25.5 7.6 L 29.2 7.7 L 32.2 6.9 L 35.2 4.5 L 37.2 1.3","0 15.1 M 28.2 -19.7 L 21.9 -19.6 L 14.6 11.9 L 20.0 11.9","0 9.9 M 11.0 -20.0 L 16.8 9.5","0 15.9 M 19.2 -19.4 L 25.0 -19.6 L 17.5 11.8 L 11.1 11.9","0 12.9 M 12.3 -.5 L 17.9 -7.7 L 20.7 -.6","0 16.3 M 9.0 10.3 L 14.3 9.7 L 22.9 9.6","0 7.4 M 11.5 -9.1 L 14.8 -7.1","0 13.7 M 21.0 -2.0 L 18.5 -2.9 L 15.9 -2.4 L 13.4 -.2 L 11.9 2.5 L 11.6 4.6 L 12.0 6.2 L 13.0 7.2 L 14.0 7.0 L 15.6 5.8 L 17.5 3.7 L 21.0 -1.7 L 22.0 -2.9 L 19.9 .5 L 18.8 2.9 L 18.5 5.5 L 18.7 7.1 L 19.2 7.5 L 20.4 7.1 L 21.7 5.7","0 12.3 M 12.7 1.9 L 14.9 -.9 L 17.2 -2.4 L 18.7 -2.6 L 19.8 -1.0 L 19.9 1.5 L 18.9 3.7 L 17.1 5.6 L 14.9 7.3 L 13.4 7.4 L 12.5 7.1 L 12.0 5.6 L 12.3 3.2 L 14.9 -5.8 L 18.8 -14.7 L 21.2 -19.5 L 24.9 -23.4 L 28.0 -25.0 L 29.9 -25.6 L 31.2 -25.4 L 32.8 -24.7 L 33.2 -22.8","0 9.5 M 17.5 -.9 L 17.8 -1.0 L 18.0 -2.1 L 17.2 -2.9 L 15.1 -3.2 L 13.2 -.9 L 11.7 1.9 L 11.5 5.5 L 12.4 7.1 L 14.0 7.3 L 15.6 6.5 L 17.4 4.8","0 13.6 M 37.9 -23.9 L 37.9 -24.7 L 37.3 -25.4 L 35.5 -25.4 L 33.9 -24.8 L 31.5 -22.9 L 29.1 -20.5 L 26.1 -15.4 L 21.8 -6.3 L 19.3 1.3 L 17.8 3.6 L 16.2 5.6 L 14.6 6.9 L 12.5 7.1 L 11.9 5.3 L 12.1 3.0 L 12.8 .3 L 15.3 -2.2 L 18.5 -3.2 L 19.9 -2.2 L 19.8 .1 L 18.8 3.9 L 18.5 6.4 L 19.3 7.5 L 20.4 7.1 L 22.0 5.7","0 10.1 M 12.8 1.7 L 13.5 1.8 L 16.5 .7 L 18.1 -.4 L 18.6 -1.8 L 17.7 -2.9 L 16.4 -2.9 L 14.3 -2.0 L 12.9 .3 L 11.9 3.7 L 12.0 6.3 L 13.3 7.5 L 15.6 7.2 L 18.0 5.8","0 7.8 M -2.9 15.8 L -2.8 17.4 L .3 18.6 L 3.7 17.7 L 7.5 14.6 L 10.2 10.2 L 12.2 5.9 L 14.1 .2 L 16.2 -6.1 L 18.2 -11.4 L 20.7 -16.3 L 23.3 -20.4 L 25.8 -22.8 L 28.0 -23.8 L 29.2 -24.2 L 31.0 -24.3 L 32.1 -23.8 L 32.7 -23.0 L 32.9 -21.8 M 11.5 -2.5 L 12.1 -2.6 L 13.7 -3.0 L 20.2 -3.0","0 10.3 M 14.9 -2.6 L 12.4 -.6 L 11.5 1.7 L 11.5 3.7 L 12.9 5.3 L 14.7 5.0 L 16.0 4.0 L 17.0 2.5 L 17.8 .2 L 17.6 -1.4 L 16.9 -2.3 L 15.5 -2.6 L 17.5 -2.7 L 18.6 -3.0 L 19.4 -3.5 L 18.6 -2.9 L 16.8 -2.7 L 17.6 -.1 L 16.9 2.4 L 16.1 4.0 L 14.8 7.0 L 14.8 8.9 L 16.2 10.9 L 17.2 14.0 L 16.3 16.3 L 15.2 17.7 L 12.9 18.7 L 9.8 18.7 L 6.9 17.2 L 5.3 14.9 L 5.4 13.0 L 6.1 11.5 L 7.9 10.1","0 13.9 M 34.0 -22.5 L 33.8 -24.4 L 32.8 -25.3 L 30.4 -25.3 L 26.5 -23.4 L 22.8 -19.4 L 19.0 -13.6 L 17.0 -9.1 L 13.7 -.1 L 11.6 7.3 L 14.0 3.3 L 17.0 -.7 L 19.4 -2.4 L 20.5 -2.9 L 21.7 -2.7 L 21.1 -.9 L 20.4 .3 L 19.2 3.2 L 18.5 5.7 L 18.7 6.9 L 19.6 7.5 L 21.0 7.1 L 21.9 6.0","0 7.3 M 11.8 -.7 L 14.8 -2.6 L 12.9 1.2 L 11.7 4.7 L 11.5 6.7 L 12.6 7.4 L 13.3 7.1 L 14.9 5.7 M 18.4 -9.4 L 15.7 -6.1","0 6.6 M 11.2 -1.2 L 14.1 -2.6 L 12.0 4.8 L 9.2 11.0 L 6.1 15.2 L 2.6 17.7 L -.8 18.6 L -2.8 18.2 L -3.6 17.2 L -4.0 15.3 M 17.6 -9.2 L 15.2 -6.1","0 12.6 M 11.9 7.0 L 14.1 -2.1 L 17.1 -10.8 L 20.0 -16.3 L 22.9 -20.4 L 26.0 -23.4 L 28.8 -25.3 L 31.0 -25.9 L 33.4 -25.3 L 33.9 -24.3 L 33.9 -22.6 M 12.7 4.1 L 14.6 .1 L 16.7 -2.1 L 18.8 -2.9 L 20.1 -2.1 L 20.6 -.7 L 19.8 .3 L 18.6 1.4 L 15.6 1.9 L 16.0 4.2 L 16.7 5.9 L 17.7 7.2 L 19.2 7.7 L 20.4 7.3 L 21.2 6.3","0 6.4 M 15.4 5.5 L 14.1 6.8 L 12.5 7.3 L 11.5 6.9 L 11.4 5.0 L 12.7 -.4 L 14.2 -5.7 L 16.7 -11.2 L 19.7 -17.0 L 23.6 -21.9 L 25.9 -24.1 L 27.9 -24.9 L 29.4 -25.0 L 29.8 -24.8 L 30.5 -23.8 L 30.5 -22.8","0 19.0 M 11.8 -1.0 L 12.9 -2.4 L 14.2 -2.8 L 14.6 -2.6 L 14.4 -1.3 L 11.6 7.1 L 15.1 .8 L 17.2 -2.0 L 18.7 -2.8 L 20.2 -2.7 L 20.4 -1.2 L 20.1 .8 L 18.0 7.2 L 20.0 2.4 L 22.2 -.8 L 23.4 -2.2 L 25.0 -2.9 L 26.0 -2.8 L 26.6 -2.2 L 26.6 -1.1 L 24.5 4.8 L 24.5 6.7 L 25.3 7.5 L 26.3 6.8 L 27.7 5.8","0 14.0 M 11.8 -1.5 L 13.1 -2.6 L 14.1 -2.9 L 14.8 -2.3 L 14.2 -.1 L 13.1 3.1 L 11.6 7.3 L 14.5 2.4 L 16.2 -.4 L 17.7 -1.9 L 20.0 -2.7 L 21.3 -2.6 L 20.9 -.8 L 19.8 1.3 L 19.0 4.1 L 18.8 6.5 L 19.9 7.3 L 21.2 6.8 L 22.2 5.6","0 10.9 M 14.8 -2.1 L 12.6 .5 L 11.9 3.8 L 12.2 6.5 L 13.8 7.6 L 16.5 6.2 L 17.9 4.1 L 18.9 .7 L 18.7 -1.7 L 17.8 -2.6 L 16.1 -2.6 L 14.8 -2.1","0 12.6 M 13.0 -2.7 L 15.2 -4.2 L 15.9 -3.8 L 13.9 .9 L 10.9 8.6 L 9.5 13.1 L 8.9 17.5 L 9.5 18.7 L 11.5 18.1 M 13.0 2.2 L 16.1 -1.0 L 18.3 -2.4 L 19.2 -2.5 L 20.4 -1.2 L 20.2 2.4 L 19.4 4.3 L 17.7 6.2 L 15.6 7.6 L 13.0 7.5 L 11.2 6.1","0 12.6 M 20.4 -1.8 L 19.7 -2.8 L 16.9 -2.9 L 13.9 -1.2 L 11.8 1.6 L 10.9 4.1 L 11.2 6.4 L 11.9 7.4 L 13.1 7.1 L 15.0 5.8 L 17.5 3.4 L 20.2 -1.0 L 21.6 -2.4 L 17.4 4.8 L 15.2 11.0 L 13.9 16.8 L 13.9 18.0 L 14.7 18.3 L 16.6 18.3","0 9.6 M 11.5 -1.4 L 13.2 -2.6 L 14.3 -2.7 L 14.4 -1.8 L 14.4 -.3 L 11.9 7.5 L 14.5 1.8 L 16.3 -1.4 L 17.5 -2.3 L 18.6 -2.8 L 19.8 -2.3","0 9.0 M 10.2 4.8 L 9.8 6.1 L 10.8 7.3 L 13.7 7.8 L 15.2 6.4 L 15.6 4.5 L 14.8 2.5 L 13.2 .4 L 13.1 -1.3 L 14.3 -2.8 L 16.2 -3.0 L 17.1 -2.5 L 17.3 -1.0","0 8.3 M 17.2 -8.6 L 14.5 -2.9 L 12.3 3.0 L 12.0 5.7 L 12.7 7.3 L 14.6 7.3 L 16.5 5.2 M 11.7 -2.8 L 13.1 -3.1 L 18.3 -3.0","0 13.9 M 12.2 -.9 L 15.4 -3.1 L 12.8 1.8 L 11.6 5.5 L 12.0 6.7 L 13.1 7.3 L 15.3 6.4 L 19.4 1.0 L 21.0 -2.5 L 21.4 -2.7 L 19.0 3.0 L 19.2 6.5 L 19.9 7.5 L 21.1 7.4 L 22.1 6.3","0 12.9 M 11.5 -1.4 L 12.9 -2.5 L 14.5 -2.2 L 14.2 -.4 L 13.7 3.2 L 12.6 7.2 L 16.6 5.8 L 19.3 3.6 L 20.7 .9 L 21.0 -1.9 L 20.3 -2.7 L 18.7 -2.2","0 17.3 M 10.8 -2.0 L 12.7 -2.9 L 13.7 -2.0 L 14.1 .2 L 13.3 6.8 L 19.6 -1.8 L 18.8 -1.6 L 18.0 2.9 L 18.1 5.9 L 18.8 7.3 L 20.7 7.3 L 22.5 5.8 L 24.2 3.9 L 25.2 1.8 L 25.3 -.4 L 24.8 -2.0 L 24.2 -2.7 L 23.3 -2.6 L 22.8 -1.9","0 12.2 M 12.1 -1.0 L 13.2 -2.7 L 14.1 -3.0 L 14.5 -1.9 L 14.6 2.2 L 16.0 5.4 L 17.4 7.3 L 18.8 7.5 L 19.4 6.8 L 20.3 5.8 M 21.1 -.6 L 21.2 -2.3 L 20.5 -2.9 L 19.0 -2.6 L 17.8 -1.6 L 16.6 -.3 L 13.5 4.8 L 12.4 6.4 L 10.6 7.3 L 9.6 7.1 L 9.6 5.6","0 13.3 M 12.2 -.7 L 15.2 -2.7 L 12.8 1.7 L 11.9 5.3 L 12.2 7.0 L 13.6 7.4 L 16.0 5.7 L 18.3 2.5 L 21.0 -2.0 L 21.5 -2.6 L 18.8 5.0 L 15.9 11.6 L 14.2 15.0 L 11.4 17.4 L 9.6 18.5 L 5.6 18.7 L 3.8 17.9 L 2.6 16.4 L 2.2 14.3 L 2.5 13.2 L 3.2 12.2","0 11.2 M 12.3 -1.2 L 13.6 -2.5 L 14.3 -3.0 L 16.5 -2.6 L 18.2 -2.3 L 20.2 -2.8 L 9.8 7.5 L 11.4 6.5 L 12.4 6.5 L 14.4 7.4 L 15.5 7.6 L 17.6 7.1 L 19.3 4.7","0 13.9 M 26.5 -19.6 L 23.2 -19.3 L 20.8 -17.0 L 19.7 -13.4 L 19.4 -9.2 L 18.6 -6.5 L 17.2 -5.1 L 14.6 -4.1 L 16.8 -3.2 L 17.6 -1.7 L 17.1 .7 L 15.1 5.3 L 14.4 7.7 L 14.8 10.4 L 15.7 11.5 L 18.5 11.9","0 7.9 M 13.4 -20.2 L 13.5 18.3","0 13.5 M 18.0 -19.6 L 20.2 -19.4 L 22.0 -18.0 L 22.6 -16.4 L 21.7 -12.9 L 20.0 -9.0 L 19.4 -7.1 L 19.5 -5.2 L 20.5 -4.3 L 21.9 -3.8 L 20.0 -2.8 L 18.0 -1.0 L 17.0 1.4 L 17.0 4.0 L 16.7 6.7 L 16.3 8.4 L 15.3 10.3 L 13.3 11.7 L 10.8 11.8 L 10.1 11.8","0 17.9 M 12.2 1.6 L 14.2 .1 L 15.4 -.6 L 16.6 -.6 L 18.5 .2 L 19.7 1.1 L 21.6 1.7 L 23.7 .7 L 25.3 -.8","0 5.5 M 15.6 -9.2 L 14.1 -8.6 L 13.4 -8.0 L 13.1 -6.4 L 14.5 -5.2 L 16.4 -5.6 L 17.5 -6.7 L 17.6 -8.5 L 17.0 -9.1 L 15.6 -9.2"]
EMSLeague = ["-8 8","0 15.3 M 23.2 -12.1 L 20.4 -8.4 L 17.6 -4.3 L 15.2 -.5 L 13.3 3.8 M 11.6 6.2 L 10.9 7.3 L 11.8 8.0 L 12.5 7.1 L 11.6 6.2","0 10.7 M 13.4 -10.4 L 13.3 -8.6 L 12.7 -6.8 L 11.4 -5.3 L 10.1 -4.2 M 15.9 -10.4 L 15.8 -8.4 L 15.3 -7.0 L 14.2 -5.7 L 12.6 -4.1","0 23.3 M 23.3 -11.9 L 9.6 9.3 M 30.2 -11.8 L 16.5 9.4 M 11.2 2.2 L 24.9 2.4 M 15.0 -5.4 L 29.2 -5.4","0 22.8 M 27.1 -8.0 L 28.8 -9.0 L 29.9 -10.2 L 30.6 -11.9 L 30.5 -13.4 L 29.7 -14.6 L 28.6 -15.3 L 27.2 -15.6 L 25.4 -15.3 L 23.3 -14.2 L 21.9 -11.9 L 21.3 -9.4 L 21.5 -7.5 L 21.6 -5.1 L 22.2 -1.8 L 22.3 1.3 L 21.8 4.2 L 20.2 7.4 L 18.0 9.0 L 15.1 10.0 L 12.6 9.8 L 10.4 8.5 L 9.4 6.0 L 9.8 3.9 L 11.8 1.9 M 30.2 -17.6 L 11.3 11.9","0 20.7 M 17.8 -12.5 L 16.2 -11.8 L 16.0 -10.5 L 16.7 -9.3 L 18.6 -9.0 L 19.6 -10.4 L 19.3 -11.7 L 18.0 -12.5 L 17.8 -12.5 M 17.9 4.8 L 16.3 5.5 L 16.1 6.8 L 16.7 8.0 L 18.7 8.3 L 19.7 6.9 L 19.4 5.5 L 18.1 4.8 L 17.9 4.8 M 24.6 -12.8 L 11.1 8.5","0 28.0 M 30.7 6.6 L 28.5 9.1 L 25.8 10.5 L 24.1 10.9 L 22.7 10.7 L 20.8 9.6 L 20.1 7.5 L 20.3 5.1 L 21.5 1.8 L 22.9 -1.2 L 24.9 -4.6 L 27.2 -8.2 L 29.2 -11.1 L 31.3 -12.9 L 32.8 -13.3 L 34.1 -12.8 L 34.3 -12.0 L 34.0 -10.7 L 32.9 -9.6 L 31.0 -8.5 L 28.3 -7.7 L 24.2 -6.4 L 19.4 -5.0 L 15.8 -3.1 L 12.7 -.1 L 11.3 2.7 L 10.9 5.8 L 11.8 8.5 L 13.8 10.2 L 16.4 10.9 L 18.8 10.9 L 22.4 9.7 L 25.2 7.6 L 27.0 5.7 L 28.9 3.0","0 6.3 M 17.7 -11.8 L 14.7 -5.6","0 9.7 M 26.4 -15.0 L 23.6 -12.7 L 20.6 -10.2 L 17.5 -6.7 L 15.2 -3.9 L 13.4 -.8 L 11.9 3.4 L 11.3 6.3 L 11.2 8.7 L 11.3 11.2","0 14.9 M 20.1 -14.0 L 20.1 -8.8 L 18.9 -3.9 L 16.8 -.2 L 14.5 3.2 L 11.6 6.6 L 8.7 9.3 L 5.1 12.1","0 11.0 M 13.7 -11.9 L 13.8 -4.9 M 11.2 -10.7 L 16.1 -5.9 M 10.4 -8.3 L 10.6 -8.3 L 16.9 -8.2 M 11.3 -5.8 L 16.0 -10.5","0 20.2 M 21.6 -7.0 L 13.0 6.3 M 11.0 -.9 L 24.7 -.8","0 5.4 M 12.3 6.7 L 11.3 7.7 L 10.6 6.7 L 11.4 5.8 L 12.3 6.7 M 11.8 7.1 L 12.1 7.6 L 11.5 8.5 L 10.1 9.0","0 17.7 M 9.7 .7 L 24.0 .8","0 6.5 M 11.5 6.1 L 10.7 7.1 L 11.7 8.0 L 12.7 7.1 L 11.5 6.1","0 23.8 M 31.6 -16.8 L 12.6 13.0","0 19.0 M 25.0 -14.6 L 22.3 -14.6 L 19.8 -13.6 L 17.0 -11.6 L 13.9 -8.1 L 12.0 -5.2 L 10.7 -1.5 L 10.0 1.1 L 9.9 4.5 L 10.7 6.6 L 12.1 7.7 L 14.0 8.3 L 16.2 8.0 L 18.7 6.5 L 20.9 4.3 L 23.1 1.2 L 24.4 -1.7 L 25.5 -4.4 L 25.9 -6.3 L 26.3 -8.4 L 25.7 -11.0 L 25.1 -12.2 L 24.0 -12.9 L 22.8 -13.3 L 21.8 -13.3 L 20.8 -12.8 L 20.0 -11.6 L 20.1 -10.7 L 21.0 -9.7 L 21.8 -9.4 L 22.8 -9.3","0 14.2 M 11.7 -9.3 L 14.8 -9.4 L 17.8 -9.9 L 21.3 -11.0 L 24.0 -12.5 L 25.6 -13.6 L 27.1 -14.9 L 10.7 7.8","0 19.9 M 23.9 -11.3 L 22.9 -8.9 L 21.5 -7.8 L 19.7 -7.6 L 18.7 -8.3 L 18.5 -9.2 L 19.4 -11.6 L 21.7 -13.6 L 23.9 -14.3 L 25.7 -14.5 L 27.9 -14.4 L 29.8 -13.0 L 30.5 -11.1 L 29.9 -8.5 L 28.6 -6.7 L 27.1 -5.4 L 23.0 -2.9 L 17.8 .4 L 12.9 4.2 L 10.5 6.6 L 9.7 7.3 L 9.9 8.0 L 10.5 8.3 L 13.2 7.3 L 14.9 6.6 L 16.1 6.4 L 17.5 6.4 L 19.0 6.9 L 20.8 7.8 L 22.1 8.6 L 23.4 8.6 L 24.1 8.5 L 24.7 7.8","0 20.3 M 21.8 -12.8 L 23.6 -13.9 L 25.7 -14.2 L 27.1 -14.0 L 28.6 -12.9 L 29.4 -11.2 L 29.2 -9.3 L 28.5 -7.3 L 26.9 -6.0 L 25.7 -5.4 L 24.6 -5.1 L 23.0 -4.9 L 21.6 -5.0 L 20.3 -5.4 L 19.5 -6.0 L 19.7 -6.6 L 20.1 -7.2 L 21.5 -7.1 L 22.7 -6.4 L 23.6 -5.7 L 24.8 -3.9 L 25.5 -2.1 L 25.4 1.0 L 24.4 3.5 L 22.8 5.7 L 20.9 7.6 L 18.2 9.2 L 15.9 9.8 L 13.6 9.9 L 11.3 9.5 L 9.4 8.0 L 9.1 5.2 L 9.3 3.5 L 10.6 1.9 L 11.6 1.3 L 12.6 1.2 L 13.8 1.9 L 14.1 3.4 L 13.5 4.4 L 12.6 5.0","0 20.4 M 15.7 8.1 L 33.2 -14.1 L 27.9 -10.3 L 22.6 -6.6 L 17.1 -4.0 L 11.5 -1.5 L 14.7 -1.9 L 20.6 -1.7 L 22.9 -1.4 L 25.2 -.8 L 26.3 -.1 L 27.2 .8 L 27.7 1.5","0 20.8 M 30.9 -13.3 L 28.2 -12.4 L 25.6 -12.3 L 24.1 -12.3 L 21.4 -12.9 L 15.8 -5.5 L 18.4 -6.9 L 21.2 -7.6 L 23.5 -6.9 L 24.8 -5.5 L 25.3 -3.7 L 24.9 -.9 L 23.5 1.9 L 21.4 5.1 L 19.6 7.1 L 17.3 8.4 L 14.1 9.2 L 12.1 8.7 L 10.3 7.7 L 9.6 5.9 L 9.8 4.0 L 10.5 3.0 L 11.6 1.6","0 17.4 M 26.0 -9.0 L 26.8 -10.3 L 26.7 -11.5 L 26.5 -12.8 L 25.7 -13.6 L 24.2 -13.8 L 22.1 -13.0 L 19.4 -11.0 L 16.4 -8.1 L 14.4 -4.9 L 12.5 -1.7 L 11.2 1.5 L 10.5 4.9 L 10.7 7.5 L 12.2 9.2 L 14.2 9.7 L 16.1 9.5 L 18.6 8.3 L 21.1 5.7 L 23.4 1.6 L 24.0 -1.0 L 24.1 -2.3 L 23.5 -3.9 L 22.0 -5.2 L 20.1 -5.5 L 17.8 -4.8 L 16.1 -3.8 L 15.1 -2.8 L 14.2 -1.7","0 12.2 M 13.6 -12.9 L 18.9 -11.9 L 21.7 -11.9 L 24.0 -12.1 L 26.0 -12.7 L 26.8 -12.9 L 26.9 -12.2 L 25.4 -9.6 L 22.0 -4.8 L 17.2 1.3 L 13.5 5.8 L 9.6 10.2","0 24.1 M 29.2 -7.7 L 29.2 -10.0 L 28.8 -11.1 L 27.4 -12.5 L 25.2 -13.4 L 22.7 -12.8 L 20.9 -11.3 L 20.1 -9.7 L 19.9 -7.6 L 20.7 -5.5 L 21.7 -3.3 L 22.7 -.7 L 22.8 1.4 L 22.2 4.1 L 21.3 6.5 L 19.1 8.7 L 15.9 10.3 L 14.1 10.7 L 12.1 10.9 L 9.3 9.7 L 8.2 8.0 L 8.5 5.7 L 9.6 3.2 L 11.3 .9 L 13.0 -.7 L 15.7 -2.1 L 19.7 -3.7 L 23.5 -5.1 L 26.0 -6.6 L 27.3 -8.3 L 27.9 -9.6 L 28.1 -11.2 L 28.0 -12.7 L 27.6 -14.3 L 26.5 -15.9","0 13.9 M 25.9 -13.3 L 22.5 -14.1 L 19.3 -14.0 L 17.1 -13.3 L 13.9 -11.5 L 11.6 -9.0 L 11.0 -7.6 L 11.0 -6.0 L 11.7 -4.7 L 13.2 -3.4 L 15.2 -3.1 L 17.7 -3.9 L 20.3 -5.4 L 22.4 -7.3 L 24.3 -9.1 L 27.6 -12.6 L 11.9 8.9","0 8.5 M 14.0 -1.7 L 13.1 -.6 L 14.0 .3 L 14.8 -.6 L 14.0 -1.7 M 12.5 4.3 L 11.5 5.4 L 12.4 6.4 L 13.3 5.5 L 12.5 4.3","0 9.0 M 11.6 5.7 L 10.6 6.8 L 11.6 7.7 L 12.4 6.8 L 11.6 5.7 M 14.3 -1.8 L 13.4 -.7 L 14.3 .2 L 15.1 -.7 L 14.3 -1.8 M 12.1 7.2 L 12.0 8.0 L 11.0 8.9 L 10.2 9.1","0 20.4 M 24.3 -7.1 L 22.1 -5.2 L 19.5 -3.5 L 17.1 -2.4 L 15.1 -1.8 L 13.9 -1.6 L 11.1 -1.4 L 13.1 .4 L 15.0 2.0 L 16.4 3.6 L 17.2 5.4","0 20.5 M 12.4 -2.8 L 26.5 -2.8 M 9.7 2.1 L 23.5 2.1","0 20.4 M 18.0 -7.9 L 18.8 -5.9 L 20.3 -4.1 L 21.9 -2.4 L 23.3 -1.4 L 24.4 -.7 L 21.9 -.8 L 18.7 .0 L 16.0 1.3 L 13.6 2.8 L 11.9 4.0 L 10.8 4.9","0 20.9 M 15.4 -6.8 L 16.9 -9.6 L 19.0 -11.3 L 21.2 -12.2 L 23.1 -12.4 L 25.0 -12.1 L 26.5 -11.1 L 27.2 -9.3 L 26.7 -7.3 L 25.2 -5.0 L 23.1 -3.2 L 21.4 -2.1 L 18.9 -1.3 L 16.4 -1.4 L 13.1 3.7 M 11.3 6.1 L 10.3 7.2 L 11.3 8.1 L 12.3 7.3 L 11.3 6.1","0 27.5 M 30.7 -3.1 L 23.3 2.2 L 20.1 4.2 L 18.0 4.8 L 16.1 4.3 L 14.9 3.2 L 14.7 1.4 L 15.9 -1.0 L 18.0 -3.1 L 21.2 -5.4 L 23.8 -6.2 L 26.1 -6.3 L 27.7 -5.8 L 28.7 -4.8 L 28.4 -3.3 L 27.4 -1.7 L 24.1 2.1 L 23.7 2.7 L 23.9 3.8 L 25.6 4.4 L 27.5 3.7 L 30.6 1.4 L 33.2 -1.7 L 33.9 -3.5 L 33.8 -5.8 L 32.4 -7.8 L 30.1 -9.1 L 27.5 -9.6 L 24.4 -9.6 L 21.3 -8.9 L 16.8 -6.9 L 13.5 -4.5 L 11.3 -2.2 L 10.1 .1 L 9.6 1.6 L 9.6 4.1 L 10.4 6.0 L 12.0 7.6 L 14.5 8.7 L 17.2 9.2 L 19.8 8.9 L 22.8 8.4 L 25.6 7.3 L 28.4 5.2","0 29.6 M 9.4 5.2 L 9.9 7.4 L 11.2 8.6 L 12.3 9.1 L 13.8 9.1 L 14.9 8.7 L 16.8 7.4 L 18.5 5.4 L 20.6 2.2 L 23.5 -2.5 L 26.2 -6.4 L 29.2 -9.8 L 32.6 -12.9 L 35.4 -14.8 L 38.3 -15.6 L 40.8 -15.9 L 42.1 -15.9 L 42.8 -15.7 L 44.6 -14.7 L 42.6 -15.7 L 41.2 -15.8 L 39.8 -15.0 L 36.6 -12.2 L 34.3 -8.8 L 32.3 -5.0 L 31.3 -2.0 L 30.6 .7 L 30.3 2.8 L 30.1 7.9 L 29.6 4.6 L 28.9 2.2 L 28.0 -.2 L 26.3 -2.1 L 25.0 -3.0 L 23.5 -3.6 L 21.3 -3.6 L 19.6 -2.9 L 19.2 -1.5 L 19.8 .0 L 21.1 .9 L 23.2 1.5 L 26.0 1.6 L 29.8 1.4 L 32.3 .8 L 34.7 -.5","0 24.3 M 33.2 -14.2 L 31.6 -15.7 L 29.3 -15.9 L 27.5 -15.6 L 24.7 -14.2 L 23.1 -12.9 L 21.0 -10.0 L 12.5 4.3 L 10.9 6.5 L 9.5 8.2 L 7.3 9.2 L 5.8 9.1 L 4.9 8.6 L 3.9 7.4 M 13.8 -9.2 L 16.0 -11.1 L 18.4 -12.3 L 20.5 -13.0 L 22.3 -13.3 L 25.2 -13.0 L 27.5 -12.4 L 29.7 -10.9 L 30.5 -9.0 L 30.3 -6.9 L 29.8 -5.4 L 28.5 -4.4 L 26.7 -3.8 L 24.6 -3.5 L 22.0 -3.8 L 21.7 -4.4 L 21.7 -5.1 L 22.4 -5.5 L 23.8 -5.3 L 25.2 -4.6 L 26.3 -3.9 L 28.0 -2.3 L 28.8 -.5 L 29.1 1.9 L 28.1 4.7 L 26.5 6.6 L 24.6 7.9 L 22.9 8.3 L 19.9 8.3 L 18.7 7.8 L 17.2 7.0 L 16.1 5.8 L 15.6 4.5 L 15.6 2.8","0 18.3 M 17.6 -12.7 L 17.7 -12.6 L 18.4 -10.7 L 19.9 -9.2 L 22.5 -7.7 L 25.7 -7.8 L 27.5 -8.7 L 28.7 -9.7 L 29.4 -11.7 L 29.4 -12.9 L 29.1 -13.3 L 28.2 -13.9 L 26.2 -13.9 L 24.2 -13.2 L 20.7 -11.5 L 19.3 -10.6 L 16.6 -8.3 L 13.2 -5.0 L 10.4 -.8 L 9.3 2.3 L 9.3 4.4 L 9.8 6.5 L 11.4 7.9 L 12.6 8.6 L 16.0 8.6 L 17.8 7.7 L 19.1 7.0 L 20.4 5.6 L 22.6 2.9","0 24.3 M 26.2 -9.0 L 24.5 -7.5 L 22.2 -6.3 L 20.9 -6.2 L 19.0 -6.3 L 16.9 -7.3 L 16.1 -8.9 L 16.2 -10.4 L 17.7 -12.4 L 19.9 -13.2 L 22.8 -13.0 L 24.5 -12.7 L 26.8 -11.7 L 28.9 -9.8 L 30.2 -7.1 L 30.4 -3.6 L 30.0 -.2 L 28.8 3.1 L 27.1 5.5 L 24.5 7.5 L 22.3 8.3 L 20.2 8.0 L 18.2 7.3 L 16.8 5.7 L 16.7 3.6 L 17.4 2.3 L 18.2 1.8 L 19.1 1.6 L 20.2 1.6 L 21.7 2.2 L 22.2 2.4 M 5.3 7.1 L 5.9 8.5 L 7.6 9.1 L 9.4 8.8 L 10.9 7.7 L 12.3 6.2 L 14.2 3.2 L 18.8 -4.8 L 21.3 -8.5 L 24.8 -12.0 L 26.8 -13.5 L 29.2 -14.6 L 31.8 -14.6 L 33.6 -14.3 L 34.5 -13.9 L 35.8 -12.4","0 20.7 M 15.9 -12.9 L 16.6 -11.0 L 17.7 -9.7 L 19.6 -8.4 L 21.7 -7.6 L 23.9 -7.7 L 25.9 -8.7 L 27.3 -9.9 L 27.7 -11.2 L 27.8 -12.6 L 27.2 -13.6 L 26.1 -14.3 L 24.6 -14.5 L 23.0 -14.2 L 20.6 -13.1 L 18.4 -11.0 L 17.4 -8.6 L 17.3 -6.4 L 17.5 -4.9 L 18.8 -3.6 L 20.2 -3.1 L 21.1 -3.3 L 21.5 -3.5 L 21.7 -4.0 L 21.4 -4.7 L 20.3 -5.2 L 18.8 -5.3 L 17.4 -5.0 L 15.1 -4.1 L 12.7 -2.0 L 11.4 .7 L 11.3 3.9 L 12.1 5.7 L 13.6 7.4 L 15.5 8.0 L 18.8 8.2 L 21.1 7.4 L 22.9 6.5 L 24.1 5.5 L 25.8 3.1","0 19.7 M 7.1 5.3 L 7.3 7.1 L 8.1 8.3 L 10.3 8.8 L 12.5 7.9 L 14.4 6.2 L 15.8 4.5 L 17.5 2.3 L 20.3 -1.4 L 23.3 -5.4 L 28.2 -10.8 L 32.3 -13.4 L 35.8 -14.2 L 37.4 -14.2 L 39.0 -13.6 L 39.6 -12.2 L 38.6 -10.7 L 37.3 -10.0 L 36.2 -9.8 L 33.9 -9.8 L 32.8 -9.8 L 30.6 -10.3 L 27.2 -11.1 L 23.0 -12.4 L 20.2 -13.3 L 18.0 -13.0 L 15.7 -12.5 L 13.2 -10.7 M 25.2 -3.2 L 23.6 -2.4 L 22.3 -2.4 L 20.6 -2.9 L 19.0 -3.5 L 17.1 -3.7 L 15.4 -3.2 L 14.8 -2.4 L 15.4 -1.3 L 17.3 -.9 L 19.4 -1.1 L 20.6 -1.7","0 24.2 M 23.3 -13.5 L 24.2 -11.0 L 25.9 -9.3 L 28.9 -7.9 L 31.7 -7.9 L 34.4 -9.3 L 35.8 -10.9 L 35.9 -12.3 L 35.5 -13.9 L 34.0 -14.7 L 32.1 -14.6 L 29.2 -13.4 L 26.8 -12.3 L 23.1 -9.7 L 20.3 -6.9 L 17.2 -3.1 L 14.8 1.5 L 14.3 4.6 L 15.4 6.9 L 17.1 8.6 L 19.6 9.1 L 22.7 8.5 L 25.8 6.5 L 27.5 4.8 L 28.8 2.6 L 26.4 9.5 L 24.0 14.2 L 21.4 17.1 L 18.2 18.9 L 16.2 18.6 L 14.7 17.2 L 14.9 14.8 L 16.2 13.0 L 18.7 11.7 L 22.9 10.1 L 25.6 9.7 L 27.8 9.5 L 31.3 9.4","0 22.6 M 21.3 -17.4 L 24.3 -15.1 L 26.5 -14.9 L 28.5 -15.8 L 29.1 -16.7 L 29.1 -17.2 L 28.3 -17.7 L 27.5 -17.7 L 26.2 -17.1 L 25.1 -16.4 L 23.4 -13.3 L 21.7 -10.1 L 20.2 -5.0 L 18.6 -.6 L 16.9 4.3 L 15.8 7.6 L 14.5 10.0 L 13.5 12.1 L 12.6 12.9 L 11.6 13.5 L 10.3 13.5 L 8.8 12.4 L 8.3 9.8 L 8.6 7.5 L 10.8 4.3 L 13.5 2.1 L 16.3 .2 L 23.3 -2.9 L 29.1 -5.1 L 33.0 -7.5 L 36.2 -10.2 L 37.8 -11.7 L 37.6 -13.8 L 37.0 -14.3 L 35.6 -14.5 L 34.3 -13.7 L 31.4 -10.1 L 28.6 -5.8 L 26.2 -1.4 L 24.6 2.1 L 24.0 5.5 L 24.8 8.4 L 25.8 9.9 L 28.3 11.3","0 20.6 M 7.9 6.9 L 8.1 9.0 L 10.0 10.3 L 11.8 10.4 L 13.9 9.5 L 16.5 7.0 L 20.1 2.4 L 24.1 -3.2 L 27.4 -7.6 L 30.9 -11.0 L 34.2 -12.9 L 36.2 -13.5 L 37.9 -13.5 L 38.9 -12.7 L 39.4 -11.9 L 38.9 -10.8 L 38.0 -10.0 L 36.8 -9.7 L 35.7 -9.8 L 33.5 -10.2 L 30.9 -11.0 L 29.2 -11.8 L 27.4 -12.0 L 25.4 -11.8","0 12.6 M 16.0 3.0 L 14.9 5.3 L 12.9 6.8 L 9.6 7.5 L 6.7 8.0 L 3.1 8.2 L -.8 9.1 L -4.3 10.6 L -6.3 13.0 L -6.7 14.0 L -6.9 15.4 L -6.3 16.7 L -4.3 17.0 L -3.0 16.6 L .1 15.5 L 3.3 12.9 L 6.8 9.5 L 11.6 3.8 L 17.7 -3.9 L 22.3 -9.3 L 26.3 -12.6 L 29.4 -14.2 L 32.2 -14.9 L 34.4 -14.8 L 35.7 -14.3 L 36.2 -13.6 L 36.5 -12.4 L 36.1 -11.7 L 34.7 -10.6 L 33.0 -10.4 L 31.7 -10.3 L 29.7 -10.7 L 26.5 -11.6 L 21.8 -12.9 L 19.4 -13.1 L 17.5 -12.7 L 16.7 -12.5","0 21.8 M 1.6 4.5 L 1.8 6.2 L 2.5 7.3 L 3.9 8.0 L 5.0 8.1 L 6.2 7.4 L 8.8 5.6 L 11.9 1.8 L 15.5 -3.0 L 17.9 -6.6 L 21.3 -10.4 L 23.9 -12.7 L 25.8 -14.1 L 27.6 -14.5 L 29.2 -14.6 L 29.9 -14.4 L 30.4 -13.0 L 29.8 -12.0 L 28.7 -11.4 L 27.7 -11.5 L 24.5 -12.0 L 21.1 -12.9 L 17.8 -13.7 L 15.6 -13.9 L 13.8 -14.2 L 12.2 -13.7 L 11.3 -13.4 L 11.0 -12.5 M 37.4 -9.5 L 37.4 -10.7 L 36.5 -11.5 L 35.5 -11.7 L 34.3 -11.4 L 31.8 -9.2 L 29.8 -7.3 L 27.5 -5.8 L 25.7 -4.7 L 23.2 -3.6 L 21.3 -3.0 L 19.0 -2.8 L 17.0 -2.7 L 15.9 -3.0 L 14.4 -3.9 L 14.4 -5.2 L 15.4 -5.8 L 16.5 -5.8 L 19.0 -4.4 L 20.0 -3.2 L 21.3 -1.3 L 22.0 .8 L 22.1 3.5 L 21.8 6.5 L 22.3 8.3 L 23.8 8.7 L 26.3 7.5","0 20.8 M 25.5 -11.9 L 28.7 -12.8 L 31.5 -12.3 L 33.5 -11.5 L 36.4 -10.4 L 38.3 -10.8 L 39.4 -11.5 L 39.7 -12.4 L 39.1 -13.2 L 37.3 -13.9 L 34.6 -13.1 L 33.0 -12.1 L 30.9 -10.1 L 28.5 -7.5 L 25.7 -3.2 L 21.2 2.6 L 18.6 5.6 L 15.1 8.3 L 13.5 9.2 L 12.2 9.2 L 9.8 8.5 L 8.9 7.0 L 9.3 5.9 L 10.8 5.1 L 13.1 5.4 L 15.3 6.8 L 17.3 9.0 L 20.7 11.8 L 23.6 13.2 L 26.0 13.4 L 27.6 12.9 L 28.8 12.0 L 28.9 10.7 L 28.8 10.1 L 27.8 8.9","0 28.6 M -3.9 3.8 L -4.7 5.3 L -4.4 7.3 L -3.3 9.0 L -1.4 9.5 L .1 9.4 L 2.6 8.6 L 5.0 6.7 L 8.2 3.2 L 12.1 -1.8 L 16.5 -7.5 L 19.3 -10.4 L 21.7 -12.6 L 23.1 -13.1 L 24.6 -13.4 L 25.2 -13.1 L 25.4 -12.0 L 23.5 -7.9 L 21.9 -3.5 L 21.3 .1 L 21.0 3.2 L 21.0 6.8 L 20.6 8.6 L 19.3 9.1 L 18.3 9.0 L 17.9 8.3 L 17.9 6.9 L 18.2 5.5 L 20.2 2.1 L 23.5 -2.0 L 28.4 -7.8 L 32.7 -11.0 L 35.3 -12.6 L 37.2 -13.2 L 37.8 -13.2 L 38.6 -12.6 L 38.6 -11.7 L 37.4 -9.9 L 34.3 -4.2 L 32.3 .1 L 31.4 4.1 L 31.1 7.7 L 31.0 9.5 L 32.4 12.0 L 34.3 12.7 L 37.1 11.8 L 38.5 10.6","0 22.4 M 1.0 3.4 L 1.0 3.6 L .3 5.9 L 1.3 8.3 L 3.1 9.1 L 5.0 9.1 L 7.7 8.0 L 10.5 5.8 L 13.1 2.7 L 16.7 -1.6 L 21.9 -7.6 L 24.7 -11.1 L 26.5 -12.4 L 27.8 -13.3 L 28.7 -13.5 L 29.4 -13.4 L 29.7 -12.4 L 29.2 -11.4 L 27.5 -8.4 L 24.3 -1.9 L 22.4 4.1 L 22.4 5.7 L 22.5 7.5 L 23.0 8.3 L 24.2 7.8 L 24.7 6.8 L 28.9 -.4 L 31.2 -3.9 L 35.7 -9.0 L 39.2 -11.8 L 41.9 -13.5 L 44.1 -14.1 L 46.3 -14.0 L 47.6 -13.1 L 47.4 -11.4 L 45.1 -10.7 L 44.3 -10.7 L 42.8 -11.2 L 41.1 -12.0 L 39.5 -14.3","0 22.7 M 27.2 -12.9 L 23.6 -13.1 L 19.7 -11.7 L 15.8 -8.9 L 12.9 -6.4 L 10.2 -2.4 L 9.0 1.0 L 8.9 3.2 L 9.4 5.6 L 11.7 7.8 L 13.9 8.6 L 18.3 8.2 L 22.4 6.6 L 28.1 2.2 L 30.9 -1.7 L 32.1 -4.5 L 32.6 -7.6 L 32.5 -9.6 L 31.1 -12.0 L 30.0 -12.9 L 28.1 -13.4 L 26.7 -13.1 L 24.4 -11.8 L 23.3 -9.6 L 23.6 -7.2 L 25.0 -5.5 L 27.0 -3.9 L 30.0 -3.1 L 32.3 -3.1 L 35.2 -4.7 L 35.8 -6.2 L 35.3 -8.0 L 34.1 -9.1 L 33.8 -9.3 L 30.7 -9.6 L 27.3 -8.3 L 25.5 -7.3 L 23.8 -5.9 L 22.3 -3.6","0 29.1 M 8.4 8.7 L 9.5 10.1 L 11.8 10.3 L 14.3 8.9 L 16.2 6.3 L 20.1 -.8 L 23.0 -5.7 L 28.1 -10.8 L 31.4 -12.8 L 34.2 -13.5 L 36.4 -13.1 L 37.6 -12.6 L 38.7 -11.2 M 17.8 -14.0 L 20.2 -12.7 L 21.4 -10.7 L 21.6 -9.2 L 21.1 -6.6 L 19.5 -6.2 L 18.2 -7.5 L 18.7 -9.9 L 20.5 -11.7 L 22.0 -12.7 L 24.4 -13.5 L 27.4 -13.8 L 29.8 -13.5 L 32.7 -12.5 L 35.0 -11.1 L 36.7 -9.1 L 37.5 -6.8 L 37.4 -3.9 L 36.4 -1.2 L 34.0 .9 L 30.5 2.1 L 27.9 2.0 L 25.0 .7 L 23.4 -1.0","0 24.8 M 20.2 -5.1 L 21.6 -5.9 L 23.5 -6.0 L 25.3 -5.4 L 26.6 -3.7 L 26.9 -1.1 L 26.1 1.3 L 24.6 2.9 L 22.8 4.1 L 21.1 4.5 L 19.2 4.7 L 17.4 4.4 L 15.3 3.4 L 13.7 1.7 L 12.9 -.1 L 12.9 -2.9 L 14.2 -5.9 L 16.0 -8.4 L 18.4 -10.3 L 20.7 -11.6 L 22.2 -12.1 L 24.8 -12.3 L 28.3 -11.7 L 30.2 -10.1 L 31.2 -7.8 L 31.2 -4.6 L 30.2 -1.4 L 28.9 1.0 L 27.3 2.8 L 25.4 4.9 L 22.9 7.0 L 21.0 8.1 L 18.2 9.3 L 15.3 10.0 L 12.6 9.9 L 10.4 9.4 L 9.3 7.9 L 9.8 6.4 L 11.6 5.8 L 15.2 6.2 L 17.4 7.1 L 19.0 8.0 L 21.7 10.7 L 23.1 12.2 L 25.0 14.0 L 27.4 14.9 L 30.3 15.1 L 32.1 14.0 L 32.4 12.7 L 32.4 11.6 L 31.2 10.4 L 29.1 10.4","0 27.9 M 6.1 9.5 L 7.1 10.8 L 8.2 11.4 L 9.6 11.3 L 11.7 10.2 L 13.6 7.9 L 16.9 2.2 L 20.6 -3.9 L 24.3 -8.7 L 27.2 -11.0 L 30.2 -12.3 L 32.8 -12.6 L 34.4 -12.1 L 35.4 -11.7 L 36.5 -10.3 M 16.0 -12.9 L 18.0 -12.0 L 19.6 -9.4 L 19.4 -7.4 L 18.9 -5.7 L 17.7 -5.3 L 17.0 -5.6 L 16.2 -6.8 L 16.9 -9.3 L 17.6 -10.2 L 19.5 -11.9 L 21.6 -12.7 L 24.8 -12.8 L 27.9 -12.5 L 30.5 -11.8 L 33.0 -10.2 L 34.8 -7.6 L 35.2 -5.5 L 35.0 -3.8 L 34.1 -1.8 L 32.1 .5 L 29.4 1.8 L 26.9 2.1 L 23.5 1.9 L 20.6 1.0 L 18.6 -.1 L 17.4 -1.6 L 17.7 -3.1 L 19.5 -3.3 L 21.6 -2.4 L 23.5 -.8 L 24.6 1.1 L 25.1 2.6 L 24.7 6.9 L 24.7 9.1 L 25.7 10.8 L 27.4 11.0 L 29.7 9.2","0 22.7 M 3.2 8.6 L 6.5 8.5 L 8.3 7.8 L 10.8 5.3 L 11.9 3.1 L 12.2 .9 L 11.1 -.6 L 9.6 -1.3 L 7.9 -.6 L 6.7 1.6 L 6.3 4.8 L 7.1 6.9 L 9.8 9.0 L 13.0 10.0 L 16.9 9.6 L 20.4 7.7 L 22.8 4.7 L 24.0 1.0 L 24.4 -7.5 L 24.8 -9.9 L 25.6 -12.1 L 26.9 -14.3 L 29.4 -15.9 L 31.8 -15.4 L 32.6 -14.3 L 32.2 -11.6 L 30.1 -9.5 L 28.1 -8.2 L 26.0 -7.8 L 23.0 -7.7 L 20.8 -8.7","0 19.8 M 6.4 6.5 L 6.2 8.3 L 7.1 9.5 L 8.6 10.1 L 10.0 10.0 L 11.8 9.1 L 13.4 7.7 L 15.9 4.6 L 22.6 -3.9 L 25.7 -7.1 L 27.7 -9.3 L 30.7 -11.2 L 33.4 -12.3 L 35.8 -12.4 L 38.3 -11.8 L 38.7 -10.9 L 38.7 -10.0 L 38.1 -9.0 L 36.4 -8.3 L 34.3 -8.0 L 31.7 -8.1 L 28.1 -8.7 L 20.8 -11.1 L 17.7 -11.2 L 15.6 -11.1 L 14.4 -10.5 L 12.3 -9.0","0 22.0 M 7.2 -8.4 L 5.7 -8.9 L 4.8 -9.7 L 4.5 -10.7 L 5.0 -11.9 L 6.2 -13.0 L 7.9 -13.3 L 10.4 -13.3 L 12.9 -12.5 L 15.3 -11.6 L 18.3 -10.7 L 20.8 -10.0 L 23.5 -10.2 L 25.0 -10.6 L 25.5 -11.7 L 25.2 -12.4 L 24.3 -12.9 L 22.9 -12.5 L 21.3 -11.0 L 17.7 -7.8 L 12.2 -1.6 L 9.9 3.0 L 9.4 4.9 L 9.7 6.8 L 11.2 8.9 L 13.7 10.0 L 16.9 9.6 L 19.0 8.4 L 20.8 7.1 L 22.0 5.6 L 24.3 .8 L 25.6 -1.7 L 27.2 -3.9 L 29.4 -6.2 L 33.1 -9.3 L 36.7 -11.1 L 32.6 -9.0 L 30.1 -6.9 L 26.2 -2.3 L 23.6 2.1 L 22.2 5.2 L 21.5 7.9 L 21.7 10.8 L 23.2 11.8 L 25.9 10.8 L 27.1 9.4 L 27.4 7.1","0 27.7 M 9.4 -7.7 L 7.8 -8.5 L 7.0 -9.8 L 7.3 -11.7 L 9.0 -12.9 L 11.1 -13.2 L 12.9 -12.9 L 15.0 -12.2 L 19.0 -10.4 L 21.0 -9.8 L 23.3 -9.5 L 25.7 -9.7 L 27.0 -10.3 L 27.7 -11.3 L 27.6 -11.8 L 26.8 -12.4 L 25.6 -12.3 L 24.2 -11.3 L 20.8 -8.4 L 17.3 -4.7 L 14.5 -.8 L 12.0 3.4 L 10.3 7.1 L 9.3 9.7 L 8.3 10.7 L 7.2 11.1 L 6.0 11.3 L 4.7 10.7 L 4.4 9.8 L 5.7 8.5 L 7.5 8.1 L 8.4 8.1 L 11.7 8.9 L 15.1 9.3 L 18.2 9.5 L 21.8 8.6 L 26.1 6.3 L 28.9 3.6 L 31.4 -.2 L 33.2 -4.1 L 34.3 -7.8 L 35.4 -13.5","0 37.4 M 11.8 -7.8 L 10.3 -8.4 L 9.4 -9.2 L 9.4 -10.5 L 10.1 -12.1 L 11.8 -12.9 L 14.6 -12.8 L 16.9 -12.3 L 18.5 -11.7 L 23.0 -10.0 L 25.3 -9.8 L 28.5 -9.8 L 29.5 -10.3 L 30.0 -10.8 L 30.0 -11.5 L 29.7 -12.1 L 29.1 -12.4 L 27.6 -12.2 L 26.3 -11.4 L 23.5 -8.7 L 19.5 -4.5 L 16.5 -.3 L 14.0 4.0 L 12.2 8.0 L 11.5 9.9 L 9.7 11.1 L 8.2 11.3 L 6.9 10.5 L 6.6 9.5 L 7.8 8.6 L 9.2 8.1 L 17.4 8.6 L 20.0 8.2 L 22.7 7.4 L 24.8 6.4 L 27.6 3.9 L 30.4 .6 L 32.2 -4.0 L 33.1 -7.5 L 33.4 -10.5 L 33.1 -10.9 L 32.5 -10.9 L 31.9 -10.1 L 31.0 -6.7 L 30.6 -1.6 L 29.9 3.4 L 29.4 5.7 L 28.1 8.2 L 26.6 10.6 L 25.4 11.7 L 24.3 12.2 L 23.4 12.2 L 22.7 11.3 L 22.8 10.7 L 23.3 10.1 L 24.4 9.9 L 30.4 9.8 L 33.0 9.1 L 36.0 7.6 L 39.1 4.4 L 41.5 .6 L 42.9 -3.5 L 43.7 -7.0 L 43.8 -10.8","0 23.9 M 9.1 .3 L 6.7 .4 L 4.8 1.1 L 2.7 2.8 L 2.1 5.0 L 2.1 6.0 L 2.9 7.9 L 4.8 9.2 L 6.9 9.6 L 9.0 9.6 L 12.1 8.9 L 15.1 7.4 L 18.2 4.8 L 20.7 1.9 L 22.8 -1.2 L 24.4 -3.7 L 27.2 -6.8 L 30.3 -9.4 L 32.7 -10.8 L 35.2 -11.5 L 37.3 -11.5 L 38.5 -10.9 L 39.6 -10.0 L 39.7 -8.5 M 20.2 -6.0 L 19.2 -4.4 L 17.8 -3.6 L 16.1 -3.6 L 15.0 -3.9 L 13.7 -5.1 L 13.3 -6.3 L 13.1 -8.5 L 14.0 -10.5 L 15.3 -11.8 L 17.5 -12.7 L 21.2 -12.8 L 23.1 -12.0 L 24.2 -11.0 L 25.0 -9.2 L 24.8 -6.3 L 24.2 -4.2 L 20.7 2.9 L 20.2 5.4 L 20.3 7.7 L 21.6 9.5 L 23.9 10.6 L 26.6 9.9 L 28.2 8.1 L 28.5 6.5 L 28.4 5.2 L 26.9 3.7 L 25.4 3.7 L 24.2 4.6","0 21.8 M 9.9 -9.1 L 8.5 -9.8 L 7.6 -11.5 L 7.9 -13.1 L 8.8 -14.0 L 9.8 -14.5 L 12.5 -14.5 L 14.9 -13.8 L 17.9 -12.5 L 21.6 -11.3 L 24.6 -11.0 L 26.3 -10.9 L 27.4 -11.3 L 28.2 -12.3 L 28.0 -13.3 L 27.0 -13.7 L 25.7 -13.3 L 24.4 -12.3 L 23.4 -11.5 L 19.8 -8.1 L 17.1 -4.9 L 14.9 -.9 L 14.4 1.9 L 15.0 4.1 L 16.7 5.5 L 20.7 5.8 L 22.0 5.0 L 24.1 3.6 L 25.6 1.7 L 31.5 -6.6 L 34.9 -9.7 L 37.5 -11.1 L 39.7 -11.9 L 36.4 -10.8 L 32.8 -7.8 L 28.4 -2.3 L 24.8 2.8 L 22.3 6.8 L 20.4 9.7 L 18.0 11.6 L 16.0 12.5 L 12.7 12.5 L 10.7 11.8 L 9.6 10.9 L 8.2 8.7 L 7.9 7.3 L 8.6 5.5 L 9.1 4.9 L 10.5 4.9 L 10.4 7.2 L 9.7 8.7 L 7.9 10.5 L 6.4 11.3","0 28.1 M 14.2 -7.0 L 13.4 -8.5 L 13.3 -10.4 L 14.2 -12.1 L 15.5 -12.9 L 16.7 -13.0 L 19.5 -12.0 L 22.1 -11.1 L 24.7 -10.4 L 27.1 -9.9 L 29.6 -9.5 L 31.4 -9.2 L 34.8 -9.4 L 37.1 -10.2 L 38.1 -10.9 L 37.9 -12.2 L 37.3 -12.7 L 35.5 -12.8 L 33.7 -12.6 L 31.6 -11.7 L 29.6 -10.3 L 27.5 -8.2 L 23.8 -2.9 L 21.5 .0 L 19.0 2.5 L 14.4 7.2 L 12.2 8.9 L 9.7 9.4 L 7.5 9.1 L 6.9 8.6 L 6.7 7.7 L 7.3 5.9 L 9.1 5.2 L 11.5 5.3 L 14.2 5.8 L 17.9 7.0 L 25.1 9.6 L 28.5 10.2 L 31.9 10.0 L 33.8 8.7 L 34.0 7.5 L 34.1 6.1 L 34.0 5.8","0 13.2 M 29.8 -13.3 L 26.3 -13.2 L 9.4 12.9 L 13.1 12.9","0 12.5 M 10.7 -16.0 L 16.3 13.1","0 20.3 M 22.2 -14.2 L 26.1 -14.1 L 9.1 12.4 L 5.6 12.7","0 20.0 M 10.1 -5.4 L 14.1 -6.3 L 18.7 -8.0 L 23.3 -10.8 L 24.9 -11.7 L 24.3 -8.9 L 24.3 -6.9 L 25.1 -5.6 L 25.9 -5.3","0 16.5 M 8.8 7.7 L 23.5 7.7","0 10.7 M 8.7 -16.6 L 9.6 -14.2 L 11.3 -12.6 L 13.9 -11.8 L 17.0 -11.7","0 20.1 M 25.4 -.5 L 21.1 2.3 L 17.4 5.0 L 14.8 6.9 L 12.6 8.0 L 11.3 8.2 L 10.0 8.1 L 8.5 7.3 L 7.7 6.1 L 7.8 3.3 L 9.3 1.2 L 13.9 -2.3 L 17.0 -3.6 L 19.4 -4.0 L 22.1 -3.6 L 23.3 -2.2 L 22.9 -.3 L 21.5 1.6 L 17.9 5.2 L 17.5 6.2 L 17.8 7.1 L 20.0 7.8 L 22.4 7.3 L 25.8 5.5 L 28.1 3.0","0 16.1 M 8.0 3.1 L 10.8 1.1 L 12.3 -.5 L 18.9 -7.6 L 22.9 -12.7 L 23.7 -13.9 L 23.7 -14.5 L 23.4 -15.3 L 22.4 -15.6 L 21.6 -15.3 L 18.5 -12.3 L 13.3 -6.3 L 10.2 -1.9 L 8.7 .7 L 8.1 2.1 L 7.9 4.3 L 7.9 5.9 L 8.9 7.1 L 10.0 7.9 L 11.0 8.3 L 12.5 8.3 L 14.9 7.3 L 17.3 5.2 L 18.9 2.8 L 19.3 .9 L 19.4 -.7 L 19.4 -1.7 L 19.0 -2.3 L 17.7 -2.3 L 17.4 -1.0 L 18.3 .6 L 20.3 2.7 L 21.7 3.6 L 23.1 3.6 L 24.1 3.0","0 16.1 M 19.1 -1.5 L 19.1 -2.3 L 18.3 -3.4 L 16.0 -3.7 L 13.3 -2.5 L 10.1 .1 L 8.4 2.1 L 7.5 4.1 L 7.6 6.0 L 9.2 7.5 L 12.3 7.9 L 16.4 7.0 L 19.9 5.3 L 24.1 3.0","0 20.2 M 22.5 .3 L 23.1 -1.7 L 22.3 -3.5 L 19.7 -4.2 L 15.8 -3.4 L 11.6 -.9 L 9.4 1.1 L 7.9 3.1 L 7.3 4.9 L 7.7 6.3 L 8.9 7.7 L 11.5 8.4 L 13.9 7.6 L 17.6 5.2 L 21.0 1.7 L 24.6 -2.1 L 28.5 -5.5 L 32.3 -9.6 L 33.5 -11.3 L 33.7 -12.1 L 33.4 -12.7 L 32.8 -12.8 L 31.6 -12.2 L 29.2 -9.0 L 26.5 -5.7 L 24.8 -3.3 L 20.1 3.6 L 19.1 5.4 L 18.9 6.7 L 19.1 7.4 L 19.8 7.9 L 21.0 7.7 L 23.6 6.7 L 25.7 5.4 L 28.2 3.0","0 15.8 M 9.1 -.8 L 12.8 1.0 L 15.9 1.3 L 18.1 1.0 L 19.8 .1 L 21.0 -1.1 L 21.4 -2.5 L 21.3 -3.2 L 20.0 -4.5 L 17.8 -5.0 L 14.6 -4.0 L 11.2 -1.6 L 8.8 1.3 L 7.7 3.6 L 7.6 5.9 L 8.4 7.1 L 9.7 8.0 L 10.6 8.2 L 13.7 8.2 L 17.0 7.2 L 20.6 5.4 L 23.8 3.0","0 11.4 M 8.1 2.7 L 12.5 .6 L 18.0 -3.4 L 21.6 -6.7 L 24.1 -10.1 L 25.2 -12.4 L 25.1 -14.4 L 24.4 -15.3 L 23.5 -15.5 L 21.9 -13.9 L 11.4 -1.5 L 1.8 11.1 L -1.4 15.9 L -2.8 18.8 L -3.2 20.3 L -2.6 21.6 L -.8 21.0 L .8 20.0 L 3.3 16.5 L 5.2 12.8 L 6.0 9.5 L 5.9 6.0 L 8.5 7.3 L 11.5 7.2 L 12.9 7.1 L 15.8 6.0 L 17.7 4.8 L 19.4 3.0","0 17.3 M 25.0 -.4 L 19.9 2.9 L 15.9 6.2 L 12.3 8.2 L 10.4 8.0 L 8.1 7.0 L 7.4 4.4 L 8.5 1.9 L 11.1 -.5 L 13.2 -2.0 L 16.0 -3.6 L 18.1 -3.9 L 20.7 -3.8 L 22.0 -3.5 L 22.9 -2.5 L 23.0 -1.2 L 22.5 .0 L 21.8 1.3 L 17.7 5.5 L 15.7 8.2 L 13.2 11.7 L 10.6 15.0 L 7.8 18.2 L 5.5 20.3 L 3.7 21.6 L 2.4 21.8 L 1.8 21.4 L 1.4 20.0 L 1.8 18.6 L 4.6 15.8 L 9.3 12.3 L 13.3 9.8 L 18.9 7.0 L 22.2 5.2 L 25.3 3.0","0 18.3 M 11.6 -2.8 L 15.9 -5.5 L 19.7 -8.5 L 23.4 -11.8 L 25.0 -13.5 L 25.4 -14.8 L 25.1 -15.8 L 24.6 -16.3 L 23.5 -16.5 L 21.3 -14.4 L 16.7 -9.4 L 13.6 -5.6 L 10.5 -1.1 L 8.3 2.4 L 5.9 7.4 L 9.8 2.2 L 14.1 -2.3 L 16.9 -4.1 L 20.4 -4.3 L 21.6 -3.4 L 22.0 -1.4 L 21.1 .6 L 18.4 3.7 L 16.9 5.8 L 17.0 7.5 L 17.6 7.7 L 19.1 7.3 L 21.4 6.4 L 23.9 5.1 L 26.3 3.0","0 9.7 M 13.1 -4.1 L 8.8 1.6 L 7.2 4.4 L 6.8 5.7 L 6.9 6.5 L 7.2 7.2 L 7.7 7.7 L 8.9 7.8 L 10.4 7.5 L 12.3 6.9 L 14.8 5.5 L 17.7 3.0 M 15.2 -8.4 L 14.5 -7.5 L 15.4 -6.8 L 16.2 -7.7 L 15.2 -8.4","0 7.1 M 12.1 -4.1 L 6.4 5.7 L 1.5 13.8 L -3.4 20.0 L -5.3 21.6 L -6.5 21.9 L -7.6 20.8 L -7.4 19.6 L -6.4 18.0 L -3.0 15.0 L 5.2 9.9 L 11.2 6.1 L 15.1 3.0 M 13.6 -8.4 L 12.8 -7.4 L 13.9 -6.6 L 14.7 -7.6 L 13.6 -8.4","0 15.0 M 5.6 7.9 L 8.5 1.9 L 12.2 -4.0 L 16.4 -10.1 L 20.3 -15.0 L 22.4 -16.3 L 23.6 -16.1 L 24.2 -15.0 L 23.6 -12.8 L 20.6 -9.2 L 17.2 -6.0 L 13.0 -2.6 L 11.1 -1.1 L 8.9 1.4 L 12.0 -2.0 L 15.0 -3.6 L 17.2 -4.1 L 20.1 -4.0 L 21.2 -3.2 L 21.4 -1.7 L 21.0 -.5 L 19.0 1.0 L 17.4 1.4 L 14.3 1.5 L 13.1 1.2 L 11.3 .6 L 11.0 4.9 L 11.4 6.6 L 12.6 7.8 L 13.9 8.4 L 15.9 8.4 L 18.6 7.0 L 20.5 5.9 L 21.8 4.7 L 23.0 3.0","0 12.5 M 8.9 1.4 L 9.2 1.4 L 16.1 -3.5 L 21.2 -8.3 L 23.4 -11.6 L 24.1 -13.7 L 23.5 -15.3 L 22.1 -15.6 L 18.8 -13.3 L 14.1 -7.2 L 10.4 -1.4 L 7.8 3.3 L 7.5 5.9 L 8.9 7.7 L 12.0 7.5 L 15.7 6.0 L 20.5 3.0","0 29.1 M 11.8 -3.8 L 12.4 -3.0 L 11.6 -1.5 L 9.5 1.4 L 6.1 4.8 L 3.0 8.1 L 10.6 .9 L 15.0 -2.3 L 18.3 -3.8 L 20.0 -4.1 L 21.0 -4.0 L 21.8 -2.9 L 21.7 -1.1 L 21.0 1.1 L 16.2 7.5 L 21.1 1.6 L 25.3 -1.9 L 28.2 -3.6 L 30.7 -3.7 L 31.9 -3.1 L 32.0 -1.6 L 31.1 .4 L 27.8 4.6 L 27.1 5.9 L 27.4 7.0 L 28.7 7.8 L 31.2 7.3 L 34.0 5.7 L 37.1 3.0","0 20.3 M 11.2 -3.5 L 11.1 -2.0 L 9.9 -.1 L 8.0 3.1 L 4.8 7.5 L 9.1 2.3 L 12.0 -.4 L 14.9 -2.4 L 17.3 -3.5 L 20.2 -3.8 L 21.6 -3.5 L 22.6 -2.6 L 22.7 -1.4 L 21.9 .0 L 19.8 3.1 L 18.6 5.1 L 18.1 6.3 L 18.4 7.2 L 19.2 7.8 L 20.6 7.9 L 22.8 7.1 L 24.9 5.8 L 26.2 4.8 L 28.3 3.0","0 19.7 M 21.7 -2.7 L 20.7 -3.9 L 17.5 -4.3 L 13.9 -3.2 L 10.5 -.7 L 8.3 2.0 L 7.6 4.4 L 7.8 6.2 L 8.9 7.7 L 11.0 8.4 L 13.0 7.8 L 16.6 5.9 L 18.6 4.0 L 20.3 2.1 L 21.6 .1 L 22.1 -.8 L 22.1 -2.1 L 21.4 -2.8 L 20.4 -2.6 L 18.8 -.5 L 18.8 1.3 L 19.3 3.1 L 20.4 4.2 L 22.8 5.0 L 24.8 4.8 L 27.7 3.0","0 20.7 M 16.2 -6.1 L 12.4 1.1 L 7.7 8.9 L 3.7 15.0 L .7 18.9 L -.8 20.3 L -1.7 20.7 L -2.8 20.6 L -3.1 20.0 L -2.3 17.1 L .2 13.1 L 3.0 8.7 L 7.2 3.9 L 11.4 -.5 L 14.7 -3.1 L 17.5 -4.6 L 21.0 -5.1 L 23.5 -4.3 L 25.0 -2.4 L 24.5 .5 L 22.6 3.4 L 20.5 5.2 L 17.4 6.6 L 15.7 7.2 L 13.4 7.2 L 12.1 6.9 L 9.7 6.0 L 15.7 8.2 L 18.6 8.2 L 21.0 7.5 L 24.4 6.1 L 26.9 4.5 L 28.7 3.0","0 17.7 M 18.0 4.4 L 17.4 9.0 L 16.0 12.7 L 14.3 16.0 L 11.7 19.4 L 9.8 21.1 L 8.4 21.4 L 7.6 20.8 L 7.4 19.5 L 8.3 17.6 L 11.8 12.6 L 14.4 9.0 L 17.2 5.5 L 18.9 3.5 L 21.6 1.1 L 22.9 -1.0 L 22.7 -3.2 L 21.9 -4.0 L 19.0 -4.6 L 15.9 -3.8 L 12.2 -1.9 L 8.5 2.0 L 7.4 4.3 L 8.1 6.3 L 10.2 7.8 L 12.7 7.5 L 15.6 5.8 L 19.7 3.0 L 18.7 4.9 L 18.9 6.2 L 19.7 6.9 L 20.9 6.6 L 22.3 5.6 L 25.7 3.0","0 15.3 M 8.0 3.0 L 9.9 1.5 L 12.0 -1.0 L 13.2 -3.2 L 13.8 -3.8 L 14.2 -4.8 L 14.0 -5.6 L 13.3 -5.9 L 12.7 -5.4 L 12.7 -4.7 L 13.6 -3.7 L 15.5 -3.1 L 16.7 -3.0 L 17.7 -2.8 L 18.0 -2.2 L 17.6 -1.3 L 13.6 4.2 L 12.8 6.2 L 13.2 8.0 L 14.5 8.7 L 15.8 8.6 L 18.0 7.3 L 23.3 3.0","0 13.4 M 7.9 3.1 L 10.3 1.2 L 12.6 -1.0 L 14.7 -2.6 L 16.3 -4.0 L 16.6 -5.0 L 16.5 -5.5 L 15.8 -5.9 L 15.0 -5.4 L 14.4 -4.5 L 14.5 -2.8 L 14.6 4.2 L 14.3 6.5 L 13.5 7.8 L 12.8 8.2 L 11.2 8.2 L 10.4 7.6 L 10.1 6.9 L 10.1 6.0 L 10.8 4.9 L 12.7 3.7 L 14.8 2.6 L 17.4 1.7 L 19.6 1.0 L 21.9 1.3","0 15.6 M 8.0 3.0 L 15.6 -3.2 L 20.4 -8.1 L 23.4 -12.4 L 24.8 -15.5 L 25.2 -16.5 L 24.7 -17.2 L 23.7 -16.6 L 21.7 -12.9 L 19.2 -8.4 L 14.8 -.3 L 11.8 5.8 L 11.7 6.9 L 12.2 7.8 L 13.5 8.3 L 15.1 8.3 L 17.9 7.3 L 21.5 5.2 L 23.6 3.0 M 11.6 -4.9 L 11.8 -5.0 L 22.6 -4.5","0 19.3 M 13.1 -4.4 L 9.5 .6 L 7.6 3.6 L 7.0 5.4 L 7.1 6.6 L 8.3 7.4 L 10.0 7.5 L 12.0 6.8 L 14.6 5.4 L 17.8 3.0 L 20.4 .3 L 24.4 -4.4 L 19.1 1.9 L 17.7 4.6 L 17.3 6.5 L 17.5 7.4 L 18.2 7.9 L 19.5 7.8 L 21.5 7.3 L 24.5 5.6 L 27.3 3.0","0 20.0 M 8.0 -2.9 L 9.2 -3.9 L 10.3 -4.4 L 11.0 -4.0 L 10.6 -2.0 L 9.4 .3 L 8.1 2.7 L 7.2 4.7 L 6.8 5.9 L 7.1 6.8 L 8.1 7.7 L 10.2 7.8 L 14.1 6.0 L 16.6 3.7 L 18.9 1.0 L 19.9 -.7 L 20.9 -2.6 L 21.2 -4.5 L 20.7 -5.2 L 19.5 -5.2 L 19.2 -4.0 L 19.7 -2.6 L 21.4 -1.4 L 24.1 -1.1 L 25.9 -1.6 L 28.1 -3.2","0 23.0 M 11.8 -3.6 L 9.2 .5 L 7.2 4.8 L 7.0 6.9 L 8.7 8.2 L 11.0 7.5 L 13.9 5.5 L 16.3 3.0 L 18.3 .4 L 20.4 -3.4 L 16.9 4.5 L 16.7 6.9 L 18.1 8.0 L 20.0 7.9 L 21.9 7.1 L 24.5 4.3 L 26.5 1.2 L 27.8 -1.1 L 28.4 -3.2 L 27.9 -4.2 L 26.9 -4.2 L 26.5 -2.7 L 26.2 -.8 L 26.6 .3 L 27.5 2.0 L 28.7 3.7 L 29.9 3.6 L 31.0 3.0","0 18.1 M 8.3 -.6 L 11.6 -2.3 L 14.2 -3.4 L 15.6 -3.7 L 16.4 -2.9 L 15.1 2.7 L 14.7 7.1 L 16.8 8.3 L 19.8 7.6 L 23.3 5.7 L 26.1 3.0 M 6.3 9.0 L 11.6 4.5 L 17.1 .4 L 21.5 -2.2 L 24.6 -3.7","0 17.6 M 15.6 -4.1 L 13.5 -3.1 L 11.0 -1.0 L 8.3 2.1 L 7.5 4.4 L 7.3 5.7 L 7.4 6.8 L 9.4 8.2 L 11.0 8.2 L 14.2 6.9 L 18.0 4.6 L 21.2 1.8 L 23.3 -1.0 L 24.5 -2.9 L 23.8 -3.9 L 22.5 -3.7 L 20.9 -.6 L 17.9 4.8 L 14.3 11.3 L 11.5 15.6 L 8.7 18.8 L 5.8 21.0 L 4.0 21.7 L 2.9 21.5 L 2.6 21.0 L 2.5 19.6 L 4.3 17.3 L 9.0 13.4 L 12.0 11.3 L 16.8 8.8 L 21.4 6.2 L 24.2 4.3 L 25.6 3.0","0 16.1 M 10.8 -1.1 L 13.7 -3.1 L 15.5 -3.8 L 17.0 -4.2 L 18.3 -3.7 L 19.4 -2.0 L 19.3 .5 L 17.4 2.9 L 14.6 4.9 L 11.8 6.4 L 13.7 7.3 L 15.1 8.8 L 14.3 12.4 L 12.0 15.4 L 9.4 18.3 L 7.1 20.5 L 5.4 21.5 L 4.2 21.8 L 3.2 21.4 L 2.8 20.1 L 3.9 18.3 L 6.3 15.6 L 11.5 11.8 L 15.2 9.4 L 19.8 7.0 L 21.7 5.3 L 24.1 3.0","0 11.7 M 25.9 -15.0 L 23.5 -14.6 L 21.1 -12.8 L 19.7 -10.1 L 18.7 -6.4 L 17.5 -4.0 L 16.3 -3.0 L 14.3 -2.1 L 16.1 -.3 L 16.1 1.0 L 15.7 2.7 L 14.1 4.9 L 11.8 6.5 L 10.4 8.0 L 10.3 9.8 L 10.5 10.4 L 11.4 11.7","0 20.3 M 27.9 -16.7 L 9.2 12.8","0 16.9 M 21.9 -15.8 L 23.0 -14.9 L 23.4 -13.3 L 22.6 -11.7 L 20.4 -9.8 L 18.6 -7.8 L 17.6 -5.4 L 17.6 -4.1 L 18.0 -3.0 L 19.5 -2.0 L 17.3 -1.1 L 15.7 .4 L 14.5 3.4 L 13.6 6.7 L 11.6 9.6 L 10.0 10.9 L 7.9 11.3","0 11.7 M 9.7 -12.8 L 9.7 -11.2 L 11.4 -10.7 L 13.1 -11.6 L 14.6 -12.8 L 16.1 -12.9 L 17.3 -12.4 L 17.8 -10.8","-1 16 M 9.59 -9.17 L 9.53 2.67 L 21.57 2.67 L 21.57 -9.37 L 9.59 -9.17"]
EMSLittlePrincess = ["-8 8","0 7.9 M 11.6 -19.1 L 11.2 -.1 M 11.1 4.9 L 10.1 6.0 L 11.1 7.4 L 12.3 6.2 L 11.1 4.9","0 11.9 M 11.1 -15.0 L 11.3 -14.1 L 11.4 -4.5 L 10.9 -5.1 M 16.5 -15.2 L 17.1 -14.4 L 17.3 -3.9 L 16.8 -4.6","0 19.9 M 10.2 -4.2 L 12.2 -5.2 L 14.7 -5.6 L 17.4 -5.6 L 20.3 -5.3 L 23.1 -5.3 L 25.1 -5.4 L 26.5 -5.9 M 10.2 -9.2 L 12.2 -10.4 L 14.2 -10.9 L 16.5 -11.0 L 18.7 -10.9 L 21.5 -10.5 L 24.3 -10.7 L 26.2 -11.1 L 27.6 -11.6 M 18.3 -15.1 L 17.4 -11.6 L 16.2 -8.4 L 14.4 -4.8 L 12.8 -2.0 M 24.2 -15.5 L 23.3 -13.8 L 21.7 -8.8 L 19.6 -3.3 L 19.1 -1.6 L 18.5 -.8","0 17.7 M 15.6 4.2 L 15.3 3.0 L 14.3 2.2 L 13.3 2.2 L 11.0 3.6 L 9.5 6.0 L 9.5 9.1 L 11.5 11.7 L 14.7 12.2 L 17.4 11.7 L 20.6 9.8 L 22.6 7.2 L 23.0 5.0 L 21.4 1.2 L 18.2 -2.3 L 14.3 -6.4 L 12.3 -9.4 L 12.3 -12.0 L 14.0 -14.1 L 16.3 -14.6 L 18.9 -14.3 L 21.1 -13.0 L 22.7 -11.2 L 22.6 -9.5 L 21.3 -7.6 M 17.1 -14.8 L 17.4 -19.4 L 16.9 -19.0 M 16.3 12.3 L 16.0 16.2","0 21.3 M 12.8 -12.7 L 9.9 -10.9 L 9.2 -8.3 L 9.7 -6.8 L 11.5 -6.2 L 13.7 -6.7 L 15.3 -7.8 L 15.1 -10.3 L 13.9 -11.5 L 13.1 -12.1 L 15.7 -11.2 L 18.4 -11.3 L 21.2 -12.0 L 23.6 -12.4 L 26.0 -12.9 L 28.0 -13.8 L 26.7 -13.7 L 23.6 -10.9 L 19.9 -6.3 L 15.7 -.5 L 13.0 4.0 L 11.3 8.1 L 10.8 11.4 L 11.8 13.4 L 13.1 14.5 M 24.5 -1.0 L 22.0 .4 L 20.6 3.4 L 20.8 5.4 L 23.3 5.6 L 26.2 3.8 L 27.5 1.6 L 26.5 -.9 L 24.5 -1.0","0 26.8 M 28.9 -17.0 L 26.4 -15.4 L 25.2 -17.0 L 22.6 -17.9 L 20.5 -17.5 L 19.1 -16.5 L 17.8 -15.2 L 17.8 -13.7 L 19.4 -12.6 L 22.2 -11.8 L 24.0 -12.3 L 23.5 -12.8 L 21.4 -12.7 L 17.8 -11.4 L 14.3 -8.5 L 12.3 -5.5 L 11.5 -1.5 L 12.1 1.8 L 14.5 4.6 L 18.3 6.3 L 22.0 5.9 L 25.4 4.4 L 28.6 2.1 L 30.6 -1.1 L 31.1 -3.9 L 29.7 -7.1 L 27.7 -8.8 L 25.9 -9.4 M 21.4 .1 L 19.3 -.3 L 17.9 -2.1 L 18.1 -5.0 L 20.0 -7.1 L 22.2 -8.5 L 25.1 -9.3 L 28.6 -10.4 L 33.6 -12.3 L 35.8 -14.7 L 35.8 -17.0 L 34.4 -18.3 L 33.1 -18.7","0 6.5 M 11.1 -14.9 L 11.4 -14.1 L 11.6 -4.1 L 10.8 -4.8","0 10.7 M 19.6 -20.0 L 18.5 -20.1 L 15.0 -18.4 L 13.6 -14.4 L 12.8 -6.4 L 12.6 2.6 L 13.1 11.2 L 13.9 15.5 L 15.1 17.3 L 16.2 18.2 L 17.5 18.6 L 18.9 18.6","0 10.3 M 6.7 18.2 L 7.0 18.2 L 9.8 17.5 L 12.6 14.3 L 13.5 9.4 L 13.7 2.7 L 13.8 -7.2 L 13.3 -14.0 L 12.7 -18.3 L 11.6 -20.2 L 9.7 -20.8 L 8.3 -20.6 L 6.8 -20.1","0 13.6 M 15.8 -1.4 L 15.6 -18.9 M 11.7 -5.8 L 20.3 -15.7 M 10.1 -10.4 L 19.3 -10.8 L 20.8 -11.0 L 21.7 -11.4","0 18.0 M 17.3 2.3 L 17.2 -4.9 M 10.4 -.8 L 23.4 -.5","0 5.1 M 9.8 8.0 L 8.9 6.6 L 10.5 5.6 L 10.2 8.3 L 8.9 10.6","0 19.0 M 10.6 -1.3 L 25.1 -1.1","0 6.7 M 9.6 6.4 L 10.6 5.3 L 11.9 6.2 L 11.2 7.0 L 9.6 6.4","0 14.7 M 9.1 16.4 L 8.7 13.0 L 9.7 8.8 L 12.2 2.7 L 16.5 -5.2 L 22.1 -14.2 L 25.7 -18.9","0 24.3 M 17.3 -10.6 L 13.9 -8.5 L 11.6 -4.5 L 11.1 .3 L 12.6 5.4 L 16.9 8.6 L 20.9 9.6 L 25.0 8.3 L 28.6 3.4 L 29.7 -2.5 L 28.4 -7.1 L 25.5 -10.7 L 22.1 -11.6 L 17.3 -10.6","0 13.2 M 15.6 13.1 L 16.4 -3.9 L 16.1 -14.8 L 14.3 -12.5 L 12.4 -11.1 L 10.0 -10.2","0 20.8 M 16.4 -4.1 L 14.3 -3.9 L 12.5 -5.1 L 12.0 -9.0 L 12.8 -12.3 L 15.3 -14.8 L 18.4 -15.8 L 21.1 -14.9 L 24.1 -11.6 L 24.9 -6.8 L 23.7 -2.0 L 21.9 2.1 L 18.9 5.2 L 15.1 8.3 L 13.1 9.8 L 11.7 9.7 L 9.0 10.4 L 13.3 9.8 L 16.7 11.3 L 20.1 12.7 L 24.4 13.2 L 26.0 12.6 L 27.4 11.5","0 23.4 M 18.8 5.6 L 19.9 4.4 L 19.7 2.6 L 18.3 1.8 L 15.6 1.9 L 12.2 3.6 L 9.9 7.5 L 10.2 11.3 L 13.3 13.5 L 18.1 13.7 L 23.3 11.9 L 27.0 9.1 L 28.4 5.0 L 27.6 -.1 L 24.6 -2.8 L 21.5 -3.6 L 19.3 -3.6 L 17.4 -2.5 L 21.7 -5.1 L 24.8 -8.4 L 25.4 -12.2 L 23.3 -15.5 L 19.3 -16.3 L 15.2 -14.8 L 13.3 -11.4 L 12.9 -8.2 L 14.7 -6.4","0 24.2 M 24.8 15.3 L 24.4 14.7 L 25.1 -3.6 L 24.1 -7.4 M 21.6 -17.5 L 21.6 -12.8 L 20.1 -8.1 L 17.3 -3.9 L 15.4 -1.8 L 12.8 -.2 L 11.1 .7 L 7.9 .9 L 11.7 1.1 L 15.0 2.0 L 19.9 3.3 L 23.8 3.7 L 28.1 3.2 L 31.3 1.8 L 33.0 .1","0 22.4 M 28.1 -16.4 L 25.3 -14.9 L 20.3 -14.8 L 16.1 -14.8 L 12.4 -13.8 L 9.0 -12.0 L 12.3 -13.8 L 12.3 -1.7 L 15.5 -4.7 L 18.9 -7.1 L 22.0 -7.6 L 24.5 -6.8 L 27.1 -4.3 L 27.7 -.8 L 27.5 4.0 L 25.7 8.0 L 23.4 10.4 L 20.3 12.6 L 16.8 13.9 L 13.0 12.8 L 11.8 9.3 L 13.1 5.8 L 14.8 3.9 L 17.2 3.2 L 19.0 3.7","0 24.7 M 17.0 7.8 L 15.4 6.6 L 15.1 3.6 L 16.8 1.0 L 20.6 -1.2 L 25.2 -1.3 L 27.7 .8 L 29.0 4.2 L 28.4 7.7 L 25.7 10.4 L 21.8 12.3 L 18.2 12.2 L 14.1 10.0 L 11.6 6.4 L 11.2 .7 L 12.2 -5.6 L 14.9 -10.0 L 19.0 -13.2 L 23.4 -14.5 L 27.1 -14.7 L 29.2 -13.4 L 30.4 -12.1","0 21.3 M 16.4 14.3 L 15.9 10.6 L 17.5 4.8 L 19.7 -1.6 L 23.2 -7.9 L 25.6 -11.5 L 27.8 -13.7 L 32.5 -15.1 L 27.4 -13.7 L 23.5 -14.2 L 18.2 -15.3 L 14.4 -14.6 L 11.5 -12.6 L 10.1 -10.0 L 10.7 -6.9","0 21.0 M 9.8 7.6 L 10.6 11.3 L 13.6 13.3 L 17.7 13.3 L 21.7 11.4 L 24.3 8.2 L 24.7 4.2 L 22.4 1.0 L 17.5 -3.1 L 14.1 -6.1 L 12.3 -8.8 L 12.6 -12.4 L 15.3 -14.9 L 18.8 -16.1 L 22.4 -15.4 L 24.8 -12.9 L 25.5 -9.2 L 24.1 -6.4 L 20.6 -3.5 L 13.3 1.4 L 10.5 4.4 L 9.8 7.6","0 23.1 M 10.8 11.1 L 11.2 11.4 L 13.5 13.3 L 17.5 13.5 L 22.4 10.8 L 26.1 6.2 L 27.7 1.5 L 27.8 -3.1 L 27.2 -8.4 L 25.4 -13.0 L 22.0 -15.9 L 18.9 -16.0 L 14.9 -13.6 L 13.1 -10.5 L 11.9 -6.3 L 12.2 -1.7 L 14.3 1.3 L 18.5 2.3 L 22.2 1.5 L 25.6 -.9 L 27.7 -4.1","0 7.1 M 10.2 -5.5 L 11.3 -6.5 L 12.7 -5.8 L 11.8 -4.9 L 10.2 -5.5 M 9.7 6.3 L 11.1 5.3 L 12.3 6.0 L 11.5 7.1 L 9.7 6.3","0 6.7 M 9.4 -6.0 L 10.5 -7.1 L 11.8 -6.0 L 10.9 -5.0 L 9.4 -6.0 M 11.1 7.7 L 10.6 6.6 L 11.8 5.8 L 11.4 8.8 L 10.8 10.1 L 9.6 11.0","0 14.5 M 19.5 7.3 L 10.7 -1.4 L 19.1 -9.8","0 19.9 M 11.0 -4.6 L 25.1 -4.2 M 11.0 1.6 L 24.7 1.9","0 16.9 M 12.9 7.4 L 21.7 -2.5 L 11.0 -9.9","0 16.6 M 13.8 6.2 L 14.9 5.2 L 18.1 6.6 L 17.4 7.5 L 13.8 6.2 M 15.5 1.5 L 13.9 1.1 L 13.2 -1.1 L 14.6 -3.9 L 17.3 -6.2 L 21.8 -8.9 L 24.0 -12.0 L 24.5 -16.1 L 22.1 -18.7 L 18.5 -20.4 L 14.2 -19.5 L 11.0 -16.2 L 9.8 -12.8 L 10.2 -8.9 L 11.6 -7.0 L 12.8 -7.1 L 14.7 -8.6","0 30.4 M 27.2 -6.9 L 24.7 -3.7 L 21.7 -.3 L 19.5 .3 L 18.5 -.8 L 19.5 -4.3 L 21.6 -6.9 L 23.7 -8.2 L 25.5 -8.1 L 26.3 -7.2 L 26.3 -4.7 L 26.5 -.3 L 28.3 .9 L 31.3 .4 L 34.0 -1.7 L 35.6 -5.5 L 35.7 -8.6 L 33.2 -12.3 L 29.3 -14.9 L 24.9 -15.6 L 20.1 -14.7 L 15.7 -12.3 L 11.9 -8.0 L 10.9 -2.9 L 11.9 .9 L 14.6 3.8 L 18.0 5.6 L 22.0 6.6 L 26.3 6.4 L 29.1 5.9 L 31.1 5.1","0 24.4 M 10.5 11.5 L 9.7 9.6 L 7.9 8.9 L 5.3 9.7 L 3.8 12.0 L 3.5 15.4 L 5.3 17.4 L 8.3 17.7 L 11.7 15.9 L 15.1 11.3 L 17.5 4.8 L 20.0 -4.3 L 22.0 -11.6 L 24.7 -16.5 L 26.8 -18.6 L 28.5 -19.7 L 30.5 -19.7 L 30.9 -18.7 L 29.1 -18.5 L 25.7 -17.5 L 23.7 -16.9 L 18.3 -17.2 L 13.5 -16.7 L 9.7 -15.4 L 6.4 -12.2 L 5.7 -8.7 L 7.2 -6.4 L 10.3 -5.7 M 29.8 -17.9 L 27.9 -6.7 L 26.9 3.4 L 18.5 3.3 L 26.9 3.3 L 26.9 9.2 L 27.9 15.7 L 29.9 20.7 L 32.0 23.8 L 33.7 24.9 L 35.5 25.3 L 37.5 25.1 L 39.8 23.9","0 29.8 M 14.2 8.8 L 12.7 8.6 L 10.9 9.3 L 10.0 11.0 L 9.5 13.6 L 10.8 16.2 L 14.3 17.8 L 17.2 17.1 L 20.1 14.7 L 21.1 11.2 L 20.4 7.3 L 18.5 3.0 L 17.3 -2.1 L 17.5 -6.2 L 19.6 -9.9 L 22.2 -12.0 M 13.5 -3.0 L 10.9 -4.6 L 10.6 -8.5 L 12.6 -13.8 L 17.2 -18.2 L 21.7 -19.7 L 26.6 -19.3 L 31.3 -17.1 L 35.4 -13.2 L 36.3 -7.4 L 34.5 -2.4 L 31.1 1.4 L 29.2 2.8 L 25.5 4.0 L 24.0 4.4 L 24.6 3.6 L 30.7 4.5 L 33.2 7.7 L 33.2 10.9 L 31.6 13.6 L 29.6 14.9 L 26.7 15.1 L 25.6 14.1 L 24.9 12.3","0 31.4 M 29.5 -7.2 L 29.2 -5.9 L 30.9 -4.2 L 33.8 -4.4 L 37.4 -6.7 L 38.9 -10.2 L 38.8 -13.2 L 36.3 -16.8 L 32.5 -18.9 L 27.0 -19.1 L 21.0 -17.2 L 14.6 -12.3 L 11.1 -7.3 L 10.1 -1.5 L 10.8 3.8 L 12.6 8.6 L 16.5 12.5 L 20.4 15.4 L 24.5 16.9 L 30.1 16.5 L 34.3 14.8 L 37.1 12.5","0 36.9 M 16.0 1.2 L 13.0 .7 L 11.2 -2.2 L 10.9 -7.1 L 12.3 -11.3 L 15.8 -15.1 L 20.0 -17.2 L 25.5 -18.6 L 31.1 -17.9 L 35.6 -15.5 L 39.0 -10.2 L 40.8 -3.3 L 41.0 3.9 L 38.9 8.6 L 34.9 12.4 L 29.0 14.7 L 24.5 15.2 L 19.8 13.9 L 14.3 12.8 L 11.6 14.3 L 11.5 16.3 L 13.9 17.7 L 18.1 15.8 L 21.6 12.4 L 22.4 7.9 L 21.5 2.1 L 20.5 -4.8 L 21.4 -10.8 L 22.9 -13.3 L 27.0 -15.5","0 30.7 M 24.5 7.2 L 21.8 7.4 L 19.3 5.1 L 20.3 1.1 L 24.1 -2.4 L 28.7 -3.4 L 33.2 -1.5 L 35.9 2.7 L 35.2 8.0 L 32.0 13.3 L 25.5 16.6 L 19.4 17.0 L 13.0 13.3 L 10.2 6.2 L 12.0 -1.3 L 16.3 -6.4 L 21.6 -9.7 L 24.6 -10.5 L 27.7 -10.5 L 26.1 -9.5 L 23.7 -9.6 L 21.1 -11.6 L 20.3 -14.2 L 22.8 -17.5 L 26.6 -19.3 L 30.4 -19.1 L 33.3 -16.8 L 34.1 -14.8 L 32.6 -12.2","0 22.1 M 16.3 7.4 L 13.9 6.2 L 11.3 7.1 L 9.7 10.8 L 11.1 16.3 L 16.2 18.2 L 20.3 16.0 L 23.4 11.6 L 24.0 6.0 L 23.1 -11.8 L 24.3 -17.0 L 28.2 -20.8 L 32.0 -21.1 L 33.2 -19.5 L 32.0 -17.4 L 29.6 -16.2 L 25.2 -15.7 L 18.3 -16.2 L 10.8 -17.1 L 7.8 -16.1 L 5.8 -14.4 L 5.2 -11.7 L 5.4 -9.1 L 6.6 -7.7 L 7.7 -7.7 M 17.6 -5.6 L 28.0 -8.5 L 27.0 -7.4","0 34.9 M 11.0 -14.8 L 8.4 -11.6 L 7.6 -7.4 L 9.2 -2.9 L 13.6 -1.2 L 18.8 -1.3 L 24.9 -3.5 L 30.8 -6.9 L 35.6 -10.9 L 38.8 -14.2 L 38.3 -17.8 L 36.2 -19.9 L 31.1 -19.5 L 26.2 -17.3 L 21.3 -12.8 L 17.3 -7.0 L 15.3 -3.1 L 13.9 2.4 L 14.7 7.7 L 18.3 12.3 L 24.7 12.4 L 30.3 9.7 L 35.6 4.8 L 39.4 -.9 L 38.5 2.4 L 39.2 8.9 L 39.4 14.9 L 38.0 17.4 L 35.8 19.2 L 32.8 19.4","0 30.3 M 15.7 -3.5 L 13.2 -2.6 L 10.0 -4.7 L 9.5 -9.5 L 11.0 -13.7 L 17.1 -20.6 L 24.1 -2.1 L 25.3 6.1 L 24.1 12.0 L 21.2 15.0 L 16.6 17.4 L 13.4 16.4 L 10.2 13.0 L 9.5 8.6 L 11.5 4.4 L 13.6 2.7 L 16.0 2.9 L 18.2 5.9 M 45.3 -16.7 L 42.3 -18.2 L 38.4 -16.7 L 35.3 -13.6 L 33.1 -7.8 L 32.6 -1.1 L 32.4 3.4 L 25.4 4.6 L 32.2 3.6 L 33.0 7.9 L 34.6 14.0 L 34.9 16.5 L 37.6 14.6","0 20.8 M 12.5 12.9 L 12.1 15.1 L 14.8 17.1 L 18.9 16.9 L 23.1 13.4 L 24.5 7.3 L 24.1 -.9 L 22.1 -11.0 L 20.4 -19.5 L 16.7 -14.4 L 13.4 -8.5 L 11.6 -3.0 L 11.3 2.1 L 14.0 5.7 L 16.1 6.3 L 18.9 6.3","0 21.1 M 25.6 5.8 L 20.4 7.8 L 16.3 7.9 L 12.2 5.2 L 10.5 -.6 L 12.3 -6.3 L 16.7 -11.9 L 21.3 -15.9 L 29.0 -20.6 L 32.9 -23.1 L 33.8 -24.9 L 32.2 -26.0 L 28.3 -25.4 L 24.8 -22.4 L 23.0 -19.1 L 21.5 -10.9 L 21.4 -2.5 L 23.3 8.8 L 24.0 14.4 L 22.6 18.5 L 19.7 21.7 L 15.9 24.2 L 12.5 25.1 L 8.3 23.9 L 7.0 19.6 L 8.8 15.7 L 14.5 12.3 L 19.3 11.3 L 23.0 11.5 L 26.4 12.7 L 30.0 17.0 L 30.0 19.2 L 28.3 21.3","0 33.6 M 16.6 9.5 L 18.0 7.3 L 16.4 4.5 L 13.7 4.0 L 10.3 5.9 L 9.4 10.1 L 10.9 14.6 L 14.8 16.6 L 18.8 16.1 L 23.6 12.3 L 24.5 7.1 L 23.9 -4.6 L 22.9 -15.6 L 23.1 -20.1 L 16.4 -17.0 L 11.8 -12.9 L 10.3 -7.9 L 12.2 -4.3 L 14.1 -3.5 L 16.4 -4.0 M 45.5 -18.6 L 41.6 -18.2 L 37.8 -15.2 L 35.4 -10.7 L 33.4 -6.5 L 30.6 -3.9 L 27.5 -2.7 L 24.9 -2.3 L 30.1 -2.2 L 33.6 .5 L 36.6 6.2 L 38.8 13.6 L 41.2 18.7 L 43.6 20.9 L 46.4 21.9 L 48.3 21.3","0 23.6 M 11.2 -3.2 L 11.4 -1.6 L 15.0 .3 L 20.8 -.2 L 25.6 -3.1 L 31.5 -8.6 L 34.2 -13.9 L 34.9 -19.2 L 33.1 -22.1 L 29.8 -22.6 L 25.9 -20.0 L 23.3 -15.2 L 22.0 -7.1 L 21.5 .0 L 21.0 6.2 L 19.5 9.7 L 16.6 13.1 L 12.3 15.4 L 7.7 14.9 L 6.3 13.8 L 5.3 9.6 L 9.4 6.6 L 15.1 8.2 L 20.0 12.2 L 24.3 17.1 L 27.9 20.0 L 31.9 20.7 L 34.1 19.4","0 31.1 M 6.1 13.1 L 6.7 13.1 L 10.3 11.5 L 14.3 7.1 L 18.0 1.6 L 21.9 -7.8 L 24.3 -14.0 L 25.2 -18.3 L 23.8 -8.7 L 23.1 8.1 L 26.3 1.5 L 30.8 -8.3 L 36.5 -17.5 L 38.5 -21.6 L 38.7 -23.2 L 37.3 -24.3 L 35.7 -22.4 L 33.5 -16.1 L 32.1 -8.0 L 32.8 2.3 L 36.4 13.6 L 39.5 19.2 L 44.7 22.3 L 49.3 20.8 L 52.8 17.0 L 53.1 13.6 L 50.8 10.2 L 47.6 10.1 L 45.5 11.8 L 44.3 15.0 M 12.4 -12.1 L 10.5 -14.8 L 11.2 -17.9 L 14.0 -20.2 L 17.9 -20.3 L 22.7 -18.9 L 23.8 -18.6 L 25.8 -18.4 L 27.5 -19.4","0 23.2 M 9.9 8.4 L 10.2 6.8 L 7.4 5.3 L 4.6 6.6 L 3.0 9.9 L 3.6 12.7 L 6.3 15.5 L 10.4 16.3 L 14.9 13.2 L 16.7 8.7 L 16.8 .2 L 16.4 -6.1 L 15.1 -11.9 L 13.8 -17.5 L 18.1 -8.1 L 23.2 2.7 L 26.4 10.5 L 28.7 16.1 L 26.9 8.3 L 26.1 -1.1 L 28.0 -12.6 L 31.9 -21.7 L 36.4 -24.9 L 39.1 -24.7 L 40.5 -22.4 L 40.1 -20.5 L 39.1 -18.9 L 37.6 -18.5","0 30.1 M 22.7 -14.5 L 17.7 -13.2 L 14.2 -9.8 L 11.5 -4.2 L 11.0 1.0 L 12.2 6.7 L 16.6 10.8 L 21.4 11.8 L 26.3 11.0 L 31.6 7.3 L 34.2 1.3 L 34.5 -5.2 L 32.0 -10.7 L 28.8 -13.8 L 24.9 -14.5 L 21.9 -13.0 L 20.1 -9.6 L 20.6 -6.4 L 22.4 -5.2 L 25.0 -5.4","0 29.4 M 16.7 9.5 L 15.7 7.8 L 13.1 7.7 L 10.7 9.5 L 9.7 13.6 L 11.7 17.4 L 16.0 18.4 L 20.2 17.1 L 22.6 13.6 L 22.6 10.0 L 20.3 3.4 L 18.3 -2.3 L 17.8 -10.1 L 19.3 -14.0 L 21.7 -16.2 M 14.2 -5.7 L 12.9 -5.7 L 10.9 -8.5 L 11.1 -13.3 L 14.7 -18.9 L 19.1 -21.0 L 24.7 -21.9 L 31.2 -20.2 L 35.2 -16.7 L 37.8 -11.1 L 37.3 -5.5 L 33.8 -1.9 L 30.0 -.1 L 26.2 .7 L 23.8 -.1 L 21.7 -2.5 L 22.2 -4.1 L 23.9 -5.8","0 33.8 M 24.1 -1.7 L 26.2 2.1 L 26.4 6.2 L 25.1 8.2 L 21.5 10.3 L 17.0 9.1 L 13.5 4.9 L 11.5 -1.5 L 12.6 -8.9 L 16.1 -15.8 L 20.7 -19.8 L 26.5 -20.5 L 30.9 -18.5 L 34.8 -13.2 L 36.7 -6.8 L 36.7 -1.5 L 34.7 4.3 L 31.3 9.2 L 26.6 12.3 L 21.6 13.3 L 15.4 13.0 L 22.4 13.9 L 26.8 15.6 L 31.9 17.7 L 36.4 19.5 L 41.7 21.0 L 46.2 19.4 L 47.0 16.5 L 45.9 14.3 L 44.1 13.0 L 41.5 12.5 L 40.6 14.3","0 29.5 M 14.0 12.4 L 14.1 10.4 L 11.6 9.5 L 9.0 10.4 L 6.9 13.6 L 7.8 17.5 L 10.8 19.3 L 14.5 18.6 L 18.1 16.1 L 19.8 12.6 L 19.9 7.7 L 18.5 -1.1 L 19.0 -6.7 L 20.6 -9.8 L 22.1 -11.3 L 24.4 -12.9 L 25.6 -13.2 M 13.3 -.8 L 10.4 -2.7 L 9.1 -7.4 L 10.4 -12.5 L 14.7 -17.2 L 19.5 -19.9 L 24.9 -20.9 L 30.2 -19.9 L 34.9 -16.2 L 36.7 -11.4 L 35.5 -6.7 L 32.3 -2.3 L 28.1 .3 L 25.4 1.6 L 22.4 2.3 L 25.5 1.8 L 28.8 3.6 L 31.5 8.9 L 34.8 16.8 L 36.8 21.6 L 39.2 23.3 L 42.9 23.2","0 21.7 M 13.3 5.8 L 10.3 8.9 L 9.1 11.8 L 10.1 16.1 L 13.6 17.7 L 18.1 17.7 L 22.8 14.7 L 26.3 11.7 L 26.7 7.3 L 24.8 3.8 L 14.6 -11.3 L 13.9 -14.5 L 14.4 -16.7 L 17.3 -19.5 L 20.1 -20.8 L 23.3 -21.0 L 26.7 -18.8 L 27.6 -15.1 L 25.5 -12.1","0 23.9 M 21.0 9.7 L 19.6 8.0 L 17.0 8.6 L 15.0 10.8 L 14.9 13.9 L 16.6 17.1 L 19.8 17.9 L 23.5 16.6 L 26.1 12.9 L 25.4 6.7 L 24.1 -3.4 L 24.2 -8.0 L 24.7 -10.5 L 26.2 -13.7 M 11.0 -17.5 L 12.1 -17.6 L 13.8 -17.0 L 15.7 -13.7 L 16.0 -9.5 L 14.6 -4.8 L 12.6 -2.0 L 9.5 -.4 L 7.5 -.8 L 7.1 -3.4 L 9.3 -8.2 L 12.8 -11.0 L 17.2 -12.5 L 22.6 -13.2 L 28.2 -14.0 L 33.4 -15.4 L 36.9 -17.1 L 38.8 -19.1 L 39.1 -21.0","0 26.4 M 11.2 -11.9 L 8.8 -11.0 L 6.8 -12.5 L 6.6 -15.1 L 8.3 -18.5 L 11.2 -20.5 L 13.9 -20.8 L 17.1 -18.5 L 17.4 -13.1 L 16.4 -7.4 L 14.2 -1.8 L 12.5 4.8 L 11.6 9.5 L 11.8 12.7 L 12.9 14.8 L 14.7 15.1 L 17.0 14.4 L 20.9 10.2 L 25.5 2.8 L 28.9 -3.9 L 32.1 -12.1 L 27.6 2.1 L 27.2 9.6 L 27.6 14.2 L 28.4 16.2 L 29.4 17.4 L 31.5 17.7 L 33.5 17.0","0 25.5 M 12.7 -8.6 L 13.6 -6.5 L 13.0 -4.5 L 10.7 -3.0 L 8.7 -3.8 L 6.7 -6.7 L 6.8 -9.8 L 8.6 -13.9 L 11.4 -15.8 L 13.9 -16.2 L 17.2 -13.0 L 19.9 -4.7 L 23.1 8.3 L 24.5 18.7 L 24.1 11.8 L 26.0 4.3 L 29.5 -5.6 L 33.2 -13.3 L 36.9 -18.9 L 39.9 -22.0 L 42.3 -22.9 L 44.7 -22.3","0 45.8 M 8.0 -6.7 L 8.5 -10.9 L 11.5 -13.6 L 15.4 -14.4 L 18.0 -15.0 L 21.2 -16.3 L 17.4 -12.0 L 14.7 -6.0 L 13.7 -.9 L 14.3 3.6 L 17.8 5.9 L 21.3 4.9 L 27.1 .5 L 30.0 -3.6 L 30.0 -5.5 L 28.0 -5.3 L 24.8 -2.5 L 23.6 1.1 L 23.2 6.9 L 25.8 13.0 L 29.8 16.0 L 35.7 17.2 L 40.8 15.7 L 46.4 10.5 L 48.7 4.9 L 49.8 -2.0 L 48.7 -8.5 L 45.7 -13.7 L 43.4 -15.0 L 39.9 -14.4 L 37.9 -12.5","0 22.0 M 10.6 8.1 L 10.9 6.7 L 9.3 5.2 L 6.2 6.2 L 4.6 9.0 L 4.8 12.6 L 7.0 15.1 L 9.7 14.9 L 13.7 12.5 L 17.6 7.7 L 20.4 2.9 L 24.8 -5.9 L 28.7 -13.6 L 32.6 -18.0 L 36.4 -20.7 L 39.9 -21.0 M 10.1 -14.1 L 8.6 -13.4 L 6.8 -14.4 L 6.8 -17.4 L 9.0 -20.7 L 11.9 -21.4 L 14.0 -20.1 L 16.3 -14.4 L 19.2 -2.0 L 22.1 8.4 L 26.5 20.0 L 28.8 23.0 L 30.9 24.5 L 33.4 25.1 L 37.3 24.3 L 39.1 21.9 L 39.1 18.9 L 37.3 17.5 L 35.6 18.3","0 24.7 M 8.9 -12.8 L 6.8 -12.4 L 5.2 -13.6 L 5.4 -16.2 L 6.8 -18.7 L 9.0 -20.6 L 12.4 -21.3 L 14.6 -19.7 L 15.5 -16.0 L 14.3 -11.4 L 12.1 -4.9 L 11.1 .8 L 12.0 4.1 L 15.6 5.5 L 18.7 4.2 L 22.4 1.5 L 25.5 -2.9 L 30.0 -9.6 L 32.1 -14.0 L 32.8 -17.5 L 32.2 -18.9 L 29.9 -18.8 L 27.0 -14.9 L 25.5 -8.9 L 25.9 -2.1 L 27.9 5.2 L 29.5 12.3 L 29.5 18.1 L 28.1 21.3 L 25.6 24.4 L 21.3 26.7 L 17.9 27.1 L 15.5 25.8 L 15.5 21.6 L 18.0 17.8 L 22.2 13.7 L 25.5 11.3 L 27.6 10.9 L 31.6 9.8 L 34.1 10.1 L 35.0 11.1 L 34.1 13.0","0 23.1 M 11.9 -19.0 L 13.8 -19.7 L 15.6 -17.8 L 17.1 -12.8 L 16.7 -7.3 L 16.1 -5.5 L 14.2 -4.0 L 12.9 -4.7 L 12.0 -8.7 L 13.6 -12.7 L 17.1 -16.1 L 21.5 -18.1 L 27.7 -18.5 L 33.2 -18.3 L 39.6 -20.4 L 42.2 -21.6 L 42.3 -23.8 L 40.7 -24.3 L 36.7 -22.8 L 34.3 -20.4 L 30.8 -14.5 L 26.8 -5.6 L 22.4 3.0 L 18.5 8.1 L 14.9 10.8 L 12.4 13.1 L 10.1 14.3 L 7.7 14.7 L 6.3 14.2 L 6.0 12.0 L 9.1 9.6 L 11.8 9.3 L 14.4 10.3 L 19.7 14.6 L 24.8 19.5 L 28.0 22.0 L 30.7 23.1 L 33.5 23.4 L 36.4 22.4 L 38.6 20.9","0 8.2 M 16.2 18.9 L 11.4 18.8 L 11.4 -21.1 L 15.8 -21.2","0 17.5 M 8.3 -18.4 L 10.9 -10.0 L 14.7 -.4 L 18.4 7.0 L 22.4 12.7 L 25.2 15.4 L 26.8 16.0","0 9.1 M 9.1 19.3 L 12.8 19.1 L 13.2 -2.9 L 12.6 -21.1 L 8.4 -21.3","0 18.2 M 10.8 -7.6 L 16.3 -14.0 L 17.2 -15.0 L 23.7 -7.4","0 24.4 M 9.8 12.7 L 19.4 12.1 L 26.9 12.4 L 30.6 11.8","0 28.9 M 21.6 -16.6 L 21.2 -17.5 L 19.9 -16.8 L 21.7 -15.4 L 24.1 -14.4 L 25.7 -14.1","0 15.0 M 18.8 -2.7 L 16.5 .7 L 14.5 3.4 L 12.2 5.4 L 10.8 5.5 L 9.8 4.8 L 10.3 1.9 L 11.5 -.9 L 14.3 -3.0 L 16.1 -3.2 L 17.7 -1.6 L 18.5 6.6 L 19.1 7.6 L 20.5 7.3 L 21.6 6.7","0 17.3 M 12.3 14.4 L 16.8 12.3 L 20.1 8.8 L 21.7 4.3 L 21.4 1.0 L 19.9 -.4 L 17.1 .3 L 15.1 2.7 L 14.1 5.5 L 13.2 8.3 L 13.1 13.3 L 11.5 5.8 L 10.8 -1.2 L 11.8 -9.1 L 13.7 -14.2 L 16.1 -16.9 L 19.6 -18.3 L 22.1 -18.6 L 23.6 -18.2 L 24.5 -17.5","0 13.7 M 17.2 -2.0 L 18.6 -3.1 L 18.2 -4.9 L 16.4 -6.0 L 14.0 -5.6 L 12.2 -4.4 L 10.4 -2.3 L 9.8 1.1 L 10.9 4.3 L 13.7 5.7 L 16.2 6.0 L 18.9 5.0 L 19.8 4.0","0 17.6 M 21.3 -1.1 L 17.8 -2.9 L 14.2 -2.7 L 11.3 -.4 L 10.1 2.8 L 10.3 5.4 L 11.8 7.0 L 15.1 6.6 L 18.2 4.8 L 20.2 1.5 L 21.4 -1.3 M 15.7 -18.2 L 17.5 -18.6 L 19.2 -16.9 L 19.9 -12.8 L 19.9 .3 L 20.4 7.1 L 21.0 9.7 L 22.4 11.2 L 24.0 11.5 L 26.2 11.0","0 14.2 M 10.8 -1.1 L 13.4 .1 L 15.8 -.2 L 17.8 -1.8 L 18.1 -3.9 L 16.9 -5.2 L 14.5 -5.1 L 12.1 -3.6 L 10.5 -.6 L 10.1 2.8 L 12.1 5.7 L 15.0 6.6 L 17.1 6.0 L 20.3 3.2","0 10.4 M 1.9 17.8 L 3.0 19.5 L 6.2 20.0 L 11.2 17.3 L 13.3 14.1 L 14.0 10.2 L 13.9 5.5 L 12.3 -2.9 L 11.6 -8.1 L 11.8 -13.6 L 12.9 -17.8 L 15.0 -19.7 L 16.9 -20.1 L 18.5 -20.1 L 20.0 -18.9 M 7.3 -7.4 L 8.9 -8.1 L 15.0 -8.7 L 16.7 -9.2","0 15.1 M 18.9 -5.6 L 17.4 -2.2 L 15.9 .2 L 13.7 1.5 L 11.3 1.4 L 9.9 -.2 L 10.0 -3.2 L 12.3 -6.2 L 14.7 -7.2 L 18.3 -7.3 L 17.8 -7.3 L 18.1 6.6 L 17.7 12.3 L 16.8 17.1 L 15.0 20.1 L 12.4 22.7 L 9.4 24.1 L 7.0 24.1 L 4.0 22.7 L 3.1 20.8","0 19.2 M 23.7 -23.1 L 20.2 -23.3 L 16.6 -21.3 L 13.9 -16.3 L 12.4 -11.1 L 11.3 -5.4 L 10.9 .5 L 11.0 6.4 L 12.1 2.6 L 13.9 -2.1 L 15.4 -4.2 L 17.1 -5.5 L 18.4 -5.5 L 19.2 -4.3 L 20.4 .8 L 22.0 6.6 L 23.3 10.6 L 24.7 12.6 L 25.7 13.4 L 27.3 13.3 L 28.5 12.2","0 8.9 M 13.9 7.0 L 12.2 7.3 L 11.2 6.9 L 11.6 -2.9 L 11.5 -3.5 L 10.1 -3.3 L 8.9 -2.5 M 9.8 -9.4 L 10.7 -10.2 L 13.2 -8.5 L 12.0 -7.4 L 9.8 -9.4","0 9.5 M 18.0 18.5 L 19.2 16.3 L 19.2 14.5 L 17.0 12.8 L 12.4 12.6 L 6.7 14.4 L 2.6 17.4 L .9 20.7 L .2 24.1 L 1.4 25.4 L 3.5 25.8 L 6.8 24.6 L 10.5 21.6 L 12.7 18.1 L 13.8 14.0 L 13.9 8.6 L 11.8 -4.7 L 9.3 -3.1 M 11.5 -10.8 L 10.6 -11.7 L 9.7 -10.9 L 11.7 -9.2 L 12.6 -10.5","0 15.5 M 11.5 14.3 L 11.4 -3.0 L 12.6 -13.2 L 14.2 -17.9 L 16.6 -20.5 L 18.1 -21.3 L 20.3 -21.6 L 21.2 -21.1 M 10.1 6.3 L 13.2 .9 L 15.1 -1.7 L 17.5 -2.9 L 18.9 -2.1 L 18.7 -.4 L 16.0 2.7 L 11.8 5.9 L 13.1 4.9 L 17.1 7.7 L 19.7 9.0 L 21.6 8.8 L 23.5 7.4","0 8.4 M 14.4 11.5 L 12.3 11.5 L 10.6 9.8 L 10.6 3.6 L 11.5 -10.6 L 11.5 -18.5 L 11.1 -20.0 L 9.8 -20.3 L 8.3 -19.7 L 6.9 -18.7","0 25.3 M 7.4 -3.3 L 9.4 -4.5 L 11.2 -4.5 L 12.1 -3.1 L 12.4 .6 L 12.8 7.5 L 13.2 2.3 L 15.0 -1.4 L 16.4 -3.6 L 18.0 -4.7 L 20.0 -4.6 L 21.0 -2.8 L 21.4 -.1 L 21.6 4.8 L 22.2 .6 L 23.8 -3.1 L 25.2 -5.1 L 26.8 -6.1 L 28.3 -5.8 L 29.0 -3.7 L 29.2 2.6 L 29.7 8.6 L 30.2 11.0 L 30.9 11.9 L 32.3 12.3 L 33.8 12.5 L 35.1 11.6","0 16.9 M 8.6 -1.9 L 11.3 -3.6 L 12.0 -.1 L 12.6 3.9 L 12.6 8.7 L 13.4 3.9 L 15.3 -.1 L 16.7 -2.1 L 18.0 -3.1 L 19.3 -3.2 L 19.9 -2.1 L 20.6 3.4 L 20.9 8.6 L 22.0 10.4 L 23.3 10.5 L 25.0 9.9","0 13.0 M 14.6 -4.6 L 12.6 -3.9 L 10.8 -2.1 L 10.0 .9 L 10.2 2.8 L 11.9 4.3 L 14.4 4.5 L 16.8 2.8 L 17.8 1.3 L 18.4 -1.3 L 18.1 -2.9 L 16.7 -3.9 L 14.6 -4.6","0 14.8 M 4.0 20.8 L 4.2 20.8 L 7.4 19.4 L 11.0 16.4 L 12.6 13.2 L 12.5 7.4 L 11.7 -2.4 L 13.1 -4.9 L 15.5 -7.7 L 17.8 -8.8 L 20.2 -8.1 L 20.9 -5.7 L 20.6 -1.9 L 18.9 .7 L 17.3 2.2 L 15.1 2.3 L 12.7 1.4 L 11.5 -2.5 L 11.2 -9.2 L 7.8 -7.9","0 15.3 M 24.9 17.7 L 22.4 18.7 L 20.0 18.2 L 18.5 15.5 L 17.9 8.8 L 18.1 1.1 L 18.6 -4.5 L 17.2 -6.1 L 13.9 -6.5 L 12.1 -5.7 L 10.3 -3.5 L 9.8 -.1 L 10.5 2.2 L 12.0 3.0 L 14.2 2.2 L 16.9 .0 L 18.7 -4.0 L 19.7 -8.2","0 12.6 M 8.0 -4.5 L 9.4 -5.5 L 10.7 -5.5 L 11.6 -3.6 L 12.8 8.8 L 13.0 1.1 L 13.6 -1.7 L 15.7 -5.6 L 18.4 -8.5 L 19.6 -9.2 L 21.3 -9.3 L 22.5 -8.5 L 22.2 -7.3 L 21.4 -6.0 L 19.5 -3.8","0 12.3 M 9.8 4.0 L 8.6 6.2 L 9.0 8.8 L 11.6 9.8 L 14.4 9.0 L 16.4 6.7 L 17.3 4.3 L 16.6 2.5 L 10.8 -6.2 L 10.6 -7.4 L 11.2 -9.0 L 12.8 -10.2 L 14.8 -10.6 L 16.7 -10.2 L 17.5 -8.5 L 16.5 -6.9","0 9.9 M 16.7 7.3 L 15.0 8.0 L 13.2 8.0 L 11.9 6.6 L 11.5 3.4 L 12.3 -7.4 L 12.2 -10.2 L 17.1 -11.0 L 9.3 -9.6 L 12.3 -10.2 L 12.4 -12.0 L 12.0 -13.4 L 11.6 -14.0 L 10.4 -14.2 L 9.2 -13.6","0 14.2 M 8.4 -2.7 L 8.7 -2.9 L 10.9 -3.9 L 11.3 -3.3 L 11.2 4.7 L 11.2 5.2 L 12.6 4.7 L 14.7 2.6 L 16.5 -.1 L 18.0 -2.5 L 18.6 -3.3 L 18.1 6.6 L 18.5 8.3 L 19.7 8.3 L 20.9 8.3 L 22.4 7.7","0 15.3 M 8.3 -3.1 L 9.8 -4.4 L 11.4 -3.6 L 12.4 -1.3 L 15.0 7.2 L 18.2 2.0 L 21.1 -3.3 L 22.7 -8.0 L 21.9 -12.5 L 20.0 -15.5 L 17.6 -15.9 L 16.3 -15.5 L 15.1 -14.5","0 19.6 M 7.3 -5.6 L 9.5 -6.3 L 10.7 -5.0 L 12.8 4.5 L 14.1 3.8 L 17.4 -4.1 L 17.8 -4.7 L 19.0 .7 L 21.3 6.3 L 21.8 6.2 L 22.8 .7 L 24.7 -4.7 L 27.5 -9.5 L 30.2 -12.0 L 32.2 -12.7 L 33.4 -12.8 L 34.4 -12.2","0 13.5 M 9.0 7.8 L 20.4 -6.8 M 7.6 -5.1 L 7.9 -5.0 L 10.0 -5.6 L 11.5 -4.1 L 16.8 7.3 L 18.5 9.2 L 20.6 9.6 L 22.1 9.1 L 23.8 8.0","0 17.2 M 7.9 -4.9 L 8.3 -4.9 L 9.9 -5.2 L 11.4 -4.1 L 12.0 .4 L 12.2 3.8 L 13.8 3.9 L 17.1 .5 L 19.4 -2.8 L 20.8 -5.4 L 21.0 -2.3 L 21.3 4.2 L 21.5 10.2 L 20.2 15.9 L 19.0 18.1 L 16.6 19.7 L 13.3 20.8 L 10.1 20.0 L 8.3 19.0 L 7.2 17.1 L 7.7 15.0 L 9.7 12.8","0 15.7 M 9.2 -3.7 L 11.8 -5.9 L 13.8 -6.3 L 18.3 -5.7 L 22.9 -6.3 L 19.3 -1.6 L 16.1 1.7 L 13.2 4.2 L 11.0 5.6 L 9.5 6.2 L 8.2 6.4 L 9.4 5.4 L 11.3 5.4 L 14.3 6.8 L 20.1 10.1 L 22.2 11.3 L 24.5 11.2 L 26.6 10.0 L 28.3 8.4","0 15.3 M 21.6 18.9 L 19.5 18.5 L 17.6 16.8 L 17.4 8.9 L 16.4 3.8 L 15.0 1.5 L 13.5 .5 L 10.7 .7 L 13.2 .5 L 15.1 -.4 L 17.3 -2.9 L 18.5 -5.7 L 18.7 -11.7 L 19.1 -16.5 L 21.0 -20.4 L 23.1 -21.3 L 25.0 -21.0","0 9.0 M 13.0 16.7 L 12.4 -17.7 L 12.1 -18.3","0 13.9 M 6.7 19.2 L 10.5 18.6 L 13.0 16.8 L 14.2 13.3 L 14.3 4.6 L 15.1 2.1 L 16.8 .9 L 17.6 .3 L 19.6 .3 L 16.6 .3 L 14.3 -1.4 L 13.5 -4.7 L 13.7 -10.3 L 13.5 -15.4 L 12.6 -18.9 L 10.2 -21.2 L 6.9 -21.1","0 20.2 M 10.3 .9 L 12.0 -2.1 L 13.6 -3.4 L 15.8 -3.6 L 19.2 -2.5 L 21.8 -1.6 L 23.5 -1.4 L 25.8 -2.9","0 7.2 M 12.1 -15.0 L 10.2 -14.2 L 9.0 -12.6 L 9.9 -11.2 L 11.9 -11.0 L 13.6 -11.7 L 14.5 -13.4 L 13.8 -14.7 L 12.1 -15.0"]
EMSMistyNight = ["-8 8","0 7.5 M 11.3 -.4 L 10.8 -.5 L 10.5 -6.7 L 10.0 -10.7 L 10.0 -13.4 L 10.7 -13.9 L 12.6 -13.9 L 13.3 -13.3 L 13.1 -8.4 L 12.5 -5.0 L 12.4 -.3 M 11.5 2.4 L 9.9 3.0 L 9.6 4.8 L 10.4 6.2 L 11.7 6.6 L 13.2 5.9 L 13.8 4.5 L 13.2 2.8 L 11.5 2.4","0 8.5 M 13.1 -8.7 L 13.4 -14.5 L 14.9 -14.5 L 15.2 -14.0 L 14.9 -8.6 L 14.0 -8.6 M 9.3 -8.7 L 9.7 -14.5 L 11.1 -14.5 L 11.4 -14.1 L 11.1 -8.6 L 10.3 -8.6","0 19.4 M 12.5 -6.0 L 10.2 -6.0 L 10.2 -7.7 L 14.0 -7.7 L 14.6 -13.4 L 16.4 -13.4 L 15.7 -7.7 L 20.1 -7.7 L 20.6 -13.4 L 22.4 -13.4 L 21.8 -7.6 L 25.7 -7.6 L 25.7 -6.1 L 21.6 -6.1 L 21.2 -1.0 L 25.1 -1.0 L 25.1 .8 L 20.8 .8 L 20.5 6.6 L 18.7 6.6 L 19.2 .7 L 14.8 .7 L 14.3 6.4 L 12.7 6.4 L 13.2 .9 L 9.5 .9 L 9.5 -1.0 L 13.5 -1.0 L 14.0 -6.0 M 18.0 -6.0 L 15.5 -6.0 L 15.1 -.9 L 19.4 -.9 L 19.8 -6.0","0 18.3 M 23.2 -14.7 L 23.7 -6.5 M 21.8 -14.6 L 22.0 -12.0 M 22.2 -6.7 L 22.0 -8.9 L 21.5 -10.0 L 20.3 -11.1 L 18.5 -12.1 L 17.3 -11.9 L 17.3 -7.1 M 17.3 -13.7 L 18.8 -13.6 L 20.1 -13.3 M 17.4 -14.4 L 17.4 -16.1 M 15.9 -16.0 L 15.9 -13.6 M 15.9 -12.0 L 15.9 -7.8 M 15.9 -13.7 L 13.6 -13.3 L 11.6 -12.1 L 10.4 -10.5 L 10.1 -8.6 L 10.7 -6.8 L 12.0 -5.1 L 14.0 -3.7 L 15.9 -2.7 L 17.8 -1.8 L 19.8 -.6 L 21.3 .7 L 21.7 1.7 L 21.7 2.9 L 20.7 4.3 L 19.2 5.0 L 18.1 5.1 M 23.2 2.9 L 23.6 1.3 L 22.6 -.5 L 20.4 -2.2 L 16.4 -4.4 L 13.9 -6.0 L 12.7 -7.1 L 12.2 -8.0 L 11.8 -8.8 L 11.8 -9.4 M 14.9 -11.9 L 13.8 -11.3 L 13.3 -10.5 L 13.2 -9.4 L 14.4 -7.8 L 16.4 -6.4 L 19.0 -4.9 L 21.7 -3.4 L 24.0 -1.6 L 25.2 .5 L 25.0 3.1 L 23.5 5.0 L 21.1 6.1 L 19.1 6.7 L 17.3 6.8 L 17.3 9.4 L 17.3 -.9 M 16.1 -1.3 L 16.1 4.3 M 16.1 5.2 L 14.4 4.6 L 13.3 4.1 L 11.9 2.8 L 11.1 1.5 L 10.9 .5 L 10.9 -1.0 M 9.3 -1.0 L 9.6 7.7 M 11.0 7.6 L 10.9 4.7 M 12.6 5.8 L 16.1 6.7 L 16.1 9.7","0 21.4 M 14.0 -11.7 L 12.5 -11.5 L 11.5 -10.2 L 11.4 -8.5 L 11.5 -7.0 L 12.3 -5.9 L 13.7 -5.2 L 15.2 -5.4 L 16.0 -6.9 L 15.9 -9.7 L 15.2 -11.1 L 14.0 -11.7 M 13.7 -3.8 L 16.1 -4.3 L 17.5 -5.5 L 18.4 -7.3 L 18.5 -9.3 L 17.8 -11.1 L 16.6 -12.4 L 15.0 -13.1 L 12.9 -13.2 L 11.0 -12.4 L 9.3 -10.4 L 9.1 -8.2 L 9.5 -6.2 L 10.8 -4.7 L 12.1 -3.9 L 13.7 -3.8 M 27.0 -12.7 L 9.4 5.2 L 10.6 6.4 L 28.1 -11.6 M 23.7 -2.1 L 21.6 -1.8 L 19.9 -.8 L 18.9 1.0 L 18.9 3.8 L 19.9 5.8 L 21.3 6.8 L 23.1 7.2 L 24.7 7.1 L 26.5 6.4 L 27.8 4.9 L 28.3 3.1 L 28.0 .8 L 27.1 -.9 L 25.7 -1.7 L 23.7 -2.1 M 22.6 -.7 L 21.7 .0 L 21.2 1.1 L 21.2 4.2 L 22.0 5.3 L 22.8 5.8 L 24.4 5.8 L 25.3 5.3 L 25.7 4.4 L 25.8 3.1 L 25.7 .9 L 24.7 -.4 L 24.1 -.7 L 22.6 -.7","0 26.5 M 21.6 5.1 L 20.1 6.3 L 17.9 6.8 L 14.6 6.5 L 11.7 5.4 L 9.8 3.5 L 8.9 .9 L 9.1 -2.1 L 10.8 -4.7 L 12.6 -5.8 M 11.4 -3.3 L 10.6 -1.2 L 10.6 .4 L 11.0 2.0 L 11.8 3.5 M 20.2 -5.0 L 15.8 -5.0 L 14.4 -4.3 L 13.2 -3.3 L 12.7 -2.0 L 12.5 -.9 L 12.5 .8 L 12.9 2.5 L 14.1 4.2 L 15.8 5.0 L 17.8 5.0 L 19.6 4.2 L 20.7 2.8 L 21.1 1.8 L 21.3 .7 L 21.3 -5.0 M 23.0 -4.9 L 23.0 2.2 M 22.4 4.3 L 24.4 6.0 L 27.2 6.8 L 29.9 6.4 L 31.8 5.2 L 33.0 3.8 L 33.8 1.8 M 32.1 1.5 L 31.3 3.3 L 29.4 4.8 L 26.6 5.2 L 25.4 4.1 L 24.7 3.0 L 24.7 -5.0 L 31.9 -5.0 M 31.9 -6.7 L 24.6 -6.7 M 24.6 -8.1 L 24.9 -16.9 M 23.3 -16.9 L 23.2 -11.5 M 21.8 -12.9 L 19.6 -13.8 L 17.1 -13.8 L 14.5 -13.2 L 12.4 -11.1 L 12.2 -8.7 L 13.1 -7.2 L 14.4 -6.2 L 14.6 -6.2 M 22.0 -10.1 L 21.1 -11.3 L 19.8 -12.0 L 17.5 -12.1 L 16.2 -11.3 L 15.5 -10.2 L 15.3 -9.0 L 16.0 -7.5 L 17.1 -6.6 L 18.9 -6.6 L 21.0 -6.6 L 21.6 -6.8 L 22.1 -7.3 L 22.4 -8.1 M 14.1 -10.9 L 13.8 -9.4 L 14.1 -8.3","0 4.8 M 9.4 -8.7 L 10.1 -14.6 L 11.7 -14.6 L 11.3 -8.6 L 10.6 -8.6","0 11.5 M 15.9 7.1 L 13.5 5.2 L 11.7 2.8 L 10.3 -.4 L 9.7 -3.6 L 10.2 -6.0 L 11.2 -8.8 L 12.8 -11.1 L 14.8 -13.4 L 17.1 -15.0 L 18.0 -14.0 L 16.3 -12.7 L 14.5 -9.9 L 13.5 -6.7 L 13.2 -3.1 L 13.5 -.3 L 14.1 2.2 L 15.2 4.5 L 16.8 6.0 L 17.8 6.9 L 17.1 8.2 M 12.3 .8 L 11.5 -2.5 L 11.5 -4.8 L 12.1 -7.2","0 11.8 M 12.2 7.1 L 14.6 5.2 L 16.4 2.8 L 17.9 -.4 L 18.4 -3.6 L 17.9 -6.0 L 16.9 -8.8 L 15.4 -11.1 L 13.3 -13.4 L 11.0 -15.0 L 10.2 -14.0 L 11.8 -12.7 L 13.6 -9.9 L 14.6 -6.7 L 14.9 -3.1 L 14.6 -.3 L 14.0 2.2 L 12.9 4.5 L 11.4 6.0 L 10.3 6.9 L 11.1 8.2 M 15.9 .8 L 16.6 -2.5 L 16.6 -4.8 L 16.1 -7.2","0 16.2 M 13.5 -6.2 L 10.7 -7.8 L 9.7 -6.0 L 14.0 -3.6 L 9.6 -1.1 L 9.9 -.4 M 10.5 .8 L 14.9 -1.7 L 14.9 3.1 L 17.1 3.1 L 17.2 -1.6 L 21.4 .7 L 22.2 -1.0 L 18.1 -3.5 L 22.6 -6.0 L 22.2 -6.8 M 21.7 -7.7 L 17.0 -5.1 L 17.0 -10.4 L 15.1 -10.4 L 14.9 -5.4 M 15.5 -3.6 L 16.1 -4.1 L 16.6 -3.5 L 16.0 -2.9 L 15.5 -3.6","0 16.7 M 9.0 -3.9 L 15.7 -3.9 L 15.7 -10.5 L 17.4 -10.5 L 17.4 -4.0 L 23.8 -4.0 L 23.8 -3.3 M 23.8 -2.3 L 17.4 -2.3 L 17.4 4.1 M 16.3 4.0 L 15.7 4.0 L 15.7 -2.3 M 14.5 -2.3 L 9.0 -2.3 L 9.0 -3.0","0 7.2 M 9.6 7.5 L 10.5 7.5 L 11.4 7.1 L 12.0 6.6 L 12.0 6.0 L 10.5 5.9 L 9.7 4.4 L 10.0 2.7 L 11.6 2.0 L 13.3 2.5 L 13.7 4.2 L 13.6 5.6 L 13.3 6.9 L 12.6 7.8 L 11.5 8.5 L 10.5 8.6 L 9.6 8.5 M 11.7 3.4 L 11.3 4.0 L 11.8 4.4 L 12.1 3.9 L 11.7 3.4 M 9.5 7.4 L 10.4 7.4 L 11.3 7.0 L 11.8 6.5 L 11.8 6.0 L 10.4 5.8 L 9.6 4.4 L 9.9 2.6 L 11.5 2.0 L 13.2 2.4 L 13.6 4.1 L 13.5 5.6 L 13.2 6.8 L 12.5 7.8 L 11.4 8.4 L 10.4 8.5 L 9.5 8.4 M 11.6 3.3 L 11.1 4.0 L 11.7 4.3 L 12.0 3.8 L 11.6 3.3","0 12.2 M 19.5 -3.4 L 19.5 -4.1 L 8.9 -4.1 M 9.0 -3.1 L 9.0 -2.3 L 19.5 -2.3","0 7.3 M 11.6 2.0 L 10.0 2.7 L 9.7 4.4 L 10.5 5.8 L 11.8 6.3 L 13.2 5.6 L 13.9 4.1 L 13.3 2.5 L 11.6 2.0 M 11.7 3.3 L 11.2 4.0 L 11.8 4.4 L 12.1 3.9 L 11.7 3.3 M 11.5 2.0 L 9.9 2.7 L 9.6 4.4 L 10.4 5.9 L 11.7 6.3 L 13.2 5.6 L 13.8 4.2 L 13.2 2.5 L 11.5 2.0 M 11.6 3.4 L 11.1 4.0 L 11.7 4.4 L 12.0 3.9 L 11.6 3.4","0 21.0 M 26.0 -15.0 L 9.5 6.4 L 10.8 7.6 L 27.4 -13.9","0 18.2 M 10.7 -10.4 L 12.7 -12.5 L 15.4 -13.7 L 17.8 -13.8 L 20.4 -13.1 L 22.8 -11.3 L 24.7 -7.9 L 24.9 -5.1 L 25.2 -1.6 L 24.3 1.4 L 22.9 4.1 L 20.6 5.9 L 17.6 6.8 L 15.8 6.8 L 13.3 5.9 L 10.8 3.7 L 9.5 .8 L 9.0 -3.6 L 9.2 -7.0 L 9.9 -9.0 L 10.7 -10.4 M 13.0 -9.1 L 13.7 -10.6 L 14.9 -11.6 L 16.6 -12.1 L 18.6 -11.8 L 20.0 -10.4 L 21.2 -6.9 L 21.5 -3.8 L 21.4 -.3 L 20.9 2.1 L 20.1 3.7 L 18.0 5.1 L 16.6 5.0 L 15.2 4.6 L 13.9 3.4 L 12.9 .8 L 12.4 -1.5 L 12.3 -5.3 M 11.3 -8.6 L 10.7 -5.0 L 10.6 -2.3 L 11.0 .2 L 11.8 2.2 L 12.4 3.0 M 22.5 1.7 L 23.2 -1.1 L 23.3 -3.6 L 23.1 -5.8 L 22.4 -8.7 L 21.7 -10.2","0 11.2 M 8.9 -7.1 L 13.8 -13.4 L 14.6 -13.4 M 15.5 -13.5 L 15.5 4.7 L 18.8 4.7 M 18.9 6.2 L 8.2 6.2 M 8.3 4.8 L 12.0 4.8 L 12.0 -8.2 L 10.4 -6.2 M 13.9 -10.5 L 13.9 4.6","0 17.5 M 10.0 -14.0 L 10.0 -5.5 M 11.3 -14.0 L 11.3 -11.9 L 12.9 -12.9 L 15.1 -13.7 L 17.3 -13.8 L 19.4 -13.6 L 21.1 -12.8 L 22.6 -11.6 L 23.3 -10.5 L 23.8 -9.1 L 23.7 -7.3 L 23.2 -5.8 L 21.7 -4.1 L 19.4 -2.1 L 12.0 3.2 M 13.7 3.2 L 23.5 3.2 L 23.5 .0 M 25.1 .0 L 25.1 6.4 M 23.3 4.5 L 11.2 4.5 M 23.4 6.4 L 9.2 6.4 L 9.2 4.4 M 10.0 3.0 L 19.5 -5.8 L 20.4 -7.6 L 20.4 -9.7 L 19.2 -11.6 L 17.6 -12.1 L 15.0 -12.1 L 13.0 -11.0 L 11.8 -9.3 L 11.2 -7.0 L 11.2 -5.4 M 21.3 -10.6 L 22.1 -9.2 L 22.1 -7.5 L 21.6 -6.3 L 20.6 -5.0","0 16.4 M 9.2 .1 L 9.2 4.3 L 11.0 5.8 L 14.3 6.9 L 18.0 6.6 L 20.7 5.5 L 22.4 3.8 L 23.2 2.2 L 23.3 -.5 L 22.4 -2.3 L 21.4 -3.6 L 20.1 -4.4 L 19.6 -4.7 M 18.6 -5.3 L 19.5 -5.7 L 20.8 -6.7 L 21.7 -8.1 L 21.9 -9.3 L 21.4 -11.3 L 20.1 -12.6 L 18.0 -13.6 L 15.2 -13.8 L 13.5 -13.6 L 12.2 -13.2 L 11.2 -12.6 L 11.2 -14.1 M 9.8 -14.3 L 9.8 -7.6 M 11.4 -7.7 L 11.4 -9.6 L 12.2 -10.9 L 13.2 -11.7 L 14.8 -12.1 L 16.9 -12.1 L 18.5 -11.2 L 19.1 -10.0 L 19.1 -8.5 L 18.6 -7.2 L 17.8 -6.2 L 16.5 -5.8 L 14.9 -5.8 M 20.3 -8.4 L 20.5 -9.3 L 20.3 -10.1 M 14.9 -5.0 L 15.0 -4.3 L 16.7 -4.3 L 18.2 -3.6 L 19.3 -2.3 L 20.0 -.4 L 19.7 1.9 L 19.2 3.7 L 17.8 4.8 L 16.2 5.2 L 14.3 5.0 L 13.3 4.6 L 12.6 4.3 L 11.5 3.3 L 11.1 2.7 L 10.6 1.7 L 10.6 .0 M 20.8 3.5 L 21.5 1.7 L 21.6 .7 L 21.5 -.2 L 21.2 -1.6","0 19.4 M 18.8 -13.4 L 16.3 -13.4 L 14.8 -8.6 L 13.1 -5.3 L 11.3 -2.3 L 9.0 .9 L 9.0 2.4 L 18.9 2.4 M 19.8 2.3 L 19.8 3.8 L 19.5 4.6 L 15.5 4.6 M 15.5 6.0 L 27.3 6.0 M 27.1 4.6 L 24.1 4.6 L 23.6 4.3 L 23.3 3.8 L 23.3 2.5 L 25.5 2.5 M 25.5 1.5 L 25.5 .5 L 23.3 .5 L 23.3 -5.1 M 21.5 -3.6 L 21.5 4.6 M 22.0 -5.1 L 20.0 -5.1 L 20.0 .5 L 11.2 .5 L 20.3 -13.3 M 17.2 -12.3 L 16.6 -9.9 L 18.1 -12.3 L 17.2 -12.3","0 16.7 M 9.6 .5 L 9.6 4.3 L 11.3 5.5 L 13.7 6.3 L 16.5 6.7 L 19.9 5.9 L 22.2 4.1 L 23.8 1.5 L 23.9 -1.4 L 22.7 -4.3 L 21.7 -5.5 L 19.8 -6.4 M 10.7 .6 L 10.7 2.3 L 11.3 3.3 L 12.8 4.5 L 14.9 5.3 L 17.1 5.2 L 19.5 3.7 L 20.3 1.7 L 20.5 -1.3 L 20.1 -3.3 L 18.5 -4.9 L 16.8 -5.6 L 14.8 -5.7 L 12.8 -5.3 L 11.7 -4.5 M 21.2 3.0 L 22.0 1.2 L 22.2 -.5 L 22.1 -2.0 L 21.4 -3.7 M 10.7 -4.5 L 10.0 -4.6 L 10.8 -13.0 L 21.4 -13.0 L 21.4 -15.3 M 22.8 -15.4 L 22.8 -9.9 M 21.0 -10.3 L 11.9 -10.3 L 11.9 -6.4 L 13.1 -7.0 L 14.3 -7.3 L 16.5 -7.2 M 12.1 -11.5 L 21.0 -11.6","0 17.6 M 22.7 -8.5 L 22.7 -11.9 M 21.6 -12.6 L 19.6 -13.7 L 16.1 -13.6 L 13.3 -12.3 L 10.8 -8.8 L 9.8 -6.0 L 9.6 -2.2 L 10.0 1.2 L 11.3 4.0 L 13.9 6.2 L 16.8 6.8 M 19.5 6.4 L 22.1 5.2 L 24.2 2.4 L 24.6 -.1 L 24.4 -2.3 L 23.6 -4.7 L 22.2 -6.3 L 19.9 -7.3 L 17.9 -7.7 L 15.1 -7.1 L 13.2 -5.4 M 12.5 -4.6 L 13.1 -8.1 L 14.4 -10.5 L 15.8 -11.8 L 17.5 -12.1 L 19.5 -11.9 L 20.9 -10.7 L 21.6 -9.4 L 21.5 -8.5 M 12.8 -.8 L 13.4 -3.4 L 15.1 -5.2 L 17.2 -6.1 L 19.1 -5.7 L 20.8 -4.1 L 21.6 -1.2 L 21.2 1.7 L 20.4 3.8 L 18.5 5.1 L 16.4 5.1 L 14.4 4.1 L 13.7 2.9 L 13.2 1.4 M 11.9 2.0 L 11.3 .5 L 11.1 -2.1 L 11.3 -5.3 L 11.6 -7.3 M 22.3 -4.0 L 23.1 -1.8 L 23.1 .1 L 22.7 2.0 L 22.1 3.3","0 16.6 M 15.7 6.1 L 13.7 6.1 L 13.8 3.0 L 14.2 .9 L 15.1 -2.0 L 16.7 -5.0 L 18.2 -7.1 L 19.5 -8.8 L 20.9 -10.1 M 19.7 -10.3 L 10.3 -10.3 L 10.3 -7.6 M 8.8 -7.6 L 8.8 -13.2 M 10.4 -13.0 L 24.1 -13.0 M 10.5 -11.5 L 20.8 -11.5 M 24.0 -11.8 L 24.0 -10.8 L 21.4 -9.2 L 19.1 -6.1 L 17.9 -3.3 L 17.2 -.2 L 17.2 6.2 M 14.9 4.7 L 15.7 .2 L 15.8 4.6 L 14.9 4.7","0 18.6 M 13.2 -5.8 L 11.7 -7.1 L 10.9 -9.3 L 12.0 -11.9 L 13.9 -13.1 L 16.6 -13.7 L 19.3 -13.5 L 22.0 -12.8 L 23.6 -11.2 L 24.3 -9.1 L 23.7 -7.2 L 22.4 -5.9 L 21.3 -5.3 M 14.0 -7.3 L 15.7 -6.1 L 18.3 -5.7 L 20.6 -6.8 L 21.2 -8.1 L 21.3 -10.0 L 20.3 -11.3 L 18.6 -12.0 L 16.1 -12.0 L 14.0 -10.9 L 13.7 -9.1 M 12.7 -10.2 L 12.4 -9.4 L 12.7 -8.4 M 22.5 -10.3 L 22.8 -9.1 L 22.4 -8.2 M 21.6 -4.7 L 23.6 -3.6 L 25.0 -1.9 L 25.8 .3 L 25.4 2.5 L 24.1 4.7 L 21.0 6.4 L 17.3 6.9 L 14.7 6.5 L 11.5 5.0 L 9.6 2.5 L 9.5 -1.1 L 11.1 -3.5 L 13.0 -4.8 L 14.7 -5.1 M 15.7 -4.1 L 18.3 -4.2 L 20.3 -3.5 L 21.9 -1.5 L 22.3 .7 L 21.9 2.7 L 20.4 4.6 L 17.8 5.0 L 14.7 4.5 L 13.4 3.1 L 12.8 .4 L 13.3 -2.1 L 14.2 -3.3 L 15.7 -4.1 M 11.8 -1.9 L 11.2 .2 L 11.2 .9 L 11.9 3.0 M 23.4 -1.8 L 23.9 -.2 L 23.9 1.0 L 23.6 2.1 L 23.1 3.0","0 17.0 M 10.7 1.6 L 10.7 5.0 M 12.0 5.8 L 14.6 6.8 L 17.7 6.7 L 20.7 4.8 L 22.9 1.3 L 23.7 -.9 L 24.0 -5.2 L 23.6 -8.0 L 22.8 -10.0 L 20.8 -12.2 L 18.3 -13.6 L 15.2 -13.6 L 12.3 -12.9 L 10.5 -11.0 L 9.1 -8.6 L 9.1 -4.8 L 10.3 -1.6 L 12.4 .0 L 15.0 .8 L 17.1 .8 L 19.2 -.4 L 20.0 -1.2 M 20.8 -6.1 L 20.2 -3.9 L 18.9 -2.2 L 16.4 -.9 L 14.3 -1.3 L 12.8 -3.1 L 11.9 -6.5 L 12.3 -8.8 L 14.0 -11.5 L 16.1 -12.1 L 18.0 -12.0 L 19.4 -10.5 L 20.4 -8.2 M 21.5 -9.2 L 22.4 -6.7 L 22.3 -4.4 L 22.3 -2.2 L 22.1 -.3 M 11.6 -10.2 L 10.6 -8.6 L 10.4 -6.3 L 10.7 -4.6 L 11.4 -3.1 M 21.1 -2.5 L 20.5 1.1 L 18.8 4.0 L 17.2 5.3 L 14.8 5.2 L 13.0 4.1 L 12.3 3.0 L 12.3 1.8","0 7.2 M 11.5 2.0 L 9.9 2.7 L 9.6 4.4 L 10.4 5.9 L 11.8 6.3 L 13.2 5.6 L 13.9 4.2 L 13.3 2.5 L 11.5 2.0 M 11.7 3.4 L 11.2 4.0 L 11.8 4.4 L 12.0 3.9 L 11.7 3.4 M 11.4 -10.2 L 9.8 -9.5 L 9.5 -7.8 L 10.3 -6.4 L 11.6 -5.9 L 13.1 -6.6 L 13.7 -8.1 L 13.1 -9.7 L 11.4 -10.2 M 11.7 -8.9 L 11.2 -8.2 L 11.8 -7.8 L 12.0 -8.3 L 11.7 -8.9","0 7.6 M 9.7 7.4 L 10.6 7.4 L 11.5 7.0 L 12.1 6.5 L 12.1 5.9 L 10.6 5.8 L 9.8 4.3 L 10.1 2.6 L 11.7 1.9 L 13.4 2.4 L 13.8 4.1 L 13.7 5.5 L 13.4 6.8 L 12.7 7.7 L 11.6 8.3 L 10.6 8.5 L 9.7 8.4 M 11.8 3.3 L 11.4 3.9 L 12.0 4.3 L 12.2 3.8 L 11.8 3.3 M 11.7 -10.2 L 10.1 -9.5 L 9.8 -7.8 L 10.6 -6.3 L 11.9 -5.9 L 13.4 -6.6 L 14.1 -8.0 L 13.4 -9.7 L 11.7 -10.2 M 11.8 -8.8 L 11.3 -8.2 L 11.9 -7.8 L 12.2 -8.3 L 11.8 -8.8","0 17.2 M 20.2 -12.2 L 9.0 -3.5 L 21.4 6.4 L 23.1 4.7 L 12.8 -2.5 M 11.5 -3.5 L 23.2 -11.4 L 21.5 -13.2","0 18.9 M 9.3 -7.6 L 26.0 -7.6 L 26.0 -6.8 M 25.9 -5.4 L 9.2 -5.4 L 9.2 -6.1 M 9.3 -1.9 L 26.0 -1.9 L 26.0 -1.2 M 25.9 .2 L 9.2 .2 L 9.2 -.5","0 17.0 M 11.9 -13.3 L 10.2 -11.7 L 21.8 -3.6 M 20.4 -2.5 L 10.3 4.5 L 11.9 6.6 L 24.3 -3.5 L 13.1 -12.5","0 15.5 M 13.9 .1 L 13.9 -2.4 L 14.7 -3.9 L 16.0 -5.1 L 17.4 -6.3 L 18.3 -7.4 L 18.6 -8.6 L 18.5 -9.6 L 17.6 -11.2 L 15.9 -12.0 L 14.4 -12.1 L 12.2 -11.4 L 11.1 -10.0 L 11.2 -8.3 M 9.6 -8.4 L 9.6 -13.7 M 10.9 -13.7 L 10.9 -12.6 L 11.7 -13.3 L 13.2 -13.8 L 16.2 -13.9 L 18.2 -13.5 L 19.7 -12.7 L 21.6 -11.2 L 22.3 -9.1 L 22.1 -7.3 L 20.9 -5.4 L 19.5 -4.4 L 18.1 -3.8 L 16.6 -2.9 L 15.9 -2.2 L 15.9 -1.7 L 15.9 .0 M 19.3 -6.3 L 20.4 -8.1 L 20.4 -9.3 L 19.8 -10.8 M 14.6 2.3 L 13.0 3.0 L 12.7 4.7 L 13.5 6.2 L 14.8 6.6 L 16.3 5.9 L 17.0 4.4 L 16.3 2.8 L 14.6 2.3 M 14.7 3.6 L 14.2 4.3 L 14.8 4.7 L 15.1 4.2 L 14.7 3.6","0 34.4 M 33.5 10.8 L 28.9 12.7 L 23.2 12.8 L 17.2 11.1 L 12.1 6.7 L 9.6 .6 L 9.5 -4.6 L 10.5 -9.9 L 13.3 -14.4 L 16.8 -17.6 L 21.8 -19.5 L 27.9 -20.0 L 32.9 -18.7 L 37.5 -15.8 L 40.2 -11.4 L 41.2 -7.6 L 40.8 -2.4 L 38.6 2.7 L 35.2 5.1 L 31.8 5.2 L 29.7 3.0 L 29.1 1.2 M 27.7 2.7 L 25.6 4.8 L 22.2 5.2 L 19.1 4.3 L 16.9 1.1 L 16.0 -3.2 L 16.7 -6.6 L 17.9 -9.4 L 20.7 -12.3 L 24.3 -13.7 L 27.9 -13.8 L 30.6 -12.6 L 31.8 -13.5 M 29.4 -11.1 L 25.2 -11.6 L 21.8 -9.1 L 20.0 -4.6 L 19.8 -.9 L 20.1 1.4 L 21.4 3.4 L 23.3 4.0 L 25.8 3.2 L 27.3 1.1 L 28.6 -1.5 L 29.3 -9.3 M 21.3 -11.0 L 18.8 -7.6 L 17.9 -4.1 L 18.0 -1.3 L 18.5 1.0 M 31.2 -10.9 L 30.3 -.3 M 32.9 -14.1 L 31.8 -.1 L 31.9 2.5 L 33.0 3.7 L 34.6 3.6 L 36.5 2.5 L 38.0 .3 L 39.1 -2.1 L 39.6 -6.4 L 38.8 -10.4 L 37.4 -13.4 L 35.0 -15.6 L 31.3 -17.5 L 27.1 -18.3 L 23.5 -18.2 L 18.9 -16.6 L 15.6 -14.1 L 12.7 -10.3 L 11.3 -6.6 L 11.1 -2.8 L 12.0 2.8 L 15.4 7.2 L 18.9 9.7 L 23.4 11.1 L 28.2 11.0 L 32.6 9.4","0 22.9 M 8.1 5.9 L 8.4 5.9 L 17.6 5.9 M 20.7 5.9 L 30.8 5.9 M 30.8 4.7 L 27.9 4.7 L 21.3 -11.5 L 21.3 -13.6 M 19.9 -13.5 L 18.8 -13.5 L 11.4 4.3 L 11.2 4.6 L 8.2 4.6 M 17.5 4.8 L 13.8 4.7 L 13.4 4.1 L 14.6 .9 L 22.6 .9 M 23.0 2.3 L 24.3 4.6 L 20.6 4.6 M 25.5 4.0 L 20.0 -10.5 M 18.9 -9.8 L 18.8 -8.9 L 21.9 -.5 L 15.3 -.5 L 17.6 -6.2","0 22.1 M 9.0 6.0 L 22.7 6.0 L 25.2 5.4 L 27.3 4.4 L 29.0 2.9 L 29.5 1.1 L 29.4 -.7 L 28.5 -2.6 L 26.7 -3.7 L 24.9 -4.3 M 21.9 -5.0 L 24.4 -5.8 L 26.2 -7.2 L 26.7 -9.1 L 26.3 -10.3 L 25.0 -11.6 L 23.0 -12.4 L 20.8 -12.9 L 17.2 -13.0 L 9.1 -13.0 M 8.9 -11.8 L 11.7 -11.8 L 12.5 -11.8 L 13.2 -11.2 L 13.2 4.2 L 12.9 4.7 L 8.9 4.7 M 16.0 4.6 L 22.4 4.6 L 24.4 3.4 L 25.6 2.0 L 25.9 .2 L 25.3 -1.5 L 24.0 -2.8 L 22.3 -3.5 L 20.0 -4.0 L 16.6 -4.0 L 16.6 2.4 M 14.9 4.1 L 14.9 -11.4 M 15.9 -11.6 L 19.5 -11.3 L 21.4 -10.8 L 22.8 -9.2 L 22.8 -7.8 L 22.0 -6.6 L 20.4 -5.7 L 18.3 -5.4 L 16.5 -5.4 L 16.5 -9.5 M 24.1 -10.2 L 24.6 -9.0 L 24.5 -7.9 L 23.9 -7.3 M 26.5 -2.1 L 27.4 -.9 L 27.6 .3 L 27.5 1.5 L 26.7 3.0","0 20.3 M 24.2 -6.4 L 23.7 -9.3 L 22.0 -11.4 L 19.3 -12.1 L 16.1 -11.5 L 13.9 -9.4 L 12.7 -5.6 L 13.1 -.8 L 14.1 1.8 L 16.6 4.4 L 20.3 4.9 L 23.2 3.9 L 24.5 2.8 L 25.4 1.5 M 13.0 2.8 L 11.8 .9 L 11.2 -1.0 L 11.0 -4.3 L 11.4 -6.5 L 12.1 -8.8 M 27.0 1.8 L 25.7 4.2 L 23.0 6.2 L 19.9 6.8 L 16.9 6.7 L 13.4 5.4 L 10.6 2.3 L 9.3 -1.0 L 9.3 -6.2 L 11.1 -10.4 L 14.3 -12.7 L 17.9 -13.9 L 19.7 -13.8 L 22.0 -13.2 M 23.8 -15.1 L 24.0 -11.9 M 25.2 -15.0 L 25.8 -6.5","0 22.6 M 8.7 5.8 L 21.4 5.8 L 24.9 4.8 L 26.8 3.4 L 28.5 .9 L 29.3 -1.2 L 29.4 -3.7 L 29.3 -4.6 L 29.1 -6.6 L 27.6 -9.4 L 26.2 -10.9 L 24.3 -12.0 L 22.8 -12.6 L 21.3 -13.0 L 8.5 -13.0 M 8.6 -11.6 L 12.2 -11.6 L 12.8 -11.0 L 12.8 4.2 L 12.4 4.9 L 8.5 4.9 M 15.6 4.5 L 20.5 4.5 L 22.5 3.8 L 23.9 2.7 L 25.1 1.0 L 25.7 -1.6 L 25.8 -4.3 L 25.5 -6.7 L 24.6 -8.8 L 23.2 -10.5 L 21.7 -11.2 L 19.6 -11.5 L 15.5 -11.5 M 16.1 -9.8 L 16.1 2.5 M 14.5 4.4 L 14.5 -11.5 M 26.2 -8.8 L 27.2 -6.4 L 27.5 -4.6 L 27.6 -2.5 L 27.3 -.6 L 26.8 .9 L 26.3 1.8","0 21.4 M 9.1 5.8 L 27.0 5.8 L 27.0 8.9 M 28.5 8.9 L 28.5 -.2 M 27.3 1.7 L 27.1 3.4 L 26.3 4.1 L 16.0 4.1 L 16.5 3.6 L 16.5 -1.9 M 16.5 -2.9 L 18.7 -2.9 L 19.9 -2.5 L 20.3 -1.4 L 20.3 1.1 L 21.5 1.1 L 21.5 -8.7 M 20.3 -7.3 L 20.3 -5.7 L 19.9 -4.9 L 19.2 -4.5 L 16.6 -4.5 L 16.6 -9.4 M 15.8 -11.6 L 23.8 -11.6 L 24.7 -10.9 L 25.2 -9.7 L 25.3 -6.9 M 26.6 -7.1 L 26.0 -15.4 M 25.1 -13.1 L 9.0 -13.1 M 8.9 -11.8 L 12.1 -11.8 L 12.8 -11.5 L 13.2 -10.8 L 13.2 3.9 L 12.7 4.8 L 8.8 4.8 M 14.8 3.8 L 14.8 -10.9","0 19.8 M 8.6 5.9 L 20.5 5.9 M 20.5 4.7 L 16.9 4.7 L 16.2 4.2 L 16.2 -2.2 M 16.0 -3.2 L 19.6 -3.2 L 20.4 -2.7 L 20.4 .7 L 21.8 .7 L 21.8 -9.0 M 20.6 -7.4 L 20.6 -5.7 L 19.8 -4.9 L 16.1 -4.9 L 16.0 -9.3 M 15.4 -11.4 L 24.6 -11.4 L 25.8 -10.2 L 25.8 -6.8 M 27.3 -7.0 L 26.5 -15.6 M 25.5 -13.2 L 8.8 -13.2 M 8.6 -11.9 L 11.9 -11.9 L 12.8 -11.0 L 12.8 4.0 L 12.3 4.8 L 8.7 4.8 M 14.5 -10.8 L 14.5 4.3","0 22.9 M 18.0 -1.8 L 23.7 -1.8 L 24.3 -1.3 L 24.3 2.3 L 23.1 3.8 L 21.2 5.0 L 18.0 5.1 L 14.8 3.4 L 13.3 .5 L 12.6 -3.3 L 12.9 -6.7 L 14.3 -10.2 L 16.6 -12.0 L 18.9 -12.3 L 21.0 -12.0 L 22.5 -10.9 L 23.6 -9.4 L 24.1 -8.0 L 24.1 -6.3 M 25.9 -6.3 L 25.2 -15.3 M 23.9 -15.2 L 24.1 -11.9 M 21.8 -13.1 L 19.5 -13.9 L 15.4 -13.3 L 12.4 -11.6 L 10.2 -8.8 L 9.1 -5.4 L 9.1 -1.9 L 10.4 2.2 L 12.8 4.9 L 15.8 6.3 L 20.1 6.9 L 23.2 5.8 L 24.8 4.5 M 12.2 -9.1 L 11.1 -6.0 L 10.8 -3.0 L 11.5 .5 L 12.7 2.4 M 25.8 -1.6 L 25.8 2.9 M 26.4 5.1 L 26.4 7.9 M 27.5 8.0 L 27.5 -1.4 L 28.1 -1.9 L 30.6 -1.9 M 30.7 -3.2 L 18.2 -3.2","0 24.9 M 8.6 6.3 L 20.1 6.3 M 21.1 6.3 L 32.7 6.3 M 32.5 4.9 L 29.0 4.9 L 28.4 4.4 L 28.4 -11.1 L 29.0 -11.7 L 32.7 -11.7 M 32.7 -13.0 L 21.4 -13.0 M 20.1 -13.0 L 8.6 -13.0 M 8.7 -11.7 L 12.2 -11.7 L 12.7 -10.9 L 12.7 4.2 L 12.1 4.7 L 8.5 4.7 M 20.0 4.8 L 16.9 4.8 L 16.3 4.2 L 16.3 -3.6 L 24.9 -3.6 M 25.0 -1.6 L 25.0 4.1 L 24.3 4.8 L 21.3 4.8 M 26.7 4.4 L 26.7 -11.7 M 21.5 -11.8 L 24.2 -11.8 L 25.0 -11.0 L 25.0 -5.7 L 24.4 -5.1 L 16.3 -5.1 M 16.2 -7.1 L 16.2 -11.2 L 16.7 -11.7 L 20.1 -11.7 M 14.5 -11.7 L 14.5 4.6","0 13.1 M 9.0 6.2 L 20.8 6.2 M 20.7 4.8 L 17.2 4.8 L 16.6 4.2 L 16.6 -11.0 L 17.4 -11.8 L 20.9 -11.8 M 20.9 -13.1 L 8.8 -13.1 M 8.8 -11.9 L 12.6 -11.9 L 13.2 -11.3 L 13.2 4.1 L 12.5 4.8 L 9.0 4.8 M 14.9 4.5 L 14.9 -11.7","0 15.5 M 8.3 6.0 L 10.1 6.5 L 12.7 6.7 L 15.7 5.6 L 17.5 4.0 L 18.3 2.4 L 18.7 .9 L 18.7 -11.0 L 19.4 -11.8 L 22.7 -11.8 M 22.8 -13.2 L 9.3 -13.2 M 9.2 -11.7 L 15.6 -11.7 M 15.2 -10.7 L 15.2 1.7 L 15.0 3.2 L 14.1 4.4 L 12.7 5.2 L 10.9 5.0 L 9.1 4.4 M 17.0 -11.3 L 17.0 2.2","0 22.9 M 8.9 5.9 L 19.4 5.9 M 19.3 4.8 L 16.6 4.8 L 16.6 -.9 L 18.1 -3.0 L 27.1 8.9 L 30.6 11.7 L 34.7 13.0 L 37.4 12.8 L 39.4 12.1 L 40.7 11.3 M 39.4 10.1 L 37.7 11.0 L 35.2 11.0 L 33.7 10.5 L 32.1 9.4 L 30.6 8.0 L 23.0 -2.3 L 22.0 -3.3 L 20.8 -4.2 M 19.5 -4.7 L 23.8 -10.3 L 25.3 -11.4 L 26.4 -11.7 L 29.5 -11.7 M 29.6 -13.2 L 21.8 -13.2 M 19.8 -13.1 L 9.0 -13.1 M 9.0 -11.7 L 12.4 -11.7 L 12.9 -11.2 L 12.9 4.2 L 12.3 4.8 L 8.9 4.8 M 14.8 4.4 L 14.8 -11.7 M 16.5 -5.4 L 16.5 -11.2 L 17.1 -11.8 L 19.7 -11.8 M 21.8 -11.7 L 23.0 -11.7 L 16.5 -3.4 M 20.5 -2.6 L 22.8 .4 L 25.4 4.2 L 27.9 7.3 L 29.2 8.8 L 30.3 9.7","0 20.3 M 8.7 6.2 L 25.6 6.2 L 25.6 8.6 M 27.1 8.6 L 27.1 -.3 M 26.1 1.6 L 26.1 3.0 L 25.0 4.1 L 15.5 4.1 M 16.4 2.7 L 16.4 -11.0 L 17.1 -11.7 L 20.8 -11.7 M 20.9 -13.1 L 8.6 -13.1 M 8.5 -11.7 L 12.4 -11.7 L 13.0 -11.1 L 13.0 4.2 L 12.4 4.7 L 8.7 4.7 M 14.6 -10.6 L 14.6 3.4","0 29.7 M 8.4 6.0 L 17.7 6.0 M 17.8 4.8 L 14.5 4.8 L 13.9 4.2 L 14.7 -7.1 M 15.4 -5.9 L 21.7 6.2 L 22.6 6.3 L 29.7 -7.7 M 29.7 -5.2 L 30.7 3.8 L 30.3 4.6 L 26.9 4.6 M 27.0 6.0 L 37.6 6.0 M 37.5 4.7 L 34.9 4.7 L 34.3 4.0 L 32.7 -10.9 L 33.3 -11.7 L 35.9 -11.7 M 35.9 -13.1 L 31.1 -13.1 L 23.2 2.2 M 22.6 .6 L 15.6 -13.1 L 10.1 -13.1 M 10.1 -11.9 L 13.5 -11.9 L 13.8 -11.4 L 12.3 4.0 L 11.5 4.7 L 8.3 4.7 M 15.2 -10.3 L 21.8 2.6 M 32.5 4.5 L 30.9 -10.0","0 23.4 M 8.6 6.0 L 18.3 6.0 M 18.2 4.7 L 14.7 4.7 L 14.2 4.2 L 14.2 -9.0 M 15.2 -7.4 L 25.3 6.4 L 25.9 6.4 M 27.0 6.4 L 27.0 -11.1 L 27.5 -11.7 L 30.7 -11.7 M 30.9 -13.2 L 21.1 -13.2 M 21.2 -11.8 L 24.5 -11.8 L 25.2 -11.1 L 25.2 .9 M 23.8 -1.3 L 15.3 -13.0 L 8.6 -13.0 M 8.5 -11.7 L 11.8 -11.7 L 12.6 -10.9 L 12.6 4.0 L 11.9 4.7 L 8.6 4.7 M 15.0 -10.6 L 24.6 2.4","0 20.6 M 9.8 -7.4 L 9.3 -3.8 L 9.5 -1.0 L 11.1 3.4 L 13.7 5.7 L 17.8 7.1 L 21.4 6.5 L 24.9 4.4 L 27.1 .9 L 27.8 -2.7 L 27.4 -7.1 L 25.5 -10.6 L 21.8 -13.2 L 17.6 -13.8 L 14.6 -13.0 L 12.7 -11.7 M 13.8 -10.0 L 12.8 -7.9 L 12.6 -4.9 L 13.0 -.9 L 14.0 2.3 L 16.0 4.5 L 19.4 5.1 L 22.4 3.6 L 23.7 .9 L 24.1 -3.1 L 23.7 -6.6 L 22.6 -9.6 L 20.8 -11.6 L 18.7 -12.1 M 11.5 -8.4 L 11.1 -5.1 L 11.0 -2.3 L 11.5 -.1 L 12.0 1.5 L 12.9 3.0 M 25.2 1.0 L 25.8 -1.7 L 25.8 -4.9 L 25.1 -8.0 L 24.0 -10.1","0 22.6 M 8.9 6.2 L 21.0 6.2 M 21.0 4.8 L 17.1 4.8 L 16.5 4.2 L 16.5 1.0 M 16.5 -.4 L 21.8 -.4 L 24.6 -.8 L 27.5 -2.2 L 29.1 -4.5 L 29.6 -7.0 L 29.1 -9.0 L 26.9 -11.4 L 24.2 -12.7 L 22.2 -13.0 L 8.9 -13.0 M 8.9 -11.7 L 12.4 -11.7 L 13.1 -11.0 L 13.1 4.1 L 12.4 4.8 L 8.9 4.8 M 16.6 -9.3 L 16.6 -2.0 L 22.0 -2.0 L 23.8 -2.7 L 25.1 -4.0 L 25.8 -5.5 L 25.7 -8.2 L 24.9 -9.9 L 23.0 -11.1 L 21.0 -11.6 L 16.0 -11.6 M 15.0 -10.5 L 15.0 4.7 M 26.4 -10.0 L 27.2 -8.5 L 27.7 -7.3 L 27.7 -6.2 L 27.2 -4.7 L 26.3 -3.5","0 20.6 M 14.0 13.6 L 12.5 13.4 L 11.6 12.2 L 11.3 10.0 L 11.8 8.1 L 13.7 6.7 L 18.5 4.8 L 21.2 3.0 L 23.2 -.1 L 23.8 -2.7 L 23.6 -5.7 L 23.0 -8.5 L 22.1 -10.2 L 20.5 -11.6 L 18.3 -12.2 M 13.4 -10.0 L 12.3 -7.2 L 12.2 -3.7 L 12.5 -.6 L 13.1 2.2 L 15.3 4.0 M 13.9 5.3 L 11.7 3.7 L 9.7 .7 L 9.0 -2.1 L 9.1 -5.7 L 10.3 -9.4 L 12.4 -11.8 L 16.0 -13.5 L 19.4 -13.5 L 22.2 -12.8 L 24.8 -11.0 L 26.7 -8.2 L 27.4 -4.9 L 27.0 -.9 L 25.8 1.7 L 23.7 4.0 L 21.1 5.4 L 14.4 8.0 M 15.7 8.3 L 19.9 8.8 L 23.4 9.6 L 26.5 10.3 L 30.6 11.4 L 33.5 11.8 L 36.2 11.4 L 37.3 10.7 L 37.9 9.6 L 37.9 8.6 M 39.8 8.6 L 39.8 9.9 L 38.9 12.0 L 37.3 13.7 L 34.0 14.6 L 32.0 14.7 L 28.4 13.9 L 23.0 12.3 L 18.6 10.7 L 15.5 9.8 L 13.8 9.9 L 13.1 10.5 L 13.0 11.4 L 13.6 12.0 L 14.2 11.9 M 11.4 .6 L 10.7 -1.4 L 10.6 -4.5 L 11.0 -7.0 L 11.4 -8.4 M 23.9 -9.7 L 25.2 -6.9 L 25.4 -4.0 L 25.3 -1.7 L 24.4 .8 M 21.2 10.2 L 26.6 11.7 L 30.0 12.7 L 32.9 13.2 L 35.3 13.1 L 37.2 12.2","0 23.3 M 8.6 5.9 L 20.0 5.9 M 20.0 4.7 L 16.6 4.7 L 16.1 4.2 L 16.1 -1.3 M 17.3 -1.4 L 19.6 -1.4 L 20.6 -.8 L 21.3 .0 L 28.2 9.0 L 29.9 10.6 L 31.5 11.8 L 33.3 12.5 L 35.4 12.9 L 38.2 12.7 L 40.1 11.9 L 41.1 11.2 M 40.4 10.1 L 38.3 11.1 L 35.6 10.9 L 34.2 10.4 L 31.5 8.2 L 25.3 .0 L 24.7 -.7 L 24.2 -1.1 M 23.3 .2 L 25.1 2.4 L 26.6 4.5 L 28.3 6.8 L 30.1 8.8 L 31.2 9.9 M 23.0 -1.7 L 26.0 -2.7 L 27.8 -4.2 L 28.9 -6.1 L 28.8 -8.3 L 28.0 -10.2 L 25.5 -11.8 L 23.6 -12.7 L 20.4 -13.1 L 8.5 -13.1 M 8.4 -11.7 L 12.1 -11.7 L 12.6 -11.2 L 12.6 4.0 L 11.9 4.7 L 8.7 4.7 M 14.3 4.5 L 14.3 -10.8 M 15.3 -11.5 L 20.3 -11.5 L 21.8 -11.3 L 22.9 -10.9 L 24.0 -10.2 L 24.9 -9.1 L 25.1 -7.3 L 24.9 -5.5 L 23.5 -4.0 L 21.8 -3.3 L 20.0 -3.2 L 16.1 -3.2 L 16.1 -9.3 M 26.1 -9.6 L 27.0 -7.8 L 27.0 -6.4 L 26.4 -4.8 L 25.9 -4.2","0 17.9 M 10.4 7.3 L 10.4 4.3 M 9.0 7.4 L 9.0 -1.7 M 10.5 -1.7 L 10.5 .3 L 11.1 2.0 L 12.3 3.2 L 14.5 4.4 L 17.8 4.8 L 20.3 3.9 L 21.4 2.7 L 21.4 1.4 L 21.0 .2 L 19.6 -.7 L 15.7 -2.5 L 12.4 -4.4 L 10.4 -6.6 L 9.7 -8.5 L 10.1 -10.3 L 11.9 -12.3 L 13.7 -13.0 L 16.5 -13.4 L 17.9 -13.4 L 19.6 -12.9 M 21.6 -14.4 L 21.6 -11.6 M 23.1 -14.4 L 23.3 -6.5 M 21.8 -6.6 L 21.8 -8.5 L 21.0 -9.9 L 19.9 -11.1 L 18.5 -11.6 L 16.8 -11.9 L 15.2 -11.7 L 13.4 -10.9 L 12.8 -9.5 L 13.8 -7.7 L 15.2 -6.7 L 20.1 -4.2 L 21.9 -3.3 L 23.9 -1.5 L 24.9 .8 L 24.3 3.3 L 22.9 4.7 L 21.0 5.7 L 18.6 6.3 L 15.3 6.3 L 12.5 5.5 M 22.7 2.8 L 23.2 1.5 L 23.0 .2 L 22.0 -1.0 L 20.4 -2.1 L 15.0 -4.9 L 13.3 -5.9 L 12.1 -7.2 L 11.5 -8.6 L 11.6 -9.1","0 20.7 M 12.3 6.2 L 24.9 6.2 M 24.8 4.8 L 20.9 4.8 L 20.5 4.4 L 20.5 -9.3 M 20.3 -11.5 L 25.8 -11.5 L 26.8 -10.4 L 27.2 -6.2 M 28.6 -6.2 L 27.7 -14.7 M 26.8 -13.1 L 12.1 -13.1 M 9.7 -14.8 L 8.8 -6.0 M 10.4 -8.2 L 10.6 -9.9 L 11.2 -10.9 L 12.1 -11.2 L 16.9 -11.2 L 16.9 4.2 L 16.6 4.8 L 12.3 4.8 M 18.7 4.4 L 18.7 -11.3","0 23.7 M 8.7 -11.8 L 11.9 -11.8 L 12.3 -11.1 L 12.3 .9 L 13.0 2.9 L 14.2 4.5 L 15.5 5.6 L 17.0 6.3 L 18.8 6.7 L 20.9 6.7 L 23.4 6.1 L 25.0 5.0 L 26.3 3.3 L 26.9 2.1 L 27.2 .4 L 27.2 -11.0 L 27.8 -11.6 L 31.1 -11.6 M 31.2 -13.2 L 21.6 -13.2 M 21.5 -11.8 L 24.6 -11.8 L 25.4 -11.3 L 25.4 1.0 L 24.8 2.3 L 23.8 3.7 L 22.4 4.7 L 20.7 5.2 L 19.0 5.2 L 17.4 4.6 L 16.5 3.8 L 15.9 2.5 M 14.5 2.3 L 13.9 1.0 L 14.0 -.8 L 14.0 -11.5 M 8.6 -13.1 L 19.8 -13.1 M 19.8 -11.6 L 16.3 -11.6 L 15.8 -11.2 L 15.8 -1.5","0 23.0 M 8.5 -11.8 L 11.3 -11.8 L 18.7 6.5 L 20.4 6.5 L 27.4 -11.1 L 28.1 -11.7 L 30.7 -11.8 M 30.7 -13.2 L 20.9 -13.2 M 21.0 -11.7 L 25.1 -11.7 L 25.6 -11.2 L 20.5 2.0 M 19.8 .2 L 15.0 -11.8 L 17.5 -11.8 M 17.5 -13.1 L 8.1 -13.1 M 13.5 -10.9 L 19.4 3.5","0 35.0 M 8.4 -11.8 L 11.2 -11.8 L 18.7 6.5 L 20.4 6.5 L 25.1 -5.0 M 25.6 -6.9 L 30.9 6.4 L 32.5 6.4 L 39.7 -11.2 L 40.1 -11.7 L 42.9 -11.7 M 42.9 -13.2 L 33.2 -13.2 M 33.4 -11.7 L 36.9 -11.7 L 37.6 -11.7 L 37.8 -10.9 L 32.6 1.9 M 32.0 .1 L 27.1 -11.8 L 30.7 -11.8 M 30.8 -13.1 L 20.6 -13.1 M 20.6 -11.7 L 23.4 -11.7 L 24.8 -8.7 L 20.3 2.1 M 19.8 .2 L 14.9 -11.7 L 16.2 -11.7 M 16.4 -13.1 L 8.4 -13.1 M 13.5 -10.8 L 19.1 2.9 M 25.7 -10.9 L 31.2 2.8","0 23.0 M 8.6 6.2 L 18.3 6.2 M 19.4 6.1 L 30.9 6.1 M 30.8 4.8 L 27.8 4.8 L 21.7 -4.6 L 26.3 -11.5 L 27.1 -11.9 L 29.7 -11.8 M 29.7 -13.2 L 19.9 -13.2 M 20.0 -11.8 L 23.4 -11.8 L 23.7 -11.3 L 20.6 -6.2 M 19.7 -7.4 L 16.6 -11.8 L 18.4 -11.8 M 18.5 -13.2 L 9.7 -13.2 M 9.7 -11.8 L 12.5 -11.8 L 18.0 -4.0 L 12.0 4.7 L 8.5 4.7 M 18.9 -2.6 L 15.0 3.5 L 14.8 4.2 L 15.1 4.7 L 18.1 4.7 M 19.6 4.7 L 22.7 4.7 L 23.1 4.1 L 19.6 -1.3 M 15.6 -10.6 L 25.5 4.6 L 24.9 4.6 L 24.9 3.4","0 22.2 M 12.9 6.2 L 25.8 6.2 M 25.8 4.8 L 21.4 4.8 L 21.0 4.4 L 21.0 -.5 L 26.6 -11.3 L 27.3 -11.7 L 30.1 -11.7 M 30.0 -13.2 L 20.3 -13.2 M 20.3 -11.7 L 23.9 -11.7 L 24.5 -11.1 L 20.0 -2.3 M 18.9 -4.8 L 15.3 -11.8 L 17.8 -11.8 M 17.9 -13.3 L 8.2 -13.3 M 8.2 -11.8 L 11.5 -11.8 L 12.0 -11.0 L 17.7 .1 L 17.7 4.3 L 17.2 4.8 L 12.8 4.8 M 19.4 4.6 L 19.4 -.1 L 14.0 -11.0","0 21.8 M 8.6 5.9 L 27.0 5.9 L 27.0 8.7 M 28.4 8.7 L 28.7 -.1 M 27.3 1.6 L 27.0 3.2 L 26.7 3.9 L 26.0 4.2 L 14.5 4.2 M 16.3 1.9 L 27.2 -11.6 L 28.7 -11.6 M 28.7 -13.0 L 11.4 -13.0 L 11.4 -15.0 M 9.8 -14.8 L 9.3 -6.1 M 10.8 -8.2 L 11.2 -9.9 L 12.5 -11.2 L 22.8 -11.2 M 21.0 -9.0 L 10.0 4.6 L 8.8 4.6 M 12.4 4.3 L 24.9 -11.4","0 10.1 M 17.8 11.3 L 9.7 11.3 L 9.7 -17.0 M 9.5 -18.3 L 17.8 -18.3 M 17.8 -17.0 L 12.8 -17.0 L 13.3 -15.9 L 13.3 8.3 L 12.6 9.4 M 11.3 9.2 L 11.3 -16.1 M 13.1 10.0 L 18.0 10.0","0 21.0 M 9.9 -13.8 L 26.0 7.3 L 27.4 6.3 L 10.9 -15.0","0 10.0 M 8.4 11.3 L 16.5 11.3 L 16.5 -17.1 M 16.7 -18.3 L 8.4 -18.3 M 8.4 -17.1 L 13.5 -17.1 L 12.9 -16.0 L 12.9 8.2 L 13.6 9.4 M 14.9 9.1 L 14.9 -16.1 M 13.1 9.9 L 8.2 9.9","0 16.7 M 16.3 -12.9 L 11.1 -7.4 L 9.7 -9.0 L 16.3 -15.3 L 23.4 -9.0 L 22.0 -7.3 L 17.7 -12.0","0 11.3 M 8.2 10.6 L 19.2 10.6","0 9.6 M 14.1 -15.8 L 11.1 -18.2 L 9.9 -19.3 L 9.9 -20.0 L 11.0 -21.1 L 12.0 -21.0 L 16.1 -16.0 L 15.5 -15.4","0 23.0 M 8.1 5.9 L 8.4 5.9 L 17.6 5.9 M 20.7 5.9 L 30.8 5.9 M 30.8 4.7 L 27.9 4.7 L 21.3 -11.5 L 21.3 -13.6 M 19.9 -13.5 L 18.8 -13.5 L 11.4 4.3 L 11.2 4.6 L 8.2 4.6 M 17.5 4.8 L 13.8 4.7 L 13.4 4.1 L 14.6 .9 L 22.6 .9 M 23.0 2.3 L 24.3 4.6 L 20.6 4.6 M 25.5 4.0 L 20.0 -10.5 M 18.9 -9.9 L 18.8 -8.9 L 21.9 -.5 L 15.4 -.5 L 17.6 -6.2","0 22.1 M 9.0 6.0 L 22.7 6.0 L 25.2 5.4 L 27.3 4.4 L 29.0 2.9 L 29.5 1.1 L 29.4 -.7 L 28.5 -2.6 L 26.7 -3.7 L 24.9 -4.3 M 21.9 -5.0 L 24.4 -5.8 L 26.1 -7.2 L 26.7 -9.1 L 26.2 -10.3 L 24.9 -11.6 L 23.0 -12.4 L 20.8 -13.0 L 17.2 -13.0 L 9.1 -13.0 M 8.9 -11.8 L 11.7 -11.8 L 12.5 -11.8 L 13.2 -11.2 L 13.2 4.2 L 12.9 4.7 L 8.9 4.7 M 16.0 4.6 L 22.4 4.6 L 24.4 3.4 L 25.6 2.0 L 25.9 .2 L 25.3 -1.5 L 24.0 -2.8 L 22.3 -3.5 L 19.9 -4.0 L 16.6 -4.0 L 16.6 2.4 M 14.9 4.1 L 14.9 -11.4 M 15.9 -11.6 L 19.4 -11.3 L 21.4 -10.8 L 22.8 -9.2 L 22.8 -7.8 L 21.9 -6.6 L 20.4 -5.7 L 18.3 -5.4 L 16.5 -5.4 L 16.5 -9.5 M 24.1 -10.2 L 24.6 -9.0 L 24.4 -8.0 L 23.9 -7.3 M 26.5 -2.1 L 27.4 -.9 L 27.6 .3 L 27.5 1.5 L 26.7 3.0","0 20.1 M 24.2 -6.4 L 23.7 -9.3 L 21.9 -11.4 L 19.2 -12.1 L 16.0 -11.5 L 13.8 -9.4 L 12.7 -5.6 L 13.1 -.8 L 14.1 1.8 L 16.6 4.4 L 20.3 4.9 L 23.2 3.9 L 24.4 2.8 L 25.4 1.5 M 12.9 2.8 L 11.8 .9 L 11.2 -1.0 L 11.0 -4.3 L 11.3 -6.5 L 12.1 -8.8 M 27.0 1.8 L 25.7 4.2 L 23.0 6.1 L 19.8 6.8 L 16.8 6.7 L 13.4 5.4 L 10.5 2.3 L 9.2 -1.0 L 9.2 -6.2 L 11.0 -10.5 L 14.2 -12.7 L 17.9 -13.9 L 19.7 -13.8 L 22.0 -13.2 M 23.8 -15.1 L 23.9 -11.9 M 25.1 -15.0 L 25.8 -6.5","0 22.5 M 8.6 5.8 L 21.4 5.8 L 24.8 4.8 L 26.7 3.4 L 28.5 .9 L 29.3 -1.2 L 29.4 -3.7 L 29.3 -4.6 L 29.1 -6.6 L 27.6 -9.4 L 26.1 -10.9 L 24.3 -12.0 L 22.8 -12.6 L 21.2 -13.0 L 8.5 -13.0 M 8.5 -11.6 L 12.2 -11.6 L 12.8 -11.0 L 12.8 4.2 L 12.4 4.9 L 8.5 4.9 M 15.5 4.5 L 20.4 4.5 L 22.4 3.8 L 23.8 2.7 L 25.1 1.0 L 25.7 -1.7 L 25.7 -4.3 L 25.4 -6.7 L 24.5 -8.8 L 23.2 -10.5 L 21.6 -11.2 L 19.6 -11.5 L 15.5 -11.5 M 16.1 -9.8 L 16.1 2.5 M 14.5 4.4 L 14.5 -11.5 M 26.1 -8.8 L 27.2 -6.4 L 27.5 -4.6 L 27.6 -2.5 L 27.2 -.6 L 26.8 .9 L 26.3 1.8","0 21.3 M 9.1 5.8 L 26.9 5.8 L 26.9 8.8 M 28.5 8.8 L 28.5 -.2 M 27.3 1.7 L 27.1 3.4 L 26.3 4.1 L 16.0 4.1 L 16.5 3.6 L 16.5 -1.9 M 16.5 -2.9 L 18.7 -2.9 L 19.9 -2.5 L 20.3 -1.4 L 20.3 1.1 L 21.5 1.1 L 21.5 -8.7 M 20.3 -7.3 L 20.3 -5.7 L 19.9 -4.9 L 19.2 -4.5 L 16.6 -4.5 L 16.6 -9.4 M 15.8 -11.6 L 23.8 -11.6 L 24.7 -10.9 L 25.2 -9.7 L 25.3 -6.9 M 25.1 -13.1 L 8.9 -13.1 M 8.8 -11.8 L 12.0 -11.8 L 12.8 -11.5 L 13.2 -10.8 L 13.2 3.8 L 12.6 4.8 L 8.8 4.8 M 14.8 3.8 L 14.8 -10.9 M 26.6 -7.2 L 25.9 -15.5","0 20.2 M 8.6 5.9 L 20.5 5.9 M 20.5 4.7 L 16.9 4.7 L 16.2 4.2 L 16.2 -2.2 M 16.0 -3.2 L 19.6 -3.2 L 20.5 -2.7 L 20.5 .7 L 21.9 .7 L 21.9 -9.0 M 20.6 -7.4 L 20.6 -5.7 L 19.8 -4.9 L 16.1 -4.9 L 16.1 -9.3 M 15.4 -11.4 L 24.7 -11.4 L 25.8 -10.2 L 25.8 -6.8 M 27.3 -7.0 L 26.6 -15.6 M 25.5 -13.2 L 8.8 -13.2 M 8.6 -11.9 L 11.9 -11.9 L 12.9 -11.0 L 12.9 4.0 L 12.3 4.8 L 8.8 4.8 M 14.5 -10.8 L 14.5 4.3","0 22.5 M 17.6 -1.8 L 23.3 -1.8 L 23.9 -1.3 L 23.9 2.3 L 22.7 3.8 L 20.8 5.0 L 17.6 5.1 L 14.4 3.4 L 12.9 .5 L 12.1 -3.3 L 12.5 -6.7 L 13.9 -10.2 L 16.2 -12.0 L 18.4 -12.3 L 20.6 -12.0 L 22.1 -10.9 L 23.2 -9.4 L 23.7 -8.0 L 23.7 -6.3 M 25.5 -6.3 L 24.7 -15.3 M 23.4 -15.2 L 23.6 -11.9 M 21.4 -13.1 L 19.0 -13.9 L 15.0 -13.3 L 12.0 -11.6 L 9.7 -8.8 L 8.7 -5.4 L 8.7 -1.9 L 10.0 2.2 L 12.4 4.9 L 15.4 6.3 L 19.6 6.9 L 22.8 5.8 L 24.4 4.5 M 11.8 -9.1 L 10.7 -6.0 L 10.4 -3.1 L 11.1 .5 L 12.3 2.4 M 25.4 -1.6 L 25.4 2.9 M 25.9 5.1 L 25.9 7.9 M 27.1 8.0 L 27.1 -1.4 L 27.6 -1.9 L 30.2 -1.9 M 30.3 -3.2 L 17.7 -3.2","0 25.3 M 8.6 6.3 L 20.1 6.3 M 21.2 6.3 L 32.6 6.3 M 32.5 4.9 L 28.9 4.9 L 28.4 4.3 L 28.4 -11.1 L 29.0 -11.7 L 32.6 -11.7 M 32.6 -13.0 L 21.4 -13.0 M 20.0 -13.0 L 8.5 -13.0 M 8.7 -11.7 L 12.2 -11.7 L 12.6 -10.9 L 12.6 4.2 L 12.0 4.7 L 8.5 4.7 M 19.9 4.8 L 16.9 4.8 L 16.3 4.2 L 16.3 -3.6 L 24.9 -3.6 M 24.9 -1.6 L 24.9 4.1 L 24.2 4.8 L 21.2 4.8 M 26.6 4.4 L 26.6 -11.7 M 21.4 -11.8 L 24.2 -11.8 L 25.0 -11.0 L 25.0 -5.7 L 24.4 -5.1 L 16.3 -5.1 M 16.1 -7.1 L 16.1 -11.2 L 16.7 -11.7 L 20.1 -11.7 M 14.5 -11.7 L 14.5 4.6","0 13.2 M 8.7 6.2 L 20.5 6.2 M 20.4 4.8 L 16.9 4.8 L 16.3 4.2 L 16.3 -11.0 L 17.1 -11.8 L 20.6 -11.8 M 20.6 -13.1 L 8.5 -13.1 M 8.5 -11.9 L 12.3 -11.9 L 12.9 -11.3 L 12.9 4.1 L 12.2 4.8 L 8.7 4.8 M 14.6 4.5 L 14.6 -11.7","0 15.5 M 8.0 6.0 L 9.8 6.5 L 12.4 6.7 L 15.4 5.6 L 17.2 4.0 L 18.0 2.3 L 18.4 .9 L 18.4 -11.0 L 19.1 -11.8 L 22.4 -11.8 M 22.5 -13.2 L 9.0 -13.2 M 8.8 -11.7 L 15.3 -11.7 M 14.9 -10.7 L 14.9 1.7 L 14.7 3.2 L 13.8 4.4 L 12.4 5.2 L 10.6 5.0 L 8.8 4.3 M 16.7 -11.3 L 16.7 2.2","0 23.3 M 8.6 5.9 L 19.1 5.9 M 19.0 4.8 L 16.3 4.8 L 16.3 -.9 L 17.8 -3.0 L 24.7 6.1 L 25.6 6.7 L 26.7 6.8 L 27.9 6.7 L 31.0 5.8 M 20.5 -4.2 L 21.7 -3.3 L 22.7 -2.3 L 27.6 4.4 L 28.0 4.7 L 31.0 4.7 M 19.2 -4.7 L 23.5 -10.3 L 25.0 -11.4 L 26.1 -11.7 L 29.2 -11.7 M 29.3 -13.2 L 21.5 -13.2 M 19.5 -13.1 L 8.7 -13.1 M 8.7 -11.7 L 12.1 -11.7 L 12.6 -11.2 L 12.6 4.2 L 12.0 4.8 L 8.6 4.8 M 14.5 4.4 L 14.5 -11.7 M 16.2 -5.4 L 16.2 -11.2 L 16.8 -11.8 L 19.3 -11.8 M 21.5 -11.7 L 22.6 -11.7 L 16.2 -3.4 M 20.2 -2.6 L 22.5 .4 L 25.1 4.2 L 26.2 5.1","0 20.1 M 8.8 6.2 L 25.7 6.2 L 25.7 8.6 M 27.2 8.6 L 27.2 -.3 M 26.2 1.6 L 26.2 3.0 L 25.0 4.1 L 15.6 4.1 M 16.5 2.7 L 16.5 -11.0 L 17.2 -11.7 L 20.9 -11.7 M 21.0 -13.1 L 8.7 -13.1 M 8.6 -11.7 L 12.5 -11.7 L 13.1 -11.1 L 13.1 4.2 L 12.5 4.7 L 8.8 4.7 M 14.7 -10.6 L 14.7 3.4","0 30.0 M 8.8 6.0 L 18.1 6.0 M 18.2 4.8 L 14.9 4.8 L 14.3 4.2 L 15.1 -7.1 M 15.8 -5.9 L 22.1 6.2 L 23.0 6.3 L 30.1 -7.7 M 30.1 -5.3 L 31.1 3.8 L 30.7 4.6 L 27.3 4.6 M 27.4 6.0 L 38.0 6.0 M 37.9 4.7 L 35.3 4.7 L 34.7 4.0 L 33.1 -10.9 L 33.7 -11.7 L 36.3 -11.7 M 36.2 -13.1 L 31.4 -13.1 L 23.6 2.2 M 23.0 .6 L 16.0 -13.1 L 10.5 -13.1 M 10.5 -11.9 L 13.9 -11.9 L 14.2 -11.4 L 12.7 4.0 L 11.9 4.7 L 8.7 4.7 M 15.6 -10.3 L 22.2 2.6 M 32.9 4.5 L 31.3 -10.0","0 23.5 M 8.8 6.0 L 18.5 6.0 M 18.4 4.7 L 14.9 4.7 L 14.4 4.2 L 14.4 -9.0 M 15.4 -7.4 L 25.4 6.4 L 26.0 6.4 M 27.1 6.4 L 27.1 -11.1 L 27.7 -11.7 L 30.9 -11.7 M 31.0 -13.2 L 21.3 -13.2 M 21.3 -11.8 L 24.6 -11.8 L 25.3 -11.1 L 25.3 .9 M 23.9 -1.3 L 15.5 -13.0 L 8.7 -13.0 M 8.6 -11.7 L 12.0 -11.7 L 12.8 -11.0 L 12.8 4.0 L 12.1 4.7 L 8.8 4.7 M 15.2 -10.6 L 24.8 2.3","0 20.7 M 9.7 -7.4 L 9.2 -3.8 L 9.4 -1.0 L 11.0 3.3 L 13.5 5.7 L 17.7 7.1 L 21.2 6.5 L 24.8 4.4 L 26.9 .9 L 27.7 -2.7 L 27.3 -7.1 L 25.4 -10.6 L 21.7 -13.2 L 17.5 -13.8 L 14.4 -13.0 L 12.6 -11.7 M 13.7 -10.1 L 12.6 -7.9 L 12.4 -4.9 L 12.8 -1.0 L 13.9 2.3 L 15.9 4.5 L 19.3 5.1 L 22.3 3.6 L 23.6 .9 L 23.9 -3.1 L 23.6 -6.6 L 22.5 -9.6 L 20.7 -11.6 L 18.5 -12.1 M 11.4 -8.4 L 10.9 -5.1 L 10.9 -2.3 L 11.4 -.1 L 11.9 1.5 L 12.7 3.0 M 25.0 1.0 L 25.7 -1.7 L 25.7 -4.9 L 25.0 -8.0 L 23.9 -10.1","0 22.1 M 8.6 6.1 L 20.8 6.1 M 20.8 4.8 L 16.9 4.8 L 16.3 4.2 L 16.3 1.0 M 16.2 -.4 L 21.6 -.4 L 24.3 -.8 L 27.3 -2.2 L 28.9 -4.5 L 29.4 -7.0 L 28.8 -9.1 L 26.7 -11.4 L 24.0 -12.7 L 22.0 -13.0 L 8.6 -13.0 M 8.7 -11.7 L 12.2 -11.7 L 12.9 -11.0 L 12.9 4.1 L 12.2 4.7 L 8.6 4.7 M 16.4 -9.3 L 16.4 -2.0 L 21.8 -2.0 L 23.5 -2.7 L 24.9 -4.0 L 25.6 -5.5 L 25.5 -8.2 L 24.6 -9.9 L 22.8 -11.1 L 20.7 -11.6 L 15.8 -11.6 M 14.8 -10.5 L 14.8 4.7 M 26.1 -10.0 L 27.0 -8.6 L 27.5 -7.3 L 27.5 -6.2 L 27.0 -4.7 L 26.1 -3.5","0 20.6 M 14.5 13.6 L 13.0 13.4 L 12.1 12.2 L 11.8 10.0 L 12.3 8.1 L 14.2 6.7 L 19.0 4.8 L 21.7 3.0 L 23.6 -.1 L 24.3 -2.7 L 24.1 -5.8 L 23.5 -8.5 L 22.6 -10.2 L 21.0 -11.6 L 18.7 -12.2 M 13.9 -10.1 L 12.8 -7.2 L 12.6 -3.7 L 13.0 -.6 L 13.6 2.2 L 15.7 4.0 M 14.4 5.3 L 12.2 3.7 L 10.1 .7 L 9.5 -2.1 L 9.6 -5.8 L 10.8 -9.4 L 12.9 -11.9 L 16.5 -13.5 L 19.8 -13.5 L 22.7 -12.8 L 25.3 -11.0 L 27.2 -8.2 L 27.9 -4.9 L 27.5 -1.0 L 26.3 1.7 L 24.1 4.0 L 21.6 5.4 L 14.9 8.0 M 11.9 .6 L 11.2 -1.5 L 11.1 -4.5 L 11.5 -7.0 L 11.9 -8.4 M 24.4 -9.7 L 25.7 -6.9 L 25.9 -4.0 L 25.8 -1.7 L 24.9 .8 M 14.4 12.0 L 13.6 11.7 L 13.3 10.9 L 13.5 10.2 L 13.9 9.8 L 14.8 9.9 L 16.1 10.8 L 17.5 11.9 L 18.8 12.7 L 20.6 13.8 L 21.6 13.9 L 22.7 13.8 L 24.4 13.1 L 25.5 11.7 L 26.1 10.0 L 26.2 9.5 L 26.2 7.2 M 24.7 7.2 L 24.7 9.2 L 24.2 10.3 L 23.6 10.7 L 22.7 11.1 L 21.8 11.0 L 20.5 10.4 L 17.1 8.6 L 16.3 8.5 M 18.8 11.0 L 20.7 12.0 L 22.0 12.4 L 23.2 12.2","0 23.8 M 9.3 5.9 L 20.7 5.9 M 20.7 4.7 L 17.3 4.7 L 16.8 4.2 L 16.8 -1.3 M 23.7 -1.7 L 26.7 -2.7 L 28.5 -4.2 L 29.6 -6.1 L 29.5 -8.3 L 28.7 -10.2 L 26.2 -11.9 L 24.3 -12.7 L 21.1 -13.1 L 9.2 -13.1 M 9.1 -11.7 L 12.8 -11.7 L 13.2 -11.2 L 13.2 4.0 L 12.6 4.7 L 9.4 4.7 M 15.0 4.5 L 15.0 -10.8 M 16.0 -11.5 L 21.0 -11.5 L 22.5 -11.3 L 23.6 -10.9 L 24.7 -10.2 L 25.6 -9.1 L 25.8 -7.3 L 25.6 -5.5 L 24.2 -4.0 L 22.5 -3.3 L 20.7 -3.2 L 16.8 -3.2 L 16.8 -9.3 M 26.8 -9.6 L 27.7 -7.8 L 27.7 -6.4 L 27.1 -4.8 L 26.6 -4.2 M 17.7 -1.5 L 20.1 -1.5 L 21.0 -1.0 L 21.6 -.3 L 22.6 .9 L 25.4 5.0 L 26.4 5.9 L 27.1 6.3 L 28.6 6.3 L 30.1 6.0 L 31.8 5.7 M 31.9 4.4 L 30.2 4.8 L 29.6 4.8 L 28.3 3.4 L 26.0 .0 L 25.3 -.8 L 24.8 -1.0 M 23.9 .2 L 25.1 1.5 L 26.4 3.7 L 27.0 4.5 L 27.4 4.8","0 18.3 M 10.8 7.3 L 10.8 4.3 M 9.4 7.4 L 9.4 -1.7 M 10.9 -1.7 L 10.9 .3 L 11.5 2.0 L 12.7 3.2 L 14.8 4.4 L 18.1 4.8 L 20.6 3.9 L 21.7 2.7 L 21.8 1.4 L 21.4 .2 L 20.0 -.7 L 16.1 -2.5 L 12.8 -4.4 L 10.8 -6.6 L 10.1 -8.5 L 10.5 -10.3 L 12.3 -12.3 L 14.1 -13.0 L 16.8 -13.4 L 18.3 -13.4 L 20.0 -12.9 M 22.0 -14.4 L 22.0 -11.6 M 23.5 -14.4 L 23.7 -6.5 M 22.1 -6.6 L 22.1 -8.6 L 21.4 -9.9 L 20.3 -11.1 L 18.9 -11.6 L 17.2 -11.9 L 15.6 -11.7 L 13.8 -10.9 L 13.2 -9.6 L 14.1 -7.7 L 15.6 -6.7 L 20.4 -4.3 L 22.3 -3.3 L 24.3 -1.5 L 25.2 .8 L 24.7 3.3 L 23.2 4.7 L 21.4 5.7 L 19.0 6.3 L 15.7 6.3 L 12.8 5.5 M 23.1 2.8 L 23.6 1.5 L 23.4 .2 L 22.4 -1.0 L 20.8 -2.1 L 15.3 -4.9 L 13.7 -5.9 L 12.5 -7.2 L 11.9 -8.6 L 12.0 -9.1","0 20.3 M 11.9 6.2 L 24.5 6.2 M 24.5 4.8 L 20.6 4.8 L 20.1 4.4 L 20.1 -9.3 M 20.0 -11.5 L 25.5 -11.5 L 26.5 -10.4 L 26.8 -6.2 M 28.2 -6.2 L 27.4 -14.7 M 26.5 -13.1 L 11.8 -13.1 M 9.4 -14.8 L 8.5 -6.0 M 10.0 -8.2 L 10.3 -9.9 L 10.9 -10.9 L 11.7 -11.2 L 16.6 -11.2 L 16.6 4.2 L 16.2 4.8 L 12.0 4.8 M 18.4 4.4 L 18.4 -11.3","0 23.8 M 9.3 -11.8 L 12.5 -11.8 L 12.9 -11.1 L 12.9 .9 L 13.6 2.9 L 14.8 4.5 L 16.1 5.6 L 17.6 6.3 L 19.4 6.7 L 21.5 6.7 L 24.0 6.1 L 25.6 5.0 L 26.9 3.3 L 27.5 2.1 L 27.8 .4 L 27.8 -11.0 L 28.4 -11.6 L 31.7 -11.6 M 31.8 -13.2 L 22.2 -13.2 M 22.1 -11.8 L 25.2 -11.8 L 26.0 -11.3 L 26.0 1.0 L 25.4 2.3 L 24.3 3.7 L 23.0 4.7 L 21.3 5.2 L 19.6 5.2 L 18.0 4.6 L 17.1 3.8 L 16.5 2.5 M 15.1 2.3 L 14.5 1.0 L 14.6 -.8 L 14.6 -11.5 M 9.2 -13.1 L 20.4 -13.1 M 20.4 -11.6 L 16.9 -11.6 L 16.4 -11.2 L 16.4 -1.5","0 23.3 M 8.8 -11.8 L 11.7 -11.8 L 19.1 6.5 L 20.7 6.5 L 27.8 -11.1 L 28.5 -11.7 L 31.1 -11.8 M 31.1 -13.2 L 21.3 -13.2 M 21.3 -11.7 L 25.5 -11.7 L 26.0 -11.2 L 20.8 2.0 M 20.1 .2 L 15.3 -11.8 L 17.9 -11.8 M 17.9 -13.1 L 8.5 -13.1 M 13.9 -10.9 L 19.8 3.5","0 35.1 M 8.4 -11.8 L 11.1 -11.8 L 18.7 6.5 L 20.4 6.5 L 25.1 -5.0 M 25.5 -6.9 L 30.9 6.4 L 32.5 6.4 L 39.7 -11.2 L 40.1 -11.7 L 42.9 -11.7 M 42.9 -13.2 L 33.2 -13.2 M 33.4 -11.7 L 36.9 -11.7 L 37.6 -11.7 L 37.7 -10.9 L 32.6 1.9 M 32.0 .1 L 27.1 -11.9 L 30.7 -11.9 M 30.8 -13.1 L 20.6 -13.1 M 20.6 -11.7 L 23.4 -11.7 L 24.7 -8.7 L 20.3 2.1 M 19.8 .2 L 14.9 -11.7 L 16.2 -11.7 M 16.4 -13.1 L 8.4 -13.1 M 13.5 -10.8 L 19.1 2.9 M 25.7 -10.9 L 31.2 2.8","0 22.6 M 8.2 6.2 L 17.9 6.2 M 19.0 6.1 L 30.5 6.1 M 30.4 4.8 L 27.4 4.8 L 21.3 -4.6 L 25.9 -11.5 L 26.7 -11.9 L 29.3 -11.9 M 29.3 -13.2 L 19.5 -13.2 M 19.6 -11.8 L 23.0 -11.8 L 23.3 -11.3 L 20.2 -6.2 M 19.3 -7.4 L 16.2 -11.8 L 18.0 -11.8 M 18.1 -13.2 L 9.3 -13.2 M 9.3 -11.8 L 12.1 -11.8 L 17.6 -4.0 L 11.6 4.7 L 8.1 4.7 M 18.5 -2.6 L 14.6 3.5 L 14.4 4.2 L 14.7 4.7 L 17.7 4.7 M 19.2 4.7 L 22.3 4.7 L 22.7 4.1 L 19.2 -1.3 M 15.2 -10.6 L 25.2 4.6 L 24.5 4.6 L 24.5 3.3","0 22.6 M 13.3 6.1 L 26.2 6.1 M 26.2 4.8 L 21.8 4.8 L 21.4 4.4 L 21.4 -.5 L 27.0 -11.3 L 27.7 -11.7 L 30.5 -11.7 M 30.3 -13.2 L 20.7 -13.2 M 20.7 -11.7 L 24.3 -11.7 L 24.9 -11.1 L 20.4 -2.3 M 19.3 -4.8 L 15.7 -11.8 L 18.2 -11.8 M 18.3 -13.3 L 8.5 -13.3 M 8.5 -11.8 L 11.9 -11.8 L 12.3 -11.0 L 18.1 .1 L 18.1 4.3 L 17.6 4.8 L 13.2 4.8 M 19.7 4.6 L 19.7 -.1 L 14.3 -11.0","0 21.4 M 8.5 5.9 L 26.8 5.9 L 26.8 8.7 M 28.3 8.7 L 28.5 -.1 M 27.2 1.6 L 26.9 3.2 L 26.5 3.9 L 25.8 4.2 L 14.4 4.2 M 16.2 1.9 L 27.1 -11.6 L 28.6 -11.6 M 28.6 -13.0 L 11.3 -13.0 L 11.3 -15.0 M 9.7 -14.8 L 9.2 -6.1 M 10.7 -8.2 L 11.0 -9.9 L 12.4 -11.2 L 22.7 -11.2 M 20.9 -9.1 L 9.9 4.6 L 8.7 4.6 M 12.3 4.3 L 24.7 -11.4","0 10.6 M 19.3 11.2 L 13.8 11.2 L 12.5 10.6 L 11.1 9.3 L 10.4 7.1 L 11.0 4.1 L 12.4 .2 L 9.2 -2.8 M 8.3 -3.5 L 12.1 -6.5 L 12.2 -7.1 L 11.1 -11.5 L 10.7 -13.5 L 10.9 -15.3 L 11.9 -17.0 L 14.0 -18.0 L 18.9 -18.1 M 18.7 -16.7 L 15.8 -16.7 L 14.6 -16.7 L 13.9 -16.0 L 13.5 -14.9 L 13.8 -13.2 L 15.5 -7.9 L 15.4 -7.1 L 10.8 -3.5 L 14.9 -.3 L 15.3 .2 L 15.4 1.3 L 13.6 6.6 L 13.4 7.7 L 13.9 8.9 L 14.5 9.6 L 15.6 9.9 L 19.3 9.9 M 12.2 7.6 L 12.1 6.2 L 13.6 1.1 L 13.6 .6 M 13.8 -7.6 L 13.7 -8.2 L 12.0 -13.9 M 19.1 11.1 L 13.6 11.1 L 12.3 10.5 L 10.9 9.3 L 10.2 7.0 L 10.8 4.0 L 12.2 .1 L 9.0 -2.9 M 8.1 -3.5 L 11.9 -6.6 L 12.0 -7.1 L 10.9 -11.5 L 10.5 -13.5 L 10.7 -15.3 L 11.8 -17.1 L 13.8 -18.0 L 18.7 -18.1 M 18.5 -16.7 L 15.6 -16.7 L 14.4 -16.8 L 13.7 -16.0 L 13.3 -15.0 L 13.6 -13.2 L 15.3 -8.0 L 15.2 -7.2 L 10.6 -3.5 L 14.7 -.4 L 15.1 .1 L 15.2 1.3 L 13.5 6.6 L 13.2 7.7 L 13.8 8.9 L 14.3 9.6 L 15.4 9.9 L 19.1 9.9 M 12.0 7.6 L 11.9 6.2 L 13.5 1.1 L 13.5 .5 M 13.6 -7.6 L 13.5 -8.2 L 11.8 -14.0","0 5.5 M 9.9 -17.7 L 9.9 10.5 M 10.7 10.5 L 11.2 10.5 L 11.2 -17.6","0 10.8 M 8.2 11.1 L 13.8 11.1 L 15.1 10.5 L 16.4 9.3 L 17.1 7.0 L 16.5 4.0 L 15.2 .1 L 18.4 -2.9 M 19.2 -3.5 L 15.4 -6.6 L 15.4 -7.1 L 16.5 -11.5 L 16.8 -13.5 L 16.7 -15.3 L 15.6 -17.1 L 13.6 -18.0 L 8.6 -18.1 M 8.8 -16.7 L 11.7 -16.7 L 12.9 -16.8 L 13.7 -16.0 L 14.0 -15.0 L 13.7 -13.2 L 12.1 -8.0 L 12.1 -7.2 L 16.7 -3.5 L 12.7 -.4 L 12.3 .1 L 12.1 1.3 L 13.9 6.6 L 14.2 7.7 L 13.6 8.9 L 13.1 9.6 L 12.0 9.9 L 8.2 9.9 M 15.3 7.6 L 15.4 6.2 L 13.9 1.1 L 13.9 .5 M 13.8 -7.6 L 13.8 -8.2 L 15.5 -14.0 M 8.2 11.1 L 13.8 11.1 L 15.1 10.5 L 16.4 9.3 L 17.1 7.0 L 16.5 4.0 L 15.2 .1 L 18.4 -2.9 M 19.2 -3.5 L 15.4 -6.6 L 15.4 -7.1 L 16.5 -11.5 L 16.8 -13.5 L 16.7 -15.3 L 15.6 -17.1 L 13.6 -18.0 L 8.6 -18.1 M 8.8 -16.7 L 11.7 -16.7 L 12.9 -16.8 L 13.7 -16.0 L 14.0 -15.0 L 13.7 -13.2 L 12.1 -8.0 L 12.1 -7.2 L 16.7 -3.5 L 12.7 -.4 L 12.3 .1 L 12.1 1.3 L 13.9 6.6 L 14.2 7.7 L 13.6 8.9 L 13.1 9.6 L 12.0 9.9 L 8.2 9.9 M 15.3 7.6 L 15.4 6.2 L 13.9 1.1 L 13.9 .5 M 13.8 -7.6 L 13.8 -8.2 L 15.5 -14.0","0 18.8 M 9.6 -2.6 L 10.6 -5.7 L 11.6 -6.8 L 13.0 -7.0 L 15.4 -6.1 L 18.0 -4.7 L 21.2 -3.1 L 22.0 -2.9 L 22.5 -3.1 L 23.5 -5.6 M 25.0 -5.2 L 24.1 -2.1 L 22.9 -.9 L 21.8 -.5 L 20.2 -.8 L 15.6 -3.2 L 13.4 -4.5 L 12.3 -4.6 L 11.7 -4.0 L 11.4 -3.0 L 11.2 -2.1 M 12.4 -5.8 L 12.6 -5.8 L 14.1 -5.4 L 16.4 -4.3 L 19.2 -2.7 L 21.1 -1.9 L 22.3 -1.9","0 9.2 M 12.7 -7.4 L 12.8 -7.3 L 14.4 -7.7 L 15.7 -8.9 L 16.2 -10.7 L 16.0 -12.6 L 14.7 -14.4 L 12.9 -15.0 L 10.4 -14.5 L 9.0 -12.6 L 8.8 -10.2 L 9.8 -8.3 L 11.1 -7.2 L 12.7 -7.4 M 12.6 -8.5 L 13.8 -9.6 L 13.9 -11.8 L 13.3 -13.0 L 12.5 -13.4 L 11.7 -13.2 L 11.1 -12.2 L 11.1 -9.5 L 11.9 -8.8 L 12.6 -8.5"]
EMSNeato = ["-8 8","0 10.5 M 16.5 -27.8 L 15.2 -17.6 L 13.4 -6.3 L 11.4 1.8 M 11.4 6.7 L 10.5 8.1 L 11.8 8.3 L 11.4 6.7","0 8.7 M 13.8 -24.2 L 12.4 -20.2 L 12.3 -19.4 M 17.0 -24.0 L 15.5 -20.3 L 15.5 -19.9","0 22.8 M 17.7 -19.0 L 16.9 -16.7 L 17.0 -14.3 L 15.8 -8.6 L 14.2 -3.1 L 12.4 5.0 M 24.4 -18.6 L 23.0 -14.4 L 21.8 -9.0 L 21.0 -2.6 L 19.3 5.0 M 9.9 -10.2 L 13.4 -11.2 L 17.1 -11.5 L 30.6 -11.1 M 8.5 -3.8 L 15.7 -4.8 L 27.8 -5.0","0 22.2 M 26.7 -19.2 L 25.0 -22.2 L 21.8 -23.6 L 18.9 -21.9 L 17.9 -17.7 L 19.0 -13.2 L 21.4 -7.6 L 23.4 -2.1 L 22.6 3.8 L 20.1 6.4 L 16.9 7.5 L 13.2 7.1 L 9.4 4.7 L 8.4 1.6 L 9.2 -1.8 L 12.0 -5.1 M 24.2 -26.0 L 20.4 -13.1 L 13.9 9.5","0 16.7 M 11.6 -22.7 L 9.7 -20.3 L 10.6 -17.3 L 13.4 -16.8 L 15.7 -18.6 L 15.7 -21.6 L 13.7 -23.0 L 11.6 -22.7 M 18.9 1.3 L 17.0 3.7 L 18.0 6.7 L 20.7 7.1 L 23.0 5.4 L 23.0 2.4 L 21.0 1.0 L 18.9 1.3 M 21.9 -23.0 L 10.5 8.9","0 25.0 M 26.5 -20.3 L 24.4 -22.5 L 20.7 -23.5 L 17.3 -23.0 L 15.0 -21.3 L 14.2 -19.0 L 15.1 -16.1 L 17.3 -13.9 L 19.3 -12.9 L 20.6 -12.8 L 20.7 -13.1 L 19.5 -13.7 L 16.0 -13.1 L 12.3 -10.1 L 10.6 -6.7 L 10.5 -1.4 L 12.1 3.1 L 15.5 6.2 L 20.0 7.6 L 25.1 6.6 L 29.5 3.0 L 31.3 -.2 L 31.4 -3.7 L 30.2 -6.1 L 29.0 -7.3 L 27.3 -8.4 M 23.0 .5 L 22.2 -1.5 L 23.1 -5.3 L 25.3 -7.5 L 28.7 -9.2 L 31.8 -10.2 L 33.4 -12.0 L 34.0 -13.7 L 33.7 -16.5","0 4.6 M 13.1 -24.7 L 12.4 -21.5 L 12.4 -19.2","0 9.5 M 21.6 -23.8 L 17.0 -19.0 L 13.4 -12.2 L 11.4 -6.1 L 10.6 .4 L 10.8 7.1 L 11.8 12.2 L 14.4 16.9","0 8.8 M 13.8 -23.2 L 15.5 -16.6 L 16.1 -10.9 L 14.9 -4.2 L 12.4 2.8 L 9.7 8.1 L 6.3 11.9 L 2.0 15.8","0 11.5 M 12.5 -19.5 L 15.2 -14.7 L 17.3 -12.1 M 10.7 -14.6 L 12.4 -15.6 L 14.8 -16.4 L 18.3 -16.4 M 12.4 -12.3 L 16.9 -19.5","0 14.1 M 15.6 -8.3 L 15.2 -4.0 L 14.3 .4 L 14.3 2.0 M 9.9 -2.5 L 12.3 -3.3 L 16.3 -3.4 L 18.3 -3.1 L 20.1 -3.2","0 5.5 M 9.2 7.3 L 9.7 6.3 L 10.4 8.0 L 8.7 11.6 L 7.7 13.1","0 14.0 M 10.1 -1.7 L 12.4 -1.9 L 15.6 -1.1 L 17.2 -1.4 L 19.4 -2.3","0 4.8 M 10.1 6.4 L 9.5 7.7 L 11.0 7.7 L 10.4 6.6","0 13.0 M 23.9 -25.0 L 22.8 -23.9 L 22.4 -21.5 L 22.0 -19.2 L 5.0 22.0","0 15.1 M 20.6 -6.8 L 19.5 -7.4 L 18.1 -8.6 L 14.6 -8.1 L 12.0 -5.5 L 10.7 -1.9 L 10.5 2.3 L 11.6 6.5 L 14.7 7.6 L 17.7 6.1 L 19.9 2.8 L 20.7 -.5 L 20.9 -3.0 L 20.3 -5.4","0 11.8 M 9.3 .4 L 11.9 -2.4 L 13.4 -4.6 L 15.1 -7.8 L 13.2 -.5 L 12.4 4.2 L 12.2 7.2 M 7.3 7.3 L 17.9 7.2","0 16.9 M 10.5 -4.6 L 11.7 -6.6 L 14.0 -8.0 L 16.4 -8.4 L 18.5 -8.2 L 20.4 -6.3 L 19.6 -2.2 L 16.6 2.1 L 14.0 4.8 L 12.6 6.5 L 10.0 7.4 L 8.3 6.9 L 7.8 5.7 L 9.2 3.6 L 11.8 4.2 L 13.9 5.0 L 17.5 6.8 L 19.8 7.3 L 21.2 6.4 L 21.8 4.8 L 22.2 2.6","0 15.0 M 10.2 -4.9 L 12.0 -6.9 L 15.6 -8.3 L 18.7 -8.0 L 20.5 -5.7 L 19.5 -2.5 L 17.7 -.3 L 15.6 1.6 L 12.0 3.2 L 15.3 2.4 L 17.9 2.9 L 20.0 5.3 L 21.6 9.1 L 20.8 13.8 L 18.7 17.9 L 14.1 20.4 L 8.9 20.4 L 4.5 18.7 L 2.3 16.1 L 2.1 12.2","0 16.8 M 23.2 7.1 L 22.0 7.4 L 9.7 7.6 L 14.0 2.2 L 17.3 -1.3 L 18.9 -3.8 L 21.6 -8.0 L 21.0 -6.5 L 20.5 .1 L 19.1 8.6 L 18.0 14.6 L 17.1 20.6","0 21.3 M 29.1 -8.5 L 26.7 -6.8 L 20.2 -6.8 L 19.4 -6.9 L 17.2 -7.9 L 16.9 -5.1 L 15.5 -.8 L 13.6 3.4 L 12.0 5.7 L 15.5 3.6 L 18.7 3.2 L 21.7 3.5 L 24.9 5.4 L 26.7 8.3 L 27.5 12.4 L 26.2 16.7 L 23.2 19.7 L 19.2 20.8 L 13.4 20.1 L 9.6 16.9 L 8.5 14.3 L 8.7 12.2","0 18.1 M 26.3 -19.0 L 25.1 -21.5 L 22.8 -23.3 L 19.9 -23.6 L 16.4 -21.1 L 13.6 -15.8 L 11.5 -9.2 L 10.4 -2.3 L 10.4 2.7 L 11.8 5.9 L 15.9 7.7 L 19.6 5.9 L 21.9 2.4 L 22.7 -2.3 L 22.5 -5.5 L 20.7 -8.0 L 17.9 -9.0 L 14.9 -8.0 L 13.2 -6.2 L 11.4 -4.1 L 10.4 -1.1","0 15.3 M 9.5 -7.7 L 12.2 -8.2 L 20.9 -7.8 L 21.5 -7.1 L 18.1 -1.2 L 15.3 6.3 L 10.5 20.2 L 10.1 20.9 M 9.1 7.1 L 20.2 7.2","0 16.6 M 18.7 -23.3 L 16.0 -22.5 L 14.4 -20.5 L 14.1 -17.3 L 14.8 -14.3 L 16.2 -11.8 L 19.3 -6.8 L 20.4 -4.3 L 21.7 -.3 L 21.7 3.4 L 19.7 6.1 L 16.7 7.6 L 14.0 7.5 L 11.2 5.9 L 9.7 3.0 L 9.7 .0 L 10.9 -3.5 L 14.9 -7.7 L 21.6 -14.1 L 22.8 -16.6 L 22.7 -19.2 L 22.0 -21.5 L 21.1 -22.9 L 20.0 -23.1 L 18.7 -23.3","0 15.2 M 22.5 -6.7 L 19.3 -8.2 L 13.9 -6.9 L 11.0 -3.7 L 9.6 -.3 L 9.7 3.6 L 11.3 6.5 L 13.9 7.1 L 16.9 5.9 L 19.9 3.0 L 21.6 -.5 L 22.5 -4.2 L 22.6 -6.0 L 21.9 -5.6 L 19.7 4.7 L 18.7 10.6 L 17.0 15.5 L 14.1 19.7 L 11.4 21.2 L 7.6 21.2 L 5.4 19.5 L 3.5 16.7","0 7.7 M 12.0 -5.9 L 11.8 -4.5 L 13.4 -4.6 L 13.4 -6.0 L 12.0 -5.9 M 9.0 5.9 L 9.1 7.3 L 10.5 7.1 L 10.6 5.8 L 9.0 5.9","0 8.3 M 11.9 -6.2 L 11.8 -4.6 L 13.3 -4.6 L 13.5 -6.1 L 11.9 -6.2 M 9.2 7.0 L 9.3 5.9 L 10.6 6.3 L 10.5 8.3 L 8.8 11.2 L 7.8 12.0","0 15.3 M 20.7 -7.9 L 16.8 -4.0 L 14.1 -2.1 L 13.3 -1.1 L 13.3 .4 L 17.0 5.3","0 14.7 M 9.9 -3.7 L 11.3 -4.5 L 16.1 -4.5 L 18.8 -4.5 M 10.5 .5 L 12.3 -.5 L 15.1 -.7 L 20.3 -.6","0 14.8 M 16.1 -5.8 L 18.3 -2.5 L 19.6 -1.3 L 20.6 -.5 L 15.8 4.3 L 13.8 5.5","0 14.8 M 10.0 -16.3 L 9.6 -18.2 L 10.3 -20.8 L 12.0 -22.5 L 14.5 -23.4 L 17.5 -23.7 L 19.8 -22.5 L 21.5 -19.7 L 21.4 -15.6 L 20.4 -12.5 L 18.3 -10.0 L 16.7 -7.2 L 15.3 -5.2 L 14.3 -1.1 L 13.9 2.1 M 12.9 6.1 L 12.6 7.3 L 13.7 7.5 L 13.9 6.2 L 12.9 6.1","0 27.9 M 25.0 -13.7 L 23.4 -14.5 L 21.9 -14.3 L 19.9 -12.3 L 18.2 -7.8 L 17.6 -3.4 L 17.5 .3 L 18.2 2.0 L 19.7 2.2 L 21.7 .3 L 23.4 -3.5 L 25.4 -9.0 L 25.9 -9.3 L 25.9 -3.3 L 26.8 .2 L 28.8 .8 L 32.1 -.9 L 34.7 -4.6 L 35.1 -8.3 L 34.6 -12.8 L 33.0 -17.0 L 29.5 -20.7 L 25.3 -22.3 L 21.2 -22.1 L 15.4 -19.9 L 10.9 -14.6 L 9.3 -8.9 L 9.1 -3.6 L 10.6 2.4 L 13.9 6.9 L 18.9 9.5 L 25.0 9.6 L 28.9 7.9 L 32.1 5.1 L 34.9 1.6","0 23.2 M 6.5 7.2 L 10.5 5.2 L 14.0 1.6 L 17.5 -3.7 L 23.6 -14.6 L 26.6 -20.4 L 27.4 -23.1 L 26.2 -16.1 L 25.5 -10.1 L 25.7 -3.7 L 26.2 2.2 L 27.4 7.2 M 11.7 -1.9 L 17.3 -1.5 L 23.6 -1.7 L 28.1 -1.1","0 17.7 M 8.9 9.1 L 16.0 -23.3 M 13.1 -21.6 L 14.9 -22.9 L 18.3 -23.1 L 20.5 -21.9 L 22.8 -18.8 L 23.1 -14.9 L 21.8 -12.3 L 19.1 -9.9 L 16.7 -8.9 L 14.3 -8.4 L 11.3 -8.2 L 17.1 -8.1 L 19.9 -7.1 L 22.3 -4.3 L 23.4 -1.9 L 23.3 1.4 L 21.5 3.8 L 18.3 6.1 L 14.2 7.2 L 10.8 7.3 L 8.0 7.0 L 6.2 6.1","0 17.3 M 26.4 -17.6 L 26.1 -20.1 L 23.8 -23.0 L 21.1 -23.7 L 18.7 -23.1 L 15.6 -19.4 L 12.8 -14.4 L 11.0 -8.5 L 9.7 -3.0 L 10.3 2.6 L 12.3 6.1 L 15.0 7.6 L 17.9 7.2 L 22.2 4.4","0 22.9 M 9.7 8.9 L 13.4 -8.9 L 17.6 -23.0 M 12.5 -20.7 L 15.2 -22.5 L 18.8 -23.3 L 22.6 -23.2 L 25.5 -22.1 L 28.2 -19.0 L 29.3 -13.0 L 28.8 -8.2 L 27.4 -2.9 L 24.9 1.5 L 20.1 5.4 L 15.4 7.1 L 11.9 7.5 L 9.0 7.3 L 6.6 6.7","0 18.6 M 8.6 7.3 L 10.2 2.4 L 15.7 -23.2 M 14.5 -21.9 L 18.8 -23.2 L 23.9 -23.5 L 27.8 -23.2 M 12.9 -8.5 L 22.5 -8.5 M 8.8 7.3 L 24.6 7.5","0 16.1 M 11.0 7.9 L 13.3 -3.0 L 16.6 -23.2 M 8.1 -17.6 L 14.0 -20.3 L 20.1 -21.7 L 26.5 -22.5 L 34.6 -23.1 M 11.2 -9.0 L 11.5 -9.0 L 15.5 -9.2 L 18.7 -9.7 L 24.4 -9.6","0 22.1 M 27.6 -17.4 L 26.5 -20.4 L 24.5 -22.5 L 21.5 -23.3 L 18.3 -21.9 L 15.1 -18.4 L 11.9 -12.5 L 10.5 -7.5 L 9.6 -2.3 L 10.0 2.7 L 13.1 6.9 L 18.8 7.6 L 23.4 5.8 L 25.1 4.4 L 26.4 .3 L 21.4 -4.4 L 19.7 -5.0 L 17.4 -4.2 L 16.5 -3.4 L 19.1 -3.7 L 30.3 -6.6 L 26.5 .0 L 24.1 7.9 L 22.0 15.9 L 21.2 22.0","0 23.6 M 16.0 -23.4 L 16.0 -23.1 L 15.0 -13.7 L 13.0 -4.1 L 9.5 8.3 M 30.4 -23.6 L 28.4 -12.7 L 26.9 -2.1 L 25.7 4.0 L 25.3 7.6 M 4.0 -1.5 L 4.4 -2.9 L 7.7 -5.8 L 10.9 -7.1 L 16.1 -8.7 L 21.6 -9.6 L 29.9 -10.2 L 36.1 -10.2","0 12.2 M 9.9 7.1 L 16.5 7.3 M 12.9 7.3 L 19.8 -23.1 M 16.2 -23.2 L 23.0 -23.1","0 16.9 M 6.5 1.3 L 8.5 5.6 L 11.1 7.7 L 14.7 7.5 L 17.7 5.2 L 19.6 1.2 L 21.1 -4.5 L 24.9 -22.9 L 24.1 -23.1 L 22.9 -22.4 L 21.5 -22.3 L 16.3 -23.5","0 20.9 M 8.7 7.5 L 15.6 -23.6 M 28.0 -23.3 L 11.4 -4.8 L 13.6 -7.1 L 14.7 -1.1 L 16.6 3.1 L 19.6 6.1 L 22.6 7.4 L 25.0 7.3 L 26.8 5.6","0 15.1 M 15.9 -22.9 L 13.5 -11.4 L 11.6 -2.5 L 10.2 4.1 L 8.8 6.8 L 16.7 7.5 L 21.3 7.2","0 28.5 M 8.8 7.3 L 15.7 -22.9 L 21.4 1.9 L 34.0 -23.1 L 33.0 7.5","0 21.9 M 9.0 7.4 L 15.5 -22.8 L 23.7 7.3 L 29.8 -23.3","0 20.2 M 22.7 -19.4 L 19.8 -20.7 L 16.2 -20.0 L 12.6 -15.2 L 10.8 -10.9 L 9.8 -4.3 L 9.6 .1 L 10.8 5.1 L 13.6 7.9 L 16.8 7.5 L 20.8 5.3 L 23.7 .8 L 25.8 -4.0 L 27.1 -11.3 L 27.1 -17.3 L 25.9 -20.5 L 24.5 -22.4 L 23.4 -23.3 L 20.5 -23.7","0 17.8 M 10.5 7.0 L 17.2 -23.8 M 13.2 -21.1 L 14.8 -22.9 L 17.1 -23.5 L 19.7 -23.3 L 22.5 -21.9 L 24.7 -18.8 L 25.2 -14.2 L 23.7 -9.5 L 21.5 -6.9 L 18.1 -5.2 L 14.6 -5.3 L 10.3 -6.8","0 21.5 M 19.3 -23.5 L 22.2 -23.9 L 25.9 -21.9 L 27.9 -17.1 L 27.9 -9.8 L 24.9 -.3 L 22.1 4.2 L 18.2 7.4 L 15.9 7.9 L 13.0 7.7 L 10.9 5.0 L 9.7 -2.5 L 10.3 -9.9 L 12.5 -15.6 L 15.6 -19.9 L 18.2 -21.0 L 19.9 -21.3 L 22.0 -21.0 M 13.2 7.9 L 17.3 12.5 L 23.4 16.6 L 29.2 18.7 L 34.8 19.1 L 44.4 17.5","0 15.5 M 9.0 7.2 L 15.9 -24.3 M 12.1 -20.7 L 14.2 -22.6 L 17.7 -23.5 L 21.0 -22.7 L 23.1 -20.4 L 24.0 -16.2 L 23.5 -12.8 L 22.2 -9.9 L 19.8 -7.7 L 17.4 -6.8 L 16.5 -6.6 L 14.2 -7.2 L 14.9 .6 L 17.2 7.5 L 20.1 12.1 L 24.5 15.1 L 29.9 16.8 L 35.6 16.1 L 39.7 14.0 L 42.6 11.4","0 18.4 M 11.7 -5.1 L 9.2 -1.7 L 8.4 2.9 L 12.0 7.1 L 18.2 7.5 L 21.2 5.5 L 23.4 1.8 L 23.2 -2.7 L 22.3 -5.6 L 18.2 -16.0 L 18.0 -20.1 L 19.4 -22.7 L 22.0 -23.5 L 24.3 -22.8 L 25.6 -21.5 L 26.3 -19.2","0 19.4 M 14.4 8.3 L 14.5 8.0 L 17.2 -6.7 L 21.1 -24.3 M 11.6 -22.8 L 25.1 -23.0 L 30.5 -23.5","0 21.2 M 15.2 -23.2 L 11.8 -6.6 L 10.5 .4 L 10.3 3.5 L 12.1 6.3 L 15.6 7.5 L 19.2 6.6 L 21.7 4.9 L 23.3 1.4 L 29.4 -23.0","0 17.9 M 11.5 -23.1 L 16.0 7.3 L 18.9 2.8 L 22.2 -3.1 L 25.2 -9.8 L 26.6 -14.3 L 26.8 -18.5 L 26.7 -20.8 L 26.3 -24.5","0 25.6 M 10.9 -23.0 L 10.9 -16.9 L 12.0 -8.6 L 12.8 -1.5 L 13.3 7.3 L 15.8 3.4 L 18.1 -2.0 L 21.6 -12.1 L 23.0 -17.5 L 23.2 -20.5 L 22.9 -22.3 L 22.0 -21.9 L 22.2 -16.9 L 22.4 -7.4 L 22.8 .1 L 23.4 3.0 L 25.6 7.1 L 29.5 -.9 L 32.6 -8.9 L 33.6 -14.8 L 33.8 -19.6 L 32.8 -23.6 L 31.1 -27.2 L 28.6 -30.2 L 25.3 -32.0 L 23.1 -32.2 L 21.5 -31.1 L 21.0 -29.5","0 20.9 M 7.0 7.9 L 19.2 -9.4 L 30.0 -23.3 M 14.9 -23.7 L 22.0 .4 L 24.8 7.7","0 14.8 M 14.2 6.4 L 16.1 -2.7 L 19.2 -11.3 L 22.6 -18.7 L 24.0 -21.3 L 25.7 -23.3 M 11.8 -23.2 L 12.6 -15.2 L 14.1 -8.5 L 15.3 -4.7 L 16.1 -3.3 M 10.2 8.6 L 13.1 7.5 L 16.5 7.2 L 19.1 7.5","0 15.8 M 11.0 -23.1 L 16.7 -22.9 L 23.2 -23.5 L 27.5 -23.5 L 19.5 -11.0 L 11.6 -.2 L 7.1 6.7 L 9.8 5.9 L 12.0 6.7 L 15.1 9.7 L 19.2 12.9 L 22.6 14.6 L 26.1 15.4 L 29.5 14.9 L 32.6 13.6 L 35.1 11.4","0 9.2 M 20.2 -22.8 L 16.2 -23.2 L 8.2 17.1 L 10.2 17.5 L 14.9 16.2","0 13.4 M 5.0 -25.0 L 22.2 16.3 L 22.5 18.3 L 22.7 20.4 L 23.9 22.0","0 10.9 M 6.3 15.6 L 11.7 16.7 L 14.4 16.5 L 22.5 -23.9 L 16.8 -23.4","0 16.8 M 11.8 -23.6 L 14.5 -25.2 L 21.8 -33.1 L 21.2 -31.7 L 22.6 -26.6 L 24.1 -24.3 L 26.2 -22.5","0 22.9 M 8.4 8.4 L 30.6 8.3","0 9.2 M 10.6 -32.7 L 11.1 -31.1 L 13.8 -27.0","0 15.0 M 19.7 -4.5 L 19.7 -6.9 L 18.8 -8.0 L 16.7 -7.5 L 13.6 -4.6 L 11.5 -1.1 L 9.7 2.8 L 9.1 5.8 L 9.9 7.0 L 11.0 7.1 L 13.7 4.8 L 16.7 .6 L 20.4 -5.6 L 18.9 .6 L 18.5 4.9 L 18.4 6.0 L 19.6 7.3","0 13.4 M 11.5 .2 L 13.3 -4.4 L 15.9 -7.6 L 18.0 -8.0 L 19.2 -5.2 L 18.0 1.7 L 16.6 5.0 L 14.7 7.2 L 13.0 7.4 L 11.6 6.1 L 10.9 3.6 L 12.2 -4.8 L 15.7 -22.9","0 11.0 M 16.0 5.3 L 14.1 7.3 L 11.4 7.5 L 9.7 5.3 L 10.2 -.3 L 12.0 -4.8 L 14.1 -7.4 L 15.8 -8.4 L 17.4 -8.4 L 18.0 -7.3 L 18.3 -6.1","0 14.5 M 18.4 -1.1 L 18.9 -4.7 L 18.5 -7.2 L 17.4 -8.1 L 14.0 -7.5 L 11.3 -4.2 L 9.7 .4 L 9.7 5.1 L 11.4 7.6 L 14.0 7.5 L 16.3 4.4 L 17.9 .4 L 20.0 -8.4 L 23.2 -22.8 L 17.3 4.1 L 17.3 6.2 L 17.5 7.5","0 11.0 M 10.6 .4 L 13.8 -.7 L 16.8 -2.8 L 17.5 -5.6 L 17.5 -7.1 L 16.4 -8.2 L 14.2 -7.9 L 11.5 -4.7 L 10.2 -.4 L 9.7 3.6 L 10.3 6.3 L 11.9 7.6 L 13.4 7.3 L 16.0 6.0","0 10.9 M -4.8 18.5 L -1.2 20.6 L 3.6 20.6 L 6.5 18.6 L 9.3 14.0 L 10.7 7.7 L 12.9 -6.9 L 14.0 -12.8 L 15.8 -17.0 L 18.7 -19.4 L 20.6 -19.6 L 22.4 -19.3 M 9.1 -7.8 L 18.1 -8.0","0 12.5 M 17.2 -1.1 L 15.8 3.2 L 13.6 6.5 L 11.9 7.5 L 10.6 7.0 L 9.5 5.0 L 9.7 2.7 L 10.7 -1.1 L 12.6 -5.0 L 14.8 -7.7 L 17.2 -8.4 L 18.7 -8.3 L 19.4 -7.6 L 19.6 -8.0 L 16.8 2.0 L 15.3 9.9 L 14.2 16.0 L 13.0 18.9 L 11.7 20.4 L 9.7 20.5 L 7.7 19.7 L 7.1 17.3 L 7.9 14.8 L 11.7 11.4 L 19.5 5.4","0 15.8 M 10.2 7.3 L 13.4 -8.4 L 15.5 -17.5 L 16.5 -22.7 L 11.0 3.3 L 14.3 -3.1 L 16.1 -6.2 L 18.9 -7.8 L 20.9 -7.0 L 20.8 -3.4 L 19.9 .2 L 18.9 7.1","0 6.8 M 11.9 6.6 L 10.6 7.5 L 9.6 7.0 L 12.7 -6.5 L 12.4 -8.6 M 13.4 -13.5 L 13.4 -12.5 L 14.3 -12.5 L 14.7 -13.6 L 13.4 -13.5","0 6.6 M -2.4 20.2 L 1.1 20.6 L 5.3 19.1 L 7.7 16.4 L 9.2 12.2 L 10.1 7.8 L 12.7 -8.3 M 13.3 -13.3 L 13.1 -12.7 L 13.9 -12.6 L 14.0 -13.3 L 13.3 -13.3","0 14.3 M 9.7 7.7 L 16.4 -22.9 L 12.1 -2.5 L 13.4 -6.0 L 15.1 -7.8 L 17.0 -8.4 L 18.3 -6.8 L 18.1 -4.8 L 17.0 -3.1 L 15.1 -1.4 L 13.3 -.3 L 11.7 .8 L 11.8 -.9 L 13.6 2.7 L 15.4 5.7 L 17.0 7.1 L 19.0 7.7 L 20.2 7.0 L 21.5 5.7","0 8.6 M 15.8 -23.3 L 10.1 5.6 L 10.6 6.9 L 12.0 7.3 L 13.7 7.1 L 14.4 6.7","0 20.7 M 13.3 -8.4 L 12.3 -2.3 L 11.0 4.2 L 10.0 7.3 L 13.0 .3 L 15.7 -5.2 L 17.0 -6.9 L 18.6 -8.0 L 20.3 -8.3 L 21.4 -6.8 L 21.1 -4.0 L 18.8 1.4 L 17.5 5.5 L 17.4 7.3 L 21.0 -3.5 L 23.6 -6.8 L 26.0 -8.2 L 27.8 -8.1 L 28.0 -6.1 L 26.4 -.3 L 25.1 3.6 L 24.5 5.5 L 24.7 7.3","0 14.4 M 12.9 -8.0 L 10.0 6.8 L 13.6 -.5 L 15.9 -5.5 L 17.2 -7.4 L 18.5 -7.9 L 19.6 -7.5 L 20.4 -6.2 L 19.1 1.3 L 18.0 7.6","0 10.7 M 16.4 -8.1 L 13.5 -6.9 L 11.0 -3.1 L 9.8 .6 L 9.8 5.5 L 12.0 7.3 L 14.3 6.9 L 17.1 3.3 L 18.4 -.8 L 18.8 -4.3 L 18.6 -6.8 L 17.9 -7.6 L 16.4 -8.1","0 13.4 M 7.3 20.6 L 13.3 -8.5 L 11.3 1.4 L 13.6 -3.7 L 15.8 -7.0 L 18.0 -8.3 L 20.1 -7.7 L 20.5 -4.7 L 19.9 -.8 L 18.8 2.5 L 16.4 6.5 L 14.3 7.5 L 12.5 7.2 L 11.4 6.1 L 11.1 2.7","0 12.4 M 18.0 -2.9 L 15.6 1.9 L 13.3 6.3 L 11.3 7.4 L 9.8 6.6 L 9.8 2.0 L 10.7 -3.0 L 12.5 -6.7 L 14.7 -8.2 L 16.1 -8.3 L 17.6 -7.3 L 18.0 -5.2 L 17.4 -1.1 L 15.8 8.4 L 12.9 20.8","0 9.9 M 13.1 -8.2 L 10.0 7.5 L 12.3 -1.1 L 15.0 -5.6 L 17.1 -7.7 L 18.2 -8.3 L 19.6 -7.8","0 10.1 M 9.4 5.3 L 10.9 6.7 L 12.8 6.9 L 14.3 5.8 L 15.3 4.0 L 14.3 .9 L 12.7 -2.1 L 11.7 -4.8 L 11.7 -6.6 L 12.5 -8.2 L 14.2 -8.6 L 15.2 -8.5 L 16.5 -7.1","0 10.7 M 15.2 5.2 L 14.2 6.4 L 13.4 6.9 L 12.0 7.1 L 10.3 5.7 L 11.0 2.4 L 14.5 -12.7 M 10.0 -8.0 L 17.5 -8.0","0 13.7 M 12.0 -8.3 L 10.7 -2.5 L 10.0 1.8 L 9.9 4.5 L 10.2 6.1 L 10.9 7.3 L 12.3 6.6 L 13.6 4.8 L 18.5 -4.2 L 20.3 -7.2 L 18.3 -2.2 L 17.6 3.3 L 17.1 6.3 L 17.0 7.2 L 17.4 7.8","0 11.5 M 10.2 -8.6 L 12.2 7.1 L 15.8 2.2 L 18.1 -3.8 L 18.7 -8.6 L 18.7 -10.9 L 17.4 -12.7 L 16.9 -13.3 L 14.7 -13.7","0 18.7 M 10.1 -7.8 L 12.5 6.7 L 17.9 -7.6 L 20.0 6.7 L 23.1 1.9 L 25.4 -2.7 L 26.4 -6.5 L 26.1 -9.2 L 25.7 -10.8 L 24.8 -11.9 L 22.5 -13.4","0 12.3 M 8.1 7.9 L 14.3 -1.4 L 19.0 -8.0 M 11.4 -8.8 L 14.1 -.1 L 17.3 7.1","0 14.1 M 12.4 -8.3 L 10.5 1.1 L 10.1 5.0 L 10.8 6.9 L 12.7 7.3 L 14.8 5.7 L 16.1 3.8 L 17.1 1.6 L 19.9 -8.1 L 16.9 6.3 L 15.6 12.5 L 14.0 17.8 L 12.8 19.8 L 10.5 21.0 L 9.0 20.2 L 7.9 18.6 L 7.9 16.4 L 8.8 14.4 L 10.8 12.5 L 20.0 5.5","0 13.3 M 11.3 -8.1 L 20.2 -8.0 L 8.4 7.5 L 10.4 6.3 L 12.5 6.8 L 14.8 7.5 L 17.0 7.3 L 18.7 6.2 L 19.0 4.7 L 18.5 3.2","0 9.3 M 18.4 -23.3 L 16.3 -22.4 L 14.3 -18.7 L 14.1 -13.1 L 13.9 -7.5 L 13.1 -5.4 L 10.7 -3.3 L 10.7 -3.7 L 12.5 -3.1 L 12.0 .3 L 10.0 7.5 L 9.2 11.7 L 9.6 15.3 L 10.4 16.9 L 12.4 16.3","0 9.6 M 17.2 -31.0 L 9.0 11.9","0 10.8 M 13.6 -22.5 L 15.4 -23.2 L 16.8 -22.1 L 17.2 -19.4 L 16.6 -15.4 L 15.0 -9.4 L 13.3 -5.2 L 12.9 -1.3 L 12.9 .4 L 14.4 .7 L 12.4 2.6 L 11.5 6.9 L 10.7 13.2 L 9.6 18.2 L 8.5 21.2 L 6.2 23.7 L 3.6 23.8 L .4 22.0","0 20.1 M 9.5 1.0 L 10.7 -1.6 L 13.4 -3.6 L 15.4 -3.5 L 17.7 -2.4 L 22.1 .1 L 23.7 .2 L 24.4 -.3 L 25.8 -2.8","0 7.6 M 16.3 -25.4 L 15.7 -26.1 L 13.3 -26.0 L 11.6 -23.0 L 12.1 -20.7 L 14.1 -19.5 L 16.2 -19.7 L 18.4 -21.1 L 19.0 -22.3 L 19.1 -23.8 L 18.2 -24.8 L 16.3 -25.4"]
EMSNixish = ["-8 8","0 9.2 M 13.6 -12.9 L 13.6 2.6 M 13.7 6.0 L 12.9 6.5 L 12.5 7.5 L 13.0 8.1 L 13.6 8.3 L 14.3 8.2 L 14.8 7.5 L 14.8 6.6 L 14.4 6.2 L 13.7 6.0","0 10.7 M 12.5 -13.0 L 12.5 -6.7 M 16.6 -12.9 L 16.6 -6.7","0 24.2 M 14.6 7.9 L 19.7 -12.8 M 28.1 -13.0 L 23.0 7.9 M 29.5 2.0 L 11.1 2.0 M 13.2 -6.8 L 31.8 -6.8","0 20.2 M 12.0 7.9 L 12.0 1.9 L 12.0 4.7 L 13.6 5.9 L 15.4 7.1 L 17.6 8.0 L 19.9 8.2 L 22.4 8.0 L 24.4 7.3 L 26.2 5.9 L 26.9 4.3 L 27.2 2.7 L 27.1 1.4 L 26.0 -.1 L 23.7 -1.4 L 21.4 -2.1 L 19.2 -2.7 L 17.1 -3.3 L 15.2 -4.0 L 13.6 -4.9 L 12.4 -6.5 L 12.0 -8.1 L 12.4 -10.1 L 13.9 -12.0 L 16.0 -12.9 L 17.9 -13.1 L 20.6 -13.0 L 22.6 -12.3 L 24.2 -11.4 L 25.5 -10.4 L 26.4 -9.5 L 26.4 -6.7 L 26.4 -12.9 M 19.2 -15.3 L 19.2 10.3","0 25.2 M 15.8 -3.5 L 17.0 -3.5 L 18.4 -4.3 L 19.4 -5.1 L 20.1 -6.1 L 20.5 -7.3 L 20.6 -8.7 L 20.4 -9.9 L 19.7 -11.2 L 18.6 -12.3 L 17.2 -13.0 L 15.9 -13.1 L 14.2 -12.8 L 12.5 -11.8 L 11.6 -10.2 L 11.3 -8.5 L 11.3 -6.9 L 12.2 -5.4 L 13.4 -4.1 L 14.5 -3.7 L 15.8 -3.5 M 27.5 8.3 L 28.7 8.3 L 30.1 7.5 L 31.1 6.7 L 31.8 5.7 L 32.2 4.5 L 32.3 3.1 L 32.1 1.9 L 31.4 .6 L 30.3 -.4 L 28.9 -1.1 L 27.6 -1.3 L 25.9 -1.0 L 24.2 .0 L 23.3 1.6 L 23.0 3.3 L 23.0 4.9 L 23.9 6.4 L 25.1 7.7 L 26.2 8.1 L 27.5 8.3 M 14.8 7.9 L 28.4 -12.9","0 22.4 M 25.2 -10.4 L 23.6 -11.8 L 21.8 -13.0 L 20.5 -13.1 L 19.0 -13.1 L 17.1 -12.6 L 15.6 -11.3 L 15.0 -9.6 L 15.1 -7.6 L 16.2 -5.7 L 28.3 8.0 L 30.5 8.0 M 18.5 -2.9 L 16.3 -2.4 L 13.9 -1.4 L 12.0 .7 L 11.4 2.5 L 11.7 4.6 L 12.6 6.6 L 14.6 8.2 L 17.2 8.7 L 19.8 8.2 L 22.2 6.8 L 24.0 5.2 L 25.5 3.0 L 28.9 -2.0","0 6.6 M 12.5 -12.9 L 12.5 -6.3","0 9.4 M 16.3 12.8 L 14.5 10.1 L 13.2 7.0 L 12.4 3.6 L 12.3 -1.0 L 12.5 -5.4 L 13.4 -9.5 L 14.5 -12.6 L 16.3 -15.3","0 9.3 M 11.6 12.9 L 13.4 10.1 L 14.7 7.1 L 15.5 3.7 L 15.6 -.9 L 15.4 -5.4 L 14.5 -9.5 L 13.4 -12.5 L 11.6 -15.2","0 14.8 M 16.6 -3.6 L 16.6 -12.9 M 12.2 -10.8 L 21.1 -5.7 M 12.1 -5.7 L 20.9 -10.8","0 16.2 M 17.1 4.8 L 17.1 -7.4 M 11.1 -1.5 L 23.3 -1.5","0 8.3 M 14.1 8.2 L 13.5 8.3 L 12.9 8.1 L 12.4 7.5 L 12.7 6.5 L 13.6 6.0 L 14.3 6.2 L 14.6 6.6 L 14.6 7.5 L 14.6 8.7 L 14.5 9.8 L 14.1 10.5 L 13.6 11.2 L 12.6 11.9","0 18.5 M 12.4 -1.5 L 24.7 -1.5","0 8.3 M 13.3 6.0 L 12.5 6.5 L 12.2 7.5 L 12.6 8.1 L 13.3 8.3 L 13.9 8.2 L 14.4 7.5 L 14.4 6.6 L 14.0 6.2 L 13.3 6.0","0 16.8 M 10.9 7.9 L 24.4 -12.9","0 21.0 M 19.7 8.2 L 21.6 8.0 L 23.9 6.8 L 25.5 5.1 L 26.7 2.8 L 27.4 .9 L 27.5 -1.2 L 27.5 -3.4 L 27.4 -5.4 L 27.3 -6.8 L 26.4 -8.8 L 24.9 -10.7 L 22.9 -12.3 L 20.9 -13.1 L 19.2 -13.1 L 16.7 -12.5 L 14.6 -10.9 L 13.2 -8.7 L 12.2 -6.4 L 12.0 -3.8 L 12.0 -.8 L 12.4 1.5 L 12.9 3.4 L 14.1 5.4 L 15.5 6.8 L 17.5 8.0 L 19.7 8.2","0 11.6 M 12.5 8.0 L 19.0 8.0 L 15.7 8.0 L 15.7 -13.0 L 11.0 -9.0","0 19.2 M 11.7 -10.1 L 13.2 -11.5 L 15.2 -12.5 L 17.3 -13.1 L 19.5 -13.1 L 21.5 -12.8 L 23.2 -12.0 L 24.7 -10.7 L 25.7 -8.4 L 25.6 -6.7 L 24.9 -5.1 L 22.9 -3.0 L 20.1 -1.3 L 17.2 .2 L 14.9 1.7 L 13.4 2.9 L 12.2 4.7 L 11.9 5.9 L 11.9 8.0 L 25.6 8.0 L 25.6 3.5","0 19.3 M 11.8 5.2 L 13.4 6.6 L 15.4 7.7 L 17.6 8.2 L 19.3 8.2 L 21.4 7.9 L 23.5 7.0 L 24.8 5.7 L 25.6 4.0 L 25.8 1.8 L 25.3 -.2 L 23.8 -1.8 L 22.1 -2.5 L 19.9 -2.9 L 16.7 -2.9 L 20.6 -2.9 L 22.2 -3.4 L 23.7 -4.4 L 24.8 -5.9 L 25.2 -7.7 L 25.0 -9.3 L 24.0 -11.1 L 22.9 -12.2 L 21.0 -12.9 L 18.9 -13.0 L 16.8 -12.9 L 14.3 -12.0 L 12.2 -10.5","0 18.8 M 16.5 -13.6 L 16.4 -11.6 L 16.1 -9.2 L 15.8 -7.2 L 15.0 -5.0 L 14.0 -2.9 L 12.8 -.6 L 10.7 2.6 L 26.7 2.6 L 23.3 2.6 L 23.3 8.2 L 23.3 -7.1","0 18.5 M 12.2 8.9 L 14.4 8.7 L 17.2 8.4 L 19.9 7.6 L 22.4 6.4 L 24.2 4.7 L 25.3 2.9 L 25.4 .9 L 25.3 -.8 L 24.5 -2.5 L 23.3 -3.7 L 21.4 -4.6 L 18.8 -5.1 L 15.8 -4.8 L 13.7 -4.0 L 12.3 -3.1 L 12.3 -12.8 L 24.5 -12.8","0 19.3 M 12.6 -5.3 L 20.5 -5.3 L 22.5 -4.6 L 24.2 -3.6 L 25.6 -2.0 L 26.3 -.4 L 26.4 1.7 L 26.2 3.8 L 24.9 5.7 L 23.6 7.1 L 21.5 8.1 L 19.1 8.2 L 17.1 7.9 L 15.1 6.8 L 13.2 4.9 L 12.0 2.2 L 11.8 -.4 L 12.0 -3.3 L 12.4 -4.9 L 13.1 -7.2 L 14.6 -9.5 L 16.7 -11.4 L 19.0 -12.9 L 21.5 -13.8 L 24.0 -13.7","0 15.3 M 10.1 -8.4 L 10.1 -12.8 L 23.5 -12.8 L 21.2 -8.6 L 19.3 -5.2 L 17.8 -1.6 L 16.8 .9 L 16.2 3.0 L 15.8 5.1 L 15.7 7.9","0 20.6 M 19.5 8.2 L 22.0 8.0 L 24.6 7.1 L 26.6 5.4 L 27.4 3.5 L 27.1 1.7 L 26.1 .2 L 24.6 -.9 L 22.9 -1.6 L 19.9 -2.7 L 17.3 -3.6 L 14.9 -4.7 L 13.6 -6.1 L 12.8 -8.2 L 13.1 -10.1 L 14.7 -12.0 L 17.1 -12.9 L 19.6 -13.2 L 21.5 -13.0 L 24.1 -12.2 L 25.8 -10.6 L 26.4 -8.9 L 26.4 -7.0 L 25.0 -5.2 L 23.1 -4.1 L 20.6 -3.2 L 17.0 -2.0 L 14.6 -1.0 L 13.0 .3 L 12.1 1.5 L 11.9 4.0 L 12.8 5.8 L 14.3 7.1 L 16.2 7.9 L 18.1 8.2 L 19.5 8.2","0 19.2 M 13.8 8.9 L 15.9 8.8 L 18.1 8.0 L 20.1 7.0 L 22.0 5.7 L 23.6 3.6 L 24.9 1.4 L 25.5 -1.1 L 25.9 -3.6 L 25.7 -5.9 L 25.2 -8.5 L 23.6 -10.8 L 21.5 -12.5 L 19.7 -13.1 L 17.6 -13.1 L 15.2 -12.6 L 13.0 -11.1 L 11.9 -9.6 L 11.4 -7.4 L 11.3 -5.3 L 12.0 -2.9 L 13.0 -1.6 L 14.3 -.6 L 16.6 .3 L 18.8 .5 L 25.1 .5","0 8.8 M 13.6 -6.9 L 12.7 -6.5 L 12.4 -5.5 L 12.9 -4.8 L 13.5 -4.6 L 14.1 -4.8 L 14.6 -5.4 L 14.6 -6.3 L 14.3 -6.7 L 13.6 -6.9 M 13.6 5.9 L 12.7 6.4 L 12.4 7.4 L 12.9 8.0 L 13.5 8.2 L 14.1 8.1 L 14.6 7.4 L 14.6 6.5 L 14.3 6.1 L 13.6 5.9","0 8.5 M 13.6 -6.9 L 12.8 -6.5 L 12.5 -5.5 L 12.9 -4.9 L 13.6 -4.7 L 14.2 -4.8 L 14.7 -5.5 L 14.7 -6.4 L 14.3 -6.7 L 13.6 -6.9 M 14.1 8.1 L 13.5 8.2 L 12.9 8.0 L 12.4 7.4 L 12.7 6.4 L 13.6 6.0 L 14.3 6.2 L 14.6 6.6 L 14.6 7.5 L 14.6 8.7 L 14.5 9.7 L 14.1 10.4 L 13.6 11.1 L 12.6 11.9","0 16.3 M 22.9 -6.2 L 11.2 .5 L 22.9 7.3","0 18.6 M 12.3 -4.7 L 24.9 -4.7 M 12.2 1.6 L 24.8 1.6","0 16.3 M 11.8 7.6 L 23.6 .8 L 11.8 -6.1","0 17.7 M 17.9 6.0 L 17.1 6.4 L 16.7 7.4 L 17.2 8.0 L 17.8 8.2 L 18.5 8.1 L 19.0 7.5 L 19.0 6.6 L 18.6 6.2 L 17.9 6.0 M 17.8 2.7 L 17.9 1.3 L 18.3 .2 L 19.2 -.8 L 20.7 -2.0 L 22.2 -3.2 L 23.4 -4.4 L 24.3 -5.7 L 24.6 -6.9 L 24.4 -8.5 L 23.7 -10.3 L 22.4 -11.8 L 20.9 -12.7 L 19.0 -13.2 L 17.0 -13.1 L 15.5 -12.8 L 14.1 -12.3 L 12.7 -11.4 L 11.7 -10.1 L 11.2 -8.8 L 11.1 -7.3","0 29.4 M 29.4 -6.4 L 29.4 4.4 L 27.7 6.4 L 25.3 7.9 L 22.2 8.2 L 19.4 6.8 L 17.9 4.9 L 17.2 1.8 L 17.2 -1.8 L 18.9 -4.9 L 21.2 -6.6 L 23.5 -7.1 L 26.2 -6.3 L 27.9 -4.7 L 28.9 -3.5 L 29.5 -2.1 L 29.5 5.8 L 30.4 7.5 L 32.2 8.3 L 33.9 7.9 L 35.3 6.2 L 36.1 4.5 L 36.5 2.1 L 36.5 -1.5 L 36.0 -3.9 L 35.1 -6.5 L 33.5 -8.8 L 31.8 -10.4 L 29.8 -11.8 L 27.6 -12.7 L 25.8 -13.0 L 23.6 -13.2 L 21.2 -12.8 L 18.7 -12.0 L 16.1 -10.2 L 14.3 -8.3 L 12.8 -5.7 L 12.1 -3.1 L 11.7 -.3 L 12.0 2.9 L 12.8 6.0 L 14.1 8.4 L 15.7 10.3 L 18.3 12.2 L 21.4 13.6 L 24.1 13.7 L 27.1 13.6 L 29.5 12.9 L 30.9 12.0 L 32.1 11.0","0 23.1 M 9.7 7.9 L 15.7 7.9 L 12.5 7.9 L 20.7 -13.0 L 26.0 .3 L 15.5 .3 L 26.1 .3 L 29.1 8.0 L 25.9 8.0 L 32.0 8.0","0 21.0 M 11.0 -12.9 L 21.6 -12.9 L 23.3 -12.4 L 24.7 -11.5 L 25.8 -10.0 L 26.0 -8.5 L 26.0 -6.9 L 25.5 -5.6 L 24.5 -4.5 L 23.5 -3.6 L 22.4 -3.1 L 21.3 -2.8 L 14.5 -2.8 L 21.5 -2.8 L 22.7 -2.8 L 24.5 -2.5 L 26.1 -1.6 L 27.1 -.1 L 27.6 1.6 L 27.6 3.5 L 27.1 5.1 L 26.1 6.6 L 24.8 7.5 L 23.3 7.8 L 22.3 8.0 L 11.5 8.0 L 14.4 8.0 L 14.4 -12.8","0 22.2 M 28.9 -13.1 L 28.9 -6.8 L 28.9 -9.8 L 27.0 -11.0 L 25.3 -12.1 L 23.5 -12.9 L 21.4 -13.1 L 19.4 -13.0 L 17.2 -12.3 L 15.0 -10.9 L 13.3 -8.6 L 12.2 -6.2 L 11.9 -3.7 L 12.0 -.5 L 12.7 2.2 L 14.0 4.6 L 16.4 6.8 L 19.3 8.0 L 23.8 8.1 L 26.2 7.4 L 27.8 6.4 L 29.0 5.3","0 23.5 M 11.2 7.9 L 21.2 7.9 L 23.6 7.3 L 25.7 6.2 L 27.8 4.1 L 29.2 2.0 L 29.9 -.4 L 29.9 -3.9 L 29.3 -6.5 L 27.8 -9.1 L 26.3 -10.9 L 23.9 -12.3 L 21.4 -13.0 L 11.2 -13.0 L 14.4 -13.0 L 14.4 7.8","0 19.7 M 26.3 3.3 L 26.3 7.9 L 11.0 7.9 L 14.3 7.9 L 14.3 -2.6 L 23.2 -2.6 L 23.2 -5.2 L 23.2 .0 L 23.2 -2.6 L 14.2 -2.6 L 14.2 -12.8 L 11.3 -12.8 L 26.1 -12.8 L 26.1 -8.4","0 18.7 M 11.2 8.0 L 18.0 8.0 L 14.5 8.0 L 14.5 -2.6 L 23.6 -2.6 L 23.6 .0 L 23.6 -5.2 L 23.6 -2.7 L 14.5 -2.7 L 14.5 -12.9 L 11.4 -12.9 L 25.9 -12.9 L 25.9 -8.4","0 24.5 M 26.0 -2.7 L 32.3 -2.7 L 29.0 -2.7 L 29.0 8.1 L 29.0 4.7 L 27.1 6.3 L 25.1 7.5 L 22.8 8.2 L 20.7 8.2 L 19.0 8.0 L 16.6 7.1 L 14.8 5.4 L 12.9 2.8 L 12.0 -.9 L 11.9 -4.1 L 12.9 -7.6 L 14.9 -10.4 L 17.5 -12.5 L 20.1 -13.2 L 23.0 -13.0 L 25.8 -12.0 L 27.8 -10.6 L 28.8 -9.1 L 28.8 -6.9 L 28.8 -13.0","0 25.0 M 11.3 8.0 L 17.5 8.0 L 14.6 8.0 L 14.6 -12.8 L 11.2 -12.8 L 17.5 -12.8 L 14.6 -12.8 L 14.6 -2.6 L 28.7 -2.6 L 28.7 -12.9 L 25.8 -12.9 L 31.9 -12.9 L 28.8 -12.9 L 28.8 8.0 L 31.9 8.0 L 26.0 8.0","0 10.8 M 11.1 8.0 L 17.7 8.0 L 14.5 8.0 L 14.5 -13.0 L 17.8 -13.0 L 11.3 -13.0","0 16.5 M 10.6 5.5 L 12.0 7.1 L 13.8 8.1 L 15.5 8.2 L 17.3 8.0 L 19.1 7.1 L 20.3 5.7 L 20.6 4.1 L 20.8 2.5 L 20.8 -12.8 L 17.5 -12.8 L 23.9 -12.8","0 22.2 M 11.2 -12.8 L 17.5 -12.8 L 14.4 -12.8 L 14.4 8.0 L 11.3 8.0 L 17.3 8.0 L 14.4 8.0 L 14.4 .5 L 26.9 -12.8 L 29.7 -12.8 L 23.0 -12.8 L 26.9 -12.8 L 18.8 -4.2 L 27.8 8.0 L 30.6 8.0 L 24.3 8.0","0 18.6 M 11.2 -13.0 L 18.3 -13.0 L 14.5 -13.0 L 14.5 7.9 L 11.3 7.9 L 26.2 7.9 L 26.2 3.5","0 31.0 M 11.2 8.0 L 17.4 8.0 L 14.5 8.0 L 14.5 -12.8 L 11.3 -12.8 L 15.2 -12.8 L 24.6 7.8 L 34.2 -12.9 L 37.9 -12.9 L 34.6 -12.9 L 34.6 8.0 L 31.9 8.0 L 37.9 8.0","0 25.2 M 11.3 7.9 L 17.3 7.9 L 14.5 7.9 L 14.5 -12.8 L 11.2 -12.8 L 14.9 -12.8 L 28.5 8.0 L 32.2 8.0 L 29.0 8.0 L 29.0 -12.9 L 26.2 -12.9 L 32.2 -12.9","0 24.9 M 21.8 8.2 L 23.7 8.2 L 26.8 7.0 L 28.8 5.2 L 30.5 2.9 L 31.4 .3 L 31.7 -2.9 L 31.0 -6.5 L 29.9 -8.8 L 28.4 -10.7 L 26.2 -12.1 L 24.1 -12.8 L 21.8 -13.1 L 19.1 -12.8 L 16.3 -11.7 L 14.4 -10.0 L 12.7 -7.4 L 11.9 -4.9 L 11.7 -2.3 L 12.0 .4 L 12.7 2.6 L 13.8 4.3 L 15.4 6.1 L 17.3 7.3 L 19.7 8.0 L 21.8 8.2","0 20.6 M 11.3 8.0 L 18.1 8.0 L 14.6 8.0 L 14.6 -12.8 L 11.4 -12.8 L 22.5 -12.8 L 24.1 -12.5 L 25.7 -11.6 L 26.9 -10.4 L 27.6 -8.6 L 27.6 -6.3 L 27.2 -3.8 L 26.1 -2.0 L 24.4 -1.0 L 22.4 -.7 L 14.7 -.7","0 25.2 M 19.1 7.9 L 16.7 7.1 L 14.4 5.2 L 12.6 2.4 L 12.0 -.3 L 11.7 -3.2 L 12.5 -7.1 L 14.1 -9.9 L 16.9 -12.2 L 20.1 -13.1 L 23.3 -13.1 L 26.3 -12.2 L 28.2 -10.8 L 29.8 -9.1 L 31.0 -6.5 L 31.5 -3.9 L 31.6 -.8 L 30.9 1.9 L 29.5 4.4 L 27.6 6.4 L 25.5 7.6 L 23.3 8.1 L 21.0 8.2 L 19.4 7.9 L 19.1 7.5 L 20.0 5.7 L 21.8 5.0 L 23.1 5.4 L 23.9 6.5 L 24.4 8.7 L 25.1 10.0 L 26.3 10.8 L 27.7 10.6 L 28.8 10.0","0 22.1 M 11.5 7.9 L 17.8 7.9 L 14.6 7.9 L 14.6 -12.8 L 11.5 -12.8 L 22.6 -12.8 L 24.5 -12.4 L 26.0 -11.6 L 27.3 -10.0 L 27.7 -8.2 L 27.6 -6.6 L 27.1 -4.6 L 26.2 -3.5 L 24.9 -2.5 L 23.2 -2.1 L 14.6 -2.1 L 20.3 -2.1 L 27.6 8.0 L 24.1 8.0 L 30.2 8.0","0 21.1 M 12.5 8.0 L 12.5 1.9 L 12.5 4.9 L 13.8 5.9 L 16.1 7.3 L 18.8 8.1 L 21.9 8.2 L 24.5 7.5 L 26.5 6.0 L 27.4 4.2 L 27.6 1.7 L 26.5 -.2 L 24.4 -1.4 L 21.8 -2.2 L 17.7 -3.4 L 14.5 -4.6 L 13.1 -5.8 L 12.3 -7.4 L 12.5 -9.7 L 13.6 -11.5 L 15.3 -12.6 L 17.7 -13.0 L 20.8 -13.0 L 22.9 -12.3 L 24.5 -11.3 L 25.8 -10.3 L 26.8 -9.3 L 26.8 -6.8 L 26.8 -13.0","0 20.0 M 16.1 8.0 L 22.7 8.0 L 19.2 8.0 L 19.2 -12.8 L 11.0 -12.8 L 11.0 -8.1 L 11.0 -12.8 L 27.6 -12.8 L 27.6 -8.1","0 24.7 M 10.7 -12.9 L 16.7 -12.9 L 14.0 -12.9 L 14.0 2.4 L 14.5 4.0 L 15.5 5.5 L 17.0 6.8 L 18.7 7.8 L 20.6 8.2 L 22.8 8.2 L 24.9 7.4 L 26.7 6.2 L 28.1 4.8 L 28.8 3.3 L 29.0 1.8 L 29.0 -12.8 L 26.0 -12.8 L 32.2 -12.8","0 23.3 M 9.9 -12.9 L 15.9 -12.9 L 12.6 -12.9 L 20.8 8.0 L 28.9 -12.8 L 25.8 -12.8 L 32.0 -12.8","0 32.1 M 9.9 -13.0 L 15.8 -13.0 L 12.7 -13.0 L 19.2 8.1 L 25.2 -13.0 L 31.3 8.1 L 38.0 -12.9 L 34.9 -12.9 L 40.6 -12.9","0 21.2 M 10.2 7.9 L 16.3 7.9 L 12.9 7.9 L 26.6 -12.8 L 29.2 -12.8 L 23.1 -12.8 M 10.3 -12.9 L 16.5 -12.9 L 13.4 -12.9 L 27.0 7.9 L 29.5 7.9 L 23.6 7.9","0 20.6 M 16.5 8.0 L 22.7 8.0 L 19.3 8.0 L 19.3 -1.2 L 12.6 -12.8 L 9.9 -12.8 L 15.9 -12.8 L 12.6 -12.8 L 19.3 -1.1 L 26.1 -12.9 L 23.2 -12.9 L 29.1 -12.9","0 20.1 M 12.0 -8.4 L 12.0 -13.0 L 26.9 -13.0 L 11.7 7.9 L 26.4 7.9 L 26.4 3.6","0 10.0 M 17.7 12.8 L 13.3 12.8 L 13.3 -15.1 L 17.5 -15.1","0 16.8 M 10.8 -13.0 L 24.3 8.0","0 9.8 M 10.6 12.7 L 14.8 12.7 L 14.8 -15.1 L 10.7 -15.1","0 15.4 M 10.9 -5.8 L 17.0 -13.9 L 23.2 -5.8","0 22.9 M 15.8 10.3 L 25.4 10.3","0 8.3 M 11.7 -13.5 L 14.8 -9.3","0 18.7 M 12.4 -5.2 L 14.1 -6.5 L 16.4 -7.1 L 19.1 -6.9 L 21.0 -6.3 L 22.6 -4.5 L 23.1 -2.9 L 23.1 4.0 L 21.8 5.7 L 19.6 7.4 L 17.4 8.2 L 14.5 8.0 L 12.3 6.8 L 11.3 5.2 L 11.3 3.4 L 12.2 1.5 L 14.5 .1 L 17.2 -.2 L 23.1 -.2 L 23.1 7.9 L 26.2 7.9","0 19.4 M 9.8 -12.9 L 13.0 -12.9 L 13.0 8.0 L 13.0 3.8 L 14.3 5.3 L 16.0 7.0 L 17.4 7.8 L 19.7 8.3 L 21.8 8.0 L 23.8 6.8 L 25.4 4.6 L 26.1 2.2 L 26.1 -.8 L 25.5 -2.8 L 24.4 -4.6 L 22.6 -5.8 L 20.5 -6.5 L 18.4 -6.6 L 13.1 -6.6","0 17.8 M 24.5 -6.8 L 24.5 -1.7 L 24.5 -3.7 L 22.4 -5.5 L 19.4 -6.8 L 17.1 -6.8 L 15.1 -6.2 L 13.4 -4.9 L 12.2 -2.9 L 11.7 -.6 L 11.7 2.1 L 12.4 4.4 L 14.0 6.7 L 16.3 8.0 L 18.0 8.2 L 19.9 8.2 L 22.7 7.3 L 24.4 5.9","0 20.4 M 21.2 -12.9 L 24.8 -12.9 L 24.8 4.1 L 22.7 6.0 L 20.9 7.5 L 18.5 8.2 L 17.1 8.1 L 14.3 7.1 L 12.5 5.0 L 11.5 2.2 L 11.7 -1.0 L 12.7 -3.7 L 15.1 -5.8 L 17.5 -6.6 L 19.9 -6.7 L 24.8 -6.7 L 24.8 8.0 L 27.8 8.0","0 18.4 M 11.9 .4 L 25.2 .4 L 25.2 -1.8 L 24.5 -3.7 L 23.5 -5.0 L 21.8 -6.3 L 19.6 -6.9 L 17.3 -7.0 L 15.0 -6.1 L 13.1 -4.4 L 12.2 -2.4 L 11.8 -.2 L 11.8 2.2 L 12.3 4.1 L 13.9 6.4 L 15.9 7.7 L 17.5 8.2 L 19.9 8.2 L 22.5 7.4 L 24.5 6.0","0 13.8 M 11.2 7.9 L 17.9 7.9 L 14.3 7.9 L 14.3 -6.7 L 11.2 -6.7 L 20.1 -6.7 L 14.2 -6.7 L 14.2 -8.5 L 14.5 -10.3 L 15.7 -12.1 L 17.3 -13.0 L 19.2 -13.2 L 21.3 -12.5 L 22.7 -11.3","0 19.6 M 14.6 5.9 L 12.6 6.8 L 11.2 8.2 L 10.9 9.9 L 11.1 11.9 L 13.1 13.6 L 15.5 14.1 L 18.3 14.3 L 21.2 14.2 L 23.6 13.5 L 25.1 12.4 L 26.0 11.0 L 26.0 9.0 L 25.1 7.3 L 23.2 6.3 L 20.8 5.7 L 18.9 5.7 L 17.0 5.8 L 15.0 5.9 L 13.5 5.6 L 11.9 5.0 L 11.6 3.9 L 12.2 2.8 L 13.8 1.8 L 15.1 2.5 L 17.3 3.0 L 19.5 3.0 L 21.8 2.4 L 23.9 1.0 L 24.6 -.7 L 24.7 -3.2 L 24.1 -4.7 L 23.2 -5.8 L 24.6 -6.8 L 27.6 -6.8 L 27.6 -3.1 L 27.6 -6.8 L 24.8 -6.8 L 23.2 -5.8 L 21.5 -6.6 L 18.5 -7.0 L 15.7 -6.6 L 12.9 -5.0 L 12.1 -2.7 L 12.2 -.6 L 13.1 1.1 L 13.8 1.9","0 21.0 M 10.9 -12.9 L 13.9 -12.9 L 13.9 7.9 L 10.9 7.9 L 16.7 7.9 L 13.9 7.9 L 13.9 -2.9 L 15.7 -4.8 L 17.4 -6.3 L 19.7 -7.0 L 21.5 -7.0 L 23.4 -6.4 L 24.6 -5.5 L 25.7 -3.9 L 25.9 -1.9 L 25.9 8.0 L 23.1 8.0 L 29.0 8.0","0 9.8 M 11.2 8.0 L 17.8 8.0 L 14.4 8.0 L 14.4 -6.8 L 11.2 -6.8 M 14.2 -9.9 L 15.1 -10.4 L 15.1 -11.2 L 14.5 -11.7 L 13.7 -11.5 L 13.4 -10.7 L 13.6 -10.3 L 14.2 -9.9","0 8.4 M 5.6 12.6 L 6.8 13.6 L 8.3 14.3 L 10.3 14.3 L 11.9 13.6 L 13.2 12.4 L 13.6 9.9 L 13.6 -6.5 L 10.5 -6.5 M 13.6 -9.9 L 14.2 -10.3 L 14.4 -11.2 L 13.9 -11.7 L 12.9 -11.6 L 12.7 -10.7 L 12.8 -10.2 L 13.6 -9.9","0 19.0 M 10.6 -13.0 L 13.9 -13.0 L 13.9 7.9 L 10.7 7.9 L 16.8 7.9 L 14.0 7.9 L 14.0 3.6 L 23.4 -6.7 L 26.1 -6.7 L 19.9 -6.7 L 23.4 -6.7 L 18.0 -.9 L 24.3 8.0 L 27.0 8.0 L 21.0 8.0","0 9.3 M 10.8 8.0 L 17.0 8.0 L 13.8 8.0 L 13.8 -13.0 L 10.8 -13.0","0 30.6 M 11.2 8.0 L 17.2 8.0 L 14.4 8.0 L 14.4 -6.8 L 11.3 -6.8 L 14.3 -6.8 L 14.3 -3.0 L 16.0 -5.0 L 18.2 -6.6 L 20.3 -6.9 L 22.3 -6.6 L 23.4 -5.6 L 24.6 -3.7 L 24.8 -2.0 L 24.8 7.9 L 22.0 7.9 L 27.6 7.9 L 24.9 7.9 L 24.9 -2.2 L 25.3 -3.2 L 26.7 -5.0 L 28.5 -6.5 L 30.4 -6.9 L 32.3 -6.7 L 33.7 -5.9 L 34.9 -4.4 L 35.4 -2.6 L 35.4 -.7 L 35.4 7.9 L 32.5 7.9 L 38.3 7.9","0 21.6 M 11.4 8.0 L 17.1 8.0 L 14.5 8.0 L 14.5 -6.7 L 11.4 -6.7 L 14.4 -6.7 L 14.4 -2.6 L 16.1 -4.8 L 17.6 -6.0 L 19.4 -6.9 L 21.1 -7.0 L 23.0 -6.7 L 24.8 -5.9 L 26.0 -4.4 L 26.4 -3.1 L 26.4 -1.5 L 26.4 7.8 L 23.6 7.8 L 29.7 7.8","0 19.1 M 18.9 8.2 L 21.0 8.0 L 23.3 6.8 L 25.0 4.9 L 25.8 2.5 L 26.0 -.1 L 25.6 -2.3 L 24.4 -4.4 L 22.8 -5.8 L 20.6 -6.8 L 18.9 -7.0 L 16.2 -6.7 L 13.7 -4.9 L 12.2 -2.7 L 11.7 .1 L 11.8 2.8 L 12.9 5.2 L 14.7 7.1 L 17.1 8.1 L 18.9 8.2","0 20.3 M 10.6 14.2 L 17.6 14.2 L 13.6 14.2 L 13.6 -6.7 L 10.8 -6.7 L 13.6 -6.7 L 13.6 -2.9 L 15.6 -4.8 L 18.4 -6.8 L 21.3 -7.1 L 24.1 -6.0 L 26.0 -3.7 L 26.7 -.7 L 26.6 2.2 L 26.0 4.6 L 24.5 6.3 L 22.5 7.4 L 20.6 7.8 L 19.0 8.0 L 13.8 8.0","0 20.0 M 21.2 14.1 L 27.9 14.1 L 24.6 14.1 L 24.6 -6.8 L 24.6 -3.0 L 23.4 -4.4 L 21.8 -5.7 L 19.8 -6.7 L 17.7 -7.1 L 15.7 -6.6 L 13.6 -5.2 L 12.4 -3.4 L 11.8 -1.6 L 11.6 .5 L 11.8 2.6 L 12.5 4.5 L 14.2 6.4 L 16.6 7.6 L 19.4 7.9 L 24.6 7.9","0 16.6 M 18.0 8.0 L 11.0 8.0 L 14.2 8.0 L 14.2 -6.7 L 11.3 -6.7 L 14.2 -6.7 L 14.2 -2.1 L 15.6 -3.7 L 16.9 -5.0 L 18.5 -6.0 L 19.9 -6.7 L 21.6 -6.9 L 24.0 -6.9 L 24.0 -3.0","0 17.9 M 12.0 8.0 L 12.0 2.8 L 12.0 5.0 L 13.3 6.2 L 14.8 7.3 L 16.8 8.1 L 18.7 8.3 L 21.1 8.0 L 23.2 7.1 L 24.3 5.8 L 24.6 4.4 L 24.3 2.8 L 22.9 1.7 L 21.2 1.1 L 18.2 .6 L 15.4 .1 L 13.6 -.6 L 12.4 -1.6 L 12.0 -2.8 L 12.0 -4.1 L 12.7 -5.4 L 14.5 -6.6 L 16.2 -6.9 L 18.8 -6.9 L 20.5 -6.4 L 21.8 -5.6 L 23.0 -4.5 L 23.9 -3.7 L 23.9 -1.6 L 23.9 -6.7","0 12.9 M 13.6 -12.9 L 13.6 -6.7 L 10.6 -6.7 L 19.7 -6.7 L 13.6 -6.7 L 13.6 4.4 L 14.0 6.0 L 14.8 7.2 L 16.1 8.0 L 17.4 8.2 L 19.0 8.0 L 20.6 7.3 L 21.5 6.5","0 21.1 M 10.3 -6.7 L 13.7 -6.7 L 13.7 3.6 L 13.8 4.9 L 14.6 6.2 L 15.5 7.2 L 16.8 8.0 L 18.7 8.3 L 20.6 8.0 L 22.7 7.2 L 24.2 5.7 L 25.6 4.0 L 25.6 8.0 L 28.8 8.0 L 25.6 8.0 L 25.6 -6.8 L 22.4 -6.8","0 20.0 M 9.8 -6.7 L 16.1 -6.7 L 12.9 -6.7 L 19.2 8.1 L 25.7 -6.7 L 28.3 -6.7 L 22.5 -6.7","0 27.7 M 10.0 -6.7 L 16.1 -6.7 L 13.0 -6.7 L 18.3 8.0 L 23.1 -6.7 L 27.9 8.1 L 33.2 -6.8 L 36.2 -6.8 L 30.0 -6.8","0 18.7 M 10.6 8.0 L 16.8 8.0 L 13.3 8.0 L 23.9 -6.7 L 26.2 -6.7 L 20.3 -6.7 M 16.9 -6.7 L 10.8 -6.7 L 13.4 -6.7 L 23.9 8.0 L 26.4 8.0 L 20.4 8.0","0 20.2 M 11.0 12.7 L 11.9 13.5 L 13.1 14.4 L 14.3 14.4 L 15.6 14.4 L 17.0 13.6 L 18.3 12.0 L 19.5 9.2 L 25.7 -6.6 L 28.3 -6.6 L 22.5 -6.6 M 10.2 -6.7 L 15.9 -6.7 L 13.0 -6.7 L 19.9 8.0","0 17.5 M 11.7 -2.7 L 11.7 -6.6 L 24.1 -6.6 L 11.3 8.0 L 24.1 8.0 L 24.1 4.0","0 10.9 M 18.6 12.7 L 16.5 12.7 L 15.7 12.2 L 15.0 11.4 L 14.5 10.5 L 14.3 9.3 L 14.3 1.2 L 13.7 -.1 L 12.7 -.8 L 11.9 -1.2 L 10.6 -1.2 L 12.0 -1.2 L 13.3 -2.0 L 14.1 -2.8 L 14.4 -3.9 L 14.4 -12.9 L 14.8 -13.7 L 15.8 -14.8 L 17.0 -15.3 L 18.6 -15.3","0 8.8 M 13.5 14.4 L 13.5 -12.9","0 10.7 M 10.6 12.8 L 12.2 12.8 L 13.4 12.4 L 14.1 11.6 L 14.7 10.8 L 14.7 9.6 L 14.7 1.4 L 15.2 .2 L 16.2 -.8 L 17.3 -1.2 L 18.4 -1.2 L 17.3 -1.2 L 16.0 -1.8 L 15.2 -2.8 L 14.8 -3.8 L 14.8 -5.1 L 14.8 -12.9 L 14.3 -13.9 L 13.6 -14.6 L 12.4 -15.2 L 10.9 -15.2","0 17.3 M 12.7 -.2 L 12.8 -1.3 L 13.5 -2.5 L 14.6 -3.0 L 15.9 -2.9 L 17.2 -2.3 L 18.2 -1.2 L 19.4 -.3 L 21.0 .1 L 22.4 -.5 L 23.0 -1.3 L 23.1 -2.6","0 14.7 M 16.4 -3.4 L 17.7 -3.4 L 19.0 -4.2 L 20.0 -5.0 L 20.7 -6.0 L 21.2 -7.2 L 21.2 -8.6 L 21.0 -9.8 L 20.4 -11.1 L 19.2 -12.2 L 17.8 -12.9 L 16.5 -13.0 L 14.8 -12.7 L 13.2 -11.7 L 12.2 -10.1 L 11.9 -8.4 L 12.0 -6.9 L 12.8 -5.3 L 14.0 -4.1 L 15.2 -3.6 L 16.4 -3.4"]
EMSNixishItalic = ["-8 8","0 9.2 M 16.7 -12.9 L 14.0 2.6 M 13.4 6.0 L 12.5 6.5 L 12.0 7.5 L 12.4 8.1 L 13.0 8.3 L 13.6 8.2 L 14.2 7.5 L 14.4 6.6 L 14.1 6.2 L 13.4 6.0","0 10.7 M 15.6 -13.0 L 14.5 -6.7 M 19.7 -12.9 L 18.6 -6.7","0 24.2 M 14.0 7.9 L 22.7 -12.8 M 31.2 -13.0 L 22.4 7.9 M 29.9 2.0 L 11.5 2.0 M 15.2 -6.8 L 33.8 -6.8","0 20.2 M 11.4 7.9 L 12.5 1.9 L 12.0 4.7 L 13.3 5.9 L 14.9 7.1 L 17.0 8.0 L 19.3 8.2 L 21.8 8.0 L 23.9 7.3 L 25.9 5.9 L 27.0 4.3 L 27.5 2.7 L 27.7 1.4 L 26.8 -.1 L 24.8 -1.4 L 22.6 -2.1 L 20.5 -2.7 L 18.4 -3.3 L 16.7 -4.0 L 15.2 -4.9 L 14.3 -6.5 L 14.2 -8.1 L 15.0 -10.1 L 16.8 -12.0 L 19.1 -12.9 L 21.0 -13.1 L 23.7 -13.0 L 25.6 -12.3 L 27.0 -11.4 L 28.1 -10.4 L 28.9 -9.5 L 28.4 -6.7 L 29.5 -12.9 M 22.7 -15.3 L 18.2 10.3","0 25.2 M 17.2 -3.5 L 18.4 -3.5 L 19.9 -4.3 L 21.1 -5.1 L 21.9 -6.1 L 22.6 -7.3 L 22.9 -8.7 L 22.9 -9.9 L 22.5 -11.2 L 21.5 -12.3 L 20.3 -13.0 L 19.0 -13.1 L 17.2 -12.8 L 15.4 -11.8 L 14.2 -10.2 L 13.5 -8.5 L 13.4 -6.9 L 13.9 -5.4 L 14.9 -4.1 L 15.9 -3.7 L 17.2 -3.5 M 26.8 8.3 L 28.1 8.3 L 29.5 7.5 L 30.7 6.7 L 31.6 5.7 L 32.2 4.5 L 32.5 3.1 L 32.5 1.9 L 32.1 .6 L 31.2 -.4 L 29.9 -1.1 L 28.6 -1.3 L 26.8 -1.0 L 25.0 .0 L 23.8 1.6 L 23.2 3.3 L 23.0 4.9 L 23.5 6.4 L 24.5 7.7 L 25.6 8.1 L 26.8 8.3 M 14.2 7.9 L 31.5 -12.9","0 22.4 M 27.8 -10.4 L 26.5 -11.8 L 24.9 -13.0 L 23.6 -13.1 L 22.1 -13.1 L 20.1 -12.6 L 18.4 -11.3 L 17.5 -9.6 L 17.2 -7.6 L 18.0 -5.7 L 27.7 8.0 L 29.9 8.0 M 19.8 -2.9 L 17.5 -2.4 L 14.9 -1.4 L 12.6 .7 L 11.8 2.5 L 11.6 4.6 L 12.2 6.6 L 14.0 8.2 L 16.5 8.7 L 19.1 8.2 L 21.8 6.8 L 23.8 5.2 L 25.8 3.0 L 30.0 -2.0","0 6.6 M 15.6 -12.9 L 14.4 -6.3","0 9.4 M 14.9 12.8 L 13.5 10.1 L 12.8 7.0 L 12.6 3.6 L 13.2 -1.0 L 14.2 -5.4 L 15.8 -9.5 L 17.6 -12.6 L 19.8 -15.3","0 9.3 M 10.1 12.9 L 12.4 10.1 L 14.2 7.1 L 15.6 3.7 L 16.6 -.9 L 17.2 -5.4 L 17.0 -9.5 L 16.4 -12.5 L 15.1 -15.2","0 14.8 M 18.0 -3.6 L 19.6 -12.9 M 14.9 -10.8 L 22.8 -5.7 M 13.9 -5.7 L 23.6 -10.8","0 16.2 M 17.0 4.8 L 19.2 -7.4 M 12.2 -1.5 L 24.4 -1.5","0 8.3 M 13.5 8.2 L 12.8 8.3 L 12.2 8.1 L 11.9 7.5 L 12.4 6.5 L 13.3 6.0 L 14.0 6.2 L 14.3 6.6 L 14.1 7.5 L 13.9 8.7 L 13.5 9.8 L 13.0 10.5 L 12.4 11.2 L 11.3 11.9","0 18.5 M 13.4 -1.5 L 25.8 -1.5","0 8.3 M 13.0 6.0 L 12.1 6.5 L 11.6 7.5 L 12.0 8.1 L 12.6 8.3 L 13.2 8.2 L 13.9 7.5 L 14.0 6.6 L 13.7 6.2 L 13.0 6.0","0 16.8 M 10.3 7.9 L 27.5 -12.9","0 21.0 M 19.0 8.2 L 21.0 8.0 L 23.5 6.8 L 25.4 5.1 L 27.0 2.8 L 28.0 .9 L 28.5 -1.2 L 28.9 -3.4 L 29.1 -5.4 L 29.3 -6.8 L 28.7 -8.8 L 27.6 -10.7 L 25.9 -12.3 L 24.0 -13.1 L 22.3 -13.1 L 19.7 -12.5 L 17.4 -10.9 L 15.5 -8.7 L 14.2 -6.4 L 13.5 -3.8 L 13.0 -.8 L 12.9 1.5 L 13.1 3.4 L 14.0 5.4 L 15.1 6.8 L 16.9 8.0 L 19.0 8.2","0 11.6 M 11.9 8.0 L 18.3 8.0 L 15.1 8.0 L 18.8 -13.0 L 13.4 -9.0","0 19.2 M 14.3 -10.1 L 16.0 -11.5 L 18.2 -12.5 L 20.4 -13.1 L 22.6 -13.1 L 24.5 -12.8 L 26.1 -12.0 L 27.3 -10.7 L 28.0 -8.4 L 27.6 -6.7 L 26.6 -5.1 L 24.3 -3.0 L 21.1 -1.3 L 17.9 .2 L 15.4 1.7 L 13.6 2.9 L 12.1 4.7 L 11.6 5.9 L 11.3 8.0 L 25.0 8.0 L 25.8 3.5","0 19.3 M 11.7 5.2 L 13.0 6.6 L 14.9 7.7 L 16.9 8.2 L 18.6 8.2 L 20.8 7.9 L 23.0 7.0 L 24.6 5.7 L 25.7 4.0 L 26.3 1.8 L 26.1 -.2 L 24.9 -1.8 L 23.3 -2.5 L 21.2 -2.9 L 18.0 -2.9 L 21.9 -2.9 L 23.6 -3.4 L 25.3 -4.4 L 26.7 -5.9 L 27.3 -7.7 L 27.4 -9.3 L 26.8 -11.1 L 25.8 -12.2 L 24.0 -12.9 L 22.0 -13.0 L 19.9 -12.9 L 17.3 -12.0 L 14.8 -10.5","0 18.8 M 19.7 -13.6 L 19.3 -11.6 L 18.5 -9.2 L 17.8 -7.2 L 16.7 -5.0 L 15.3 -2.9 L 13.7 -.6 L 11.0 2.6 L 27.0 2.6 L 23.7 2.6 L 22.7 8.2 L 25.4 -7.1","0 18.5 M 11.4 8.9 L 13.6 8.7 L 16.5 8.4 L 19.4 7.6 L 22.0 6.4 L 24.2 4.7 L 25.6 2.9 L 26.0 .9 L 26.2 -.8 L 25.7 -2.5 L 24.8 -3.7 L 23.0 -4.6 L 20.5 -5.1 L 17.5 -4.8 L 15.2 -4.0 L 13.6 -3.1 L 15.3 -12.8 L 27.6 -12.8","0 19.3 M 14.3 -5.3 L 22.2 -5.3 L 24.1 -4.6 L 25.6 -3.6 L 26.8 -2.0 L 27.1 -.4 L 26.9 1.7 L 26.3 3.8 L 24.7 5.7 L 23.1 7.1 L 20.9 8.1 L 18.4 8.2 L 16.5 7.9 L 14.7 6.8 L 13.1 4.9 L 12.4 2.2 L 12.7 -.4 L 13.3 -3.3 L 14.0 -4.9 L 15.2 -7.2 L 17.0 -9.5 L 19.5 -11.4 L 22.1 -12.9 L 24.7 -13.8 L 27.2 -13.7","0 15.3 M 12.4 -8.4 L 13.2 -12.8 L 26.6 -12.8 L 23.5 -8.6 L 21.0 -5.2 L 18.9 -1.6 L 17.4 .9 L 16.5 3.0 L 15.7 5.1 L 15.1 7.9","0 20.6 M 18.8 8.2 L 21.4 8.0 L 24.2 7.1 L 26.5 5.4 L 27.5 3.5 L 27.6 1.7 L 26.9 .2 L 25.6 -.9 L 24.0 -1.6 L 21.2 -2.7 L 18.7 -3.6 L 16.5 -4.7 L 15.4 -6.1 L 15.0 -8.2 L 15.6 -10.1 L 17.6 -12.0 L 20.2 -12.9 L 22.7 -13.2 L 24.6 -13.0 L 27.1 -12.2 L 28.5 -10.6 L 28.8 -8.9 L 28.4 -7.0 L 26.8 -5.2 L 24.6 -4.1 L 21.9 -3.2 L 18.2 -2.0 L 15.6 -1.0 L 13.7 .3 L 12.6 1.5 L 12.0 4.0 L 12.6 5.8 L 13.8 7.1 L 15.6 7.9 L 17.5 8.2 L 18.8 8.2","0 19.2 M 13.0 8.9 L 15.1 8.8 L 17.5 8.0 L 19.7 7.0 L 21.8 5.7 L 23.7 3.6 L 25.4 1.4 L 26.4 -1.1 L 27.3 -3.6 L 27.6 -5.9 L 27.5 -8.5 L 26.3 -10.8 L 24.5 -12.5 L 22.8 -13.1 L 20.7 -13.1 L 18.2 -12.6 L 15.8 -11.1 L 14.4 -9.6 L 13.5 -7.4 L 13.0 -5.3 L 13.3 -2.9 L 14.1 -1.6 L 15.2 -.6 L 17.3 .3 L 19.5 .5 L 25.8 .5","0 8.8 M 15.6 -6.9 L 14.7 -6.5 L 14.2 -5.5 L 14.5 -4.8 L 15.1 -4.6 L 15.8 -4.8 L 16.4 -5.4 L 16.5 -6.3 L 16.2 -6.7 L 15.6 -6.9 M 13.3 5.9 L 12.4 6.4 L 11.9 7.4 L 12.2 8.0 L 12.9 8.2 L 13.5 8.1 L 14.1 7.4 L 14.3 6.5 L 14.0 6.1 L 13.3 5.9","0 8.5 M 15.7 -6.9 L 14.8 -6.5 L 14.3 -5.5 L 14.6 -4.9 L 15.2 -4.7 L 15.9 -4.8 L 16.5 -5.5 L 16.6 -6.4 L 16.3 -6.7 L 15.7 -6.9 M 13.5 8.1 L 12.9 8.2 L 12.2 8.0 L 11.9 7.4 L 12.4 6.4 L 13.3 6.0 L 14.0 6.2 L 14.3 6.6 L 14.1 7.5 L 13.9 8.7 L 13.5 9.7 L 13.0 10.4 L 12.4 11.1 L 11.3 11.9","0 16.3 M 24.8 -6.2 L 11.9 .5 L 22.4 7.3","0 18.6 M 13.9 -4.7 L 26.5 -4.7 M 12.7 1.6 L 25.3 1.6","0 16.3 M 11.2 7.6 L 24.3 .8 L 13.6 -6.1","0 17.7 M 17.6 6.0 L 16.7 6.4 L 16.2 7.4 L 16.6 8.0 L 17.2 8.2 L 17.8 8.1 L 18.4 7.5 L 18.6 6.6 L 18.3 6.2 L 17.6 6.0 M 18.2 2.7 L 18.4 1.3 L 19.1 .2 L 20.1 -.8 L 21.9 -2.0 L 23.6 -3.2 L 24.9 -4.4 L 26.1 -5.7 L 26.6 -6.9 L 26.7 -8.5 L 26.3 -10.3 L 25.3 -11.8 L 23.9 -12.7 L 22.1 -13.2 L 20.1 -13.1 L 18.5 -12.8 L 17.0 -12.3 L 15.5 -11.4 L 14.2 -10.1 L 13.6 -8.8 L 13.2 -7.3","0 29.4 M 31.3 -6.4 L 29.4 4.4 L 27.4 6.4 L 24.7 7.9 L 21.6 8.2 L 19.0 6.8 L 17.9 4.9 L 17.7 1.8 L 18.3 -1.8 L 20.6 -4.9 L 23.2 -6.6 L 25.5 -7.1 L 28.1 -6.3 L 29.5 -4.7 L 30.3 -3.5 L 30.6 -2.1 L 29.2 5.8 L 29.9 7.5 L 31.5 8.3 L 33.3 7.9 L 35.0 6.2 L 36.1 4.5 L 37.0 2.1 L 37.6 -1.5 L 37.5 -3.9 L 37.0 -6.5 L 35.8 -8.8 L 34.4 -10.4 L 32.7 -11.8 L 30.7 -12.7 L 28.9 -13.0 L 26.8 -13.2 L 24.3 -12.8 L 21.7 -12.0 L 18.7 -10.2 L 16.6 -8.3 L 14.6 -5.7 L 13.4 -3.1 L 12.6 -.3 L 12.2 2.9 L 12.5 6.0 L 13.4 8.4 L 14.6 10.3 L 16.9 12.2 L 19.8 13.6 L 22.4 13.7 L 25.5 13.6 L 28.0 12.9 L 29.6 12.0 L 30.9 11.0","0 23.1 M 9.1 7.9 L 15.1 7.9 L 11.9 7.9 L 23.8 -13.0 L 26.8 .3 L 16.2 .3 L 26.8 .3 L 28.5 8.0 L 25.3 8.0 L 31.4 8.0","0 21.0 M 14.1 -12.9 L 24.7 -12.9 L 26.3 -12.4 L 27.5 -11.5 L 28.3 -10.0 L 28.2 -8.5 L 28.0 -6.9 L 27.2 -5.6 L 26.1 -4.5 L 25.0 -3.6 L 23.7 -3.1 L 22.6 -2.8 L 15.8 -2.8 L 22.8 -2.8 L 24.0 -2.8 L 25.7 -2.5 L 27.2 -1.6 L 27.9 -.1 L 28.1 1.6 L 27.7 3.5 L 27.0 5.1 L 25.7 6.6 L 24.2 7.5 L 22.7 7.8 L 21.7 8.0 L 10.9 8.0 L 13.8 8.0 L 17.4 -12.8","0 22.2 M 32.0 -13.1 L 30.9 -6.8 L 31.4 -9.8 L 29.7 -11.0 L 28.2 -12.1 L 26.6 -12.9 L 24.5 -13.1 L 22.5 -13.0 L 20.2 -12.3 L 17.7 -10.9 L 15.6 -8.6 L 14.1 -6.2 L 13.3 -3.7 L 12.8 -.5 L 13.1 2.2 L 13.9 4.6 L 15.9 6.8 L 18.7 8.0 L 23.2 8.1 L 25.7 7.4 L 27.5 6.4 L 28.8 5.3","0 23.5 M 10.6 7.9 L 20.6 7.9 L 23.1 7.3 L 25.4 6.2 L 27.9 4.1 L 29.6 2.0 L 30.8 -.4 L 31.4 -3.9 L 31.3 -6.5 L 30.3 -9.1 L 29.0 -10.9 L 26.8 -12.3 L 24.5 -13.0 L 14.3 -13.0 L 17.5 -13.0 L 13.8 7.8","0 19.7 M 26.5 3.3 L 25.7 7.9 L 10.4 7.9 L 13.7 7.9 L 15.5 -2.6 L 24.5 -2.6 L 24.9 -5.2 L 24.0 .0 L 24.5 -2.6 L 15.5 -2.6 L 17.3 -12.8 L 14.4 -12.8 L 29.1 -12.8 L 28.4 -8.4","0 18.7 M 10.6 8.0 L 17.3 8.0 L 13.9 8.0 L 15.8 -2.6 L 24.9 -2.6 L 24.4 .0 L 25.3 -5.2 L 24.9 -2.7 L 15.7 -2.7 L 17.5 -12.9 L 14.4 -12.9 L 28.9 -12.9 L 28.2 -8.4","0 24.5 M 27.2 -2.7 L 33.5 -2.7 L 30.2 -2.7 L 28.3 8.1 L 28.9 4.7 L 26.8 6.3 L 24.6 7.5 L 22.1 8.2 L 20.1 8.2 L 18.4 8.0 L 16.1 7.1 L 14.7 5.4 L 13.2 2.8 L 13.0 -.9 L 13.4 -4.1 L 15.1 -7.6 L 17.5 -10.4 L 20.5 -12.5 L 23.3 -13.2 L 26.1 -13.0 L 28.7 -12.0 L 30.5 -10.6 L 31.2 -9.1 L 30.8 -6.9 L 31.9 -13.0","0 25.0 M 10.7 8.0 L 16.9 8.0 L 14.0 8.0 L 17.7 -12.8 L 14.3 -12.8 L 20.5 -12.8 L 17.7 -12.8 L 15.9 -2.6 L 30.0 -2.6 L 31.8 -12.9 L 28.9 -12.9 L 34.9 -12.9 L 31.8 -12.9 L 28.1 8.0 L 31.3 8.0 L 25.3 8.0","0 10.8 M 10.5 8.0 L 17.1 8.0 L 13.9 8.0 L 17.6 -13.0 L 20.9 -13.0 L 14.4 -13.0","0 16.5 M 10.4 5.5 L 11.5 7.1 L 13.2 8.1 L 14.8 8.2 L 16.7 8.0 L 18.6 7.1 L 20.1 5.7 L 20.7 4.1 L 21.2 2.5 L 23.9 -12.8 L 20.6 -12.8 L 27.0 -12.8","0 22.2 M 14.2 -12.8 L 20.6 -12.8 L 17.5 -12.8 L 13.8 8.0 L 10.7 8.0 L 16.7 8.0 L 13.8 8.0 L 15.1 .5 L 29.9 -12.8 L 32.8 -12.8 L 26.1 -12.8 L 29.9 -12.8 L 20.4 -4.2 L 27.2 8.0 L 30.0 8.0 L 23.7 8.0","0 18.6 M 14.2 -13.0 L 21.4 -13.0 L 17.6 -13.0 L 13.9 7.9 L 10.7 7.9 L 25.6 7.9 L 26.4 3.5","0 31.0 M 10.6 8.0 L 16.8 8.0 L 13.9 8.0 L 17.6 -12.8 L 14.4 -12.8 L 18.2 -12.8 L 24.0 7.8 L 37.3 -12.9 L 41.0 -12.9 L 37.7 -12.9 L 34.0 8.0 L 31.3 8.0 L 37.2 8.0","0 25.2 M 10.7 7.9 L 16.8 7.9 L 13.9 7.9 L 17.6 -12.8 L 14.3 -12.8 L 17.9 -12.8 L 27.9 8.0 L 31.6 8.0 L 28.4 8.0 L 32.1 -12.9 L 29.2 -12.9 L 35.3 -12.9","0 24.9 M 21.1 8.2 L 23.1 8.2 L 26.4 7.0 L 28.7 5.2 L 30.8 2.9 L 32.1 .3 L 33.0 -2.9 L 32.9 -6.5 L 32.2 -8.8 L 31.1 -10.7 L 29.2 -12.1 L 27.2 -12.8 L 24.9 -13.1 L 22.2 -12.8 L 19.2 -11.7 L 16.9 -10.0 L 14.7 -7.4 L 13.6 -4.9 L 12.9 -2.3 L 12.8 .4 L 13.1 2.6 L 13.8 4.3 L 15.1 6.1 L 16.9 7.3 L 19.1 8.0 L 21.1 8.2","0 20.6 M 10.7 8.0 L 17.5 8.0 L 14.0 8.0 L 17.6 -12.8 L 14.5 -12.8 L 25.6 -12.8 L 27.1 -12.5 L 28.6 -11.6 L 29.6 -10.4 L 29.9 -8.6 L 29.5 -6.3 L 28.7 -3.8 L 27.2 -2.0 L 25.4 -1.0 L 23.3 -.7 L 15.6 -.7","0 25.2 M 18.5 7.9 L 16.2 7.1 L 14.3 5.2 L 12.9 2.4 L 12.8 -.3 L 13.1 -3.2 L 14.5 -7.1 L 16.6 -9.9 L 19.9 -12.2 L 23.2 -13.1 L 26.4 -13.1 L 29.2 -12.2 L 30.9 -10.8 L 32.2 -9.1 L 32.9 -6.5 L 33.0 -3.9 L 32.5 -.8 L 31.3 1.9 L 29.5 4.4 L 27.3 6.4 L 24.9 7.6 L 22.7 8.1 L 20.3 8.2 L 18.8 7.9 L 18.5 7.5 L 19.8 5.7 L 21.7 5.0 L 22.9 5.4 L 23.5 6.5 L 23.7 8.7 L 24.1 10.0 L 25.2 10.8 L 26.6 10.6 L 27.8 10.0","0 22.1 M 10.9 7.9 L 17.2 7.9 L 14.0 7.9 L 17.6 -12.8 L 14.6 -12.8 L 25.6 -12.8 L 27.5 -12.4 L 28.8 -11.6 L 29.9 -10.0 L 30.0 -8.2 L 29.6 -6.6 L 28.7 -4.6 L 27.6 -3.5 L 26.1 -2.5 L 24.3 -2.1 L 15.7 -2.1 L 21.4 -2.1 L 26.9 8.0 L 23.4 8.0 L 29.6 8.0","0 21.1 M 11.9 8.0 L 12.9 1.9 L 12.4 4.9 L 13.6 5.9 L 15.6 7.3 L 18.1 8.1 L 21.3 8.2 L 23.9 7.5 L 26.2 6.0 L 27.5 4.2 L 28.1 1.7 L 27.3 -.2 L 25.4 -1.4 L 23.0 -2.2 L 19.1 -3.4 L 16.1 -4.6 L 14.9 -5.8 L 14.4 -7.4 L 15.0 -9.7 L 16.4 -11.5 L 18.3 -12.6 L 20.8 -13.0 L 23.9 -13.0 L 25.8 -12.3 L 27.3 -11.3 L 28.4 -10.3 L 29.2 -9.3 L 28.8 -6.8 L 29.9 -13.0","0 20.0 M 15.5 8.0 L 22.0 8.0 L 18.6 8.0 L 22.2 -12.8 L 14.0 -12.8 L 13.2 -8.1 L 14.0 -12.8 L 30.6 -12.8 L 29.8 -8.1","0 24.7 M 13.7 -12.9 L 19.8 -12.9 L 17.0 -12.9 L 14.3 2.4 L 14.6 4.0 L 15.4 5.5 L 16.6 6.8 L 18.1 7.8 L 19.9 8.2 L 22.2 8.2 L 24.4 7.4 L 26.4 6.2 L 28.0 4.8 L 29.0 3.3 L 29.4 1.8 L 32.0 -12.8 L 29.1 -12.8 L 35.3 -12.8","0 23.3 M 12.9 -12.9 L 19.0 -12.9 L 15.7 -12.9 L 20.2 8.0 L 32.0 -12.8 L 28.9 -12.8 L 35.0 -12.8","0 32.1 M 12.9 -13.0 L 18.9 -13.0 L 15.8 -13.0 L 18.6 8.1 L 28.2 -13.0 L 30.7 8.1 L 41.0 -12.9 L 38.0 -12.9 L 43.7 -12.9","0 21.2 M 9.6 7.9 L 15.7 7.9 L 12.3 7.9 L 29.6 -12.8 L 32.2 -12.8 L 26.2 -12.8 M 13.4 -12.9 L 19.6 -12.9 L 16.4 -12.9 L 26.4 7.9 L 28.9 7.9 L 23.1 7.9","0 20.6 M 15.9 8.0 L 22.0 8.0 L 18.7 8.0 L 20.3 -1.2 L 15.7 -12.8 L 12.9 -12.8 L 18.9 -12.8 L 15.6 -12.8 L 20.3 -1.1 L 29.1 -12.9 L 26.3 -12.9 L 32.2 -12.9","0 20.1 M 14.3 -8.4 L 15.1 -13.0 L 30.0 -13.0 L 11.1 7.9 L 25.8 7.9 L 26.6 3.6","0 10.0 M 16.2 12.8 L 11.9 12.8 L 16.8 -15.1 L 21.0 -15.1","0 16.8 M 13.8 -13.0 L 23.7 8.0","0 9.8 M 9.1 12.7 L 13.3 12.7 L 18.2 -15.1 L 14.2 -15.1","0 15.4 M 12.7 -5.8 L 20.3 -13.9 L 25.0 -5.8","0 22.9 M 14.8 10.3 L 24.3 10.3","0 8.3 M 14.9 -13.5 L 17.2 -9.3","0 18.7 M 14.1 -5.2 L 16.0 -6.5 L 18.5 -7.1 L 21.1 -6.9 L 22.9 -6.3 L 24.2 -4.5 L 24.4 -2.9 L 23.2 4.0 L 21.5 5.7 L 19.1 7.4 L 16.8 8.2 L 13.9 8.0 L 11.9 6.8 L 11.2 5.2 L 11.5 3.4 L 12.7 1.5 L 15.3 .1 L 18.1 -.2 L 23.9 -.2 L 22.5 7.9 L 25.6 7.9","0 19.4 M 12.9 -12.9 L 16.1 -12.9 L 12.4 8.0 L 13.1 3.8 L 14.1 5.3 L 15.6 7.0 L 16.8 7.8 L 19.0 8.3 L 21.2 8.0 L 23.4 6.8 L 25.4 4.6 L 26.5 2.2 L 27.0 -.8 L 26.8 -2.8 L 26.0 -4.6 L 24.4 -5.8 L 22.4 -6.5 L 20.3 -6.6 L 15.0 -6.6","0 17.8 M 26.5 -6.8 L 25.6 -1.7 L 25.9 -3.7 L 24.1 -5.5 L 21.4 -6.8 L 19.1 -6.8 L 17.0 -6.2 L 15.1 -4.9 L 13.5 -2.9 L 12.6 -.6 L 12.1 2.1 L 12.4 4.4 L 13.6 6.7 L 15.7 8.0 L 17.4 8.2 L 19.3 8.2 L 22.3 7.3 L 24.2 5.9","0 20.4 M 24.2 -12.9 L 27.9 -12.9 L 24.9 4.1 L 22.5 6.0 L 20.4 7.5 L 17.9 8.2 L 16.4 8.1 L 13.8 7.1 L 12.4 5.0 L 12.0 2.2 L 12.6 -1.0 L 14.2 -3.7 L 16.9 -5.8 L 19.4 -6.6 L 21.8 -6.7 L 26.8 -6.7 L 24.2 8.0 L 27.2 8.0","0 18.4 M 12.6 .4 L 25.9 .4 L 26.3 -1.8 L 26.0 -3.7 L 25.2 -5.0 L 23.7 -6.3 L 21.6 -6.9 L 19.3 -7.0 L 16.9 -6.1 L 14.7 -4.4 L 13.4 -2.4 L 12.7 -.2 L 12.2 2.2 L 12.4 4.1 L 13.6 6.4 L 15.3 7.7 L 16.8 8.2 L 19.3 8.2 L 22.0 7.4 L 24.3 6.0","0 13.8 M 10.6 7.9 L 17.3 7.9 L 13.7 7.9 L 16.2 -6.7 L 13.2 -6.7 L 22.0 -6.7 L 16.2 -6.7 L 16.5 -8.5 L 17.2 -10.3 L 18.6 -12.1 L 20.4 -13.0 L 22.4 -13.2 L 24.3 -12.5 L 25.5 -11.3","0 19.6 M 14.4 5.9 L 12.2 6.8 L 10.6 8.2 L 9.9 9.9 L 9.8 11.9 L 11.5 13.6 L 13.8 14.1 L 16.6 14.3 L 19.5 14.2 L 22.0 13.5 L 23.7 12.4 L 24.8 11.0 L 25.2 9.0 L 24.6 7.3 L 22.9 6.3 L 20.6 5.7 L 18.7 5.7 L 16.7 5.8 L 14.8 5.9 L 13.3 5.6 L 11.8 5.0 L 11.7 3.9 L 12.5 2.8 L 14.2 1.8 L 15.5 2.5 L 17.5 3.0 L 19.8 3.0 L 22.2 2.4 L 24.5 1.0 L 25.5 -.7 L 26.0 -3.2 L 25.7 -4.7 L 25.0 -5.8 L 26.6 -6.8 L 29.6 -6.8 L 28.9 -3.1 L 29.6 -6.8 L 26.8 -6.8 L 25.0 -5.8 L 23.4 -6.6 L 20.6 -7.0 L 17.7 -6.6 L 14.5 -5.0 L 13.3 -2.7 L 13.1 -.6 L 13.7 1.1 L 14.3 1.9","0 21.0 M 13.9 -12.9 L 17.0 -12.9 L 13.3 7.9 L 10.3 7.9 L 16.1 7.9 L 13.3 7.9 L 15.2 -2.9 L 17.3 -4.8 L 19.3 -6.3 L 21.7 -7.0 L 23.5 -7.0 L 25.3 -6.4 L 26.4 -5.5 L 27.2 -3.9 L 27.0 -1.9 L 25.3 8.0 L 22.5 8.0 L 28.3 8.0","0 9.8 M 10.6 8.0 L 17.2 8.0 L 13.8 8.0 L 16.4 -6.8 L 13.2 -6.8 M 16.8 -9.9 L 17.7 -10.4 L 17.9 -11.2 L 17.4 -11.7 L 16.5 -11.5 L 16.1 -10.7 L 16.2 -10.3 L 16.8 -9.9","0 8.4 M 4.2 12.6 L 5.2 13.6 L 6.6 14.3 L 8.5 14.3 L 10.3 13.6 L 11.8 12.4 L 12.7 9.9 L 15.6 -6.5 L 12.5 -6.5 M 16.1 -9.9 L 16.8 -10.3 L 17.2 -11.2 L 16.7 -11.7 L 15.8 -11.6 L 15.3 -10.7 L 15.4 -10.2 L 16.1 -9.9","0 19.0 M 13.7 -13.0 L 17.0 -13.0 L 13.3 7.9 L 10.1 7.9 L 16.2 7.9 L 13.4 7.9 L 14.1 3.6 L 25.3 -6.7 L 28.0 -6.7 L 21.8 -6.7 L 25.3 -6.7 L 18.9 -.9 L 23.7 8.0 L 26.4 8.0 L 20.4 8.0","0 9.3 M 10.2 8.0 L 16.4 8.0 L 13.2 8.0 L 16.8 -13.0 L 13.8 -13.0","0 30.6 M 10.6 8.0 L 16.6 8.0 L 13.8 8.0 L 16.4 -6.8 L 13.3 -6.8 L 16.3 -6.8 L 15.7 -3.0 L 17.7 -5.0 L 20.1 -6.6 L 22.3 -6.9 L 24.2 -6.6 L 25.2 -5.6 L 26.0 -3.7 L 26.0 -2.0 L 24.2 7.9 L 21.4 7.9 L 27.0 7.9 L 24.3 7.9 L 26.1 -2.2 L 26.6 -3.2 L 28.3 -5.0 L 30.5 -6.5 L 32.5 -6.9 L 34.2 -6.7 L 35.5 -5.9 L 36.5 -4.4 L 36.6 -2.6 L 36.3 -.7 L 34.8 7.9 L 31.9 7.9 L 37.7 7.9","0 21.6 M 10.8 8.0 L 16.5 8.0 L 13.8 8.0 L 16.4 -6.7 L 13.4 -6.7 L 16.4 -6.7 L 15.7 -2.6 L 17.7 -4.8 L 19.5 -6.0 L 21.4 -6.9 L 23.1 -7.0 L 25.0 -6.7 L 26.6 -5.9 L 27.5 -4.4 L 27.7 -3.1 L 27.5 -1.5 L 25.8 7.8 L 23.0 7.8 L 29.1 7.8","0 19.1 M 18.2 8.2 L 20.4 8.0 L 22.9 6.8 L 25.0 4.9 L 26.2 2.5 L 26.8 -.1 L 26.8 -2.3 L 26.0 -4.4 L 24.6 -5.8 L 22.6 -6.8 L 20.9 -7.0 L 18.2 -6.7 L 15.3 -4.9 L 13.5 -2.7 L 12.4 .1 L 12.1 2.8 L 12.8 5.2 L 14.2 7.1 L 16.4 8.1 L 18.2 8.2","0 20.3 M 8.8 14.2 L 15.8 14.2 L 11.9 14.2 L 15.6 -6.7 L 12.8 -6.7 L 15.6 -6.7 L 14.9 -2.9 L 17.3 -4.8 L 20.4 -6.8 L 23.3 -7.1 L 26.0 -6.0 L 27.4 -3.7 L 27.6 -.7 L 27.0 2.2 L 26.0 4.6 L 24.2 6.3 L 22.0 7.4 L 20.0 7.8 L 18.4 8.0 L 13.1 8.0","0 20.0 M 19.5 14.1 L 26.2 14.1 L 22.9 14.1 L 26.6 -6.8 L 25.9 -3.0 L 24.9 -4.4 L 23.6 -5.7 L 21.8 -6.7 L 19.8 -7.1 L 17.7 -6.6 L 15.3 -5.2 L 13.8 -3.4 L 12.9 -1.6 L 12.3 .5 L 12.2 2.6 L 12.5 4.5 L 13.9 6.4 L 16.0 7.6 L 18.8 7.9 L 24.0 7.9","0 16.6 M 17.4 8.0 L 10.4 8.0 L 13.6 8.0 L 16.2 -6.7 L 13.3 -6.7 L 16.2 -6.7 L 15.3 -2.1 L 17.0 -3.7 L 18.6 -5.0 L 20.3 -6.0 L 21.9 -6.7 L 23.6 -6.9 L 26.0 -6.9 L 25.3 -3.0","0 17.9 M 11.4 8.0 L 12.3 2.8 L 11.9 5.0 L 13.0 6.2 L 14.3 7.3 L 16.2 8.1 L 18.0 8.3 L 20.4 8.0 L 22.8 7.1 L 24.1 5.8 L 24.6 4.4 L 24.6 2.8 L 23.4 1.7 L 21.8 1.1 L 18.9 .6 L 16.1 .1 L 14.5 -.6 L 13.4 -1.6 L 13.2 -2.8 L 13.5 -4.1 L 14.5 -5.4 L 16.4 -6.6 L 18.2 -6.9 L 20.8 -6.9 L 22.4 -6.4 L 23.6 -5.6 L 24.6 -4.5 L 25.3 -3.7 L 25.0 -1.6 L 25.9 -6.7","0 12.9 M 16.7 -12.9 L 15.6 -6.7 L 12.5 -6.7 L 21.7 -6.7 L 15.6 -6.7 L 13.6 4.4 L 13.7 6.0 L 14.4 7.2 L 15.5 8.0 L 16.8 8.2 L 18.4 8.0 L 20.1 7.3 L 21.2 6.5","0 21.1 M 12.3 -6.7 L 15.7 -6.7 L 13.9 3.6 L 13.8 4.9 L 14.3 6.2 L 15.1 7.2 L 16.2 8.0 L 18.0 8.3 L 20.0 8.0 L 22.2 7.2 L 24.0 5.7 L 25.7 4.0 L 25.0 8.0 L 28.2 8.0 L 25.0 8.0 L 27.6 -6.8 L 24.4 -6.8","0 20.0 M 11.7 -6.7 L 18.0 -6.7 L 14.8 -6.7 L 18.6 8.1 L 27.7 -6.7 L 30.3 -6.7 L 24.5 -6.7","0 27.7 M 12.0 -6.7 L 18.1 -6.7 L 15.0 -6.7 L 17.7 8.0 L 25.1 -6.7 L 27.3 8.1 L 35.2 -6.8 L 38.2 -6.8 L 32.0 -6.8","0 18.7 M 10.0 8.0 L 16.2 8.0 L 12.7 8.0 L 25.8 -6.7 L 28.1 -6.7 L 22.3 -6.7 M 18.9 -6.7 L 12.7 -6.7 L 15.4 -6.7 L 23.3 8.0 L 25.8 8.0 L 19.8 8.0","0 20.2 M 9.6 12.7 L 10.3 13.5 L 11.3 14.4 L 12.6 14.4 L 13.9 14.4 L 15.4 13.6 L 17.0 12.0 L 18.7 9.2 L 27.6 -6.6 L 30.2 -6.6 L 24.5 -6.6 M 12.2 -6.7 L 17.9 -6.7 L 15.0 -6.7 L 19.3 8.0","0 17.5 M 13.0 -2.7 L 13.7 -6.6 L 26.1 -6.6 L 10.7 8.0 L 23.5 8.0 L 24.2 4.0","0 10.9 M 17.2 12.7 L 15.1 12.7 L 14.3 12.2 L 13.7 11.4 L 13.4 10.5 L 13.5 9.3 L 14.9 1.2 L 14.5 -.1 L 13.6 -.8 L 12.9 -1.2 L 11.6 -1.2 L 13.0 -1.2 L 14.4 -2.0 L 15.4 -2.8 L 15.9 -3.9 L 17.5 -12.9 L 18.1 -13.7 L 19.2 -14.8 L 20.5 -15.3 L 22.1 -15.3","0 8.8 M 11.7 14.4 L 16.5 -12.9","0 10.7 M 9.1 12.8 L 10.8 12.8 L 12.0 12.4 L 12.8 11.6 L 13.6 10.8 L 13.8 9.6 L 15.3 1.4 L 16.0 .2 L 17.1 -.8 L 18.3 -1.2 L 19.4 -1.2 L 18.4 -1.2 L 17.1 -1.8 L 16.5 -2.8 L 16.3 -3.8 L 16.5 -5.1 L 17.9 -12.9 L 17.5 -13.9 L 17.0 -14.6 L 15.9 -15.2 L 14.4 -15.2","0 17.3 M 13.5 -.2 L 13.8 -1.3 L 14.8 -2.5 L 15.9 -3.0 L 17.2 -2.9 L 18.4 -2.3 L 19.2 -1.2 L 20.2 -.3 L 21.8 .1 L 23.3 -.5 L 24.1 -1.3 L 24.4 -2.6","0 14.7 M 17.8 -3.4 L 19.1 -3.4 L 20.6 -4.2 L 21.7 -5.0 L 22.6 -6.0 L 23.2 -7.2 L 23.5 -8.6 L 23.5 -9.8 L 23.1 -11.1 L 22.2 -12.2 L 20.9 -12.9 L 19.6 -13.0 L 17.9 -12.7 L 16.1 -11.7 L 14.8 -10.1 L 14.2 -8.4 L 14.0 -6.9 L 14.5 -5.3 L 15.5 -4.1 L 16.6 -3.6 L 17.8 -3.4"]
EMSOsmotron = ["-8 8","0 5.5 M 13.2 -13.0 L 13.2 1.8 M 12.6 6.3 L 12.6 7.4 L 13.8 7.4 L 13.7 6.3 L 12.6 6.3","0 10.5 M 13.0 -12.8 L 13.0 -9.4 M 17.6 -12.8 L 17.6 -9.4","0 22.5 M 20.5 -12.8 L 13.8 7.8 M 30.6 -12.9 L 23.8 7.7 M 12.4 -7.4 L 32.9 -7.4 M 11.6 1.8 L 31.9 1.8","0 22.4 M 12.5 3.8 L 12.5 5.2 L 14.1 6.8 L 29.7 6.8 L 31.4 5.0 L 31.4 -1.1 L 29.6 -2.9 L 14.2 -2.9 L 12.6 -4.5 L 12.6 -10.4 L 14.2 -12.0 L 30.0 -12.0 L 31.4 -10.5 L 31.4 -9.1 M 22.2 -16.2 L 22.2 11.2","0 27.6 M 13.0 -10.7 L 13.0 -6.3 L 14.5 -4.8 L 19.2 -4.8 L 20.8 -6.4 L 20.8 -10.6 L 19.3 -12.2 L 14.6 -12.2 L 13.0 -10.7 M 35.6 -11.5 L 14.6 6.1 M 28.9 1.0 L 28.9 5.4 L 30.5 6.9 L 35.1 6.9 L 36.7 5.3 L 36.7 1.0 L 35.2 -.5 L 30.5 -.5 L 28.9 1.0","0 27.1 M 31.8 -1.5 L 31.8 5.2 L 30.3 6.7 L 14.8 6.7 L 13.3 5.2 L 13.3 -2.5 L 16.1 -4.1 M 31.1 -8.8 L 31.1 -10.4 L 29.4 -12.0 L 16.1 -12.0 L 14.4 -10.3 L 14.4 -5.1 L 36.6 5.9","0 5.9 M 13.1 -12.9 L 13.1 -9.4","0 7.1 M 16.2 -12.0 L 14.9 -12.0 L 13.2 -10.3 L 13.2 5.2 L 14.8 6.8 L 16.2 6.8","0 7.6 M 12.2 -11.9 L 13.6 -11.9 L 15.4 -10.1 L 15.4 5.1 L 13.8 6.7 L 12.3 6.7","0 13.3 M 13.7 -2.4 L 17.2 -6.8 L 11.7 -8.7 M 17.0 -12.5 L 17.1 -6.8 L 22.5 -8.7 M 17.1 -6.8 L 20.5 -2.2","0 12.1 M 16.9 4.9 L 16.9 -6.0 M 11.5 -.6 L 22.4 -.6","0 4.6 M 12.3 6.3 L 12.3 11.0 L 13.6 9.7 L 13.6 6.4 L 12.3 6.3","0 14.4 M 12.1 -.7 L 23.2 -.7","0 5.3 M 12.3 6.3 L 12.3 7.4 L 13.8 7.4 L 13.8 6.3 L 12.3 6.3","0 14.4 M 10.5 6.0 L 25.2 -11.2","0 24.2 M 13.1 -10.0 L 13.1 5.1 L 14.9 6.8 L 30.7 6.8 L 32.6 5.0 L 32.6 -10.4 L 31.0 -12.0 L 15.1 -12.0 L 13.1 -10.0 M 13.3 5.0 L 32.4 -10.5","0 10.6 M 12.6 -7.1 L 17.5 -12.8 L 18.2 -12.8 L 18.2 7.7","0 23.5 M 13.1 -9.0 L 13.1 -10.2 L 15.1 -12.2 L 30.7 -12.2 L 32.5 -10.3 L 32.5 -4.2 L 30.7 -2.4 L 15.0 -2.4 L 13.1 -.5 L 13.1 6.7 L 33.3 6.7","0 23.5 M 12.9 -9.0 L 12.9 -10.7 L 14.1 -11.9 L 29.4 -11.9 L 31.2 -10.1 L 31.2 -4.3 L 29.9 -3.0 L 16.1 -3.0 L 29.9 -3.0 L 31.8 -1.1 L 31.8 4.9 L 30.0 6.7 L 14.4 6.7 L 13.0 5.2 L 13.0 4.4","0 20.7 M 26.7 7.7 L 26.7 -12.5 L 11.0 .9 L 31.1 .9","0 24.1 M 13.6 3.9 L 13.6 5.0 L 15.3 6.7 L 31.3 6.7 L 33.1 4.9 L 33.1 -1.1 L 31.4 -2.8 L 13.5 -2.8 L 13.5 -11.9 L 34.0 -11.9","0 22.9 M 29.5 -12.0 L 14.8 -12.0 L 13.2 -10.4 L 13.2 5.0 L 15.1 6.9 L 30.7 6.9 L 32.5 5.1 L 32.5 -1.2 L 30.7 -2.9 L 14.2 -2.9 L 13.1 -3.9","0 19.0 M 10.5 -11.9 L 24.9 -11.9 L 26.7 -10.2 L 26.7 7.8","0 23.5 M 15.2 6.7 L 30.8 6.7 L 32.5 5.0 L 32.5 -1.3 L 30.7 -3.1 L 14.4 -3.1 L 13.0 -4.5 L 13.0 -10.3 L 14.8 -12.1 L 30.6 -12.1 L 32.4 -10.3 L 32.4 -4.5 L 30.9 -2.9 L 14.4 -2.9 L 12.9 -1.5 L 12.9 5.1 L 15.2 6.7","0 23.5 M 13.5 6.8 L 30.3 6.8 L 32.2 5.0 L 32.2 -10.3 L 30.3 -12.2 L 15.1 -12.2 L 13.1 -10.1 L 13.1 -4.1 L 14.9 -2.3 L 32.0 -2.3","0 5.2 M 12.2 -8.7 L 12.2 -7.4 L 13.8 -7.4 L 13.8 -8.7 L 12.2 -8.7 M 12.1 6.3 L 12.1 7.6 L 13.6 7.6 L 13.6 6.3 L 12.1 6.3","0 5.2 M 12.9 -8.7 L 12.9 -7.3 L 14.3 -7.3 L 14.3 -8.7 L 12.9 -8.7 M 13.0 6.5 L 13.0 10.9 L 14.2 9.7 L 14.2 6.5 L 13.0 6.5","0 12.6 M 21.9 -7.5 L 10.9 -.9 L 22.1 5.6","0 17.7 M 12.0 -3.6 L 27.0 -3.6 M 11.8 2.4 L 27.1 2.4","0 13.2 M 12.0 -7.9 L 23.8 -.8 L 12.1 5.8","0 19.0 M 11.6 -12.0 L 27.3 -12.0 L 29.2 -10.1 L 29.2 -3.6 L 27.3 -1.7 L 18.0 -1.7 L 16.0 .3 L 16.0 1.7 M 15.3 6.3 L 15.3 7.5 L 16.5 7.5 L 16.5 6.4 L 15.3 6.3","0 24.1 M 27.6 1.0 L 27.6 -4.8 L 25.8 -6.6 L 20.9 -6.6 L 19.0 -4.8 L 19.0 -.2 L 20.6 1.4 L 33.0 1.4 L 33.0 -10.1 L 31.1 -12.0 L 15.4 -12.0 L 13.6 -10.2 L 13.6 5.2 L 15.2 6.8 L 32.9 6.8","0 23.4 M 13.0 7.8 L 13.0 -10.2 L 14.9 -12.1 L 30.0 -12.1 L 31.8 -10.2 L 31.8 -1.2 L 12.9 -1.2 L 31.8 -1.2 L 31.8 7.7","0 24.0 M 13.1 -11.9 L 29.3 -11.9 L 31.4 -9.8 L 31.4 -4.8 L 30.2 -3.0 L 14.4 -3.0 L 13.3 -4.1 L 13.3 -2.0 L 14.4 -3.0 L 30.2 -3.0 L 32.0 -1.3 L 32.0 5.1 L 30.2 6.9 L 13.0 6.9 L 13.1 -11.9","0 22.8 M 32.8 -12.1 L 14.9 -12.1 L 13.0 -10.2 L 13.0 5.0 L 14.9 6.9 L 32.9 6.9","0 24.0 M 13.0 -12.0 L 13.0 6.8 L 30.0 6.8 L 31.9 4.9 L 31.9 -10.2 L 30.1 -12.0 L 13.0 -12.0","0 21.8 M 31.1 6.8 L 13.1 6.8 L 13.1 -2.9 L 27.5 -2.9 L 13.1 -2.9 L 13.1 -12.0 L 31.0 -12.0","0 19.9 M 13.0 7.7 L 13.0 -2.9 L 27.6 -2.9 L 13.0 -2.9 L 13.0 -12.1 L 31.0 -12.1","0 24.0 M 25.9 -2.3 L 31.8 -2.3 L 31.8 4.6 L 29.6 6.8 L 14.9 6.8 L 13.0 4.9 L 13.0 -10.1 L 15.2 -12.3 L 30.2 -12.3 L 31.8 -10.7 L 31.8 -9.1","0 24.1 M 13.1 -12.8 L 13.1 7.7 L 13.1 -2.8 L 32.4 -2.8 L 32.4 -12.8 L 32.4 7.5","0 5.1 M 13.0 -12.8 L 13.0 7.8","0 22.3 M 30.6 -12.9 L 30.6 5.5 L 29.2 6.9 L 13.1 6.9 L 11.3 5.0 L 11.3 3.2","0 22.3 M 13.0 -12.9 L 13.0 7.6 L 13.0 -2.9 L 21.9 -2.9 L 30.4 7.5 L 21.8 -2.9 L 30.5 -12.9","0 22.4 M 13.7 -12.7 L 13.7 6.7 L 33.5 6.7","0 26.3 M 13.1 7.5 L 13.1 -12.6 L 14.1 -12.5 L 24.0 -.9 L 33.8 -12.6 L 34.7 -12.6 L 34.7 7.7","0 24.1 M 12.9 7.5 L 12.9 -12.4 L 14.3 -12.4 L 31.1 7.4 L 31.9 7.4 L 31.8 -12.6","0 23.4 M 13.0 -10.2 L 13.0 5.1 L 14.7 6.7 L 30.3 6.7 L 31.9 5.1 L 31.9 -10.5 L 30.3 -11.9 L 14.6 -12.0 L 13.0 -10.2","0 22.4 M 12.9 7.7 L 12.9 -11.9 L 30.4 -11.9 L 31.9 -10.4 L 31.9 -2.6 L 30.3 -1.0 L 14.4 -1.0 L 12.9 -2.5","0 25.2 M 35.7 6.7 L 14.7 6.7 L 13.0 5.0 L 13.0 -10.4 L 14.7 -12.1 L 30.1 -12.1 L 32.0 -10.2 L 32.0 5.2 L 30.4 6.7","0 23.4 M 12.9 7.7 L 12.9 -12.0 L 30.2 -12.0 L 31.9 -10.3 L 31.9 -2.9 L 30.1 -1.2 L 14.3 -1.2 L 12.8 -2.7 L 14.3 -1.2 L 23.8 -1.2 L 31.1 7.7","0 23.5 M 13.0 3.9 L 13.0 5.4 L 14.3 6.7 L 30.2 6.7 L 31.7 5.2 L 31.7 -1.3 L 30.2 -2.8 L 14.5 -2.8 L 13.0 -4.4 L 13.0 -10.4 L 14.8 -12.2 L 30.4 -12.2 L 31.9 -10.7 L 31.9 -9.1","0 21.3 M 21.5 7.7 L 21.5 -12.0 L 11.3 -12.0 L 31.6 -12.0","0 23.6 M 13.0 -12.7 L 13.0 5.1 L 14.6 6.8 L 30.3 6.8 L 31.9 5.1 L 31.9 -12.9","0 29.1 M 12.9 -12.7 L 24.8 7.6 L 37.0 -12.8","0 33.9 M 12.7 -12.7 L 20.2 7.5 L 27.7 -12.9 L 35.8 7.8 L 43.3 -13.0","0 22.9 M 13.5 7.5 L 30.8 -12.8 L 22.2 -2.6 L 13.5 -12.7 L 30.9 7.7","0 23.0 M 12.3 -12.7 L 21.6 -1.3 L 21.6 7.7 L 21.6 -1.3 L 30.9 -12.7","0 23.4 M 12.0 -12.0 L 31.8 -12.0 L 31.8 -10.4 L 13.3 5.1 L 13.3 6.7 L 31.9 6.7","0 7.0 M 16.2 6.8 L 13.1 6.8 L 13.1 -11.9 L 16.2 -11.9","0 14.4 M 10.3 -12.0 L 25.0 5.9","0 7.4 M 12.0 -12.0 L 14.8 -12.0 L 14.8 6.6 L 12.0 6.6","0 17.9 M 28.3 -2.2 L 19.6 -12.4 L 11.0 -2.2","0 23.0 M 11.9 9.2 L 33.1 9.2","0 5.2 M 12.3 -21.5 L 13.2 -17.9","0 19.4 M 12.2 -8.1 L 26.3 -8.1 L 28.0 -6.5 L 28.0 6.8 L 14.5 6.8 L 12.9 5.2 L 12.9 -.5 L 27.8 -.5","0 18.8 M 12.9 -14.5 L 12.9 6.7 L 26.3 6.7 L 27.9 5.0 L 27.9 -6.4 L 26.2 -8.1 L 14.2 -8.1 L 13.1 -7.0","0 19.6 M 28.9 6.8 L 14.7 6.8 L 13.0 5.0 L 13.0 -6.5 L 14.7 -8.2 L 28.9 -8.2","0 18.9 M 27.4 -14.4 L 27.4 6.8 L 13.7 6.8 L 11.9 4.9 L 11.9 -6.2 L 13.6 -7.9 L 25.8 -7.9 L 27.3 -6.5","0 19.6 M 28.8 6.9 L 14.6 6.9 L 13.0 5.2 L 13.0 -6.4 L 14.7 -8.2 L 26.3 -8.2 L 28.0 -6.5 L 28.0 -.7 L 12.9 -.7","0 10.9 M 12.9 7.6 L 12.9 -8.0 L 21.3 -8.0 L 12.9 -8.0 L 12.9 -12.1 L 14.6 -13.8 L 21.4 -13.8","0 19.5 M 14.9 13.7 L 26.1 13.7 L 27.9 11.9 L 27.9 -6.6 L 26.1 -8.4 L 14.2 -8.4 L 12.4 -6.6 L 12.4 5.4 L 13.9 6.9 L 26.0 6.9 L 27.8 5.1","0 19.1 M 13.0 7.6 L 13.0 -14.5 L 13.0 -8.1 L 26.3 -8.1 L 28.1 -6.4 L 28.1 7.7","0 4.6 M 13.0 7.7 L 12.9 7.5 L 12.9 -8.7 M 12.4 -13.1 L 12.4 -14.4 L 13.7 -14.4 L 13.7 -13.1 L 12.4 -13.1","0 6.4 M 5.0 13.8 L 12.6 13.8 L 14.3 12.0 L 14.3 -8.9 M 13.6 -12.9 L 13.6 -14.4 L 15.0 -14.4 L 15.0 -12.9 L 13.6 -12.9","0 18.2 M 13.0 -14.4 L 13.0 7.8 L 13.0 -.6 L 19.6 -.6 L 27.0 -8.9 L 19.6 -.6 L 27.1 7.7","0 7.4 M 12.8 -14.5 L 12.8 5.0 L 14.6 6.8 L 17.8 6.8","0 28.1 M 12.9 7.5 L 12.9 -8.0 L 23.6 -8.0 L 25.1 -6.6 L 25.1 7.8 L 25.1 -6.6 L 26.5 -8.0 L 35.5 -8.0 L 37.1 -6.4 L 37.1 7.7","0 19.4 M 12.9 7.7 L 12.9 -7.8 L 26.5 -7.8 L 28.0 -6.3 L 28.0 7.8","0 20.1 M 13.6 -6.1 L 13.6 5.0 L 15.3 6.8 L 26.9 6.8 L 28.5 5.2 L 28.5 -6.8 L 27.1 -8.3 L 15.6 -8.3 L 13.6 -6.1","0 18.6 M 13.1 14.7 L 13.1 -7.9 L 26.7 -7.9 L 28.1 -6.6 L 28.1 5.7 L 26.8 7.0 L 14.7 7.0 L 13.3 5.6","0 19.0 M 27.2 14.5 L 27.2 -8.0 L 13.4 -8.0 L 11.8 -6.5 L 11.8 5.1 L 13.5 6.8 L 25.3 6.8 L 27.0 5.2","0 13.9 M 13.0 7.8 L 13.0 -6.5 L 14.7 -8.3 L 24.8 -8.3","0 19.6 M 13.0 4.4 L 13.0 5.4 L 14.4 6.8 L 26.4 6.8 L 27.9 5.2 L 27.9 .9 L 26.5 -.5 L 14.8 -.5 L 13.2 -2.1 L 13.2 -6.6 L 14.9 -8.2 L 26.2 -8.2 L 27.8 -6.6 L 27.8 -5.7","0 11.0 M 13.0 -14.6 L 13.0 -8.0 L 21.3 -8.0 L 13.0 -8.0 L 13.0 5.4 L 14.1 6.6 L 21.3 6.6","0 20.0 M 13.5 -8.8 L 13.5 5.3 L 14.9 6.7 L 26.8 6.7 L 28.5 4.9 L 28.5 -9.0","0 22.4 M 12.5 -8.8 L 21.6 7.7 L 31.2 -9.0","0 30.9 M 12.8 -8.6 L 19.3 6.9 L 26.2 -8.7 L 33.7 6.7 L 39.8 -8.9","0 19.5 M 13.3 7.7 L 27.1 -8.8 L 20.2 -.6 L 13.3 -8.9 L 27.2 7.6","0 18.9 M 14.9 13.7 L 26.1 13.7 L 27.9 11.9 L 27.9 -8.9 L 27.9 5.7 L 26.7 6.8 L 14.0 6.8 L 12.3 5.1 L 12.3 -8.8","0 20.1 M 12.3 -8.1 L 28.3 -8.1 L 28.3 -6.9 L 12.5 5.7 L 12.5 6.7 L 28.2 6.7","0 7.6 M 16.8 6.7 L 15.2 6.7 L 13.8 5.3 L 13.8 -.3 L 11.4 -2.7 L 13.8 -5.1 L 13.8 -10.3 L 15.4 -12.0 L 16.8 -12.0","0 5.1 M 12.9 -16.8 L 12.9 11.1","0 7.6 M 12.4 6.7 L 13.9 6.7 L 15.3 5.3 L 15.3 -.3 L 17.8 -2.7 L 15.4 -5.1 L 15.4 -10.3 L 13.7 -12.0 L 12.4 -12.0","0 10.8 M 11.2 -1.3 L 14.0 -1.7 L 18.3 .2 L 20.6 -.4","0 12.0 M 12.3 -11.3 L 12.3 -6.2 L 13.6 -4.9 L 19.2 -4.9 L 20.5 -6.3 L 20.5 -11.4 L 19.0 -12.9 L 13.9 -12.9 L 12.3 -11.3"]
EMSPancakes = ["-8 8","0 9.0 M 12.9 -13.9 L 13.0 -7.6 L 12.3 1.1 M 11.2 5.4 L 12.7 5.4 L 12.8 7.4 L 11.0 7.2 L 11.2 5.4","0 12.6 M 11.2 -12.8 L 11.3 -6.7 M 16.9 -13.4 L 17.4 -6.2","0 24.7 M 17.4 6.0 L 16.6 -4.4 L 16.9 -9.2 M 23.7 -14.6 L 24.4 -3.2 L 24.5 4.1 M 11.5 .0 L 13.5 .2 L 22.7 -.7 L 26.2 -1.0 L 29.1 -.7 M 10.1 -6.5 L 15.3 -6.3 L 21.4 -7.0 L 28.8 -7.8","0 19.5 M 17.7 9.0 L 17.3 -14.3 M 22.7 -6.8 L 21.6 -9.4 L 19.5 -10.6 L 16.0 -10.7 L 13.1 -9.2 L 11.3 -6.2 L 12.0 -3.6 L 15.1 -2.3 L 18.9 -1.8 L 22.3 -.4 L 23.9 1.5 L 23.9 3.7 L 22.0 5.1 L 16.6 5.3 L 13.0 4.6 L 11.2 2.5","0 26.0 M 12.3 -13.3 L 10.7 -10.5 L 11.1 -7.7 L 13.6 -6.6 L 16.1 -8.6 L 16.4 -10.9 L 15.3 -12.4 L 12.9 -12.3 M 29.2 -14.5 L 21.2 -5.1 L 16.2 2.4 L 11.4 8.8 M 25.4 .4 L 24.0 2.7 L 24.2 5.2 L 26.4 6.7 L 29.2 6.1 L 30.8 3.2 L 29.9 .4 L 28.1 -.4 L 25.4 .4","0 18.5 M 21.1 7.2 L 16.9 2.6 L 14.1 -2.5 L 12.9 -6.3 L 13.8 -8.2 L 15.0 -8.2 L 15.2 -6.6 L 14.5 -4.9 L 12.6 -1.7 L 11.2 2.1 L 11.2 5.6 L 13.4 7.1 L 16.7 5.9 L 20.4 3.3 L 22.6 .8 L 23.2 -1.0","0 6.4 M 10.7 -12.9 L 10.8 -5.9","0 10.0 M 16.3 9.3 L 13.0 5.5 L 11.3 .7 L 11.5 -6.0 L 13.5 -10.7 L 15.7 -13.5","0 9.9 M 9.5 9.0 L 12.4 5.4 L 14.0 .0 L 13.8 -5.6 L 12.0 -10.7 L 9.7 -13.4","0 16.6 M 13.5 -.8 L 15.7 -7.1 L 17.2 -12.5 M 9.9 -9.8 L 15.7 -6.9 L 21.1 -5.2 M 10.1 -4.4 L 21.5 -9.8","0 18.0 M 16.8 4.6 L 17.0 -7.4 M 10.3 -1.5 L 22.6 -1.9","0 8.2 M 9.3 11.1 L 13.7 5.1","0 14.5 M 10.6 -1.4 L 19.0 -1.6","0 6.6 M 10.5 5.5 L 12.2 5.7 L 12.1 7.0 L 10.7 7.2 L 10.5 5.5","0 12.5 M 10.9 9.7 L 16.2 -8.8 L 19.1 -16.6","0 22.3 M 10.9 -2.7 L 11.9 -7.5 L 15.1 -10.7 L 19.6 -11.8 L 23.4 -10.8 L 26.0 -8.2 L 27.5 -4.0 L 27.3 .7 L 24.8 4.9 L 20.8 6.7 L 16.0 6.3 L 12.0 2.3 L 10.9 -2.7","0 8.4 M 12.3 6.5 L 11.9 4.7 L 12.7 -10.9 L 12.2 -11.7","0 18.2 M 10.9 -8.9 L 12.5 -11.4 L 16.2 -11.7 L 19.0 -10.8 L 19.9 -7.8 L 18.8 -3.9 L 15.8 1.4 L 12.6 6.6 L 22.4 6.2","0 18.1 M 10.5 6.3 L 10.8 6.3 L 15.5 6.4 L 20.2 5.2 L 22.4 2.1 L 22.3 -.4 L 20.0 -2.3 L 16.1 -2.5 L 14.5 -2.0 L 18.8 -4.2 L 21.9 -7.3 L 22.6 -10.3 L 21.0 -12.0 L 17.0 -11.6 L 13.7 -10.0","0 16.7 M 20.5 7.0 L 20.6 -12.6 M 21.3 -.4 L 13.7 -.5 L 11.8 -1.4 L 10.5 -2.9 L 10.0 -4.9 L 10.2 -9.2","0 19.0 M 11.3 5.8 L 14.6 7.1 L 19.5 6.5 L 22.3 4.6 L 22.9 1.5 L 22.0 -1.4 L 20.0 -3.0 L 17.1 -3.5 L 13.2 -2.1 L 13.2 -11.2 L 14.5 -11.8 L 24.0 -11.6 L 24.3 -11.3","0 20.2 M 18.1 6.3 L 18.0 3.7 L 19.2 .0 L 21.9 -1.9 L 24.6 -2.3 L 25.7 -1.3 L 25.6 .8 L 24.6 3.5 L 21.6 5.8 L 18.7 6.4 L 16.2 6.4 L 12.1 4.5 L 10.5 -.2 L 11.6 -6.3 L 14.7 -11.8","0 15.4 M 9.4 -11.4 L 21.0 -11.2 L 13.9 5.0 L 13.8 6.2","0 16.2 M 22.1 -8.1 L 21.7 -10.6 L 19.1 -12.2 L 15.5 -11.5 L 13.3 -9.9 L 12.1 -8.2 L 13.3 -5.6 L 16.1 -2.3 L 17.7 .3 L 18.5 3.0 L 18.3 5.5 L 16.3 6.9 L 13.3 6.7 L 11.2 5.5 L 11.3 1.5 L 13.2 -1.1 L 17.7 -4.6 L 21.6 -8.0","0 19.0 M 22.1 7.3 L 22.8 .7 L 23.2 -5.6 L 20.8 -4.0 L 17.4 -3.1 L 13.7 -4.0 L 11.1 -5.9 L 10.7 -8.8 L 12.4 -11.1 L 16.6 -12.4 L 20.1 -11.7 L 22.0 -9.5 L 22.4 -5.5","0 7.0 M 10.4 -4.5 L 10.3 -2.7 L 12.0 -2.8 L 12.2 -4.4 L 10.4 -4.5 M 10.2 4.2 L 10.0 6.0 L 12.0 6.2 L 12.0 4.3 L 10.2 4.2","0 6.6 M 10.1 -4.2 L 10.1 -2.4 L 12.1 -2.2 L 12.2 -4.4 L 10.1 -4.2 M 11.2 4.8 L 11.2 5.6 L 9.0 9.6","0 16.6 M 21.8 5.3 L 15.5 2.1 L 10.5 .0 L 16.1 -3.8 L 21.0 -6.3","0 16.2 M 11.2 -5.4 L 18.2 -5.7 L 19.8 -5.6 M 11.4 .0 L 13.9 .4 L 19.3 -.1 L 20.8 .0","0 17.0 M 11.5 4.7 L 17.1 1.5 L 21.3 -1.2 L 21.6 -1.8 L 16.9 -3.8 L 11.1 -6.8","0 15.7 M 12.0 5.5 L 12.0 7.0 L 13.7 7.3 L 13.9 5.6 L 12.0 5.5 M 13.9 1.3 L 12.8 .0 L 14.0 -1.8 L 18.5 -3.9 L 21.6 -6.9 L 21.6 -11.1 L 19.9 -13.6 L 16.9 -14.3 L 13.5 -14.0 L 11.3 -12.2","0 27.8 M 25.4 2.4 L 23.6 3.8 L 20.5 4.6 L 18.2 3.2 L 18.1 .0 L 19.6 -3.4 L 22.9 -4.3 L 25.0 -3.1 L 25.8 -.1 L 25.4 3.2 L 26.5 4.7 L 29.0 5.3 L 30.8 4.6 L 32.0 1.7 L 31.7 -3.9 L 29.1 -7.8 L 24.8 -10.1 L 18.8 -9.6 L 13.7 -6.8 L 10.9 -1.9 L 10.3 2.6 L 12.6 7.7 L 16.2 9.9 L 20.6 10.9 L 26.7 10.5 L 32.4 8.8","0 22.3 M 10.0 6.4 L 18.8 -12.2 L 24.5 -.8 L 26.5 3.6 L 27.5 6.5 L 28.5 8.0 M 12.4 -1.0 L 25.0 -.9","0 19.1 M 12.0 6.2 L 12.0 -11.0 L 14.1 -12.0 L 17.3 -12.5 L 20.2 -12.0 L 21.2 -10.7 L 21.0 -8.8 L 19.3 -7.5 L 14.9 -5.0 L 13.0 -5.0 L 15.0 -6.3 L 20.0 -6.2 L 22.9 -4.9 L 25.0 -2.2 L 25.1 2.0 L 22.5 5.0 L 16.6 6.3 L 12.0 6.2","0 20.2 M 24.4 -6.8 L 24.4 -8.8 L 22.4 -11.2 L 19.2 -12.5 L 15.2 -11.5 L 12.4 -8.7 L 10.7 -4.6 L 10.3 -.1 L 11.5 3.7 L 14.5 6.4 L 18.9 7.0 L 23.5 6.4 L 26.3 5.3 L 26.5 5.1","0 22.1 M 11.2 6.9 L 11.2 -11.5 L 15.3 -12.0 L 19.6 -11.2 L 24.0 -8.6 L 26.8 -4.8 L 27.1 .0 L 24.4 4.3 L 19.5 6.3 L 15.5 6.5 L 11.5 6.3","0 18.2 M 24.1 6.7 L 19.3 5.9 L 11.5 6.4 L 11.4 -3.2 L 20.6 -3.3 L 11.4 -3.1 L 11.3 -11.7 L 11.3 -11.2 L 25.3 -11.1","0 17.6 M 11.1 6.5 L 11.5 -2.5 L 21.5 -3.6 L 11.5 -2.5 L 11.6 -11.3 L 24.0 -11.2 L 24.6 -11.0","0 20.6 M 25.2 -9.4 L 21.9 -11.7 L 16.8 -11.5 L 13.4 -9.0 L 11.2 -5.6 L 10.3 -2.3 L 11.1 1.6 L 13.5 5.1 L 17.2 6.4 L 21.1 6.4 L 24.3 5.0 L 25.5 3.4 L 25.6 6.3 L 25.1 -1.9 L 26.3 -2.0 L 20.5 -1.9","0 20.0 M 10.9 -11.7 L 11.3 6.6 M 11.1 -2.9 L 25.2 -2.9 M 25.1 6.9 L 24.4 -12.1","0 12.2 M 11.1 6.3 L 18.1 6.4 L 14.4 6.2 L 14.3 -11.8 L 11.1 -11.6 L 14.3 -12.0 L 19.1 -11.8","0 14.2 M 9.6 5.2 L 12.4 6.9 L 16.5 5.7 L 19.1 2.8 L 19.6 .2 L 19.2 -11.8","0 19.2 M 12.4 6.9 L 12.2 -12.3 M 22.5 -11.8 L 12.6 -1.2 L 17.6 -6.4 L 25.8 8.4","0 16.1 M 11.1 -11.9 L 11.3 6.5 L 22.9 6.5","0 24.1 M 11.2 6.0 L 11.0 4.9 L 11.1 -6.8 L 11.8 -11.7 L 13.4 -7.0 L 17.6 .9 L 19.1 3.2 L 21.2 .8 L 25.6 -6.4 L 28.7 -11.7 L 28.6 5.2 L 28.2 6.7","0 19.7 M 11.4 6.0 L 11.5 -11.0 L 13.8 -5.8 L 16.4 -1.0 L 18.9 2.5 L 21.9 6.1 L 23.7 7.3 L 24.2 3.0 L 24.7 -12.9","0 23.6 M 10.4 -3.8 L 11.1 .6 L 13.3 3.9 L 16.6 6.2 L 20.4 7.4 L 24.7 5.8 L 28.1 2.6 L 29.3 -2.3 L 28.4 -7.3 L 25.6 -10.9 L 21.6 -12.2 L 17.0 -11.8 L 12.9 -9.5 L 11.2 -6.6 L 10.4 -3.8","0 18.1 M 11.8 6.5 L 11.6 -9.5 L 14.5 -11.5 L 18.7 -12.2 L 22.6 -11.0 L 24.3 -8.2 L 23.7 -4.4 L 20.8 -2.1 L 17.2 -.7 L 14.1 -.8 L 11.1 -.8","0 23.8 M 26.1 4.2 L 23.6 6.1 L 17.7 6.9 L 12.6 4.3 L 10.4 .2 L 10.3 -5.2 L 12.2 -9.4 L 16.2 -11.8 L 21.1 -12.5 L 24.8 -10.3 L 27.8 -6.5 L 28.9 -2.6 L 28.1 .9 L 26.1 4.2 M 21.5 .4 L 25.0 3.2 L 27.4 6.2 L 29.0 8.1","0 19.7 M 12.5 5.9 L 11.4 -6.1 L 11.6 -8.8 L 15.5 -11.7 L 19.1 -12.4 L 22.5 -10.9 L 23.5 -8.1 L 21.9 -6.0 L 19.6 -4.8 L 12.0 -2.5 L 16.7 -3.2 L 19.5 -3.4 L 22.7 -2.5 L 24.6 -1.3 L 25.6 1.4 L 25.7 7.8","0 17.4 M 11.7 4.0 L 12.8 5.9 L 15.9 7.0 L 20.9 5.6 L 23.4 3.1 L 23.7 1.4 L 22.5 -.1 L 20.0 -1.3 L 15.9 -2.3 L 12.6 -3.3 L 10.7 -5.4 L 11.2 -8.4 L 13.6 -10.7 L 16.9 -12.1 L 19.4 -12.3 L 21.4 -11.2 L 21.9 -9.9 L 22.0 -8.0","0 17.6 M 17.5 6.5 L 17.1 .1 L 16.7 -11.4 L 10.7 -11.1 L 22.9 -11.9 L 23.5 -11.7","0 19.1 M 11.5 -11.3 L 10.7 -5.4 L 10.7 -.3 L 12.6 4.9 L 15.4 7.0 L 19.0 6.9 L 21.1 5.5 L 23.5 3.0 L 23.6 5.5 L 23.6 -4.2 L 23.8 -8.0 L 24.6 -11.7","0 19.1 M 9.6 -10.4 L 11.6 -2.9 L 15.4 6.5 L 21.0 -3.1 L 26.4 -11.7","0 25.9 M 10.2 -12.4 L 12.4 -4.4 L 14.5 4.8 L 14.9 6.4 L 15.6 5.9 L 18.6 -3.1 L 21.3 -9.1 L 22.5 -1.8 L 24.9 6.2 L 26.7 2.0 L 28.4 -5.0 L 30.5 -10.8 L 32.4 -14.0","0 14.0 M 10.1 5.8 L 10.6 4.2 L 14.4 -3.8 L 20.5 -13.7 M 9.4 -11.3 L 14.9 -.7 L 17.3 3.7 L 18.8 6.3 L 20.0 7.2","0 15.6 M 12.6 8.1 L 16.4 -.2 L 24.0 -12.4 M 8.7 -11.0 L 16.1 -.1","0 19.2 M 10.5 -11.6 L 22.5 -11.8 L 12.9 2.4 L 11.7 4.8 L 11.5 6.2 L 26.1 6.0","0 9.3 M 14.2 9.3 L 11.0 9.3 L 11.2 -13.2 L 14.4 -13.4","0 12.1 M 17.2 10.0 L 12.2 -9.4 L 9.3 -16.3","0 9.5 M 10.9 9.3 L 13.8 9.1 L 14.0 -13.4 L 11.1 -13.4","0 17.5 M 10.5 .9 L 13.2 -4.4 L 15.6 -10.9 L 18.5 -7.4 L 21.6 -1.7 L 23.1 .4","0 22.0 M 8.9 11.2 L 29.2 11.2","0 8.2 M 8.8 -16.3 L 13.6 -11.3","0 21.7 M 24.6 1.3 L 25.4 -1.9 L 23.9 -5.4 L 20.2 -7.5 L 15.8 -7.2 L 12.8 -4.9 L 10.7 -1.3 L 10.2 2.4 L 12.3 5.3 L 16.1 7.0 L 20.0 6.4 L 23.2 4.1 L 24.4 1.9 L 24.6 5.1 L 25.4 6.7 L 27.4 7.3 L 28.9 6.0","0 18.7 M 11.2 6.8 L 11.2 -13.8 L 11.2 -4.7 L 14.0 -6.6 L 16.6 -7.4 L 19.2 -7.5 L 21.7 -6.4 L 23.3 -4.3 L 23.8 -.9 L 23.3 2.7 L 21.3 5.0 L 18.3 6.5 L 15.2 6.7 L 11.4 5.9","0 17.3 M 22.7 5.9 L 22.0 6.4 L 17.5 6.6 L 13.5 6.1 L 11.2 4.5 L 10.3 .7 L 11.2 -3.4 L 13.6 -6.5 L 17.3 -7.6 L 20.3 -7.2 L 22.1 -5.6 L 22.7 -3.8","0 20.2 M 24.4 6.7 L 24.4 -4.0 L 22.3 -6.3 L 18.8 -7.6 L 14.7 -7.0 L 11.5 -4.6 L 10.3 -1.6 L 10.3 2.0 L 12.0 5.2 L 15.1 7.0 L 18.8 6.9 L 22.5 5.3 L 24.4 3.1 L 24.4 -13.6","0 18.7 M 24.2 5.7 L 21.2 6.7 L 17.5 7.1 L 13.8 6.2 L 10.9 4.3 L 9.8 .8 L 10.3 -3.3 L 13.0 -6.8 L 17.3 -8.0 L 21.2 -7.3 L 23.0 -5.9 L 23.9 -3.4 L 10.1 .9","0 15.1 M 13.9 6.7 L 13.4 -1.7 L 13.6 -6.8 L 9.3 -6.8 L 21.6 -6.8 L 13.5 -6.8 L 13.9 -10.2 L 15.1 -13.1 L 17.8 -14.6 L 20.2 -14.9 L 21.6 -14.2 L 22.8 -13.4","0 18.5 M 15.0 14.4 L 17.7 15.4 L 20.4 15.3 L 22.3 14.1 L 23.2 11.2 L 23.7 5.3 L 23.8 -1.6 L 22.8 2.9 L 20.6 5.9 L 16.8 7.2 L 13.7 6.5 L 10.6 3.7 L 10.0 -.7 L 11.2 -4.8 L 14.3 -7.6 L 18.9 -7.6 L 21.9 -5.2 L 23.5 -1.6","0 19.7 M 10.9 6.8 L 10.9 -13.5 L 10.9 -4.0 L 13.6 -6.3 L 16.7 -7.6 L 19.8 -7.2 L 22.7 -5.8 L 24.5 -3.5 L 24.8 .2 L 24.5 7.2","0 7.7 M 11.2 -15.1 L 10.5 -14.3 L 12.1 -13.0 L 12.7 -14.1 L 11.2 -15.1 M 12.1 -7.7 L 11.6 -3.3 L 11.4 .4 L 11.8 3.6 L 12.1 7.2","0 7.6 M 2.9 15.1 L 6.5 15.1 L 8.8 14.4 L 10.8 13.1 L 11.6 10.8 L 11.9 8.1 L 12.0 -7.7 M 11.8 -12.6 L 12.6 -13.6 L 11.4 -14.9 L 10.3 -14.3 L 11.8 -12.6","0 17.1 M 12.3 -13.9 L 11.6 7.0 L 11.8 1.8 L 22.9 -9.0 L 17.6 -3.8 L 22.9 7.3 L 23.1 8.8","0 9.0 M 11.6 -13.7 L 11.6 4.6 L 12.3 5.8 L 13.7 6.6 L 15.0 6.5 L 16.2 5.5","0 29.8 M 11.2 6.1 L 10.5 2.1 L 10.9 -7.2 L 10.9 -4.4 L 12.8 -6.7 L 16.2 -7.7 L 18.8 -7.1 L 20.5 -5.7 L 21.6 -3.5 L 22.0 -.4 L 21.8 6.2 L 22.0 -2.6 L 23.3 -5.0 L 26.6 -6.7 L 30.2 -6.7 L 32.7 -5.5 L 34.4 -2.3 L 35.0 2.1 L 34.6 6.1 L 34.0 7.6","0 19.6 M 11.5 7.0 L 10.8 -.8 L 10.9 -7.8 L 10.9 -3.3 L 14.0 -6.1 L 18.3 -7.7 L 21.6 -7.1 L 23.3 -5.4 L 24.8 -2.6 L 25.2 1.1 L 24.6 4.6 L 24.1 7.4","0 19.1 M 17.1 7.2 L 20.8 6.1 L 23.5 3.4 L 24.8 -.4 L 23.8 -4.3 L 21.6 -6.9 L 18.3 -7.9 L 14.7 -7.3 L 11.5 -5.2 L 10.0 -1.5 L 10.6 2.3 L 13.3 5.6 L 17.1 7.2","0 19.5 M 11.3 14.4 L 10.9 -5.1 L 14.0 -7.1 L 18.5 -7.4 L 22.5 -5.9 L 24.6 -2.8 L 24.6 1.3 L 22.2 4.8 L 17.7 6.5 L 15.3 6.5 L 11.5 6.0","0 19.7 M 24.3 14.3 L 24.5 -1.2 L 23.8 2.1 L 21.7 4.8 L 18.5 6.5 L 14.4 5.7 L 11.5 3.2 L 10.6 -1.0 L 11.7 -4.7 L 14.9 -7.2 L 18.2 -7.7 L 21.9 -6.4 L 24.2 -4.3 L 24.4 -1.0","0 15.7 M 11.2 6.7 L 11.5 -7.5 L 11.5 -4.3 L 13.5 -6.5 L 16.4 -7.6 L 19.3 -8.0 L 21.6 -7.8 L 22.6 -6.9 L 22.9 -6.5","0 18.7 M 11.8 5.5 L 14.1 7.0 L 17.4 7.0 L 21.8 5.7 L 23.2 4.3 L 23.4 2.8 L 21.7 1.4 L 17.8 .5 L 14.4 .1 L 11.3 -1.5 L 11.0 -4.2 L 12.6 -6.7 L 15.8 -8.0 L 18.5 -8.2 L 21.2 -7.3 L 21.9 -6.1 L 21.9 -4.8","0 15.6 M 21.8 -6.1 L 8.6 -6.1 L 13.7 -6.1 L 14.2 -12.0 L 13.6 .3 L 14.4 4.0 L 15.8 6.4 L 17.5 6.8 L 19.5 6.1 L 21.0 5.2","0 18.7 M 11.5 -7.7 L 10.5 -3.1 L 10.3 .1 L 11.4 4.0 L 13.1 6.4 L 15.3 7.3 L 17.7 7.2 L 19.6 6.1 L 21.4 4.4 L 22.5 2.4 L 23.5 .5 L 23.3 6.8 L 23.4 -7.6","0 17.6 M 9.3 -7.3 L 13.5 3.4 L 15.5 7.1 L 17.5 5.0 L 24.4 -7.9","0 28.3 M 11.6 -7.0 L 11.2 -2.8 L 11.5 1.0 L 12.6 4.7 L 14.2 6.9 L 16.1 7.6 L 17.9 7.0 L 20.3 4.5 L 21.6 1.3 L 22.1 -1.0 L 21.8 -6.2 L 22.5 2.8 L 23.3 5.1 L 24.9 6.8 L 27.0 7.0 L 29.6 5.6 L 32.1 3.0 L 33.7 .0 L 34.0 -3.8 L 33.6 -6.7 L 32.8 -9.5","0 15.5 M 10.3 6.9 L 10.3 6.1 L 17.1 -2.6 L 20.4 -6.8 L 22.1 -8.0 M 10.7 -8.1 L 17.9 4.1 L 20.5 6.7 L 22.1 7.0","0 16.7 M 12.0 14.2 L 12.4 12.0 L 16.7 4.3 L 20.5 -2.6 L 24.1 -8.0 M 9.5 -6.9 L 15.5 5.3","0 15.2 M 9.1 -7.3 L 18.5 -7.4 L 18.8 -5.6 L 10.9 6.3 L 19.0 6.6 L 21.3 6.2","0 11.7 M 16.9 9.6 L 14.6 9.2 L 13.4 8.7 L 13.7 6.4 L 14.7 1.9 L 14.2 .3 L 10.9 -2.0 L 10.2 -2.2 L 13.8 -4.8 L 14.4 -6.5 L 13.5 -11.8 L 14.2 -13.2 L 16.8 -13.8","0 11.5 M 13.9 14.5 L 13.3 -1.0 L 13.7 -10.2 L 14.1 -16.4","0 11.7 M 10.8 9.8 L 12.8 9.5 L 14.2 8.4 L 14.4 6.6 L 13.5 3.3 L 13.2 .6 L 14.6 -1.1 L 16.3 -2.2 L 17.7 -2.8 L 16.5 -3.6 L 14.7 -4.6 L 13.5 -5.9 L 13.9 -10.1 L 13.9 -12.3 L 12.9 -13.5 L 10.8 -13.8","0 18.1 M 11.0 -1.5 L 12.7 -3.1 L 15.1 -3.9 L 17.2 -2.9 L 18.7 -1.7 L 20.8 -1.6 L 23.4 -2.5","0 10.6 M 10.6 -8.4 L 11.4 -6.0 L 13.3 -4.9 L 16.0 -5.5 L 17.2 -7.9 L 17.4 -9.9 L 16.1 -11.6 L 13.6 -12.2 L 11.4 -10.8 L 10.6 -8.4"]
EMSPepita = ["-8 8","0 6.9 M 12.4 -12.9 L 11.5 -5.1 L 11.7 2.1 M 10.8 6.2 L 10.8 7.2 L 12.0 7.2 L 12.0 6.3 L 10.8 6.2","0 9.1 M 9.0 -17.2 L 8.9 -10.6 M 13.2 -17.0 L 13.5 -10.5","0 17.4 M 16.3 -5.2 L 12.9 -.2 L 9.6 7.0 M 16.0 6.2 L 21.3 -5.1 M 22.1 -1.8 L 12.8 -1.8 L 8.6 -2.4 M 8.7 3.9 L 13.6 2.9 L 16.0 2.8 L 21.4 3.4","0 16.5 M 20.4 -9.2 L 18.5 -10.8 L 15.9 -11.3 L 12.7 -11.0 L 9.9 -9.3 L 8.7 -6.9 L 9.2 -4.4 L 11.5 -2.7 L 14.9 -1.6 L 17.8 -.2 L 19.7 1.1 L 20.9 3.2 L 21.1 5.5 L 19.5 6.6 L 16.3 6.9 L 12.4 6.7 L 8.6 5.9 M 13.5 11.1 L 15.5 -14.8","0 30.2 M 9.9 -11.2 L 8.4 -9.8 L 8.2 -7.2 L 10.1 -5.6 L 12.8 -5.7 L 15.2 -7.6 L 15.8 -10.2 L 14.7 -11.8 L 12.4 -12.4 M 29.9 1.8 L 28.4 3.3 L 28.1 5.9 L 30.1 7.5 L 32.7 7.4 L 35.2 5.5 L 35.7 2.9 L 34.6 1.3 L 32.3 .7 M 26.7 -16.8 L 20.3 -.7 L 18.1 6.2 L 17.6 9.8","0 16.4 M 21.1 -1.6 L 19.4 2.2 L 16.6 5.6 L 13.6 7.0 L 10.5 6.4 L 9.2 4.2 L 9.5 2.3 L 12.3 -.1 L 16.4 -3.3 L 17.5 -5.7 L 17.9 -8.3 L 17.1 -10.6 L 15.4 -12.2 L 13.1 -12.1 L 11.2 -10.4 L 10.3 -7.7 L 10.2 -5.2 L 11.3 -2.2 L 13.0 1.1 L 15.3 3.9 L 19.1 6.6 L 21.0 6.8","0 4.5 M 9.2 -17.1 L 8.5 -13.7 L 8.5 -10.8","0 10.2 M 14.6 -17.1 L 11.4 -9.1 L 9.4 -1.9 L 9.0 5.0 L 10.9 12.1 L 15.3 20.3","0 10.7 M 8.3 -17.2 L 13.2 -11.8 L 15.3 -5.1 L 16.2 1.4 L 15.5 9.8 L 12.6 20.0","0 16.4 M 15.0 8.7 L 15.9 -5.9 M 10.6 6.9 L 15.8 .3 L 17.1 -1.7 L 20.1 -3.8 M 9.0 1.6 L 21.9 1.0 M 11.1 -3.4 L 18.6 5.0 L 20.9 6.9","0 12.8 M 13.3 -4.2 L 13.6 2.0 L 14.3 5.4 M 9.0 1.6 L 13.1 1.4 L 18.4 .3","0 6.7 M 12.0 8.1 L 11.4 10.5 L 8.8 14.6","0 10.6 M 8.5 1.6 L 16.0 1.5","0 6.8 M 10.9 6.4 L 10.9 7.4 L 12.1 7.4 L 12.1 6.5 L 10.9 6.4","0 12.7 M 18.1 -10.8 L 12.3 3.2 L 9.9 9.8 L 8.9 13.3 L 8.6 15.8","0 16.3 M 10.5 -6.2 L 8.5 -3.2 L 8.5 1.3 L 11.0 4.4 L 15.4 5.0 L 20.1 2.5 L 22.6 -.9 L 23.4 -5.1 L 21.4 -8.6 L 16.8 -10.7 L 14.4 -10.1 L 12.5 -8.9","0 7.8 M 10.4 -12.7 L 10.4 6.9","0 16.4 M 11.7 -8.1 L 11.7 -10.1 L 12.7 -11.8 L 14.9 -12.3 L 17.2 -11.2 L 17.4 -8.7 L 15.0 -4.9 L 11.6 -.1 L 10.1 2.4 L 10.1 4.4 L 11.7 6.2 L 14.8 6.6 L 19.1 6.7","0 16.4 M 9.6 6.9 L 13.9 6.3 L 16.8 4.8 L 19.3 3.2 L 19.7 1.5 L 19.2 .2 L 15.6 -1.9 L 14.4 -3.1 L 14.4 -4.3 L 15.1 -5.5 L 17.2 -7.0 L 18.8 -9.3 L 18.5 -10.8 L 16.8 -12.4 L 13.9 -12.7 L 11.7 -12.1 L 10.0 -11.7","0 16.4 M 12.6 -12.5 L 10.8 -9.0 L 10.1 -5.3 L 10.4 -2.8 L 12.5 -.1 L 14.8 .8 L 16.9 .3 L 18.5 -.5 L 19.6 -1.5 L 18.8 1.3 L 18.7 4.0 L 19.4 6.4 L 20.0 7.0","0 16.6 M 11.0 -11.6 L 10.9 -8.3 L 12.2 -5.7 L 15.7 -2.1 L 18.4 1.1 L 18.4 4.0 L 16.1 6.3 L 13.0 6.7 L 11.1 6.5 L 8.5 5.1 M 14.7 -10.4 L 18.8 -11.8 L 21.4 -12.5","0 16.3 M 20.9 -12.6 L 14.5 -8.2 L 10.7 -3.9 L 8.8 .3 L 8.9 4.3 L 11.1 6.6 L 15.6 6.5 L 18.6 4.6 L 20.3 1.5 L 20.0 -1.5 L 18.1 -3.0 L 15.2 -2.9 L 13.3 -1.4","0 16.4 M 9.8 -10.9 L 13.1 -11.3 L 18.4 -12.4 L 19.6 -12.2 L 20.6 -10.7 L 20.5 -8.8 L 19.3 -6.4 L 15.9 .7 L 14.5 6.8","0 16.2 M 11.5 -9.3 L 10.3 -7.4 L 11.2 -4.5 L 13.1 -2.5 L 16.2 .1 L 17.8 2.3 L 18.3 4.3 L 17.6 5.9 L 15.5 6.8 L 12.6 6.4 L 10.5 4.4 L 10.4 2.2 L 11.6 .3 L 12.9 -.9 L 18.9 -6.0 L 19.8 -8.7 L 18.7 -11.1 L 16.9 -12.2 L 15.2 -12.5 L 13.5 -11.5","0 16.3 M 15.8 6.8 L 18.5 3.6 L 19.7 -.1 L 20.0 -3.9 L 19.6 -7.0 L 19.1 -9.4 L 19.7 -6.1 L 17.5 -4.2 L 13.7 -3.3 L 11.3 -4.1 L 9.9 -6.8 L 10.8 -10.3 L 13.0 -12.3 L 15.8 -12.5 L 17.0 -11.8","0 7.3 M 11.1 -2.7 L 11.1 -1.7 L 12.4 -1.7 L 12.4 -2.6 L 11.1 -2.7 M 11.0 6.0 L 11.0 7.0 L 12.2 7.0 L 12.2 6.1 L 11.0 6.0","0 7.3 M 11.3 -2.8 L 11.3 -1.8 L 12.5 -1.8 L 12.5 -2.7 L 11.3 -2.8 M 11.9 6.2 L 11.4 9.0 L 9.8 11.7 L 8.3 13.4","0 15.7 M 20.8 -11.3 L 15.1 -6.3 L 9.8 -2.5 L 8.5 -1.4 L 8.1 .3 L 9.3 1.7 L 12.8 2.7 L 15.9 4.2 L 20.1 6.9","0 16.8 M 8.6 -1.4 L 13.4 -2.0 L 16.2 -1.9 L 21.5 -1.3 M 9.1 5.4 L 15.1 4.8 L 22.1 4.8","0 16.8 M 8.4 -12.5 L 15.5 -6.5 L 19.2 -4.0 L 20.7 -2.4 L 21.0 -.7 L 20.4 .2 L 18.8 1.3 L 9.4 6.7","0 11.7 M 10.8 6.3 L 10.8 7.3 L 12.1 7.3 L 12.1 6.4 L 10.8 6.3 M 11.6 1.2 L 11.8 -1.1 L 15.9 -8.7 L 16.5 -12.3 L 16.0 -14.8 L 13.8 -16.6 L 10.8 -16.6 L 9.0 -15.0 L 8.1 -12.9 L 9.0 -11.3","0 22.5 M 22.1 -3.5 L 21.3 .5 L 18.9 4.3 L 16.4 5.9 L 14.0 5.1 L 13.3 1.6 L 14.8 -1.0 L 16.8 -1.5 L 18.7 -.1 L 20.2 2.8 L 22.1 4.2 L 24.6 3.2 L 26.9 .6 L 28.0 -2.7 L 27.6 -6.0 L 25.4 -8.4 L 22.2 -9.3 L 17.0 -8.0 L 12.6 -4.8 L 9.7 -.3 L 9.1 5.0 L 10.3 9.7 L 13.9 12.4 L 19.7 11.4 L 23.2 9.8 L 25.8 8.1","0 17.7 M 8.5 6.9 L 10.6 -4.0 L 12.6 -9.5 L 14.1 -11.9 L 15.7 -12.5 L 16.4 -12.3 L 17.5 -10.5 L 18.8 -6.2 L 19.8 -.1 L 20.1 3.8 L 20.1 5.2 L 19.4 6.6 L 18.3 7.0 L 17.2 6.7 L 16.1 5.9 L 14.1 2.3 L 14.3 .7 L 15.2 -.6 L 16.8 -1.7 L 19.6 -2.6 L 22.6 -3.1","0 16.8 M 9.8 2.3 L 9.0 .1 L 8.5 -3.2 L 8.8 -6.6 L 9.5 -9.0 L 10.5 -10.7 L 11.9 -12.1 L 13.3 -12.4 L 14.7 -12.1 L 15.6 -10.4 L 15.5 -8.4 L 14.6 -5.8 L 14.4 -3.9 L 14.9 -2.3 L 16.2 -1.9 L 18.4 -1.6 L 21.0 -.8 L 22.2 .7 L 21.8 3.2 L 19.8 5.1 L 16.8 6.6 L 14.6 6.9 L 13.0 6.6 L 11.8 5.8","0 15.9 M 20.3 -11.5 L 18.3 -12.4 L 14.9 -12.1 L 11.9 -9.9 L 10.0 -7.3 L 9.0 -4.2 L 8.7 -.7 L 9.3 2.6 L 11.1 5.4 L 14.2 6.9 L 18.1 6.6 L 21.0 4.8","0 16.8 M 8.7 3.5 L 8.3 -1.5 L 8.4 -5.5 L 8.9 -8.9 L 10.2 -11.4 L 12.7 -12.4 L 15.6 -12.5 L 18.5 -11.2 L 20.9 -8.9 L 21.6 -5.8 L 21.3 -3.1 L 19.0 -.4 L 9.4 8.1","0 16.4 M 21.3 -12.5 L 15.4 -12.3 L 10.0 -11.2 L 9.0 -7.4 L 8.5 -3.2 L 12.4 -3.7 L 15.8 -3.9 L 18.7 -3.4 L 15.8 -3.9 L 12.6 -3.7 L 8.5 -3.2 L 8.2 1.6 L 8.5 4.0 L 9.8 5.9 L 11.7 6.8 L 15.4 6.8 L 18.6 6.0 L 21.3 4.7","0 16.4 M 22.5 -12.1 L 18.4 -12.7 L 13.5 -12.1 L 9.7 -10.5 L 8.2 -8.9 L 8.2 -5.2 L 9.1 -.3 L 11.3 4.6 L 13.2 7.0 L 12.4 -.7 L 12.6 -6.6 L 12.5 -2.9 L 16.8 -2.6 L 19.6 -3.1","0 16.8 M 20.0 -8.0 L 20.5 -9.5 L 20.0 -11.5 L 18.4 -12.5 L 15.1 -12.5 L 11.8 -9.7 L 9.6 -6.4 L 8.0 -2.4 L 8.0 1.3 L 9.7 4.8 L 12.5 6.9 L 15.4 6.6 L 17.4 5.1 L 18.1 3.8 L 18.3 1.5 L 17.9 .0 L 17.9 -1.5 L 18.9 -2.6 L 20.2 -2.9 L 21.9 -2.9","0 18.3 M 11.8 -12.6 L 12.4 -6.6 L 13.6 -1.1 L 14.2 2.2 L 14.3 5.4 L 13.2 6.6 L 11.8 6.8 L 9.7 6.2 L 8.5 4.8 L 7.9 2.8 L 8.2 1.1 L 9.3 .2 L 12.9 -1.5 L 16.2 -3.3 L 18.7 -5.2 L 20.5 -7.2 L 21.2 -8.6 L 21.6 -11.9 L 21.5 -5.2 L 22.0 1.1 L 23.2 6.8","0 7.3 M 10.1 -11.4 L 10.0 2.8 L 10.8 6.9","0 17.1 M 10.0 1.1 L 8.7 2.6 L 8.2 4.1 L 9.0 5.9 L 11.4 6.9 L 15.1 6.9 L 18.6 5.6 L 20.8 3.6 L 21.6 1.6 L 21.0 -3.4 L 20.7 -8.4 L 20.9 -10.7 L 21.3 -12.4","0 17.9 M 8.9 -10.3 L 8.3 3.4 L 9.1 6.0 L 10.4 7.0 L 12.2 6.7 L 13.2 4.8 L 19.4 -8.0 L 22.8 -12.5 L 19.4 -8.0 L 17.0 -2.9 L 18.8 .4 L 21.0 4.6 L 22.8 6.8","0 13.9 M 9.6 -12.6 L 9.7 -6.6 L 8.6 1.7 L 8.8 4.3 L 10.4 5.7 L 13.2 6.4 L 18.8 6.6","0 21.2 M 9.7 6.8 L 8.7 4.8 L 8.7 .3 L 8.9 -5.0 L 10.2 -10.4 L 11.1 -8.1 L 12.1 -5.8 L 13.0 -4.3 L 14.6 -3.1 L 16.4 -3.4 L 18.9 -4.9 L 21.0 -7.1 L 22.8 -9.4 L 24.0 -11.9 L 23.8 -7.2 L 24.4 -1.1 L 25.1 3.6 L 26.3 6.9","0 20.9 M 9.3 7.9 L 12.3 -12.3 L 12.9 -10.9 L 13.8 -7.2 L 15.0 -1.7 L 16.1 2.0 L 17.8 5.8 L 19.0 6.9 L 20.7 6.7 L 22.1 5.0 L 23.1 2.4 L 25.8 -12.6","0 19.7 M 11.3 -6.7 L 9.0 -4.3 L 8.2 -1.1 L 8.4 1.9 L 9.9 4.7 L 12.5 6.6 L 16.7 7.1 L 19.6 5.8 L 22.6 2.8 L 24.3 -.8 L 24.2 -5.2 L 23.1 -9.3 L 20.1 -11.7 L 16.1 -12.6 L 12.8 -11.3","0 16.5 M 10.6 8.1 L 10.6 6.1 L 8.1 -2.8 L 8.5 -7.1 L 10.6 -10.3 L 14.4 -12.1 L 18.4 -12.3 L 20.8 -10.2 L 21.5 -7.1 L 20.4 -4.4 L 18.3 -3.0 L 13.4 -1.0","0 21.4 M 18.3 -6.6 L 15.8 -7.8 L 13.6 -7.5 L 10.4 -5.4 L 8.8 -1.9 L 8.4 1.7 L 10.2 4.9 L 13.2 6.4 L 18.3 6.7 L 22.2 5.0 L 25.3 1.7 L 26.7 -2.7 L 26.5 -7.0 L 24.6 -10.1 L 21.0 -12.2 L 17.4 -12.3 L 15.0 -10.8 L 13.6 -9.4 L 12.8 -6.7 L 12.8 -4.4 L 14.5 -1.6 L 16.9 -.1 L 19.9 1.3 L 22.6 2.9 L 24.6 4.7 L 26.9 9.3","0 20.2 M 9.6 6.9 L 8.5 2.6 L 8.8 -2.9 L 11.3 -7.6 L 14.3 -10.6 L 18.4 -12.1 L 22.2 -12.4 L 24.6 -11.1 L 25.7 -9.1 L 25.4 -7.2 L 22.8 -4.4 L 19.0 -2.1 L 17.0 -.3 L 16.5 1.9 L 17.6 3.9 L 19.8 5.2 L 22.9 6.6 L 25.2 6.8","0 19.5 M 8.7 6.9 L 13.9 7.0 L 19.3 6.2 L 23.0 5.4 L 24.4 3.6 L 23.9 1.3 L 21.6 -.3 L 18.3 -1.3 L 14.7 -3.1 L 12.8 -4.5 L 11.8 -6.5 L 12.8 -9.1 L 15.1 -11.3 L 18.7 -12.3 L 21.8 -12.2 L 23.4 -10.1 L 23.2 -8.0 L 21.9 -6.4","0 15.8 M 8.4 -12.0 L 13.1 -12.5 L 17.6 -12.3 L 20.0 -11.4 L 22.1 -10.7 L 22.5 -10.1 L 22.0 -9.8 L 20.3 -9.8 L 17.9 -8.9 L 14.7 -5.5 L 13.7 -1.5 L 13.7 2.3 L 15.1 7.0","0 16.7 M 9.6 -9.4 L 8.7 -5.2 L 8.5 -1.4 L 9.2 2.9 L 11.5 6.0 L 14.3 6.9 L 17.5 5.8 L 20.0 2.5 L 21.3 -1.8 L 21.5 -6.8 L 21.4 -10.3 L 21.1 -12.5","0 18.3 M 8.2 -12.5 L 8.6 -5.7 L 9.6 -.9 L 11.0 3.7 L 11.9 5.5 L 13.1 6.7 L 14.3 6.9 L 15.7 6.1 L 16.4 4.6 L 17.3 .7 L 18.5 -5.2 L 20.1 -9.3 L 21.0 -11.1 L 22.2 -12.2 L 23.5 -12.5","0 29.8 M 8.7 -9.3 L 8.8 -4.5 L 9.4 -.1 L 10.8 3.4 L 12.4 6.1 L 14.0 6.9 L 15.2 6.2 L 19.7 -5.9 L 20.6 -7.2 L 21.5 -7.7 L 23.0 -7.6 L 23.6 -6.0 L 25.4 4.4 L 25.9 5.4 L 26.9 6.0 L 27.8 5.7 L 28.6 4.3 L 31.3 -3.8 L 33.2 -8.8 L 35.0 -12.3","0 19.3 M 9.3 6.7 L 13.0 1.6 L 17.7 -4.4 L 21.3 -8.4 L 23.2 -9.8 M 9.3 -12.5 L 12.0 -10.0 L 16.2 -2.3 L 18.9 2.5 L 20.9 5.1 L 22.6 6.4 L 23.9 6.7","0 16.8 M 8.6 -12.5 L 9.7 -9.2 L 12.1 -6.9 L 15.3 -6.0 L 17.6 -6.6 L 19.6 -8.0 L 21.1 -9.2 L 22.2 -10.9 L 21.7 -8.5 L 20.8 -5.6 L 18.0 -.2 L 16.1 3.9 L 15.4 6.9","0 17.4 M 8.5 -10.4 L 13.4 -11.6 L 17.1 -12.3 L 20.0 -12.3 L 21.8 -11.3 L 22.1 -10.0 L 21.8 -7.8 L 18.9 -5.1 L 12.9 -.8 L 10.7 .8 L 9.7 2.6 L 9.6 4.0 L 10.1 5.5 L 12.1 6.4 L 14.8 6.9 L 21.2 6.6 L 22.4 6.0","0 14.5 M 17.1 -15.4 L 15.5 -16.6 L 14.6 -16.9 L 10.1 -15.4 L 9.3 -14.4 L 9.6 -10.9 L 10.1 -4.2 L 9.6 6.4 L 9.1 14.0 L 9.9 16.3 L 12.8 17.4 L 15.9 17.2 L 18.9 16.2","0 13.1 M 8.4 -10.2 L 12.1 2.1 L 18.1 16.0","0 13.6 M 9.4 -16.2 L 13.0 -16.8 L 15.5 -15.9 L 17.3 -13.9 L 17.6 -10.9 L 16.3 6.1 L 17.4 8.3 L 18.6 11.8 L 19.1 14.6 L 18.2 16.6 L 16.3 17.5 L 8.6 16.4","0 12.7 M 8.5 -8.5 L 12.9 -13.8 L 13.9 -14.0 L 14.5 -13.4 L 17.6 -8.4","0 19.8 M 9.3 6.7 L 13.7 6.0 L 18.6 6.6 L 22.1 6.8 L 27.1 6.6","0 8.2 M 8.0 -14.7 L 11.0 -10.5 L 13.2 -8.4","0 14.4 M 17.7 -1.6 L 16.6 -3.3 L 13.5 -3.7 L 10.0 -1.5 L 8.1 2.0 L 8.0 4.9 L 10.2 7.3 L 14.5 5.8 L 16.3 4.4 L 18.7 2.2 L 18.8 4.8 L 19.6 6.6 L 20.5 6.9 L 21.4 6.3 L 22.4 4.5","0 15.1 M 11.8 -17.0 L 9.7 -9.6 L 8.7 -2.3 L 9.0 2.2 L 12.1 -1.6 L 15.6 -3.7 L 18.4 -3.2 L 19.3 .1 L 17.7 4.4 L 14.6 6.8 L 11.0 6.4","0 9.9 M 15.4 -3.3 L 12.3 -3.7 L 9.5 -2.0 L 7.2 1.5 L 8.3 5.8 L 12.1 7.2 L 15.1 6.4 L 17.9 4.6","0 16.5 M 17.9 -2.3 L 14.7 -3.8 L 11.5 -2.8 L 8.8 .0 L 7.6 3.3 L 8.6 6.3 L 12.0 6.8 L 15.3 4.1 L 17.1 .4 L 19.4 -8.1 L 20.5 -16.8 L 19.1 2.2 L 19.6 4.8 L 21.6 6.9 L 22.5 7.0 L 23.3 6.6 L 24.5 4.5","0 10.1 M 8.2 4.6 L 11.9 3.7 L 14.6 1.0 L 14.9 -1.5 L 14.1 -3.2 L 11.2 -3.9 L 7.8 -1.6 L 7.1 2.0 L 7.6 4.1 L 10.3 6.6 L 13.9 6.9 L 17.5 5.6 M 17.6 5.5 L 18.2 4.5","0 13.5 M 14.1 20.1 L 12.7 15.6 L 11.6 5.6 L 11.5 -4.2 L 12.7 -11.7 L 14.7 -15.3 L 17.2 -16.0 L 18.7 -14.2 L 19.5 -10.2 L 17.7 -5.2 L 15.0 -1.7 M 9.1 9.5 L 12.8 7.3 L 15.2 6.6 L 18.7 6.2","0 10.7 M 16.8 -2.5 L 14.6 -3.9 L 11.4 -3.3 L 8.8 -.9 L 8.8 2.4 L 12.0 6.6 L 14.8 9.8 L 16.7 13.4 L 16.5 18.3 L 14.0 20.3 L 11.3 19.6 L 10.3 16.8 L 11.8 12.8 L 18.0 5.9 L 18.7 4.5","0 16.3 M 9.9 -16.8 L 8.5 -4.9 L 7.9 1.0 L 7.8 4.1 L 8.5 6.4 L 9.6 6.8 L 10.8 6.3 L 13.6 .9 L 15.1 -2.3 L 17.4 -3.7 L 19.2 -3.8 L 20.2 -1.4 L 20.2 4.8 L 20.7 6.7 L 21.4 7.3 L 22.1 7.3 L 23.0 6.8 L 24.3 4.5","0 7.3 M 8.6 -3.9 L 7.7 .9 L 8.0 4.7 L 10.3 6.9 L 13.5 6.4 L 14.5 5.9 L 15.3 4.5 M 10.0 -11.6 L 11.0 -10.0","0 9.3 M 12.2 -3.8 L 12.2 .3 L 13.4 5.3 L 14.3 9.9 L 14.7 15.4 L 12.9 19.4 L 9.5 20.3 L 7.9 18.0 L 8.9 15.2 L 12.1 9.8 L 16.6 5.8 L 17.3 4.5 M 12.0 -11.1 L 12.2 -9.3","0 13.6 M 8.8 -16.7 L 7.7 -9.7 L 7.7 -3.6 L 7.7 .7 L 8.0 4.9 L 9.0 4.9 L 9.2 4.2 L 9.9 .7 L 12.9 -2.3 L 15.2 -3.4 L 17.5 -3.9 M 13.3 1.5 L 15.4 5.4 L 17.7 7.0 L 19.5 6.7 L 20.8 6.0 L 21.6 4.6","0 8.6 M 10.0 -1.7 L 12.7 -4.7 L 14.5 -9.3 L 14.3 -13.7 L 12.2 -15.8 L 9.1 -15.0 L 7.4 -10.9 L 6.8 -5.2 L 6.9 1.3 L 8.3 5.4 L 11.8 7.0 L 15.9 5.8 L 16.6 4.5","0 34.6 M 42.6 4.5 L 42.0 5.5 L 39.9 6.9 L 38.6 6.9 L 37.3 5.8 L 37.1 1.7 L 36.8 -.5 L 34.7 -1.8 L 33.6 -.9 L 31.8 1.0 L 29.4 5.1 L 27.3 6.8 L 25.5 6.6 L 24.8 4.9 L 24.8 .9 L 24.4 -1.7 L 22.7 -2.9 L 21.3 -2.5 L 20.0 -1.1 L 16.1 5.1 L 14.2 5.8 L 12.7 5.3 L 12.3 3.4 L 12.1 -2.4 L 11.3 -3.1 L 10.8 -1.4 L 9.6 1.7 L 8.8 3.0 L 7.9 4.6","0 19.4 M 24.2 6.9 L 23.1 5.8 L 22.4 3.0 L 22.4 -.7 L 21.6 -2.4 L 19.9 -2.8 L 17.9 -1.7 L 15.4 1.6 L 13.0 6.6 L 12.5 3.4 L 12.0 -.7 L 10.7 -3.1 L 10.1 -2.7 L 9.6 -.7 L 9.1 2.2 L 8.0 4.5 M 24.2 7.0 L 25.3 7.0 L 26.5 6.3 L 27.5 4.5","0 12.7 M 9.3 -1.8 L 8.1 .5 L 8.5 3.9 L 9.9 6.1 L 14.0 7.0 L 17.8 5.0 L 19.8 1.4 L 19.3 -1.6 L 16.8 -3.6 L 13.8 -3.7 L 12.6 -3.0","0 20.6 M 19.8 6.3 L 21.8 6.9 L 23.6 6.6 L 25.0 4.8 L 26.0 .8 L 24.8 -2.6 L 21.8 -4.0 L 18.6 -2.6 L 16.4 -.1 L 14.3 5.4 L 12.5 20.2 L 12.3 8.7 L 12.1 3.2 L 11.1 1.1 L 9.9 .5 L 9.0 1.0 L 8.5 2.3 L 8.0 4.5","0 14.8 M 19.1 -1.8 L 17.5 -3.3 L 14.9 -3.8 L 11.1 -2.1 L 9.5 .3 L 8.8 3.7 L 10.0 6.7 L 13.4 6.6 L 16.3 4.9 L 19.4 1.6 L 18.7 10.1 L 18.9 15.5 L 19.4 20.0","0 16.2 M 8.6 .4 L 8.1 -1.9 L 10.2 -3.5 L 14.0 -3.9 L 16.8 -2.9 L 17.7 .5 L 18.9 4.8 L 20.2 6.6 L 22.5 6.7 L 23.2 6.2 L 24.2 4.5","0 17.3 M 8.0 4.6 L 9.5 2.2 L 13.2 -1.6 L 16.1 -3.5 L 18.1 -4.0 L 20.4 -3.3 L 22.4 -1.0 L 22.7 2.4 L 21.1 5.5 L 17.5 6.9 L 15.5 6.6 L 14.6 5.7","0 11.9 M 12.6 -14.5 L 12.0 1.1 L 12.9 4.6 L 15.0 6.9 L 17.5 6.5 L 19.3 5.6 L 19.9 4.5 M 8.5 -3.9 L 13.0 -3.8 L 17.4 -4.5","0 20.7 M 12.0 -1.7 L 11.6 2.4 L 12.8 5.6 L 15.6 7.1 L 19.0 5.7 L 21.0 3.0 L 22.1 -2.7 L 22.7 3.8 L 24.5 6.6 L 26.6 6.7 L 28.1 5.6 L 28.7 4.5","0 19.3 M 10.9 -1.6 L 11.3 2.2 L 12.8 5.8 L 14.8 6.8 L 17.5 6.0 L 19.3 2.8 L 21.8 -2.5 L 23.4 -3.8 L 25.0 -3.8 L 25.9 -2.3","0 30.2 M 12.9 -2.8 L 12.6 3.0 L 13.5 5.6 L 15.9 6.9 L 18.8 5.6 L 21.4 2.5 L 24.4 -2.9 L 24.6 1.2 L 25.7 4.4 L 27.3 4.9 L 30.4 3.6 L 33.5 .9 L 35.6 -1.9 L 36.1 -4.2 L 36.3 -.5 L 37.5 1.1","0 20.9 M 11.8 -3.6 L 18.2 4.3 L 20.9 5.8 L 24.5 5.8 L 26.2 2.8 L 25.7 -.8 L 23.4 -2.7 L 20.3 -2.7 L 17.8 -.3 L 15.3 5.1 L 13.3 11.5","0 16.5 M 8.7 -2.6 L 8.5 .7 L 9.0 4.0 L 12.2 6.0 L 16.0 4.3 L 18.0 1.3 L 18.7 -.8 L 18.7 -3.3 L 21.5 9.5 L 21.7 13.4 L 21.4 17.2 L 19.7 20.1 L 17.4 20.1 L 16.0 18.2 L 16.6 14.6 L 19.4 10.4 L 22.1 7.6 L 23.0 6.7 L 23.9 5.6 L 24.5 4.5","0 16.0 M 9.3 .7 L 8.6 -1.0 L 9.7 -3.3 L 13.2 -4.0 L 16.0 -3.8 L 17.8 -1.7 L 17.6 1.3 L 16.7 5.2 L 17.5 7.5 L 19.8 11.5 L 20.7 14.9 L 19.1 18.8 L 16.6 20.5 L 14.0 18.5 L 15.0 15.1 L 17.1 12.0 L 22.8 6.6 L 24.0 4.5","0 13.4 M 15.2 -13.5 L 15.4 -9.0 L 13.5 -3.2 L 10.3 2.1 L 12.3 2.8 L 13.6 4.4 L 13.3 8.8 L 14.5 13.4 L 16.8 15.2 L 18.6 15.9","0 7.8 M 12.8 -15.6 L 11.9 -4.3 L 11.6 11.3","0 11.1 M 8.6 -16.2 L 10.6 -16.8 L 12.4 -16.2 L 13.3 -14.2 L 12.5 -10.8 L 11.9 -4.4 L 13.1 -1.5 L 14.7 -.6 L 16.7 -.4 L 14.5 1.5 L 13.2 4.5 L 12.9 9.2 L 13.9 12.8 L 14.8 14.4","0 14.1 M 8.4 -.3 L 9.5 -2.1 L 10.9 -2.6 L 13.0 -1.5 L 14.8 .1 L 16.8 .1 L 18.7 -1.8","0 9.7 M 9.0 -16.1 L 7.8 -14.2 L 8.7 -11.6 L 11.9 -10.4 L 14.6 -12.2 L 15.2 -14.7 L 13.7 -16.8 L 11.5 -16.8"]
EMSQwandry = ["-8 8","0 10.1 M 20.9 -10.4 L 14.6 1.8 L 13.8 4.5 M 12.6 7.4 L 11.5 9.5 L 13.6 7.6 L 12.6 7.4","0 8.5 M 11.0 -5.9 L 10.5 -6.6 L 11.5 -6.8 L 12.0 -5.5 L 10.2 -2.7 M 14.3 -5.9 L 13.8 -6.6 L 14.9 -6.8 L 15.3 -5.5 L 13.5 -2.7","0 32.6 M 25.2 -13.0 L 17.8 7.1 M 33.7 -12.7 L 26.4 7.2 M 12.9 1.0 L 35.7 1.0 M 15.9 -6.9 L 38.7 -6.9","0 21.2 M 25.0 -10.3 L 26.6 -11.3 L 26.9 -12.6 L 25.9 -13.2 L 21.3 -12.5 L 18.2 -10.9 L 16.6 -8.9 L 16.3 -7.1 L 21.1 -1.4 L 21.7 .1 L 20.7 1.7 L 19.0 2.2 L 16.8 2.2 L 15.7 2.1 L 14.2 1.1 M 17.4 2.4 L 16.0 4.6 L 15.8 6.5 M 23.4 -13.0 L 24.6 -14.7 L 25.0 -16.6","0 27.8 M 22.0 -14.9 L 20.0 -13.9 L 17.3 -11.0 L 15.1 -7.5 L 15.3 -5.5 L 16.2 -4.4 L 17.8 -4.7 L 22.2 -9.3 L 23.1 -10.5 L 23.4 -13.3 L 23.0 -15.2 L 21.9 -15.4 L 21.0 -14.6 L 22.1 -12.8 L 24.7 -12.2 L 29.5 -13.4 L 33.2 -14.7 L 34.0 -14.0 L 22.5 -.4 L 17.6 6.5 L 15.6 10.0 L 15.3 11.8 L 15.4 13.0 M 29.5 1.5 L 28.0 1.5 L 25.3 3.7 L 22.7 7.3 L 21.9 9.8 L 22.5 11.4 L 24.4 11.8 L 26.6 9.9 L 28.9 7.4 L 30.1 5.5 L 30.6 2.9 L 30.2 1.1 L 28.6 1.0 L 29.1 3.1 L 31.1 3.4","0 24.3 M 29.9 -9.3 L 26.3 -9.7 L 22.3 -8.0 L 19.9 -6.2 L 19.3 -5.1 L 19.3 -4.2 L 20.6 -3.3 L 25.6 -3.4 L 21.2 -3.3 L 17.5 -2.0 L 13.9 1.1 L 12.4 3.8 L 13.2 7.2 L 15.0 8.8 L 18.2 9.3 L 22.6 8.5 L 25.9 6.6 L 27.4 4.3 L 27.7 2.1 L 27.3 .8 L 25.8 -.3 L 23.1 -.6 L 20.0 .3 L 18.6 1.6 M 32.3 -11.4 L 29.3 -8.6 L 28.3 -7.0 L 28.2 -5.8 M 32.1 -6.0 L 32.7 -4.8 L 31.5 -3.8 L 27.9 -1.6 L 22.6 1.0 L 18.2 4.1 L 16.6 6.2 L 16.7 9.4 L 18.6 11.8 L 21.0 12.7 L 22.2 12.6","0 7.8 M 14.5 -10.4 L 14.5 -11.0 L 15.6 -10.3 L 14.6 -7.9 L 13.2 -6.4","0 14.2 M 30.1 -17.1 L 22.7 -15.2 L 15.9 -10.4 L 11.9 -5.9 L 9.9 -1.5 L 9.3 2.3 L 10.2 6.7 L 12.1 8.8 L 14.2 9.8 L 15.8 9.9","0 23.7 M 23.6 -17.1 L 26.9 -16.3 L 29.4 -13.9 L 30.5 -11.1 L 30.2 -6.7 L 28.3 -1.7 L 24.4 2.8 L 19.8 6.5 L 13.0 9.6 L 9.2 10.0","0 13.7 M 14.3 1.0 L 16.1 -7.3 M 11.7 -.6 L 18.6 -5.8 M 10.4 -3.2 L 19.4 -3.1 M 12.5 -6.5 L 18.3 .4","0 15.5 M 16.9 -5.4 L 16.0 -.1 L 15.3 3.2 L 14.2 6.1 M 10.4 1.1 L 16.6 .9 L 21.6 .3","0 7.6 M 12.6 8.3 L 12.4 7.8 L 13.3 7.6 L 13.7 8.7 L 13.3 10.1 L 11.8 11.7","0 11.5 M 10.0 1.2 L 14.1 1.0 L 17.7 .4","0 8.9 M 12.2 7.7 L 12.2 8.6 L 13.6 8.5 L 13.6 7.7 L 12.2 7.7","0 22.6 M 29.1 -14.6 L 20.1 -3.7 L 12.9 6.0 L 11.3 8.6 L 10.2 10.2 L 10.3 11.2 L 10.6 12.1","0 21.7 M 18.2 -5.9 L 16.9 -6.1 L 13.9 -3.1 L 10.9 1.9 L 9.9 4.6 L 10.4 7.3 L 12.2 8.7 L 15.0 8.8 L 19.4 7.0 L 24.5 2.4 L 27.7 -2.0 L 28.5 -5.8 L 27.2 -7.8 L 24.2 -9.3 L 18.7 -9.5 L 16.5 -9.2 L 14.0 -8.2","0 9.5 M 11.5 -4.7 L 15.7 -9.7 L 16.9 -9.5 L 12.7 -1.4 L 10.5 4.7 L 10.4 6.8 L 10.8 9.3","0 20.1 M 15.2 -4.5 L 14.6 -5.8 L 16.4 -7.2 L 21.8 -9.2 L 25.7 -9.5 L 27.5 -9.1 L 27.8 -6.9 L 22.9 -.8 L 15.9 4.7 L 10.4 8.2 L 16.4 7.5 L 21.2 7.2 L 23.1 7.3 L 24.0 7.7 L 24.5 8.8","0 20.4 M 15.9 -6.4 L 15.9 -7.6 L 16.6 -8.6 L 19.7 -9.6 L 23.0 -9.7 L 25.9 -9.1 L 27.7 -8.0 L 28.1 -6.6 L 25.9 -4.4 L 21.1 -2.4 L 16.5 -1.3 L 20.2 -1.5 L 22.9 -.9 L 24.1 -.1 L 25.2 1.5 L 24.9 3.8 L 21.1 7.3 L 16.4 9.2 L 13.2 9.1 L 10.6 7.7 L 9.8 5.5 L 10.1 3.3","0 18.5 M 20.9 -9.3 L 20.8 -8.4 L 13.4 -3.1 L 9.9 .5 L 10.0 1.9 L 14.7 .7 L 19.8 .4 L 23.7 .7 L 25.0 .9 L 25.5 1.5 L 25.0 2.6 M 24.7 -9.9 L 25.4 -8.8 L 24.7 -6.2 L 20.7 2.6 L 19.8 7.0 L 20.0 9.4 L 20.5 11.0","0 17.4 M 24.9 -9.6 L 21.5 -8.7 L 17.8 -8.6 L 15.2 -9.1 L 10.7 -1.2 L 11.1 -1.1 L 14.1 -3.1 L 17.6 -3.9 L 20.6 -3.6 L 22.4 -2.9 L 23.5 -.3 L 22.3 3.1 L 18.1 7.3 L 13.6 9.8 L 8.9 10.6 L 5.1 10.1 L 3.5 9.2 L 2.1 7.4","0 18.2 M 26.6 -10.8 L 25.5 -11.3 L 23.5 -11.1 L 19.7 -8.6 L 14.2 -3.0 L 10.6 2.5 L 9.5 5.5 L 9.4 7.0 L 10.3 8.8 L 12.7 9.6 L 15.7 9.1 L 19.8 7.0 L 23.5 3.3 L 24.2 1.0 L 23.7 -.6 L 22.2 -1.4 L 19.7 -1.2 L 17.3 -.2 L 14.6 1.6 L 13.7 3.0 L 13.3 3.9","0 16.4 M 10.5 -5.5 L 10.6 -6.7 L 11.5 -7.6 L 15.0 -8.6 L 19.3 -9.0 L 22.7 -8.9 L 24.6 -8.4 L 25.5 -8.1 L 24.7 -7.2 L 20.0 -4.3 L 14.9 .5 L 11.7 4.5 L 10.1 7.4 L 10.0 9.5 L 10.5 10.8","0 22.7 M 27.1 -9.5 L 25.0 -9.9 L 20.4 -8.2 L 17.1 -6.9 L 15.0 -5.4 L 14.4 -4.6 L 14.3 -3.1 L 19.3 1.3 L 21.2 3.3 L 21.3 5.7 L 19.5 7.8 L 16.4 8.7 L 13.4 8.8 L 11.2 8.5 L 10.3 7.3 L 11.8 4.2 L 14.4 2.2 L 26.5 -6.4 L 29.8 -9.7 L 31.0 -12.0","0 15.2 M 20.5 -7.7 L 19.9 -9.2 L 18.5 -10.3 L 16.2 -10.0 L 13.3 -8.5 L 10.5 -5.8 L 9.2 -3.8 L 9.5 -1.9 L 11.4 -.5 L 14.6 -1.1 L 16.7 -2.0 L 19.1 -3.4 L 21.8 -5.5 L 22.0 -5.5 L 18.2 .8 L 15.6 6.6 L 15.2 9.6 L 15.2 11.4 L 15.8 12.3 L 16.7 12.4","0 8.9 M 13.8 .7 L 13.8 1.9 L 14.9 1.9 L 14.9 .9 L 13.8 .7 M 12.4 7.6 L 12.3 8.5 L 13.6 8.5 L 13.6 7.5 L 12.4 7.6","0 8.9 M 13.6 .6 L 13.7 1.8 L 14.8 1.9 L 14.9 .8 L 13.6 .6 M 13.0 8.5 L 12.4 7.9 L 13.2 7.5 L 14.0 8.5 L 13.2 10.4 L 11.8 11.8","0 12.5 M 16.5 -5.9 L 12.6 -.2 L 16.4 4.0","0 15.2 M 11.1 -3.5 L 15.2 -3.1 L 18.3 -3.4 L 22.4 -3.9 M 10.2 .8 L 14.3 1.2 L 17.3 .9 L 21.4 .4","0 12.3 M 12.1 -5.4 L 15.8 -1.6 L 12.0 4.1","0 15.2 M 13.2 -6.4 L 12.6 -7.8 L 13.2 -8.9 L 15.2 -9.6 L 18.2 -10.0 L 21.8 -9.5 L 24.0 -8.6 L 24.8 -7.0 L 24.2 -5.6 L 20.4 -3.8 L 16.5 -2.0 L 14.1 -.6 L 12.7 .8 L 12.8 2.7 L 13.4 3.8 L 14.6 4.5 L 15.4 4.5 M 13.1 7.4 L 11.7 8.2 L 11.5 9.6 L 12.9 8.1","0 34.6 M 32.3 -9.3 L 31.6 -10.5 L 28.0 -11.1 L 24.9 -9.1 L 21.8 -5.9 L 20.0 -2.5 L 19.3 .7 L 20.3 2.2 L 21.9 2.2 L 24.7 -.4 L 27.9 -4.8 L 30.2 -7.4 L 30.6 -7.1 L 28.7 -3.0 L 28.8 .2 L 29.4 2.0 L 30.8 2.6 L 32.6 1.6 L 35.9 -2.5 L 38.1 -5.8 L 40.3 -9.4 L 40.6 -12.4 L 37.6 -15.2 L 32.1 -15.5 L 26.8 -14.0 L 21.3 -10.6 L 16.5 -5.7 L 14.1 -1.2 L 13.9 3.3 L 15.5 6.6 L 20.2 8.1 L 27.3 6.8 L 32.4 4.3 L 36.8 .4 L 38.8 -2.5 L 39.5 -5.0 L 39.0 -9.5","0 28.1 M 10.3 8.5 L 13.6 8.6 L 17.2 6.8 L 22.7 2.7 L 27.1 -1.2 L 30.4 -4.5 L 32.4 -6.9 L 33.5 -8.4 L 34.1 -9.9 M 40.4 -13.8 L 35.7 -5.3 L 32.9 -.3 L 31.0 4.8 L 30.2 8.2 L 30.2 10.7 L 31.0 12.8 M 17.0 1.6 L 19.1 2.0 L 25.8 1.6 L 32.3 .8","0 25.7 M 21.1 -10.5 L 16.3 -2.5 L 13.7 3.7 L 12.2 8.3 L 12.0 11.8 L 13.0 13.4 M 17.8 8.9 L 21.5 10.2 L 26.9 9.3 L 30.0 6.8 L 31.4 3.9 L 30.4 1.5 L 27.6 -.3 L 25.1 -.7 L 22.8 -1.2 L 20.3 -1.1 L 20.3 -.7 L 26.2 -2.5 L 31.9 -5.7 L 33.9 -8.1 L 34.3 -11.0 L 32.8 -12.8 L 28.0 -13.9 L 22.5 -13.8 L 17.1 -12.5 L 9.7 -10.1","0 24.9 M 34.8 -11.9 L 31.3 -13.3 L 25.2 -12.8 L 19.5 -10.0 L 15.1 -6.1 L 11.8 -1.7 L 10.7 2.6 L 10.9 6.0 L 13.3 9.3 L 17.0 11.0 L 21.6 10.7 L 26.2 9.2 L 29.0 7.6 L 31.6 5.2 M 32.1 -5.6 L 32.6 -7.5 L 34.0 -10.5 L 35.3 -12.7 L 36.7 -14.3","0 33.4 M 13.9 12.2 L 12.7 10.0 L 14.1 4.8 L 16.6 -1.4 L 21.8 -10.5 M 10.0 -9.7 L 16.0 -11.8 L 21.5 -12.9 L 27.0 -13.7 L 31.9 -13.2 L 35.8 -11.7 L 39.1 -8.8 L 39.8 -3.4 L 36.9 2.4 L 32.9 6.1 L 27.5 8.5 L 21.6 10.1 L 15.9 9.8","0 23.9 M 9.7 .2 L 13.5 1.0 L 19.3 .3 L 23.8 .0 L 26.9 -.8 M 30.0 -8.5 L 30.3 -10.5 L 31.3 -12.6 L 32.9 -15.0 M 31.8 -13.0 L 28.8 -13.6 L 22.6 -12.1 L 17.1 -8.4 L 13.3 -4.0 L 11.3 -.3 L 10.3 3.5 L 11.8 8.2 L 15.5 10.8 L 21.0 10.9 L 25.7 9.3 L 29.0 7.3 L 31.4 5.1","0 23.3 M 10.4 -8.3 L 15.6 -11.9 L 20.6 -13.8 L 24.1 -14.9 L 27.8 -15.0 L 30.6 -13.6 L 31.3 -10.5 L 30.5 -7.0 L 25.7 1.9 L 22.8 7.9 L 22.0 10.6 L 22.2 12.1 L 22.6 13.5 M 13.8 .7 L 17.5 .6 L 22.0 .1 L 31.0 -1.3","0 29.0 M 21.0 18.9 L 23.3 18.4 L 26.3 14.9 L 29.3 10.2 L 31.9 4.6 L 34.6 -1.2 L 30.0 4.8 L 26.6 7.7 L 22.2 10.3 L 18.4 11.0 L 13.9 9.9 L 11.3 7.5 L 10.3 3.3 L 11.2 -1.0 L 15.0 -6.5 L 21.0 -11.1 L 27.3 -13.3 L 31.6 -13.2 L 34.4 -12.1 L 35.8 -10.4 L 33.9 -8.3 L 32.5 -6.3 L 33.0 -10.0 L 34.3 -12.7 L 36.1 -14.8 M 22.9 .4 L 32.4 -.5 L 36.3 -1.3","0 26.4 M 23.7 -12.9 L 18.6 -3.7 L 15.3 3.7 L 13.5 9.7 L 13.4 12.6 L 13.5 13.8 L 14.1 14.7 M 10.0 .7 L 21.2 .3 L 27.0 -.3 L 31.6 -1.3 M 37.9 -11.4 L 33.4 -4.4 L 30.3 1.2 L 29.4 5.1 L 29.6 7.2 L 31.0 8.5 L 32.5 8.2","0 17.3 M 8.7 9.5 L 14.9 9.5 L 19.4 8.8 L 22.3 8.2 M 17.7 10.6 L 16.0 10.8 L 15.0 10.4 L 14.4 9.0 L 14.3 7.0 L 16.6 2.1 L 20.7 -4.7 L 28.1 -13.8 M 27.1 -12.3 L 22.7 -12.5 L 17.9 -11.3 L 15.4 -10.0 L 14.2 -8.6 L 14.1 -7.5","0 30.8 M 10.7 1.0 L 9.6 -.3 L 10.0 -2.9 L 14.2 -6.2 L 18.1 -8.6 L 25.4 -11.9 L 30.1 -13.3 L 34.4 -13.8 L 36.9 -13.5 L 39.7 -11.6 L 40.2 -8.6 L 38.4 -3.1 L 34.4 2.7 L 28.4 8.4 L 23.5 11.9 L 18.8 14.0 L 15.2 14.0 L 13.5 12.1 L 14.2 9.8 L 16.5 6.5 L 21.0 2.9 L 26.4 -.3 L 33.7 -3.9","0 22.3 M 18.5 -10.6 L 14.1 -2.8 L 11.1 3.5 L 9.8 7.9 L 9.9 10.7 L 10.2 12.0 L 10.7 12.4 M 35.4 -11.6 L 31.5 -11.7 L 27.8 -9.8 L 22.5 -5.5 L 19.1 -2.5 L 14.9 .2 L 16.7 3.6 L 18.4 6.6 L 20.9 9.5 L 23.4 12.0 L 26.1 13.3 L 28.6 13.6 L 29.9 12.7 L 30.5 11.0 L 29.5 9.2 L 27.7 7.0","0 22.9 M 17.1 1.5 L 17.7 1.3 L 21.9 -4.4 L 24.6 -8.9 L 27.0 -12.7 L 27.2 -14.5 L 26.6 -15.6 L 24.6 -16.1 L 22.7 -14.4 L 18.8 -8.0 L 15.9 -2.2 L 13.6 3.4 L 12.9 6.8 L 12.4 8.7 L 12.2 11.0 L 13.0 12.9 M 9.2 9.8 L 14.8 8.2 L 19.6 7.5 L 24.7 7.1 L 28.4 8.0 L 29.6 9.2 L 29.1 10.9 L 28.4 12.0","0 33.5 M 20.8 -13.4 L 13.9 -1.5 L 11.6 3.7 L 10.6 7.1 L 10.4 9.3 L 10.6 11.3 L 11.2 12.8 L 10.4 9.3 L 11.4 4.6 L 13.4 .4 L 16.9 -3.3 L 20.9 -7.8 L 23.8 -9.9 L 26.3 -10.9 L 28.4 -10.8 L 29.3 -9.6 L 28.7 -5.9 L 25.8 1.4 L 22.1 7.9 L 25.4 4.3 L 37.9 -8.3 L 40.1 -9.2 L 40.5 -9.4 L 38.1 -5.5 L 36.2 -.1 L 35.1 4.8 L 35.0 8.4 L 35.5 10.3 L 36.6 11.1 L 38.4 10.6 L 39.6 8.4 L 40.6 5.9","0 23.1 M 20.4 -13.7 L 15.3 -5.2 L 12.3 .7 L 11.3 4.0 L 10.9 7.9 L 11.0 10.1 L 11.3 11.5 L 10.8 9.3 L 11.5 6.7 L 14.1 3.7 L 19.1 -1.9 L 31.1 -12.5 L 28.4 -7.7 L 25.7 -.5 L 24.8 4.1 L 24.7 8.1 L 25.0 9.8 L 26.5 11.0 L 27.7 10.6 L 28.8 8.9 L 30.3 6.3","0 28.4 M 29.2 1.6 L 33.1 -1.2 L 36.0 -4.6 L 37.3 -8.1 L 36.6 -10.8 L 34.2 -12.2 L 31.3 -12.7 L 26.2 -12.2 L 20.1 -9.8 L 15.1 -5.9 L 12.1 -1.8 L 10.7 2.1 L 11.0 6.0 L 12.7 9.0 L 15.5 10.7 L 21.8 10.4 L 27.8 7.9 L 32.1 4.3 L 35.0 .7 L 35.9 -2.2 L 36.1 -4.0 L 35.0 -6.7 L 32.1 -8.9 L 29.5 -9.9 L 28.0 -9.9 L 25.4 -9.7","0 30.3 M 9.3 -7.9 L 14.2 -10.3 L 18.6 -11.8 L 24.0 -12.7 L 28.6 -12.8 L 33.0 -12.8 L 36.7 -11.7 L 39.5 -10.2 L 40.2 -8.3 L 39.6 -5.1 L 35.2 -2.0 L 30.3 .0 L 25.8 .5 L 21.2 -.4 M 28.2 -11.6 L 23.0 -4.2 L 19.3 2.3 L 17.4 7.4 L 16.8 10.3 L 17.2 12.4","0 28.9 M 10.4 -3.6 L 14.5 -7.9 L 19.7 -11.2 L 24.7 -12.6 L 28.7 -13.0 L 31.8 -12.2 L 34.5 -10.4 L 36.6 -6.7 L 36.3 -2.5 L 34.0 1.9 L 29.3 6.5 L 25.4 9.2 L 20.5 10.9 L 16.1 10.9 L 13.0 8.5 L 11.7 4.8 L 12.3 .9 L 15.4 -3.6 L 19.3 -6.8 L 22.3 -8.3 L 24.3 -8.7 L 27.0 -8.6 M 13.5 5.6 L 16.5 4.9 L 19.5 5.9 L 22.9 7.7 L 27.4 11.0 L 32.2 14.4 L 37.8 17.2 L 42.2 17.6 L 43.9 16.6 L 44.1 14.5 L 43.3 11.8 L 40.9 9.6 L 38.6 8.5 L 36.4 7.7 L 34.7 7.6","0 28.1 M 9.4 -8.0 L 14.4 -10.8 L 20.4 -12.4 L 24.7 -12.8 L 29.3 -13.0 L 34.6 -12.5 L 38.3 -11.1 L 40.2 -9.1 L 39.8 -6.1 L 37.0 -3.2 L 32.2 -.8 L 28.4 .4 L 25.0 .6 L 23.0 .4 L 19.2 .0 M 28.1 -11.0 L 22.9 -5.9 L 19.5 -1.1 L 17.6 2.7 L 16.4 6.3 L 16.2 8.7 L 16.3 10.1 L 16.9 10.7 M 19.0 -3.7 L 23.7 3.8 L 27.0 8.0 L 29.3 9.9 L 31.6 10.1 L 33.0 9.2 L 33.1 7.3","0 15.9 M 25.5 -9.1 L 28.7 -10.8 L 29.6 -11.6 L 29.7 -12.2 L 28.9 -13.6 L 27.6 -14.0 L 25.0 -13.7 L 22.1 -12.9 L 16.2 -10.6 L 14.0 -8.3 L 13.4 -5.8 L 14.2 -2.8 L 16.9 -.1 L 20.6 4.5 L 21.2 6.5 L 20.2 8.5 L 17.0 9.5 L 14.6 9.6 L 11.9 9.3 L 9.9 8.2","0 24.1 M 19.0 -7.5 L 15.1 -8.0 L 11.8 -9.7 L 9.9 -11.7 L 9.8 -13.2 L 10.5 -14.6 L 12.7 -15.0 L 16.1 -14.2 L 23.2 -12.6 L 30.7 -11.3 L 35.2 -10.6 L 39.1 -10.7 L 40.6 -11.7 L 40.7 -13.0 L 40.2 -13.8 L 37.7 -15.7 L 36.1 -16.2 M 30.6 -9.5 L 27.2 -6.6 L 23.7 -1.4 L 21.2 3.5 L 20.0 7.0 L 20.1 9.5 L 20.6 10.9 L 22.0 11.5 L 23.8 11.2 L 24.9 10.3","0 18.6 M 9.1 -4.7 L 13.4 -7.8 L 16.8 -10.0 L 18.5 -10.6 L 19.7 -10.1 L 19.8 -9.2 L 17.8 -5.5 L 14.0 .1 L 12.6 4.0 L 11.9 6.4 L 12.6 8.0 L 14.3 9.1 L 16.4 8.1 L 26.3 -.9 L 33.9 -9.7 L 35.2 -11.9 L 35.5 -13.0 L 34.7 -13.3 L 32.5 -12.2 L 28.9 -8.3 L 25.9 -4.0 L 24.1 -.3 L 22.2 4.8 L 21.6 9.5 L 22.0 12.9 L 22.5 15.6 L 23.1 16.9 L 24.0 18.3","0 24.6 M 10.8 -5.9 L 14.1 -10.5 L 17.8 -13.4 L 20.9 -14.1 L 23.3 -12.4 L 23.9 -8.3 L 23.2 -2.8 L 19.4 9.6 L 20.1 9.7 L 25.1 2.1 L 32.3 -7.3 L 37.6 -11.9 L 40.3 -13.7 L 42.1 -14.2 L 44.1 -14.1 L 44.9 -13.6 L 45.3 -12.9","0 36.0 M 28.4 -13.0 L 22.0 -8.9 L 15.5 -2.2 L 11.5 3.5 L 9.8 7.8 L 10.0 10.6 L 11.1 12.1 L 13.6 12.1 L 16.9 10.3 L 20.5 6.9 L 27.3 -.6 L 32.6 -5.8 L 32.2 .7 L 32.2 5.4 L 33.2 8.3 L 35.0 9.7 L 37.1 9.4 L 39.0 6.9 L 41.0 2.5 L 41.5 -5.0 L 40.9 -7.4 L 40.2 -8.4 L 39.4 -9.3 L 38.4 -9.5","0 23.5 M 15.6 -9.0 L 15.7 -11.8 L 16.5 -12.4 L 16.8 -11.7 L 20.3 -2.9 L 22.8 3.6 L 25.0 8.2 L 26.7 9.0 L 28.5 8.9 L 29.2 7.8 L 29.9 6.0 L 30.2 4.7 M 34.5 -14.1 L 23.4 -4.5 L 17.5 .7 L 13.9 4.4 L 11.0 8.1 L 9.1 11.6","0 26.3 M 9.6 -9.0 L 13.4 -12.7 L 16.6 -14.9 L 19.5 -15.0 L 20.6 -12.5 L 19.5 -6.4 L 17.9 -.9 L 15.7 3.9 L 14.3 7.1 L 16.7 4.5 L 21.1 -1.4 L 25.8 -7.8 L 28.5 -11.1 L 30.2 -12.8 L 31.7 -13.4 L 32.4 -13.0 L 33.4 -11.6 L 33.3 -8.0 L 30.2 -.6 L 25.8 6.5 L 20.5 13.8 L 16.7 17.8 L 14.0 19.1 L 12.9 18.4 L 13.2 16.4 L 14.7 13.4 L 18.1 8.4 L 23.7 2.7 L 29.4 -2.8 L 32.5 -5.5 L 34.9 -7.0","0 32.3 M 17.8 -11.4 L 18.4 -10.9 L 28.9 -11.8 L 33.7 -11.9 L 36.0 -11.1 L 37.1 -10.4 L 37.4 -9.0 L 37.7 -7.5 L 25.0 -1.2 L 18.3 3.0 L 14.3 5.6 L 11.6 7.7 L 10.2 9.0 L 17.5 7.5 L 25.9 6.3 L 33.6 6.6 L 37.1 7.3 L 39.2 8.5 L 39.7 9.7 L 38.9 12.8 L 37.4 14.3 L 36.0 15.3","0 21.8 M 28.4 -15.4 L 23.2 -15.4 L 20.8 -13.2 L 15.0 -4.2 L 11.3 3.3 L 10.4 7.9 L 10.8 8.8 L 12.1 9.3 L 17.7 9.6","0 20.4 M 10.2 -15.8 L 14.3 -10.5 L 19.3 -4.2 L 23.0 1.7 L 25.5 7.1 L 26.7 11.1 L 26.6 12.9","0 20.5 M 20.8 -15.2 L 25.6 -15.4 L 27.8 -14.8 L 27.0 -10.2 L 23.5 -1.9 L 19.5 4.4 L 15.9 8.7 L 14.6 9.3 L 9.8 9.2","0 14.0 M 11.2 -2.8 L 15.4 -5.9 L 17.8 -3.8 L 20.0 -2.6","0 28.8 M 8.3 10.8 L 36.7 10.7","0 8.7 M 9.8 -6.1 L 15.5 -2.0","0 14.2 M 22.7 -2.4 L 21.4 -3.9 L 18.8 -4.3 L 15.9 -2.8 L 12.3 .9 L 10.1 4.6 L 9.5 7.3 L 10.3 8.9 L 12.1 8.9 L 13.5 7.6 L 20.4 -.6 L 20.5 -.4 L 19.0 4.3 L 19.0 7.8 L 19.5 9.3 L 20.9 9.5","0 14.5 M 9.0 9.1 L 11.5 10.3 L 15.3 8.9 L 18.4 5.7 L 20.1 2.2 L 21.0 -1.1 L 20.7 -2.8 L 19.3 -3.9 L 16.9 -3.6 L 14.9 -1.7 L 12.3 1.9 L 10.9 5.0 L 11.0 7.8 L 11.0 4.8 L 18.2 -12.1 L 18.3 -13.6 L 17.4 -14.6 L 15.6 -14.9 L 14.6 -14.6","0 12.4 M 18.3 -.8 L 19.0 -1.9 L 18.8 -3.2 L 18.3 -4.0 L 16.5 -4.2 L 12.9 -1.6 L 10.0 2.8 L 9.2 6.4 L 9.8 8.2 L 11.5 9.3 L 13.6 9.3 L 15.5 7.8 L 17.9 5.4 L 20.3 2.5","0 15.2 M 18.8 -3.9 L 17.6 -4.3 L 16.3 -3.9 L 12.5 -.3 L 10.0 3.6 L 9.3 6.1 L 9.5 7.8 L 10.9 9.1 L 12.9 8.3 L 16.0 4.3 L 18.5 .9 L 20.5 -1.4 L 22.2 -6.4 L 24.1 -11.3 L 24.7 -13.6 L 23.3 -14.5 L 22.4 -14.6 L 25.6 -13.9 L 26.0 -13.0 L 25.6 -11.8 L 18.8 2.7 L 18.3 6.0 L 17.8 8.5 L 18.3 10.3 L 19.1 11.0 L 20.1 10.9","0 11.8 M 13.2 2.6 L 15.7 1.9 L 18.1 -.2 L 18.8 -1.7 L 18.8 -3.2 L 17.9 -4.0 L 16.5 -4.2 L 14.2 -3.0 L 11.5 .3 L 9.5 3.9 L 9.1 6.3 L 9.3 7.9 L 10.6 9.2 L 13.1 9.3 L 15.3 8.0 L 17.2 6.1 L 18.7 4.3 L 19.9 2.6","0 11.4 M -4.9 18.7 L -4.2 20.6 L -2.4 22.2 L .7 23.0 L 3.7 21.8 L 6.5 18.8 L 8.9 14.7 L 12.0 7.3 L 15.2 -2.8 L 18.0 -10.8 L 20.1 -14.7 L 21.3 -15.8 L 23.4 -15.7 L 24.5 -14.6 L 24.0 -12.4 M 12.6 -4.0 L 14.5 -3.3 L 16.8 -3.3 L 19.9 -3.9 L 22.4 -4.5","0 12.1 M 21.7 -.1 L 21.7 -1.5 L 19.7 -2.6 L 16.6 -2.7 L 13.5 -1.4 L 11.1 1.6 L 9.7 4.8 L 10.0 7.1 L 11.5 8.7 L 14.4 8.5 L 17.3 5.2 L 18.7 1.0 L 18.3 -2.6 L 17.1 -4.7 L 15.6 -5.8 L 14.2 -6.0 L 13.3 -5.2 L 13.0 -3.1 L 13.5 .5 L 16.1 6.0 L 16.8 8.8 L 16.1 14.3 L 14.3 19.1 L 9.5 24.6 L 3.1 28.6 L -2.9 29.8 L -8.8 27.8 L -10.4 25.2 L -10.2 22.2 L -8.3 18.9 L -4.9 15.9 L -.2 13.6 L 4.1 12.0 L 8.3 11.2 L 10.8 11.0 L 15.3 11.2 L 19.7 12.8 L 21.5 14.8 L 21.7 16.7","0 13.0 M 14.5 -14.7 L 14.9 -14.7 L 16.9 -15.0 L 18.1 -14.1 L 18.3 -12.7 L 16.3 -8.0 L 10.8 4.2 L 10.0 7.3 L 10.0 10.8 L 7.6 8.1 L 10.9 5.9 L 15.1 2.1 L 18.4 -1.7 L 19.7 -4.0 L 20.2 -4.0 L 19.5 -2.6 L 18.0 .6 L 16.9 4.5 L 17.0 7.4 L 17.6 9.0 L 19.0 9.6 L 19.7 9.2","0 8.5 M 14.0 -3.7 L 12.0 .6 L 10.9 4.7 L 10.5 8.6 L 11.2 9.7 L 12.5 9.4 L 14.1 8.2 M 15.0 -7.5 L 17.4 -9.6 L 16.6 -7.5 L 15.0 -7.5","0 8.6 M 8.3 9.0 L 1.9 13.9 L -2.4 18.3 L -6.1 23.1 L -8.1 26.7 L -7.9 29.7 L -6.5 31.2 L -3.0 30.5 L 1.4 26.2 L 6.4 19.1 L 9.7 12.6 L 12.5 4.8 L 13.0 1.0 L 13.2 -3.7 M 15.4 -8.8 L 13.8 -7.0 L 14.9 -6.7 L 15.4 -8.8","0 13.9 M 14.2 -14.8 L 16.5 -15.0 L 17.7 -13.3 L 16.9 -10.2 L 11.4 2.7 L 10.6 4.6 L 10.2 6.8 L 10.0 9.1 L 11.1 6.6 L 13.7 3.2 L 16.5 -.6 L 20.0 -3.7 L 23.0 -5.6 L 22.8 -3.3 L 21.3 -.6 L 19.6 .7 L 18.3 1.6 L 15.5 .8 L 14.8 .1 L 14.1 .8 L 16.6 3.2 L 17.8 5.2 L 18.7 8.2 L 18.9 10.4 L 18.5 12.5","0 9.1 M 11.2 .5 L 14.1 -2.1 L 17.4 -6.9 L 20.2 -10.7 L 21.5 -14.0 L 20.6 -15.5 L 19.4 -15.8 L 17.7 -15.0 L 13.6 -7.3 L 11.8 -1.7 L 10.5 3.7 L 10.4 6.6 L 10.4 8.4 L 11.4 9.3 L 13.0 9.4","0 22.0 M 12.0 -5.3 L 12.4 -5.3 L 13.7 -4.8 L 14.2 -3.7 L 13.8 -1.5 L 10.5 8.2 L 15.2 .2 L 17.6 -3.1 L 19.8 -4.0 L 21.0 -3.0 L 21.1 -.5 L 18.8 8.2 L 21.5 5.2 L 26.9 -1.0 L 28.2 -1.4 L 27.1 2.4 L 26.6 6.7 L 27.2 8.8 L 28.1 8.9","0 15.2 M 11.7 -5.3 L 13.4 -5.0 L 14.0 -3.9 L 13.2 .2 L 11.5 5.4 L 10.8 8.3 L 13.1 4.5 L 16.1 .5 L 18.2 -2.4 L 19.0 -2.9 L 20.5 -3.3 L 20.5 -3.3 L 21.1 -4.2 L 21.9 -4.1 L 20.3 -1.6 L 18.7 3.5 L 18.5 6.9 L 19.2 9.0 L 20.5 9.6 L 21.1 9.5 L 21.7 8.9","0 12.2 M 14.1 .8 L 12.4 -.3 L 11.4 -1.7 L 11.5 -4.3 L 13.4 -5.9 L 15.7 -6.0 L 17.2 -5.0 L 18.3 -3.0 L 18.7 -.3 L 18.3 3.0 L 16.6 6.6 L 14.5 8.6 L 13.4 8.9 L 11.3 8.8 L 9.8 7.1 L 9.7 4.4 L 10.6 1.6 L 11.8 .1 L 13.5 -1.3 L 14.9 -2.2 L 16.5 -2.8 L 18.9 -2.8 L 20.4 -2.5","0 17.1 M 12.5 -5.0 L 14.2 -5.3 L 15.7 -4.8 L 16.1 -3.5 L 15.4 -1.1 L 11.8 6.8 L 9.6 11.8 L 8.4 16.6 L 8.5 18.6 L 9.0 19.8 L 9.7 20.4 L 10.9 19.8 M 12.1 6.3 L 14.7 2.0 L 17.6 -1.3 L 20.3 -3.7 L 22.4 -4.4 L 23.4 -3.6 L 23.7 -1.7 L 23.0 1.4 L 21.2 4.2 L 19.1 6.8 L 16.9 8.4 L 15.2 8.7 L 13.6 8.6 L 11.4 7.9","0 13.8 M 21.2 -2.8 L 20.1 -4.1 L 17.7 -4.1 L 14.3 -1.5 L 12.3 1.3 L 10.5 4.2 L 9.6 6.5 L 9.5 8.1 L 10.2 8.6 L 11.4 8.7 L 13.5 7.3 L 16.9 3.3 L 20.5 -1.2 L 21.1 -1.3 L 16.8 6.4 L 14.5 13.1 L 13.1 17.8 L 12.9 19.0 L 13.2 20.7 L 14.2 21.2 L 15.3 20.8 L 16.9 18.6 L 18.4 15.3 L 19.2 11.5 L 19.2 8.4 L 18.8 7.2 L 17.3 5.6","0 13.3 M 12.3 -5.3 L 13.2 -4.8 L 13.7 -4.0 L 13.6 -2.5 L 10.5 8.4 L 12.8 3.3 L 14.7 1.0 L 17.0 -1.5 L 19.6 -3.2 L 21.6 -4.4 L 20.2 -4.4 L 19.3 -1.5 L 19.4 .0 L 20.0 .7 L 21.2 1.1","0 10.5 M 9.2 9.5 L 11.3 9.5 L 13.7 8.7 L 14.6 7.8 L 14.7 6.3 L 11.4 2.7 L 10.9 1.1 L 11.1 -.6 L 12.9 -2.7 L 15.0 -3.9 L 16.6 -4.4 L 18.5 -4.2","0 9.1 M 12.0 9.6 L 10.9 9.9 L 9.9 9.5 L 9.6 7.8 L 10.3 5.2 L 15.0 -5.4 L 15.4 -7.5 L 15.4 -9.3 L 14.8 -9.8 L 13.7 -9.6 M 11.3 -3.8 L 14.2 -3.0 L 16.9 -3.2 L 18.9 -3.7 L 20.6 -4.4","0 15.5 M 13.9 -4.0 L 13.9 -3.2 L 11.6 1.8 L 10.0 5.7 L 9.9 7.5 L 11.0 9.1 L 12.5 9.2 L 14.2 7.3 L 18.7 .7 L 21.4 -3.7 L 22.1 -3.9 L 19.9 1.4 L 19.1 5.4 L 19.6 8.4 L 20.7 9.7 L 21.9 9.4 L 22.2 9.2","0 11.4 M 9.5 -3.4 L 10.9 -4.0 L 12.1 -3.1 L 12.4 -1.0 L 11.8 9.1 L 13.5 4.9 L 16.2 1.3 L 18.5 -1.6 L 20.7 -3.9 L 23.3 -6.0","0 22.2 M 15.4 -3.0 L 11.7 2.5 L 9.9 6.2 L 9.7 7.9 L 10.6 9.0 L 12.1 8.7 L 13.4 7.5 L 16.6 3.5 L 20.0 -1.3 L 20.7 -1.4 L 20.6 1.7 L 20.9 4.9 L 21.6 7.2 L 22.6 8.6 L 24.0 8.9 L 26.0 7.7 L 28.1 4.4 L 28.8 1.3 L 28.8 -.9 L 28.4 -2.5 L 27.4 -4.0","0 14.5 M 12.9 -3.7 L 14.3 -3.4 L 14.4 -2.7 L 15.0 2.0 L 15.9 6.2 L 17.0 8.7 L 18.2 9.6 L 19.6 9.4 L 20.6 8.9 M 24.0 -4.7 L 18.5 .0 L 14.2 4.0 L 9.8 8.9 L 7.2 12.2","0 14.8 M 12.2 -5.3 L 13.4 -5.1 L 13.9 -4.3 L 13.9 -3.1 L 12.4 1.0 L 9.7 8.5 L 12.4 4.7 L 15.6 .9 L 18.1 -1.6 L 19.7 -3.6 L 20.5 -4.2 L 22.1 -3.0 L 21.3 3.6 L 17.9 12.9 L 14.8 19.1 L 11.0 24.3 L 7.3 28.1 L 5.4 29.7 L 2.5 29.9 L 1.0 29.1 L .4 26.7 L 2.5 22.1 L 6.4 17.2 L 10.9 12.9 L 14.2 10.3 L 16.3 8.5","0 16.5 M 13.0 -2.8 L 16.6 -3.3 L 19.4 -3.7 L 21.5 -3.7 L 22.6 -3.5 L 23.7 -1.9 L 22.8 -.6 L 11.5 7.2 L 10.0 8.6 L 12.7 7.5 L 16.8 7.1 L 20.4 7.1 L 22.4 7.6 L 23.5 8.7 L 23.4 10.3 L 22.9 11.2","0 12.8 M 22.4 -12.9 L 18.0 -11.7 L 16.5 -8.1 L 16.1 -5.1 L 14.9 -2.6 L 13.9 -1.2 L 12.3 -.6 L 10.3 .0 L 12.4 .6 L 14.2 2.4 L 14.3 4.1 L 13.0 10.1 L 13.1 11.6 L 14.1 12.8 L 15.0 13.0 L 16.6 13.1","0 8.6 M 13.0 -12.2 L 13.5 -8.6 L 13.1 -3.1 L 12.5 3.1 L 11.8 8.1 L 10.7 12.3","0 15.9 M 15.7 -13.2 L 18.0 -13.1 L 19.7 -11.9 L 19.8 -9.5 L 18.8 -2.6 L 19.3 -1.4 L 20.3 -.6 L 21.5 -.3 L 22.6 .1 L 20.4 .5 L 18.3 1.5 L 17.1 3.9 L 16.3 7.5 L 15.4 10.7 L 13.9 12.1 L 12.2 12.8 L 10.2 12.8","0 15.1 M 13.9 -5.2 L 14.6 -5.8 L 15.8 -6.1 L 17.0 -5.8 L 18.4 -5.3 L 18.9 -5.1 L 19.8 -5.5 L 20.6 -6.1","0 11.2 M 12.7 -7.5 L 11.1 -6.0 L 11.3 -3.7 L 13.5 -2.3 L 16.3 -3.1 L 17.1 -5.4 L 15.6 -7.7 L 13.9 -8.3 L 12.7 -7.5"]
EMSReadability = ["-8 8","0 8.9 M 12.4 -13.4 L 12.4 1.9 M 11.7 5.8 L 11.7 7.4 L 13.2 7.4 L 13.2 5.8 L 11.7 5.8","0 12.1 M 11.7 -14.0 L 11.8 -7.6 M 16.1 -14.0 L 16.3 -7.6","0 15.9 M 14.4 -12.6 L 11.9 7.5 M 20.1 -12.6 L 17.6 7.5 M 10.3 -6.2 L 22.3 -6.2 M 9.7 .2 L 21.6 .2","0 15.9 M 20.4 -10.4 L 18.8 -11.8 L 17.1 -12.2 L 16.1 -12.3 L 16.1 -15.7 L 16.1 -12.3 L 14.0 -11.9 L 12.4 -10.4 L 11.8 -8.7 L 11.9 -6.6 L 12.7 -5.1 L 14.3 -3.9 L 17.8 -2.1 L 19.2 -1.0 L 20.3 .1 L 20.9 1.9 L 20.9 3.4 L 20.4 5.3 L 18.7 6.7 L 16.6 7.4 L 16.1 7.4 L 16.1 10.7 L 16.1 7.4 L 14.5 7.2 L 12.5 6.4 L 11.0 5.2","0 26.3 M 14.1 -1.0 L 15.6 -1.3 L 16.8 -2.3 L 17.6 -3.9 L 18.0 -6.1 L 18.1 -7.7 L 17.6 -9.9 L 16.8 -11.6 L 15.8 -12.6 L 14.6 -13.1 L 13.3 -13.0 L 11.8 -12.1 L 10.9 -10.7 L 10.5 -9.0 L 10.4 -5.6 L 10.7 -3.8 L 11.4 -2.4 L 12.4 -1.5 L 13.2 -1.1 L 14.1 -1.0 M 28.1 7.6 L 29.6 7.3 L 30.7 6.2 L 31.6 4.7 L 31.9 2.5 L 32.0 .9 L 31.6 -1.4 L 30.8 -3.1 L 29.8 -4.1 L 28.5 -4.6 L 27.2 -4.4 L 25.8 -3.6 L 24.8 -2.2 L 24.5 -.5 L 24.3 2.9 L 24.7 4.8 L 25.4 6.1 L 26.3 7.0 L 27.2 7.5 L 28.1 7.6 M 15.4 7.7 L 26.8 -13.3","0 19.0 M 25.7 7.3 L 23.4 6.3 L 20.9 4.2 L 18.3 1.7 L 16.6 -.4 L 14.5 -3.7 L 13.5 -6.1 L 13.2 -9.2 L 13.5 -11.0 L 14.6 -12.4 L 16.2 -13.0 L 18.1 -12.7 L 19.2 -11.7 L 19.7 -10.1 L 19.4 -8.4 L 18.4 -6.7 L 17.1 -5.6 L 13.3 -2.7 L 12.0 -1.5 L 10.8 .1 L 10.2 1.8 L 10.5 3.7 L 11.5 5.8 L 13.5 7.0 L 16.0 7.5 L 17.9 7.0 L 20.1 5.7 L 21.7 3.8 L 23.1 1.9 L 24.2 -.6 L 25.0 -2.8","0 7.9 M 11.7 -14.0 L 11.9 -7.6","0 9.6 M 15.6 12.7 L 14.0 9.7 L 12.6 5.8 L 12.1 3.4 L 11.8 -.1 L 11.8 -3.4 L 12.3 -6.3 L 13.0 -9.1 L 14.1 -12.1 L 15.0 -13.8 L 15.7 -14.8","0 9.6 M 10.0 12.8 L 11.7 9.6 L 13.0 6.2 L 13.6 2.9 L 14.0 -1.2 L 13.5 -5.2 L 13.1 -7.8 L 12.4 -10.2 L 11.2 -12.6 L 10.0 -14.9","0 13.4 M 12.4 -7.5 L 14.6 -10.7 L 18.2 -11.9 L 14.6 -10.7 L 14.6 -14.5 L 14.6 -10.7 L 11.0 -11.9 L 14.6 -10.7 L 17.1 -7.4","0 15.9 M 15.9 -9.6 L 15.9 4.1 M 9.8 -2.8 L 22.3 -2.8","0 7.9 M 12.5 7.2 L 11.3 7.2 L 11.3 5.6 L 12.5 5.6 L 13.0 7.4 L 12.9 8.9 L 12.3 10.2 L 11.5 11.0 L 10.6 11.8","0 10.4 M 9.8 -.3 L 16.3 -.3","0 7.9 M 11.1 5.7 L 11.1 7.3 L 12.7 7.3 L 12.7 5.7 L 11.1 5.7","0 12.1 M 9.4 12.5 L 18.9 -14.5","0 15.9 M 15.8 7.4 L 17.7 7.0 L 19.7 5.0 L 20.6 2.9 L 21.0 .5 L 21.2 -2.8 L 21.0 -5.9 L 20.3 -8.9 L 19.3 -10.8 L 17.7 -12.0 L 16.3 -12.5 L 15.1 -12.4 L 13.2 -11.3 L 11.9 -9.5 L 11.0 -6.6 L 10.7 -3.6 L 10.6 -.6 L 11.0 2.2 L 12.0 5.0 L 13.2 6.3 L 14.4 7.3 L 15.8 7.4","0 16.0 M 16.4 -11.0 L 13.1 -10.9 L 16.5 -12.2 L 16.5 7.0 L 11.5 7.0 L 21.4 7.0","0 16.0 M 10.4 -9.7 L 11.7 -11.0 L 13.3 -12.0 L 15.3 -12.5 L 17.0 -12.2 L 18.8 -11.3 L 19.9 -9.8 L 20.4 -7.6 L 20.3 -5.7 L 19.3 -3.4 L 17.5 -.8 L 15.3 1.9 L 13.3 4.0 L 11.5 6.0 L 10.6 7.0 L 21.9 7.0","0 15.8 M 10.8 -10.3 L 12.4 -11.5 L 14.5 -12.4 L 16.2 -12.4 L 18.0 -11.9 L 19.5 -10.7 L 20.2 -9.1 L 20.5 -7.2 L 20.0 -5.5 L 18.3 -4.2 L 16.4 -3.2 L 14.8 -2.9 L 13.6 -2.9 L 15.1 -2.9 L 16.7 -2.7 L 18.3 -2.1 L 20.0 -.8 L 20.8 .4 L 21.1 1.8 L 21.0 3.3 L 20.7 4.5 L 19.7 5.9 L 18.3 6.8 L 16.5 7.3 L 14.6 7.3 L 12.8 6.8 L 11.0 5.8 L 9.9 4.8","0 16.0 M 18.8 7.5 L 18.8 -12.0 L 9.5 1.0 L 22.1 1.0","0 15.9 M 9.9 4.9 L 11.2 6.0 L 12.6 6.8 L 14.2 7.4 L 15.7 7.5 L 18.0 6.9 L 19.6 5.6 L 20.9 3.7 L 21.4 1.5 L 21.1 -1.1 L 20.0 -3.1 L 17.7 -4.4 L 15.4 -4.6 L 13.7 -4.2 L 12.0 -3.3 L 11.8 -3.6 L 12.4 -12.0 L 20.6 -12.0","0 15.8 M 10.7 -.4 L 12.2 -2.0 L 14.0 -3.4 L 15.8 -4.0 L 17.8 -4.0 L 19.3 -3.3 L 20.4 -2.3 L 21.2 -.4 L 21.5 1.8 L 21.0 4.1 L 19.9 6.0 L 18.2 7.2 L 16.2 7.5 L 14.4 6.9 L 12.8 5.7 L 11.5 3.7 L 10.9 .9 L 10.7 -2.1 L 11.1 -5.9 L 11.8 -8.2 L 12.7 -10.0 L 14.2 -11.5 L 16.1 -12.3 L 18.0 -12.4 L 19.8 -11.8 L 21.1 -10.7","0 16.0 M 15.1 7.4 L 15.5 2.1 L 16.3 -1.7 L 17.4 -5.0 L 18.8 -7.6 L 20.3 -10.0 L 21.8 -12.1 L 10.3 -12.1","0 15.9 M 17.4 -2.2 L 19.4 -3.8 L 20.6 -5.6 L 20.9 -7.3 L 20.8 -9.1 L 19.5 -11.2 L 17.5 -12.3 L 15.9 -12.4 L 13.5 -11.7 L 11.9 -10.1 L 11.5 -8.3 L 12.0 -5.8 L 13.6 -4.3 L 16.4 -2.8 L 19.0 -1.4 L 20.7 -.1 L 21.5 1.7 L 21.3 3.9 L 20.7 5.5 L 18.8 7.0 L 16.4 7.5 L 14.5 7.2 L 12.5 6.3 L 11.0 4.7 L 10.5 3.0 L 10.7 .5 L 12.3 -1.7 L 13.6 -2.6 L 15.3 -3.4","0 15.9 M 10.8 5.6 L 11.9 6.7 L 13.7 7.3 L 15.6 7.5 L 17.6 6.5 L 19.5 4.6 L 20.6 1.7 L 21.1 -1.8 L 21.1 -5.1 L 20.4 -8.2 L 19.2 -10.6 L 17.3 -12.0 L 15.1 -12.4 L 12.8 -11.6 L 11.4 -10.2 L 10.6 -8.4 L 10.4 -6.6 L 10.5 -4.6 L 11.6 -2.5 L 13.6 -1.2 L 16.0 -.9 L 18.6 -2.0 L 20.2 -3.5 L 21.2 -4.8","0 7.9 M 11.1 -6.4 L 11.1 -4.9 L 12.6 -4.9 L 12.6 -6.4 L 11.1 -6.4 M 11.1 5.7 L 11.1 7.2 L 12.6 7.2 L 12.6 5.7 L 11.1 5.7","0 7.8 M 11.1 -6.4 L 11.1 -4.8 L 12.7 -4.8 L 12.7 -6.4 L 11.1 -6.4 M 12.5 7.2 L 11.3 7.2 L 11.3 5.6 L 12.5 5.6 L 13.0 7.4 L 12.9 8.9 L 12.4 10.2 L 11.5 11.0 L 10.6 11.8","0 16.0 M 22.3 2.2 L 9.7 -2.9 L 22.3 -8.0","0 16.0 M 9.6 -6.0 L 22.3 -6.0 M 9.6 .4 L 22.3 .4","0 15.8 M 9.8 2.2 L 22.3 -3.0 L 9.8 -8.0","0 13.6 M 13.4 5.7 L 13.4 7.3 L 15.0 7.3 L 15.0 5.7 L 13.4 5.7 M 14.0 1.6 L 14.2 -.3 L 15.0 -2.3 L 17.2 -5.3 L 18.5 -7.4 L 18.8 -9.2 L 18.4 -11.0 L 17.4 -12.4 L 16.2 -13.2 L 14.5 -13.4 L 12.8 -13.1 L 11.4 -12.4 L 10.2 -11.3","0 26.4 M 25.3 -5.1 L 24.0 2.5 L 22.4 4.1 L 20.8 4.9 L 18.9 5.0 L 17.2 3.7 L 16.7 1.6 L 17.3 -1.6 L 19.0 -4.1 L 21.3 -5.3 L 23.3 -4.9 L 24.3 -4.0 L 24.9 -2.8 L 24.0 2.7 L 24.2 3.9 L 25.9 5.2 L 28.2 5.0 L 30.1 3.4 L 31.4 1.3 L 31.8 -1.3 L 31.7 -4.0 L 30.9 -6.9 L 29.5 -9.0 L 27.7 -10.6 L 24.8 -11.6 L 21.7 -11.8 L 19.0 -11.3 L 15.9 -9.7 L 13.7 -7.6 L 12.2 -5.3 L 11.0 -2.3 L 10.6 .3 L 10.6 2.5 L 11.3 5.5 L 12.5 7.9 L 15.0 10.1 L 17.2 11.1 L 20.3 11.7 L 23.2 11.6 L 25.9 10.2","0 17.4 M 9.3 7.5 L 16.8 -13.0 L 21.2 -.1 L 12.2 -.1 L 21.2 -.1 L 23.9 7.5","0 19.1 M 12.1 7.1 L 12.1 -12.5 L 17.9 -12.5 L 19.6 -12.4 L 21.3 -11.7 L 22.7 -10.4 L 23.1 -8.9 L 23.1 -7.1 L 22.4 -5.5 L 20.9 -4.4 L 19.6 -3.8 L 17.8 -3.5 L 12.3 -3.5 L 17.9 -3.5 L 19.6 -3.2 L 21.6 -2.7 L 23.2 -1.6 L 24.1 -.6 L 24.4 .8 L 24.4 2.8 L 23.6 4.7 L 22.2 5.9 L 19.7 6.9 L 17.9 7.1 L 12.3 7.1","0 18.7 M 24.5 4.9 L 22.4 6.5 L 19.6 7.5 L 16.8 7.1 L 14.2 5.7 L 12.2 3.3 L 11.2 .8 L 10.9 -3.0 L 11.2 -6.5 L 12.5 -9.4 L 14.5 -11.6 L 16.8 -12.7 L 19.4 -12.9 L 21.7 -12.4 L 23.3 -11.4 L 23.8 -10.8","0 19.9 M 12.2 7.0 L 12.2 -12.5 L 17.8 -12.5 L 20.1 -11.9 L 21.8 -11.0 L 23.0 -9.8 L 24.4 -7.5 L 24.9 -4.9 L 24.9 -3.3 L 24.8 -1.2 L 24.5 1.2 L 23.7 2.9 L 22.3 5.0 L 20.1 6.3 L 18.0 6.9 L 16.4 7.0 L 12.3 7.0","0 17.1 M 22.8 7.0 L 12.2 7.0 L 12.2 -3.3 L 21.0 -3.3 L 12.2 -3.3 L 12.2 -12.4 L 22.4 -12.4","0 15.9 M 12.2 7.4 L 12.2 -3.0 L 21.1 -3.0 L 12.2 -3.0 L 12.2 -12.4 L 22.4 -12.4","0 19.8 M 19.0 -2.0 L 24.5 -2.0 L 24.5 5.4 L 23.2 6.3 L 20.4 7.3 L 18.4 7.4 L 16.4 7.0 L 14.6 6.0 L 12.5 3.6 L 11.1 .6 L 10.8 -2.9 L 11.2 -6.3 L 12.5 -9.3 L 14.6 -11.6 L 16.7 -12.6 L 19.1 -13.0 L 21.7 -12.6 L 23.3 -11.7 L 24.4 -10.8","0 21.2 M 12.2 7.3 L 12.2 -12.7 L 12.2 -3.4 L 24.9 -3.4 L 24.9 -12.6 L 24.9 7.3","0 8.5 M 12.2 7.4 L 12.2 -12.7","0 15.5 M 10.5 4.8 L 11.5 6.0 L 12.7 6.9 L 14.3 7.5 L 16.3 7.2 L 18.2 5.9 L 19.1 4.0 L 19.3 2.5 L 19.3 -12.8","0 18.5 M 12.2 7.4 L 12.2 -12.8 M 23.6 -12.6 L 12.5 -.1 M 17.3 -5.5 L 24.8 7.4","0 15.6 M 12.2 -12.8 L 12.2 7.0 L 22.2 7.0","0 23.2 M 12.1 7.5 L 12.1 -12.8 L 13.1 -12.8 L 19.6 4.9 L 26.1 -12.7 L 26.8 -12.7 L 26.8 7.4","0 20.8 M 12.0 7.3 L 12.0 -12.6 L 12.7 -12.6 L 24.6 7.3 L 24.6 -12.7","0 21.5 M 18.6 7.3 L 21.2 6.9 L 23.8 5.2 L 25.6 2.5 L 26.5 -1.0 L 26.5 -4.3 L 26.0 -7.0 L 25.0 -9.2 L 23.4 -11.3 L 21.2 -12.6 L 19.0 -13.0 L 17.1 -12.7 L 15.0 -11.9 L 13.0 -10.2 L 11.5 -7.3 L 11.0 -5.0 L 10.9 -1.6 L 11.3 1.0 L 12.3 3.4 L 13.7 5.3 L 15.3 6.6 L 17.0 7.2 L 18.6 7.3","0 18.4 M 12.3 7.5 L 12.3 -12.6 L 19.4 -12.6 L 21.2 -12.1 L 22.5 -11.1 L 23.5 -9.8 L 23.9 -7.8 L 23.8 -6.0 L 23.0 -4.0 L 21.5 -2.8 L 19.4 -2.0 L 17.0 -1.9 L 12.2 -1.9","0 21.4 M 18.5 7.5 L 20.7 7.0 L 23.0 5.8 L 24.9 3.8 L 26.0 1.0 L 26.4 -1.4 L 26.4 -4.2 L 26.0 -7.1 L 25.2 -9.1 L 23.4 -11.3 L 21.1 -12.6 L 19.0 -13.1 L 16.8 -12.7 L 14.7 -11.8 L 12.9 -10.0 L 11.8 -8.1 L 11.1 -5.1 L 10.8 -2.8 L 11.0 -.6 L 11.7 2.0 L 12.8 4.2 L 14.2 5.7 L 15.9 6.8 L 17.6 7.3 L 18.5 7.4 L 19.4 9.2 L 20.7 10.5 L 22.1 11.3 L 23.9 11.8 L 25.5 11.9 L 27.0 11.6","0 18.4 M 12.1 7.4 L 12.1 -12.6 L 18.8 -12.6 L 20.4 -12.1 L 22.2 -11.2 L 23.5 -9.2 L 23.5 -7.5 L 23.2 -5.6 L 22.0 -3.9 L 20.5 -3.0 L 18.1 -2.4 L 12.2 -2.4 L 17.9 -2.4 L 23.7 7.4","0 17.3 M 10.5 4.6 L 12.2 6.0 L 13.8 6.8 L 15.8 7.2 L 18.1 7.3 L 20.6 6.3 L 22.3 4.8 L 22.9 2.8 L 22.8 1.0 L 21.7 -.8 L 19.4 -2.3 L 15.3 -4.1 L 13.0 -5.6 L 11.8 -7.2 L 11.7 -9.2 L 12.5 -11.3 L 14.8 -12.7 L 17.0 -13.0 L 19.1 -12.8 L 20.7 -12.0 L 22.2 -10.9","0 17.4 M 16.7 7.3 L 16.7 -12.6 L 9.8 -12.6 L 23.7 -12.6","0 21.0 M 12.3 -12.8 L 12.3 1.1 L 12.6 2.9 L 13.5 4.8 L 14.7 6.1 L 16.5 7.1 L 18.2 7.5 L 20.3 7.2 L 22.4 6.1 L 23.9 4.3 L 24.6 2.7 L 24.8 .5 L 24.8 -12.7","0 16.3 M 9.4 -12.8 L 16.1 7.4 L 22.8 -12.7","0 25.1 M 10.1 -12.8 L 14.8 7.4 L 15.2 7.3 L 20.4 -12.7 L 20.8 -12.7 L 26.1 7.4 L 26.5 7.4 L 31.0 -12.8","0 16.1 M 9.8 7.4 L 21.8 -12.8 M 10.4 -12.9 L 22.2 7.4","0 15.0 M 9.4 -12.8 L 15.5 -.7 L 15.5 7.3 L 15.5 -.8 L 21.5 -12.7","0 17.8 M 11.2 -12.6 L 23.2 -12.6 L 10.5 7.1 L 23.6 7.1","0 9.7 M 16.3 11.9 L 12.1 11.9 L 12.1 -14.2 L 16.3 -14.2","0 12.2 M 9.3 -14.4 L 18.8 12.5","0 9.7 M 9.4 11.8 L 13.6 11.8 L 13.6 -14.3 L 9.4 -14.3","0 16.0 M 11.2 -1.9 L 15.9 -13.4 L 20.7 -1.6","0 16.8 M 8.9 10.6 L 23.9 10.6","0 17.7 M 15.0 -14.5 L 17.9 -10.6","0 16.5 M 11.7 -5.6 L 13.8 -6.8 L 15.6 -7.3 L 17.4 -7.5 L 18.8 -7.0 L 20.0 -5.9 L 20.8 -4.3 L 20.9 -2.1 L 20.9 4.6 L 20.9 7.3 L 20.8 4.6 L 19.5 5.5 L 18.1 6.5 L 16.5 7.2 L 14.7 7.5 L 13.2 7.0 L 12.0 6.2 L 11.1 4.9 L 11.1 3.0 L 11.8 1.5 L 13.4 .2 L 15.0 -.4 L 16.9 -1.0 L 18.7 -1.3 L 19.8 -1.4 L 20.7 -1.4","0 17.9 M 11.9 -14.8 L 11.9 7.5 L 11.9 4.8 L 13.0 5.7 L 14.7 6.8 L 16.5 7.3 L 18.3 7.4 L 20.4 6.2 L 21.7 4.8 L 22.7 2.8 L 23.1 .3 L 23.0 -2.2 L 22.5 -4.5 L 21.0 -6.4 L 19.7 -7.1 L 17.9 -7.5 L 16.0 -7.1 L 14.1 -6.1 L 12.1 -4.5","0 15.0 M 21.1 5.7 L 19.5 6.9 L 17.1 7.4 L 14.9 7.1 L 12.6 5.6 L 11.3 3.5 L 10.8 1.0 L 10.8 -1.6 L 11.6 -4.0 L 13.2 -5.9 L 15.1 -7.0 L 17.2 -7.3 L 19.0 -7.0 L 20.2 -6.4 L 20.7 -5.8","0 18.0 M 21.9 -14.7 L 21.9 7.3 L 21.9 4.3 L 20.5 5.7 L 18.6 7.0 L 16.7 7.5 L 15.1 7.2 L 13.5 6.5 L 11.9 4.8 L 10.9 2.5 L 10.7 -.3 L 11.4 -3.6 L 13.1 -6.1 L 15.5 -7.3 L 17.4 -7.5 L 19.4 -6.8 L 20.7 -6.0 L 22.0 -4.8","0 16.0 M 10.8 -.4 L 21.8 -.4 L 21.8 -2.2 L 21.3 -4.5 L 19.8 -6.3 L 18.3 -7.3 L 16.2 -7.4 L 14.1 -6.8 L 12.3 -5.3 L 11.6 -3.8 L 10.8 -1.9 L 10.6 .1 L 11.1 2.5 L 12.0 4.7 L 13.8 6.5 L 15.5 7.3 L 17.6 7.5 L 19.4 7.0 L 21.1 6.1","0 9.2 M 12.3 7.4 L 12.3 -7.0 L 9.9 -7.0 L 16.1 -7.0 L 12.2 -7.0 L 12.2 -11.4 L 12.5 -12.9 L 13.5 -14.4 L 15.0 -15.0 L 16.3 -14.8 L 17.2 -14.4","0 16.2 M 13.4 6.7 L 11.9 8.1 L 10.9 9.8 L 10.7 11.6 L 12.1 13.1 L 14.4 14.1 L 17.1 14.4 L 19.5 13.8 L 21.9 12.2 L 22.8 10.7 L 22.7 9.0 L 21.8 7.4 L 19.6 6.8 L 13.5 6.8 L 12.2 5.9 L 11.6 4.5 L 11.9 3.2 L 13.6 1.3 L 14.7 2.0 L 16.4 2.3 L 18.5 1.6 L 20.0 .2 L 20.7 -1.5 L 20.7 -3.5 L 19.9 -5.3 L 19.3 -6.1 L 17.9 -7.0 L 22.7 -7.0 L 17.9 -7.0 L 16.4 -7.3 L 14.1 -7.1 L 12.5 -5.8 L 11.6 -4.0 L 11.5 -2.0 L 11.9 -.4 L 12.7 .6 L 13.6 1.4","0 17.6 M 12.0 7.3 L 12.0 -14.7 L 12.0 -3.6 L 13.5 -5.2 L 14.8 -6.4 L 16.7 -7.2 L 18.6 -7.4 L 20.8 -6.2 L 21.6 -4.8 L 22.0 -2.5 L 22.0 7.4","0 8.0 M 12.0 7.5 L 12.0 -7.2 M 11.1 -13.3 L 11.1 -11.7 L 12.7 -11.7 L 12.7 -13.3 L 11.1 -13.3","0 8.3 M 7.7 13.9 L 7.9 13.9 L 9.0 14.2 L 10.5 14.1 L 11.8 13.2 L 12.2 11.6 L 12.2 -7.3 M 11.3 -13.2 L 11.3 -11.7 L 12.9 -11.7 L 12.9 -13.2 L 11.3 -13.2","0 15.4 M 11.9 7.5 L 11.9 -14.8 M 20.7 -7.2 L 12.0 3.3 M 16.1 -1.7 L 21.8 7.5","0 8.4 M 12.1 -14.7 L 12.1 6.0 L 12.3 6.7 L 12.6 7.1 L 13.1 7.4 L 13.8 7.4","0 26.5 M 11.9 7.5 L 11.9 -7.2 L 11.9 -3.9 L 13.3 -5.1 L 14.6 -6.2 L 15.8 -7.0 L 17.3 -7.4 L 18.6 -7.2 L 19.5 -6.8 L 20.5 -5.8 L 21.2 -4.1 L 21.4 -2.0 L 21.4 7.5 L 21.4 -3.6 L 21.8 -4.4 L 23.9 -6.3 L 25.5 -7.1 L 26.8 -7.5 L 28.2 -7.1 L 29.1 -6.6 L 30.2 -5.3 L 30.7 -2.7 L 30.7 7.4","0 17.7 M 12.0 7.5 L 12.0 -7.3 L 12.0 -3.7 L 13.4 -5.1 L 14.7 -6.3 L 15.7 -6.9 L 17.2 -7.3 L 18.2 -7.4 L 19.7 -7.0 L 20.6 -6.4 L 21.3 -5.4 L 21.9 -4.0 L 21.9 7.5","0 17.8 M 17.1 7.4 L 17.2 7.4 L 19.2 6.9 L 21.1 5.6 L 22.3 3.6 L 22.8 1.4 L 22.9 -.7 L 22.6 -2.6 L 21.9 -4.3 L 20.9 -5.6 L 19.5 -6.8 L 18.0 -7.3 L 16.6 -7.4 L 15.0 -7.1 L 13.5 -6.2 L 12.2 -4.7 L 11.5 -3.3 L 10.9 -1.2 L 10.9 .4 L 11.1 2.3 L 11.6 4.0 L 12.8 5.6 L 14.2 6.7 L 15.7 7.3 L 17.1 7.4","0 18.0 M 11.9 14.2 L 11.9 -7.3 L 11.9 -4.1 L 13.6 -5.8 L 15.6 -6.9 L 17.3 -7.2 L 19.4 -7.2 L 21.0 -6.3 L 22.4 -4.3 L 23.1 -2.0 L 23.1 .6 L 22.8 2.8 L 21.7 5.1 L 20.1 6.6 L 18.9 7.2 L 17.0 7.3 L 15.5 7.0 L 13.8 6.1 L 12.2 5.0","0 17.7 M 21.9 14.1 L 21.9 -7.2 L 21.9 -5.0 L 20.1 -6.3 L 18.2 -7.1 L 15.8 -7.3 L 13.6 -6.4 L 12.1 -4.6 L 11.1 -2.4 L 10.7 -.6 L 10.8 1.2 L 11.0 3.1 L 11.8 5.0 L 13.1 6.3 L 14.5 7.1 L 16.4 7.5 L 18.5 6.9 L 20.4 5.7 L 21.8 4.5","0 10.8 M 12.1 7.4 L 12.1 -7.3 L 12.1 -2.8 L 13.0 -4.6 L 14.4 -6.4 L 15.9 -7.1 L 17.3 -7.3 L 18.2 -7.2","0 13.6 M 10.1 5.5 L 11.9 6.7 L 13.9 7.3 L 15.5 7.5 L 17.5 6.8 L 19.0 5.6 L 19.5 3.8 L 19.1 2.0 L 17.3 .5 L 14.8 -.5 L 12.5 -1.5 L 11.2 -2.8 L 10.9 -4.3 L 11.4 -5.7 L 13.0 -7.1 L 15.0 -7.4 L 17.0 -7.0 L 18.7 -6.0","0 10.6 M 17.5 6.8 L 16.4 7.3 L 15.0 7.3 L 13.7 6.9 L 12.6 5.6 L 12.4 3.4 L 12.4 -6.9 L 9.5 -6.9 L 17.2 -6.9 L 12.4 -6.9 L 12.4 -11.4","0 17.6 M 21.5 -7.1 L 21.5 7.4 L 21.5 3.6 L 20.4 4.9 L 19.1 6.2 L 17.3 7.2 L 15.6 7.5 L 13.8 7.0 L 12.6 6.0 L 11.9 4.7 L 11.8 2.2 L 11.8 -7.1","0 14.6 M 9.7 -7.4 L 15.2 7.5 L 15.6 7.5 L 21.1 -7.4","0 22.3 M 9.9 -7.3 L 14.3 7.7 L 14.7 7.7 L 18.9 -7.3 L 19.5 -7.3 L 23.7 7.7 L 24.1 7.7 L 28.4 -7.3","0 13.8 M 9.6 7.7 L 19.6 -7.4 M 10.2 -7.4 L 20.3 7.7","0 14.6 M 9.7 -7.2 L 15.7 7.9 M 20.9 -7.1 L 14.7 10.5 L 14.0 12.0 L 13.0 13.1 L 11.8 13.8 L 9.7 13.8","0 13.5 M 10.5 -6.8 L 19.4 -6.8 L 10.0 7.0 L 20.1 7.0","0 9.8 M 16.4 11.9 L 14.9 12.0 L 13.3 11.2 L 12.6 9.6 L 13.0 1.2 L 12.6 .1 L 11.8 -.7 L 11.1 -1.0 L 9.8 -1.1 L 11.4 -1.5 L 12.6 -2.2 L 12.8 -3.5 L 12.7 -11.9 L 13.0 -13.3 L 14.4 -14.2 L 16.4 -14.2","0 8.1 M 11.8 15.0 L 11.8 -15.5","0 9.8 M 9.4 11.9 L 11.3 11.8 L 12.7 11.1 L 13.1 9.2 L 12.9 1.4 L 13.3 -.1 L 14.1 -.8 L 15.3 -1.2 L 15.8 -1.2 L 14.6 -1.6 L 13.5 -2.0 L 13.0 -3.1 L 13.0 -6.0 L 13.3 -12.0 L 12.4 -13.7 L 11.1 -14.3 L 9.5 -14.3","0 16.0 M 10.4 -2.3 L 11.5 -3.6 L 12.8 -4.2 L 14.4 -4.2 L 15.9 -2.9 L 17.6 -1.6 L 18.6 -1.2 L 19.8 -1.4 L 20.7 -2.2 L 21.6 -3.1","0 10.8 M 13.7 -7.0 L 15.3 -7.5 L 16.4 -9.2 L 16.6 -11.0 L 15.6 -12.6 L 14.4 -13.4 L 12.6 -13.5 L 11.0 -12.3 L 10.3 -10.9 L 10.4 -9.1 L 11.2 -8.0 L 12.5 -7.1 L 13.7 -7.0"]
EMSReadabilityItalic = ["-8 8","0 8.9 M 16.7 -13.4 L 14.0 1.9 M 12.5 5.8 L 12.3 7.4 L 13.8 7.4 L 14.1 5.8 L 12.5 5.8","0 12.1 M 16.1 -14.0 L 15.1 -7.6 M 20.5 -14.0 L 19.6 -7.6","0 15.9 M 18.5 -12.6 L 12.5 7.5 M 24.3 -12.6 L 18.2 7.5 M 13.3 -6.2 L 25.3 -6.2 M 11.6 .2 L 23.5 .2","0 15.9 M 24.2 -10.4 L 22.8 -11.8 L 21.2 -12.2 L 20.2 -12.3 L 20.8 -15.7 L 20.2 -12.3 L 18.1 -11.9 L 16.2 -10.4 L 15.2 -8.7 L 15.0 -6.6 L 15.6 -5.1 L 16.9 -3.9 L 20.1 -2.1 L 21.3 -1.0 L 22.1 .1 L 22.4 1.9 L 22.2 3.4 L 21.4 5.3 L 19.4 6.7 L 17.2 7.4 L 16.7 7.4 L 16.1 10.7 L 16.7 7.4 L 15.1 7.2 L 13.3 6.4 L 11.9 5.2","0 26.3 M 16.2 -1.0 L 17.8 -1.3 L 19.1 -2.3 L 20.2 -3.9 L 21.0 -6.1 L 21.4 -7.7 L 21.3 -9.9 L 20.8 -11.6 L 20.0 -12.6 L 18.8 -13.1 L 17.5 -13.0 L 15.9 -12.1 L 14.7 -10.7 L 14.0 -9.0 L 13.3 -5.6 L 13.3 -3.8 L 13.8 -2.4 L 14.5 -1.5 L 15.3 -1.1 L 16.2 -1.0 M 28.6 7.6 L 30.2 7.3 L 31.5 6.2 L 32.6 4.7 L 33.4 2.5 L 33.8 .9 L 33.8 -1.4 L 33.3 -3.1 L 32.4 -4.1 L 31.2 -4.6 L 29.9 -4.4 L 28.3 -3.6 L 27.1 -2.2 L 26.5 -.5 L 25.7 2.9 L 25.7 4.8 L 26.2 6.1 L 27.0 7.0 L 27.7 7.5 L 28.6 7.6 M 16.0 7.7 L 31.1 -13.3","0 19.0 M 26.3 7.3 L 24.2 6.3 L 22.0 4.2 L 19.9 1.7 L 18.6 -.4 L 17.1 -3.7 L 16.5 -6.1 L 16.8 -9.2 L 17.4 -11.0 L 18.7 -12.4 L 20.4 -13.0 L 22.2 -12.7 L 23.2 -11.7 L 23.4 -10.1 L 22.8 -8.4 L 21.5 -6.7 L 20.0 -5.6 L 15.7 -2.7 L 14.1 -1.5 L 12.7 .1 L 11.8 1.8 L 11.7 3.7 L 12.4 5.8 L 14.2 7.0 L 16.6 7.5 L 18.6 7.0 L 20.9 5.7 L 22.9 3.8 L 24.6 1.9 L 26.2 -.6 L 27.4 -2.8","0 7.9 M 16.1 -14.0 L 15.1 -7.6","0 9.6 M 15.3 12.7 L 14.2 9.7 L 13.5 5.8 L 13.4 3.4 L 13.7 -.1 L 14.4 -3.4 L 15.4 -6.3 L 16.6 -9.1 L 18.2 -12.1 L 19.4 -13.8 L 20.2 -14.8","0 9.6 M 9.6 12.8 L 11.9 9.6 L 13.8 6.2 L 15.0 2.9 L 16.2 -1.2 L 16.4 -5.2 L 16.4 -7.8 L 16.1 -10.2 L 15.4 -12.6 L 14.6 -14.9","0 13.4 M 15.6 -7.5 L 18.4 -10.7 L 22.3 -11.9 L 18.4 -10.7 L 19.1 -14.5 L 18.4 -10.7 L 15.0 -11.9 L 18.4 -10.7 L 20.3 -7.4","0 15.9 M 19.5 -9.6 L 17.1 4.1 M 12.2 -2.8 L 24.7 -2.8","0 7.9 M 13.1 7.2 L 11.9 7.2 L 12.2 5.6 L 13.4 5.6 L 13.6 7.4 L 13.2 8.9 L 12.4 10.2 L 11.4 11.0 L 10.4 11.8","0 10.4 M 11.8 -.3 L 18.3 -.3","0 7.9 M 12.0 5.7 L 11.8 7.3 L 13.3 7.3 L 13.6 5.7 L 12.0 5.7","0 12.1 M 9.1 12.5 L 23.4 -14.5","0 15.9 M 16.4 7.4 L 18.4 7.0 L 20.7 5.0 L 22.0 2.9 L 22.9 .5 L 23.6 -2.8 L 24.0 -5.9 L 23.8 -8.9 L 23.1 -10.8 L 21.8 -12.0 L 20.4 -12.5 L 19.2 -12.4 L 17.2 -11.3 L 15.5 -9.5 L 14.0 -6.6 L 13.2 -3.6 L 12.7 -.6 L 12.5 2.2 L 13.0 5.0 L 13.9 6.3 L 15.0 7.3 L 16.4 7.4","0 16.0 M 20.3 -11.0 L 17.0 -10.9 L 20.6 -12.2 L 17.2 7.0 L 12.2 7.0 L 22.1 7.0","0 16.0 M 14.0 -9.7 L 15.6 -11.0 L 17.4 -12.0 L 19.4 -12.5 L 21.1 -12.2 L 22.8 -11.3 L 23.5 -9.8 L 23.6 -7.6 L 23.3 -5.7 L 21.8 -3.4 L 19.5 -.8 L 16.9 1.9 L 14.5 4.0 L 12.3 6.0 L 11.3 7.0 L 22.6 7.0","0 15.8 M 14.5 -10.3 L 16.4 -11.5 L 18.6 -12.4 L 20.3 -12.4 L 22.0 -11.9 L 23.3 -10.7 L 23.8 -9.1 L 23.7 -7.2 L 22.9 -5.5 L 21.0 -4.2 L 18.9 -3.2 L 17.3 -2.9 L 16.0 -2.9 L 17.5 -2.9 L 19.0 -2.7 L 20.6 -2.1 L 22.0 -.8 L 22.6 .4 L 22.7 1.8 L 22.3 3.3 L 21.8 4.5 L 20.6 5.9 L 19.0 6.8 L 17.1 7.3 L 15.3 7.3 L 13.5 6.8 L 11.9 5.8 L 10.9 4.8","0 16.0 M 19.4 7.5 L 22.9 -12.0 L 11.2 1.0 L 23.8 1.0","0 15.9 M 11.0 4.9 L 12.0 6.0 L 13.3 6.8 L 14.8 7.4 L 16.3 7.5 L 18.6 6.9 L 20.5 5.6 L 22.1 3.7 L 23.0 1.5 L 23.2 -1.1 L 22.4 -3.1 L 20.4 -4.4 L 18.1 -4.6 L 16.3 -4.2 L 14.5 -3.3 L 14.3 -3.6 L 16.5 -12.0 L 24.7 -12.0","0 15.8 M 12.7 -.4 L 14.5 -2.0 L 16.5 -3.4 L 18.4 -4.0 L 20.4 -4.0 L 21.8 -3.3 L 22.8 -2.3 L 23.2 -.4 L 23.0 1.8 L 22.2 4.1 L 20.7 6.0 L 18.9 7.2 L 16.8 7.5 L 15.1 6.9 L 13.7 5.7 L 12.7 3.7 L 12.6 .9 L 13.0 -2.1 L 14.0 -5.9 L 15.1 -8.2 L 16.4 -10.0 L 18.2 -11.5 L 20.2 -12.3 L 22.1 -12.4 L 23.8 -11.8 L 24.9 -10.7","0 16.0 M 15.7 7.4 L 17.1 2.1 L 18.5 -1.7 L 20.3 -5.0 L 22.0 -7.6 L 23.9 -10.0 L 25.8 -12.1 L 14.3 -12.1","0 15.9 M 19.8 -2.2 L 22.0 -3.8 L 23.5 -5.6 L 24.1 -7.3 L 24.4 -9.1 L 23.4 -11.2 L 21.6 -12.3 L 20.0 -12.4 L 17.5 -11.7 L 15.7 -10.1 L 14.9 -8.3 L 15.0 -5.8 L 16.3 -4.3 L 18.8 -2.8 L 21.1 -1.4 L 22.6 -.1 L 23.1 1.7 L 22.5 3.9 L 21.6 5.5 L 19.4 7.0 L 17.0 7.5 L 15.1 7.2 L 13.2 6.3 L 12.1 4.7 L 11.9 3.0 L 12.5 .5 L 14.5 -1.7 L 16.0 -2.6 L 17.8 -3.4","0 15.9 M 11.7 5.6 L 12.7 6.7 L 14.3 7.3 L 16.2 7.5 L 18.4 6.5 L 20.6 4.6 L 22.2 1.7 L 23.3 -1.8 L 23.9 -5.1 L 23.8 -8.2 L 23.0 -10.6 L 21.4 -12.0 L 19.2 -12.4 L 16.8 -11.6 L 15.2 -10.2 L 14.0 -8.4 L 13.4 -6.6 L 13.2 -4.6 L 13.9 -2.5 L 15.7 -1.2 L 18.0 -.9 L 20.9 -2.0 L 22.7 -3.5 L 23.9 -4.8","0 7.9 M 14.1 -6.4 L 13.9 -4.9 L 15.4 -4.9 L 15.7 -6.4 L 14.1 -6.4 M 12.0 5.7 L 11.7 7.2 L 13.3 7.2 L 13.5 5.7 L 12.0 5.7","0 7.8 M 14.2 -6.4 L 13.9 -4.8 L 15.5 -4.8 L 15.8 -6.4 L 14.2 -6.4 M 13.1 7.2 L 11.9 7.2 L 12.2 5.6 L 13.4 5.6 L 13.6 7.4 L 13.2 8.9 L 12.5 10.2 L 11.4 11.0 L 10.4 11.8","0 16.0 M 23.8 2.2 L 12.1 -2.9 L 25.6 -8.0","0 16.0 M 12.5 -6.0 L 25.3 -6.0 M 11.4 .4 L 24.1 .4","0 15.8 M 11.3 2.2 L 24.8 -3.0 L 13.1 -8.0","0 13.6 M 14.3 5.7 L 14.0 7.3 L 15.6 7.3 L 15.9 5.7 L 14.3 5.7 M 15.6 1.6 L 16.1 -.3 L 17.3 -2.3 L 20.1 -5.3 L 21.7 -7.4 L 22.4 -9.2 L 22.3 -11.0 L 21.5 -12.4 L 20.4 -13.2 L 18.7 -13.4 L 17.1 -13.1 L 15.6 -12.4 L 14.1 -11.3","0 26.4 M 28.2 -5.1 L 25.5 2.5 L 23.5 4.1 L 21.9 4.9 L 19.9 5.0 L 18.4 3.7 L 18.3 1.6 L 19.4 -1.6 L 21.6 -4.1 L 24.2 -5.3 L 26.1 -4.9 L 26.9 -4.0 L 27.3 -2.8 L 25.4 2.7 L 25.4 3.9 L 26.9 5.2 L 29.3 5.0 L 31.4 3.4 L 33.1 1.3 L 34.0 -1.3 L 34.4 -4.0 L 34.0 -6.9 L 33.0 -9.0 L 31.5 -10.6 L 28.7 -11.6 L 25.8 -11.8 L 22.9 -11.3 L 19.5 -9.7 L 17.0 -7.6 L 15.0 -5.3 L 13.3 -2.3 L 12.5 .3 L 12.1 2.5 L 12.3 5.5 L 13.0 7.9 L 15.1 10.1 L 17.1 11.1 L 20.1 11.7 L 23.1 11.6 L 26.0 10.2","0 17.4 M 9.9 7.5 L 21.0 -13.0 L 23.1 -.1 L 14.1 -.1 L 23.1 -.1 L 24.4 7.5","0 19.1 M 12.7 7.1 L 16.2 -12.5 L 22.0 -12.5 L 23.7 -12.4 L 25.3 -11.7 L 26.5 -10.4 L 26.6 -8.9 L 26.2 -7.1 L 25.3 -5.5 L 23.6 -4.4 L 22.2 -3.8 L 20.4 -3.5 L 14.8 -3.5 L 20.5 -3.5 L 22.1 -3.2 L 24.0 -2.7 L 25.4 -1.6 L 26.1 -.6 L 26.2 .8 L 25.8 2.8 L 24.7 4.7 L 23.0 5.9 L 20.4 6.9 L 18.5 7.1 L 13.0 7.1","0 18.7 M 25.5 4.9 L 23.1 6.5 L 20.2 7.5 L 17.4 7.1 L 15.1 5.7 L 13.5 3.3 L 12.9 .8 L 13.3 -3.0 L 14.2 -6.5 L 16.0 -9.4 L 18.4 -11.6 L 20.9 -12.7 L 23.6 -12.9 L 25.9 -12.4 L 27.2 -11.4 L 27.6 -10.8","0 19.9 M 12.9 7.0 L 16.4 -12.5 L 22.0 -12.5 L 24.2 -11.9 L 25.6 -11.0 L 26.7 -9.8 L 27.6 -7.5 L 27.7 -4.9 L 27.4 -3.3 L 27.0 -1.2 L 26.2 1.2 L 25.1 2.9 L 23.4 5.0 L 20.8 6.3 L 18.7 6.9 L 17.1 7.0 L 12.9 7.0","0 17.1 M 23.5 7.0 L 12.9 7.0 L 14.7 -3.3 L 23.5 -3.3 L 14.7 -3.3 L 16.3 -12.4 L 26.6 -12.4","0 15.9 M 12.8 7.4 L 14.6 -3.0 L 23.5 -3.0 L 14.6 -3.0 L 16.3 -12.4 L 26.5 -12.4","0 19.8 M 21.3 -2.0 L 26.8 -2.0 L 25.5 5.4 L 24.0 6.3 L 21.1 7.3 L 19.0 7.4 L 17.1 7.0 L 15.4 6.0 L 13.7 3.6 L 12.9 .6 L 13.2 -2.9 L 14.2 -6.3 L 16.1 -9.3 L 18.5 -11.6 L 20.9 -12.6 L 23.4 -13.0 L 25.9 -12.6 L 27.3 -11.7 L 28.2 -10.8","0 21.2 M 12.8 7.3 L 16.4 -12.7 L 14.7 -3.4 L 27.4 -3.4 L 29.1 -12.6 L 25.5 7.3","0 8.5 M 12.8 7.4 L 16.3 -12.7","0 15.5 M 11.6 4.8 L 12.3 6.0 L 13.4 6.9 L 14.9 7.5 L 17.0 7.2 L 19.1 5.9 L 20.3 4.0 L 20.8 2.5 L 23.5 -12.8","0 18.5 M 12.8 7.4 L 16.4 -12.8 M 27.7 -12.6 L 14.4 -.1 M 20.2 -5.5 L 25.4 7.4","0 15.6 M 16.4 -12.8 L 12.9 7.0 L 22.9 7.0","0 23.2 M 12.7 7.5 L 16.3 -12.8 L 17.3 -12.8 L 20.6 4.9 L 30.3 -12.7 L 30.9 -12.7 L 27.4 7.4","0 20.8 M 12.6 7.3 L 16.2 -12.6 L 16.9 -12.6 L 25.2 7.3 L 28.8 -12.7","0 21.5 M 19.2 7.3 L 21.9 6.9 L 24.8 5.2 L 27.1 2.5 L 28.6 -1.0 L 29.2 -4.3 L 29.2 -7.0 L 28.6 -9.2 L 27.3 -11.3 L 25.3 -12.6 L 23.3 -13.0 L 21.3 -12.7 L 19.0 -11.9 L 16.7 -10.2 L 14.7 -7.3 L 13.8 -5.0 L 13.1 -1.6 L 13.0 1.0 L 13.6 3.4 L 14.7 5.3 L 16.1 6.6 L 17.7 7.2 L 19.2 7.3","0 18.4 M 12.8 7.5 L 16.4 -12.6 L 23.6 -12.6 L 25.3 -12.1 L 26.4 -11.1 L 27.2 -9.8 L 27.2 -7.8 L 26.8 -6.0 L 25.6 -4.0 L 23.9 -2.8 L 21.7 -2.0 L 19.3 -1.9 L 14.5 -1.9","0 21.4 M 19.1 7.5 L 21.4 7.0 L 23.9 5.8 L 26.1 3.8 L 27.7 1.0 L 28.6 -1.4 L 29.0 -4.2 L 29.2 -7.1 L 28.7 -9.1 L 27.3 -11.3 L 25.2 -12.6 L 23.2 -13.1 L 21.0 -12.7 L 18.7 -11.8 L 16.6 -10.0 L 15.2 -8.1 L 13.9 -5.1 L 13.2 -2.8 L 13.0 -.6 L 13.2 2.0 L 14.0 4.2 L 15.1 5.7 L 16.6 6.8 L 18.2 7.3 L 19.1 7.4 L 19.6 9.2 L 20.7 10.5 L 22.0 11.3 L 23.7 11.8 L 25.3 11.9 L 26.8 11.6","0 18.4 M 12.7 7.4 L 16.3 -12.6 L 22.9 -12.6 L 24.5 -12.1 L 26.1 -11.2 L 27.0 -9.2 L 26.7 -7.5 L 26.1 -5.6 L 24.6 -3.9 L 22.9 -3.0 L 20.5 -2.4 L 14.6 -2.4 L 20.2 -2.4 L 24.3 7.4","0 17.3 M 11.6 4.6 L 13.1 6.0 L 14.5 6.8 L 16.4 7.2 L 18.7 7.3 L 21.4 6.3 L 23.3 4.8 L 24.3 2.8 L 24.5 1.0 L 23.8 -.8 L 21.7 -2.3 L 18.0 -4.1 L 15.9 -5.6 L 14.9 -7.2 L 15.3 -9.2 L 16.5 -11.3 L 18.9 -12.7 L 21.2 -13.0 L 23.3 -12.8 L 24.7 -12.0 L 26.0 -10.9","0 17.4 M 17.3 7.3 L 20.8 -12.6 L 13.9 -12.6 L 27.9 -12.6","0 21.0 M 16.5 -12.8 L 14.0 1.1 L 14.0 2.9 L 14.6 4.8 L 15.5 6.1 L 17.1 7.1 L 18.8 7.5 L 20.9 7.2 L 23.2 6.1 L 25.0 4.3 L 26.1 2.7 L 26.7 .5 L 29.0 -12.7","0 16.3 M 13.6 -12.8 L 16.6 7.4 L 27.0 -12.7","0 25.1 M 14.3 -12.8 L 15.4 7.4 L 15.8 7.3 L 24.6 -12.7 L 25.0 -12.7 L 26.7 7.4 L 27.1 7.4 L 35.2 -12.8","0 16.1 M 10.4 7.4 L 26.0 -12.8 M 14.6 -12.9 L 22.8 7.4","0 15.0 M 13.6 -12.8 L 17.5 -.7 L 16.1 7.3 L 17.5 -.8 L 25.6 -12.7","0 17.8 M 15.4 -12.6 L 27.3 -12.6 L 11.1 7.1 L 24.3 7.1","0 9.7 M 16.1 11.9 L 11.9 11.9 L 16.5 -14.2 L 20.8 -14.2","0 12.2 M 13.8 -14.4 L 18.5 12.5","0 9.7 M 9.2 11.8 L 13.4 11.8 L 18.1 -14.3 L 13.8 -14.3","0 16.0 M 13.5 -1.9 L 20.1 -13.4 L 22.9 -1.6","0 16.8 M 8.9 10.6 L 23.9 10.6","0 17.7 M 19.5 -14.5 L 21.7 -10.6","0 16.5 M 14.6 -5.6 L 16.9 -6.8 L 18.8 -7.3 L 20.7 -7.5 L 22.0 -7.0 L 23.0 -5.9 L 23.4 -4.3 L 23.1 -2.1 L 21.9 4.6 L 21.5 7.3 L 21.9 4.6 L 20.4 5.5 L 18.8 6.5 L 17.1 7.2 L 15.3 7.5 L 13.8 7.0 L 12.8 6.2 L 12.1 4.9 L 12.4 3.0 L 13.5 1.5 L 15.3 .2 L 17.0 -.4 L 19.0 -1.0 L 20.8 -1.3 L 22.0 -1.4 L 22.9 -1.4","0 17.9 M 16.5 -14.8 L 12.5 7.5 L 13.0 4.8 L 13.8 5.7 L 15.4 6.8 L 17.1 7.3 L 18.9 7.4 L 21.2 6.2 L 22.8 4.8 L 24.1 2.8 L 25.0 .3 L 25.3 -2.2 L 25.2 -4.5 L 24.1 -6.4 L 22.9 -7.1 L 21.1 -7.5 L 19.1 -7.1 L 17.1 -6.1 L 14.8 -4.5","0 15.0 M 22.0 5.7 L 20.1 6.9 L 17.7 7.4 L 15.6 7.1 L 13.6 5.6 L 12.6 3.5 L 12.5 1.0 L 13.0 -1.6 L 14.2 -4.0 L 16.1 -5.9 L 18.2 -7.0 L 20.4 -7.3 L 22.1 -7.0 L 23.3 -6.4 L 23.6 -5.8","0 18.0 M 26.5 -14.7 L 22.5 7.3 L 23.1 4.3 L 21.4 5.7 L 19.3 7.0 L 17.3 7.5 L 15.7 7.2 L 14.3 6.5 L 12.9 4.8 L 12.4 2.5 L 12.7 -.3 L 14.0 -3.6 L 16.0 -6.1 L 18.7 -7.3 L 20.7 -7.5 L 22.5 -6.8 L 23.7 -6.0 L 24.7 -4.8","0 16.0 M 12.8 -.4 L 23.8 -.4 L 24.1 -2.2 L 24.0 -4.5 L 22.9 -6.3 L 21.5 -7.3 L 19.4 -7.4 L 17.2 -6.8 L 15.2 -5.3 L 14.1 -3.8 L 13.0 -1.9 L 12.5 .1 L 12.5 2.5 L 13.0 4.7 L 14.5 6.5 L 16.1 7.3 L 18.2 7.5 L 20.0 7.0 L 22.0 6.1","0 9.2 M 12.9 7.4 L 15.4 -7.0 L 13.1 -7.0 L 19.2 -7.0 L 15.4 -7.0 L 16.2 -11.4 L 16.7 -12.9 L 17.9 -14.4 L 19.6 -15.0 L 20.9 -14.8 L 21.7 -14.4","0 16.2 M 14.1 6.7 L 12.3 8.1 L 11.1 9.8 L 10.6 11.6 L 11.6 13.1 L 13.8 14.1 L 16.4 14.4 L 19.0 13.8 L 21.6 12.2 L 22.8 10.7 L 23.0 9.0 L 22.4 7.4 L 20.3 6.8 L 14.2 6.8 L 13.1 5.9 L 12.7 4.5 L 13.2 3.2 L 15.3 1.3 L 16.3 2.0 L 17.9 2.3 L 20.1 1.6 L 21.8 .2 L 22.9 -1.5 L 23.2 -3.5 L 22.8 -5.3 L 22.3 -6.1 L 21.1 -7.0 L 25.9 -7.0 L 21.0 -7.0 L 19.6 -7.3 L 17.3 -7.1 L 15.5 -5.8 L 14.2 -4.0 L 13.7 -2.0 L 13.9 -.4 L 14.5 .6 L 15.2 1.4","0 17.6 M 12.6 7.3 L 16.6 -14.7 L 14.6 -3.6 L 16.3 -5.2 L 17.8 -6.4 L 19.9 -7.2 L 21.8 -7.4 L 23.8 -6.2 L 24.4 -4.8 L 24.3 -2.5 L 22.6 7.4","0 8.0 M 12.6 7.5 L 15.2 -7.2 M 15.4 -13.3 L 15.1 -11.7 L 16.7 -11.7 L 17.0 -13.3 L 15.4 -13.3","0 8.3 M 7.2 13.9 L 7.4 13.9 L 8.3 14.2 L 9.8 14.1 L 11.3 13.2 L 12.0 11.6 L 15.4 -7.3 M 15.6 -13.2 L 15.3 -11.7 L 16.9 -11.7 L 17.2 -13.2 L 15.6 -13.2","0 15.4 M 12.5 7.5 L 16.5 -14.8 M 23.9 -7.2 L 13.4 3.3 M 18.3 -1.7 L 22.4 7.5","0 8.4 M 16.6 -14.7 L 13.0 6.0 L 13.0 6.7 L 13.2 7.1 L 13.7 7.4 L 14.3 7.4","0 26.5 M 12.5 7.5 L 15.1 -7.2 L 14.5 -3.9 L 16.1 -5.1 L 17.6 -6.2 L 19.0 -7.0 L 20.5 -7.4 L 21.8 -7.2 L 22.6 -6.8 L 23.5 -5.8 L 23.8 -4.1 L 23.6 -2.0 L 21.9 7.5 L 23.9 -3.6 L 24.5 -4.4 L 26.9 -6.3 L 28.7 -7.1 L 30.0 -7.5 L 31.3 -7.1 L 32.2 -6.6 L 33.0 -5.3 L 33.0 -2.7 L 31.2 7.4","0 17.7 M 12.6 7.5 L 15.2 -7.3 L 14.6 -3.7 L 16.2 -5.1 L 17.7 -6.3 L 18.8 -6.9 L 20.4 -7.3 L 21.4 -7.4 L 22.9 -7.0 L 23.6 -6.4 L 24.2 -5.4 L 24.5 -4.0 L 22.4 7.5","0 17.8 M 17.7 7.4 L 17.8 7.4 L 19.9 6.9 L 22.0 5.6 L 23.5 3.6 L 24.5 1.4 L 24.9 -.7 L 24.9 -2.6 L 24.6 -4.3 L 23.9 -5.6 L 22.6 -6.8 L 21.2 -7.3 L 19.9 -7.4 L 18.2 -7.1 L 16.5 -6.2 L 15.0 -4.7 L 14.0 -3.3 L 13.0 -1.2 L 12.8 .4 L 12.6 2.3 L 12.8 4.0 L 13.7 5.6 L 14.9 6.7 L 16.3 7.3 L 17.7 7.4","0 18.0 M 11.3 14.2 L 15.1 -7.3 L 14.6 -4.1 L 16.5 -5.8 L 18.7 -6.9 L 20.5 -7.2 L 22.6 -7.2 L 24.1 -6.3 L 25.1 -4.3 L 25.4 -2.0 L 25.0 .6 L 24.2 2.8 L 22.7 5.1 L 20.8 6.6 L 19.5 7.2 L 17.6 7.3 L 16.1 7.0 L 14.6 6.1 L 13.2 5.0","0 17.7 M 21.3 14.1 L 25.1 -7.2 L 24.7 -5.0 L 23.1 -6.3 L 21.4 -7.1 L 19.0 -7.3 L 16.6 -6.4 L 14.8 -4.6 L 13.5 -2.4 L 12.8 -.6 L 12.5 1.2 L 12.4 3.1 L 12.8 5.0 L 13.8 6.3 L 15.1 7.1 L 17.0 7.5 L 19.2 6.9 L 21.3 5.7 L 22.9 4.5","0 10.8 M 12.7 7.4 L 15.3 -7.3 L 14.5 -2.8 L 15.7 -4.6 L 17.4 -6.4 L 19.0 -7.1 L 20.5 -7.3 L 21.4 -7.2","0 13.6 M 11.1 5.5 L 12.7 6.7 L 14.5 7.3 L 16.1 7.5 L 18.2 6.8 L 20.0 5.6 L 20.7 3.8 L 20.6 2.0 L 19.1 .5 L 16.8 -.5 L 14.7 -1.5 L 13.6 -2.8 L 13.6 -4.3 L 14.4 -5.7 L 16.2 -7.1 L 18.3 -7.4 L 20.2 -7.0 L 21.7 -6.0","0 10.6 M 18.2 6.8 L 17.0 7.3 L 15.6 7.3 L 14.3 6.9 L 13.5 5.6 L 13.7 3.4 L 15.6 -6.9 L 12.6 -6.9 L 20.3 -6.9 L 15.6 -6.9 L 16.4 -11.4","0 17.6 M 24.7 -7.1 L 22.1 7.4 L 22.8 3.6 L 21.4 4.9 L 19.9 6.2 L 17.9 7.2 L 16.2 7.5 L 14.5 7.0 L 13.4 6.0 L 13.0 4.7 L 13.3 2.2 L 14.9 -7.1","0 14.6 M 12.9 -7.4 L 15.8 7.5 L 16.2 7.5 L 24.4 -7.4","0 22.3 M 13.2 -7.3 L 14.8 7.7 L 15.2 7.7 L 22.1 -7.3 L 22.7 -7.3 L 24.3 7.7 L 24.7 7.7 L 31.6 -7.3","0 13.8 M 10.1 7.7 L 22.9 -7.4 M 13.4 -7.4 L 20.9 7.7","0 14.6 M 12.9 -7.2 L 16.2 7.9 M 24.1 -7.1 L 14.8 10.5 L 13.8 12.0 L 12.5 13.1 L 11.2 13.8 L 9.1 13.8","0 13.5 M 13.6 -6.8 L 22.5 -6.8 L 10.6 7.0 L 20.8 7.0","0 9.8 M 16.2 11.9 L 14.6 12.0 L 13.3 11.2 L 12.7 9.6 L 14.7 1.2 L 14.5 .1 L 13.8 -.7 L 13.1 -1.0 L 11.9 -1.1 L 13.6 -1.5 L 14.9 -2.2 L 15.4 -3.5 L 16.8 -11.9 L 17.3 -13.3 L 18.9 -14.2 L 20.8 -14.2","0 8.1 M 11.1 15.0 L 16.5 -15.5","0 9.8 M 9.2 11.9 L 11.1 11.8 L 12.6 11.1 L 13.4 9.2 L 14.6 1.4 L 15.3 -.1 L 16.1 -.8 L 17.5 -1.2 L 17.9 -1.2 L 16.8 -1.6 L 15.8 -2.0 L 15.5 -3.1 L 16.0 -6.0 L 17.3 -12.0 L 16.8 -13.7 L 15.6 -14.3 L 14.0 -14.3","0 16.0 M 12.7 -2.3 L 14.1 -3.6 L 15.5 -4.2 L 17.1 -4.2 L 18.4 -2.9 L 19.8 -1.6 L 20.7 -1.2 L 22.0 -1.4 L 23.0 -2.2 L 24.0 -3.1","0 10.8 M 16.8 -7.0 L 18.5 -7.5 L 20.0 -9.2 L 20.4 -11.0 L 19.7 -12.6 L 18.7 -13.4 L 16.9 -13.5 L 15.1 -12.3 L 14.2 -10.9 L 13.9 -9.1 L 14.5 -8.0 L 15.6 -7.1 L 16.8 -7.0"]
EMSSociety = ["-8 8","0 21.8 M 33.5 -19.6 L 18.8 3.6 M 17.1 6.7 L 16.3 8.0","0 19.2 M 24.0 -16.9 L 20.4 -11.9 M 26.9 -16.8 L 23.1 -11.7","0 29.0 M 25.3 -4.2 L 20.7 9.0 M 29.3 -4.0 L 24.7 8.9 M 19.1 .8 L 32.9 .6 M 17.4 4.3 L 31.7 4.1","0 37.1 M 40.2 -27.1 L 36.9 -21.7 L 32.9 -14.2 L 28.6 -5.0 L 24.7 3.6 L 21.3 12.4 M 33.5 -18.8 L 35.8 -18.2 L 38.5 -18.8 L 41.4 -19.8 L 42.5 -21.2 L 42.2 -22.4 L 40.9 -23.3 L 39.8 -23.8 L 37.2 -24.4 L 33.1 -24.1 L 28.9 -22.8 L 26.7 -20.6 L 26.2 -18.8 L 27.0 -16.3 L 28.4 -14.6 L 30.1 -12.7 L 33.9 -9.9 L 37.1 -6.6 L 39.0 -3.4 L 38.9 .3 L 37.3 3.3 L 34.0 6.5 L 30.5 8.1 L 26.4 8.9 L 24.2 8.7 L 20.3 8.1 L 18.2 6.9 L 16.8 5.1 L 16.2 2.0 L 17.8 -1.3 L 21.0 -3.2 L 24.6 -3.8 L 26.8 -3.4 L 29.6 -2.3 L 30.4 -1.0 L 30.7 .9","0 46.9 M 27.3 -19.0 L 30.0 -21.0 L 31.6 -22.8 L 31.2 -24.6 L 28.4 -25.0 L 25.2 -23.3 L 20.9 -19.4 L 18.4 -15.1 L 16.8 -11.2 L 16.5 -8.5 L 16.8 -6.3 L 18.0 -4.8 L 20.5 -4.3 L 25.4 -6.3 L 30.0 -11.4 L 32.3 -15.8 L 33.1 -18.9 L 33.1 -20.4 L 32.9 -20.9 L 32.4 -21.5 L 30.6 -22.0 L 28.2 -20.4 L 27.3 -19.8 L 27.0 -18.2 M 44.1 -6.9 L 46.8 -8.8 L 48.4 -10.6 L 48.0 -12.4 L 45.2 -12.8 L 42.0 -11.2 L 37.7 -7.2 L 35.2 -2.9 L 33.6 .9 L 33.3 3.7 L 33.6 5.9 L 34.8 7.3 L 37.3 7.9 L 42.2 5.9 L 46.8 .8 L 49.1 -3.7 L 49.9 -6.7 L 49.9 -8.2 L 49.7 -8.8 L 49.2 -9.3 L 47.4 -9.9 L 45.0 -8.2 L 44.1 -7.7 L 43.8 -6.0 M 45.4 -27.8 L 37.2 -16.0 L 32.1 -7.9 L 28.3 -1.8 L 25.2 4.5 L 22.6 10.7","0 35.0 M 25.3 -3.5 L 25.5 1.1 L 26.2 -1.3 L 27.8 -3.0 L 29.8 -4.5 L 32.2 -5.9 L 35.0 -6.7 L 37.4 -6.6 L 39.0 -5.5 L 39.2 -3.5 L 38.0 -.7 L 35.1 2.7 L 32.4 5.0 L 28.7 7.1 L 24.7 8.3 L 20.7 8.6 L 17.8 7.7 L 15.9 5.5 L 15.7 2.0 L 16.6 -1.4 L 19.0 -4.9 L 21.8 -7.9 L 26.4 -12.0 L 30.8 -15.3 L 33.5 -17.4 L 36.0 -19.9 L 37.1 -21.3 L 37.3 -22.5 L 36.8 -23.0 L 35.6 -23.2 L 33.9 -22.3 L 31.2 -19.5 L 30.1 -17.4 L 28.8 -12.7 L 28.7 -9.1 L 28.6 -5.7 L 29.1 -1.7 L 30.6 2.8 L 33.0 7.2 L 35.3 9.2 L 38.1 10.2 L 40.1 10.1 L 41.3 9.9 L 42.3 9.5 L 43.3 9.0 L 44.5 8.2","0 16.3 M 24.3 -16.8 L 20.7 -11.9","0 21.0 M 36.6 -25.2 L 28.7 -19.8 L 23.2 -13.9 L 20.5 -9.1 L 18.5 -3.7 L 17.4 1.7 L 17.3 6.2 L 18.1 10.1 L 20.7 14.5","0 21.1 M 26.5 -24.9 L 29.2 -19.8 L 29.7 -15.0 L 28.9 -7.7 L 26.7 -1.3 L 22.8 5.1 L 18.5 9.5 L 15.0 12.2 L 10.7 14.5","0 29.3 M 21.8 -5.1 L 25.2 .0 M 19.7 -2.8 L 26.9 -2.8 M 20.2 -.5 L 26.7 -5.1 M 22.3 .6 L 24.5 -6.0","0 22.8 M 22.5 -11.1 L 18.5 .4 M 14.7 -5.4 L 27.0 -5.4","0 16.2 M 16.6 8.1 L 16.3 7.0 L 17.3 6.8 L 17.3 7.8 L 16.1 8.9 L 14.4 10.2 L 12.8 10.7 L 12.4 10.8","0 30.6 M 18.9 3.4 L 19.1 3.4 L 31.2 3.6","0 17.5 M 17.9 7.0 L 16.8 8.5","0 24.6 M 35.8 -28.7 L 30.5 -19.6 L 26.7 -11.7 L 21.4 -.8 L 18.5 7.0 L 16.9 11.0","0 34.1 M 30.7 -13.4 L 31.1 -15.2 L 32.8 -16.7 L 36.1 -18.8 L 37.4 -20.6 L 37.5 -22.5 L 36.4 -23.9 L 33.2 -24.1 L 29.1 -22.5 L 23.6 -18.2 L 18.8 -12.1 L 15.5 -5.9 L 14.3 -.8 L 13.9 3.5 L 15.0 6.5 L 18.2 8.6 L 23.1 7.8 L 27.0 5.9 L 31.9 1.2 L 35.5 -3.7 L 38.1 -9.6 L 39.2 -13.8 L 39.1 -16.9 L 38.4 -18.8 L 36.2 -19.8 L 34.2 -20.1 L 31.9 -19.8 L 30.1 -19.3 L 28.6 -18.5","0 20.4 M 19.8 -17.9 L 18.7 -16.5 L 18.3 -17.0 L 21.4 -18.6 L 23.8 -19.8 L 29.3 -20.9 L 32.9 -22.2 L 34.5 -23.2 L 34.7 -23.9 L 34.1 -24.4 L 32.1 -24.3 L 29.0 -22.4 L 27.4 -21.2 L 23.9 -16.8 L 20.1 -11.1 L 17.2 -5.4 L 14.1 1.6 L 12.9 5.4 L 12.5 7.7 L 12.6 9.0","0 30.6 M 28.5 -18.4 L 27.6 -15.7 L 25.8 -13.1 L 23.0 -11.2 L 18.8 -10.9 L 16.9 -12.1 L 16.6 -14.2 L 17.9 -17.1 L 20.6 -20.1 L 24.2 -22.1 L 27.9 -23.2 L 31.2 -23.5 L 33.9 -22.6 L 35.0 -20.2 L 34.8 -17.4 L 33.0 -13.1 L 29.5 -7.2 L 25.8 -2.5 L 21.8 1.9 L 18.6 5.4 L 15.2 7.9 L 12.2 8.9 L 11.1 7.8 L 11.3 5.7 L 13.7 3.0 L 17.0 1.6 L 18.6 1.4 L 21.0 2.2 L 25.3 5.2 L 28.0 7.0 L 30.8 7.7 L 33.7 7.0 L 36.0 5.9","0 29.4 M 28.3 -19.3 L 26.6 -16.1 L 24.2 -14.2 L 20.7 -13.4 L 19.0 -14.7 L 18.8 -17.4 L 20.8 -20.5 L 23.3 -22.6 L 26.3 -23.9 L 29.5 -24.7 L 32.3 -24.8 L 35.3 -23.7 L 36.3 -22.1 L 36.2 -20.0 L 35.1 -18.1 L 32.6 -15.4 L 29.0 -12.8 L 25.2 -10.7 L 20.4 -8.0 L 22.4 -8.8 L 24.0 -9.3 L 28.4 -9.0 L 30.1 -7.5 L 30.9 -5.7 L 30.7 -3.5 L 29.3 -.5 L 27.3 2.1 L 23.7 5.5 L 20.4 7.3 L 17.5 8.3 L 12.9 8.4 L 10.5 7.3 L 10.4 6.1 L 11.6 5.3 L 13.8 5.1 L 17.5 6.1 L 21.0 8.5 L 22.6 9.5 L 24.4 9.6","0 32.8 M 33.1 -17.9 L 29.2 -9.8 L 25.7 -2.1 L 24.1 2.7 L 22.9 6.5 L 22.6 8.9 M 36.0 -19.4 L 38.3 -21.2 L 39.1 -22.8 L 38.9 -24.4 L 36.7 -25.1 L 33.2 -24.6 L 28.2 -22.2 L 23.5 -18.1 L 19.7 -14.2 L 16.6 -9.4 L 14.6 -5.8 L 13.9 -2.5 L 14.6 .5 L 16.6 1.2 L 19.1 1.4 L 22.1 1.0 L 29.6 -.6 L 31.7 -.8 L 33.9 -.5 L 35.2 -.1 L 36.4 .3","0 30.5 M 32.0 -17.4 L 31.0 -18.4 L 30.9 -20.2 L 31.6 -21.8 L 32.7 -23.2 L 35.5 -24.8 L 37.9 -24.9 L 38.8 -24.3 L 38.5 -23.4 L 37.0 -22.2 L 35.7 -21.5 L 34.0 -21.2 L 31.7 -21.3 L 29.6 -21.3 L 26.7 -21.7 L 22.6 -22.7 L 21.3 -19.0 L 19.7 -14.4 L 18.3 -11.8 L 16.2 -8.2 L 19.5 -9.6 L 23.4 -10.2 L 27.5 -10.2 L 29.8 -8.6 L 30.5 -5.7 L 29.2 -2.7 L 26.5 1.7 L 23.6 4.8 L 20.0 7.2 L 16.0 8.9 L 11.7 8.8 L 9.7 8.0 L 9.0 7.0 L 9.3 5.8 L 10.9 5.5 L 29.4 5.7","0 33.3 M 40.6 -22.3 L 37.3 -23.9 L 33.9 -24.3 L 29.0 -22.2 L 23.6 -18.5 L 17.7 -9.9 L 15.3 -4.3 L 14.2 .7 L 14.5 4.2 L 16.1 6.9 L 18.4 8.1 L 22.0 8.4 L 25.2 7.2 L 27.4 5.8 L 30.0 3.3 L 32.9 -.6 L 34.6 -5.4 L 34.6 -8.0 L 33.3 -10.1 L 32.0 -10.7 L 28.6 -10.7 L 25.7 -9.6 L 23.1 -7.0 L 22.0 -4.8 L 22.0 -1.3 L 22.9 .6 L 24.2 2.4 L 27.3 3.7 L 31.5 4.2 L 34.4 3.4 L 36.3 1.4","0 31.6 M 25.3 -19.0 L 24.5 -17.0 L 22.6 -15.7 L 20.4 -15.5 L 18.6 -15.8 L 16.9 -17.5 L 16.7 -20.2 L 17.9 -22.8 L 21.2 -24.3 L 23.7 -24.4 L 26.5 -24.1 L 30.3 -22.5 L 35.6 -20.7 L 38.5 -20.0 L 41.6 -19.8 L 44.0 -21.0 L 44.9 -22.0 L 44.8 -23.9 L 42.9 -24.4 L 40.6 -24.2 L 38.2 -23.3 L 36.5 -22.0 L 33.7 -19.7 L 30.3 -15.3 L 27.4 -11.1 L 25.0 -7.1 L 22.5 -1.8 L 20.6 3.6 L 19.8 6.4 L 19.9 9.2 M 19.6 -9.3 L 33.6 -9.3","0 35.4 M 24.1 -10.2 L 28.4 -10.8 L 32.2 -12.3 M 32.2 -12.3 L 37.8 -16.1 L 40.3 -19.2 L 40.7 -20.9 L 39.7 -22.8 L 37.0 -24.2 L 34.1 -24.4 L 29.8 -23.9 L 26.6 -22.5 L 24.8 -20.2 L 24.7 -17.5 L 26.0 -14.9 L 32.2 -9.6 L 35.6 -6.1 L 37.1 -3.6 L 37.1 .1 L 35.1 3.9 L 32.3 6.4 L 27.9 8.5 L 22.0 8.9 L 17.3 6.7 L 14.7 3.2 L 14.5 -1.3 L 16.5 -5.1 L 19.4 -6.8 L 23.4 -7.8 L 25.7 -7.4 L 27.8 -6.5 L 28.8 -5.1 L 29.1 -3.4","0 35.2 M 31.5 -11.5 L 30.8 -9.2 L 28.6 -6.4 L 27.2 -5.1 L 23.0 -4.4 L 20.4 -4.9 L 19.4 -7.1 L 19.5 -10.6 L 21.7 -15.0 L 23.8 -18.5 L 26.7 -21.0 L 30.2 -22.9 L 35.1 -23.7 L 37.7 -22.2 L 39.4 -19.6 L 39.3 -15.6 L 38.4 -10.8 L 36.5 -6.7 L 33.5 -1.2 L 30.4 2.7 L 27.3 5.4 L 23.5 7.5 L 20.3 8.3 L 16.3 7.8 L 13.3 5.8","0 18.0 M 21.2 .5 L 20.7 1.7 M 17.8 7.1 L 17.2 8.1","0 16.5 M 21.1 .6 L 20.4 1.6 M 16.6 7.8 L 16.2 6.7 L 17.5 6.7 L 17.3 8.0 L 16.0 9.2 L 14.3 10.5 L 13.1 10.7 L 12.6 10.8","0 27.0 M 28.5 -7.0 L 27.0 -6.0 L 23.4 -5.3 L 20.6 -5.0 L 16.6 -4.7 L 19.5 -2.7 L 23.5 -.7 L 25.7 .6 L 26.3 1.1 L 26.6 1.7","0 23.9 M 15.5 -7.2 L 27.6 -7.2 M 14.8 -4.3 L 26.9 -4.5","0 27.0 M 16.5 -7.8 L 17.2 -6.7 L 20.3 -4.8 L 26.3 -1.6 L 23.8 -1.1 L 19.5 -.8 L 16.9 -.1 L 14.6 1.0","0 30.7 M 29.0 -18.2 L 28.3 -15.7 L 26.9 -13.8 L 24.8 -11.6 L 22.9 -10.7 L 19.2 -10.5 L 17.5 -11.5 L 17.1 -13.2 L 18.0 -16.5 L 20.9 -19.5 L 25.5 -22.0 L 31.0 -22.8 L 34.3 -22.1 L 35.7 -19.5 L 35.4 -15.4 L 33.2 -11.3 L 29.9 -7.7 L 26.8 -5.4 L 23.6 -3.3 L 21.1 -1.1 L 19.9 .6 L 19.6 2.3 L 19.6 3.3 L 20.3 4.1 L 21.8 4.4 L 22.1 4.3 M 18.1 7.0 L 17.2 8.4","0 31.3 M 27.3 2.2 L 28.8 1.0 L 29.4 -.3 L 28.9 -1.2 L 26.2 -1.1 L 22.8 1.1 L 21.0 2.7 L 19.2 4.7 L 18.4 6.5 L 18.7 7.4 L 19.8 7.6 L 21.1 6.9 L 25.3 3.5 L 25.7 3.4 L 23.7 5.8 L 23.6 7.7 L 26.4 8.1 L 30.2 6.9 L 33.1 5.1 L 35.6 2.3 L 36.8 -.5 L 36.7 -2.3 L 35.4 -3.9 L 32.3 -5.1 L 28.6 -5.1 L 24.9 -3.9 L 21.6 -2.2 L 16.8 1.3 L 14.4 4.2 L 13.1 6.5 L 12.9 9.0 L 13.5 10.9 L 15.6 12.3 L 19.4 12.8 L 21.9 12.7 L 24.5 11.9 L 27.1 10.7 L 28.7 9.9","0 42.5 M 8.0 7.2 L 11.5 8.1 L 15.2 8.1 L 19.1 7.2 L 23.0 5.4 L 26.1 3.3 L 30.4 -1.1 L 35.5 -6.9 L 39.4 -12.5 L 43.2 -17.9 L 46.7 -21.4 L 48.0 -22.2 L 49.3 -22.3 L 50.4 -21.3 L 48.2 -16.1 L 43.6 -5.7 L 39.6 2.8 L 36.7 7.5 L 35.9 8.3 L 34.5 8.3 L 32.2 4.3 L 31.0 2.4 L 27.2 -1.9 L 24.0 -3.8 L 20.3 -5.1 L 18.4 -5.1 L 17.1 -4.7 L 16.9 -3.9 L 18.3 -2.3 L 21.9 -1.0 L 30.5 .0 L 43.4 -.2 L 46.9 -.2 L 49.4 -.5 L 50.9 -.8","0 41.5 M 25.7 -11.2 L 24.1 -12.8 L 20.9 -13.7 L 18.0 -13.9 L 16.1 -14.8 L 14.0 -16.1 L 13.7 -17.4 L 13.9 -19.3 L 16.7 -21.2 L 22.0 -22.0 L 25.9 -22.1 L 30.3 -21.4 L 32.7 -20.0 L 33.8 -18.1 L 33.8 -16.3 L 32.6 -13.2 L 29.6 -6.8 L 25.5 .2 L 21.5 5.9 L 17.7 10.5 L 16.1 12.3 L 14.7 13.2 L 13.9 13.7 L 13.1 13.4 L 12.8 12.4 L 12.6 11.3 L 13.9 8.6 L 16.9 3.7 L 21.9 -2.7 L 28.4 -9.4 L 34.6 -15.3 L 38.8 -18.2 L 43.1 -20.7 L 46.2 -21.7 L 48.9 -22.0 L 50.1 -21.3 L 50.2 -20.2 L 48.8 -17.6 L 45.4 -14.7 L 41.1 -11.8 L 38.7 -10.2 L 33.8 -7.5 L 37.3 -8.7 L 40.3 -8.7 L 42.9 -8.1 L 44.3 -5.6 L 44.1 -2.8 L 41.9 1.2 L 39.0 4.5 L 35.9 6.9 L 31.8 8.6 L 28.4 9.1 L 26.0 8.7 L 24.1 7.8 L 23.7 7.1 L 23.9 6.0 L 25.2 5.6 L 43.9 5.6","0 25.7 M 14.6 -7.5 L 19.1 -7.8 L 23.4 -9.3 L 28.3 -11.5 L 32.8 -13.9 L 36.5 -16.1 L 39.9 -19.0 L 41.0 -20.3 L 41.2 -21.7 L 39.7 -22.2 L 36.9 -21.8 L 30.9 -18.2 L 25.3 -13.7 L 21.7 -9.7 L 18.0 -5.4 L 14.3 .1 L 12.6 4.6 L 13.0 8.0 L 15.0 9.9 L 17.9 10.2 L 21.4 9.2 L 25.4 7.8 L 29.0 5.0 L 33.7 .8","0 41.6 M 43.3 -23.1 L 40.4 -21.3 L 35.6 -15.6 L 30.7 -9.1 L 25.3 -.8 L 20.9 5.4 L 19.0 7.9 L 16.7 10.1 L 15.0 10.9 L 13.1 11.0 L 12.5 10.1 L 13.5 8.3 L 18.4 2.4 L 23.4 -1.5 L 26.0 -2.9 L 28.9 -4.3 L 30.9 -4.4 L 32.4 -3.2 L 32.6 -1.3 L 32.1 6.6 L 33.3 7.9 L 35.2 7.9 L 37.6 6.4 L 40.7 3.2 L 45.9 -3.9 L 50.7 -11.3 L 52.6 -16.3 L 53.6 -19.3 L 53.4 -22.2 L 52.1 -23.1 L 50.1 -23.3 L 46.7 -22.2 L 42.2 -18.7 L 38.6 -13.9 L 36.6 -10.2 L 35.6 -6.1 L 35.8 -3.5 L 37.3 -1.3 L 40.5 -.4 L 43.8 -.7 L 47.6 -2.6 L 51.3 -4.5 L 54.3 -6.2 L 55.2 -6.9 L 56.8 -7.1","0 36.7 M 13.7 -22.0 L 23.9 -21.2 L 31.7 -20.9 L 38.0 -21.1 L 44.1 -21.3 L 47.7 -22.2 L 49.0 -23.1 L 47.0 -23.6 L 43.1 -23.0 L 40.3 -22.7 L 36.1 -21.4 L 31.5 -20.0 L 24.5 -16.8 L 20.4 -14.3 L 18.7 -12.6 L 17.9 -11.0 L 18.3 -9.9 L 19.8 -9.6 L 24.7 -9.6 L 33.2 -10.7 L 34.8 -11.0 L 36.3 -10.8 L 36.5 -10.1 L 36.0 -9.1 L 33.3 -7.2 L 22.1 -1.9 L 16.5 1.9 L 14.6 4.5 L 14.4 7.0 L 16.5 8.1 L 22.4 7.8 L 30.2 7.0 L 33.4 7.1 L 35.3 7.3 L 36.3 7.9 L 37.6 9.0","0 25.0 M 13.3 -18.5 L 11.9 -19.4 L 11.8 -20.0 L 21.2 -19.6 L 29.9 -19.8 L 36.3 -20.4 L 43.9 -21.6 L 47.3 -22.8 L 49.3 -23.9 L 49.4 -24.7 L 46.4 -24.9 L 42.1 -23.3 L 39.9 -21.6 L 37.4 -19.3 L 32.6 -13.4 L 28.3 -7.8 L 24.2 -1.5 L 20.8 3.8 L 17.5 7.0 L 15.0 8.2 L 13.8 8.7 L 13.0 8.1 L 13.0 7.0 M 17.5 -5.3 L 34.4 -5.6 L 32.4 -4.5 L 31.5 -3.6 L 31.5 -3.1","0 27.1 M 12.6 -13.9 L 15.6 -13.5 L 20.2 -14.4 L 24.3 -16.3 L 27.7 -18.2 L 29.7 -19.9 L 30.9 -21.3 L 31.3 -22.1 L 31.1 -22.8 L 30.1 -23.3 L 27.0 -22.7 L 23.0 -20.7 L 19.8 -18.2 L 16.7 -15.2 L 14.7 -12.7 L 13.8 -10.3 L 14.2 -8.4 L 15.2 -7.2 L 17.2 -6.8 L 20.0 -6.7 L 23.4 -7.4 L 28.1 -9.4 L 33.8 -12.6 L 37.9 -15.6 L 45.1 -21.4 L 37.4 -14.5 L 33.7 -10.0 L 29.7 -4.5 L 25.7 .9 L 22.9 4.6 L 20.9 7.3 L 18.8 9.1 L 16.8 10.3 L 15.5 10.4 L 14.9 10.2 L 13.9 9.0 L 13.2 6.7 L 13.7 4.4 L 15.3 5.7 L 18.6 6.0 L 22.8 5.7 L 25.7 4.8 L 28.6 3.8 L 35.1 .8","0 35.8 M 27.6 -12.6 L 26.4 -13.9 L 23.1 -14.9 L 18.8 -16.1 L 15.9 -17.6 L 15.3 -19.2 L 15.9 -20.9 L 18.6 -22.6 L 22.6 -23.5 L 28.8 -23.5 L 31.7 -23.0 L 33.3 -22.0 L 34.7 -20.1 L 34.7 -17.1 L 32.1 -12.1 L 24.2 .9 L 20.9 5.3 L 17.2 9.4 L 13.9 12.4 L 11.7 13.7 L 10.6 13.7 L 10.8 12.4 L 12.7 8.9 L 17.4 4.8 L 28.0 -2.8 L 43.7 -13.0 L 50.5 -18.0 L 53.7 -21.1 L 55.3 -23.1 L 54.8 -24.4 L 53.4 -24.1 L 50.5 -22.5 L 46.7 -18.9 L 43.4 -14.5 L 40.3 -10.8 L 37.2 -6.4 L 32.9 .8 L 31.2 4.6 L 31.1 7.3 L 32.4 8.3 L 34.2 8.3 L 36.6 7.0 L 39.0 5.0 L 43.8 .8","0 21.7 M 36.1 -20.1 L 33.3 -17.0 L 26.7 -7.7 L 21.0 .8 L 16.0 7.2 L 15.1 8.3 L 13.8 8.3 L 13.8 7.2 M 37.6 -18.3 L 39.6 -20.1 L 40.5 -22.2 L 39.6 -23.6 L 35.8 -23.9 L 31.2 -22.6 L 25.3 -19.8 L 20.2 -16.5 L 15.9 -13.1 L 13.4 -9.8 L 12.7 -8.0 L 13.0 -6.6 L 14.6 -5.5 L 17.4 -5.2 L 21.9 -5.5 L 30.0 -6.8 L 32.9 -7.2 L 34.5 -7.5 L 36.1 -7.0 L 38.4 -6.3","0 32.0 M 50.5 -25.1 L 49.1 -24.1 L 46.6 -21.3 L 42.9 -16.8 L 39.9 -12.2 L 35.5 -5.0 L 32.7 -.1 L 29.1 6.5 L 25.3 12.9 L 22.2 17.7 L 19.3 20.8 L 17.3 22.9 L 15.7 23.6 L 12.8 23.9 L 11.6 22.1 L 10.5 19.5 L 11.3 14.8 L 12.4 11.8 L 15.9 7.3 L 20.2 3.0 L 24.9 -.1 L 32.6 -5.1 L 40.2 -9.5 L 46.0 -13.3 L 49.5 -16.9 L 50.3 -18.9 L 49.8 -20.9 L 49.0 -21.6 L 47.8 -21.8 L 44.7 -21.7 L 38.7 -20.4 L 31.6 -17.1 L 26.1 -12.8 L 22.7 -8.8 L 21.0 -4.0 L 21.6 -.5 L 23.2 1.6 L 26.6 3.0 L 29.5 3.3 L 33.7 2.9 L 37.0 2.0 L 39.9 .8","0 37.5 M 24.6 -12.9 L 23.9 -13.9 L 22.9 -14.5 L 18.9 -15.1 L 15.2 -15.7 L 12.3 -16.7 L 11.1 -17.4 L 11.0 -19.3 L 12.2 -20.9 L 15.2 -22.1 L 19.8 -23.0 L 27.3 -22.9 L 30.0 -22.0 L 31.3 -20.4 L 31.5 -17.7 L 30.2 -14.0 L 27.2 -7.8 L 22.8 -1.6 L 18.1 4.6 L 15.8 7.2 L 14.2 8.9 L 13.1 9.1 L 13.3 8.0 L 13.9 7.0 M 56.7 -26.1 L 54.9 -25.9 L 52.3 -24.2 L 49.0 -21.9 L 44.7 -18.2 L 41.2 -15.0 L 37.6 -11.9 L 35.0 -10.1 L 32.9 -8.6 L 31.1 -8.3 L 30.5 -8.6 L 30.8 -9.8 L 31.9 -11.7 L 34.8 -14.0 L 36.4 -14.3 L 37.7 -13.7 L 37.5 -12.3 L 36.2 -8.7 L 33.9 -2.3 L 32.6 2.7 L 32.2 5.9 L 32.9 8.0 L 35.1 8.6 L 37.3 8.1 L 39.1 7.6 L 40.5 6.6 L 42.4 4.8 L 45.4 .8","0 42.6 M 16.4 -12.8 L 23.6 -12.6 L 30.1 -13.7 L 36.3 -15.2 L 40.9 -16.6 L 46.1 -18.9 L 49.8 -21.1 L 51.5 -22.8 L 51.2 -23.8 L 49.6 -24.0 L 47.1 -23.6 L 43.9 -22.0 L 41.4 -20.1 L 38.1 -16.3 L 33.7 -11.1 L 25.8 -.8 L 20.4 6.1 L 18.0 8.5 L 15.2 10.1 L 14.3 11.0 L 12.8 10.8 L 12.3 9.9 L 13.3 7.3 L 16.5 4.6 L 19.4 2.4 L 21.3 1.4 L 22.8 .9 L 26.1 .8 L 29.7 1.8 L 31.9 3.6 L 35.2 6.2 L 37.6 7.7 L 40.8 8.1 L 43.2 7.8 L 45.9 6.3","0 42.0 M 24.6 -13.9 L 22.2 -10.6 L 19.3 -8.0 L 16.7 -6.4 L 13.6 -6.1 L 12.2 -7.7 L 13.0 -10.4 L 15.7 -13.9 L 20.6 -18.8 L 24.1 -21.1 L 26.9 -22.5 L 30.2 -22.9 L 31.8 -21.9 L 32.6 -19.6 L 31.9 -16.6 L 29.5 -10.2 L 26.0 -5.1 L 22.5 .0 L 19.4 4.0 L 16.7 7.0 L 15.2 8.1 L 14.6 8.1 L 13.9 7.8 L 13.8 6.7 L 15.7 2.9 L 20.9 -3.2 L 24.8 -7.8 L 27.4 -10.2 L 31.7 -13.6 L 35.4 -15.9 L 36.9 -16.6 L 39.1 -16.7 L 39.6 -15.8 L 39.1 -13.9 L 35.8 -8.1 L 31.3 -1.3 L 26.8 4.2 L 24.9 6.5 L 24.6 7.7 L 27.0 5.5 L 33.8 -.5 L 40.1 -6.1 L 44.2 -9.4 L 46.0 -10.3 L 47.0 -10.3 L 47.1 -9.0 L 46.4 -7.9 L 41.2 -1.0 L 38.1 3.2 L 36.9 6.2 L 36.7 7.8 L 37.9 8.8 L 39.5 8.7 L 41.7 7.7 L 44.5 6.1 L 50.0 .8","0 33.0 M 23.4 -9.1 L 24.0 -11.8 L 25.2 -14.5 L 26.4 -15.1 L 25.4 -12.1 L 24.3 -10.9 L 20.8 -7.8 L 17.8 -5.9 L 14.7 -5.4 L 12.8 -6.1 L 12.5 -8.4 L 15.3 -13.1 L 19.4 -17.3 L 23.9 -20.4 L 28.6 -22.0 L 31.0 -22.0 L 32.9 -20.9 L 33.7 -18.5 L 32.8 -15.0 L 30.4 -9.2 L 28.3 -6.1 L 24.9 -1.1 L 21.6 3.4 L 18.3 6.7 L 16.9 8.3 L 15.6 8.9 L 14.3 8.5 L 14.6 6.8 L 15.9 4.8 L 21.0 -1.9 L 27.3 -8.2 L 33.2 -12.9 L 38.1 -15.9 L 40.4 -16.9 L 41.9 -16.9 L 42.1 -16.1 L 41.6 -14.6 L 33.4 -3.3 L 30.9 .0 L 28.9 3.5 L 27.8 6.5 L 28.4 7.8 L 30.0 8.3 L 32.4 7.0 L 34.8 5.7 L 40.9 .8","0 30.3 M 30.8 -13.6 L 30.9 -14.8 L 31.8 -16.3 L 35.4 -18.6 L 36.8 -19.8 L 37.8 -21.2 L 37.7 -23.1 L 36.6 -24.2 L 33.9 -24.5 L 30.0 -23.3 L 25.2 -20.1 L 19.6 -14.0 L 15.6 -7.8 L 13.6 -3.2 L 12.9 .8 L 13.0 4.8 L 14.3 7.1 L 17.0 8.3 L 20.2 8.1 L 23.4 6.8 L 25.5 5.6 L 29.8 1.8 L 33.9 -3.1 L 37.2 -8.8 L 38.6 -12.9 L 39.3 -16.7 L 39.0 -18.5 L 38.2 -19.4 L 35.7 -20.5 L 31.9 -20.0 L 26.9 -17.2 L 23.1 -13.6 L 20.4 -8.7 L 19.1 -4.7 L 19.1 -.5 L 21.5 3.3 L 25.3 4.4 L 29.2 4.8 L 32.9 3.7 L 38.2 .9","0 24.2 M 24.7 -10.2 L 24.4 -12.0 L 22.4 -14.2 L 19.3 -15.9 L 17.1 -17.2 L 15.3 -18.5 L 14.3 -20.4 L 14.8 -21.7 L 16.7 -23.1 L 19.5 -23.8 L 23.4 -23.8 L 27.0 -23.2 L 30.3 -22.0 L 32.2 -20.5 L 33.0 -17.7 L 32.7 -14.9 L 30.8 -10.6 L 27.1 -4.2 L 23.9 .2 L 19.7 5.4 L 17.4 7.8 L 14.8 9.8 L 12.6 10.5 L 12.4 10.5 L 12.4 9.2 L 14.7 5.1 L 19.2 -.8 L 25.0 -7.3 L 28.7 -11.1 L 33.3 -15.2 L 39.7 -19.9 L 44.2 -22.5 L 47.2 -23.2 L 48.3 -23.1 L 49.1 -22.5 L 49.4 -21.5 L 47.8 -18.2 L 44.8 -13.5 L 41.9 -10.9 L 39.1 -8.8 L 37.4 -8.2 L 36.0 -8.0 L 34.8 -8.6 L 33.8 -9.3 L 33.3 -10.5","0 45.3 M 37.1 -16.0 L 34.2 -12.5 L 30.6 -9.6 L 25.8 -7.2 L 21.5 -6.5 L 19.7 -7.4 L 19.6 -9.5 L 21.4 -13.2 L 26.2 -17.8 L 32.4 -21.2 L 37.8 -23.3 L 41.7 -23.6 L 45.2 -23.1 L 46.6 -21.2 L 47.0 -18.8 L 46.1 -16.1 L 43.4 -11.6 L 38.7 -6.6 L 33.4 -1.0 L 25.9 5.1 L 21.5 8.6 L 17.1 11.0 L 14.4 12.0 L 12.9 11.6 L 12.4 10.6 L 13.4 8.2 L 16.6 5.4 L 21.5 2.8 L 24.4 1.4 L 26.1 1.2 L 28.8 1.4 L 31.5 2.8 L 35.6 5.2 L 38.4 6.9 L 41.5 7.9 L 44.5 7.5 L 46.0 7.2 L 48.9 5.7","0 41.6 M 25.8 -12.1 L 25.0 -14.2 L 23.0 -15.6 L 18.0 -17.1 L 15.1 -19.1 L 14.6 -20.8 L 15.9 -22.2 L 18.6 -23.2 L 23.9 -23.4 L 27.7 -22.8 L 30.9 -21.4 L 32.8 -19.0 L 32.8 -16.6 L 32.3 -13.4 L 30.1 -9.0 L 27.6 -4.6 L 22.7 1.9 L 17.8 7.3 L 15.3 9.4 L 14.3 10.1 L 13.2 10.5 L 12.6 9.7 L 13.1 7.8 L 15.4 4.0 L 20.2 -2.0 L 26.8 -9.0 L 31.4 -13.3 L 37.5 -17.8 L 42.8 -20.9 L 46.9 -22.6 L 49.9 -23.0 L 51.1 -22.5 L 51.4 -22.1 L 51.3 -20.5 L 50.0 -18.2 L 47.3 -14.8 L 43.8 -11.3 L 41.1 -9.2 L 40.0 -8.5 L 38.0 -7.8 L 37.0 -7.9 L 35.3 -8.3 L 34.0 -9.0 L 33.4 -9.9 L 32.7 -11.3 L 33.7 -11.4 L 33.5 -2.4 L 34.0 1.4 L 36.0 6.2 L 38.1 8.1 L 40.6 8.1 L 44.7 5.5 L 49.5 .6","0 42.1 M 14.0 8.7 L 16.9 8.1 L 21.2 6.3 L 28.7 2.8 L 36.0 -1.6 L 47.8 -8.8 L 54.3 -14.2 L 58.6 -18.3 L 59.7 -20.0 L 60.5 -21.4 L 60.6 -22.5 L 60.2 -23.1 L 59.3 -23.2 L 57.5 -22.8 L 54.0 -20.4 L 51.8 -17.7 L 48.8 -13.4 L 46.5 -9.3 L 43.8 -4.3 L 40.3 2.0 L 37.6 5.5 L 34.5 7.7 L 32.0 7.7 L 29.1 6.1 L 26.6 3.2 L 24.0 -.5 L 21.7 -3.3 L 18.5 -5.7 L 16.2 -6.4 L 13.8 -6.1 L 12.8 -4.9 L 14.1 -3.0 L 18.4 -1.6 L 28.9 -.4 L 39.1 -.4 L 46.5 -1.1 L 51.6 -2.1","0 24.6 M 12.8 -18.5 L 10.9 -19.3 L 10.9 -20.0 L 16.1 -18.8 L 23.7 -18.8 L 32.9 -18.8 L 40.7 -19.6 L 46.5 -20.9 L 50.7 -22.2 L 52.0 -23.2 L 52.3 -24.3 L 50.9 -24.9 L 47.2 -24.4 L 43.7 -23.0 L 40.5 -20.7 L 36.0 -16.2 L 31.2 -9.5 L 27.4 -3.7 L 24.3 1.4 L 21.7 5.1 L 20.2 6.7 L 18.3 8.3 L 17.8 8.9 L 16.0 9.1 L 16.1 8.1 L 16.8 6.7","0 35.7 M 24.1 -11.6 L 24.4 -11.6 L 26.0 -15.3 L 26.4 -16.4 L 27.2 -16.1 L 24.4 -12.6 L 22.0 -10.3 L 19.2 -8.5 L 15.4 -7.4 L 13.4 -7.8 L 12.6 -9.4 L 13.1 -11.5 L 15.8 -15.6 L 19.8 -19.1 L 24.6 -22.0 L 28.4 -23.5 L 30.7 -24.1 L 33.9 -23.6 L 35.2 -21.9 L 35.0 -20.0 L 33.7 -16.6 L 30.3 -11.8 L 25.7 -5.7 L 19.9 2.2 L 18.8 4.1 L 18.4 5.9 L 19.5 7.3 L 21.4 7.5 L 24.7 6.2 L 28.7 3.7 L 33.8 -.7 L 39.2 -5.8 L 44.3 -11.6 L 47.2 -15.5 L 47.8 -17.1 L 47.5 -17.9 L 47.0 -17.9 L 44.3 -16.3 L 40.7 -12.5 L 36.5 -7.1 L 33.8 -2.8 L 32.2 .1 L 30.9 3.3 L 31.0 6.8 L 32.5 8.3 L 35.2 8.4 L 36.8 7.7 L 39.5 6.0 L 43.6 .8","0 23.9 M 24.7 -12.2 L 23.9 -13.7 L 21.2 -15.0 L 17.5 -15.6 L 13.5 -16.4 L 11.7 -17.3 L 10.9 -18.8 L 11.3 -20.7 L 13.7 -22.2 L 16.3 -22.8 L 20.8 -23.2 L 25.0 -23.0 L 28.6 -22.4 L 31.1 -21.0 L 31.8 -19.0 L 31.6 -15.5 L 30.1 -12.1 L 26.4 -4.3 L 23.4 .5 L 20.7 4.3 L 18.9 7.1 L 17.8 8.1 L 17.2 8.9 L 15.9 8.9 L 15.6 8.1 L 16.1 6.0 L 17.4 4.1 L 19.3 1.6 L 21.8 -1.1 L 25.0 -4.1 L 31.4 -9.6 L 41.3 -16.9 L 44.6 -19.1 L 49.7 -21.7","0 37.5 M 23.8 -10.6 L 24.1 -11.9 L 23.5 -12.9 L 20.9 -14.2 L 17.6 -14.9 L 14.6 -15.8 L 12.5 -16.6 L 11.3 -17.2 L 10.1 -19.0 L 10.1 -20.5 L 11.2 -21.8 L 15.0 -23.3 L 19.6 -23.7 L 25.3 -23.3 L 29.6 -21.7 L 31.6 -19.0 L 32.1 -15.5 L 31.4 -11.2 L 28.5 -4.9 L 25.1 .9 L 21.7 5.4 L 18.4 8.9 L 17.0 9.9 L 15.6 10.1 L 15.2 9.3 L 15.7 7.5 L 19.2 2.7 L 24.3 -2.9 L 27.4 -6.0 L 34.5 -11.9 L 38.2 -14.3 L 39.4 -14.9 L 40.6 -15.2 L 41.2 -15.1 L 41.4 -14.0 L 41.1 -12.9 L 33.4 3.6 L 32.4 6.0 L 32.3 6.9 L 33.9 5.0 L 36.2 2.7 L 40.0 -2.1 L 44.2 -6.5 L 49.0 -11.0 L 54.0 -15.1 L 58.4 -18.1 L 61.6 -19.8 L 64.5 -21.2 L 61.2 -18.6","0 38.5 M 25.3 -10.7 L 28.3 -15.7 L 28.6 -15.3 L 25.2 -11.7 L 22.1 -8.8 L 17.4 -6.4 L 14.8 -6.0 L 13.6 -6.4 L 12.7 -8.0 L 13.5 -11.1 L 15.4 -14.4 L 19.4 -18.7 L 23.4 -21.4 L 28.5 -23.6 L 32.1 -24.1 L 34.7 -22.7 L 35.6 -19.4 L 35.0 -15.4 L 30.0 1.2 L 29.6 5.0 L 30.1 7.0 L 32.5 8.3 L 35.2 8.5 L 37.9 7.7 L 39.8 6.5 L 42.6 4.5 L 46.5 .7 M 53.5 -20.4 L 55.9 -22.7 L 56.1 -23.6 L 40.1 -12.3 L 26.8 -1.7 L 21.2 3.4 L 16.3 8.3","0 38.2 M 28.2 -13.9 L 25.5 -11.1 L 22.6 -8.3 L 19.8 -6.6 L 16.2 -5.8 L 14.0 -6.6 L 13.6 -10.1 L 16.5 -15.0 L 22.1 -19.1 L 26.8 -21.7 L 32.3 -22.9 L 35.7 -21.6 L 36.4 -18.8 L 34.9 -15.1 L 31.8 -10.1 L 23.3 -.5 L 20.2 4.4 L 19.5 7.4 L 20.6 8.7 L 24.1 8.0 L 29.3 4.7 L 39.5 -4.5 L 46.3 -11.1 L 48.4 -14.5 L 48.9 -16.4 M 49.3 -16.4 L 47.7 -16.4 L 42.3 -11.7 L 38.0 -5.8 L 34.0 -.9 L 27.2 7.9 L 20.4 17.3 L 13.2 28.4 L 11.4 32.2 L 11.2 33.7 L 13.3 34.5 L 16.7 32.3 L 21.7 26.7 L 23.8 23.2 L 24.3 20.2 L 23.4 18.3 L 21.0 17.0 L 18.0 16.9 L 16.5 17.1 L 26.5 13.3 L 33.8 9.1 L 39.7 5.6 L 43.2 3.0 L 46.2 .8","0 50.0 M 44.0 -10.7 L 43.9 -12.0 L 42.8 -13.4 L 39.1 -14.6 L 33.5 -15.3 L 28.4 -16.0 L 26.0 -17.1 L 24.7 -19.0 L 26.3 -22.2 L 30.1 -23.9 L 36.3 -24.4 L 41.2 -24.2 L 46.7 -23.1 L 50.6 -21.4 L 53.5 -19.0 L 54.5 -16.6 L 54.4 -14.1 L 52.4 -11.3 L 47.6 -7.0 L 40.0 -1.6 L 33.5 2.2 L 25.3 7.0 L 16.7 10.8 L 14.1 11.4 L 12.8 10.9 L 12.9 9.8 L 15.4 7.6 L 19.9 5.1 L 23.2 3.6 L 25.9 3.4 L 28.3 3.8 L 30.8 4.4 L 34.4 6.2 L 40.2 8.4 L 43.3 8.4 L 47.0 7.9 L 49.5 7.0 L 53.2 4.7","0 25.2 M 36.3 -26.7 L 26.0 -26.6 L 19.7 -4.2 L 14.3 15.2 L 24.7 15.4","0 22.0 M 19.8 -30.8 L 20.6 -22.2 L 21.3 -11.4 L 20.9 -2.2 L 20.8 5.7 L 20.4 13.1","0 25.2 M 25.2 -26.7 L 36.0 -26.6 L 24.3 15.2 L 14.5 15.2","0 21.6 M 17.7 4.3 L 20.1 3.2 L 21.5 2.2 L 22.3 1.4 L 22.8 2.4 L 23.1 3.5 L 24.0 4.6","0 27.7 M 15.6 8.6 L 28.2 8.9","0 21.4 M 16.4 -5.8 L 18.4 -4.1 L 21.1 -3.0","0 12.5 M 11.8 2.4 L 12.1 2.4 L 13.2 1.5 L 14.0 .4 L 14.2 -.3 L 13.7 -1.0 L 12.8 -1.2 L 11.0 -1.1 L 8.4 .5 L 6.0 2.6 L 4.0 4.7 L 3.3 6.2 L 3.4 7.4 L 4.7 7.4 L 5.8 6.9 L 7.8 5.4 L 10.0 3.7 L 10.4 3.5 L 8.5 6.0 L 8.4 7.4 L 9.1 8.3 L 10.4 7.9 L 13.5 6.0 L 16.6 3.9 L 20.5 .8","0 13.1 M 25.2 -18.3 L 18.2 -8.8 L 13.7 -2.4 L 11.0 2.0 L 9.4 4.8 L 9.0 6.6 L 9.4 7.6 L 10.4 7.4 L 11.6 6.6 L 13.0 5.4 L 13.9 3.8 L 14.3 2.0 L 14.3 .6 L 13.8 -.7 L 12.6 -1.7 L 10.1 -2.3 L 8.7 -1.6 L 7.9 -.3 L 8.0 .8 L 8.5 2.1 L 9.5 3.3 L 11.4 4.5 L 12.7 4.8 L 15.1 4.7 L 17.1 3.8 L 21.1 .8","0 10.3 M 11.5 1.6 L 12.4 .7 L 12.9 .0 L 12.8 -.5 L 12.6 -.8 L 11.8 -1.0 L 10.4 -.7 L 7.7 1.0 L 5.8 3.0 L 4.6 5.4 L 4.9 7.3 L 5.6 8.0 L 7.6 8.1 L 10.5 6.7 L 13.7 4.6 L 18.3 .8","0 11.8 M 25.3 -17.7 L 22.8 -13.9 L 18.9 -8.8 L 14.9 -3.4 L 10.4 3.2 L 9.1 4.2 L 7.1 5.8 L 4.6 7.3 L 3.1 7.8 L 2.8 6.6 L 3.7 4.9 L 6.0 2.5 L 8.1 .7 L 10.2 -.5 L 11.7 -.6 L 12.2 .6 L 10.1 4.6 L 9.9 6.7 L 10.4 7.3 L 12.5 6.5 L 16.5 3.9 L 19.8 .8","0 11.0 M 6.3 4.9 L 8.8 3.4 L 11.2 1.5 L 12.7 -.4 L 12.7 -1.3 L 11.5 -1.7 L 9.6 -.7 L 8.0 .8 L 6.4 2.9 L 5.9 4.4 L 5.6 5.9 L 5.8 6.9 L 7.2 7.9 L 9.0 7.8 L 11.6 6.5 L 14.5 4.5 L 19.0 .8","0 9.8 M 8.0 .8 L 13.8 -5.6 L 16.5 -8.6 L 21.0 -13.3 L 21.7 -14.3 L 22.2 -14.2 L 19.1 -9.1 L 14.6 -2.4 L 4.8 10.6 L -2.2 21.5 L -3.9 24.2 L -4.6 25.6 L -3.9 26.6 L -3.2 26.6 L .3 25.0 L 4.6 19.9 L 6.7 15.8 L 8.0 11.6 L 8.2 8.3 L 7.2 5.9 L 5.1 4.3 L 3.5 4.0 L 1.6 4.3 L .2 5.1 L -.1 5.9 L .2 6.9 L 2.2 8.3 L 5.3 8.9 L 8.7 8.0 L 12.0 6.2 L 14.3 4.3 L 17.8 .8","0 12.4 M 13.2 1.6 L 14.9 -.1 L 15.6 -1.4 L 14.2 -2.1 L 12.1 -1.9 L 9.7 -.4 L 6.0 2.3 L 3.4 5.4 L 3.5 7.0 L 5.4 7.3 L 6.9 6.4 L 9.8 4.3 L 11.6 2.7 L 11.1 2.4 L 5.6 11.0 L -1.5 21.1 L -3.7 24.2 L -4.5 25.5 L -4.8 24.8 L -3.0 21.5 L -.1 17.7 L 3.0 13.9 L 6.2 11.0 L 7.9 9.7 L 13.0 6.6 L 15.9 4.5 L 20.4 .8","0 13.6 M 19.4 -16.5 L 9.2 -1.0 L 3.6 7.6 L 7.3 4.2 L 10.1 1.8 L 11.7 .7 L 13.0 .1 L 13.9 .0 L 14.3 .0 L 14.2 1.0 L 11.8 4.3 L 10.7 6.2 L 10.6 7.4 L 11.7 8.1 L 12.9 7.6 L 15.0 6.4 L 17.6 4.5 L 21.6 .9","0 7.7 M 8.6 .0 L 6.2 3.3 L 5.0 5.5 L 4.6 6.5 L 4.6 7.3 L 4.9 7.9 L 5.8 7.8 L 8.9 5.9 L 13.5 2.6 L 15.7 .8 M 11.7 -4.4 L 11.0 -3.2","0 7.6 M 8.0 .8 L 11.6 -2.0 L 12.1 -1.4 L 7.7 5.0 L 2.0 13.2 L -1.5 17.9 L -4.6 22.5 L -6.4 25.1 L -6.6 26.3 L -5.6 26.8 L -3.7 26.1 L -.5 22.9 L 1.9 19.1 L 2.2 16.4 L 1.6 14.8 L .6 13.5 L -.6 12.9 L -2.5 12.5 L 1.0 12.2 L 3.6 11.7 L 6.3 10.0 L 10.9 5.9 L 15.6 .8 M 14.2 -5.9 L 13.2 -4.5","0 16.1 M 8.0 .8 L 10.9 -1.9 L 13.2 -4.3 L 16.4 -7.4 L 20.7 -11.4 L 22.8 -14.5 L 23.4 -16.5 L 22.9 -16.8 L 17.6 -10.2 L 14.0 -4.8 L 10.7 .0 L 9.1 2.1 L 5.7 6.8 L 5.7 7.5 L 8.8 3.5 L 11.7 .6 L 14.8 -2.1 L 17.8 -4.4 L 19.8 -5.3 L 20.9 -5.2 L 21.2 -4.1 L 20.3 -2.9 L 18.2 -.7 L 15.8 1.2 L 14.6 1.8 L 13.6 1.6 L 12.1 1.8 L 10.8 1.1 L 12.3 .5 L 12.9 .7 L 11.6 3.4 L 11.5 5.7 L 13.1 7.4 L 15.1 7.4 L 18.3 5.5 L 24.1 .8","0 10.5 M 8.2 .9 L 8.4 .9 L 11.1 -1.0 L 15.8 -5.1 L 20.0 -9.0 L 22.9 -12.1 L 24.6 -14.6 L 25.0 -15.9 L 24.7 -16.5 L 24.1 -16.7 L 22.7 -16.3 L 19.6 -14.0 L 15.8 -10.4 L 12.3 -5.8 L 9.3 -1.5 L 6.8 3.1 L 6.1 5.3 L 6.0 6.5 L 6.3 7.4 L 7.1 8.1 L 8.6 7.7 L 10.7 6.9 L 13.6 4.8 L 18.5 .9","0 20.1 M 28.1 .8 L 24.7 3.9 L 22.5 5.6 L 19.7 7.3 L 17.8 8.0 L 17.0 7.8 L 16.9 6.9 L 17.8 5.3 L 19.7 3.0 L 20.6 2.1 L 21.1 1.3 L 21.1 .8 L 20.3 1.1 L 18.7 2.3 L 15.5 4.7 L 12.9 6.6 L 11.5 7.2 L 10.7 7.3 L 10.9 6.5 L 11.3 5.9 L 12.2 4.8 L 13.4 3.2 L 15.2 1.1 L 15.3 .2 L 14.4 .1 L 13.3 1.0 L 11.3 2.4 L 7.3 5.6 L 4.1 7.5 L 7.0 3.4 L 9.3 .4 L 9.9 -.3 L 8.0 .8","0 16.2 M 8.0 .8 L 8.7 .2 L 10.1 -1.0 L 10.8 -1.1 L 11.0 -.7 L 10.7 .1 L 6.1 6.2 L 5.4 7.3 L 5.6 7.7 L 6.3 7.7 L 8.6 5.8 L 12.3 3.2 L 14.7 1.2 L 17.3 -.2 L 17.7 -.3 L 17.9 .2 L 15.8 2.9 L 13.7 5.5 L 13.3 6.7 L 13.3 7.9 L 14.4 8.0 L 16.4 6.8 L 20.1 4.3 L 24.2 .9","0 11.4 M 9.9 -.9 L 8.1 .7 L 6.3 3.3 L 5.6 6.9 L 5.9 8.3 L 7.9 8.5 L 11.0 6.0 L 13.1 2.8 L 14.0 .0 L 14.5 -2.3 L 14.3 -4.4 L 12.7 -6.3 L 11.0 -6.2 L 9.6 -5.3 L 9.1 -3.9 L 9.3 -1.8 L 10.2 .9 L 11.3 2.3 L 12.8 3.8 L 14.5 3.8 L 16.2 2.9 L 17.7 2.1 L 19.4 .8","0 14.9 M 23.0 .8 L 18.7 4.3 L 16.5 6.0 L 13.6 7.8 L 12.4 8.0 L 11.7 7.4 L 11.9 6.4 L 13.3 4.9 L 15.6 2.0 L 17.0 .5 L 16.9 -.3 L 16.4 -.5 L 14.6 -.3 L 12.9 .6 L 10.2 2.3 L 7.7 4.3 L 4.8 6.6 L 1.1 10.4 L -3.0 15.0 L -5.7 18.4 L -7.9 21.5 L -8.9 23.6 L -8.8 25.1 L -8.6 25.8 L -7.5 25.7 L -6.8 25.0 L -5.8 24.0 L -4.2 21.8 L -.3 17.1 L 4.6 10.4 L 9.4 3.4 L 12.6 -1.1 L 17.2 -7.0 L 18.5 -9.4 L 17.7 -8.7 L 15.9 -6.6 L 13.6 -4.0 L 8.0 .8","0 13.1 M 13.5 1.4 L 15.2 -.2 L 15.7 -1.6 L 15.1 -2.5 L 12.3 -2.0 L 9.1 -.1 L 6.6 1.9 L 4.6 4.1 L 3.7 6.0 L 3.6 7.0 L 5.6 7.4 L 7.5 6.2 L 9.5 4.8 L 11.2 3.3 L 11.5 3.3 L 5.5 10.7 L .9 16.7 L -2.8 22.0 L -4.1 24.4 L -4.5 25.6 L -3.5 26.1 L -2.5 25.9 L -.7 24.3 L 1.9 21.7 L 4.1 18.4 L 6.0 15.1 L 6.8 13.3 L 7.6 11.2 L 7.7 10.2 L 7.6 8.0 L 9.3 8.2 L 11.8 7.5 L 15.6 5.1 L 21.1 .8","0 11.5 M 8.0 .8 L 10.8 -1.4 L 12.3 -3.1 L 13.4 -4.4 L 13.7 -5.3 L 12.8 -5.4 L 11.5 -4.0 L 11.2 -3.2 L 11.4 -1.9 L 12.1 -.8 L 13.0 .1 L 9.9 3.9 L 8.7 5.6 L 8.4 7.1 L 9.0 7.6 L 10.3 7.4 L 14.2 5.0 L 19.5 .8","0 10.6 M 8.0 .8 L 9.1 .1 L 10.4 -.9 L 11.3 -2.7 L 11.8 -2.8 L 11.2 .0 L 10.8 2.0 L 10.5 4.7 L 10.3 6.2 L 9.6 7.3 L 9.1 8.0 L 8.2 8.5 L 7.0 8.2 L 6.3 7.1 L 7.8 8.5 L 10.1 7.7 L 11.3 7.0 L 14.7 4.8 L 18.6 .8","0 7.9 M 16.8 -9.6 L 12.0 -4.1 L 8.1 .6 L 5.6 4.0 L 5.0 6.6 L 5.4 7.9 L 6.6 7.7 L 10.4 5.2 L 15.9 .8 M 7.2 -8.6 L 6.3 -8.9 L 5.5 -9.5 L 8.7 -10.2 L 15.0 -11.0 L 21.2 -11.2 L 26.8 -11.4 L 31.2 -10.9","0 12.6 M 8.5 .4 L 6.1 2.7 L 4.4 4.8 L 3.3 6.8 L 3.7 7.5 L 4.8 7.5 L 8.4 5.0 L 12.3 1.8 L 13.6 .5 L 14.2 .4 L 10.8 4.4 L 9.8 5.9 L 9.4 7.0 L 9.7 7.7 L 10.7 7.9 L 13.0 6.7 L 16.0 4.4 L 20.6 .8","0 10.4 M 6.7 1.6 L 8.6 .5 L 9.3 1.0 L 8.0 3.2 L 5.6 7.8 L 6.6 7.2 L 10.1 4.5 L 14.2 1.2 L 16.7 -.5 L 17.7 -1.3 L 18.8 -1.3 L 19.2 -.7 L 18.4 .8","0 14.4 M 9.6 -.7 L 7.2 1.6 L 5.3 4.0 L 4.6 6.0 L 4.7 6.8 L 5.6 7.2 L 6.7 7.0 L 9.8 4.9 L 13.1 2.4 L 15.7 -.1 L 12.9 3.4 L 12.0 5.2 L 11.4 7.1 L 11.7 8.1 L 12.4 8.4 L 14.5 7.8 L 16.0 6.6 L 17.7 4.9 L 18.6 3.4 L 18.8 2.1 L 18.5 .7","0 12.3 M 7.9 .8 L 10.0 -.6 L 9.3 2.4 L 8.8 5.1 L 8.8 6.8 L 9.8 7.8 L 11.2 7.4 L 14.7 5.3 L 20.3 .8 M 16.3 -1.3 L 13.7 .2 L 11.4 1.7 L 9.0 3.4 L 6.9 5.4 L 4.4 7.7","0 14.1 M 9.0 -.4 L 6.4 2.8 L 5.2 4.5 L 4.8 6.1 L 5.6 6.6 L 6.9 6.1 L 9.5 4.4 L 11.9 2.4 L 14.1 .9 L 15.3 .1 L 15.4 .5 L 11.1 6.6 L 5.7 13.1 L 1.9 17.7 L -1.2 21.8 L -2.2 23.7 L -2.3 25.0 L -1.4 25.2 L 1.2 23.7 L 3.9 20.8 L 5.5 18.4 L 6.1 16.1 L 5.7 14.6 L 4.8 13.2 L 3.6 12.6 L 2.4 12.2 L 6.0 11.0 L 11.2 8.5 L 16.4 5.4 L 22.1 .8","0 8.8 M 6.1 2.3 L 9.1 .1 L 11.0 -1.1 L 12.1 -1.5 L 12.9 -1.1 L 13.2 -.3 L 12.9 .4 L 11.7 1.8 L 9.9 3.3 L 7.9 4.8 L 4.2 6.9 L 6.4 7.8 L 7.6 8.7 L 7.9 10.0 L 7.6 12.3 L 6.5 15.2 L 5.1 17.1 L 3.1 19.5 L .2 22.7 L -2.2 25.0 L -3.3 25.6 L -4.6 25.6 L -5.3 25.0 L -5.3 23.5 L -4.5 21.9 L -3.8 20.2 L -.6 16.5 L 2.5 13.5 L 6.0 11.0 L 8.0 9.7 L 11.8 7.8","0 25.0 M 34.1 -23.9 L 32.4 -24.6 L 29.4 -25.0 L 27.4 -24.4 L 25.9 -22.1 L 25.5 -18.7 L 24.8 -13.7 L 24.2 -10.3 L 23.3 -8.6 L 21.9 -7.0 L 19.8 -6.2 L 21.5 -5.4 L 22.3 -3.8 L 21.7 -2.0 L 19.3 3.8 L 18.0 7.0 L 17.6 9.0 L 17.4 10.7 L 18.2 12.2 L 19.7 13.6 L 22.9 15.0","0 22.4 M 29.7 -29.3 L 26.4 -16.7 L 23.4 -8.4 L 20.5 -1.0 L 17.3 7.3 L 15.1 12.1","0 27.0 M 26.0 -25.2 L 28.4 -24.5 L 30.3 -22.8 L 31.4 -20.9 L 31.6 -18.8 L 30.4 -15.1 L 28.3 -10.7 L 27.4 -8.3 L 26.9 -6.9 L 27.5 -5.2 L 28.0 -4.3 L 29.2 -4.0 L 27.6 -3.1 L 26.0 -2.1 L 24.9 .8 L 24.4 4.5 L 23.9 9.5 L 22.7 13.4 L 20.9 14.6 L 18.7 14.8 L 16.7 14.6 L 15.1 13.9","0 25.2 M 19.2 2.4 L 21.3 4.0 L 23.2 3.5 L 25.9 3.3 L 26.5 3.7 L 27.5 4.6","0 22.6 M 20.7 -20.8 L 18.4 -18.8 L 18.0 -16.4 L 19.4 -15.0 L 22.6 -15.5 L 24.2 -17.3 L 25.0 -18.7 L 24.7 -20.1 L 23.9 -21.0 L 22.7 -21.2 L 20.7 -20.8"]
EMSSwiss = ["-8 8","0 15.4 M 26.5 -19.0 L 17.4 1.1 M 15.0 6.9 L 14.3 7.5 L 15.2 8.1 L 15.9 7.5","0 8.8 M 16.8 -21.6 L 13.8 -14.2 M 22.3 -21.7 L 19.4 -14.2","0 34.2 M 31.1 -16.7 L 26.8 -11.3 L 23.1 -6.0 L 19.3 .2 L 16.1 5.8 M 40.3 -16.7 L 36.0 -11.3 L 32.3 -6.0 L 28.6 .2 L 25.3 5.8 M 17.2 -8.6 L 40.8 -8.5 M 14.0 -2.4 L 37.3 -2.2","0 19.9 M 28.6 -8.9 L 29.4 -11.0 L 29.5 -12.6 L 29.0 -13.6 L 27.9 -14.3 L 26.8 -14.6 L 24.9 -14.6 L 22.9 -13.4 L 21.9 -12.2 L 21.1 -10.5 L 21.3 -8.8 L 22.2 -7.6 L 23.1 -6.3 L 24.7 -4.5 L 25.8 -2.7 L 26.3 -1.0 L 26.1 .8 L 25.3 2.5 L 23.1 4.2 L 21.0 4.7 L 19.4 4.7 L 17.3 4.0 L 15.9 2.7 L 15.3 1.5 L 15.2 -.2 L 15.4 -1.3 L 15.9 -2.0 L 16.4 -2.7 M 28.1 -17.8 L 17.3 10.7","0 32.5 M 21.8 -19.2 L 18.3 -15.0 L 16.1 -11.5 L 15.4 -9.0 L 15.8 -7.4 L 16.4 -7.0 L 17.6 -6.9 L 19.6 -7.7 L 21.9 -9.5 L 24.7 -13.0 L 26.1 -15.3 L 26.9 -17.4 L 26.8 -18.8 L 26.3 -19.8 L 24.9 -20.9 L 29.2 -20.0 L 33.0 -19.8 L 36.2 -19.9 L 39.7 -20.3 L 42.5 -20.9 L 44.8 -21.4 L 40.9 -19.0 L 33.5 -12.4 L 26.9 -6.3 L 20.0 1.1 L 16.3 5.4 L 12.4 10.0 M 34.3 -3.8 L 31.4 -.6 L 28.9 3.2 L 27.9 6.1 L 28.1 7.7 L 28.7 8.7 L 29.8 8.7 L 32.2 7.8 L 35.0 5.2 L 36.6 2.8 L 38.4 .2 L 39.0 -1.8 L 39.0 -3.1 L 38.5 -4.2 L 37.9 -4.8 L 37.2 -5.3 L 36.5 -5.5","0 31.3 M 35.5 -1.5 L 34.5 1.2 L 32.9 3.6 L 30.5 6.2 L 25.5 8.9 L 22.1 9.4 L 19.1 8.9 L 16.2 6.9 L 15.6 4.8 L 16.0 1.3 L 18.1 -1.7 L 21.1 -3.8 L 23.4 -5.2 L 26.4 -7.0 L 29.2 -8.8 L 31.5 -10.9 L 32.8 -12.7 L 33.0 -14.5 L 31.8 -15.8 L 29.4 -16.0 L 27.7 -14.4 L 26.9 -12.6 L 27.0 -10.0 L 28.8 -4.7 L 35.9 8.3 L 38.8 11.7 L 40.8 13.0 L 42.7 13.3 L 44.3 12.7 L 46.1 11.4 L 48.0 9.8 L 48.7 8.4 M 23.9 3.3 L 22.7 1.2 L 22.9 -.2 L 24.4 -1.2 L 26.2 -1.7 L 32.3 -1.8 L 37.5 -1.5 L 39.4 -1.4 L 39.9 -1.5","0 5.7 M 17.5 -22.4 L 14.2 -14.1","0 14.1 M 38.3 -24.5 L 32.6 -22.9 L 26.8 -20.0 L 22.0 -16.5 L 17.4 -11.7 L 14.4 -6.9 L 13.0 -3.4 L 11.9 2.4 L 12.3 7.3 L 14.1 9.6 L 16.1 10.5 L 18.0 10.6 L 19.5 10.1","0 26.3 M 25.8 -24.4 L 28.3 -24.7 L 30.6 -23.9 L 32.2 -21.8 L 32.8 -17.7 L 31.7 -11.4 L 29.0 -4.7 L 24.8 .6 L 21.1 3.9 L 17.2 6.3 L 13.1 8.5 L 9.3 9.7 L 6.4 10.3","0 26.1 M 25.1 -22.4 L 19.8 -4.2 M 15.6 -17.8 L 29.8 -8.7 M 12.6 -8.7 L 32.4 -17.9","0 17.0 M 24.5 -9.3 L 18.4 5.7 M 13.5 -2.5 L 30.1 -2.3","0 6.6 M 12.5 6.4 L 13.1 7.8 L 13.0 8.9 L 12.0 10.7 L 10.5 12.3","0 12.9 M 12.8 .2 L 19.9 .3","0 7.9 M 11.7 6.8 L 11.0 7.3 L 11.8 7.9 L 12.6 7.3","0 19.4 M 35.7 -23.1 L 23.2 -7.8 L 11.5 6.6 L 9.4 9.7","0 19.1 M 19.6 -11.8 L 16.2 -8.5 L 14.0 -4.8 L 12.7 -.3 L 12.3 3.0 L 13.2 5.9 L 14.9 7.5 L 16.8 8.1 L 18.8 7.6 L 21.0 6.2 L 23.7 3.5 L 25.6 .5 L 27.0 -3.4 L 27.8 -7.4 L 27.4 -10.0 L 26.3 -12.3 L 25.1 -13.0 L 23.5 -13.2 L 22.3 -13.2 L 20.9 -12.6 L 19.6 -11.8","0 12.7 M 15.3 -9.6 L 22.5 -13.8 L 20.5 -11.9 L 15.1 6.3 L 13.5 7.6 L 9.7 8.0 L 19.2 8.1 L 17.4 8.0 L 15.3 6.1","0 16.9 M 17.1 -8.0 L 17.8 -12.1 L 20.6 -13.5 L 24.2 -13.9 L 26.3 -13.4 L 27.4 -12.2 L 27.9 -10.1 L 27.4 -7.8 L 25.3 -5.2 L 21.6 -1.5 L 17.7 1.9 L 10.7 8.1 L 12.0 7.6 L 14.9 7.5 L 18.2 7.6 L 21.0 7.6 L 22.8 6.8 L 24.1 5.5 L 25.7 3.1","0 16.5 M 16.1 -8.0 L 16.4 -8.2 L 17.3 -12.1 L 19.2 -13.2 L 22.7 -13.7 L 24.7 -13.3 L 26.6 -12.4 L 27.0 -10.3 L 26.6 -8.6 L 25.2 -6.9 L 23.1 -5.6 L 20.8 -4.5 L 17.7 -4.0 L 21.1 -3.6 L 23.2 -3.0 L 24.4 -1.8 L 24.6 .6 L 23.5 3.5 L 21.9 5.9 L 19.8 7.4 L 17.7 8.1 L 15.0 8.4 L 12.7 8.2 L 11.6 7.3 L 11.1 6.5 L 11.9 3.1","0 20.8 M 29.5 -3.0 L 26.3 .7 L 18.4 1.0 L 12.2 1.1 L 20.8 -8.1 L 24.5 -11.9 L 26.9 -13.0 L 20.5 6.5 L 17.8 7.6 L 15.2 8.0 L 24.9 8.1 L 22.2 7.2 L 20.7 6.5","0 17.4 M 27.5 -8.7 L 29.7 -13.1 L 19.4 -13.1 L 15.4 -3.9 L 18.0 -4.5 L 21.0 -4.6 L 23.7 -3.7 L 25.1 -1.9 L 25.0 1.2 L 23.6 4.0 L 21.5 6.1 L 20.1 7.4 L 17.5 8.3 L 14.9 8.4 L 13.0 8.2 L 11.6 7.5 L 11.2 6.5 L 11.9 3.5","0 17.2 M 27.6 -10.0 L 28.4 -12.0 L 28.2 -13.1 L 24.8 -14.2 L 20.6 -12.7 L 17.5 -10.1 L 15.5 -7.3 L 14.0 -3.9 L 12.8 -.4 L 12.2 3.0 L 12.7 6.4 L 15.0 7.9 L 17.4 8.0 L 20.0 7.3 L 22.7 5.2 L 24.0 3.6 L 24.9 1.0 L 25.0 -1.6 L 24.0 -3.4 L 22.7 -4.6 L 20.7 -5.0 L 17.9 -4.4 L 16.4 -3.5 L 15.2 -2.7 L 14.4 -1.6 L 12.8 .8","0 15.7 M 15.2 -8.9 L 15.3 -9.2 L 17.2 -12.9 L 27.7 -12.7 L 28.9 -13.1 L 25.2 -8.5 L 21.7 -4.5 L 18.0 -.2 L 14.9 4.1 L 12.4 7.9","0 18.0 M 23.3 -14.3 L 20.0 -13.2 L 17.3 -10.3 L 16.2 -7.7 L 16.8 -5.4 L 18.0 -4.4 L 21.9 -1.1 L 22.7 .7 L 22.4 3.0 L 21.1 5.6 L 18.7 7.5 L 17.0 8.3 L 14.6 8.3 L 12.9 8.1 L 11.4 6.7 L 11.1 4.8 L 12.4 1.9 L 14.5 -.1 L 16.7 -1.7 L 22.5 -5.3 L 25.0 -7.5 L 26.5 -9.2 L 26.9 -10.6 L 27.0 -12.7 L 25.9 -13.7 L 24.9 -14.1 L 23.3 -14.3","0 18.0 M 12.2 4.1 L 11.6 6.9 L 13.8 8.2 L 17.1 7.9 L 20.7 5.9 L 23.2 3.1 L 25.1 .2 L 26.3 -3.0 L 27.3 -5.3 L 27.8 -7.7 L 27.7 -10.1 L 26.8 -12.3 L 25.6 -13.4 L 24.0 -13.8 L 22.0 -13.7 L 20.0 -13.1 L 16.7 -10.5 L 15.4 -8.3 L 14.8 -5.1 L 15.6 -2.9 L 17.0 -1.6 L 19.1 -1.0 L 21.6 -1.4 L 23.7 -2.6 L 25.1 -3.6 L 26.4 -5.5 L 27.6 -8.2","0 7.9 M 16.8 -5.9 L 16.1 -5.4 L 16.9 -4.8 L 17.6 -5.4 M 13.3 7.1 L 12.6 7.6 L 13.4 8.2 L 14.1 7.6","0 8.0 M 17.4 -5.9 L 16.7 -5.4 L 17.6 -4.8 L 18.3 -5.4 M 12.9 7.6 L 14.1 6.9 L 13.7 9.7 L 12.2 12.4 L 10.4 13.9","0 15.5 M 24.4 -9.6 L 19.5 -6.1 L 14.1 -2.6 L 18.1 .5 L 20.5 2.9 L 21.4 4.0 L 21.3 4.7","0 17.9 M 13.3 -5.2 L 26.5 -5.1 M 11.9 1.0 L 25.6 1.1","0 15.4 M 15.1 -9.6 L 18.4 -6.2 L 20.0 -4.7 L 22.6 -2.4 L 16.9 .8 L 13.6 3.1 L 12.2 4.3 L 12.5 4.7","0 22.8 M 15.3 7.1 L 14.6 7.6 L 15.4 8.2 L 16.1 7.6 M 18.1 -14.0 L 19.0 -17.4 L 19.8 -18.6 L 21.2 -19.4 L 24.2 -20.1 L 26.7 -20.5 L 28.6 -20.0 L 30.4 -18.7 L 31.4 -16.9 L 31.1 -14.4 L 29.1 -11.6 L 26.8 -10.0 L 24.1 -8.5 L 21.3 -6.8 L 19.7 -5.4 L 18.2 -3.9 L 17.1 -2.1 L 16.9 -.2 L 17.1 1.0 L 17.4 1.7","0 39.6 M 37.7 -11.5 L 33.8 -11.6 L 29.9 -10.9 L 27.3 -8.3 L 24.9 -5.5 L 23.6 -2.4 L 22.9 .1 L 23.3 1.4 L 24.1 1.2 L 26.5 .5 L 29.3 -2.2 L 30.7 -3.8 L 32.7 -6.1 L 35.0 -10.2 L 35.7 -11.2 L 31.0 -1.7 L 30.3 .8 L 30.4 1.8 L 33.6 1.7 L 37.3 .9 L 41.9 -1.4 L 44.3 -4.3 L 45.7 -7.7 L 45.9 -10.7 L 45.2 -13.3 L 42.7 -15.8 L 38.6 -17.6 L 34.8 -18.3 L 30.3 -18.0 L 26.1 -16.8 L 21.0 -14.0 L 16.9 -9.7 L 14.9 -4.8 L 14.5 -.9 L 15.5 3.3 L 17.7 6.2 L 21.4 8.2 L 25.7 8.9 L 30.1 8.6 L 33.1 7.9 L 36.6 6.5 L 39.0 4.7 L 40.5 3.0","0 41.8 M 10.4 3.1 L 9.7 5.1 L 9.8 7.2 L 11.2 8.5 L 12.9 8.8 L 15.6 8.6 L 19.1 6.8 L 23.6 3.7 L 32.0 -3.5 L 37.5 -9.2 L 40.4 -12.4 L 42.7 -14.6 L 45.3 -16.8 L 47.8 -17.9 L 49.5 -18.8 L 50.5 -19.1 L 51.5 -19.1 L 52.8 -19.2 L 54.3 -20.1 L 55.5 -20.6 L 57.1 -20.8 L 55.2 -20.4 L 53.4 -19.5 L 51.9 -18.0 L 49.7 -14.9 L 47.9 -11.4 L 46.2 -8.4 L 44.6 -4.8 L 42.3 -1.0 L 40.8 3.2 L 40.2 5.5 L 40.2 7.3 L 40.8 8.1 L 41.6 8.2 L 42.9 8.3 L 44.3 7.8 L 46.1 6.2 L 47.7 4.6 L 49.8 1.9 M 17.5 .0 L 17.3 -.9 L 18.2 -2.4 L 19.8 -3.2 L 22.4 -4.1 L 24.8 -4.4 L 26.9 -4.5 L 30.3 -4.4 L 34.1 -4.1 L 37.3 -4.1 L 39.8 -4.2 L 40.9 -4.2 L 42.1 -4.9 M 33.3 -11.4 L 32.4 -12.7 L 32.9 -15.1 L 34.6 -17.0 L 37.7 -18.3 L 43.1 -19.0 L 46.4 -18.9 L 50.0 -19.0","0 28.9 M 13.5 -12.1 L 12.5 -13.4 L 12.3 -14.5 L 12.3 -16.0 L 12.7 -16.9 L 13.9 -17.8 L 15.7 -18.5 L 18.1 -18.9 L 20.9 -19.1 L 23.8 -19.3 L 27.0 -19.0 L 29.4 -19.2 L 33.4 -19.0 L 35.4 -18.1 L 36.6 -16.5 L 37.0 -13.2 L 36.0 -10.9 L 34.2 -9.0 L 32.5 -7.7 L 30.0 -6.6 L 28.1 -6.1 L 23.6 -5.3 L 24.1 -5.9 L 29.1 -5.7 L 32.0 -5.1 L 34.5 -3.6 L 34.8 -.8 L 34.2 2.4 L 32.3 4.9 L 30.2 6.7 L 26.8 8.3 L 24.5 8.9 L 20.5 8.9 L 18.2 8.4 L 16.1 7.7 L 15.1 6.9 L 14.5 5.0 L 13.4 6.5 L 15.1 6.9 M 28.2 -18.8 L 25.9 -17.2 L 23.9 -13.9 L 13.0 5.7 L 11.7 7.3 L 10.2 8.6 L 9.5 9.1 L 8.7 9.2","0 29.5 M 36.2 -12.1 L 36.8 -13.7 L 37.4 -15.4 L 37.3 -16.7 L 35.9 -18.1 L 34.5 -18.9 L 32.2 -19.4 L 27.9 -19.0 L 22.9 -17.0 L 18.7 -13.5 L 15.4 -9.9 L 13.5 -6.6 L 12.2 -3.2 L 11.5 .8 L 11.9 4.1 L 13.6 6.8 L 15.5 8.2 L 18.3 9.0 L 22.7 9.2 L 27.0 8.4 L 30.8 7.2 L 34.8 4.7 L 36.5 3.0 L 37.5 1.9","0 31.9 M 12.9 -12.3 L 12.0 -14.2 L 11.9 -15.5 L 12.4 -16.9 L 12.8 -17.5 L 14.7 -18.2 L 16.7 -18.7 L 19.7 -19.1 L 23.9 -19.2 L 28.8 -19.4 L 32.6 -19.2 L 36.0 -18.4 L 38.1 -17.5 L 39.9 -15.6 L 41.2 -12.0 L 40.9 -9.0 L 40.5 -5.3 L 38.1 -.4 L 35.4 3.2 L 31.9 6.1 L 28.5 7.7 L 25.8 8.5 L 22.7 8.8 L 19.8 8.8 L 17.8 8.6 L 16.1 8.0 L 15.3 7.5 L 14.3 4.6 L 13.1 6.1 L 15.0 7.5 M 29.0 -19.3 L 26.0 -17.9 L 24.3 -16.2 L 14.4 3.0 L 13.9 4.4 L 12.4 6.4 L 11.1 7.4 L 10.4 8.1 L 9.3 8.8 L 8.2 9.0","0 27.0 M 27.6 -19.2 L 25.0 -17.9 L 24.2 -16.9 L 13.3 2.1 L 12.0 4.5 L 11.9 6.1 L 12.7 7.1 L 14.2 7.8 L 19.2 8.5 L 23.8 8.4 L 27.0 7.8 L 28.8 7.5 L 30.6 6.4 L 32.6 4.7 L 35.0 1.9 M 14.4 -12.2 L 13.2 -15.0 L 13.5 -16.9 L 14.7 -17.8 L 17.4 -18.6 L 21.0 -19.0 L 32.5 -19.4 L 36.7 -19.0 L 37.4 -17.8 L 37.2 -16.4 L 36.4 -14.5 M 18.2 -6.2 L 28.9 -5.9 L 30.3 -6.1 L 31.4 -6.9","0 29.9 M 39.5 -19.2 L 35.5 -18.0 L 33.7 -16.2 L 29.8 -8.8 L 22.6 4.7 L 21.0 6.7 L 18.9 8.2 L 16.9 9.0 L 14.8 9.3 L 12.7 8.8 L 11.5 8.0 L 10.4 6.6 L 10.2 5.1 L 10.1 2.7 M 21.2 -11.4 L 19.8 -13.0 L 19.2 -14.6 L 19.1 -16.1 L 21.0 -18.1 L 23.3 -18.5 L 26.2 -18.8 L 31.4 -19.3 L 43.8 -19.2 L 45.4 -19.0 L 46.7 -18.9 L 47.3 -18.3 L 47.3 -17.1 L 46.6 -15.1 L 46.4 -14.4 M 28.9 -6.2 L 38.8 -6.0 L 39.7 -5.8 L 39.6 -5.1 L 38.9 -3.5 L 38.6 -3.1","0 29.7 M 35.9 -12.0 L 36.9 -13.8 L 37.4 -15.7 L 36.9 -17.1 L 35.5 -18.7 L 31.2 -19.5 L 23.6 -17.5 L 18.6 -13.8 L 14.4 -8.5 L 12.4 -3.6 L 11.2 2.2 L 12.1 5.0 L 14.2 7.3 L 18.0 9.5 L 22.7 9.6 L 26.7 8.1 L 31.5 5.7 L 33.4 3.2 L 35.4 .2 L 37.7 -4.9 L 33.5 7.2 L 31.0 14.3 L 26.7 21.0 L 21.8 24.3 L 17.1 25.5 L 14.2 25.3 L 11.2 23.5 L 10.1 21.9 L 10.1 19.0 M 24.7 -.8 L 24.2 -2.0 L 24.2 -4.0 L 25.6 -4.9 L 40.6 -5.6","0 41.6 M 19.8 -12.5 L 18.7 -14.5 L 18.7 -16.4 L 20.2 -17.8 L 22.3 -18.5 L 25.3 -18.9 L 27.9 -18.9 L 34.4 -19.2 L 37.5 -19.2 L 34.5 -18.8 L 32.0 -16.1 L 29.5 -12.1 L 25.9 -5.2 L 23.1 .6 L 20.3 4.7 L 18.4 6.9 L 15.5 8.5 L 12.9 8.3 L 10.9 7.8 L 8.9 6.1 L 8.6 4.6 L 8.5 1.8 M 54.5 -20.7 L 51.2 -19.5 L 49.6 -18.7 L 43.4 -7.8 L 38.4 2.1 L 37.7 4.6 L 37.9 6.4 L 38.5 7.8 L 40.0 8.3 L 42.6 8.3 L 44.9 7.2 L 47.8 4.4 L 49.6 1.9 M 18.7 -4.5 L 20.8 -5.1 L 34.4 -4.5 L 38.6 -4.6 L 41.2 -5.4","0 19.0 M 24.5 -12.7 L 23.3 -14.9 L 23.3 -17.2 L 24.9 -18.2 L 26.9 -18.8 L 40.5 -19.1 L 35.0 -18.3 L 32.4 -16.0 L 30.1 -12.1 L 26.4 -4.1 L 23.8 .4 L 21.1 4.5 L 18.6 6.4 L 16.1 7.8 L 13.2 7.8 L 11.1 7.2 L 9.8 5.8 L 9.0 4.2 L 8.9 2.6","0 11.0 M 15.0 -11.4 L 12.8 -14.2 L 12.9 -16.6 L 15.1 -18.1 L 19.5 -19.0 L 28.6 -19.3 L 25.5 -17.5 L 23.7 -16.1 L 20.4 -9.3 L 16.0 .6 L 13.4 6.5 L 10.0 11.4 L 6.9 14.5 L 3.8 15.7 L 1.5 16.0 L -1.3 14.8 L -2.6 12.9 L -2.9 10.5","0 31.0 M 17.5 -12.1 L 16.1 -14.5 L 16.8 -17.0 L 18.0 -18.1 L 19.9 -18.5 L 22.7 -19.0 L 31.0 -19.1 L 28.6 -18.8 L 25.4 -16.3 L 23.3 -13.0 L 17.0 -1.9 L 12.0 6.9 L 9.4 8.8 L 10.8 7.7 L 13.0 7.4 L 12.7 6.0 M 48.4 -17.6 L 46.9 -18.8 L 42.7 -18.6 L 38.3 -16.4 L 32.4 -13.0 L 25.0 -8.4 L 19.1 -4.2 L 20.7 -5.3 L 24.2 1.7 L 27.6 6.1 L 30.7 7.7 L 33.2 7.7 L 35.6 6.1 L 37.4 4.1 L 39.0 1.9","0 28.0 M 33.6 -12.8 L 34.7 -14.9 L 34.9 -17.2 L 33.6 -18.6 L 31.1 -19.5 L 27.5 -18.8 L 25.1 -16.4 L 22.8 -12.6 L 20.3 -7.3 L 18.0 -2.0 L 16.2 2.5 L 14.4 5.1 L 12.8 6.2 L 10.5 7.3 L 8.6 8.7 L 8.6 7.6 L 13.8 7.3 L 22.7 7.5 L 29.9 7.6 L 33.2 6.8 L 33.4 6.0 L 33.5 5.1 L 33.3 4.5 L 31.6 2.3","0 44.8 M 22.9 -11.6 L 20.9 -13.6 L 20.8 -16.1 L 21.7 -17.3 L 23.6 -18.1 L 26.1 -18.8 L 28.1 -19.0 L 36.7 -19.2 L 34.2 -17.8 L 30.7 -14.6 L 28.5 -9.4 L 25.6 -3.2 L 22.8 1.6 L 19.9 4.9 L 16.9 7.6 L 13.9 8.1 L 11.7 7.6 L 9.2 5.4 L 8.8 4.7 L 8.6 2.9 M 35.2 -18.4 L 34.1 -16.1 L 33.9 -11.6 L 33.9 -4.2 L 33.8 .3 L 33.8 2.2 L 33.3 3.5 L 32.2 5.1 L 50.6 -14.2 L 55.6 -19.5 L 56.9 -20.7 L 58.9 -21.3 L 57.0 -20.5 L 54.2 -17.8 L 51.5 -13.7 L 46.7 -4.4 L 44.1 1.4 L 43.1 5.2 L 43.2 7.1 L 44.6 8.3 L 46.4 8.1 L 49.3 6.1 L 51.0 4.2 L 52.8 1.9","0 37.2 M 23.1 -11.5 L 22.7 -11.5 L 21.0 -14.0 L 21.0 -16.3 L 22.4 -17.8 L 25.3 -18.7 L 28.6 -19.0 L 37.4 -19.1 L 37.4 -18.8 L 34.2 -17.8 L 32.5 -16.8 L 30.9 -14.9 L 29.4 -11.1 L 27.3 -6.1 L 25.2 -1.3 L 23.4 2.2 L 20.6 5.4 L 18.0 7.2 L 15.2 8.2 L 12.4 8.0 L 9.4 6.3 L 8.9 4.7 L 8.5 2.8 M 33.2 -16.6 L 33.5 -13.6 L 38.7 3.5 L 40.4 6.9 L 38.3 8.8 L 40.8 3.7 L 45.6 -8.7 L 49.5 -17.1 L 51.9 -20.9 L 53.7 -22.0 L 54.4 -22.1 L 55.7 -22.0 L 56.4 -21.3 L 56.4 -20.7","0 30.5 M 30.0 -19.7 L 24.1 -18.8 L 18.9 -15.8 L 15.0 -11.4 L 11.8 -6.6 L 10.3 -1.8 L 10.2 2.8 L 11.4 5.9 L 13.8 7.7 L 17.3 8.8 L 21.3 8.8 L 27.0 7.2 L 33.7 2.4 L 38.0 -3.4 L 40.0 -9.2 L 40.2 -13.5 L 39.0 -16.7 L 35.9 -18.8 L 33.5 -19.5 L 30.0 -19.7","0 27.8 M 30.1 -19.2 L 27.3 -18.2 L 25.8 -16.9 L 14.5 4.2 L 13.3 6.0 L 12.3 7.3 L 11.0 8.2 L 9.2 8.9 L 12.4 7.3 L 14.8 6.9 L 14.8 3.8 M 13.6 -12.4 L 12.5 -14.5 L 13.0 -17.2 L 14.6 -18.3 L 18.2 -18.9 L 25.0 -19.1 L 30.8 -19.3 L 34.8 -18.8 L 37.3 -16.3 L 37.5 -13.3 L 36.7 -10.4 L 34.6 -7.7 L 32.1 -6.0 L 29.3 -4.9 L 26.9 -4.5 L 22.9 -4.4","0 30.6 M 31.0 -19.7 L 25.8 -19.3 L 19.3 -16.4 L 14.3 -11.3 L 11.4 -6.3 L 9.7 -.9 L 10.0 4.1 L 12.3 6.9 L 15.6 8.3 L 18.9 8.6 L 23.0 8.4 L 26.8 7.1 L 30.6 5.1 L 34.9 .9 L 38.0 -3.9 L 39.9 -9.6 L 39.7 -14.0 L 38.3 -17.1 L 36.4 -18.5 L 33.7 -19.3 L 31.0 -19.7 M 23.5 8.3 L 26.6 13.8 L 29.5 18.5 L 31.4 21.0 L 33.5 21.5 L 36.0 21.2 L 39.2 19.9 L 41.7 17.8","0 33.3 M 13.7 -12.4 L 12.7 -14.4 L 12.4 -16.0 L 13.0 -17.1 L 14.9 -18.0 L 17.6 -18.8 L 21.4 -19.1 L 33.4 -19.0 L 36.1 -18.1 L 37.5 -15.3 L 37.5 -12.9 L 37.0 -10.6 L 35.4 -8.2 L 33.6 -6.4 L 30.8 -5.3 L 27.7 -4.6 L 23.4 -4.5 L 22.8 -4.1 L 26.1 2.3 L 28.7 6.0 L 31.5 8.0 L 34.7 8.2 L 36.8 7.0 L 39.2 4.8 L 41.3 1.9 M 30.0 -19.0 L 26.9 -18.1 L 25.2 -16.1 L 14.7 4.0 L 12.4 7.3 L 9.8 8.9 L 13.1 6.8 L 14.7 6.9 L 14.5 4.7","0 23.1 M 33.0 -12.9 L 34.2 -15.7 L 34.4 -17.7 L 32.5 -19.5 L 29.9 -20.0 L 27.9 -20.0 L 24.9 -18.6 L 23.0 -17.1 L 22.0 -14.0 L 22.5 -10.5 L 25.9 -5.8 L 29.3 .2 L 28.8 4.5 L 27.0 6.9 L 24.7 8.5 L 22.0 9.5 L 17.4 9.0 L 13.7 7.5 L 12.1 6.1 L 11.0 3.7 L 11.1 .7 L 12.2 -1.3","0 21.9 M 38.5 -17.6 L 33.4 -16.1 L 31.5 -14.0 L 29.6 -10.1 L 27.4 -4.4 L 25.2 .0 L 23.8 3.3 L 20.7 6.9 L 17.5 8.8 L 14.7 9.3 L 12.6 8.8 L 10.9 7.6 L 9.9 5.6 L 9.8 3.4 M 11.5 -11.4 L 9.7 -13.3 L 9.1 -14.9 L 9.0 -16.2 L 9.7 -17.2 L 13.5 -18.4 L 18.1 -19.0 L 22.7 -18.7 L 38.8 -17.3 L 42.5 -17.2 L 44.4 -17.3 L 45.4 -18.5","0 33.8 M 10.6 -12.8 L 9.6 -15.2 L 9.3 -16.3 L 10.6 -18.1 L 13.3 -19.0 L 29.8 -19.3 L 25.9 -18.5 L 24.4 -16.7 L 21.2 -9.9 L 17.8 -2.5 L 15.2 3.5 L 14.2 5.5 L 13.9 8.0 L 16.1 8.9 L 18.9 8.3 L 23.8 5.1 L 28.1 .6 L 30.3 -1.7 L 32.9 -5.4 L 42.4 -18.4 L 43.9 -20.0 L 42.0 -18.2 L 39.1 -17.3 L 31.2 -.5 L 29.4 5.7 L 29.9 7.9 L 32.2 8.9 L 34.3 8.4 L 36.4 7.3 L 39.1 4.9 L 41.8 1.9","0 27.7 M 10.9 -12.6 L 9.6 -15.1 L 9.9 -17.3 L 11.9 -18.6 L 14.1 -19.0 L 29.9 -19.0 M 25.6 -19.0 L 27.1 -12.4 L 26.6 -6.1 L 25.2 2.4 L 22.9 10.3 L 23.9 9.5 L 31.5 -.8 L 38.4 -9.1 L 47.3 -17.6 L 51.6 -20.6 L 54.5 -21.5 L 56.9 -21.4 L 57.6 -20.6 L 57.6 -19.2 L 57.0 -16.5","0 46.1 M 22.7 -19.0 L 25.7 -14.7 L 26.5 -7.1 L 25.6 .2 L 23.2 9.0 L 24.6 9.1 L 29.7 1.4 L 36.0 -7.5 L 41.4 -14.0 L 45.1 -16.9 L 48.1 -18.1 L 50.1 -18.5 L 51.3 -18.7 L 46.9 -17.2 L 43.9 -14.7 L 41.7 -11.2 L 40.2 -5.1 L 39.8 1.2 L 39.1 5.0 L 37.6 9.5 L 38.3 9.7 L 42.4 3.8 L 47.7 -3.3 L 53.1 -9.1 L 57.7 -14.0 L 61.5 -17.6 L 67.0 -20.9 L 69.3 -21.5 L 70.8 -21.5 L 71.9 -21.1 L 72.2 -20.0 L 72.1 -18.4 L 71.6 -16.6 M 11.0 -12.6 L 10.3 -14.3 L 9.8 -16.6 L 10.6 -18.3 L 13.2 -18.6 L 17.3 -18.9 L 30.3 -19.0","0 29.8 M 23.0 -18.4 L 22.7 -13.0 L 23.6 -6.3 L 25.0 .0 L 27.6 5.6 L 29.8 7.7 L 32.5 7.6 L 34.7 5.9 L 36.3 4.1 L 37.8 1.9 M 45.4 -15.2 L 46.4 -17.4 L 46.4 -18.9 L 45.0 -19.7 L 42.4 -19.9 L 38.5 -18.1 L 33.2 -13.7 L 27.2 -8.2 L 20.1 -.1 L 12.4 6.7 L 5.8 10.2 L 3.7 10.6 L 3.1 9.4 L 3.2 7.8 L 3.5 7.3 L 4.8 7.4 M 10.6 -12.8 L 9.5 -14.9 L 9.7 -17.1 L 10.5 -17.9 L 11.9 -18.5 L 14.3 -19.0 L 30.1 -18.8","0 23.3 M 22.8 -18.6 L 24.9 -15.9 L 26.0 -10.6 L 25.4 -5.8 L 24.3 -.1 M 44.6 -16.5 L 44.8 -18.8 L 43.9 -20.0 L 41.4 -20.0 L 37.9 -17.5 L 34.2 -13.3 L 30.3 -8.0 L 26.1 -1.5 L 23.3 2.9 L 20.7 6.4 L 18.1 8.5 L 15.1 9.4 L 11.8 9.1 L 10.1 7.9 L 8.9 6.1 L 8.8 3.8 M 13.7 -12.6 L 12.7 -14.9 L 12.5 -16.4 L 13.4 -17.7 L 15.3 -18.5 L 18.5 -19.1 L 29.5 -18.8","0 22.7 M 17.2 -12.9 L 16.2 -14.9 L 16.2 -16.9 L 16.9 -17.8 L 19.1 -18.5 L 23.1 -19.0 L 36.6 -18.8 L 16.9 -1.6 L 11.9 3.0 L 8.6 7.1 L 7.1 9.2 L 7.2 9.9 L 8.0 9.9 L 10.0 5.9 L 12.4 4.2 L 16.6 2.8 L 19.8 2.8 L 23.4 4.9 L 28.4 10.5 L 33.0 15.7 L 37.1 19.1 L 39.7 20.4 L 42.6 20.5 L 44.5 19.3 L 45.3 17.9 L 45.7 16.0 L 45.3 14.5 L 44.9 13.7 L 43.3 11.9","0 18.5 M 35.0 -21.2 L 29.1 -21.7 L 26.0 -20.0 L 23.9 -16.4 L 10.0 13.0 L 19.9 13.1 L 21.5 12.7","0 25.3 M 9.7 -22.1 L 33.0 9.6","0 20.0 M 20.3 -20.9 L 32.1 -21.2 L 16.7 11.4 L 15.5 12.6 L 14.3 13.1 L 11.3 13.3 L 7.4 13.1 L 6.7 13.3","0 15.8 M 12.8 -4.9 L 18.6 -8.5 L 23.2 -4.9","0 7.6 M 10.8 7.2 L 11.9 7.9 L 12.8 7.8 L 12.0 7.0","0 11.7 M 11.0 -13.4 L 16.9 -9.4","0 14.6 M 19.8 -4.9 L 15.9 -5.4 L 11.7 -3.1 L 8.2 1.5 L 6.3 6.2 L 6.9 7.4 L 8.8 7.3 L 14.2 2.8 L 15.5 1.6 L 17.4 -1.5 L 18.4 -3.2 L 18.4 -4.5 L 20.3 -4.9 L 15.5 3.0 L 14.4 5.9 L 14.1 7.5 L 15.1 7.9 L 17.5 6.9 L 20.6 4.2 L 22.6 1.9","0 11.8 M 8.0 1.9 L 10.3 .0 L 12.4 -2.2 L 16.1 -9.5 L 19.2 -14.4 L 23.6 -19.7 L 27.8 -21.9 L 30.1 -22.2 L 31.6 -21.4 L 32.0 -20.2 M 12.1 -2.0 L 9.6 3.1 L 8.3 6.1 L 8.4 7.6 L 9.5 8.2 L 11.7 8.3 L 15.6 5.7 L 18.1 2.3 L 19.8 -.6 L 20.5 -3.0 L 19.8 -4.5 L 18.7 -4.6 L 15.4 -2.0 L 14.0 -.3 L 12.4 .9 L 10.0 3.7","0 11.4 M 18.3 -1.6 L 18.7 -3.7 L 17.9 -5.1 L 16.4 -5.5 L 14.7 -5.1 L 11.9 -3.2 L 9.3 -.4 L 7.2 3.3 L 6.5 6.7 L 7.9 8.3 L 10.6 8.2 L 14.0 6.8 L 17.3 4.2 L 18.7 2.8 L 19.3 1.9","0 14.2 M 35.4 -21.1 L 33.2 -22.4 L 29.5 -21.3 L 25.9 -17.6 L 22.8 -12.0 L 19.2 -5.2 L 17.0 -1.0 L 15.1 1.8 L 12.0 4.8 L 10.3 6.2 L 8.1 7.4 L 6.7 7.6 L 6.3 7.1 L 6.7 4.1 L 9.5 -.7 L 11.8 -3.4 L 13.6 -4.6 L 14.9 -5.4 L 16.9 -5.4 L 17.5 -5.0 L 18.3 -3.7 L 14.8 3.8 L 14.0 6.5 L 14.4 7.8 L 16.3 7.6 L 18.0 6.4 L 20.6 3.9 L 22.2 1.9","0 12.1 M 9.2 1.8 L 13.1 1.3 L 16.1 .0 L 17.9 -1.8 L 18.2 -3.7 L 17.9 -4.9 L 16.5 -5.3 L 13.7 -4.5 L 10.6 -1.8 L 8.1 1.6 L 6.9 5.0 L 7.1 6.8 L 8.1 7.7 L 10.5 8.4 L 12.9 7.8 L 15.6 6.4 L 18.0 4.5 L 20.1 1.9","0 9.2 M 32.2 -20.2 L 32.0 -21.4 L 30.5 -22.1 L 28.1 -22.1 L 25.7 -21.0 L 23.6 -19.3 L 21.4 -16.1 L 18.9 -11.1 L 16.2 -5.1 L 14.3 -.4 L 11.6 6.4 L 9.6 10.5 L 7.2 14.6 L 4.3 17.3 L 2.2 18.6 L -.4 19.5 L -2.1 19.6 L -4.2 19.1 L -6.1 17.6 L -6.7 16.7 L -6.3 14.0 M 13.1 -4.9 L 13.4 -4.9 L 20.3 -5.0 L 21.2 -5.2","0 11.0 M 20.0 -5.1 L 17.4 -2.0 L 15.2 1.1 L 11.8 4.7 L 10.4 6.3 L 7.7 7.5 L 6.6 7.7 L 6.0 6.7 L 7.0 3.6 L 8.6 1.0 L 10.2 -1.0 L 12.7 -3.7 L 14.5 -5.0 L 16.5 -5.2 L 18.3 -4.9 L 19.1 -4.9 L 15.3 4.7 L 11.4 13.4 L 7.6 19.5 L 4.5 22.9 L .7 25.1 L -2.9 25.5 L -7.0 24.1 L -8.5 22.6 L -9.0 21.5 L -8.9 19.1","0 14.4 M 31.7 -19.7 L 31.6 -21.0 L 29.9 -22.5 L 26.7 -22.3 L 23.5 -21.2 L 19.4 -18.5 L 16.0 -14.7 L 13.3 -10.0 L 9.6 -1.9 L 5.7 7.8 L 6.2 7.8 L 9.3 3.0 L 12.2 -.5 L 14.9 -3.2 L 16.8 -4.3 L 18.9 -5.1 L 18.9 -3.9 L 17.9 -2.1 L 14.4 4.5 L 13.6 6.0 L 13.2 7.3 L 13.9 8.1 L 15.4 8.0 L 17.5 7.2 L 19.4 5.6 L 22.4 1.9","0 9.6 M 8.0 1.9 L 10.8 -1.5 L 13.2 -3.8 L 15.1 -5.5 L 14.0 -3.9 L 9.9 3.9 L 8.8 6.6 L 8.8 7.7 L 9.6 8.0 L 11.4 7.6 L 14.4 5.9 L 16.1 3.8 L 17.6 1.9 M 18.1 -13.1 L 17.5 -11.9 L 18.8 -11.9 L 19.1 -13.0","0 6.8 M 17.6 -5.5 L 15.1 -4.4 L 14.2 -3.7 L 11.8 3.3 L 7.8 12.1 L 4.5 18.3 L 1.7 21.6 L -1.7 24.1 L -5.1 25.2 L -8.9 25.3 L -10.9 24.4 L -12.6 22.9 L -13.1 21.1 L -13.0 19.3 M 17.8 -13.3 L 17.2 -12.1 L 18.6 -12.0 L 19.0 -13.2","0 18.9 M 32.4 -20.5 L 32.4 -21.4 L 30.9 -22.3 L 27.4 -21.7 L 23.7 -19.2 L 21.0 -16.2 L 17.4 -10.4 L 14.3 -3.8 L 12.3 1.6 L 10.5 5.4 L 9.3 7.8 L 10.2 7.6 L 12.7 3.3 L 16.5 -.9 L 19.2 -3.5 L 21.6 -4.8 L 23.0 -4.5 L 23.4 -3.9 M 15.8 -1.3 L 16.7 4.0 L 17.6 7.1 L 19.4 7.9 L 21.8 7.4 L 24.3 5.1 L 26.9 1.9","0 11.1 M 8.0 1.9 L 15.4 -4.9 L 19.9 -9.5 L 23.6 -14.9 L 25.5 -18.7 L 26.4 -20.6 L 26.4 -21.6 L 26.1 -22.4 L 25.6 -22.6 L 24.1 -22.6 L 22.3 -20.9 L 19.2 -16.6 L 14.7 -8.1 L 11.2 -1.1 L 9.2 3.3 L 8.9 6.4 L 10.1 7.8 L 13.0 7.6 L 16.0 5.4 L 19.1 1.9","0 24.3 M 8.0 1.9 L 11.6 -2.4 L 13.8 -4.6 L 15.6 -5.0 L 13.7 -2.7 L 11.3 3.1 L 9.5 8.1 L 12.0 2.3 L 16.0 -1.5 L 18.2 -3.3 L 20.5 -4.8 L 21.7 -4.8 L 22.0 -4.1 L 20.4 -1.7 L 17.4 4.2 L 16.3 6.7 L 16.6 7.2 L 18.3 3.3 L 21.4 .1 L 24.0 -2.2 L 25.7 -3.8 L 27.6 -4.7 L 28.6 -4.9 L 29.1 -3.9 L 27.3 -1.0 L 23.9 6.6 L 24.5 8.1 L 27.1 7.1 L 29.7 4.8 L 32.3 1.9","0 17.1 M 8.0 1.9 L 13.4 -4.9 L 14.4 -5.0 L 15.6 -5.4 L 14.0 -3.9 L 8.7 8.1 L 9.2 8.1 L 12.8 1.9 L 16.7 -2.4 L 19.0 -4.1 L 21.0 -4.9 L 22.1 -5.0 L 22.1 -4.2 L 20.0 -1.2 L 17.0 5.2 L 16.4 6.6 L 16.4 7.8 L 17.5 8.4 L 19.0 7.8 L 20.9 6.4 L 25.1 1.9","0 12.8 M 14.7 -5.0 L 10.7 -2.0 L 8.1 1.6 L 6.7 5.1 L 6.8 7.1 L 7.8 8.0 L 10.4 7.9 L 13.6 5.4 L 15.9 2.6 L 17.4 -.1 L 18.4 -2.4 L 18.5 -4.0 L 18.1 -4.9 L 16.9 -5.6 L 16.0 -5.6 L 14.7 -5.0 M 14.1 5.2 L 14.5 5.2 L 15.5 5.7 L 18.2 4.4 L 20.8 1.9","0 11.0 M 18.8 -11.4 L 18.4 -12.3 L 17.1 -12.5 L 14.7 -11.2 L 11.9 -8.5 L 10.0 -4.2 L 8.6 .6 L 6.5 5.4 L 4.2 10.5 L 1.2 16.7 L -1.6 20.4 L -5.4 23.7 L -8.3 25.2 L -12.1 25.6 L -14.6 24.8 L -16.8 22.9 L -17.3 21.7 L -17.4 18.9 M 8.6 1.5 L 12.3 -2.1 L 15.4 -4.4 L 16.9 -4.9 L 17.7 -3.4 L 16.4 -.3 L 14.2 3.3 L 13.2 5.1 L 11.6 6.8 L 9.9 7.8 L 8.0 8.5 L 6.5 8.3 L 6.1 7.0","0 13.7 M 21.0 -5.1 L 18.6 -5.0 L 16.0 -5.4 L 12.3 -3.9 L 10.0 -1.1 L 8.2 1.5 L 6.6 4.9 L 6.2 6.7 L 6.7 7.7 L 7.8 7.8 L 9.0 7.3 L 10.8 5.9 L 12.6 4.5 L 14.1 3.0 L 17.3 -1.3 L 18.5 -3.7 L 18.5 -4.7 L 19.6 -4.8 L 13.3 7.8 L 8.6 17.9 L 5.7 25.1 L 6.8 24.4 L 10.3 17.7 L 14.1 12.1 L 19.2 5.1 L 21.6 1.9","0 11.5 M 8.0 1.9 L 13.3 -4.9 L 15.0 -5.1 L 16.0 -5.8 L 14.1 -3.7 L 8.8 8.4 L 9.3 8.3 L 12.9 .9 L 17.0 -3.7 L 18.8 -4.6 L 19.8 -5.0 L 20.8 -4.8 L 22.0 -3.0 L 21.7 -2.2 L 21.3 -1.3","0 9.5 M 17.2 -1.7 L 17.8 -3.5 L 16.9 -5.2 L 14.8 -5.6 L 13.2 -4.7 L 12.0 -3.7 L 11.4 -2.0 L 12.5 .4 L 14.6 2.9 L 15.3 4.0 L 15.3 6.4 L 13.5 8.3 L 11.2 9.2 L 8.9 8.6 L 7.3 7.8 L 6.3 6.4 L 6.3 5.0 L 6.7 3.9 M 8.0 1.9 L 11.6 -2.8","0 10.6 M 8.0 1.9 L 11.1 -1.3 L 13.4 -4.0 L 15.1 -5.8 L 17.4 -10.6 L 18.1 -11.8 L 19.3 -12.7 L 13.7 -2.2 L 11.0 3.0 L 10.1 6.1 L 9.9 7.5 L 11.0 7.9 L 13.7 6.7 L 16.1 5.1 L 18.6 1.9 M 11.0 -4.8 L 11.9 -5.1 L 20.0 -5.2","0 20.5 M 8.0 1.9 L 11.4 -2.0 L 12.8 -3.4 L 14.7 -4.6 L 15.7 -5.1 L 16.1 -4.6 L 15.2 -2.5 L 11.1 5.0 L 10.4 7.3 L 10.5 7.9 L 11.8 8.1 L 13.5 7.5 L 15.7 5.9 L 17.6 3.7 L 20.0 1.2 L 22.2 -2.3 L 23.2 -4.6 L 26.1 -5.4 L 24.1 -4.6 L 21.5 -.5 L 19.5 4.1 L 19.4 6.9 L 20.9 7.8 L 23.5 6.8 L 25.8 5.2 L 28.5 1.9","0 13.0 M 8.0 1.9 L 11.6 -2.5 L 12.9 -4.0 L 14.9 -5.2 L 13.2 -3.1 L 11.9 .4 L 11.2 5.1 L 11.4 7.3 L 12.9 8.2 L 15.1 7.0 L 18.6 3.3 L 20.7 -.2 L 21.6 -2.6 L 21.9 -4.1 L 21.0 -5.5","0 23.0 M 8.0 1.9 L 12.1 -4.1 L 12.2 -4.5 L 14.5 -4.8 L 13.2 -3.6 L 11.8 1.3 L 11.0 5.8 L 10.9 7.5 L 12.5 8.2 L 14.0 7.4 L 17.2 4.6 L 19.1 1.7 L 20.7 -1.0 L 22.3 -4.3 L 24.0 -5.0 L 22.8 -3.3 L 21.6 .0 L 20.9 3.8 L 20.7 6.4 L 20.9 7.7 L 21.9 8.1 L 24.2 7.5 L 26.9 5.7 L 28.8 3.7 L 30.8 .6 L 32.2 -2.4 L 32.7 -3.7 L 32.6 -5.1 L 32.3 -5.8 L 31.7 -6.2","0 15.9 M 15.6 -4.6 L 14.2 -3.8 L 14.0 -3.1 L 14.6 2.7 L 16.0 6.5 L 17.0 7.6 L 18.7 8.1 L 19.4 7.8 L 21.0 6.6 L 22.3 4.9 L 23.9 1.9 M 25.8 -4.8 L 24.3 -4.6 L 20.7 -2.2 L 17.2 .4 L 12.4 4.6 L 8.3 8.4","0 15.3 M 7.9 2.0 L 12.0 -2.7 L 14.2 -4.8 L 16.5 -4.7 L 15.0 -2.2 L 12.2 2.8 L 10.2 7.0 L 10.4 8.1 L 13.4 7.6 L 17.3 4.3 L 19.9 1.2 L 21.4 -1.3 L 22.4 -3.0 L 23.1 -3.7 L 24.3 -4.7 L 25.9 -5.1 L 23.5 -3.1 L 20.4 3.8 L 16.2 13.1 L 13.6 17.9 L 10.2 21.9 L 7.0 24.3 L 2.9 25.6 L .3 25.4 L -2.9 24.0 L -4.1 21.8 L -4.3 19.1","0 11.8 M 13.0 -3.9 L 13.9 -4.5 L 21.6 -4.6 L 22.2 -4.1 L 16.9 -.1 L 12.2 3.7 L 9.7 6.1 L 8.6 7.3 L 7.7 8.8 L 7.9 9.4 L 8.3 7.9 L 11.0 5.9 L 14.6 5.9 L 16.9 8.2 L 18.5 10.2 L 20.8 12.4 L 22.3 13.6 L 24.1 14.0 L 25.2 13.7 L 26.5 13.0 L 26.8 11.7 L 26.6 10.5 L 25.8 9.7","0 18.1 M 34.6 -20.0 L 31.2 -19.7 L 28.2 -18.5 L 26.0 -16.4 L 24.6 -13.5 L 22.9 -10.3 L 21.2 -7.0 L 18.1 -4.9 L 16.7 -4.0 L 14.7 -3.6 L 12.8 -3.5 L 16.7 -2.5 L 18.2 -1.2 L 18.1 1.3 L 14.8 8.8 L 14.2 11.2 L 14.6 12.2 L 15.7 12.7 L 17.5 13.2 L 18.6 13.3 L 19.3 13.4","0 19.1 M 24.1 -20.7 L 12.5 8.3","0 21.4 M 21.8 -19.8 L 25.5 -19.8 L 27.7 -18.3 L 27.6 -15.0 L 26.1 -12.3 L 24.7 -9.4 L 23.8 -7.0 L 24.1 -4.8 L 25.9 -3.7 L 29.1 -3.0 L 25.4 -2.7 L 22.7 -1.5 L 20.7 .5 L 18.5 4.1 L 17.1 8.1 L 15.1 10.2 L 13.6 11.9 L 12.3 12.6 L 9.6 13.1 L 6.8 13.1","0 14.6 M 12.3 -9.0 L 14.0 -9.8 L 15.4 -9.9 L 17.1 -9.2 L 19.5 -8.3 L 20.9 -8.5 L 22.2 -9.0 L 22.8 -9.5","0 10.5 M 15.2 -11.8 L 13.5 -10.6 L 12.8 -8.9 L 13.2 -7.6 L 15.3 -6.1 L 18.5 -6.8 L 19.9 -8.0 L 20.5 -9.8 L 20.0 -11.5 L 19.1 -12.2 L 16.9 -12.6 L 15.2 -11.8"]
EMSTech = ["-8 8","0 2.8 M 12.3 -14.7 L 12.2 .6 M 12.8 6.2 L 12.1 6.7","0 7.1 M 13.5 -17.5 L 13.4 -11.7 L 13.7 -10.8 M 16.7 -17.5 L 16.6 -11.5 L 16.8 -10.9","0 21.5 M 16.9 -12.2 L 17.2 3.7 M 23.2 -13.0 L 24.0 3.5 M 11.9 -7.1 L 20.9 -8.0 L 30.1 -8.4 M 12.9 -.8 L 21.7 -2.0 L 30.1 -2.8","0 18.6 M 26.8 -11.8 L 20.3 -11.5 L 16.8 -10.7 L 13.8 -9.2 L 12.5 -7.6 L 12.4 -6.1 L 13.3 -4.6 L 15.5 -4.0 L 21.2 -4.0 L 25.2 -4.4 L 27.5 -3.8 L 28.0 -2.5 L 27.5 -1.0 L 25.0 .5 L 22.3 1.9 L 18.4 2.6 L 13.9 2.8 M 19.1 -18.9 L 21.3 8.7","0 20.3 M 16.1 -12.7 L 14.0 -12.2 L 13.5 -10.3 L 13.7 -9.2 L 14.6 -8.5 L 16.9 -8.6 L 18.7 -9.6 L 18.9 -11.5 L 18.0 -12.3 L 16.1 -12.7 M 27.9 -14.3 L 16.3 6.5 M 25.6 2.2 L 24.9 4.2 L 25.6 5.8 L 27.1 5.9 L 28.6 5.7 L 30.4 4.3 L 30.4 2.7 L 29.7 1.9 L 28.0 1.7 L 25.6 2.2","0 23.1 M 32.8 -2.8 L 30.9 -.4 L 28.2 1.8 L 24.5 4.2 L 20.9 6.0 L 17.6 6.9 L 14.9 6.8 L 13.5 6.1 L 13.6 4.1 L 14.4 2.4 L 19.6 -4.5 L 21.7 -8.3 L 22.2 -10.4 L 22.5 -12.6 L 22.0 -14.1 L 21.1 -14.8 L 19.7 -14.6 L 17.9 -13.6 L 16.6 -12.0 L 16.0 -10.6 L 15.9 -7.8 L 16.4 -5.6 L 17.8 -3.5 L 19.0 -2.0 L 21.4 .2 L 24.8 3.1 L 28.1 4.9 L 30.0 5.7 L 30.8 5.7","0 4.5 M 13.7 -12.4 L 12.4 -8.2","0 9.5 M 18.5 -18.8 L 16.3 -16.3 L 14.5 -12.8 L 13.3 -9.4 L 12.6 -5.7 L 12.3 -2.5 L 12.9 .9 L 14.1 4.9 L 15.9 8.1","0 11.2 M 12.6 -18.0 L 15.6 -15.5 L 17.5 -12.4 L 19.2 -8.4 L 19.9 -5.1 L 20.0 -2.1 L 19.5 .8 L 18.3 3.4 L 17.4 5.1 L 15.2 7.6","0 17.0 M 19.3 -6.3 L 22.0 -14.2 L 20.8 -6.6 L 27.2 -8.5 L 20.6 -5.6 L 22.2 2.1 L 19.0 -4.4 L 14.6 1.7 L 18.2 -5.9 L 13.3 -9.8 L 19.3 -7.1","0 17.5 M 18.7 -8.2 L 19.1 -2.7 L 19.7 3.0 L 20.0 5.3 M 12.2 -1.1 L 15.1 -1.7 L 18.6 -2.3 L 22.4 -2.8 L 26.7 -2.9","0 5.3 M 14.0 5.4 L 12.6 8.6 L 11.7 9.8","0 10.1 M 12.5 -.4 L 16.2 -1.0 L 18.8 -1.3","0 3.5 M 12.1 6.7 L 12.6 6.6","0 15.5 M 25.9 -14.4 L 22.0 -8.3 L 19.6 -4.2 L 17.6 -1.3 L 15.2 2.4 L 12.3 6.8","0 20.5 M 21.7 -14.2 L 23.8 -14.0 L 26.4 -12.9 L 28.4 -10.5 L 29.4 -7.8 L 29.9 -4.7 L 29.4 -.8 L 28.0 2.3 L 25.4 5.1 L 22.6 6.4 L 18.3 6.7 L 14.7 5.7 L 12.8 3.7 L 12.0 1.2 L 12.5 -3.3 L 13.7 -7.3 L 15.8 -11.0 L 17.6 -12.9 L 19.7 -14.1 L 21.7 -14.2","0 7.6 M 14.5 -14.3 L 13.9 6.5","0 17.5 M 12.7 -10.7 L 14.9 -12.6 L 17.2 -13.9 L 20.0 -14.6 L 21.6 -14.6 L 23.2 -13.5 L 23.8 -11.9 L 23.5 -9.6 L 22.7 -7.3 L 20.9 -3.8 L 18.5 .1 L 15.6 3.6 L 13.1 6.4 L 16.3 6.4 L 20.3 6.0 L 23.7 5.3 L 26.8 4.5","0 16.6 M 12.2 -12.3 L 13.4 -12.5 L 17.5 -13.9 L 20.5 -14.4 L 23.0 -14.5 L 24.5 -14.2 L 25.3 -13.1 L 25.2 -11.4 L 24.2 -9.8 L 21.4 -7.4 L 17.9 -5.0 L 14.9 -3.4 L 18.8 -5.0 L 22.2 -5.5 L 24.4 -4.7 L 25.3 -3.4 L 25.2 -1.4 L 23.5 1.2 L 20.8 3.7 L 18.0 5.5 L 14.6 6.7 L 13.4 6.9","0 16.4 M 22.7 7.0 L 22.6 -9.9 L 22.3 -13.3 L 21.5 -14.4 L 19.3 -12.7 L 14.2 -6.2 L 12.2 -3.4 L 21.9 -3.8 L 26.1 -4.5","0 17.4 M 27.4 -14.2 L 23.2 -12.9 L 19.1 -11.8 L 16.3 -11.5 L 13.0 -11.2 L 13.2 -14.5 L 12.5 -3.5 L 14.7 -3.7 L 18.5 -4.4 L 22.1 -4.5 L 24.7 -4.2 L 26.6 -2.3 L 26.9 .1 L 26.3 2.2 L 23.9 4.1 L 20.8 5.5 L 17.3 6.3 L 12.6 6.7 L 12.6 5.8","0 21.3 M 22.9 -14.2 L 20.3 -13.4 L 17.9 -11.6 L 15.7 -9.0 L 14.1 -6.7 L 13.0 -3.6 L 12.9 -.4 L 13.4 1.9 L 15.2 4.4 L 17.8 6.1 L 19.7 6.7 L 21.9 6.8 L 24.8 6.5 L 27.9 4.9 L 30.0 2.4 L 30.6 .9 L 30.5 -.9 L 29.7 -2.1 L 28.0 -2.2 L 25.3 -1.1 L 22.5 1.1 L 20.7 2.6 L 19.1 4.2 L 18.0 5.5","0 18.0 M 12.1 -13.2 L 16.8 -13.3 L 22.4 -14.3 L 27.3 -14.8 L 25.5 -12.7 L 23.1 -8.0 L 21.2 -3.8 L 20.2 .4 L 19.7 2.8 L 19.5 5.5","0 20.9 M 21.6 -14.2 L 18.3 -12.7 L 16.4 -10.8 L 15.7 -8.5 L 16.1 -6.7 L 17.5 -5.5 L 19.4 -5.0 L 22.3 -5.9 L 24.1 -6.4 L 26.9 -6.7 L 29.6 -5.6 L 31.4 -3.0 L 31.2 -.1 L 29.1 3.1 L 26.3 5.3 L 23.1 6.5 L 19.2 6.7 L 16.2 6.1 L 13.8 3.8 L 13.4 1.5 L 14.2 -.6 L 15.9 -2.7 L 18.0 -4.5 L 19.3 -5.1 L 25.9 -6.7 L 28.4 -8.4 L 30.1 -9.8 L 30.3 -11.6 L 29.5 -13.1 L 28.3 -13.9 L 25.2 -14.6 L 21.6 -14.2","0 16.9 M 27.3 -7.4 L 23.4 -6.4 L 20.2 -5.9 L 16.9 -5.7 L 14.3 -6.2 L 12.8 -7.2 L 12.7 -8.8 L 13.6 -10.7 L 16.6 -13.0 L 19.8 -14.0 L 22.8 -14.3 L 24.7 -13.4 L 26.2 -11.9 L 27.2 -9.6 L 27.1 -5.7 L 26.3 -2.6 L 25.0 .5 L 23.1 3.6 L 20.9 5.5 L 19.1 6.4","0 5.1 M 12.8 -3.9 L 13.5 -3.8 M 14.2 3.3 L 14.8 3.3","0 2.9 M 12.0 -3.5 L 12.5 -3.5 M 12.7 5.1 L 11.9 8.8 L 11.3 10.5 L 10.6 11.8","0 16.0 M 23.7 -7.0 L 17.4 -2.0 L 15.2 -.1 L 17.5 1.7 L 21.4 3.3 L 22.9 3.9 L 24.1 4.5","0 15.8 M 13.2 -2.5 L 22.9 -3.7 M 13.4 2.0 L 19.6 1.1 L 23.6 .4","0 15.8 M 14.0 -6.3 L 17.5 -5.0 L 20.0 -3.9 L 23.6 -2.7 L 22.0 -1.2 L 19.5 .7 L 17.5 2.2 L 14.6 4.4","0 16.4 M 12.0 -13.5 L 15.2 -14.2 L 18.7 -14.6 L 21.2 -14.6 L 23.8 -13.8 L 25.5 -12.7 L 26.0 -11.3 L 25.8 -9.7 L 24.4 -8.3 L 22.6 -6.9 L 19.2 -4.6 L 15.8 -3.0 L 16.5 -2.2 L 18.5 -1.8 L 20.2 -1.8 M 19.2 6.4 L 20.0 6.4","0 36.1 M 31.8 -8.0 L 29.3 -8.4 L 25.3 -7.2 L 23.5 -5.4 L 23.0 -4.0 L 23.2 -2.4 L 24.6 -1.6 L 27.0 -2.3 L 29.5 -4.0 L 30.9 -5.3 L 31.8 -6.8 L 33.0 -5.0 L 34.7 -4.0 L 36.9 -4.3 L 38.7 -5.3 L 39.2 -6.5 L 39.0 -8.9 L 37.6 -11.4 L 35.6 -13.0 L 31.4 -14.6 L 26.5 -14.7 L 22.3 -13.5 L 19.2 -11.7 L 16.9 -9.6 L 15.0 -6.7 L 13.5 -3.7 L 13.0 -.1 L 14.3 3.3 L 17.4 5.5 L 21.3 6.6 L 25.3 7.1 L 30.0 6.7 L 35.2 5.8 L 39.4 4.5 L 42.7 2.7 L 45.1 .5","0 21.4 M 12.4 6.9 L 16.2 -3.1 L 18.6 -9.7 L 20.3 -14.3 L 20.8 -14.2 L 22.7 -11.1 L 25.5 -5.4 L 27.5 -.4 L 29.3 4.0 L 30.8 6.7 M 15.2 -.7 L 18.9 -1.5 L 23.2 -2.8 L 26.8 -3.5 L 30.2 -4.3","0 24.0 M 13.3 -13.8 L 13.4 -4.7 L 13.8 .9 L 14.5 6.8 L 19.6 6.4 L 25.0 5.2 L 29.3 3.5 L 32.3 1.6 L 32.8 -.3 L 32.1 -2.3 L 29.3 -3.9 L 26.3 -4.3 L 22.9 -4.7 L 19.0 -4.4 L 14.7 -4.0 L 20.8 -5.6 L 24.7 -7.3 L 27.4 -8.9 L 28.3 -10.5 L 28.1 -12.2 L 27.1 -13.0 L 24.6 -14.1 L 21.0 -14.7 L 17.4 -14.8 L 12.0 -14.5","0 23.7 M 27.4 -13.5 L 26.2 -14.6 L 23.2 -15.0 L 19.4 -13.8 L 16.0 -11.4 L 13.9 -8.4 L 12.8 -5.8 L 12.3 -2.9 L 12.2 .1 L 13.8 2.9 L 15.8 5.0 L 18.2 6.1 L 21.4 6.5 L 25.3 5.9 L 28.4 4.3 L 31.1 2.2 L 33.0 .6","0 21.7 M 12.9 -14.4 L 13.0 7.0 L 15.9 6.6 L 19.4 5.5 L 23.1 3.6 L 26.1 1.5 L 28.5 -.9 L 30.4 -3.7 L 31.0 -6.0 L 30.7 -8.6 L 28.6 -11.1 L 25.1 -13.0 L 21.7 -13.9 L 18.2 -14.1 L 15.6 -13.8 L 13.0 -13.2","0 19.7 M 26.1 -14.2 L 13.1 -13.8 L 13.0 -2.8 L 26.4 -4.3 L 13.1 -2.8 L 13.5 6.3 L 28.9 5.3","0 23.3 M 33.1 -14.0 L 26.2 -13.6 L 21.5 -12.8 L 17.2 -12.4 L 13.9 -11.7 L 13.3 -14.6 L 14.3 -9.8 L 15.2 -4.8 L 15.2 -2.0 L 13.2 -1.1 L 17.0 -2.6 L 24.3 -3.8 L 31.0 -4.9 L 16.9 -2.6 L 15.2 -1.8 L 15.1 6.7","0 23.7 M 26.4 -14.6 L 23.5 -14.3 L 20.4 -12.8 L 18.1 -10.8 L 16.3 -8.9 L 14.4 -5.5 L 13.1 -1.9 L 12.9 1.4 L 13.5 3.8 L 15.0 5.5 L 17.9 6.7 L 20.9 6.2 L 24.5 4.5 L 26.8 2.8 L 28.6 1.1 L 29.0 .3 L 29.2 -5.8 L 19.5 -4.1 L 32.6 -6.3 L 29.3 -5.7 L 29.3 8.4","0 19.1 M 13.9 -14.5 L 13.5 -3.9 L 13.5 1.0 L 14.2 7.0 L 13.6 -3.4 L 11.9 -2.8 L 16.0 -3.6 L 20.6 -4.1 L 26.4 -4.4 L 26.4 -14.4 L 26.3 -1.9 L 26.7 2.9 L 27.2 5.4 L 27.8 6.6","0 3.4 M 13.1 -14.3 L 13.0 -6.0 L 12.9 -1.8 L 13.0 1.8 L 13.0 6.3","0 17.4 M 25.9 -14.3 L 26.1 -2.8 L 25.9 1.5 L 25.2 4.2 L 24.2 5.6 L 22.2 6.4 L 19.8 6.3 L 17.5 5.9 L 14.8 5.0 L 13.0 3.6 L 11.8 2.4 L 11.6 1.5","0 19.2 M 13.5 -13.8 L 13.0 -6.4 L 12.9 -1.5 L 12.9 6.7 M 27.9 -14.1 L 22.6 -10.0 L 19.0 -7.3 L 15.3 -5.3 L 13.6 -4.0 L 13.0 -1.4 L 16.6 .0 L 21.3 2.1 L 24.8 3.8 L 27.6 5.6 L 28.9 6.4","0 19.6 M 13.7 -14.3 L 13.7 -14.1 L 13.8 -5.4 L 13.8 -.2 L 13.5 4.3 L 13.4 6.1 L 19.8 6.1 L 28.9 6.3","0 26.7 M 12.6 6.1 L 13.6 -4.0 L 14.4 -11.2 L 15.1 -14.0 L 15.7 -14.2 L 17.1 -13.2 L 19.5 -8.3 L 22.0 -3.5 L 24.2 1.0 L 25.6 -1.0 L 29.3 -7.9 L 32.6 -14.3 L 33.3 -13.8 L 34.0 -10.9 L 34.7 -6.0 L 35.5 -.8 L 36.3 6.6","0 20.8 M 12.8 6.1 L 13.1 -.7 L 13.2 -6.6 L 13.2 -12.9 L 13.7 -13.9 L 17.1 -10.2 L 21.1 -5.0 L 26.3 1.7 L 29.1 5.5 L 29.2 1.8 L 29.2 -5.4 L 29.1 -14.5","0 22.0 M 21.8 -14.5 L 19.2 -14.0 L 16.4 -12.2 L 14.2 -9.5 L 12.5 -6.0 L 12.3 -1.9 L 13.7 2.4 L 15.9 4.5 L 18.3 5.8 L 21.7 6.1 L 25.9 5.7 L 29.3 3.4 L 31.4 -.3 L 31.5 -4.1 L 31.0 -7.8 L 29.0 -10.9 L 27.8 -12.6 L 25.9 -13.7 L 23.6 -14.5 L 21.8 -14.5","0 21.5 M 13.6 6.1 L 13.6 .5 L 13.9 -7.3 L 14.1 -10.5 L 15.0 -12.7 L 17.8 -14.1 L 22.1 -14.8 L 26.4 -14.7 L 30.1 -13.3 L 31.2 -12.1 L 31.1 -9.7 L 29.8 -7.7 L 26.9 -5.9 L 23.3 -4.8 L 19.9 -4.3 L 13.8 -4.1","0 24.2 M 29.1 3.6 L 30.5 2.0 L 31.6 -1.4 L 32.0 -5.8 L 31.3 -9.6 L 28.9 -12.4 L 25.2 -14.2 L 21.8 -14.1 L 18.7 -12.8 L 16.6 -10.7 L 14.5 -7.7 L 13.4 -4.2 L 12.6 -.8 L 13.6 3.3 L 15.9 5.4 L 18.6 6.8 L 21.8 7.3 L 24.5 6.9 L 26.8 6.0 L 29.4 3.9 L 32.7 6.0 L 27.6 2.5 L 23.0 -1.7 L 22.4 -1.8","0 22.0 M 12.9 -14.1 L 13.2 -4.2 L 13.4 6.3 L 13.7 -6.4 L 13.1 -12.2 L 16.3 -14.1 L 20.1 -14.7 L 23.2 -14.3 L 25.6 -14.2 L 27.4 -13.8 L 28.5 -12.7 L 28.8 -11.4 L 27.2 -10.1 L 24.3 -9.0 L 21.6 -7.8 L 18.6 -6.8 L 13.6 -5.3 L 13.4 -4.5 L 17.1 -2.5 L 20.0 -.5 L 24.4 2.1 L 31.2 6.6 L 31.9 6.7","0 21.4 M 29.0 -14.1 L 24.9 -13.4 L 20.7 -12.3 L 16.9 -11.2 L 15.3 -9.9 L 14.5 -8.9 L 14.2 -8.0 L 15.0 -6.6 L 19.2 -5.2 L 23.1 -3.8 L 27.1 -2.2 L 29.3 -1.0 L 30.6 .1 L 30.5 1.2 L 28.8 3.2 L 24.9 5.2 L 20.3 6.7 L 16.9 6.9 L 14.5 6.6 L 13.1 5.9 L 12.6 4.9","0 20.7 M 11.4 -14.3 L 17.5 -14.0 L 22.9 -13.7 L 28.2 -13.7 L 30.7 -14.3 M 19.5 -13.7 L 18.8 -3.7 L 18.5 1.6 L 18.5 6.1","0 18.4 M 13.7 -13.8 L 12.5 -7.0 L 11.9 -1.8 L 11.9 1.5 L 13.1 4.3 L 14.6 6.0 L 18.2 6.3 L 21.7 4.7 L 24.5 2.1 L 26.2 -2.7 L 27.0 -6.9 L 26.8 -14.0 L 26.8 6.2","0 20.1 M 11.7 -14.0 L 20.6 5.6 L 21.8 5.8 L 25.7 -4.1 L 30.2 -14.3","0 32.3 M 12.5 -14.3 L 20.8 6.0 L 23.3 .3 L 28.0 -10.5 L 29.3 -9.2 L 31.5 -5.7 L 35.0 1.4 L 37.4 5.9 L 39.0 1.4 L 40.4 -4.7 L 42.0 -14.0","0 20.3 M 12.3 -14.2 L 18.0 -6.4 L 25.2 1.1 L 30.1 5.6 M 29.6 -14.7 L 22.3 -5.4 L 17.3 .6 L 13.2 5.9 L 12.9 6.0","0 17.0 M 12.5 -14.3 L 14.7 -12.3 L 17.7 -8.9 L 22.2 -4.0 L 26.0 -14.3 L 27.0 -15.2 L 26.1 -14.3 L 21.8 -2.5 L 19.0 6.4","0 20.9 M 12.9 -14.2 L 30.7 -14.3 L 28.1 -10.3 L 21.2 -2.0 L 15.1 5.2 L 14.5 5.9 L 17.7 6.7 L 21.2 6.8 L 31.5 6.2","0 14.3 M 20.9 -19.9 L 12.9 -18.0 L 13.4 -3.4 L 14.4 9.0 L 22.9 7.7","0 16.4 M 11.7 -11.7 L 17.8 -3.0 L 22.2 2.8 L 25.6 6.6","0 18.3 M 12.2 -17.3 L 16.9 -18.2 L 22.4 -18.9 L 24.2 -19.1 L 24.5 -9.2 L 24.8 -2.4 L 25.1 5.2 L 25.3 8.6 L 22.2 9.3 L 18.5 9.7 L 15.5 9.9","0 9.3 M 12.3 -3.8 L 13.1 -5.4 L 15.9 -7.4 L 17.7 -6.3 L 19.8 -4.0","0 23.5 M 13.5 6.9 L 18.7 6.0 L 24.2 5.6 L 32.2 4.9","0 4.5 M 12.3 -12.2 L 14.4 -10.5","0 16.9 M 26.0 -1.8 L 24.2 2.2 L 21.3 4.9 L 19.2 6.1 L 17.2 6.8 L 14.4 6.5 L 12.9 5.5 L 12.5 2.4 L 14.0 -.7 L 16.0 -3.7 L 19.2 -5.9 L 21.6 -7.0 L 23.4 -7.0 L 25.6 -6.6 L 26.0 -5.1 L 26.4 6.9","0 18.7 M 13.6 -14.3 L 13.8 5.7 L 15.3 6.3 L 17.9 5.8 L 21.8 4.2 L 26.6 .4 L 28.5 -2.9 L 29.2 -5.5 L 28.6 -6.9 L 27.1 -7.5 L 23.6 -7.2 L 20.5 -5.1 L 17.1 -2.7 L 14.0 1.7","0 19.1 M 26.0 -6.2 L 25.0 -7.1 L 22.0 -7.4 L 18.8 -6.2 L 16.1 -4.2 L 13.2 -.4 L 12.3 3.6 L 14.2 5.9 L 18.1 7.1 L 22.3 6.9 L 25.3 6.2 L 28.5 4.5","0 17.7 M 26.6 -13.7 L 26.1 -5.3 L 25.9 .1 L 26.1 4.5 L 26.2 6.4 L 26.0 1.2 L 23.1 4.3 L 18.4 6.4 L 15.1 6.6 L 12.8 5.3 L 12.1 1.9 L 13.8 -1.4 L 17.9 -4.2 L 21.6 -4.8 L 24.4 -4.4 L 26.2 -2.5","0 16.9 M 13.4 -2.4 L 17.4 -2.5 L 22.0 -2.6 L 25.0 -3.1 L 25.5 -4.2 L 25.1 -5.3 L 22.5 -7.6 L 19.2 -7.6 L 16.2 -6.5 L 14.1 -4.6 L 12.6 -.7 L 12.1 1.6 L 12.0 3.2 L 13.7 5.4 L 16.5 6.8 L 19.7 6.6 L 23.1 5.8 L 25.5 4.6 L 26.4 3.5","0 19.1 M 28.4 -10.2 L 25.6 -13.2 L 22.3 -14.7 L 20.1 -14.9 L 17.5 -13.2 L 16.3 -10.5 L 16.3 -7.6 L 16.8 -4.9 L 17.9 1.2 L 18.3 6.2 L 17.5 -1.1 L 11.6 -.2 L 22.8 -1.7 L 28.0 -2.4","0 17.5 M 26.6 -1.3 L 24.5 2.3 L 20.7 5.3 L 16.6 6.8 L 13.7 6.8 L 12.8 5.3 L 14.0 1.5 L 17.0 -3.0 L 20.4 -5.8 L 22.6 -6.9 L 24.8 -6.6 L 26.6 -5.2 L 27.1 9.0 L 26.7 13.8 L 25.6 16.8 L 24.2 18.8 L 22.9 19.9 L 21.2 20.2 L 19.9 20.3 L 16.3 20.2","0 16.4 M 13.4 -14.2 L 13.1 -4.3 L 13.4 6.8 L 14.2 -1.6 L 16.7 -4.8 L 19.6 -6.6 L 22.2 -6.5 L 24.0 -5.0 L 25.8 -1.6 L 26.1 1.7 L 26.2 6.1","0 8.0 M 14.7 -13.2 L 15.3 -13.2 M 15.5 -7.2 L 15.8 5.6 L 16.4 6.2","0 5.3 M 11.3 -13.1 L 11.8 -13.8 M 12.0 -8.6 L 12.0 -2.9 L 12.4 3.7 L 12.7 13.2 L 12.4 16.9 L 11.4 18.4 L 10.2 18.8 L 9.3 18.8 L 6.7 18.2 L 5.1 16.9","0 15.9 M 11.9 -14.4 L 12.5 -2.3 L 12.5 6.6 L 12.7 -.8 L 15.5 -3.2 L 22.7 -8.0 L 13.0 -1.2 L 16.8 1.6 L 25.4 6.3","0 6.4 M 14.3 -14.9 L 14.6 -.9 L 14.8 5.7","0 26.9 M 12.9 -7.7 L 13.1 6.9 L 14.3 -3.1 L 16.3 -6.1 L 19.8 -7.6 L 21.9 -7.7 L 23.3 -6.8 L 24.4 -4.1 L 24.0 6.9 L 25.1 -3.3 L 27.5 -6.0 L 30.9 -7.6 L 33.8 -7.6 L 35.6 -6.8 L 36.0 -4.3 L 36.1 .4 L 36.3 6.6","0 15.4 M 11.9 -7.3 L 12.0 6.4 L 11.9 -3.3 L 15.6 -5.7 L 19.2 -7.4 L 21.5 -7.6 L 23.2 -7.4 L 24.3 -6.2 L 25.1 -2.7 L 25.0 6.7","0 17.6 M 20.0 -7.9 L 16.0 -6.1 L 13.9 -3.1 L 12.5 -.1 L 13.2 3.9 L 14.5 6.1 L 18.7 6.8 L 22.2 5.9 L 25.8 3.6 L 27.8 -.1 L 27.1 -4.7 L 25.5 -6.5 L 23.7 -7.6 L 20.0 -7.9","0 16.4 M 12.4 -7.0 L 12.6 19.0 L 12.5 -5.0 L 16.1 -7.0 L 20.2 -7.9 L 24.8 -7.2 L 26.3 -5.0 L 26.0 -1.6 L 24.6 .7 L 21.7 3.2 L 18.7 4.7 L 12.7 6.2","0 16.4 M 25.7 -5.9 L 24.8 -7.4 L 22.6 -7.7 L 18.6 -6.1 L 15.7 -3.4 L 13.7 -.2 L 12.7 2.7 L 13.0 5.4 L 15.6 6.9 L 18.5 6.7 L 21.9 5.2 L 23.7 3.4 L 24.9 1.3 L 25.8 -4.2 L 26.3 19.9","0 16.6 M 13.1 -7.9 L 12.7 6.5 L 13.7 -1.6 L 16.1 -4.7 L 19.2 -6.5 L 21.7 -7.5 L 22.8 -7.6 L 26.1 -7.3 L 26.5 -7.0","0 14.8 M 24.9 -6.6 L 23.9 -7.6 L 20.9 -7.6 L 17.5 -6.9 L 14.4 -5.3 L 13.1 -3.2 L 13.1 -.9 L 14.4 .1 L 17.3 .1 L 20.4 -.5 L 22.4 -.4 L 24.0 .2 L 25.0 1.1 L 24.7 2.6 L 21.6 5.0 L 17.6 6.1 L 15.3 7.0 L 14.3 6.9","0 13.3 M 17.8 -14.3 L 18.3 6.8 L 18.0 -5.0 L 11.9 -5.0 L 23.3 -5.1","0 15.9 M 13.3 -7.6 L 12.5 -3.0 L 12.2 2.3 L 13.4 5.4 L 15.9 6.7 L 20.1 6.4 L 22.5 4.9 L 23.8 4.3 L 25.1 2.5 L 26.0 .6 L 25.3 -8.0 L 26.3 6.6","0 17.1 M 12.9 -7.8 L 19.7 5.2 L 20.5 6.5 L 22.5 1.7 L 26.8 -7.3","0 24.6 M 12.5 -7.6 L 14.7 -.5 L 16.9 3.9 L 18.4 6.2 L 19.0 5.8 L 21.8 -2.9 L 22.3 -4.8 L 23.6 -3.9 L 28.7 5.5 L 30.0 6.3 L 34.6 -7.5","0 15.4 M 12.3 -7.2 L 19.2 .2 L 25.6 6.6 L 19.0 .2 L 24.4 -7.2 L 19.2 .3 L 15.2 4.8 L 13.0 6.9","0 18.7 M 12.6 -6.5 L 22.9 8.2 L 28.6 -6.8 L 18.2 20.5","0 16.0 M 12.8 -7.4 L 13.2 -7.4 L 25.5 -7.3 L 26.1 -6.8 L 22.9 -3.2 L 17.1 2.0 L 13.6 5.4 L 13.3 6.4 L 16.6 6.4 L 25.9 6.4 L 26.7 6.7","0 11.1 M 22.3 -19.1 L 20.7 -19.0 L 18.9 -18.0 L 17.9 -16.2 L 17.6 -13.8 L 17.8 -9.7 L 17.6 -9.1 L 15.0 -6.9 L 14.1 -5.8 L 14.0 -4.5 L 14.6 -3.1 L 17.1 -1.2 L 18.5 .0 L 18.6 4.0 L 19.2 7.4 L 20.6 9.2 L 22.2 10.1 L 23.7 10.3","0 4.4 M 13.4 -15.7 L 13.7 8.2","0 13.1 M 13.9 -19.1 L 16.4 -18.5 L 18.0 -16.9 L 18.5 -12.7 L 18.1 -8.8 L 20.7 -7.2 L 22.5 -5.7 L 22.9 -4.3 L 21.9 -3.5 L 18.0 -.5 L 18.1 2.6 L 17.8 6.2 L 16.6 8.3 L 15.1 9.4 L 12.5 10.2","0 14.3 M 12.5 -2.0 L 13.7 -3.9 L 15.1 -4.9 L 16.2 -4.9 L 17.9 -3.7 L 20.0 -2.0 L 21.6 -2.3 L 22.9 -2.8 L 24.6 -5.3","0 6.7 M 13.1 -6.6 L 11.9 -5.0 L 12.5 -2.3 L 14.7 -1.3 L 16.7 -1.9 L 17.8 -3.7 L 16.5 -6.5 L 15.4 -7.2 L 13.1 -6.6"]
futuram = ["-8 8","-5 6 M 0 -12 L 0 2 L 1 2 M 0 -12 L 1 -12 L 1 2 M 0 6 L -1 7 L -1 8 L 0 9 L 1 9 L 2 8 L 2 7 L 1 6 L 0 6 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7","-9 9 M -4 -12 L -5 -11 L -5 -5 M -4 -11 L -5 -5 M -4 -12 L -3 -11 L -5 -5 M 5 -12 L 4 -11 L 4 -5 M 5 -11 L 4 -5 M 5 -12 L 6 -11 L 4 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-9 10 M 0 -16 L 0 13 L 1 13 M 0 -16 L 1 -16 L 1 13 M 5 -9 L 7 -9 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -9 L -6 -7 L -5 -5 L -4 -4 L 4 0 L 5 1 L 6 3 L 6 5 L 5 7 L 2 8 L -1 8 L -3 7 L -4 6 M 5 -9 L 4 -10 L 2 -11 L -1 -11 L -4 -10 L -5 -9 L -5 -7 L -4 -5 L 4 -1 L 6 1 L 7 3 L 7 5 L 6 7 L 5 8 L 2 9 L -1 9 L -4 8 L -6 6 L -4 6 M 6 6 L 3 8","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-12 13 M 9 -4 L 8 -3 L 9 -2 L 10 -3 L 10 -4 L 9 -5 L 8 -5 L 7 -4 L 6 -2 L 4 3 L 2 6 L 0 8 L -2 9 L -5 9 L -8 8 L -9 6 L -9 3 L -8 1 L -2 -3 L 0 -5 L 1 -7 L 1 -9 L 0 -11 L -2 -12 L -4 -11 L -5 -9 L -5 -7 L -4 -4 L -2 -1 L 3 6 L 5 8 L 8 9 L 9 9 L 10 8 L 10 7 M -5 9 L -7 8 L -8 6 L -8 3 L -7 1 L -5 -1 M -5 -7 L -4 -5 L 4 6 L 6 8 L 8 9","-4 5 M 1 -12 L 0 -11 L 0 -5 M 1 -11 L 0 -5 M 1 -12 L 2 -11 L 0 -5","-7 7 M 4 -16 L 2 -14 L 0 -11 L -2 -7 L -3 -2 L -3 2 L -2 7 L 0 11 L 2 14 L 4 16 M 2 -14 L 0 -10 L -1 -7 L -2 -2 L -2 2 L -1 7 L 0 10 L 2 14","-7 7 M -4 -16 L -2 -14 L 0 -11 L 2 -7 L 3 -2 L 3 2 L 2 7 L 0 11 L -2 14 L -4 16 M -2 -14 L 0 -10 L 1 -7 L 2 -2 L 2 2 L 1 7 L 0 10 L -2 14","-8 8 M 0 -12 L -1 -11 L 1 -1 L 0 0 M 0 -12 L 0 0 M 0 -12 L 1 -11 L -1 -1 L 0 0 M -5 -9 L -4 -9 L 4 -3 L 5 -3 M -5 -9 L 5 -3 M -5 -9 L -5 -8 L 5 -4 L 5 -3 M 5 -9 L 4 -9 L -4 -3 L -5 -3 M 5 -9 L -5 -3 M 5 -9 L 5 -8 L -5 -4 L -5 -3","-12 13 M 0 -9 L 0 8 L 1 8 M 0 -9 L 1 -9 L 1 8 M -8 -1 L 9 -1 L 9 0 M -8 -1 L -8 0 L 9 0","-5 6 M 2 8 L 1 9 L 0 9 L -1 8 L -1 7 L 0 6 L 1 6 L 2 7 L 2 10 L 1 12 L -1 13 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7 M 1 9 L 2 10 M 2 8 L 1 12","-13 13 M -9 0 L 9 0","-5 6 M 0 6 L -1 7 L -1 8 L 0 9 L 1 9 L 2 8 L 2 7 L 1 6 L 0 6 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7","-11 12 M 9 -16 L -9 16 L -8 16 M 9 -16 L 10 -16 L -8 16","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12 M -3 -11 L -5 -8 L -6 -3 L -6 0 L -5 5 L -3 8 M -4 7 L -1 8 L 1 8 L 4 7 M 3 8 L 5 5 L 6 0 L 6 -3 L 5 -8 L 3 -11 M 4 -10 L 1 -11 L -1 -11 L -4 -10","-10 10 M -4 -8 L -2 -9 L 1 -12 L 1 9 M -4 -8 L -4 -7 L -2 -8 L 0 -10 L 0 9 L 1 9","-10 10 M -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 3 -1 L -6 9 M -6 -7 L -5 -7 L -5 -8 L -4 -10 L -2 -11 L 2 -11 L 4 -10 L 5 -8 L 5 -6 L 4 -4 L 2 -1 L -7 9 M -6 8 L 7 8 L 7 9 M -7 9 L 7 9","-10 10 M -5 -12 L 6 -12 L -1 -3 M -5 -12 L -5 -11 L 5 -11 M 5 -12 L -2 -3 M -1 -4 L 1 -4 L 4 -3 L 6 -1 L 7 2 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5 L -6 5 M -2 -3 L 1 -3 L 4 -2 L 6 1 M 2 -3 L 5 -1 L 6 2 L 6 3 L 5 6 L 2 8 M 6 4 L 4 7 L 1 8 L -2 8 L -5 7 L -6 5 M -3 8 L -6 6","-10 10 M 3 -9 L 3 9 L 4 9 M 4 -12 L 4 9 M 4 -12 L -7 4 L 8 4 M 3 -9 L -6 4 M -6 3 L 8 3 L 8 4","-10 10 M -5 -12 L -6 -3 M -4 -11 L -5 -4 M -5 -12 L 5 -12 L 5 -11 M -4 -11 L 5 -11 M -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5 L -6 5 M -6 -3 L -5 -3 L -3 -4 L 1 -4 L 4 -3 L 6 0 M 2 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 2 8 M 6 4 L 4 7 L 1 8 L -2 8 L -5 7 L -6 5 M -3 8 L -6 6","-10 10 M 4 -11 L 5 -9 L 6 -9 L 5 -11 L 2 -12 L 0 -12 L -3 -11 L -5 -8 L -6 -3 L -6 2 L -5 6 L -3 8 L 0 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 L -3 -3 L -5 -1 M 5 -10 L 2 -11 L 0 -11 L -3 -10 M -2 -11 L -4 -8 L -5 -3 L -5 2 L -4 6 L -1 8 M -5 4 L -3 7 L 0 8 L 1 8 L 4 7 L 6 4 M 2 8 L 5 6 L 6 3 L 6 2 L 5 -1 L 2 -3 M 6 1 L 4 -2 L 1 -3 L 0 -3 L -3 -2 L -5 1 M -1 -3 L -4 -1 L -5 2","-10 10 M -7 -12 L 7 -12 L -3 9 M -7 -12 L -7 -11 L 6 -11 M 6 -12 L -4 9 L -3 9","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -7 L -5 -5 L -4 -4 L -2 -3 L 2 -2 L 4 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 2 8 L -2 8 L -5 7 L -6 5 L -6 2 L -5 0 L -4 -1 L -2 -2 L 2 -3 L 4 -4 L 5 -5 L 6 -7 L 6 -9 L 5 -11 L 2 -12 L -2 -12 M -4 -11 L -5 -9 L -5 -7 L -4 -5 L -2 -4 L 2 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 2 L -6 0 L -4 -2 L -2 -3 L 2 -4 L 4 -5 L 5 -7 L 5 -9 L 4 -11 M 5 -10 L 2 -11 L -2 -11 L -5 -10 M -6 6 L -3 8 M 3 8 L 6 6","-10 10 M 5 -2 L 3 0 L 0 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 0 -12 L 3 -11 L 5 -9 L 6 -5 L 6 0 L 5 5 L 3 8 L 0 9 L -2 9 L -5 8 L -6 6 L -5 6 L -4 8 M 5 -5 L 4 -2 L 1 0 M 5 -4 L 3 -1 L 0 0 L -1 0 L -4 -1 L -6 -4 M -2 0 L -5 -2 L -6 -5 L -6 -6 L -5 -9 L -2 -11 M -6 -7 L -4 -10 L -1 -11 L 0 -11 L 3 -10 L 5 -7 M 1 -11 L 4 -9 L 5 -5 L 5 0 L 4 5 L 2 8 M 3 7 L 0 8 L -2 8 L -5 7","-5 6 M 0 -5 L -1 -4 L -1 -3 L 0 -2 L 1 -2 L 2 -3 L 2 -4 L 1 -5 L 0 -5 M 0 -4 L 0 -3 L 1 -3 L 1 -4 L 0 -4 M 0 6 L -1 7 L -1 8 L 0 9 L 1 9 L 2 8 L 2 7 L 1 6 L 0 6 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7","-5 6 M 0 -5 L -1 -4 L -1 -3 L 0 -2 L 1 -2 L 2 -3 L 2 -4 L 1 -5 L 0 -5 M 0 -4 L 0 -3 L 1 -3 L 1 -4 L 0 -4 M 2 8 L 1 9 L 0 9 L -1 8 L -1 7 L 0 6 L 1 6 L 2 7 L 2 10 L 1 12 L -1 13 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7 M 1 9 L 2 10 M 2 8 L 1 12","-12 12 M 8 -9 L -8 0 L 8 9","-12 13 M -8 -5 L 9 -5 L 9 -4 M -8 -5 L -8 -4 L 9 -4 M -8 3 L 9 3 L 9 4 M -8 3 L -8 4 L 9 4","-12 12 M -8 -9 L 8 0 L -8 9","-9 10 M -6 -7 L -6 -8 L -5 -10 L -4 -11 L -1 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 3 -2 L 0 -1 M -6 -7 L -5 -7 L -5 -8 L -4 -10 L -1 -11 L 2 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 3 -3 L 0 -2 M -5 -9 L -2 -11 M 3 -11 L 6 -9 M 6 -5 L 2 -2 M 0 -2 L 0 2 L 1 2 L 1 -2 M 0 6 L -1 7 L -1 8 L 0 9 L 1 9 L 2 8 L 2 7 L 1 6 L 0 6 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-10 10 M 0 -12 L -8 9 M 0 -9 L -7 9 L -8 9 M 0 -9 L 7 9 L 8 9 M 0 -12 L 8 9 M -5 3 L 5 3 M -6 4 L 6 4","-10 10 M -6 -12 L -6 9 M -5 -11 L -5 8 M -6 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -5 L 6 -3 L 5 -2 L 2 -1 M -5 -11 L 2 -11 L 5 -10 L 6 -8 L 6 -5 L 5 -3 L 2 -2 M -5 -2 L 2 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -6 9 M -5 -1 L 2 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 2 8 L -5 8","-10 11 M 8 -7 L 7 -9 L 5 -11 L 3 -12 L -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 L -3 8 L -1 9 L 3 9 L 5 8 L 7 6 L 8 4 M 8 -7 L 7 -7 L 6 -9 L 5 -10 L 3 -11 L -1 -11 L -3 -10 L -5 -7 L -6 -4 L -6 1 L -5 4 L -3 7 L -1 8 L 3 8 L 5 7 L 6 6 L 7 4 L 8 4","-10 11 M -6 -12 L -6 9 M -5 -11 L -5 8 M -6 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -7 L 8 -4 L 8 1 L 7 4 L 6 6 L 4 8 L 1 9 L -6 9 M -5 -11 L 1 -11 L 4 -10 L 5 -9 L 6 -7 L 7 -4 L 7 1 L 6 4 L 5 6 L 4 7 L 1 8 L -5 8","-9 10 M -5 -12 L -5 9 M -4 -11 L -4 8 M -5 -12 L 7 -12 M -4 -11 L 7 -11 L 7 -12 M -4 -2 L 2 -2 L 2 -1 M -4 -1 L 2 -1 M -4 8 L 7 8 L 7 9 M -5 9 L 7 9","-9 9 M -5 -12 L -5 9 M -4 -11 L -4 9 L -5 9 M -5 -12 L 7 -12 M -4 -11 L 7 -11 L 7 -12 M -4 -2 L 2 -2 L 2 -1 M -4 -1 L 2 -1","-10 11 M 8 -7 L 7 -9 L 5 -11 L 3 -12 L -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 L -3 8 L -1 9 L 3 9 L 5 8 L 7 6 L 8 4 L 8 0 L 3 0 M 8 -7 L 7 -7 L 6 -9 L 5 -10 L 3 -11 L -1 -11 L -3 -10 L -4 -9 L -5 -7 L -6 -4 L -6 1 L -5 4 L -4 6 L -3 7 L -1 8 L 3 8 L 5 7 L 6 6 L 7 4 L 7 1 L 3 1 L 3 0","-11 11 M -7 -12 L -7 9 M -7 -12 L -6 -12 L -6 9 L -7 9 M 7 -12 L 6 -12 L 6 9 L 7 9 M 7 -12 L 7 9 M -6 -2 L 6 -2 M -6 -1 L 6 -1","-4 5 M 0 -12 L 0 9 L 1 9 M 0 -12 L 1 -12 L 1 9","-8 9 M 4 -12 L 4 4 L 3 7 L 1 8 L -1 8 L -3 7 L -4 4 L -5 4 M 4 -12 L 5 -12 L 5 4 L 4 7 L 3 8 L 1 9 L -1 9 L -3 8 L -4 7 L -5 4","-10 11 M -6 -12 L -6 9 L -5 9 M -6 -12 L -5 -12 L -5 9 M 8 -12 L 7 -12 L -5 0 M 8 -12 L -5 1 M -2 -3 L 7 9 L 8 9 M -1 -3 L 8 9","-9 8 M -5 -12 L -5 9 M -5 -12 L -4 -12 L -4 8 M -4 8 L 7 8 L 7 9 M -5 9 L 7 9","-12 12 M -8 -12 L -8 9 M -7 -7 L -7 9 L -8 9 M -7 -7 L 0 9 M -8 -12 L 0 6 M 8 -12 L 0 6 M 7 -7 L 0 9 M 7 -7 L 7 9 L 8 9 M 8 -12 L 8 9","-11 11 M -7 -12 L -7 9 M -6 -9 L -6 9 L -7 9 M -6 -9 L 7 9 M -7 -12 L 6 6 M 6 -12 L 6 6 M 6 -12 L 7 -12 L 7 9","-11 11 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -2 9 L 2 9 L 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11 L 2 -12 L -2 -12 M -1 -11 L -4 -10 L -6 -7 L -7 -4 L -7 1 L -6 4 L -4 7 L -1 8 L 1 8 L 4 7 L 6 4 L 7 1 L 7 -4 L 6 -7 L 4 -10 L 1 -11 L -1 -11","-10 10 M -6 -12 L -6 9 M -5 -11 L -5 9 L -6 9 M -6 -12 L 3 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -5 L 6 -3 L 5 -2 L 3 -1 L -5 -1 M -5 -11 L 3 -11 L 5 -10 L 6 -8 L 6 -5 L 5 -3 L 3 -2 L -5 -2","-11 11 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -2 9 L 2 9 L 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11 L 2 -12 L -2 -12 M -1 -11 L -4 -10 L -6 -7 L -7 -4 L -7 1 L -6 4 L -4 7 L -1 8 L 1 8 L 4 7 L 6 4 L 7 1 L 7 -4 L 6 -7 L 4 -10 L 1 -11 L -1 -11 M 1 6 L 6 11 L 7 11 M 1 6 L 2 6 L 7 11","-10 10 M -6 -12 L -6 9 M -5 -11 L -5 9 L -6 9 M -6 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -5 L 6 -3 L 5 -2 L 2 -1 L -5 -1 M -5 -11 L 2 -11 L 5 -10 L 6 -8 L 6 -5 L 5 -3 L 2 -2 L -5 -2 M 0 -1 L 6 9 L 7 9 M 1 -1 L 7 9","-10 10 M 7 -9 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 2 -1 L 4 0 L 5 1 L 6 3 L 6 6 L 5 7 L 2 8 L -2 8 L -4 7 L -5 6 L -7 6 M 7 -9 L 5 -9 L 4 -10 L 2 -11 L -2 -11 L -5 -10 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 2 -2 L 4 -1 L 6 1 L 7 3 L 7 6 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6","-8 9 M 0 -11 L 0 9 M 1 -11 L 1 9 L 0 9 M -6 -12 L 7 -12 L 7 -11 M -6 -12 L -6 -11 L 7 -11","-11 11 M -7 -12 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 -12 M -7 -12 L -6 -12 L -6 3 L -5 6 L -4 7 L -1 8 L 1 8 L 4 7 L 5 6 L 6 3 L 6 -12 L 7 -12","-10 10 M -8 -12 L 0 9 M -8 -12 L -7 -12 L 0 6 M 8 -12 L 7 -12 L 0 6 M 8 -12 L 0 9","-13 13 M -11 -12 L -5 9 M -11 -12 L -10 -12 L -5 6 M 0 -12 L -5 6 M 0 -9 L -5 9 M 0 -9 L 5 9 M 0 -12 L 5 6 M 11 -12 L 10 -12 L 5 6 M 11 -12 L 5 9","-10 10 M -7 -12 L 6 9 L 7 9 M -7 -12 L -6 -12 L 7 9 M 7 -12 L 6 -12 L -7 9 M 7 -12 L -6 9 L -7 9","-9 10 M -7 -12 L 0 -2 L 0 9 L 1 9 M -7 -12 L -6 -12 L 1 -2 M 8 -12 L 7 -12 L 0 -2 M 8 -12 L 1 -2 L 1 9","-10 10 M 6 -12 L -7 9 M 7 -12 L -6 9 M -7 -12 L 7 -12 M -7 -12 L -7 -11 L 6 -11 M -6 8 L 7 8 L 7 9 M -7 9 L 7 9","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-11 11 M -8 2 L 0 -3 L 8 2 M -8 2 L 0 -2 L 8 2","-10 10 M -10 16 L 10 16","-6 6 M -2 -12 L 3 -6 M -2 -12 L -3 -11 L 3 -6","-10 10 M 5 -5 L 5 9 L 6 9 M 5 -5 L 6 -5 L 6 9 M 5 -2 L 3 -4 L 1 -5 L -2 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -2 9 L 1 9 L 3 8 L 5 6 M 5 -2 L 1 -4 L -2 -4 L -4 -3 L -5 -2 L -6 1 L -6 3 L -5 6 L -4 7 L -2 8 L 1 8 L 5 6","-10 10 M -6 -12 L -6 9 L -5 9 M -6 -12 L -5 -12 L -5 9 M -5 -2 L -3 -4 L -1 -5 L 2 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 2 9 L -1 9 L -3 8 L -5 6 M -5 -2 L -1 -4 L 2 -4 L 4 -3 L 5 -2 L 6 1 L 6 3 L 5 6 L 4 7 L 2 8 L -1 8 L -5 6","-9 9 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6 M 6 -2 L 5 -1 L 4 -3 L 2 -4 L -1 -4 L -3 -3 L -4 -2 L -5 1 L -5 3 L -4 6 L -3 7 L -1 8 L 2 8 L 4 7 L 5 5 L 6 6","-10 10 M 5 -12 L 5 9 L 6 9 M 5 -12 L 6 -12 L 6 9 M 5 -2 L 3 -4 L 1 -5 L -2 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -2 9 L 1 9 L 3 8 L 5 6 M 5 -2 L 1 -4 L -2 -4 L -4 -3 L -5 -2 L -6 1 L -6 3 L -5 6 L -4 7 L -2 8 L 1 8 L 5 6","-9 9 M -5 2 L 6 2 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6 M -5 1 L 5 1 L 5 -1 L 4 -3 L 2 -4 L -1 -4 L -3 -3 L -4 -2 L -5 1 L -5 3 L -4 6 L -3 7 L -1 8 L 2 8 L 4 7 L 5 5 L 6 6","-6 8 M 5 -12 L 3 -12 L 1 -11 L 0 -8 L 0 9 L 1 9 M 5 -12 L 5 -11 L 3 -11 L 1 -10 M 2 -11 L 1 -8 L 1 9 M -3 -5 L 4 -5 L 4 -4 M -3 -5 L -3 -4 L 4 -4","-10 10 M 6 -5 L 5 -5 L 5 10 L 4 13 L 3 14 L 1 15 L -1 15 L -3 14 L -4 13 L -6 13 M 6 -5 L 6 10 L 5 13 L 3 15 L 1 16 L -2 16 L -4 15 L -6 13 M 5 -2 L 3 -4 L 1 -5 L -2 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -2 9 L 1 9 L 3 8 L 5 6 M 5 -2 L 1 -4 L -2 -4 L -4 -3 L -5 -2 L -6 1 L -6 3 L -5 6 L -4 7 L -2 8 L 1 8 L 5 6","-10 10 M -6 -12 L -6 9 L -5 9 M -6 -12 L -5 -12 L -5 9 M -5 -1 L -2 -4 L 0 -5 L 3 -5 L 5 -4 L 6 -1 L 6 9 M -5 -1 L -2 -3 L 0 -4 L 2 -4 L 4 -3 L 5 -1 L 5 9 L 6 9","-4 5 M 0 -12 L -1 -11 L -1 -10 L 0 -9 L 1 -9 L 2 -10 L 2 -11 L 1 -12 L 0 -12 M 0 -11 L 0 -10 L 1 -10 L 1 -11 L 0 -11 M 0 -5 L 0 9 L 1 9 M 0 -5 L 1 -5 L 1 9","-4 5 M 0 -12 L -1 -11 L -1 -10 L 0 -9 L 1 -9 L 2 -10 L 2 -11 L 1 -12 L 0 -12 M 0 -11 L 0 -10 L 1 -10 L 1 -11 L 0 -11 M 0 -5 L 0 16 L 1 16 M 0 -5 L 1 -5 L 1 16","-10 9 M -6 -12 L -6 9 L -5 9 M -6 -12 L -5 -12 L -5 9 M 6 -5 L 5 -5 L -5 5 M 6 -5 L -5 6 M -2 2 L 4 9 L 6 9 M -1 1 L 6 9","-4 5 M 0 -12 L 0 9 L 1 9 M 0 -12 L 1 -12 L 1 9","-15 16 M -11 -5 L -11 9 L -10 9 M -11 -5 L -10 -5 L -10 9 M -10 -1 L -7 -4 L -5 -5 L -2 -5 L 0 -4 L 1 -1 L 1 9 M -10 -1 L -7 -3 L -5 -4 L -3 -4 L -1 -3 L 0 -1 L 0 9 L 1 9 M 1 -1 L 4 -4 L 6 -5 L 9 -5 L 11 -4 L 12 -1 L 12 9 M 1 -1 L 4 -3 L 6 -4 L 8 -4 L 10 -3 L 11 -1 L 11 9 L 12 9","-10 10 M -6 -5 L -6 9 L -5 9 M -6 -5 L -5 -5 L -5 9 M -5 -1 L -2 -4 L 0 -5 L 3 -5 L 5 -4 L 6 -1 L 6 9 M -5 -1 L -2 -3 L 0 -4 L 2 -4 L 4 -3 L 5 -1 L 5 9 L 6 9","-9 10 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6 L 7 3 L 7 1 L 6 -2 L 4 -4 L 2 -5 L -1 -5 M -1 -4 L -3 -3 L -4 -2 L -5 1 L -5 3 L -4 6 L -3 7 L -1 8 L 2 8 L 4 7 L 5 6 L 6 3 L 6 1 L 5 -2 L 4 -3 L 2 -4 L -1 -4","-10 10 M -6 -5 L -6 16 L -5 16 M -6 -5 L -5 -5 L -5 16 M -5 -2 L -3 -4 L -1 -5 L 2 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 2 9 L -1 9 L -3 8 L -5 6 M -5 -2 L -1 -4 L 2 -4 L 4 -3 L 5 -2 L 6 1 L 6 3 L 5 6 L 4 7 L 2 8 L -1 8 L -5 6","-10 10 M 5 -5 L 5 16 L 6 16 M 5 -5 L 6 -5 L 6 16 M 5 -2 L 3 -4 L 1 -5 L -2 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -2 9 L 1 9 L 3 8 L 5 6 M 5 -2 L 1 -4 L -2 -4 L -4 -3 L -5 -2 L -6 1 L -6 3 L -5 6 L -4 7 L -2 8 L 1 8 L 5 6","-7 7 M -3 -5 L -3 9 L -2 9 M -3 -5 L -2 -5 L -2 9 M -2 1 L -1 -2 L 1 -4 L 3 -5 L 6 -5 M -2 1 L -1 -1 L 1 -3 L 3 -4 L 6 -4 L 6 -5","-8 9 M 6 -2 L 5 -4 L 2 -5 L -1 -5 L -4 -4 L -5 -2 L -4 0 L -2 1 L 3 3 L 5 4 M 4 3 L 5 5 L 5 6 L 4 8 M 5 7 L 2 8 L -1 8 L -4 7 M -3 8 L -4 6 L -5 6 M 6 -2 L 5 -2 L 4 -4 M 5 -3 L 2 -4 L -1 -4 L -4 -3 M -3 -4 L -4 -2 L -3 0 M -4 -1 L -2 0 L 3 2 L 5 3 L 6 5 L 6 6 L 5 8 L 2 9 L -1 9 L -4 8 L -5 6","-5 6 M 0 -12 L 0 9 L 1 9 M 0 -12 L 1 -12 L 1 9 M -3 -5 L 4 -5 L 4 -4 M -3 -5 L -3 -4 L 4 -4","-10 10 M -6 -5 L -6 5 L -5 8 L -3 9 L 0 9 L 2 8 L 5 5 M -6 -5 L -5 -5 L -5 5 L -4 7 L -2 8 L 0 8 L 2 7 L 5 5 M 5 -5 L 5 9 L 6 9 M 5 -5 L 6 -5 L 6 9","-8 8 M -6 -5 L 0 9 M -6 -5 L -5 -5 L 0 7 M 6 -5 L 5 -5 L 0 7 M 6 -5 L 0 9","-12 12 M -9 -5 L -4 9 M -9 -5 L -8 -5 L -4 6 M 0 -5 L -4 6 M 0 -2 L -4 9 M 0 -2 L 4 9 M 0 -5 L 4 6 M 9 -5 L 8 -5 L 4 6 M 9 -5 L 4 9","-9 9 M -6 -5 L 5 9 L 6 9 M -6 -5 L -5 -5 L 6 9 M 6 -5 L 5 -5 L -6 9 M 6 -5 L -5 9 L -6 9","-8 8 M -6 -5 L 0 9 M -6 -5 L -5 -5 L 0 7 M 6 -5 L 5 -5 L 0 7 L -4 16 M 6 -5 L 0 9 L -3 16 L -4 16","-9 9 M 4 -4 L -6 9 M 6 -5 L -4 8 M -6 -5 L 6 -5 M -6 -5 L -6 -4 L 4 -4 M -4 8 L 6 8 L 6 9 M -6 9 L 6 9","-7 7 M 3 -16 L -4 0 L 3 16","-4 4 M 0 -16 L 0 16","-7 7 M -3 -16 L 4 0 L -3 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
gothiceng = ["-8 8","-6 6 M 0 -12 L -1 -11 L -3 -10 L -1 -9 L 0 2 M 0 -9 L 1 -10 L 0 -11 L -1 -10 L 0 -9 L 0 2 M 0 -12 L 1 -11 L 3 -10 L 1 -9 L 0 2 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-9 9 M -4 -12 L -5 -11 L -5 -5 M -4 -11 L -5 -5 M -4 -12 L -3 -11 L -5 -5 M 5 -12 L 4 -11 L 4 -5 M 5 -11 L 4 -5 M 5 -12 L 6 -11 L 4 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 10 M -2 -16 L -2 13 M 2 -16 L 2 13 M 2 -12 L 4 -11 L 5 -9 L 5 -7 L 7 -8 L 6 -10 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -6 L -6 -4 L -3 -2 L 3 0 L 5 1 L 6 3 L 6 6 L 5 8 M 6 -8 L 5 -10 M -6 -6 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 2 M -5 7 L -6 5 M -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 3 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -5 4 L -5 6 L -4 8 L -2 9","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-13 13 M 7 -4 L 8 -3 L 9 -3 L 10 -4 M 6 -3 L 7 -2 L 9 -2 M 6 -2 L 7 -1 L 8 -1 L 9 -2 L 10 -4 M 7 -4 L 1 2 M 0 3 L -6 9 L -10 4 L -4 -2 M -3 -3 L 1 -7 L -3 -12 L -8 -6 L -2 0 L 2 6 L 4 8 L 6 9 L 8 9 L 9 8 L 10 6 M -6 8 L -9 4 M 0 -7 L -3 -11 M -7 -6 L -2 -1 L 2 5 L 4 7 L 6 8 L 9 8 M -5 8 L -9 3 M 0 -6 L -4 -11 M -7 -7 L -1 -1 L 3 5 L 4 6 L 6 7 L 9 7 L 10 6","-4 5 M 1 -12 L 0 -11 L 0 -5 M 1 -11 L 0 -5 M 1 -12 L 2 -11 L 0 -5","-7 7 M 3 -16 L 1 -14 L -1 -11 L -3 -7 L -4 -2 L -4 2 L -3 7 L -1 11 L 1 14 L 3 16 M -1 -10 L -2 -7 L -3 -3 L -3 3 L -2 7 L -1 10 M 1 -14 L 0 -12 L -1 -9 L -2 -3 L -2 3 L -1 9 L 0 12 L 1 14","-7 7 M -3 -16 L -1 -14 L 1 -11 L 3 -7 L 4 -2 L 4 2 L 3 7 L 1 11 L -1 14 L -3 16 M 1 -10 L 2 -7 L 3 -3 L 3 3 L 2 7 L 1 10 M -1 -14 L 0 -12 L 1 -9 L 2 -3 L 2 3 L 1 9 L 0 12 L -1 14","-8 8 M 0 -12 L -1 -11 L 1 -1 L 0 0 M 0 -12 L 0 0 M 0 -12 L 1 -11 L -1 -1 L 0 0 M -5 -9 L -4 -9 L 4 -3 L 5 -3 M -5 -9 L 5 -3 M -5 -9 L -5 -8 L 5 -4 L 5 -3 M 5 -9 L 4 -9 L -4 -3 L -5 -3 M 5 -9 L -5 -3 M 5 -9 L 5 -8 L -5 -4 L -5 -3","-12 13 M 0 -9 L 0 8 L 1 8 M 0 -9 L 1 -9 L 1 8 M -8 -1 L 9 -1 L 9 0 M -8 -1 L -8 0 L 9 0","-6 6 M 0 12 L 0 10 L -2 8 L 0 6 L 1 8 L 1 10 L 0 12 L -2 13 M 0 7 L -1 8 L 0 9 L 0 7","-13 13 M -9 0 L 9 0","-6 6 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-11 12 M 9 -16 L -9 16 L -8 16 M 9 -16 L 10 -16 L -8 16","-10 10 M -6 -10 L -6 6 L -8 7 M -5 -9 L -5 6 L -2 8 M -4 -10 L -4 6 L -2 7 L -1 8 M -6 -10 L -4 -10 L 1 -11 L 3 -12 M 1 -11 L 2 -10 L 4 -9 L 4 7 M 2 -11 L 5 -9 L 5 6 M 3 -12 L 4 -11 L 6 -10 L 8 -10 L 6 -9 L 6 7 M -8 7 L -6 7 L -4 8 L -3 9 L -1 8 L 4 7 L 6 7","-10 10 M -3 -10 L -2 -9 L -1 -7 L -1 6 L -3 7 M -1 -9 L -2 -10 L -1 -11 L 0 -9 L 0 7 L 2 8 M -3 -10 L 0 -12 L 1 -10 L 1 6 L 3 7 L 4 7 M -3 7 L -2 7 L 0 8 L 1 9 L 2 8 L 4 7","-10 10 M -6 -10 L -4 -10 L -2 -11 L -1 -12 L 1 -11 L 4 -10 L 6 -10 M -2 -10 L 0 -11 M -6 -10 L -4 -9 L -2 -9 L 0 -10 L 1 -11 M 4 -10 L 4 -2 M 5 -9 L 5 -3 M 6 -10 L 6 -2 L -1 -2 L -4 -1 L -6 1 L -7 4 L -7 9 M -7 9 L -3 7 L 1 6 L 4 6 L 8 7 M -4 8 L -1 7 L 4 7 L 7 8 M -7 9 L -2 8 L 3 8 L 6 9 L 8 7","-10 10 M -6 -10 L -5 -10 L -3 -11 L -2 -12 L 0 -11 L 4 -10 L 6 -10 M -3 -10 L -1 -11 M -6 -10 L -4 -9 L -2 -9 L 0 -11 M 4 -10 L 4 -3 M 5 -9 L 5 -4 M 6 -10 L 6 -3 L 4 -3 L 1 -2 L -1 -1 M -1 -2 L 1 -1 L 4 0 L 6 0 L 6 7 M 5 1 L 5 6 M 4 0 L 4 7 M -7 7 L -5 6 L -3 6 L -1 7 L 0 8 M -3 7 L -1 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 4 7 L 6 7","-10 10 M 3 -12 L -7 -2 L -7 3 L 2 3 M 4 3 L 8 3 L 9 4 L 9 2 L 8 3 M -6 -2 L -6 2 M -5 -4 L -5 3 M 2 -11 L 2 6 L 0 7 M 3 -8 L 4 -10 L 3 -11 L 3 7 L 5 8 M 3 -12 L 5 -10 L 4 -8 L 4 6 L 6 7 L 7 7 M 0 7 L 1 7 L 3 8 L 4 9 L 5 8 L 7 7","-10 10 M -6 -12 L -6 -3 M -6 -12 L 6 -12 M -5 -11 L 4 -11 M -6 -10 L 3 -10 L 5 -11 L 6 -12 M 4 -6 L 3 -5 L 1 -4 L -3 -3 L -6 -3 M 1 -4 L 2 -4 L 4 -3 L 4 7 M 3 -5 L 5 -4 L 5 6 M 4 -6 L 5 -5 L 7 -4 L 8 -4 L 6 -3 L 6 7 M -7 7 L -5 6 L -3 6 L -1 7 L 0 8 M -3 7 L -1 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 4 7 L 6 7","-10 10 M -6 -10 L -6 6 L -8 7 M -5 -9 L -5 6 L -2 8 M -4 -10 L -4 6 L -2 7 L -1 8 M -6 -10 L -4 -10 L 0 -11 L 2 -12 L 3 -11 L 5 -10 L 6 -10 M 1 -11 L 3 -10 M 0 -11 L 2 -9 L 4 -9 L 6 -10 M -4 -2 L -3 -2 L 1 -3 L 3 -4 L 4 -5 M 1 -3 L 2 -3 L 4 -2 L 4 7 M 3 -4 L 5 -2 L 5 6 M 4 -5 L 5 -4 L 7 -3 L 8 -3 L 6 -2 L 6 7 M -8 7 L -6 7 L -4 8 L -3 9 L -1 8 L 4 7 L 6 7","-10 10 M -7 -10 L -5 -12 L -2 -11 L 3 -11 L 8 -12 M -6 -11 L -3 -10 L 2 -10 L 5 -11 M -7 -10 L -3 -9 L 0 -9 L 4 -10 L 8 -12 M 8 -12 L 7 -10 L 5 -7 L 1 -3 L -1 0 L -2 3 L -2 6 L -1 9 M 0 -1 L -1 2 L -1 5 L 0 8 M 3 -5 L 1 -2 L 0 1 L 0 4 L 1 7 L -1 9","-10 10 M -6 -9 L -6 -3 M -5 -8 L -5 -4 M -4 -9 L -4 -3 M -6 -9 L -4 -9 L 1 -10 L 3 -11 L 4 -12 M 1 -10 L 2 -10 L 4 -9 L 4 -3 M 3 -11 L 5 -10 L 5 -4 M 4 -12 L 5 -11 L 7 -10 L 8 -10 L 6 -9 L 6 -3 M -6 -3 L -4 -3 L 4 0 L 6 0 M 6 -3 L 4 -3 L -4 0 L -6 0 M -6 0 L -6 6 L -8 7 M -5 1 L -5 6 L -2 8 M -4 0 L -4 6 L -2 7 L -1 8 M 4 0 L 4 7 M 5 1 L 5 6 M 6 0 L 6 7 M -8 7 L -6 7 L -4 8 L -3 9 L -1 8 L 4 7 L 6 7","-10 10 M -6 -10 L -6 -1 L -8 0 M -5 -9 L -5 0 L -3 1 M -4 -10 L -4 -1 L -2 0 L -1 0 M -6 -10 L -4 -10 L 1 -11 L 3 -12 M 1 -11 L 2 -10 L 4 -9 L 4 7 M 2 -11 L 5 -9 L 5 6 M 3 -12 L 4 -11 L 6 -10 L 8 -10 L 6 -9 L 6 7 M -8 0 L -7 0 L -5 1 L -4 2 L -3 1 L -1 0 L 3 -1 L 4 -1 M -7 7 L -5 6 L -3 6 L -1 7 L 0 8 M -3 7 L -1 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 4 7 L 6 7","-6 6 M 0 -5 L -2 -3 L 0 -2 L 2 -3 L 0 -5 M 0 -4 L -1 -3 L 1 -3 L 0 -4 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-6 6 M 0 -5 L -2 -3 L 0 -2 L 2 -3 L 0 -5 M 0 -4 L -1 -3 L 1 -3 L 0 -4 M 0 12 L 0 10 L -2 8 L 0 6 L 1 8 L 1 10 L 0 12 L -2 13 M 0 7 L -1 8 L 0 9 L 0 7","-12 12 M 8 -9 L -8 0 L 8 9","-12 13 M -8 -5 L 9 -5 L 9 -4 M -8 -5 L -8 -4 L 9 -4 M -8 3 L 9 3 L 9 4 M -8 3 L -8 4 L 9 4","-12 12 M -8 -9 L 8 0 L -8 9","-9 9 M -6 -8 L -5 -10 L -4 -11 L -1 -12 L 1 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 3 -2 L 1 -1 M -5 -8 L -4 -10 M 4 -10 L 5 -9 L 5 -5 L 4 -4 M -6 -8 L -4 -7 L -4 -9 L -3 -11 L -1 -12 M 1 -12 L 3 -11 L 4 -9 L 4 -5 L 3 -3 L 1 -1 M 0 -1 L 0 2 L 1 -1 L -1 -1 L 0 2 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-11 11 M -6 -9 L -4 -11 L -2 -12 L 0 -12 L 1 -11 L 8 5 L 9 6 L 11 6 M -1 -11 L 0 -10 L 7 6 L 8 8 L 9 7 L 7 6 M -4 -11 L -2 -11 L -1 -10 L 6 6 L 7 8 L 8 9 L 9 9 L 11 6 M -6 -5 L -5 -6 L -3 -7 L -2 -7 L -1 -6 M -2 -6 L -2 -5 M -5 -6 L -3 -6 L -2 -4 M -11 9 L -9 7 L -7 6 L -4 6 L -2 7 M -8 7 L -4 7 L -3 8 M -11 9 L -8 8 L -5 8 L -4 9 L -2 7 M 0 -8 L -6 6 M -4 1 L 4 1","-12 12 M -10 -10 L -8 -12 L -5 -12 L -3 -11 L -1 -12 M -7 -11 L -4 -11 M -10 -10 L -8 -11 L -6 -10 L -3 -10 L -1 -12 M -5 -7 L -6 -6 L -7 -4 L -7 -3 L -9 -3 L -10 -2 L -10 0 L -9 -1 L -7 -1 L -7 5 M -6 -5 L -6 3 M -9 -2 L -6 -2 M -5 -7 L -5 2 L -6 4 L -7 5 M 0 -9 L -1 -8 L -2 -6 L -2 3 M -1 -7 L -1 1 M 0 -9 L 0 0 L -1 2 L -2 3 M 0 -9 L 6 -12 L 8 -11 L 9 -9 L 9 -7 L 7 -5 L 3 -3 M 6 -11 L 8 -9 L 8 -7 M 4 -11 L 6 -10 L 7 -9 L 7 -6 L 5 -4 M 5 -4 L 8 -2 L 9 0 L 9 6 M 7 -2 L 8 0 L 8 5 M 5 -4 L 6 -3 L 7 -1 L 7 6 M -8 9 L -5 7 L -2 6 L 2 6 L 5 7 M -6 8 L -3 7 L 2 7 L 4 8 M -8 9 L -4 8 L 1 8 L 3 9 L 5 7 L 7 6 L 9 6 M 3 -3 L 3 6 M 3 0 L 7 0 M 3 3 L 7 3","-13 11 M -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 1 L -9 4 L -8 6 L -5 8 L -2 9 L 1 9 L 4 8 L 6 7 L 8 5 L 9 3 M -8 -7 L -9 -4 L -9 1 L -7 5 L -4 7 L -1 8 L 2 8 L 5 7 M -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 0 L -7 3 L -4 6 L -1 7 L 2 7 L 5 6 L 7 5 L 9 3 M -2 -8 L -2 4 M -1 -8 L -1 2 M 0 -9 L 0 1 L -1 3 L -2 4 M -2 -8 L 0 -9 L 3 -12 L 5 -11 L 7 -11 L 8 -12 M 2 -11 L 4 -10 L 6 -10 M 1 -10 L 3 -9 L 5 -9 L 7 -10 L 8 -12 M 5 -9 L 5 6","-11 12 M -9 -12 L 5 -12 L 7 -11 L 8 -9 L 8 6 M -7 -11 L 5 -11 L 7 -9 L 7 5 M -9 -12 L -8 -11 L -6 -10 L 5 -10 L 6 -9 L 6 6 M -3 -7 L -4 -6 L -5 -4 L -5 -3 L -7 -3 L -8 -2 L -8 0 L -7 -1 L -5 -1 L -5 4 M -4 -5 L -4 2 M -7 -2 L -4 -2 M -3 -7 L -3 1 L -4 3 L -5 4 M -9 9 L -6 7 L -3 6 L 1 6 L 4 7 M -7 8 L -4 7 L 1 7 L 3 8 M -9 9 L -5 8 L 0 8 L 2 9 L 4 7 L 6 6 L 8 6 M 0 -10 L 0 6 M 0 -5 L 2 -4 L 4 -4 L 6 -5 M 0 1 L 2 0 L 4 0 L 6 1","-11 11 M -9 -10 L -7 -12 L -5 -12 L -3 -11 L -1 -12 M -6 -11 L -4 -11 M -9 -10 L -7 -11 L -5 -10 L -3 -10 L -1 -12 M -4 -7 L -5 -6 L -6 -4 L -6 -3 L -8 -3 L -9 -2 L -9 0 L -8 -1 L -6 -1 L -6 5 M -5 -5 L -5 3 M -8 -2 L -5 -2 M -4 -7 L -4 2 L -5 4 L -6 5 M -1 -5 L 0 -8 L 1 -10 L 2 -11 L 4 -12 L 6 -12 L 9 -11 M 2 -10 L 4 -11 L 6 -11 L 8 -10 M 0 -8 L 1 -9 L 3 -10 L 5 -10 L 7 -9 L 9 -11 M -1 3 L 0 0 L 1 -2 L 2 -3 L 4 -3 L 6 -2 M 2 -2 L 4 -2 L 5 -1 M 0 0 L 1 -1 L 3 -1 L 4 0 L 6 -2 M -7 9 L -4 7 L 0 6 L 5 6 L 9 7 M -5 8 L -2 7 L 5 7 L 8 8 M -7 9 L -3 8 L 4 8 L 7 9 L 9 7 M -1 -5 L -1 6","-12 11 M -8 -10 L -6 -12 L -3 -12 L -1 -11 L 1 -12 M -5 -11 L -2 -11 M -8 -10 L -6 -11 L -4 -10 L -1 -10 L 1 -12 M -2 -7 L -3 -6 L -4 -4 L -4 -3 L -6 -3 L -7 -2 L -7 0 L -6 -1 L -4 -1 L -4 4 M -3 -5 L -3 2 M -6 -2 L -3 -2 M -2 -7 L -2 1 L -3 3 L -4 4 M 1 -8 L 1 7 L 0 8 L -1 8 L -5 6 L -7 6 L -9 7 L -11 9 M 2 -8 L 2 6 M 2 -2 L 6 -2 M -2 8 L -3 8 L -5 7 L -8 7 M 3 -9 L 3 -3 L 6 -3 M 6 -1 L 3 -1 L 3 5 L 2 7 L -2 9 L -4 9 L -6 8 L -8 8 L -11 9 M 1 -8 L 3 -9 L 6 -12 L 8 -11 L 10 -11 L 11 -12 M 5 -11 L 7 -10 L 9 -10 M 4 -10 L 6 -9 L 8 -9 L 10 -10 L 11 -12 M 6 -9 L 6 5","-13 12 M -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 3 9 L 6 8 L 8 6 L 9 4 L 9 1 L 8 -1 L 7 -2 L 5 -3 L 3 -3 M -8 -7 L -9 -4 L -9 1 L -8 4 M -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 M 7 6 L 8 5 L 8 1 L 7 -1 M 3 9 L 5 8 L 6 7 L 7 5 L 7 1 L 6 -1 L 5 -2 L 3 -3 M -2 -8 L -2 5 M -1 -8 L -1 3 M 0 -9 L 0 2 L -1 4 L -2 5 M -2 -8 L 0 -9 L 3 -12 L 5 -11 L 7 -11 L 8 -12 M 2 -11 L 4 -10 L 6 -10 M 1 -10 L 3 -9 L 5 -9 L 7 -10 L 8 -12 M 7 -10 L 3 -3 L 3 9 M 3 1 L 7 1 M 3 4 L 7 4","-12 12 M -10 -10 L -8 -12 L -5 -12 L -3 -11 L -1 -12 M -7 -11 L -4 -11 M -10 -10 L -8 -11 L -6 -10 L -3 -10 L -1 -12 M -5 -7 L -6 -6 L -7 -4 L -7 -3 L -9 -3 L -10 -2 L -10 0 L -9 -1 L -7 -1 L -7 5 M -6 -5 L -6 3 M -9 -2 L -6 -2 M -5 -7 L -5 2 L -6 4 L -7 5 M -8 9 L -5 7 L -2 6 L 1 6 L 3 7 M -6 8 L -3 7 L 0 7 L 2 8 M -8 9 L -4 8 L -1 8 L 1 9 L 3 7 M 0 -9 L -1 -8 L -2 -6 L -2 3 M -1 -7 L -1 1 M 0 -9 L 0 0 L -1 2 L -2 3 M 0 -9 L 2 -11 L 4 -12 L 6 -12 L 8 -11 M 5 -11 L 6 -11 L 7 -10 M 2 -11 L 4 -11 L 6 -9 L 8 -11 M 3 -3 L 5 -4 L 7 -6 L 8 -5 L 9 -2 L 9 2 L 8 6 L 6 9 M 6 -5 L 7 -4 L 8 -2 L 8 3 L 7 6 M 5 -4 L 6 -4 L 7 -2 L 7 3 L 6 9 M 3 -3 L 3 7 M 3 0 L 7 0 M 3 3 L 7 3","-9 10 M -6 -10 L -4 -12 L -1 -12 L 2 -11 L 4 -12 M -3 -11 L 1 -11 M -6 -10 L -4 -11 L -1 -10 L 2 -10 L 4 -12 M 1 -7 L 0 -6 L -1 -4 L -1 -3 L -3 -3 L -4 -2 L -4 0 L -3 -1 L -1 -1 L -1 4 M 0 -5 L 0 2 M -3 -2 L 0 -2 M 1 -7 L 1 1 L 0 3 L -1 4 M 7 -10 L 5 -8 L 4 -5 L 4 6 L 3 8 L 1 8 L -3 6 L -5 6 L -7 7 L -9 9 M 5 -7 L 5 5 M 0 8 L -1 8 L -3 7 L -6 7 M 7 -10 L 6 -8 L 6 4 L 5 6 L 3 8 L 1 9 L -2 9 L -4 8 L -7 8 L -9 9","-10 10 M -6 -10 L -4 -12 L -1 -12 L 2 -11 L 4 -12 M -3 -11 L 1 -11 M -6 -10 L -4 -11 L -1 -10 L 2 -10 L 4 -12 M 1 -7 L 0 -6 L -1 -4 L -1 -3 L -3 -3 L -4 -2 L -4 0 L -3 -1 L -1 -1 L -1 4 M 0 -5 L 0 2 M -3 -2 L 0 -2 M 1 -7 L 1 1 L 0 3 L -1 4 M 7 -10 L 5 -8 L 4 -5 L 4 6 L 3 8 M 5 -7 L 5 5 M 7 -10 L 6 -8 L 6 4 L 5 6 L 3 8 L 0 9 L -3 9 L -6 8 L -8 6 L -8 4 L -7 3 L -6 3 L -5 4 L -6 5 L -7 5 M -8 4 L -5 4","-12 12 M -10 -10 L -8 -12 L -5 -12 L -3 -11 L -1 -12 M -7 -11 L -4 -11 M -10 -10 L -8 -11 L -6 -10 L -3 -10 L -1 -12 M -5 -7 L -6 -6 L -7 -4 L -7 -3 L -9 -3 L -10 -2 L -10 0 L -9 -1 L -7 -1 L -7 5 M -6 -5 L -6 3 M -9 -2 L -6 -2 M -5 -7 L -5 2 L -6 4 L -7 5 M -8 9 L -5 7 L -2 6 L 1 6 L 3 7 M -6 8 L -4 7 L 0 7 L 2 8 M -8 9 L -4 8 L -1 8 L 1 9 L 3 7 M 0 -9 L -1 -8 L -2 -6 L -2 3 M -1 -7 L -1 1 M 0 -9 L 0 0 L -1 2 L -2 3 M 0 -9 L 2 -11 L 4 -12 L 6 -12 L 8 -11 M 5 -11 L 6 -11 L 7 -10 M 2 -11 L 4 -11 L 6 -9 L 8 -11 M 3 -3 L 6 -6 L 7 -5 L 9 -4 M 5 -5 L 7 -4 L 9 -4 M 9 -4 L 7 -1 L 5 1 L 3 3 M 5 1 L 7 2 L 8 6 L 9 8 L 10 8 M 7 4 L 8 8 M 5 1 L 6 2 L 7 8 L 8 9 L 9 9 L 10 8 M 3 -3 L 3 7","-11 11 M -9 -10 L -7 -12 L -4 -12 L -2 -11 L 0 -12 M -6 -11 L -3 -11 M -9 -10 L -7 -11 L -5 -10 L -2 -10 L 0 -12 M -4 -7 L -5 -6 L -6 -4 L -6 -3 L -8 -3 L -9 -2 L -9 0 L -8 -1 L -6 -1 L -6 5 M -5 -5 L -5 3 M -8 -2 L -5 -2 M -4 -7 L -4 2 L -5 4 L -6 5 M -7 9 L -4 7 L 0 6 L 5 6 L 9 7 M -5 8 L -2 7 L 5 7 L 8 8 M -7 9 L -3 8 L 4 8 L 7 9 L 9 7 M 1 -9 L 0 -8 L -1 -6 L -1 3 M 0 -7 L 0 1 M 1 -9 L 1 0 L 0 2 L -1 3 M 1 -9 L 3 -11 L 5 -12 L 7 -12 L 9 -11 M 6 -11 L 7 -11 L 8 -10 M 3 -11 L 5 -11 L 7 -9 L 9 -11 M 5 -11 L 5 6","-14 14 M -6 -8 L -7 -7 L -8 -5 L -8 -3 L -10 -3 L -11 -2 L -11 0 L -10 -1 L -8 -1 L -8 3 M -7 -6 L -7 1 M -10 -2 L -7 -2 M -6 -8 L -6 0 L -7 2 L -8 3 M -13 9 L -11 7 L -9 6 L -7 6 L -5 7 L -4 7 L -3 6 M -10 7 L -7 7 L -5 8 M -13 9 L -11 8 L -8 8 L -6 9 L -5 9 L -4 8 L -3 6 M -6 -8 L -2 -12 L 2 -8 L 2 5 L 3 7 L 4 7 M -2 -11 L 1 -8 L 1 6 L 0 7 L 1 8 L 2 7 L 1 6 M -2 -2 L 1 -2 M -4 -10 L -3 -10 L 0 -7 L 0 -3 L -3 -3 M -3 -1 L 0 -1 L 0 6 L -1 7 L 1 9 L 4 7 L 5 6 M 2 -8 L 6 -12 L 10 -8 L 10 5 L 11 7 L 12 7 M 6 -11 L 9 -8 L 9 6 L 11 8 M 6 -2 L 9 -2 M 4 -10 L 5 -10 L 8 -7 L 8 -3 L 5 -3 M 5 -1 L 8 -1 L 8 7 L 10 9 L 12 7 M -3 -10 L -3 6 M 5 -10 L 5 6","-13 12 M -11 -9 L -9 -11 L -7 -12 L -5 -12 L -3 -11 L -1 -8 L 4 3 L 6 6 L 7 7 M -5 -11 L -3 -9 L -2 -7 L 4 5 L 7 8 M -9 -11 L -7 -11 L -5 -10 L -3 -7 L 2 4 L 4 7 L 5 8 L 7 9 M 4 -10 L 6 -9 L 8 -9 L 10 -10 L 11 -12 M 5 -11 L 7 -10 L 9 -10 M 4 -10 L 6 -12 L 8 -11 L 10 -11 L 11 -12 M -7 -3 L -9 -3 L -10 -2 L -10 0 L -9 -1 L -7 -1 M -9 -2 L -7 -2 M -11 9 L -9 7 L -7 6 L -4 6 L -2 7 M -8 7 L -5 7 L -3 8 M -11 9 L -8 8 L -5 8 L -4 9 L -2 7 M -7 -11 L -7 6 M 7 -9 L 7 9 M 0 -6 L 1 -5 L 3 -4 L 5 -4 L 7 -5 M -7 2 L -5 1 L -1 1 L 1 2","-13 13 M -4 -12 L -6 -11 L -8 -9 L -9 -7 L -10 -4 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 1 9 L 4 8 L 6 7 L 8 5 L 9 3 L 10 0 L 10 -4 L 9 -7 L 8 -9 L 6 -11 L 4 -12 L 3 -11 L 0 -9 L -3 -8 M -8 -8 L -9 -5 L -9 1 L -8 4 M -4 -12 L -6 -10 L -7 -8 L -8 -5 L -8 1 L -7 4 L -6 6 L -4 8 M 8 4 L 9 1 L 9 -5 L 7 -9 L 6 -10 M 4 8 L 6 6 L 7 4 L 8 1 L 8 -5 L 7 -7 L 5 -10 L 3 -11 M -3 -8 L -3 5 M -2 -8 L -2 3 M -1 -8 L -1 2 L -2 4 L -3 5 M 3 -11 L 3 8 M 3 -5 L 5 -4 L 6 -4 L 8 -5 M 3 1 L 5 0 L 6 0 L 8 1","-10 12 M -7 -12 L -6 -11 L -5 -9 L -5 -3 L -7 -3 L -8 -2 L -8 0 L -7 -1 L -5 -1 L -5 7 L -8 9 L -5 8 L -5 16 L -3 14 M -5 -10 L -4 -8 L -4 14 M -7 -2 L -4 -2 M -7 -12 L -5 -11 L -4 -10 L -3 -8 L -3 14 M -3 -7 L 0 -9 L 4 -12 L 8 -8 L 8 6 M 4 -11 L 7 -8 L 7 6 M 2 -10 L 3 -10 L 6 -7 L 6 7 M 0 6 L 3 6 L 6 7 M 1 7 L 3 7 L 5 8 M 0 8 L 2 8 L 4 9 L 6 7 L 8 6 M 0 -9 L 0 13 M 0 -5 L 2 -4 L 4 -4 L 6 -5 M 0 1 L 2 0 L 4 0 L 6 1","-13 13 M -4 -12 L -6 -11 L -8 -9 L -9 -7 L -10 -4 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -2 9 L 2 9 L 4 8 L 6 7 L 8 5 L 9 3 L 10 0 L 10 -4 L 9 -7 L 8 -9 L 6 -11 L 4 -12 L 3 -11 L 0 -9 L -3 -8 M -8 -8 L -9 -5 L -9 1 L -8 4 M -4 -12 L -6 -10 L -7 -8 L -8 -5 L -8 1 L -7 4 L -6 6 L -4 8 M 8 4 L 9 1 L 9 -5 L 7 -9 L 6 -10 M 4 8 L 6 6 L 7 4 L 8 1 L 8 -5 L 7 -7 L 5 -10 L 3 -11 M -3 -8 L -3 5 M -2 -8 L -2 3 M -1 -8 L -1 2 L -2 4 L -3 5 M 3 -11 L 3 8 M 3 -5 L 5 -4 L 6 -4 L 8 -5 M 3 1 L 5 0 L 6 0 L 8 1 M -2 9 L -1 8 L 0 8 L 2 9 L 6 14 L 8 15 L 9 15 M 2 10 L 4 13 L 6 15 L 7 15 M 0 8 L 1 9 L 4 15 L 6 16 L 8 16 L 9 15","-12 12 M -10 -10 L -8 -12 L -5 -12 L -3 -11 L -1 -12 M -7 -11 L -4 -11 M -10 -10 L -8 -11 L -6 -10 L -3 -10 L -1 -12 M -5 -7 L -6 -6 L -7 -4 L -7 -3 L -9 -3 L -10 -2 L -10 0 L -9 -1 L -7 -1 L -7 5 M -6 -5 L -6 3 M -9 -2 L -6 -2 M -5 -7 L -5 2 L -6 4 L -7 5 M -8 9 L -5 7 L -2 6 L 0 6 L 3 7 M -6 8 L -4 7 L 0 7 L 2 8 M -8 9 L -4 8 L -1 8 L 1 9 L 3 7 M 0 -9 L -1 -8 L -2 -6 L -2 3 M -1 -7 L -1 1 M 0 -9 L 0 0 L -1 2 L -2 3 M 0 -9 L 3 -11 L 5 -12 L 7 -11 L 8 -9 L 8 -6 L 7 -4 L 6 -3 L 2 -1 L 0 0 M 5 -11 L 6 -11 L 7 -9 L 7 -5 L 6 -4 M 3 -11 L 5 -10 L 6 -8 L 6 -5 L 5 -3 L 2 -1 M 2 -1 L 4 0 L 5 1 L 8 6 L 9 7 L 10 7 M 5 2 L 7 6 L 9 8 M 2 -1 L 4 1 L 6 7 L 8 9 L 10 7","-11 12 M 3 -9 L 2 -10 L 0 -11 L -3 -12 M 4 -10 L 2 -11 M 5 -11 L 1 -12 L -3 -12 L -6 -11 L -7 -10 L -8 -8 L -7 -6 L -6 -5 L -3 -4 L 5 -4 L 7 -3 L 8 -2 L 8 0 L 7 3 M -7 -7 L -6 -6 L -3 -5 L 6 -5 L 8 -4 L 9 -3 L 9 -1 L 8 1 M -7 -10 L -7 -8 L -6 -7 L -3 -6 L 7 -6 L 9 -5 L 10 -3 L 10 -1 L 7 3 L 3 9 M -9 -3 L -8 -2 L -6 -1 L 3 -1 L 4 0 L 4 1 L 3 3 M -8 -1 L -6 0 L 2 0 L 3 1 M -9 -3 L -9 -2 L -8 0 L -6 1 L 1 1 L 3 2 L 3 3 M -9 9 L -6 7 L -2 6 L 1 6 L 4 7 M -7 8 L -4 7 L 0 7 L 3 8 M -9 9 L -5 8 L 0 8 L 3 9 M 5 -11 L 3 -9 L 1 -6 M 0 -4 L -2 -1 M -3 1 L -5 3 L -7 4 L -8 4 L -8 3 L -7 4","-13 11 M -8 -8 L -9 -6 L -10 -3 L -10 1 L -9 4 L -7 7 L -5 8 L -2 9 L 1 9 L 4 8 L 6 7 L 8 5 L 9 3 M -9 1 L -8 4 L -6 6 L -4 7 L -1 8 L 2 8 L 5 7 M -8 -8 L -9 -5 L -9 -1 L -8 2 L -6 5 L -4 6 L -1 7 L 2 7 L 5 6 L 7 5 L 9 3 M -10 -9 L -9 -11 L -7 -12 L -3 -12 L 3 -11 L 7 -11 L 9 -12 M -2 -11 L 2 -10 L 6 -10 M -10 -9 L -9 -10 L -7 -11 L -4 -11 L 2 -9 L 5 -9 L 7 -10 L 9 -12 M 1 -9 L 0 -8 L -2 -7 L -2 4 M -1 -7 L -1 2 M 0 -8 L 0 1 L -1 3 L -2 4 M 5 -9 L 5 6","-12 12 M -10 -10 L -8 -12 L -6 -12 L -3 -11 L -1 -12 M -7 -11 L -4 -11 M -10 -10 L -8 -11 L -5 -10 L -3 -10 L -1 -12 M -7 -8 L -8 -6 L -9 -3 L -9 1 L -8 4 L -7 6 L -5 8 L -2 9 L 1 9 L 4 8 L 6 7 L 8 9 L 10 7 M -8 1 L -7 4 L -4 7 L -1 8 L 2 8 M -7 -8 L -8 -4 L -8 -1 L -7 2 L -6 4 L -4 6 L -1 7 L 3 7 L 6 6 M 3 -9 L -1 -8 L -2 -6 L -2 4 M -1 -7 L -1 2 M 0 -8 L 0 1 L -1 3 L -2 4 M 3 -9 L 5 -10 L 7 -12 L 8 -11 L 10 -10 L 8 -9 L 8 5 L 9 7 L 10 7 M 7 -9 L 8 -10 L 7 -11 L 6 -10 L 7 -9 L 7 6 L 9 8 M 5 -10 L 6 -9 L 6 6 M 3 -9 L 3 7 M 3 -4 L 6 -4 M 3 0 L 6 0","-11 12 M -8 -12 L -7 -11 L -6 -9 L -6 -3 L -8 -3 L -9 -2 L -9 0 L -8 -1 L -6 -1 L -6 6 L -8 7 M -6 -10 L -5 -8 L -5 6 M -8 -2 L -5 -2 M -4 7 L -1 7 L 1 8 M -8 -12 L -6 -11 L -5 -10 L -4 -8 L -4 6 L 0 6 L 3 7 M -8 7 L -5 7 L -2 8 L 0 9 L 3 7 L 6 6 L 8 6 M 0 -8 L 3 -9 L 5 -10 L 7 -12 L 8 -11 L 10 -10 L 8 -9 L 8 6 M 7 -9 L 8 -10 L 7 -11 L 6 -10 L 7 -9 L 7 5 M 5 -10 L 6 -9 L 6 6 M 0 -8 L 0 6 M 0 -5 L 2 -4 L 4 -4 L 6 -5 M 0 1 L 2 0 L 4 0 L 6 1","-13 14 M -10 -12 L -9 -11 L -8 -9 L -8 -3 L -10 -3 L -11 -2 L -11 0 L -10 -1 L -8 -1 L -8 6 L -10 7 M -8 -10 L -7 -8 L -7 6 M -10 -2 L -7 -2 M -6 7 L -4 7 L -2 8 M -10 -12 L -8 -11 L -7 -10 L -6 -8 L -6 6 L -3 6 L -1 7 M -10 7 L -7 7 L -4 8 L -3 9 L -1 7 L 2 6 L 4 7 L 5 9 L 7 7 L 10 6 M -3 -10 L 0 -12 L 2 -10 L 2 6 L 5 6 L 7 7 M 0 -11 L 1 -10 L 1 6 M -3 -10 L -1 -10 L 0 -9 L 0 6 L -1 7 M 5 7 L 6 8 M 5 -10 L 8 -12 L 10 -10 L 10 6 M 8 -11 L 9 -10 L 9 6 M 5 -10 L 7 -10 L 8 -9 L 8 6 L 7 7 M -3 -10 L -3 6 M 5 -10 L 5 6 M -3 -4 L 0 -4 M -3 0 L 0 0 M 5 -4 L 8 -4 M 5 0 L 8 0","-11 11 M -10 -9 L -8 -11 L -6 -12 L -4 -12 L -3 -11 L 5 7 L 6 8 L 8 8 M -5 -11 L -4 -10 L 4 7 L 5 8 M -8 -11 L -6 -11 L -5 -10 L 3 8 L 4 9 L 6 9 L 8 8 L 10 6 M 5 -12 L 7 -11 L 9 -11 L 10 -12 M 5 -11 L 6 -10 L 8 -10 M 4 -10 L 5 -9 L 7 -9 L 9 -10 L 10 -12 M -10 9 L -9 7 L -7 6 L -5 6 L -4 7 M -8 7 L -6 7 L -5 8 M -10 9 L -9 8 L -7 8 L -5 9 M 5 -12 L 1 -3 M -1 0 L -5 9 M -6 -2 L -2 -2 M 1 -2 L 6 -2","-11 12 M -8 -12 L -7 -11 L -6 -9 L -6 -3 L -8 -3 L -9 -2 L -9 0 L -8 -1 L -6 -1 L -6 6 L -8 7 M -6 -10 L -5 -8 L -5 6 M -8 -2 L -5 -2 M -4 7 L -1 7 L 1 8 M -8 -12 L -6 -11 L -5 -10 L -4 -8 L -4 6 L 0 6 L 3 7 M -8 7 L -5 7 L -2 8 L 0 9 L 3 7 L 6 6 M 0 -8 L 3 -9 L 5 -10 L 7 -12 L 8 -11 L 10 -10 L 8 -9 L 8 12 L 7 14 L 5 16 L 3 15 L -1 14 L -6 14 M 7 -9 L 8 -10 L 7 -11 L 6 -10 L 7 -9 L 7 7 M 5 -10 L 6 -9 L 6 6 L 8 9 M 6 15 L 4 14 L 1 14 M 7 14 L 4 13 L -2 13 L -6 14 M 0 -8 L 0 6 M 0 -5 L 2 -4 L 4 -4 L 6 -5 M 0 1 L 2 0 L 4 0 L 6 1","-10 10 M 6 -11 L 5 -9 L 0 -3 L -3 1 L -5 5 L -8 9 M 4 -7 L -4 4 M 8 -12 L 5 -8 L 3 -4 L 0 0 L -5 6 L -6 8 M -8 -10 L -6 -12 L -3 -11 L 3 -11 L 8 -12 M -7 -11 L -3 -10 L 1 -10 L 5 -11 M -8 -10 L -4 -9 L 0 -9 L 4 -10 L 6 -11 M -6 8 L -4 7 L 0 6 L 4 6 L 8 7 M -5 8 L -1 7 L 3 7 L 7 8 M -8 9 L -3 8 L 3 8 L 6 9 L 8 7 M -5 -2 L -1 -2 M 2 -2 L 6 -2","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-11 11 M -8 2 L 0 -3 L 8 2 M -8 2 L 0 -2 L 8 2","-11 11 M -11 16 L 11 16","-6 6 M -2 -12 L 3 -6 M -2 -12 L -3 -11 L 3 -6","-8 9 M -2 0 L -4 2 L -5 4 L -5 6 L -4 8 L -2 9 L 0 7 L 3 6 M -5 4 L -4 6 L -3 7 L -1 8 M -4 2 L -4 4 L -3 6 L -1 7 L 0 7 M -4 -2 L -2 -2 L 1 -3 L 3 -4 L 4 -5 L 6 -3 L 5 -2 L 5 6 L 6 7 L 7 7 M -3 -4 L -4 -3 L -1 -3 M 2 -3 L 5 -3 L 4 -4 L 4 7 L 5 8 M -5 -3 L -3 -5 L -2 -4 L 0 -3 L 3 -2 L 3 7 L 5 9 L 7 7 M -5 -3 L 0 2","-9 9 M -6 -10 L -5 -8 L -5 6 L -7 7 M -4 -8 L -5 -10 L -4 -11 L -4 6 L -1 8 M -6 -10 L -3 -12 L -3 6 L -1 7 L 0 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 3 7 L 5 7 M -3 -2 L 0 -3 L 2 -4 L 3 -5 L 4 -4 L 6 -3 L 7 -3 L 5 -2 L 5 7 M 2 -4 L 4 -3 L 4 6 M 0 -3 L 1 -3 L 3 -2 L 3 7","-8 6 M -4 -3 L -4 6 L -6 7 L -5 7 L -3 8 L -2 9 M -3 -3 L -3 7 L -1 8 M -2 -3 L -2 6 L 0 7 L 1 7 L -1 8 L -2 9 M -4 -3 L 0 -4 L 2 -5 L 3 -4 L 5 -3 L 6 -3 M 1 -4 L 2 -3 L 4 -3 M -2 -3 L 0 -4 L 2 -2 L 4 -2 L 6 -3","-9 8 M 0 -5 L -2 -4 L -5 -3 L -5 6 L -7 7 M -4 -3 L -4 6 L -1 8 M 0 -5 L -3 -3 L -3 6 L -1 7 L 0 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 3 7 L 5 7 M -5 -10 L -2 -12 L -1 -9 L 5 -3 L 5 7 M -2 -9 L -4 -10 L -3 -11 L -2 -9 L 4 -3 L 4 6 M -5 -10 L 3 -2 L 3 7","-8 6 M -4 -3 L -4 6 L -6 7 L -5 7 L -3 8 L -2 9 M -3 -3 L -3 7 L -1 8 M -2 -3 L -2 6 L 0 7 L 1 7 L -1 8 L -2 9 M -4 -3 L 0 -4 L 2 -5 L 5 -1 L 3 0 L -2 3 M 1 -4 L 4 -1 M -2 -3 L 0 -4 L 3 0","-8 5 M -4 -10 L -4 6 L -6 7 L -5 7 L -3 8 L -2 9 M -3 -10 L -3 7 L -1 8 M -2 -10 L -2 6 L 0 7 L 1 7 L -1 8 L -2 9 M -4 -10 L -1 -11 L 1 -12 L 2 -11 L 4 -10 L 5 -10 M 0 -11 L 1 -10 L 3 -10 M -2 -10 L -1 -11 L 1 -9 L 3 -9 L 5 -10 M -7 -5 L -4 -5 M -2 -5 L 2 -5","-9 9 M -5 -3 L -5 6 L -7 7 L -6 7 L -4 8 L -3 9 L -2 8 L 0 7 L 3 6 M -4 -2 L -4 7 L -2 8 M -3 -3 L -3 6 L -1 7 L 0 7 M -5 -3 L -3 -3 L 0 -4 L 2 -5 L 3 -4 L 5 -3 L 7 -3 L 5 -2 L 5 10 L 4 13 L 2 15 L 0 16 L -1 15 L -3 14 L -5 14 M 1 -4 L 4 -2 L 4 10 M 1 15 L -1 14 L -2 14 M 0 -4 L 1 -3 L 3 -2 L 3 8 L 4 11 L 4 13 M 2 15 L 1 14 L -1 13 L -3 13 L -5 14","-9 9 M -6 -10 L -5 -8 L -5 6 L -7 7 L -6 7 L -4 8 L -3 9 M -4 -8 L -5 -10 L -4 -11 L -4 7 L -2 8 M -6 -10 L -3 -12 L -3 6 L -1 7 L -3 9 M -3 -2 L 0 -3 L 2 -4 L 3 -5 L 4 -4 L 6 -3 L 7 -3 L 5 -2 L 5 7 L 3 9 L 2 11 M 2 -4 L 4 -3 L 4 7 L 3 9 M 0 -3 L 1 -3 L 3 -2 L 3 7 L 2 11 L 2 14 L 3 16 L 4 16 L 2 14","-5 5 M 0 -12 L -2 -10 L 0 -9 L 2 -10 L 0 -12 M 0 -11 L -1 -10 L 1 -10 L 0 -11 M 0 -5 L -1 -4 L -3 -3 L -1 -2 L -1 7 L 1 9 L 3 7 M 0 -2 L 1 -3 L 0 -4 L -1 -3 L 0 -2 L 0 7 L 1 8 M 0 -5 L 1 -4 L 3 -3 L 1 -2 L 1 6 L 2 7 L 3 7","-5 5 M 0 -12 L -2 -10 L 0 -9 L 2 -10 L 0 -12 M 0 -11 L -1 -10 L 1 -10 L 0 -11 M 0 -5 L -1 -4 L -3 -3 L -1 -2 L -1 7 L 1 9 L 2 11 M 0 -2 L 1 -3 L 0 -4 L -1 -3 L 0 -2 L 0 7 L 1 9 M 0 -5 L 1 -4 L 3 -3 L 1 -2 L 1 7 L 2 11 L 2 14 L 0 16 L -2 16 L -2 15 L 0 16","-9 8 M -6 -10 L -5 -8 L -5 6 L -7 7 L -6 7 L -4 8 L -3 9 M -4 -8 L -5 -10 L -4 -11 L -4 7 L -2 8 M -6 -10 L -3 -12 L -3 6 L -1 7 L -3 9 M -3 -2 L 0 -4 L 2 -5 L 4 -2 L 1 0 L -3 3 M 1 -4 L 3 -2 M 0 -4 L 2 -1 M 1 0 L 2 1 L 4 6 L 5 7 L 6 7 M 1 1 L 2 2 L 3 7 L 4 8 M 0 1 L 1 2 L 2 7 L 4 9 L 6 7","-5 5 M -2 -10 L -1 -8 L -1 6 L -3 7 L -2 7 L 0 8 L 1 9 M 0 -8 L -1 -10 L 0 -11 L 0 7 L 2 8 M -2 -10 L 1 -12 L 1 6 L 3 7 L 4 7 L 2 8 L 1 9","-13 13 M -11 -3 L -10 -3 L -9 -2 L -9 6 L -11 7 L -10 7 L -8 8 L -7 9 M -9 -4 L -8 -3 L -8 7 L -6 8 M -11 -3 L -9 -5 L -7 -3 L -7 6 L -5 7 L -7 9 M -7 -2 L -4 -3 L -2 -4 L -1 -5 L 1 -3 L 1 6 L 3 7 L 1 9 M -2 -4 L 0 -3 L 0 7 L 2 8 M -4 -3 L -3 -3 L -1 -2 L -1 6 L -2 7 L 0 8 L 1 9 M 1 -2 L 4 -3 L 6 -4 L 7 -5 L 8 -4 L 10 -3 L 11 -3 L 9 -2 L 9 6 L 10 7 L 11 7 M 6 -4 L 8 -3 L 8 7 L 9 8 M 4 -3 L 5 -3 L 7 -2 L 7 7 L 9 9 L 11 7","-9 9 M -7 -3 L -6 -3 L -5 -2 L -5 6 L -7 7 L -6 7 L -4 8 L -3 9 M -5 -4 L -4 -3 L -4 7 L -2 8 M -7 -3 L -5 -5 L -3 -3 L -3 6 L -1 7 L -3 9 M -3 -2 L 0 -3 L 2 -4 L 3 -5 L 4 -4 L 6 -3 L 7 -3 L 5 -2 L 5 6 L 6 7 L 7 7 M 2 -4 L 4 -3 L 4 7 L 5 8 M 0 -3 L 1 -3 L 3 -2 L 3 7 L 5 9 L 7 7","-9 9 M -5 -3 L -5 6 L -7 7 M -4 -2 L -4 6 L -1 8 M -3 -3 L -3 6 L -1 7 L 0 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 3 7 L 5 7 M -5 -3 L -3 -3 L 0 -4 L 2 -5 L 3 -4 L 5 -3 L 7 -3 L 5 -2 L 5 7 M 1 -4 L 4 -2 L 4 6 M 0 -4 L 1 -3 L 3 -2 L 3 7","-9 9 M -6 -5 L -5 -3 L -5 6 L -7 7 L -5 7 L -5 16 M -5 -4 L -4 -3 L -4 15 L -3 14 L -4 12 M -4 7 L -3 7 L -1 8 M -6 -5 L -4 -4 L -3 -3 L -3 6 L -1 7 L 0 8 M -3 8 L -2 9 L 0 8 L 3 7 L 5 7 M -3 8 L -3 12 L -2 14 L -5 16 M -3 -2 L 0 -3 L 2 -4 L 3 -5 L 4 -4 L 6 -3 L 7 -3 L 5 -2 L 5 7 M 2 -4 L 4 -3 L 4 6 M 0 -3 L 1 -3 L 3 -2 L 3 7","-9 9 M -5 -3 L -5 6 L -7 7 M -4 -2 L -4 7 L -2 8 M -3 -3 L -3 6 L -1 7 L 0 7 M -7 7 L -6 7 L -4 8 L -3 9 L -2 8 L 0 7 L 3 6 M -5 -3 L -3 -3 L 0 -4 L 2 -5 L 3 -4 L 5 -3 L 7 -3 L 5 -2 L 5 16 M 1 -4 L 4 -2 L 4 15 L 3 14 L 4 12 M 0 -4 L 1 -3 L 3 -2 L 3 12 L 2 14 L 5 16","-8 6 M -6 -3 L -5 -3 L -4 -2 L -4 6 L -6 7 L -5 7 L -3 8 L -2 9 M -5 -4 L -3 -3 L -3 7 L -1 8 M -6 -3 L -4 -5 L -2 -3 L -2 6 L 0 7 L 1 7 L -1 8 L -2 9 M -2 -3 L 2 -5 L 3 -4 L 5 -3 L 6 -3 M 1 -4 L 2 -3 L 4 -3 M 0 -4 L 2 -2 L 4 -2 L 6 -3","-8 8 M -5 -3 L -5 1 L -3 2 L 3 2 L 5 3 L 5 7 M -4 -3 L -4 1 M 4 3 L 4 7 M -2 -4 L -3 -3 L -3 1 L -1 2 M 1 2 L 3 3 L 3 7 L 2 8 M -5 -3 L -2 -4 L 0 -5 L 2 -4 L 4 -4 L 5 -5 M -1 -4 L 1 -4 M -2 -4 L 0 -3 L 2 -3 L 4 -4 M 5 7 L 2 8 L 0 9 L -2 8 L -4 8 L -6 9 M 1 8 L -1 8 M 2 8 L 0 7 L -3 7 L -6 9 M 5 -5 L 4 -3 L 2 0 L -3 5 L -6 9","-5 5 M -2 -10 L -1 -8 L -1 6 L -3 7 L -2 7 L 0 8 L 1 9 M 0 -8 L -1 -10 L 0 -11 L 0 7 L 2 8 M -2 -10 L 1 -12 L 1 6 L 3 7 L 4 7 L 2 8 L 1 9 M -4 -5 L -1 -5 M 1 -5 L 4 -5","-9 9 M -7 -3 L -6 -3 L -5 -2 L -5 6 L -7 7 M -6 -4 L -4 -3 L -4 7 L -2 8 M -7 -3 L -5 -5 L -3 -3 L -3 6 L -1 7 L 0 7 M -7 7 L -6 7 L -4 8 L -3 9 L -2 8 L 0 7 L 3 6 M 3 -5 L 4 -4 L 6 -3 L 7 -3 L 5 -2 L 5 6 L 6 7 L 7 7 M 2 -4 L 4 -3 L 4 7 L 5 8 M 3 -5 L 1 -3 L 3 -2 L 3 7 L 5 9 L 7 7","-9 9 M -6 -5 L -5 -3 L -5 6 L -2 9 L 0 7 L 3 6 L 5 6 M -5 -4 L -4 -3 L -4 6 L -1 8 M -6 -5 L -4 -4 L -3 -3 L -3 5 L -2 6 L 0 7 M 3 -5 L 4 -4 L 6 -3 L 7 -3 L 5 -2 L 5 6 M 2 -4 L 4 -3 L 4 5 M 3 -5 L 1 -3 L 3 -2 L 3 6","-13 13 M -10 -5 L -9 -3 L -9 6 L -6 9 L -4 7 L -1 6 M -9 -4 L -8 -3 L -8 6 L -5 8 M -10 -5 L -8 -4 L -7 -3 L -7 5 L -6 6 L -4 7 M -1 -5 L -3 -3 L -1 -2 L -1 6 L 2 9 L 4 7 L 7 6 L 9 6 M -2 -4 L 0 -3 L 0 6 L 3 8 M -1 -5 L 0 -4 L 2 -3 L 1 -2 L 1 5 L 2 6 L 4 7 M 7 -5 L 8 -4 L 10 -3 L 11 -3 L 9 -2 L 9 6 M 6 -4 L 8 -3 L 8 5 M 7 -5 L 5 -3 L 7 -2 L 7 6","-10 9 M -7 -3 L -6 -3 L -4 -2 L -3 -1 L 1 7 L 2 8 L 4 9 L 6 7 M -5 -4 L -3 -3 L 2 7 L 4 8 M -7 -3 L -5 -5 L -3 -4 L -2 -3 L 2 5 L 3 6 L 5 7 L 6 7 M 0 1 L 3 -5 L 4 -4 L 6 -4 L 7 -5 M 3 -4 L 4 -3 L 5 -3 M 2 -3 L 4 -2 L 6 -3 L 7 -5 M -1 3 L -4 9 L -5 8 L -7 8 L -8 9 M -4 8 L -5 7 L -6 7 M -3 7 L -5 6 L -7 7 L -8 9 M -5 2 L -2 2 M 1 2 L 4 2","-9 9 M -7 -3 L -6 -3 L -5 -2 L -5 6 L -7 7 M -6 -4 L -4 -3 L -4 7 L -2 8 M -7 -3 L -5 -5 L -3 -3 L -3 6 L -1 7 L 0 7 M -7 7 L -6 7 L -4 8 L -3 9 L -2 8 L 0 7 L 3 6 M 3 -5 L 4 -4 L 6 -3 L 7 -3 L 5 -2 L 5 10 L 4 13 L 2 15 L 0 16 L -1 15 L -3 14 L -5 14 M 2 -4 L 4 -3 L 4 10 M 1 15 L -1 14 L -2 14 M 3 -5 L 1 -3 L 3 -2 L 3 8 L 4 11 L 4 13 M 2 15 L 1 14 L -1 13 L -3 13 L -5 14","-9 9 M 6 -5 L -6 9 M -6 -3 L -4 -2 L -1 -2 L 2 -3 L 6 -5 M -5 -4 L -3 -3 L 1 -3 M -6 -3 L -4 -5 L -2 -4 L 2 -4 L 6 -5 M -6 9 L -2 7 L 1 6 L 4 6 L 6 7 M -1 7 L 3 7 L 5 8 M -6 9 L -2 8 L 2 8 L 4 9 L 6 7 M -4 2 L 4 2","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
gothicger = ["-8 8","-6 6 M 0 -12 L -1 -11 L -3 -10 L -1 -9 L 0 2 M 0 -9 L 1 -10 L 0 -11 L -1 -10 L 0 -9 L 0 2 M 0 -12 L 1 -11 L 3 -10 L 1 -9 L 0 2 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-9 9 M -4 -12 L -5 -11 L -5 -5 M -4 -11 L -5 -5 M -4 -12 L -3 -11 L -5 -5 M 5 -12 L 4 -11 L 4 -5 M 5 -11 L 4 -5 M 5 -12 L 6 -11 L 4 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 10 M -2 -16 L -2 13 M 2 -16 L 2 13 M 2 -12 L 4 -11 L 5 -9 L 5 -7 L 7 -8 L 6 -10 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -6 L -6 -4 L -3 -2 L 3 0 L 5 1 L 6 3 L 6 6 L 5 8 M 6 -8 L 5 -10 M -6 -6 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 2 M -5 7 L -6 5 M -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 3 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -5 4 L -5 6 L -4 8 L -2 9","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-13 13 M 7 -4 L 8 -3 L 9 -3 L 10 -4 M 6 -3 L 7 -2 L 9 -2 M 6 -2 L 7 -1 L 8 -1 L 9 -2 L 10 -4 M 7 -4 L 1 2 M 0 3 L -6 9 L -10 4 L -4 -2 M -3 -3 L 1 -7 L -3 -12 L -8 -6 L -2 0 L 2 6 L 4 8 L 6 9 L 8 9 L 9 8 L 10 6 M -6 8 L -9 4 M 0 -7 L -3 -11 M -7 -6 L -2 -1 L 2 5 L 4 7 L 6 8 L 9 8 M -5 8 L -9 3 M 0 -6 L -4 -11 M -7 -7 L -1 -1 L 3 5 L 4 6 L 6 7 L 9 7 L 10 6","-4 5 M 1 -12 L 0 -11 L 0 -5 M 1 -11 L 0 -5 M 1 -12 L 2 -11 L 0 -5","-7 7 M 3 -16 L 1 -14 L -1 -11 L -3 -7 L -4 -2 L -4 2 L -3 7 L -1 11 L 1 14 L 3 16 M -1 -10 L -2 -7 L -3 -3 L -3 3 L -2 7 L -1 10 M 1 -14 L 0 -12 L -1 -9 L -2 -3 L -2 3 L -1 9 L 0 12 L 1 14","-7 7 M -3 -16 L -1 -14 L 1 -11 L 3 -7 L 4 -2 L 4 2 L 3 7 L 1 11 L -1 14 L -3 16 M 1 -10 L 2 -7 L 3 -3 L 3 3 L 2 7 L 1 10 M -1 -14 L 0 -12 L 1 -9 L 2 -3 L 2 3 L 1 9 L 0 12 L -1 14","-8 8 M 0 -12 L -1 -11 L 1 -1 L 0 0 M 0 -12 L 0 0 M 0 -12 L 1 -11 L -1 -1 L 0 0 M -5 -9 L -4 -9 L 4 -3 L 5 -3 M -5 -9 L 5 -3 M -5 -9 L -5 -8 L 5 -4 L 5 -3 M 5 -9 L 4 -9 L -4 -3 L -5 -3 M 5 -9 L -5 -3 M 5 -9 L 5 -8 L -5 -4 L -5 -3","-12 13 M 0 -9 L 0 8 L 1 8 M 0 -9 L 1 -9 L 1 8 M -8 -1 L 9 -1 L 9 0 M -8 -1 L -8 0 L 9 0","-6 6 M 0 12 L 0 10 L -2 8 L 0 6 L 1 8 L 1 10 L 0 12 L -2 13 M 0 7 L -1 8 L 0 9 L 0 7","-13 13 M -9 0 L 9 0","-6 6 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-11 12 M 9 -16 L -9 16 L -8 16 M 9 -16 L 10 -16 L -8 16","-10 10 M -6 -10 L -6 6 L -8 7 M -5 -9 L -5 6 L -2 8 M -4 -10 L -4 6 L -2 7 L -1 8 M -6 -10 L -4 -10 L 1 -11 L 3 -12 M 1 -11 L 2 -10 L 4 -9 L 4 7 M 2 -11 L 5 -9 L 5 6 M 3 -12 L 4 -11 L 6 -10 L 8 -10 L 6 -9 L 6 7 M -8 7 L -6 7 L -4 8 L -3 9 L -1 8 L 4 7 L 6 7","-10 10 M -3 -10 L -2 -9 L -1 -7 L -1 6 L -3 7 M -1 -9 L -2 -10 L -1 -11 L 0 -9 L 0 7 L 2 8 M -3 -10 L 0 -12 L 1 -10 L 1 6 L 3 7 L 4 7 M -3 7 L -2 7 L 0 8 L 1 9 L 2 8 L 4 7","-10 10 M -6 -10 L -4 -10 L -2 -11 L -1 -12 L 1 -11 L 4 -10 L 6 -10 M -2 -10 L 0 -11 M -6 -10 L -4 -9 L -2 -9 L 0 -10 L 1 -11 M 4 -10 L 4 -2 M 5 -9 L 5 -3 M 6 -10 L 6 -2 L -1 -2 L -4 -1 L -6 1 L -7 4 L -7 9 M -7 9 L -3 7 L 1 6 L 4 6 L 8 7 M -4 8 L -1 7 L 4 7 L 7 8 M -7 9 L -2 8 L 3 8 L 6 9 L 8 7","-10 10 M -6 -10 L -5 -10 L -3 -11 L -2 -12 L 0 -11 L 4 -10 L 6 -10 M -3 -10 L -1 -11 M -6 -10 L -4 -9 L -2 -9 L 0 -11 M 4 -10 L 4 -3 M 5 -9 L 5 -4 M 6 -10 L 6 -3 L 4 -3 L 1 -2 L -1 -1 M -1 -2 L 1 -1 L 4 0 L 6 0 L 6 7 M 5 1 L 5 6 M 4 0 L 4 7 M -7 7 L -5 6 L -3 6 L -1 7 L 0 8 M -3 7 L -1 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 4 7 L 6 7","-10 10 M 3 -12 L -7 -2 L -7 3 L 2 3 M 4 3 L 8 3 L 9 4 L 9 2 L 8 3 M -6 -2 L -6 2 M -5 -4 L -5 3 M 2 -11 L 2 6 L 0 7 M 3 -8 L 4 -10 L 3 -11 L 3 7 L 5 8 M 3 -12 L 5 -10 L 4 -8 L 4 6 L 6 7 L 7 7 M 0 7 L 1 7 L 3 8 L 4 9 L 5 8 L 7 7","-10 10 M -6 -12 L -6 -3 M -6 -12 L 6 -12 M -5 -11 L 4 -11 M -6 -10 L 3 -10 L 5 -11 L 6 -12 M 4 -6 L 3 -5 L 1 -4 L -3 -3 L -6 -3 M 1 -4 L 2 -4 L 4 -3 L 4 7 M 3 -5 L 5 -4 L 5 6 M 4 -6 L 5 -5 L 7 -4 L 8 -4 L 6 -3 L 6 7 M -7 7 L -5 6 L -3 6 L -1 7 L 0 8 M -3 7 L -1 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 4 7 L 6 7","-10 10 M -6 -10 L -6 6 L -8 7 M -5 -9 L -5 6 L -2 8 M -4 -10 L -4 6 L -2 7 L -1 8 M -6 -10 L -4 -10 L 0 -11 L 2 -12 L 3 -11 L 5 -10 L 6 -10 M 1 -11 L 3 -10 M 0 -11 L 2 -9 L 4 -9 L 6 -10 M -4 -2 L -3 -2 L 1 -3 L 3 -4 L 4 -5 M 1 -3 L 2 -3 L 4 -2 L 4 7 M 3 -4 L 5 -2 L 5 6 M 4 -5 L 5 -4 L 7 -3 L 8 -3 L 6 -2 L 6 7 M -8 7 L -6 7 L -4 8 L -3 9 L -1 8 L 4 7 L 6 7","-10 10 M -7 -10 L -5 -12 L -2 -11 L 3 -11 L 8 -12 M -6 -11 L -3 -10 L 2 -10 L 5 -11 M -7 -10 L -3 -9 L 0 -9 L 4 -10 L 8 -12 M 8 -12 L 7 -10 L 5 -7 L 1 -3 L -1 0 L -2 3 L -2 6 L -1 9 M 0 -1 L -1 2 L -1 5 L 0 8 M 3 -5 L 1 -2 L 0 1 L 0 4 L 1 7 L -1 9","-10 10 M -6 -9 L -6 -3 M -5 -8 L -5 -4 M -4 -9 L -4 -3 M -6 -9 L -4 -9 L 1 -10 L 3 -11 L 4 -12 M 1 -10 L 2 -10 L 4 -9 L 4 -3 M 3 -11 L 5 -10 L 5 -4 M 4 -12 L 5 -11 L 7 -10 L 8 -10 L 6 -9 L 6 -3 M -6 -3 L -4 -3 L 4 0 L 6 0 M 6 -3 L 4 -3 L -4 0 L -6 0 M -6 0 L -6 6 L -8 7 M -5 1 L -5 6 L -2 8 M -4 0 L -4 6 L -2 7 L -1 8 M 4 0 L 4 7 M 5 1 L 5 6 M 6 0 L 6 7 M -8 7 L -6 7 L -4 8 L -3 9 L -1 8 L 4 7 L 6 7","-10 10 M -6 -10 L -6 -1 L -8 0 M -5 -9 L -5 0 L -3 1 M -4 -10 L -4 -1 L -2 0 L -1 0 M -6 -10 L -4 -10 L 1 -11 L 3 -12 M 1 -11 L 2 -10 L 4 -9 L 4 7 M 2 -11 L 5 -9 L 5 6 M 3 -12 L 4 -11 L 6 -10 L 8 -10 L 6 -9 L 6 7 M -8 0 L -7 0 L -5 1 L -4 2 L -3 1 L -1 0 L 3 -1 L 4 -1 M -7 7 L -5 6 L -3 6 L -1 7 L 0 8 M -3 7 L -1 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 4 7 L 6 7","-6 6 M 0 -5 L -2 -3 L 0 -2 L 2 -3 L 0 -5 M 0 -4 L -1 -3 L 1 -3 L 0 -4 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-6 6 M 0 -5 L -2 -3 L 0 -2 L 2 -3 L 0 -5 M 0 -4 L -1 -3 L 1 -3 L 0 -4 M 0 12 L 0 10 L -2 8 L 0 6 L 1 8 L 1 10 L 0 12 L -2 13 M 0 7 L -1 8 L 0 9 L 0 7","-12 12 M 8 -9 L -8 0 L 8 9","-12 13 M -8 -5 L 9 -5 L 9 -4 M -8 -5 L -8 -4 L 9 -4 M -8 3 L 9 3 L 9 4 M -8 3 L -8 4 L 9 4","-12 12 M -8 -9 L 8 0 L -8 9","-9 9 M -6 -8 L -5 -10 L -4 -11 L -1 -12 L 1 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 3 -2 L 1 -1 M -5 -8 L -4 -10 M 4 -10 L 5 -9 L 5 -5 L 4 -4 M -6 -8 L -4 -7 L -4 -9 L -3 -11 L -1 -12 M 1 -12 L 3 -11 L 4 -9 L 4 -5 L 3 -3 L 1 -1 M 0 -1 L 0 2 L 1 -1 L -1 -1 L 0 2 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-12 12 M -9 -10 L -8 -9 L -9 -8 L -10 -9 L -9 -11 L -7 -12 L -5 -12 L -3 -11 L -2 -10 L -1 -7 L -1 -3 L -2 0 L -4 2 L -6 3 L -9 4 M -3 -10 L -2 -7 L -2 -2 L -3 0 M -5 -12 L -4 -11 L -3 -8 L -3 -2 L -4 1 L -6 3 M -6 4 L -3 7 M -7 4 L -3 8 M -9 4 L -4 9 L 3 4 M 10 -11 L 9 -10 L 10 -10 L 10 -11 L 9 -12 L 7 -12 L 5 -11 L 4 -10 L 3 -8 L 3 7 L 5 9 L 9 5 M 5 -10 L 4 -8 L 4 6 L 6 8 M 7 -12 L 6 -11 L 5 -8 L 5 5 L 7 7","-13 13 M -11 -1 L -11 0 L -10 1 L -8 1 L -6 0 L -6 -3 L -7 -5 L -9 -8 L -9 -10 L -7 -12 M -7 -3 L -9 -7 M -8 1 L -7 0 L -7 -2 L -9 -5 L -10 -7 L -10 -9 L -9 -11 L -7 -12 L -4 -12 L -2 -11 L -1 -10 L 0 -8 L 0 0 L -1 3 L -3 5 M -2 -10 L -1 -8 L -1 2 M -4 -12 L -3 -11 L -2 -8 L -2 3 L -3 5 M 0 -9 L 1 -11 L 3 -12 L 5 -12 L 7 -11 L 8 -10 L 9 -8 L 10 -7 M 7 -10 L 8 -8 M 5 -12 L 6 -11 L 7 -8 L 8 -7 L 10 -7 M 10 -7 L 0 -2 M 7 -5 L 9 -3 L 10 0 L 10 3 L 9 6 L 7 8 L 4 9 L 1 9 L -2 8 L -8 5 L -9 5 L -10 6 M 6 -4 L 7 -4 L 9 -2 M 4 -4 L 7 -3 L 9 -1 L 10 1 M 2 8 L 0 8 L -6 5 L -7 5 M 8 7 L 6 8 L 3 8 L 0 7 L -4 5 L -7 4 L -9 4 L -10 6 L -10 8 L -9 9 L -8 8 L -9 7","-12 12 M 0 -10 L -2 -12 L -4 -12 L -6 -11 L -8 -8 L -9 -4 L -9 0 L -8 4 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 9 5 M -6 -10 L -7 -8 L -8 -5 L -8 0 L -7 4 L -5 7 L -2 8 M -4 -12 L -5 -11 L -6 -9 L -7 -5 L -7 -1 L -6 3 L -5 5 L -3 7 L 0 8 L 3 8 L 6 7 L 9 5 M 3 -12 L 0 -10 L -1 -9 L -2 -7 L -2 -6 L -1 -4 L 2 -2 L 3 0 L 3 2 M -1 -7 L -1 -6 L 3 -2 L 3 -1 M -1 -9 L -1 -8 L 0 -6 L 3 -4 L 4 -2 L 4 0 L 3 2 L 1 3 L 0 3 L -2 2 L -3 0 M 3 -12 L 4 -11 L 6 -10 L 8 -10 M 3 -11 L 4 -10 L 5 -10 M 2 -11 L 4 -9 L 6 -9 L 8 -10 L 9 -11","-13 13 M -10 -6 L -10 -7 L -9 -9 L -7 -11 L -4 -12 L 0 -12 L 3 -11 L 5 -10 L 7 -8 L 9 -5 L 10 -1 L 10 3 L 9 6 L 7 8 L 4 9 L 1 9 L -2 8 L -8 5 L -9 5 L -10 6 M -7 -10 L -5 -11 L 0 -11 L 3 -10 L 5 -9 L 7 -7 L 9 -4 M 2 8 L 0 8 L -6 5 L -7 5 M -10 -7 L -8 -9 L -5 -10 L 0 -10 L 3 -9 L 5 -8 L 7 -6 L 9 -3 L 10 0 M 8 7 L 6 8 L 3 8 L 0 7 L -4 5 L -7 4 L -9 4 L -10 6 L -10 8 L -9 9 L -8 8 L -9 7 M -2 -10 L -5 -7 L -6 -5 L -6 -3 L -4 1 L -4 3 M -5 -4 L -5 -3 L -4 -1 L -4 0 M -5 -7 L -5 -5 L -3 -1 L -3 1 L -4 3 L -5 4 L -7 4 L -8 3 L -8 2","-12 12 M 0 -10 L -2 -12 L -4 -12 L -6 -11 L -8 -8 L -9 -4 L -9 0 L -8 4 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 9 5 M -6 -10 L -7 -8 L -8 -5 L -8 0 L -7 4 L -5 7 L -2 8 M -4 -12 L -5 -11 L -6 -9 L -7 -5 L -7 -1 L -6 3 L -5 5 L -3 7 L 0 8 L 3 8 L 6 7 L 9 5 M 3 -12 L 0 -10 L -1 -9 L -2 -7 L -2 -6 L -1 -4 L 2 -2 L 3 0 L 3 2 M -1 -7 L -1 -6 L 3 -2 L 3 -1 M -1 -9 L -1 -8 L 0 -6 L 3 -4 L 4 -2 L 4 0 L 3 2 L 1 3 L 0 3 L -2 2 L -3 0 M 3 -12 L 4 -11 L 6 -10 L 8 -10 M 3 -11 L 4 -10 L 5 -10 M 2 -11 L 4 -9 L 6 -9 L 8 -10 L 9 -11 M 3 -4 L 7 -7 M 7 -7 L 8 -6 L 10 -6 M 6 -6 L 7 -5 L 8 -5 M 5 -5 L 6 -4 L 8 -4 L 10 -6","-12 12 M -5 -4 L -7 -5 L -8 -7 L -8 -9 L -7 -11 L -4 -12 L -1 -12 L 2 -11 L 6 -9 M -7 -10 L -5 -11 L 0 -11 L 3 -10 M -8 -7 L -7 -9 L -5 -10 L 0 -10 L 6 -9 L 8 -9 L 9 -10 L 9 -11 L 8 -12 L 7 -12 M 1 -10 L 0 -9 L -1 -7 L -1 -5 L 0 -3 L 4 1 L 5 4 L 5 7 L 4 10 L 3 11 L 1 12 M 2 -2 L 5 1 L 6 4 L 6 7 L 5 9 M -1 -5 L 1 -3 L 4 -1 L 6 1 L 7 4 L 7 7 L 6 9 L 4 11 L 1 12 L -3 12 L -6 11 L -7 10 L -8 8 L -8 5 L -6 2 L -6 0 L -7 -1 M -6 10 L -7 9 L -7 5 L -6 3 M -3 12 L -5 11 L -6 9 L -6 5 L -5 2 L -5 0 L -6 -1 L -8 -1 L -9 0 L -9 1 M 3 -2 L 7 -6 M 7 -6 L 8 -5 L 10 -5 M 6 -5 L 7 -4 L 8 -4 M 5 -4 L 6 -3 L 8 -3 L 10 -5","-13 13 M 3 -8 L 2 -10 L 1 -11 L -1 -12 L -4 -12 L -7 -11 L -9 -8 L -10 -4 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 9 5 L 10 2 L 10 -1 L 9 -4 L 7 -6 M -7 -10 L -8 -8 L -9 -5 L -9 0 L -8 3 L -7 5 M 8 5 L 9 3 L 9 -1 L 8 -4 L 7 -5 M -4 -12 L -6 -11 L -7 -9 L -8 -5 L -8 0 L -7 4 L -6 6 L -4 8 M 5 8 L 7 6 L 8 3 L 8 -1 L 7 -3 L 5 -5 M 3 -12 L 0 -10 L -2 -8 L -3 -6 L -3 -5 L -2 -3 L 1 -1 L 2 1 L 2 3 M -2 -6 L -2 -5 L 2 -1 L 2 0 M -2 -8 L -2 -7 L -1 -5 L 2 -3 L 3 -1 L 3 1 L 2 3 L 0 4 L -1 4 L -3 3 L -4 1 M 2 -3 L 7 -6 L 8 -8 M 10 -12 L 8 -8 M 7 -11 L 11 -9 M 10 -12 L 9 -11 L 7 -11 L 8 -10 L 8 -8 L 9 -9 L 11 -9 L 10 -10 L 10 -12","-12 13 M 0 -12 L -2 -11 L -4 -9 L -5 -7 L -5 -5 L -4 -3 L -2 -1 L -1 1 L -1 3 M -4 -6 L -4 -5 L -1 -1 L -1 0 M -4 -9 L -4 -7 L -3 -5 L -1 -3 L 0 -1 L 0 1 L -1 3 L -2 4 L -4 5 L -6 5 L -8 4 L -9 3 L -10 1 L -10 -1 L -9 -2 L -8 -1 L -9 0 M 0 -12 L 2 -10 L 4 -10 L 6 -11 M -1 -11 L 1 -10 M -2 -11 L -1 -10 L 1 -9 L 3 -9 L 6 -11 M 0 -2 L 7 -7 M 7 -7 L 9 -4 L 10 -1 L 10 2 L 9 5 L 7 7 L 4 8 L 0 9 M 6 -6 L 8 -4 L 9 -1 L 9 3 L 8 5 M 4 -5 L 5 -5 L 7 -3 L 8 0 L 8 4 L 7 6 L 6 7 L 4 8 M 4 8 L 2 8 L 0 7 L -2 7 L -4 8 L -5 10 L -4 12 L -2 13 L 0 13 L 2 12 M 1 8 L -1 8 M 0 9 L -2 8 L -4 8","-12 13 M -2 -2 L -4 -2 L -6 -3 L -7 -4 L -8 -6 L -8 -8 L -7 -10 L -6 -11 L -3 -12 L -1 -12 L 2 -11 L 5 -8 L 7 -7 M -6 -10 L -4 -11 L 0 -11 L 2 -10 L 3 -9 M -8 -8 L -7 -9 L -5 -10 L -1 -10 L 2 -9 L 4 -8 L 7 -7 L 9 -7 L 10 -8 L 10 -10 L 9 -11 L 7 -11 M -8 6 L -7 7 L -8 8 L -9 7 L -9 5 L -8 4 L -6 4 L -4 5 L -2 7 L 0 10 L 2 12 M -4 6 L -3 7 L -1 10 L 0 11 M -6 4 L -5 5 L -4 7 L -2 10 L -1 11 L 1 12 L 4 12 L 6 11 L 7 10 L 8 8 L 8 5 L 7 3 L 5 0 L 4 -2 L 4 -3 M 7 6 L 7 5 L 4 0 L 4 -1 M 6 11 L 7 9 L 7 7 L 6 5 L 4 2 L 3 0 L 3 -2 L 5 -4 L 7 -4 L 8 -3 L 8 -2","-12 13 M -2 -2 L -4 -2 L -6 -3 L -7 -4 L -8 -6 L -8 -8 L -7 -10 L -6 -11 L -3 -12 L -1 -12 L 2 -11 L 5 -8 L 7 -7 M -6 -10 L -4 -11 L 0 -11 L 2 -10 L 3 -9 M -8 -8 L -7 -9 L -5 -10 L -1 -10 L 2 -9 L 4 -8 L 7 -7 L 9 -7 L 10 -8 L 10 -10 L 9 -11 L 7 -11 M -8 6 L -7 7 L -8 8 L -9 7 L -9 5 L -8 4 L -6 4 L -4 5 L -2 7 L 0 10 L 2 12 M -4 6 L -3 7 L -1 10 L 0 11 M -6 4 L -5 5 L -4 7 L -2 10 L -1 11 L 1 12 L 4 12 L 6 11 L 7 10 L 8 8 L 8 5 L 7 3 L 5 0 L 4 -2 L 4 -3 M 7 6 L 7 5 L 4 0 L 4 -1 M 6 11 L 7 9 L 7 7 L 6 5 L 4 2 L 3 0 L 3 -2 L 5 -4 L 7 -4 L 8 -3 L 8 -2","-13 13 M 9 -7 L 8 -9 L 6 -11 L 3 -12 L 0 -12 L -3 -11 L -5 -9 L -6 -7 L -6 -4 L -5 -1 L -2 5 L -2 7 L -4 9 M -5 -4 L -5 -3 L -2 3 L -2 4 M -4 -10 L -5 -8 L -5 -5 L -4 -3 L -2 1 L -1 4 L -1 6 L -2 8 L -4 9 L -6 9 L -8 8 M -10 4 L -8 8 M -11 7 L -7 5 M -10 4 L -10 6 L -11 7 L -9 7 L -8 8 L -8 6 L -7 5 L -9 5 L -10 4 M -4 -3 L -4 -5 L -3 -7 L -1 -8 L 2 -8 L 4 -7 L 6 -5 L 7 -5 M 3 -7 L 5 -5 M 0 -8 L 2 -7 L 3 -6 L 4 -4 M 7 -5 L -2 -1 M 3 -3 L 7 6 L 8 7 L 9 7 M 2 -2 L 6 6 L 8 8 M 1 -2 L 5 7 L 7 9 L 10 6","-11 12 M 8 1 L 7 2 L 4 2 L 3 1 L 3 -1 L 4 -3 L 6 -6 L 7 -8 L 7 -10 M 4 -1 L 4 -2 L 7 -6 L 7 -7 M 5 2 L 4 1 L 4 0 L 5 -2 L 7 -4 L 8 -6 L 8 -8 L 7 -10 L 6 -11 L 3 -12 L -2 -12 L -5 -11 L -6 -10 L -7 -8 L -7 -6 L -6 -4 L -4 -1 L -3 1 L -3 2 L -4 4 M -6 -7 L -6 -6 L -3 -1 L -3 0 M -6 -10 L -6 -8 L -5 -6 L -3 -3 L -2 -1 L -2 1 L -3 3 L -5 5 L -8 7 M -5 5 L -3 5 L 0 7 L 3 8 L 6 8 L 8 7 M -4 6 L -3 6 L 1 8 L 2 8 M -8 7 L -6 6 L -5 6 L -1 8 L 2 9 L 4 9 L 7 8 L 8 7 L 9 5","-16 16 M -13 -1 L -13 0 L -12 1 L -10 1 L -8 0 L -8 -3 L -9 -5 L -11 -8 L -11 -10 L -9 -12 M -9 -3 L -11 -7 M -10 1 L -9 0 L -9 -2 L -11 -5 L -12 -7 L -12 -9 L -11 -11 L -9 -12 L -7 -12 L -5 -11 L -3 -9 L -2 -6 L -2 0 L -3 3 L -4 5 L -6 7 L -9 9 L -10 8 L -11 8 M -4 -9 L -3 -6 L -3 0 L -4 3 L -5 5 M -8 8 L -9 7 L -10 7 M -7 -12 L -5 -10 L -4 -7 L -4 0 L -5 4 L -6 6 L -7 7 L -8 6 L -9 6 L -12 9 M -4 -11 L -2 -12 L 0 -12 L 2 -11 L 4 -9 L 5 -6 L 5 0 L 4 3 L 3 5 L 1 7 L -1 9 L -2 8 L -3 8 M 3 -9 L 4 -6 L 4 0 L 3 4 M 0 8 L -1 7 L -2 7 M 0 -12 L 2 -10 L 3 -7 L 3 1 L 2 5 L 1 7 L 0 6 L -1 6 L -4 9 M 3 -10 L 4 -11 L 6 -12 L 8 -12 L 10 -11 L 11 -10 L 12 -8 L 13 -7 M 10 -10 L 11 -8 M 8 -12 L 9 -11 L 10 -8 L 11 -7 L 13 -7 M 13 -7 L 10 -5 L 9 -4 L 8 -1 L 8 2 L 9 6 L 11 9 L 14 6 M 10 -4 L 9 -2 L 9 2 L 10 5 L 12 8 M 13 -7 L 11 -5 L 10 -3 L 10 1 L 11 5 L 13 7","-14 14 M -11 -1 L -11 0 L -10 1 L -8 1 L -6 0 L -6 -3 L -7 -5 L -9 -8 L -9 -10 L -7 -12 M -7 -3 L -9 -7 M -8 1 L -7 0 L -7 -2 L -9 -5 L -10 -7 L -10 -9 L -9 -11 L -7 -12 L -4 -12 L -2 -11 L 0 -9 L 1 -6 L 1 0 L 0 3 L -1 5 L -3 7 L -6 9 L -7 8 L -9 8 L -11 9 M -1 -9 L 0 -7 L 0 0 L -1 3 L -2 5 L -3 6 M -5 8 L -7 7 L -9 7 M -4 -12 L -2 -10 L -1 -7 L -1 0 L -2 4 L -4 7 L -6 6 L -8 6 L -11 9 M 0 -10 L 1 -11 L 3 -12 L 5 -12 L 7 -11 L 8 -10 L 9 -8 L 10 -7 M 7 -10 L 8 -8 M 5 -12 L 6 -11 L 7 -8 L 8 -7 L 10 -7 M 10 -7 L 7 -5 L 6 -4 L 5 -1 L 5 2 L 6 6 L 8 9 L 11 6 M 7 -4 L 6 -2 L 6 2 L 7 5 L 9 8 M 10 -7 L 8 -5 L 7 -3 L 7 1 L 8 5 L 10 7","-14 14 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -7 -5 L -5 -1 L -5 1 M -6 -6 L -6 -5 L -5 -3 L -5 -2 M -6 -9 L -6 -7 L -4 -3 L -4 -1 L -5 1 L -6 2 L -8 2 L -9 1 L -9 0 M -2 -12 L -1 -11 L 5 -9 L 8 -7 L 9 -5 L 10 -2 L 10 1 L 9 4 L 8 6 L 6 8 L 3 9 L 0 9 L -3 8 L -9 5 L -10 5 L -11 6 M -2 -11 L -1 -10 L 5 -8 L 7 -7 L 8 -6 M -2 -12 L -2 -10 L -1 -9 L 5 -7 L 7 -6 L 9 -4 L 10 -2 M 1 8 L -1 8 L -7 5 L -8 5 M 7 7 L 5 8 L 2 8 L -1 7 L -5 5 L -8 4 L -10 4 L -11 6 L -11 8 L -10 9 L -9 8 L -10 7","-13 14 M -10 -1 L -10 0 L -9 1 L -7 1 L -5 0 L -5 -3 L -6 -5 L -8 -8 L -8 -10 L -6 -12 M -6 -3 L -8 -7 M -7 1 L -6 0 L -6 -2 L -8 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -3 -12 L -1 -11 L 0 -10 L 1 -8 L 1 3 M 1 5 L 1 10 L 0 12 L -2 13 L -5 13 L -6 12 L -6 10 L -5 9 L -4 10 L -5 11 M -1 -10 L 0 -8 L 0 10 L -1 12 M -3 -12 L -2 -11 L -1 -8 L -1 3 M -1 5 L -1 10 L -2 12 L -3 13 M 1 -8 L 6 -12 M 6 -12 L 8 -9 L 9 -7 L 10 -3 L 10 0 L 9 3 L 7 6 L 4 9 M 5 -11 L 8 -7 L 9 -4 L 9 -3 M 4 -10 L 6 -8 L 8 -5 L 9 -2 L 9 1 L 8 4 L 7 6 M 5 7 L 3 4 L 1 3 M -1 3 L -3 4 L -5 6 M 5 8 L 3 5 L 1 4 L -2 4 M 4 9 L 2 6 L 1 5 M -1 5 L -3 5 L -5 6","-14 14 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -7 -5 L -5 -1 L -5 1 M -6 -6 L -6 -5 L -5 -3 L -5 -2 M -6 -9 L -6 -7 L -4 -3 L -4 -1 L -5 1 L -6 2 L -8 2 L -9 1 L -9 0 M -2 -12 L -1 -11 L 5 -9 L 8 -7 L 9 -5 L 10 -2 L 10 1 L 9 4 L 8 6 M 6 8 L 3 9 L 0 9 L -3 8 L -9 5 L -10 5 L -11 6 M -2 -11 L -1 -10 L 5 -8 L 7 -7 L 8 -6 M -2 -12 L -2 -10 L -1 -9 L 5 -7 L 7 -6 L 9 -4 L 10 -2 M 1 8 L -1 8 L -7 5 L -8 5 M 6 8 L 2 8 L -1 7 L -5 5 L -8 4 L -10 4 L -11 6 L -11 8 L -10 9 L -9 8 L -10 7 M 2 6 L 4 4 L 6 4 L 10 8 L 11 8 M 5 5 L 6 5 L 9 8 M 3 5 L 4 5 L 8 9 L 10 9 L 12 7","-14 14 M -11 -1 L -11 0 L -10 1 L -8 1 L -6 0 L -6 -3 L -7 -5 L -9 -8 L -9 -10 L -7 -12 M -7 -3 L -9 -7 M -8 1 L -7 0 L -7 -2 L -9 -5 L -10 -7 L -10 -9 L -9 -11 L -7 -12 L -4 -12 L -2 -11 L -1 -10 L 0 -8 L 0 4 L -1 6 L -3 8 L -5 9 L -7 9 L -9 8 M -2 -10 L -1 -8 L -1 4 L -2 6 M -4 -12 L -3 -11 L -2 -8 L -2 4 L -3 7 L -5 9 M -11 4 L -9 8 M -12 7 L -8 5 M -11 4 L -11 6 L -12 7 L -10 7 L -9 8 L -9 6 L -8 5 L -10 5 L -11 4 M 0 -9 L 1 -11 L 3 -12 L 5 -12 L 7 -11 L 8 -10 L 9 -8 L 10 -7 M 7 -10 L 8 -8 M 5 -12 L 6 -11 L 7 -8 L 8 -7 L 10 -7 M 10 -7 L 0 -2 M 2 -3 L 6 7 L 8 9 L 11 6 M 3 -3 L 7 6 L 9 8 M 4 -4 L 8 6 L 9 7 L 10 7","-13 14 M 10 -10 L 9 -11 L 10 -12 L 11 -11 L 11 -9 L 10 -7 L 8 -7 L 4 -9 L 1 -10 L -3 -10 L -7 -9 L -9 -7 M 7 -8 L 4 -10 L 1 -11 L -3 -11 L -6 -10 M 11 -9 L 10 -8 L 8 -8 L 4 -11 L 1 -12 L -3 -12 L -6 -11 L -8 -9 L -9 -7 L -10 -4 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 3 9 L 6 8 L 8 7 L 10 5 L 11 2 L 11 -1 L 10 -3 L 8 -4 L 5 -4 L 3 -3 L 1 0 L -1 1 L -3 1 M -6 6 L -4 7 L -1 8 L 3 8 L 7 7 M -9 3 L -7 5 L -5 6 L -2 7 L 3 7 L 7 6 L 9 5 L 10 4 L 11 2 M 6 -3 L 5 -3 L 1 1 L 0 1 M 11 -1 L 9 -3 L 7 -3 L 5 -2 L 3 1 L 1 2 L -1 2 L -3 1 L -4 -1 L -4 -3 L -3 -5 L -1 -6","-12 13 M -6 -4 L -8 -5 L -9 -7 L -9 -9 L -8 -11 L -5 -12 L 0 -12 L 3 -11 L 7 -8 L 9 -8 L 10 -9 M -8 -10 L -6 -11 L 0 -11 L 3 -10 L 6 -8 M -9 -7 L -8 -9 L -6 -10 L 0 -10 L 3 -9 L 7 -7 L 9 -7 L 10 -9 L 10 -11 L 9 -12 L 8 -11 L 9 -10 M 3 -9 L 0 -6 L -1 -4 L -1 -2 L 1 2 L 1 4 M 0 -3 L 0 -2 L 1 0 L 1 1 M 0 -6 L 0 -4 L 2 0 L 2 2 L 1 4 L 0 5 L -2 5 L -3 4 L -3 2 M -8 7 L -7 8 L -8 9 L -9 8 L -9 6 L -8 4 L -6 4 L -3 5 L 1 7 L 4 8 L 7 8 L 9 7 M -6 5 L -5 5 L 1 8 L 3 8 M -9 6 L -8 5 L -7 5 L -5 6 L -1 8 L 2 9 L 5 9 L 8 8 L 10 6","-11 11 M -8 -10 L -7 -10 L -6 -9 L -6 5 L -8 6 M -7 -11 L -5 -10 L -5 6 L -2 8 M -9 -9 L -6 -12 L -4 -10 L -4 5 L -2 7 L 0 7 M -8 6 L -7 6 L -5 7 L -3 9 L 0 7 L 4 4 M 2 -10 L 3 -10 L 4 -9 L 4 7 L 6 9 L 9 6 M 3 -11 L 5 -10 L 5 7 L 7 8 M 1 -9 L 4 -12 L 7 -10 L 6 -9 L 6 6 L 7 7 L 8 7","-14 14 M -11 -1 L -11 0 L -10 1 L -8 1 L -6 0 L -6 -3 L -7 -5 L -9 -8 L -9 -10 L -7 -12 M -7 -3 L -9 -7 M -8 1 L -7 0 L -7 -2 L -9 -5 L -10 -7 L -10 -9 L -9 -11 L -7 -12 L -4 -12 L -2 -11 L -1 -10 L 0 -8 L 0 0 L -1 3 L -3 5 M -2 -10 L -1 -8 L -1 2 M -4 -12 L -3 -11 L -2 -8 L -2 3 L -3 5 M 0 -9 L 1 -11 L 3 -12 L 5 -12 L 7 -11 L 9 -8 L 10 -7 M 7 -10 L 8 -8 M 5 -12 L 6 -11 L 7 -8 L 8 -7 L 10 -7 M 8 -7 L 6 -7 L 5 -6 L 5 -4 L 6 -2 L 9 0 L 10 2 M 6 -3 L 9 -1 M 5 -5 L 6 -4 L 9 -2 L 10 0 L 10 4 L 9 6 L 7 8 L 5 9 L 1 9 L -2 8 L -8 5 L -9 5 L -10 6 M 2 8 L 0 8 L -6 5 L -7 5 M 8 7 L 6 8 L 3 8 L 0 7 L -4 5 L -7 4 L -9 4 L -10 6 L -10 8 L -9 9 L -8 8 L -9 7","-16 17 M -13 -1 L -13 0 L -12 1 L -10 1 L -8 0 L -8 -3 L -9 -5 L -11 -8 L -11 -10 L -9 -12 M -9 -3 L -11 -7 M -10 1 L -9 0 L -9 -2 L -11 -5 L -12 -7 L -12 -9 L -11 -11 L -9 -12 L -6 -12 L -4 -11 L -3 -10 L -2 -8 L -2 -4 L -3 -1 L -5 2 L -7 4 M -4 -10 L -3 -8 L -3 -3 L -4 0 M -6 -12 L -5 -11 L -4 -8 L -4 -3 L -5 1 L -7 4 M -4 -11 L -2 -12 L 1 -12 L 3 -11 M 5 -12 L 2 -11 L 1 -9 L 1 -5 L 2 -2 L 4 1 L 5 3 L 5 5 L 4 7 M 2 -5 L 2 -4 L 5 1 L 5 2 M 5 -12 L 3 -11 L 2 -9 L 2 -6 L 3 -4 L 5 -1 L 6 2 L 6 4 L 5 6 L 3 8 L 1 9 L -3 9 L -5 8 L -7 6 L -9 5 L -11 5 L -12 6 M -4 8 L -7 5 L -8 5 M -1 9 L -3 8 L -6 5 L -8 4 L -11 4 L -12 6 L -12 8 L -11 9 L -10 8 L -11 7 M 5 -12 L 8 -12 L 10 -11 L 12 -8 L 13 -7 M 10 -10 L 11 -8 M 8 -12 L 9 -11 L 10 -8 L 11 -7 L 13 -7 M 11 -7 L 9 -7 L 8 -6 L 8 -4 L 9 -2 L 12 0 L 13 2 M 9 -3 L 12 -1 M 8 -5 L 9 -4 L 12 -2 L 13 0 L 13 5 L 12 7 L 11 8 L 9 9 L 6 9 L 3 8 M 7 8 L 6 8 L 4 7 M 12 7 L 10 8 L 8 8 L 6 7 L 5 6","-12 12 M -7 -10 L -5 -10 L -3 -9 L -2 -8 L -1 -5 L -1 -3 M -1 -1 L -1 3 L -2 6 L -5 9 L -7 8 L -9 9 M -4 8 L -6 7 L -7 7 M -3 7 L -4 7 L -6 6 L -9 9 M -5 -11 L -2 -10 L -1 -9 L 0 -6 L 0 3 L 1 5 L 3 7 L 5 8 M -9 -9 L -4 -12 L -2 -11 L 0 -9 L 1 -6 L 1 -3 M 1 -1 L 1 2 L 2 5 L 3 6 L 5 7 L 7 7 M -1 3 L 0 6 L 2 8 L 4 9 L 9 6 M 1 -6 L 2 -9 L 5 -12 L 7 -11 L 9 -12 M 4 -11 L 6 -10 L 7 -10 M 3 -10 L 4 -10 L 6 -9 L 9 -12 M -7 1 L -5 -3 L -1 -3 M 1 -3 L 5 -3 L 7 -5 M -5 -2 L 5 -2 M -7 1 L -5 -1 L -1 -1 M 1 -1 L 5 -1 L 7 -5","-13 13 M -10 -1 L -10 0 L -9 1 L -7 1 L -5 0 L -5 -3 L -6 -5 L -8 -8 L -8 -10 L -6 -12 M -6 -3 L -8 -7 M -7 1 L -6 0 L -6 -2 L -8 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -3 -12 L -1 -11 L 0 -10 L 1 -8 L 1 -3 L 0 0 L -1 2 L -1 3 L 1 5 L 2 5 M -1 -10 L 0 -8 L 0 -2 L -1 1 L -2 3 L 1 6 M -3 -12 L -2 -11 L -1 -8 L -1 -2 L -2 2 L -3 4 L 0 7 L 3 4 M 1 -8 L 9 -12 M 7 -11 L 7 8 L 6 11 M 8 -11 L 8 6 L 7 9 M 9 -12 L 9 4 L 8 8 L 7 10 L 5 12 L 2 13 L -2 13 L -5 12 L -7 10 L -8 8 L -7 7 L -6 8 L -7 9","-12 12 M -4 -9 L -3 -11 L -1 -12 L 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -5 L 5 -3 L 4 -2 L 2 -1 M -1 -1 L -3 -2 L -4 -4 M 4 -10 L 5 -9 L 5 -4 L 4 -3 M 2 -12 L 3 -11 L 4 -9 L 4 -4 L 3 -2 L 2 -1 M -5 3 L -4 1 L -3 0 L -1 -1 L 2 -1 L 5 0 L 7 2 L 8 4 L 8 8 L 7 10 L 5 12 L 2 13 L -2 13 L -4 12 L -7 8 L -8 7 M 6 2 L 7 4 L 7 8 L 6 10 M 2 -1 L 5 1 L 6 3 L 6 9 L 5 11 L 4 12 L 2 13 M -3 12 L -4 11 L -6 8 L -7 7 M 0 13 L -2 12 L -3 11 L -5 8 L -6 7 L -9 7 L -10 8 L -10 10 L -9 11 L -8 11","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-11 11 M -8 2 L 0 -3 L 8 2 M -8 2 L 0 -2 L 8 2","-12 12 M -12 16 L 12 16","-6 6 M -2 -12 L 3 -6 M -2 -12 L -3 -11 L 3 -6","-8 9 M 2 -5 L -1 -4 L -3 -3 L -4 -2 L -5 1 L -5 4 L -4 7 L -3 9 L 3 6 M -4 4 L -3 7 L -2 8 M -1 -4 L -3 -2 L -4 1 L -4 3 L -3 6 L -1 8 M 0 -4 L 1 -3 L 3 -2 L 3 7 L 5 9 L 8 6 M 1 -4 L 4 -2 L 4 6 L 6 8 M 2 -5 L 3 -4 L 5 -3 L 6 -3 M 5 -2 L 6 -3 M 5 -2 L 5 6 L 6 7 L 7 7","-8 9 M -6 -10 L -5 -9 L -4 -7 M 2 -12 L -1 -11 L -3 -9 L -4 -7 L -4 6 L -5 7 M -2 -9 L -3 -7 L -3 6 L 0 8 M 2 -12 L 0 -11 L -1 -10 L -2 -7 L -2 6 L 0 7 L 1 8 M -5 7 L -4 7 L -2 8 L -1 9 L 2 8 M -2 -2 L 4 -5 L 5 -3 L 6 0 L 6 3 L 5 6 L 4 7 L 2 8 M 3 -4 L 4 -3 L 5 -1 M 2 -4 L 4 -2 L 5 1 L 5 3 L 4 6 L 2 8","-7 6 M 0 -4 L 2 -2 L 4 -3 L 2 -5 L 0 -4 L -3 -2 L -4 0 L -4 5 L -3 7 L -1 9 L 3 7 M 1 -4 L 3 -3 M -2 -2 L -3 0 L -3 5 L -2 7 L -1 8 M -1 -3 L -2 -1 L -2 4 L -1 6 L 1 8","-8 9 M -1 -12 L -4 -9 L -4 -7 L -3 -6 L 1 -4 L 4 -2 L 5 0 L 5 3 L 4 6 L 2 8 M -3 -8 L -3 -7 L 1 -5 L 4 -3 L 5 -2 M -3 -10 L -3 -9 L -2 -8 L 3 -5 L 5 -3 L 6 0 L 6 3 L 5 6 L 2 8 L -1 9 M 0 -4 L -4 -2 L -4 6 L -5 7 M -3 -2 L -3 6 L 0 8 M -2 -3 L -2 6 L 0 7 L 1 8 M -5 7 L -4 7 L -2 8 L -1 9","-7 6 M -2 3 L 4 -1 L 1 -5 L -3 -2 L -4 0 L -4 5 L -3 7 L -1 9 L 3 7 M 3 -1 L 0 -4 M -2 -2 L -3 0 L -3 5 L -2 7 L -1 8 M 2 0 L 0 -3 L -1 -3 L -2 -1 L -2 4 L -1 6 L 1 8","-6 7 M 6 -12 L 5 -11 L 3 -11 L 1 -12 L -1 -12 L -2 -10 L -2 -5 L -3 -3 L -4 -2 M 4 -10 L 2 -10 L 0 -11 L -1 -11 M 6 -12 L 5 -10 L 4 -9 L 2 -9 L 0 -10 L -1 -10 L -2 -9 M -2 -7 L -1 -5 L 0 -4 L 2 -3 L 4 -3 L 4 -2 M -4 -2 L -2 -2 M 0 -2 L 4 -2 M -2 -2 L -2 2 L -1 14 M 1 -3 L -2 -3 L -1 -4 L -1 9 M 0 -2 L 0 2 L -1 14","-8 9 M 2 -5 L -1 -4 L -3 -3 L -4 -2 L -5 1 L -5 4 L -4 7 L -3 9 L 3 6 M -4 5 L -3 7 L -2 8 M -1 -4 L -3 -2 L -4 1 L -4 3 L -3 6 L -1 8 M 0 -4 L 1 -3 L 3 -2 L 3 6 L 4 9 L 4 11 L 3 13 M 1 -4 L 4 -2 L 4 8 M 2 -5 L 3 -4 L 5 -3 L 6 -3 M 5 -2 L 6 -3 M 5 -2 L 5 10 L 4 12 L 3 13 L 1 14 L -2 14 L -4 13 L -5 12 L -5 11 L -4 11 L -4 12","-8 9 M -6 -10 L -5 -9 L -4 -7 M 2 -12 L -1 -11 L -3 -9 L -4 -7 L -4 6 L -5 7 M -2 -9 L -3 -7 L -3 7 L -2 8 M 2 -12 L 0 -11 L -1 -10 L -2 -7 L -2 6 L -1 7 L 0 7 M -5 7 L -3 8 L -2 9 L 1 6 M -2 -2 L 4 -5 L 5 -3 L 6 1 L 6 5 L 5 8 L 4 10 L 2 12 L -1 14 M 3 -4 L 4 -3 L 5 0 M 2 -4 L 4 -1 L 5 2 L 5 5 L 4 9 L 2 12","-5 5 M 0 -12 L -1 -11 L -1 -10 L 0 -9 L 1 -10 L 1 -11 L 0 -12 M -1 -11 L 1 -10 M -1 -10 L 1 -11 M -3 -3 L -2 -3 L -1 -2 L -1 7 L 1 9 L 4 6 M -2 -4 L 0 -3 L 0 6 L 2 8 M -4 -2 L -1 -5 L 0 -4 L 2 -3 M 1 -2 L 2 -3 M 1 -2 L 1 6 L 2 7 L 3 7","-5 5 M 0 -12 L -1 -11 L -1 -10 L 0 -9 L 1 -10 L 1 -11 L 0 -12 M -1 -11 L 1 -10 M -1 -10 L 1 -11 M -3 -3 L -2 -3 L -1 -2 L -1 9 L -2 12 L -3 13 L -5 14 M -2 -4 L 0 -3 L 0 9 L -1 11 M -4 -2 L -1 -5 L 0 -4 L 2 -3 M 1 -2 L 2 -3 M 1 -2 L 1 9 L 0 11 L -2 13 L -5 14 M 1 9 L 2 11 L 3 12","-7 7 M -4 -10 L -3 -9 L -2 -7 M 3 -12 L 1 -11 L -1 -9 L -2 -7 L -2 -5 L -3 -3 L -4 -2 M -2 -2 L -2 6 L -3 7 M 0 -9 L -1 -7 L -1 -5 M -1 -3 L -2 -3 L -1 -5 L -1 6 L 1 8 M 3 -12 L 1 -10 L 0 -7 L 0 -3 M 0 -2 L 0 6 L 1 7 L 2 7 M -3 7 L -1 8 L 0 9 L 3 6 M 0 -6 L 4 -9 L 5 -8 L 5 -6 L 3 -4 L 1 -3 M 3 -8 L 4 -7 L 4 -6 L 3 -4 M 0 -3 L 5 -3 L 5 -2 M -4 -2 L -2 -2 M 0 -2 L 5 -2","-5 5 M -3 -10 L -2 -9 L -1 -7 M 5 -12 L 2 -11 L 0 -9 L -1 -7 L -1 6 L -2 7 M 1 -9 L 0 -7 L 0 7 L 2 8 M 5 -12 L 3 -11 L 2 -10 L 1 -7 L 1 6 L 2 7 L 3 7 M -2 7 L 0 8 L 1 9 L 4 6","-13 13 M -11 -3 L -10 -3 L -9 -2 L -9 6 L -10 7 L -8 9 M -10 -4 L -8 -2 L -8 6 L -9 7 L -8 8 L -7 7 L -8 6 M -12 -2 L -9 -5 L -7 -3 L -7 6 L -6 7 L -8 9 M -4 -4 L -2 -3 L -1 -1 L -1 6 L -2 7 L 0 9 M -2 -4 L -1 -3 L 0 -1 L 0 6 L -1 7 L 0 8 L 1 7 L 0 6 M -7 -2 L -4 -4 L -2 -5 L 0 -4 L 1 -2 L 1 6 L 2 7 L 0 9 M 4 -4 L 5 -3 L 7 -2 L 7 7 L 9 9 L 12 6 M 5 -4 L 8 -2 L 8 6 L 10 8 M 1 -2 L 4 -4 L 6 -5 L 7 -4 L 9 -3 L 10 -3 M 9 -2 L 10 -3 M 9 -2 L 9 6 L 10 7 L 11 7","-9 9 M -7 -3 L -6 -3 L -5 -2 L -5 6 L -6 7 L -4 9 M -6 -4 L -4 -2 L -4 6 L -5 7 L -4 8 L -3 7 L -4 6 M -8 -2 L -5 -5 L -3 -3 L -3 6 L -2 7 L -4 9 M 0 -4 L 1 -3 L 3 -2 L 3 7 L 5 9 L 8 6 M 1 -4 L 4 -2 L 4 6 L 6 8 M -3 -2 L 0 -4 L 2 -5 L 3 -4 L 5 -3 L 6 -3 M 5 -2 L 6 -3 M 5 -2 L 5 6 L 6 7 L 7 7","-8 9 M -4 -2 L -4 6 L -5 7 M -3 -2 L -3 6 L 0 8 M -1 -3 L -2 -2 L -2 6 L 0 7 L 1 8 M -5 7 L -4 7 L -2 8 L -1 9 L 2 8 M -4 -2 L -1 -3 L 4 -5 L 5 -3 L 6 0 L 6 3 L 5 6 L 4 7 L 2 8 M 3 -4 L 4 -3 L 5 -1 M 2 -4 L 4 -2 L 5 1 L 5 3 L 4 6 L 2 8","-8 9 M -3 -8 L -5 -6 L -5 -4 L -4 -1 L -4 6 L -6 8 M -4 7 L -3 14 M -4 -5 L -4 -4 L -3 -1 L -3 9 M -4 -7 L -4 -6 L -3 -4 L -2 -1 L -2 6 L -1 6 L 1 7 L 2 8 M -2 7 L -3 14 M 1 8 L -1 7 M 2 8 L 0 9 L -2 7 M -4 7 L -6 8 M -2 -2 L 4 -5 L 5 -3 L 6 0 L 6 3 L 5 6 L 4 7 L 2 8 M 3 -4 L 4 -3 L 5 -1 M 2 -4 L 4 -2 L 5 1 L 5 3 L 4 6 L 2 8","-8 9 M 2 -5 L -1 -4 L -3 -3 L -4 -2 L -5 1 L -5 4 L -4 7 L -3 9 L 3 6 M -4 5 L -3 7 L -2 8 M -1 -4 L -3 -2 L -4 1 L -4 3 L -3 6 L -1 8 M 0 -4 L 1 -3 L 3 -2 L 3 6 L 4 14 M 1 -4 L 4 -2 L 4 9 M 2 -5 L 3 -4 L 5 -3 L 6 -3 M 5 -2 L 6 -3 M 5 -2 L 5 6 L 4 14","-7 7 M -4 -3 L -3 -3 L -2 -2 L -2 6 L -3 7 M -3 -4 L -1 -2 L -1 7 L 1 8 M -5 -2 L -2 -5 L 0 -3 L 0 6 L 1 7 L 2 7 M -3 7 L -1 8 L 0 9 L 3 6 M 2 -4 L 3 -2 L 5 -3 L 4 -5 L 0 -3 M 3 -4 L 4 -3","-6 5 M 6 -12 L 5 -11 L 3 -11 L 1 -12 L -1 -12 L -2 -10 L -2 -5 L -3 -3 L -4 -2 M 4 -10 L 2 -10 L 0 -11 L -1 -11 M 6 -12 L 5 -10 L 4 -9 L 2 -9 L 0 -10 L -1 -10 L -2 -9 M -2 -7 L 0 -2 M -2 -2 L -2 2 L -1 14 M -1 -3 L -2 -3 L -1 -4 L -1 9 M 0 -2 L 0 2 L -1 14 M -4 -2 L -2 -2","-6 6 M 1 -9 L 0 -6 L -1 -4 L -2 -3 L -4 -2 M 1 -9 L 1 -3 L 4 -3 L 4 -2 M -4 -2 L -1 -2 M 1 -2 L 4 -2 M -1 -2 L -1 6 L -2 7 M 0 -3 L -1 -3 L 0 -5 L 0 6 L 2 8 M 1 -2 L 1 6 L 2 7 L 3 7 M -2 7 L 0 8 L 1 9 L 4 6","-9 9 M -7 -3 L -6 -3 L -5 -2 L -5 6 L -6 7 M -6 -4 L -4 -2 L -4 6 L -2 8 M -8 -2 L -5 -5 L -3 -3 L -3 6 L -1 7 L 0 8 M -6 7 L -5 7 L -3 8 L -2 9 L 0 8 L 3 6 M 4 -5 L 2 -3 L 3 -2 L 3 7 L 5 9 L 8 6 M 4 -2 L 5 -3 L 4 -4 L 3 -3 L 4 -2 L 4 6 L 6 8 M 4 -5 L 6 -3 L 5 -2 L 5 6 L 6 7 L 7 7","-8 9 M -3 -7 L -5 -5 L -5 -3 L -4 0 L -4 6 L -5 7 M -4 -4 L -4 -3 L -3 0 L -3 6 L 0 8 M -4 -6 L -4 -5 L -3 -3 L -2 0 L -2 6 L 0 7 L 1 8 M -5 7 L -4 7 L -2 8 L -1 9 L 2 8 M -2 -2 L 4 -5 L 5 -3 L 6 0 L 6 3 L 5 6 L 4 7 L 2 8 M 3 -4 L 4 -3 L 5 -1 M 2 -4 L 4 -2 L 5 1 L 5 3 L 4 6 L 2 8","-12 13 M -7 -7 L -9 -5 L -9 -3 L -8 0 L -8 6 L -9 7 L -7 9 M -8 -4 L -8 -3 L -7 0 L -7 6 L -8 7 L -7 8 L -6 7 L -7 6 M -8 -6 L -8 -5 L -7 -3 L -6 0 L -6 6 L -5 7 L -7 9 M -3 -4 L -1 -3 L 0 -1 L 0 6 L -1 7 M -1 -4 L 0 -3 L 1 -1 L 1 6 L 4 8 M -6 -2 L -3 -4 L -1 -5 L 1 -4 L 2 -2 L 2 6 L 4 7 L 5 8 M -1 7 L 0 7 L 2 8 L 3 9 L 6 8 M 2 -2 L 8 -5 L 9 -3 L 10 0 L 10 2 L 9 6 L 8 7 L 6 8 M 7 -4 L 8 -3 L 9 -1 M 6 -4 L 8 -2 L 9 1 L 9 3 L 8 6 L 6 8","-7 8 M -3 -3 L -2 -3 L -1 -2 L -1 6 L -2 6 L -4 7 L -5 9 L -5 11 L -4 13 L -2 14 L 1 14 L 4 13 L 4 12 L 3 12 L 3 13 M -2 -4 L 0 -2 L 0 6 L 3 8 M -4 -2 L -1 -5 L 1 -3 L 1 6 L 3 7 L 4 8 M 6 7 L 2 9 L 1 8 L -1 7 L -3 7 L -5 9 M 3 -4 L 4 -2 L 6 -3 L 5 -5 L 1 -3 M 4 -4 L 5 -3","-8 9 M -3 -7 L -5 -5 L -5 -3 L -4 0 L -4 6 L -5 7 M -4 -4 L -4 -3 L -3 0 L -3 7 L -1 8 M -4 -6 L -4 -5 L -3 -3 L -2 0 L -2 6 L -1 7 L 0 7 M -5 7 L -3 8 L -2 9 L 1 6 M -2 -2 L 4 -5 L 5 -3 L 6 1 L 6 5 L 5 8 L 4 10 L 2 12 L -1 14 M 3 -4 L 4 -3 L 5 0 M 2 -4 L 4 -1 L 5 2 L 5 5 L 4 9 L 2 12","-7 7 M -4 -2 L 1 -5 L 3 -4 L 4 -2 L 4 0 L 3 2 L -1 4 M 1 -4 L 3 -3 M 0 -4 L 2 -3 L 3 -1 L 3 0 L 2 2 L 1 3 M 1 3 L 3 5 L 4 7 L 4 11 L 3 13 L 1 14 L -1 14 L -3 13 L -4 11 L -4 9 L -3 7 L -1 6 L 5 4 M 0 4 L 2 5 L 3 7 M -1 4 L 2 6 L 3 8 L 3 11 L 2 13 L 1 14","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
gothicita = ["-8 8","-6 6 M 0 -12 L -1 -11 L -3 -10 L -1 -9 L 0 2 M 0 -9 L 1 -10 L 0 -11 L -1 -10 L 0 -9 L 0 2 M 0 -12 L 1 -11 L 3 -10 L 1 -9 L 0 2 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-9 9 M -4 -12 L -5 -11 L -5 -5 M -4 -11 L -5 -5 M -4 -12 L -3 -11 L -5 -5 M 5 -12 L 4 -11 L 4 -5 M 5 -11 L 4 -5 M 5 -12 L 6 -11 L 4 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 10 M -2 -16 L -2 13 M 2 -16 L 2 13 M 2 -12 L 4 -11 L 5 -9 L 5 -7 L 7 -8 L 6 -10 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -6 L -6 -4 L -3 -2 L 3 0 L 5 1 L 6 3 L 6 6 L 5 8 M 6 -8 L 5 -10 M -6 -6 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 2 M -5 7 L -6 5 M -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 3 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -5 4 L -5 6 L -4 8 L -2 9","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-13 13 M 7 -4 L 8 -3 L 9 -3 L 10 -4 M 6 -3 L 7 -2 L 9 -2 M 6 -2 L 7 -1 L 8 -1 L 9 -2 L 10 -4 M 7 -4 L 1 2 M 0 3 L -6 9 L -10 4 L -4 -2 M -3 -3 L 1 -7 L -3 -12 L -8 -6 L -2 0 L 2 6 L 4 8 L 6 9 L 8 9 L 9 8 L 10 6 M -6 8 L -9 4 M 0 -7 L -3 -11 M -7 -6 L -2 -1 L 2 5 L 4 7 L 6 8 L 9 8 M -5 8 L -9 3 M 0 -6 L -4 -11 M -7 -7 L -1 -1 L 3 5 L 4 6 L 6 7 L 9 7 L 10 6","-4 5 M 1 -12 L 0 -11 L 0 -5 M 1 -11 L 0 -5 M 1 -12 L 2 -11 L 0 -5","-7 7 M 3 -16 L 1 -14 L -1 -11 L -3 -7 L -4 -2 L -4 2 L -3 7 L -1 11 L 1 14 L 3 16 M -1 -10 L -2 -7 L -3 -3 L -3 3 L -2 7 L -1 10 M 1 -14 L 0 -12 L -1 -9 L -2 -3 L -2 3 L -1 9 L 0 12 L 1 14","-7 7 M -3 -16 L -1 -14 L 1 -11 L 3 -7 L 4 -2 L 4 2 L 3 7 L 1 11 L -1 14 L -3 16 M 1 -10 L 2 -7 L 3 -3 L 3 3 L 2 7 L 1 10 M -1 -14 L 0 -12 L 1 -9 L 2 -3 L 2 3 L 1 9 L 0 12 L -1 14","-8 8 M 0 -12 L -1 -11 L 1 -1 L 0 0 M 0 -12 L 0 0 M 0 -12 L 1 -11 L -1 -1 L 0 0 M -5 -9 L -4 -9 L 4 -3 L 5 -3 M -5 -9 L 5 -3 M -5 -9 L -5 -8 L 5 -4 L 5 -3 M 5 -9 L 4 -9 L -4 -3 L -5 -3 M 5 -9 L -5 -3 M 5 -9 L 5 -8 L -5 -4 L -5 -3","-12 13 M 0 -9 L 0 8 L 1 8 M 0 -9 L 1 -9 L 1 8 M -8 -1 L 9 -1 L 9 0 M -8 -1 L -8 0 L 9 0","-6 6 M 0 12 L 0 10 L -2 8 L 0 6 L 1 8 L 1 10 L 0 12 L -2 13 M 0 7 L -1 8 L 0 9 L 0 7","-13 13 M -9 0 L 9 0","-6 6 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-11 12 M 9 -16 L -9 16 L -8 16 M 9 -16 L 10 -16 L -8 16","-10 10 M -6 -10 L -6 6 L -8 7 M -5 -9 L -5 6 L -2 8 M -4 -10 L -4 6 L -2 7 L -1 8 M -6 -10 L -4 -10 L 1 -11 L 3 -12 M 1 -11 L 2 -10 L 4 -9 L 4 7 M 2 -11 L 5 -9 L 5 6 M 3 -12 L 4 -11 L 6 -10 L 8 -10 L 6 -9 L 6 7 M -8 7 L -6 7 L -4 8 L -3 9 L -1 8 L 4 7 L 6 7","-10 10 M -3 -10 L -2 -9 L -1 -7 L -1 6 L -3 7 M -1 -9 L -2 -10 L -1 -11 L 0 -9 L 0 7 L 2 8 M -3 -10 L 0 -12 L 1 -10 L 1 6 L 3 7 L 4 7 M -3 7 L -2 7 L 0 8 L 1 9 L 2 8 L 4 7","-10 10 M -6 -10 L -4 -10 L -2 -11 L -1 -12 L 1 -11 L 4 -10 L 6 -10 M -2 -10 L 0 -11 M -6 -10 L -4 -9 L -2 -9 L 0 -10 L 1 -11 M 4 -10 L 4 -2 M 5 -9 L 5 -3 M 6 -10 L 6 -2 L -1 -2 L -4 -1 L -6 1 L -7 4 L -7 9 M -7 9 L -3 7 L 1 6 L 4 6 L 8 7 M -4 8 L -1 7 L 4 7 L 7 8 M -7 9 L -2 8 L 3 8 L 6 9 L 8 7","-10 10 M -6 -10 L -5 -10 L -3 -11 L -2 -12 L 0 -11 L 4 -10 L 6 -10 M -3 -10 L -1 -11 M -6 -10 L -4 -9 L -2 -9 L 0 -11 M 4 -10 L 4 -3 M 5 -9 L 5 -4 M 6 -10 L 6 -3 L 4 -3 L 1 -2 L -1 -1 M -1 -2 L 1 -1 L 4 0 L 6 0 L 6 7 M 5 1 L 5 6 M 4 0 L 4 7 M -7 7 L -5 6 L -3 6 L -1 7 L 0 8 M -3 7 L -1 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 4 7 L 6 7","-10 10 M 3 -12 L -7 -2 L -7 3 L 2 3 M 4 3 L 8 3 L 9 4 L 9 2 L 8 3 M -6 -2 L -6 2 M -5 -4 L -5 3 M 2 -11 L 2 6 L 0 7 M 3 -8 L 4 -10 L 3 -11 L 3 7 L 5 8 M 3 -12 L 5 -10 L 4 -8 L 4 6 L 6 7 L 7 7 M 0 7 L 1 7 L 3 8 L 4 9 L 5 8 L 7 7","-10 10 M -6 -12 L -6 -3 M -6 -12 L 6 -12 M -5 -11 L 4 -11 M -6 -10 L 3 -10 L 5 -11 L 6 -12 M 4 -6 L 3 -5 L 1 -4 L -3 -3 L -6 -3 M 1 -4 L 2 -4 L 4 -3 L 4 7 M 3 -5 L 5 -4 L 5 6 M 4 -6 L 5 -5 L 7 -4 L 8 -4 L 6 -3 L 6 7 M -7 7 L -5 6 L -3 6 L -1 7 L 0 8 M -3 7 L -1 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 4 7 L 6 7","-10 10 M -6 -10 L -6 6 L -8 7 M -5 -9 L -5 6 L -2 8 M -4 -10 L -4 6 L -2 7 L -1 8 M -6 -10 L -4 -10 L 0 -11 L 2 -12 L 3 -11 L 5 -10 L 6 -10 M 1 -11 L 3 -10 M 0 -11 L 2 -9 L 4 -9 L 6 -10 M -4 -2 L -3 -2 L 1 -3 L 3 -4 L 4 -5 M 1 -3 L 2 -3 L 4 -2 L 4 7 M 3 -4 L 5 -2 L 5 6 M 4 -5 L 5 -4 L 7 -3 L 8 -3 L 6 -2 L 6 7 M -8 7 L -6 7 L -4 8 L -3 9 L -1 8 L 4 7 L 6 7","-10 10 M -7 -10 L -5 -12 L -2 -11 L 3 -11 L 8 -12 M -6 -11 L -3 -10 L 2 -10 L 5 -11 M -7 -10 L -3 -9 L 0 -9 L 4 -10 L 8 -12 M 8 -12 L 7 -10 L 5 -7 L 1 -3 L -1 0 L -2 3 L -2 6 L -1 9 M 0 -1 L -1 2 L -1 5 L 0 8 M 3 -5 L 1 -2 L 0 1 L 0 4 L 1 7 L -1 9","-10 10 M -6 -9 L -6 -3 M -5 -8 L -5 -4 M -4 -9 L -4 -3 M -6 -9 L -4 -9 L 1 -10 L 3 -11 L 4 -12 M 1 -10 L 2 -10 L 4 -9 L 4 -3 M 3 -11 L 5 -10 L 5 -4 M 4 -12 L 5 -11 L 7 -10 L 8 -10 L 6 -9 L 6 -3 M -6 -3 L -4 -3 L 4 0 L 6 0 M 6 -3 L 4 -3 L -4 0 L -6 0 M -6 0 L -6 6 L -8 7 M -5 1 L -5 6 L -2 8 M -4 0 L -4 6 L -2 7 L -1 8 M 4 0 L 4 7 M 5 1 L 5 6 M 6 0 L 6 7 M -8 7 L -6 7 L -4 8 L -3 9 L -1 8 L 4 7 L 6 7","-10 10 M -6 -10 L -6 -1 L -8 0 M -5 -9 L -5 0 L -3 1 M -4 -10 L -4 -1 L -2 0 L -1 0 M -6 -10 L -4 -10 L 1 -11 L 3 -12 M 1 -11 L 2 -10 L 4 -9 L 4 7 M 2 -11 L 5 -9 L 5 6 M 3 -12 L 4 -11 L 6 -10 L 8 -10 L 6 -9 L 6 7 M -8 0 L -7 0 L -5 1 L -4 2 L -3 1 L -1 0 L 3 -1 L 4 -1 M -7 7 L -5 6 L -3 6 L -1 7 L 0 8 M -3 7 L -1 8 M -7 7 L -5 7 L -3 8 L -2 9 L 0 8 L 4 7 L 6 7","-6 6 M 0 -5 L -2 -3 L 0 -2 L 2 -3 L 0 -5 M 0 -4 L -1 -3 L 1 -3 L 0 -4 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-6 6 M 0 -5 L -2 -3 L 0 -2 L 2 -3 L 0 -5 M 0 -4 L -1 -3 L 1 -3 L 0 -4 M 0 12 L 0 10 L -2 8 L 0 6 L 1 8 L 1 10 L 0 12 L -2 13 M 0 7 L -1 8 L 0 9 L 0 7","-12 12 M 8 -9 L -8 0 L 8 9","-12 13 M -8 -5 L 9 -5 L 9 -4 M -8 -5 L -8 -4 L 9 -4 M -8 3 L 9 3 L 9 4 M -8 3 L -8 4 L 9 4","-12 12 M -8 -9 L 8 0 L -8 9","-9 9 M -6 -8 L -5 -10 L -4 -11 L -1 -12 L 1 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 3 -2 L 1 -1 M -5 -8 L -4 -10 M 4 -10 L 5 -9 L 5 -5 L 4 -4 M -6 -8 L -4 -7 L -4 -9 L -3 -11 L -1 -12 M 1 -12 L 3 -11 L 4 -9 L 4 -5 L 3 -3 L 1 -1 M 0 -1 L 0 2 L 1 -1 L -1 -1 L 0 2 M 0 6 L -2 8 L 0 9 L 2 8 L 0 6 M 0 7 L -1 8 L 1 8 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-13 13 M -4 -10 L -6 -9 L -8 -7 L -9 -5 L -10 -2 L -10 1 L -9 3 L -7 4 M -8 -6 L -9 -3 L -9 1 L -8 3 M -4 -10 L -6 -8 L -7 -6 L -8 -3 L -8 0 L -7 4 L -7 6 L -8 8 L -10 9 M 4 -10 L 6 -10 L 6 7 L 4 7 M 7 -10 L 7 7 M 8 -11 L 8 8 M -10 -12 L -7 -11 L -1 -10 L 4 -10 L 8 -11 L 10 -12 M -8 -2 L 6 -2 M -10 9 L -7 8 L -1 7 L 4 7 L 8 8 L 10 9","-13 13 M -6 -11 L -6 8 M -5 -11 L -5 8 M -2 -12 L -4 -11 L -4 8 L -2 9 M -10 -8 L -8 -10 L -6 -11 L -2 -12 L 3 -12 L 6 -11 L 8 -9 L 8 -7 L 7 -5 M 6 -10 L 7 -9 L 7 -7 L 6 -5 M 3 -12 L 5 -11 L 6 -9 L 6 -7 L 5 -6 M -1 3 L -3 2 L -4 0 L -4 -2 L -3 -4 L -2 -5 L 1 -6 L 4 -6 L 7 -5 L 9 -3 L 10 -1 L 10 2 L 9 5 L 7 7 L 5 8 L 2 9 L -2 9 L -6 8 L -8 7 L -10 5 M 8 -3 L 9 -1 L 9 3 L 8 5 M 4 -6 L 7 -4 L 8 -1 L 8 3 L 7 6 L 5 8","-13 13 M 10 -12 L 9 -10 L 8 -8 L 6 -10 L 4 -11 L 1 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 1 9 L 4 8 L 6 7 L 8 5 L 9 7 L 10 9 M 9 -10 L 8 -5 L 8 2 L 9 7 M 8 -7 L 7 -8 M 8 -4 L 7 -7 L 6 -9 L 4 -11 M -8 -7 L -9 -4 L -9 1 L -8 4 M -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 M 7 5 L 8 4 M 4 8 L 6 6 L 7 4 L 8 1","-13 13 M -7 -11 L -7 8 M -6 -11 L -6 8 M -4 -12 L -5 -11 L -5 8 L -4 9 M -10 -7 L -9 -9 L -7 -11 L -4 -12 L 1 -12 L 4 -11 L 6 -10 L 8 -8 L 9 -6 L 10 -3 L 10 0 L 9 3 L 8 5 L 6 7 L 4 8 L 1 9 L -4 9 L -7 8 L -9 6 L -10 4 M 8 -7 L 9 -4 L 9 1 L 8 4 M 4 -11 L 6 -9 L 7 -7 L 8 -4 L 8 1 L 7 4 L 6 6 L 4 8","-13 13 M 10 -12 L 9 -10 L 8 -8 L 6 -10 L 4 -11 L 1 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 1 9 L 4 8 L 6 7 L 8 5 L 9 7 L 10 9 M 9 -10 L 8 -5 L 8 2 L 9 7 M 8 -7 L 7 -8 M 8 -5 L 6 -9 L 4 -11 M -8 -7 L -9 -4 L -9 1 L -8 4 M -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 M 7 5 L 8 4 M 4 8 L 6 6 L 7 4 L 8 1 M -8 -2 L -7 -3 L -4 -3 L 3 -1 L 6 -1 L 8 -2 M -2 -2 L 0 -1 L 3 0 L 5 0 L 7 -1 M -5 -3 L 0 0 L 3 1 L 5 1 L 7 0 L 8 -2 M 8 -5 L 7 -6 L 6 -6 L 5 -5 L 6 -4 L 7 -5","-13 13 M -8 -10 L -8 8 M -5 -11 L -7 -10 L -7 7 M -3 -12 L -5 -11 L -6 -9 L -6 7 L -4 7 M -10 -8 L -8 -10 L -6 -11 L -3 -12 L 1 -12 L 4 -11 L 6 -10 L 7 -9 L 10 -12 M 10 -12 L 9 -10 L 8 -6 L 8 -3 L 9 1 L 10 3 M 8 -9 L 7 -7 M 4 -11 L 6 -9 L 7 -6 L 8 -3 M -6 -2 L -5 -3 L -3 -3 L 2 -2 L 5 -2 L 7 -3 M -1 -2 L 2 -1 L 4 -1 L 6 -2 M -4 -3 L 2 0 L 4 0 L 6 -1 L 7 -3 L 7 -6 L 6 -7 L 5 -7 L 4 -6 L 5 -5 L 6 -6 M -10 9 L -8 8 L -4 7 L 1 7 L 7 8 L 10 9","-13 13 M 10 -12 L 9 -10 L 8 -8 L 6 -10 L 4 -11 L 1 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 4 8 L 6 7 L 7 6 L 8 4 L 9 7 L 10 9 M 9 -10 L 8 -5 L 8 2 L 9 7 M 8 -7 L 7 -8 M 8 -4 L 7 -7 L 6 -9 L 4 -11 M -8 -7 L -9 -4 L -9 1 L -8 4 M -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 M 6 6 L 7 4 L 7 0 M 4 8 L 5 7 L 6 4 L 6 -1 M -7 1 L -6 0 L -5 1 L -6 2 L -7 2 L -8 1 M -8 -2 L -7 -4 L -5 -5 L -3 -5 L 0 -4 L 3 -2 L 5 -1 M -7 -3 L -5 -4 L -3 -4 L 0 -3 L 2 -2 M -8 -2 L -6 -3 L -3 -3 L 3 -1 L 7 -1 L 8 -2","-13 13 M -8 -11 L -8 8 L -10 9 M -7 -10 L -7 8 M -4 -10 L -6 -10 L -6 8 M -10 -12 L -8 -11 L -4 -10 L 1 -10 L 7 -11 L 10 -12 M -6 -2 L -5 -4 L -3 -6 L 0 -7 L 4 -7 L 7 -6 L 9 -4 L 10 -1 L 10 2 L 9 3 L 7 4 M 8 -4 L 9 -2 L 9 1 L 8 3 M 4 -7 L 6 -6 L 7 -5 L 8 -3 L 8 1 L 7 4 L 7 6 L 8 8 L 10 9 M -10 9 L -6 8 L -2 8 L 3 9","-13 13 M -1 -9 L -1 7 M 0 -8 L 0 6 M 1 -9 L 1 7 M -10 -12 L -6 -10 L -2 -9 L 2 -9 L 6 -10 L 10 -12 M -10 9 L -7 8 L -3 7 L 3 7 L 7 8 L 10 9","-13 13 M 2 -9 L 4 -9 L 4 6 L 3 8 L 1 9 M 5 -9 L 5 6 L 4 7 M 6 -10 L 6 7 M -10 -12 L -6 -10 L -2 -9 L 2 -9 L 6 -10 L 10 -12 M -9 -3 L -10 -1 L -10 3 L -9 6 L -7 8 L -4 9 L 1 9 L 4 8 L 6 7 L 8 5 L 10 2 M -9 3 L -8 6 L -7 7 M -10 1 L -8 3 L -7 6 L -6 8 L -4 9","-13 13 M -8 -11 L -8 8 L -10 9 M -7 -10 L -7 8 M -4 -10 L -6 -10 L -6 8 M -10 -12 L -8 -11 L -4 -10 L 1 -10 L 7 -11 L 10 -12 M -6 -2 L -5 -4 L -3 -6 L 0 -7 L 3 -7 L 6 -6 L 7 -5 L 7 -3 L 6 -2 L 1 0 L -1 1 L -2 2 L -2 3 L -1 4 L 0 3 L -1 2 M 5 -6 L 6 -5 L 6 -3 L 5 -2 M 3 -7 L 5 -5 L 5 -3 L 4 -2 L 1 0 M 1 0 L 4 0 L 7 1 L 8 3 L 8 5 L 7 6 M 5 1 L 7 3 L 7 5 M 1 0 L 4 1 L 6 3 L 7 6 L 8 8 L 9 9 L 10 9 M -10 9 L -6 8 L -2 8 L 3 9","-13 13 M -8 -11 L -8 8 M -7 -10 L -7 7 M -4 -10 L -6 -10 L -6 7 L -4 7 M 10 -7 L 8 -4 L 7 -2 L 6 1 L 6 3 L 7 5 L 9 6 M 8 -3 L 7 0 L 7 3 L 8 5 M 10 -7 L 9 -5 L 8 -1 L 8 2 L 9 6 L 10 9 M -10 -12 L -8 -11 L -4 -10 L 1 -10 L 7 -11 L 10 -12 M -10 9 L -8 8 L -4 7 L 1 7 L 7 8 L 10 9","-13 13 M -1 -9 L -1 7 M 0 -8 L 0 6 M 1 -9 L 1 7 M -4 7 L -6 5 L -8 4 L -9 3 L -10 0 L -10 -5 L -9 -8 L -7 -10 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 7 -10 L 9 -8 L 10 -5 L 10 0 L 9 3 L 8 4 L 6 5 L 4 7 M -8 3 L -9 0 L -9 -5 L -8 -8 M -6 5 L -7 3 L -8 0 L -8 -6 L -7 -9 L -5 -11 M 8 -8 L 9 -5 L 9 0 L 8 3 M 5 -11 L 7 -9 L 8 -6 L 8 0 L 7 3 L 6 5 M -10 -12 L -6 -10 L -2 -9 L 2 -9 L 6 -10 L 10 -12 M -10 9 L -7 8 L -3 7 L 3 7 L 7 8 L 10 9","-13 13 M -8 -10 L -8 8 L -10 9 M -6 -10 L -7 -9 L -7 8 M -3 -12 L -5 -11 L -6 -9 L -6 8 M -10 -8 L -8 -10 L -6 -11 L -3 -12 L 1 -12 L 4 -11 L 6 -10 L 8 -8 L 9 -6 L 10 -3 L 10 1 L 9 3 L 7 4 M 8 -7 L 9 -4 L 9 0 L 8 3 M 4 -11 L 6 -9 L 7 -7 L 8 -4 L 8 0 L 7 4 L 7 6 L 8 8 L 9 9 L 10 9 M -10 9 L -6 8 L -2 8 L 3 9","-13 13 M -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 1 9 L 4 8 L 6 7 L 8 5 L 9 3 L 10 0 L 10 -3 L 9 -6 L 8 -8 L 6 -10 L 4 -11 L 1 -12 L -1 -12 M -8 -7 L -9 -4 L -9 1 L -8 4 M -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 M 8 4 L 9 1 L 9 -4 L 8 -7 M 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11","-13 13 M -8 -9 L -8 8 M -5 -10 L -7 -8 L -7 7 M -1 -12 L -3 -11 L -5 -9 L -6 -7 L -6 7 L -4 7 M -10 -7 L -8 -9 L -4 -11 L -1 -12 L 2 -12 L 5 -11 L 7 -10 L 9 -8 L 10 -5 L 10 -3 L 9 0 L 7 2 L 4 3 L 0 3 L -3 2 L -5 0 L -6 -3 M 8 -8 L 9 -6 L 9 -2 L 8 0 M 5 -11 L 7 -9 L 8 -6 L 8 -2 L 7 1 L 4 3 M -10 9 L -8 8 L -4 7 L 1 7 L 7 8 L 10 9","-13 13 M -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 1 9 L 4 8 L 6 7 L 8 5 L 9 3 L 10 0 L 10 -3 L 9 -6 L 8 -8 L 6 -10 L 4 -11 L 1 -12 L -1 -12 M -8 -7 L -9 -4 L -9 1 L -8 4 M -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 M 8 4 L 9 1 L 9 -4 L 8 -7 M 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11 M -8 1 L -7 3 L -4 4 L 2 5 L 9 5 L 10 6 L 10 8 L 9 9 L 9 8 L 10 7 M -2 5 L 0 5 M -7 3 L -4 5 L -1 6 L 1 6 L 2 5","-13 13 M -8 -9 L -8 8 L -10 9 M -7 -9 L -7 8 M -6 -10 L -6 8 M -10 -7 L -8 -9 L -6 -10 L -4 -11 L -1 -12 L 3 -12 L 7 -11 L 9 -9 L 10 -7 L 10 -4 L 9 -2 L 8 -1 M 7 -10 L 8 -9 L 9 -7 L 9 -4 L 8 -2 M 3 -12 L 5 -11 L 7 -9 L 8 -7 L 8 -3 L 7 -1 M 6 0 L 3 1 L 0 1 L -2 0 L -2 -2 L 0 -3 L 3 -3 L 6 -2 L 8 0 L 10 3 L 10 5 L 9 6 L 8 6 M 6 -1 L 7 0 L 9 4 L 9 5 L 8 2 M 2 -3 L 4 -2 L 6 0 L 7 2 L 8 6 L 9 8 L 10 9 M -10 9 L -6 8 L -2 8 L 3 9","-13 13 M 2 -12 L 8 -11 L 10 -12 L 9 -10 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -8 -8 L -9 -5 L -9 -3 L -8 0 L -6 2 L -3 3 L 0 3 L 2 2 L 3 1 L 4 -1 L 4 -2 M 9 -11 L 8 -10 L 9 -8 M -8 -2 L -7 0 L -6 1 L -3 2 L 0 2 L 2 1 M -7 -9 L -8 -7 L -8 -4 L -7 -2 L -5 0 L -2 1 L 0 1 L 2 0 L 4 -2 L 5 -3 L 6 -3 M -6 -1 L -5 -1 L -4 -2 L -2 -4 L 0 -5 L 3 -5 L 5 -4 L 7 -2 L 8 0 L 8 3 L 7 6 L 5 8 M -2 -5 L 0 -6 L 3 -6 L 6 -5 L 8 -3 L 9 0 L 9 3 L 8 5 M -9 5 L -8 7 L -9 8 M -4 -2 L -4 -3 L -3 -5 L -2 -6 L 0 -7 L 3 -7 L 6 -6 L 9 -3 L 10 0 L 10 2 L 9 5 L 7 7 L 5 8 L 2 9 L -2 9 L -5 8 L -7 7 L -9 5 L -9 7 L -10 9 L -8 8 L -2 9","-13 13 M -1 -10 L -5 -10 L -7 -9 L -8 -8 L -9 -6 L -10 -3 L -10 1 L -9 4 L -8 6 L -7 7 L -5 8 L -2 9 L 1 9 L 4 8 L 6 7 L 8 5 L 9 3 L 10 0 L 10 -4 L 9 -7 L 7 -9 L 5 -10 M 3 -10 L 2 -9 L 2 -7 L 3 -6 L 4 -7 L 3 -8 M -9 1 L -8 4 L -6 6 L -4 7 L -1 8 L 2 8 L 5 7 M -8 -8 L -9 -4 L -9 -1 L -8 2 L -6 5 L -4 6 L -1 7 L 2 7 L 5 6 L 7 5 L 9 2 L 10 0 M -10 -12 L -7 -9 M -7 -10 L -6 -11 M -9 -11 L -8 -11 L -7 -12 L -5 -11 L -1 -10 L 5 -10 L 8 -11 L 10 -12","-13 13 M -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 3 9 L 6 8 L 8 7 M -7 -8 L -8 -6 L -9 -3 L -9 1 L -8 4 M -7 -9 L -6 -8 L -6 -7 L -7 -5 L -8 -2 L -8 1 L -7 4 L -6 6 L -4 8 M 4 -10 L 6 -10 L 6 6 L 5 8 L 3 9 M 7 -10 L 7 6 L 6 7 M 8 -11 L 8 7 L 10 9 M -10 -12 L -7 -11 L -1 -10 L 4 -10 L 8 -11 L 10 -12","-13 13 M -10 -12 L 0 9 M -9 -11 L -8 -10 L -1 5 L 0 7 M -8 -11 L -7 -10 L 0 5 L 1 6 M 10 -12 L 0 9 M 5 -4 L 3 1 M 7 -6 L 3 -1 L 2 2 L 2 4 M -10 -12 L -8 -11 L -3 -10 L 3 -10 L 8 -11 L 10 -12","-13 13 M -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 1 9 L 4 8 L 6 7 L 8 5 L 9 3 L 10 0 L 10 -3 L 9 -6 L 8 -8 L 6 -10 M -8 -6 L -9 -3 L -9 0 L -8 3 L -7 5 M -8 -8 L -7 -7 L -7 -6 L -8 -3 L -8 0 L -7 4 L -6 6 L -4 8 M 7 5 L 8 3 L 9 0 L 9 -3 L 8 -6 M 4 8 L 6 6 L 7 4 L 8 0 L 8 -3 L 7 -6 L 7 -7 L 8 -8 M -1 -9 L -1 9 M 0 -8 L 0 8 M 1 -9 L 1 9 M -10 -12 L -6 -10 L -2 -9 L 2 -9 L 6 -10 L 10 -12","-13 13 M -10 -12 L 6 7 L 7 8 M -9 -11 L -7 -10 L 8 8 M -6 -10 L 10 9 M 10 -12 L 1 -2 M -1 0 L -8 8 M -2 1 L -5 3 L -6 5 M -1 0 L -5 2 L -6 3 L -7 5 L -7 7 M -10 -12 L -6 -10 L -2 -9 L 2 -9 L 6 -10 L 10 -12 M -10 9 L -8 8 L -4 7 L 1 7 L 7 8 L 10 9","-13 13 M 6 -10 L 6 8 M 7 -10 L 7 7 M 8 -11 L 8 7 M -7 -10 L -9 -8 L -10 -5 L -10 -2 L -9 1 L -7 3 L -5 4 L -2 5 L 1 5 L 4 4 L 6 3 M -6 3 L -3 4 L 3 4 M -10 -2 L -9 0 L -7 2 L -4 3 L 2 3 L 4 4 M -10 -12 L -6 -10 L -2 -9 L 2 -9 L 6 -10 L 10 -12 M -10 5 L -8 7 L -6 8 L -2 9 L 2 9 L 6 8 L 10 6","-13 13 M -10 -12 L -9 -11 L -7 -10 L -4 -10 L 1 -12 L 4 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 M 6 -11 L 7 -9 L 7 -7 L 6 -5 M 4 -12 L 5 -11 L 6 -9 L 6 -6 M 6 -4 L 2 -3 L 0 -3 L -2 -4 L -2 -6 L 0 -7 L 2 -7 L 6 -6 M 2 -7 L 4 -6 L 5 -5 L 4 -4 L 2 -3 M 7 -5 L 9 -3 L 10 0 L 10 2 L 9 5 L 7 7 L 5 8 L 2 9 L -2 9 L -5 8 L -7 7 L -9 5 L -10 2 L -10 0 L -9 -3 L -8 -4 L -6 -5 L -4 -5 L -2 -4 L -2 -2 L -3 -1 L -4 -2 L -3 -3 M 6 -5 L 8 -3 L 9 -1 L 9 3 L 8 5 M 6 -4 L 7 -3 L 8 -1 L 8 3 L 7 6 L 5 8","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-11 11 M -8 2 L 0 -3 L 8 2 M -8 2 L 0 -2 L 8 2","-13 13 M -13 16 L 13 16","-6 6 M -2 -12 L 3 -6 M -2 -12 L -3 -11 L 3 -6","-8 9 M -2 -1 L -5 2 L -5 6 L -2 9 L 2 7 M -4 2 L -4 6 L -2 8 M -3 0 L -3 5 L 0 8 M 0 1 L -5 -4 L -4 -5 L -3 -4 L -4 -3 M -3 -4 L 1 -4 L 3 -5 L 5 -3 L 5 6 L 6 7 M 3 -4 L 4 -3 L 4 6 L 3 7 L 4 8 L 5 7 L 4 6 M 1 -4 L 3 -2 L 3 6 L 2 7 L 4 9 L 6 7","-9 8 M -4 -10 L -6 -12 L -5 -8 L -5 6 L -2 9 L 3 7 L 5 6 M -4 -10 L -4 6 L -2 8 M -4 -10 L -2 -12 L -3 -8 L -3 5 L 0 8 M -3 -3 L 2 -5 L 5 -2 L 5 6 M 2 -4 L 4 -2 L 4 6 M 0 -4 L 3 -1 L 3 7","-7 5 M -4 -2 L -4 7 L -2 9 L 0 7 M -3 -2 L -3 7 L -2 8 M -2 -3 L -2 6 L -1 7 L 0 7 M -4 -2 L 2 -5 L 4 -3 L 2 -2 L 0 -4 M 1 -4 L 3 -3","-8 8 M 0 -5 L -5 -2 L -5 6 L -2 9 L 0 8 L 3 7 L 5 7 M -4 -2 L -4 6 L -2 8 M -3 -3 L -3 5 L 0 8 M -2 -9 L -2 -12 L -1 -9 L 5 -2 L 5 7 M -2 -9 L 4 -2 L 4 6 M -2 -9 L -5 -9 L -2 -8 L 3 -2 L 3 7","-7 6 M -4 -2 L -4 7 L -2 9 L 0 7 M -3 -2 L -3 7 L -2 8 M -2 -3 L -2 6 L -1 7 L 0 7 M -4 -2 L 2 -5 L 5 -1 L -2 3 M 1 -4 L 4 -1 M 0 -4 L 3 0","-7 5 M -3 -9 L -3 6 L -4 7 L -2 9 M -2 -9 L -2 6 L -3 7 L -2 8 L -1 7 L -2 6 M -1 -10 L -1 6 L 0 7 L -2 9 M -3 -9 L 3 -12 L 5 -10 L 3 -9 L 1 -11 M 2 -11 L 4 -10 M -6 -5 L -3 -5 M -1 -5 L 3 -5","-8 9 M -5 -2 L -5 6 L -2 9 L 3 7 M -4 -2 L -4 6 L -2 8 M -3 -3 L -3 5 L 0 8 M -5 -2 L -3 -3 L 2 -5 L 5 -2 L 5 11 L 4 13 L 3 14 L 1 15 L -1 15 L -3 14 L -5 15 L -3 16 L -1 15 M 2 -4 L 4 -2 L 4 11 L 3 13 M -2 15 L -4 15 M 0 -4 L 3 -1 L 3 12 L 2 14 L 1 15","-9 9 M -4 -10 L -6 -12 L -5 -8 L -5 6 L -6 7 L -4 9 M -4 -10 L -4 6 L -5 7 L -4 8 L -3 7 L -4 6 M -4 -10 L -2 -12 L -3 -8 L -3 6 L -2 7 L -4 9 M -3 -3 L 0 -4 L 2 -5 L 5 -2 L 5 7 L 2 11 L 2 14 L 3 16 L 4 16 L 2 14 M 2 -4 L 4 -2 L 4 7 L 3 9 M 0 -4 L 3 -1 L 3 8 L 2 11","-5 5 M 0 -12 L -2 -10 L 0 -8 L 2 -10 L 0 -12 M 0 -11 L -1 -10 L 0 -9 L 1 -10 L 0 -11 M 0 -5 L -2 -3 L -1 -2 L -1 6 L -2 7 L 0 9 M 0 -2 L 1 -3 L 0 -4 L -1 -3 L 0 -2 L 0 6 L -1 7 L 0 8 L 1 7 L 0 6 M 0 -5 L 2 -3 L 1 -2 L 1 6 L 2 7 L 0 9","-5 5 M 0 -12 L -2 -10 L 0 -8 L 2 -10 L 0 -12 M 0 -11 L -1 -10 L 0 -9 L 1 -10 L 0 -11 M 0 -5 L -2 -3 L -1 -2 L -1 7 L 2 11 M 0 -2 L 1 -3 L 0 -4 L -1 -3 L 0 -2 L 0 7 L 1 9 M 0 -5 L 2 -3 L 1 -2 L 1 8 L 2 11 L 2 14 L 0 16 L -2 15 L -2 16 L 0 16","-9 8 M -4 -10 L -6 -12 L -5 -8 L -5 6 L -6 7 L -4 9 M -4 -10 L -4 6 L -5 7 L -4 8 L -3 7 L -4 6 M -4 -10 L -2 -12 L -3 -8 L -3 6 L -2 7 L -4 9 M -3 -2 L 0 -4 L 2 -5 L 4 -2 L 1 0 L -3 3 M 1 -4 L 3 -2 M 0 -4 L 2 -1 M 0 1 L 1 2 L 2 7 L 4 9 L 6 7 M 1 1 L 2 3 L 3 7 L 4 8 M 1 0 L 2 1 L 4 6 L 5 7 L 6 7","-5 5 M 0 -10 L -2 -12 L -1 -8 L -1 6 L -2 7 L 0 9 M 0 -10 L 0 6 L -1 7 L 0 8 L 1 7 L 0 6 M 0 -10 L 2 -12 L 1 -8 L 1 6 L 2 7 L 0 9","-13 13 M -11 -3 L -10 -3 L -9 -2 L -9 6 L -10 7 L -8 9 M -9 -4 L -8 -3 L -8 6 L -9 7 L -8 8 L -7 7 L -8 6 M -11 -3 L -9 -5 L -7 -3 L -7 6 L -6 7 L -8 9 M -7 -3 L -4 -4 L -2 -5 L 1 -3 L 1 6 L 2 7 L 0 9 M -2 -4 L 0 -3 L 0 6 L -1 7 L 0 8 L 1 7 L 0 6 M -4 -4 L -1 -2 L -1 6 L -2 7 L 0 9 M 1 -3 L 4 -4 L 6 -5 L 9 -3 L 9 6 L 10 7 L 8 9 M 6 -4 L 8 -3 L 8 6 L 7 7 L 8 8 L 9 7 L 8 6 M 4 -4 L 7 -2 L 7 6 L 6 7 L 8 9","-9 9 M -7 -3 L -6 -3 L -5 -2 L -5 6 L -6 7 L -4 9 M -5 -4 L -4 -3 L -4 6 L -5 7 L -4 8 L -3 7 L -4 6 M -7 -3 L -5 -5 L -3 -3 L -3 6 L -2 7 L -4 9 M -3 -3 L 0 -4 L 2 -5 L 5 -3 L 5 6 L 6 7 L 4 9 M 2 -4 L 4 -3 L 4 6 L 3 7 L 4 8 L 5 7 L 4 6 M 0 -4 L 3 -2 L 3 6 L 2 7 L 4 9","-8 8 M -5 -2 L -5 6 L -2 9 L 3 7 L 5 6 M -4 -2 L -4 6 L -2 8 M -3 -3 L -3 5 L 0 8 M -5 -2 L -3 -3 L 2 -5 L 5 -2 L 5 6 M 2 -4 L 4 -2 L 4 6 M 0 -4 L 3 -1 L 3 7","-9 8 M -6 -5 L -5 -3 L -5 6 L -7 7 L -5 7 L -5 13 L -6 16 L -4 14 M -4 -3 L -4 14 M -6 -5 L -4 -4 L -3 -3 L -3 6 L -1 7 L 0 8 M -4 7 L -3 7 L -1 8 M -3 8 L -2 9 L 3 7 L 5 6 M -3 8 L -3 13 L -2 16 L -4 14 M -3 -3 L 0 -4 L 2 -5 L 5 -2 L 5 6 M 2 -4 L 4 -2 L 4 6 M 0 -4 L 3 -1 L 3 7","-8 9 M -5 -2 L -5 6 L -2 9 L 3 7 M -4 -2 L -4 6 L -2 8 M -3 -3 L -3 5 L 0 8 M -5 -2 L -3 -3 L 2 -5 L 5 -2 L 5 13 L 6 16 L 4 14 M 2 -4 L 4 -2 L 4 14 M 0 -4 L 3 -1 L 3 13 L 2 16 L 4 14","-7 6 M -5 -3 L -4 -3 L -3 -2 L -3 6 L -4 7 L -2 9 M -3 -4 L -2 -3 L -2 6 L -3 7 L -2 8 L -1 7 L -2 6 M -5 -3 L -3 -5 L -1 -3 L -1 6 L 0 7 L -2 9 M -1 -3 L 3 -5 L 5 -3 L 3 -2 L 1 -4 M 2 -4 L 4 -3","-8 8 M -5 -2 L -5 1 L -3 3 L 3 0 L 5 2 L 5 6 M -4 -2 L -4 1 L -3 2 M -3 -3 L -3 1 L -2 2 M 3 1 L 4 2 L 4 6 M 2 1 L 3 2 L 3 7 M -5 -2 L 1 -5 L 4 -4 L 2 -3 L -1 -4 M 0 -4 L 3 -4 M 5 6 L -1 9 L -5 7 L -3 6 L 1 8 M -3 7 L -1 8","-5 5 M 0 -10 L -2 -12 L -1 -8 L -1 6 L -2 7 L 0 9 M 0 -10 L 0 6 L -1 7 L 0 8 L 1 7 L 0 6 M 0 -10 L 2 -12 L 1 -8 L 1 6 L 2 7 L 0 9 M -4 -5 L -1 -5 M 1 -5 L 4 -5","-9 9 M -7 -3 L -6 -3 L -5 -2 L -5 7 L -2 9 L 3 7 M -5 -4 L -4 -3 L -4 7 L -2 8 M -7 -3 L -5 -5 L -3 -3 L -3 6 L 0 8 M 4 -5 L 6 -3 L 5 -2 L 5 6 L 6 7 L 7 7 M 4 -2 L 5 -3 L 4 -4 L 3 -3 L 4 -2 L 4 7 L 5 8 M 4 -5 L 2 -3 L 3 -2 L 3 7 L 5 9 L 7 7","-9 9 M -6 -5 L -5 -3 L -5 6 L -1 9 L 1 7 L 5 5 M -5 -4 L -4 -3 L -4 6 L -1 8 M -6 -5 L -4 -4 L -3 -3 L -3 5 L 0 7 L 1 7 M 4 -5 L 6 -3 L 5 -2 L 5 5 M 4 -2 L 5 -3 L 4 -4 L 3 -3 L 4 -2 L 4 5 M 4 -5 L 2 -3 L 3 -2 L 3 6","-13 13 M -10 -5 L -9 -3 L -9 6 L -5 9 L -3 7 L -1 6 M -9 -4 L -8 -3 L -8 6 L -5 8 M -10 -5 L -8 -4 L -7 -3 L -7 5 L -4 7 L -3 7 M 0 -5 L -2 -3 L -1 -2 L -1 6 L 3 9 L 5 7 L 9 5 M 0 -2 L 1 -3 L 0 -4 L -1 -3 L 0 -2 L 0 6 L 3 8 M 0 -5 L 2 -3 L 1 -2 L 1 5 L 4 7 L 5 7 M 8 -5 L 10 -3 L 9 -2 L 9 5 M 8 -2 L 9 -3 L 8 -4 L 7 -3 L 8 -2 L 8 5 M 8 -5 L 6 -3 L 7 -2 L 7 6","-9 9 M -6 -3 L -4 -2 L 3 8 L 4 9 L 6 7 M -5 -4 L -3 -3 L 3 7 L 5 8 M -6 -3 L -4 -5 L -3 -4 L 4 6 L 6 7 M 6 -5 L 4 -5 L 4 -3 L 6 -3 L 6 -5 L 4 -3 L 1 1 M -1 3 L -4 7 L -6 9 L -4 9 L -4 7 L -6 7 L -6 9 M -4 2 L -1 2 M 1 2 L 4 2","-9 9 M -7 -3 L -6 -3 L -5 -2 L -5 7 L -2 9 L 3 7 M -5 -4 L -4 -3 L -4 7 L -2 8 M -7 -3 L -5 -5 L -3 -3 L -3 6 L 0 8 M 4 -5 L 6 -3 L 5 -2 L 5 11 L 4 13 L 3 14 L 1 15 L -1 15 L -3 14 L -5 15 L -3 16 L -1 15 M 4 -2 L 5 -3 L 4 -4 L 3 -3 L 4 -2 L 4 12 L 3 13 M -2 15 L -4 15 M 4 -5 L 2 -3 L 3 -2 L 3 12 L 2 14 L 1 15","-6 9 M 0 -4 L -3 -2 L -3 -3 L 0 -4 L 2 -5 L 5 -3 L 5 1 L 0 3 M 2 -4 L 4 -3 L 4 1 M 0 -4 L 3 -2 L 3 1 L 2 2 M 0 3 L 5 5 L 5 11 L 4 13 L 3 14 L 1 15 L -1 15 L -3 14 L -5 15 L -3 16 L -1 15 M 4 5 L 4 12 L 3 13 M -2 15 L -4 15 M 2 4 L 3 5 L 3 12 L 2 14 L 1 15","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
greek = ["-8 8","-5 5 M 0 -12 L 0 2 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-8 8 M -4 -12 L -4 -5 M 4 -12 L 4 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 10 M -2 -16 L -2 13 M 2 -16 L 2 13 M 7 -9 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 1 L 7 3 L 7 6 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-13 13 M 10 -3 L 10 -4 L 9 -5 L 8 -5 L 7 -4 L 6 -2 L 4 3 L 2 6 L 0 8 L -2 9 L -6 9 L -8 8 L -9 7 L -10 5 L -10 3 L -9 1 L -8 0 L -1 -4 L 0 -5 L 1 -7 L 1 -9 L 0 -11 L -2 -12 L -4 -11 L -5 -9 L -5 -7 L -4 -4 L -2 -1 L 3 6 L 5 8 L 7 9 L 9 9 L 10 8 L 10 7","-5 5 M 0 -10 L -1 -11 L 0 -12 L 1 -11 L 1 -9 L 0 -7 L -1 -6","-7 7 M 4 -16 L 2 -14 L 0 -11 L -2 -7 L -3 -2 L -3 2 L -2 7 L 0 11 L 2 14 L 4 16","-7 7 M -4 -16 L -2 -14 L 0 -11 L 2 -7 L 3 -2 L 3 2 L 2 7 L 0 11 L -2 14 L -4 16","-8 8 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-13 13 M 0 -9 L 0 9 M -9 0 L 9 0","-4 4 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-13 13 M -9 0 L 9 0","-4 4 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-11 11 M 9 -16 L -9 16","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12","-10 10 M -4 -8 L -2 -9 L 1 -12 L 1 9","-10 10 M -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 3 -1 L -7 9 L 7 9","-10 10 M -5 -12 L 6 -12 L 0 -4 L 3 -4 L 5 -3 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 3 -12 L -7 2 L 8 2 M 3 -12 L 3 9","-10 10 M 5 -12 L -5 -12 L -6 -3 L -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 6 -9 L 5 -11 L 2 -12 L 0 -12 L -3 -11 L -5 -8 L -6 -3 L -6 2 L -5 6 L -3 8 L 0 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 L -3 -3 L -5 -1 L -6 2","-10 10 M 7 -12 L -3 9 M -7 -12 L 7 -12","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 1 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 2 L -6 0 L -4 -2 L -1 -3 L 3 -4 L 5 -5 L 6 -7 L 6 -9 L 5 -11 L 2 -12 L -2 -12","-10 10 M 6 -5 L 5 -2 L 3 0 L 0 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 0 -12 L 3 -11 L 5 -9 L 6 -5 L 6 0 L 5 5 L 3 8 L 0 9 L -2 9 L -5 8 L -6 6","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-12 12 M 8 -9 L -8 0 L 8 9","-13 13 M -9 -3 L 9 -3 M -9 3 L 9 3","-12 12 M -8 -9 L 8 0 L -8 9","-9 9 M -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 4 -3 L 0 -1 L 0 2 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-9 9 M 0 -12 L -8 9 M 0 -12 L 8 9 M -5 2 L 5 2","-11 10 M -7 -12 L -7 9 M -7 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 2 -2 M -7 -2 L 2 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -7 9","-10 10 M -7 -12 L 7 9 M -7 9 L 7 -12","-9 9 M 0 -12 L -8 9 M 0 -12 L 8 9 M -8 9 L 8 9","-10 9 M -6 -12 L -6 9 M -6 -12 L 7 -12 M -6 -2 L 2 -2 M -6 9 L 7 9","-10 10 M 0 -12 L 0 9 M -2 -7 L -5 -6 L -6 -5 L -7 -3 L -7 0 L -6 2 L -5 3 L -2 4 L 2 4 L 5 3 L 6 2 L 7 0 L 7 -3 L 6 -5 L 5 -6 L 2 -7 L -2 -7","-10 7 M -6 -12 L -6 9 M -6 -12 L 6 -12","-11 11 M -7 -12 L -7 9 M 7 -12 L 7 9 M -7 -2 L 7 -2","-4 4 M 0 -12 L 0 9","-2 3 M 0 -1 L 0 0 L 1 0 L 1 -1 L 0 -1","-11 10 M -7 -12 L -7 9 M 7 -12 L -7 2 M -2 -3 L 7 9","-9 9 M 0 -12 L -8 9 M 0 -12 L 8 9","-12 12 M -8 -12 L -8 9 M -8 -12 L 0 9 M 8 -12 L 0 9 M 8 -12 L 8 9","-11 11 M -7 -12 L -7 9 M -7 -12 L 7 9 M 7 -12 L 7 9","-11 11 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -2 9 L 2 9 L 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11 L 2 -12 L -2 -12","-11 11 M -7 -12 L -7 9 M 7 -12 L 7 9 M -7 -12 L 7 -12","-11 11 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -2 9 L 2 9 L 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11 L 2 -12 L -2 -12 M -3 -2 L 3 -2","-11 10 M -7 -12 L -7 9 M -7 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -5 L 6 -3 L 5 -2 L 2 -1 L -7 -1","-9 9 M -7 -12 L 0 -2 L -7 9 M -7 -12 L 7 -12 M -7 9 L 7 9","-8 8 M 0 -12 L 0 9 M -7 -12 L 7 -12","-9 9 M -7 -7 L -7 -9 L -6 -11 L -5 -12 L -3 -12 L -2 -11 L -1 -9 L 0 -5 L 0 9 M 7 -7 L 7 -9 L 6 -11 L 5 -12 L 3 -12 L 2 -11 L 1 -9 L 0 -5","-7 7 M -1 -12 L -3 -11 L -4 -9 L -4 -7 L -3 -5 L -1 -4 L 1 -4 L 3 -5 L 4 -7 L 4 -9 L 3 -11 L 1 -12 L -1 -12","-10 10 M -7 9 L -3 9 L -6 2 L -7 -2 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -6 L 7 -2 L 6 2 L 3 9 L 7 9","-9 9 M -7 -12 L 7 -12 M -3 -2 L 3 -2 M -7 9 L 7 9","-11 11 M 0 -12 L 0 9 M -9 -6 L -8 -6 L -7 -5 L -6 -1 L -5 1 L -4 2 L -1 3 L 1 3 L 4 2 L 5 1 L 6 -1 L 7 -5 L 8 -6 L 9 -6","-10 10 M 7 -12 L -7 9 M -7 -12 L 7 -12 M -7 9 L 7 9","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-8 8 M 0 -14 L -8 0 M 0 -14 L 8 0","-9 9 M -9 16 L 9 16","-4 4 M 1 -7 L -1 -5 L -1 -3 L 0 -2 L 1 -3 L 0 -4 L -1 -3","-10 11 M -1 -5 L -3 -4 L -5 -2 L -6 0 L -7 3 L -7 6 L -6 8 L -4 9 L -2 9 L 0 8 L 3 5 L 5 2 L 7 -2 L 8 -5 M -1 -5 L 1 -5 L 2 -4 L 3 -2 L 5 6 L 6 8 L 7 9 L 8 9","-9 10 M 3 -12 L 1 -11 L -1 -9 L -3 -5 L -4 -2 L -5 2 L -6 8 L -7 16 M 3 -12 L 5 -12 L 7 -10 L 7 -7 L 6 -5 L 5 -4 L 3 -3 L 0 -3 M 0 -3 L 2 -2 L 4 0 L 5 2 L 5 5 L 4 7 L 3 8 L 1 9 L -1 9 L -3 8 L -4 7 L -5 4","-9 9 M -7 -5 L -5 -5 L -3 -3 L 3 14 L 5 16 L 7 16 M 8 -5 L 7 -3 L 5 0 L -5 11 L -7 14 L -8 16","-9 9 M 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 4 L -5 7 L -4 8 L -2 9 L 0 9 L 2 8 L 4 6 L 5 3 L 5 0 L 4 -3 L 2 -5 L 0 -7 L -1 -9 L -1 -11 L 0 -12 L 2 -12 L 4 -11 L 6 -9","-8 8 M 5 -3 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -3 -2 L -2 0 L 1 1 M 1 1 L -3 2 L -5 4 L -5 6 L -4 8 L -2 9 L 1 9 L 3 8 L 5 6","-11 11 M -3 -4 L -5 -3 L -7 -1 L -8 2 L -8 5 L -7 7 L -6 8 L -4 9 L -1 9 L 2 8 L 5 6 L 7 3 L 8 0 L 8 -3 L 6 -5 L 4 -5 L 2 -3 L 0 1 L -2 6 L -5 16","-9 10 M -8 -2 L -6 -4 L -4 -5 L -3 -5 L -1 -4 L 0 -3 L 1 0 L 1 4 L 0 9 M 8 -5 L 7 -2 L 6 0 L 0 9 L -2 13 L -3 16","-10 10 M -9 -1 L -8 -3 L -6 -5 L -4 -5 L -3 -4 L -3 -2 L -4 2 L -6 9 M -4 2 L -2 -2 L 0 -4 L 2 -5 L 4 -5 L 6 -3 L 6 0 L 5 5 L 2 16","-6 5 M 0 -5 L -2 2 L -3 6 L -3 8 L -2 9 L 0 9 L 2 7 L 3 5","-11 11 M -7 -7 L 7 7 M 7 -7 L -7 7","-9 9 M -3 -5 L -7 9 M 7 -4 L 6 -5 L 5 -5 L 3 -4 L -1 0 L -3 1 L -4 1 M -4 1 L -2 2 L -1 3 L 1 8 L 2 9 L 3 9 L 4 8","-8 8 M -7 -12 L -5 -12 L -3 -11 L -2 -10 L 6 9 M 0 -5 L -6 9","-10 11 M -3 -5 L -9 16 M -4 -1 L -5 4 L -5 7 L -3 9 L -1 9 L 1 8 L 3 6 L 5 2 M 7 -5 L 5 2 L 4 6 L 4 8 L 5 9 L 7 9 L 9 7 L 10 5","-9 9 M -6 -5 L -3 -5 L -4 1 L -5 6 L -6 9 M 7 -5 L 6 -2 L 5 0 L 3 3 L 0 6 L -3 8 L -6 9","-8 9 M 0 -5 L -2 -4 L -4 -2 L -5 1 L -5 4 L -4 7 L -3 8 L -1 9 L 1 9 L 3 8 L 5 6 L 6 3 L 6 0 L 5 -3 L 4 -4 L 2 -5 L 0 -5","-11 11 M -2 -5 L -6 9 M 3 -5 L 4 1 L 5 6 L 6 9 M -9 -2 L -7 -4 L -4 -5 L 9 -5","-11 10 M -10 -1 L -9 -3 L -7 -5 L -5 -5 L -4 -4 L -4 -2 L -5 3 L -5 6 L -4 8 L -3 9 L -1 9 L 1 8 L 3 5 L 4 3 L 5 0 L 6 -5 L 6 -8 L 5 -11 L 3 -12 L 1 -12 L 0 -10 L 0 -8 L 1 -5 L 3 -2 L 5 0 L 8 2","-9 9 M -5 1 L -5 4 L -4 7 L -3 8 L -1 9 L 1 9 L 3 8 L 5 6 L 6 3 L 6 0 L 5 -3 L 4 -4 L 2 -5 L 0 -5 L -2 -4 L -4 -2 L -5 1 L -9 16","-9 11 M 9 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 4 L -5 7 L -4 8 L -2 9 L 0 9 L 2 8 L 4 6 L 5 3 L 5 0 L 4 -3 L 3 -4 L 1 -5","-10 10 M 1 -5 L -2 9 M -8 -2 L -6 -4 L -3 -5 L 8 -5","-10 10 M -9 -1 L -8 -3 L -6 -5 L -4 -5 L -3 -4 L -3 -2 L -5 4 L -5 7 L -3 9 L -1 9 L 2 8 L 4 6 L 6 2 L 7 -2 L 7 -5","-13 13 M 0 -9 L -1 -8 L 0 -7 L 1 -8 L 0 -9 M -9 0 L 9 0 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-12 11 M -4 -5 L -6 -4 L -8 -1 L -9 2 L -9 5 L -8 8 L -7 9 L -5 9 L -3 8 L -1 5 M 0 1 L -1 5 L 0 8 L 1 9 L 3 9 L 5 8 L 7 5 L 8 2 L 8 -1 L 7 -4 L 6 -5","-8 8 M 2 -12 L 0 -11 L -1 -10 L -1 -9 L 0 -8 L 3 -7 L 6 -7 M 3 -7 L 0 -6 L -2 -5 L -3 -3 L -3 -1 L -1 1 L 2 2 L 4 2 M 2 2 L -2 3 L -4 4 L -5 6 L -5 8 L -3 10 L 1 12 L 2 13 L 2 15 L 0 16 L -2 16","-12 11 M 4 -12 L -4 16 M -11 -1 L -10 -3 L -8 -5 L -6 -5 L -5 -4 L -5 -2 L -6 3 L -6 6 L -5 8 L -3 9 L -1 9 L 2 8 L 4 6 L 6 3 L 8 -2 L 9 -5","-8 7 M 2 -12 L 0 -11 L -1 -10 L -1 -9 L 0 -8 L 3 -7 L 6 -7 M 6 -7 L 2 -5 L -1 -3 L -4 0 L -5 3 L -5 5 L -4 7 L -2 9 L 1 11 L 2 13 L 2 15 L 1 16 L -1 16 L -2 14","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
japanese = ["-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 9 L -11 8 L -10 7 L -9 8 L -9 10 L -10 12 L -11 13","-14 13 M -10 -3 L -8 -1 L 8 -2 L 10 -1 M -9 -2 L 10 -1","-14 13 M -5 -10 L -7 -11 L -7 10 M -6 -10 L -6 10 M -6 8 L 6 8 M -6 -10 L 6 -10 M 5 -10 L 6 -11 L 8 -10 L 7 -8 M 6 -10 L 6 10 M 7 -10 L 7 10 M -6 -1 L 6 -1","-14 13 M -7 -11 L -9 -12 L -9 9 M -8 -11 L -8 9 M -8 -11 L 7 -11 M 6 -11 L 7 -12 L 9 -11 L 8 -9 M 7 -11 L 7 5 L 6 7 L 5 8 M 7 6 L 7 7 L 6 8 M 8 -11 L 8 7 L 7 9 L 6 9 L 5 8 L 3 7 M -1 -11 L -1 -2 M 0 -11 L 0 -2 M -8 -2 L 7 -2","-14 13 M -6 -12 L -8 -7 L -11 -1 M -6 -12 L -5 -11 L -6 -9 L -9 -4 L -11 -1 M -6 -9 L 10 -9 L 8 -11 L 6 -9 M 6 -9 L 9 -10 M 0 -9 L 0 10 M 1 -9 L 1 10 M -4 -3 L -6 -4 L -6 3 M -5 -3 L -5 3 M -5 -3 L 9 -3 L 7 -5 L 5 -3 M 5 -3 L 8 -4 M -11 3 L 11 3 L 9 1 L 7 3 M 7 3 L 10 2","-14 13 M -1 -12 L -1 -6 L -2 -1 L -4 3 L -6 6 L -8 8 L -11 10 M 0 -11 L 0 -7 M -1 -12 L 1 -11 L 0 -4 L -1 0 L -3 4 L -6 7 L -9 9 L -11 10 M -11 -5 L 11 -5 L 9 -7 L 7 -5 M 7 -5 L 10 -6 M 1 -5 L 2 -1 L 3 2 L 4 4 L 6 7 L 9 10 L 11 9 M 7 7 L 9 9 M 1 -5 L 2 -2 L 4 2 L 6 5 L 8 7 L 11 9","-14 13 M -8 -11 L -10 -12 L -10 10 M -9 -11 L -9 10 M -9 -11 L 9 -11 M 8 -11 L 9 -12 L 11 -11 L 10 -9 M 9 -11 L 9 10 M 10 -11 L 10 10 M -7 -7 L 7 -7 L 6 -8 L 5 -7 M -1 -7 L -1 5 M 0 -7 L 0 5 M -6 -1 L 6 -1 L 5 -2 L 4 -1 M -7 5 L 7 5 L 6 4 L 5 5 M 2 1 L 3 3 L 4 3 L 4 2 L 2 1 M -9 9 L 9 9","-14 13 M -1 -12 L -1 -6 L -2 -1 L -4 3 L -6 6 L -8 8 L -11 10 M 0 -11 L 0 -7 M -1 -12 L 1 -11 L 0 -4 L -1 0 L -3 4 L -6 7 L -9 9 L -11 10 M 1 -11 L 1 -7 L 2 -1 L 3 2 L 4 4 L 6 7 L 9 10 L 11 9 M 7 7 L 9 9 M 1 -7 L 2 -2 L 4 2 L 6 5 L 8 7 L 11 9","-14 13 M 0 -11 L 1 -12 L -1 -12 L -1 10 M 0 -11 L 0 10 M -11 -10 L 11 -10 L 9 -11 L 8 -10 M -6 -6 L -8 -7 L -8 3 M -7 -6 L -7 3 M -7 -6 L 6 -6 M 5 -6 L 6 -7 L 8 -6 L 7 -4 M 6 -6 L 6 3 M 7 -6 L 7 3 M -7 -2 L 6 -2 M -7 2 L 6 2 M -1 2 L -4 5 L -7 7 L -11 9 M -1 4 L -4 6 L -6 7 L -11 9 M 0 2 L 3 6 L 6 8 L 9 9 L 11 8 M 0 2 L 3 5 L 7 7 L 11 8","-14 13 M 0 -10 L 1 -11 L -1 -12 L -1 11 M 0 -11 L 0 11 M -8 -6 L -10 -7 L -10 4 M -9 -6 L -9 4 M -9 -6 L 8 -6 M 7 -6 L 8 -7 L 10 -6 L 9 -4 M 8 -6 L 8 4 M 9 -6 L 9 4 M -9 3 L 8 3","-14 13 M 0 -10 L 1 -11 L -1 -12 L -1 10 M 0 -11 L 0 10 M -11 -6 L 11 -6 L 9 -8 L 7 -6 M 7 -6 L 10 -7 M -2 -6 L -5 0 L -8 4 L -11 7 M -1 -5 L -3 -1 L -5 2 L -7 4 L -11 7 M 1 -5 L 2 -2 L 3 0 L 6 4 L 9 7 L 11 6 M 7 4 L 9 6 M 1 -5 L 2 -3 L 5 1 L 8 4 L 11 6 M -5 5 L 4 5 L 3 4 L 2 5","-14 13 M 0 -11 L 0 -12 L 1 -13 L -1 -13 L -1 -11 M -11 -11 L 11 -11 L 9 -13 L 7 -11 M 7 -11 L 10 -12 M -6 -7 L -8 -8 L -8 0 M -7 -7 L -7 0 M -7 -7 L 6 -7 M 5 -7 L 6 -8 L 8 -7 L 7 -5 M 6 -7 L 6 0 M 7 -7 L 7 0 M -7 -1 L 6 -1 M -1 -1 L -1 6 L -2 8 L -3 9 M -1 7 L -1 8 L -2 9 M 0 -1 L 0 8 L -1 10 L -2 10 L -3 9 L -5 8 M -6 2 L -11 7 M -6 2 L -5 3 L -11 7 M 4 2 L 6 4 L 8 7 L 9 7 L 9 6 L 8 5 L 4 2","-14 13 M -1 -12 L -1 9 M -1 -12 L 0 -12 L 0 9 M -8 -10 L -8 -2 M -8 -10 L -7 -10 L -7 -2 M -7 -3 L 6 -3 M 6 -10 L 6 -2 M 6 -10 L 7 -10 L 7 -2 M -10 1 L -10 10 M -10 1 L -9 1 L -9 10 M -9 9 L 8 9 M 8 1 L 8 10 M 8 1 L 9 1 L 9 10","-14 13 M -10 -12 L -10 5 M -10 -12 L -9 -11 L -9 5 M -9 -11 L -5 -11 M -5 -11 L -5 4 M -6 -11 L -5 -12 L -4 -11 L -4 4 M -9 -4 L -5 -4 M -9 3 L -5 3 M 3 -11 L 4 -12 L 2 -12 L 2 -4 M 3 -11 L 3 -4 M -2 -8 L 9 -8 L 7 -9 L 6 -8 M -4 -4 L 11 -4 L 9 -5 L 8 -4 M 5 -4 L 5 8 L 4 9 M 6 -4 L 6 8 L 5 10 L 4 9 L 2 8 M -4 0 L 11 0 L 9 -1 L 8 0 M -1 2 L 0 3 L 1 5 L 2 5 L 2 4 L 1 3 L -1 2","-14 13 M 0 -10 L 1 -11 L -1 -12 L -1 9 M 0 -11 L 0 9 M 0 -2 L 9 -2 L 7 -4 L 5 -2 M 5 -2 L 8 -3 M -11 9 L 11 9 L 9 7 L 7 9 M 7 9 L 10 8","-14 13 M -1 -11 L 0 -12 L -2 -12 L -2 -5 M -1 -11 L -1 -5 M -9 -9 L 3 -9 L 2 -10 L 1 -9 M -11 -5 L 11 -5 L 9 -6 L 8 -5 M 6 -11 L 3 -7 L 0 -4 L -4 -1 L -9 2 M 6 -11 L 7 -10 L 2 -5 L -2 -2 L -5 0 L -9 2 L -11 3 M -3 -1 L -5 -2 L -5 10 M -4 -1 L -4 10 M -4 -1 L 6 -1 M 5 -1 L 6 -2 L 8 -1 L 7 1 M 6 -1 L 6 10 M 7 -1 L 7 10 M -4 4 L 6 4 M -4 9 L 6 9","-14 13 M 0 -10 L 1 -11 L -1 -12 L -1 10 M 0 -11 L 0 10 M -11 -3 L 11 -3 L 9 -5 L 7 -3 M 7 -3 L 10 -4","-14 13 M -11 -1 L 11 -1 L 8 -3 L 6 -1 M 6 -1 L 9 -2","-14 13 M -8 -8 L 8 -8 L 6 -10 L 4 -8 M 4 -8 L 7 -9 M -11 6 L 11 6 L 9 4 L 7 6 M 7 6 L 10 5","-14 13 M -9 -9 L 9 -9 L 7 -11 L 5 -9 M 5 -9 L 8 -10 M -7 -1 L 7 -1 L 5 -3 L 3 -1 M 3 -1 L 6 -2 M -11 8 L 11 8 L 9 6 L 7 8 M 7 8 L 10 7","-14 13 M -8 -9 L -10 -10 L -10 8 M -9 -9 L -9 8 M -9 -9 L 9 -9 M 8 -9 L 9 -10 L 11 -9 L 10 -7 M 9 -9 L 9 8 M 10 -9 L 10 8 M -3 -9 L -3 -4 L -4 0 L -5 2 M -2 -9 L -2 -4 L -3 -1 L -5 2 L -7 4 M 1 -9 L 1 1 L 2 2 L 6 2 L 7 1 L 6 0 M 2 -9 L 2 0 L 3 1 L 5 1 L 6 0 L 6 -2 M -9 7 L 9 7","-14 13 M -9 -10 L 8 -10 L 6 -12 L 4 -10 M 4 -10 L 7 -11 M -1 -10 L -4 8 M 0 -10 L -3 8 M -9 -2 L 4 -2 M 3 -2 L 4 -3 L 6 -2 L 5 0 M 4 -2 L 3 8 M 5 -2 L 5 0 L 4 8 M -11 8 L 11 8 L 9 6 L 7 8 M 7 8 L 10 7","-14 13 M 0 -9 L 1 -10 L -1 -11 L -1 -5 M 0 -10 L 0 -5 M -11 -5 L 11 -5 L 9 -7 L 7 -5 M 7 -5 L 10 -6 M -5 -1 L -6 2 L -8 6 L -10 9 M -4 0 L -5 2 M -5 -1 L -3 0 L -5 3 L -8 7 L -10 9 M 2 -1 L 4 1 L 7 5 L 8 7 L 9 8 L 10 7 L 9 5 L 6 2 L 2 -1 M 7 4 L 9 7","-14 13 M -5 -9 L -4 -10 L -6 -11 L -6 8 L -5 9 L 7 9 L 8 8 L 7 6 M 6 8 L 7 8 L 7 7 M -5 -10 L -5 7 L -4 8 L 5 8 L 7 6 L 8 3 M -10 -1 L -4 -2 L 1 -3 L 9 -5 L 6 -6 L 5 -4 M 5 -4 L 7 -5","-14 13 M 0 -6 L -1 -3 L -3 2 L -5 5 L -8 8 L -11 10 M 0 -6 L 1 -5 L 0 -2 L -2 2 L -4 5 L -6 7 L -9 9 L -11 10 M -6 -11 L 3 -11 M 0 -11 L 1 -12 L 3 -11 L 1 -9 M 1 -11 L 1 -6 L 2 -1 L 3 2 L 4 4 L 6 7 L 9 10 L 11 9 M 7 7 L 9 9 M 1 -6 L 2 -2 L 4 2 L 6 5 L 8 7 L 11 9","-14 13 M -4 -9 L -3 -10 L -5 -11 L -5 0 L -6 4 L -8 7 L -11 10 M -4 -10 L -4 0 L -5 4 L -7 7 L -11 10 M -11 -4 L 2 -5 M 1 -5 L 2 -6 L 4 -5 L 3 -3 M 2 -5 L 2 8 L 3 9 L 10 9 L 11 8 L 10 6 M 9 8 L 10 8 L 10 7 M 3 -5 L 3 7 L 4 8 L 8 8 L 10 6 L 11 3","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -3 -12 L -1 -11 L -1 -9 L -2 -6 M -2 -11 L -2 0 L -1 4 M -7 -7 L -5 -6 L 0 -6 L 3 -7 L 6 -8 M 3 -7 L 4 -8 L 6 -8 M 1 1 L 2 -3 L 3 -2 L 1 1 L -2 5 L -4 7 L -6 8 L -8 8 L -9 7 L -9 4 L -8 2 L -6 0 L -4 -1 L -1 -2 L 4 -2 L 7 -1 L 9 1 L 10 3 L 10 5 L 9 7 L 7 9 L 4 10 L 2 10 M -7 8 L -8 7 L -8 4 L -7 2 L -5 0 L -1 -2 M 4 -2 L 6 -1 L 8 1 L 9 3 L 9 5 L 8 7 L 6 9 L 4 10","-14 13 M -10 -10 L -8 -9 L -8 -7 L -9 -5 L -10 -2 M -9 -9 L -9 -7 L -10 -2 L -10 1 L -9 4 L -8 5 L -6 6 L -5 6 L -5 4 L -4 1 L -3 -1 M -8 5 L -6 5 L -5 4 M 5 -6 L 7 -5 L 9 -2 L 10 1 L 10 3 L 8 2 L 5 3 M 9 -2 L 9 1 L 8 2","-14 13 M -4 -13 L -3 -12 L -1 -11 L 3 -11 M -3 -12 L 2 -12 L 3 -11 L -1 -9 M -7 -5 L -7 -4 L -6 -3 L -5 -3 L -2 -5 L 0 -6 M -7 -4 L -6 -4 L -3 -5 L 0 -6 L 2 -6 L 5 -5 L 6 -3 L 6 0 L 5 3 L 3 6 L 0 8 L -4 10 M 2 -6 L 4 -5 L 5 -3 L 5 0 L 4 3 L 3 5 L 1 7 L -2 9","-14 13 M -4 -13 L -3 -12 L -1 -11 L 3 -11 M -3 -12 L 2 -12 L 3 -11 L -1 -9 M -8 -5 L -8 -4 L -7 -3 L -5 -3 L 0 -5 L 3 -6 L 4 -5 M -8 -4 L -5 -4 L 0 -5 M 4 -5 L 0 -2 L -6 4 L -10 8 M 3 -6 L 0 -2 M -10 8 L -10 7 L -6 4 L -4 3 L 0 3 L 1 4 L 2 8 L 3 9 L 10 9 M 5 9 L 8 8 L 9 8 L 10 9","-14 13 M -5 -12 L -3 -11 L -3 -9 L -4 -5 M -4 -11 L -4 9 M -4 2 L -3 8 L -4 9 L -5 7 L -7 6 L -10 5 M -10 -5 L -8 -4 L -4 -4 L -1 -5 L 1 -6 M -4 -4 L -2 -5 L -1 -6 L 1 -6 M -10 6 L -6 3 L -1 0 L 2 -1 L 4 -1 L 7 0 L 8 2 L 8 4 L 7 6 L 5 7 L 3 7 L 1 6 L 0 4 M -10 6 L -10 5 L -6 3 M 4 -1 L 6 0 L 7 2 L 7 4 L 6 6 L 5 7 M 5 -7 L 7 -7 L 9 -6 L 10 -5 L 8 -5 L 7 -4 M 7 -7 L 8 -6 L 8 -5","-14 13 M -4 -12 L -2 -11 L -2 -9 L -3 -6 L -5 -1 L -10 9 M -3 -11 L -3 -9 L -5 -3 L -7 2 L -10 9 M -10 -5 L -10 -4 L -9 -3 L -8 -3 L -5 -5 L -3 -6 L 0 -6 L 2 -5 L 3 -3 L 3 0 L 2 4 L 0 8 L -1 9 L -2 9 L -2 8 L -3 7 L -5 6 M -10 -4 L -8 -4 L -5 -5 M 0 -6 L 2 -4 L 2 0 L 1 4 L 0 6 L -2 8 M 5 -5 L 7 -4 L 9 -2 L 10 0 L 10 2 L 9 1 L 7 2 M 8 -3 L 9 -1 L 9 1","-14 13 M -4 -12 L -1 -11 L 0 -7 L 1 -4 L 3 0 L 6 4 L 5 5 M -2 -11 L 0 -7 M 3 0 L 5 5 M -6 -7 L -4 -6 L -1 -6 L 2 -7 M -9 -3 L -8 -2 L -5 -1 L 0 -1 L 5 -2 L 8 -3 M 5 -2 L 7 -4 L 8 -3 M 5 5 L 3 4 L 0 3 L -4 3 L -6 4 L -7 5 L -7 7 L -6 8 L -4 9 L -1 10 L 5 10 M -4 9 L 4 9 L 5 10","-14 13 M 2 -12 L 4 -11 L 4 -10 L -4 -2 M 3 -11 L 2 -9 L -4 -2 L -4 -1 L 1 4 L 3 7 L 4 9 M -4 -1 L 4 6 L 5 8 L 4 9","-14 13 M -9 -11 L -7 -10 L -7 -8 L -8 -5 L -9 -1 M -8 -10 L -8 -7 L -9 -1 L -9 3 L -8 7 L -7 8 L -7 6 L -6 2 L -5 -1 L -4 -3 L -3 -4 L -1 -5 L 8 -5 L 10 -6 M -9 3 L -8 5 L -7 6 M 4 -5 L 8 -6 L 9 -7 L 10 -6 M 4 -12 L 6 -11 L 6 3 L 5 6 L 3 8 L 0 10 M 5 -11 L 6 -8 M 6 0 L 5 4 L 3 7 L 0 10","-14 13 M -5 -10 L -3 -9 L 0 -8 L 2 -8 L 5 -9 M -3 -9 L 2 -9 L 4 -10 L 5 -9 L -1 -6 M -7 1 L -7 3 L -6 5 L -4 6 L 0 7 L 7 7 M -4 6 L 6 6 L 7 7","-14 13 M -8 -7 L -7 -6 L -4 -5 L 0 -5 L 4 -6 L 6 -7 L 7 -8 M 4 -6 L 6 -8 L 7 -8 M -2 -12 L -1 -9 L 0 -7 L 3 -3 L 5 0 L 6 2 M -2 -12 L -1 -12 L -1 -10 L 0 -7 M 3 -3 L 6 0 L 7 2 L 7 3 M 7 3 L 6 2 L 4 1 L 0 0 L -4 0 L -7 1 L -8 3 L -8 5 L -7 7 L -5 8 L -1 9 L 3 9 M -8 5 L -7 6 L -5 7 L -1 8 L 4 8 L 3 9","-14 13 M -6 -12 L -4 -11 L -5 1 L -5 6 L -4 8 M -5 -11 L -6 1 L -6 5 L -5 7 L -4 8 L -2 9 L 1 9 L 4 8 L 7 6 L 9 4","-14 13 M 0 -12 L 2 -11 L 2 1 L 1 3 L -1 4 L -3 3 L -4 1 L -4 0 L -3 -2 L -1 -3 L 1 -2 L 2 0 L 2 4 L 1 8 L -1 10 M 1 -11 L 2 -6 M 2 4 L 1 7 L -1 10 M -10 -8 L -8 -6 L -5 -6 L 4 -7 L 8 -8 L 10 -7 M -9 -7 L -5 -6 M 4 -7 L 10 -7","-14 13 M -6 -8 L -4 -7 L -4 4 L -3 6 L -2 7 L 0 8 L 8 8 M -5 -7 L -4 -4 M 3 8 L 6 7 L 7 7 L 8 8 M 3 -11 L 5 -10 L 5 2 L 4 4 L 3 3 L 0 1 M 4 -10 L 5 -7 M 5 -1 L 4 2 L 3 3 M -10 -4 L -8 -2 L -6 -2 L -2 -3 L 3 -4 L 7 -5 L 9 -5 L 10 -4 M -9 -3 L -2 -3 M 3 -4 L 10 -4","-14 13 M -4 -11 L -2 -9 L 4 -11 M -3 -10 L -1 -10 L 4 -11 L 5 -10 M 5 -10 L 2 -7 L -4 -3 L -8 -1 M 4 -11 L 3 -9 L 1 -7 L -4 -3 M -9 -2 L -7 0 L -3 -2 M -8 -1 L -3 -2 L 3 -3 L 8 -4 L 9 -3 M 3 -3 L 9 -3 M 3 -3 L 1 -2 L -1 0 L -2 2 L -2 4 L -1 6 L 0 7 L 3 8 L 7 8 M -1 6 L 2 7 L 6 7 L 7 8","-14 13 M -4 -12 L -2 -11 L -2 -9 L -4 -3 L -5 0 L -7 5 L -9 9 M -3 -11 L -3 -8 L -4 -3 M -5 0 L -7 4 L -9 7 L -9 9 M -10 -5 L -8 -4 L -5 -4 L -2 -5 L 0 -6 L 2 -7 M 0 -6 L 1 -8 L 2 -7 M 3 -4 L 6 -4 L 9 -3 L 7 -3 L 5 -2 M 6 -4 L 7 -3 M 0 4 L 1 6 L 2 7 L 4 8 L 9 8 M 1 6 L 3 7 L 10 7 L 9 8","-14 13 M -5 -12 L -3 -11 L -3 -9 L -5 -4 L -6 0 L -6 2 L -5 3 M -4 -11 L -4 -7 M -5 -4 L -5 3 M -10 -8 L -7 -7 L -3 -7 L 1 -8 L 3 -9 M 1 -8 L 2 -10 L 3 -9 M -5 3 L -3 1 L 0 -1 L 3 -2 L 6 -2 L 8 -1 L 9 1 L 9 4 L 8 6 L 5 8 L 1 9 L -3 9 M 6 -2 L 7 -1 L 8 1 L 8 4 L 7 6 L 5 8","-14 13 M -10 -6 L -8 -4 L -3 -6 L 1 -7 L 5 -7 L 8 -6 L 9 -5 L 10 -3 L 10 0 L 9 2 L 8 3 L 6 4 L 3 5 L -2 6 M -9 -5 L -3 -6 M 5 -7 L 7 -6 L 8 -5 L 9 -3 L 9 0 L 8 2 L 6 4","-14 13 M -10 -9 L -8 -7 L -6 -7 L -2 -8 L 3 -9 L 7 -10 L 9 -10 L 10 -9 M -9 -8 L -2 -8 M 3 -9 L 10 -9 M 7 -9 L 4 -8 L 1 -6 L -1 -3 L -2 0 L -2 3 L -1 6 L 0 7 L 2 8 L 6 9 L 9 9 M -2 3 L -1 5 L 0 6 L 2 7 L 6 8 L 8 8 L 9 9","-14 13 M -3 -12 L -1 -11 L -1 -1 M -2 -11 L -2 -5 L -1 -1 M 5 -4 L 7 -2 L -1 -1 M 6 -3 L 2 -2 L -1 -1 L -4 0 L -6 1 L -7 3 L -7 5 L -6 7 L -5 8 L -3 9 L 8 9 M -6 7 L -4 8 L 7 8 L 8 9","-14 13 M -5 -12 L -3 -11 L -3 -9 L -5 -3 L -6 0 L -8 5 L -10 9 M -4 -11 L -4 -8 L -5 -3 M -6 0 L -8 4 L -10 7 L -10 9 M -10 -5 L -8 -4 L -6 -4 L -3 -5 L -1 -6 L 1 -7 M -1 -6 L 0 -8 L 1 -7 M 4 -8 L 6 -8 L 8 -7 L 10 -5 L 8 -6 L 6 -5 M 6 -8 L 8 -6 M 4 -3 L 4 -1 L 5 2 L 6 4 L 6 6 L 5 8 L 3 9 L 0 9 L -2 8 L -3 6 L -2 4 L 0 3 L 3 3 L 5 4 L 9 8 M 4 -1 L 5 4 L 5 7 L 3 9 M 7 6 L 8 8 L 9 8","-14 13 M -9 -11 L -7 -10 L -7 -8 L -8 -5 L -9 -1 M -8 -10 L -8 -7 L -9 -1 L -9 3 L -8 7 L -7 8 L -7 6 L -6 2 L -5 -1 M -9 3 L -8 5 L -7 6 M 1 -8 L 4 -9 L 7 -9 L 9 -8 L 7 -8 L 5 -7 M 5 -9 L 7 -8 M -1 1 L -1 3 L 0 5 L 3 6 L 10 6 M -1 3 L 0 4 L 3 5 L 8 5 L 10 6","-14 13 M -8 -9 L -6 -8 L -6 -3 M -7 -8 L -6 -3 L -5 0 L -4 2 L -3 4 L -2 5 M -4 2 L -2 4 L -2 5 M 0 -11 L 2 -10 L 2 -8 L 0 -3 L -3 4 L -5 7 L -7 8 L -9 8 L -10 6 L -10 4 L -9 1 L -8 -1 L -6 -3 L -3 -5 L 1 -6 L 4 -6 L 7 -5 L 9 -3 L 10 0 L 10 3 L 9 6 L 8 7 L 6 8 L 4 8 L 2 7 L 1 6 L 1 5 L 2 4 L 4 3 L 6 3 L 8 4 L 10 7 M 1 -10 L 1 -8 L 0 -3 M -8 8 L -9 6 L -9 3 L -8 0 L -6 -3 M 4 -6 L 6 -5 L 8 -3 L 9 0 L 9 4 L 8 7 M 8 4 L 10 6 L 10 7","-14 13 M -5 -12 L -3 -11 L -3 -9 L -5 9 M -4 -11 L -4 9 L -5 9 L -6 6 L -7 5 L -9 4 M -10 -6 L -9 -4 L -7 -4 L -3 -6 L -3 -5 M -9 -5 L -6 -5 L -4 -6 L -5 -2 M -3 -5 L -5 -2 L -7 1 L -10 5 L -10 4 L -7 1 L -3 -3 L 1 -6 L 4 -7 L 6 -7 L 8 -6 L 9 -4 L 9 3 L 8 6 L 7 7 L 5 8 L 3 8 L 1 7 L 0 6 L 0 5 L 1 4 L 3 3 L 5 3 L 7 4 L 8 5 L 10 8 M 6 -7 L 7 -6 L 8 -4 L 8 4 L 7 7 M 8 5 L 10 7 L 10 8","-14 13 M -1 -10 L 0 -8 L 0 -5 L -1 -2 L -2 0 L -4 3 L -6 5 L -8 5 L -9 4 L -10 2 L -10 -1 L -9 -4 L -7 -7 L -4 -9 L -1 -10 L 2 -10 L 5 -9 L 7 -8 L 9 -6 L 10 -3 L 10 0 L 9 3 L 7 5 L 5 6 L 2 7 L -1 7 M -4 3 L -6 4 L -8 4 L -9 2 L -9 -1 L -8 -5 L -7 -7 M 5 -9 L 8 -6 L 9 -3 L 9 0 L 8 3 L 5 6","-14 13 M -9 -11 L -7 -10 L -7 -8 L -8 -5 L -9 -1 M -8 -10 L -8 -7 L -9 -1 L -9 3 L -8 7 L -7 8 L -7 6 L -6 2 L -5 -1 M -9 3 L -8 5 L -7 6 M 3 -11 L 5 -10 L 5 5 L 4 7 L 2 8 L 0 8 L -2 7 L -3 5 L -2 3 L 0 2 L 2 2 L 4 3 L 9 7 M 4 -10 L 5 -6 M 4 3 L 9 6 L 9 7 M -2 -5 L 0 -4 L 3 -4 L 7 -5 L 9 -6 M 7 -5 L 8 -7 L 9 -6","-14 13 M -9 -11 L -8 -10 L -6 -9 L -2 -9 M -8 -10 L -3 -10 L -2 -9 M -2 -9 L -5 -7 L -7 -5 L -9 -2 L -10 1 L -10 4 L -9 6 L -8 7 L -6 8 L -3 8 L 0 7 L 2 5 L 3 3 L 4 -1 L 4 -5 L 3 -9 L 4 -9 M -10 3 L -9 5 L -8 6 L -6 7 L -3 7 L 0 6 L 2 4 L 3 2 L 4 -1 M 4 -9 L 6 -6 L 7 -4 L 9 -1 L 10 1 L 8 1 L 7 2 M 3 -9 L 6 -6 M 7 -4 L 8 -1 L 8 1","-14 13 M -2 -12 L -1 -9 L 1 -8 M -1 -10 L 1 -9 L 2 -9 L 2 -8 M 2 -8 L -1 -7 L -3 -6 L -4 -5 L -4 -3 L -3 -2 L -1 -1 L 1 0 L 2 1 L 3 3 L 3 5 L 2 7 L 0 8 L -2 8 L -5 7 L -7 5 M -1 -1 L 1 1 L 2 3 L 2 5 L 1 7 L 0 8 M -9 7 L -6 4 L -3 2 L 0 1 M 4 1 L 7 2 L 9 4 L 10 6 L 7 6 M -9 7 L -9 6 L -6 4 M 4 1 L 6 2 L 8 4 L 9 6","-14 13 M -10 -2 L -8 0 L -5 -5 M -9 -1 L -4 -6 L -2 -6 L 3 -1 L 7 2 L 9 3 L 10 4 L 8 4 L 6 5 M 3 -1 L 8 4","-14 13 M -9 -11 L -7 -10 L -7 -8 L -8 -5 L -9 -1 M -8 -10 L -8 -7 L -9 -1 L -9 3 L -8 7 L -7 8 L -7 6 L -6 2 L -5 -1 M -9 3 L -8 5 L -7 6 M -1 -11 L 1 -10 L 3 -10 L 7 -11 M 3 -10 L 5 -11 L 6 -12 L 7 -11 M -2 -3 L 1 -2 L 4 -2 L 7 -3 L 9 -4 M 7 -3 L 8 -5 L 9 -4 M 3 -10 L 5 -9 L 5 5 L 4 7 L 2 8 L 0 8 L -2 7 L -3 5 L -2 3 L 0 2 L 2 2 L 4 3 L 9 7 M 4 -9 L 5 -5 M 4 3 L 9 6 L 9 7","-14 13 M 0 -12 L 2 -11 L 2 6 L 1 8 L -1 9 L -3 9 L -5 8 L -6 6 L -5 4 L -3 3 L -1 3 L 2 4 L 5 6 L 8 9 M 1 -11 L 2 -7 M 5 6 L 8 8 L 8 9 M -10 -9 L -8 -7 L 1 -7 L 8 -8 M -9 -8 L -4 -7 M 1 -7 L 5 -8 L 7 -9 L 8 -8 M -5 -2 L -3 -1 L 1 -1 L 5 -2 L 7 -3 M 5 -2 L 6 -4 L 7 -3","-14 13 M -8 -11 L -7 -9 L -5 -9 L -2 -10 L 1 -12 L 2 -11 M -7 -10 L -2 -10 M 2 -11 L -2 -5 L -5 1 L -7 4 L -8 5 L -9 5 L -10 4 L -10 2 L -9 0 L -7 -1 L -2 -1 L 2 0 L 5 1 L 10 3 M 1 -12 L -2 -5 M 2 0 L 10 2 L 10 3 M 4 -5 L 6 -4 L 6 2 L 5 5 L 3 7 L 1 8 L -2 9 M 5 -4 L 5 3 L 4 6","-14 13 M -5 -12 L -3 -11 L -3 -9 L -4 -5 L -5 -1 L -6 2 L -7 4 L -8 5 L -9 5 L -10 4 L -10 2 L -9 0 L -8 -1 L -7 -1 L -6 0 L -6 5 L -5 8 L -3 9 L 3 9 L 6 8 L 7 7 L 6 6 L 5 4 L 4 0 L 4 -4 L 5 -5 L 7 -5 L 9 -4 L 10 -2 L 10 -1 L 9 -1 L 7 0 M -4 -11 L -4 -5 M -6 5 L -5 7 L -3 8 L 3 8 L 5 7 L 6 6 M 7 -5 L 9 -3 L 9 -1 M -10 -7 L -7 -6 L -4 -6 L -1 -7 L 1 -8 M -1 -7 L 0 -9 L 1 -8","-14 13 M -8 -9 L -6 -8 L -6 -3 M -7 -8 L -6 -3 L -5 0 L -4 2 L -3 4 L -2 5 M -4 2 L -2 4 L -2 5 M 1 -11 L 3 -10 L 3 -8 L 2 -5 L 0 0 L -1 2 L -3 5 L -5 7 L -7 8 L -9 8 L -10 7 L -10 5 L -9 2 L -8 0 L -6 -2 L -3 -4 L 0 -5 L 4 -5 L 7 -4 L 9 -2 L 10 1 L 10 4 L 9 6 L 8 7 L 6 8 L 3 9 L 0 9 M 2 -10 L 2 -8 L 0 0 M -8 8 L -9 7 L -9 4 L -8 1 L -6 -2 M 4 -5 L 6 -4 L 8 -2 L 9 1 L 9 4 L 8 6 L 6 8","-14 13 M -3 -12 L -1 -11 L -1 -9 L -2 -5 M -2 -11 L -2 2 L -1 6 L 0 8 L 2 9 L 6 9 L 8 8 L 9 6 L 9 4 L 8 2 L 6 0 L 3 -2 M 5 9 L 7 8 L 8 6 L 8 3 L 7 1 M -6 -8 L -5 -7 L -2 -6 L 1 -6 M -5 -7 L 0 -7 L 1 -6 M 1 -6 L -2 -5 L -4 -4 L -6 -2 L -7 0 L -6 2 L -4 3 L 1 3","-14 13 M -2 -12 L 0 -11 L 1 -10 L 2 -8 L 1 -7 L -2 -8 L -5 -8 L -6 -7 L -6 -5 L -3 2 L -1 9 M 0 -11 L 1 -9 L 1 -7 M -3 2 L 0 8 L -1 9 M -10 -4 L -9 -2 L -7 -2 L -4 -4 L 0 -6 L 4 -7 L 7 -7 L 9 -6 L 10 -4 L 10 -2 L 9 0 L 8 1 L 5 2 L 2 2 L -1 1 M -9 -3 L -7 -3 L -4 -4 M 7 -7 L 8 -6 L 9 -4 L 9 -2 L 8 0 L 7 1 L 5 2","-14 13 M -10 -10 L -8 -9 L -8 -7 L -9 -5 L -10 -2 M -9 -9 L -9 -7 L -10 -2 L -10 1 L -9 4 L -8 5 L -6 6 L -5 6 L -5 4 L -4 1 L -3 -1 M -8 5 L -6 5 L -5 4 M 5 -6 L 7 -5 L 9 -2 L 10 1 L 10 3 L 8 2 L 5 3 M 9 -2 L 9 1 L 8 2","-14 13 M -10 -8 L -8 -7 L -8 -5 L -9 -2 M -9 -7 L -9 2 L -8 5 L -7 6 L -7 4 L -6 1 L -5 -1 L -3 -4 L 0 -7 L 3 -8 L 6 -8 L 8 -7 L 9 -6 L 10 -4 L 10 -1 L 9 1 L 7 3 L 5 4 L 2 4 L 0 3 L -2 1 L -3 -2 L -3 -5 L -2 -9 L -1 -11 L 1 -12 L 3 -12 L 4 -10 L 4 1 L 3 5 L 2 7 L -1 9 M -9 2 L -8 4 L -7 4 M 8 -7 L 9 -4 L 9 -1 L 8 2 M 4 1 L 3 4 L 2 6 L -1 9","-14 13 M -4 -13 L -3 -12 L -1 -11 L 3 -11 M -3 -12 L 2 -12 L 3 -11 L -1 -9 M -8 -5 L -8 -4 L -7 -3 L -5 -3 L 0 -5 L 3 -6 L 4 -5 M -8 -4 L -5 -4 L 0 -5 M 4 -5 L 0 -2 L -6 4 L -10 8 M 3 -6 L 0 -2 M -10 8 L -10 7 L -6 4 L -4 3 L 0 3 L 1 4 L 2 8 L 3 9 L 10 9 M 5 9 L 8 8 L 9 8 L 10 9","-14 13 M -2 -12 L 1 -11 L 1 -9 L 0 -4 M 0 -11 L 0 6 L -1 8 L -3 9 L -6 9 L -8 8 L -9 7 L -9 5 L -8 4 L -6 3 L -3 3 L 0 4 L 4 6 L 9 9 M 0 4 L 5 6 L 9 8 L 9 9 M 0 -4 L 3 -4 L 7 -5 M 3 -4 L 5 -5 L 6 -6 L 7 -5","-14 13 M -3 -12 L -1 -12 L 1 -11 L 2 -10 L 0 -10 L -2 -9 M -1 -12 L 0 -11 L 0 -10 M -6 -6 L -7 -4 L -8 0 L -8 2 L -7 3 L -3 0 L -1 -1 L 2 -2 L 5 -2 L 7 -1 L 8 1 L 8 3 L 7 5 L 5 7 L 3 8 L -1 9 L -3 9 M -8 0 L -7 2 L -6 2 M 5 -2 L 6 -1 L 7 1 L 7 3 L 6 5 L 4 7 L 2 8 L -1 9","-14 13 M -6 -12 L -4 -11 L -4 -9 L -6 -5 M -5 -11 L -5 -9 L -6 -5 L -6 -2 L -5 1 L -4 2 L -4 0 L -3 -3 L -1 -6 L 1 -8 L 3 -9 L 5 -9 L 6 -8 L 7 -5 L 7 0 L 6 4 L 4 7 L 1 9 L -3 10 M -6 -2 L -5 0 L -4 0 M 4 -9 L 5 -8 L 6 -5 L 6 0 L 5 4 L 3 7 L 1 9","-14 13 M -5 -11 L -4 -9 L -2 -9 L 3 -11 M -4 -10 L -2 -10 L 3 -11 L 4 -10 M 4 -10 L 0 -7 L -4 -2 L -7 3 M 3 -11 L 0 -7 M -4 -2 L -7 1 L -7 3 M -7 3 L -5 1 L -2 -1 L 1 -2 L 4 -2 L 6 -1 L 7 0 L 8 2 L 8 5 L 7 7 L 6 8 L 4 9 L 1 9 L -1 8 L -2 7 L -2 6 L -1 5 L 1 5 L 3 6 L 5 8 M 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 4 9","-14 13 M -5 -12 L -3 -11 L -3 -9 L -5 9 M -4 -11 L -4 9 L -5 9 L -6 6 L -7 5 L -9 4 M -10 -6 L -9 -4 L -7 -4 L -3 -6 L -3 -5 M -9 -5 L -6 -5 L -3 -6 L -5 -2 M -3 -5 L -5 -2 L -7 1 L -10 5 L -10 4 L -7 1 L -3 -3 L 1 -6 L 4 -7 L 5 -7 L 7 -6 L 8 -4 L 7 6 L 7 8 L 8 9 M 5 -7 L 6 -6 L 7 -4 L 6 6 L 6 8 L 7 9 L 8 9 L 9 8 L 10 6","-14 13 M -5 -11 L -4 -9 L -2 -9 L 3 -11 M -4 -10 L -2 -10 L 3 -11 L 4 -10 M 4 -10 L 0 -7 L -4 -2 L -7 3 M 3 -11 L 0 -7 M -4 -2 L -7 1 L -7 3 M -7 3 L -5 1 L -2 -1 L 1 -2 L 4 -2 L 6 -1 L 7 0 L 8 2 L 8 5 L 7 7 L 5 9 L 2 10 L 0 10 M 4 -2 L 6 0 L 7 2 L 7 5 L 6 8","-14 13 M -5 -12 L -3 -11 L -3 -9 L -5 9 M -4 -11 L -4 9 L -5 9 L -6 6 L -7 5 L -9 4 M -10 -6 L -9 -4 L -7 -4 L -3 -6 L -3 -5 M -9 -5 L -6 -5 L -3 -6 L -5 -2 M -3 -5 L -5 -2 L -7 1 L -10 5 L -10 4 L -7 1 L -4 -2 L -1 -4 L 2 -5 L 5 -5 L 7 -4 L 8 -3 L 9 -1 L 9 2 L 8 5 L 6 7 L 4 8 L 1 9 M 5 -5 L 7 -3 L 8 -1 L 8 2 L 7 5 L 4 8","-14 13 M -5 -11 L -4 -9 L -2 -9 L 2 -11 M -4 -10 L -2 -10 L 2 -11 L 3 -10 M 3 -10 L -1 -4 L -5 4 L -6 6 L -7 7 L -9 7 L -10 5 L -10 3 L -9 1 L -7 -1 L -4 -3 L 0 -4 L 4 -4 L 7 -3 L 9 -1 L 10 1 L 10 4 L 9 6 L 7 8 L 5 9 L 2 9 L 0 8 L -1 7 L -1 6 L 0 5 L 2 5 L 4 6 L 6 8 M 2 -11 L -1 -4 M -8 7 L -9 5 L -9 3 L -8 0 M 8 -2 L 9 1 L 9 4 L 8 7","-14 13 M -4 -13 L -3 -12 L -1 -11 L 3 -11 M -3 -12 L 2 -12 L 3 -11 L -1 -9 M -7 -5 L -7 -4 L -6 -3 L -5 -3 L -2 -5 L 0 -6 M -7 -4 L -6 -4 L -3 -5 L 0 -6 L 2 -6 L 5 -5 L 6 -3 L 6 0 L 5 3 L 3 6 L 0 8 L -4 10 M 2 -6 L 4 -5 L 5 -3 L 5 0 L 4 3 L 3 5 L 1 7 L -2 9","-14 13 M -6 -11 L -5 -9 L -3 -9 L -1 -10 L 2 -12 M -5 -10 L -3 -10 L 0 -11 L 2 -12 L 3 -11 M 3 -11 L -1 -8 L -5 -4 L -8 0 M 2 -12 L -1 -8 M -8 0 L -8 -2 L -5 -4 L -3 -5 L 0 -6 L 3 -6 L 5 -5 L 6 -3 L 6 -1 L 5 1 L 3 2 L -2 2 L -3 1 L -3 -1 L -2 -2 L 0 -2 L 1 -1 L 1 1 L 0 2 L -4 3 L -7 5 L -10 8 L -10 9 L -9 9 L -7 5 M -8 7 L -6 6 L -4 6 L -2 8 L -1 8 L 1 6 L 4 5 L 7 5 L 9 6 L 10 7 L 10 9 L 9 8 L 7 8 M -4 6 L -2 7 L -1 7 L 1 6 M 7 5 L 9 7 L 9 8","-14 13 M -2 -12 L 0 -11 L 0 -10 L -2 -6 L -4 -3 L -7 0 L -10 3 M -1 -11 L -1 -10 L -2 -6 M -7 0 L -10 2 L -10 3 M -5 -2 L -3 -3 L -1 -3 L 1 -2 L 2 0 L 2 4 M -1 -3 L 0 -2 L 1 0 L 1 5 L 2 4 M -9 -8 L -6 -7 L -3 -7 L 1 -8 L 5 -9 M 1 -8 L 4 -10 L 5 -9 M 9 -3 L 10 -1 L 2 0 L -1 1 L -3 2 L -4 4 L -4 6 L -3 8 L -1 9 L 7 9 M 9 -2 L 2 0 M 2 9 L 6 8 L 7 9","-14 13 M -1 -12 L 1 -10 L -2 -5 L -6 2 L -10 9 M 0 -11 L -2 -5 M -10 9 L -10 7 L -6 2 L -4 0 L -2 -1 L 0 -1 L 2 0 L 2 5 L 3 7 L 4 8 M 0 -1 L 1 0 L 1 5 L 2 7 L 4 8 L 6 8 L 8 7 L 9 5 L 10 2","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -4 -12 L -2 -11 L -2 -9 L -3 -6 L -5 -1 L -10 9 M -3 -11 L -3 -9 L -5 -3 L -7 2 L -10 9 M -10 -5 L -10 -4 L -9 -3 L -8 -3 L -5 -5 L -3 -6 L 0 -6 L 2 -5 L 3 -3 L 3 0 L 2 4 L 0 8 L -1 9 L -2 9 L -2 8 L -3 7 L -5 6 M -10 -4 L -8 -4 L -5 -5 M 0 -6 L 2 -4 L 2 0 L 1 4 L 0 6 L -2 8 M 5 -5 L 7 -4 L 9 -2 L 10 0 L 10 2 L 9 1 L 7 2 M 8 -3 L 9 -1 L 9 1 M 5 -10 L 7 -8 M 7 -12 L 9 -10","-14 13 M -4 -12 L -1 -11 L 0 -7 L 1 -4 L 3 0 L 6 4 L 5 5 M -2 -11 L 0 -7 M 3 0 L 5 5 M -6 -7 L -4 -6 L -1 -6 L 2 -7 M -9 -3 L -8 -2 L -5 -1 L 0 -1 L 5 -2 L 8 -3 M 5 -2 L 7 -4 L 8 -3 M 5 5 L 3 4 L 0 3 L -4 3 L -6 4 L -7 5 L -7 7 L -6 8 L -4 9 L -1 10 L 5 10 M -4 9 L 4 9 L 5 10 M 5 -10 L 7 -8 M 7 -12 L 9 -10","-14 13 M 2 -12 L 4 -11 L 4 -10 L -4 -2 M 3 -11 L 2 -9 L -4 -2 L -4 -1 L 1 4 L 3 7 L 4 9 M -4 -1 L 4 6 L 5 8 L 4 9 M 7 -10 L 9 -8 M 9 -12 L 11 -10","-14 13 M -9 -11 L -7 -10 L -7 -8 L -8 -5 L -9 -1 M -8 -10 L -8 -7 L -9 -1 L -9 3 L -8 7 L -7 8 L -7 6 L -6 2 L -5 -1 L -4 -3 L -3 -4 L -1 -5 L 8 -5 L 10 -6 M -9 3 L -8 5 L -7 6 M 4 -5 L 8 -6 L 9 -7 L 10 -6 M 4 -12 L 6 -11 L 6 3 L 5 6 L 3 8 L 0 10 M 5 -11 L 6 -8 M 6 0 L 5 4 L 3 7 L 0 10 M 9 -11 L 11 -9 M 11 -13 L 13 -11","-14 13 M -5 -10 L -3 -9 L 0 -8 L 2 -8 L 5 -9 M -3 -9 L 2 -9 L 4 -10 L 5 -9 L -1 -6 M -7 1 L -7 3 L -6 5 L -4 6 L 0 7 L 7 7 M -4 6 L 6 6 L 7 7 M 7 -11 L 9 -9 M 9 -13 L 11 -11","-14 13 M -8 -7 L -7 -6 L -4 -5 L 0 -5 L 4 -6 L 6 -7 L 7 -8 M 4 -6 L 6 -8 L 7 -8 M -2 -12 L -1 -9 L 0 -7 L 3 -3 L 5 0 L 6 2 M -2 -12 L -1 -12 L -1 -10 L 0 -7 M 3 -3 L 6 0 L 7 2 L 7 3 M 7 3 L 6 2 L 4 1 L 0 0 L -4 0 L -7 1 L -8 3 L -8 5 L -7 7 L -5 8 L -1 9 L 3 9 M -8 5 L -7 6 L -5 7 L -1 8 L 4 8 L 3 9 M 8 -11 L 10 -9 M 10 -13 L 12 -11","-14 13 M -6 -12 L -4 -11 L -5 1 L -5 6 L -4 8 M -5 -11 L -6 1 L -6 5 L -5 7 L -4 8 L -2 9 L 1 9 L 4 8 L 7 6 L 9 4 M 1 -10 L 3 -8 M 3 -12 L 5 -10","-14 13 M 0 -12 L 2 -11 L 2 1 L 1 3 L -1 4 L -3 3 L -4 1 L -4 0 L -3 -2 L -1 -3 L 1 -2 L 2 0 L 2 4 L 1 8 L -1 10 M 1 -11 L 2 -6 M 2 4 L 1 7 L -1 10 M -10 -8 L -8 -6 L -5 -6 L 4 -7 L 8 -8 L 10 -7 M -9 -7 L -5 -6 M 4 -7 L 10 -7 M 6 -12 L 8 -10 M 9 -13 L 11 -11","-14 13 M -6 -8 L -4 -7 L -4 4 L -3 6 L -2 7 L 0 8 L 8 8 M -5 -7 L -4 -4 M 3 8 L 6 7 L 7 7 L 8 8 M 3 -11 L 5 -10 L 5 2 L 4 4 L 3 3 L 0 1 M 4 -10 L 5 -7 M 5 -1 L 4 2 L 3 3 M -10 -4 L -8 -2 L -6 -2 L -2 -3 L 3 -4 L 7 -5 L 9 -5 L 10 -4 M -9 -3 L -2 -3 M 3 -4 L 10 -4 M 8 -10 L 10 -8 M 10 -12 L 12 -10","-14 13 M -4 -11 L -2 -9 L 4 -11 M -3 -10 L -1 -10 L 4 -11 L 5 -10 M 5 -10 L 2 -7 L -4 -3 L -8 -1 M 4 -11 L 3 -9 L 1 -7 L -4 -3 M -9 -2 L -7 0 L -3 -2 M -8 -1 L -3 -2 L 3 -3 L 8 -4 L 9 -3 M 3 -3 L 9 -3 M 3 -3 L 1 -2 L -1 0 L -2 2 L -2 4 L -1 6 L 0 7 L 3 8 L 7 8 M -1 6 L 2 7 L 6 7 L 7 8 M 8 -10 L 10 -8 M 10 -12 L 12 -10","-14 13 M -4 -12 L -2 -11 L -2 -9 L -4 -3 L -5 0 L -7 5 L -9 9 M -3 -11 L -3 -8 L -4 -3 M -5 0 L -7 4 L -9 7 L -9 9 M -10 -5 L -8 -4 L -5 -4 L -2 -5 L 0 -6 L 2 -7 M 0 -6 L 1 -8 L 2 -7 M 3 -4 L 6 -4 L 9 -3 L 7 -3 L 5 -2 M 6 -4 L 7 -3 M 0 4 L 1 6 L 2 7 L 4 8 L 9 8 M 1 6 L 3 7 L 10 7 L 9 8 M 6 -10 L 8 -8 M 8 -12 L 10 -10","-14 13 M -5 -12 L -3 -11 L -3 -9 L -5 -4 L -6 0 L -6 2 L -5 3 M -4 -11 L -4 -7 M -5 -4 L -5 3 M -10 -8 L -7 -7 L -3 -7 L 1 -8 L 3 -9 M 1 -8 L 2 -10 L 3 -9 M -5 3 L -3 1 L 0 -1 L 3 -2 L 6 -2 L 8 -1 L 9 1 L 9 4 L 8 6 L 5 8 L 1 9 L -3 9 M 6 -2 L 7 -1 L 8 1 L 8 4 L 7 6 L 5 8 M 6 -9 L 8 -7 M 8 -11 L 10 -9","-14 13 M -10 -6 L -8 -4 L -3 -6 L 1 -7 L 5 -7 L 8 -6 L 9 -5 L 10 -3 L 10 0 L 9 2 L 8 3 L 6 4 L 3 5 L -2 6 M -9 -5 L -3 -6 M 5 -7 L 7 -6 L 8 -5 L 9 -3 L 9 0 L 8 2 L 6 4 M 8 -10 L 10 -8 M 10 -12 L 12 -10","-14 13 M -10 -9 L -8 -7 L -6 -7 L -2 -8 L 3 -9 L 7 -10 L 9 -10 L 10 -9 M -9 -8 L -2 -8 M 3 -9 L 10 -9 M 7 -9 L 4 -8 L 1 -6 L -1 -3 L -2 0 L -2 3 L -1 6 L 0 7 L 2 8 L 6 9 L 9 9 M -2 3 L -1 5 L 0 6 L 2 7 L 6 8 L 8 8 L 9 9 M 8 -5 L 10 -3 M 10 -7 L 12 -5","-14 13 M -3 -12 L -1 -11 L -1 -1 M -2 -11 L -2 -5 L -1 -1 M 5 -4 L 7 -2 L -1 -1 M 6 -3 L 2 -2 L -1 -1 L -4 0 L -6 1 L -7 3 L -7 5 L -6 7 L -5 8 L -3 9 L 8 9 M -6 7 L -4 8 L 7 8 L 8 9 M 6 -9 L 8 -7 M 8 -11 L 10 -9","-14 13 M -9 -11 L -7 -10 L -7 -8 L -8 -5 L -9 -1 M -8 -10 L -8 -7 L -9 -1 L -9 3 L -8 7 L -7 8 L -7 6 L -6 2 L -5 -1 M -9 3 L -8 5 L -7 6 M 3 -11 L 5 -10 L 5 5 L 4 7 L 2 8 L 0 8 L -2 7 L -3 5 L -2 3 L 0 2 L 2 2 L 4 3 L 9 7 M 4 -10 L 5 -6 M 4 3 L 9 6 L 9 7 M -2 -5 L 0 -4 L 3 -4 L 7 -5 L 9 -6 M 7 -5 L 8 -7 L 9 -6 M 8 -11 L 10 -9 M 10 -13 L 12 -11","-14 13 M -9 -11 L -8 -10 L -6 -9 L -2 -9 M -8 -10 L -3 -10 L -2 -9 M -2 -9 L -5 -7 L -7 -5 L -9 -2 L -10 1 L -10 4 L -9 6 L -8 7 L -6 8 L -3 8 L 0 7 L 2 5 L 3 3 L 4 -1 L 4 -5 L 3 -9 L 4 -9 M -10 3 L -9 5 L -8 6 L -6 7 L -3 7 L 0 6 L 2 4 L 3 2 L 4 -1 M 4 -9 L 6 -6 L 7 -4 L 9 -1 L 10 1 L 8 1 L 7 2 M 3 -9 L 6 -6 M 7 -4 L 8 -1 L 8 1 M 7 -10 L 9 -8 M 9 -12 L 11 -10","-14 13 M -2 -12 L -1 -9 L 1 -8 M -1 -10 L 1 -9 L 2 -9 L 2 -8 M 2 -8 L -1 -7 L -3 -6 L -4 -5 L -4 -3 L -3 -2 L -1 -1 L 1 0 L 2 1 L 3 3 L 3 5 L 2 7 L 0 8 L -2 8 L -5 7 L -7 5 M -1 -1 L 1 1 L 2 3 L 2 5 L 1 7 L 0 8 M -9 7 L -6 4 L -3 2 L 0 1 M 4 1 L 7 2 L 9 4 L 10 6 L 7 6 M -9 7 L -9 6 L -6 4 M 4 1 L 6 2 L 8 4 L 9 6 M 5 -9 L 7 -7 M 7 -11 L 9 -9","-14 13 M -10 -2 L -8 0 L -5 -5 M -9 -1 L -4 -6 L -2 -6 L 3 -1 L 7 2 L 9 3 L 10 4 L 8 4 L 6 5 M 3 -1 L 8 4 M 3 -8 L 5 -6 M 5 -10 L 7 -8","-14 13 M -9 -11 L -7 -10 L -7 -8 L -8 -5 L -9 -1 M -8 -10 L -8 -7 L -9 -1 L -9 3 L -8 7 L -7 8 L -7 6 L -6 2 L -5 -1 M -9 3 L -8 5 L -7 6 M -1 -11 L 1 -10 L 3 -10 L 7 -11 M 3 -10 L 5 -11 L 6 -12 L 7 -11 M -2 -3 L 1 -2 L 4 -2 L 7 -3 L 9 -4 M 7 -3 L 8 -5 L 9 -4 M 3 -10 L 5 -9 L 5 5 L 4 7 L 2 8 L 0 8 L -2 7 L -3 5 L -2 3 L 0 2 L 2 2 L 4 3 L 9 7 M 4 -9 L 5 -5 M 4 3 L 9 6 L 9 7 M 9 -9 L 11 -7 M 11 -11 L 13 -9","-14 13 M -9 -11 L -7 -10 L -7 -8 L -8 -5 L -9 -1 M -8 -10 L -8 -7 L -9 -1 L -9 3 L -8 7 L -7 8 L -7 6 L -6 2 L -5 -1 M -9 3 L -8 5 L -7 6 M 3 -11 L 5 -10 L 5 5 L 4 7 L 2 8 L 0 8 L -2 7 L -3 5 L -2 3 L 0 2 L 2 2 L 4 3 L 9 7 M 4 -10 L 5 -6 M 4 3 L 9 6 L 9 7 M -2 -5 L 0 -4 L 3 -4 L 7 -5 L 9 -6 M 7 -5 L 8 -7 L 9 -6 M 9 -13 L 8 -12 L 8 -10 L 9 -9 L 11 -9 L 12 -10 L 12 -12 L 11 -13 L 9 -13","-14 13 M -9 -11 L -8 -10 L -6 -9 L -2 -9 M -8 -10 L -3 -10 L -2 -9 M -2 -9 L -5 -7 L -7 -5 L -9 -2 L -10 1 L -10 4 L -9 6 L -8 7 L -6 8 L -3 8 L 0 7 L 2 5 L 3 3 L 4 -1 L 4 -5 L 3 -9 L 4 -9 M -10 3 L -9 5 L -8 6 L -6 7 L -3 7 L 0 6 L 2 4 L 3 2 L 4 -1 M 4 -9 L 6 -6 L 7 -4 L 9 -1 L 10 1 L 8 1 L 7 2 M 3 -9 L 6 -6 M 7 -4 L 8 -1 L 8 1 M 8 -12 L 7 -11 L 7 -9 L 8 -8 L 10 -8 L 11 -9 L 11 -11 L 10 -12 L 8 -12","-14 13 M -2 -12 L -1 -9 L 1 -8 M -1 -10 L 1 -9 L 2 -9 L 2 -8 M 2 -8 L -1 -7 L -3 -6 L -4 -5 L -4 -3 L -3 -2 L -1 -1 L 1 0 L 2 1 L 3 3 L 3 5 L 2 7 L 0 8 L -2 8 L -5 7 L -7 5 M -1 -1 L 1 1 L 2 3 L 2 5 L 1 7 L 0 8 M -9 7 L -6 4 L -3 2 L 0 1 M 4 1 L 7 2 L 9 4 L 10 6 L 7 6 M -9 7 L -9 6 L -6 4 M 4 1 L 6 2 L 8 4 L 9 6 M 6 -11 L 5 -10 L 5 -8 L 6 -7 L 8 -7 L 9 -8 L 9 -10 L 8 -11 L 6 -11","-14 13 M -10 -2 L -8 0 L -5 -5 M -9 -1 L -4 -6 L -2 -6 L 3 -1 L 7 2 L 9 3 L 10 4 L 8 4 L 6 5 M 3 -1 L 8 4 M 4 -10 L 3 -9 L 3 -7 L 4 -6 L 6 -6 L 7 -7 L 7 -9 L 6 -10 L 4 -10","-14 13 M -9 -11 L -7 -10 L -7 -8 L -8 -5 L -9 -1 M -8 -10 L -8 -7 L -9 -1 L -9 3 L -8 7 L -7 8 L -7 6 L -6 2 L -5 -1 M -9 3 L -8 5 L -7 6 M -1 -11 L 1 -10 L 3 -10 L 7 -11 M 3 -10 L 5 -11 L 6 -12 L 7 -11 M -2 -3 L 1 -2 L 4 -2 L 7 -3 L 9 -4 M 7 -3 L 8 -5 L 9 -4 M 3 -10 L 5 -9 L 5 5 L 4 7 L 2 8 L 0 8 L -2 7 L -3 5 L -2 3 L 0 2 L 2 2 L 4 3 L 9 7 M 4 -9 L 5 -5 M 4 3 L 9 6 L 9 7 M 10 -11 L 9 -10 L 9 -8 L 10 -7 L 12 -7 L 13 -8 L 13 -10 L 12 -11 L 10 -11","-14 13 M -10 -11 L -8 -9 L -3 -10 L 3 -11 L 8 -12 L 10 -10 M -9 -10 L -3 -10 M 3 -11 L 9 -11 M 10 -10 L 8 -8 L 4 -5 L 2 -4 M 9 -11 L 7 -8 L 5 -6 L 2 -4 M 0 -5 L 2 -4 L 2 -1 L 1 3 L -1 6 L -4 9 M 0 -5 L 1 -4 L 1 -1 L 0 3 L -2 7","-14 13 M 4 -12 L 6 -10 L 3 -6 L 0 -3 L -4 0 L -7 2 M 5 -11 L 4 -9 L 1 -5 L -3 -1 L -7 2 M 1 -4 L 3 -3 L 3 10 M 1 -4 L 2 -3 L 2 9 L 3 10","-14 13 M -2 -12 L 1 -11 L 1 -9 L 0 -7 M -2 -12 L 0 -11 L 0 -7 M -8 -9 L -7 -7 L -7 -2 L -6 -1 M -6 -7 L -6 -1 M -6 -7 L 7 -7 M -8 -9 L -7 -8 L -3 -7 M 3 -7 L 6 -8 L 8 -6 M 8 -6 L 5 0 L 3 3 L 0 6 L -3 8 L -5 9 M 7 -7 L 6 -4 L 4 0 L 1 4 L -2 7 L -5 9","-14 13 M -1 -7 L 1 -6 L 1 5 M 0 -6 L 0 5 M -8 -8 L -6 -6 L 6 -8 L 8 -7 M -7 -7 L 8 -7 M -10 4 L -8 6 L 8 4 L 10 5 M -9 5 L 10 5","-14 13 M 0 -12 L 3 -11 L 3 7 L 2 9 L 1 7 L -2 5 M 2 -11 L 2 6 L 1 7 M -10 -6 L -8 -4 L -3 -5 L 3 -6 L 8 -7 L 10 -6 M -9 -5 L -3 -5 M 3 -6 L 10 -6 M 1 -5 L -2 -1 L -6 3 L -10 6 M 2 -5 L 0 -2 L -3 1 L -7 4 L -10 6","-14 13 M -1 -12 L 1 -10 L 0 -7 L -2 -2 L -4 2 L -6 5 L -9 9 M 0 -11 L -1 -8 L -3 -2 L -5 3 L -9 9 M -9 -6 L -7 -4 L -3 -5 L 2 -6 L 6 -7 L 8 -5 M -8 -5 L -3 -5 M 2 -6 L 7 -6 M 8 -5 L 7 1 L 6 5 L 5 7 L 3 9 L 2 8 L 0 7 M 7 -6 L 6 1 L 5 5 L 4 7 L 2 8","-14 13 M -3 -12 L 0 -11 L 2 9 M -1 -11 L 1 10 L 2 9 M -8 -6 L -6 -4 L -2 -5 L 2 -6 L 6 -7 L 8 -6 M -7 -5 L -2 -5 M 2 -6 L 8 -6 M -10 0 L -8 2 L -3 1 L 3 0 L 8 -1 L 10 0 M -9 1 L -3 1 M 3 0 L 10 0","-14 13 M -2 -12 L 0 -10 L -2 -6 L -4 -3 L -6 -1 L -8 1 M -1 -11 L -2 -8 L -4 -4 L -6 -1 M -1 -8 L 1 -7 L 6 -7 M 3 -7 L 5 -8 L 7 -6 M 7 -6 L 4 0 L 1 4 L -2 7 L -5 9 L -7 10 M 6 -7 L 5 -4 L 3 0 L 0 4 L -3 7 L -7 10","-14 13 M -4 -12 L -2 -10 L -4 -6 L -6 -3 L -8 -1 L -10 1 M -3 -11 L -4 -8 L -6 -4 L -8 -1 M -6 -3 L 2 -4 L 7 -5 L 10 -4 M 2 -4 L 10 -4 M 0 -3 L 2 -1 L 0 3 L -2 6 L -4 8 L -6 10 M 1 -2 L 0 1 L -2 5 L -4 8","-14 13 M -8 -8 L -6 -6 L 6 -8 L 8 -6 M -7 -7 L 7 -7 M 8 -6 L 7 -3 L 6 4 M 7 -7 L 6 -2 L 6 4 M -8 4 L -6 6 L 6 4 L 7 5 M -7 5 L 7 5","-14 13 M -6 -9 L -4 -8 L -4 -3 L -5 1 M -5 -8 L -5 1 M 2 -12 L 5 -11 L 5 -6 L 4 -1 L 3 2 L 2 4 L 0 7 L -2 9 M 4 -11 L 4 -6 L 3 -1 L 2 3 L 0 7 M -10 -5 L -8 -3 L -3 -4 L 3 -5 L 8 -6 L 10 -5 M -9 -4 L -3 -4 M 3 -5 L 10 -5","-14 13 M -5 -11 L -3 -10 L -2 -9 L -2 -8 L -3 -8 L -4 -10 L -5 -11 M -10 -4 L -8 -3 L -7 -2 L -7 -1 L -8 -1 L -9 -3 L -10 -4 M -9 6 L -7 8 L -3 6 L 1 3 L 5 -1 L 9 -6 M -8 7 L -3 5 L 1 2 L 9 -6","-14 13 M -8 -9 L -6 -7 L 5 -9 L 7 -7 M -7 -8 L 6 -8 M 7 -7 L 5 -4 L 2 -1 L -1 1 L -3 2 L -8 4 M 6 -8 L 5 -6 L 3 -3 L 1 -1 L -2 1 L -8 4 M 3 1 L 6 3 L 8 5 L 8 6 L 7 6 L 6 4 L 3 1","-14 13 M -3 -11 L 0 -10 L 0 -8 L -1 1 M -1 -10 L -1 4 L 0 6 L 2 7 L 9 7 M 4 7 L 8 6 L 9 7 M -10 -4 L -8 -2 L -3 -3 L 3 -4 L 8 -5 L 10 -3 M -9 -3 L -3 -3 M 3 -4 L 9 -4 M 10 -3 L 7 -1 L 4 2 M 9 -4 L 4 2","-14 13 M -9 -9 L -7 -8 L -6 -7 L -6 -6 L -7 -6 L -8 -8 L -9 -9 M 6 -10 L 8 -8 L 5 -2 L 2 2 L -1 5 L -4 7 L -6 8 M 7 -9 L 6 -6 L 4 -2 L 1 2 L -2 5 L -6 8","-14 13 M -2 -12 L 0 -10 L -2 -6 L -4 -3 L -6 -1 L -8 1 M -1 -11 L -2 -8 L -4 -4 L -6 -1 M -1 -8 L 1 -7 L 6 -7 M 3 -7 L 5 -8 L 7 -6 M 7 -6 L 4 0 L 1 4 L -2 7 L -5 9 L -7 10 M 6 -7 L 5 -4 L 3 0 L 0 4 L -3 7 L -7 10 M -4 -2 L -1 -1 L 1 0 L 4 2 L 5 3 L 5 4 L 4 4 L 3 2 L 1 0","-14 13 M -6 -8 L -3 -8 L 2 -9 L 6 -11 M -3 -8 L 0 -9 L 2 -10 L 5 -12 L 6 -11 M -2 -8 L 1 -7 L 1 -1 L 0 3 L -2 6 L -5 9 M 0 -7 L 0 -1 L -1 3 L -3 7 M -10 -4 L -8 -2 L -3 -3 L 3 -4 L 8 -5 L 10 -4 M -9 -3 L -3 -3 M 3 -4 L 10 -4","-14 13 M -9 -9 L -7 -8 L -6 -7 L -6 -6 L -7 -6 L -8 -8 L -9 -9 M -3 -10 L -1 -9 L 0 -8 L 0 -7 L -1 -7 L -2 -9 L -3 -10 M 6 -10 L 8 -8 L 5 -2 L 2 2 L -1 5 L -4 7 L -6 8 M 7 -9 L 6 -6 L 4 -2 L 1 2 L -2 5 L -6 8","-14 13 M -6 -12 L -4 -10 L 5 -12 L 6 -11 M -5 -11 L 6 -11 M -10 -4 L -8 -2 L -3 -3 L 3 -4 L 8 -5 L 10 -4 M -9 -3 L -3 -3 M 3 -4 L 10 -4 M 1 -3 L 1 -1 L 0 3 L -2 6 L -5 9 M 0 -3 L 0 -1 L -1 3 L -3 7","-14 13 M -5 -12 L -2 -11 L -2 10 M -3 -11 L -3 9 L -2 10 M -2 -3 L 0 -3 L 3 -2 L 4 -1 L 4 0 L 3 0 L 2 -2 L 0 -3","-14 13 M -1 -12 L 2 -11 L 2 -6 L 1 -1 L 0 2 L -1 4 L -3 7 L -5 9 M 1 -11 L 1 -6 L 0 -1 L -1 3 L -3 7 M -10 -4 L -8 -2 L -3 -3 L 3 -4 L 8 -5 L 10 -4 M -9 -3 L -3 -3 M 3 -4 L 10 -4","-14 13 M -6 -8 L -4 -6 L 5 -8 L 6 -7 M -5 -7 L 6 -7 M -10 4 L -8 6 L 8 4 L 10 5 M -9 5 L 10 5","-14 13 M -8 -9 L -6 -7 L 5 -9 L 7 -7 M -7 -8 L 6 -8 M 7 -7 L 5 -4 L 2 -1 L -1 1 L -3 2 L -8 4 M 6 -8 L 5 -6 L 3 -3 L 1 -1 L -2 1 L -8 4 M -5 -3 L -2 -2 L 2 0 L 5 2 L 7 4 L 7 5 L 6 5 L 4 2 L 2 0","-14 13 M -2 -12 L 0 -11 L 1 -10 L 1 -9 L 0 -9 L -1 -11 L -2 -12 M -8 -6 L -6 -4 L 4 -6 L 6 -4 M -7 -5 L 5 -5 M 6 -4 L 2 0 L -1 2 L -3 3 L -8 5 M 5 -5 L 3 -2 L 1 0 L -2 2 L -8 5 M 0 1 L 1 2 L 1 10 M 0 1 L 0 9 L 1 10 M 6 3 L 8 4 L 9 5 L 9 6 L 8 6 L 7 4 L 6 3","-14 13 M 5 -10 L 7 -8 L 4 -2 L 1 2 L -2 5 L -5 7 L -7 8 M 6 -9 L 5 -6 L 2 -1 L -1 3 L -4 6 L -7 8","-14 13 M -6 -6 L -4 -4 L -5 -1 L -6 1 L -8 3 L -10 4 M -5 -5 L -6 -1 L -8 3 M 4 -6 L 6 -4 L 8 -1 L 10 3 L 10 4 L 9 4 L 8 0 L 6 -4","-14 13 M -9 -11 L -6 -10 L -6 -8 L -7 1 M -7 -10 L -7 4 L -6 6 L -4 7 L 7 7 M -1 7 L 3 6 L 5 6 L 7 7 M -7 0 L -3 -1 L 0 -2 L 6 -4 M 0 -2 L 4 -4 L 6 -4","-14 13 M -8 -11 L -6 -9 L 7 -9 M -7 -10 L -3 -9 M 3 -9 L 6 -10 L 8 -8 M 8 -8 L 5 -2 L 3 1 L 0 4 L -3 6 L -5 7 M 7 -9 L 6 -6 L 4 -2 L 1 2 L -2 5 L -5 7","-14 13 M -11 -1 L -9 1 L -2 -6 L -1 -6 L 9 4 M -10 0 L -8 -1 L -4 -4 M 3 -2 L 8 2 L 10 3 L 9 4","-14 13 M -2 -12 L 1 -11 L 1 7 L 0 9 L -1 7 L -3 6 M 0 -11 L 0 6 L -1 7 M -10 -6 L -8 -4 L -3 -5 L 3 -6 L 8 -7 L 10 -6 M -9 -5 L -3 -5 M 3 -6 L 10 -6 M -6 1 L -8 4 L -9 5 L -10 5 L -10 4 L -8 3 L -6 1 M 6 1 L 9 3 L 10 4 L 10 5 L 9 5 L 8 3 L 6 1","-14 13 M -10 -6 L -8 -4 L -3 -5 L 3 -6 L 8 -7 L 10 -5 M -9 -5 L -3 -5 M 3 -6 L 9 -6 M 10 -5 L 8 -3 L 4 0 L 2 1 M 9 -6 L 7 -3 L 5 -1 L 2 1 M -1 0 L 2 2 L 4 4 L 4 5 L 3 5 L 2 3 L -1 0","-14 13 M -2 -12 L 1 -11 L 3 -10 L 4 -9 L 4 -8 L 3 -8 L 1 -10 L -2 -12 M -5 -5 L -2 -4 L 0 -3 L 1 -2 L 1 -1 L 0 -1 L -2 -3 L -5 -5 M -4 4 L 1 6 L 3 7 L 4 8 L 4 9 L 3 9 L 1 7 L -2 5 L -4 4","-14 13 M 0 -9 L 2 -7 L -5 5 M 1 -8 L -5 5 M -10 5 L -8 7 L 7 4 M -9 6 L 7 4 M 4 1 L 6 3 L 8 6 L 9 6 L 9 5 L 7 3 L 4 1","-14 13 M 5 -10 L 7 -8 L 4 -2 L 1 2 L -2 5 L -5 7 L -7 8 M 6 -9 L 5 -6 L 3 -2 L 0 2 L -3 5 L -7 8 M -3 -4 L 1 -2 L 4 0 L 6 2 L 6 3 L 5 3 L 4 1 L 2 -1 L -1 -3","-14 13 M -6 -9 L -4 -7 L 5 -9 L 6 -8 M -5 -8 L 6 -8 M -1 -7 L -1 4 L 0 6 L 2 7 L 9 7 M 0 -7 L 0 -5 L -1 1 M 4 7 L 8 6 L 9 7 M -10 -1 L -8 1 L -3 0 L 3 -1 L 8 -2 L 10 -1 M -9 0 L -3 0 M 3 -1 L 10 -1","-14 13 M -3 -12 L 0 -11 L 2 9 M -1 -11 L 1 10 L 2 9 M -10 -6 L -8 -4 L -3 -5 L 3 -6 L 8 -7 L 10 -5 M -9 -5 L -3 -5 M 3 -6 L 9 -6 M 10 -5 L 7 -2 L 4 0 L 2 1 M 9 -6 L 8 -4 L 5 -1 L 2 1","-14 13 M 4 -12 L 6 -10 L 3 -6 L 0 -3 L -4 0 L -7 2 M 5 -11 L 4 -9 L 1 -5 L -3 -1 L -7 2 M 1 -4 L 3 -3 L 3 10 M 1 -4 L 2 -3 L 2 9 L 3 10","-14 13 M -9 -8 L -7 -6 L 3 -8 L 5 -6 M -8 -7 L 4 -7 M 5 -6 L 4 -3 L 3 4 M 4 -7 L 3 -2 L 3 4 M -10 4 L -8 6 L 8 4 L 10 5 M -9 5 L 10 5","-14 13 M -1 -7 L 1 -6 L 1 5 M 0 -6 L 0 5 M -8 -8 L -6 -6 L 6 -8 L 8 -7 M -7 -7 L 8 -7 M -10 4 L -8 6 L 8 4 L 10 5 M -9 5 L 10 5","-14 13 M -8 -8 L -6 -6 L 6 -8 L 8 -6 M -7 -7 L 7 -7 M -8 -2 L -6 0 L 6 -2 M -7 -1 L 6 -1 M -8 4 L -6 6 L 6 4 M -7 5 L 6 5 M 8 -6 L 7 -3 L 7 7 M 7 -7 L 6 -2 L 6 7","-14 13 M -6 -12 L -4 -10 L 5 -12 L 6 -11 M -5 -11 L 6 -11 M -8 -5 L -6 -3 L 5 -5 L 7 -3 M -7 -4 L 6 -4 M 7 -3 L 5 0 L 2 3 L -1 5 L -3 6 L -6 7 M 6 -4 L 5 -2 L 3 1 L 1 3 L -2 5 L -6 7","-14 13 M -6 -9 L -4 -8 L -4 -3 L -5 1 M -5 -8 L -5 1 M 2 -12 L 5 -11 L 5 -1 L 4 3 L 2 6 L -1 9 M 4 -11 L 4 -1 L 3 3 L 2 5 L -1 9","-14 13 M -6 -8 L -4 -7 L -4 -4 L -5 0 L -7 3 L -10 6 M -5 -7 L -5 -4 L -6 0 L -7 2 L -10 6 M -1 -9 L 1 -8 L 1 -5 L 0 1 M 0 -8 L 0 4 L 1 6 L 3 6 L 5 5 L 7 3 L 10 -1 M 0 4 L 1 5 L 4 5 L 6 4","-14 13 M -10 -9 L -7 -8 L -7 -5 L -8 1 M -8 -8 L -8 4 L -7 6 L -4 6 L -1 5 L 2 3 L 6 0 L 9 -3 M -8 4 L -7 5 L -4 5 L -1 4 L 3 2 L 6 0","-14 13 M -8 -8 L -6 -6 L 6 -8 L 8 -6 M -7 -7 L 7 -7 M -7 -7 L -7 8 M -6 -6 L -6 6 L -7 8 M 8 -6 L 7 -3 L 6 4 M 7 -7 L 6 -2 L 6 4 M -6 6 L 6 4 L 7 5 M -6 5 L 7 5","-14 13 M -8 -11 L -7 -9 L -7 -4 L -6 -3 M -6 -9 L -6 -3 M -6 -9 L 7 -9 M -8 -11 L -7 -10 L -3 -9 M 3 -9 L 6 -10 L 8 -8 M 8 -8 L 5 -2 L 3 1 L 0 4 L -3 6 L -5 7 M 7 -9 L 6 -6 L 4 -2 L 1 2 L -2 5 L -5 7","-14 13 M -1 -12 L 2 -11 L 2 9 M 1 -11 L 1 10 L 2 9 M -8 -8 L -6 -6 L 6 -8 L 8 -7 M -7 -7 L 8 -7 M -6 -6 L -4 -5 L -4 0 M -5 -5 L -5 0 M -10 -1 L -8 1 L 8 -1 L 10 0 M -9 0 L 10 0","-14 13 M -2 -12 L 1 -11 L 1 -9 L 0 -7 M -2 -12 L 0 -11 L 0 -7 M -8 -9 L -7 -7 L -7 -2 L -6 -1 M -6 -7 L -6 -1 M -6 -7 L 7 -7 M -8 -9 L -7 -8 L -3 -7 M 3 -7 L 6 -8 L 8 -6 M 8 -6 L 5 0 L 3 3 L 0 6 L -3 8 L -5 9 M 7 -7 L 6 -4 L 4 0 L 1 4 L -2 7 L -5 9","-14 13 M -8 -8 L -6 -6 L 6 -8 L 8 -6 M -7 -7 L 7 -7 M 8 -6 L 5 -4 L 1 -1 M 7 -7 L 1 -1 M -1 -2 L 1 -1 L 1 5 M 0 -1 L 0 5 M -10 4 L -8 6 L 8 4 L 10 5 M -9 5 L 10 5","-14 13 M -8 -11 L -6 -9 L 7 -9 M -7 -10 L -3 -9 M 3 -9 L 6 -10 L 8 -8 M -6 -4 L -4 -2 L 4 -3 M -5 -3 L 4 -3 M 8 -8 L 5 -2 L 3 1 L 0 4 L -3 6 L -5 7 M 7 -9 L 6 -6 L 4 -2 L 1 2 L -2 5 L -5 7","-14 13 M -8 -10 L -6 -9 L -5 -8 L -5 -7 L -6 -7 L -7 -9 L -8 -10 M -9 5 L -7 7 L -3 5 L 1 2 L 5 -2 L 9 -7 M -8 6 L -3 4 L 1 1 L 9 -7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -10 7 L -11 8 L -10 9 L -9 8 L -10 7","-14 13 M -1 -12 L 1 -10 L 0 -7 L -2 -2 L -4 2 L -6 5 L -9 9 M 0 -11 L -1 -8 L -3 -2 L -5 3 L -9 9 M -9 -6 L -7 -4 L -3 -5 L 2 -6 L 6 -7 L 8 -5 M -8 -5 L -3 -5 M 2 -6 L 7 -6 M 8 -5 L 7 1 L 6 5 L 5 7 L 3 9 L 2 8 L 0 7 M 7 -6 L 6 1 L 5 5 L 4 7 L 2 8 M 8 -10 L 10 -8 M 10 -12 L 12 -10","-14 13 M -3 -12 L 0 -11 L 2 9 M -1 -11 L 1 10 L 2 9 M -8 -6 L -6 -4 L -2 -5 L 2 -6 L 6 -7 L 8 -6 M -7 -5 L -2 -5 M 2 -6 L 8 -6 M -10 0 L -8 2 L -3 1 L 3 0 L 8 -1 L 10 0 M -9 1 L -3 1 M 3 0 L 10 0 M 8 -10 L 10 -8 M 10 -12 L 12 -10","-14 13 M -2 -12 L 0 -10 L -2 -6 L -4 -3 L -6 -1 L -8 1 M -1 -11 L -2 -8 L -4 -4 L -6 -1 M -1 -8 L 1 -7 L 6 -7 M 3 -7 L 5 -8 L 7 -6 M 7 -6 L 4 0 L 1 4 L -2 7 L -5 9 L -7 10 M 6 -7 L 5 -4 L 3 0 L 0 4 L -3 7 L -7 10 M 7 -10 L 9 -8 M 9 -12 L 11 -10","-14 13 M -4 -12 L -2 -10 L -4 -6 L -6 -3 L -8 -1 L -10 1 M -3 -11 L -4 -8 L -6 -4 L -8 -1 M -6 -3 L 2 -4 L 7 -5 L 10 -4 M 2 -4 L 10 -4 M 0 -3 L 2 -1 L 0 3 L -2 6 L -4 8 L -6 10 M 1 -2 L 0 1 L -2 5 L -4 8 M 7 -10 L 9 -8 M 9 -12 L 11 -10","-14 13 M -8 -8 L -6 -6 L 6 -8 L 8 -6 M -7 -7 L 7 -7 M 8 -6 L 7 -3 L 6 4 M 7 -7 L 6 -2 L 6 4 M -8 4 L -6 6 L 6 4 L 7 5 M -7 5 L 7 5 M 8 -10 L 10 -8 M 10 -12 L 12 -10","-14 13 M -6 -9 L -4 -8 L -4 -3 L -5 1 M -5 -8 L -5 1 M 2 -12 L 5 -11 L 5 -6 L 4 -1 L 3 2 L 2 4 L 0 7 L -2 9 M 4 -11 L 4 -6 L 3 -1 L 2 3 L 0 7 M -10 -5 L -8 -3 L -3 -4 L 3 -5 L 8 -6 L 10 -5 M -9 -4 L -3 -4 M 3 -5 L 10 -5 M 8 -10 L 10 -8 M 10 -12 L 12 -10","-14 13 M -5 -11 L -3 -10 L -2 -9 L -2 -8 L -3 -8 L -4 -10 L -5 -11 M -10 -4 L -8 -3 L -7 -2 L -7 -1 L -8 -1 L -9 -3 L -10 -4 M -9 6 L -7 8 L -3 6 L 1 3 L 5 -1 L 9 -6 M -8 7 L -3 5 L 1 2 L 9 -6 M 4 -10 L 6 -8 M 6 -12 L 8 -10","-14 13 M -8 -9 L -6 -7 L 5 -9 L 7 -7 M -7 -8 L 6 -8 M 7 -7 L 5 -4 L 2 -1 L -1 1 L -3 2 L -8 4 M 6 -8 L 5 -6 L 3 -3 L 1 -1 L -2 1 L -8 4 M 3 1 L 6 3 L 8 5 L 8 6 L 7 6 L 6 4 L 3 1 M 8 -10 L 10 -8 M 10 -12 L 12 -10","-14 13 M -3 -11 L 0 -10 L 0 -8 L -1 1 M -1 -10 L -1 4 L 0 6 L 2 7 L 9 7 M 4 7 L 8 6 L 9 7 M -10 -4 L -8 -2 L -3 -3 L 3 -4 L 8 -5 L 10 -3 M -9 -3 L -3 -3 M 3 -4 L 9 -4 M 10 -3 L 7 -1 L 4 2 M 9 -4 L 4 2 M 7 -10 L 9 -8 M 9 -12 L 11 -10","-14 13 M -9 -9 L -7 -8 L -6 -7 L -6 -6 L -7 -6 L -8 -8 L -9 -9 M 6 -10 L 8 -8 L 5 -2 L 2 2 L -1 5 L -4 7 L -6 8 M 7 -9 L 6 -6 L 4 -2 L 1 2 L -2 5 L -6 8 M 9 -11 L 11 -9 M 11 -13 L 13 -11","-14 13 M -2 -12 L 0 -10 L -2 -6 L -4 -3 L -6 -1 L -8 1 M -1 -11 L -2 -8 L -4 -4 L -6 -1 M -1 -8 L 1 -7 L 6 -7 M 3 -7 L 5 -8 L 7 -6 M 7 -6 L 4 0 L 1 4 L -2 7 L -5 9 L -7 10 M 6 -7 L 5 -4 L 3 0 L 0 4 L -3 7 L -7 10 M -4 -2 L -1 -1 L 1 0 L 4 2 L 5 3 L 5 4 L 4 4 L 3 2 L 1 0 M 7 -10 L 9 -8 M 9 -12 L 11 -10","-14 13 M -6 -8 L -3 -8 L 2 -9 L 6 -11 M -3 -8 L 0 -9 L 2 -10 L 5 -12 L 6 -11 M -2 -8 L 1 -7 L 1 -1 L 0 3 L -2 6 L -5 9 M 0 -7 L 0 -1 L -1 3 L -3 7 M -10 -4 L -8 -2 L -3 -3 L 3 -4 L 8 -5 L 10 -4 M -9 -3 L -3 -3 M 3 -4 L 10 -4 M 8 -10 L 10 -8 M 10 -12 L 12 -10","-14 13 M -9 -9 L -7 -8 L -6 -7 L -6 -6 L -7 -6 L -8 -8 L -9 -9 M -3 -10 L -1 -9 L 0 -8 L 0 -7 L -1 -7 L -2 -9 L -3 -10 M 6 -10 L 8 -8 L 5 -2 L 2 2 L -1 5 L -4 7 L -6 8 M 7 -9 L 6 -6 L 4 -2 L 1 2 L -2 5 L -6 8 M 9 -11 L 11 -9 M 11 -13 L 13 -11","-14 13 M -6 -12 L -4 -10 L 5 -12 L 6 -11 M -5 -11 L 6 -11 M -10 -4 L -8 -2 L -3 -3 L 3 -4 L 8 -5 L 10 -4 M -9 -3 L -3 -3 M 3 -4 L 10 -4 M 1 -3 L 1 -1 L 0 3 L -2 6 L -5 9 M 0 -3 L 0 -1 L -1 3 L -3 7 M 8 -10 L 10 -8 M 10 -12 L 12 -10","-14 13 M -5 -12 L -2 -11 L -2 10 M -3 -11 L -3 9 L -2 10 M -2 -3 L 0 -3 L 3 -2 L 4 -1 L 4 0 L 3 0 L 2 -2 L 0 -3 M 2 -10 L 4 -8 M 4 -12 L 6 -10","-14 13 M -6 -6 L -4 -4 L -5 -1 L -6 1 L -8 3 L -10 4 M -5 -5 L -6 -1 L -8 3 M 4 -6 L 6 -4 L 8 -1 L 10 3 L 10 4 L 9 4 L 8 0 L 6 -4 M 7 -9 L 9 -7 M 9 -11 L 11 -9","-14 13 M -9 -11 L -6 -10 L -6 -8 L -7 1 M -7 -10 L -7 4 L -6 6 L -4 7 L 7 7 M -1 7 L 3 6 L 5 6 L 7 7 M -7 0 L -3 -1 L 0 -2 L 6 -4 M 0 -2 L 4 -4 L 6 -4 M 7 -9 L 9 -7 M 9 -11 L 11 -9","-14 13 M -8 -11 L -6 -9 L 7 -9 M -7 -10 L -3 -9 M 3 -9 L 6 -10 L 8 -8 M 8 -8 L 5 -2 L 3 1 L 0 4 L -3 6 L -5 7 M 7 -9 L 6 -6 L 4 -2 L 1 2 L -2 5 L -5 7 M 9 -11 L 11 -9 M 11 -13 L 13 -11","-14 13 M -11 -1 L -9 1 L -2 -6 L -1 -6 L 9 4 M -10 0 L -8 -1 L -4 -4 M 3 -2 L 8 2 L 10 3 L 9 4 M 4 -8 L 6 -6 M 6 -10 L 8 -8","-14 13 M -2 -12 L 1 -11 L 1 7 L 0 9 L -1 7 L -3 6 M 0 -11 L 0 6 L -1 7 M -10 -6 L -8 -4 L -3 -5 L 3 -6 L 8 -7 L 10 -6 M -9 -5 L -3 -5 M 3 -6 L 10 -6 M -6 1 L -8 4 L -9 5 L -10 5 L -10 4 L -8 3 L -6 1 M 6 1 L 9 3 L 10 4 L 10 5 L 9 5 L 8 3 L 6 1 M 8 -11 L 10 -9 M 10 -13 L 12 -11","-14 13 M -6 -6 L -4 -4 L -5 -1 L -6 1 L -8 3 L -10 4 M -5 -5 L -6 -1 L -8 3 M 4 -6 L 6 -4 L 8 -1 L 10 3 L 10 4 L 9 4 L 8 0 L 6 -4 M 8 -11 L 7 -10 L 7 -8 L 8 -7 L 10 -7 L 11 -8 L 11 -10 L 10 -11 L 8 -11","-14 13 M -9 -11 L -6 -10 L -6 -8 L -7 1 M -7 -10 L -7 4 L -6 6 L -4 7 L 7 7 M -1 7 L 3 6 L 5 6 L 7 7 M -7 0 L -3 -1 L 0 -2 L 6 -4 M 0 -2 L 4 -4 L 6 -4 M 8 -11 L 7 -10 L 7 -8 L 8 -7 L 10 -7 L 11 -8 L 11 -10 L 10 -11 L 8 -11","-14 13 M -8 -11 L -6 -9 L 7 -9 M -7 -10 L -3 -9 M 3 -9 L 6 -10 L 8 -8 M 8 -8 L 5 -2 L 3 1 L 0 4 L -3 6 L -5 7 M 7 -9 L 6 -6 L 4 -2 L 1 2 L -2 5 L -5 7 M 10 -13 L 9 -12 L 9 -10 L 10 -9 L 12 -9 L 13 -10 L 13 -12 L 12 -13 L 10 -13","-14 13 M -11 -1 L -9 1 L -2 -6 L -1 -6 L 9 4 M -10 0 L -8 -1 L -4 -4 M 3 -2 L 8 2 L 10 3 L 9 4 M 5 -10 L 4 -9 L 4 -7 L 5 -6 L 7 -6 L 8 -7 L 8 -9 L 7 -10 L 5 -10","-14 13 M -2 -12 L 1 -11 L 1 7 L 0 9 L -1 7 L -3 6 M 0 -11 L 0 6 L -1 7 M -10 -6 L -8 -4 L -3 -5 L 3 -6 L 8 -7 L 10 -6 M -9 -5 L -3 -5 M 3 -6 L 10 -6 M -6 1 L -8 4 L -9 5 L -10 5 L -10 4 L -8 3 L -6 1 M 6 1 L 9 3 L 10 4 L 10 5 L 9 5 L 8 3 L 6 1 M 9 -13 L 8 -12 L 8 -10 L 9 -9 L 11 -9 L 12 -10 L 12 -12 L 11 -13 L 9 -13"]
markers = ["-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-7 7 M -1 -7 L -4 -6 L -6 -4 L -7 -1 L -7 1 L -6 4 L -4 6 L -1 7 L 1 7 L 4 6 L 6 4 L 7 1 L 7 -1 L 6 -4 L 4 -6 L 1 -7 L -1 -7","-6 6 M -6 -6 L -6 6 L 6 6 L 6 -6 L -6 -6","-7 7 M 0 -8 L -7 4 L 7 4 L 0 -8","-6 6 M 0 -10 L -6 0 L 0 10 L 6 0 L 0 -10","-8 8 M 0 -9 L -2 -3 L -8 -3 L -3 1 L -5 7 L 0 3 L 5 7 L 3 1 L 8 -3 L 2 -3 L 0 -9","-6 6 M -2 -6 L -2 -2 L -6 -2 L -6 2 L -2 2 L -2 6 L 2 6 L 2 2 L 6 2 L 6 -2 L 2 -2 L 2 -6 L -2 -6","-7 7 M 0 -7 L 0 7 M -7 0 L 7 0","-5 5 M -5 -5 L 5 5 M 5 -5 L -5 5","-5 5 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-4 4 M -1 -4 L -3 -3 L -4 -1 L -4 1 L -3 3 L -1 4 L 1 4 L 3 3 L 4 1 L 4 -1 L 3 -3 L 1 -4 L -1 -4 M -3 -1 L -3 1 M -2 -2 L -2 2 M -1 -3 L -1 3 M 0 -3 L 0 3 M 1 -3 L 1 3 M 2 -2 L 2 2 M 3 -1 L 3 1","-4 4 M -4 -4 L -4 4 L 4 4 L 4 -4 L -4 -4 M -3 -3 L -3 3 M -2 -3 L -2 3 M -1 -3 L -1 3 M 0 -3 L 0 3 M 1 -3 L 1 3 M 2 -3 L 2 3 M 3 -3 L 3 3","-5 5 M 0 -6 L -5 3 L 5 3 L 0 -6 M 0 -3 L -3 2 M 0 -3 L 3 2 M 0 0 L -1 2 M 0 0 L 1 2","-6 3 M -6 0 L 3 5 L 3 -5 L -6 0 M -3 0 L 2 3 M -3 0 L 2 -3 M 0 0 L 2 1 M 0 0 L 2 -1","-5 5 M 0 6 L 5 -3 L -5 -3 L 0 6 M 0 3 L 3 -2 M 0 3 L -3 -2 M 0 0 L 1 -2 M 0 0 L -1 -2","-3 6 M 6 0 L -3 -5 L -3 5 L 6 0 M 3 0 L -2 -3 M 3 0 L -2 3 M 0 0 L -2 -1 M 0 0 L -2 1","-14 14 M -14 0 L 14 0 M -14 0 L 0 16 M 14 0 L 0 16","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-7 7 M -1 -7 L -4 -6 L -6 -4 L -7 -1 L -7 1 L -6 4 L -4 6 L -1 7 L 1 7 L 4 6 L 6 4 L 7 1 L 7 -1 L 6 -4 L 4 -6 L 1 -7 L -1 -7","-6 6 M -6 -6 L -6 6 L 6 6 L 6 -6 L -6 -6","-7 7 M 0 -8 L -7 4 L 7 4 L 0 -8","-6 6 M 0 -10 L -6 0 L 0 10 L 6 0 L 0 -10","-8 8 M 0 -9 L -2 -3 L -8 -3 L -3 1 L -5 7 L 0 3 L 5 7 L 3 1 L 8 -3 L 2 -3 L 0 -9","-6 6 M -2 -6 L -2 -2 L -6 -2 L -6 2 L -2 2 L -2 6 L 2 6 L 2 2 L 6 2 L 6 -2 L 2 -2 L 2 -6 L -2 -6","-7 7 M 0 -7 L 0 7 M -7 0 L 7 0","-5 5 M -5 -5 L 5 5 M 5 -5 L -5 5","-5 5 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-4 4 M -1 -4 L -3 -3 L -4 -1 L -4 1 L -3 3 L -1 4 L 1 4 L 3 3 L 4 1 L 4 -1 L 3 -3 L 1 -4 L -1 -4 M -3 -1 L -3 1 M -2 -2 L -2 2 M -1 -3 L -1 3 M 0 -3 L 0 3 M 1 -3 L 1 3 M 2 -2 L 2 2 M 3 -1 L 3 1","-4 4 M -4 -4 L -4 4 L 4 4 L 4 -4 L -4 -4 M -3 -3 L -3 3 M -2 -3 L -2 3 M -1 -3 L -1 3 M 0 -3 L 0 3 M 1 -3 L 1 3 M 2 -3 L 2 3 M 3 -3 L 3 3","-5 5 M 0 -6 L -5 3 L 5 3 L 0 -6 M 0 -3 L -3 2 M 0 -3 L 3 2 M 0 0 L -1 2 M 0 0 L 1 2","-6 3 M -6 0 L 3 5 L 3 -5 L -6 0 M -3 0 L 2 3 M -3 0 L 2 -3 M 0 0 L 2 1 M 0 0 L 2 -1","-5 5 M 0 6 L 5 -3 L -5 -3 L 0 6 M 0 3 L 3 -2 M 0 3 L -3 -2 M 0 0 L 1 -2 M 0 0 L -1 -2","-3 6 M 6 0 L -3 -5 L -3 5 L 6 0 M 3 0 L -2 -3 M 3 0 L -2 3 M 0 0 L -2 -1 M 0 0 L -2 1","-14 14 M -14 0 L 14 0 M -14 0 L 0 16 M 14 0 L 0 16","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8","-8 8"]
mathlow = ["-8 8","-12 12 M 0 -8 L 0 9 M -8 0 L 8 0 M -8 9 L 8 9","-12 12 M 0 -8 L 0 9 M -8 -8 L 8 -8 M -8 0 L 8 0","-11 11 M -7 -7 L 7 7 M 7 -7 L -7 7","-2 3 M 0 -1 L 0 0 L 1 0 L 1 -1 L 0 -1","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-12 12 M 8 -12 L -8 -5 L 8 2 M -8 4 L 8 4 M -8 9 L 8 9","-12 12 M -8 -12 L 8 -5 L -8 2 M -8 4 L 8 4 M -8 9 L 8 9","-7 7 M 4 -16 L 2 -14 L 0 -11 L -2 -7 L -3 -2 L -3 2 L -2 7 L 0 11 L 2 14 L 4 16 M 2 -14 L 0 -10 L -1 -7 L -2 -2 L -2 2 L -1 7 L 0 10 L 2 14","-7 7 M -4 -16 L -2 -14 L 0 -11 L 2 -7 L 3 -2 L 3 2 L 2 7 L 0 11 L -2 14 L -4 16 M -2 -14 L 0 -10 L 1 -7 L 2 -2 L 2 2 L 1 7 L 0 10 L -2 14","-8 8 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-13 13 M 0 -9 L 0 9 M -9 0 L 9 0","-4 4 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-13 13 M -9 0 L 9 0","-4 4 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-11 11 M 9 -16 L -9 16","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12","-10 10 M -4 -8 L -2 -9 L 1 -12 L 1 9","-10 10 M -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 3 -1 L -7 9 L 7 9","-10 10 M -5 -12 L 6 -12 L 0 -4 L 3 -4 L 5 -3 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 3 -12 L -7 2 L 8 2 M 3 -12 L 3 9","-10 10 M 5 -12 L -5 -12 L -6 -3 L -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 6 -9 L 5 -11 L 2 -12 L 0 -12 L -3 -11 L -5 -8 L -6 -3 L -6 2 L -5 6 L -3 8 L 0 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 L -3 -3 L -5 -1 L -6 2","-10 10 M 7 -12 L -3 9 M -7 -12 L 7 -12","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 1 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 2 L -6 0 L -4 -2 L -1 -3 L 3 -4 L 5 -5 L 6 -7 L 6 -9 L 5 -11 L 2 -12 L -2 -12","-10 10 M 6 -5 L 5 -2 L 3 0 L 0 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 0 -12 L 3 -11 L 5 -9 L 6 -5 L 6 0 L 5 5 L 3 8 L 0 9 L -2 9 L -5 8 L -6 6","-17 17 M -10 -16 L -10 16 M -9 -16 L -9 16 M 9 -16 L 9 16 M 10 -16 L 10 16 M -14 -16 L 14 -16 M -14 16 L -5 16 M 5 16 L 14 16","-16 15 M -11 -16 L -1 -2 L -12 16 M -12 -16 L -2 -2 M -13 -16 L -2 -1 M -13 -16 L 10 -16 L 12 -9 L 9 -16 M -11 15 L 10 15 M -12 16 L 10 16 L 12 9 L 9 16","-12 12 M 8 -9 L -8 0 L 8 9","-13 13 M -9 -3 L 9 -3 M -9 3 L 9 3","-12 12 M -8 -9 L 8 0 L -8 9","-13 13 M 7 -9 L -7 9 M -9 -3 L 9 -3 M -9 3 L 9 3","-13 13 M -9 -5 L 9 -5 M -9 0 L 9 0 M -9 5 L 9 5","-9 10 M 6 -5 L 6 9 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-10 9 M -6 -12 L -6 9 M -6 -2 L -4 -4 L -2 -5 L 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 L -2 9 L -4 8 L -6 6","-9 9 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-9 10 M 6 -12 L 6 9 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-9 9 M -6 1 L 6 1 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-5 7 M 5 -12 L 3 -12 L 1 -11 L 0 -8 L 0 9 M -3 -5 L 4 -5","-9 10 M 6 -5 L 6 11 L 5 14 L 4 15 L 2 16 L -1 16 L -3 15 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-9 10 M -5 -12 L -5 9 M -5 -1 L -2 -4 L 0 -5 L 3 -5 L 5 -4 L 6 -1 L 6 9","-4 4 M -1 -12 L 0 -11 L 1 -12 L 0 -13 L -1 -12 M 0 -5 L 0 9","-5 5 M 0 -12 L 1 -11 L 2 -12 L 1 -13 L 0 -12 M 1 -5 L 1 12 L 0 15 L -2 16 L -4 16","-9 8 M -5 -12 L -5 9 M 5 -5 L -5 5 M -1 1 L 6 9","-4 4 M 0 -12 L 0 9","-15 15 M -11 -5 L -11 9 M -11 -1 L -8 -4 L -6 -5 L -3 -5 L -1 -4 L 0 -1 L 0 9 M 0 -1 L 3 -4 L 5 -5 L 8 -5 L 10 -4 L 11 -1 L 11 9","-9 10 M -5 -5 L -5 9 M -5 -1 L -2 -4 L 0 -5 L 3 -5 L 5 -4 L 6 -1 L 6 9","-9 10 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6 L 7 3 L 7 1 L 6 -2 L 4 -4 L 2 -5 L -1 -5","-10 9 M -6 -5 L -6 16 M -6 -2 L -4 -4 L -2 -5 L 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 L -2 9 L -4 8 L -6 6","-9 10 M 6 -5 L 6 16 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-7 6 M -3 -5 L -3 9 M -3 1 L -2 -2 L 0 -4 L 2 -5 L 5 -5","-8 9 M 6 -2 L 5 -4 L 2 -5 L -1 -5 L -4 -4 L -5 -2 L -4 0 L -2 1 L 3 2 L 5 3 L 6 5 L 6 6 L 5 8 L 2 9 L -1 9 L -4 8 L -5 6","-5 7 M 0 -12 L 0 5 L 1 8 L 3 9 L 5 9 M -3 -5 L 4 -5","-9 10 M -5 -5 L -5 5 L -4 8 L -2 9 L 1 9 L 3 8 L 6 5 M 6 -5 L 6 9","-8 8 M -6 -5 L 0 9 M 6 -5 L 0 9","-11 11 M -8 -5 L -4 9 M 0 -5 L -4 9 M 0 -5 L 4 9 M 8 -5 L 4 9","-8 9 M -5 -5 L 6 9 M 6 -5 L -5 9","-8 8 M -6 -5 L 0 9 M 6 -5 L 0 9 L -2 13 L -4 15 L -6 16 L -7 16","-8 9 M 6 -5 L -5 9 M -5 -5 L 6 -5 M -5 9 L 6 9","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-12 13 M 9 5 L 7 5 L 5 4 L 3 2 L 0 -2 L -1 -3 L -3 -4 L -5 -4 L -7 -3 L -8 -1 L -8 1 L -7 3 L -5 4 L -3 4 L -1 3 L 0 2 L 3 -2 L 5 -4 L 7 -5 L 9 -5","-12 13 M 10 1 L 9 3 L 7 4 L 5 4 L 3 3 L 2 2 L -1 -2 L -2 -3 L -4 -4 L -6 -4 L -8 -3 L -9 -1 L -9 1 L -8 3 L -6 4 L -4 4 L -2 3 L -1 2 L 2 -2 L 3 -3 L 5 -4 L 7 -4 L 9 -3 L 10 -1 L 10 1","-7 7 M -1 -12 L -3 -11 L -4 -9 L -4 -7 L -3 -5 L -1 -4 L 1 -4 L 3 -5 L 4 -7 L 4 -9 L 3 -11 L 1 -12 L -1 -12","-10 10 M -2 -16 L -2 13 M 2 -16 L 2 13 M 7 -9 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 1 L 7 3 L 7 6 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6","-13 9 M -10 -5 L -6 -5 L 0 7 M -7 -5 L 0 9 M 9 -16 L 0 9","-17 16 M -14 -5 L -9 -5 L 0 7 M -10 -4 L 0 9 M 16 -24 L 0 9","-12 12 M 8 -8 L 1 -8 L -3 -7 L -5 -6 L -7 -4 L -8 -1 L -8 1 L -7 4 L -5 6 L -3 7 L 1 8 L 8 8","-12 12 M -8 -8 L -8 -1 L -7 3 L -6 5 L -4 7 L -1 8 L 1 8 L 4 7 L 6 5 L 7 3 L 8 -1 L 8 -8","-12 12 M -8 -8 L -1 -8 L 3 -7 L 5 -6 L 7 -4 L 8 -1 L 8 1 L 7 4 L 5 6 L 3 7 L -1 8 L -8 8","-12 12 M -8 8 L -8 1 L -7 -3 L -6 -5 L -4 -7 L -1 -8 L 1 -8 L 4 -7 L 6 -5 L 7 -3 L 8 1 L 8 8","-12 12 M 8 -8 L 1 -8 L -3 -7 L -5 -6 L -7 -4 L -8 -1 L -8 1 L -7 4 L -5 6 L -3 7 L 1 8 L 8 8 M -8 0 L 4 0","-13 13 M 6 -2 L 9 0 L 6 2 M 3 -5 L 8 0 L 3 5 M -9 0 L 8 0","-8 8 M -2 -6 L 0 -9 L 2 -6 M -5 -3 L 0 -8 L 5 -3 M 0 -8 L 0 9","-13 13 M -6 -2 L -9 0 L -6 2 M -3 -5 L -8 0 L -3 5 M -8 0 L 9 0","-8 8 M -2 6 L 0 9 L 2 6 M -5 3 L 0 8 L 5 3 M 0 -9 L 0 8","-9 10 M 6 0 L 5 -3 L 4 -4 L 2 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 5 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 6 L 6 3 L 7 -2 L 7 -7 L 6 -10 L 5 -11 L 3 -12 L 0 -12 L -2 -11 L -3 -10 L -3 -9 L -2 -9 L -2 -10 M 0 -5 L -2 -4 L -4 -1 L -5 2 L -5 6 L -4 8 M 0 9 L 2 8 L 4 6 L 5 3 L 6 -2 L 6 -7 L 5 -10 L 3 -12","-10 10 M -8 -12 L 0 9 M -7 -12 L 0 7 M 8 -12 L 0 9 M -8 -12 L 8 -12 M -7 -11 L 7 -11","-17 16 M -14 -5 L -9 -5 L 0 7 M -10 -4 L 0 9 M 16 -24 L 0 9","-12 12 M 9 -15 L 8 -14 L 9 -13 L 10 -14 L 10 -15 L 9 -16 L 7 -16 L 5 -15 L 3 -13 L 2 -11 L 1 -8 L 0 -4 L -2 8 L -3 12 L -4 14 M 4 -14 L 3 -12 L 2 -8 L 0 4 L -1 8 L -2 11 L -3 13 L -5 15 L -7 16 L -9 16 L -10 15 L -10 14 L -9 13 L -8 14 L -9 15","-15 15 M 11 -36 L 10 -36 L 9 -35 L 9 -34 L 10 -33 L 11 -33 L 12 -34 L 12 -36 L 11 -38 L 9 -39 L 7 -39 L 5 -38 L 3 -36 L 2 -34 L 1 -31 L 0 -24 L -1 -8 L -1 24 L -2 33 L -3 36 M 10 -35 L 10 -34 L 11 -34 L 11 -35 L 10 -35 M 0 -24 L 0 24 M 3 -36 L 2 -33 L 1 -24 L 1 8 L 0 24 L -1 31 L -2 34 L -3 36 L -5 38 L -7 39 L -9 39 L -11 38 L -12 36 L -12 34 L -11 33 L -10 33 L -9 34 L -9 35 L -10 36 L -11 36 M -11 34 L -11 35 L -10 35 L -10 34 L -11 34","-9 9 M 6 -39 L 3 -33 L 0 -26 L -2 -21 L -3 -17 L -4 -12 L -5 -4 L -5 4 L -4 12 L -3 17 L -2 21 L 0 26 L 3 33 L 6 39 M 3 -33 L 1 -28 L -1 -22 L -2 -18 L -3 -12 L -4 -4 L -4 4 L -3 12 L -2 18 L -1 22 L 1 28 L 3 33","-9 9 M -6 -39 L -3 -33 L 0 -26 L 2 -21 L 3 -17 L 4 -12 L 5 -4 L 5 4 L 4 12 L 3 17 L 2 21 L 0 26 L -3 33 L -6 39 M -3 -33 L -1 -28 L 1 -22 L 2 -18 L 3 -12 L 4 -4 L 4 4 L 3 12 L 2 18 L 1 22 L -1 28 L -3 33","-9 9 M -5 -39 L -5 0 L -5 39 M -4 -39 L -4 0 L -4 39 M -5 -39 L 6 -39 M -5 39 L 6 39","-9 9 M 4 -39 L 4 0 L 4 39 M 5 -39 L 5 0 L 5 39 M -6 -39 L 5 -39 M -6 39 L 5 39","-9 10 M 6 -12 L 6 9 M -7 -12 L 6 -12 M -2 -2 L 6 -2 M -7 9 L 6 9","-10 10 M -7 -9 L -6 -7 L 6 5 L 7 7 L 7 9 M -6 -6 L 6 6 M -7 -9 L -7 -7 L -6 -5 L 6 7 L 7 9 M -2 -2 L -6 2 L -7 4 L -7 6 L -6 8 L -7 9 M -7 4 L -5 8 M -6 2 L -6 4 L -5 6 L -5 8 L -7 9 M 1 1 L 6 -4 M 4 -9 L 4 -6 L 5 -4 L 7 -4 L 7 -6 L 5 -7 L 4 -9 M 4 -9 L 5 -6 L 7 -4","-13 13 M 0 -9 L -1 -8 L 0 -7 L 1 -8 L 0 -9 M -9 0 L 9 0 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-7 7 M -3 -16 L -3 16 M 3 -16 L 3 16","-12 12 M 0 -16 L 0 9 M -9 9 L 9 9","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-12 12 M 9 -16 L -9 9 L 9 9","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-13 13 M 0 -9 L -1 -8 L 0 -7 L 1 -8 L 0 -9 M -9 7 L -10 8 L -9 9 L -8 8 L -9 7 M 9 7 L 8 8 L 9 9 L 10 8 L 9 7","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3"]
mathupp = ["-8 8","-12 12 M 0 -8 L 0 9 M -8 0 L 8 0 M -8 9 L 8 9","-12 12 M 0 -8 L 0 9 M -8 -8 L 8 -8 M -8 0 L 8 0","-11 11 M -7 -7 L 7 7 M 7 -7 L -7 7","-2 3 M 0 -1 L 0 0 L 1 0 L 1 -1 L 0 -1","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-12 12 M 8 -12 L -8 -5 L 8 2 M -8 4 L 8 4 M -8 9 L 8 9","-12 12 M -8 -12 L 8 -5 L -8 2 M -8 4 L 8 4 M -8 9 L 8 9","-7 7 M 4 -16 L 2 -14 L 0 -11 L -2 -7 L -3 -2 L -3 2 L -2 7 L 0 11 L 2 14 L 4 16 M 2 -14 L 0 -10 L -1 -7 L -2 -2 L -2 2 L -1 7 L 0 10 L 2 14","-7 7 M -4 -16 L -2 -14 L 0 -11 L 2 -7 L 3 -2 L 3 2 L 2 7 L 0 11 L -2 14 L -4 16 M -2 -14 L 0 -10 L 1 -7 L 2 -2 L 2 2 L 1 7 L 0 10 L -2 14","-8 8 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-13 13 M 0 -9 L 0 9 M -9 0 L 9 0","-5 5 M 1 8 L 0 9 L -1 8 L 0 7 L 1 8 L 1 10 L 0 12 L -1 13","-13 13 M -9 0 L 9 0","-5 5 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-11 11 M 9 -16 L -9 16","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12","-10 10 M -4 -8 L -2 -9 L 1 -12 L 1 9","-10 10 M -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 3 -1 L -7 9 L 7 9","-10 10 M -5 -12 L 6 -12 L 0 -4 L 3 -4 L 5 -3 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 3 -12 L -7 2 L 8 2 M 3 -12 L 3 9","-10 10 M 5 -12 L -5 -12 L -6 -3 L -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 6 -9 L 5 -11 L 2 -12 L 0 -12 L -3 -11 L -5 -8 L -6 -3 L -6 2 L -5 6 L -3 8 L 0 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 L -3 -3 L -5 -1 L -6 2","-10 10 M 7 -12 L -3 9 M -7 -12 L 7 -12","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 1 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 2 L -6 0 L -4 -2 L -1 -3 L 3 -4 L 5 -5 L 6 -7 L 6 -9 L 5 -11 L 2 -12 L -2 -12","-10 10 M 6 -5 L 5 -2 L 3 0 L 0 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 0 -12 L 3 -11 L 5 -9 L 6 -5 L 6 0 L 5 5 L 3 8 L 0 9 L -2 9 L -5 8 L -6 6","-17 17 M -10 -16 L -10 16 M -9 -16 L -9 16 M 9 -16 L 9 16 M 10 -16 L 10 16 M -14 -16 L 14 -16 M -14 16 L -5 16 M 5 16 L 14 16","-16 15 M -11 -16 L -1 -2 L -12 16 M -12 -16 L -2 -2 M -13 -16 L -2 -1 M -13 -16 L 10 -16 L 12 -9 L 9 -16 M -11 15 L 10 15 M -12 16 L 10 16 L 12 9 L 9 16","-12 12 M 8 -9 L -8 0 L 8 9","-13 13 M -9 -3 L 9 -3 M -9 3 L 9 3","-12 12 M -8 -9 L 8 0 L -8 9","-13 13 M 7 -9 L -7 9 M -9 -3 L 9 -3 M -9 3 L 9 3","-13 13 M -9 -5 L 9 -5 M -9 0 L 9 0 M -9 5 L 9 5","-9 9 M 0 -12 L -8 9 M 0 -12 L 8 9 M -5 2 L 5 2","-11 10 M -7 -12 L -7 9 M -7 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 2 -2 M -7 -2 L 2 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -7 9","-10 11 M 8 -7 L 7 -9 L 5 -11 L 3 -12 L -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 L -3 8 L -1 9 L 3 9 L 5 8 L 7 6 L 8 4","-11 10 M -7 -12 L -7 9 M -7 -12 L 0 -12 L 3 -11 L 5 -9 L 6 -7 L 7 -4 L 7 1 L 6 4 L 5 6 L 3 8 L 0 9 L -7 9","-10 9 M -6 -12 L -6 9 M -6 -12 L 7 -12 M -6 -2 L 2 -2 M -6 9 L 7 9","-10 8 M -6 -12 L -6 9 M -6 -12 L 7 -12 M -6 -2 L 2 -2","-10 11 M 8 -7 L 7 -9 L 5 -11 L 3 -12 L -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 L -3 8 L -1 9 L 3 9 L 5 8 L 7 6 L 8 4 L 8 1 M 3 1 L 8 1","-11 11 M -7 -12 L -7 9 M 7 -12 L 7 9 M -7 -2 L 7 -2","-4 4 M 0 -12 L 0 9","-8 8 M 4 -12 L 4 4 L 3 7 L 2 8 L 0 9 L -2 9 L -4 8 L -5 7 L -6 4 L -6 2","-11 10 M -7 -12 L -7 9 M 7 -12 L -7 2 M -2 -3 L 7 9","-10 7 M -6 -12 L -6 9 M -6 9 L 6 9","-12 12 M -8 -12 L -8 9 M -8 -12 L 0 9 M 8 -12 L 0 9 M 8 -12 L 8 9","-11 11 M -7 -12 L -7 9 M -7 -12 L 7 9 M 7 -12 L 7 9","-11 11 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -2 9 L 2 9 L 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11 L 2 -12 L -2 -12","-11 10 M -7 -12 L -7 9 M -7 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -5 L 6 -3 L 5 -2 L 2 -1 L -7 -1","-11 11 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -2 9 L 2 9 L 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11 L 2 -12 L -2 -12 M 1 5 L 7 11","-11 10 M -7 -12 L -7 9 M -7 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 2 -2 L -7 -2 M 0 -2 L 7 9","-10 10 M 7 -9 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 1 L 7 3 L 7 6 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6","-8 8 M 0 -12 L 0 9 M -7 -12 L 7 -12","-11 11 M -7 -12 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 -12","-9 9 M -8 -12 L 0 9 M 8 -12 L 0 9","-12 12 M -10 -12 L -5 9 M 0 -12 L -5 9 M 0 -12 L 5 9 M 10 -12 L 5 9","-10 10 M -7 -12 L 7 9 M 7 -12 L -7 9","-9 9 M -8 -12 L 0 -2 L 0 9 M 8 -12 L 0 -2","-10 10 M 7 -12 L -7 9 M -7 -12 L 7 -12 M -7 9 L 7 9","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-12 13 M 9 5 L 7 5 L 5 4 L 3 2 L 0 -2 L -1 -3 L -3 -4 L -5 -4 L -7 -3 L -8 -1 L -8 1 L -7 3 L -5 4 L -3 4 L -1 3 L 0 2 L 3 -2 L 5 -4 L 7 -5 L 9 -5","-12 13 M 10 1 L 9 3 L 7 4 L 5 4 L 3 3 L 2 2 L -1 -2 L -2 -3 L -4 -4 L -6 -4 L -8 -3 L -9 -1 L -9 1 L -8 3 L -6 4 L -4 4 L -2 3 L -1 2 L 2 -2 L 3 -3 L 5 -4 L 7 -4 L 9 -3 L 10 -1 L 10 1","-7 7 M -1 -12 L -3 -11 L -4 -9 L -4 -7 L -3 -5 L -1 -4 L 1 -4 L 3 -5 L 4 -7 L 4 -9 L 3 -11 L 1 -12 L -1 -12","-8 8 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-13 9 M -10 -5 L -6 -5 L 0 7 M -7 -5 L 0 9 M 9 -16 L 0 9","-17 16 M -14 -5 L -9 -5 L 0 7 M -10 -4 L 0 9 M 16 -24 L 0 9","-12 12 M 8 -8 L 1 -8 L -3 -7 L -5 -6 L -7 -4 L -8 -1 L -8 1 L -7 4 L -5 6 L -3 7 L 1 8 L 8 8","-12 12 M -8 -8 L -8 -1 L -7 3 L -6 5 L -4 7 L -1 8 L 1 8 L 4 7 L 6 5 L 7 3 L 8 -1 L 8 -8","-12 12 M -8 -8 L -1 -8 L 3 -7 L 5 -6 L 7 -4 L 8 -1 L 8 1 L 7 4 L 5 6 L 3 7 L -1 8 L -8 8","-12 12 M -8 8 L -8 1 L -7 -3 L -6 -5 L -4 -7 L -1 -8 L 1 -8 L 4 -7 L 6 -5 L 7 -3 L 8 1 L 8 8","-12 12 M 8 -8 L 1 -8 L -3 -7 L -5 -6 L -7 -4 L -8 -1 L -8 1 L -7 4 L -5 6 L -3 7 L 1 8 L 8 8 M -8 0 L 4 0","-13 13 M 6 -2 L 9 0 L 6 2 M 3 -5 L 8 0 L 3 5 M -9 0 L 8 0","-8 8 M -2 -6 L 0 -9 L 2 -6 M -5 -3 L 0 -8 L 5 -3 M 0 -8 L 0 9","-13 13 M -6 -2 L -9 0 L -6 2 M -3 -5 L -8 0 L -3 5 M -8 0 L 9 0","-8 8 M -2 6 L 0 9 L 2 6 M -5 3 L 0 8 L 5 3 M 0 -9 L 0 8","-9 10 M 6 0 L 5 -3 L 4 -4 L 2 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 5 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 6 L 6 3 L 7 -2 L 7 -7 L 6 -10 L 5 -11 L 3 -12 L 0 -12 L -2 -11 L -3 -10 L -3 -9 L -2 -9 L -2 -10 M 0 -5 L -2 -4 L -4 -1 L -5 2 L -5 6 L -4 8 M 0 9 L 2 8 L 4 6 L 5 3 L 6 -2 L 6 -7 L 5 -10 L 3 -12","-10 10 M -8 -12 L 0 9 M -7 -12 L 0 7 M 8 -12 L 0 9 M -8 -12 L 8 -12 M -7 -11 L 7 -11","-17 16 M -14 -5 L -9 -5 L 0 7 M -10 -4 L 0 9 M 16 -24 L 0 9","-12 12 M 9 -15 L 8 -14 L 9 -13 L 10 -14 L 10 -15 L 9 -16 L 7 -16 L 5 -15 L 3 -13 L 2 -11 L 1 -8 L 0 -4 L -2 8 L -3 12 L -4 14 M 4 -14 L 3 -12 L 2 -8 L 0 4 L -1 8 L -2 11 L -3 13 L -5 15 L -7 16 L -9 16 L -10 15 L -10 14 L -9 13 L -8 14 L -9 15","-15 15 M 11 -36 L 10 -36 L 9 -35 L 9 -34 L 10 -33 L 11 -33 L 12 -34 L 12 -36 L 11 -38 L 9 -39 L 7 -39 L 5 -38 L 3 -36 L 2 -34 L 1 -31 L 0 -24 L -1 -8 L -1 24 L -2 33 L -3 36 M 10 -35 L 10 -34 L 11 -34 L 11 -35 L 10 -35 M 0 -24 L 0 24 M 3 -36 L 2 -33 L 1 -24 L 1 8 L 0 24 L -1 31 L -2 34 L -3 36 L -5 38 L -7 39 L -9 39 L -11 38 L -12 36 L -12 34 L -11 33 L -10 33 L -9 34 L -9 35 L -10 36 L -11 36 M -11 34 L -11 35 L -10 35 L -10 34 L -11 34","-9 9 M 6 -39 L 3 -33 L 0 -26 L -2 -21 L -3 -17 L -4 -12 L -5 -4 L -5 4 L -4 12 L -3 17 L -2 21 L 0 26 L 3 33 L 6 39 M 3 -33 L 1 -28 L -1 -22 L -2 -18 L -3 -12 L -4 -4 L -4 4 L -3 12 L -2 18 L -1 22 L 1 28 L 3 33","-9 9 M -6 -39 L -3 -33 L 0 -26 L 2 -21 L 3 -17 L 4 -12 L 5 -4 L 5 4 L 4 12 L 3 17 L 2 21 L 0 26 L -3 33 L -6 39 M -3 -33 L -1 -28 L 1 -22 L 2 -18 L 3 -12 L 4 -4 L 4 4 L 3 12 L 2 18 L 1 22 L -1 28 L -3 33","-9 9 M -5 -39 L -5 0 L -5 39 M -4 -39 L -4 0 L -4 39 M -5 -39 L 6 -39 M -5 39 L 6 39","-9 9 M 4 -39 L 4 0 L 4 39 M 5 -39 L 5 0 L 5 39 M -6 -39 L 5 -39 M -6 39 L 5 39","-9 10 M 6 -12 L 6 9 M -7 -12 L 6 -12 M -2 -2 L 6 -2 M -7 9 L 6 9","-10 10 M -7 -9 L -6 -7 L 6 5 L 7 7 L 7 9 M -6 -6 L 6 6 M -7 -9 L -7 -7 L -6 -5 L 6 7 L 7 9 M -2 -2 L -6 2 L -7 4 L -7 6 L -6 8 L -7 9 M -7 4 L -5 8 M -6 2 L -6 4 L -5 6 L -5 8 L -7 9 M 1 1 L 6 -4 M 4 -9 L 4 -6 L 5 -4 L 7 -4 L 7 -6 L 5 -7 L 4 -9 M 4 -9 L 5 -6 L 7 -4","-13 13 M 0 -9 L -1 -8 L 0 -7 L 1 -8 L 0 -9 M -9 0 L 9 0 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-7 7 M -3 -16 L -3 16 M 3 -16 L 3 16","-12 12 M 0 -16 L 0 9 M -9 9 L 9 9","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-12 12 M 9 -16 L -9 9 L 9 9","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-13 13 M 0 -9 L -1 -8 L 0 -7 L 1 -8 L 0 -9 M -9 7 L -10 8 L -9 9 L -8 8 L -9 7 M 9 7 L 8 8 L 9 9 L 10 8 L 9 7","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3"]
meteorology = ["-8 8","-2 1 M 1 0 L 0 1 L -1 1 L -2 0 L -2 -1 L -1 -2 L 0 -2 L 1 -1 L 1 1 L 0 3 L -1 4 M -1 -1 L -1 0 L 0 0 L 0 -1 L -1 -1","-2 2 M -1 -2 L -2 -1 L -2 1 L -1 2 L 1 2 L 2 1 L 2 -1 L 1 -2 L -1 -2 M 0 -1 L -1 0 L 0 1 L 1 0 L 0 -1","-4 4 M -2 -3 L 2 3 M 2 -3 L -2 3 M -4 0 L 4 0","-5 5 M 0 -7 L -1 -5 L -3 -2 L -5 0 M 0 -7 L 1 -5 L 3 -2 L 5 0 M 0 -5 L -3 -1 M 0 -5 L 3 -1 M 0 -3 L -2 -1 M 0 -3 L 2 -1 M -1 -1 L 1 -1 M -5 0 L 5 0","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-5 5 M -5 0 L -5 -1 L -4 -3 L -3 -4 L -1 -5 L 1 -5 L 3 -4 L 4 -3 L 5 -1 L 5 0 M -2 -4 L 2 -4 M -3 -3 L 3 -3 M -4 -2 L 4 -2 M -4 -1 L 4 -1 M -5 0 L 5 0","-6 0 M -6 -12 L -6 0 L 0 0 L -6 -12 M -6 -9 L -2 -1 M -6 -6 L -3 0 M -6 -3 L -5 -1","-5 5 M 0 -7 L -1 -5 L -3 -2 L -5 0 M 0 -7 L 1 -5 L 3 -2 L 5 0","-5 5 M 5 0 L 5 -1 L 4 -3 L 3 -4 L 1 -5 L -1 -5 L -3 -4 L -4 -3 L -5 -1 L -5 0","-8 8 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-11 11 M 11 0 L 11 -2 L 10 -5 L 8 -8 L 5 -10 L 2 -11 L -2 -11 L -5 -10 L -8 -8 L -10 -5 L -11 -2 L -11 0","-4 4 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-13 13 M -9 0 L 9 0","-4 4 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-11 11 M 9 -16 L -9 16","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12","-10 10 M -4 -8 L -2 -9 L 1 -12 L 1 9","-10 10 M -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 3 -1 L -7 9 L 7 9","-10 10 M -5 -12 L 6 -12 L 0 -4 L 3 -4 L 5 -3 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 3 -12 L -7 2 L 8 2 M 3 -12 L 3 9","-10 10 M 5 -12 L -5 -12 L -6 -3 L -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5","-10 10 M 6 -9 L 5 -11 L 2 -12 L 0 -12 L -3 -11 L -5 -8 L -6 -3 L -6 2 L -5 6 L -3 8 L 0 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 L -3 -3 L -5 -1 L -6 2","-10 10 M 7 -12 L -3 9 M -7 -12 L 7 -12","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 1 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 2 L -6 0 L -4 -2 L -1 -3 L 3 -4 L 5 -5 L 6 -7 L 6 -9 L 5 -11 L 2 -12 L -2 -12","-10 10 M 6 -5 L 5 -2 L 3 0 L 0 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 0 -12 L 3 -11 L 5 -9 L 6 -5 L 6 0 L 5 5 L 3 8 L 0 9 L -2 9 L -5 8 L -6 6","-5 5 M -5 0 L -5 1 L -4 3 L -3 4 L -1 5 L 1 5 L 3 4 L 4 3 L 5 1 L 5 0","-6 6 M -6 -2 L -4 0 L -1 1 L 1 1 L 4 0 L 6 -2","0 3 M 0 3 L 2 2 L 3 0 L 2 -2 L 0 -3","0 4 M 0 0 L 3 -2 L 4 -4 L 4 -6 L 3 -7 L 2 -7","-4 0 M 0 0 L -3 -2 L -4 -4 L -4 -6 L -3 -7 L -2 -7","-9 9 M -5 -8 L -4 -7 L -5 -6 L -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 1 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 4 -3 L 0 -1 L 0 2 M 1 -12 L 3 -11 L 4 -10 L 5 -8 L 5 -6 L 4 -4 L 2 -2 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-9 9 M 0 -12 L -8 9 M 0 -12 L 8 9 M -5 2 L 5 2","-11 10 M -7 -12 L -7 9 M -7 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 2 -2 M -7 -2 L 2 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -7 9","-10 11 M 8 -7 L 7 -9 L 5 -11 L 3 -12 L -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 L -3 8 L -1 9 L 3 9 L 5 8 L 7 6 L 8 4","-11 10 M -7 -12 L -7 9 M -7 -12 L 0 -12 L 3 -11 L 5 -9 L 6 -7 L 7 -4 L 7 1 L 6 4 L 5 6 L 3 8 L 0 9 L -7 9","-10 9 M -6 -12 L -6 9 M -6 -12 L 7 -12 M -6 -2 L 2 -2 M -6 9 L 7 9","-10 8 M -6 -12 L -6 9 M -6 -12 L 7 -12 M -6 -2 L 2 -2","-10 11 M 8 -7 L 7 -9 L 5 -11 L 3 -12 L -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 L -3 8 L -1 9 L 3 9 L 5 8 L 7 6 L 8 4 L 8 1 M 3 1 L 8 1","-11 11 M -7 -12 L -7 9 M 7 -12 L 7 9 M -7 -2 L 7 -2","-4 4 M 0 -12 L 0 9","-8 8 M 4 -12 L 4 4 L 3 7 L 2 8 L 0 9 L -2 9 L -4 8 L -5 7 L -6 4 L -6 2","-11 10 M -7 -12 L -7 9 M 7 -12 L -7 2 M -2 -3 L 7 9","-10 7 M -6 -12 L -6 9 M -6 9 L 6 9","-12 12 M -8 -12 L -8 9 M -8 -12 L 0 9 M 8 -12 L 0 9 M 8 -12 L 8 9","-11 11 M -7 -12 L -7 9 M -7 -12 L 7 9 M 7 -12 L 7 9","-11 11 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -2 9 L 2 9 L 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11 L 2 -12 L -2 -12","-11 10 M -7 -12 L -7 9 M -7 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -5 L 6 -3 L 5 -2 L 2 -1 L -7 -1","-11 11 M -2 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -2 9 L 2 9 L 4 8 L 6 6 L 7 4 L 8 1 L 8 -4 L 7 -7 L 6 -9 L 4 -11 L 2 -12 L -2 -12 M 1 5 L 7 11","-11 10 M -7 -12 L -7 9 M -7 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 2 -2 L -7 -2 M 0 -2 L 7 9","-10 10 M 7 -9 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 1 L 7 3 L 7 6 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6","-8 8 M 0 -12 L 0 9 M -7 -12 L 7 -12","-11 11 M -7 -12 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 -12","-9 9 M -8 -12 L 0 9 M 8 -12 L 0 9","-12 12 M -10 -12 L -5 9 M 0 -12 L -5 9 M 0 -12 L 5 9 M 10 -12 L 5 9","-10 10 M -7 -12 L 7 9 M 7 -12 L -7 9","-9 9 M -8 -12 L 0 -2 L 0 9 M 8 -12 L 0 -2","-10 10 M 7 -12 L -7 9 M -7 -12 L 7 -12 M -7 9 L 7 9","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-10 10 M 7 -9 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 1 L 7 3 L 7 6 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6","-11 11 M 0 0 L 2 3 L 3 4 L 5 5 L 7 5 L 9 4 L 10 3 L 11 1 L 11 -1 L 10 -3 L 9 -4 L 7 -5 L 5 -5 L 3 -4 L 2 -3 L -2 3 L -3 4 L -5 5 L -7 5 L -9 4 L -10 3 L -11 1 L -11 -1 L -10 -3 L -9 -4 L -7 -5 L -5 -5 L -3 -4 L -2 -3 L 0 0","-11 11 M -9 5 L -10 4 L -11 2 L -11 -1 L -10 -3 L -9 -4 L -7 -5 L -5 -5 L -3 -4 L -2 -3 L 2 3 L 3 4 L 5 5 L 7 5 L 9 4 L 10 3 L 11 1 L 11 -2 L 10 -4 L 9 -5","-9 10 M 6 -5 L 6 9 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-10 9 M -6 -12 L -6 9 M -6 -2 L -4 -4 L -2 -5 L 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 L -2 9 L -4 8 L -6 6","-9 9 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-9 10 M 6 -12 L 6 9 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-9 9 M -6 1 L 6 1 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-5 7 M 5 -12 L 3 -12 L 1 -11 L 0 -8 L 0 9 M -3 -5 L 4 -5","-9 10 M 6 -5 L 6 11 L 5 14 L 4 15 L 2 16 L -1 16 L -3 15 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-9 10 M -5 -12 L -5 9 M -5 -1 L -2 -4 L 0 -5 L 3 -5 L 5 -4 L 6 -1 L 6 9","-4 4 M -1 -12 L 0 -11 L 1 -12 L 0 -13 L -1 -12 M 0 -5 L 0 9","-5 5 M 0 -12 L 1 -11 L 2 -12 L 1 -13 L 0 -12 M 1 -5 L 1 12 L 0 15 L -2 16 L -4 16","-9 8 M -5 -12 L -5 9 M 5 -5 L -5 5 M -1 1 L 6 9","-4 4 M 0 -12 L 0 9","-15 15 M -11 -5 L -11 9 M -11 -1 L -8 -4 L -6 -5 L -3 -5 L -1 -4 L 0 -1 L 0 9 M 0 -1 L 3 -4 L 5 -5 L 8 -5 L 10 -4 L 11 -1 L 11 9","-9 10 M -5 -5 L -5 9 M -5 -1 L -2 -4 L 0 -5 L 3 -5 L 5 -4 L 6 -1 L 6 9","-9 10 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6 L 7 3 L 7 1 L 6 -2 L 4 -4 L 2 -5 L -1 -5","-10 9 M -6 -5 L -6 16 M -6 -2 L -4 -4 L -2 -5 L 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 L -2 9 L -4 8 L -6 6","-9 10 M 6 -5 L 6 16 M 6 -2 L 4 -4 L 2 -5 L -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 L 2 9 L 4 8 L 6 6","-7 6 M -3 -5 L -3 9 M -3 1 L -2 -2 L 0 -4 L 2 -5 L 5 -5","-8 9 M 6 -2 L 5 -4 L 2 -5 L -1 -5 L -4 -4 L -5 -2 L -4 0 L -2 1 L 3 2 L 5 3 L 6 5 L 6 6 L 5 8 L 2 9 L -1 9 L -4 8 L -5 6","-5 7 M 0 -12 L 0 5 L 1 8 L 3 9 L 5 9 M -3 -5 L 4 -5","-9 10 M -5 -5 L -5 5 L -4 8 L -2 9 L 1 9 L 3 8 L 6 5 M 6 -5 L 6 9","-8 8 M -6 -5 L 0 9 M 6 -5 L 0 9","-11 11 M -8 -5 L -4 9 M 0 -5 L -4 9 M 0 -5 L 4 9 M 8 -5 L 4 9","-8 9 M -5 -5 L 6 9 M 6 -5 L -5 9","-8 8 M -6 -5 L 0 9 M 6 -5 L 0 9 L -2 13 L -4 15 L -6 16 L -7 16","-8 9 M 6 -5 L -5 9 M -5 -5 L 6 -5 M -5 9 L 6 9","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-10 10 M -7 -12 L -7 9 M -10 -12 L 9 -12 L -1 -2 L 9 8 M 8 4 L 9 7 L 10 9 M 8 4 L 8 7 M 5 7 L 8 7 M 5 7 L 8 8 L 10 9","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-7 7 M 3 -17 L 0 -16 L -2 -15 L -4 -13 L -6 -10 L -7 -6 L -7 0 L -6 3 L -4 5 L -1 6 L 1 6 L 4 5 L 6 3 L 7 0 M -7 -2 L -6 -5 L -4 -7 L -1 -8 L 1 -8 L 4 -7 L 6 -5 L 7 -2 L 7 4 L 6 8 L 4 11 L 2 13 L 0 14 L -3 15","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3"]
music = ["-8 8","-5 5 M 0 -12 L -1 -10 L 0 2 L 1 -10 L 0 -12 M 0 -10 L 0 -4 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-8 8 M -5 -2 L -1 0 L 2 2 L 4 4 L 5 7 L 5 9 L 4 11 L 3 12 M -5 -1 L 1 2 M -5 0 L -2 1 L 2 3 L 4 5 L 5 7","-8 8 M 5 -7 L 4 -5 L 2 -3 L -2 -1 L -5 0 M 1 -2 L -5 1 M 3 -12 L 4 -11 L 5 -9 L 5 -7 L 4 -4 L 2 -2 L -1 0 L -5 2","-10 10 M 1 -5 L -3 -4 L -6 -2 L -7 0 L -7 2 L -6 4 L -4 5 L -1 5 L 3 4 L 6 2 L 7 0 L 7 -2 L 6 -4 L 4 -5 L 1 -5 M 6 -4 L 1 -5 M 4 -5 L -1 -4 L -6 -2 M -3 -4 L -7 0 M -6 4 L -1 5 M -4 5 L 1 4 L 6 2 M 3 4 L 7 0","-10 10 M 1 -5 L -3 -4 L -6 -2 L -7 0 L -7 2 L -6 4 L -4 5 L -1 5 L 3 4 L 6 2 L 7 0 L 7 -2 L 6 -4 L 4 -5 L 1 -5 M 6 -4 L 1 -5 M 4 -5 L -1 -4 L -6 -2 M -3 -4 L -7 0 M -6 4 L -1 5 M -4 5 L 1 4 L 6 2 M 3 4 L 7 0","-8 9 M 1 -5 L -2 -4 L -4 -2 L -5 0 L -5 2 L -4 4 L -2 5 L 0 5 L 3 4 L 5 2 L 6 0 L 6 -2 L 5 -4 L 3 -5 L 1 -5 M -3 -2 L 3 -5 M -4 0 L 4 -4 M -5 2 L 5 -3 M -4 3 L 6 -2 M -3 4 L 5 0 M -2 5 L 4 2","-8 8 M -3 -11 L -3 12 M 3 -12 L 3 11 M -5 -4 L 5 -6 M -5 -3 L 5 -5 M -5 5 L 5 3 M -5 6 L 5 4","-8 8 M -4 -12 L -4 6 M 4 -6 L 4 12 M -4 -4 L 4 -6 M -4 -3 L 4 -5 M -4 5 L 4 3 M -4 6 L 4 4","-8 8 M -4 -16 L -4 5 M -4 -4 L -1 -6 L 2 -6 L 4 -5 L 5 -3 L 5 -1 L 4 1 L 1 3 L -1 4 L -4 5 M -4 -4 L -1 -5 L 2 -5 L 4 -4 M 3 -5 L 4 -3 L 4 -1 L 3 1 L 1 3","-13 13 M -10 -9 L -10 -6 M 10 -9 L 10 -6 M -10 -9 L 10 -9 M -10 -8 L 10 -8 M -10 -7 L 10 -7 M -10 -6 L 10 -6","-8 8 M -5 -4 L -5 -1 M 5 -4 L 5 -1 M -5 -4 L 5 -4 M -5 -3 L 5 -3 M -5 -2 L 5 -2 M -5 -1 L 5 -1","-8 8 M -5 -6 L 5 6 M -5 -6 L -3 -4 L -1 -3 L 2 -3 L 4 -4 L 5 -5 L 5 -7 L 3 -7 L 3 -5 L 2 -3 M -3 -4 L 2 -3 M -1 -3 L 5 -5 M 4 -7 L 4 -4 M 3 -6 L 5 -6 M 5 6 L 3 4 L 1 3 L -2 3 L -4 4 L -5 5 L -5 7 L -3 7 L -3 5 L -2 3 M 3 4 L -2 3 M 1 3 L -5 5 M -4 4 L -4 7 M -5 6 L -3 6","-8 8 M -2 -3 L -3 -5 L -3 -7 L -5 -7 L -5 -5 L -4 -4 L -2 -3 L 1 -3 L 3 -4 L 5 -6 M -4 -7 L -4 -4 M -5 -6 L -3 -6 M -5 -5 L 1 -3 M -2 -3 L 3 -4 M 5 -6 L 5 7","-8 8 M -1 -15 L 4 -5 L 0 2 L 0 3 M 3 -6 L -1 1 M 2 -9 L 2 -7 L -2 0 L 0 3 L 3 7 M 5 10 L 3 7 L 1 6 L -1 6 L -3 7 L -4 9 L -4 11 L -3 13 L 0 15 M 5 10 L 3 8 L 1 7 L -3 7 L -3 11 L -2 13 L 0 15 M 1 6 L -2 8 L -4 11","-13 20 M -4 1 L -3 3 L -1 4 L 1 4 L 3 3 L 4 1 L 4 -1 L 3 -3 L 1 -4 L -1 -4 L -3 -3 L -4 -2 L -5 1 L -5 4 L -4 7 L -2 9 L 1 10 L 4 10 L 7 9 L 9 7 L 10 5 L 11 2 L 11 -2 L 10 -5 L 8 -8 L 6 -9 L 3 -10 L 0 -10 L -3 -9 L -5 -8 L -7 -6 L -9 -3 L -10 1 L -10 6 L -9 11 L -7 15 L -5 17 L -2 19 L 2 20 L 7 20 L 11 19 L 14 17 L 16 15 M -7 -6 L -8 -4 L -9 0 L -9 6 L -8 10 L -6 14 L -4 16 L -1 18 L 3 19 L 7 19 L 11 18 L 13 17 L 16 15 M -2 -3 L 2 -3 M -3 -2 L 3 -2 M -4 -1 L 4 -1 M -4 0 L 4 0 M -4 1 L 4 1 M -3 2 L 3 2 M -2 3 L 2 3 M 15 -6 L 15 -4 L 17 -4 L 17 -6 L 15 -6 M 16 -6 L 16 -4 M 15 -5 L 17 -5 M 15 4 L 15 6 L 17 6 L 17 4 L 15 4 M 16 4 L 16 6 M 15 5 L 17 5","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12 M -1 -12 L -3 -11 L -4 -10 L -5 -8 L -6 -3 L -6 0 L -5 5 L -4 7 L -3 8 L -1 9 M 1 9 L 3 8 L 4 7 L 5 5 L 6 0 L 6 -3 L 5 -8 L 4 -10 L 3 -11 L 1 -12","-10 10 M -4 -8 L -2 -9 L 1 -12 L 1 9 M 0 -11 L 0 9 M -4 9 L 5 9","-10 10 M -6 -8 L -5 -7 L -6 -6 L -7 -7 L -7 -8 L -6 -10 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 3 -2 L -2 0 L -4 1 L -6 3 L -7 6 L -7 9 M 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 2 -2 L -2 0 M -7 7 L -6 6 L -4 6 L 1 8 L 4 8 L 6 7 L 7 6 M -4 6 L 1 9 L 5 9 L 6 8 L 7 6 L 7 4","-10 10 M -6 -8 L -5 -7 L -6 -6 L -7 -7 L -7 -8 L -6 -10 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -9 L 6 -6 L 5 -4 L 2 -3 L -1 -3 M 2 -12 L 4 -11 L 5 -9 L 5 -6 L 4 -4 L 2 -3 M 2 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 4 L -6 5 M 5 -1 L 6 2 L 6 5 L 5 7 L 4 8 L 2 9","-10 10 M 2 -10 L 2 9 M 3 -12 L 3 9 M 3 -12 L -8 3 L 8 3 M -1 9 L 6 9","-10 10 M -5 -12 L -7 -2 M -7 -2 L -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 4 L -6 5 M 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 M -5 -12 L 5 -12 M -5 -11 L 0 -11 L 5 -12","-10 10 M 5 -9 L 4 -8 L 5 -7 L 6 -8 L 6 -9 L 5 -11 L 3 -12 L 0 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -3 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 L -3 -3 L -5 -1 L -6 2 M 0 -12 L -2 -11 L -4 -9 L -5 -7 L -6 -3 L -6 3 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 3 L 6 2 L 5 -1 L 3 -3 L 1 -4","-10 10 M -7 -12 L -7 -6 M -7 -8 L -6 -10 L -4 -12 L -2 -12 L 3 -9 L 5 -9 L 6 -10 L 7 -12 M -6 -10 L -4 -11 L -2 -11 L 3 -9 M 7 -12 L 7 -9 L 6 -6 L 2 -1 L 1 1 L 0 4 L 0 9 M 6 -6 L 1 -1 L 0 1 L -1 4 L -1 9","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -6 L -5 -4 L -2 -3 L 2 -3 L 5 -4 L 6 -6 L 6 -9 L 5 -11 L 2 -12 L -2 -12 M -2 -12 L -4 -11 L -5 -9 L -5 -6 L -4 -4 L -2 -3 M 2 -3 L 4 -4 L 5 -6 L 5 -9 L 4 -11 L 2 -12 M -2 -3 L -5 -2 L -6 -1 L -7 1 L -7 5 L -6 7 L -5 8 L -2 9 L 2 9 L 5 8 L 6 7 L 7 5 L 7 1 L 6 -1 L 5 -2 L 2 -3 M -2 -3 L -4 -2 L -5 -1 L -6 1 L -6 5 L -5 7 L -4 8 L -2 9 M 2 9 L 4 8 L 5 7 L 6 5 L 6 1 L 5 -1 L 4 -2 L 2 -3","-10 10 M 6 -5 L 5 -2 L 3 0 L 0 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -6 L 7 0 L 6 4 L 5 6 L 3 8 L 0 9 L -3 9 L -5 8 L -6 6 L -6 5 L -5 4 L -4 5 L -5 6 M -1 1 L -3 0 L -5 -2 L -6 -5 L -6 -6 L -5 -9 L -3 -11 L -1 -12 M 1 -12 L 3 -11 L 5 -9 L 6 -6 L 6 0 L 5 4 L 4 6 L 2 8 L 0 9","-5 5 M 0 -5 L -1 -4 L 0 -3 L 1 -4 L 0 -5 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-17 12 M -11 20 L -10 20 L -9 19 L -9 18 L -10 17 L -11 17 L -12 18 L -12 20 L -11 22 L -9 23 L -7 23 L -4 22 L -2 20 L -1 18 L 0 14 L 0 3 L -1 -23 L -1 -30 L 0 -35 L 1 -37 L 3 -38 L 4 -38 L 6 -37 L 7 -35 L 7 -31 L 6 -28 L 5 -26 L 3 -23 L -2 -19 L -8 -15 L -10 -13 L -12 -10 L -13 -8 L -14 -4 L -14 0 L -13 4 L -11 7 L -8 9 L -4 10 L 0 10 L 4 9 L 6 8 L 8 5 L 9 2 L 9 -2 L 8 -5 L 7 -7 L 5 -9 L 2 -10 L -2 -10 L -5 -9 L -7 -7 L -8 -4 L -8 0 L -7 3 L -5 5 M -11 18 L -11 19 L -10 19 L -10 18 L -11 18 M 3 -23 L -1 -19 L -6 -15 L -9 -12 L -11 -9 L -12 -7 L -13 -4 L -13 0 L -12 4 L -11 6 L -8 9 M 0 10 L 3 9 L 5 8 L 7 5 L 8 2 L 8 -2 L 7 -5 L 6 -7 L 4 -9 L 2 -10","-13 20 M -4 1 L -3 3 L -1 4 L 1 4 L 3 3 L 4 1 L 4 -1 L 3 -3 L 1 -4 L -1 -4 L -3 -3 L -4 -2 L -5 1 L -5 4 L -4 7 L -2 9 L 1 10 L 4 10 L 7 9 L 9 7 L 10 5 L 11 2 L 11 -2 L 10 -5 L 8 -8 L 6 -9 L 3 -10 L 0 -10 L -3 -9 L -5 -8 L -7 -6 L -9 -3 L -10 1 L -10 6 L -9 11 L -7 15 L -5 17 L -2 19 L 2 20 L 7 20 L 11 19 L 14 17 L 16 15 M -7 -6 L -8 -4 L -9 0 L -9 6 L -8 10 L -6 14 L -4 16 L -1 18 L 3 19 L 7 19 L 11 18 L 13 17 L 16 15 M -2 -3 L 2 -3 M -3 -2 L 3 -2 M -4 -1 L 4 -1 M -4 0 L 4 0 M -4 1 L 4 1 M -3 2 L 3 2 M -2 3 L 2 3 M 15 -6 L 15 -4 L 17 -4 L 17 -6 L 15 -6 M 16 -6 L 16 -4 M 15 -5 L 17 -5 M 15 4 L 15 6 L 17 6 L 17 4 L 15 4 M 16 4 L 16 6 M 15 5 L 17 5","-9 24 M -4 -1 L -3 -3 L -1 -4 L 1 -4 L 3 -3 L 4 -1 L 4 1 L 3 3 L 1 4 L -1 4 L -3 3 L -4 2 L -5 -1 L -5 -4 L -4 -7 L -2 -9 L 1 -10 L 5 -10 L 9 -9 L 12 -7 L 14 -4 L 15 0 L 15 5 L 14 9 L 13 11 L 11 14 L 8 17 L 4 20 L -1 23 L -5 25 M 5 -10 L 8 -9 L 11 -7 L 13 -4 L 14 0 L 14 5 L 13 9 L 12 11 L 10 14 L 7 17 L 2 21 L -1 23 M -2 -3 L 2 -3 M -3 -2 L 3 -2 M -4 -1 L 4 -1 M -4 0 L 4 0 M -4 1 L 4 1 M -3 2 L 3 2 M -2 3 L 2 3 M 19 -6 L 19 -4 L 21 -4 L 21 -6 L 19 -6 M 20 -6 L 20 -4 M 19 -5 L 21 -5 M 19 4 L 19 6 L 21 6 L 21 4 L 19 4 M 20 4 L 20 6 M 19 5 L 21 5","-14 14 M -10 -18 L -10 18 M -5 -18 L -5 18 M 5 -18 L 5 18 M 10 -18 L 10 18 M -5 -5 L 5 -7 M -5 -4 L 5 -6 M -5 -3 L 5 -5 M -5 5 L 5 3 M -5 6 L 5 4 M -5 7 L 5 5","-14 14 M -10 -20 L -10 20 M -9 -20 L -9 20 M -5 -20 L -5 20 M -1 -16 L 1 -16 L 1 -14 L -1 -14 L -1 -17 L 0 -19 L 2 -20 L 5 -20 L 7 -19 L 9 -17 L 10 -14 L 10 -9 L 9 -6 L 7 -4 L 5 -3 L 3 -3 L 1 -4 L 0 -6 L -1 -4 L -3 -1 L -4 0 L -3 1 L -1 4 L 0 6 L 1 4 L 3 3 L 5 3 L 7 4 L 9 6 L 10 9 L 10 14 L 9 17 L 7 19 L 5 20 L 2 20 L 0 19 L -1 17 L -1 14 L 1 14 L 1 16 L -1 16 M 0 -16 L 0 -14 M -1 -15 L 1 -15 M 7 -19 L 8 -17 L 9 -14 L 9 -9 L 8 -6 L 7 -4 M 0 -6 L 0 -4 L -2 -1 L -4 0 L -2 1 L 0 4 L 0 6 M 7 4 L 8 6 L 9 9 L 9 14 L 8 17 L 7 19 M 0 14 L 0 16 M -1 15 L 1 15","-8 8 M -5 -4 L -5 -1 M 5 -4 L 5 -1 M -5 -4 L 5 -4 M -5 -3 L 5 -3 M -5 -2 L 5 -2 M -5 -1 L 5 -1","-10 10 M 3 -12 L -10 9 M 3 -12 L 4 9 M 2 -10 L 3 9 M -6 3 L 3 3 M -12 9 L -6 9 M 0 9 L 6 9","-12 12 M -3 -12 L -9 9 M -2 -12 L -8 9 M -6 -12 L 5 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -4 L 7 -3 L 4 -2 M 5 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -4 L 6 -3 L 4 -2 M -5 -2 L 4 -2 L 6 -1 L 7 1 L 7 3 L 6 6 L 4 8 L 0 9 L -12 9 M 4 -2 L 5 -1 L 6 1 L 6 3 L 5 6 L 3 8 L 0 9","-10 11 M 8 -10 L 9 -10 L 10 -12 L 9 -6 L 9 -8 L 8 -10 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -2 9 L 1 9 L 3 8 L 5 6 L 6 4 M 2 -12 L 0 -11 L -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 4 L -5 7 L -4 8 L -2 9","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M -6 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -7 L 8 -3 L 7 1 L 5 5 L 3 7 L 1 8 L -3 9 L -12 9 M 3 -12 L 5 -11 L 6 -10 L 7 -7 L 7 -3 L 6 1 L 4 5 L 2 7 L 0 8 L -3 9","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M 2 -6 L 0 2 M -6 -12 L 9 -12 L 8 -6 L 8 -12 M -5 -2 L 1 -2 M -12 9 L 3 9 L 5 4 L 2 9","-12 10 M -3 -12 L -9 9 M -2 -12 L -8 9 M 2 -6 L 0 2 M -6 -12 L 9 -12 L 8 -6 L 8 -12 M -5 -2 L 1 -2 M -12 9 L -5 9","-10 12 M 8 -10 L 9 -10 L 10 -12 L 9 -6 L 9 -8 L 8 -10 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -2 9 L 0 9 L 3 8 L 5 6 L 7 2 M 2 -12 L 0 -11 L -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 4 L -5 7 L -4 8 L -2 9 M 0 9 L 2 8 L 4 6 L 6 2 M 3 2 L 10 2","-13 13 M -4 -12 L -10 9 M -3 -12 L -9 9 M 9 -12 L 3 9 M 10 -12 L 4 9 M -7 -12 L 0 -12 M 6 -12 L 13 -12 M -6 -2 L 6 -2 M -13 9 L -6 9 M 0 9 L 7 9","-6 7 M 3 -12 L -3 9 M 4 -12 L -2 9 M 0 -12 L 7 -12 M -6 9 L 1 9","-9 9 M 6 -12 L 1 5 L 0 7 L -1 8 L -3 9 L -5 9 L -7 8 L -8 6 L -8 4 L -7 3 L -6 4 L -7 5 M 5 -12 L 0 5 L -1 7 L -3 9 M 2 -12 L 9 -12","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M 11 -12 L -6 1 M 1 -3 L 5 9 M 0 -3 L 4 9 M -6 -12 L 1 -12 M 7 -12 L 13 -12 M -12 9 L -5 9 M 1 9 L 7 9","-10 10 M -1 -12 L -7 9 M 0 -12 L -6 9 M -4 -12 L 3 -12 M -10 9 L 5 9 L 7 3 L 4 9","-13 14 M -4 -12 L -10 9 M -4 -12 L -3 9 M -3 -12 L -2 7 M 10 -12 L -3 9 M 10 -12 L 4 9 M 11 -12 L 5 9 M -7 -12 L -3 -12 M 10 -12 L 14 -12 M -13 9 L -7 9 M 1 9 L 8 9","-12 13 M -3 -12 L -9 9 M -3 -12 L 4 6 M -3 -9 L 4 9 M 10 -12 L 4 9 M -6 -12 L -3 -12 M 7 -12 L 13 -12 M -12 9 L -6 9","-11 11 M 1 -12 L -2 -11 L -4 -9 L -6 -6 L -7 -3 L -8 1 L -8 4 L -7 7 L -6 8 L -4 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 8 -4 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 1 -12 M 1 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -4 9 M -1 9 L 1 8 L 3 6 L 5 3 L 6 0 L 7 -4 L 7 -7 L 6 -10 L 4 -12","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M -6 -12 L 6 -12 L 9 -11 L 10 -9 L 10 -7 L 9 -4 L 7 -2 L 3 -1 L -5 -1 M 6 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -4 L 6 -2 L 3 -1 M -12 9 L -5 9","-11 11 M 1 -12 L -2 -11 L -4 -9 L -6 -6 L -7 -3 L -8 1 L -8 4 L -7 7 L -6 8 L -4 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 8 -4 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 1 -12 M 1 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -4 9 M -1 9 L 1 8 L 3 6 L 5 3 L 6 0 L 7 -4 L 7 -7 L 6 -10 L 4 -12 M -6 7 L -6 6 L -5 4 L -3 3 L -2 3 L 0 4 L 1 6 L 1 13 L 2 14 L 4 14 L 5 12 L 5 11 M 1 6 L 2 12 L 3 13 L 4 13 L 5 12","-12 12 M -3 -12 L -9 9 M -2 -12 L -8 9 M -6 -12 L 5 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -4 L 7 -3 L 4 -2 L -5 -2 M 5 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -4 L 6 -3 L 4 -2 M 0 -2 L 2 -1 L 3 0 L 4 8 L 5 9 L 7 9 L 8 7 L 8 6 M 3 0 L 5 7 L 6 8 L 7 8 L 8 7 M -12 9 L -5 9","-11 12 M 8 -10 L 9 -10 L 10 -12 L 9 -6 L 9 -8 L 8 -10 L 7 -11 L 4 -12 L 0 -12 L -3 -11 L -5 -9 L -5 -7 L -4 -5 L -3 -4 L 4 0 L 6 2 M -5 -7 L -3 -5 L 4 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 4 8 L 1 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 3 L -9 9 L -8 7 L -7 7","-10 11 M 3 -12 L -3 9 M 4 -12 L -2 9 M -3 -12 L -6 -6 L -4 -12 L 11 -12 L 10 -6 L 10 -12 M -6 9 L 1 9","-12 13 M -4 -12 L -7 -1 L -8 3 L -8 6 L -7 8 L -4 9 L 0 9 L 3 8 L 5 6 L 6 3 L 10 -12 M -3 -12 L -6 -1 L -7 3 L -7 6 L -6 8 L -4 9 M -7 -12 L 0 -12 M 7 -12 L 13 -12","-10 10 M -4 -12 L -3 9 M -3 -12 L -2 7 M 10 -12 L -3 9 M -6 -12 L 0 -12 M 6 -12 L 12 -12","-13 13 M -5 -12 L -7 9 M -4 -12 L -6 7 M 3 -12 L -7 9 M 3 -12 L 1 9 M 4 -12 L 2 7 M 11 -12 L 1 9 M -8 -12 L -1 -12 M 8 -12 L 14 -12","-11 11 M -4 -12 L 3 9 M -3 -12 L 4 9 M 10 -12 L -10 9 M -6 -12 L 0 -12 M 6 -12 L 12 -12 M -12 9 L -6 9 M 0 9 L 6 9","-10 11 M -4 -12 L 0 -2 L -3 9 M -3 -12 L 1 -2 L -2 9 M 11 -12 L 1 -2 M -6 -12 L 0 -12 M 7 -12 L 13 -12 M -6 9 L 1 9","-11 11 M 9 -12 L -10 9 M 10 -12 L -9 9 M -3 -12 L -6 -6 L -4 -12 L 10 -12 M -10 9 L 4 9 L 6 3 L 3 9","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-6 6 M 2 -12 L -3 -6 M 2 -12 L 3 -11 L -3 -6","-13 13 M -9 0 L 9 0","-6 6 M -2 -12 L 3 -6 M -2 -12 L -3 -11 L 3 -6","-10 11 M 6 -5 L 4 2 L 3 6 L 3 8 L 4 9 L 7 9 L 9 7 L 10 5 M 7 -5 L 5 2 L 4 6 L 4 8 L 5 9 M 4 2 L 4 -1 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 5 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 3 5 L 4 2 M -1 -5 L -3 -4 L -5 -1 L -6 2 L -6 6 L -5 8","-10 9 M -2 -12 L -6 1 L -6 4 L -5 7 L -4 8 M -1 -12 L -5 1 M -5 1 L -4 -2 L -2 -4 L 0 -5 L 2 -5 L 4 -4 L 5 -3 L 6 -1 L 6 2 L 5 5 L 3 8 L 0 9 L -2 9 L -4 8 L -5 5 L -5 1 M 4 -4 L 5 -2 L 5 2 L 4 5 L 2 8 L 0 9 M -5 -12 L -1 -12","-9 9 M 5 -2 L 5 -1 L 6 -1 L 6 -2 L 5 -4 L 3 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 5 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 5 M 0 -5 L -2 -4 L -4 -1 L -5 2 L -5 6 L -4 8","-10 11 M 8 -12 L 4 2 L 3 6 L 3 8 L 4 9 L 7 9 L 9 7 L 10 5 M 9 -12 L 5 2 L 4 6 L 4 8 L 5 9 M 4 2 L 4 -1 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 5 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 3 5 L 4 2 M -1 -5 L -3 -4 L -5 -1 L -6 2 L -6 6 L -5 8 M 5 -12 L 9 -12","-9 9 M -5 4 L -1 3 L 2 2 L 5 0 L 6 -2 L 5 -4 L 3 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 5 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 6 M 0 -5 L -2 -4 L -4 -1 L -5 2 L -5 6 L -4 8","-7 8 M 8 -11 L 7 -10 L 8 -9 L 9 -10 L 9 -11 L 8 -12 L 6 -12 L 4 -11 L 3 -10 L 2 -8 L 1 -5 L -2 9 L -3 13 L -4 15 M 6 -12 L 4 -10 L 3 -8 L 2 -4 L 0 5 L -1 9 L -2 12 L -3 14 L -4 15 L -6 16 L -8 16 L -9 15 L -9 14 L -8 13 L -7 14 L -8 15 M -3 -5 L 7 -5","-10 10 M 7 -5 L 3 9 L 2 12 L 0 15 L -3 16 L -6 16 L -8 15 L -9 14 L -9 13 L -8 12 L -7 13 L -8 14 M 6 -5 L 2 9 L 1 12 L -1 15 L -3 16 M 4 2 L 4 -1 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 5 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 3 5 L 4 2 M -1 -5 L -3 -4 L -5 -1 L -6 2 L -6 6 L -5 8","-10 11 M -2 -12 L -8 9 M -1 -12 L -7 9 M -5 2 L -3 -2 L -1 -4 L 1 -5 L 3 -5 L 5 -4 L 6 -3 L 6 -1 L 4 5 L 4 8 L 5 9 M 3 -5 L 5 -3 L 5 -1 L 3 5 L 3 8 L 4 9 L 7 9 L 9 7 L 10 5 M -5 -12 L -1 -12","-6 7 M 3 -12 L 2 -11 L 3 -10 L 4 -11 L 3 -12 M -5 -1 L -4 -3 L -2 -5 L 1 -5 L 2 -4 L 2 -1 L 0 5 L 0 8 L 1 9 M 0 -5 L 1 -4 L 1 -1 L -1 5 L -1 8 L 0 9 L 3 9 L 5 7 L 6 5","-6 7 M 4 -12 L 3 -11 L 4 -10 L 5 -11 L 4 -12 M -4 -1 L -3 -3 L -1 -5 L 2 -5 L 3 -4 L 3 -1 L 0 9 L -1 12 L -2 14 L -3 15 L -5 16 L -7 16 L -8 15 L -8 14 L -7 13 L -6 14 L -7 15 M 1 -5 L 2 -4 L 2 -1 L -1 9 L -2 12 L -3 14 L -5 16","-10 10 M -2 -12 L -8 9 M -1 -12 L -7 9 M 6 -4 L 5 -3 L 6 -2 L 7 -3 L 7 -4 L 6 -5 L 5 -5 L 3 -4 L -1 0 L -3 1 L -5 1 M -3 1 L -1 2 L 1 8 L 2 9 M -3 1 L -2 2 L 0 8 L 1 9 L 3 9 L 5 8 L 7 5 M -5 -12 L -1 -12","-5 7 M 3 -12 L -1 2 L -2 6 L -2 8 L -1 9 L 2 9 L 4 7 L 5 5 M 4 -12 L 0 2 L -1 6 L -1 8 L 0 9 M 0 -12 L 4 -12","-17 16 M -16 -1 L -15 -3 L -13 -5 L -10 -5 L -9 -4 L -9 -2 L -10 2 L -12 9 M -11 -5 L -10 -4 L -10 -2 L -11 2 L -13 9 M -10 2 L -8 -2 L -6 -4 L -4 -5 L -2 -5 L 0 -4 L 1 -3 L 1 -1 L -2 9 M -2 -5 L 0 -3 L 0 -1 L -3 9 M 0 2 L 2 -2 L 4 -4 L 6 -5 L 8 -5 L 10 -4 L 11 -3 L 11 -1 L 9 5 L 9 8 L 10 9 M 8 -5 L 10 -3 L 10 -1 L 8 5 L 8 8 L 9 9 L 12 9 L 14 7 L 15 5","-12 11 M -11 -1 L -10 -3 L -8 -5 L -5 -5 L -4 -4 L -4 -2 L -5 2 L -7 9 M -6 -5 L -5 -4 L -5 -2 L -6 2 L -8 9 M -5 2 L -3 -2 L -1 -4 L 1 -5 L 3 -5 L 5 -4 L 6 -3 L 6 -1 L 4 5 L 4 8 L 5 9 M 3 -5 L 5 -3 L 5 -1 L 3 5 L 3 8 L 4 9 L 7 9 L 9 7 L 10 5","-9 9 M 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 5 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 5 L 6 2 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L 0 -5 M 0 -5 L -2 -4 L -4 -1 L -5 2 L -5 6 L -4 8 M 0 9 L 2 8 L 4 5 L 5 2 L 5 -2 L 4 -4","-11 10 M -10 -1 L -9 -3 L -7 -5 L -4 -5 L -3 -4 L -3 -2 L -4 2 L -8 16 M -5 -5 L -4 -4 L -4 -2 L -5 2 L -9 16 M -4 2 L -3 -1 L -1 -4 L 1 -5 L 3 -5 L 5 -4 L 6 -3 L 7 -1 L 7 2 L 6 5 L 4 8 L 1 9 L -1 9 L -3 8 L -4 5 L -4 2 M 5 -4 L 6 -2 L 6 2 L 5 5 L 3 8 L 1 9 M -12 16 L -5 16","-10 10 M 6 -5 L 0 16 M 7 -5 L 1 16 M 4 2 L 4 -1 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 5 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 3 5 L 4 2 M -1 -5 L -3 -4 L -5 -1 L -6 2 L -6 6 L -5 8 M -3 16 L 4 16","-9 8 M -8 -1 L -7 -3 L -5 -5 L -2 -5 L -1 -4 L -1 -2 L -2 2 L -4 9 M -3 -5 L -2 -4 L -2 -2 L -3 2 L -5 9 M -2 2 L 0 -2 L 2 -4 L 4 -5 L 6 -5 L 7 -4 L 7 -3 L 6 -2 L 5 -3 L 6 -4","-8 9 M 6 -3 L 6 -2 L 7 -2 L 7 -3 L 6 -4 L 3 -5 L 0 -5 L -3 -4 L -4 -3 L -4 -1 L -3 0 L 4 4 L 5 5 M -4 -2 L -3 -1 L 4 3 L 5 4 L 5 7 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -6 6 L -5 6 L -5 7","-7 7 M 2 -12 L -2 2 L -3 6 L -3 8 L -2 9 L 1 9 L 3 7 L 4 5 M 3 -12 L -1 2 L -2 6 L -2 8 L -1 9 M -4 -5 L 5 -5","-12 11 M -11 -1 L -10 -3 L -8 -5 L -5 -5 L -4 -4 L -4 -1 L -6 5 L -6 7 L -4 9 M -6 -5 L -5 -4 L -5 -1 L -7 5 L -7 7 L -6 8 L -4 9 L -2 9 L 0 8 L 2 6 L 4 2 M 6 -5 L 4 2 L 3 6 L 3 8 L 4 9 L 7 9 L 9 7 L 10 5 M 7 -5 L 5 2 L 4 6 L 4 8 L 5 9","-10 10 M -9 -1 L -8 -3 L -6 -5 L -3 -5 L -2 -4 L -2 -1 L -4 5 L -4 7 L -2 9 M -4 -5 L -3 -4 L -3 -1 L -5 5 L -5 7 L -4 8 L -2 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 -1 L 7 -5 L 6 -5 L 7 -3","-15 14 M -14 -1 L -13 -3 L -11 -5 L -8 -5 L -7 -4 L -7 -1 L -9 5 L -9 7 L -7 9 M -9 -5 L -8 -4 L -8 -1 L -10 5 L -10 7 L -9 8 L -7 9 L -5 9 L -3 8 L -1 6 L 0 4 M 2 -5 L 0 4 L 0 7 L 1 8 L 3 9 L 5 9 L 7 8 L 9 6 L 10 4 L 11 0 L 11 -5 L 10 -5 L 11 -3 M 3 -5 L 1 4 L 1 7 L 3 9","-10 10 M -7 -1 L -5 -4 L -3 -5 L 0 -5 L 1 -3 L 1 0 M -1 -5 L 0 -3 L 0 0 L -1 4 L -2 6 L -4 8 L -6 9 L -7 9 L -8 8 L -8 7 L -7 6 L -6 7 L -7 8 M -1 4 L -1 7 L 0 9 L 3 9 L 5 8 L 7 5 M 7 -4 L 6 -3 L 7 -2 L 8 -3 L 8 -4 L 7 -5 L 6 -5 L 4 -4 L 2 -2 L 1 0 L 0 4 L 0 7 L 1 9","-11 10 M -10 -1 L -9 -3 L -7 -5 L -4 -5 L -3 -4 L -3 -1 L -5 5 L -5 7 L -3 9 M -5 -5 L -4 -4 L -4 -1 L -6 5 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 3 6 L 5 2 M 8 -5 L 4 9 L 3 12 L 1 15 L -2 16 L -5 16 L -7 15 L -8 14 L -8 13 L -7 12 L -6 13 L -7 14 M 7 -5 L 3 9 L 2 12 L 0 15 L -2 16","-10 10 M 7 -5 L 6 -3 L 4 -1 L -4 5 L -6 7 L -7 9 M -6 -1 L -5 -3 L -3 -5 L 0 -5 L 4 -3 M -5 -3 L -3 -4 L 0 -4 L 4 -3 L 6 -3 M -6 7 L -4 7 L 0 8 L 3 8 L 5 7 M -4 7 L 0 9 L 3 9 L 5 7 L 6 5","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
scriptc = ["-8 8","-5 6 M 3 -12 L 2 -11 L 0 1 M 3 -11 L 0 1 M 3 -12 L 4 -11 L 0 1 M -2 7 L -3 8 L -2 9 L -1 8 L -2 7","-9 9 M -2 -12 L -4 -5 M -1 -12 L -4 -5 M 7 -12 L 5 -5 M 8 -12 L 5 -5","-10 11 M 1 -12 L -6 16 M 7 -12 L 0 16 M -6 -1 L 8 -1 M -7 5 L 7 5","-10 11 M 2 -16 L -6 13 M 7 -16 L -1 13 M 8 -8 L 7 -7 L 8 -6 L 9 -7 L 9 -8 L 8 -10 L 7 -11 L 4 -12 L 0 -12 L -3 -11 L -5 -9 L -5 -7 L -4 -5 L -3 -4 L 4 0 L 6 2 M -5 -7 L -3 -5 L 4 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 4 8 L 1 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 4 L -7 3 L -6 4 L -7 5","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-13 13 M 10 -4 L 9 -3 L 10 -2 L 11 -3 L 11 -4 L 10 -5 L 9 -5 L 7 -4 L 5 -2 L 0 6 L -2 8 L -4 9 L -7 9 L -10 8 L -11 6 L -11 4 L -10 2 L -9 1 L -7 0 L -2 -2 L 0 -3 L 2 -5 L 3 -7 L 3 -9 L 2 -11 L 0 -12 L -2 -11 L -3 -9 L -3 -6 L -2 0 L -1 3 L 1 6 L 3 8 L 5 9 L 7 9 L 8 7 L 8 6 M -7 9 L -9 8 L -10 6 L -10 4 L -9 2 L -8 1 L -2 -2 M -3 -6 L -2 -1 L -1 2 L 1 5 L 3 7 L 5 8 L 7 8 L 8 7","-5 6 M 3 -10 L 2 -11 L 3 -12 L 4 -11 L 4 -10 L 3 -8 L 1 -6","-7 8 M 8 -16 L 4 -13 L 1 -10 L -1 -7 L -3 -3 L -4 2 L -4 6 L -3 11 L -2 14 L -1 16 M 4 -13 L 1 -9 L -1 -5 L -2 -2 L -3 3 L -3 8 L -2 13 L -1 16","-8 7 M 1 -16 L 2 -14 L 3 -11 L 4 -6 L 4 -2 L 3 3 L 1 7 L -1 10 L -4 13 L -8 16 M 1 -16 L 2 -13 L 3 -8 L 3 -3 L 2 2 L 1 5 L -1 9 L -4 13","-8 9 M 2 -12 L 2 0 M -3 -9 L 7 -3 M 7 -9 L -3 -3","-13 13 M 0 -9 L 0 9 M -9 0 L 9 0","-5 6 M -2 9 L -3 8 L -2 7 L -1 8 L -1 9 L -2 11 L -4 13","-13 13 M -9 0 L 9 0","-5 6 M -2 7 L -3 8 L -2 9 L -1 8 L -2 7","-11 11 M 13 -16 L -13 16","-10 11 M 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 8 -4 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 2 -12 M 2 -12 L 0 -11 L -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 4 L -5 7 L -3 9 M -1 9 L 1 8 L 3 6 L 5 3 L 6 0 L 7 -4 L 7 -7 L 6 -10 L 4 -12","-10 11 M 2 -8 L -3 9 M 4 -12 L -2 9 M 4 -12 L 1 -9 L -2 -7 L -4 -6 M 3 -9 L -1 -7 L -4 -6","-10 11 M -3 -8 L -2 -7 L -3 -6 L -4 -7 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 4 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 5 -3 L 2 -1 L -2 1 L -5 3 L -7 5 L -9 9 M 4 -12 L 6 -11 L 7 -9 L 7 -7 L 6 -5 L 4 -3 L -2 1 M -8 7 L -7 6 L -5 6 L 0 8 L 3 8 L 5 7 L 6 5 M -5 6 L 0 9 L 3 9 L 5 8 L 6 5","-10 11 M -3 -8 L -2 -7 L -3 -6 L -4 -7 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 4 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 4 -3 L 1 -2 M 4 -12 L 6 -11 L 7 -9 L 7 -7 L 6 -5 L 4 -3 M -1 -2 L 1 -2 L 4 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 4 8 L 1 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 4 L -7 3 L -6 4 L -7 5 M 1 -2 L 3 -1 L 4 0 L 5 2 L 5 5 L 4 7 L 3 8 L 1 9","-10 11 M 6 -11 L 0 9 M 7 -12 L 1 9 M 7 -12 L -8 3 L 8 3","-10 11 M -1 -12 L -6 -2 M -1 -12 L 9 -12 M -1 -11 L 4 -11 L 9 -12 M -6 -2 L -5 -3 L -2 -4 L 1 -4 L 4 -3 L 5 -2 L 6 0 L 6 3 L 5 6 L 3 8 L 0 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 4 L -7 3 L -6 4 L -7 5 M 1 -4 L 3 -3 L 4 -2 L 5 0 L 5 3 L 4 6 L 2 8 L 0 9","-10 11 M 7 -9 L 6 -8 L 7 -7 L 8 -8 L 8 -9 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 5 L -6 7 L -5 8 L -3 9 L 0 9 L 3 8 L 5 6 L 6 4 L 6 1 L 5 -1 L 4 -2 L 2 -3 L -1 -3 L -3 -2 L -5 0 L -6 2 M 2 -12 L 0 -11 L -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 6 L -5 8 M 0 9 L 2 8 L 4 6 L 5 4 L 5 0 L 4 -2","-10 11 M -4 -12 L -6 -6 M 9 -12 L 8 -9 L 6 -6 L 1 0 L -1 3 L -2 5 L -3 9 M 6 -6 L 0 0 L -2 3 L -3 5 L -4 9 M -5 -9 L -2 -12 L 0 -12 L 5 -9 M -4 -10 L -2 -11 L 0 -11 L 5 -9 L 7 -9 L 8 -10 L 9 -12","-10 11 M 1 -12 L -2 -11 L -3 -10 L -4 -8 L -4 -5 L -3 -3 L -1 -2 L 2 -2 L 6 -3 L 7 -4 L 8 -6 L 8 -9 L 7 -11 L 4 -12 L 1 -12 M 1 -12 L -1 -11 L -2 -10 L -3 -8 L -3 -5 L -2 -3 L -1 -2 M 2 -2 L 5 -3 L 6 -4 L 7 -6 L 7 -9 L 6 -11 L 4 -12 M -1 -2 L -5 -1 L -7 1 L -8 3 L -8 6 L -7 8 L -4 9 L 0 9 L 4 8 L 5 7 L 6 5 L 6 2 L 5 0 L 4 -1 L 2 -2 M -1 -2 L -4 -1 L -6 1 L -7 3 L -7 6 L -6 8 L -4 9 M 0 9 L 3 8 L 4 7 L 5 5 L 5 1 L 4 -1","-10 11 M 7 -5 L 6 -3 L 4 -1 L 2 0 L -1 0 L -3 -1 L -4 -2 L -5 -4 L -5 -7 L -4 -9 L -2 -11 L 1 -12 L 4 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -4 L 7 0 L 6 3 L 4 6 L 2 8 L -1 9 L -4 9 L -6 8 L -7 6 L -7 5 L -6 4 L -5 5 L -6 6 M -3 -1 L -4 -3 L -4 -7 L -3 -9 L -1 -11 L 1 -12 M 6 -11 L 7 -9 L 7 -4 L 6 0 L 5 3 L 3 6 L 1 8 L -1 9","-5 6 M 1 -5 L 0 -4 L 1 -3 L 2 -4 L 1 -5 M -2 7 L -3 8 L -2 9 L -1 8","-5 6 M 1 -5 L 0 -4 L 1 -3 L 2 -4 L 1 -5 M -2 9 L -3 8 L -2 7 L -1 8 L -1 9 L -2 11 L -4 13","-12 12 M 8 -9 L -8 0 L 8 9","-13 13 M -9 -3 L 9 -3 M -9 3 L 9 3","-12 12 M -8 -9 L 8 0 L -8 9","-10 11 M -3 -8 L -2 -7 L -3 -6 L -4 -7 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 5 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -5 L 7 -4 L 1 -2 L -1 -1 L -1 1 L 0 2 L 2 2 M 5 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 6 -4 L 4 -3 M -2 7 L -3 8 L -2 9 L -1 8 L -2 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-13 10 M 6 -12 L 4 -10 L 2 -7 L -1 -2 L -3 1 L -6 5 L -9 8 L -11 9 L -13 9 L -14 8 L -14 6 L -13 5 L -12 6 L -13 7 M 6 -12 L 5 -8 L 3 2 L 2 9 M 6 -12 L 3 9 M 2 9 L 2 7 L 1 4 L 0 2 L -2 0 L -4 -1 L -6 -1 L -7 0 L -7 2 L -6 5 L -3 8 L 0 9 L 4 9 L 6 8","-12 12 M 3 -11 L 2 -10 L 1 -8 L -1 -3 L -3 3 L -4 5 L -6 8 L -8 9 M 2 -10 L 1 -7 L -1 1 L -2 4 L -3 6 L -5 8 L -8 9 L -10 9 L -11 8 L -11 6 L -10 5 L -9 6 L -10 7 M -3 -6 L -4 -4 L -5 -3 L -7 -3 L -8 -4 L -8 -6 L -7 -8 L -5 -10 L -3 -11 L 0 -12 L 6 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -5 L 6 -4 L 2 -3 L 0 -3 M 6 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 6 -4 M 2 -3 L 5 -2 L 6 -1 L 7 1 L 7 4 L 6 7 L 5 8 L 3 9 L 1 9 L 0 8 L 0 6 L 1 3 M 2 -3 L 4 -2 L 5 -1 L 6 1 L 6 4 L 5 7 L 3 9","-10 11 M -7 -10 L -8 -8 L -8 -6 L -7 -4 L -4 -3 L -1 -3 L 3 -4 L 5 -5 L 7 -7 L 8 -9 L 8 -11 L 7 -12 L 5 -12 L 2 -11 L -1 -8 L -3 -5 L -5 -1 L -6 3 L -6 6 L -5 8 L -2 9 L 0 9 L 3 8 L 5 6 L 6 4 L 6 2 L 5 0 L 3 0 L 1 1 L 0 3 M 5 -12 L 3 -11 L 0 -8 L -2 -5 L -4 -1 L -5 3 L -5 6 L -4 8 L -2 9","-12 11 M 3 -11 L 2 -10 L 1 -8 L -1 -3 L -3 3 L -4 5 L -6 8 L -8 9 M 2 -10 L 1 -7 L -1 1 L -2 4 L -3 6 L -5 8 L -8 9 L -10 9 L -11 8 L -11 6 L -10 5 L -8 5 L -6 6 L -4 8 L -2 9 L 1 9 L 3 8 L 5 6 L 7 2 L 8 -3 L 8 -6 L 7 -9 L 5 -11 L 3 -12 L -2 -12 L -5 -11 L -7 -9 L -8 -7 L -8 -5 L -7 -4 L -5 -4 L -4 -5 L -3 -7","-9 10 M 5 -9 L 4 -8 L 4 -6 L 5 -5 L 7 -5 L 8 -7 L 8 -9 L 7 -11 L 5 -12 L 2 -12 L 0 -11 L -1 -10 L -2 -8 L -2 -6 L -1 -4 L 1 -3 M 2 -12 L 0 -10 L -1 -8 L -1 -5 L 1 -3 M 1 -3 L -1 -3 L -4 -2 L -6 0 L -7 2 L -7 5 L -6 7 L -5 8 L -3 9 L 0 9 L 3 8 L 5 6 L 6 4 L 6 2 L 5 0 L 3 0 L 1 1 L 0 3 M -1 -3 L -3 -2 L -5 0 L -6 2 L -6 6 L -5 8","-11 10 M 5 -10 L 4 -8 L 2 -3 L 0 3 L -1 5 L -3 8 L -5 9 M -1 -6 L -2 -4 L -4 -3 L -6 -3 L -7 -5 L -7 -7 L -6 -9 L -4 -11 L -1 -12 L 9 -12 L 6 -11 L 5 -10 L 4 -7 L 2 1 L 1 4 L 0 6 L -2 8 L -5 9 L -7 9 L -9 8 L -10 7 L -10 6 L -9 5 L -8 6 L -9 7 M 1 -12 L 5 -11 L 6 -11 M -3 1 L -2 0 L 0 -1 L 4 -1 L 6 -2 L 8 -5 L 6 2","-11 11 M -8 -9 L -9 -7 L -9 -5 L -8 -3 L -6 -2 L -3 -2 L 0 -3 L 2 -4 L 5 -7 L 6 -10 L 6 -11 L 5 -12 L 4 -12 L 2 -11 L 0 -9 L -1 -7 L -2 -4 L -2 -1 L -1 1 L 1 2 L 3 2 L 5 1 L 7 -1 L 8 -3 M 5 -12 L 3 -11 L 1 -9 L 0 -7 L -1 -4 L -1 0 L 1 2 M 8 -3 L 7 1 L 5 5 L 3 7 L 1 8 L -3 9 L -6 9 L -8 8 L -9 6 L -9 5 L -8 4 L -7 5 L -8 6 M 7 1 L 5 4 L 3 6 L 0 8 L -3 9","-12 12 M -6 -6 L -7 -7 L -7 -9 L -6 -11 L -3 -12 L 0 -12 L -3 -1 L -5 5 L -6 7 L -7 8 L -9 9 L -11 9 L -12 8 L -12 6 L -11 5 L -10 6 L -11 7 M 0 -12 L -3 -3 L -4 0 L -6 5 L -7 7 L -9 9 M -8 2 L -7 1 L -5 0 L 4 -3 L 6 -4 L 9 -6 L 11 -8 L 12 -10 L 12 -11 L 11 -12 L 10 -12 L 8 -11 L 6 -8 L 5 -6 L 3 0 L 2 4 L 2 7 L 4 9 L 5 9 L 7 8 L 9 6 M 10 -12 L 8 -10 L 6 -6 L 4 0 L 3 4 L 3 7 L 4 9","-9 7 M 5 -10 L 3 -7 L 1 -2 L -1 3 L -2 5 L -4 8 L -6 9 M 7 -6 L 5 -4 L 2 -3 L -1 -3 L -3 -4 L -4 -6 L -4 -8 L -3 -10 L -1 -11 L 3 -12 L 7 -12 L 5 -10 L 4 -8 L 2 -2 L 0 4 L -1 6 L -3 8 L -6 9 L -8 9 L -9 8 L -9 6 L -8 5 L -7 6 L -8 7","-9 8 M 7 -12 L 5 -10 L 3 -7 L 1 -2 L -2 7 L -4 11 M 7 -5 L 5 -3 L 2 -2 L -1 -2 L -3 -3 L -4 -5 L -4 -7 L -3 -9 L -1 -11 L 3 -12 L 7 -12 L 5 -9 L 4 -7 L 1 2 L -1 6 L -2 8 L -4 11 L -5 12 L -7 13 L -8 12 L -8 10 L -7 8 L -5 6 L -3 5 L 0 4 L 4 3","-12 12 M -6 -6 L -7 -7 L -7 -9 L -5 -11 L -2 -12 L 0 -12 L -3 -1 L -5 5 L -6 7 L -7 8 L -9 9 L -11 9 L -12 8 L -12 6 L -11 5 L -10 6 L -11 7 M 0 -12 L -3 -3 L -4 0 L -6 5 L -7 7 L -9 9 M 8 -11 L 5 -7 L 3 -5 L 1 -4 L -2 -3 M 11 -11 L 10 -10 L 11 -9 L 12 -10 L 12 -11 L 11 -12 L 10 -12 L 8 -11 L 5 -6 L 4 -5 L 2 -4 L -2 -3 M -2 -3 L 1 -2 L 2 0 L 3 7 L 4 9 M -2 -3 L 0 -2 L 1 0 L 2 7 L 4 9 L 5 9 L 7 8 L 9 6","-9 9 M -5 -9 L -6 -7 L -6 -5 L -5 -3 L -3 -2 L 0 -2 L 3 -3 L 5 -4 L 8 -7 L 9 -10 L 9 -11 L 8 -12 L 7 -12 L 5 -11 L 4 -10 L 2 -7 L -2 3 L -3 5 L -5 8 L -7 9 M 4 -10 L 2 -6 L 0 1 L -1 4 L -2 6 L -4 8 L -7 9 L -9 9 L -10 8 L -10 6 L -9 5 L -7 5 L -5 6 L -2 8 L 0 9 L 3 9 L 5 8 L 7 6","-14 14 M 0 -12 L -4 -3 L -7 3 L -9 6 L -11 8 L -13 9 L -15 9 L -16 8 L -16 6 L -15 5 L -14 6 L -15 7 M 0 -12 L -2 -5 L -3 -1 L -4 4 L -4 8 L -2 9 M 0 -12 L -1 -8 L -2 -3 L -3 4 L -3 8 L -2 9 M 9 -12 L 5 -3 L 0 6 L -2 9 M 9 -12 L 7 -5 L 6 -1 L 5 4 L 5 8 L 7 9 L 8 9 L 10 8 L 12 6 M 9 -12 L 8 -8 L 7 -3 L 6 4 L 6 8 L 7 9","-11 12 M 0 -12 L -1 -8 L -3 -2 L -5 3 L -6 5 L -8 8 L -10 9 L -12 9 L -13 8 L -13 6 L -12 5 L -11 6 L -12 7 M 0 -12 L 0 -7 L 1 4 L 2 9 M 0 -12 L 1 -7 L 2 4 L 2 9 M 14 -11 L 13 -10 L 14 -9 L 15 -10 L 15 -11 L 14 -12 L 12 -12 L 10 -11 L 8 -8 L 7 -6 L 5 -1 L 3 5 L 2 9","-10 11 M 1 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -4 L -7 0 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 1 L 8 -3 L 8 -7 L 7 -10 L 6 -11 L 5 -11 L 3 -10 L 1 -8 L -1 -4 L -2 1 L -2 4 M -1 -11 L -3 -8 L -5 -4 L -6 0 L -6 4 L -5 7 L -3 9","-12 11 M 3 -11 L 2 -10 L 1 -8 L -1 -3 L -3 3 L -4 5 L -6 8 L -8 9 M 2 -10 L 1 -7 L -1 1 L -2 4 L -3 6 L -5 8 L -8 9 L -10 9 L -11 8 L -11 6 L -10 5 L -9 6 L -10 7 M -3 -6 L -4 -4 L -5 -3 L -7 -3 L -8 -4 L -8 -6 L -7 -8 L -5 -10 L -3 -11 L 0 -12 L 4 -12 L 7 -11 L 8 -10 L 9 -8 L 9 -5 L 8 -3 L 7 -2 L 4 -1 L 2 -1 L 0 -2 M 4 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -5 L 7 -3 L 6 -2 L 4 -1","-10 11 M 3 -8 L 3 -6 L 2 -4 L 1 -3 L -1 -2 L -3 -2 L -4 -4 L -4 -6 L -3 -9 L -1 -11 L 2 -12 L 5 -12 L 7 -11 L 8 -9 L 8 -5 L 7 -2 L 5 1 L 1 5 L -2 7 L -4 8 L -7 9 L -9 9 L -10 8 L -10 6 L -9 5 L -7 5 L -5 6 L -2 8 L 1 9 L 4 9 L 6 8 L 8 6 M 5 -12 L 6 -11 L 7 -9 L 7 -5 L 6 -2 L 4 1 L 1 4 L -3 7 L -7 9","-12 12 M 3 -11 L 2 -10 L 1 -8 L -1 -3 L -3 3 L -4 5 L -6 8 L -8 9 M 2 -10 L 1 -7 L -1 1 L -2 4 L -3 6 L -5 8 L -8 9 L -10 9 L -11 8 L -11 6 L -10 5 L -9 6 L -10 7 M -3 -6 L -4 -4 L -5 -3 L -7 -3 L -8 -4 L -8 -6 L -7 -8 L -5 -10 L -3 -11 L 0 -12 L 5 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -5 L 7 -4 L 4 -3 L 0 -3 M 5 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 6 -4 L 4 -3 M 0 -3 L 3 -2 L 4 0 L 5 7 L 6 9 M 0 -3 L 2 -2 L 3 0 L 4 7 L 6 9 L 7 9 L 9 8 L 11 6","-10 10 M -4 -9 L -5 -7 L -5 -5 L -4 -3 L -2 -2 L 1 -2 L 4 -3 L 6 -4 L 9 -7 L 10 -10 L 10 -11 L 9 -12 L 8 -12 L 6 -11 L 5 -10 L 4 -8 L 3 -5 L 1 2 L 0 5 L -2 8 L -4 9 M 4 -8 L 3 -4 L 2 3 L 1 6 L -1 8 L -4 9 L -7 9 L -9 8 L -10 6 L -10 5 L -9 4 L -8 5 L -9 6","-9 9 M 7 -10 L 6 -8 L 4 -3 L 2 3 L 1 5 L -1 8 L -3 9 M 1 -6 L 0 -4 L -2 -3 L -4 -3 L -5 -5 L -5 -7 L -4 -9 L -2 -11 L 1 -12 L 10 -12 L 8 -11 L 7 -10 L 6 -7 L 4 1 L 3 4 L 2 6 L 0 8 L -3 9 L -5 9 L -7 8 L -8 7 L -8 6 L -7 5 L -6 6 L -7 7 M 3 -12 L 7 -11 L 8 -11","-11 11 M -10 -8 L -8 -11 L -6 -12 L -5 -12 L -3 -10 L -3 -7 L -4 -4 L -7 4 L -7 7 L -6 9 M -5 -12 L -4 -10 L -4 -7 L -7 1 L -8 4 L -8 7 L -6 9 L -4 9 L -2 8 L 1 5 L 3 2 L 4 0 M 8 -12 L 4 0 L 3 4 L 3 7 L 5 9 L 6 9 L 8 8 L 10 6 M 9 -12 L 5 0 L 4 4 L 4 7 L 5 9","-11 10 M -10 -8 L -8 -11 L -6 -12 L -5 -12 L -3 -10 L -3 -7 L -4 -3 L -6 4 L -6 7 L -5 9 M -5 -12 L -4 -10 L -4 -7 L -6 0 L -7 4 L -7 7 L -5 9 L -4 9 L -1 8 L 2 5 L 4 2 L 6 -2 L 7 -5 L 8 -9 L 8 -11 L 7 -12 L 6 -12 L 5 -11 L 4 -9 L 4 -6 L 5 -4 L 7 -2 L 9 -1 L 11 -1","-12 11 M -9 -6 L -10 -6 L -11 -7 L -11 -9 L -10 -11 L -8 -12 L -4 -12 L -5 -10 L -6 -6 L -7 3 L -8 9 M -6 -6 L -6 3 L -7 9 M 4 -12 L 2 -10 L 0 -6 L -3 3 L -5 7 L -7 9 M 4 -12 L 3 -10 L 2 -6 L 1 3 L 0 9 M 2 -6 L 2 3 L 1 9 M 14 -12 L 12 -11 L 10 -9 L 8 -6 L 5 3 L 3 7 L 1 9","-10 10 M -2 -7 L -3 -6 L -5 -6 L -6 -7 L -6 -9 L -5 -11 L -3 -12 L -1 -12 L 1 -11 L 2 -9 L 2 -6 L 1 -2 L -1 3 L -3 6 L -5 8 L -8 9 L -10 9 L -11 8 L -11 6 L -10 5 L -9 6 L -10 7 M -1 -12 L 0 -11 L 1 -9 L 1 -6 L 0 -2 L -2 3 L -4 6 L -6 8 L -8 9 M 11 -11 L 10 -10 L 11 -9 L 12 -10 L 12 -11 L 11 -12 L 9 -12 L 7 -11 L 5 -9 L 3 -6 L 1 -2 L 0 3 L 0 6 L 1 8 L 2 9 L 3 9 L 5 8 L 7 6","-11 11 M -8 -8 L -6 -11 L -4 -12 L -3 -12 L -1 -11 L -1 -9 L -3 -3 L -3 0 L -2 2 M -3 -12 L -2 -11 L -2 -9 L -4 -3 L -4 0 L -2 2 L 0 2 L 3 1 L 5 -1 L 7 -4 L 8 -6 M 10 -12 L 8 -6 L 5 2 L 3 6 M 11 -12 L 9 -6 L 7 -1 L 5 3 L 3 6 L 1 8 L -2 9 L -6 9 L -8 8 L -9 6 L -9 5 L -8 4 L -7 5 L -8 6","-11 10 M 8 -10 L 7 -8 L 5 -3 L 4 0 L 3 2 L 1 5 L -1 7 L -3 8 L -6 9 M 1 -6 L 0 -4 L -2 -3 L -4 -3 L -5 -5 L -5 -7 L -4 -9 L -2 -11 L 1 -12 L 11 -12 L 9 -11 L 8 -10 L 7 -7 L 6 -3 L 4 3 L 2 6 L -1 8 L -6 9 L -10 9 L -11 8 L -11 6 L -10 5 L -8 5 L -6 6 L -3 8 L -1 9 L 2 9 L 5 8 L 7 6 M 4 -12 L 8 -11 L 9 -11","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-8 8 M -2 -6 L 0 -9 L 2 -6 M -5 -3 L 0 -8 L 5 -3 M 0 -8 L 0 9","-8 8 M -8 11 L 8 11","-5 6 M 4 -12 L 2 -10 L 1 -8 L 1 -7 L 2 -6 L 3 -7 L 2 -8","-7 9 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 6 M -2 0 L -4 2 L -5 4 L -5 7 L -3 9 M 4 0 L 2 6 L 2 8 L 4 9 L 6 8 L 7 7 L 9 4 M 5 0 L 3 6 L 3 8 L 4 9","-6 8 M -6 4 L -4 1 L -2 -3 M 1 -12 L -5 6 L -5 8 L -3 9 L -2 9 L 0 8 L 2 6 L 3 3 L 3 0 L 4 4 L 5 5 L 6 5 L 8 4 M 2 -12 L -4 6 L -4 8 L -3 9","-6 6 M 2 1 L 1 2 L 2 2 L 2 1 L 1 0 L -1 0 L -3 1 L -4 2 L -5 4 L -5 6 L -4 8 L -2 9 L 1 9 L 4 7 L 6 4 M -1 0 L -3 2 L -4 4 L -4 7 L -2 9","-7 9 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 6 M -2 0 L -4 2 L -5 4 L -5 7 L -3 9 M 8 -12 L 2 6 L 2 8 L 4 9 L 6 8 L 7 7 L 9 4 M 9 -12 L 3 6 L 3 8 L 4 9","-6 6 M -3 7 L -1 6 L 0 5 L 1 3 L 1 1 L 0 0 L -1 0 L -3 1 L -4 2 L -5 4 L -5 6 L -4 8 L -2 9 L 1 9 L 4 7 L 6 4 M -1 0 L -3 2 L -4 4 L -4 7 L -2 9","-3 6 M 0 0 L 3 -3 L 5 -6 L 6 -9 L 6 -11 L 5 -12 L 3 -11 L 2 -9 L -7 18 L -7 20 L -6 21 L -4 20 L -3 17 L -2 8 L -1 9 L 1 9 L 3 8 L 4 7 L 6 4 M 2 -9 L 1 -4 L 0 0 L -3 9 L -5 14 L -7 18","-7 9 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 6 M -2 0 L -4 2 L -5 4 L -5 7 L -3 9 M 4 0 L -2 18 M 5 0 L 2 9 L 0 14 L -2 18 L -3 20 L -5 21 L -6 20 L -6 18 L -5 15 L -3 13 L 0 11 L 4 9 L 7 7 L 9 4","-6 9 M -6 4 L -4 1 L -2 -3 M 1 -12 L -6 9 M 2 -12 L -5 9 M -3 3 L -1 1 L 1 0 L 2 0 L 4 1 L 4 3 L 3 6 L 3 8 L 4 9 M 2 0 L 3 1 L 3 3 L 2 6 L 2 8 L 4 9 L 6 8 L 7 7 L 9 4","-4 4 M 1 -6 L 0 -5 L 1 -4 L 2 -5 L 1 -6 M -1 0 L -3 6 L -3 8 L -1 9 L 1 8 L 2 7 L 4 4 M 0 0 L -2 6 L -2 8 L -1 9","-4 4 M 1 -6 L 0 -5 L 1 -4 L 2 -5 L 1 -6 M -1 0 L -7 18 M 0 0 L -3 9 L -5 14 L -7 18 L -8 20 L -10 21 L -11 20 L -11 18 L -10 15 L -8 13 L -5 11 L -1 9 L 2 7 L 4 4","-6 8 M -6 4 L -4 1 L -2 -3 M 1 -12 L -6 9 M 2 -12 L -5 9 M 3 0 L 3 1 L 4 1 L 3 0 L 2 0 L 0 2 L -3 3 M -3 3 L 0 4 L 1 8 L 2 9 M -3 3 L -1 4 L 0 8 L 2 9 L 3 9 L 6 7 L 8 4","-4 4 M -4 4 L -2 1 L 0 -3 M 3 -12 L -3 6 L -3 8 L -1 9 L 1 8 L 2 7 L 4 4 M 4 -12 L -2 6 L -2 8 L -1 9","-13 12 M -13 4 L -11 1 L -9 0 L -7 1 L -7 3 L -9 9 M -9 0 L -8 1 L -8 3 L -10 9 M -7 3 L -5 1 L -3 0 L -2 0 L 0 1 L 0 3 L -2 9 M -2 0 L -1 1 L -1 3 L -3 9 M 0 3 L 2 1 L 4 0 L 5 0 L 7 1 L 7 3 L 6 6 L 6 8 L 7 9 M 5 0 L 6 1 L 6 3 L 5 6 L 5 8 L 7 9 L 9 8 L 10 7 L 12 4","-9 9 M -9 4 L -7 1 L -5 0 L -3 1 L -3 3 L -5 9 M -5 0 L -4 1 L -4 3 L -6 9 M -3 3 L -1 1 L 1 0 L 2 0 L 4 1 L 4 3 L 3 6 L 3 8 L 4 9 M 2 0 L 3 1 L 3 3 L 2 6 L 2 8 L 4 9 L 6 8 L 7 7 L 9 4","-7 7 M 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 7 L 3 5 L 3 3 L 2 1 L 0 0 L -1 1 L -1 3 L 0 5 L 2 6 L 4 6 L 6 5 L 7 4 M -2 0 L -4 2 L -5 4 L -5 7 L -3 9","-6 9 M -6 4 L -4 1 L -2 -3 M -1 -6 L -10 21 M 0 -6 L -9 21 M -3 3 L -1 1 L 1 0 L 2 0 L 4 1 L 4 3 L 3 6 L 3 8 L 4 9 M 2 0 L 3 1 L 3 3 L 2 6 L 2 8 L 4 9 L 6 8 L 7 7 L 9 4","-7 9 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 M -2 0 L -4 2 L -5 4 L -5 7 L -3 9 M 4 0 L -2 18 L -2 20 L -1 21 L 1 20 L 2 17 L 2 9 L 4 9 L 7 7 L 9 4 M 5 0 L 2 9 L 0 14 L -2 18","-6 8 M -6 4 L -4 1 L -2 0 L 0 1 L 0 3 L -2 9 M -2 0 L -1 1 L -1 3 L -3 9 M 0 3 L 2 1 L 4 0 L 5 0 L 4 3 M 4 0 L 4 3 L 5 5 L 6 5 L 8 4","-4 8 M -4 4 L -2 1 L -1 -1 L -1 1 L 2 3 L 3 5 L 3 7 L 2 8 L 0 9 M -1 1 L 1 3 L 2 5 L 2 7 L 0 9 M -4 8 L -2 9 L 3 9 L 6 7 L 8 4","-4 4 M -4 4 L -2 1 L 0 -3 M 3 -12 L -3 6 L -3 8 L -1 9 L 1 8 L 2 7 L 4 4 M 4 -12 L -2 6 L -2 8 L -1 9 M -2 -4 L 4 -4","-7 9 M -4 0 L -6 6 L -6 8 L -4 9 L -3 9 L -1 8 L 1 6 L 3 3 M -3 0 L -5 6 L -5 8 L -4 9 M 4 0 L 2 6 L 2 8 L 4 9 L 6 8 L 7 7 L 9 4 M 5 0 L 3 6 L 3 8 L 4 9","-7 8 M -4 0 L -5 2 L -6 5 L -6 8 L -4 9 L -3 9 L 0 8 L 2 6 L 3 3 L 3 0 M -3 0 L -4 2 L -5 5 L -5 8 L -4 9 M 3 0 L 4 4 L 5 5 L 6 5 L 8 4","-10 11 M -6 0 L -8 2 L -9 5 L -9 8 L -7 9 L -6 9 L -4 8 L -2 6 M -5 0 L -7 2 L -8 5 L -8 8 L -7 9 M 0 0 L -2 6 L -2 8 L 0 9 L 1 9 L 3 8 L 5 6 L 6 3 L 6 0 M 1 0 L -1 6 L -1 8 L 0 9 M 6 0 L 7 4 L 8 5 L 9 5 L 11 4","-8 8 M -8 4 L -6 1 L -4 0 L -2 0 L -1 1 L -1 3 L -2 6 L -3 8 L -5 9 L -6 9 L -7 8 L -7 7 L -6 7 L -7 8 M 5 1 L 4 2 L 5 2 L 5 1 L 4 0 L 3 0 L 1 1 L 0 3 L -1 6 L -1 8 L 0 9 L 3 9 L 6 7 L 8 4 M -1 1 L 0 3 M 1 1 L -1 3 M -2 6 L -1 8 M -1 6 L -3 8","-7 9 M -4 0 L -6 6 L -6 8 L -4 9 L -3 9 L -1 8 L 1 6 L 3 3 M -3 0 L -5 6 L -5 8 L -4 9 M 4 0 L -2 18 M 5 0 L 2 9 L 0 14 L -2 18 L -3 20 L -5 21 L -6 20 L -6 18 L -5 15 L -3 13 L 0 11 L 4 9 L 7 7 L 9 4","-6 7 M -6 4 L -4 1 L -2 0 L 0 0 L 2 1 L 2 4 L 1 6 L -2 8 L -4 9 M 0 0 L 1 1 L 1 4 L 0 6 L -2 8 M -4 9 L -2 10 L -1 12 L -1 15 L -2 18 L -4 20 L -6 21 L -7 20 L -7 18 L -6 15 L -3 12 L 0 10 L 4 7 L 7 4 M -4 9 L -3 10 L -2 12 L -2 15 L -3 18 L -4 20","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-7 8 M 1 -12 L -1 -11 L -2 -9 L -2 -7 L -1 -5 L 1 -4 L 3 -4 L 5 -5 L 6 -7 L 6 -9 L 5 -11 L 3 -12 L 1 -12"]
scripts = ["-8 8","-5 6 M 3 -12 L 2 -11 L 0 1 M 3 -11 L 0 1 M 3 -12 L 4 -11 L 0 1 M -2 7 L -3 8 L -2 9 L -1 8 L -2 7","-9 9 M -2 -12 L -4 -5 M -1 -12 L -4 -5 M 7 -12 L 5 -5 M 8 -12 L 5 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 11 M 2 -16 L -6 13 M 7 -16 L -1 13 M 8 -8 L 7 -7 L 8 -6 L 9 -7 L 9 -8 L 8 -10 L 7 -11 L 4 -12 L 0 -12 L -3 -11 L -5 -9 L -5 -7 L -4 -5 L -3 -4 L 4 0 L 6 2 M -5 -7 L -3 -5 L 4 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 4 8 L 1 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 4 L -7 3 L -6 4 L -7 5","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-13 13 M 10 -4 L 9 -3 L 10 -2 L 11 -3 L 11 -4 L 10 -5 L 9 -5 L 7 -4 L 5 -2 L 0 6 L -2 8 L -4 9 L -7 9 L -10 8 L -11 6 L -11 4 L -10 2 L -9 1 L -7 0 L -2 -2 L 0 -3 L 2 -5 L 3 -7 L 3 -9 L 2 -11 L 0 -12 L -2 -11 L -3 -9 L -3 -6 L -2 0 L -1 3 L 1 6 L 3 8 L 5 9 L 7 9 L 8 7 L 8 6 M -7 9 L -9 8 L -10 6 L -10 4 L -9 2 L -8 1 L -2 -2 M -3 -6 L -2 -1 L -1 2 L 1 5 L 3 7 L 5 8 L 7 8 L 8 7","-5 6 M 3 -10 L 2 -11 L 3 -12 L 4 -11 L 4 -10 L 3 -8 L 1 -6","-7 8 M 8 -16 L 4 -13 L 1 -10 L -1 -7 L -3 -3 L -4 2 L -4 6 L -3 11 L -2 14 L -1 16 M 4 -13 L 1 -9 L -1 -5 L -2 -2 L -3 3 L -3 8 L -2 13 L -1 16","-8 7 M 1 -16 L 2 -14 L 3 -11 L 4 -6 L 4 -2 L 3 3 L 1 7 L -1 10 L -4 13 L -8 16 M 1 -16 L 2 -13 L 3 -8 L 3 -3 L 2 2 L 1 5 L -1 9 L -4 13","-8 9 M 2 -12 L 2 0 M -3 -9 L 7 -3 M 7 -9 L -3 -3","-13 13 M 0 -9 L 0 9 M -9 0 L 9 0","-5 6 M -2 9 L -3 8 L -2 7 L -1 8 L -1 9 L -2 11 L -4 13","-13 13 M -9 0 L 9 0","-5 5 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-11 11 M 13 -16 L -13 16","-10 11 M 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 8 -4 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 2 -12 M 2 -12 L 0 -11 L -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 4 L -5 7 L -3 9 M -1 9 L 1 8 L 3 6 L 5 3 L 6 0 L 7 -4 L 7 -7 L 6 -10 L 4 -12","-10 11 M 2 -8 L -3 9 M 4 -12 L -2 9 M 4 -12 L 1 -9 L -2 -7 L -4 -6 M 3 -9 L -1 -7 L -4 -6","-10 11 M -3 -8 L -2 -7 L -3 -6 L -4 -7 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 4 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 5 -3 L 2 -1 L -2 1 L -5 3 L -7 5 L -9 9 M 4 -12 L 6 -11 L 7 -9 L 7 -7 L 6 -5 L 4 -3 L -2 1 M -8 7 L -7 6 L -5 6 L 0 8 L 3 8 L 5 7 L 6 5 M -5 6 L 0 9 L 3 9 L 5 8 L 6 5","-10 11 M -3 -8 L -2 -7 L -3 -6 L -4 -7 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 4 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 4 -3 L 1 -2 M 4 -12 L 6 -11 L 7 -9 L 7 -7 L 6 -5 L 4 -3 M -1 -2 L 1 -2 L 4 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 4 8 L 1 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 4 L -7 3 L -6 4 L -7 5 M 1 -2 L 3 -1 L 4 0 L 5 2 L 5 5 L 4 7 L 3 8 L 1 9","-10 11 M 6 -11 L 0 9 M 7 -12 L 1 9 M 7 -12 L -8 3 L 8 3","-10 11 M -1 -12 L -6 -2 M -1 -12 L 9 -12 M -1 -11 L 4 -11 L 9 -12 M -6 -2 L -5 -3 L -2 -4 L 1 -4 L 4 -3 L 5 -2 L 6 0 L 6 3 L 5 6 L 3 8 L 0 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 4 L -7 3 L -6 4 L -7 5 M 1 -4 L 3 -3 L 4 -2 L 5 0 L 5 3 L 4 6 L 2 8 L 0 9","-10 11 M 7 -9 L 6 -8 L 7 -7 L 8 -8 L 8 -9 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 5 L -6 7 L -5 8 L -3 9 L 0 9 L 3 8 L 5 6 L 6 4 L 6 1 L 5 -1 L 4 -2 L 2 -3 L -1 -3 L -3 -2 L -5 0 L -6 2 M 2 -12 L 0 -11 L -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 6 L -5 8 M 0 9 L 2 8 L 4 6 L 5 4 L 5 0 L 4 -2","-10 11 M -4 -12 L -6 -6 M 9 -12 L 8 -9 L 6 -6 L 1 0 L -1 3 L -2 5 L -3 9 M 6 -6 L 0 0 L -2 3 L -3 5 L -4 9 M -5 -9 L -2 -12 L 0 -12 L 5 -9 M -4 -10 L -2 -11 L 0 -11 L 5 -9 L 7 -9 L 8 -10 L 9 -12","-10 11 M 1 -12 L -2 -11 L -3 -10 L -4 -8 L -4 -5 L -3 -3 L -1 -2 L 2 -2 L 6 -3 L 7 -4 L 8 -6 L 8 -9 L 7 -11 L 4 -12 L 1 -12 M 1 -12 L -1 -11 L -2 -10 L -3 -8 L -3 -5 L -2 -3 L -1 -2 M 2 -2 L 5 -3 L 6 -4 L 7 -6 L 7 -9 L 6 -11 L 4 -12 M -1 -2 L -5 -1 L -7 1 L -8 3 L -8 6 L -7 8 L -4 9 L 0 9 L 4 8 L 5 7 L 6 5 L 6 2 L 5 0 L 4 -1 L 2 -2 M -1 -2 L -4 -1 L -6 1 L -7 3 L -7 6 L -6 8 L -4 9 M 0 9 L 3 8 L 4 7 L 5 5 L 5 1 L 4 -1","-10 11 M 7 -5 L 6 -3 L 4 -1 L 2 0 L -1 0 L -3 -1 L -4 -2 L -5 -4 L -5 -7 L -4 -9 L -2 -11 L 1 -12 L 4 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -4 L 7 0 L 6 3 L 4 6 L 2 8 L -1 9 L -4 9 L -6 8 L -7 6 L -7 5 L -6 4 L -5 5 L -6 6 M -3 -1 L -4 -3 L -4 -7 L -3 -9 L -1 -11 L 1 -12 M 6 -11 L 7 -9 L 7 -4 L 6 0 L 5 3 L 3 6 L 1 8 L -1 9","-5 6 M 1 -5 L 0 -4 L 1 -3 L 2 -4 L 1 -5 M -2 7 L -3 8 L -2 9 L -1 8","-5 6 M 1 -5 L 0 -4 L 1 -3 L 2 -4 L 1 -5 M -2 9 L -3 8 L -2 7 L -1 8 L -1 9 L -2 11 L -4 13","-12 12 M 8 -9 L -8 0 L 8 9","-13 13 M -9 -3 L 9 -3 M -9 3 L 9 3","-12 12 M -8 -9 L 8 0 L -8 9","-10 11 M -3 -8 L -2 -7 L -3 -6 L -4 -7 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 5 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -5 L 7 -4 L 1 -2 L -1 -1 L -1 1 L 0 2 L 2 2 M 5 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 6 -4 L 4 -3 M -2 7 L -3 8 L -2 9 L -1 8 L -2 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-11 9 M -11 9 L -9 8 L -6 5 L -3 1 L 1 -6 L 4 -12 L 4 9 L 3 6 L 1 3 L -1 1 L -4 -1 L -6 -1 L -7 0 L -7 2 L -6 4 L -4 6 L -1 8 L 2 9 L 7 9","-12 11 M 1 -10 L 2 -9 L 2 -6 L 1 -2 L 0 1 L -1 3 L -3 6 L -5 8 L -7 9 L -8 9 L -9 8 L -9 5 L -8 0 L -7 -3 L -6 -5 L -4 -8 L -2 -10 L 0 -11 L 3 -12 L 6 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -5 L 7 -4 L 5 -3 L 2 -2 M 1 -2 L 2 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 3 9 L 0 9 L -2 8 L -3 6","-10 10 M 2 -6 L 2 -5 L 3 -4 L 5 -4 L 7 -5 L 8 -7 L 8 -9 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -4 L -7 0 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 2 8 L 4 6 L 5 4","-11 12 M 2 -12 L 0 -11 L -1 -9 L -2 -5 L -3 1 L -4 4 L -5 6 L -7 8 L -9 9 L -11 9 L -12 8 L -12 6 L -11 5 L -9 5 L -7 6 L -5 8 L -2 9 L 1 9 L 4 8 L 6 6 L 8 2 L 9 -3 L 9 -7 L 8 -10 L 7 -11 L 5 -12 L 2 -12 L 0 -10 L 0 -8 L 1 -5 L 3 -2 L 5 0 L 8 2 L 10 3","-10 10 M 4 -8 L 4 -7 L 5 -6 L 7 -6 L 8 -7 L 8 -9 L 7 -11 L 4 -12 L 0 -12 L -3 -11 L -4 -9 L -4 -6 L -3 -4 L -2 -3 L 1 -2 L -2 -2 L -5 -1 L -6 0 L -7 2 L -7 5 L -6 7 L -5 8 L -2 9 L 1 9 L 4 8 L 6 6 L 7 4","-10 10 M 0 -6 L -2 -6 L -4 -7 L -5 -9 L -4 -11 L -1 -12 L 2 -12 L 6 -11 L 9 -11 L 11 -12 M 6 -11 L 4 -4 L 2 2 L 0 6 L -2 8 L -4 9 L -6 9 L -8 8 L -9 6 L -9 4 L -8 3 L -6 3 L -4 4 M -1 -2 L 8 -2","-11 12 M -11 9 L -9 8 L -5 4 L -2 -1 L -1 -4 L 0 -8 L 0 -11 L -1 -12 L -2 -12 L -3 -11 L -4 -9 L -4 -6 L -3 -4 L -1 -3 L 3 -3 L 6 -4 L 7 -5 L 8 -7 L 8 -1 L 7 4 L 6 6 L 4 8 L 1 9 L -3 9 L -6 8 L -8 6 L -9 4 L -9 2","-12 12 M -5 -5 L -7 -6 L -8 -8 L -8 -9 L -7 -11 L -5 -12 L -4 -12 L -2 -11 L -1 -9 L -1 -7 L -2 -3 L -4 3 L -6 7 L -8 9 L -10 9 L -11 8 L -11 6 M -5 0 L 4 -3 L 6 -4 L 9 -6 L 11 -8 L 12 -10 L 12 -11 L 11 -12 L 10 -12 L 8 -10 L 6 -6 L 4 0 L 3 5 L 3 8 L 4 9 L 5 9 L 7 8 L 8 7 L 10 4","-9 8 M 5 4 L 3 2 L 1 -1 L 0 -3 L -1 -6 L -1 -9 L 0 -11 L 1 -12 L 3 -12 L 4 -11 L 5 -9 L 5 -6 L 4 -1 L 2 4 L 1 6 L -1 8 L -3 9 L -5 9 L -7 8 L -8 6 L -8 4 L -7 3 L -5 3 L -3 4","-8 7 M 2 12 L 0 9 L -2 4 L -3 -2 L -3 -8 L -2 -11 L 0 -12 L 2 -12 L 3 -11 L 4 -8 L 4 -5 L 3 0 L 0 9 L -2 15 L -3 18 L -4 20 L -6 21 L -7 20 L -7 18 L -6 15 L -4 12 L -2 10 L 1 8 L 5 6","-12 12 M -5 -5 L -7 -6 L -8 -8 L -8 -9 L -7 -11 L -5 -12 L -4 -12 L -2 -11 L -1 -9 L -1 -7 L -2 -3 L -4 3 L -6 7 L -8 9 L -10 9 L -11 8 L -11 6 M 12 -9 L 12 -11 L 11 -12 L 10 -12 L 8 -11 L 6 -9 L 4 -6 L 2 -4 L 0 -3 L -2 -3 M 0 -3 L 1 -1 L 1 6 L 2 8 L 3 9 L 4 9 L 6 8 L 7 7 L 9 4","-9 10 M -5 0 L -3 0 L 1 -1 L 4 -3 L 6 -5 L 7 -7 L 7 -10 L 6 -12 L 4 -12 L 3 -11 L 2 -9 L 1 -4 L 0 1 L -1 4 L -2 6 L -4 8 L -6 9 L -8 9 L -9 8 L -9 6 L -8 5 L -6 5 L -4 6 L -1 8 L 2 9 L 4 9 L 7 8 L 9 6","-18 15 M -13 -5 L -15 -6 L -16 -8 L -16 -9 L -15 -11 L -13 -12 L -12 -12 L -10 -11 L -9 -9 L -9 -7 L -10 -2 L -11 2 L -13 9 M -11 2 L -8 -6 L -6 -10 L -5 -11 L -3 -12 L -2 -12 L 0 -11 L 1 -9 L 1 -7 L 0 -2 L -1 2 L -3 9 M -1 2 L 2 -6 L 4 -10 L 5 -11 L 7 -12 L 8 -12 L 10 -11 L 11 -9 L 11 -7 L 10 -2 L 8 5 L 8 8 L 9 9 L 10 9 L 12 8 L 13 7 L 15 4","-13 11 M -8 -5 L -10 -6 L -11 -8 L -11 -9 L -10 -11 L -8 -12 L -7 -12 L -5 -11 L -4 -9 L -4 -7 L -5 -2 L -6 2 L -8 9 M -6 2 L -3 -6 L -1 -10 L 0 -11 L 2 -12 L 4 -12 L 6 -11 L 7 -9 L 7 -7 L 6 -2 L 4 5 L 4 8 L 5 9 L 6 9 L 8 8 L 9 7 L 11 4","-10 11 M 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -4 L -7 0 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 1 L 8 -3 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 2 -12 L 0 -10 L 0 -7 L 1 -4 L 3 -1 L 5 1 L 8 3 L 10 4","-12 13 M 1 -10 L 2 -9 L 2 -6 L 1 -2 L 0 1 L -1 3 L -3 6 L -5 8 L -7 9 L -8 9 L -9 8 L -9 5 L -8 0 L -7 -3 L -6 -5 L -4 -8 L -2 -10 L 0 -11 L 3 -12 L 8 -12 L 10 -11 L 11 -10 L 12 -8 L 12 -5 L 11 -3 L 10 -2 L 8 -1 L 5 -1 L 3 -2 L 2 -3","-10 12 M 3 -6 L 2 -4 L 1 -3 L -1 -2 L -3 -2 L -4 -4 L -4 -6 L -3 -9 L -1 -11 L 2 -12 L 5 -12 L 7 -11 L 8 -9 L 8 -5 L 7 -2 L 5 1 L 1 5 L -2 7 L -4 8 L -7 9 L -9 9 L -10 8 L -10 6 L -9 5 L -7 5 L -5 6 L -2 8 L 1 9 L 4 9 L 7 8 L 9 6","-12 13 M 1 -10 L 2 -9 L 2 -6 L 1 -2 L 0 1 L -1 3 L -3 6 L -5 8 L -7 9 L -8 9 L -9 8 L -9 5 L -8 0 L -7 -3 L -6 -5 L -4 -8 L -2 -10 L 0 -11 L 3 -12 L 7 -12 L 9 -11 L 10 -10 L 11 -8 L 11 -5 L 10 -3 L 9 -2 L 7 -1 L 4 -1 L 1 -2 L 2 -1 L 3 1 L 3 6 L 4 8 L 6 9 L 8 8 L 9 7 L 11 4","-10 10 M -10 9 L -8 8 L -6 6 L -3 2 L -1 -1 L 1 -5 L 2 -8 L 2 -11 L 1 -12 L 0 -12 L -1 -11 L -2 -9 L -2 -7 L -1 -5 L 1 -3 L 4 -1 L 6 1 L 7 3 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6 L -8 4 L -8 2","-10 9 M 0 -6 L -2 -6 L -4 -7 L -5 -9 L -4 -11 L -1 -12 L 2 -12 L 6 -11 L 9 -11 L 11 -12 M 6 -11 L 4 -4 L 2 2 L 0 6 L -2 8 L -4 9 L -6 9 L -8 8 L -9 6 L -9 4 L -8 3 L -6 3 L -4 4","-13 11 M -8 -5 L -10 -6 L -11 -8 L -11 -9 L -10 -11 L -8 -12 L -7 -12 L -5 -11 L -4 -9 L -4 -7 L -5 -3 L -6 0 L -7 4 L -7 6 L -6 8 L -4 9 L -2 9 L 0 8 L 1 7 L 3 3 L 6 -5 L 8 -12 M 6 -5 L 5 -1 L 4 5 L 4 8 L 5 9 L 6 9 L 8 8 L 9 7 L 11 4","-12 11 M -7 -5 L -9 -6 L -10 -8 L -10 -9 L -9 -11 L -7 -12 L -6 -12 L -4 -11 L -3 -9 L -3 -7 L -4 -3 L -5 0 L -6 4 L -6 7 L -5 9 L -3 9 L -1 8 L 2 5 L 4 2 L 6 -2 L 7 -5 L 8 -9 L 8 -11 L 7 -12 L 6 -12 L 5 -11 L 4 -9 L 4 -7 L 5 -4 L 7 -2 L 9 -1","-15 13 M -10 -5 L -12 -6 L -13 -8 L -13 -9 L -12 -11 L -10 -12 L -9 -12 L -7 -11 L -6 -9 L -6 -6 L -7 9 M 3 -12 L -7 9 M 3 -12 L 1 9 M 15 -12 L 13 -11 L 10 -8 L 7 -4 L 4 2 L 1 9","-12 12 M -4 -6 L -6 -6 L -7 -7 L -7 -9 L -6 -11 L -4 -12 L -2 -12 L 0 -11 L 1 -9 L 1 -6 L -1 3 L -1 6 L 0 8 L 2 9 L 4 9 L 6 8 L 7 6 L 7 4 L 6 3 L 4 3 M 11 -9 L 11 -11 L 10 -12 L 8 -12 L 6 -11 L 4 -9 L 2 -6 L -2 3 L -4 6 L -6 8 L -8 9 L -10 9 L -11 8 L -11 6","-12 11 M -7 -5 L -9 -6 L -10 -8 L -10 -9 L -9 -11 L -7 -12 L -6 -12 L -4 -11 L -3 -9 L -3 -7 L -4 -3 L -5 0 L -6 4 L -6 6 L -5 8 L -4 9 L -2 9 L 0 8 L 2 6 L 4 3 L 5 1 L 7 -5 M 9 -12 L 7 -5 L 4 5 L 2 11 L 0 16 L -2 20 L -4 21 L -5 20 L -5 18 L -4 15 L -2 12 L 1 9 L 4 7 L 9 4","-10 11 M 3 -6 L 2 -4 L 1 -3 L -1 -2 L -3 -2 L -4 -4 L -4 -6 L -3 -9 L -1 -11 L 2 -12 L 5 -12 L 7 -11 L 8 -9 L 8 -5 L 7 -2 L 5 2 L 2 5 L -2 8 L -4 9 L -7 9 L -8 8 L -8 6 L -7 5 L -4 5 L -2 6 L -1 7 L 0 9 L 0 12 L -1 15 L -2 17 L -4 20 L -6 21 L -7 20 L -7 18 L -6 15 L -4 12 L -1 9 L 2 7 L 8 4","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-8 8 M -2 -6 L 0 -9 L 2 -6 M -5 -3 L 0 -8 L 5 -3 M 0 -8 L 0 9","-8 8 M -8 11 L 8 11","-5 6 M 4 -12 L 2 -10 L 1 -8 L 1 -7 L 2 -6 L 3 -7 L 2 -8","-6 10 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 6 L 4 0 L 3 5 L 3 8 L 4 9 L 5 9 L 7 8 L 8 7 L 10 4","-5 9 M -5 4 L -3 1 L 0 -4 L 1 -6 L 2 -9 L 2 -11 L 1 -12 L -1 -11 L -2 -9 L -3 -5 L -4 2 L -4 8 L -3 9 L -2 9 L 0 8 L 2 6 L 3 3 L 3 0 L 4 4 L 5 5 L 7 5 L 9 4","-5 6 M 2 2 L 2 1 L 1 0 L -1 0 L -3 1 L -4 2 L -5 4 L -5 6 L -4 8 L -2 9 L 1 9 L 4 7 L 6 4","-6 10 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 6 L 8 -12 M 4 0 L 3 5 L 3 8 L 4 9 L 5 9 L 7 8 L 8 7 L 10 4","-4 6 M -3 7 L -1 6 L 0 5 L 1 3 L 1 1 L 0 0 L -1 0 L -3 1 L -4 3 L -4 6 L -3 8 L -1 9 L 1 9 L 3 8 L 4 7 L 6 4","-3 5 M -3 4 L 1 -1 L 3 -4 L 4 -6 L 5 -9 L 5 -11 L 4 -12 L 2 -11 L 1 -9 L -1 -1 L -4 8 L -7 15 L -8 18 L -8 20 L -7 21 L -5 20 L -4 17 L -3 8 L -2 9 L 0 9 L 2 8 L 3 7 L 5 4","-6 9 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 7 M 4 0 L 2 7 L -2 18 L -3 20 L -5 21 L -6 20 L -6 18 L -5 15 L -2 12 L 1 10 L 3 9 L 6 7 L 9 4","-5 10 M -5 4 L -3 1 L 0 -4 L 1 -6 L 2 -9 L 2 -11 L 1 -12 L -1 -11 L -2 -9 L -3 -5 L -4 1 L -5 9 M -5 9 L -4 6 L -3 4 L -1 1 L 1 0 L 3 0 L 4 1 L 4 3 L 3 6 L 3 8 L 4 9 L 5 9 L 7 8 L 8 7 L 10 4","-2 5 M 1 -5 L 1 -4 L 2 -4 L 2 -5 L 1 -5 M -2 4 L 0 0 L -2 6 L -2 8 L -1 9 L 0 9 L 2 8 L 3 7 L 5 4","-2 5 M 1 -5 L 1 -4 L 2 -4 L 2 -5 L 1 -5 M -2 4 L 0 0 L -6 18 L -7 20 L -9 21 L -10 20 L -10 18 L -9 15 L -6 12 L -3 10 L -1 9 L 2 7 L 5 4","-5 9 M -5 4 L -3 1 L 0 -4 L 1 -6 L 2 -9 L 2 -11 L 1 -12 L -1 -11 L -2 -9 L -3 -5 L -4 1 L -5 9 M -5 9 L -4 6 L -3 4 L -1 1 L 1 0 L 3 0 L 4 1 L 4 3 L 2 4 L -1 4 M -1 4 L 1 5 L 2 8 L 3 9 L 4 9 L 6 8 L 7 7 L 9 4","-3 5 M -3 4 L -1 1 L 2 -4 L 3 -6 L 4 -9 L 4 -11 L 3 -12 L 1 -11 L 0 -9 L -1 -5 L -2 2 L -2 8 L -1 9 L 0 9 L 2 8 L 3 7 L 5 4","-13 12 M -13 4 L -11 1 L -9 0 L -8 1 L -8 2 L -9 6 L -10 9 M -9 6 L -8 4 L -6 1 L -4 0 L -2 0 L -1 1 L -1 2 L -2 6 L -3 9 M -2 6 L -1 4 L 1 1 L 3 0 L 5 0 L 6 1 L 6 3 L 5 6 L 5 8 L 6 9 L 7 9 L 9 8 L 10 7 L 12 4","-8 10 M -8 4 L -6 1 L -4 0 L -3 1 L -3 2 L -4 6 L -5 9 M -4 6 L -3 4 L -1 1 L 1 0 L 3 0 L 4 1 L 4 3 L 3 6 L 3 8 L 4 9 L 5 9 L 7 8 L 8 7 L 10 4","-6 8 M 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 2 7 L 3 5 L 3 3 L 2 1 L 0 0 L -1 1 L -1 3 L 0 5 L 2 6 L 5 6 L 7 5 L 8 4","-7 8 M -7 4 L -5 1 L -4 -1 L -5 3 L -11 21 M -5 3 L -4 1 L -2 0 L 0 0 L 2 1 L 3 3 L 3 5 L 2 7 L 1 8 L -1 9 M -5 8 L -3 9 L 0 9 L 3 8 L 5 7 L 8 4","-6 9 M 3 3 L 2 1 L 0 0 L -2 0 L -4 1 L -5 2 L -6 4 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 M 4 0 L 3 3 L 1 8 L -2 15 L -3 18 L -3 20 L -2 21 L 0 20 L 1 17 L 1 10 L 3 9 L 6 7 L 9 4","-5 8 M -5 4 L -3 1 L -2 -1 L -2 1 L 1 1 L 2 2 L 2 4 L 1 7 L 1 8 L 2 9 L 3 9 L 5 8 L 6 7 L 8 4","-4 7 M -4 4 L -2 1 L -1 -1 L -1 1 L 1 4 L 2 6 L 2 8 L 0 9 M -4 8 L -2 9 L 2 9 L 4 8 L 5 7 L 7 4","-3 6 M -3 4 L -1 1 L 1 -3 M 4 -12 L -2 6 L -2 8 L -1 9 L 1 9 L 3 8 L 4 7 L 6 4 M -2 -4 L 5 -4","-6 9 M -6 4 L -4 0 L -6 6 L -6 8 L -5 9 L -3 9 L -1 8 L 1 6 L 3 3 M 4 0 L 2 6 L 2 8 L 3 9 L 4 9 L 6 8 L 7 7 L 9 4","-6 9 M -6 4 L -4 0 L -5 5 L -5 8 L -4 9 L -3 9 L 0 8 L 2 6 L 3 3 L 3 0 M 3 0 L 4 4 L 5 5 L 7 5 L 9 4","-9 12 M -6 0 L -8 2 L -9 5 L -9 7 L -8 9 L -6 9 L -4 8 L -2 6 M 0 0 L -2 6 L -2 8 L -1 9 L 1 9 L 3 8 L 5 6 L 6 3 L 6 0 M 6 0 L 7 4 L 8 5 L 10 5 L 12 4","-8 8 M -8 4 L -6 1 L -4 0 L -2 0 L -1 1 L -1 8 L 0 9 L 3 9 L 6 7 L 8 4 M 5 1 L 4 0 L 2 0 L 1 1 L -3 8 L -4 9 L -6 9 L -7 8","-6 9 M -6 4 L -4 0 L -6 6 L -6 8 L -5 9 L -3 9 L -1 8 L 1 6 L 3 3 M 4 0 L -2 18 L -3 20 L -5 21 L -6 20 L -6 18 L -5 15 L -2 12 L 1 10 L 3 9 L 6 7 L 9 4","-6 8 M -6 4 L -4 1 L -2 0 L 0 0 L 2 2 L 2 4 L 1 6 L -1 8 L -4 9 L -2 10 L -1 12 L -1 15 L -2 18 L -3 20 L -5 21 L -6 20 L -6 18 L -5 15 L -2 12 L 1 10 L 5 7 L 8 4","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-7 7 M -1 -12 L -3 -11 L -4 -9 L -4 -7 L -3 -5 L -1 -4 L 1 -4 L 3 -5 L 4 -7 L 4 -9 L 3 -11 L 1 -12 L -1 -12"]
symbolic = ["-8 8","-14 14 M -14 0 L 14 0","-14 14 M -14 14 L 14 -14","0 0 M 0 -20 L 0 20","-14 14 M -14 -14 L 14 14","-14 14 M -14 0 L 14 0","-12 12 M -12 7 L 12 -7","-7 7 M -7 12 L 7 -12","0 0 M 0 -14 L 0 14","-7 7 M -7 -12 L 7 12","-12 12 M -12 -7 L 12 7","-7 7 M -7 0 L 7 0","-5 5 M -5 5 L 5 -5","0 0 M 0 -7 L 0 7","-5 5 M -5 -5 L 5 5","-11 0 M 0 -11 L -2 -11 L -5 -10 L -8 -8 L -10 -5 L -11 -2 L -11 0","-11 0 M -11 0 L -11 2 L -10 5 L -8 8 L -5 10 L -2 11 L 0 11","0 11 M 0 11 L 2 11 L 5 10 L 8 8 L 10 5 L 11 2 L 11 0","0 11 M 11 0 L 11 -2 L 10 -5 L 8 -8 L 5 -10 L 2 -11 L 0 -11","-14 14 M -14 -3 L -11 -1 L -7 1 L -2 2 L 2 2 L 7 1 L 11 -1 L 14 -3","-2 3 M 3 -14 L 1 -11 L -1 -7 L -2 -2 L -2 2 L -1 7 L 1 11 L 3 14","-3 2 M -3 -14 L -1 -11 L 1 -7 L 2 -2 L 2 2 L 1 7 L -1 11 L -3 14","-14 14 M -14 3 L -11 1 L -7 -1 L -2 -2 L 2 -2 L 7 -1 L 11 1 L 14 3","-7 7 M 0 -8 L 7 -4 L -7 4 L 0 8","-8 8 M -8 0 L -4 -7 L 4 7 L 8 0","-7 7 M -7 4 L -7 -4 L 7 4 L 7 -4","-8 8 M -6 6 L -8 -2 L 8 2 L 6 -6","-8 8 M -8 11 L -6 11 L -3 10 L -1 9 L 2 6 L 3 4 L 4 1 L 4 -3 L 3 -6 L 2 -8 L 1 -9 L -1 -9 L -2 -8 L -3 -6 L -4 -3 L -4 1 L -3 4 L -2 6 L 1 9 L 3 10 L 6 11 L 8 11","-9 11 M 11 8 L 11 6 L 10 3 L 9 1 L 6 -2 L 4 -3 L 1 -4 L -3 -4 L -6 -3 L -8 -2 L -9 -1 L -9 1 L -8 2 L -6 3 L -3 4 L 1 4 L 4 3 L 6 2 L 9 -1 L 10 -3 L 11 -6 L 11 -8","-8 8 M 8 -11 L 6 -11 L 3 -10 L 1 -9 L -2 -6 L -3 -4 L -4 -1 L -4 3 L -3 6 L -2 8 L -1 9 L 1 9 L 2 8 L 3 6 L 4 3 L 4 -1 L 3 -4 L 2 -6 L -1 -9 L -3 -10 L -6 -11 L -8 -11","-11 9 M -11 -8 L -11 -6 L -10 -3 L -9 -1 L -6 2 L -4 3 L -1 4 L 3 4 L 6 3 L 8 2 L 9 1 L 9 -1 L 8 -2 L 6 -3 L 3 -4 L -1 -4 L -4 -3 L -6 -2 L -9 1 L -10 3 L -11 6 L -11 8","-13 9 M -13 -2 L -12 0 L -10 2 L -8 3 L -5 4 L -1 4 L 3 3 L 6 1 L 8 -2 L 9 -4 L 8 -6 L 5 -6 L 1 -5 L -1 -4 L -4 -2 L -6 1 L -7 4 L -7 7 L -6 10 L -5 12","-13 7 M -13 2 L -10 4 L -7 5 L -2 5 L 1 4 L 4 2 L 6 -1 L 7 -4 L 7 -6 L 6 -7 L 4 -7 L 1 -6 L -2 -4 L -4 -1 L -5 2 L -5 7 L -4 10 L -2 13","-3 3 M -1 -3 L -3 -1 L -3 1 L -1 3 L 1 3 L 3 1 L 3 -1 L 1 -3 L -1 -3 M -1 -2 L -2 -1 L -2 1 L -1 2 L 1 2 L 2 1 L 2 -1 L 1 -2 L -1 -2 M 0 -1 L -1 0 L 0 1 L 1 0 L 0 -1","0 5 M 0 -5 L 1 -5 L 3 -4 L 4 -3 L 5 -1 L 5 1 L 4 3 L 3 4 L 1 5 L 0 5","-14 14 M -14 0 L -8 0 M -3 0 L 3 0 M 8 0 L 14 0","-14 14 M -14 3 L -14 -3 L 14 -3 L 14 3","-8 8 M 0 -14 L -8 0 M 0 -14 L 8 0","-14 14 M -14 0 L 14 0 M -8 7 L 8 7 M -2 14 L 2 14","-14 14 M -14 0 L 14 0 M -14 0 L 0 16 M 14 0 L 0 16","-7 7 M -1 -7 L -4 -6 L -6 -4 L -7 -1 L -7 1 L -6 4 L -4 6 L -1 7 L 1 7 L 4 6 L 6 4 L 7 1 L 7 -1 L 6 -4 L 4 -6 L 1 -7 L -1 -7","-6 6 M -6 -6 L -6 6 L 6 6 L 6 -6 L -6 -6","-7 7 M 0 -8 L -7 4 L 7 4 L 0 -8","-6 6 M 0 -10 L -6 0 L 0 10 L 6 0 L 0 -10","-8 8 M 0 -9 L -2 -3 L -8 -3 L -3 1 L -5 7 L 0 3 L 5 7 L 3 1 L 8 -3 L 2 -3 L 0 -9","-7 7 M 0 -7 L 0 7 M -7 0 L 7 0","-5 5 M -5 -5 L 5 5 M 5 -5 L -5 5","-5 5 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-4 4 M -1 -4 L -3 -3 L -4 -1 L -4 1 L -3 3 L -1 4 L 1 4 L 3 3 L 4 1 L 4 -1 L 3 -3 L 1 -4 L -1 -4 M -3 -1 L -3 1 M -2 -2 L -2 2 M -1 -3 L -1 3 M 0 -3 L 0 3 M 1 -3 L 1 3 M 2 -2 L 2 2 M 3 -1 L 3 1","-4 4 M -4 -4 L -4 4 L 4 4 L 4 -4 L -4 -4 M -3 -3 L -3 3 M -2 -3 L -2 3 M -1 -3 L -1 3 M 0 -3 L 0 3 M 1 -3 L 1 3 M 2 -3 L 2 3 M 3 -3 L 3 3","-5 5 M 0 -6 L -5 3 L 5 3 L 0 -6 M 0 -3 L -3 2 M 0 -3 L 3 2 M 0 0 L -1 2 M 0 0 L 1 2","-6 3 M -6 0 L 3 5 L 3 -5 L -6 0 M -3 0 L 2 3 M -3 0 L 2 -3 M 0 0 L 2 1 M 0 0 L 2 -1","-5 5 M 0 6 L 5 -3 L -5 -3 L 0 6 M 0 3 L 3 -2 M 0 3 L -3 -2 M 0 0 L 1 -2 M 0 0 L -1 -2","-3 6 M 6 0 L -3 -5 L -3 5 L 6 0 M 3 0 L -2 -3 M 3 0 L -2 3 M 0 0 L -2 -1 M 0 0 L -2 1","0 7 M 0 -7 L 0 7 M 0 -7 L 7 -4 L 0 -1 M 1 -5 L 4 -4 L 1 -3","-9 9 M 0 -11 L 0 4 M -5 -8 L 5 -2 M 5 -8 L -5 -2 M -9 4 L -6 10 M 9 4 L 6 10 M -9 4 L 9 4 M -6 10 L 6 10","-5 5 M 0 -6 L 0 6 M -3 -3 L 3 -3 M -5 3 L -3 5 L -1 6 L 1 6 L 3 5 L 5 3","-6 6 M 0 -6 L 0 6 M -6 -1 L -5 -3 L 5 -3 L 6 -1 M -2 5 L 2 5","-7 7 M -5 -4 L 5 6 M 5 -4 L -5 6 M -3 -6 L -6 -3 L -7 -1 M 3 -6 L 6 -3 L 7 -1","-9 9 M -4 -9 L -9 9 M 4 -9 L 9 9 M -5 -5 L 9 9 M 5 -5 L -9 9 M -4 -9 L 4 -9 M -5 -5 L 5 -5","-7 7 M -7 -12 L 7 12","-11 9 M -5 -8 L 1 4 M -7 -2 L 1 -6 M -11 10 L 9 10 L 9 0 L -11 10","-6 6 M -2 -6 L -2 -2 L -6 -2 L -6 2 L -2 2 L -2 6 L 2 6 L 2 2 L 6 2 L 6 -2 L 2 -2 L 2 -6 L -2 -6","-7 7 M 7 -2 L 6 -4 L 4 -6 L 1 -7 L -1 -7 L -4 -6 L -6 -4 L -7 -1 L -7 1 L -6 4 L -4 6 L -1 7 L 1 7 L 4 6 L 6 4 L 7 2 M 7 -2 L 5 -4 L 3 -5 L 1 -5 L -1 -4 L -2 -3 L -3 -1 L -3 1 L -2 3 L -1 4 L 1 5 L 3 5 L 5 4 L 7 2","-7 7 M 0 -8 L -7 4 L 7 4 L 0 -8 M 0 8 L 7 -4 L -7 -4 L 0 8","-11 11 M -2 -9 L -2 -11 L -1 -12 L 1 -12 L 2 -11 L 2 -9 M -11 8 L -10 6 L -8 4 L -7 2 L -6 -2 L -6 -7 L -5 -8 L -3 -9 L 3 -9 L 5 -8 L 6 -7 L 6 -2 L 7 2 L 8 4 L 10 6 L 11 8 M -11 8 L 11 8 M -1 8 L -2 9 L -1 10 L 1 10 L 2 9 L 1 8","-8 8 M 0 -5 L 0 1 M 0 1 L -1 10 M 0 1 L 1 10 M -1 10 L 1 10 M 0 -5 L -1 -8 L -2 -10 L -4 -11 M -1 -8 L -4 -11 M 0 -5 L 1 -8 L 2 -10 L 4 -11 M 1 -8 L 4 -11 M 0 -5 L -4 -7 L -6 -7 L -8 -5 M -2 -6 L -6 -6 L -8 -5 M 0 -5 L 4 -7 L 6 -7 L 8 -5 M 2 -6 L 6 -6 L 8 -5 M 0 -5 L -2 -4 L -3 -3 L -3 0 M 0 -5 L -2 -3 L -3 0 M 0 -5 L 2 -4 L 3 -3 L 3 0 M 0 -5 L 2 -3 L 3 0","-8 8 M 0 -9 L 0 -7 M 0 -4 L 0 -2 M 0 1 L 0 3 M 0 7 L -1 10 M 0 7 L 1 10 M -1 10 L 1 10 M 0 -11 L -1 -9 L -2 -8 M 0 -11 L 1 -9 L 2 -8 M -2 -8 L 0 -9 L 2 -8 M 0 -7 L -2 -4 L -4 -3 L -5 -4 M 0 -7 L 2 -4 L 4 -3 L 5 -4 M -4 -3 L -2 -3 L 0 -4 L 2 -3 L 4 -3 M 0 -2 L -2 1 L -4 2 L -6 2 L -7 0 L -7 1 L -6 2 M 0 -2 L 2 1 L 4 2 L 6 2 L 7 0 L 7 1 L 6 2 M -4 2 L -2 2 L 0 1 L 2 2 L 4 2 M 0 3 L -2 6 L -3 7 L -5 8 L -6 8 L -7 7 L -8 5 L -8 7 L -6 8 M 0 3 L 2 6 L 3 7 L 5 8 L 6 8 L 7 7 L 8 5 L 8 7 L 6 8 M -5 8 L -3 8 L 0 7 L 3 8 L 5 8","-8 8 M 0 7 L -1 10 M 0 7 L 1 10 M -1 10 L 1 10 M 0 7 L 3 8 L 6 8 L 8 6 L 8 3 L 7 2 L 5 2 L 7 0 L 8 -3 L 7 -5 L 5 -6 L 3 -5 L 4 -8 L 3 -10 L 1 -11 L -1 -11 L -3 -10 L -4 -8 L -3 -5 L -5 -6 L -7 -5 L -8 -3 L -7 0 L -5 2 L -7 2 L -8 3 L -8 6 L -6 8 L -3 8 L 0 7","-8 8 M 0 7 L -1 10 M 0 7 L 1 10 M -1 10 L 1 10 M 0 7 L 4 6 L 4 4 L 6 3 L 6 0 L 8 -1 L 8 -6 L 7 -9 L 6 -10 L 4 -10 L 2 -11 L -2 -11 L -4 -10 L -6 -10 L -7 -9 L -8 -6 L -8 -1 L -6 0 L -6 3 L -4 4 L -4 6 L 0 7","-9 9 M -9 -2 L -7 0 M -6 -7 L -4 -2 M 0 -11 L 0 -3 M 6 -7 L 4 -2 M 9 -2 L 7 0","-11 11 M -9 -9 L -8 -7 L -7 -3 L -7 3 L -8 7 L -9 9 M 9 -9 L 8 -7 L 7 -3 L 7 3 L 8 7 L 9 9 M -9 -9 L -7 -8 L -3 -7 L 3 -7 L 7 -8 L 9 -9 M -9 9 L -7 8 L -3 7 L 3 7 L 7 8 L 9 9","-12 12 M 0 0 L 0 9 L -1 10 M 0 4 L -1 10 M 0 -9 L -1 -10 L -3 -10 L -4 -9 L -4 -7 L -3 -4 L 0 0 M 0 -9 L 1 -10 L 3 -10 L 4 -9 L 4 -7 L 3 -4 L 0 0 M 0 0 L -4 -3 L -6 -4 L -8 -4 L -9 -3 L -9 -1 L -8 0 M 0 0 L 4 -3 L 6 -4 L 8 -4 L 9 -3 L 9 -1 L 8 0 M 0 0 L -4 3 L -6 4 L -8 4 L -9 3 L -9 1 L -8 0 M 0 0 L 4 3 L 6 4 L 8 4 L 9 3 L 9 1 L 8 0","-8 8 M 3 -9 L 2 -8 L 3 -7 L 4 -8 L 4 -9 L 3 -11 L 1 -12 L -1 -12 L -3 -11 L -4 -9 L -4 -7 L -3 -5 L -1 -3 L 4 0 M -3 -5 L 2 -2 L 4 0 L 5 2 L 5 4 L 4 6 L 2 8 M -2 -4 L -4 -2 L -5 0 L -5 2 L -4 4 L -2 6 L 3 9 M -4 4 L 1 7 L 3 9 L 4 11 L 4 13 L 3 15 L 1 16 L -1 16 L -3 15 L -4 13 L -4 12 L -3 11 L -2 12 L -3 13","-8 8 M 0 -12 L -1 -10 L 0 -8 L 1 -10 L 0 -12 M 0 -12 L 0 16 M 0 -1 L -1 2 L 0 16 L 1 2 L 0 -1 M -6 -5 L -4 -4 L -2 -5 L -4 -6 L -6 -5 M -6 -5 L 6 -5 M 2 -5 L 4 -4 L 6 -5 L 4 -6 L 2 -5","-8 8 M 0 -12 L -1 -10 L 0 -8 L 1 -10 L 0 -12 M 0 -12 L 0 2 M 0 -2 L -1 0 L 1 4 L 0 6 L -1 4 L 1 0 L 0 -2 M 0 2 L 0 16 M 0 12 L -1 14 L 0 16 L 1 14 L 0 12 M -6 -5 L -4 -4 L -2 -5 L -4 -6 L -6 -5 M -6 -5 L 6 -5 M 2 -5 L 4 -4 L 6 -5 L 4 -6 L 2 -5 M -6 9 L -4 10 L -2 9 L -4 8 L -6 9 M -6 9 L 6 9 M 2 9 L 4 10 L 6 9 L 4 8 L 2 9","-13 13 M 0 -9 L -1 -8 L 0 -7 L 1 -8 L 0 -9 M -9 7 L -10 8 L -9 9 L -8 8 L -9 7 M 9 7 L 8 8 L 9 9 L 10 8 L 9 7","-12 12 M 0 -10 L -4 -6 L -7 -2 L -8 1 L -8 3 L -7 5 L -5 6 L -3 6 L -1 5 L 0 3 M 0 -10 L 4 -6 L 7 -2 L 8 1 L 8 3 L 7 5 L 5 6 L 3 6 L 1 5 L 0 3 M 0 3 L -1 7 L -2 10 M 0 3 L 1 7 L 2 10 M -2 10 L 2 10","-12 12 M 0 -4 L -1 -7 L -2 -9 L -4 -10 L -5 -10 L -7 -9 L -8 -7 L -8 -3 L -7 0 L -6 2 L -4 5 L 0 10 M 0 -4 L 1 -7 L 2 -9 L 4 -10 L 5 -10 L 7 -9 L 8 -7 L 8 -3 L 7 0 L 6 2 L 4 5 L 0 10","-12 12 M 0 -11 L -2 -8 L -6 -3 L -9 0 M 0 -11 L 2 -8 L 6 -3 L 9 0 M -9 0 L -6 3 L -2 8 L 0 11 M 9 0 L 6 3 L 2 8 L 0 11","-12 12 M 0 2 L 2 5 L 4 6 L 6 6 L 8 5 L 9 3 L 9 1 L 8 -1 L 6 -2 L 4 -2 L 1 -1 M 1 -1 L 3 -3 L 4 -5 L 4 -7 L 3 -9 L 1 -10 L -1 -10 L -3 -9 L -4 -7 L -4 -5 L -3 -3 L -1 -1 M -1 -1 L -4 -2 L -6 -2 L -8 -1 L -9 1 L -9 3 L -8 5 L -6 6 L -4 6 L -2 5 L 0 2 M 0 2 L -1 7 L -2 10 M 0 2 L 1 7 L 2 10 M -2 10 L 2 10","-9 9 M 4 -39 L 1 -37 L -1 -35 L -2 -33 L -3 -30 L -3 -26 L -2 -22 L 2 -14 L 3 -11 L 3 -8 L 2 -5 L 0 -2 M 1 -37 L -1 -34 L -2 -30 L -2 -26 L -1 -23 L 3 -15 L 4 -11 L 4 -8 L 3 -5 L 0 -2 L -4 0 L 0 2 L 3 5 L 4 8 L 4 11 L 3 15 L -1 23 L -2 26 L -2 30 L -1 34 L 1 37 M 0 2 L 2 5 L 3 8 L 3 11 L 2 14 L -2 22 L -3 26 L -3 30 L -2 33 L -1 35 L 1 37 L 4 39","-9 9 M -4 -39 L -1 -37 L 1 -35 L 2 -33 L 3 -30 L 3 -26 L 2 -22 L -2 -14 L -3 -11 L -3 -8 L -2 -5 L 0 -2 M -1 -37 L 1 -34 L 2 -30 L 2 -26 L 1 -23 L -3 -15 L -4 -11 L -4 -8 L -3 -5 L 0 -2 L 4 0 L 0 2 L -3 5 L -4 8 L -4 11 L -3 15 L 1 23 L 2 26 L 2 30 L 1 34 L -1 37 M 0 2 L -2 5 L -3 8 L -3 11 L -2 14 L 2 22 L 3 26 L 3 30 L 2 33 L 1 35 L -1 37 L -4 39","-9 9 M 4 -36 L 1 -33 L -1 -30 L -3 -26 L -4 -21 L -4 -15 L -3 -9 L -2 -5 L 1 6 L 2 10 L 3 16 L 3 21 L 2 26 L 1 29 L -1 33 M 1 -33 L -1 -29 L -2 -26 L -3 -21 L -3 -16 L -2 -10 L -1 -6 L 2 5 L 3 9 L 4 15 L 4 21 L 3 26 L 1 30 L -1 33 L -4 36","-9 9 M -4 -36 L -1 -33 L 1 -30 L 3 -26 L 4 -21 L 4 -15 L 3 -9 L 2 -5 L -1 6 L -2 10 L -3 16 L -3 21 L -2 26 L -1 29 L 1 33 M -1 -33 L 1 -29 L 2 -26 L 3 -21 L 3 -16 L 2 -10 L 1 -6 L -2 5 L -3 9 L -4 15 L -4 21 L -3 26 L -1 30 L 1 33 L 4 36","-27 8 M -24 0 L -17 0 L 0 29 M -18 0 L -1 29 M -19 0 L 0 32 M 8 -48 L 4 -8 L 0 32","-9 9 M 2 -5 L 4 -4 L 6 -2 L 6 -3 L 5 -4 L 2 -5 L -1 -5 L -4 -4 L -5 -3 L -6 -1 L -6 1 L -5 3 L -3 5 L 1 8 M -1 -5 L -3 -4 L -4 -3 L -5 -1 L -5 1 L -4 3 L 1 8 L 2 10 L 2 12 L 1 13 L -1 13","-11 11 M -6 -5 L -7 -4 L -8 -2 L -8 0 L -7 3 L -3 7 L -2 9 M -8 0 L -7 2 L -3 6 L -2 9 L -2 11 L -3 14 L -5 16 L -6 16 L -7 15 L -8 13 L -8 10 L -7 6 L -5 2 L -3 -1 L 0 -4 L 2 -5 L 4 -5 L 7 -4 L 8 -2 L 8 2 L 7 6 L 5 8 L 3 9 L 2 9 L 1 8 L 1 6 L 2 5 L 3 6 L 2 7 M 4 -5 L 6 -4 L 7 -2 L 7 2 L 6 6 L 5 8","-13 13 M 7 -11 L 6 -10 L 7 -9 L 8 -10 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -4 -7 L -5 -4 L -6 0 L -8 9 L -9 13 L -10 15 M 2 -12 L 0 -11 L -2 -9 L -3 -7 L -4 -4 L -6 5 L -7 9 L -8 12 L -9 14 L -10 15 L -12 16 L -14 16 L -15 15 L -15 14 L -14 13 L -13 14 L -14 15 M 13 -11 L 12 -10 L 13 -9 L 14 -10 L 14 -11 L 13 -12 L 11 -12 L 9 -11 L 8 -10 L 7 -8 L 6 -5 L 3 9 L 2 13 L 1 15 M 11 -12 L 9 -10 L 8 -8 L 7 -4 L 5 5 L 4 9 L 3 12 L 2 14 L 1 15 L -1 16 L -3 16 L -4 15 L -4 14 L -3 13 L -2 14 L -3 15 M -9 -5 L 12 -5","-12 12 M 9 -11 L 8 -10 L 9 -9 L 10 -10 L 9 -11 L 6 -12 L 3 -12 L 0 -11 L -2 -9 L -3 -7 L -4 -4 L -5 0 L -7 9 L -8 13 L -9 15 M 3 -12 L 1 -11 L -1 -9 L -2 -7 L -3 -4 L -5 5 L -6 9 L -7 12 L -8 14 L -9 15 L -11 16 L -13 16 L -14 15 L -14 14 L -13 13 L -12 14 L -13 15 M 7 -5 L 5 2 L 4 6 L 4 8 L 5 9 L 8 9 L 10 7 L 11 5 M 8 -5 L 6 2 L 5 6 L 5 8 L 6 9 M -8 -5 L 8 -5","-12 12 M 7 -11 L 6 -10 L 7 -9 L 8 -10 L 8 -11 L 6 -12 M 10 -12 L 3 -12 L 0 -11 L -2 -9 L -3 -7 L -4 -4 L -5 0 L -7 9 L -8 13 L -9 15 M 3 -12 L 1 -11 L -1 -9 L -2 -7 L -3 -4 L -5 5 L -6 9 L -7 12 L -8 14 L -9 15 L -11 16 L -13 16 L -14 15 L -14 14 L -13 13 L -12 14 L -13 15 M 9 -12 L 5 2 L 4 6 L 4 8 L 5 9 L 8 9 L 10 7 L 11 5 M 10 -12 L 6 2 L 5 6 L 5 8 L 6 9 M -8 -5 L 7 -5","-18 17 M 2 -11 L 1 -10 L 2 -9 L 3 -10 L 2 -11 L 0 -12 L -3 -12 L -6 -11 L -8 -9 L -9 -7 L -10 -4 L -11 0 L -13 9 L -14 13 L -15 15 M -3 -12 L -5 -11 L -7 -9 L -8 -7 L -9 -4 L -11 5 L -12 9 L -13 12 L -14 14 L -15 15 L -17 16 L -19 16 L -20 15 L -20 14 L -19 13 L -18 14 L -19 15 M 14 -11 L 13 -10 L 14 -9 L 15 -10 L 14 -11 L 11 -12 L 8 -12 L 5 -11 L 3 -9 L 2 -7 L 1 -4 L 0 0 L -2 9 L -3 13 L -4 15 M 8 -12 L 6 -11 L 4 -9 L 3 -7 L 2 -4 L 0 5 L -1 9 L -2 12 L -3 14 L -4 15 L -6 16 L -8 16 L -9 15 L -9 14 L -8 13 L -7 14 L -8 15 M 12 -5 L 10 2 L 9 6 L 9 8 L 10 9 L 13 9 L 15 7 L 16 5 M 13 -5 L 11 2 L 10 6 L 10 8 L 11 9 M -14 -5 L 13 -5","-18 17 M 2 -11 L 1 -10 L 2 -9 L 3 -10 L 2 -11 L 0 -12 L -3 -12 L -6 -11 L -8 -9 L -9 -7 L -10 -4 L -11 0 L -13 9 L -14 13 L -15 15 M -3 -12 L -5 -11 L -7 -9 L -8 -7 L -9 -4 L -11 5 L -12 9 L -13 12 L -14 14 L -15 15 L -17 16 L -19 16 L -20 15 L -20 14 L -19 13 L -18 14 L -19 15 M 12 -11 L 11 -10 L 12 -9 L 13 -10 L 13 -11 L 11 -12 M 15 -12 L 8 -12 L 5 -11 L 3 -9 L 2 -7 L 1 -4 L 0 0 L -2 9 L -3 13 L -4 15 M 8 -12 L 6 -11 L 4 -9 L 3 -7 L 2 -4 L 0 5 L -1 9 L -2 12 L -3 14 L -4 15 L -6 16 L -8 16 L -9 15 L -9 14 L -8 13 L -7 14 L -8 15 M 14 -12 L 10 2 L 9 6 L 9 8 L 10 9 L 13 9 L 15 7 L 16 5 M 15 -12 L 11 2 L 10 6 L 10 8 L 11 9 M -14 -5 L 12 -5","-6 7 M -5 -1 L -4 -3 L -2 -5 L 1 -5 L 2 -4 L 2 -1 L 0 5 L 0 8 L 1 9 M 0 -5 L 1 -4 L 1 -1 L -1 5 L -1 8 L 0 9 L 3 9 L 5 7 L 6 5","-6 6 M 0 -6 L -4 5 L 6 -2 L -6 -2 L 4 5 L 0 -6 M 0 0 L 0 -6 M 0 0 L -6 -2 M 0 0 L -4 5 M 0 0 L 4 5 M 0 0 L 6 -2","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3"]
timesg = ["-8 8","-5 5 M 0 -12 L -1 -10 L 0 2 L 1 -10 L 0 -12 M 0 -10 L 0 -4 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-8 8 M -4 -12 L -5 -5 M -3 -12 L -5 -5 M 4 -12 L 3 -5 M 5 -12 L 3 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 10 M -2 -16 L -2 13 M 2 -16 L 2 13 M 6 -9 L 5 -8 L 6 -7 L 7 -8 L 7 -9 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 7 2 M -7 -7 L -5 -5 L -3 -4 L 3 -2 L 5 -1 L 6 0 L 7 2 L 7 6 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6 L -7 5 L -6 4 L -5 5 L -6 6","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-12 13 M 9 -4 L 8 -3 L 9 -2 L 10 -3 L 10 -4 L 9 -5 L 8 -5 L 7 -4 L 6 -2 L 4 3 L 2 6 L 0 8 L -2 9 L -5 9 L -8 8 L -9 6 L -9 3 L -8 1 L -2 -3 L 0 -5 L 1 -7 L 1 -9 L 0 -11 L -2 -12 L -4 -11 L -5 -9 L -5 -7 L -4 -4 L -2 -1 L 3 6 L 5 8 L 8 9 L 9 9 L 10 8 L 10 7 M -5 9 L -7 8 L -8 6 L -8 3 L -7 1 L -5 -1 M -5 -7 L -4 -5 L 4 6 L 6 8 L 8 9","-4 4 M 0 -12 L -1 -5 M 1 -12 L -1 -5","-7 7 M 3 -16 L 1 -14 L -1 -11 L -3 -7 L -4 -2 L -4 2 L -3 7 L -1 11 L 1 14 L 3 16 L 4 16 M 3 -16 L 4 -16 L 2 -14 L 0 -11 L -2 -7 L -3 -2 L -3 2 L -2 7 L 0 11 L 2 14 L 4 16","-7 7 M -4 -16 L -2 -14 L 0 -11 L 2 -7 L 3 -2 L 3 2 L 2 7 L 0 11 L -2 14 L -4 16 L -3 16 M -4 -16 L -3 -16 L -1 -14 L 1 -11 L 3 -7 L 4 -2 L 4 2 L 3 7 L 1 11 L -1 14 L -3 16","-8 8 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-13 13 M 0 -9 L 0 9 M -9 0 L 9 0","-4 4 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-13 13 M -9 0 L 9 0","-4 4 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-11 11 M 9 -16 L -9 16","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12 M -1 -12 L -3 -11 L -4 -10 L -5 -8 L -6 -3 L -6 0 L -5 5 L -4 7 L -3 8 L -1 9 M 1 9 L 3 8 L 4 7 L 5 5 L 6 0 L 6 -3 L 5 -8 L 4 -10 L 3 -11 L 1 -12","-10 10 M -4 -8 L -2 -9 L 1 -12 L 1 9 M 0 -11 L 0 9 M -4 9 L 5 9","-10 10 M -6 -8 L -5 -7 L -6 -6 L -7 -7 L -7 -8 L -6 -10 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 3 -2 L -2 0 L -4 1 L -6 3 L -7 6 L -7 9 M 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 2 -2 L -2 0 M -7 7 L -6 6 L -4 6 L 1 8 L 4 8 L 6 7 L 7 6 M -4 6 L 1 9 L 5 9 L 6 8 L 7 6 L 7 4","-10 10 M -6 -8 L -5 -7 L -6 -6 L -7 -7 L -7 -8 L -6 -10 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -9 L 6 -6 L 5 -4 L 2 -3 L -1 -3 M 2 -12 L 4 -11 L 5 -9 L 5 -6 L 4 -4 L 2 -3 M 2 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 4 L -6 5 M 5 -1 L 6 2 L 6 5 L 5 7 L 4 8 L 2 9","-10 10 M 2 -10 L 2 9 M 3 -12 L 3 9 M 3 -12 L -8 3 L 8 3 M -1 9 L 6 9","-10 10 M -5 -12 L -7 -2 M -7 -2 L -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 4 L -6 5 M 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 M -5 -12 L 5 -12 M -5 -11 L 0 -11 L 5 -12","-10 10 M 5 -9 L 4 -8 L 5 -7 L 6 -8 L 6 -9 L 5 -11 L 3 -12 L 0 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -3 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 L -3 -3 L -5 -1 L -6 2 M 0 -12 L -2 -11 L -4 -9 L -5 -7 L -6 -3 L -6 3 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 3 L 6 2 L 5 -1 L 3 -3 L 1 -4","-10 10 M -7 -12 L -7 -6 M -7 -8 L -6 -10 L -4 -12 L -2 -12 L 3 -9 L 5 -9 L 6 -10 L 7 -12 M -6 -10 L -4 -11 L -2 -11 L 3 -9 M 7 -12 L 7 -9 L 6 -6 L 2 -1 L 1 1 L 0 4 L 0 9 M 6 -6 L 1 -1 L 0 1 L -1 4 L -1 9","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -6 L -5 -4 L -2 -3 L 2 -3 L 5 -4 L 6 -6 L 6 -9 L 5 -11 L 2 -12 L -2 -12 M -2 -12 L -4 -11 L -5 -9 L -5 -6 L -4 -4 L -2 -3 M 2 -3 L 4 -4 L 5 -6 L 5 -9 L 4 -11 L 2 -12 M -2 -3 L -5 -2 L -6 -1 L -7 1 L -7 5 L -6 7 L -5 8 L -2 9 L 2 9 L 5 8 L 6 7 L 7 5 L 7 1 L 6 -1 L 5 -2 L 2 -3 M -2 -3 L -4 -2 L -5 -1 L -6 1 L -6 5 L -5 7 L -4 8 L -2 9 M 2 9 L 4 8 L 5 7 L 6 5 L 6 1 L 5 -1 L 4 -2 L 2 -3","-10 10 M 6 -5 L 5 -2 L 3 0 L 0 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -6 L 7 0 L 6 4 L 5 6 L 3 8 L 0 9 L -3 9 L -5 8 L -6 6 L -6 5 L -5 4 L -4 5 L -5 6 M -1 1 L -3 0 L -5 -2 L -6 -5 L -6 -6 L -5 -9 L -3 -11 L -1 -12 M 1 -12 L 3 -11 L 5 -9 L 6 -6 L 6 0 L 5 4 L 4 6 L 2 8 L 0 9","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-12 12 M 8 -9 L -8 0 L 8 9","-13 13 M -9 -3 L 9 -3 M -9 3 L 9 3","-12 12 M -8 -9 L 8 0 L -8 9","-9 9 M -5 -8 L -4 -7 L -5 -6 L -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 1 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 4 -3 L 0 -1 L 0 2 M 1 -12 L 3 -11 L 4 -10 L 5 -8 L 5 -6 L 4 -4 L 2 -2 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-10 10 M 0 -12 L -7 9 M 0 -12 L 7 9 M 0 -9 L 6 9 M -5 3 L 4 3 M -9 9 L -3 9 M 3 9 L 9 9","-11 11 M -6 -12 L -6 9 M -5 -12 L -5 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -6 L 7 -4 L 6 -3 L 3 -2 M 3 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 3 -2 M -5 -2 L 3 -2 L 6 -1 L 7 0 L 8 2 L 8 5 L 7 7 L 6 8 L 3 9 L -9 9 M 3 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 3 9","-10 10 M -7 -12 L 6 9 M -6 -12 L 7 9 M 7 -12 L -7 9 M -9 -12 L -3 -12 M 3 -12 L 9 -12 M -9 9 L -3 9 M 3 9 L 9 9","-10 10 M 0 -12 L -8 9 M 0 -12 L 8 9 M 0 -9 L 7 9 M -7 8 L 7 8 M -8 9 L 8 9","-11 10 M -6 -12 L -6 9 M -5 -12 L -5 9 M 1 -6 L 1 2 M -9 -12 L 7 -12 L 7 -6 L 6 -12 M -5 -2 L 1 -2 M -9 9 L 7 9 L 7 3 L 6 9","-10 11 M 0 -12 L 0 9 M 1 -12 L 1 9 M -2 -7 L -5 -6 L -6 -5 L -7 -3 L -7 0 L -6 2 L -5 3 L -2 4 L 3 4 L 6 3 L 7 2 L 8 0 L 8 -3 L 7 -5 L 6 -6 L 3 -7 L -2 -7 M -2 -7 L -4 -6 L -5 -5 L -6 -3 L -6 0 L -5 2 L -4 3 L -2 4 M 3 4 L 5 3 L 6 2 L 7 0 L 7 -3 L 6 -5 L 5 -6 L 3 -7 M -3 -12 L 4 -12 M -3 9 L 4 9","-9 9 M -4 -12 L -4 9 M -3 -12 L -3 9 M -7 -12 L 8 -12 L 8 -6 L 7 -12 M -7 9 L 0 9","-12 12 M -7 -12 L -7 9 M -6 -12 L -6 9 M 6 -12 L 6 9 M 7 -12 L 7 9 M -10 -12 L -3 -12 M 3 -12 L 10 -12 M -6 -2 L 6 -2 M -10 9 L -3 9 M 3 9 L 10 9","-5 6 M 0 -12 L 0 9 M 1 -12 L 1 9 M -3 -12 L 4 -12 M -3 9 L 4 9","-2 3 M 0 -1 L 0 0 L 1 0 L 1 -1 L 0 -1","-12 10 M -7 -12 L -7 9 M -6 -12 L -6 9 M 7 -12 L -6 1 M -1 -3 L 7 9 M -2 -3 L 6 9 M -10 -12 L -3 -12 M 3 -12 L 9 -12 M -10 9 L -3 9 M 3 9 L 9 9","-10 10 M 0 -12 L -7 9 M 0 -12 L 7 9 M 0 -9 L 6 9 M -9 9 L -3 9 M 3 9 L 9 9","-12 13 M -7 -12 L -7 9 M -6 -12 L 0 6 M -7 -12 L 0 9 M 7 -12 L 0 9 M 7 -12 L 7 9 M 8 -12 L 8 9 M -10 -12 L -6 -12 M 7 -12 L 11 -12 M -10 9 L -4 9 M 4 9 L 11 9","-11 12 M -6 -12 L -6 9 M -5 -12 L 7 7 M -5 -10 L 7 9 M 7 -12 L 7 9 M -9 -12 L -5 -12 M 4 -12 L 10 -12 M -9 9 L -3 9","-11 11 M -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -3 L -8 0 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 4 L 8 0 L 8 -3 L 7 -7 L 6 -9 L 4 -11 L 1 -12 L -1 -12 M -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -3 L -7 0 L -6 4 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 4 L 7 0 L 7 -3 L 6 -7 L 5 -9 L 3 -11 L 1 -12","-12 12 M -7 -12 L -7 9 M -6 -12 L -6 9 M 6 -12 L 6 9 M 7 -12 L 7 9 M -10 -12 L 10 -12 M -10 9 L -3 9 M 3 9 L 10 9","-11 11 M -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -3 L -8 0 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 4 L 8 0 L 8 -3 L 7 -7 L 6 -9 L 4 -11 L 1 -12 L -1 -12 M -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -3 L -7 0 L -6 4 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 4 L 7 0 L 7 -3 L 6 -7 L 5 -9 L 3 -11 L 1 -12 M -3 -5 L -3 2 M 3 -5 L 3 2 M -3 -2 L 3 -2 M -3 -1 L 3 -1","-11 11 M -6 -12 L -6 9 M -5 -12 L -5 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -5 L 7 -3 L 6 -2 L 3 -1 L -5 -1 M 3 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -5 L 6 -3 L 5 -2 L 3 -1 M -9 9 L -2 9","-10 11 M -7 -12 L 0 -2 L -8 9 M -8 -12 L -1 -2 M -8 -12 L 7 -12 L 8 -6 L 6 -12 M -7 8 L 6 8 M -8 9 L 7 9 L 8 3 L 6 9","-9 10 M 0 -12 L 0 9 M 1 -12 L 1 9 M -6 -12 L -7 -6 L -7 -12 L 8 -12 L 8 -6 L 7 -12 M -3 9 L 4 9","-9 10 M -7 -7 L -7 -9 L -6 -11 L -5 -12 L -3 -12 L -2 -11 L -1 -9 L 0 -5 L 0 9 M -7 -9 L -5 -11 L -3 -11 L -1 -9 M 8 -7 L 8 -9 L 7 -11 L 6 -12 L 4 -12 L 3 -11 L 2 -9 L 1 -5 L 1 9 M 8 -9 L 6 -11 L 4 -11 L 2 -9 M -3 9 L 4 9","-7 7 M -1 -12 L -3 -11 L -4 -9 L -4 -7 L -3 -5 L -1 -4 L 1 -4 L 3 -5 L 4 -7 L 4 -9 L 3 -11 L 1 -12 L -1 -12","-11 11 M -8 6 L -7 9 L -3 9 L -5 5 L -7 1 L -8 -2 L -8 -6 L -7 -9 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 7 -9 L 8 -6 L 8 -2 L 7 1 L 5 5 L 3 9 L 7 9 L 8 6 M -5 5 L -6 2 L -7 -2 L -7 -6 L -6 -9 L -4 -11 L -2 -12 M 2 -12 L 4 -11 L 6 -9 L 7 -6 L 7 -2 L 6 2 L 5 5 M -7 8 L -4 8 M 4 8 L 7 8","-11 11 M -7 -13 L -8 -8 M 8 -13 L 7 -8 M -3 -4 L -4 1 M 4 -4 L 3 1 M -7 5 L -8 10 M 8 5 L 7 10 M -7 -11 L 7 -11 M -7 -10 L 7 -10 M -3 -2 L 3 -2 M -3 -1 L 3 -1 M -7 7 L 7 7 M -7 8 L 7 8","-11 12 M 0 -12 L 0 9 M 1 -12 L 1 9 M -9 -5 L -8 -6 L -6 -5 L -5 -1 L -4 1 L -3 2 L -1 3 M -8 -6 L -7 -5 L -6 -1 L -5 1 L -4 2 L -1 3 L 2 3 L 5 2 L 6 1 L 7 -1 L 8 -5 L 9 -6 M 2 3 L 4 2 L 5 1 L 6 -1 L 7 -5 L 9 -6 L 10 -5 M -3 -12 L 4 -12 M -3 9 L 4 9","-10 10 M 6 -12 L -7 9 M 7 -12 L -6 9 M -6 -12 L -7 -6 L -7 -12 L 7 -12 M -7 9 L 7 9 L 7 3 L 6 9","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-11 11 M -8 2 L 0 -3 L 8 2 M -8 2 L 0 -2 L 8 2","-10 10 M -10 16 L 10 16","-6 6 M -2 -12 L 3 -6 M -2 -12 L -3 -11 L 3 -6","-11 12 M -1 -5 L -4 -4 L -6 -2 L -7 0 L -8 3 L -8 6 L -7 8 L -4 9 L -2 9 L 0 8 L 3 5 L 5 2 L 7 -2 L 8 -5 M -1 -5 L -3 -4 L -5 -2 L -6 0 L -7 3 L -7 6 L -6 8 L -4 9 M -1 -5 L 1 -5 L 3 -4 L 4 -2 L 6 6 L 7 8 L 8 9 M 1 -5 L 2 -4 L 3 -2 L 5 6 L 6 8 L 8 9 L 9 9","-11 10 M 2 -12 L -1 -11 L -3 -9 L -5 -5 L -6 -2 L -7 2 L -8 8 L -9 16 M 2 -12 L 0 -11 L -2 -9 L -4 -5 L -5 -2 L -6 2 L -7 8 L -8 16 M 2 -12 L 4 -12 L 6 -11 L 7 -10 L 7 -7 L 6 -5 L 5 -4 L 2 -3 L -2 -3 M 4 -12 L 6 -10 L 6 -7 L 5 -5 L 4 -4 L 2 -3 M -2 -3 L 2 -2 L 4 0 L 5 2 L 5 5 L 4 7 L 3 8 L 0 9 L -2 9 L -4 8 L -5 7 L -6 4 M -2 -3 L 1 -2 L 3 0 L 4 2 L 4 5 L 3 7 L 2 8 L 0 9","-9 9 M -7 -5 L -5 -5 L -3 -4 L -2 -2 L 3 13 L 4 15 L 5 16 M -5 -5 L -4 -4 L -3 -2 L 2 13 L 3 15 L 5 16 L 7 16 M 8 -5 L 7 -3 L 5 0 L -5 11 L -7 14 L -8 16","-9 10 M 4 -4 L 2 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 5 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 5 L 6 2 L 6 -1 L 5 -3 L 1 -8 L 0 -10 L 0 -12 L 1 -13 L 3 -13 L 5 -12 L 7 -10 M 0 -5 L -2 -4 L -4 -1 L -5 2 L -5 6 L -4 8 M 0 9 L 2 8 L 4 5 L 5 2 L 5 -2 L 4 -4 L 2 -7 L 1 -9 L 1 -11 L 2 -12 L 4 -12 L 7 -10","-9 9 M 6 -2 L 4 -4 L 2 -5 L -2 -5 L -4 -4 L -4 -2 L -2 0 L 1 1 M -2 -5 L -3 -4 L -3 -2 L -1 0 L 1 1 M 1 1 L -4 2 L -6 4 L -6 6 L -5 8 L -2 9 L 1 9 L 3 8 L 5 6 M 1 1 L -3 2 L -5 4 L -5 6 L -4 8 L -2 9","-11 11 M -3 -4 L -5 -3 L -7 -1 L -8 2 L -8 5 L -7 7 L -6 8 L -4 9 L -1 9 L 2 8 L 5 6 L 7 3 L 8 0 L 8 -3 L 6 -5 L 4 -5 L 2 -3 L 0 1 L -2 6 L -5 16 M -8 5 L -6 7 L -4 8 L -1 8 L 2 7 L 5 5 L 7 3 M 8 -3 L 6 -4 L 4 -4 L 2 -2 L 0 1 L -2 7 L -4 16","-10 10 M -9 -2 L -7 -4 L -5 -5 L -3 -5 L -1 -4 L 0 -3 L 1 0 L 1 4 L 0 8 L -3 16 M -8 -3 L -6 -4 L -2 -4 L 0 -3 M 8 -5 L 7 -2 L 6 0 L 1 7 L -2 12 L -4 16 M 7 -5 L 6 -2 L 5 0 L 1 7","-11 11 M -10 -1 L -9 -3 L -7 -5 L -4 -5 L -3 -4 L -3 -2 L -4 2 L -6 9 M -5 -5 L -4 -4 L -4 -2 L -5 2 L -7 9 M -4 2 L -2 -2 L 0 -4 L 2 -5 L 4 -5 L 6 -4 L 7 -3 L 7 0 L 6 5 L 3 16 M 4 -5 L 6 -3 L 6 0 L 5 5 L 2 16","-6 6 M 0 -5 L -2 2 L -3 6 L -3 8 L -2 9 L 1 9 L 3 7 L 4 5 M 1 -5 L -1 2 L -2 6 L -2 8 L -1 9","-11 11 M -7 -7 L 7 7 M 7 -7 L -7 7","-10 10 M -4 -5 L -8 9 M -3 -5 L -7 9 M 6 -5 L 7 -4 L 8 -4 L 7 -5 L 5 -5 L 3 -4 L -1 0 L -3 1 L -5 1 M -3 1 L -1 2 L 1 8 L 2 9 M -3 1 L -2 2 L 0 8 L 1 9 L 3 9 L 5 8 L 7 5","-10 10 M -7 -12 L -5 -12 L -3 -11 L -2 -10 L -1 -8 L 5 6 L 6 8 L 7 9 M -5 -12 L -3 -10 L -2 -8 L 4 6 L 5 8 L 7 9 L 8 9 M 0 -5 L -8 9 M 0 -5 L -7 9","-12 11 M -5 -5 L -11 16 M -4 -5 L -10 16 M -5 -2 L -6 4 L -6 7 L -4 9 L -2 9 L 0 8 L 2 6 L 4 3 M 6 -5 L 3 6 L 3 8 L 4 9 L 7 9 L 9 7 L 10 5 M 7 -5 L 4 6 L 4 8 L 5 9","-10 10 M -4 -5 L -6 9 M -3 -5 L -4 1 L -5 6 L -6 9 M 7 -5 L 6 -1 L 4 3 M 8 -5 L 7 -2 L 6 0 L 4 3 L 2 5 L -1 7 L -3 8 L -6 9 M -7 -5 L -3 -5","-9 9 M 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 5 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 5 L 6 2 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L 0 -5 M 0 -5 L -2 -4 L -4 -1 L -5 2 L -5 6 L -4 8 M 0 9 L 2 8 L 4 5 L 5 2 L 5 -2 L 4 -4","-11 11 M -2 -4 L -6 9 M -2 -4 L -5 9 M 4 -4 L 4 9 M 4 -4 L 5 9 M -9 -2 L -7 -4 L -4 -5 L 9 -5 M -9 -2 L -7 -3 L -4 -4 L 9 -4","-12 11 M -11 -1 L -10 -3 L -8 -5 L -5 -5 L -4 -4 L -4 -2 L -5 3 L -5 6 L -4 8 L -3 9 M -6 -5 L -5 -4 L -5 -2 L -6 3 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 3 6 L 5 3 L 6 0 L 7 -5 L 7 -9 L 6 -11 L 4 -12 L 2 -12 L 0 -10 L 0 -8 L 1 -5 L 3 -2 L 5 0 L 8 2 M 1 8 L 3 5 L 4 3 L 5 0 L 6 -5 L 6 -9 L 5 -11 L 4 -12","-10 9 M -6 4 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 5 L 6 2 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -10 16 M 0 9 L 2 8 L 4 5 L 5 2 L 5 -2 L 4 -4 M 0 -5 L -2 -4 L -4 -1 L -5 2 L -9 16","-10 11 M 9 -5 L -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 5 L -6 7 L -5 8 L -3 9 L -1 9 L 2 8 L 4 5 L 5 2 L 5 -1 L 4 -3 L 3 -4 L 1 -5 M -1 -5 L -3 -4 L -5 -1 L -6 2 L -6 6 L -5 8 M -1 9 L 1 8 L 3 5 L 4 2 L 4 -2 L 3 -4 M 3 -4 L 9 -4","-10 10 M 1 -4 L -2 9 M 1 -4 L -1 9 M -8 -2 L -6 -4 L -3 -5 L 8 -5 M -8 -2 L -6 -3 L -3 -4 L 8 -4","-10 10 M -9 -1 L -8 -3 L -6 -5 L -3 -5 L -2 -4 L -2 -2 L -4 4 L -4 7 L -2 9 M -4 -5 L -3 -4 L -3 -2 L -5 4 L -5 7 L -4 8 L -2 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 7 -3 L 6 -5 L 5 -4 L 6 -3 L 7 0 M 6 3 L 7 -3","-13 13 M 0 -9 L -1 -8 L 0 -7 L 1 -8 L 0 -9 M -9 0 L 9 0 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-12 11 M -8 -1 L -6 -3 L -3 -4 L -4 -5 L -6 -4 L -8 -1 L -9 2 L -9 5 L -8 8 L -7 9 L -5 9 L -3 8 L -1 5 L 0 2 M -9 5 L -8 7 L -7 8 L -5 8 L -3 7 L -1 5 M -1 2 L -1 5 L 0 8 L 1 9 L 3 9 L 5 8 L 7 5 L 8 2 L 8 -1 L 7 -4 L 6 -5 L 5 -4 L 7 -3 L 8 -1 M -1 5 L 0 7 L 1 8 L 3 8 L 5 7 L 7 5","-9 8 M 2 -12 L 0 -11 L -1 -10 L -1 -9 L 0 -8 L 3 -7 L 6 -7 M 3 -7 L -1 -6 L -3 -5 L -4 -3 L -4 -1 L -2 1 L 1 2 L 4 2 M 3 -7 L 0 -6 L -2 -5 L -3 -3 L -3 -1 L -1 1 L 1 2 M 1 2 L -3 3 L -5 4 L -6 6 L -6 8 L -4 10 L 1 12 L 2 13 L 2 15 L 0 16 L -2 16 M 1 2 L -2 3 L -4 4 L -5 6 L -5 8 L -3 10 L 1 12","-12 11 M 3 -12 L -3 16 M 4 -12 L -4 16 M -11 -1 L -10 -3 L -8 -5 L -5 -5 L -4 -4 L -4 -2 L -5 3 L -5 6 L -3 8 L 0 8 L 2 7 L 5 4 L 7 1 M -6 -5 L -5 -4 L -5 -2 L -6 3 L -6 6 L -5 8 L -3 9 L 0 9 L 2 8 L 4 6 L 6 3 L 7 1 L 9 -5","-9 9 M 2 -12 L 0 -11 L -1 -10 L -1 -9 L 0 -8 L 3 -7 L 8 -7 L 8 -8 L 5 -7 L 1 -5 L -2 -3 L -5 0 L -6 3 L -6 5 L -5 7 L -2 9 L 1 11 L 2 13 L 2 15 L 1 16 L -1 16 L -2 15 M 3 -6 L -1 -3 L -4 0 L -5 3 L -5 5 L -4 7 L -2 9","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
timesi = ["-8 8","-5 6 M 3 -12 L 2 -11 L 0 1 M 3 -11 L 0 1 M 3 -12 L 4 -11 L 0 1 M -2 7 L -3 8 L -2 9 L -1 8 L -2 7","-9 9 M -2 -12 L -4 -5 M -1 -12 L -4 -5 M 7 -12 L 5 -5 M 8 -12 L 5 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 11 M 2 -16 L -6 13 M 7 -16 L -1 13 M 8 -8 L 7 -7 L 8 -6 L 9 -7 L 9 -8 L 8 -10 L 7 -11 L 4 -12 L 0 -12 L -3 -11 L -5 -9 L -5 -7 L -4 -5 L -3 -4 L 4 0 L 6 2 M -5 -7 L -3 -5 L 4 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 4 8 L 1 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 4 L -7 3 L -6 4 L -7 5","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-12 13 M 9 -4 L 8 -3 L 9 -2 L 10 -3 L 10 -4 L 9 -5 L 8 -5 L 7 -4 L 6 -2 L 4 3 L 2 6 L 0 8 L -2 9 L -5 9 L -8 8 L -9 6 L -9 3 L -8 1 L -2 -3 L 0 -5 L 1 -7 L 1 -9 L 0 -11 L -2 -12 L -4 -11 L -5 -9 L -5 -7 L -4 -4 L -2 -1 L 3 6 L 5 8 L 8 9 L 9 9 L 10 8 L 10 7 M -5 9 L -7 8 L -8 6 L -8 3 L -7 1 L -5 -1 M -5 -7 L -4 -5 L 4 6 L 6 8 L 8 9","-4 5 M 3 -12 L 1 -5 M 4 -12 L 1 -5","-7 8 M 8 -16 L 4 -13 L 1 -10 L -1 -7 L -3 -3 L -4 2 L -4 6 L -3 11 L -2 14 L -1 16 M 4 -13 L 1 -9 L -1 -5 L -2 -2 L -3 3 L -3 8 L -2 13 L -1 16","-8 7 M 1 -16 L 2 -14 L 3 -11 L 4 -6 L 4 -2 L 3 3 L 1 7 L -1 10 L -4 13 L -8 16 M 1 -16 L 2 -13 L 3 -8 L 3 -3 L 2 2 L 1 5 L -1 9 L -4 13","-8 8 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-13 13 M 0 -9 L 0 9 M -9 0 L 9 0","-5 6 M -2 9 L -3 8 L -2 7 L -1 8 L -1 9 L -2 11 L -4 13","-13 13 M -9 0 L 9 0","-5 6 M -2 7 L -3 8 L -2 9 L -1 8 L -2 7","-11 11 M 9 -16 L -9 16","-10 11 M 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 8 -4 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 2 -12 M 2 -12 L 0 -11 L -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 4 L -5 7 L -3 9 M -1 9 L 1 8 L 3 6 L 5 3 L 6 0 L 7 -4 L 7 -7 L 6 -10 L 4 -12","-10 11 M 2 -8 L -3 9 M 4 -12 L -2 9 M 4 -12 L 1 -9 L -2 -7 L -4 -6 M 3 -9 L -1 -7 L -4 -6","-10 11 M -3 -8 L -2 -7 L -3 -6 L -4 -7 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 4 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 5 -3 L 2 -1 L -2 1 L -5 3 L -7 5 L -9 9 M 4 -12 L 6 -11 L 7 -9 L 7 -7 L 6 -5 L 4 -3 L -2 1 M -8 7 L -7 6 L -5 6 L 0 8 L 3 8 L 5 7 L 6 5 M -5 6 L 0 9 L 3 9 L 5 8 L 6 5","-10 11 M -3 -8 L -2 -7 L -3 -6 L -4 -7 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 4 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 4 -3 L 1 -2 M 4 -12 L 6 -11 L 7 -9 L 7 -7 L 6 -5 L 4 -3 M -1 -2 L 1 -2 L 4 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 4 8 L 1 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 4 L -7 3 L -6 4 L -7 5 M 1 -2 L 3 -1 L 4 0 L 5 2 L 5 5 L 4 7 L 3 8 L 1 9","-10 11 M 6 -11 L 0 9 M 7 -12 L 1 9 M 7 -12 L -8 3 L 8 3","-10 11 M -1 -12 L -6 -2 M -1 -12 L 9 -12 M -1 -11 L 4 -11 L 9 -12 M -6 -2 L -5 -3 L -2 -4 L 1 -4 L 4 -3 L 5 -2 L 6 0 L 6 3 L 5 6 L 3 8 L 0 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 4 L -7 3 L -6 4 L -7 5 M 1 -4 L 3 -3 L 4 -2 L 5 0 L 5 3 L 4 6 L 2 8 L 0 9","-10 11 M 7 -9 L 6 -8 L 7 -7 L 8 -8 L 8 -9 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 5 L -6 7 L -5 8 L -3 9 L 0 9 L 3 8 L 5 6 L 6 4 L 6 1 L 5 -1 L 4 -2 L 2 -3 L -1 -3 L -3 -2 L -5 0 L -6 2 M 2 -12 L 0 -11 L -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 6 L -5 8 M 0 9 L 2 8 L 4 6 L 5 4 L 5 0 L 4 -2","-10 11 M -4 -12 L -6 -6 M 9 -12 L 8 -9 L 6 -6 L 1 0 L -1 3 L -2 5 L -3 9 M 6 -6 L 0 0 L -2 3 L -3 5 L -4 9 M -5 -9 L -2 -12 L 0 -12 L 5 -9 M -4 -10 L -2 -11 L 0 -11 L 5 -9 L 7 -9 L 8 -10 L 9 -12","-10 11 M 1 -12 L -2 -11 L -3 -10 L -4 -8 L -4 -5 L -3 -3 L -1 -2 L 2 -2 L 6 -3 L 7 -4 L 8 -6 L 8 -9 L 7 -11 L 4 -12 L 1 -12 M 1 -12 L -1 -11 L -2 -10 L -3 -8 L -3 -5 L -2 -3 L -1 -2 M 2 -2 L 5 -3 L 6 -4 L 7 -6 L 7 -9 L 6 -11 L 4 -12 M -1 -2 L -5 -1 L -7 1 L -8 3 L -8 6 L -7 8 L -4 9 L 0 9 L 4 8 L 5 7 L 6 5 L 6 2 L 5 0 L 4 -1 L 2 -2 M -1 -2 L -4 -1 L -6 1 L -7 3 L -7 6 L -6 8 L -4 9 M 0 9 L 3 8 L 4 7 L 5 5 L 5 1 L 4 -1","-10 11 M 7 -5 L 6 -3 L 4 -1 L 2 0 L -1 0 L -3 -1 L -4 -2 L -5 -4 L -5 -7 L -4 -9 L -2 -11 L 1 -12 L 4 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -4 L 7 0 L 6 3 L 4 6 L 2 8 L -1 9 L -4 9 L -6 8 L -7 6 L -7 5 L -6 4 L -5 5 L -6 6 M -3 -1 L -4 -3 L -4 -7 L -3 -9 L -1 -11 L 1 -12 M 6 -11 L 7 -9 L 7 -4 L 6 0 L 5 3 L 3 6 L 1 8 L -1 9","-5 6 M 1 -5 L 0 -4 L 1 -3 L 2 -4 L 1 -5 M -2 7 L -3 8 L -2 9 L -1 8","-5 6 M 1 -5 L 0 -4 L 1 -3 L 2 -4 L 1 -5 M -2 9 L -3 8 L -2 7 L -1 8 L -1 9 L -2 11 L -4 13","-12 12 M 8 -9 L -8 0 L 8 9","-13 13 M -9 -3 L 9 -3 M -9 3 L 9 3","-12 12 M -8 -9 L 8 0 L -8 9","-10 11 M -3 -8 L -2 -7 L -3 -6 L -4 -7 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 5 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -5 L 7 -4 L 1 -2 L -1 -1 L -1 1 L 0 2 L 2 2 M 5 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 6 -4 L 4 -3 M -2 7 L -3 8 L -2 9 L -1 8 L -2 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-10 10 M 3 -12 L -10 9 M 3 -12 L 4 9 M 2 -10 L 3 9 M -6 3 L 3 3 M -12 9 L -6 9 M 0 9 L 6 9","-12 12 M -3 -12 L -9 9 M -2 -12 L -8 9 M -6 -12 L 5 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -4 L 7 -3 L 4 -2 M 5 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -4 L 6 -3 L 4 -2 M -5 -2 L 4 -2 L 6 -1 L 7 1 L 7 3 L 6 6 L 4 8 L 0 9 L -12 9 M 4 -2 L 5 -1 L 6 1 L 6 3 L 5 6 L 3 8 L 0 9","-10 11 M 8 -10 L 9 -10 L 10 -12 L 9 -6 L 9 -8 L 8 -10 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -2 9 L 1 9 L 3 8 L 5 6 L 6 4 M 2 -12 L 0 -11 L -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 4 L -5 7 L -4 8 L -2 9","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M -6 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -7 L 8 -3 L 7 1 L 5 5 L 3 7 L 1 8 L -3 9 L -12 9 M 3 -12 L 5 -11 L 6 -10 L 7 -7 L 7 -3 L 6 1 L 4 5 L 2 7 L 0 8 L -3 9","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M 2 -6 L 0 2 M -6 -12 L 9 -12 L 8 -6 L 8 -12 M -5 -2 L 1 -2 M -12 9 L 3 9 L 5 4 L 2 9","-12 10 M -3 -12 L -9 9 M -2 -12 L -8 9 M 2 -6 L 0 2 M -6 -12 L 9 -12 L 8 -6 L 8 -12 M -5 -2 L 1 -2 M -12 9 L -5 9","-10 12 M 8 -10 L 9 -10 L 10 -12 L 9 -6 L 9 -8 L 8 -10 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -2 9 L 0 9 L 3 8 L 5 6 L 7 2 M 2 -12 L 0 -11 L -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 4 L -5 7 L -4 8 L -2 9 M 0 9 L 2 8 L 4 6 L 6 2 M 3 2 L 10 2","-13 13 M -4 -12 L -10 9 M -3 -12 L -9 9 M 9 -12 L 3 9 M 10 -12 L 4 9 M -7 -12 L 0 -12 M 6 -12 L 13 -12 M -6 -2 L 6 -2 M -13 9 L -6 9 M 0 9 L 7 9","-6 7 M 3 -12 L -3 9 M 4 -12 L -2 9 M 0 -12 L 7 -12 M -6 9 L 1 9","-9 9 M 6 -12 L 1 5 L 0 7 L -1 8 L -3 9 L -5 9 L -7 8 L -8 6 L -8 4 L -7 3 L -6 4 L -7 5 M 5 -12 L 0 5 L -1 7 L -3 9 M 2 -12 L 9 -12","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M 11 -12 L -6 1 M 1 -3 L 5 9 M 0 -3 L 4 9 M -6 -12 L 1 -12 M 7 -12 L 13 -12 M -12 9 L -5 9 M 1 9 L 7 9","-10 10 M -1 -12 L -7 9 M 0 -12 L -6 9 M -4 -12 L 3 -12 M -10 9 L 5 9 L 7 3 L 4 9","-13 14 M -4 -12 L -10 9 M -4 -12 L -3 9 M -3 -12 L -2 7 M 10 -12 L -3 9 M 10 -12 L 4 9 M 11 -12 L 5 9 M -7 -12 L -3 -12 M 10 -12 L 14 -12 M -13 9 L -7 9 M 1 9 L 8 9","-12 13 M -3 -12 L -9 9 M -3 -12 L 4 6 M -3 -9 L 4 9 M 10 -12 L 4 9 M -6 -12 L -3 -12 M 7 -12 L 13 -12 M -12 9 L -6 9","-11 11 M 1 -12 L -2 -11 L -4 -9 L -6 -6 L -7 -3 L -8 1 L -8 4 L -7 7 L -6 8 L -4 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 8 -4 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 1 -12 M 1 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -4 9 M -1 9 L 1 8 L 3 6 L 5 3 L 6 0 L 7 -4 L 7 -7 L 6 -10 L 4 -12","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M -6 -12 L 6 -12 L 9 -11 L 10 -9 L 10 -7 L 9 -4 L 7 -2 L 3 -1 L -5 -1 M 6 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -4 L 6 -2 L 3 -1 M -12 9 L -5 9","-11 11 M 1 -12 L -2 -11 L -4 -9 L -6 -6 L -7 -3 L -8 1 L -8 4 L -7 7 L -6 8 L -4 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 8 -4 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 1 -12 M 1 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -4 9 M -1 9 L 1 8 L 3 6 L 5 3 L 6 0 L 7 -4 L 7 -7 L 6 -10 L 4 -12 M -6 7 L -6 6 L -5 4 L -3 3 L -2 3 L 0 4 L 1 6 L 1 13 L 2 14 L 4 14 L 5 12 L 5 11 M 1 6 L 2 12 L 3 13 L 4 13 L 5 12","-12 12 M -3 -12 L -9 9 M -2 -12 L -8 9 M -6 -12 L 5 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -4 L 7 -3 L 4 -2 L -5 -2 M 5 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -4 L 6 -3 L 4 -2 M 0 -2 L 2 -1 L 3 0 L 4 8 L 5 9 L 7 9 L 8 7 L 8 6 M 3 0 L 5 7 L 6 8 L 7 8 L 8 7 M -12 9 L -5 9","-11 12 M 8 -10 L 9 -10 L 10 -12 L 9 -6 L 9 -8 L 8 -10 L 7 -11 L 4 -12 L 0 -12 L -3 -11 L -5 -9 L -5 -7 L -4 -5 L -3 -4 L 4 0 L 6 2 M -5 -7 L -3 -5 L 4 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 4 8 L 1 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 3 L -9 9 L -8 7 L -7 7","-10 11 M 3 -12 L -3 9 M 4 -12 L -2 9 M -3 -12 L -6 -6 L -4 -12 L 11 -12 L 10 -6 L 10 -12 M -6 9 L 1 9","-12 13 M -4 -12 L -7 -1 L -8 3 L -8 6 L -7 8 L -4 9 L 0 9 L 3 8 L 5 6 L 6 3 L 10 -12 M -3 -12 L -6 -1 L -7 3 L -7 6 L -6 8 L -4 9 M -7 -12 L 0 -12 M 7 -12 L 13 -12","-10 10 M -4 -12 L -3 9 M -3 -12 L -2 7 M 10 -12 L -3 9 M -6 -12 L 0 -12 M 6 -12 L 12 -12","-13 13 M -5 -12 L -7 9 M -4 -12 L -6 7 M 3 -12 L -7 9 M 3 -12 L 1 9 M 4 -12 L 2 7 M 11 -12 L 1 9 M -8 -12 L -1 -12 M 8 -12 L 14 -12","-11 11 M -4 -12 L 3 9 M -3 -12 L 4 9 M 10 -12 L -10 9 M -6 -12 L 0 -12 M 6 -12 L 12 -12 M -12 9 L -6 9 M 0 9 L 6 9","-10 11 M -4 -12 L 0 -2 L -3 9 M -3 -12 L 1 -2 L -2 9 M 11 -12 L 1 -2 M -6 -12 L 0 -12 M 7 -12 L 13 -12 M -6 9 L 1 9","-11 11 M 9 -12 L -10 9 M 10 -12 L -9 9 M -3 -12 L -6 -6 L -4 -12 L 10 -12 M -10 9 L 4 9 L 6 3 L 3 9","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-11 11 M -8 2 L 0 -3 L 8 2 M -8 2 L 0 -2 L 8 2","-10 10 M -10 16 L 10 16","-6 6 M -2 -12 L 3 -6 M -2 -12 L -3 -11 L 3 -6","-10 11 M 6 -5 L 4 2 L 3 6 L 3 8 L 4 9 L 7 9 L 9 7 L 10 5 M 7 -5 L 5 2 L 4 6 L 4 8 L 5 9 M 4 2 L 4 -1 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 5 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 3 5 L 4 2 M -1 -5 L -3 -4 L -5 -1 L -6 2 L -6 6 L -5 8","-10 9 M -2 -12 L -6 1 L -6 4 L -5 7 L -4 8 M -1 -12 L -5 1 M -5 1 L -4 -2 L -2 -4 L 0 -5 L 2 -5 L 4 -4 L 5 -3 L 6 -1 L 6 2 L 5 5 L 3 8 L 0 9 L -2 9 L -4 8 L -5 5 L -5 1 M 4 -4 L 5 -2 L 5 2 L 4 5 L 2 8 L 0 9 M -5 -12 L -1 -12","-9 9 M 5 -2 L 5 -1 L 6 -1 L 6 -2 L 5 -4 L 3 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 5 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 5 M 0 -5 L -2 -4 L -4 -1 L -5 2 L -5 6 L -4 8","-10 11 M 8 -12 L 4 2 L 3 6 L 3 8 L 4 9 L 7 9 L 9 7 L 10 5 M 9 -12 L 5 2 L 4 6 L 4 8 L 5 9 M 4 2 L 4 -1 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 5 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 3 5 L 4 2 M -1 -5 L -3 -4 L -5 -1 L -6 2 L -6 6 L -5 8 M 5 -12 L 9 -12","-9 9 M -5 4 L -1 3 L 2 2 L 5 0 L 6 -2 L 5 -4 L 3 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 5 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 6 M 0 -5 L -2 -4 L -4 -1 L -5 2 L -5 6 L -4 8","-7 8 M 8 -11 L 7 -10 L 8 -9 L 9 -10 L 9 -11 L 8 -12 L 6 -12 L 4 -11 L 3 -10 L 2 -8 L 1 -5 L -2 9 L -3 13 L -4 15 M 6 -12 L 4 -10 L 3 -8 L 2 -4 L 0 5 L -1 9 L -2 12 L -3 14 L -4 15 L -6 16 L -8 16 L -9 15 L -9 14 L -8 13 L -7 14 L -8 15 M -3 -5 L 7 -5","-10 10 M 7 -5 L 3 9 L 2 12 L 0 15 L -3 16 L -6 16 L -8 15 L -9 14 L -9 13 L -8 12 L -7 13 L -8 14 M 6 -5 L 2 9 L 1 12 L -1 15 L -3 16 M 4 2 L 4 -1 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 5 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 3 5 L 4 2 M -1 -5 L -3 -4 L -5 -1 L -6 2 L -6 6 L -5 8","-10 11 M -2 -12 L -8 9 M -1 -12 L -7 9 M -5 2 L -3 -2 L -1 -4 L 1 -5 L 3 -5 L 5 -4 L 6 -3 L 6 -1 L 4 5 L 4 8 L 5 9 M 3 -5 L 5 -3 L 5 -1 L 3 5 L 3 8 L 4 9 L 7 9 L 9 7 L 10 5 M -5 -12 L -1 -12","-6 7 M 3 -12 L 2 -11 L 3 -10 L 4 -11 L 3 -12 M -5 -1 L -4 -3 L -2 -5 L 1 -5 L 2 -4 L 2 -1 L 0 5 L 0 8 L 1 9 M 0 -5 L 1 -4 L 1 -1 L -1 5 L -1 8 L 0 9 L 3 9 L 5 7 L 6 5","-6 7 M 4 -12 L 3 -11 L 4 -10 L 5 -11 L 4 -12 M -4 -1 L -3 -3 L -1 -5 L 2 -5 L 3 -4 L 3 -1 L 0 9 L -1 12 L -2 14 L -3 15 L -5 16 L -7 16 L -8 15 L -8 14 L -7 13 L -6 14 L -7 15 M 1 -5 L 2 -4 L 2 -1 L -1 9 L -2 12 L -3 14 L -5 16","-10 10 M -2 -12 L -8 9 M -1 -12 L -7 9 M 6 -4 L 5 -3 L 6 -2 L 7 -3 L 7 -4 L 6 -5 L 5 -5 L 3 -4 L -1 0 L -3 1 L -5 1 M -3 1 L -1 2 L 1 8 L 2 9 M -3 1 L -2 2 L 0 8 L 1 9 L 3 9 L 5 8 L 7 5 M -5 -12 L -1 -12","-5 7 M 3 -12 L -1 2 L -2 6 L -2 8 L -1 9 L 2 9 L 4 7 L 5 5 M 4 -12 L 0 2 L -1 6 L -1 8 L 0 9 M 0 -12 L 4 -12","-17 16 M -16 -1 L -15 -3 L -13 -5 L -10 -5 L -9 -4 L -9 -2 L -10 2 L -12 9 M -11 -5 L -10 -4 L -10 -2 L -11 2 L -13 9 M -10 2 L -8 -2 L -6 -4 L -4 -5 L -2 -5 L 0 -4 L 1 -3 L 1 -1 L -2 9 M -2 -5 L 0 -3 L 0 -1 L -3 9 M 0 2 L 2 -2 L 4 -4 L 6 -5 L 8 -5 L 10 -4 L 11 -3 L 11 -1 L 9 5 L 9 8 L 10 9 M 8 -5 L 10 -3 L 10 -1 L 8 5 L 8 8 L 9 9 L 12 9 L 14 7 L 15 5","-12 11 M -11 -1 L -10 -3 L -8 -5 L -5 -5 L -4 -4 L -4 -2 L -5 2 L -7 9 M -6 -5 L -5 -4 L -5 -2 L -6 2 L -8 9 M -5 2 L -3 -2 L -1 -4 L 1 -5 L 3 -5 L 5 -4 L 6 -3 L 6 -1 L 4 5 L 4 8 L 5 9 M 3 -5 L 5 -3 L 5 -1 L 3 5 L 3 8 L 4 9 L 7 9 L 9 7 L 10 5","-9 9 M 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 5 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 5 L 6 2 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L 0 -5 M 0 -5 L -2 -4 L -4 -1 L -5 2 L -5 6 L -4 8 M 0 9 L 2 8 L 4 5 L 5 2 L 5 -2 L 4 -4","-11 10 M -10 -1 L -9 -3 L -7 -5 L -4 -5 L -3 -4 L -3 -2 L -4 2 L -8 16 M -5 -5 L -4 -4 L -4 -2 L -5 2 L -9 16 M -4 2 L -3 -1 L -1 -4 L 1 -5 L 3 -5 L 5 -4 L 6 -3 L 7 -1 L 7 2 L 6 5 L 4 8 L 1 9 L -1 9 L -3 8 L -4 5 L -4 2 M 5 -4 L 6 -2 L 6 2 L 5 5 L 3 8 L 1 9 M -12 16 L -5 16","-10 10 M 6 -5 L 0 16 M 7 -5 L 1 16 M 4 2 L 4 -1 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 5 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 3 5 L 4 2 M -1 -5 L -3 -4 L -5 -1 L -6 2 L -6 6 L -5 8 M -3 16 L 4 16","-9 8 M -8 -1 L -7 -3 L -5 -5 L -2 -5 L -1 -4 L -1 -2 L -2 2 L -4 9 M -3 -5 L -2 -4 L -2 -2 L -3 2 L -5 9 M -2 2 L 0 -2 L 2 -4 L 4 -5 L 6 -5 L 7 -4 L 7 -3 L 6 -2 L 5 -3 L 6 -4","-8 9 M 6 -3 L 6 -2 L 7 -2 L 7 -3 L 6 -4 L 3 -5 L 0 -5 L -3 -4 L -4 -3 L -4 -1 L -3 0 L 4 4 L 5 5 M -4 -2 L -3 -1 L 4 3 L 5 4 L 5 7 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -6 6 L -5 6 L -5 7","-7 7 M 2 -12 L -2 2 L -3 6 L -3 8 L -2 9 L 1 9 L 3 7 L 4 5 M 3 -12 L -1 2 L -2 6 L -2 8 L -1 9 M -4 -5 L 5 -5","-12 11 M -11 -1 L -10 -3 L -8 -5 L -5 -5 L -4 -4 L -4 -1 L -6 5 L -6 7 L -4 9 M -6 -5 L -5 -4 L -5 -1 L -7 5 L -7 7 L -6 8 L -4 9 L -2 9 L 0 8 L 2 6 L 4 2 M 6 -5 L 4 2 L 3 6 L 3 8 L 4 9 L 7 9 L 9 7 L 10 5 M 7 -5 L 5 2 L 4 6 L 4 8 L 5 9","-10 10 M -9 -1 L -8 -3 L -6 -5 L -3 -5 L -2 -4 L -2 -1 L -4 5 L -4 7 L -2 9 M -4 -5 L -3 -4 L -3 -1 L -5 5 L -5 7 L -4 8 L -2 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 -1 L 7 -5 L 6 -5 L 7 -3","-15 14 M -14 -1 L -13 -3 L -11 -5 L -8 -5 L -7 -4 L -7 -1 L -9 5 L -9 7 L -7 9 M -9 -5 L -8 -4 L -8 -1 L -10 5 L -10 7 L -9 8 L -7 9 L -5 9 L -3 8 L -1 6 L 0 4 M 2 -5 L 0 4 L 0 7 L 1 8 L 3 9 L 5 9 L 7 8 L 9 6 L 10 4 L 11 0 L 11 -5 L 10 -5 L 11 -3 M 3 -5 L 1 4 L 1 7 L 3 9","-10 10 M -7 -1 L -5 -4 L -3 -5 L 0 -5 L 1 -3 L 1 0 M -1 -5 L 0 -3 L 0 0 L -1 4 L -2 6 L -4 8 L -6 9 L -7 9 L -8 8 L -8 7 L -7 6 L -6 7 L -7 8 M -1 4 L -1 7 L 0 9 L 3 9 L 5 8 L 7 5 M 7 -4 L 6 -3 L 7 -2 L 8 -3 L 8 -4 L 7 -5 L 6 -5 L 4 -4 L 2 -2 L 1 0 L 0 4 L 0 7 L 1 9","-11 10 M -10 -1 L -9 -3 L -7 -5 L -4 -5 L -3 -4 L -3 -1 L -5 5 L -5 7 L -3 9 M -5 -5 L -4 -4 L -4 -1 L -6 5 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 3 6 L 5 2 M 8 -5 L 4 9 L 3 12 L 1 15 L -2 16 L -5 16 L -7 15 L -8 14 L -8 13 L -7 12 L -6 13 L -7 14 M 7 -5 L 3 9 L 2 12 L 0 15 L -2 16","-10 10 M 7 -5 L 6 -3 L 4 -1 L -4 5 L -6 7 L -7 9 M -6 -1 L -5 -3 L -3 -5 L 0 -5 L 4 -3 M -5 -3 L -3 -4 L 0 -4 L 4 -3 L 6 -3 M -6 7 L -4 7 L 0 8 L 3 8 L 5 7 M -4 7 L 0 9 L 3 9 L 5 7 L 6 5","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
timesib = ["-8 8","-5 6 M 4 -12 L 3 -12 L 2 -11 L 0 2 M 4 -11 L 3 -11 L 0 2 M 4 -11 L 4 -10 L 0 2 M 4 -12 L 5 -11 L 5 -10 L 0 2 M -2 6 L -3 7 L -3 8 L -2 9 L -1 9 L 0 8 L 0 7 L -1 6 L -2 6 M -2 7 L -2 8 L -1 8 L -1 7 L -2 7","-9 9 M -2 -12 L -4 -5 M -1 -12 L -4 -5 M 7 -12 L 5 -5 M 8 -12 L 5 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 11 M 2 -16 L -6 13 M 7 -16 L -1 13 M 8 -7 L 8 -8 L 7 -8 L 7 -6 L 9 -6 L 9 -8 L 8 -10 L 7 -11 L 4 -12 L 0 -12 L -3 -11 L -5 -9 L -5 -6 L -4 -4 L -2 -2 L 4 1 L 5 3 L 5 6 L 4 8 M -4 -6 L -3 -4 L 4 0 L 5 2 M -3 -11 L -4 -9 L -4 -7 L -3 -5 L 3 -2 L 5 0 L 6 2 L 6 5 L 5 7 L 4 8 L 1 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 3 L -6 3 L -6 5 L -7 5 L -7 4","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-13 13 M 10 -3 L 10 -4 L 9 -4 L 9 -2 L 11 -2 L 11 -4 L 10 -5 L 9 -5 L 7 -4 L 5 -2 L 0 6 L -2 8 L -4 9 L -7 9 L -10 8 L -11 6 L -11 4 L -10 2 L -9 1 L -7 0 L -2 -2 L 0 -3 L 2 -5 L 3 -7 L 3 -9 L 2 -11 L 0 -12 L -2 -11 L -3 -9 L -3 -6 L -2 0 L -1 3 L 0 5 L 2 8 L 4 9 L 6 9 L 7 7 L 7 6 M -6 9 L -10 8 M -9 8 L -10 6 L -10 4 L -9 2 L -8 1 L -6 0 M -2 -2 L -1 1 L 2 7 L 4 8 M -7 9 L -8 8 L -9 6 L -9 4 L -8 2 L -7 1 L -5 0 L 0 -3 M -3 -6 L -2 -3 L -1 0 L 1 4 L 3 7 L 5 8 L 6 8 L 7 7","-4 5 M 3 -12 L 1 -5 M 4 -12 L 1 -5","-8 8 M 8 -16 L 6 -15 L 3 -13 L 0 -10 L -2 -7 L -4 -3 L -5 1 L -5 6 L -4 10 L -3 13 L -1 16 M 1 -10 L -1 -7 L -3 -3 L -4 2 L -4 10 M 8 -16 L 5 -14 L 2 -11 L 0 -8 L -1 -6 L -2 -3 L -3 1 L -4 10 M -4 2 L -3 11 L -2 14 L -1 16","-8 8 M 1 -16 L 3 -13 L 4 -10 L 5 -6 L 5 -1 L 4 3 L 2 7 L 0 10 L -3 13 L -6 15 L -8 16 M 4 -10 L 4 -2 L 3 3 L 1 7 L -1 10 M 1 -16 L 2 -14 L 3 -11 L 4 -2 M 4 -10 L 3 -1 L 2 3 L 1 6 L 0 8 L -2 11 L -5 14 L -8 16","-8 9 M 2 -12 L 1 -11 L 3 -1 L 2 0 M 2 -12 L 2 0 M 2 -12 L 3 -11 L 1 -1 L 2 0 M -3 -9 L -2 -9 L 6 -3 L 7 -3 M -3 -9 L 7 -3 M -3 -9 L -3 -8 L 7 -4 L 7 -3 M 7 -9 L 6 -9 L -2 -3 L -3 -3 M 7 -9 L -3 -3 M 7 -9 L 7 -8 L -3 -4 L -3 -3","-12 13 M 0 -9 L 0 8 L 1 8 M 0 -9 L 1 -9 L 1 8 M -8 -1 L 9 -1 L 9 0 M -8 -1 L -8 0 L 9 0","-5 6 M -1 9 L -2 9 L -3 8 L -3 7 L -2 6 L -1 6 L 0 7 L 0 9 L -1 11 L -2 12 L -4 13 M -2 7 L -2 8 L -1 8 L -1 7 L -2 7 M -1 9 L -1 10 L -2 12","-13 13 M -9 0 L 9 0","-5 6 M -2 6 L -3 7 L -3 8 L -2 9 L -1 9 L 0 8 L 0 7 L -1 6 L -2 6 M -2 7 L -2 8 L -1 8 L -1 7 L -2 7","-11 12 M 9 -16 L -9 16 L -8 16 M 9 -16 L 10 -16 L -8 16","-10 11 M 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 8 -4 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 2 -12 M -1 -10 L -3 -8 L -4 -6 L -5 -3 L -6 1 L -6 5 L -5 7 M 2 7 L 4 5 L 5 3 L 6 0 L 7 -4 L 7 -8 L 6 -10 M 2 -12 L 0 -11 L -2 -8 L -3 -6 L -4 -3 L -5 1 L -5 6 L -4 8 L -3 9 M -1 9 L 1 8 L 3 5 L 4 3 L 5 0 L 6 -4 L 6 -9 L 5 -11 L 4 -12","-10 11 M 2 -8 L -3 9 L -1 9 M 5 -12 L 3 -8 L -2 9 M 5 -12 L -1 9 M 5 -12 L 2 -9 L -1 -7 L -3 -6 M 2 -8 L 0 -7 L -3 -6","-10 11 M -3 -7 L -3 -8 L -2 -8 L -2 -6 L -4 -6 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 4 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 5 -3 L -5 3 L -7 5 L -9 9 M 6 -11 L 7 -9 L 7 -7 L 6 -5 L 4 -3 L 1 -1 M 4 -12 L 5 -11 L 6 -9 L 6 -7 L 5 -5 L 3 -3 L -5 3 M -8 7 L -7 6 L -5 6 L 0 7 L 5 7 L 6 6 M -5 6 L 0 8 L 5 8 M -5 6 L 0 9 L 3 9 L 5 8 L 6 6 L 6 5","-10 11 M -3 -7 L -3 -8 L -2 -8 L -2 -6 L -4 -6 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 4 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -5 L 6 -4 L 4 -3 L 1 -2 M 6 -11 L 7 -9 L 7 -7 L 6 -5 L 5 -4 M 4 -12 L 5 -11 L 6 -9 L 6 -7 L 5 -5 L 3 -3 L 1 -2 M -1 -2 L 1 -2 L 4 -1 L 5 0 L 6 2 L 6 5 L 5 7 L 3 8 L 0 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 3 L -6 3 L -6 5 L -7 5 L -7 4 M 4 0 L 5 2 L 5 5 L 4 7 M 1 -2 L 3 -1 L 4 1 L 4 5 L 3 7 L 2 8 L 0 9","-10 11 M 5 -8 L 0 9 L 2 9 M 8 -12 L 6 -8 L 1 9 M 8 -12 L 2 9 M 8 -12 L -8 3 L 8 3","-10 11 M -1 -12 L -6 -2 M -1 -12 L 9 -12 M -1 -11 L 7 -11 M -2 -10 L 3 -10 L 7 -11 L 9 -12 M -6 -2 L -5 -3 L -2 -4 L 1 -4 L 4 -3 L 5 -2 L 6 0 L 6 3 L 5 6 L 3 8 L -1 9 L -4 9 L -6 8 L -7 7 L -8 5 L -8 3 L -6 3 L -6 5 L -7 5 L -7 4 M 4 -2 L 5 0 L 5 3 L 4 6 L 2 8 M 1 -4 L 3 -3 L 4 -1 L 4 3 L 3 6 L 1 8 L -1 9","-10 11 M 7 -8 L 7 -9 L 6 -9 L 6 -7 L 8 -7 L 8 -9 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -3 9 L 0 9 L 3 8 L 5 6 L 6 4 L 6 1 L 5 -1 L 4 -2 L 2 -3 L -1 -3 L -3 -2 L -4 -1 L -5 1 M -2 -9 L -4 -6 L -5 -3 L -6 1 L -6 5 L -5 7 M 4 6 L 5 4 L 5 1 L 4 -1 M 2 -12 L 0 -11 L -2 -8 L -3 -6 L -4 -3 L -5 1 L -5 6 L -4 8 L -3 9 M 0 9 L 2 8 L 3 7 L 4 4 L 4 0 L 3 -2 L 2 -3","-10 11 M -4 -12 L -6 -6 M 9 -12 L 8 -9 L 6 -6 L 2 -1 L 0 2 L -1 5 L -2 9 M 0 1 L -2 5 L -3 9 M 6 -6 L 0 0 L -2 3 L -3 5 L -4 9 L -2 9 M -5 -9 L -2 -12 L 0 -12 L 5 -9 M -3 -11 L 0 -11 L 5 -9 M -5 -9 L -3 -10 L 0 -10 L 5 -9 L 7 -9 L 8 -10 L 9 -12","-10 11 M 1 -12 L -2 -11 L -3 -10 L -4 -8 L -4 -5 L -3 -3 L -1 -2 L 2 -2 L 5 -3 L 7 -4 L 8 -6 L 8 -9 L 7 -11 L 5 -12 L 1 -12 M 3 -12 L -2 -11 M -2 -10 L -3 -8 L -3 -4 L -2 -3 M -3 -3 L 0 -2 M 1 -2 L 5 -3 M 6 -4 L 7 -6 L 7 -9 L 6 -11 M 7 -11 L 3 -12 M 1 -12 L -1 -10 L -2 -8 L -2 -4 L -1 -2 M 2 -2 L 4 -3 L 5 -4 L 6 -6 L 6 -10 L 5 -12 M -1 -2 L -5 -1 L -7 1 L -8 3 L -8 6 L -7 8 L -4 9 L 0 9 L 4 8 L 5 7 L 6 5 L 6 2 L 5 0 L 4 -1 L 2 -2 M 0 -2 L -5 -1 M -4 -1 L -6 1 L -7 3 L -7 6 L -6 8 M -7 8 L -2 9 L 4 8 M 4 7 L 5 5 L 5 2 L 4 0 M 4 -1 L 1 -2 M -1 -2 L -3 -1 L -5 1 L -6 3 L -6 6 L -5 8 L -4 9 M 0 9 L 2 8 L 3 7 L 4 5 L 4 1 L 3 -1 L 2 -2","-10 11 M 6 -4 L 5 -2 L 4 -1 L 2 0 L -1 0 L -3 -1 L -4 -2 L -5 -4 L -5 -7 L -4 -9 L -2 -11 L 1 -12 L 4 -12 L 6 -11 L 7 -10 L 8 -7 L 8 -4 L 7 0 L 6 3 L 4 6 L 2 8 L -1 9 L -4 9 L -6 8 L -7 6 L -7 4 L -5 4 L -5 6 L -6 6 L -6 5 M -3 -2 L -4 -4 L -4 -7 L -3 -9 M 6 -10 L 7 -8 L 7 -4 L 6 0 L 5 3 L 3 6 M -1 0 L -2 -1 L -3 -3 L -3 -7 L -2 -10 L -1 -11 L 1 -12 M 4 -12 L 5 -11 L 6 -9 L 6 -4 L 5 0 L 4 3 L 3 5 L 1 8 L -1 9","-5 6 M 1 -5 L 0 -4 L 0 -3 L 1 -2 L 2 -2 L 3 -3 L 3 -4 L 2 -5 L 1 -5 M 1 -4 L 1 -3 L 2 -3 L 2 -4 L 1 -4 M -2 6 L -3 7 L -3 8 L -2 9 L -1 9 L 0 8 L 0 7 L -1 6 L -2 6 M -2 7 L -2 8 L -1 8 L -1 7 L -2 7","-5 6 M 1 -5 L 0 -4 L 0 -3 L 1 -2 L 2 -2 L 3 -3 L 3 -4 L 2 -5 L 1 -5 M 1 -4 L 1 -3 L 2 -3 L 2 -4 L 1 -4 M -1 9 L -2 9 L -3 8 L -3 7 L -2 6 L -1 6 L 0 7 L 0 9 L -1 11 L -2 12 L -4 13 M -2 7 L -2 8 L -1 8 L -1 7 L -2 7 M -1 9 L -1 10 L -2 12","-12 12 M 8 -9 L -8 0 L 8 9","-12 13 M -8 -5 L 9 -5 L 9 -4 M -8 -5 L -8 -4 L 9 -4 M -8 3 L 9 3 L 9 4 M -8 3 L -8 4 L 9 4","-12 12 M -8 -9 L 8 0 L -8 9","-10 11 M -3 -7 L -3 -8 L -2 -8 L -2 -6 L -4 -6 L -4 -8 L -3 -10 L -2 -11 L 1 -12 L 5 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -5 L 7 -4 L 5 -3 L 1 -2 L -1 -1 L -1 1 L 1 2 L 2 2 M 3 -12 L 8 -11 M 7 -11 L 8 -9 L 8 -7 L 7 -5 L 6 -4 L 4 -3 M 5 -12 L 6 -11 L 7 -9 L 7 -7 L 6 -5 L 5 -4 L 1 -2 L 0 -1 L 0 1 L 1 2 M -2 6 L -3 7 L -3 8 L -2 9 L -1 9 L 0 8 L 0 7 L -1 6 L -2 6 M -2 7 L -2 8 L -1 8 L -1 7 L -2 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-10 10 M 3 -12 L -9 8 M 1 -8 L 2 9 M 2 -10 L 3 8 M 3 -12 L 3 -10 L 4 7 L 4 9 M -6 3 L 2 3 M -12 9 L -6 9 M -1 9 L 6 9 M -9 8 L -11 9 M -9 8 L -7 9 M 2 8 L 0 9 M 2 7 L 1 9 M 4 7 L 5 9","-12 12 M -3 -12 L -9 9 M -2 -12 L -8 9 M -1 -12 L -7 9 M -6 -12 L 5 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -4 L 7 -3 L 4 -2 M 7 -11 L 8 -9 L 8 -7 L 7 -4 L 6 -3 M 5 -12 L 6 -11 L 7 -9 L 7 -7 L 6 -4 L 4 -2 M -4 -2 L 4 -2 L 6 -1 L 7 1 L 7 3 L 6 6 L 4 8 L 0 9 L -12 9 M 5 -1 L 6 1 L 6 3 L 5 6 L 3 8 M 4 -2 L 5 0 L 5 3 L 4 6 L 2 8 L 0 9 M -5 -12 L -2 -11 M -4 -12 L -3 -10 M 0 -12 L -2 -10 M 1 -12 L -2 -11 M -8 8 L -11 9 M -8 7 L -10 9 M -7 7 L -6 9 M -8 8 L -5 9","-10 11 M 8 -10 L 9 -10 L 10 -12 L 9 -6 L 9 -8 L 8 -10 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -2 9 L 1 9 L 3 8 L 5 6 L 6 4 M -1 -10 L -3 -8 L -4 -6 L -5 -3 L -6 1 L -6 5 L -5 7 M 2 -12 L 0 -11 L -2 -8 L -3 -6 L -4 -3 L -5 1 L -5 6 L -4 8 L -2 9","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M -1 -12 L -7 9 M -6 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -7 L 8 -3 L 7 1 L 5 5 L 3 7 L 1 8 L -3 9 L -12 9 M 5 -11 L 6 -10 L 7 -7 L 7 -3 L 6 1 L 4 5 L 2 7 M 3 -12 L 5 -10 L 6 -7 L 6 -3 L 5 1 L 3 5 L 0 8 L -3 9 M -5 -12 L -2 -11 M -4 -12 L -3 -10 M 0 -12 L -2 -10 M 1 -12 L -2 -11 M -8 8 L -11 9 M -8 7 L -10 9 M -7 7 L -6 9 M -8 8 L -5 9","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M -1 -12 L -7 9 M 3 -6 L 1 2 M -6 -12 L 9 -12 L 8 -6 M -4 -2 L 2 -2 M -12 9 L 3 9 L 5 4 M -5 -12 L -2 -11 M -4 -12 L -3 -10 M 0 -12 L -2 -10 M 1 -12 L -2 -11 M 5 -12 L 8 -11 M 6 -12 L 8 -10 M 7 -12 L 8 -9 M 8 -12 L 8 -6 M 3 -6 L 1 -2 L 1 2 M 2 -4 L 0 -2 L 1 0 M 2 -3 L -1 -2 L 1 -1 M -8 8 L -11 9 M -8 7 L -10 9 M -7 7 L -6 9 M -8 8 L -5 9 M -2 9 L 3 8 M 0 9 L 3 7 M 3 7 L 5 4","-12 10 M -3 -12 L -9 9 M -2 -12 L -8 9 M -1 -12 L -7 9 M 3 -6 L 1 2 M -6 -12 L 9 -12 L 8 -6 M -4 -2 L 2 -2 M -12 9 L -4 9 M -5 -12 L -2 -11 M -4 -12 L -3 -10 M 0 -12 L -2 -10 M 1 -12 L -2 -11 M 5 -12 L 8 -11 M 6 -12 L 8 -10 M 7 -12 L 8 -9 M 8 -12 L 8 -6 M 3 -6 L 1 -2 L 1 2 M 2 -4 L 0 -2 L 1 0 M 2 -3 L -1 -2 L 1 -1 M -8 8 L -11 9 M -8 7 L -10 9 M -7 7 L -6 9 M -8 8 L -5 9","-10 12 M 8 -10 L 9 -10 L 10 -12 L 9 -6 L 9 -8 L 8 -10 L 7 -11 L 5 -12 L 2 -12 L -1 -11 L -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 4 L -6 7 L -5 8 L -2 9 L 0 9 L 3 8 L 5 6 L 7 2 M -1 -10 L -3 -8 L -4 -6 L -5 -3 L -6 1 L -6 5 L -5 7 M 4 6 L 5 5 L 6 2 M 2 -12 L 0 -11 L -2 -8 L -3 -6 L -4 -3 L -5 1 L -5 6 L -4 8 L -2 9 M 0 9 L 2 8 L 4 5 L 5 2 M 2 2 L 10 2 M 3 2 L 5 3 M 4 2 L 5 5 M 8 2 L 6 4 M 9 2 L 6 3","-13 13 M -4 -12 L -10 9 M -3 -12 L -9 9 M -2 -12 L -8 9 M 8 -12 L 2 9 M 9 -12 L 3 9 M 10 -12 L 4 9 M -7 -12 L 1 -12 M 5 -12 L 13 -12 M -6 -2 L 6 -2 M -13 9 L -5 9 M -1 9 L 7 9 M -6 -12 L -3 -11 M -5 -12 L -4 -10 M -1 -12 L -3 -10 M 0 -12 L -3 -11 M 6 -12 L 9 -11 M 7 -12 L 8 -10 M 11 -12 L 9 -10 M 12 -12 L 9 -11 M -9 8 L -12 9 M -9 7 L -11 9 M -8 7 L -7 9 M -9 8 L -6 9 M 3 8 L 0 9 M 3 7 L 1 9 M 4 7 L 5 9 M 3 8 L 6 9","-7 7 M 2 -12 L -4 9 M 3 -12 L -3 9 M 4 -12 L -2 9 M -1 -12 L 7 -12 M -7 9 L 1 9 M 0 -12 L 3 -11 M 1 -12 L 2 -10 M 5 -12 L 3 -10 M 6 -12 L 3 -11 M -3 8 L -6 9 M -3 7 L -5 9 M -2 7 L -1 9 M -3 8 L 0 9","-9 10 M 5 -12 L 0 5 L -1 7 L -3 9 M 6 -12 L 2 1 L 1 4 L 0 6 M 7 -12 L 3 1 L 1 6 L -1 8 L -3 9 L -5 9 L -7 8 L -8 6 L -8 4 L -7 3 L -6 3 L -5 4 L -5 5 L -6 6 L -7 6 M -7 4 L -7 5 L -6 5 L -6 4 L -7 4 M 2 -12 L 10 -12 M 3 -12 L 6 -11 M 4 -12 L 5 -10 M 8 -12 L 6 -10 M 9 -12 L 6 -11","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M -1 -12 L -7 9 M 10 -11 L -5 0 M -1 -3 L 3 9 M 0 -3 L 4 9 M 1 -4 L 5 8 M -6 -12 L 2 -12 M 7 -12 L 13 -12 M -12 9 L -4 9 M 0 9 L 7 9 M -5 -12 L -2 -11 M -4 -12 L -3 -10 M 0 -12 L -2 -10 M 1 -12 L -2 -11 M 8 -12 L 10 -11 M 12 -12 L 10 -11 M -8 8 L -11 9 M -8 7 L -10 9 M -7 7 L -6 9 M -8 8 L -5 9 M 3 8 L 1 9 M 3 7 L 2 9 M 4 7 L 6 9","-10 10 M -1 -12 L -7 9 M 0 -12 L -6 9 M 1 -12 L -5 9 M -4 -12 L 4 -12 M -10 9 L 5 9 L 7 3 M -3 -12 L 0 -11 M -2 -12 L -1 -10 M 2 -12 L 0 -10 M 3 -12 L 0 -11 M -6 8 L -9 9 M -6 7 L -8 9 M -5 7 L -4 9 M -6 8 L -3 9 M 0 9 L 5 8 M 2 9 L 6 6 M 4 9 L 7 3","-14 14 M -5 -12 L -11 8 M -5 -11 L -4 7 L -4 9 M -4 -12 L -3 7 M -3 -12 L -2 6 M 9 -12 L -2 6 L -4 9 M 9 -12 L 3 9 M 10 -12 L 4 9 M 11 -12 L 5 9 M -8 -12 L -3 -12 M 9 -12 L 14 -12 M -14 9 L -8 9 M 0 9 L 8 9 M -7 -12 L -5 -11 M -6 -12 L -5 -10 M 12 -12 L 10 -10 M 13 -12 L 10 -11 M -11 8 L -13 9 M -11 8 L -9 9 M 4 8 L 1 9 M 4 7 L 2 9 M 5 7 L 6 9 M 4 8 L 7 9","-12 13 M -3 -12 L -9 8 M -3 -12 L 4 9 M -2 -12 L 4 6 M -1 -12 L 5 6 M 10 -11 L 5 6 L 4 9 M -6 -12 L -1 -12 M 7 -12 L 13 -12 M -12 9 L -6 9 M -5 -12 L -2 -11 M -4 -12 L -2 -10 M 8 -12 L 10 -11 M 12 -12 L 10 -11 M -9 8 L -11 9 M -9 8 L -7 9","-11 11 M 1 -12 L -2 -11 L -4 -9 L -6 -6 L -7 -3 L -8 1 L -8 4 L -7 7 L -6 8 L -4 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 8 -4 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 1 -12 M -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 5 L -6 7 M 3 6 L 5 3 L 6 0 L 7 -4 L 7 -8 L 6 -10 M 1 -12 L -1 -11 L -3 -8 L -4 -6 L -5 -3 L -6 1 L -6 6 L -5 8 L -4 9 M -1 9 L 1 8 L 3 5 L 4 3 L 5 0 L 6 -4 L 6 -9 L 5 -11 L 4 -12","-12 11 M -3 -12 L -9 9 M -2 -12 L -8 9 M -1 -12 L -7 9 M -6 -12 L 6 -12 L 9 -11 L 10 -9 L 10 -7 L 9 -4 L 7 -2 L 3 -1 L -5 -1 M 8 -11 L 9 -9 L 9 -7 L 8 -4 L 6 -2 M 6 -12 L 7 -11 L 8 -9 L 8 -7 L 7 -4 L 5 -2 L 3 -1 M -12 9 L -4 9 M -5 -12 L -2 -11 M -4 -12 L -3 -10 M 0 -12 L -2 -10 M 1 -12 L -2 -11 M -8 8 L -11 9 M -8 7 L -10 9 M -7 7 L -6 9 M -8 8 L -5 9","-11 11 M 1 -12 L -2 -11 L -4 -9 L -6 -6 L -7 -3 L -8 1 L -8 4 L -7 7 L -6 8 L -4 9 L -1 9 L 2 8 L 4 6 L 6 3 L 7 0 L 8 -4 L 8 -7 L 7 -10 L 6 -11 L 4 -12 L 1 -12 M -3 -9 L -5 -6 L -6 -3 L -7 1 L -7 5 L -6 7 M 3 6 L 5 3 L 6 0 L 7 -4 L 7 -8 L 6 -10 M 1 -12 L -1 -11 L -3 -8 L -4 -6 L -5 -3 L -6 1 L -6 6 L -5 8 L -4 9 M -1 9 L 1 8 L 3 5 L 4 3 L 5 0 L 6 -4 L 6 -9 L 5 -11 L 4 -12 M -6 6 L -5 4 L -3 3 L -2 3 L 0 4 L 1 6 L 2 11 L 3 12 L 4 12 L 5 11 M 2 12 L 3 13 L 4 13 M 1 6 L 1 13 L 2 14 L 4 14 L 5 11 L 5 10","-12 12 M -3 -12 L -9 9 M -2 -12 L -8 9 M -1 -12 L -7 9 M -6 -12 L 5 -12 L 8 -11 L 9 -9 L 9 -7 L 8 -4 L 7 -3 L 4 -2 L -4 -2 M 7 -11 L 8 -9 L 8 -7 L 7 -4 L 6 -3 M 5 -12 L 6 -11 L 7 -9 L 7 -7 L 6 -4 L 4 -2 M 0 -2 L 2 -1 L 3 0 L 5 6 L 6 7 L 7 7 L 8 6 M 5 7 L 6 8 L 7 8 M 3 0 L 4 8 L 5 9 L 7 9 L 8 6 L 8 5 M -12 9 L -4 9 M -5 -12 L -2 -11 M -4 -12 L -3 -10 M 0 -12 L -2 -10 M 1 -12 L -2 -11 M -8 8 L -11 9 M -8 7 L -10 9 M -7 7 L -6 9 M -8 8 L -5 9","-11 12 M 8 -10 L 9 -10 L 10 -12 L 9 -6 L 9 -8 L 8 -10 L 7 -11 L 4 -12 L 0 -12 L -3 -11 L -5 -9 L -5 -6 L -4 -4 L -2 -2 L 4 1 L 5 3 L 5 6 L 4 8 M -4 -6 L -3 -4 L 4 0 L 5 2 M -3 -11 L -4 -9 L -4 -7 L -3 -5 L 3 -2 L 5 0 L 6 2 L 6 5 L 5 7 L 4 8 L 1 9 L -3 9 L -6 8 L -7 7 L -8 5 L -8 3 L -9 9 L -8 7 L -7 7","-11 11 M 2 -12 L -4 9 M 3 -12 L -3 9 M 4 -12 L -2 9 M -5 -12 L -7 -6 M 11 -12 L 10 -6 M -5 -12 L 11 -12 M -7 9 L 1 9 M -4 -12 L -7 -6 M -2 -12 L -6 -9 M 0 -12 L -5 -11 M 7 -12 L 10 -11 M 8 -12 L 10 -10 M 9 -12 L 10 -9 M 10 -12 L 10 -6 M -3 8 L -6 9 M -3 7 L -5 9 M -2 7 L -1 9 M -3 8 L 0 9","-12 13 M -4 -12 L -7 -1 L -8 3 L -8 6 L -7 8 L -4 9 L 0 9 L 3 8 L 5 6 L 6 3 L 10 -11 M -3 -12 L -6 -1 L -7 3 L -7 7 L -6 8 M -2 -12 L -5 -1 L -6 3 L -6 7 L -4 9 M -7 -12 L 1 -12 M 7 -12 L 13 -12 M -6 -12 L -3 -11 M -5 -12 L -4 -10 M -1 -12 L -3 -10 M 0 -12 L -3 -11 M 8 -12 L 10 -11 M 12 -12 L 10 -11","-10 10 M -4 -12 L -4 -10 L -3 7 L -3 9 M -3 -11 L -2 6 M -2 -12 L -1 5 M 9 -11 L -3 9 M -6 -12 L 1 -12 M 6 -12 L 12 -12 M -5 -12 L -4 -10 M -1 -12 L -2 -10 M 0 -12 L -3 -11 M 7 -12 L 9 -11 M 11 -12 L 9 -11","-13 13 M -5 -12 L -5 -10 L -7 7 L -7 9 M -4 -11 L -6 6 M -3 -12 L -5 5 M 3 -12 L -5 5 L -7 9 M 3 -12 L 3 -10 L 1 7 L 1 9 M 4 -11 L 2 6 M 5 -12 L 3 5 M 11 -11 L 3 5 L 1 9 M -8 -12 L 0 -12 M 3 -12 L 5 -12 M 8 -12 L 14 -12 M -7 -12 L -4 -11 M -6 -12 L -5 -10 M -2 -12 L -4 -9 M -1 -12 L -4 -11 M 9 -12 L 11 -11 M 13 -12 L 11 -11","-11 11 M -4 -12 L 2 9 M -3 -12 L 3 9 M -2 -12 L 4 9 M 9 -11 L -9 8 M -6 -12 L 1 -12 M 6 -12 L 12 -12 M -12 9 L -6 9 M -1 9 L 6 9 M -5 -12 L -3 -10 M -1 -12 L -2 -10 M 0 -12 L -2 -11 M 7 -12 L 9 -11 M 11 -12 L 9 -11 M -9 8 L -11 9 M -9 8 L -7 9 M 2 8 L 0 9 M 2 7 L 1 9 M 3 7 L 5 9","-11 11 M -5 -12 L -1 -2 L -4 9 M -4 -12 L 0 -2 L -3 9 M -3 -12 L 1 -2 L -2 9 M 10 -11 L 1 -2 M -7 -12 L 0 -12 M 7 -12 L 13 -12 M -7 9 L 1 9 M -6 -12 L -4 -11 M -2 -12 L -3 -10 M -1 -12 L -4 -11 M 8 -12 L 10 -11 M 12 -12 L 10 -11 M -3 8 L -6 9 M -3 7 L -5 9 M -2 7 L -1 9 M -3 8 L 0 9","-11 11 M 8 -12 L -10 9 M 9 -12 L -9 9 M 10 -12 L -8 9 M 10 -12 L -4 -12 L -6 -6 M -10 9 L 4 9 L 6 3 M -3 -12 L -6 -6 M -2 -12 L -5 -9 M 0 -12 L -4 -11 M 0 9 L 4 8 M 2 9 L 5 6 M 3 9 L 6 3","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-11 11 M -8 2 L 0 -3 L 8 2 M -8 2 L 0 -2 L 8 2","-10 10 M -10 16 L 10 16","-6 6 M -2 -12 L 3 -6 M -2 -12 L -3 -11 L 3 -6","-11 11 M 5 -5 L 3 2 L 3 6 L 4 8 L 5 9 L 7 9 L 9 7 L 10 5 M 6 -5 L 4 2 L 4 8 M 5 -5 L 7 -5 L 5 2 L 4 6 M 3 2 L 3 -1 L 2 -4 L 0 -5 L -2 -5 L -5 -4 L -7 -1 L -8 2 L -8 4 L -7 7 L -6 8 L -4 9 L -2 9 L 0 8 L 1 7 L 2 5 L 3 2 M -4 -4 L -6 -1 L -7 2 L -7 5 L -6 7 M -2 -5 L -4 -3 L -5 -1 L -6 2 L -6 5 L -5 8 L -4 9","-9 10 M -2 -12 L -4 -5 L -5 1 L -5 5 L -4 7 L -3 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 2 L 7 0 L 6 -3 L 5 -4 L 3 -5 L 1 -5 L -1 -4 L -2 -3 L -3 -1 L -4 2 M -1 -12 L -3 -5 L -4 -1 L -4 5 L -3 8 M 4 7 L 5 5 L 6 2 L 6 -1 L 5 -3 M -5 -12 L 0 -12 L -2 -5 L -4 2 M 1 9 L 3 7 L 4 5 L 5 2 L 5 -1 L 4 -4 L 3 -5 M -4 -12 L -1 -11 M -3 -12 L -2 -10","-9 9 M 5 -1 L 5 -2 L 4 -2 L 4 0 L 6 0 L 6 -2 L 5 -4 L 3 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 4 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 5 M -3 -3 L -4 -1 L -5 2 L -5 5 L -4 7 M 0 -5 L -2 -3 L -3 -1 L -4 2 L -4 5 L -3 8 L -2 9","-11 11 M 7 -12 L 4 -1 L 3 3 L 3 6 L 4 8 L 5 9 L 7 9 L 9 7 L 10 5 M 8 -12 L 5 -1 L 4 3 L 4 8 M 4 -12 L 9 -12 L 5 2 L 4 6 M 3 2 L 3 -1 L 2 -4 L 0 -5 L -2 -5 L -5 -4 L -7 -1 L -8 2 L -8 4 L -7 7 L -6 8 L -4 9 L -2 9 L 0 8 L 1 7 L 2 5 L 3 2 M -5 -3 L -6 -1 L -7 2 L -7 5 L -6 7 M -2 -5 L -4 -3 L -5 -1 L -6 2 L -6 5 L -5 8 L -4 9 M 5 -12 L 8 -11 M 6 -12 L 7 -10","-9 9 M -5 4 L -1 3 L 2 2 L 5 0 L 6 -2 L 5 -4 L 3 -5 L 0 -5 L -3 -4 L -5 -1 L -6 2 L -6 4 L -5 7 L -4 8 L -2 9 L 0 9 L 3 8 L 5 6 M -3 -3 L -4 -1 L -5 2 L -5 5 L -4 7 M 0 -5 L -2 -3 L -3 -1 L -4 2 L -4 5 L -3 8 L -2 9","-8 8 M 8 -10 L 8 -11 L 7 -11 L 7 -9 L 9 -9 L 9 -11 L 8 -12 L 6 -12 L 4 -11 L 2 -9 L 1 -7 L 0 -4 L -1 0 L -3 9 L -4 12 L -5 14 L -7 16 M 2 -8 L 1 -5 L 0 0 L -2 9 L -3 12 M 6 -12 L 4 -10 L 3 -8 L 2 -5 L 1 0 L -1 8 L -2 11 L -3 13 L -5 15 L -7 16 L -9 16 L -10 15 L -10 13 L -8 13 L -8 15 L -9 15 L -9 14 M -4 -5 L 7 -5","-10 11 M 6 -5 L 2 9 L 1 12 L -1 15 L -3 16 M 7 -5 L 3 9 L 1 13 M 6 -5 L 8 -5 L 4 9 L 2 13 L 0 15 L -3 16 L -6 16 L -8 15 L -9 14 L -9 12 L -7 12 L -7 14 L -8 14 L -8 13 M 4 2 L 4 -1 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 4 L -6 7 L -5 8 L -3 9 L -1 9 L 1 8 L 2 7 L 3 5 L 4 2 M -4 -3 L -5 -1 L -6 2 L -6 5 L -5 7 M -1 -5 L -3 -3 L -4 -1 L -5 2 L -5 5 L -4 8 L -3 9","-11 11 M -3 -12 L -9 9 L -7 9 M -2 -12 L -8 9 M -6 -12 L -1 -12 L -7 9 M -5 2 L -3 -2 L -1 -4 L 1 -5 L 3 -5 L 5 -4 L 6 -2 L 6 1 L 4 6 M 5 -4 L 5 0 L 4 4 L 4 8 M 5 -2 L 3 3 L 3 6 L 4 8 L 5 9 L 7 9 L 9 7 L 10 5 M -5 -12 L -2 -11 M -4 -12 L -3 -10","-7 6 M 1 -12 L 1 -10 L 3 -10 L 3 -12 L 1 -12 M 2 -12 L 2 -10 M 1 -11 L 3 -11 M -6 -1 L -5 -3 L -3 -5 L -1 -5 L 0 -4 L 1 -2 L 1 1 L -1 6 M 0 -4 L 0 0 L -1 4 L -1 8 M 0 -2 L -2 3 L -2 6 L -1 8 L 0 9 L 2 9 L 4 7 L 5 5","-7 6 M 3 -12 L 3 -10 L 5 -10 L 5 -12 L 3 -12 M 4 -12 L 4 -10 M 3 -11 L 5 -11 M -5 -1 L -4 -3 L -2 -5 L 0 -5 L 1 -4 L 2 -2 L 2 1 L 0 8 L -1 11 L -2 13 L -4 15 L -6 16 L -8 16 L -9 15 L -9 13 L -7 13 L -7 15 L -8 15 L -8 14 M 1 -4 L 1 1 L -1 8 L -2 11 L -3 13 M 1 -2 L 0 2 L -2 9 L -3 12 L -4 14 L -6 16","-11 11 M -3 -12 L -9 9 L -7 9 M -2 -12 L -8 9 M -6 -12 L -1 -12 L -7 9 M 7 -3 L 7 -4 L 6 -4 L 6 -2 L 8 -2 L 8 -4 L 7 -5 L 5 -5 L 3 -4 L -1 0 L -3 1 M -5 1 L -3 1 L -1 2 L 0 3 L 2 7 L 3 8 L 5 8 M -1 3 L 1 7 L 2 8 M -3 1 L -2 2 L 0 8 L 1 9 L 3 9 L 5 8 L 7 5 M -5 -12 L -2 -11 M -4 -12 L -3 -10","-6 6 M 2 -12 L -1 -1 L -2 3 L -2 6 L -1 8 L 0 9 L 2 9 L 4 7 L 5 5 M 3 -12 L 0 -1 L -1 3 L -1 8 M -1 -12 L 4 -12 L 0 2 L -1 6 M 0 -12 L 3 -11 M 1 -12 L 2 -10","-18 17 M -17 -1 L -16 -3 L -14 -5 L -12 -5 L -11 -4 L -10 -2 L -10 1 L -12 9 M -11 -4 L -11 1 L -13 9 M -11 -2 L -12 2 L -14 9 L -12 9 M -10 1 L -8 -2 L -6 -4 L -4 -5 L -2 -5 L 0 -4 L 1 -2 L 1 1 L -1 9 M 0 -4 L 0 1 L -2 9 M 0 -2 L -1 2 L -3 9 L -1 9 M 1 1 L 3 -2 L 5 -4 L 7 -5 L 9 -5 L 11 -4 L 12 -2 L 12 1 L 10 6 M 11 -4 L 11 0 L 10 4 L 10 8 M 11 -2 L 9 3 L 9 6 L 10 8 L 11 9 L 13 9 L 15 7 L 16 5","-12 12 M -11 -1 L -10 -3 L -8 -5 L -6 -5 L -5 -4 L -4 -2 L -4 1 L -6 9 M -5 -4 L -5 1 L -7 9 M -5 -2 L -6 2 L -8 9 L -6 9 M -4 1 L -2 -2 L 0 -4 L 2 -5 L 4 -5 L 6 -4 L 7 -2 L 7 1 L 5 6 M 6 -4 L 6 0 L 5 4 L 5 8 M 6 -2 L 4 3 L 4 6 L 5 8 L 6 9 L 8 9 L 10 7 L 11 5","-10 10 M -1 -5 L -4 -4 L -6 -1 L -7 2 L -7 4 L -6 7 L -5 8 L -2 9 L 1 9 L 4 8 L 6 5 L 7 2 L 7 0 L 6 -3 L 5 -4 L 2 -5 L -1 -5 M -4 -3 L -5 -1 L -6 2 L -6 5 L -5 7 M 4 7 L 5 5 L 6 2 L 6 -1 L 5 -3 M -1 -5 L -3 -3 L -4 -1 L -5 2 L -5 5 L -4 8 L -2 9 M 1 9 L 3 7 L 4 5 L 5 2 L 5 -1 L 4 -4 L 2 -5","-11 11 M -10 -1 L -9 -3 L -7 -5 L -5 -5 L -4 -4 L -3 -2 L -3 1 L -4 5 L -7 16 M -4 -4 L -4 1 L -5 5 L -8 16 M -4 -2 L -5 2 L -9 16 M -3 2 L -2 -1 L -1 -3 L 0 -4 L 2 -5 L 4 -5 L 6 -4 L 7 -3 L 8 0 L 8 2 L 7 5 L 5 8 L 2 9 L 0 9 L -2 8 L -3 5 L -3 2 M 6 -3 L 7 -1 L 7 2 L 6 5 L 5 7 M 4 -5 L 5 -4 L 6 -1 L 6 2 L 5 5 L 4 7 L 2 9 M -12 16 L -4 16 M -8 15 L -11 16 M -8 14 L -10 16 M -7 14 L -6 16 M -8 15 L -5 16","-11 10 M 5 -5 L -1 16 M 6 -5 L 0 16 M 5 -5 L 7 -5 L 1 16 M 3 2 L 3 -1 L 2 -4 L 0 -5 L -2 -5 L -5 -4 L -7 -1 L -8 2 L -8 4 L -7 7 L -6 8 L -4 9 L -2 9 L 0 8 L 1 7 L 2 5 L 3 2 M -5 -3 L -6 -1 L -7 2 L -7 5 L -6 7 M -2 -5 L -4 -3 L -5 -1 L -6 2 L -6 5 L -5 8 L -4 9 M -4 16 L 4 16 M 0 15 L -3 16 M 0 14 L -2 16 M 1 14 L 2 16 M 0 15 L 3 16","-9 9 M -8 -1 L -7 -3 L -5 -5 L -3 -5 L -2 -4 L -1 -2 L -1 2 L -3 9 M -2 -4 L -2 2 L -4 9 M -2 -2 L -3 2 L -5 9 L -3 9 M 7 -3 L 7 -4 L 6 -4 L 6 -2 L 8 -2 L 8 -4 L 7 -5 L 5 -5 L 3 -4 L 1 -2 L -1 2","-8 9 M 6 -2 L 6 -3 L 5 -3 L 5 -1 L 7 -1 L 7 -3 L 6 -4 L 3 -5 L 0 -5 L -3 -4 L -4 -3 L -4 -1 L -3 1 L -1 2 L 2 3 L 4 4 L 5 6 M -3 -4 L -4 -1 M -3 0 L -1 1 L 2 2 L 4 3 M 5 4 L 4 8 M -4 -3 L -3 -1 L -1 0 L 2 1 L 4 2 L 5 4 L 5 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -6 5 L -4 5 L -4 7 L -5 7 L -5 6","-7 7 M 2 -12 L -1 -1 L -2 3 L -2 6 L -1 8 L 0 9 L 2 9 L 4 7 L 5 5 M 3 -12 L 0 -1 L -1 3 L -1 8 M 2 -12 L 4 -12 L 0 2 L -1 6 M -4 -5 L 6 -5","-12 12 M -11 -1 L -10 -3 L -8 -5 L -6 -5 L -5 -4 L -4 -2 L -4 1 L -6 6 M -5 -4 L -5 0 L -6 4 L -6 8 M -5 -2 L -7 3 L -7 6 L -6 8 L -4 9 L -2 9 L 0 8 L 2 6 L 4 3 M 6 -5 L 4 3 L 4 6 L 5 8 L 6 9 L 8 9 L 10 7 L 11 5 M 7 -5 L 5 3 L 5 8 M 6 -5 L 8 -5 L 6 2 L 5 6","-10 10 M -9 -1 L -8 -3 L -6 -5 L -4 -5 L -3 -4 L -2 -2 L -2 1 L -4 6 M -3 -4 L -3 0 L -4 4 L -4 8 M -3 -2 L -5 3 L -5 6 L -4 8 L -2 9 L 0 9 L 2 8 L 4 6 L 6 3 L 7 -1 L 7 -5 L 6 -5 L 6 -4 L 7 -2","-15 15 M -14 -1 L -13 -3 L -11 -5 L -9 -5 L -8 -4 L -7 -2 L -7 1 L -9 6 M -8 -4 L -8 0 L -9 4 L -9 8 M -8 -2 L -10 3 L -10 6 L -9 8 L -7 9 L -5 9 L -3 8 L -1 6 L 0 3 M 2 -5 L 0 3 L 0 6 L 1 8 L 3 9 L 5 9 L 7 8 L 9 6 L 11 3 L 12 -1 L 12 -5 L 11 -5 L 11 -4 L 12 -2 M 3 -5 L 1 3 L 1 8 M 2 -5 L 4 -5 L 2 2 L 1 6","-11 11 M -8 -1 L -6 -4 L -4 -5 L -2 -5 L 0 -4 L 1 -2 L 1 0 M -2 -5 L -1 -4 L -1 0 L -2 4 L -3 6 L -5 8 L -7 9 L -9 9 L -10 8 L -10 6 L -8 6 L -8 8 L -9 8 L -9 7 M 0 -3 L 0 0 L -1 4 L -1 7 M 8 -3 L 8 -4 L 7 -4 L 7 -2 L 9 -2 L 9 -4 L 8 -5 L 6 -5 L 4 -4 L 2 -2 L 1 0 L 0 4 L 0 8 L 1 9 M -2 4 L -2 6 L -1 8 L 1 9 L 3 9 L 5 8 L 7 5","-11 11 M -10 -1 L -9 -3 L -7 -5 L -5 -5 L -4 -4 L -3 -2 L -3 1 L -5 6 M -4 -4 L -4 0 L -5 4 L -5 8 M -4 -2 L -6 3 L -6 6 L -5 8 L -3 9 L -1 9 L 1 8 L 3 6 L 5 2 M 7 -5 L 3 9 L 2 12 L 0 15 L -2 16 M 8 -5 L 4 9 L 2 13 M 7 -5 L 9 -5 L 5 9 L 3 13 L 1 15 L -2 16 L -5 16 L -7 15 L -8 14 L -8 12 L -6 12 L -6 14 L -7 14 L -7 13","-10 10 M 7 -5 L 6 -3 L 4 -1 L -4 5 L -6 7 L -7 9 M 6 -3 L -3 -3 L -5 -2 L -6 0 M 4 -3 L 0 -4 L -3 -4 L -4 -3 M 4 -3 L 0 -5 L -3 -5 L -5 -3 L -6 0 M -6 7 L 3 7 L 5 6 L 6 4 M -4 7 L 0 8 L 3 8 L 4 7 M -4 7 L 0 9 L 3 9 L 5 7 L 6 4","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
timesr = ["-8 8","-5 5 M 0 -12 L -1 -10 L 0 2 L 1 -10 L 0 -12 M 0 -10 L 0 -4 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-9 9 M -4 -12 L -5 -11 L -5 -5 M -4 -11 L -5 -5 M -4 -12 L -3 -11 L -5 -5 M 5 -12 L 4 -11 L 4 -5 M 5 -11 L 4 -5 M 5 -12 L 6 -11 L 4 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 10 M -2 -16 L -2 13 M 2 -16 L 2 13 M 6 -9 L 5 -8 L 6 -7 L 7 -8 L 7 -9 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 7 2 M -7 -7 L -5 -5 L -3 -4 L 3 -2 L 5 -1 L 6 0 L 7 2 L 7 6 L 5 8 L 2 9 L -2 9 L -5 8 L -7 6 L -7 5 L -6 4 L -5 5 L -6 6","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-12 13 M 9 -4 L 8 -3 L 9 -2 L 10 -3 L 10 -4 L 9 -5 L 8 -5 L 7 -4 L 6 -2 L 4 3 L 2 6 L 0 8 L -2 9 L -5 9 L -8 8 L -9 6 L -9 3 L -8 1 L -2 -3 L 0 -5 L 1 -7 L 1 -9 L 0 -11 L -2 -12 L -4 -11 L -5 -9 L -5 -7 L -4 -4 L -2 -1 L 3 6 L 5 8 L 8 9 L 9 9 L 10 8 L 10 7 M -5 9 L -7 8 L -8 6 L -8 3 L -7 1 L -5 -1 M -5 -7 L -4 -5 L 4 6 L 6 8 L 8 9","-4 4 M 0 -12 L -1 -5 M 1 -12 L -1 -5","-7 7 M 4 -16 L 2 -14 L 0 -11 L -2 -7 L -3 -2 L -3 2 L -2 7 L 0 11 L 2 14 L 4 16 M 2 -14 L 0 -10 L -1 -7 L -2 -2 L -2 2 L -1 7 L 0 10 L 2 14","-7 7 M -4 -16 L -2 -14 L 0 -11 L 2 -7 L 3 -2 L 3 2 L 2 7 L 0 11 L -2 14 L -4 16 M -2 -14 L 0 -10 L 1 -7 L 2 -2 L 2 2 L 1 7 L 0 10 L -2 14","-8 8 M 0 -6 L 0 6 M -5 -3 L 5 3 M 5 -3 L -5 3","-13 13 M 0 -9 L 0 9 M -9 0 L 9 0","-4 4 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-13 13 M -9 0 L 9 0","-4 4 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-11 11 M 9 -16 L -9 16","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12 M -1 -12 L -3 -11 L -4 -10 L -5 -8 L -6 -3 L -6 0 L -5 5 L -4 7 L -3 8 L -1 9 M 1 9 L 3 8 L 4 7 L 5 5 L 6 0 L 6 -3 L 5 -8 L 4 -10 L 3 -11 L 1 -12","-10 10 M -4 -8 L -2 -9 L 1 -12 L 1 9 M 0 -11 L 0 9 M -4 9 L 5 9","-10 10 M -6 -8 L -5 -7 L -6 -6 L -7 -7 L -7 -8 L -6 -10 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 3 -2 L -2 0 L -4 1 L -6 3 L -7 6 L -7 9 M 2 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 2 -2 L -2 0 M -7 7 L -6 6 L -4 6 L 1 8 L 4 8 L 6 7 L 7 6 M -4 6 L 1 9 L 5 9 L 6 8 L 7 6 L 7 4","-10 10 M -6 -8 L -5 -7 L -6 -6 L -7 -7 L -7 -8 L -6 -10 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -9 L 6 -6 L 5 -4 L 2 -3 L -1 -3 M 2 -12 L 4 -11 L 5 -9 L 5 -6 L 4 -4 L 2 -3 M 2 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 4 L -6 5 M 5 -1 L 6 2 L 6 5 L 5 7 L 4 8 L 2 9","-10 10 M 2 -10 L 2 9 M 3 -12 L 3 9 M 3 -12 L -8 3 L 8 3 M -1 9 L 6 9","-10 10 M -5 -12 L -7 -2 M -7 -2 L -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 4 L -6 5 M 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 M -5 -12 L 5 -12 M -5 -11 L 0 -11 L 5 -12","-10 10 M 5 -9 L 4 -8 L 5 -7 L 6 -8 L 6 -9 L 5 -11 L 3 -12 L 0 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -3 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L 0 -4 L -3 -3 L -5 -1 L -6 2 M 0 -12 L -2 -11 L -4 -9 L -5 -7 L -6 -3 L -6 3 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 3 L 6 2 L 5 -1 L 3 -3 L 1 -4","-10 10 M -7 -12 L -7 -6 M -7 -8 L -6 -10 L -4 -12 L -2 -12 L 3 -9 L 5 -9 L 6 -10 L 7 -12 M -6 -10 L -4 -11 L -2 -11 L 3 -9 M 7 -12 L 7 -9 L 6 -6 L 2 -1 L 1 1 L 0 4 L 0 9 M 6 -6 L 1 -1 L 0 1 L -1 4 L -1 9","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -6 L -5 -4 L -2 -3 L 2 -3 L 5 -4 L 6 -6 L 6 -9 L 5 -11 L 2 -12 L -2 -12 M -2 -12 L -4 -11 L -5 -9 L -5 -6 L -4 -4 L -2 -3 M 2 -3 L 4 -4 L 5 -6 L 5 -9 L 4 -11 L 2 -12 M -2 -3 L -5 -2 L -6 -1 L -7 1 L -7 5 L -6 7 L -5 8 L -2 9 L 2 9 L 5 8 L 6 7 L 7 5 L 7 1 L 6 -1 L 5 -2 L 2 -3 M -2 -3 L -4 -2 L -5 -1 L -6 1 L -6 5 L -5 7 L -4 8 L -2 9 M 2 9 L 4 8 L 5 7 L 6 5 L 6 1 L 5 -1 L 4 -2 L 2 -3","-10 10 M 6 -5 L 5 -2 L 3 0 L 0 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -6 L 7 0 L 6 4 L 5 6 L 3 8 L 0 9 L -3 9 L -5 8 L -6 6 L -6 5 L -5 4 L -4 5 L -5 6 M -1 1 L -3 0 L -5 -2 L -6 -5 L -6 -6 L -5 -9 L -3 -11 L -1 -12 M 1 -12 L 3 -11 L 5 -9 L 6 -6 L 6 0 L 5 4 L 4 6 L 2 8 L 0 9","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 0 4 L -1 5 L 0 6 L 1 5 L 0 4","-4 4 M 0 -3 L -1 -2 L 0 -1 L 1 -2 L 0 -3 M 1 5 L 0 6 L -1 5 L 0 4 L 1 5 L 1 7 L -1 9","-12 12 M 8 -9 L -8 0 L 8 9","-13 13 M -9 -3 L 9 -3 M -9 3 L 9 3","-12 12 M -8 -9 L 8 0 L -8 9","-9 9 M -5 -8 L -4 -7 L -5 -6 L -6 -7 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 1 -12 L 4 -11 L 5 -10 L 6 -8 L 6 -6 L 5 -4 L 4 -3 L 0 -1 L 0 2 M 1 -12 L 3 -11 L 4 -10 L 5 -8 L 5 -6 L 4 -4 L 2 -2 M 0 7 L -1 8 L 0 9 L 1 8 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-10 10 M 0 -12 L -7 9 M 0 -12 L 7 9 M 0 -9 L 6 9 M -5 3 L 4 3 M -9 9 L -3 9 M 3 9 L 9 9","-11 11 M -6 -12 L -6 9 M -5 -12 L -5 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -6 L 7 -4 L 6 -3 L 3 -2 M 3 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 3 -2 M -5 -2 L 3 -2 L 6 -1 L 7 0 L 8 2 L 8 5 L 7 7 L 6 8 L 3 9 L -9 9 M 3 -2 L 5 -1 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 3 9","-11 10 M 6 -9 L 7 -6 L 7 -12 L 6 -9 L 4 -11 L 1 -12 L -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 4 M -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 L -3 8 L -1 9","-11 11 M -6 -12 L -6 9 M -5 -12 L -5 9 M -9 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -7 L 8 -4 L 8 1 L 7 4 L 6 6 L 4 8 L 1 9 L -9 9 M 1 -12 L 3 -11 L 5 -9 L 6 -7 L 7 -4 L 7 1 L 6 4 L 5 6 L 3 8 L 1 9","-11 10 M -6 -12 L -6 9 M -5 -12 L -5 9 M 1 -6 L 1 2 M -9 -12 L 7 -12 L 7 -6 L 6 -12 M -5 -2 L 1 -2 M -9 9 L 7 9 L 7 3 L 6 9","-11 9 M -6 -12 L -6 9 M -5 -12 L -5 9 M 1 -6 L 1 2 M -9 -12 L 7 -12 L 7 -6 L 6 -12 M -5 -2 L 1 -2 M -9 9 L -2 9","-11 12 M 6 -9 L 7 -6 L 7 -12 L 6 -9 L 4 -11 L 1 -12 L -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 M -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 L -3 8 L -1 9 M 6 1 L 6 9 M 7 1 L 7 9 M 3 1 L 10 1","-12 12 M -7 -12 L -7 9 M -6 -12 L -6 9 M 6 -12 L 6 9 M 7 -12 L 7 9 M -10 -12 L -3 -12 M 3 -12 L 10 -12 M -6 -2 L 6 -2 M -10 9 L -3 9 M 3 9 L 10 9","-5 6 M 0 -12 L 0 9 M 1 -12 L 1 9 M -3 -12 L 4 -12 M -3 9 L 4 9","-7 8 M 3 -12 L 3 5 L 2 8 L 0 9 L -2 9 L -4 8 L -5 6 L -5 4 L -4 3 L -3 4 L -4 5 M 2 -12 L 2 5 L 1 8 L 0 9 M -1 -12 L 6 -12","-12 10 M -7 -12 L -7 9 M -6 -12 L -6 9 M 7 -12 L -6 1 M -1 -3 L 7 9 M -2 -3 L 6 9 M -10 -12 L -3 -12 M 3 -12 L 9 -12 M -10 9 L -3 9 M 3 9 L 9 9","-9 9 M -4 -12 L -4 9 M -3 -12 L -3 9 M -7 -12 L 0 -12 M -7 9 L 8 9 L 8 3 L 7 9","-12 13 M -7 -12 L -7 9 M -6 -12 L 0 6 M -7 -12 L 0 9 M 7 -12 L 0 9 M 7 -12 L 7 9 M 8 -12 L 8 9 M -10 -12 L -6 -12 M 7 -12 L 11 -12 M -10 9 L -4 9 M 4 9 L 11 9","-11 12 M -6 -12 L -6 9 M -5 -12 L 7 7 M -5 -10 L 7 9 M 7 -12 L 7 9 M -9 -12 L -5 -12 M 4 -12 L 10 -12 M -9 9 L -3 9","-11 11 M -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -3 L -8 0 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 4 L 8 0 L 8 -3 L 7 -7 L 6 -9 L 4 -11 L 1 -12 L -1 -12 M -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -3 L -7 0 L -6 4 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 4 L 7 0 L 7 -3 L 6 -7 L 5 -9 L 3 -11 L 1 -12","-11 11 M -6 -12 L -6 9 M -5 -12 L -5 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -5 L 7 -3 L 6 -2 L 3 -1 L -5 -1 M 3 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -5 L 6 -3 L 5 -2 L 3 -1 M -9 9 L -2 9","-11 11 M -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -3 L -8 0 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 4 L 8 0 L 8 -3 L 7 -7 L 6 -9 L 4 -11 L 1 -12 L -1 -12 M -1 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -3 L -7 0 L -6 4 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 4 L 7 0 L 7 -3 L 6 -7 L 5 -9 L 3 -11 L 1 -12 M -4 7 L -4 6 L -3 4 L -1 3 L 0 3 L 2 4 L 3 6 L 4 13 L 5 14 L 7 14 L 8 12 L 8 11 M 3 6 L 4 10 L 5 12 L 6 13 L 7 13 L 8 12","-11 11 M -6 -12 L -6 9 M -5 -12 L -5 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -6 L 7 -4 L 6 -3 L 3 -2 L -5 -2 M 3 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 3 -2 M -9 9 L -2 9 M 0 -2 L 2 -1 L 3 0 L 6 7 L 7 8 L 8 8 L 9 7 M 2 -1 L 3 1 L 5 8 L 6 9 L 8 9 L 9 7 L 9 6","-10 10 M 6 -9 L 7 -12 L 7 -6 L 6 -9 L 4 -11 L 1 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -7 L -6 -5 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 7 2 M -7 -7 L -5 -5 L -3 -4 L 3 -2 L 5 -1 L 6 0 L 7 2 L 7 6 L 5 8 L 2 9 L -1 9 L -4 8 L -6 6 L -7 3 L -7 9 L -6 6","-9 10 M 0 -12 L 0 9 M 1 -12 L 1 9 M -6 -12 L -7 -6 L -7 -12 L 8 -12 L 8 -6 L 7 -12 M -3 9 L 4 9","-12 12 M -7 -12 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 -12 M -6 -12 L -6 3 L -5 6 L -3 8 L -1 9 M -10 -12 L -3 -12 M 4 -12 L 10 -12","-10 10 M -7 -12 L 0 9 M -6 -12 L 0 6 M 7 -12 L 0 9 M -9 -12 L -3 -12 M 3 -12 L 9 -12","-12 12 M -8 -12 L -4 9 M -7 -12 L -4 4 M 0 -12 L -4 9 M 0 -12 L 4 9 M 1 -12 L 4 4 M 8 -12 L 4 9 M -11 -12 L -4 -12 M 5 -12 L 11 -12","-10 10 M -7 -12 L 6 9 M -6 -12 L 7 9 M 7 -12 L -7 9 M -9 -12 L -3 -12 M 3 -12 L 9 -12 M -9 9 L -3 9 M 3 9 L 9 9","-10 11 M -7 -12 L 0 -1 L 0 9 M -6 -12 L 1 -1 L 1 9 M 8 -12 L 1 -1 M -9 -12 L -3 -12 M 4 -12 L 10 -12 M -3 9 L 4 9","-10 10 M 6 -12 L -7 9 M 7 -12 L -6 9 M -6 -12 L -7 -6 L -7 -12 L 7 -12 M -7 9 L 7 9 L 7 3 L 6 9","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-11 11 M -8 2 L 0 -3 L 8 2 M -8 2 L 0 -2 L 8 2","-10 10 M -10 16 L 10 16","-6 6 M -2 -12 L 3 -6 M -2 -12 L -3 -11 L 3 -6","-9 11 M -4 -3 L -4 -2 L -5 -2 L -5 -3 L -4 -4 L -2 -5 L 2 -5 L 4 -4 L 5 -3 L 6 -1 L 6 6 L 7 8 L 8 9 M 5 -3 L 5 6 L 6 8 L 8 9 L 9 9 M 5 -1 L 4 0 L -2 1 L -5 2 L -6 4 L -6 6 L -5 8 L -2 9 L 1 9 L 3 8 L 5 6 M -2 1 L -4 2 L -5 4 L -5 6 L -4 8 L -2 9","-11 10 M -6 -12 L -6 9 M -5 -12 L -5 9 M -5 -2 L -3 -4 L -1 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -1 9 L -3 8 L -5 6 M 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 M -9 -12 L -5 -12","-10 9 M 5 -2 L 4 -1 L 5 0 L 6 -1 L 6 -2 L 4 -4 L 2 -5 L -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9","-10 11 M 5 -12 L 5 9 M 6 -12 L 6 9 M 5 -2 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 3 8 L 5 6 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 M 2 -12 L 6 -12 M 5 9 L 9 9","-10 9 M -6 1 L 6 1 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 M 5 1 L 5 -2 L 4 -4 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9","-7 6 M 3 -11 L 2 -10 L 3 -9 L 4 -10 L 4 -11 L 3 -12 L 1 -12 L -1 -11 L -2 -9 L -2 9 M 1 -12 L 0 -11 L -1 -9 L -1 9 M -5 -5 L 3 -5 M -5 9 L 2 9","-9 10 M -1 -5 L -3 -4 L -4 -3 L -5 -1 L -5 1 L -4 3 L -3 4 L -1 5 L 1 5 L 3 4 L 4 3 L 5 1 L 5 -1 L 4 -3 L 3 -4 L 1 -5 L -1 -5 M -3 -4 L -4 -2 L -4 2 L -3 4 M 3 4 L 4 2 L 4 -2 L 3 -4 M 4 -3 L 5 -4 L 7 -5 L 7 -4 L 5 -4 M -4 3 L -5 4 L -6 6 L -6 7 L -5 9 L -2 10 L 3 10 L 6 11 L 7 12 M -6 7 L -5 8 L -2 9 L 3 9 L 6 10 L 7 12 L 7 13 L 6 15 L 3 16 L -3 16 L -6 15 L -7 13 L -7 12 L -6 10 L -3 9","-11 11 M -6 -12 L -6 9 M -5 -12 L -5 9 M -5 -2 L -3 -4 L 0 -5 L 2 -5 L 5 -4 L 6 -2 L 6 9 M 2 -5 L 4 -4 L 5 -2 L 5 9 M -9 -12 L -5 -12 M -9 9 L -2 9 M 2 9 L 9 9","-5 6 M 0 -12 L -1 -11 L 0 -10 L 1 -11 L 0 -12 M 0 -5 L 0 9 M 1 -5 L 1 9 M -3 -5 L 1 -5 M -3 9 L 4 9","-5 6 M 1 -12 L 0 -11 L 1 -10 L 2 -11 L 1 -12 M 2 -5 L 2 13 L 1 15 L -1 16 L -3 16 L -4 15 L -4 14 L -3 13 L -2 14 L -3 15 M 1 -5 L 1 13 L 0 15 L -1 16 M -2 -5 L 2 -5","-11 10 M -6 -12 L -6 9 M -5 -12 L -5 9 M 5 -5 L -5 5 M 0 1 L 6 9 M -1 1 L 5 9 M -9 -12 L -5 -12 M 2 -5 L 8 -5 M -9 9 L -2 9 M 2 9 L 8 9","-5 6 M 0 -12 L 0 9 M 1 -12 L 1 9 M -3 -12 L 1 -12 M -3 9 L 4 9","-16 17 M -11 -5 L -11 9 M -10 -5 L -10 9 M -10 -2 L -8 -4 L -5 -5 L -3 -5 L 0 -4 L 1 -2 L 1 9 M -3 -5 L -1 -4 L 0 -2 L 0 9 M 1 -2 L 3 -4 L 6 -5 L 8 -5 L 11 -4 L 12 -2 L 12 9 M 8 -5 L 10 -4 L 11 -2 L 11 9 M -14 -5 L -10 -5 M -14 9 L -7 9 M -3 9 L 4 9 M 8 9 L 15 9","-11 11 M -6 -5 L -6 9 M -5 -5 L -5 9 M -5 -2 L -3 -4 L 0 -5 L 2 -5 L 5 -4 L 6 -2 L 6 9 M 2 -5 L 4 -4 L 5 -2 L 5 9 M -9 -5 L -5 -5 M -9 9 L -2 9 M 2 9 L 9 9","-10 10 M -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 1 L 6 -2 L 4 -4 L 1 -5 L -1 -5 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 M 1 9 L 3 8 L 5 6 L 6 3 L 6 1 L 5 -2 L 3 -4 L 1 -5","-11 10 M -6 -5 L -6 16 M -5 -5 L -5 16 M -5 -2 L -3 -4 L -1 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -1 9 L -3 8 L -5 6 M 1 -5 L 3 -4 L 5 -2 L 6 1 L 6 3 L 5 6 L 3 8 L 1 9 M -9 -5 L -5 -5 M -9 16 L -2 16","-10 10 M 5 -5 L 5 16 M 6 -5 L 6 16 M 5 -2 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 3 8 L 5 6 M -1 -5 L -3 -4 L -5 -2 L -6 1 L -6 3 L -5 6 L -3 8 L -1 9 M 2 16 L 9 16","-9 8 M -4 -5 L -4 9 M -3 -5 L -3 9 M -3 1 L -2 -2 L 0 -4 L 2 -5 L 5 -5 L 6 -4 L 6 -3 L 5 -2 L 4 -3 L 5 -4 M -7 -5 L -3 -5 M -7 9 L 0 9","-8 9 M 5 -3 L 6 -5 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L -2 -5 L -4 -4 L -5 -3 L -5 -1 L -4 0 L -2 1 L 3 3 L 5 4 L 6 5 M -5 -2 L -4 -1 L -2 0 L 3 2 L 5 3 L 6 4 L 6 7 L 5 8 L 3 9 L -1 9 L -3 8 L -4 7 L -5 5 L -5 9 L -4 7","-7 8 M -2 -12 L -2 5 L -1 8 L 1 9 L 3 9 L 5 8 L 6 6 M -1 -12 L -1 5 L 0 8 L 1 9 M -5 -5 L 3 -5","-11 11 M -6 -5 L -6 6 L -5 8 L -2 9 L 0 9 L 3 8 L 5 6 M -5 -5 L -5 6 L -4 8 L -2 9 M 5 -5 L 5 9 M 6 -5 L 6 9 M -9 -5 L -5 -5 M 2 -5 L 6 -5 M 5 9 L 9 9","-9 9 M -6 -5 L 0 9 M -5 -5 L 0 7 M 6 -5 L 0 9 M -8 -5 L -2 -5 M 2 -5 L 8 -5","-12 12 M -8 -5 L -4 9 M -7 -5 L -4 6 M 0 -5 L -4 9 M 0 -5 L 4 9 M 1 -5 L 4 6 M 8 -5 L 4 9 M -11 -5 L -4 -5 M 5 -5 L 11 -5","-10 10 M -6 -5 L 5 9 M -5 -5 L 6 9 M 6 -5 L -6 9 M -8 -5 L -2 -5 M 2 -5 L 8 -5 M -8 9 L -2 9 M 2 9 L 8 9","-10 9 M -6 -5 L 0 9 M -5 -5 L 0 7 M 6 -5 L 0 9 L -2 13 L -4 15 L -6 16 L -7 16 L -8 15 L -7 14 L -6 15 M -8 -5 L -2 -5 M 2 -5 L 8 -5","-9 9 M 5 -5 L -6 9 M 6 -5 L -5 9 M -5 -5 L -6 -1 L -6 -5 L 6 -5 M -6 9 L 6 9 L 6 5 L 5 9","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]
timesrb = ["-8 8","-5 6 M 0 -12 L -1 -11 L -1 -9 L 0 -1 M 0 -12 L 0 2 L 1 2 M 0 -12 L 1 -12 L 1 2 M 1 -12 L 2 -11 L 2 -9 L 1 -1 M 0 6 L -1 7 L -1 8 L 0 9 L 1 9 L 2 8 L 2 7 L 1 6 L 0 6 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7","-9 9 M -4 -12 L -5 -11 L -5 -5 M -4 -11 L -5 -5 M -4 -12 L -3 -11 L -5 -5 M 5 -12 L 4 -11 L 4 -5 M 5 -11 L 4 -5 M 5 -12 L 6 -11 L 4 -5","-10 11 M 1 -16 L -6 16 M 7 -16 L 0 16 M -6 -3 L 8 -3 M -7 3 L 7 3","-10 10 M -2 -16 L -2 13 M 2 -16 L 2 13 M 6 -7 L 6 -8 L 5 -8 L 5 -6 L 7 -6 L 7 -8 L 6 -10 L 5 -11 L 2 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -6 L -6 -4 L -3 -2 L 3 0 L 5 1 L 6 3 L 6 6 L 5 8 M -6 -6 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 2 M -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 3 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 3 L -5 3 L -5 5 L -6 5 L -6 4","-12 12 M 9 -12 L -9 9 M -4 -12 L -2 -10 L -2 -8 L -3 -6 L -5 -5 L -7 -5 L -9 -7 L -9 -9 L -8 -11 L -6 -12 L -4 -12 L -2 -11 L 1 -10 L 4 -10 L 7 -11 L 9 -12 M 5 2 L 3 3 L 2 5 L 2 7 L 4 9 L 6 9 L 8 8 L 9 6 L 9 4 L 7 2 L 5 2","-13 13 M 9 -3 L 9 -4 L 8 -4 L 8 -2 L 10 -2 L 10 -4 L 9 -5 L 8 -5 L 7 -4 L 6 -2 L 4 3 L 2 6 L 0 8 L -2 9 L -6 9 L -8 8 L -9 6 L -9 3 L -8 1 L -2 -3 L 0 -5 L 1 -7 L 1 -9 L 0 -11 L -2 -12 L -4 -11 L -5 -9 L -5 -6 L -4 -3 L -2 0 L 2 5 L 5 8 L 7 9 L 9 9 L 10 7 L 10 6 M -7 8 L -8 6 L -8 3 L -7 1 L -6 0 M 0 -5 L 1 -9 M 1 -7 L 0 -11 M -4 -11 L -5 -7 M -4 -4 L -2 -1 L 2 4 L 5 7 L 7 8 M -4 9 L -6 8 L -7 6 L -7 3 L -6 1 L -2 -3 M -5 -9 L -4 -5 L -1 -1 L 3 4 L 6 7 L 8 8 L 9 8 L 10 7","-4 5 M 1 -12 L 0 -11 L 0 -5 M 1 -11 L 0 -5 M 1 -12 L 2 -11 L 0 -5","-7 7 M 3 -16 L 1 -14 L -1 -11 L -3 -7 L -4 -2 L -4 2 L -3 7 L -1 11 L 1 14 L 3 16 M -1 -10 L -2 -7 L -3 -3 L -3 3 L -2 7 L -1 10 M 1 -14 L 0 -12 L -1 -9 L -2 -3 L -2 3 L -1 9 L 0 12 L 1 14","-7 7 M -3 -16 L -1 -14 L 1 -11 L 3 -7 L 4 -2 L 4 2 L 3 7 L 1 11 L -1 14 L -3 16 M 1 -10 L 2 -7 L 3 -3 L 3 3 L 2 7 L 1 10 M -1 -14 L 0 -12 L 1 -9 L 2 -3 L 2 3 L 1 9 L 0 12 L -1 14","-8 8 M 0 -12 L -1 -11 L 1 -1 L 0 0 M 0 -12 L 0 0 M 0 -12 L 1 -11 L -1 -1 L 0 0 M -5 -9 L -4 -9 L 4 -3 L 5 -3 M -5 -9 L 5 -3 M -5 -9 L -5 -8 L 5 -4 L 5 -3 M 5 -9 L 4 -9 L -4 -3 L -5 -3 M 5 -9 L -5 -3 M 5 -9 L 5 -8 L -5 -4 L -5 -3","-12 13 M 0 -9 L 0 8 L 1 8 M 0 -9 L 1 -9 L 1 8 M -8 -1 L 9 -1 L 9 0 M -8 -1 L -8 0 L 9 0","-5 6 M 2 8 L 1 9 L 0 9 L -1 8 L -1 7 L 0 6 L 1 6 L 2 7 L 2 10 L 1 12 L -1 13 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7 M 1 9 L 2 10 M 2 8 L 1 12","-13 13 M -9 0 L 9 0","-5 6 M 0 6 L -1 7 L -1 8 L 0 9 L 1 9 L 2 8 L 2 7 L 1 6 L 0 6 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7","-11 12 M 9 -16 L -9 16 L -8 16 M 9 -16 L 10 -16 L -8 16","-10 10 M -1 -12 L -4 -11 L -6 -8 L -7 -3 L -7 0 L -6 5 L -4 8 L -1 9 L 1 9 L 4 8 L 6 5 L 7 0 L 7 -3 L 6 -8 L 4 -11 L 1 -12 L -1 -12 M -4 -10 L -5 -8 L -6 -4 L -6 1 L -5 5 L -4 7 M 4 7 L 5 5 L 6 1 L 6 -4 L 5 -8 L 4 -10 M -1 -12 L -3 -11 L -4 -9 L -5 -4 L -5 1 L -4 6 L -3 8 L -1 9 M 1 9 L 3 8 L 4 6 L 5 1 L 5 -4 L 4 -9 L 3 -11 L 1 -12","-10 10 M -1 -10 L -1 9 M 0 -10 L 0 8 M 1 -12 L 1 9 M 1 -12 L -2 -9 L -4 -8 M -5 9 L 5 9 M -1 8 L -3 9 M -1 7 L -2 9 M 1 7 L 2 9 M 1 8 L 3 9","-10 10 M -6 -8 L -6 -7 L -5 -7 L -5 -8 L -6 -8 M -6 -9 L -5 -9 L -4 -8 L -4 -7 L -5 -6 L -6 -6 L -7 -7 L -7 -8 L -6 -10 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 3 -2 L -2 0 L -4 1 L -6 3 L -7 6 L -7 9 M 5 -10 L 6 -8 L 6 -6 L 5 -4 M 2 -12 L 4 -11 L 5 -8 L 5 -6 L 4 -4 L 2 -2 L -2 0 M -7 7 L -6 6 L -4 6 L 1 7 L 5 7 L 7 6 M -4 6 L 1 8 L 5 8 L 6 7 M -4 6 L 1 9 L 5 9 L 6 8 L 7 6 L 7 4","-10 10 M -6 -8 L -6 -7 L -5 -7 L -5 -8 L -6 -8 M -6 -9 L -5 -9 L -4 -8 L -4 -7 L -5 -6 L -6 -6 L -7 -7 L -7 -8 L -6 -10 L -5 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -9 L 6 -6 L 5 -4 L 2 -3 M 4 -11 L 5 -9 L 5 -6 L 4 -4 M 1 -12 L 3 -11 L 4 -9 L 4 -6 L 3 -4 L 1 -3 M -1 -3 L 2 -3 L 4 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 3 L -4 4 L -4 5 L -5 6 L -6 6 M 5 0 L 6 2 L 6 5 L 5 7 M 1 -3 L 3 -2 L 4 -1 L 5 2 L 5 5 L 4 8 L 2 9 M -6 4 L -6 5 L -5 5 L -5 4 L -6 4","-10 10 M 1 -9 L 1 9 M 2 -10 L 2 8 M 3 -12 L 3 9 M 3 -12 L -8 3 L 8 3 M -2 9 L 6 9 M 1 8 L -1 9 M 1 7 L 0 9 M 3 7 L 4 9 M 3 8 L 5 9","-10 10 M -5 -12 L -7 -2 L -5 -4 L -2 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -2 9 L -5 8 L -6 7 L -7 5 L -7 4 L -6 3 L -5 3 L -4 4 L -4 5 L -5 6 L -6 6 M 5 -2 L 6 0 L 6 4 L 5 6 M 1 -5 L 3 -4 L 4 -3 L 5 0 L 5 4 L 4 7 L 3 8 L 1 9 M -6 4 L -6 5 L -5 5 L -5 4 L -6 4 M -5 -12 L 5 -12 M -5 -11 L 3 -11 M -5 -10 L -1 -10 L 3 -11 L 5 -12","-10 10 M 4 -9 L 4 -8 L 5 -8 L 5 -9 L 4 -9 M 5 -10 L 4 -10 L 3 -9 L 3 -8 L 4 -7 L 5 -7 L 6 -8 L 6 -9 L 5 -11 L 3 -12 L 0 -12 L -3 -11 L -5 -9 L -6 -7 L -7 -3 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 2 L 6 -1 L 4 -3 L 1 -4 L -1 -4 L -3 -3 L -4 -2 L -5 0 M -4 -9 L -5 -7 L -6 -3 L -6 3 L -5 6 L -4 7 M 5 6 L 6 4 L 6 1 L 5 -1 M 0 -12 L -2 -11 L -3 -10 L -4 -8 L -5 -4 L -5 3 L -4 6 L -3 8 L -1 9 M 1 9 L 3 8 L 4 7 L 5 4 L 5 1 L 4 -2 L 3 -3 L 1 -4","-10 10 M -7 -12 L -7 -6 M 7 -12 L 7 -9 L 6 -6 L 2 -1 L 1 1 L 0 5 L 0 9 M 1 0 L 0 2 L -1 5 L -1 9 M 6 -6 L 1 -1 L -1 2 L -2 5 L -2 9 L 0 9 M -7 -8 L -6 -10 L -4 -12 L -2 -12 L 3 -9 L 5 -9 L 6 -10 L 7 -12 M -5 -10 L -4 -11 L -2 -11 L 0 -10 M -7 -8 L -6 -9 L -4 -10 L -2 -10 L 3 -9","-10 10 M -2 -12 L -5 -11 L -6 -9 L -6 -6 L -5 -4 L -2 -3 L 2 -3 L 5 -4 L 6 -6 L 6 -9 L 5 -11 L 2 -12 L -2 -12 M -4 -11 L -5 -9 L -5 -6 L -4 -4 M 4 -4 L 5 -6 L 5 -9 L 4 -11 M -2 -12 L -3 -11 L -4 -9 L -4 -6 L -3 -4 L -2 -3 M 2 -3 L 3 -4 L 4 -6 L 4 -9 L 3 -11 L 2 -12 M -2 -3 L -5 -2 L -6 -1 L -7 1 L -7 5 L -6 7 L -5 8 L -2 9 L 2 9 L 5 8 L 6 7 L 7 5 L 7 1 L 6 -1 L 5 -2 L 2 -3 M -5 -1 L -6 1 L -6 5 L -5 7 M 5 7 L 6 5 L 6 1 L 5 -1 M -2 -3 L -4 -2 L -5 1 L -5 5 L -4 8 L -2 9 M 2 9 L 4 8 L 5 5 L 5 1 L 4 -2 L 2 -3","-10 10 M -5 5 L -5 6 L -4 6 L -4 5 L -5 5 M 5 -3 L 4 -1 L 3 0 L 1 1 L -1 1 L -4 0 L -6 -2 L -7 -5 L -7 -6 L -6 -9 L -4 -11 L -1 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -6 L 7 0 L 6 4 L 5 6 L 3 8 L 0 9 L -3 9 L -5 8 L -6 6 L -6 5 L -5 4 L -4 4 L -3 5 L -3 6 L -4 7 L -5 7 M -5 -2 L -6 -4 L -6 -7 L -5 -9 M 4 -10 L 5 -9 L 6 -6 L 6 0 L 5 4 L 4 6 M -1 1 L -3 0 L -4 -1 L -5 -4 L -5 -7 L -4 -10 L -3 -11 L -1 -12 M 1 -12 L 3 -11 L 4 -9 L 5 -6 L 5 1 L 4 5 L 3 7 L 2 8 L 0 9","-5 6 M 0 -5 L -1 -4 L -1 -3 L 0 -2 L 1 -2 L 2 -3 L 2 -4 L 1 -5 L 0 -5 M 0 -4 L 0 -3 L 1 -3 L 1 -4 L 0 -4 M 0 6 L -1 7 L -1 8 L 0 9 L 1 9 L 2 8 L 2 7 L 1 6 L 0 6 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7","-5 6 M 0 -5 L -1 -4 L -1 -3 L 0 -2 L 1 -2 L 2 -3 L 2 -4 L 1 -5 L 0 -5 M 0 -4 L 0 -3 L 1 -3 L 1 -4 L 0 -4 M 2 8 L 1 9 L 0 9 L -1 8 L -1 7 L 0 6 L 1 6 L 2 7 L 2 10 L 1 12 L -1 13 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7 M 1 9 L 2 10 M 2 8 L 1 12","-12 12 M 8 -9 L -8 0 L 8 9","-12 13 M -8 -5 L 9 -5 L 9 -4 M -8 -5 L -8 -4 L 9 -4 M -8 3 L 9 3 L 9 4 M -8 3 L -8 4 L 9 4","-12 12 M -8 -9 L 8 0 L -8 9","-9 10 M -5 -7 L -5 -8 L -4 -8 L -4 -6 L -6 -6 L -6 -8 L -5 -10 L -4 -11 L -2 -12 L 2 -12 L 5 -11 L 6 -10 L 7 -8 L 7 -6 L 6 -4 L 5 -3 L 1 -1 M 5 -10 L 6 -9 L 6 -5 L 5 -4 M 2 -12 L 4 -11 L 5 -9 L 5 -5 L 4 -3 L 3 -2 M 0 -1 L 0 2 L 1 2 L 1 -1 L 0 -1 M 0 6 L -1 7 L -1 8 L 0 9 L 1 9 L 2 8 L 2 7 L 1 6 L 0 6 M 0 7 L 0 8 L 1 8 L 1 7 L 0 7","-13 14 M 5 -4 L 4 -6 L 2 -7 L -1 -7 L -3 -6 L -4 -5 L -5 -2 L -5 1 L -4 3 L -2 4 L 1 4 L 3 3 L 4 1 M -1 -7 L -3 -5 L -4 -2 L -4 1 L -3 3 L -2 4 M 5 -7 L 4 1 L 4 3 L 6 4 L 8 4 L 10 2 L 11 -1 L 11 -3 L 10 -6 L 9 -8 L 7 -10 L 5 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -10 L -8 -8 L -9 -6 L -10 -3 L -10 0 L -9 3 L -8 5 L -6 7 L -4 8 L -1 9 L 2 9 L 5 8 L 7 7 L 8 6 M 6 -7 L 5 1 L 5 3 L 6 4","-10 10 M 0 -12 L -7 8 M -1 -9 L 5 9 M 0 -9 L 6 9 M 0 -12 L 7 9 M -5 3 L 4 3 M -9 9 L -3 9 M 2 9 L 9 9 M -7 8 L -8 9 M -7 8 L -5 9 M 5 8 L 3 9 M 5 7 L 4 9 M 6 7 L 8 9","-11 11 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -6 L 7 -4 L 6 -3 L 3 -2 M 6 -10 L 7 -8 L 7 -6 L 6 -4 M 3 -12 L 5 -11 L 6 -9 L 6 -5 L 5 -3 L 3 -2 M -4 -2 L 3 -2 L 6 -1 L 7 0 L 8 2 L 8 5 L 7 7 L 6 8 L 3 9 L -9 9 M 6 0 L 7 2 L 7 5 L 6 7 M 3 -2 L 5 -1 L 6 1 L 6 6 L 5 8 L 3 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9","-11 10 M 6 -9 L 7 -12 L 7 -6 L 6 -9 L 4 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -1 9 L 2 9 L 4 8 L 6 6 L 7 4 M -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 M -1 -12 L -3 -11 L -5 -8 L -6 -4 L -6 1 L -5 5 L -3 8 L -1 9","-11 11 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 1 -12 L 4 -11 L 6 -9 L 7 -7 L 8 -4 L 8 1 L 7 4 L 6 6 L 4 8 L 1 9 L -9 9 M 5 -9 L 6 -7 L 7 -4 L 7 1 L 6 4 L 5 6 M 1 -12 L 3 -11 L 5 -8 L 6 -4 L 6 1 L 5 5 L 3 8 L 1 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9","-11 10 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 7 -12 L 7 -6 M -4 -2 L 2 -2 M 2 -6 L 2 2 M -9 9 L 7 9 L 7 3 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M 2 -12 L 7 -11 M 4 -12 L 7 -10 M 5 -12 L 7 -9 M 6 -12 L 7 -6 M 2 -6 L 1 -2 L 2 2 M 2 -4 L 0 -2 L 2 0 M 2 -3 L -2 -2 L 2 -1 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9 M 2 9 L 7 8 M 4 9 L 7 7 M 5 9 L 7 6 M 6 9 L 7 3","-11 9 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 7 -12 L 7 -6 M -4 -2 L 2 -2 M 2 -6 L 2 2 M -9 9 L -1 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M 2 -12 L 7 -11 M 4 -12 L 7 -10 M 5 -12 L 7 -9 M 6 -12 L 7 -6 M 2 -6 L 1 -2 L 2 2 M 2 -4 L 0 -2 L 2 0 M 2 -3 L -2 -2 L 2 -1 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9","-11 12 M 6 -9 L 7 -12 L 7 -6 L 6 -9 L 4 -11 L 2 -12 L -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -4 L -8 1 L -7 4 L -6 6 L -4 8 L -1 9 L 2 9 L 4 8 L 6 8 L 7 9 L 7 1 M -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 M -1 -12 L -3 -11 L -5 -8 L -6 -4 L -6 1 L -5 5 L -3 8 L -1 9 M 6 2 L 6 7 M 5 1 L 5 7 L 4 8 M 2 1 L 10 1 M 3 1 L 5 2 M 4 1 L 5 3 M 8 1 L 7 3 M 9 1 L 7 2","-12 12 M -7 -12 L -7 9 M -6 -11 L -6 8 M -5 -12 L -5 9 M 5 -12 L 5 9 M 6 -11 L 6 8 M 7 -12 L 7 9 M -10 -12 L -2 -12 M 2 -12 L 10 -12 M -5 -2 L 5 -2 M -10 9 L -2 9 M 2 9 L 10 9 M -9 -12 L -7 -11 M -8 -12 L -7 -10 M -4 -12 L -5 -10 M -3 -12 L -5 -11 M 3 -12 L 5 -11 M 4 -12 L 5 -10 M 8 -12 L 7 -10 M 9 -12 L 7 -11 M -7 8 L -9 9 M -7 7 L -8 9 M -5 7 L -4 9 M -5 8 L -3 9 M 5 8 L 3 9 M 5 7 L 4 9 M 7 7 L 8 9 M 7 8 L 9 9","-6 6 M -1 -12 L -1 9 M 0 -11 L 0 8 M 1 -12 L 1 9 M -4 -12 L 4 -12 M -4 9 L 4 9 M -3 -12 L -1 -11 M -2 -12 L -1 -10 M 2 -12 L 1 -10 M 3 -12 L 1 -11 M -1 8 L -3 9 M -1 7 L -2 9 M 1 7 L 2 9 M 1 8 L 3 9","-8 8 M 1 -12 L 1 5 L 0 8 L -1 9 M 2 -11 L 2 5 L 1 8 M 3 -12 L 3 5 L 2 8 L -1 9 L -3 9 L -5 8 L -6 6 L -6 4 L -5 3 L -4 3 L -3 4 L -3 5 L -4 6 L -5 6 M -5 4 L -5 5 L -4 5 L -4 4 L -5 4 M -2 -12 L 6 -12 M -1 -12 L 1 -11 M 0 -12 L 1 -10 M 4 -12 L 3 -10 M 5 -12 L 3 -11","-12 10 M -7 -12 L -7 9 M -6 -11 L -6 8 M -5 -12 L -5 9 M 6 -11 L -5 0 M -2 -2 L 5 9 M -1 -2 L 6 9 M -1 -4 L 7 9 M -10 -12 L -2 -12 M 3 -12 L 9 -12 M -10 9 L -2 9 M 2 9 L 9 9 M -9 -12 L -7 -11 M -8 -12 L -7 -10 M -4 -12 L -5 -10 M -3 -12 L -5 -11 M 5 -12 L 6 -11 M 8 -12 L 6 -11 M -7 8 L -9 9 M -7 7 L -8 9 M -5 7 L -4 9 M -5 8 L -3 9 M 5 7 L 3 9 M 5 7 L 8 9","-9 9 M -4 -12 L -4 9 M -3 -11 L -3 8 M -2 -12 L -2 9 M -7 -12 L 1 -12 M -7 9 L 8 9 L 8 3 M -6 -12 L -4 -11 M -5 -12 L -4 -10 M -1 -12 L -2 -10 M 0 -12 L -2 -11 M -4 8 L -6 9 M -4 7 L -5 9 M -2 7 L -1 9 M -2 8 L 0 9 M 3 9 L 8 8 M 5 9 L 8 7 M 6 9 L 8 6 M 7 9 L 8 3","-13 13 M -8 -12 L -8 8 M -8 -12 L -1 9 M -7 -12 L -1 6 M -6 -12 L 0 6 M 6 -12 L -1 9 M 6 -12 L 6 9 M 7 -11 L 7 8 M 8 -12 L 8 9 M -11 -12 L -6 -12 M 6 -12 L 11 -12 M -11 9 L -5 9 M 3 9 L 11 9 M -10 -12 L -8 -11 M 9 -12 L 8 -10 M 10 -12 L 8 -11 M -8 8 L -10 9 M -8 8 L -6 9 M 6 8 L 4 9 M 6 7 L 5 9 M 8 7 L 9 9 M 8 8 L 10 9","-12 12 M -7 -12 L -7 8 M -7 -12 L 7 9 M -6 -12 L 6 6 M -5 -12 L 7 6 M 7 -11 L 7 9 M -10 -12 L -5 -12 M 4 -12 L 10 -12 M -10 9 L -4 9 M -9 -12 L -7 -11 M 5 -12 L 7 -11 M 9 -12 L 7 -11 M -7 8 L -9 9 M -7 8 L -5 9","-11 11 M -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -3 L -8 0 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 4 L 8 0 L 8 -3 L 7 -7 L 6 -9 L 4 -11 L 1 -12 L -1 -12 M -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 M 5 6 L 6 4 L 7 1 L 7 -4 L 6 -7 L 5 -9 M -1 -12 L -3 -11 L -5 -8 L -6 -4 L -6 1 L -5 5 L -3 8 L -1 9 M 1 9 L 3 8 L 5 5 L 6 1 L 6 -4 L 5 -8 L 3 -11 L 1 -12","-11 11 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -5 L 7 -3 L 6 -2 L 3 -1 L -4 -1 M 6 -10 L 7 -8 L 7 -5 L 6 -3 M 3 -12 L 5 -11 L 6 -9 L 6 -4 L 5 -2 L 3 -1 M -9 9 L -1 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9","-11 11 M -1 -12 L -4 -11 L -6 -9 L -7 -7 L -8 -3 L -8 0 L -7 4 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 4 L 8 0 L 8 -3 L 7 -7 L 6 -9 L 4 -11 L 1 -12 L -1 -12 M -5 -9 L -6 -7 L -7 -4 L -7 1 L -6 4 L -5 6 M 5 6 L 6 4 L 7 1 L 7 -4 L 6 -7 L 5 -9 M -1 -12 L -3 -11 L -5 -8 L -6 -4 L -6 1 L -5 5 L -3 8 L -1 9 M 1 9 L 3 8 L 5 5 L 6 1 L 6 -4 L 5 -8 L 3 -11 L 1 -12 M -4 6 L -3 4 L -1 3 L 0 3 L 2 4 L 3 6 L 4 12 L 5 14 L 7 14 L 8 12 L 8 10 M 4 10 L 5 12 L 6 13 L 7 13 M 3 6 L 5 11 L 6 12 L 7 12 L 8 11","-11 11 M -6 -12 L -6 9 M -5 -11 L -5 8 M -4 -12 L -4 9 M -9 -12 L 3 -12 L 6 -11 L 7 -10 L 8 -8 L 8 -6 L 7 -4 L 6 -3 L 3 -2 L -4 -2 M 6 -10 L 7 -8 L 7 -6 L 6 -4 M 3 -12 L 5 -11 L 6 -9 L 6 -5 L 5 -3 L 3 -2 M 0 -2 L 2 -1 L 3 1 L 5 7 L 6 9 L 8 9 L 9 7 L 9 5 M 5 5 L 6 7 L 7 8 L 8 8 M 2 -1 L 3 0 L 6 6 L 7 7 L 8 7 L 9 6 M -9 9 L -1 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -3 -12 L -4 -10 M -2 -12 L -4 -11 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9","-10 10 M 6 -9 L 7 -12 L 7 -6 L 6 -9 L 4 -11 L 1 -12 L -2 -12 L -5 -11 L -7 -9 L -7 -6 L -6 -4 L -3 -2 L 3 0 L 5 1 L 6 3 L 6 6 L 5 8 M -6 -6 L -5 -4 L -3 -3 L 3 -1 L 5 0 L 6 2 M -5 -11 L -6 -9 L -6 -7 L -5 -5 L -3 -4 L 3 -2 L 6 0 L 7 2 L 7 5 L 6 7 L 5 8 L 2 9 L -1 9 L -4 8 L -6 6 L -7 3 L -7 9 L -6 6","-10 10 M -8 -12 L -8 -6 M -1 -12 L -1 9 M 0 -11 L 0 8 M 1 -12 L 1 9 M 8 -12 L 8 -6 M -8 -12 L 8 -12 M -4 9 L 4 9 M -7 -12 L -8 -6 M -6 -12 L -8 -9 M -5 -12 L -8 -10 M -3 -12 L -8 -11 M 3 -12 L 8 -11 M 5 -12 L 8 -10 M 6 -12 L 8 -9 M 7 -12 L 8 -6 M -1 8 L -3 9 M -1 7 L -2 9 M 1 7 L 2 9 M 1 8 L 3 9","-12 12 M -7 -12 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 -11 M -6 -11 L -6 4 L -5 6 M -5 -12 L -5 4 L -4 7 L -3 8 L -1 9 M -10 -12 L -2 -12 M 4 -12 L 10 -12 M -9 -12 L -7 -11 M -8 -12 L -7 -10 M -4 -12 L -5 -10 M -3 -12 L -5 -11 M 5 -12 L 7 -11 M 9 -12 L 7 -11","-10 10 M -7 -12 L 0 9 M -6 -12 L 0 6 L 0 9 M -5 -12 L 1 6 M 7 -11 L 0 9 M -9 -12 L -2 -12 M 3 -12 L 9 -12 M -8 -12 L -6 -10 M -4 -12 L -5 -10 M -3 -12 L -5 -11 M 5 -12 L 7 -11 M 8 -12 L 7 -11","-12 12 M -8 -12 L -4 9 M -7 -12 L -4 4 L -4 9 M -6 -12 L -3 4 M 0 -12 L -3 4 L -4 9 M 0 -12 L 4 9 M 1 -12 L 4 4 L 4 9 M 2 -12 L 5 4 M 8 -11 L 5 4 L 4 9 M -11 -12 L -3 -12 M 0 -12 L 2 -12 M 5 -12 L 11 -12 M -10 -12 L -7 -11 M -9 -12 L -7 -10 M -5 -12 L -6 -10 M -4 -12 L -6 -11 M 6 -12 L 8 -11 M 10 -12 L 8 -11","-10 10 M -7 -12 L 5 9 M -6 -12 L 6 9 M -5 -12 L 7 9 M 6 -11 L -6 8 M -9 -12 L -2 -12 M 3 -12 L 9 -12 M -9 9 L -3 9 M 2 9 L 9 9 M -8 -12 L -5 -10 M -4 -12 L -5 -10 M -3 -12 L -5 -11 M 4 -12 L 6 -11 M 8 -12 L 6 -11 M -6 8 L -8 9 M -6 8 L -4 9 M 5 8 L 3 9 M 5 7 L 4 9 M 5 7 L 8 9","-11 11 M -8 -12 L -1 -1 L -1 9 M -7 -12 L 0 -1 L 0 8 M -6 -12 L 1 -1 L 1 9 M 7 -11 L 1 -1 M -10 -12 L -3 -12 M 4 -12 L 10 -12 M -4 9 L 4 9 M -9 -12 L -7 -11 M -4 -12 L -6 -11 M 5 -12 L 7 -11 M 9 -12 L 7 -11 M -1 8 L -3 9 M -1 7 L -2 9 M 1 7 L 2 9 M 1 8 L 3 9","-10 10 M 7 -12 L -7 -12 L -7 -6 M 5 -12 L -7 9 M 6 -12 L -6 9 M 7 -12 L -5 9 M -7 9 L 7 9 L 7 3 M -6 -12 L -7 -6 M -5 -12 L -7 -9 M -4 -12 L -7 -10 M -2 -12 L -7 -11 M 2 9 L 7 8 M 4 9 L 7 7 M 5 9 L 7 6 M 6 9 L 7 3","-7 7 M -3 -16 L -3 16 M -2 -16 L -2 16 M -3 -16 L 4 -16 M -3 16 L 4 16","-7 7 M -7 -12 L 7 12","-7 7 M 2 -16 L 2 16 M 3 -16 L 3 16 M -4 -16 L 3 -16 M -4 16 L 3 16","-11 11 M -8 2 L 0 -3 L 8 2 M -8 2 L 0 -2 L 8 2","-10 10 M -10 16 L 10 16","-6 6 M -2 -12 L 3 -6 M -2 -12 L -3 -11 L 3 -6","-9 11 M -4 -2 L -4 -3 L -3 -3 L -3 -1 L -5 -1 L -5 -3 L -4 -4 L -2 -5 L 2 -5 L 4 -4 L 5 -3 L 6 -1 L 6 6 L 7 8 L 8 9 M 4 -3 L 5 -1 L 5 6 L 6 8 M 2 -5 L 3 -4 L 4 -2 L 4 6 L 5 8 L 8 9 L 9 9 M 4 0 L 3 1 L -2 2 L -5 3 L -6 5 L -6 6 L -5 8 L -2 9 L 1 9 L 3 8 L 4 6 M -4 3 L -5 5 L -5 6 L -4 8 M 3 1 L -1 2 L -3 3 L -4 5 L -4 6 L -3 8 L -2 9","-11 10 M -6 -12 L -6 9 L -5 8 L -3 8 M -5 -11 L -5 7 M -9 -12 L -4 -12 L -4 8 M -4 -2 L -3 -4 L -1 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -1 9 L -3 8 L -4 6 M 5 -2 L 6 0 L 6 4 L 5 6 M 1 -5 L 3 -4 L 4 -3 L 5 0 L 5 4 L 4 7 L 3 8 L 1 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10","-10 9 M 5 -1 L 5 -2 L 4 -2 L 4 0 L 6 0 L 6 -2 L 4 -4 L 2 -5 L -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 M -5 -2 L -6 0 L -6 4 L -5 6 M -1 -5 L -3 -4 L -4 -3 L -5 0 L -5 4 L -4 7 L -3 8 L -1 9","-10 11 M 4 -12 L 4 9 L 9 9 M 5 -11 L 5 8 M 1 -12 L 6 -12 L 6 9 M 4 -2 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 3 8 L 4 6 M -5 -2 L -6 0 L -6 4 L -5 6 M -1 -5 L -3 -4 L -4 -3 L -5 0 L -5 4 L -4 7 L -3 8 L -1 9 M 2 -12 L 4 -11 M 3 -12 L 4 -10 M 6 7 L 7 9 M 6 8 L 8 9","-10 9 M -5 1 L 6 1 L 6 -1 L 5 -3 L 4 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 M 5 0 L 5 -1 L 4 -3 M -5 -2 L -6 0 L -6 4 L -5 6 M 4 1 L 4 -2 L 3 -4 L 1 -5 M -1 -5 L -3 -4 L -4 -3 L -5 0 L -5 4 L -4 7 L -3 8 L -1 9","-7 7 M 5 -10 L 5 -11 L 4 -11 L 4 -9 L 6 -9 L 6 -11 L 5 -12 L 2 -12 L 0 -11 L -1 -10 L -2 -7 L -2 9 M 0 -10 L -1 -7 L -1 8 M 2 -12 L 1 -11 L 0 -9 L 0 9 M -5 -5 L 4 -5 M -5 9 L 3 9 M -2 8 L -4 9 M -2 7 L -3 9 M 0 7 L 1 9 M 0 8 L 2 9","-9 10 M 6 -4 L 7 -3 L 8 -4 L 7 -5 L 6 -5 L 4 -4 L 3 -3 M -1 -5 L -3 -4 L -4 -3 L -5 -1 L -5 1 L -4 3 L -3 4 L -1 5 L 1 5 L 3 4 L 4 3 L 5 1 L 5 -1 L 4 -3 L 3 -4 L 1 -5 L -1 -5 M -3 -3 L -4 -1 L -4 1 L -3 3 M 3 3 L 4 1 L 4 -1 L 3 -3 M -1 -5 L -2 -4 L -3 -2 L -3 2 L -2 4 L -1 5 M 1 5 L 2 4 L 3 2 L 3 -2 L 2 -4 L 1 -5 M -4 3 L -5 4 L -6 6 L -6 7 L -5 9 L -4 10 L -1 11 L 3 11 L 6 12 L 7 13 M -4 9 L -1 10 L 3 10 L 6 11 M -6 7 L -5 8 L -2 9 L 3 9 L 6 10 L 7 12 L 7 13 L 6 15 L 3 16 L -3 16 L -6 15 L -7 13 L -7 12 L -6 10 L -3 9 M -3 16 L -5 15 L -6 13 L -6 12 L -5 10 L -3 9","-11 12 M -6 -12 L -6 9 M -5 -11 L -5 8 M -9 -12 L -4 -12 L -4 9 M -4 -1 L -3 -3 L -2 -4 L 0 -5 L 3 -5 L 5 -4 L 6 -3 L 7 0 L 7 9 M 5 -3 L 6 0 L 6 8 M 3 -5 L 4 -4 L 5 -1 L 5 9 M -9 9 L -1 9 M 2 9 L 10 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9 M 5 8 L 3 9 M 5 7 L 4 9 M 7 7 L 8 9 M 7 8 L 9 9","-6 6 M -1 -12 L -1 -10 L 1 -10 L 1 -12 L -1 -12 M 0 -12 L 0 -10 M -1 -11 L 1 -11 M -1 -5 L -1 9 M 0 -4 L 0 8 M -4 -5 L 1 -5 L 1 9 M -4 9 L 4 9 M -3 -5 L -1 -4 M -2 -5 L -1 -3 M -1 8 L -3 9 M -1 7 L -2 9 M 1 7 L 2 9 M 1 8 L 3 9","-7 6 M 0 -12 L 0 -10 L 2 -10 L 2 -12 L 0 -12 M 1 -12 L 1 -10 M 0 -11 L 2 -11 M 0 -5 L 0 12 L -1 15 L -2 16 M 1 -4 L 1 11 L 0 14 M -3 -5 L 2 -5 L 2 11 L 1 14 L 0 15 L -2 16 L -5 16 L -6 15 L -6 13 L -4 13 L -4 15 L -5 15 L -5 14 M -2 -5 L 0 -4 M -1 -5 L 0 -3","-11 11 M -6 -12 L -6 9 M -5 -11 L -5 8 M -9 -12 L -4 -12 L -4 9 M 5 -4 L -4 5 M 0 1 L 7 9 M 0 2 L 6 9 M -1 2 L 5 9 M 2 -5 L 9 -5 M -9 9 L -1 9 M 2 9 L 9 9 M -8 -12 L -6 -11 M -7 -12 L -6 -10 M 3 -5 L 5 -4 M 8 -5 L 5 -4 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9 M 5 7 L 3 9 M 4 7 L 8 9","-6 6 M -1 -12 L -1 9 M 0 -11 L 0 8 M -4 -12 L 1 -12 L 1 9 M -4 9 L 4 9 M -3 -12 L -1 -11 M -2 -12 L -1 -10 M -1 8 L -3 9 M -1 7 L -2 9 M 1 7 L 2 9 M 1 8 L 3 9","-17 17 M -12 -5 L -12 9 M -11 -4 L -11 8 M -15 -5 L -10 -5 L -10 9 M -10 -1 L -9 -3 L -8 -4 L -6 -5 L -3 -5 L -1 -4 L 0 -3 L 1 0 L 1 9 M -1 -3 L 0 0 L 0 8 M -3 -5 L -2 -4 L -1 -1 L -1 9 M 1 -1 L 2 -3 L 3 -4 L 5 -5 L 8 -5 L 10 -4 L 11 -3 L 12 0 L 12 9 M 10 -3 L 11 0 L 11 8 M 8 -5 L 9 -4 L 10 -1 L 10 9 M -15 9 L -7 9 M -4 9 L 4 9 M 7 9 L 15 9 M -14 -5 L -12 -4 M -13 -5 L -12 -3 M -12 8 L -14 9 M -12 7 L -13 9 M -10 7 L -9 9 M -10 8 L -8 9 M -1 8 L -3 9 M -1 7 L -2 9 M 1 7 L 2 9 M 1 8 L 3 9 M 10 8 L 8 9 M 10 7 L 9 9 M 12 7 L 13 9 M 12 8 L 14 9","-11 12 M -6 -5 L -6 9 M -5 -4 L -5 8 M -9 -5 L -4 -5 L -4 9 M -4 -1 L -3 -3 L -2 -4 L 0 -5 L 3 -5 L 5 -4 L 6 -3 L 7 0 L 7 9 M 5 -3 L 6 0 L 6 8 M 3 -5 L 4 -4 L 5 -1 L 5 9 M -9 9 L -1 9 M 2 9 L 10 9 M -8 -5 L -6 -4 M -7 -5 L -6 -3 M -6 8 L -8 9 M -6 7 L -7 9 M -4 7 L -3 9 M -4 8 L -2 9 M 5 8 L 3 9 M 5 7 L 4 9 M 7 7 L 8 9 M 7 8 L 9 9","-10 10 M -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 4 8 L 6 6 L 7 3 L 7 1 L 6 -2 L 4 -4 L 1 -5 L -1 -5 M -5 -2 L -6 0 L -6 4 L -5 6 M 5 6 L 6 4 L 6 0 L 5 -2 M -1 -5 L -3 -4 L -4 -3 L -5 0 L -5 4 L -4 7 L -3 8 L -1 9 M 1 9 L 3 8 L 4 7 L 5 4 L 5 0 L 4 -3 L 3 -4 L 1 -5","-11 10 M -6 -5 L -6 16 M -5 -4 L -5 15 M -9 -5 L -4 -5 L -4 16 M -4 -2 L -3 -4 L -1 -5 L 1 -5 L 4 -4 L 6 -2 L 7 1 L 7 3 L 6 6 L 4 8 L 1 9 L -1 9 L -3 8 L -4 6 M 5 -2 L 6 0 L 6 4 L 5 6 M 1 -5 L 3 -4 L 4 -3 L 5 0 L 5 4 L 4 7 L 3 8 L 1 9 M -9 16 L -1 16 M -8 -5 L -6 -4 M -7 -5 L -6 -3 M -6 15 L -8 16 M -6 14 L -7 16 M -4 14 L -3 16 M -4 15 L -2 16","-10 10 M 4 -4 L 4 16 M 5 -3 L 5 15 M 3 -4 L 5 -4 L 6 -5 L 6 16 M 4 -2 L 3 -4 L 1 -5 L -1 -5 L -4 -4 L -6 -2 L -7 1 L -7 3 L -6 6 L -4 8 L -1 9 L 1 9 L 3 8 L 4 6 M -5 -2 L -6 0 L -6 4 L -5 6 M -1 -5 L -3 -4 L -4 -3 L -5 0 L -5 4 L -4 7 L -3 8 L -1 9 M 1 16 L 9 16 M 4 15 L 2 16 M 4 14 L 3 16 M 6 14 L 7 16 M 6 15 L 8 16","-9 8 M -4 -5 L -4 9 M -3 -4 L -3 8 M -7 -5 L -2 -5 L -2 9 M 5 -3 L 5 -4 L 4 -4 L 4 -2 L 6 -2 L 6 -4 L 5 -5 L 3 -5 L 1 -4 L -1 -2 L -2 1 M -7 9 L 1 9 M -6 -5 L -4 -4 M -5 -5 L -4 -3 M -4 8 L -6 9 M -4 7 L -5 9 M -2 7 L -1 9 M -2 8 L 0 9","-8 9 M 5 -3 L 6 -5 L 6 -1 L 5 -3 L 4 -4 L 2 -5 L -2 -5 L -4 -4 L -5 -3 L -5 -1 L -4 1 L -2 2 L 3 3 L 5 4 L 6 7 M -4 -4 L -5 -1 M -4 0 L -2 1 L 3 2 L 5 3 M 6 4 L 5 8 M -5 -3 L -4 -1 L -2 0 L 3 1 L 5 2 L 6 4 L 6 7 L 5 8 L 3 9 L -1 9 L -3 8 L -4 7 L -5 5 L -5 9 L -4 7","-7 8 M -2 -10 L -2 4 L -1 7 L 0 8 L 2 9 L 4 9 L 6 8 L 7 6 M -1 -10 L -1 5 L 0 7 M -2 -10 L 0 -12 L 0 5 L 1 8 L 2 9 M -5 -5 L 4 -5","-11 12 M -6 -5 L -6 4 L -5 7 L -4 8 L -2 9 L 1 9 L 3 8 L 4 7 L 5 5 M -5 -4 L -5 5 L -4 7 M -9 -5 L -4 -5 L -4 5 L -3 8 L -2 9 M 5 -5 L 5 9 L 10 9 M 6 -4 L 6 8 M 2 -5 L 7 -5 L 7 9 M -8 -5 L -6 -4 M -7 -5 L -6 -3 M 7 7 L 8 9 M 7 8 L 9 9","-9 9 M -6 -5 L 0 9 M -5 -5 L 0 7 M -4 -5 L 1 7 M 6 -4 L 1 7 L 0 9 M -8 -5 L -1 -5 M 2 -5 L 8 -5 M -7 -5 L -4 -3 M -2 -5 L -4 -4 M 4 -5 L 6 -4 M 7 -5 L 6 -4","-12 12 M -8 -5 L -4 9 M -7 -5 L -4 6 M -6 -5 L -3 6 M 0 -5 L -3 6 L -4 9 M 0 -5 L 4 9 M 1 -5 L 4 6 M 0 -5 L 2 -5 L 5 6 M 8 -4 L 5 6 L 4 9 M -11 -5 L -3 -5 M 5 -5 L 11 -5 M -10 -5 L -7 -4 M -4 -5 L -6 -4 M 6 -5 L 8 -4 M 10 -5 L 8 -4","-10 10 M -6 -5 L 4 9 M -5 -5 L 5 9 M -4 -5 L 6 9 M 5 -4 L -5 8 M -8 -5 L -1 -5 M 2 -5 L 8 -5 M -8 9 L -2 9 M 1 9 L 8 9 M -7 -5 L -5 -4 M -2 -5 L -4 -4 M 3 -5 L 5 -4 M 7 -5 L 5 -4 M -5 8 L -7 9 M -5 8 L -3 9 M 4 8 L 2 9 M 5 8 L 7 9","-10 9 M -6 -5 L 0 9 M -5 -5 L 0 7 M -4 -5 L 1 7 M 6 -4 L 1 7 L -2 13 L -4 15 L -6 16 L -8 16 L -9 15 L -9 13 L -7 13 L -7 15 L -8 15 L -8 14 M -8 -5 L -1 -5 M 2 -5 L 8 -5 M -7 -5 L -4 -3 M -2 -5 L -4 -4 M 4 -5 L 6 -4 M 7 -5 L 6 -4","-9 9 M 4 -5 L -6 9 M 5 -5 L -5 9 M 6 -5 L -4 9 M 6 -5 L -6 -5 L -6 -1 M -6 9 L 6 9 L 6 5 M -5 -5 L -6 -1 M -4 -5 L -6 -2 M -3 -5 L -6 -3 M -1 -5 L -6 -4 M 1 9 L 6 8 M 3 9 L 6 7 M 4 9 L 6 6 M 5 9 L 6 5","-7 7 M 2 -16 L 0 -15 L -1 -14 L -2 -12 L -2 -10 L -1 -8 L 0 -7 L 1 -5 L 1 -3 L -1 -1 M 0 -15 L -1 -13 L -1 -11 L 0 -9 L 1 -8 L 2 -6 L 2 -4 L 1 -2 L -3 0 L 1 2 L 2 4 L 2 6 L 1 8 L 0 9 L -1 11 L -1 13 L 0 15 M -1 1 L 1 3 L 1 5 L 0 7 L -1 8 L -2 10 L -2 12 L -1 14 L 0 15 L 2 16","-4 4 M 0 -16 L 0 16","-7 7 M -2 -16 L 0 -15 L 1 -14 L 2 -12 L 2 -10 L 1 -8 L 0 -7 L -1 -5 L -1 -3 L 1 -1 M 0 -15 L 1 -13 L 1 -11 L 0 -9 L -1 -8 L -2 -6 L -2 -4 L -1 -2 L 3 0 L -1 2 L -2 4 L -2 6 L -1 8 L 0 9 L 1 11 L 1 13 L 0 15 M 1 1 L -1 3 L -1 5 L 0 7 L 1 8 L 2 10 L 2 12 L 1 14 L 0 15 L -2 16","-12 12 M -9 3 L -9 1 L -8 -2 L -6 -3 L -4 -3 L -2 -2 L 2 1 L 4 2 L 6 2 L 8 1 L 9 -1 M -9 1 L -8 -1 L -6 -2 L -4 -2 L -2 -1 L 2 2 L 4 3 L 6 3 L 8 2 L 9 -1 L 9 -3","-8 8 M -8 -12 L -8 9 L -7 9 L -7 -12 L -6 -12 L -6 9 L -5 9 L -5 -12 L -4 -12 L -4 9 L -3 9 L -3 -12 L -2 -12 L -2 9 L -1 9 L -1 -12 L 0 -12 L 0 9 L 1 9 L 1 -12 L 2 -12 L 2 9 L 3 9 L 3 -12 L 4 -12 L 4 9 L 5 9 L 5 -12 L 6 -12 L 6 9 L 7 9 L 7 -12 L 8 -12 L 8 9"]

group_allfonts = (
                    [
						['futural','Sans 1-stroke'],
						['futuram','Sans bold'],
						['timesr','Serif medium'],
						['timesi','Serif medium italic'],
						['timesib','Serif bold italic'],
						['timesrb','Serif bold'],
						['scripts','Script 1-stroke'],
						['cursive','Script 1-stroke (alt)'],
						['scriptc','Script medium'],
						['gothiceng','Gothic English'],
						['gothicger','Gothic German'],
						['gothicita','Gothic Italian'],
						['EMSAllure','EMS Allure'],
						['EMSBird','EMS Bird'],
						['EMSBirdSwashCaps','EMS Bird Swash Caps'],
						['EMSBrush','EMS Brush'],
						['EMSCapitol','EMS Capitol'],
						['EMSCasualHand','EMS Casual Hand'],
						['EMSDecorousScript','EMS Decorous Script'],
						['EMSDelight','EMS Delight'],
						['EMSDelightSwashCaps','EMS Delight Swash Caps'],
						['EMSElfin','EMS Elfin'],
						['EMSFelix','EMS Felix'],
						['EMSHerculean','EMS Herculean'],
						['EMSInvite','EMS Invite'],
						['EMSLeague','EMS League'],
						['EMSLittlePrincess','EMS Little Princess'],
						['EMSMistyNight','EMS Misty Night'],
						['EMSNeato','EMS Neato'],
						['EMSNixish','EMS Nixish'],
						['EMSNixishItalic','EMS Nixish Italic'],
						['EMSOsmotron','EMS Osmotron'],
						['EMSPancakes','EMS Pancakes'],
						['EMSPepita','EMS Pepita'],
						['EMSQwandry','EMS Qwandry'],
						['EMSReadability','EMS Readability'],
						['EMSReadabilityItalic','EMS Readability Italic'],
						['EMSSociety','EMS Society'],
						['EMSSwiss','EMS Swiss'],
						['EMSTech','EMS Tech'],
						['greek','Greek 1-stroke'],
						['timesg','Greek medium'],
						['cyrillic','Cyrillic'],
						['japanese','Japanese'],
						['astrology','Astrology'],
						['mathlow','Math (lower)'],
						['mathupp','Math (upper)'],
						['markers','Markers'],
						['meteorology','Meteorology'],
						['music','Music'],
						['symbolic','Symbolic']
					]
                )
