"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBSeeder = void 0;
const core_1 = require("@aws-cdk/core");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const directories_1 = require("./directories");
class DynamoDBSeeder extends core_1.Construct {
    constructor(scope, id, props) {
        var _a, _b, _c, _d;
        super(scope, id);
        const seeds = props.seeds.bind(this);
        const seedsBucket = ((_a = seeds.s3Location) === null || _a === void 0 ? void 0 : _a.bucketName) ? aws_s3_1.Bucket.fromBucketName(this, 'SeedsBucket', seeds.s3Location.bucketName)
            : undefined;
        const serviceToken = core_1.CustomResourceProvider.getOrCreate(this, 'Custom::DynamodbSeeder', {
            codeDirectory: directories_1.dynamodbSeederDir,
            runtime: core_1.CustomResourceProviderRuntime.NODEJS_12,
            timeout: (_b = props.timeout) !== null && _b !== void 0 ? _b : core_1.Duration.minutes(15),
            policyStatements: [
                {
                    Effect: aws_iam_1.Effect.ALLOW,
                    Action: ['dynamodb:BatchWriteItem'],
                    Resource: props.table.tableArn,
                },
                seedsBucket
                    ? {
                        Effect: aws_iam_1.Effect.ALLOW,
                        Action: ['s3:GetObject'],
                        Resource: `${seedsBucket.bucketArn}/${(_d = (_c = seeds.s3Location) === null || _c === void 0 ? void 0 : _c.objectKey) !== null && _d !== void 0 ? _d : '*'}`,
                    }
                    : undefined,
            ],
        });
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken,
            resourceType: 'Custom::DynamodbSeeder',
            properties: {
                TableName: props.table.tableName,
                Seeds: {
                    InlineSeeds: seeds.inlineSeeds,
                    S3Bucket: seeds.s3Location && seeds.s3Location.bucketName,
                    S3Key: seeds.s3Location && seeds.s3Location.objectKey,
                    S3ObjectVersion: seeds.s3Location && seeds.s3Location.objectVersion,
                },
            },
        });
    }
}
exports.DynamoDBSeeder = DynamoDBSeeder;
//# sourceMappingURL=data:application/json;base64,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