
from setuptools import setup, find_packages
import pathlib

here = pathlib.Path(__file__).parent.resolve()

# Get the long description from the README file
long_description = (here / "README.md").read_text(encoding="utf-8")

setup(
   
    name="pyowletapi",
    version="2022.11.3",
    description="Owlet baby montior API wrapper",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/RyanClark123/pyowletapi",
    author="Ryan Clark",
    classifiers=[ 
        "License :: OSI Approved :: MIT License",        
        "Programming Language :: Python :: 3.9",
    ],
    
    keywords="owlet, api, baby",
    package_dir={"": "src"}, 
    packages=find_packages(where="src"), 
    python_requires=">=3.9",
    
    install_requires=["aiohttp"], 
)