# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Mar 30 15:41:12 2021
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .no_type_key import tNoTypeKey

class tNoType(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 id: str = '',
                 status: str = '',
                 descr: str = '',
                 grp: str = '',
                 priority: int = 0,
                 pref_corr: dict = None,
                 corr_cnt: int = 0,
                 max_life: int = 0,
                 modified_by: str = ''):
        """
        Constructor.

        :param id: str
        :param status: str
        :param descr: str
        :param grp: str
        :param priority: int
        :param pref_corr: dict
        :param corr_cnt: int
        :param max_life: int
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.id = id
        self.status = status
        self.descr = descr
        self.grp = grp
        self.priority = priority
        self.pref_corr = pref_corr
        self.corr_cnt = corr_cnt
        self.max_life = max_life
        self.modified_by = modified_by
        self.tm_stamp = None

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = ''
        self.status = ''
        self.descr = ''
        self.grp = ''
        self.priority = 0
        self.pref_corr = None
        self.corr_cnt = 0
        self.max_life = 0
        self.modified_by = ''
        self.tm_stamp = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tNoType'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_string("id", self.id)
        _w.write_char("status", self.status)
        _w.write_string("descr", self.descr)
        _w.write_string("grp", self.grp)
        _w.write_int32("priority", self.priority)
        _w.write_json("pref_corr", self.pref_corr)
        _w.write_int32("corr_cnt", self.corr_cnt)
        _w.write_int32("max_life", self.max_life)
        _w.write_string("modified_by", self.modified_by)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_string("id")
        self.status = _r.read_char("status")
        self.descr = _r.read_string("descr")
        self.grp = _r.read_string("grp")
        self.priority = _r.read_int32("priority")
        self.pref_corr = _r.read_json("pref_corr")
        self.corr_cnt = _r.read_int32("corr_cnt")
        self.max_life = _r.read_int32("max_life")
        self.modified_by = _r.read_string("modified_by")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tNoType"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.status = rec.status
        self.descr = rec.descr
        self.grp = rec.grp
        self.priority = rec.priority
        self.pref_corr = rec.pref_corr
        self.corr_cnt = rec.corr_cnt
        self.max_life = rec.max_life
        self.modified_by = rec.modified_by
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tNoType"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tNoType"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tNoTypeKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tNoTypeKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))
        if key_only:
            return dvc

        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['A','D']))
        dvc.add_targ("descr", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("descr", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 256))
        dvc.add_targ("grp", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("grp", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 64))
        dvc.add_targ("priority", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("corr_cnt", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("max_life", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tNoType._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tNoTypeKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id

    def _read_key(self, _key: tNoTypeKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id

    class Status_Couplet(dict):
        key_active = "A"
        key_disabled = "D"

        value_active = "Active"
        value_disabled = "Disabled"

        def __init__(self):
            self[self.key_active] = self.value_active
            self[self.key_disabled] = self.value_disabled

        @staticmethod
        def get_value(key):
            if key == tNoType.Status_Couplet.key_active:
                return tNoType.Status_Couplet.value_active

            if key == tNoType.Status_Couplet.key_disabled:
                return tNoType.Status_Couplet.value_disabled

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return (x.id > y.id) - (x.id < y.id)

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<NoType [id:%.32s, status:%.32s, descr:%.32s, grp:%.32s, priority:%r, pref_corr:%.32s, corr_cnt:%r, max_life:%r, modified_by:%.32s, tm_stamp:%s]>' % (
            self.id, self.status, self.descr, self.grp, self.priority, self.pref_corr, self.corr_cnt, self.max_life, self.modified_by, self.tm_stamp)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tNoType.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tNoType()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tNoType.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tNoType._cache_davs(dvc, for_ins, key_only)

