# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Mar 30 15:41:12 2021
#

import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from .corr_prov_cfg_key import tCorrProvCfgKey

class tCorrProvCfg(mettle.io.ISerializable, mettle.db.IPrimaryKey):

    def __init__(self,
                 id: int = 0,
                 corrtype_id: str = '',
                 corrprov_id: str = '',
                 status: str = '',
                 notes: str = '',
                 activate: datetime.datetime = None,
                 deactivate: datetime.datetime = None,
                 cfg: dict = None,
                 modified_by: str = ''):
        """
        Constructor.

        :param id: int
        :param corrtype_id: str
        :param corrprov_id: str
        :param status: str
        :param notes: str
        :param activate: datetime.datetime
        :param deactivate: datetime.datetime
        :param cfg: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.id = id
        self.corrtype_id = corrtype_id
        self.corrprov_id = corrprov_id
        self.status = status
        self.notes = notes
        self.activate = activate
        self.deactivate = deactivate
        self.cfg = cfg
        self.modified_by = modified_by
        self.tm_stamp = None

    def clear(self):
        """
        Clears all member variables for this database record.
        """
        self.id = 0
        self.corrtype_id = ''
        self.corrprov_id = ''
        self.status = ''
        self.notes = ''
        self.activate = None
        self.deactivate = None
        self.cfg = None
        self.modified_by = ''
        self.tm_stamp = None

    def _name(self) -> str:
        """
        Name of the record.

        :return: The name.
        """
        return 'tCorrProvCfg'

    def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
        """
        Serialize record to a stream.

        :param _w:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _w.write_start(_oname)
        _w.write_int64("id", self.id)
        _w.write_string("corrtype_id", self.corrtype_id)
        _w.write_string("corrprov_id", self.corrprov_id)
        _w.write_char("status", self.status)
        _w.write_string("notes", self.notes)
        _w.write_datetime("activate", self.activate)
        _w.write_datetime("deactivate", self.deactivate)
        _w.write_json("cfg", self.cfg)
        _w.write_string("modified_by", self.modified_by)
        _w.write_datetime("tm_stamp", self.tm_stamp)
        _w.write_end(_oname)

    def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
        """
        Deserialize record from a stream.

        :param _r:
        :param _oname:
        """
        if _oname == None:
            _oname = self._name()

        _r.read_start(_oname)
        self.id = _r.read_int64("id")
        self.corrtype_id = _r.read_string("corrtype_id")
        self.corrprov_id = _r.read_string("corrprov_id")
        self.status = _r.read_char("status")
        self.notes = _r.read_string("notes")
        self.activate = _r.read_datetime("activate")
        self.deactivate = _r.read_datetime("deactivate")
        self.cfg = _r.read_json("cfg")
        self.modified_by = _r.read_string("modified_by")
        self.tm_stamp = _r.read_datetime("tm_stamp")
        _r.read_end(_oname)

    def _copy_from(self, rec: "tCorrProvCfg"):
        """
        Copies the column from the rec into this record.

        :param rec: The source record.
        """
        self.id = rec.id
        self.corrtype_id = rec.corrtype_id
        self.corrprov_id = rec.corrprov_id
        self.status = rec.status
        self.notes = rec.notes
        self.activate = rec.activate
        self.deactivate = rec.deactivate
        self.cfg = rec.cfg
        self.modified_by = rec.modified_by
        self.tm_stamp = rec.tm_stamp

    def _write_pk(self, _key: "tCorrProvCfg"):
        """
        Write the primary key columns to the key object.

        :param _key:
        """
        self._write_key(_key)

    def _read_pk(self, _key: "tCorrProvCfg"):
        """
        Read the primary key columns from the key object.

        :param _key:
        """
        self._read_key(_key)

    def _serialize_key(self, _w: mettle.io.IWriter):
        """
        Serialize the primary key to a stream.

        :param _w:
        """
        _key = tCorrProvCfgKey()

        self._write_key(_key)
        _key._serialize(_w)

    def _deserialize_key(self, _r: mettle.io.IReader):
        """
        Deserialize the primary key from a stream.

        :param _r:
        """
        _key = tCorrProvCfgKey()

        _key._deserialize(_r)
        self._read_key(_key)

    @staticmethod
    def _cache_davs(dvc=None, for_ins: bool = False, key_only: bool = False):
        """
        Cache the DAV into the dav cache (or create one) and return it.

        :param dvc: (mettle.lib.DavCache), target cache, if None a new one is created and returned.
        :param for_ins: Davs for insert.
        :param key_only: Davs by key only, ie for delete/selectone.
        """
        if dvc is None:
            dvc = mettle.lib.DavCache()

        if not for_ins:
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
            dvc.add_targ("id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))

        if key_only:
            return dvc

        dvc.add_targ("corrtype_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("corrtype_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 16))
        dvc.add_targ("corrprov_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("corrprov_id", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 16))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Min, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 1))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("status", mettle.lib.Dav(mettle.lib.Dav.eDavType.In, ['F','A','D','E']))
        dvc.add_targ("notes", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 4096))
        dvc.add_targ("activate", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.NotNull))
        dvc.add_targ("modified_by", mettle.lib.Dav(mettle.lib.Dav.eDavType.Max, 128))

        return dvc

    def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
        tCorrProvCfg._cache_davs(dvc, for_ins, key_only)

    def _write_key(self, _key: tCorrProvCfgKey):
        """
        Write primary key columns to _key.

        :param _key:
        """
        _key.id = self.id

    def _read_key(self, _key: tCorrProvCfgKey):
        """
        Read the primary key columns from _key.

        :param _key:
        """
        self.id = _key.id

    class Status_Couplet(dict):
        key_future = "F"
        key_active = "A"
        key_disabled = "D"
        key_expired = "E"

        value_future = "Future"
        value_active = "Active"
        value_disabled = "Disabled"
        value_expired = "Expired"

        def __init__(self):
            self[self.key_future] = self.value_future
            self[self.key_active] = self.value_active
            self[self.key_disabled] = self.value_disabled
            self[self.key_expired] = self.value_expired

        @staticmethod
        def get_value(key):
            if key == tCorrProvCfg.Status_Couplet.key_future:
                return tCorrProvCfg.Status_Couplet.value_future

            if key == tCorrProvCfg.Status_Couplet.key_active:
                return tCorrProvCfg.Status_Couplet.value_active

            if key == tCorrProvCfg.Status_Couplet.key_disabled:
                return tCorrProvCfg.Status_Couplet.value_disabled

            if key == tCorrProvCfg.Status_Couplet.key_expired:
                return tCorrProvCfg.Status_Couplet.value_expired

            return ""

    @staticmethod
    def _pk_compare(x, y) -> int:
        """
        Compare function do primary key comparisons for list sorts and searches.

        :return: zero for x == y, negative for x < y, positive for x > y
        """
        return x.id - y.id

    def __lt__(self, other):
        return other and self._pk_compare(self, other) < 0

    def __gt__(self, other):
        return other and self._pk_compare(self, other) > 0

    def __eq__(self, other):
        return other and self._pk_compare(self, other) == 0

    def __le__(self, other):
        return other and self._pk_compare(self, other) <= 0

    def __ge__(self, other):
        return other and self._pk_compare(self, other) >= 0

    def __ne__(self, other):
        return other == None or self._pk_compare(self, other)

    def __repr__(self) -> str:
        return '<CorrProvCfg [id:%r, corrtype_id:%.32s, corrprov_id:%.32s, status:%.32s, notes:%.32s, activate:%s, deactivate:%s, cfg:%.32s, modified_by:%.32s, tm_stamp:%s]>' % (
            self.id, self.corrtype_id, self.corrprov_id, self.status, self.notes, self.activate, self.deactivate, self.cfg, self.modified_by, self.tm_stamp)


    class List(list, mettle.io.ISerializable):
        """
        List Class
        """

        def _name(self) -> str:
            """
            Name of the list.

            :return: The name
            """
            return 'tCorrProvCfg.List'

        def _serialize(self, _w: mettle.io.IWriter, _oname: str = None):
            """
            Serialize the list to a stream.

            :param _w:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _w.write_start_list(_oname, len(self))

            for _rec in self:
                _rec._serialize(_w)

            _w.write_end(_oname)

        def _deserialize(self, _r: mettle.io.IReader, _oname: str = None):
            """
            Deserialize the list from a stream.

            :param _r:
            :param _oname:
            """
            if _oname == None:
                _oname = self._name()

            _cnt = _r.read_start_list(_oname)

            while _cnt >= 1:
                _rec  = tCorrProvCfg()
                _cnt -= 1
                _rec._deserialize(_r)
                self.append(_rec)

            _r.read_end(_oname)

        def __repr__(self) -> str:
            return '<tCorrProvCfg.List[%d]>' % (len(self))

        def _get_davs(self, dvc=None, for_ins: bool = False, key_only: bool = False):
            return tCorrProvCfg._cache_davs(dvc, for_ins, key_only)

