# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Mar 30 15:41:12 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.msg_req import tMsgReq

class dMsgReqInsert:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tMsgReq()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        id: int,
                        notype_id: str,
                        priority: int,
                        status: str,
                        time_req: datetime.datetime,
                        time_to_send: datetime.datetime,
                        time_proc: datetime.datetime,
                        msg_addr: dict,
                        msg_dict: dict,
                        cust_res: bool,
                        meta_data: dict,
                        modified_by: str,
                        tm_stamp: datetime.datetime) -> "dMsgReqInsert":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :param notype_id: str
        :param priority: int
        :param status: str
        :param time_req: datetime.datetime
        :param time_to_send: datetime.datetime
        :param time_proc: datetime.datetime
        :param msg_addr: dict
        :param msg_dict: dict
        :param cust_res: bool
        :param meta_data: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        :return: Self for convenience.
        """
        self.irec.id = id
        self.irec.notype_id = notype_id
        self.irec.priority = priority
        self.irec.status = status
        self.irec.time_req = time_req
        self.irec.time_to_send = time_to_send
        self.irec.time_proc = time_proc
        self.irec.msg_addr = msg_addr
        self.irec.msg_dict = msg_dict
        self.irec.cust_res = cust_res
        self.irec.meta_data = meta_data
        self.irec.modified_by = modified_by
        self.irec.tm_stamp = tm_stamp

        return await self.exec()

    async def exec(self, irec: tMsgReq = None) -> "dMsgReqInsert":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("MsgReqInsert", self._dbcon.STMNT_TYPE_CUD)

        self._dbstmnt.sql("""insert into loco.MsgReq (
  notype_id,
  priority,
  status,
  time_req,
  time_to_send,
  time_proc,
  msg_addr,
  msg_dict,
  cust_res,
  meta_data,
  modified_by,
  tm_stamp
) values (
  :notype_id,
  :priority,
  :status,
  :time_req,
  :time_to_send,
  :time_proc,
  :msg_addr,
  :msg_dict,
  :cust_res,
  :meta_data,
  :modified_by,
  :tm_stamp
)""")

        self.irec.tm_stamp = await self._dbcon.get_timestamp()

        self._dbstmnt.bind_in("notype_id", self.irec.notype_id, str, 128)
        self._dbstmnt.bind_in("priority", self.irec.priority, int, 4)
        self._dbstmnt.bind_in("status", self.irec.status, str, 1)
        self._dbstmnt.bind_in("time_req", self.irec.time_req, datetime.datetime)
        self._dbstmnt.bind_in("time_to_send", self.irec.time_to_send, datetime.datetime)
        self._dbstmnt.bind_in("time_proc", self.irec.time_proc, datetime.datetime)
        self._dbstmnt.bind_in("msg_addr", self.irec.msg_addr, dict)
        self._dbstmnt.bind_in("msg_dict", self.irec.msg_dict, dict)
        self._dbstmnt.bind_in("cust_res", self.irec.cust_res, bool)
        self._dbstmnt.bind_in("meta_data", self.irec.meta_data, dict)
        self._dbstmnt.bind_in("modified_by", self.irec.modified_by, str, 128)
        self._dbstmnt.bind_in("tm_stamp", self.irec.tm_stamp, datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        self.irec.id = await self._dbcon.post_get_sequence(self._dbstmnt, "loco.MsgReq", "id", 8)

        if irec:
            irec._copy_from(self.irec)

        return self

