# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Mar 30 15:41:12 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.corr_type_allow_key import tCorrTypeAllowKey
from bs_loco.db.tables.corr_type_allow import tCorrTypeAllow

class dCorrTypeAllowSelectOne:

    def __init__(self, dbcon: mettle.db.IAConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tCorrTypeAllowKey()
        self.orec     = tCorrTypeAllow()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    async def exec_deft(self,
                        corrtype_id: str,
                        allow_id: str) -> "dCorrTypeAllowSelectOne":
        """
        Execute the query by setting all the inputs.

        :param corrtype_id: str
        :param allow_id: str
        :return: Self for convenience.
        """
        self.irec.corrtype_id = corrtype_id
        self.irec.allow_id = allow_id

        return await self.exec()

    async def exec(self, irec: tCorrTypeAllowKey = None) -> "dCorrTypeAllowSelectOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = await self._dbcon.statement("CorrTypeAllowSelectOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  corrtype_id,
  allow_id,
  status,
  regex,
  modified_by,
  tm_stamp
from
  loco.CorrTypeAllow
where
  corrtype_id = :corrtype_id and
  allow_id = :allow_id""")

        self._dbstmnt.bind_in("corrtype_id", self.irec.corrtype_id, str, 16)
        self._dbstmnt.bind_in("allow_id", self.irec.allow_id, str, 32)

        self._dbstmnt.bind_out("corrtype_id", str, 16)
        self._dbstmnt.bind_out("allow_id", str, 32)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("regex", str, 256)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        await self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    async def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not await self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.corrtype_id = self._dbstmnt.result[0]
        self.orec.allow_id = self._dbstmnt.result[1]
        self.orec.status = self._dbstmnt.result[2]
        self.orec.regex = self._dbstmnt.result[3]
        self.orec.modified_by = self._dbstmnt.result[4]
        self.orec.tm_stamp = self._dbstmnt.result[5]

        return True

    async def fetch_all(self, outList: tCorrTypeAllow.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while await self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

