# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Mar 30 15:41:12 2021
#  Target Database = postgresql
#
import asyncio
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.no_type import tNoType
from bs_loco.db.tables.no_type_key import tNoTypeKey

from .no_type_lock_one import dNoTypeLockOne
from .no_type_select_one import dNoTypeSelectOne
from .no_type_update import dNoTypeUpdate
from .no_type_insert import dNoTypeInsert
from .no_type_delete_one import dNoTypeDeleteOne

class dNoType:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tNoType()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    def lock_one(self, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record.

        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tNoTypeKey()

        self.rec._write_key(_key)

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_with(self, _rec: tNoType, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record using a record.

        :param _rec: The table rec to select with and into.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tNoTypeKey()
        _rec._write_key(_key)

        self.lock_one_by_key(_key, _lock4update, _expected)
        _rec._copy_from(self.rec)
        return True

    def lock_one_deft(self,
                      id: str,
                      _lock4update: mettle.db.DBLock,
                      _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record by it's primary key columns.

        :param id: str
        :param _lock4update:  The db lock object to use. 
        :param _expected: bool
        """
        _key = tNoTypeKey()

        _key.id = id

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_by_key(self, _key: tNoTypeKey, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record with it's primary key.

        :param _key: Primary key of the table record.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        with dNoTypeLockOne(self._dbcon) as _qry:
            _dex = _lock4update.retrys - 1 if _lock4update.retrys > 0 else 0

            while _dex >= 0:
                try:
                    _qry.exec(_key)
                    if not _qry.fetch():
                        if not _expected:
                            return False

                        raise mettle.lib.xMettle("LockOne failed to return a record (dNoType)")

                    break
                except mettle.lib.xMettle as _x:
                    if _x.get_error_code() != mettle.lib.xMettle.eCode.DBLockNoWaitFailed:
                        raise _x

                    if _dex == 0:
                        raise mettle.lib.xMettle("Could not lock NoType record after %d attempt(s) at %d mili second intervals!" % (
_lock4update.retrys, _lock4update.mili_seconds), errCode = mettle.lib.xMettle.eCode.DBLockNoWaitFailed)

                    if _lock4update.mili_seconds > 0:
                        time.sleep(_lock4update.mili_seconds * 0.001)
                _dex -= 1

            self.rec = _qry.orec

            return True

    def try_select_one(self) -> bool:
        """
        Attempt to select the record.

        :return: True if the record was found.
        """
        _key = tNoTypeKey()

        self.rec._write_key(_key)

        return self.try_select_one_by_key(_key)

    def try_select_one_with(self, _rec: tNoType) -> bool:
        """
        Attempt to select the record using a table rec.

        :param _rec: The table rec to select with and into.
        :return: True if the row as selectd.
        """
        _key = tNoTypeKey()
        _rec._write_key(_key)

        if not self.try_select_one_by_key(_key):
            return False

        _rec._copy_from(self.rec)

        return True

    def try_select_one_deft(self,
                            id: str) -> bool:
        """
        Attempt to select the record by it's primary key columns.

        :param id: str
        :return: True if the row as selectd.
        """
        _key = tNoTypeKey()

        _key.id = id

        return self.try_select_one_by_key(_key)

    def try_select_one_by_key(self, _key: tNoTypeKey) -> bool:
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :returns: True if row was selected.
        """
        with dNoTypeSelectOne(self._dbcon) as _qry:
            _qry.exec(_key)
            if not _qry.fetch():
                return False

            self.rec = _qry.orec

        return True

    def select_one(self) -> "dNoType":
        """
        Selects the record, raises and error if it does not exist.

        :return: Self for convenience.
        """
        if not self.try_select_one():
            raise mettle.lib.xMettle("SelectOne failed to return a record (dNoType)")

        return self

    def select_one_with(self, _rec: tNoType) -> "dNoType":
        """
        Attempt to select the record with the table record.

        :param _rec: Table record.
        :returns: Self for convenience.
        """
        if not self.try_select_one_with(_rec):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dNoType)")

        return self

    def select_one_deft(self,
                        id: str) -> "dNoType":
        """
        Selects the record by its primary key columns, raises and error if it does not exist.

        :param id: str
        """
        _key = tNoTypeKey()

        _key.id = id

        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dNoType)")

        return self

    def select_one_by_key(self, _key: tNoTypeKey) -> "dNoType":
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :return: Self for convenience.
        """
        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dNoType)")

        return self

    def update_deft(self,
                    id: str,
                    status: str,
                    descr: str,
                    grp: str,
                    priority: int,
                    pref_corr: dict,
                    corr_cnt: int,
                    max_life: int,
                    modified_by: str):
        """
        Update the record by setting all column values.

        :param id: str
        :param status: str
        :param descr: str
        :param grp: str
        :param priority: int
        :param pref_corr: dict
        :param corr_cnt: int
        :param max_life: int
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.id = id
        self.rec.status = status
        self.rec.descr = descr
        self.rec.grp = grp
        self.rec.priority = priority
        self.rec.pref_corr = pref_corr
        self.rec.corr_cnt = corr_cnt
        self.rec.max_life = max_life
        self.rec.modified_by = modified_by

        self.update()

    def update(self, irec: tNoType = None):
        """
        Update the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to update the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dNoTypeUpdate(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def insert_deft(self,
                    id: str,
                    status: str,
                    descr: str,
                    grp: str,
                    priority: int,
                    pref_corr: dict,
                    corr_cnt: int,
                    max_life: int,
                    modified_by: str):
        """
        Insert the record setting all column values.

        :param id: str
        :param status: str
        :param descr: str
        :param grp: str
        :param priority: int
        :param pref_corr: dict
        :param corr_cnt: int
        :param max_life: int
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.id = id
        self.rec.status = status
        self.rec.descr = descr
        self.rec.grp = grp
        self.rec.priority = priority
        self.rec.pref_corr = pref_corr
        self.rec.corr_cnt = corr_cnt
        self.rec.max_life = max_life
        self.rec.modified_by = modified_by

        self.insert()

    def insert(self, irec: tNoType = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dNoTypeInsert(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def delete_one_deft(self,
                        id: str):
        """
        Delete one record by it's primary key columns.

        :param id: str
        """
        _key = tNoTypeKey()

        _key.id = id

        self.delete_one(_key)

    def delete_one(self, irec: tNoTypeKey = None):
        """
        Delete the record by its primary key or irec if it is not None.

        :param irec: If not None use this record to delete record.
        """
        _key = tNoTypeKey()

        if irec:
            _key._copy_from(irec)
        else:
            self.rec._write_key(_key)

        with dNoTypeDeleteOne(self._dbcon) as _qry:
            _qry.exec(_key)

