# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Mar 30 15:41:12 2021
#  Target Database = postgresql
#
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.msg_key import tMsgKey
from bs_loco.db.tables.msg import tMsg

class dMsgSelectOne:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self._dbcon   = dbcon
        self._dbstmnt = None
        self.irec     = tMsgKey()
        self.orec     = tMsg()

    def __del__(self):
        """
        Destructor.
        """
        del self._dbstmnt

    def __enter__(self):
        """
        With statement enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        With statement exit.
        """
        self._destroy()

    def _destroy(self):
        if self._dbstmnt == None:
            return

        del self._dbstmnt
        self._dbstmnt = None

    def exec_deft(self,
                  id: int) -> "dMsgSelectOne":
        """
        Execute the query by setting all the inputs.

        :param id: int
        :return: Self for convenience.
        """
        self.irec.id = id

        return self.exec()

    def exec(self, irec: tMsgKey = None) -> "dMsgSelectOne":
        """
        Execute the query, optionally passing in the input rec.

        :param irec:
        :return: Self for convenience.
        """
        if irec:
            self.irec._copy_from(irec)

        self._destroy()

        self._dbstmnt = self._dbcon.statement("MsgSelectOne", self._dbcon.STMNT_TYPE_READ)

        self._dbstmnt.sql("""select
  id,
  msgreq_id,
  corrtype_id,
  notype_id,
  priority,
  status,
  retry_cnt,
  fail_cnt,
  time_sent,
  time_taken,
  corrprov_id,
  msglog,
  payload,
  modified_by,
  tm_stamp
from
  loco.Msg
where
  id = :id""")

        self._dbstmnt.bind_in("id", self.irec.id, int, 8)

        self._dbstmnt.bind_out("id", int, 8)
        self._dbstmnt.bind_out("msgreq_id", int, 8)
        self._dbstmnt.bind_out("corrtype_id", str, 16)
        self._dbstmnt.bind_out("notype_id", str, 128)
        self._dbstmnt.bind_out("priority", int, 4)
        self._dbstmnt.bind_out("status", str, 1)
        self._dbstmnt.bind_out("retry_cnt", int, 4)
        self._dbstmnt.bind_out("fail_cnt", int, 4)
        self._dbstmnt.bind_out("time_sent", datetime.datetime)
        self._dbstmnt.bind_out("time_taken", float)
        self._dbstmnt.bind_out("corrprov_id", str, 16)
        self._dbstmnt.bind_out("msglog", dict)
        self._dbstmnt.bind_out("payload", dict)
        self._dbstmnt.bind_out("modified_by", str, 128)
        self._dbstmnt.bind_out("tm_stamp", datetime.datetime)

        self._dbcon.execute(self._dbstmnt)

        if irec:
            irec._copy_from(self.irec)

        return self

    def fetch(self) -> bool:
        """
        Fetches the next row from the executed query.

        :return: True if a row is retreived.
        """
        if not self._dbcon.fetch(self._dbstmnt):
            return False

        self.orec.id = self._dbstmnt.result[0]
        self.orec.msgreq_id = self._dbstmnt.result[1]
        self.orec.corrtype_id = self._dbstmnt.result[2]
        self.orec.notype_id = self._dbstmnt.result[3]
        self.orec.priority = self._dbstmnt.result[4]
        self.orec.status = self._dbstmnt.result[5]
        self.orec.retry_cnt = self._dbstmnt.result[6]
        self.orec.fail_cnt = self._dbstmnt.result[7]
        self.orec.time_sent = self._dbstmnt.result[8]
        self.orec.time_taken = self._dbstmnt.result[9]
        self.orec.corrprov_id = self._dbstmnt.result[10]
        self.orec.msglog = self._dbstmnt.result[11]
        self.orec.payload = self._dbstmnt.result[12]
        self.orec.modified_by = self._dbstmnt.result[13]
        self.orec.tm_stamp = self._dbstmnt.result[14]

        return True

    def fetch_all(self, outList: tMsg.List, clearList: bool = True) -> int:
        """
        Fetch all the rows into the specified list and return the list count.

        :param outList:
        :param clearList:
        :return: Number of rows fetched.
        """
        if clearList:
            outList.clear()

        while self.fetch():
            outList.append(copy.deepcopy(self.orec))

        return len(outList)

