# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Mar 30 15:41:12 2021
#  Target Database = postgresql
#
import asyncio
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_loco.db.tables.corr_type import tCorrType
from bs_loco.db.tables.corr_type_key import tCorrTypeKey

from .corr_type_lock_one import dCorrTypeLockOne
from .corr_type_select_one import dCorrTypeSelectOne
from .corr_type_update import dCorrTypeUpdate
from .corr_type_insert import dCorrTypeInsert

class dCorrType:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tCorrType()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    def lock_one(self, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record.

        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tCorrTypeKey()

        self.rec._write_key(_key)

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_with(self, _rec: tCorrType, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Lock and select the record using a record.

        :param _rec: The table rec to select with and into.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        _key = tCorrTypeKey()
        _rec._write_key(_key)

        self.lock_one_by_key(_key, _lock4update, _expected)
        _rec._copy_from(self.rec)
        return True

    def lock_one_deft(self,
                      id: str,
                      _lock4update: mettle.db.DBLock,
                      _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record by it's primary key columns.

        :param id: str
        :param _lock4update:  The db lock object to use. 
        :param _expected: bool
        """
        _key = tCorrTypeKey()

        _key.id = id

        return self.lock_one_by_key(_key, _lock4update, _expected)

    def lock_one_by_key(self, _key: tCorrTypeKey, _lock4update: mettle.db.DBLock, _expected: bool = True) -> bool:
        """
        Attempt to lock and select the record with it's primary key.

        :param _key: Primary key of the table record.
        :param _lock4update: The db lock object to use.
        :param _expected: If set to false, will not raise if record is not found.
        :return: True if selected, False if not found and _expected is set to False
        """
        with dCorrTypeLockOne(self._dbcon) as _qry:
            _dex = _lock4update.retrys - 1 if _lock4update.retrys > 0 else 0

            while _dex >= 0:
                try:
                    _qry.exec(_key)
                    if not _qry.fetch():
                        if not _expected:
                            return False

                        raise mettle.lib.xMettle("LockOne failed to return a record (dCorrType)")

                    break
                except mettle.lib.xMettle as _x:
                    if _x.get_error_code() != mettle.lib.xMettle.eCode.DBLockNoWaitFailed:
                        raise _x

                    if _dex == 0:
                        raise mettle.lib.xMettle("Could not lock CorrType record after %d attempt(s) at %d mili second intervals!" % (
_lock4update.retrys, _lock4update.mili_seconds), errCode = mettle.lib.xMettle.eCode.DBLockNoWaitFailed)

                    if _lock4update.mili_seconds > 0:
                        time.sleep(_lock4update.mili_seconds * 0.001)
                _dex -= 1

            self.rec = _qry.orec

            return True

    def try_select_one(self) -> bool:
        """
        Attempt to select the record.

        :return: True if the record was found.
        """
        _key = tCorrTypeKey()

        self.rec._write_key(_key)

        return self.try_select_one_by_key(_key)

    def try_select_one_with(self, _rec: tCorrType) -> bool:
        """
        Attempt to select the record using a table rec.

        :param _rec: The table rec to select with and into.
        :return: True if the row as selectd.
        """
        _key = tCorrTypeKey()
        _rec._write_key(_key)

        if not self.try_select_one_by_key(_key):
            return False

        _rec._copy_from(self.rec)

        return True

    def try_select_one_deft(self,
                            id: str) -> bool:
        """
        Attempt to select the record by it's primary key columns.

        :param id: str
        :return: True if the row as selectd.
        """
        _key = tCorrTypeKey()

        _key.id = id

        return self.try_select_one_by_key(_key)

    def try_select_one_by_key(self, _key: tCorrTypeKey) -> bool:
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :returns: True if row was selected.
        """
        with dCorrTypeSelectOne(self._dbcon) as _qry:
            _qry.exec(_key)
            if not _qry.fetch():
                return False

            self.rec = _qry.orec

        return True

    def select_one(self) -> "dCorrType":
        """
        Selects the record, raises and error if it does not exist.

        :return: Self for convenience.
        """
        if not self.try_select_one():
            raise mettle.lib.xMettle("SelectOne failed to return a record (dCorrType)")

        return self

    def select_one_with(self, _rec: tCorrType) -> "dCorrType":
        """
        Attempt to select the record with the table record.

        :param _rec: Table record.
        :returns: Self for convenience.
        """
        if not self.try_select_one_with(_rec):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dCorrType)")

        return self

    def select_one_deft(self,
                        id: str) -> "dCorrType":
        """
        Selects the record by its primary key columns, raises and error if it does not exist.

        :param id: str
        """
        _key = tCorrTypeKey()

        _key.id = id

        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dCorrType)")

        return self

    def select_one_by_key(self, _key: tCorrTypeKey) -> "dCorrType":
        """
        Attempt to select the record with it's primary key.

        :param _key: Primary key of the table record.
        :return: Self for convenience.
        """
        if not self.try_select_one_by_key(_key):
            raise mettle.lib.xMettle("SelectOne failed to return a record (dCorrType)")

        return self

    def update_deft(self,
                    id: str,
                    descr: str,
                    status: str,
                    templ_schema: dict,
                    modified_by: str):
        """
        Update the record by setting all column values.

        :param id: str
        :param descr: str
        :param status: str
        :param templ_schema: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.id = id
        self.rec.descr = descr
        self.rec.status = status
        self.rec.templ_schema = templ_schema
        self.rec.modified_by = modified_by

        self.update()

    def update(self, irec: tCorrType = None):
        """
        Update the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to update the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dCorrTypeUpdate(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

    def insert_deft(self,
                    id: str,
                    descr: str,
                    status: str,
                    templ_schema: dict,
                    modified_by: str):
        """
        Insert the record setting all column values.

        :param id: str
        :param descr: str
        :param status: str
        :param templ_schema: dict
        :param modified_by: str
        :param tm_stamp: datetime.datetime
        """
        self.rec.id = id
        self.rec.descr = descr
        self.rec.status = status
        self.rec.templ_schema = templ_schema
        self.rec.modified_by = modified_by

        self.insert()

    def insert(self, irec: tCorrType = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dCorrTypeInsert(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

