
<a href="https://derwen.ai/"><img src="https://derwen.ai/static/logo_500px.png" width="122" height="122" align="right" /></a>

# Welcome!

Thanks for your interest in contributing to **pynock** 🎉 

This page gives a quick overview of how things are organized and most
importantly, how to get involved.


## Issues and bug reports

First, if you want to report a potential issue with this library, please
[do a quick search](https://github.com/DerwenAI/pynock/issues)
to see if the issue has already been reported.
If so, it's best to simply leave a comment on an existing issue,
rather than create a new one.
Older issues may also include helpful info and show solutions to
commonly encountered questions.


## Testing

To start developing and run tests locally, first install the dev requirements: `python3 -m pip install -r requirements-dev.txt`

The testing that runs in our CI can be run with: `python3 -m pytest tests/`


## Opening new issues

When opening a 
[new issue](https://github.com/DerwenAI/pynock/issues/new/choose),
please use a **descriptive title** and include information about your
**environment** and library **installation**:

  * Which operating system and version number?
  * Which version of Python?
  * How did you install? `pip`, `conda`, clone repo then `setup.py`, etc.

Try to provide as many details as possible.
What exactly is going wrong?
_How_ is it failing?
Is there an error?

Please understand that in general our developer community does not
provide support via email, Twitter DMs, and other 1:1 messaging.
We believe that help is much more valuable when it gets **shared
publicly**, so that more people can benefit.


## Code of conduct

In all communications and collaborations, we adhere to the
[Contributor Covenant Code of Conduct](https://github.com/DerwenAI/pynock/blob/main/code_of_conduct.md).
By participating, you are expected to follow this code.


## Contributing to the code base

You don't have to be an expert to contribute, and we're happy to help
you get started.
We'll try to use the
[`good first issue`](https://github.com/DerwenAI/pynock/labels/good%20first%20issue)
tags to mark bugs and feature requests that are easy and self-contained.

If you've decided to take on one of these problems, it's best to
[fork the repo](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/about-forks)
and do development and testing in your own fork first.

Please follow the conventions for code formatting, type annotations,
unit tests, code linting, naming conventions, and so on.
Understand that we will not be able to accept pull requests that make
*major overhauls* of the code base or completely change our shared
work on formatting, testing, etc.

If you need to incorporate other libraries, please discuss this with
the other developers.
There may be issues regarding point releases and compatibility that
would have impact on other parts of the code base.

Once you're making good progress, don't forget to add a quick comment
to the original issue.
You can also use the issue to ask questions, or share your work in
progress.
Then when you're ready to submit code for review, please use a 
[pull request](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request)
on our `main` repo branch.


Suggestions and contributions for our documentation and tutorial are always welcomed.
These tend to be good starting points for new contributors: you'll get
familiar with our code samples and other resources through that.

Many thanks!
