/*
 * Library single_file_tree functions test program
 *
 * Copyright (C) 2006-2023, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <file_stream.h>
#include <types.h>

#if defined( HAVE_STDLIB_H ) || defined( WINAPI )
#include <stdlib.h>
#endif

#include "ewf_test_libcdata.h"
#include "ewf_test_libcerror.h"
#include "ewf_test_libewf.h"
#include "ewf_test_macros.h"
#include "ewf_test_unused.h"

#include "../libewf/libewf_lef_file_entry.h"
#include "../libewf/libewf_single_file_tree.h"
#include "../libewf/libewf_single_files.h"

/* UTF-16 little-endian encoded single files data
 */
uint8_t ewf_test_single_files_data1[ 5700 ] = {
	0x35, 0x00, 0x0a, 0x00, 0x72, 0x00, 0x65, 0x00, 0x63, 0x00, 0x0a, 0x00, 0x74, 0x00, 0x62, 0x00,
	0x09, 0x00, 0x63, 0x00, 0x6c, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x66, 0x00, 0x70, 0x00,
	0x09, 0x00, 0x70, 0x00, 0x67, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x67, 0x00, 0x09, 0x00, 0x69, 0x00,
	0x67, 0x00, 0x09, 0x00, 0x63, 0x00, 0x64, 0x00, 0x09, 0x00, 0x77, 0x00, 0x64, 0x00, 0x09, 0x00,
	0x6d, 0x00, 0x64, 0x00, 0x09, 0x00, 0x61, 0x00, 0x64, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00,
	0x31, 0x00, 0x39, 0x00, 0x39, 0x00, 0x32, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00, 0x6d, 0x00, 0x0a, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x09, 0x00, 0x70, 0x00, 0x72, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x61, 0x00,
	0x09, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x69, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x0a, 0x00,
	0x73, 0x00, 0x72, 0x00, 0x63, 0x00, 0x65, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x0a, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00,
	0x65, 0x00, 0x76, 0x00, 0x09, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x6f, 0x00,
	0x63, 0x00, 0x09, 0x00, 0x73, 0x00, 0x65, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x66, 0x00, 0x72, 0x00,
	0x09, 0x00, 0x6d, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x74, 0x00, 0x62, 0x00, 0x09, 0x00, 0x6c, 0x00,
	0x6f, 0x00, 0x09, 0x00, 0x70, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x61, 0x00, 0x68, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x68, 0x00, 0x09, 0x00, 0x67, 0x00, 0x75, 0x00, 0x09, 0x00, 0x70, 0x00, 0x67, 0x00,
	0x75, 0x00, 0x09, 0x00, 0x61, 0x00, 0x71, 0x00, 0x09, 0x00, 0x69, 0x00, 0x70, 0x00, 0x09, 0x00,
	0x73, 0x00, 0x69, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x09, 0x00, 0x64, 0x00, 0x74, 0x00,
	0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x66, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00,
	0x09, 0x00, 0x46, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x04, 0x5f, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x46, 0x00, 0x6c, 0x00, 0x61, 0x00,
	0x73, 0x00, 0x68, 0x00, 0x20, 0x00, 0x44, 0x00, 0x69, 0x00, 0x73, 0x00, 0x6b, 0x00, 0x09, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x32, 0x00, 0x31, 0x00, 0x34, 0x00, 0x34, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x37, 0x00, 0x37, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00, 0x42, 0x00,
	0x39, 0x00, 0x32, 0x00, 0x41, 0x00, 0x35, 0x00, 0x38, 0x00, 0x43, 0x00, 0x38, 0x00, 0x37, 0x00,
	0x43, 0x00, 0x34, 0x00, 0x38, 0x00, 0x30, 0x00, 0x41, 0x00, 0x33, 0x00, 0x30, 0x00, 0x46, 0x00,
	0x42, 0x00, 0x43, 0x00, 0x35, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x31, 0x00, 0x41, 0x00,
	0x36, 0x00, 0x35, 0x00, 0x09, 0x00, 0x37, 0x00, 0x37, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x42, 0x00, 0x39, 0x00, 0x32, 0x00, 0x41, 0x00, 0x35, 0x00, 0x38, 0x00, 0x43, 0x00, 0x38, 0x00,
	0x37, 0x00, 0x43, 0x00, 0x34, 0x00, 0x38, 0x00, 0x30, 0x00, 0x41, 0x00, 0x33, 0x00, 0x30, 0x00,
	0x46, 0x00, 0x42, 0x00, 0x43, 0x00, 0x35, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x31, 0x00,
	0x41, 0x00, 0x36, 0x00, 0x35, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x72, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x73, 0x00,
	0x75, 0x00, 0x62, 0x00, 0x0a, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x70, 0x00,
	0x09, 0x00, 0x6e, 0x00, 0x09, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x6e, 0x00, 0x75, 0x00,
	0x09, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x67, 0x00, 0x75, 0x00, 0x0a, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x72, 0x00,
	0x79, 0x00, 0x0a, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00, 0x0a, 0x00, 0x6d, 0x00, 0x69, 0x00,
	0x64, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x73, 0x00, 0x09, 0x00, 0x62, 0x00, 0x65, 0x00, 0x09, 0x00,
	0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x63, 0x00, 0x72, 0x00, 0x09, 0x00, 0x61, 0x00, 0x63, 0x00,
	0x09, 0x00, 0x77, 0x00, 0x72, 0x00, 0x09, 0x00, 0x6d, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x64, 0x00,
	0x6c, 0x00, 0x09, 0x00, 0x73, 0x00, 0x69, 0x00, 0x67, 0x00, 0x09, 0x00, 0x68, 0x00, 0x61, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x68, 0x00, 0x61, 0x00, 0x09, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x74, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x6e, 0x00, 0x68, 0x00, 0x09, 0x00, 0x70, 0x00, 0x09, 0x00, 0x6e, 0x00,
	0x09, 0x00, 0x64, 0x00, 0x75, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x09, 0x00, 0x70, 0x00,
	0x6f, 0x00, 0x09, 0x00, 0x70, 0x00, 0x6d, 0x00, 0x09, 0x00, 0x6f, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x09, 0x00, 0x73, 0x00, 0x70, 0x00, 0x74, 0x00, 0x68, 0x00, 0x09, 0x00, 0x6f, 0x00, 0x70, 0x00,
	0x72, 0x00, 0x09, 0x00, 0x73, 0x00, 0x72, 0x00, 0x63, 0x00, 0x09, 0x00, 0x73, 0x00, 0x75, 0x00,
	0x62, 0x00, 0x09, 0x00, 0x63, 0x00, 0x69, 0x00, 0x64, 0x00, 0x09, 0x00, 0x6a, 0x00, 0x71, 0x00,
	0x09, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x74, 0x00, 0x09, 0x00, 0x65, 0x00, 0x70, 0x00, 0x09, 0x00,
	0x61, 0x00, 0x71, 0x00, 0x09, 0x00, 0x63, 0x00, 0x66, 0x00, 0x69, 0x00, 0x09, 0x00, 0x73, 0x00,
	0x67, 0x00, 0x09, 0x00, 0x65, 0x00, 0x61, 0x00, 0x09, 0x00, 0x6c, 0x00, 0x70, 0x00, 0x74, 0x00,
	0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x36, 0x00, 0x0a, 0x00, 0x41, 0x00, 0x44, 0x00,
	0x31, 0x00, 0x43, 0x00, 0x34, 0x00, 0x31, 0x00, 0x42, 0x00, 0x42, 0x00, 0x33, 0x00, 0x46, 0x00,
	0x31, 0x00, 0x42, 0x00, 0x37, 0x00, 0x34, 0x00, 0x38, 0x00, 0x43, 0x00, 0x39, 0x00, 0x30, 0x00,
	0x45, 0x00, 0x34, 0x00, 0x38, 0x00, 0x34, 0x00, 0x44, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00,
	0x37, 0x00, 0x43, 0x00, 0x31, 0x00, 0x33, 0x00, 0x39, 0x00, 0x44, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x4c, 0x00, 0x6f, 0x00, 0x67, 0x00, 0x69, 0x00, 0x63, 0x00, 0x61, 0x00,
	0x6c, 0x00, 0x45, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x2d, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x32, 0x00,
	0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x35, 0x00, 0x38, 0x00, 0x30, 0x00, 0x42, 0x00,
	0x41, 0x00, 0x33, 0x00, 0x30, 0x00, 0x44, 0x00, 0x42, 0x00, 0x38, 0x00, 0x34, 0x00, 0x32, 0x00,
	0x41, 0x00, 0x39, 0x00, 0x38, 0x00, 0x45, 0x00, 0x39, 0x00, 0x44, 0x00, 0x46, 0x00, 0x31, 0x00,
	0x31, 0x00, 0x32, 0x00, 0x34, 0x00, 0x30, 0x00, 0x34, 0x00, 0x37, 0x00, 0x46, 0x00, 0x42, 0x00,
	0x36, 0x00, 0x30, 0x00, 0x36, 0x00, 0x41, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00,
	0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x39, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00,
	0x38, 0x00, 0x39, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x44, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x44, 0x00, 0x38, 0x00, 0x43, 0x00, 0x44, 0x00, 0x39, 0x00, 0x38, 0x00, 0x46, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x42, 0x00, 0x32, 0x00, 0x30, 0x00, 0x34, 0x00, 0x45, 0x00, 0x39, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x39, 0x00, 0x39, 0x00, 0x38, 0x00, 0x45, 0x00, 0x43, 0x00, 0x46, 0x00,
	0x38, 0x00, 0x34, 0x00, 0x32, 0x00, 0x37, 0x00, 0x45, 0x00, 0x09, 0x00, 0x44, 0x00, 0x41, 0x00,
	0x33, 0x00, 0x39, 0x00, 0x41, 0x00, 0x33, 0x00, 0x45, 0x00, 0x45, 0x00, 0x35, 0x00, 0x45, 0x00,
	0x36, 0x00, 0x42, 0x00, 0x34, 0x00, 0x42, 0x00, 0x30, 0x00, 0x44, 0x00, 0x33, 0x00, 0x32, 0x00,
	0x35, 0x00, 0x35, 0x00, 0x42, 0x00, 0x46, 0x00, 0x45, 0x00, 0x46, 0x00, 0x39, 0x00, 0x35, 0x00,
	0x36, 0x00, 0x30, 0x00, 0x31, 0x00, 0x38, 0x00, 0x39, 0x00, 0x30, 0x00, 0x41, 0x00, 0x46, 0x00,
	0x44, 0x00, 0x38, 0x00, 0x30, 0x00, 0x37, 0x00, 0x30, 0x00, 0x39, 0x00, 0x09, 0x00, 0x45, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x54, 0x00, 0x65, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x41, 0x00, 0x39, 0x00,
	0x46, 0x00, 0x42, 0x00, 0x44, 0x00, 0x32, 0x00, 0x44, 0x00, 0x41, 0x00, 0x42, 0x00, 0x31, 0x00,
	0x30, 0x00, 0x45, 0x00, 0x41, 0x00, 0x38, 0x00, 0x38, 0x00, 0x33, 0x00, 0x38, 0x00, 0x46, 0x00,
	0x36, 0x00, 0x35, 0x00, 0x32, 0x00, 0x39, 0x00, 0x46, 0x00, 0x41, 0x00, 0x34, 0x00, 0x45, 0x00,
	0x34, 0x00, 0x44, 0x00, 0x39, 0x00, 0x37, 0x00, 0x41, 0x00, 0x38, 0x00, 0x09, 0x00, 0x32, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x34, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00,
	0x38, 0x00, 0x39, 0x00, 0x38, 0x00, 0x32, 0x00, 0x33, 0x00, 0x09, 0x00, 0x31, 0x00, 0x35, 0x00,
	0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x35, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x38, 0x00, 0x39, 0x00,
	0x38, 0x00, 0x31, 0x00, 0x36, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x38, 0x00, 0x09, 0x00, 0x35, 0x00, 0x44, 0x00, 0x44, 0x00, 0x33, 0x00, 0x39, 0x00, 0x43, 0x00,
	0x41, 0x00, 0x42, 0x00, 0x31, 0x00, 0x43, 0x00, 0x35, 0x00, 0x33, 0x00, 0x43, 0x00, 0x32, 0x00,
	0x43, 0x00, 0x37, 0x00, 0x37, 0x00, 0x43, 0x00, 0x44, 0x00, 0x33, 0x00, 0x35, 0x00, 0x32, 0x00,
	0x39, 0x00, 0x38, 0x00, 0x33, 0x00, 0x46, 0x00, 0x39, 0x00, 0x36, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x45, 0x00, 0x31, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x20, 0x00, 0x54, 0x00, 0x45, 0x00, 0x53, 0x00, 0x54, 0x00, 0x46, 0x00, 0x49, 0x00, 0x4c, 0x00,
	0x45, 0x00, 0x2e, 0x00, 0x54, 0x00, 0x58, 0x00, 0x54, 0x00, 0x09, 0x00, 0x09, 0x00, 0x74, 0x00,
	0x65, 0x00, 0x73, 0x00, 0x74, 0x00, 0x66, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x2e, 0x00,
	0x74, 0x00, 0x78, 0x00, 0x74, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x37, 0x00, 0x32, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x31, 0x00, 0x34, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x33, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00,
	0x34, 0x00, 0x31, 0x00, 0x39, 0x00, 0x34, 0x00, 0x33, 0x00, 0x31, 0x00, 0x32, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x0a, 0x00, 0x41, 0x00, 0x44, 0x00, 0x39, 0x00, 0x39, 0x00, 0x36, 0x00, 0x35, 0x00, 0x46, 0x00,
	0x34, 0x00, 0x34, 0x00, 0x36, 0x00, 0x30, 0x00, 0x34, 0x00, 0x33, 0x00, 0x37, 0x00, 0x38, 0x00,
	0x43, 0x00, 0x39, 0x00, 0x45, 0x00, 0x45, 0x00, 0x30, 0x00, 0x43, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x33, 0x00, 0x46, 0x00, 0x44, 0x00, 0x32, 0x00, 0x33, 0x00, 0x31, 0x00, 0x34, 0x00, 0x45, 0x00,
	0x34, 0x00, 0x09, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x43, 0x00, 0x39, 0x00, 0x30, 0x00, 0x41, 0x00,
	0x33, 0x00, 0x41, 0x00, 0x33, 0x00, 0x35, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00, 0x35, 0x00,
	0x41, 0x00, 0x45, 0x00, 0x43, 0x00, 0x37, 0x00, 0x38, 0x00, 0x41, 0x00, 0x43, 0x00, 0x31, 0x00,
	0x36, 0x00, 0x46, 0x00, 0x31, 0x00, 0x31, 0x00, 0x34, 0x00, 0x44, 0x00, 0x38, 0x00, 0x36, 0x00,
	0x34, 0x00, 0x38, 0x00, 0x41, 0x00, 0x32, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x56, 0x00, 0x6f, 0x00, 0x6c, 0x00, 0x75, 0x00,
	0x6d, 0x00, 0x65, 0x00, 0x20, 0x00, 0x42, 0x00, 0x6f, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x20, 0x00, 0x35, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x34, 0x00, 0x31, 0x00,
	0x39, 0x00, 0x34, 0x00, 0x33, 0x00, 0x30, 0x00, 0x34, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x44, 0x00,
	0x31, 0x00, 0x46, 0x00, 0x45, 0x00, 0x36, 0x00, 0x45, 0x00, 0x42, 0x00, 0x39, 0x00, 0x30, 0x00,
	0x33, 0x00, 0x39, 0x00, 0x45, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x44, 0x00, 0x41, 0x00,
	0x38, 0x00, 0x35, 0x00, 0x44, 0x00, 0x32, 0x00, 0x30, 0x00, 0x41, 0x00, 0x31, 0x00, 0x37, 0x00,
	0x33, 0x00, 0x43, 0x00, 0x43, 0x00, 0x31, 0x00, 0x43, 0x00, 0x41, 0x00, 0x42, 0x00, 0x09, 0x00,
	0x31, 0x00, 0x33, 0x00, 0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x37, 0x00,
	0x46, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00, 0x36, 0x00, 0x38, 0x00, 0x43, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00, 0x35, 0x00, 0x44, 0x00, 0x32, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x33, 0x00, 0x34, 0x00, 0x39, 0x00, 0x45, 0x00, 0x33, 0x00, 0x46, 0x00,
	0x43, 0x00, 0x43, 0x00, 0x46, 0x00, 0x46, 0x00, 0x33, 0x00, 0x35, 0x00, 0x35, 0x00, 0x09, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x50, 0x00,
	0x72, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x72, 0x00, 0x79, 0x00, 0x20, 0x00, 0x46, 0x00,
	0x41, 0x00, 0x54, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00,
	0x36, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x35, 0x00, 0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x20, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x34, 0x00, 0x31, 0x00, 0x39, 0x00, 0x34, 0x00,
	0x33, 0x00, 0x30, 0x00, 0x34, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0a, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x35, 0x00, 0x39, 0x00, 0x42, 0x00,
	0x42, 0x00, 0x39, 0x00, 0x34, 0x00, 0x30, 0x00, 0x43, 0x00, 0x31, 0x00, 0x39, 0x00, 0x38, 0x00,
	0x39, 0x00, 0x35, 0x00, 0x44, 0x00, 0x38, 0x00, 0x39, 0x00, 0x42, 0x00, 0x32, 0x00, 0x31, 0x00,
	0x34, 0x00, 0x34, 0x00, 0x37, 0x00, 0x42, 0x00, 0x37, 0x00, 0x44, 0x00, 0x35, 0x00, 0x38, 0x00,
	0x37, 0x00, 0x45, 0x00, 0x37, 0x00, 0x33, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x37, 0x00, 0x32, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00,
	0x31, 0x00, 0x30, 0x00, 0x31, 0x00, 0x35, 0x00, 0x20, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00,
	0x62, 0x00, 0x09, 0x00, 0x37, 0x00, 0x46, 0x00, 0x32, 0x00, 0x46, 0x00, 0x31, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x38, 0x00, 0x43, 0x00, 0x33, 0x00, 0x30, 0x00, 0x30, 0x00, 0x44, 0x00, 0x36, 0x00,
	0x35, 0x00, 0x44, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x33, 0x00, 0x34, 0x00, 0x39, 0x00,
	0x45, 0x00, 0x33, 0x00, 0x46, 0x00, 0x43, 0x00, 0x43, 0x00, 0x46, 0x00, 0x46, 0x00, 0x33, 0x00,
	0x35, 0x00, 0x35, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x53, 0x00, 0x65, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x64, 0x00,
	0x61, 0x00, 0x72, 0x00, 0x79, 0x00, 0x20, 0x00, 0x46, 0x00, 0x41, 0x00, 0x54, 0x00, 0x09, 0x00,
	0x34, 0x00, 0x31, 0x00, 0x31, 0x00, 0x37, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x35, 0x00, 0x31, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00,
	0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x38, 0x00, 0x20, 0x00, 0x20, 0x00, 0x35, 0x00,
	0x33, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00, 0x66, 0x00,
	0x66, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x37, 0x00, 0x31, 0x00, 0x33, 0x00,
	0x30, 0x00, 0x33, 0x00, 0x31, 0x00, 0x36, 0x00, 0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x0a, 0x00, 0x32, 0x00, 0x36, 0x00, 0x09, 0x00, 0x30, 0x00, 0x0a, 0x00, 0x37, 0x00,
	0x30, 0x00, 0x43, 0x00, 0x37, 0x00, 0x37, 0x00, 0x36, 0x00, 0x33, 0x00, 0x35, 0x00, 0x44, 0x00,
	0x32, 0x00, 0x39, 0x00, 0x45, 0x00, 0x45, 0x00, 0x42, 0x00, 0x38, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x36, 0x00, 0x37, 0x00, 0x39, 0x00, 0x33, 0x00, 0x45, 0x00, 0x38, 0x00, 0x42, 0x00, 0x37, 0x00,
	0x45, 0x00, 0x44, 0x00, 0x37, 0x00, 0x36, 0x00, 0x34, 0x00, 0x30, 0x00, 0x36, 0x00, 0x09, 0x00,
	0x32, 0x00, 0x36, 0x00, 0x31, 0x00, 0x38, 0x00, 0x35, 0x00, 0x37, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x31, 0x00, 0x30, 0x00, 0x31, 0x00,
	0x36, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x38, 0x00, 0x20, 0x00, 0x31, 0x00, 0x62, 0x00, 0x09, 0x00, 0x32, 0x00, 0x39, 0x00, 0x39, 0x00,
	0x37, 0x00, 0x44, 0x00, 0x44, 0x00, 0x36, 0x00, 0x31, 0x00, 0x39, 0x00, 0x30, 0x00, 0x38, 0x00,
	0x44, 0x00, 0x33, 0x00, 0x44, 0x00, 0x31, 0x00, 0x38, 0x00, 0x30, 0x00, 0x36, 0x00, 0x37, 0x00,
	0x38, 0x00, 0x44, 0x00, 0x33, 0x00, 0x31, 0x00, 0x41, 0x00, 0x44, 0x00, 0x35, 0x00, 0x45, 0x00,
	0x42, 0x00, 0x34, 0x00, 0x32, 0x00, 0x41, 0x00, 0x38, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x42, 0x00,
	0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x09, 0x00, 0x55, 0x00, 0x6e, 0x00, 0x61, 0x00,
	0x6c, 0x00, 0x6c, 0x00, 0x6f, 0x00, 0x63, 0x00, 0x61, 0x00, 0x74, 0x00, 0x65, 0x00, 0x64, 0x00,
	0x20, 0x00, 0x43, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x73, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x32, 0x00, 0x38, 0x00, 0x32, 0x00, 0x36, 0x00,
	0x32, 0x00, 0x34, 0x00, 0x09, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00,
	0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00,
	0x62, 0x00, 0x61, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x34, 0x00, 0x35, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x32, 0x00, 0x32, 0x00, 0x38, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x34, 0x00, 0x33, 0x00, 0x20, 0x00, 0x32, 0x00, 0x20, 0x00, 0x34, 0x00, 0x35, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x20, 0x00, 0x31, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x32, 0x00, 0x20, 0x00, 0x31, 0x00, 0x20, 0x00, 0x32, 0x00, 0x32, 0x00, 0x38, 0x00,
	0x20, 0x00, 0x38, 0x00, 0x20, 0x00, 0x34, 0x00, 0x37, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x39, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x20, 0x00, 0x34, 0x00, 0x20, 0x00, 0x66, 0x00, 0x39, 0x00, 0x62, 0x00, 0x39, 0x00, 0x20, 0x00,
	0x32, 0x00, 0x33, 0x00, 0x38, 0x00, 0x20, 0x00, 0x37, 0x00, 0x63, 0x00, 0x64, 0x00, 0x63, 0x00,
	0x38, 0x00, 0x09, 0x00, 0x31, 0x00, 0x20, 0x00, 0x09, 0x00, 0x36, 0x00, 0x32, 0x00, 0x39, 0x00,
	0x31, 0x00, 0x34, 0x00, 0x35, 0x00, 0x36, 0x00, 0x09, 0x00, 0x31, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x09, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x09, 0x00, 0x09, 0x00,
	0x0a, 0x00, 0x0a, 0x00 };

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

/* Tests the libewf_single_file_tree_get_sub_node_by_utf8_name function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_file_tree_get_sub_node_by_utf8_name(
     void )
{
	uint8_t utf8_name[ 5 ]                      = { 'T', 'e', 's', 't', 0 };

	libcdata_tree_node_t *root_node             = NULL;
	libcdata_tree_node_t *sub_node              = NULL;
	libcerror_error_t *error                    = NULL;
	libewf_lef_file_entry_t *sub_lef_file_entry = NULL;
	libewf_single_files_t *single_files         = NULL;
	size64_t media_size                         = 0;
	uint8_t format                              = 0;
	int result                                  = 0;

	/* Initialize test
	 */
	result = libewf_single_files_initialize(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_read_data(
	          single_files,
	          ewf_test_single_files_data1,
	          5700,
	          &media_size,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_get_file_entry_tree_root_node(
	          single_files,
	          &root_node,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "root_node",
	 root_node );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	result = libewf_single_file_tree_get_sub_node_by_utf8_name(
	          root_node,
	          utf8_name,
	          4,
	          &sub_node,
	          &sub_lef_file_entry,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "sub_node,",
	 sub_node );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "sub_lef_file_entry,",
	 sub_lef_file_entry );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_single_file_tree_get_sub_node_by_utf8_name(
	          NULL,
	          utf8_name,
	          4,
	          &sub_node,
	          &sub_lef_file_entry,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_file_tree_get_sub_node_by_utf8_name(
	          root_node,
	          utf8_name,
	          4,
	          NULL,
	          &sub_lef_file_entry,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_file_tree_get_sub_node_by_utf8_name(
	          root_node,
	          utf8_name,
	          4,
	          &sub_node,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_file_tree_get_sub_node_by_utf8_name(
	          root_node,
	          NULL,
	          4,
	          &sub_node,
	          &sub_lef_file_entry,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Clean up
	 */
	result = libewf_single_files_free(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( single_files != NULL )
	{
		libewf_single_files_free(
		 &single_files,
		 NULL );
	}
	return( 0 );
}

/* Tests the libewf_single_file_tree_get_sub_node_by_utf16_name function
 * Returns 1 if successful or 0 if not
 */
int ewf_test_single_file_tree_get_sub_node_by_utf16_name(
     void )
{
	uint16_t utf16_name[ 5 ]                    = { 'T', 'e', 's', 't', 0 };

	libcdata_tree_node_t *root_node             = NULL;
	libcdata_tree_node_t *sub_node              = NULL;
	libcerror_error_t *error                    = NULL;
	libewf_lef_file_entry_t *sub_lef_file_entry = NULL;
	libewf_single_files_t *single_files         = NULL;
	size64_t media_size                         = 0;
	uint8_t format                              = 0;
	int result                                  = 0;

	/* Initialize test
	 */
	result = libewf_single_files_initialize(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_read_data(
	          single_files,
	          ewf_test_single_files_data1,
	          5700,
	          &media_size,
	          &format,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libewf_single_files_get_file_entry_tree_root_node(
	          single_files,
	          &root_node,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "root_node",
	 root_node );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	result = libewf_single_file_tree_get_sub_node_by_utf16_name(
	          root_node,
	          utf16_name,
	          4,
	          &sub_node,
	          &sub_lef_file_entry,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "sub_node,",
	 sub_node );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "sub_lef_file_entry,",
	 sub_lef_file_entry );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libewf_single_file_tree_get_sub_node_by_utf16_name(
	          NULL,
	          utf16_name,
	          4,
	          &sub_node,
	          &sub_lef_file_entry,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_file_tree_get_sub_node_by_utf16_name(
	          root_node,
	          utf16_name,
	          4,
	          NULL,
	          &sub_lef_file_entry,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_file_tree_get_sub_node_by_utf16_name(
	          root_node,
	          utf16_name,
	          4,
	          &sub_node,
	          NULL,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libewf_single_file_tree_get_sub_node_by_utf16_name(
	          root_node,
	          NULL,
	          4,
	          &sub_node,
	          &sub_lef_file_entry,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	EWF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Clean up
	 */
	result = libewf_single_files_free(
	          &single_files,
	          &error );

	EWF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	EWF_TEST_ASSERT_IS_NULL(
	 "single_files",
	 single_files );

	EWF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( single_files != NULL )
	{
		libewf_single_files_free(
		 &single_files,
		 NULL );
	}
	return( 0 );
}

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

/* The main program
 */
#if defined( HAVE_WIDE_SYSTEM_CHARACTER )
int wmain(
     int argc EWF_TEST_ATTRIBUTE_UNUSED,
     wchar_t * const argv[] EWF_TEST_ATTRIBUTE_UNUSED )
#else
int main(
     int argc EWF_TEST_ATTRIBUTE_UNUSED,
     char * const argv[] EWF_TEST_ATTRIBUTE_UNUSED )
#endif
{
	EWF_TEST_UNREFERENCED_PARAMETER( argc )
	EWF_TEST_UNREFERENCED_PARAMETER( argv )

#if defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT )

	EWF_TEST_RUN(
	 "libewf_single_file_tree_get_sub_node_by_utf8_name",
	 ewf_test_single_file_tree_get_sub_node_by_utf8_name );

	EWF_TEST_RUN(
	 "libewf_single_file_tree_get_sub_node_by_utf16_name",
	 ewf_test_single_file_tree_get_sub_node_by_utf16_name );

#endif /* defined( __GNUC__ ) && !defined( LIBEWF_DLL_IMPORT ) */

	return( EXIT_SUCCESS );

on_error:
	return( EXIT_FAILURE );
}

