import codecs
import os.path
from setuptools import setup, find_packages

def read(rel_path):
    here = os.path.abspath(os.path.dirname(__file__))
    with codecs.open(os.path.join(here, rel_path), 'r') as fp:
        return fp.read()

def get_version(rel_path):
    for line in read(rel_path).splitlines():
        if line.startswith('__version__'):
            delim = '"' if '"' in line else "'"
            return line.split(delim)[1]
    else:
        raise RuntimeError("Unable to find version string.")

with open('README.md', 'r') as fh:
    long_description = fh.read()

setup(
    name='pylabnet',
    version=get_version('pylabnet/__init__.py'),
    description='Client-server, python-based laboratory software',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://github.com/lukingroup/pylabnet',
    author='Lukin SiV Team',
    author_email='b16lukin@gmail.com',
    license='MIT',
    packages=find_packages(),
    include_package_data=True,
    entry_points={
        'console_scripts': [
            'pylabnet=pylabnet.launchers.launch_control:main',
            'pylabnet_proxy=pylabnet.launchers.launch_control:main_proxy'
            ]
        },
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Operating System :: Microsoft :: Windows :: Windows 10",
        "Programming Language :: Python :: 3",
        "Topic :: Scientific/Engineering :: Physics"
    ],
    install_requires=[
        'alabaster>=0.7.12',
        'asn1crypto>=1.0.1',
        'astroid>=2.3.1',
        'astropy>=3.2.1',
        'atomicwrites>=1.3.0',
        'attrs>=19.2.0',
        'Babel>=2.7.0',
        'backcall>=0.1.0',
        'backports.os>=0.1.1',
        'backports.shutil-get-terminal-size>=1.0.0',
        'beautifulsoup4>=4.8.0',
        'bitarray>=1.0.1',
        'bkcharts>=0.2',
        'bleach>=3.1.0',
        'bokeh>=1.3.4',
        'boto>=2.49.0',
        'certifi>=2019.9.11',
        'cffi>=1.12.3',
        'chardet>=3.0.4',
        'Click>=7.0',
        'cloudpickle>=1.2.2',
        'colorama>=0.4.1',
        'comtypes>=1.1.7',
        'contextlib2>=0.6.0',
        'cryptography>=2.7',
        'cycler>=0.10.0',
        'Cython>=0.29.13',
        'cytoolz>=0.10.0',
        'dask>=2.5.2',
        'decorator>=4.4.0',
        'defusedxml>=0.6.0',
        'distributed>=2.5.2',
        'docutils>=0.15.2',
        'entrypoints>=0.3',
        'et-xmlfile>=1.0.1',
        'fastcache>=1.1.0',
        'filelock>=3.0.12',
        'flake8>=3.7.9',
        'Flask>=1.1.1',
        'fsspec>=0.5.2',
        'gevent>=1.4.0',
        'glob2>=0.7',
        'greenlet>=0.4.15',
        'h5py>=2.9.0',
        'HeapDict>=1.0.1',
        'html5lib>=1.0.1',
        'idna>=2.8',
        'imageio>=2.6.0',
        'imagesize>=1.1.0',
        'importlib-metadata>=0.23',
        'ipykernel>=5.1.2',
        'ipython>=7.8.0',
        'ipython-genutils>=0.2.0',
        'ipywidgets>=7.5.1',
        'isort>=4.3.21',
        'itsdangerous>=1.1.0',
        'jdcal>=1.4.1',
        'jedi>=0.15.1',
        'Jinja2>=2.10.3',
        'joblib>=0.13.2',
        'json5>=0.8.5',
        'jsonschema>=3.0.2',
        'jupyter>=1.0.0',
        'jupyter-client>=5.3.3',
        'jupyter-console>=6.0.0',
        'jupyter-core>=4.5.0',
        'jupyterlab>=1.1.4',
        'jupyterlab-server>=1.1.0',
        'keyring>=18.0.0',
        'kiwisolver>=1.1.0',
        'lazy-object-proxy>=1.4.2',
        'libarchive-c>=2.8',
        'llvmlite>=0.29.0',
        'locket>=0.2.0',
        'lxml>=4.4.1',
        'MarkupSafe>=1.1.1',
        'matplotlib>=3.1.1',
        'mccabe>=0.6.1',
        'mistune>=0.8.4',
        'mock>=3.0.5',
        'more-itertools>=7.2.0',
        'mpmath>=1.1.0',
        'msgpack>=0.6.1',
        'multipledispatch>=0.6.0',
        'nbconvert>=5.6.0',
        'nbformat>=4.4.0',
        'networkx>=2.3',
        'nidaqmx>=0.5.7',
        'nltk>=3.4.5',
        'nose>=1.3.7',
        'notebook>=6.0.1',
        'numba>=0.45.1',
        'numexpr>=2.7.0',
        'numpy>=1.16.5',
        'numpydoc>=0.9.1',
        'olefile>=0.46',
        'openpyxl>=3.0.0',
        'packaging>=19.2',
        'pandas>=0.25.1',
        'pandocfilters>=1.4.2',
        'parso>=0.7.0',
        'partd>=1.0.0',
        'path.py>=12.0.1',
        'pathlib2>=2.3.5',
        'patsy>=0.5.1',
        'pep8>=1.7.1',
        'pickleshare>=0.7.5',
        'Pillow>=6.2.0',
        'pkginfo>=1.5.0.1',
        'plotly>=4.1.1',
        'pluggy>=0.13.0',
        'plumbum>=1.6.7',
        'ply>=3.11',
        'prometheus-client>=0.7.1',
        'prompt-toolkit>=2.0.10',
        'psutil>=5.6.3',
        'ptvsd>=4.3.2',
        'py>=1.8.0',
        'pycodestyle>=2.5.0',
        'pycosat>=0.6.3',
        'pycparser>=2.19',
        'pycurl>=7.43.0.3',
        'pyflakes>=2.1.1',
        'Pygments>=2.5.1',
        'pylint>=2.4.2',
        'pyodbc>=4.0.27',
        'pyOpenSSL>=19.0.0',
        'pyparsing>=2.4.2',
        'PyQt5>=5.13.0',
        'PyQt5-sip>=12.7.1',
        'pyqtgraph>=0.10.0',
        'pyreadline>=2.1',
        'pyrsistent>=0.15.4',
        'PySocks>=1.7.1',
        'pytest>=5.2.1',
        'pytest-arraydiff>=0.3',
        'pytest-astropy>=0.5.0',
        'pytest-doctestplus>=0.4.0',
        'pytest-openfiles>=0.4.0',
        'pytest-remotedata>=0.3.2',
        'python-dateutil>=2.8.0',
        'python-dotenv>=0.12.0',
        'pytz>=2019.3',
        'PyVISA>=1.10.1',
        'PyWavelets>=1.0.3',
        'PyYAML>=5.1.2',
        'pyzmq>=18.1.0',
        'QtAwesome>=0.6.0',
        'qtconsole>=4.5.5',
        'QtPy>=1.9.0',
        'requests>=2.22.0',
        'retrying>=1.3.3',
        'rope>=0.14.0',
        'rpyc>=4.1.1',
        'ruamel-yaml>=0.15.46',
        'scikit-image>=0.15.0',
        'scikit-learn>=0.21.3',
        'scipy>=1.3.1',
        'seaborn>=0.9.0',
        'Send2Trash>=1.5.0',
        'simplegeneric>=0.8.1',
        'singledispatch>=3.4.0.3',
        'six>=1.12.0',
        'snowballstemmer>=2.0.0',
        'sortedcollections>=1.1.2',
        'sortedcontainers>=2.1.0',
        'soupsieve>=1.9.3',
        'Sphinx>=2.2.0',
        'sphinxcontrib-applehelp>=1.0.1',
        'sphinxcontrib-devhelp>=1.0.1',
        'sphinxcontrib-htmlhelp>=1.0.2',
        'sphinxcontrib-jsmath>=1.0.1',
        'sphinxcontrib-qthelp>=1.0.2',
        'sphinxcontrib-serializinghtml>=1.1.3',
        'sphinxcontrib-websupport>=1.1.2',
        # 'spyder>=3.3.6',
        # 'spyder-kernels>=0.5.2',
        'SQLAlchemy>=1.3.9',
        'statsmodels>=0.10.1',
        'sympy>=1.4',
        'tables>=3.5.2',
        'tblib>=1.4.0',
        'terminado>=0.8.2',
        'testpath>=0.4.2',
        'toolz>=0.10.0',
        'tornado>=6.0.3',
        'tqdm>=4.36.1',
        'traitlets>=4.3.3',
        'unicodecsv>=0.14.1',
        'urllib3>=1.24.2',
        'wcwidth>=0.1.7',
        'webencodings>=0.5.1',
        'Werkzeug>=0.16.0',
        'widgetsnbextension>=3.5.1',
        'wrapt>=1.11.2',
        'xlrd>=1.2.0',
        'XlsxWriter>=1.2.1',
        'xlwt>=1.3.0',
        'zhinst>=20.1.1211',
        'zict>=1.0.0',
        'zipp>=0.6.0',
    ]
)
