# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00c_annotation_types.ipynb (unless otherwise specified).

__all__ = []

# Internal Cell
from pathlib import Path
from collections.abc import MutableMapping
from typing import Dict, Optional, Iterable, Any, Union
from ipywidgets import Layout
from ..mltypes import OutputImageLabel, OutputLabel
from ..custom_input.buttons import ImageButton, ImageButtonSetting, ActionButton

# Internal Cell
class AnnotationStore(MutableMapping):
    def __init__(self, annotations: Optional[Dict] = None):
        self._annotations = annotations or {}

    def __getitem__(self, key: str):
        return self._annotations[key]

    def __delitem__(self, key: str):
        if key in self:
            del self._annotations[key]

    def __setitem__(self, key: str, value: Any):
        self._annotations[key] = value

    def __iter__(self):
        return iter(self._annotations)

    def __len__(self):
        return len(self._annotations)

    def __repr__(self):
        return "{}({!r})".format(self.__class__.__name__, self._annotations)

# Internal Cell
class LabelStore(AnnotationStore):
    def __getitem__(self, key: str):
        assert isinstance(key, str)
        return self._annotations[key]

    def __delitem__(self, key: str):
        assert isinstance(key, str)
        if key in self:
            del self._annotations[key]

    def __setitem__(self, key: str, value: Optional[Dict[str, bool]]):
        assert isinstance(key, str)
        if value:
            assert isinstance(value, dict)
        self._annotations[key] = value

# Internal Cell
def _label_store_to_image_button(
    annotation: LabelStore,
    width: int = 150,
    height: int = 150,
    disabled: bool = False
) -> Iterable[ImageButton]:
    button_setting = ImageButtonSetting(
        display_label=False,
        image_width=f'{width}px',
        image_height=f'{height}px'
    )

    buttons = []

    for path, value in annotation.items():
        image_button = ImageButton(button_setting)
        image_button.image_path = str(path)
        image_button.label_value = Path(path).stem
        image_button.active = value.get('answer', False)
        image_button.disabled = disabled
        buttons.append(image_button)

    return buttons

# Internal Cell
def _label_store_to_button(
    annotation: LabelStore,
    disabled: bool
) -> Iterable[ActionButton]:
    layout = {
        'width': 'auto',
        'height': 'auto'
    }
    buttons = []

    for label, value in annotation.items():
        button = ActionButton(layout=Layout(**layout))
        button.description = label
        button.value = label
        button.tooltip = label
        button.disabled = disabled
        if value.get('answer', True):
            button.layout.border = 'solid 2px #1B8CF3'
        buttons.append(button)

    return buttons

# Internal Cell
class LabelStoreCaster:  # pylint: disable=too-few-public-methods
    """Factory that casts the correctly widget
    accordingly with the input"""

    def __init__(
        self,
        output: Union[OutputImageLabel, OutputLabel],
        width: int = 150,
        height: int = 150,
        widgets_disabled: bool = False
    ):
        self.width = width
        self.height = height
        self.output = output
        self.widgets_disabled = widgets_disabled

    def __call__(self, annotation: LabelStore) -> Iterable:
        if isinstance(self.output, OutputImageLabel):
            return _label_store_to_image_button(
                annotation,
                self.width,
                self.height,
                self.widgets_disabled
            )

        if isinstance(self.output, OutputLabel):
            return _label_store_to_button(
                annotation,
                disabled=self.widgets_disabled
            )

        raise ValueError(
            f"output should have type OutputImageLabel or OutputLabel. {type(self.output)} given"
        )