# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00d_doc_utils.ipynb (unless otherwise specified).

__all__ = ['nbglob', 'hide', 'collapse_cells']

# Internal Cell
import os

# Internal Cell
def is_building_docs() -> bool:
    return 'DOCUTILSCONFIG' in os.environ

# Internal Cell
import glob
from fastcore.all import L, compose, Path
from nbdev.export2html import _mk_flag_re, _re_cell_to_collapse_output, check_re
from nbdev.export import check_re_multi
import nbformat as nbf

# Cell
def nbglob(fname='.', recursive=False, extension='.ipynb') -> L:
    """Find all files in a directory matching an extension.
    Ignores hidden directories and filenames starting with `_`"""
    fname = Path(fname)
    if fname.is_dir():
        abs_name = fname.absolute()
        rec_path = f'{abs_name}/**/*{extension}'
        non_rec_path = f'{abs_name}/*{extension}'
        fname = rec_path if recursive else non_rec_path
    fls = L(
        glob.glob(str(fname), recursive=recursive)
    ).filter(
        lambda x: '/.' not in x
    ).map(Path)
    return fls.filter(lambda x: not x.name.startswith('_') and x.name.endswith(extension))

# Internal Cell
def upd_metadata(cell, tag):
    cell_tags = list(set(cell.get('metadata', {}).get('tags', [])))
    if tag not in cell_tags:
        cell_tags.append(tag)
    cell['metadata']['tags'] = cell_tags

# Cell
def hide(cell):
    """Hide inputs of `cell` that need to be hidden
    if check_re_multi(cell, [_re_show_doc, *_re_hide_input]): upd_metadata(cell, 'remove-input')
    elif check_re(cell, _re_hide_output): upd_metadata(cell, 'remove-output')
    """
    regexes = ['#(.+|)hide', '%%ipytest']
    if check_re_multi(cell, regexes):
        upd_metadata(cell, 'remove-cell')

    return cell


_re_cell_to_collapse_input = _mk_flag_re(
    '(collapse_input|collapse-input)', 0, "Cell with #collapse_input")


def collapse_cells(cell):
    "Add a collapse button to inputs or outputs of `cell` in either the open or closed position"
    if check_re(cell, _re_cell_to_collapse_input):
        upd_metadata(cell, 'hide-input')
    elif check_re(cell, _re_cell_to_collapse_output):
        upd_metadata(cell, 'hide-output')
    return cell

# Internal Cell
if __name__ == '__main__':

    _func = compose(hide, collapse_cells)
    files = nbglob('nbs/')

    for file in files:
        nb = nbf.read(file, nbf.NO_CONVERT)
        for c in nb.cells:
            _func(c)
        nbf.write(nb, file)