# Autogenerated file. Do not edit.
from jacdac.bus import Bus, Client
from .constants import *
from typing import Optional


class DimmerClient(Client):
    """
    A light or fan controller that dims the current on a line.
    Implements a client for the `Dimmer <https://microsoft.github.io/jacdac-docs/services/dimmer>`_ service.

    """

    def __init__(self, bus: Bus, role: str) -> None:
        super().__init__(bus, JD_SERVICE_CLASS_DIMMER, JD_DIMMER_PACK_FORMATS, role)


    @property
    def intensity(self) -> Optional[float]:
        """
        The intensity of the current. Set to ``0`` to turn off completely the current., _: /
        """
        return self.register(JD_DIMMER_REG_INTENSITY).float_value(100)

    @intensity.setter
    def intensity(self, value: float) -> None:
        self.register(JD_DIMMER_REG_INTENSITY).set_values(value / 100)


    @property
    def variant(self) -> Optional[DimmerVariant]:
        """
        (Optional) The type of physical device, 
        """
        return self.register(JD_DIMMER_REG_VARIANT).value()

    
