"""removed nfc and pin

Revision ID: 7bd4fcd38fde
Revises: 9ca98a2e5674
Create Date: 2023-09-12 15:36:56.901769

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '7bd4fcd38fde'
down_revision = '9ca98a2e5674'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.pre_upgrade()
    with op.batch_alter_table('test_access_model', schema=None) as batch_op:
        batch_op.drop_index('ix_test_access_model_nfc_id')
        batch_op.drop_index('ix_test_access_model_pin_id')
        batch_op.drop_column('pin_id')
        batch_op.drop_column('nfc_id')

    op.post_upgrade()
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.pre_downgrade()
    with op.batch_alter_table('test_access_model', schema=None) as batch_op:
        batch_op.add_column(sa.Column('nfc_id', sa.VARCHAR(), nullable=True))
        batch_op.add_column(sa.Column('pin_id', sa.VARCHAR(), nullable=True))
        batch_op.create_index('ix_test_access_model_pin_id', ['pin_id'], unique=False)
        batch_op.create_index('ix_test_access_model_nfc_id', ['nfc_id'], unique=False)

    op.post_downgrade()
    # ### end Alembic commands ###
