/* File: fortranmetricsmodule.c
 * This file is auto-generated with f2py (version:1.20.3).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Tue Sep 28 00:21:00 2021
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *fortranmetrics_error;
static PyObject *fortranmetrics_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
/*need_typedefs*/

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define CHECKSCALAR(check,tcheck,name,show,var)\
    if (!(check)) {\
        char errstring[256];\
        sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
        PyErr_SetString(fortranmetrics_error,errstring);\
        /*goto capi_fail;*/\
    } else 
#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int
double_from_pyobj(double* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;
    if (PyFloat_Check(obj)) {
        *v = PyFloat_AsDouble(obj);
        return !(*v == -1.0 && PyErr_Occurred());
    }

    tmp = PyNumber_Float(obj);
    if (tmp) {
        *v = PyFloat_AsDouble(tmp);
        Py_DECREF(tmp);
        return !(*v == -1.0 && PyErr_Occurred());
    }
    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj,0);
    if (tmp) {
        PyErr_Clear();
        if (double_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err==NULL) err = fortranmetrics_error;
        PyErr_SetString(err,errmess);
    }
    return 0;
}

static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int
float_from_pyobj(float* v, PyObject *obj, const char *errmess)
{
    double d=0.0;
    if (double_from_pyobj(&d,obj,errmess)) {
        *v = (float)d;
        return 1;
    }
    return 0;
}

static int
int_from_pyobj(int* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;

    if (PyLong_Check(obj)) {
        *v = Npy__PyLong_AsInt(obj);
        return !(*v == -1 && PyErr_Occurred());
    }

    tmp = PyNumber_Long(obj);
    if (tmp) {
        *v = Npy__PyLong_AsInt(tmp);
        Py_DECREF(tmp);
        return !(*v == -1 && PyErr_Occurred());
    }

    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj, 0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v, tmp, errmess)) {
            Py_DECREF(tmp);
            return 1;
        }
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err == NULL) {
            err = fortranmetrics_error;
        }
        PyErr_SetString(err, errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/****************************** f90_sharpe_ratio ******************************/
static char doc_f2py_rout_fortranmetrics_fortranmetrics_f90_sharpe_ratio[] = "\
sharpe_ratio = f90_sharpe_ratio(weights,r,cov,rf,[nbsymbols])\n\nWrapper for ``f90_sharpe_ratio``.\
\n\nParameters\n----------\n"
"weights : input rank-1 array('f') with bounds (nbsymbols)\n"
"r : input rank-1 array('f') with bounds (nbsymbols)\n"
"cov : input rank-2 array('f') with bounds (nbsymbols,nbsymbols)\n"
"rf : input float\n"
"\nOther Parameters\n----------------\n"
"nbsymbols : input int, optional\n    Default: len(weights)\n"
"\nReturns\n-------\n"
"sharpe_ratio : float";
/* #declfortranroutine# */
static PyObject *f2py_rout_fortranmetrics_fortranmetrics_f90_sharpe_ratio(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,int*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float f90_sharpe_ratio = 0;
  int nbsymbols = 0;
  PyObject *nbsymbols_capi = Py_None;
  float *weights = NULL;
  npy_intp weights_Dims[1] = {-1};
  const int weights_Rank = 1;
  PyArrayObject *capi_weights_tmp = NULL;
  int capi_weights_intent = 0;
  PyObject *weights_capi = Py_None;
  float *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  float *cov = NULL;
  npy_intp cov_Dims[2] = {-1, -1};
  const int cov_Rank = 2;
  PyArrayObject *capi_cov_tmp = NULL;
  int capi_cov_intent = 0;
  PyObject *cov_capi = Py_None;
  float rf = 0;
  PyObject *rf_capi = Py_None;
    static char *capi_kwlist[] = {"weights","r","cov","rf","nbsymbols",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOO|O:fortranmetrics.fortranmetrics.f90_sharpe_ratio",\
        capi_kwlist,&weights_capi,&r_capi,&cov_capi,&rf_capi,&nbsymbols_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable weights */
  ;
  capi_weights_intent |= F2PY_INTENT_IN;
  capi_weights_tmp = array_from_pyobj(NPY_FLOAT,weights_Dims,weights_Rank,capi_weights_intent,weights_capi);
  if (capi_weights_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranmetrics_error,"failed in converting 1st argument `weights' of fortranmetrics.fortranmetrics.f90_sharpe_ratio to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    weights = (float *)(PyArray_DATA(capi_weights_tmp));

  /* Processing variable rf */
    f2py_success = float_from_pyobj(&rf,rf_capi,"fortranmetrics.fortranmetrics.f90_sharpe_ratio() 4th argument (rf) can't be converted to float");
  if (f2py_success) {
  /* Processing variable nbsymbols */
  if (nbsymbols_capi == Py_None) nbsymbols = len(weights); else
    f2py_success = int_from_pyobj(&nbsymbols,nbsymbols_capi,"fortranmetrics.fortranmetrics.f90_sharpe_ratio() 1st keyword (nbsymbols) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(weights)>=nbsymbols,"len(weights)>=nbsymbols","1st keyword nbsymbols","f90_sharpe_ratio:nbsymbols=%d",nbsymbols) {
  /* Processing variable r */
  r_Dims[0]=nbsymbols;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_FLOAT,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranmetrics_error,"failed in converting 2nd argument `r' of fortranmetrics.fortranmetrics.f90_sharpe_ratio to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    r = (float *)(PyArray_DATA(capi_r_tmp));

  /* Processing variable cov */
  cov_Dims[0]=nbsymbols,cov_Dims[1]=nbsymbols;
  capi_cov_intent |= F2PY_INTENT_IN;
  capi_cov_tmp = array_from_pyobj(NPY_FLOAT,cov_Dims,cov_Rank,capi_cov_intent,cov_capi);
  if (capi_cov_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranmetrics_error,"failed in converting 3rd argument `cov' of fortranmetrics.fortranmetrics.f90_sharpe_ratio to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cov = (float *)(PyArray_DATA(capi_cov_tmp));

  /* Processing variable f90_sharpe_ratio */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&f90_sharpe_ratio,&nbsymbols,weights,r,cov,&rf);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("f",f90_sharpe_ratio);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable f90_sharpe_ratio */
  if((PyObject *)capi_cov_tmp!=cov_capi) {
    Py_XDECREF(capi_cov_tmp); }
  }  /*if (capi_cov_tmp == NULL) ... else of cov*/
  /* End of cleaning variable cov */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*CHECKSCALAR(len(weights)>=nbsymbols)*/
  } /*if (f2py_success) of nbsymbols*/
  /* End of cleaning variable nbsymbols */
  } /*if (f2py_success) of rf*/
  /* End of cleaning variable rf */
  if((PyObject *)capi_weights_tmp!=weights_capi) {
    Py_XDECREF(capi_weights_tmp); }
  }  /*if (capi_weights_tmp == NULL) ... else of weights*/
  /* End of cleaning variable weights */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************** end of f90_sharpe_ratio **************************/

/**************************** f90_mpt_costfunction ****************************/
static char doc_f2py_rout_fortranmetrics_fortranmetrics_f90_mpt_costfunction[] = "\
mpt_costfunction = f90_mpt_costfunction(weights,r,cov,rf,lamb,v0,[nbsymbols])\n\nWrapper for ``f90_mpt_costfunction``.\
\n\nParameters\n----------\n"
"weights : input rank-1 array('f') with bounds (nbsymbols + 1)\n"
"r : input rank-1 array('f') with bounds (nbsymbols)\n"
"cov : input rank-2 array('f') with bounds (nbsymbols,nbsymbols)\n"
"rf : input float\n"
"lamb : input float\n"
"v0 : input float\n"
"\nOther Parameters\n----------------\n"
"nbsymbols : input int, optional\n    Default: (len(weights)-1)\n"
"\nReturns\n-------\n"
"mpt_costfunction : float";
/* #declfortranroutine# */
static PyObject *f2py_rout_fortranmetrics_fortranmetrics_f90_mpt_costfunction(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,int*,float*,float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float f90_mpt_costfunction = 0;
  int nbsymbols = 0;
  PyObject *nbsymbols_capi = Py_None;
  float *weights = NULL;
  npy_intp weights_Dims[1] = {-1};
  const int weights_Rank = 1;
  PyArrayObject *capi_weights_tmp = NULL;
  int capi_weights_intent = 0;
  PyObject *weights_capi = Py_None;
  float *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  float *cov = NULL;
  npy_intp cov_Dims[2] = {-1, -1};
  const int cov_Rank = 2;
  PyArrayObject *capi_cov_tmp = NULL;
  int capi_cov_intent = 0;
  PyObject *cov_capi = Py_None;
  float rf = 0;
  PyObject *rf_capi = Py_None;
  float lamb = 0;
  PyObject *lamb_capi = Py_None;
  float v0 = 0;
  PyObject *v0_capi = Py_None;
    static char *capi_kwlist[] = {"weights","r","cov","rf","lamb","v0","nbsymbols",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOO|O:fortranmetrics.fortranmetrics.f90_mpt_costfunction",\
        capi_kwlist,&weights_capi,&r_capi,&cov_capi,&rf_capi,&lamb_capi,&v0_capi,&nbsymbols_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable weights */
  ;
  capi_weights_intent |= F2PY_INTENT_IN;
  capi_weights_tmp = array_from_pyobj(NPY_FLOAT,weights_Dims,weights_Rank,capi_weights_intent,weights_capi);
  if (capi_weights_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranmetrics_error,"failed in converting 1st argument `weights' of fortranmetrics.fortranmetrics.f90_mpt_costfunction to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    weights = (float *)(PyArray_DATA(capi_weights_tmp));

  /* Processing variable rf */
    f2py_success = float_from_pyobj(&rf,rf_capi,"fortranmetrics.fortranmetrics.f90_mpt_costfunction() 4th argument (rf) can't be converted to float");
  if (f2py_success) {
  /* Processing variable lamb */
    f2py_success = float_from_pyobj(&lamb,lamb_capi,"fortranmetrics.fortranmetrics.f90_mpt_costfunction() 5th argument (lamb) can't be converted to float");
  if (f2py_success) {
  /* Processing variable v0 */
    f2py_success = float_from_pyobj(&v0,v0_capi,"fortranmetrics.fortranmetrics.f90_mpt_costfunction() 6th argument (v0) can't be converted to float");
  if (f2py_success) {
  /* Processing variable nbsymbols */
  if (nbsymbols_capi == Py_None) nbsymbols = (len(weights)-1); else
    f2py_success = int_from_pyobj(&nbsymbols,nbsymbols_capi,"fortranmetrics.fortranmetrics.f90_mpt_costfunction() 1st keyword (nbsymbols) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(weights)-1)>=nbsymbols,"(len(weights)-1)>=nbsymbols","1st keyword nbsymbols","f90_mpt_costfunction:nbsymbols=%d",nbsymbols) {
  /* Processing variable r */
  r_Dims[0]=nbsymbols;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_FLOAT,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranmetrics_error,"failed in converting 2nd argument `r' of fortranmetrics.fortranmetrics.f90_mpt_costfunction to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    r = (float *)(PyArray_DATA(capi_r_tmp));

  /* Processing variable cov */
  cov_Dims[0]=nbsymbols,cov_Dims[1]=nbsymbols;
  capi_cov_intent |= F2PY_INTENT_IN;
  capi_cov_tmp = array_from_pyobj(NPY_FLOAT,cov_Dims,cov_Rank,capi_cov_intent,cov_capi);
  if (capi_cov_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranmetrics_error,"failed in converting 3rd argument `cov' of fortranmetrics.fortranmetrics.f90_mpt_costfunction to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cov = (float *)(PyArray_DATA(capi_cov_tmp));

  /* Processing variable f90_mpt_costfunction */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&f90_mpt_costfunction,&nbsymbols,weights,r,cov,&rf,&lamb,&v0);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("f",f90_mpt_costfunction);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable f90_mpt_costfunction */
  if((PyObject *)capi_cov_tmp!=cov_capi) {
    Py_XDECREF(capi_cov_tmp); }
  }  /*if (capi_cov_tmp == NULL) ... else of cov*/
  /* End of cleaning variable cov */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*CHECKSCALAR((len(weights)-1)>=nbsymbols)*/
  } /*if (f2py_success) of nbsymbols*/
  /* End of cleaning variable nbsymbols */
  } /*if (f2py_success) of v0*/
  /* End of cleaning variable v0 */
  } /*if (f2py_success) of lamb*/
  /* End of cleaning variable lamb */
  } /*if (f2py_success) of rf*/
  /* End of cleaning variable rf */
  if((PyObject *)capi_weights_tmp!=weights_capi) {
    Py_XDECREF(capi_weights_tmp); }
  }  /*if (capi_weights_tmp == NULL) ... else of weights*/
  /* End of cleaning variable weights */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/************************ end of f90_mpt_costfunction ************************/

/************************ f90_mpt_entropy_costfunction ************************/
static char doc_f2py_rout_fortranmetrics_fortranmetrics_f90_mpt_entropy_costfunction[] = "\
mpt_entropy_costfunction = f90_mpt_entropy_costfunction(weights,r,cov,rf,lamb0,lamb1,v,[nbsymbols])\n\nWrapper for ``f90_mpt_entropy_costfunction``.\
\n\nParameters\n----------\n"
"weights : input rank-1 array('f') with bounds (nbsymbols + 1)\n"
"r : input rank-1 array('f') with bounds (nbsymbols)\n"
"cov : input rank-2 array('f') with bounds (nbsymbols,nbsymbols)\n"
"rf : input float\n"
"lamb0 : input float\n"
"lamb1 : input float\n"
"v : input float\n"
"\nOther Parameters\n----------------\n"
"nbsymbols : input int, optional\n    Default: (len(weights)-1)\n"
"\nReturns\n-------\n"
"mpt_entropy_costfunction : float";
/* #declfortranroutine# */
static PyObject *f2py_rout_fortranmetrics_fortranmetrics_f90_mpt_entropy_costfunction(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,int*,float*,float*,float*,float*,float*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float f90_mpt_entropy_costfunction = 0;
  int nbsymbols = 0;
  PyObject *nbsymbols_capi = Py_None;
  float *weights = NULL;
  npy_intp weights_Dims[1] = {-1};
  const int weights_Rank = 1;
  PyArrayObject *capi_weights_tmp = NULL;
  int capi_weights_intent = 0;
  PyObject *weights_capi = Py_None;
  float *r = NULL;
  npy_intp r_Dims[1] = {-1};
  const int r_Rank = 1;
  PyArrayObject *capi_r_tmp = NULL;
  int capi_r_intent = 0;
  PyObject *r_capi = Py_None;
  float *cov = NULL;
  npy_intp cov_Dims[2] = {-1, -1};
  const int cov_Rank = 2;
  PyArrayObject *capi_cov_tmp = NULL;
  int capi_cov_intent = 0;
  PyObject *cov_capi = Py_None;
  float rf = 0;
  PyObject *rf_capi = Py_None;
  float lamb0 = 0;
  PyObject *lamb0_capi = Py_None;
  float lamb1 = 0;
  PyObject *lamb1_capi = Py_None;
  float v = 0;
  PyObject *v_capi = Py_None;
    static char *capi_kwlist[] = {"weights","r","cov","rf","lamb0","lamb1","v","nbsymbols",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OOOOOOO|O:fortranmetrics.fortranmetrics.f90_mpt_entropy_costfunction",\
        capi_kwlist,&weights_capi,&r_capi,&cov_capi,&rf_capi,&lamb0_capi,&lamb1_capi,&v_capi,&nbsymbols_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable weights */
  ;
  capi_weights_intent |= F2PY_INTENT_IN;
  capi_weights_tmp = array_from_pyobj(NPY_FLOAT,weights_Dims,weights_Rank,capi_weights_intent,weights_capi);
  if (capi_weights_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranmetrics_error,"failed in converting 1st argument `weights' of fortranmetrics.fortranmetrics.f90_mpt_entropy_costfunction to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    weights = (float *)(PyArray_DATA(capi_weights_tmp));

  /* Processing variable rf */
    f2py_success = float_from_pyobj(&rf,rf_capi,"fortranmetrics.fortranmetrics.f90_mpt_entropy_costfunction() 4th argument (rf) can't be converted to float");
  if (f2py_success) {
  /* Processing variable lamb0 */
    f2py_success = float_from_pyobj(&lamb0,lamb0_capi,"fortranmetrics.fortranmetrics.f90_mpt_entropy_costfunction() 5th argument (lamb0) can't be converted to float");
  if (f2py_success) {
  /* Processing variable lamb1 */
    f2py_success = float_from_pyobj(&lamb1,lamb1_capi,"fortranmetrics.fortranmetrics.f90_mpt_entropy_costfunction() 6th argument (lamb1) can't be converted to float");
  if (f2py_success) {
  /* Processing variable v */
    f2py_success = float_from_pyobj(&v,v_capi,"fortranmetrics.fortranmetrics.f90_mpt_entropy_costfunction() 7th argument (v) can't be converted to float");
  if (f2py_success) {
  /* Processing variable nbsymbols */
  if (nbsymbols_capi == Py_None) nbsymbols = (len(weights)-1); else
    f2py_success = int_from_pyobj(&nbsymbols,nbsymbols_capi,"fortranmetrics.fortranmetrics.f90_mpt_entropy_costfunction() 1st keyword (nbsymbols) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR((len(weights)-1)>=nbsymbols,"(len(weights)-1)>=nbsymbols","1st keyword nbsymbols","f90_mpt_entropy_costfunction:nbsymbols=%d",nbsymbols) {
  /* Processing variable r */
  r_Dims[0]=nbsymbols;
  capi_r_intent |= F2PY_INTENT_IN;
  capi_r_tmp = array_from_pyobj(NPY_FLOAT,r_Dims,r_Rank,capi_r_intent,r_capi);
  if (capi_r_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranmetrics_error,"failed in converting 2nd argument `r' of fortranmetrics.fortranmetrics.f90_mpt_entropy_costfunction to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    r = (float *)(PyArray_DATA(capi_r_tmp));

  /* Processing variable cov */
  cov_Dims[0]=nbsymbols,cov_Dims[1]=nbsymbols;
  capi_cov_intent |= F2PY_INTENT_IN;
  capi_cov_tmp = array_from_pyobj(NPY_FLOAT,cov_Dims,cov_Rank,capi_cov_intent,cov_capi);
  if (capi_cov_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranmetrics_error,"failed in converting 3rd argument `cov' of fortranmetrics.fortranmetrics.f90_mpt_entropy_costfunction to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    cov = (float *)(PyArray_DATA(capi_cov_tmp));

  /* Processing variable f90_mpt_entropy_costfunction */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(&f90_mpt_entropy_costfunction,&nbsymbols,weights,r,cov,&rf,&lamb0,&lamb1,&v);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("f",f90_mpt_entropy_costfunction);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable f90_mpt_entropy_costfunction */
  if((PyObject *)capi_cov_tmp!=cov_capi) {
    Py_XDECREF(capi_cov_tmp); }
  }  /*if (capi_cov_tmp == NULL) ... else of cov*/
  /* End of cleaning variable cov */
  if((PyObject *)capi_r_tmp!=r_capi) {
    Py_XDECREF(capi_r_tmp); }
  }  /*if (capi_r_tmp == NULL) ... else of r*/
  /* End of cleaning variable r */
  } /*CHECKSCALAR((len(weights)-1)>=nbsymbols)*/
  } /*if (f2py_success) of nbsymbols*/
  /* End of cleaning variable nbsymbols */
  } /*if (f2py_success) of v*/
  /* End of cleaning variable v */
  } /*if (f2py_success) of lamb1*/
  /* End of cleaning variable lamb1 */
  } /*if (f2py_success) of lamb0*/
  /* End of cleaning variable lamb0 */
  } /*if (f2py_success) of rf*/
  /* End of cleaning variable rf */
  if((PyObject *)capi_weights_tmp!=weights_capi) {
    Py_XDECREF(capi_weights_tmp); }
  }  /*if (capi_weights_tmp == NULL) ... else of weights*/
  /* End of cleaning variable weights */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/******************** end of f90_mpt_entropy_costfunction ********************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/

static FortranDataDef f2py_fortranmetrics_def[] = {
  {"f90_sharpe_ratio",-1,{{-1}},0,NULL,(void *)f2py_rout_fortranmetrics_fortranmetrics_f90_sharpe_ratio,doc_f2py_rout_fortranmetrics_fortranmetrics_f90_sharpe_ratio},
  {"f90_mpt_costfunction",-1,{{-1}},0,NULL,(void *)f2py_rout_fortranmetrics_fortranmetrics_f90_mpt_costfunction,doc_f2py_rout_fortranmetrics_fortranmetrics_f90_mpt_costfunction},
  {"f90_mpt_entropy_costfunction",-1,{{-1}},0,NULL,(void *)f2py_rout_fortranmetrics_fortranmetrics_f90_mpt_entropy_costfunction,doc_f2py_rout_fortranmetrics_fortranmetrics_f90_mpt_entropy_costfunction},
  {NULL}
};

static void f2py_setup_fortranmetrics(char *f90_sharpe_ratio,char *f90_mpt_costfunction,char *f90_mpt_entropy_costfunction) {
  int i_f2py=0;
  f2py_fortranmetrics_def[i_f2py++].data = f90_sharpe_ratio;
  f2py_fortranmetrics_def[i_f2py++].data = f90_mpt_costfunction;
  f2py_fortranmetrics_def[i_f2py++].data = f90_mpt_entropy_costfunction;
}
extern void F_FUNC(f2pyinitfortranmetrics,F2PYINITFORTRANMETRICS)(void (*)(char *,char *,char *));
static void f2py_init_fortranmetrics(void) {
  F_FUNC(f2pyinitfortranmetrics,F2PYINITFORTRANMETRICS)(f2py_setup_fortranmetrics);
}

/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "fortranmetrics",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit_fortranmetrics(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = fortranmetrics_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module fortranmetrics (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyUnicode_FromString("1.20.3");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module 'fortranmetrics' is auto-generated with f2py (version:1.20.3).\nFunctions:\n"
"Fortran 90/95 modules:\n""  fortranmetrics --- f90_sharpe_ratio(),f90_mpt_costfunction(),f90_mpt_entropy_costfunction()"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString("1.20.3");
  PyDict_SetItemString(d, "__f2py_numpy_version__", s);
  Py_DECREF(s);
  fortranmetrics_error = PyErr_NewException ("fortranmetrics.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "_fortranmetrics_error", fortranmetrics_error);
  Py_DECREF(fortranmetrics_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }



/*eof initf2pywraphooks*/
  PyDict_SetItemString(d, "fortranmetrics", PyFortranObject_New(f2py_fortranmetrics_def,f2py_init_fortranmetrics));
/*eof initf90modhooks*/

/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"fortranmetrics");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
