/* File: fortranfitmodule.c
 * This file is auto-generated with f2py (version:1.20.3).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * Generation date: Tue Sep 28 00:21:00 2021
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *fortranfit_error;
static PyObject *fortranfit_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
/*need_typedefs*/

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#define CHECKSCALAR(check,tcheck,name,show,var)\
    if (!(check)) {\
        char errstring[256];\
        sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
        PyErr_SetString(fortranfit_error,errstring);\
        /*goto capi_fail;*/\
    } else 
#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
    PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
    fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif


/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int
int_from_pyobj(int* v, PyObject *obj, const char *errmess)
{
    PyObject* tmp = NULL;

    if (PyLong_Check(obj)) {
        *v = Npy__PyLong_AsInt(obj);
        return !(*v == -1 && PyErr_Occurred());
    }

    tmp = PyNumber_Long(obj);
    if (tmp) {
        *v = Npy__PyLong_AsInt(tmp);
        Py_DECREF(tmp);
        return !(*v == -1 && PyErr_Occurred());
    }

    if (PyComplex_Check(obj))
        tmp = PyObject_GetAttrString(obj,"real");
    else if (PyBytes_Check(obj) || PyUnicode_Check(obj))
        /*pass*/;
    else if (PySequence_Check(obj))
        tmp = PySequence_GetItem(obj, 0);
    if (tmp) {
        PyErr_Clear();
        if (int_from_pyobj(v, tmp, errmess)) {
            Py_DECREF(tmp);
            return 1;
        }
        Py_DECREF(tmp);
    }
    {
        PyObject* err = PyErr_Occurred();
        if (err == NULL) {
            err = fortranfit_error;
        }
        PyErr_SetString(err, errmess);
    }
    return 0;
}


/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/********************** f90_fit_blackscholesmerton_model **********************/
static char doc_f2py_rout_fortranfit_fortranfit_f90_fit_blackscholesmerton_model[] = "\
rsigma_tuple = f90_fit_blackscholesmerton_model(ts,prices,[nbpts])\n\nWrapper for ``f90_fit_blackscholesmerton_model``.\
\n\nParameters\n----------\n"
"ts : input rank-1 array('f') with bounds (nbpts)\n"
"prices : input rank-1 array('f') with bounds (nbpts)\n"
"\nOther Parameters\n----------------\n"
"nbpts : input int, optional\n    Default: len(ts)\n"
"\nReturns\n-------\n"
"rsigma_tuple : rank-1 array('f') with bounds (2) and f90_fit_blackscholesmerton_model storage";
/* #declfortranroutine# */
static PyObject *f2py_rout_fortranfit_fortranfit_f90_fit_blackscholesmerton_model(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(float*,int*,float*,float*)) {
    PyObject * volatile capi_buildvalue = NULL;
    volatile int f2py_success = 1;
/*decl*/

  float *f90_fit_blackscholesmerton_model = NULL;
  npy_intp f90_fit_blackscholesmerton_model_Dims[1] = {-1};
  const int f90_fit_blackscholesmerton_model_Rank = 1;
  PyArrayObject *capi_f90_fit_blackscholesmerton_model_tmp = NULL;
  int capi_f90_fit_blackscholesmerton_model_intent = 0;
  int nbpts = 0;
  PyObject *nbpts_capi = Py_None;
  float *ts = NULL;
  npy_intp ts_Dims[1] = {-1};
  const int ts_Rank = 1;
  PyArrayObject *capi_ts_tmp = NULL;
  int capi_ts_intent = 0;
  PyObject *ts_capi = Py_None;
  float *prices = NULL;
  npy_intp prices_Dims[1] = {-1};
  const int prices_Rank = 1;
  PyArrayObject *capi_prices_tmp = NULL;
  int capi_prices_intent = 0;
  PyObject *prices_capi = Py_None;
    static char *capi_kwlist[] = {"ts","prices","nbpts",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
    if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
        "OO|O:fortranfit.fortranfit.f90_fit_blackscholesmerton_model",\
        capi_kwlist,&ts_capi,&prices_capi,&nbpts_capi))
        return NULL;
/*frompyobj*/
  /* Processing variable ts */
  ;
  capi_ts_intent |= F2PY_INTENT_IN;
  capi_ts_tmp = array_from_pyobj(NPY_FLOAT,ts_Dims,ts_Rank,capi_ts_intent,ts_capi);
  if (capi_ts_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranfit_error,"failed in converting 1st argument `ts' of fortranfit.fortranfit.f90_fit_blackscholesmerton_model to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    ts = (float *)(PyArray_DATA(capi_ts_tmp));

  /* Processing variable nbpts */
  if (nbpts_capi == Py_None) nbpts = len(ts); else
    f2py_success = int_from_pyobj(&nbpts,nbpts_capi,"fortranfit.fortranfit.f90_fit_blackscholesmerton_model() 1st keyword (nbpts) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(ts)>=nbpts,"len(ts)>=nbpts","1st keyword nbpts","f90_fit_blackscholesmerton_model:nbpts=%d",nbpts) {
  /* Processing variable prices */
  prices_Dims[0]=nbpts;
  capi_prices_intent |= F2PY_INTENT_IN;
  capi_prices_tmp = array_from_pyobj(NPY_FLOAT,prices_Dims,prices_Rank,capi_prices_intent,prices_capi);
  if (capi_prices_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranfit_error,"failed in converting 2nd argument `prices' of fortranfit.fortranfit.f90_fit_blackscholesmerton_model to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    prices = (float *)(PyArray_DATA(capi_prices_tmp));

  /* Processing variable f90_fit_blackscholesmerton_model */
  f90_fit_blackscholesmerton_model_Dims[0]=2;
  capi_f90_fit_blackscholesmerton_model_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_f90_fit_blackscholesmerton_model_tmp = array_from_pyobj(NPY_FLOAT,f90_fit_blackscholesmerton_model_Dims,f90_fit_blackscholesmerton_model_Rank,capi_f90_fit_blackscholesmerton_model_intent,Py_None);
  if (capi_f90_fit_blackscholesmerton_model_tmp == NULL) {
    PyObject *exc, *val, *tb;
    PyErr_Fetch(&exc, &val, &tb);
    PyErr_SetString(exc ? exc : fortranfit_error,"failed in converting hidden `f90_fit_blackscholesmerton_model' of fortranfit.fortranfit.f90_fit_blackscholesmerton_model to C/Fortran array" );
    npy_PyErr_ChainExceptionsCause(exc, val, tb);
  } else {
    f90_fit_blackscholesmerton_model = (float *)(PyArray_DATA(capi_f90_fit_blackscholesmerton_model_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
  (*f2py_func)(f90_fit_blackscholesmerton_model,&nbpts,ts,prices);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
        if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
        CFUNCSMESS("Building return value.\n");
        capi_buildvalue = Py_BuildValue("N",capi_f90_fit_blackscholesmerton_model_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
        } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_f90_fit_blackscholesmerton_model_tmp == NULL) ... else of f90_fit_blackscholesmerton_model*/
  /* End of cleaning variable f90_fit_blackscholesmerton_model */
  if((PyObject *)capi_prices_tmp!=prices_capi) {
    Py_XDECREF(capi_prices_tmp); }
  }  /*if (capi_prices_tmp == NULL) ... else of prices*/
  /* End of cleaning variable prices */
  } /*CHECKSCALAR(len(ts)>=nbpts)*/
  } /*if (f2py_success) of nbpts*/
  /* End of cleaning variable nbpts */
  if((PyObject *)capi_ts_tmp!=ts_capi) {
    Py_XDECREF(capi_ts_tmp); }
  }  /*if (capi_ts_tmp == NULL) ... else of ts*/
  /* End of cleaning variable ts */
/*end of cleanupfrompyobj*/
    if (capi_buildvalue == NULL) {
/*routdebugfailure*/
    } else {
/*routdebugleave*/
    }
    CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
    return capi_buildvalue;
}
/****************** end of f90_fit_blackscholesmerton_model ******************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/

static FortranDataDef f2py_fortranfit_def[] = {
  {"f90_fit_blackscholesmerton_model",-1,{{-1}},0,NULL,(void *)f2py_rout_fortranfit_fortranfit_f90_fit_blackscholesmerton_model,doc_f2py_rout_fortranfit_fortranfit_f90_fit_blackscholesmerton_model},
  {NULL}
};

static void f2py_setup_fortranfit(char *f90_fit_blackscholesmerton_model) {
  int i_f2py=0;
  f2py_fortranfit_def[i_f2py++].data = f90_fit_blackscholesmerton_model;
}
extern void F_FUNC(f2pyinitfortranfit,F2PYINITFORTRANFIT)(void (*)(char *));
static void f2py_init_fortranfit(void) {
  F_FUNC(f2pyinitfortranfit,F2PYINITFORTRANFIT)(f2py_setup_fortranfit);
}

/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "fortranfit",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};

PyMODINIT_FUNC PyInit_fortranfit(void) {
  int i;
  PyObject *m,*d, *s, *tmp;
  m = fortranfit_module = PyModule_Create(&moduledef);
  Py_SET_TYPE(&PyFortran_Type, &PyType_Type);
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module fortranfit (failed to import numpy)"); return m;}
  d = PyModule_GetDict(m);
  s = PyUnicode_FromString("1.20.3");
  PyDict_SetItemString(d, "__version__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString(
    "This module 'fortranfit' is auto-generated with f2py (version:1.20.3).\nFunctions:\n"
"Fortran 90/95 modules:\n""  fortranfit --- f90_fit_blackscholesmerton_model()"".");
  PyDict_SetItemString(d, "__doc__", s);
  Py_DECREF(s);
  s = PyUnicode_FromString("1.20.3");
  PyDict_SetItemString(d, "__f2py_numpy_version__", s);
  Py_DECREF(s);
  fortranfit_error = PyErr_NewException ("fortranfit.error", NULL, NULL);
  /*
   * Store the error object inside the dict, so that it could get deallocated.
   * (in practice, this is a module, so it likely will not and cannot.)
   */
  PyDict_SetItemString(d, "_fortranfit_error", fortranfit_error);
  Py_DECREF(fortranfit_error);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++) {
    tmp = PyFortranObject_NewAsAttr(&f2py_routine_defs[i]);
    PyDict_SetItemString(d, f2py_routine_defs[i].name, tmp);
    Py_DECREF(tmp);
  }

/*eof initf2pywraphooks*/
  PyDict_SetItemString(d, "fortranfit", PyFortranObject_New(f2py_fortranfit_def,f2py_init_fortranfit));
/*eof initf90modhooks*/

/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"fortranfit");
#endif
  return m;
}
#ifdef __cplusplus
}
#endif
