# c_long flidev_t
# An opaque handle used by library functions to refer to FLI hardware.
FLI_INVALID_DEVICE = -1

FLIDOMAIN_NONE = 0x00
FLIDOMAIN_PARALLEL_PORT = 0x01
FLIDOMAIN_USB = 0x02
FLIDOMAIN_SERIAL = 0x03
FLIDOMAIN_INET = 0x04
FLIDOMAIN_SERIAL_19200 = 0x05
FLIDOMAIN_SERIAL_1200 = 0x06

FLIDEVICE_NONE = 0x000
FLIDEVICE_CAMERA = 0x100
FLIDEVICE_FILTERWHEEL = 0x200
FLIDEVICE_FOCUSER = 0x300
FLIDEVICE_HS_FILTERWHEEL = 0x0400
FLIDEVICE_RAW = 0x0f00
FLIDEVICE_ENUMERATE_BY_CONNECTION = 0x8000

# c_long fliframe_t
# The frame type for an FLI CCD camera device.  Valid frame types are
# FLI_FRAME_TYPE_NORMAL and FLI_FRAME_TYPE_DARK.
FLI_FRAME_TYPE_NORMAL = 0x0
FLI_FRAME_TYPE_DARK = 0x1
FLI_FRAME_TYPE_FLOOD = 0x2
FLI_FRAME_TYPE_RBI_FLUSH = FLI_FRAME_TYPE_FLOOD | FLI_FRAME_TYPE_DARK

# c_long flibitdepth_t
# The gray-scale bit depth for an FLI camera device.  Valid bit depths are
# FLI_MODE_8BIT and FLI_MODE_16BIT.
FLI_MODE_8BIT = 0x0
FLI_MODE_16BIT = 0x1

# c_long flishutter_t
# Type used for shutter operations for an FLI camera device.  Valid shutter
# types are FLI_SHUTTER_CLOSE, FLI_SHUTTER_OPEN, FLI_SHUTTER_EXTERNAL_TRIGGER,
# FLI_SHUTTER_EXTERNAL_TRIGGER_LOW, and FLI_SHUTTER_EXTERNAL_TRIGGER_HIGH.
FLI_SHUTTER_CLOSE = 0x0000
FLI_SHUTTER_OPEN = 0x0001
FLI_SHUTTER_EXTERNAL_TRIGGER = 0x0002
FLI_SHUTTER_EXTERNAL_TRIGGER_LOW = 0x0002
FLI_SHUTTER_EXTERNAL_TRIGGER_HIGH = 0x0004
FLI_SHUTTER_EXTERNAL_EXPOSURE_CONTROL = 0x0008

# c_long flibgflush_t
# Type used for background flush operations for an FLI camera device.  Valid
# bgflush types are FLI_BGFLUSH_STOP and FLI_BGFLUSH_START.
FLI_BGFLUSH_STOP = 0x0000
FLI_BGFLUSH_START = 0x0001

# c_long flichannel_t
# Type used to determine which temperature channel to read.  Valid channel
# types are FLI_TEMPERATURE_INTERNAL and FLI_TEMPERATURE_EXTERNAL.
FLI_TEMPERATURE_INTERNAL = 0x0000
FLI_TEMPERATURE_EXTERNAL = 0x0001
FLI_TEMPERATURE_CCD = 0x0000
FLI_TEMPERATURE_BASE = 0x0001

# c_long flidebug_t
# Type specifying library debug levels.  Valid debug levels are FLIDEBUG_NONE,
# FLIDEBUG_INFO, FLIDEBUG_WARN, and FLIDEBUG_FAIL.
FLIDEBUG_NONE = 0x00
FLIDEBUG_INFO = 0x01
FLIDEBUG_WARN = 0x02
FLIDEBUG_FAIL = 0x04
FLIDEBUG_IO = 0x08
FLIDEBUG_ALL = FLIDEBUG_INFO | FLIDEBUG_WARN | FLIDEBUG_FAIL

# c_long flimode_t

# c_long flistatus_t
# Status settings
FLI_CAMERA_STATUS_UNKNOWN = 0xffffffff
FLI_CAMERA_STATUS_MASK = 0x00000003
FLI_CAMERA_STATUS_IDLE = 0x00
FLI_CAMERA_STATUS_WAITING_FOR_TRIGGER = 0x01
FLI_CAMERA_STATUS_EXPOSING = 0x02
FLI_CAMERA_STATUS_READING_CCD = 0x03
FLI_CAMERA_DATA_READY = 0x80000000

FLI_FOCUSER_STATUS_UNKNOWN = 0xffffffff
FLI_FOCUSER_STATUS_HOMING = 0x00000004
FLI_FOCUSER_STATUS_MOVING_IN = 0x00000001
FLI_FOCUSER_STATUS_MOVING_OUT = 0x00000002
FLI_FOCUSER_STATUS_MOVING_MASK = 0x00000007
FLI_FOCUSER_STATUS_HOME = 0x00000080
FLI_FOCUSER_STATUS_LIMIT = 0x00000040
FLI_FOCUSER_STATUS_LEGACY = 0x10000000

FLI_FILTER_WHEEL_PHYSICAL = 0x100
FLI_FILTER_WHEEL_VIRTUAL = 0
FLI_FILTER_WHEEL_LEFT = FLI_FILTER_WHEEL_PHYSICAL | 0x00
FLI_FILTER_WHEEL_RIGHT = FLI_FILTER_WHEEL_PHYSICAL | 0x01
FLI_FILTER_STATUS_MOVING_CCW = 0x01
FLI_FILTER_STATUS_MOVING_CW = 0x02
FLI_FILTER_POSITION_UNKNOWN = 0xff
FLI_FILTER_POSITION_CURRENT = 0x200
FLI_FILTER_STATUS_HOMING = 0x00000004
FLI_FILTER_STATUS_HOME = 0x00000080
FLI_FILTER_STATUS_HOME_LEFT = 0x00000080
FLI_FILTER_STATUS_HOME_RIGHT = 0x00000040
FLI_FILTER_STATUS_HOME_SUCCEEDED = 0x00000008

# c_long flitdirate_t
# c_long flitdiflags_t

FLI_IO_P0 = 0x01
FLI_IO_P1 = 0x02
FLI_IO_P2 = 0x04
FLI_IO_P3 = 0x08

FLI_FAN_SPEED_OFF = 0x00
FLI_FAN_SPEED_ON = 0xffffffff

FLI_EEPROM_USER = 0x00
FLI_EEPROM_PIXEL_MAP = 0x01

FLI_PIXEL_DEFECT_COLUMN = 0x00
FLI_PIXEL_DEFECT_CLUSTER = 0x10
FLI_PIXEL_DEFECT_POINT_BRIGHT = 0x20
FLI_PIXEL_DEFECT_POINT_DARK = 0x30
