# coding: utf-8

# flake8: noqa
"""
    OriginStamp API Documentation

    The following documentation describes the API v3 for OriginStamp. OriginStamp is a trusted timestamping service that uses the decentralized blockchain to store anonymous, tamper-proof timestamps for any digital content. OriginStamp allows users to timestamp files, emails, or plain text, and subsequently store the created hashes in the blockchain as well as retrieve and verify timetamps that have been committed to the blockchain.The trusted timestamping service of OriginStamp allows you to generate a hash fingerprint and prove that it was created at a specific point in time. If you are interested in integrating trusted timestamping into your own project, feel free to use our provided API. The following interactive documentation describes the interfaces and supports your integration. With this documentation you are able to try out the different requests and see the responses. For the authorization, add your API key to the Authorization header of your request.<br/><h2>Timestamping Steps</h2><ol><li><strong>Determine Hash: </strong> Calculate the SHA-256 of your record using a cryptographic library.</li><li><strong>Create Timestamp: </strong>Create a timestamp and add meta information to index it, e.g. a comment. You can also request a notification (email or webhook) once the tamper-proof timestamp has been created.</li><li><strong>Archive original file: </strong>Since we have no access to your original data, you should archive it because the timestamp is only valid in combination with the original file.</li><li><strong>Check Timestamp Status: </strong>Since the timestamps are always transmitted to the blockchain network at certain times, i.e. there is a delay, you can check the status of a hash and thus get the timestamp information.</li><li><strong>Get Timestamp Proof: </strong>As soon as the tamper-proof timestamp has been generated, you should archive the proof (Merkle Tree), which we created in our open procedure, together with the original file. With this proof, the existence of the file can be verified independently of OriginStamp. Here you can choose if the raw proof (xml) is sufficient proof or if you want to have a certificate (pdf).</li></ol><br/><h2>Installation Notes</h2><ul><li>Make sure you set the Authorization header correctly using your API key.</li><li>If a Cloudflare error occurs, please set a custom UserAgent header.</li><li>Please have a look at the models below to find out what each field means.</li></ul>  # noqa: E501

    OpenAPI spec version: 3.0
    Contact: mail@originstamp.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

# import models into model package
from originstamp_client.models.currency_model import CurrencyModel
from originstamp_client.models.default_of_download_link_response import DefaultOfDownloadLinkResponse
from originstamp_client.models.default_of_list_of_currency_model import DefaultOfListOfCurrencyModel
from originstamp_client.models.default_of_timestamp_data import DefaultOfTimestampData
from originstamp_client.models.default_of_timestamp_response import DefaultOfTimestampResponse
from originstamp_client.models.default_of_void import DefaultOfVoid
from originstamp_client.models.default_of_webhook_response import DefaultOfWebhookResponse
from originstamp_client.models.default_ofstring import DefaultOfstring
from originstamp_client.models.default_usage_response import DefaultUsageResponse
from originstamp_client.models.download_link_response import DownloadLinkResponse
from originstamp_client.models.manual_webhook_request import ManualWebhookRequest
from originstamp_client.models.notification import Notification
from originstamp_client.models.proof_request import ProofRequest
from originstamp_client.models.timestamp_bulk_request import TimestampBulkRequest
from originstamp_client.models.timestamp_data import TimestampData
from originstamp_client.models.timestamp_request import TimestampRequest
from originstamp_client.models.timestamp_response import TimestampResponse
from originstamp_client.models.usage_response import UsageResponse
from originstamp_client.models.webhook_request import WebhookRequest
from originstamp_client.models.webhook_response import WebhookResponse
