# coding: utf-8

"""
    OriginStamp Client

    OpenAPI spec version: 3.0
    OriginStamp Documentation: https://docs.originstamp.com
    Contact: mail@originstamp.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from originstamp_client.api_client import ApiClient


class WebhookApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_webhook_status(self, authorization, webhook_request, **kwargs):  # noqa: E501
        """Webhook  # noqa: E501

        RESTful interface to receive the status of a webhook. Based on the input parameters (target URL, hash and currency), we look up the most recent entry in the notification queue.This method is intended to support the webhook integration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook_status(authorization, webhook_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param WebhookRequest webhook_request: DTO for registering webhook information. (required)
        :return: DefaultOfWebhookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_webhook_status_with_http_info(authorization, webhook_request, **kwargs)  # noqa: E501
        else:
            (data) = self.get_webhook_status_with_http_info(authorization, webhook_request, **kwargs)  # noqa: E501
            return data

    def get_webhook_status_with_http_info(self, authorization, webhook_request, **kwargs):  # noqa: E501
        """Webhook  # noqa: E501

        RESTful interface to receive the status of a webhook. Based on the input parameters (target URL, hash and currency), we look up the most recent entry in the notification queue.This method is intended to support the webhook integration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook_status_with_http_info(authorization, webhook_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param WebhookRequest webhook_request: DTO for registering webhook information. (required)
        :return: DefaultOfWebhookResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'webhook_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhook_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `get_webhook_status`")  # noqa: E501
        # verify the required parameter 'webhook_request' is set
        if ('webhook_request' not in params or
                params['webhook_request'] is None):
            raise ValueError("Missing the required parameter `webhook_request` when calling `get_webhook_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'webhook_request' in params:
            body_params = params['webhook_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API Key Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v3/webhook/information', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DefaultOfWebhookResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_webhook_notification(self, authorization, webhook_request, **kwargs):  # noqa: E501
        """Webhook  # noqa: E501

        Method which allows a subscription for a webhook notification. If this method is called, a new entry is added to notification queue that is triggered as soon as a tamper-proof timestamp or the hash is created. An empty data payload means that the entry was created successfully.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_webhook_notification(authorization, webhook_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param WebhookRequest webhook_request: DTO for querying webhook information. (required)
        :return: DefaultOfVoid
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_webhook_notification_with_http_info(authorization, webhook_request, **kwargs)  # noqa: E501
        else:
            (data) = self.register_webhook_notification_with_http_info(authorization, webhook_request, **kwargs)  # noqa: E501
            return data

    def register_webhook_notification_with_http_info(self, authorization, webhook_request, **kwargs):  # noqa: E501
        """Webhook  # noqa: E501

        Method which allows a subscription for a webhook notification. If this method is called, a new entry is added to notification queue that is triggered as soon as a tamper-proof timestamp or the hash is created. An empty data payload means that the entry was created successfully.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_webhook_notification_with_http_info(authorization, webhook_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param WebhookRequest webhook_request: DTO for querying webhook information. (required)
        :return: DefaultOfVoid
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'webhook_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_webhook_notification" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `register_webhook_notification`")  # noqa: E501
        # verify the required parameter 'webhook_request' is set
        if ('webhook_request' not in params or
                params['webhook_request'] is None):
            raise ValueError("Missing the required parameter `webhook_request` when calling `register_webhook_notification`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'webhook_request' in params:
            body_params = params['webhook_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API Key Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v3/webhook/register', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DefaultOfVoid',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def trigger_timestamp_webhook(self, authorization, manual_webhook_request, **kwargs):  # noqa: E501
        """Dev  # noqa: E501

        With this interface you can trigger manual webhook to see how a webhook looks like. Please use a hash, that was already timestamped before such as https://redir.originstamp.com/hash/9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08 . Usually, the webhook is triggered as soon as the tamper-proof time stamp with the selected crypto currency has been created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trigger_timestamp_webhook(authorization, manual_webhook_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param ManualWebhookRequest manual_webhook_request: DTO for webhook request. (required)
        :return: DefaultOfstring
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.trigger_timestamp_webhook_with_http_info(authorization, manual_webhook_request, **kwargs)  # noqa: E501
        else:
            (data) = self.trigger_timestamp_webhook_with_http_info(authorization, manual_webhook_request, **kwargs)  # noqa: E501
            return data

    def trigger_timestamp_webhook_with_http_info(self, authorization, manual_webhook_request, **kwargs):  # noqa: E501
        """Dev  # noqa: E501

        With this interface you can trigger manual webhook to see how a webhook looks like. Please use a hash, that was already timestamped before such as https://redir.originstamp.com/hash/9f86d081884c7d659a2feaa0c55ad015a3bf4f1b2b0b822cd15d6c15b0f00a08 . Usually, the webhook is triggered as soon as the tamper-proof time stamp with the selected crypto currency has been created.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.trigger_timestamp_webhook_with_http_info(authorization, manual_webhook_request, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param ManualWebhookRequest manual_webhook_request: DTO for webhook request. (required)
        :return: DefaultOfstring
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'manual_webhook_request']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method trigger_timestamp_webhook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `trigger_timestamp_webhook`")  # noqa: E501
        # verify the required parameter 'manual_webhook_request' is set
        if ('manual_webhook_request' not in params or
                params['manual_webhook_request'] is None):
            raise ValueError("Missing the required parameter `manual_webhook_request` when calling `trigger_timestamp_webhook`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'manual_webhook_request' in params:
            body_params = params['manual_webhook_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API Key Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v3/webhook/start', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DefaultOfstring',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
