# coding: utf-8

"""
    OriginStamp Client

    OpenAPI spec version: 3.0
    OriginStamp Documentation: https://docs.originstamp.com
    Contact: mail@originstamp.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from originstamp_client.api_client import ApiClient


class ProofApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_proof(self, authorization, proof_request_url, **kwargs):  # noqa: E501
        """Proof  # noqa: E501

        Generates the download URL for Proof (Seed / Merkle Tree). This interface must be used to obtain the proof or certificate of your tamper-proof timestamp. The parameters are as follows: Cryptocurrency (e.g., Bitcoin, Ethereum,..), type of evidence (e.g., certificate, merkle tree) and the associated hash. The entries are analyzed, e.g., whether a valid timestamp exists for the hash. Then the URL and the filename are returned, with which your proof can be saved. Please note that the download link is only valid for 5 minutes. When using cURL to fetch the proof with the download link make sure to specify \"application/octet-stream\" in the \"Accept\" header.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proof(authorization, proof_request_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param ProofRequest proof_request_url: Information needed to return the proof. (required)
        :return: DefaultOfDownloadLinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_proof_with_http_info(authorization, proof_request_url, **kwargs)  # noqa: E501
        else:
            (data) = self.get_proof_with_http_info(authorization, proof_request_url, **kwargs)  # noqa: E501
            return data

    def get_proof_with_http_info(self, authorization, proof_request_url, **kwargs):  # noqa: E501
        """Proof  # noqa: E501

        Generates the download URL for Proof (Seed / Merkle Tree). This interface must be used to obtain the proof or certificate of your tamper-proof timestamp. The parameters are as follows: Cryptocurrency (e.g., Bitcoin, Ethereum,..), type of evidence (e.g., certificate, merkle tree) and the associated hash. The entries are analyzed, e.g., whether a valid timestamp exists for the hash. Then the URL and the filename are returned, with which your proof can be saved. Please note that the download link is only valid for 5 minutes. When using cURL to fetch the proof with the download link make sure to specify \"application/octet-stream\" in the \"Accept\" header.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_proof_with_http_info(authorization, proof_request_url, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str authorization: A valid API key is essential for authorization to handle the request. (required)
        :param ProofRequest proof_request_url: Information needed to return the proof. (required)
        :return: DefaultOfDownloadLinkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['authorization', 'proof_request_url']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_proof" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'authorization' is set
        if ('authorization' not in params or
                params['authorization'] is None):
            raise ValueError("Missing the required parameter `authorization` when calling `get_proof`")  # noqa: E501
        # verify the required parameter 'proof_request_url' is set
        if ('proof_request_url' not in params or
                params['proof_request_url'] is None):
            raise ValueError("Missing the required parameter `proof_request_url` when calling `get_proof`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'authorization' in params:
            header_params['Authorization'] = params['authorization']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'proof_request_url' in params:
            body_params = params['proof_request_url']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['API Key Authorization']  # noqa: E501

        return self.api_client.call_api(
            '/v3/timestamp/proof/url', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DefaultOfDownloadLinkResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
