# coding: utf-8

"""
UserDevelopmentApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class UserDevelopmentApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_users_development_activities(self, **kwargs):
        """
        Get list of Development Activities
        Either moduleId or userId is required. Results are filtered based on the applicable permissions.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_users_development_activities(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] user_id: Specifies the list of user IDs to be queried, up to 100 user IDs. It searches for any relationship for the userId.
        :param str module_id: Specifies the ID of the learning module.
        :param str interval: Specifies the dateDue range to be queried. Milliseconds will be truncated. A maximum of 1 year can be specified in the range. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param str completion_interval: Specifies the range of completion dates to be used for filtering. A maximum of 1 year can be specified in the range. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param str overdue: Specifies if non-overdue, overdue, or all activities are returned. If not specified, all activities are returned
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_order: Specifies result set sort order sorted by the date due; if not specified, default sort order is descending (Desc)
        :param list[str] types: Specifies the activity types.
        :param list[str] statuses: Specifies the activity statuses to filter by
        :param list[str] relationship: Specifies how the current user relation should be interpreted, and filters the activities returned to only those that have the specified relationship. If not specified, all relationships are returned.
        :return: DevelopmentActivityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'module_id', 'interval', 'completion_interval', 'overdue', 'page_size', 'page_number', 'sort_order', 'types', 'statuses', 'relationship']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_users_development_activities" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/users/development/activities'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'user_id' in params:
            query_params['userId'] = params['user_id']
        if 'module_id' in params:
            query_params['moduleId'] = params['module_id']
        if 'interval' in params:
            query_params['interval'] = params['interval']
        if 'completion_interval' in params:
            query_params['completionInterval'] = params['completion_interval']
        if 'overdue' in params:
            query_params['overdue'] = params['overdue']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'types' in params:
            query_params['types'] = params['types']
        if 'statuses' in params:
            query_params['statuses'] = params['statuses']
        if 'relationship' in params:
            query_params['relationship'] = params['relationship']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DevelopmentActivityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_users_development_activities_me(self, **kwargs):
        """
        Get list of Development Activities for current user
        Results are filtered based on the applicable permissions.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_users_development_activities_me(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str module_id: Specifies the ID of the learning module.
        :param str interval: Specifies the dateDue range to be queried. Milliseconds will be truncated. A maximum of 1 year can be specified in the range. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param str completion_interval: Specifies the range of completion dates to be used for filtering. A maximum of 1 year can be specified in the range. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
        :param str overdue: Specifies if non-overdue, overdue, or all activities are returned. If not specified, all activities are returned
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_order: Specifies result set sort order sorted by the date due; if not specified, default sort order is descending (Desc)
        :param list[str] types: Specifies the activity types.
        :param list[str] statuses: Specifies the activity statuses to filter by
        :param list[str] relationship: Specifies how the current user relation should be interpreted, and filters the activities returned to only those that have the specified relationship. If not specified, all relationships are returned.
        :return: DevelopmentActivityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['module_id', 'interval', 'completion_interval', 'overdue', 'page_size', 'page_number', 'sort_order', 'types', 'statuses', 'relationship']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_users_development_activities_me" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/users/development/activities/me'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'module_id' in params:
            query_params['moduleId'] = params['module_id']
        if 'interval' in params:
            query_params['interval'] = params['interval']
        if 'completion_interval' in params:
            query_params['completionInterval'] = params['completion_interval']
        if 'overdue' in params:
            query_params['overdue'] = params['overdue']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'types' in params:
            query_params['types'] = params['types']
        if 'statuses' in params:
            query_params['statuses'] = params['statuses']
        if 'relationship' in params:
            query_params['relationship'] = params['relationship']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DevelopmentActivityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_users_development_activity(self, activity_id, type, **kwargs):
        """
        Get a Development Activity
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_users_development_activity(activity_id, type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str activity_id: Specifies the activity ID, maps to either assignment or appointment ID (required)
        :param str type: Specifies the activity type. (required)
        :return: DevelopmentActivity
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['activity_id', 'type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_users_development_activity" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'activity_id' is set
        if ('activity_id' not in params) or (params['activity_id'] is None):
            raise ValueError("Missing the required parameter `activity_id` when calling `get_users_development_activity`")
        # verify the required parameter 'type' is set
        if ('type' not in params) or (params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_users_development_activity`")


        resource_path = '/api/v2/users/development/activities/{activityId}'.replace('{format}', 'json')
        path_params = {}
        if 'activity_id' in params:
            path_params['activityId'] = params['activity_id']

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DevelopmentActivity',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_users_development_activities_aggregates_query(self, body, **kwargs):
        """
        Retrieve aggregated development activity data
        Results are filtered based on the applicable permissions.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_users_development_activities_aggregates_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DevelopmentActivityAggregateParam body: Aggregate Request (required)
        :return: DevelopmentActivityAggregateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_users_development_activities_aggregates_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_users_development_activities_aggregates_query`")


        resource_path = '/api/v2/users/development/activities/aggregates/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DevelopmentActivityAggregateResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
