# coding: utf-8

"""
QualityApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class QualityApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_quality_calibration(self, calibration_id, calibrator_id, **kwargs):
        """
        Delete a calibration by id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_quality_calibration(calibration_id, calibrator_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str calibration_id: Calibration ID (required)
        :param str calibrator_id: calibratorId (required)
        :return: Calibration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['calibration_id', 'calibrator_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quality_calibration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'calibration_id' is set
        if ('calibration_id' not in params) or (params['calibration_id'] is None):
            raise ValueError("Missing the required parameter `calibration_id` when calling `delete_quality_calibration`")
        # verify the required parameter 'calibrator_id' is set
        if ('calibrator_id' not in params) or (params['calibrator_id'] is None):
            raise ValueError("Missing the required parameter `calibrator_id` when calling `delete_quality_calibration`")


        resource_path = '/api/v2/quality/calibrations/{calibrationId}'.replace('{format}', 'json')
        path_params = {}
        if 'calibration_id' in params:
            path_params['calibrationId'] = params['calibration_id']

        query_params = {}
        if 'calibrator_id' in params:
            query_params['calibratorId'] = params['calibrator_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Calibration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_quality_conversation_evaluation(self, conversation_id, evaluation_id, **kwargs):
        """
        Delete an evaluation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_quality_conversation_evaluation(conversation_id, evaluation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversationId (required)
        :param str evaluation_id: evaluationId (required)
        :param str expand: evaluatorId
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'evaluation_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quality_conversation_evaluation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `delete_quality_conversation_evaluation`")
        # verify the required parameter 'evaluation_id' is set
        if ('evaluation_id' not in params) or (params['evaluation_id'] is None):
            raise ValueError("Missing the required parameter `evaluation_id` when calling `delete_quality_conversation_evaluation`")


        resource_path = '/api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'evaluation_id' in params:
            path_params['evaluationId'] = params['evaluation_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Evaluation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_quality_form(self, form_id, **kwargs):
        """
        Delete an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_quality_form(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quality_form" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `delete_quality_form`")


        resource_path = '/api/v2/quality/forms/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_quality_forms_evaluation(self, form_id, **kwargs):
        """
        Delete an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_quality_forms_evaluation(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quality_forms_evaluation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `delete_quality_forms_evaluation`")


        resource_path = '/api/v2/quality/forms/evaluations/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_quality_forms_survey(self, form_id, **kwargs):
        """
        Delete a survey form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_quality_forms_survey(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quality_forms_survey" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `delete_quality_forms_survey`")


        resource_path = '/api/v2/quality/forms/surveys/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_quality_keywordset(self, keyword_set_id, **kwargs):
        """
        Delete a keywordSet by id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_quality_keywordset(keyword_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str keyword_set_id: KeywordSet ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['keyword_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quality_keywordset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'keyword_set_id' is set
        if ('keyword_set_id' not in params) or (params['keyword_set_id'] is None):
            raise ValueError("Missing the required parameter `keyword_set_id` when calling `delete_quality_keywordset`")


        resource_path = '/api/v2/quality/keywordsets/{keywordSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'keyword_set_id' in params:
            path_params['keywordSetId'] = params['keyword_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_quality_keywordsets(self, ids, **kwargs):
        """
        Delete keyword sets
        Bulk delete of keyword sets; this will only delete the keyword sets that match the ids specified in the query param.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_quality_keywordsets(ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ids: A comma-delimited list of valid KeywordSet ids (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_quality_keywordsets" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ids' is set
        if ('ids' not in params) or (params['ids'] is None):
            raise ValueError("Missing the required parameter `ids` when calling `delete_quality_keywordsets`")


        resource_path = '/api/v2/quality/keywordsets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'ids' in params:
            query_params['ids'] = params['ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_agents_activity(self, **kwargs):
        """
        Gets a list of Agent Activities
        Including the number of evaluations and average evaluation score

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_agents_activity(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param datetime start_time: Start time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :param datetime end_time: End time of agent activity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :param list[str] agent_user_id: user id of agent requested
        :param str evaluator_user_id: user id of the evaluator
        :param str name: name
        :param str group: group id
        :return: AgentActivityEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'start_time', 'end_time', 'agent_user_id', 'evaluator_user_id', 'name', 'group']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_agents_activity" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/agents/activity'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'start_time' in params:
            query_params['startTime'] = params['start_time']
        if 'end_time' in params:
            query_params['endTime'] = params['end_time']
        if 'agent_user_id' in params:
            query_params['agentUserId'] = params['agent_user_id']
        if 'evaluator_user_id' in params:
            query_params['evaluatorUserId'] = params['evaluator_user_id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'group' in params:
            query_params['group'] = params['group']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AgentActivityEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_calibration(self, calibration_id, **kwargs):
        """
        Get a calibration by id.  Requires either calibrator id or conversation id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_calibration(calibration_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str calibration_id: Calibration ID (required)
        :param str calibrator_id: calibratorId
        :param str conversation_id: conversationId
        :return: Calibration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['calibration_id', 'calibrator_id', 'conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_calibration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'calibration_id' is set
        if ('calibration_id' not in params) or (params['calibration_id'] is None):
            raise ValueError("Missing the required parameter `calibration_id` when calling `get_quality_calibration`")


        resource_path = '/api/v2/quality/calibrations/{calibrationId}'.replace('{format}', 'json')
        path_params = {}
        if 'calibration_id' in params:
            path_params['calibrationId'] = params['calibration_id']

        query_params = {}
        if 'calibrator_id' in params:
            query_params['calibratorId'] = params['calibrator_id']
        if 'conversation_id' in params:
            query_params['conversationId'] = params['conversation_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Calibration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_calibrations(self, calibrator_id, **kwargs):
        """
        Get the list of calibrations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_calibrations(calibrator_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str calibrator_id: user id of calibrator (required)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str conversation_id: conversation id
        :param datetime start_time: Beginning of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :param datetime end_time: end of the calibration query. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :return: CalibrationEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['calibrator_id', 'page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'conversation_id', 'start_time', 'end_time']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_calibrations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'calibrator_id' is set
        if ('calibrator_id' not in params) or (params['calibrator_id'] is None):
            raise ValueError("Missing the required parameter `calibrator_id` when calling `get_quality_calibrations`")


        resource_path = '/api/v2/quality/calibrations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'conversation_id' in params:
            query_params['conversationId'] = params['conversation_id']
        if 'start_time' in params:
            query_params['startTime'] = params['start_time']
        if 'end_time' in params:
            query_params['endTime'] = params['end_time']
        if 'calibrator_id' in params:
            query_params['calibratorId'] = params['calibrator_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CalibrationEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_conversation_audits(self, conversation_id, **kwargs):
        """
        Get audits for conversation or recording
        Different permissions are required for viewing different resource audit entries.  The quality:evaluation:viewAudit permission is required to view evaluation audits, the recording:recording:viewAudit permission is required to view recording audits, and so on.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_conversation_audits(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str recording_id: id of the recording
        :param str entity_type: entity type options: Recording, Calibration, Evaluation, Annotation, Screen_Recording
        :return: QualityAuditPage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'recording_id', 'entity_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_conversation_audits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_quality_conversation_audits`")


        resource_path = '/api/v2/quality/conversations/{conversationId}/audits'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'recording_id' in params:
            query_params['recordingId'] = params['recording_id']
        if 'entity_type' in params:
            query_params['entityType'] = params['entity_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QualityAuditPage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_conversation_evaluation(self, conversation_id, evaluation_id, **kwargs):
        """
        Get an evaluation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_conversation_evaluation(conversation_id, evaluation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversationId (required)
        :param str evaluation_id: evaluationId (required)
        :param str expand: agent, evaluator, evaluationForm
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'evaluation_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_conversation_evaluation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_quality_conversation_evaluation`")
        # verify the required parameter 'evaluation_id' is set
        if ('evaluation_id' not in params) or (params['evaluation_id'] is None):
            raise ValueError("Missing the required parameter `evaluation_id` when calling `get_quality_conversation_evaluation`")


        resource_path = '/api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'evaluation_id' in params:
            path_params['evaluationId'] = params['evaluation_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Evaluation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_conversation_surveys(self, conversation_id, **kwargs):
        """
        Get the surveys for a conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_conversation_surveys(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversationId (required)
        :return: list[Survey]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_conversation_surveys" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_quality_conversation_surveys`")


        resource_path = '/api/v2/quality/conversations/{conversationId}/surveys'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[Survey]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_evaluations_query(self, **kwargs):
        """
        Queries Evaluations and returns a paged list
        Query params must include one of conversationId, evaluatorUserId, or agentUserId

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_evaluations_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str conversation_id: conversationId specified
        :param str agent_user_id: user id of the agent
        :param str evaluator_user_id: evaluator user id
        :param str queue_id: queue id
        :param str start_time: start time of the evaluation query
        :param str end_time: end time of the evaluation query
        :param list[str] evaluation_state: 
        :param bool is_released: the evaluation has been released
        :param bool agent_has_read: agent has the evaluation
        :param bool expand_answer_total_scores: get the total scores for evaluations
        :param int maximum: maximum
        :param str sort_order: sort order options for agentUserId or evaluatorUserId query. Valid options are 'a', 'asc', 'ascending', 'd', 'desc', 'descending'
        :return: EvaluationEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'conversation_id', 'agent_user_id', 'evaluator_user_id', 'queue_id', 'start_time', 'end_time', 'evaluation_state', 'is_released', 'agent_has_read', 'expand_answer_total_scores', 'maximum', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_evaluations_query" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/evaluations/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'conversation_id' in params:
            query_params['conversationId'] = params['conversation_id']
        if 'agent_user_id' in params:
            query_params['agentUserId'] = params['agent_user_id']
        if 'evaluator_user_id' in params:
            query_params['evaluatorUserId'] = params['evaluator_user_id']
        if 'queue_id' in params:
            query_params['queueId'] = params['queue_id']
        if 'start_time' in params:
            query_params['startTime'] = params['start_time']
        if 'end_time' in params:
            query_params['endTime'] = params['end_time']
        if 'evaluation_state' in params:
            query_params['evaluationState'] = params['evaluation_state']
        if 'is_released' in params:
            query_params['isReleased'] = params['is_released']
        if 'agent_has_read' in params:
            query_params['agentHasRead'] = params['agent_has_read']
        if 'expand_answer_total_scores' in params:
            query_params['expandAnswerTotalScores'] = params['expand_answer_total_scores']
        if 'maximum' in params:
            query_params['maximum'] = params['maximum']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_evaluators_activity(self, **kwargs):
        """
        Get an evaluator activity
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_evaluators_activity(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param datetime start_time: The start time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :param datetime end_time: The end time specified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
        :param str name: Evaluator name
        :param list[str] permission: permission strings
        :param str group: group id
        :return: EvaluatorActivityEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'start_time', 'end_time', 'name', 'permission', 'group']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_evaluators_activity" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/evaluators/activity'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'start_time' in params:
            query_params['startTime'] = params['start_time']
        if 'end_time' in params:
            query_params['endTime'] = params['end_time']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'permission' in params:
            query_params['permission'] = params['permission']
        if 'group' in params:
            query_params['group'] = params['group']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluatorActivityEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_form(self, form_id, **kwargs):
        """
        Get an evaluation form
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_form(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_form" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_quality_form`")


        resource_path = '/api/v2/quality/forms/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_form_versions(self, form_id, **kwargs):
        """
        Gets all the revisions for a specific evaluation.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_form_versions(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: EvaluationFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_form_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_quality_form_versions`")


        resource_path = '/api/v2/quality/forms/{formId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_forms(self, **kwargs):
        """
        Get the list of evaluation forms
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_forms(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str expand: Expand
        :param str name: Name
        :param str sort_order: Order to sort results, either asc or desc
        :return: EvaluationFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'next_page', 'previous_page', 'expand', 'name', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_forms" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/forms'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_forms_evaluation(self, form_id, **kwargs):
        """
        Get an evaluation form
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_forms_evaluation(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_forms_evaluation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_quality_forms_evaluation`")


        resource_path = '/api/v2/quality/forms/evaluations/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_forms_evaluation_versions(self, form_id, **kwargs):
        """
        Gets all the revisions for a specific evaluation.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_forms_evaluation_versions(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: EvaluationFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_forms_evaluation_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_quality_forms_evaluation_versions`")


        resource_path = '/api/v2/quality/forms/evaluations/{formId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_forms_evaluations(self, **kwargs):
        """
        Get the list of evaluation forms
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_forms_evaluations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str expand: Expand
        :param str name: Name
        :param str sort_order: Order to sort results, either asc or desc
        :return: EvaluationFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'next_page', 'previous_page', 'expand', 'name', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_forms_evaluations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/forms/evaluations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_forms_survey(self, form_id, **kwargs):
        """
        Get a survey form
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_forms_survey(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: SurveyForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_forms_survey" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_quality_forms_survey`")


        resource_path = '/api/v2/quality/forms/surveys/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_forms_survey_versions(self, form_id, **kwargs):
        """
        Gets all the revisions for a specific survey.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_forms_survey_versions(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: SurveyFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_forms_survey_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_quality_forms_survey_versions`")


        resource_path = '/api/v2/quality/forms/surveys/{formId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_forms_surveys(self, **kwargs):
        """
        Get the list of survey forms
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_forms_surveys(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str expand: Expand
        :param str name: Name
        :param str sort_order: Order to sort results, either asc or desc
        :return: SurveyFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'next_page', 'previous_page', 'expand', 'name', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_forms_surveys" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/forms/surveys'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_forms_surveys_bulk(self, id, **kwargs):
        """
        Retrieve a list of survey forms by their ids
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_forms_surveys_bulk(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] id: A comma-delimited list of valid survey form ids (required)
        :return: SurveyFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_forms_surveys_bulk" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_quality_forms_surveys_bulk`")


        resource_path = '/api/v2/quality/forms/surveys/bulk'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_forms_surveys_bulk_contexts(self, context_id, **kwargs):
        """
        Retrieve a list of the latest form versions by context ids
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_forms_surveys_bulk_contexts(context_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] context_id: A comma-delimited list of valid survey form context ids (required)
        :param bool published: If true, the latest published version will be included. If false, only the unpublished version will be included.
        :return: SurveyFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['context_id', 'published']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_forms_surveys_bulk_contexts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'context_id' is set
        if ('context_id' not in params) or (params['context_id'] is None):
            raise ValueError("Missing the required parameter `context_id` when calling `get_quality_forms_surveys_bulk_contexts`")


        resource_path = '/api/v2/quality/forms/surveys/bulk/contexts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'context_id' in params:
            query_params['contextId'] = params['context_id']
        if 'published' in params:
            query_params['published'] = params['published']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_keywordset(self, keyword_set_id, **kwargs):
        """
        Get a keywordSet by id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_keywordset(keyword_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str keyword_set_id: KeywordSet ID (required)
        :return: KeywordSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['keyword_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_keywordset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'keyword_set_id' is set
        if ('keyword_set_id' not in params) or (params['keyword_set_id'] is None):
            raise ValueError("Missing the required parameter `keyword_set_id` when calling `get_quality_keywordset`")


        resource_path = '/api/v2/quality/keywordsets/{keywordSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'keyword_set_id' in params:
            path_params['keywordSetId'] = params['keyword_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KeywordSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_keywordsets(self, **kwargs):
        """
        Get the list of keyword sets
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_keywordsets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The total page size requested
        :param int page_number: The page number requested
        :param str sort_by: variable name requested to sort by
        :param list[str] expand: variable name requested by expand list
        :param str next_page: next page token
        :param str previous_page: Previous page token
        :param str name: the keyword set name - used for filtering results in searches.
        :param str queue_id: the queue id - used for filtering results in searches.
        :param str agent_id: the agent id - used for filtering results in searches.
        :param str operator: If agentID and queueId are both present, this determines whether the query is an AND or OR between those parameters.
        :return: KeywordSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'expand', 'next_page', 'previous_page', 'name', 'queue_id', 'agent_id', 'operator']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_keywordsets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/keywordsets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'previous_page' in params:
            query_params['previousPage'] = params['previous_page']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'queue_id' in params:
            query_params['queueId'] = params['queue_id']
        if 'agent_id' in params:
            query_params['agentId'] = params['agent_id']
        if 'operator' in params:
            query_params['operator'] = params['operator']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KeywordSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_publishedform(self, form_id, **kwargs):
        """
        Get the published evaluation forms.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_publishedform(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_publishedform" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_quality_publishedform`")


        resource_path = '/api/v2/quality/publishedforms/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_publishedforms(self, **kwargs):
        """
        Get the published evaluation forms.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_publishedforms(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str name: Name
        :param bool only_latest_per_context: onlyLatestPerContext
        :return: EvaluationFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'name', 'only_latest_per_context']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_publishedforms" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/publishedforms'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'only_latest_per_context' in params:
            query_params['onlyLatestPerContext'] = params['only_latest_per_context']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_publishedforms_evaluation(self, form_id, **kwargs):
        """
        Get the most recent published version of an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_publishedforms_evaluation(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_publishedforms_evaluation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_quality_publishedforms_evaluation`")


        resource_path = '/api/v2/quality/publishedforms/evaluations/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_publishedforms_evaluations(self, **kwargs):
        """
        Get the published evaluation forms.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_publishedforms_evaluations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str name: Name
        :param bool only_latest_per_context: onlyLatestPerContext
        :return: EvaluationFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'name', 'only_latest_per_context']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_publishedforms_evaluations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/publishedforms/evaluations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'only_latest_per_context' in params:
            query_params['onlyLatestPerContext'] = params['only_latest_per_context']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_publishedforms_survey(self, form_id, **kwargs):
        """
        Get the most recent published version of a survey form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_publishedforms_survey(form_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :return: SurveyForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_publishedforms_survey" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `get_quality_publishedforms_survey`")


        resource_path = '/api/v2/quality/publishedforms/surveys/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_publishedforms_surveys(self, **kwargs):
        """
        Get the published survey forms.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_publishedforms_surveys(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str name: Name
        :param bool only_latest_enabled_per_context: onlyLatestEnabledPerContext
        :return: SurveyFormEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'name', 'only_latest_enabled_per_context']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_publishedforms_surveys" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/publishedforms/surveys'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'only_latest_enabled_per_context' in params:
            query_params['onlyLatestEnabledPerContext'] = params['only_latest_enabled_per_context']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyFormEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_survey(self, survey_id, **kwargs):
        """
        Get a survey for a conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_survey(survey_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str survey_id: surveyId (required)
        :return: Survey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['survey_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_survey" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'survey_id' is set
        if ('survey_id' not in params) or (params['survey_id'] is None):
            raise ValueError("Missing the required parameter `survey_id` when calling `get_quality_survey`")


        resource_path = '/api/v2/quality/surveys/{surveyId}'.replace('{format}', 'json')
        path_params = {}
        if 'survey_id' in params:
            path_params['surveyId'] = params['survey_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Survey',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_quality_surveys_scorable(self, customer_survey_url, **kwargs):
        """
        Get a survey as an end-customer, for the purposes of scoring it.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_quality_surveys_scorable(customer_survey_url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str customer_survey_url: customerSurveyUrl (required)
        :return: ScorableSurvey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['customer_survey_url']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_quality_surveys_scorable" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'customer_survey_url' is set
        if ('customer_survey_url' not in params) or (params['customer_survey_url'] is None):
            raise ValueError("Missing the required parameter `customer_survey_url` when calling `get_quality_surveys_scorable`")


        resource_path = '/api/v2/quality/surveys/scorable'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'customer_survey_url' in params:
            query_params['customerSurveyUrl'] = params['customer_survey_url']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScorableSurvey',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_quality_forms_survey(self, form_id, body, **kwargs):
        """
        Disable a particular version of a survey form and invalidates any invitations that have already been sent to customers using this version of the form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_quality_forms_survey(form_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :param SurveyForm body: Survey form (required)
        :return: SurveyForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_quality_forms_survey" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `patch_quality_forms_survey`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_quality_forms_survey`")


        resource_path = '/api/v2/quality/forms/surveys/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_analytics_evaluations_aggregates_query(self, body, **kwargs):
        """
        Query for evaluation aggregates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_analytics_evaluations_aggregates_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EvaluationAggregationQuery body: query (required)
        :return: EvaluationAggregateQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_analytics_evaluations_aggregates_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_analytics_evaluations_aggregates_query`")


        resource_path = '/api/v2/analytics/evaluations/aggregates/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationAggregateQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_analytics_surveys_aggregates_query(self, body, **kwargs):
        """
        Query for survey aggregates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_analytics_surveys_aggregates_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SurveyAggregationQuery body: query (required)
        :return: SurveyAggregateQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_analytics_surveys_aggregates_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_analytics_surveys_aggregates_query`")


        resource_path = '/api/v2/analytics/surveys/aggregates/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyAggregateQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_analytics_transcripts_aggregates_query(self, body, **kwargs):
        """
        Query for transcript aggregates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_analytics_transcripts_aggregates_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TranscriptAggregationQuery body: query (required)
        :return: TranscriptAggregateQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_analytics_transcripts_aggregates_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_analytics_transcripts_aggregates_query`")


        resource_path = '/api/v2/analytics/transcripts/aggregates/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TranscriptAggregateQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_calibrations(self, body, **kwargs):
        """
        Create a calibration
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_calibrations(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CalibrationCreate body: calibration (required)
        :param str expand: calibratorId
        :return: Calibration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_calibrations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_quality_calibrations`")


        resource_path = '/api/v2/quality/calibrations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Calibration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_conversation_evaluations(self, conversation_id, body, **kwargs):
        """
        Create an evaluation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_conversation_evaluations(conversation_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversationId (required)
        :param Evaluation body: evaluation (required)
        :param str expand: evaluatorId
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_conversation_evaluations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_quality_conversation_evaluations`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_quality_conversation_evaluations`")


        resource_path = '/api/v2/quality/conversations/{conversationId}/evaluations'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Evaluation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_evaluations_scoring(self, body, **kwargs):
        """
        Score evaluation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_evaluations_scoring(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EvaluationFormAndScoringSet body: evaluationAndScoringSet (required)
        :return: EvaluationScoringSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_evaluations_scoring" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_quality_evaluations_scoring`")


        resource_path = '/api/v2/quality/evaluations/scoring'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationScoringSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_forms(self, body, **kwargs):
        """
        Create an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_forms(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EvaluationForm body: Evaluation form (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_forms" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_quality_forms`")


        resource_path = '/api/v2/quality/forms'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_forms_evaluations(self, body, **kwargs):
        """
        Create an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_forms_evaluations(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EvaluationForm body: Evaluation form (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_forms_evaluations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_quality_forms_evaluations`")


        resource_path = '/api/v2/quality/forms/evaluations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_forms_surveys(self, body, **kwargs):
        """
        Create a survey form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_forms_surveys(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SurveyForm body: Survey form (required)
        :return: SurveyForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_forms_surveys" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_quality_forms_surveys`")


        resource_path = '/api/v2/quality/forms/surveys'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_keywordsets(self, body, **kwargs):
        """
        Create a Keyword Set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_keywordsets(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param KeywordSet body: keywordSet (required)
        :param str expand: queueId
        :return: KeywordSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_keywordsets" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_quality_keywordsets`")


        resource_path = '/api/v2/quality/keywordsets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KeywordSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_publishedforms(self, body, **kwargs):
        """
        Publish an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_publishedforms(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PublishForm body: Publish request containing id of form to publish (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_publishedforms" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_quality_publishedforms`")


        resource_path = '/api/v2/quality/publishedforms'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_publishedforms_evaluations(self, body, **kwargs):
        """
        Publish an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_publishedforms_evaluations(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PublishForm body: Publish request containing id of form to publish (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_publishedforms_evaluations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_quality_publishedforms_evaluations`")


        resource_path = '/api/v2/quality/publishedforms/evaluations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_publishedforms_surveys(self, body, **kwargs):
        """
        Publish a survey form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_publishedforms_surveys(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PublishForm body: Survey form (required)
        :return: SurveyForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_publishedforms_surveys" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_quality_publishedforms_surveys`")


        resource_path = '/api/v2/quality/publishedforms/surveys'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_spotability(self, **kwargs):
        """
        Retrieve the spotability statistic
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_spotability(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param KeywordSet body: Keyword Set
        :return: KeywordSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_spotability" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/quality/spotability'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KeywordSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_quality_surveys_scoring(self, body, **kwargs):
        """
        Score survey
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_quality_surveys_scoring(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SurveyFormAndScoringSet body: surveyAndScoringSet (required)
        :return: SurveyScoringSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_quality_surveys_scoring" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_quality_surveys_scoring`")


        resource_path = '/api/v2/quality/surveys/scoring'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyScoringSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_quality_calibration(self, calibration_id, body, **kwargs):
        """
        Update a calibration to the specified calibration via PUT.  Editable fields include: evaluators, expertEvaluator, and scoringIndex
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_quality_calibration(calibration_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str calibration_id: Calibration ID (required)
        :param Calibration body: Calibration (required)
        :return: Calibration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['calibration_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_quality_calibration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'calibration_id' is set
        if ('calibration_id' not in params) or (params['calibration_id'] is None):
            raise ValueError("Missing the required parameter `calibration_id` when calling `put_quality_calibration`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_quality_calibration`")


        resource_path = '/api/v2/quality/calibrations/{calibrationId}'.replace('{format}', 'json')
        path_params = {}
        if 'calibration_id' in params:
            path_params['calibrationId'] = params['calibration_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Calibration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_quality_conversation_evaluation(self, conversation_id, evaluation_id, body, **kwargs):
        """
        Update an evaluation
        The quality:evaluation:edit permission allows modification of most fields, while the quality:evaluation:editScore permission allows an evaluator to change just the question scores, and the quality:evaluation:editAgentSignoff permission allows an agent to change the agent comments and sign off on the evaluation.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_quality_conversation_evaluation(conversation_id, evaluation_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: conversationId (required)
        :param str evaluation_id: evaluationId (required)
        :param Evaluation body: evaluation (required)
        :param str expand: evaluatorId
        :return: Evaluation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'evaluation_id', 'body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_quality_conversation_evaluation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `put_quality_conversation_evaluation`")
        # verify the required parameter 'evaluation_id' is set
        if ('evaluation_id' not in params) or (params['evaluation_id'] is None):
            raise ValueError("Missing the required parameter `evaluation_id` when calling `put_quality_conversation_evaluation`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_quality_conversation_evaluation`")


        resource_path = '/api/v2/quality/conversations/{conversationId}/evaluations/{evaluationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'evaluation_id' in params:
            path_params['evaluationId'] = params['evaluation_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Evaluation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_quality_form(self, form_id, body, **kwargs):
        """
        Update an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_quality_form(form_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :param EvaluationForm body: Evaluation form (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_quality_form" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `put_quality_form`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_quality_form`")


        resource_path = '/api/v2/quality/forms/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_quality_forms_evaluation(self, form_id, body, **kwargs):
        """
        Update an evaluation form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_quality_forms_evaluation(form_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :param EvaluationForm body: Evaluation form (required)
        :return: EvaluationForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_quality_forms_evaluation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `put_quality_forms_evaluation`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_quality_forms_evaluation`")


        resource_path = '/api/v2/quality/forms/evaluations/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EvaluationForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_quality_forms_survey(self, form_id, body, **kwargs):
        """
        Update a survey form.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_quality_forms_survey(form_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str form_id: Form ID (required)
        :param SurveyForm body: Survey form (required)
        :return: SurveyForm
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['form_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_quality_forms_survey" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'form_id' is set
        if ('form_id' not in params) or (params['form_id'] is None):
            raise ValueError("Missing the required parameter `form_id` when calling `put_quality_forms_survey`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_quality_forms_survey`")


        resource_path = '/api/v2/quality/forms/surveys/{formId}'.replace('{format}', 'json')
        path_params = {}
        if 'form_id' in params:
            path_params['formId'] = params['form_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SurveyForm',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_quality_keywordset(self, keyword_set_id, body, **kwargs):
        """
        Update a keywordSet to the specified keywordSet via PUT.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_quality_keywordset(keyword_set_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str keyword_set_id: KeywordSet ID (required)
        :param KeywordSet body: keywordSet (required)
        :return: KeywordSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['keyword_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_quality_keywordset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'keyword_set_id' is set
        if ('keyword_set_id' not in params) or (params['keyword_set_id'] is None):
            raise ValueError("Missing the required parameter `keyword_set_id` when calling `put_quality_keywordset`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_quality_keywordset`")


        resource_path = '/api/v2/quality/keywordsets/{keywordSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'keyword_set_id' in params:
            path_params['keywordSetId'] = params['keyword_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='KeywordSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_quality_surveys_scorable(self, body, **kwargs):
        """
        Update a survey as an end-customer, for the purposes of scoring it.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_quality_surveys_scorable(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ScorableSurvey body: survey (required)
        :param str customer_survey_url: customerSurveyUrl
        :return: ScorableSurvey
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'customer_survey_url']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_quality_surveys_scorable" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_quality_surveys_scorable`")


        resource_path = '/api/v2/quality/surveys/scorable'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'customer_survey_url' in params:
            query_params['customerSurveyUrl'] = params['customer_survey_url']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScorableSurvey',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
