# Generated by Django 2.0.7 on 2018-07-26 16:49

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='GlobeeIPN',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('payment_status', models.CharField(choices=[('unpaid', 'unpaid - ready to receive payment'), ('paid', 'waiting for confirmations'), ('underpaid', 'user has paid less'), ('overpaid', 'user has mistakenly paid more'), ('paid_late', 'the payment was made outside of the quotation window'), ('confirmed', 'payment has been confirmed'), ('completed', 'payment-request is now completed')], help_text='Globee payment status', max_length=12)),
                ('payment_id', models.CharField(help_text='Globee payment ID', max_length=255)),
                ('total', models.FloatField(help_text='The amount in fiat or crypto-currency')),
                ('customer_email', models.EmailField(help_text='The email address of your customer', max_length=254)),
                ('customer_name', models.CharField(blank=True, help_text='The name of your customer', max_length=50, null=True)),
                ('currency', models.CharField(default='USD', help_text='ISO 4217 currency codes', max_length=3)),
                ('custom_payment_id', models.CharField(blank=True, help_text='A reference or custom identifier that you can use to link the payment back to your system', max_length=255, null=True)),
                ('callback_data', models.CharField(blank=True, help_text='Passthrough data that will be returned in the IPN callback', max_length=255, null=True)),
                ('notification_email', models.CharField(blank=True, help_text='An email address that the system will send a notification email to once the payment has been confirmed', max_length=255, null=True)),
                ('confirmation_speed', models.CharField(choices=[('low', 'low speed / low risk'), ('medium', 'medium speed / medium risk'), ('high', 'high speed with / risk')], default='medium', max_length=5)),
                ('created_at', models.DateTimeField()),
                ('expires_at', models.DateTimeField()),
            ],
        ),
    ]
