# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.packaging_integration_spec import PackagingIntegrationSpec  # noqa: F401,E501
from odahuflow.sdk.models.packaging_integration_status import PackagingIntegrationStatus  # noqa: F401,E501
from odahuflow.sdk.models import util


class PackagingIntegration(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, id: str=None, spec: PackagingIntegrationSpec=None, status: PackagingIntegrationStatus=None):  # noqa: E501
        """PackagingIntegration - a model defined in Swagger

        :param id: The id of this PackagingIntegration.  # noqa: E501
        :type id: str
        :param spec: The spec of this PackagingIntegration.  # noqa: E501
        :type spec: PackagingIntegrationSpec
        :param status: The status of this PackagingIntegration.  # noqa: E501
        :type status: PackagingIntegrationStatus
        """
        self.swagger_types = {
            'id': str,
            'spec': PackagingIntegrationSpec,
            'status': PackagingIntegrationStatus
        }

        self.attribute_map = {
            'id': 'id',
            'spec': 'spec',
            'status': 'status'
        }

        self._id = id
        self._spec = spec
        self._status = status

    @classmethod
    def from_dict(cls, dikt) -> 'PackagingIntegration':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PackagingIntegration of this PackagingIntegration.  # noqa: E501
        :rtype: PackagingIntegration
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> str:
        """Gets the id of this PackagingIntegration.

        Packaging integration id  # noqa: E501

        :return: The id of this PackagingIntegration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this PackagingIntegration.

        Packaging integration id  # noqa: E501

        :param id: The id of this PackagingIntegration.
        :type id: str
        """

        self._id = id

    @property
    def spec(self) -> PackagingIntegrationSpec:
        """Gets the spec of this PackagingIntegration.

        Packaging integration specification  # noqa: E501

        :return: The spec of this PackagingIntegration.
        :rtype: PackagingIntegrationSpec
        """
        return self._spec

    @spec.setter
    def spec(self, spec: PackagingIntegrationSpec):
        """Sets the spec of this PackagingIntegration.

        Packaging integration specification  # noqa: E501

        :param spec: The spec of this PackagingIntegration.
        :type spec: PackagingIntegrationSpec
        """

        self._spec = spec

    @property
    def status(self) -> PackagingIntegrationStatus:
        """Gets the status of this PackagingIntegration.

        Packaging integration status  # noqa: E501

        :return: The status of this PackagingIntegration.
        :rtype: PackagingIntegrationStatus
        """
        return self._status

    @status.setter
    def status(self, status: PackagingIntegrationStatus):
        """Sets the status of this PackagingIntegration.

        Packaging integration status  # noqa: E501

        :param status: The status of this PackagingIntegration.
        :type status: PackagingIntegrationStatus
        """

        self._status = status
