# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.parameter import Parameter  # noqa: F401,E501
from odahuflow.sdk.models import util


class ModelProperty(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, name: str=None, parameters: List[Parameter]=None):  # noqa: E501
        """ModelProperty - a model defined in Swagger

        :param name: The name of this ModelProperty.  # noqa: E501
        :type name: str
        :param parameters: The parameters of this ModelProperty.  # noqa: E501
        :type parameters: List[Parameter]
        """
        self.swagger_types = {
            'name': str,
            'parameters': List[Parameter]
        }

        self.attribute_map = {
            'name': 'name',
            'parameters': 'parameters'
        }

        self._name = name
        self._parameters = parameters

    @classmethod
    def from_dict(cls, dikt) -> 'ModelProperty':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Property of this ModelProperty.  # noqa: E501
        :rtype: ModelProperty
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> str:
        """Gets the name of this ModelProperty.

        Property name  # noqa: E501

        :return: The name of this ModelProperty.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str):
        """Sets the name of this ModelProperty.

        Property name  # noqa: E501

        :param name: The name of this ModelProperty.
        :type name: str
        """

        self._name = name

    @property
    def parameters(self) -> List[Parameter]:
        """Gets the parameters of this ModelProperty.

        List of property parameters  # noqa: E501

        :return: The parameters of this ModelProperty.
        :rtype: List[Parameter]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters: List[Parameter]):
        """Sets the parameters of this ModelProperty.

        List of property parameters  # noqa: E501

        :param parameters: The parameters of this ModelProperty.
        :type parameters: List[Parameter]
        """

        self._parameters = parameters
