# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.jwks import JWKS  # noqa: F401,E501
from odahuflow.sdk.models import util


class ModelDeploymentSecurityConfig(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, jwks: JWKS=None, role_name: str=None):  # noqa: E501
        """ModelDeploymentSecurityConfig - a model defined in Swagger

        :param jwks: The jwks of this ModelDeploymentSecurityConfig.  # noqa: E501
        :type jwks: JWKS
        :param role_name: The role_name of this ModelDeploymentSecurityConfig.  # noqa: E501
        :type role_name: str
        """
        self.swagger_types = {
            'jwks': JWKS,
            'role_name': str
        }

        self.attribute_map = {
            'jwks': 'jwks',
            'role_name': 'roleName'
        }

        self._jwks = jwks
        self._role_name = role_name

    @classmethod
    def from_dict(cls, dikt) -> 'ModelDeploymentSecurityConfig':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ModelDeploymentSecurityConfig of this ModelDeploymentSecurityConfig.  # noqa: E501
        :rtype: ModelDeploymentSecurityConfig
        """
        return util.deserialize_model(dikt, cls)

    @property
    def jwks(self) -> JWKS:
        """Gets the jwks of this ModelDeploymentSecurityConfig.


        :return: The jwks of this ModelDeploymentSecurityConfig.
        :rtype: JWKS
        """
        return self._jwks

    @jwks.setter
    def jwks(self, jwks: JWKS):
        """Sets the jwks of this ModelDeploymentSecurityConfig.


        :param jwks: The jwks of this ModelDeploymentSecurityConfig.
        :type jwks: JWKS
        """

        self._jwks = jwks

    @property
    def role_name(self) -> str:
        """Gets the role_name of this ModelDeploymentSecurityConfig.

        Deprecated  # noqa: E501

        :return: The role_name of this ModelDeploymentSecurityConfig.
        :rtype: str
        """
        return self._role_name

    @role_name.setter
    def role_name(self, role_name: str):
        """Sets the role_name of this ModelDeploymentSecurityConfig.

        Deprecated  # noqa: E501

        :param role_name: The role_name of this ModelDeploymentSecurityConfig.
        :type role_name: str
        """

        self._role_name = role_name
