#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
# agentMET4FOF documentation build configuration file, created from PyDynamic
# draft on Fri Jul 12 10:31:35 2019.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# from an autogenerated derived file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import os
import sys
import shutil

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
# sys.path.insert(0, os.path.abspath('.'))
sys.path.insert(0, os.path.abspath(".."))

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.coverage",
    "sphinx.ext.mathjax",
    "sphinx.ext.viewcode",
    "sphinx.ext.napoleon",
    "sphinx.ext.todo",
    "sphinx.ext.intersphinx",
    "nbsphinx",
    "recommonmark",
]

# ReadTheDocs Sphinx theme option taken from
# https://sphinx-rtd-theme.readthedocs.io/en/latest/configuring.html
html_theme_options = {
    # True hides the + signs to expand the menu entries in the sidebar.
    "collapse_navigation": False,
}

# This should make Python built-in, Pandas, SciPy, PyDynamic and time-series-metadata
# documentation available inside our docs.
intersphinx_mapping = {
    "Python": ("http://docs.python.org/", None),
    "pd": ("http://pandas.pydata.org/pandas-docs/dev", None),
    "SciPy": ("https://docs.scipy.org/doc/scipy/reference", None),
    "PyDynamic": (
        "https://pydynamic.readthedocs.io/en/latest/",
        None,
    ),
    "time-series-metadata": (
        "https://time-series-metadata.readthedocs.io/en/latest/",
        None,
    ),
    "np": (
        "http://docs.scipy.org/doc/numpy/",
        None,
    ),
}
# We keep the objects.inv files in our docs folder to get hints on how to specify the
# cross-references. More on the topic can be found here:
# https://www.sphinx-doc.org/en/master/usage/extensions/intersphinx.html
# The objects.inv we gathered by the command:
# $ python -msphinx.ext.intersphinx https://docs.python.org/3/objects.inv
# which we took from the linked page (almost at the very bottom at the time of
# writing this).


nbsphinx_allow_errors = True

################################################################################
# This part is originally taken from
# https://github.com/cornellius-gp/gpytorch/issues/new/choose?permalink=https%3A%2F%2Fgithub.com%2Fcornellius-gp%2Fgpytorch%2Fblob%2F0b28dd0b8430a0df9838593e7e632dc01d20bcf4%2Fdocs%2Fsource%2Fconf.py%23L107
#
# Copy over examples and tutorials and all other folders to docs' source
# This makes it so that nbsphinx can properly load the notebook images

# Copy over README.md from root folder.
shutil.copyfile(
    os.path.abspath(os.path.join(os.path.dirname(__file__), "..", "README.md")),
    os.path.join(os.path.dirname(__file__), "README.md"),
)

# Copy over all other specified folders from repository tree.


def make_path_dict(source: str, destination: str) -> dict:
    # Function to construct the desired dict structure for the folders to copy.
    return {"source": source, "destination": destination}


# Set up all paths for source and destination folders.
tutorials_source = os.path.abspath(
    os.path.join(os.path.dirname(__file__), "..", "agentMET4FOF_tutorials")
)
tutorials_dest = os.path.abspath(
    os.path.join(os.path.dirname(__file__), "agentMET4FOF_tutorials")
)

# Assemble the list of dicts of all source and destination folders to copy.
path_dicts = [
    make_path_dict(tutorials_source, tutorials_dest),
]

# Do the actual copying.
for path_dict in path_dicts:
    source_folder = path_dict["source"]
    dest_folder = path_dict["destination"]
    if os.path.exists(dest_folder):
        shutil.rmtree(dest_folder)
    os.mkdir(dest_folder)

    for root, dirs, files in os.walk(source_folder):
        for dr in dirs:
            os.mkdir(os.path.join(root.replace(source_folder, dest_folder), dr))
        for fil in files:
            if os.path.splitext(fil)[1] in [".ipynb", ".md", ".rst"]:
                source_filename = os.path.join(root, fil)
                dest_filename = source_filename.replace(source_folder, dest_folder)
                shutil.copyfile(source_filename, dest_filename)
################################################################################

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
# source_suffix = ['.rst', '.md']
source_suffix = [".rst", ".md"]

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# The master toctree document.
master_doc = "index"

# General information about the project.
project = "agentMET4FOF"
copyright = (
    "2021, Bang Xiang Yong (UCAM), Björn Ludwig (PTB), Anupam Prasad Vedurmudi (PTB), "
    "Maximilian Gruber (PTB), Haris Lulic (IMBIH)"
)
author = (
    "Bang Xiang Yong, Björn Ludwig, Anupam Prasad Vedurmudi, Maximilian Gruber, "
    "Haris Lulic"
)

# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = '0.6.1'
# The full version, including alpha/beta/rc tags.
# release = '0.0.1'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ["_build"]

# The reST default role (used for this markup: `text`) to use for all
# documents.
# default_role = None

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = "colorful"

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
# keep_warnings = False

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True


# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = "sphinx_rtd_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
# html_theme_options = {}

# Add any paths that contain custom themes here, relative to this directory.
# html_theme_path = []

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
# html_title = None

# A shorter title for the navigation bar.  Default is the same as html_title.
# html_short_title = None

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
# html_logo = None

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
# html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = []

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
# html_extra_path = []

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
# html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
# html_domain_indices = True

# If false, no index is generated.
# html_use_index = True

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
# html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
# html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
# html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None

# Language to be used for generating the HTML full-text search index.
# Sphinx supports the following languages:
#   'da', 'de', 'en', 'es', 'fi', 'fr', 'h', 'it', 'ja'
#   'nl', 'no', 'pt', 'ro', 'r', 'sv', 'tr'
# html_search_language = 'en'

# A dictionary with options for the search language support, empty by default.
# Now only 'ja' uses this config value
# html_search_options = {'type': 'default'}

# The name of a javascript file (relative to the configuration directory) that
# implements a search results scorer. If empty, the default will be used.
# html_search_scorer = 'scorer.js'

# Output file base name for HTML help builder.
htmlhelp_basename = "agentMe4FoFdoc"

# -- Options for LaTeX output ---------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #'preamble': '',
    # Latex figure (float) alignment
    #'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (
        master_doc,
        "agentMET4FOF.tex",
        "agentMET4FOF Documentation",
        "Bang Xiang Yong",
        "manual",
    ),
]

# The name of an image file (relative to this directory) to place at the top of
# the title page.
# latex_logo = None

# For "manual" documents, if this is true, then toplevel headings are parts,
# not chapters.
# latex_use_parts = False

# If true, show page references after internal links.
# latex_show_pagerefs = False

# If true, show URL addresses after external links.
# latex_show_urls = False

# Documents to append as an appendix to all manuals.
# latex_appendices = []

# If false, no module index is generated.
# latex_domain_indices = True


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "agentMET4FOF", "agentMET4FOF Documentation", [author], 1)]

# If true, show URL addresses after external links.
# man_show_urls = False


# -- Options for Texinfo output -------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "agentMET4FOF",
        "agentMET4FOF Documentation",
        author,
        "agentMET4FOF",
        "One line description of project.",
        "Miscellaneous",
    ),
]

# Documents to append as an appendix to all manuals.
# texinfo_appendices = []

# If false, no module index is generated.
# texinfo_domain_indices = True

# How to display URL addresses: 'footnote', 'no', or 'inline'.
# texinfo_show_urls = 'footnote'

# If true, do not generate a @detailmenu in the "Top" node's menu.
# texinfo_no_detailmenu = False
