# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import meta_v1
from . import authentication_v1


@dataclass
class SelfSubjectReview(DataclassDictMixIn):
    """SelfSubjectReview contains the user information that the kube-apiserver has
      about the user making this request. When using impersonation, users will
      receive the user info of the user being impersonated.  If impersonation or
      request header authentication is used, any extra keys will have their case
      ignored and returned as lowercase.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **status** ``SelfSubjectReviewStatus`` - *(optional)* Status is filled in by the server with the user attributes.
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    status: 'SelfSubjectReviewStatus' = None


@dataclass
class SelfSubjectReviewStatus(DataclassDictMixIn):
    """SelfSubjectReviewStatus is filled by the kube-apiserver and sent back to a
      user.

      **parameters**

      * **userInfo** ``authentication_v1.UserInfo`` - *(optional)* User attributes of the user making this request.
    """
    userInfo: 'authentication_v1.UserInfo' = None


