from sgqlc.types import Arg, Enum, Field, Input, Type, list_of, non_null
from sgqlc.types.relay import Node


class Timezone(Enum):
    __choices__ = (
        "AFRICA_ABIDJAN",
        "AFRICA_ACCRA",
        "AFRICA_ADDIS_ABABA",
        "AFRICA_ALGIERS",
        "AFRICA_ASMARA",
        "AFRICA_ASMERA",
        "AFRICA_BAMAKO",
        "AFRICA_BANGUI",
        "AFRICA_BANJUL",
        "AFRICA_BISSAU",
        "AFRICA_BLANTYRE",
        "AFRICA_BRAZZAVILLE",
        "AFRICA_BUJUMBURA",
        "AFRICA_CAIRO",
        "AFRICA_CASABLANCA",
        "AFRICA_CEUTA",
        "AFRICA_CONAKRY",
        "AFRICA_DAKAR",
        "AFRICA_DAR_ES_SALAAM",
        "AFRICA_DJIBOUTI",
        "AFRICA_DOUALA",
        "AFRICA_EL_AAIUN",
        "AFRICA_FREETOWN",
        "AFRICA_GABORONE",
        "AFRICA_HARARE",
        "AFRICA_JOHANNESBURG",
        "AFRICA_JUBA",
        "AFRICA_KAMPALA",
        "AFRICA_KHARTOUM",
        "AFRICA_KIGALI",
        "AFRICA_KINSHASA",
        "AFRICA_LAGOS",
        "AFRICA_LIBREVILLE",
        "AFRICA_LOME",
        "AFRICA_LUANDA",
        "AFRICA_LUBUMBASHI",
        "AFRICA_LUSAKA",
        "AFRICA_MALABO",
        "AFRICA_MAPUTO",
        "AFRICA_MASERU",
        "AFRICA_MBABANE",
        "AFRICA_MOGADISHU",
        "AFRICA_MONROVIA",
        "AFRICA_NAIROBI",
        "AFRICA_NDJAMENA",
        "AFRICA_NIAMEY",
        "AFRICA_NOUAKCHOTT",
        "AFRICA_OUAGADOUGOU",
        "AFRICA_PORTO_NOVO",
        "AFRICA_SAO_TOME",
        "AFRICA_TIMBUKTU",
        "AFRICA_TRIPOLI",
        "AFRICA_TUNIS",
        "AFRICA_WINDHOEK",
        "AMERICA_ADAK",
        "AMERICA_ANCHORAGE",
        "AMERICA_ANGUILLA",
        "AMERICA_ANTIGUA",
        "AMERICA_ARAGUAINA",
        "AMERICA_ARGENTINA_BUENOS_AIRES",
        "AMERICA_ARGENTINA_CATAMARCA",
        "AMERICA_ARGENTINA_COMOD_RIVADAVIA",
        "AMERICA_ARGENTINA_CORDOBA",
        "AMERICA_ARGENTINA_JUJUY",
        "AMERICA_ARGENTINA_LA_RIOJA",
        "AMERICA_ARGENTINA_MENDOZA",
        "AMERICA_ARGENTINA_RIO_GALLEGOS",
        "AMERICA_ARGENTINA_SALTA",
        "AMERICA_ARGENTINA_SAN_JUAN",
        "AMERICA_ARGENTINA_SAN_LUIS",
        "AMERICA_ARGENTINA_TUCUMAN",
        "AMERICA_ARGENTINA_USHUAIA",
        "AMERICA_ARUBA",
        "AMERICA_ASUNCION",
        "AMERICA_ATIKOKAN",
        "AMERICA_ATKA",
        "AMERICA_BAHIA",
        "AMERICA_BAHIA_BANDERAS",
        "AMERICA_BARBADOS",
        "AMERICA_BELEM",
        "AMERICA_BELIZE",
        "AMERICA_BLANC_SABLON",
        "AMERICA_BOA_VISTA",
        "AMERICA_BOGOTA",
        "AMERICA_BOISE",
        "AMERICA_BUENOS_AIRES",
        "AMERICA_CAMBRIDGE_BAY",
        "AMERICA_CAMPO_GRANDE",
        "AMERICA_CANCUN",
        "AMERICA_CARACAS",
        "AMERICA_CATAMARCA",
        "AMERICA_CAYENNE",
        "AMERICA_CAYMAN",
        "AMERICA_CHICAGO",
        "AMERICA_CHIHUAHUA",
        "AMERICA_CORAL_HARBOUR",
        "AMERICA_CORDOBA",
        "AMERICA_COSTA_RICA",
        "AMERICA_CRESTON",
        "AMERICA_CUIABA",
        "AMERICA_CURACAO",
        "AMERICA_DANMARKSHAVN",
        "AMERICA_DAWSON",
        "AMERICA_DAWSON_CREEK",
        "AMERICA_DENVER",
        "AMERICA_DETROIT",
        "AMERICA_DOMINICA",
        "AMERICA_EDMONTON",
        "AMERICA_EIRUNEPE",
        "AMERICA_EL_SALVADOR",
        "AMERICA_ENSENADA",
        "AMERICA_FORTALEZA",
        "AMERICA_FORT_NELSON",
        "AMERICA_FORT_WAYNE",
        "AMERICA_GLACE_BAY",
        "AMERICA_GODTHAB",
        "AMERICA_GOOSE_BAY",
        "AMERICA_GRAND_TURK",
        "AMERICA_GRENADA",
        "AMERICA_GUADELOUPE",
        "AMERICA_GUATEMALA",
        "AMERICA_GUAYAQUIL",
        "AMERICA_GUYANA",
        "AMERICA_HALIFAX",
        "AMERICA_HAVANA",
        "AMERICA_HERMOSILLO",
        "AMERICA_INDIANAPOLIS",
        "AMERICA_INDIANA_INDIANAPOLIS",
        "AMERICA_INDIANA_KNOX",
        "AMERICA_INDIANA_MARENGO",
        "AMERICA_INDIANA_PETERSBURG",
        "AMERICA_INDIANA_TELL_CITY",
        "AMERICA_INDIANA_VEVAY",
        "AMERICA_INDIANA_VINCENNES",
        "AMERICA_INDIANA_WINAMAC",
        "AMERICA_INUVIK",
        "AMERICA_IQALUIT",
        "AMERICA_JAMAICA",
        "AMERICA_JUJUY",
        "AMERICA_JUNEAU",
        "AMERICA_KENTUCKY_LOUISVILLE",
        "AMERICA_KENTUCKY_MONTICELLO",
        "AMERICA_KNOX_IN",
        "AMERICA_KRALENDIJK",
        "AMERICA_LA_PAZ",
        "AMERICA_LIMA",
        "AMERICA_LOS_ANGELES",
        "AMERICA_LOUISVILLE",
        "AMERICA_LOWER_PRINCES",
        "AMERICA_MACEIO",
        "AMERICA_MANAGUA",
        "AMERICA_MANAUS",
        "AMERICA_MARIGOT",
        "AMERICA_MARTINIQUE",
        "AMERICA_MATAMOROS",
        "AMERICA_MAZATLAN",
        "AMERICA_MENDOZA",
        "AMERICA_MENOMINEE",
        "AMERICA_MERIDA",
        "AMERICA_METLAKATLA",
        "AMERICA_MEXICO_CITY",
        "AMERICA_MIQUELON",
        "AMERICA_MONCTON",
        "AMERICA_MONTERREY",
        "AMERICA_MONTEVIDEO",
        "AMERICA_MONTREAL",
        "AMERICA_MONTSERRAT",
        "AMERICA_NASSAU",
        "AMERICA_NEW_YORK",
        "AMERICA_NIPIGON",
        "AMERICA_NOME",
        "AMERICA_NORONHA",
        "AMERICA_NORTH_DAKOTA_BEULAH",
        "AMERICA_NORTH_DAKOTA_CENTER",
        "AMERICA_NORTH_DAKOTA_NEW_SALEM",
        "AMERICA_NUUK",
        "AMERICA_OJINAGA",
        "AMERICA_PANAMA",
        "AMERICA_PANGNIRTUNG",
        "AMERICA_PARAMARIBO",
        "AMERICA_PHOENIX",
        "AMERICA_PORTO_ACRE",
        "AMERICA_PORTO_VELHO",
        "AMERICA_PORT_AU_PRINCE",
        "AMERICA_PORT_OF_SPAIN",
        "AMERICA_PUERTO_RICO",
        "AMERICA_PUNTA_ARENAS",
        "AMERICA_RAINY_RIVER",
        "AMERICA_RANKIN_INLET",
        "AMERICA_RECIFE",
        "AMERICA_REGINA",
        "AMERICA_RESOLUTE",
        "AMERICA_RIO_BRANCO",
        "AMERICA_ROSARIO",
        "AMERICA_SANTAREM",
        "AMERICA_SANTA_ISABEL",
        "AMERICA_SANTIAGO",
        "AMERICA_SANTO_DOMINGO",
        "AMERICA_SAO_PAULO",
        "AMERICA_SCORESBYSUND",
        "AMERICA_SHIPROCK",
        "AMERICA_SITKA",
        "AMERICA_ST_BARTHELEMY",
        "AMERICA_ST_JOHNS",
        "AMERICA_ST_KITTS",
        "AMERICA_ST_LUCIA",
        "AMERICA_ST_THOMAS",
        "AMERICA_ST_VINCENT",
        "AMERICA_SWIFT_CURRENT",
        "AMERICA_TEGUCIGALPA",
        "AMERICA_THULE",
        "AMERICA_THUNDER_BAY",
        "AMERICA_TIJUANA",
        "AMERICA_TORONTO",
        "AMERICA_TORTOLA",
        "AMERICA_VANCOUVER",
        "AMERICA_VIRGIN",
        "AMERICA_WHITEHORSE",
        "AMERICA_WINNIPEG",
        "AMERICA_YAKUTAT",
        "AMERICA_YELLOWKNIFE",
        "ANTARCTICA_CASEY",
        "ANTARCTICA_DAVIS",
        "ANTARCTICA_DUMONT_DURVILLE",
        "ANTARCTICA_MACQUARIE",
        "ANTARCTICA_MAWSON",
        "ANTARCTICA_MC_MURDO",
        "ANTARCTICA_PALMER",
        "ANTARCTICA_ROTHERA",
        "ANTARCTICA_SOUTH_POLE",
        "ANTARCTICA_SYOWA",
        "ANTARCTICA_TROLL",
        "ANTARCTICA_VOSTOK",
        "ARCTIC_LONGYEARBYEN",
        "ASIA_ADEN",
        "ASIA_ALMATY",
        "ASIA_AMMAN",
        "ASIA_ANADYR",
        "ASIA_AQTAU",
        "ASIA_AQTOBE",
        "ASIA_ASHGABAT",
        "ASIA_ASHKHABAD",
        "ASIA_ATYRAU",
        "ASIA_BAGHDAD",
        "ASIA_BAHRAIN",
        "ASIA_BAKU",
        "ASIA_BANGKOK",
        "ASIA_BARNAUL",
        "ASIA_BEIRUT",
        "ASIA_BISHKEK",
        "ASIA_BRUNEI",
        "ASIA_CALCUTTA",
        "ASIA_CHITA",
        "ASIA_CHOIBALSAN",
        "ASIA_CHONGQING",
        "ASIA_CHUNGKING",
        "ASIA_COLOMBO",
        "ASIA_DACCA",
        "ASIA_DAMASCUS",
        "ASIA_DHAKA",
        "ASIA_DILI",
        "ASIA_DUBAI",
        "ASIA_DUSHANBE",
        "ASIA_FAMAGUSTA",
        "ASIA_GAZA",
        "ASIA_HARBIN",
        "ASIA_HEBRON",
        "ASIA_HONG_KONG",
        "ASIA_HOVD",
        "ASIA_HO_CHI_MINH",
        "ASIA_IRKUTSK",
        "ASIA_ISTANBUL",
        "ASIA_JAKARTA",
        "ASIA_JAYAPURA",
        "ASIA_JERUSALEM",
        "ASIA_KABUL",
        "ASIA_KAMCHATKA",
        "ASIA_KARACHI",
        "ASIA_KASHGAR",
        "ASIA_KATHMANDU",
        "ASIA_KATMANDU",
        "ASIA_KHANDYGA",
        "ASIA_KOLKATA",
        "ASIA_KRASNOYARSK",
        "ASIA_KUALA_LUMPUR",
        "ASIA_KUCHING",
        "ASIA_KUWAIT",
        "ASIA_MACAO",
        "ASIA_MACAU",
        "ASIA_MAGADAN",
        "ASIA_MAKASSAR",
        "ASIA_MANILA",
        "ASIA_MUSCAT",
        "ASIA_NICOSIA",
        "ASIA_NOVOKUZNETSK",
        "ASIA_NOVOSIBIRSK",
        "ASIA_OMSK",
        "ASIA_ORAL",
        "ASIA_PHNOM_PENH",
        "ASIA_PONTIANAK",
        "ASIA_PYONGYANG",
        "ASIA_QATAR",
        "ASIA_QOSTANAY",
        "ASIA_QYZYLORDA",
        "ASIA_RANGOON",
        "ASIA_RIYADH",
        "ASIA_SAIGON",
        "ASIA_SAKHALIN",
        "ASIA_SAMARKAND",
        "ASIA_SEOUL",
        "ASIA_SHANGHAI",
        "ASIA_SINGAPORE",
        "ASIA_SREDNEKOLYMSK",
        "ASIA_TAIPEI",
        "ASIA_TASHKENT",
        "ASIA_TBILISI",
        "ASIA_TEHRAN",
        "ASIA_TEL_AVIV",
        "ASIA_THIMBU",
        "ASIA_THIMPHU",
        "ASIA_TOKYO",
        "ASIA_TOMSK",
        "ASIA_UJUNG_PANDANG",
        "ASIA_ULAANBAATAR",
        "ASIA_ULAN_BATOR",
        "ASIA_URUMQI",
        "ASIA_UST_NERA",
        "ASIA_VIENTIANE",
        "ASIA_VLADIVOSTOK",
        "ASIA_YAKUTSK",
        "ASIA_YANGON",
        "ASIA_YEKATERINBURG",
        "ASIA_YEREVAN",
        "ATLANTIC_AZORES",
        "ATLANTIC_BERMUDA",
        "ATLANTIC_CANARY",
        "ATLANTIC_CAPE_VERDE",
        "ATLANTIC_FAEROE",
        "ATLANTIC_FAROE",
        "ATLANTIC_JAN_MAYEN",
        "ATLANTIC_MADEIRA",
        "ATLANTIC_REYKJAVIK",
        "ATLANTIC_SOUTH_GEORGIA",
        "ATLANTIC_STANLEY",
        "ATLANTIC_ST_HELENA",
        "AUSTRALIA_ACT",
        "AUSTRALIA_ADELAIDE",
        "AUSTRALIA_BRISBANE",
        "AUSTRALIA_BROKEN_HILL",
        "AUSTRALIA_CANBERRA",
        "AUSTRALIA_CURRIE",
        "AUSTRALIA_DARWIN",
        "AUSTRALIA_EUCLA",
        "AUSTRALIA_HOBART",
        "AUSTRALIA_LHI",
        "AUSTRALIA_LINDEMAN",
        "AUSTRALIA_LORD_HOWE",
        "AUSTRALIA_MELBOURNE",
        "AUSTRALIA_NORTH",
        "AUSTRALIA_NSW",
        "AUSTRALIA_PERTH",
        "AUSTRALIA_QUEENSLAND",
        "AUSTRALIA_SOUTH",
        "AUSTRALIA_SYDNEY",
        "AUSTRALIA_TASMANIA",
        "AUSTRALIA_VICTORIA",
        "AUSTRALIA_WEST",
        "AUSTRALIA_YANCOWINNA",
        "BRAZIL_ACRE",
        "BRAZIL_DE_NORONHA",
        "BRAZIL_EAST",
        "BRAZIL_WEST",
        "CANADA_ATLANTIC",
        "CANADA_CENTRAL",
        "CANADA_EASTERN",
        "CANADA_MOUNTAIN",
        "CANADA_NEWFOUNDLAND",
        "CANADA_PACIFIC",
        "CANADA_SASKATCHEWAN",
        "CANADA_YUKON",
        "CET",
        "CHILE_CONTINENTAL",
        "CHILE_EASTER_ISLAND",
        "CST6_CDT",
        "CUBA",
        "EET",
        "EGYPT",
        "EIRE",
        "EST",
        "EST5_EDT",
        "ETC_GMT",
        "ETC_GMT0",
        "ETC_GMT_0",
        "ETC_GMT_1",
        "ETC_GMT_10",
        "ETC_GMT_11",
        "ETC_GMT_12",
        "ETC_GMT_13",
        "ETC_GMT_14",
        "ETC_GMT_2",
        "ETC_GMT_3",
        "ETC_GMT_4",
        "ETC_GMT_5",
        "ETC_GMT_6",
        "ETC_GMT_7",
        "ETC_GMT_8",
        "ETC_GMT_9",
        "ETC_GREENWICH",
        "ETC_UCT",
        "ETC_UNIVERSAL",
        "ETC_UTC",
        "ETC_ZULU",
        "EUROPE_AMSTERDAM",
        "EUROPE_ANDORRA",
        "EUROPE_ASTRAKHAN",
        "EUROPE_ATHENS",
        "EUROPE_BELFAST",
        "EUROPE_BELGRADE",
        "EUROPE_BERLIN",
        "EUROPE_BRATISLAVA",
        "EUROPE_BRUSSELS",
        "EUROPE_BUCHAREST",
        "EUROPE_BUDAPEST",
        "EUROPE_BUSINGEN",
        "EUROPE_CHISINAU",
        "EUROPE_COPENHAGEN",
        "EUROPE_DUBLIN",
        "EUROPE_GIBRALTAR",
        "EUROPE_GUERNSEY",
        "EUROPE_HELSINKI",
        "EUROPE_ISLE_OF_MAN",
        "EUROPE_ISTANBUL",
        "EUROPE_JERSEY",
        "EUROPE_KALININGRAD",
        "EUROPE_KIEV",
        "EUROPE_KIROV",
        "EUROPE_LISBON",
        "EUROPE_LJUBLJANA",
        "EUROPE_LONDON",
        "EUROPE_LUXEMBOURG",
        "EUROPE_MADRID",
        "EUROPE_MALTA",
        "EUROPE_MARIEHAMN",
        "EUROPE_MINSK",
        "EUROPE_MONACO",
        "EUROPE_MOSCOW",
        "EUROPE_NICOSIA",
        "EUROPE_OSLO",
        "EUROPE_PARIS",
        "EUROPE_PODGORICA",
        "EUROPE_PRAGUE",
        "EUROPE_RIGA",
        "EUROPE_ROME",
        "EUROPE_SAMARA",
        "EUROPE_SAN_MARINO",
        "EUROPE_SARAJEVO",
        "EUROPE_SARATOV",
        "EUROPE_SIMFEROPOL",
        "EUROPE_SKOPJE",
        "EUROPE_SOFIA",
        "EUROPE_STOCKHOLM",
        "EUROPE_TALLINN",
        "EUROPE_TIRANE",
        "EUROPE_TIRASPOL",
        "EUROPE_ULYANOVSK",
        "EUROPE_UZHGOROD",
        "EUROPE_VADUZ",
        "EUROPE_VATICAN",
        "EUROPE_VIENNA",
        "EUROPE_VILNIUS",
        "EUROPE_VOLGOGRAD",
        "EUROPE_WARSAW",
        "EUROPE_ZAGREB",
        "EUROPE_ZAPOROZHYE",
        "EUROPE_ZURICH",
        "FACTORY",
        "GB",
        "GB_EIRE",
        "GMT",
        "GMT0",
        "GMT_0",
        "GREENWICH",
        "HONGKONG",
        "HST",
        "ICELAND",
        "INDIAN_ANTANANARIVO",
        "INDIAN_CHAGOS",
        "INDIAN_CHRISTMAS",
        "INDIAN_COCOS",
        "INDIAN_COMORO",
        "INDIAN_KERGUELEN",
        "INDIAN_MAHE",
        "INDIAN_MALDIVES",
        "INDIAN_MAURITIUS",
        "INDIAN_MAYOTTE",
        "INDIAN_REUNION",
        "IRAN",
        "ISRAEL",
        "JAMAICA",
        "JAPAN",
        "KWAJALEIN",
        "LIBYA",
        "MET",
        "MEXICO_BAJA_NORTE",
        "MEXICO_BAJA_SUR",
        "MEXICO_GENERAL",
        "MST",
        "MST7_MDT",
        "NAVAJO",
        "NZ",
        "NZ_CHAT",
        "PACIFIC_APIA",
        "PACIFIC_AUCKLAND",
        "PACIFIC_BOUGAINVILLE",
        "PACIFIC_CHATHAM",
        "PACIFIC_CHUUK",
        "PACIFIC_EASTER",
        "PACIFIC_EFATE",
        "PACIFIC_ENDERBURY",
        "PACIFIC_FAKAOFO",
        "PACIFIC_FIJI",
        "PACIFIC_FUNAFUTI",
        "PACIFIC_GALAPAGOS",
        "PACIFIC_GAMBIER",
        "PACIFIC_GUADALCANAL",
        "PACIFIC_GUAM",
        "PACIFIC_HONOLULU",
        "PACIFIC_JOHNSTON",
        "PACIFIC_KIRITIMATI",
        "PACIFIC_KOSRAE",
        "PACIFIC_KWAJALEIN",
        "PACIFIC_MAJURO",
        "PACIFIC_MARQUESAS",
        "PACIFIC_MIDWAY",
        "PACIFIC_NAURU",
        "PACIFIC_NIUE",
        "PACIFIC_NORFOLK",
        "PACIFIC_NOUMEA",
        "PACIFIC_PAGO_PAGO",
        "PACIFIC_PALAU",
        "PACIFIC_PITCAIRN",
        "PACIFIC_POHNPEI",
        "PACIFIC_PONAPE",
        "PACIFIC_PORT_MORESBY",
        "PACIFIC_RAROTONGA",
        "PACIFIC_SAIPAN",
        "PACIFIC_SAMOA",
        "PACIFIC_TAHITI",
        "PACIFIC_TARAWA",
        "PACIFIC_TONGATAPU",
        "PACIFIC_TRUK",
        "PACIFIC_WAKE",
        "PACIFIC_WALLIS",
        "PACIFIC_YAP",
        "POLAND",
        "PORTUGAL",
        "PRC",
        "PST8_PDT",
        "ROC",
        "ROK",
        "SINGAPORE",
        "TURKEY",
        "UCT",
        "UNIVERSAL",
        "US_ALASKA",
        "US_ALEUTIAN",
        "US_ARIZONA",
        "US_CENTRAL",
        "US_EASTERN",
        "US_EAST_INDIANA",
        "US_HAWAII",
        "US_INDIANA_STARKE",
        "US_MICHIGAN",
        "US_MOUNTAIN",
        "US_PACIFIC",
        "US_SAMOA",
        "UTC",
        "WET",
        "W_SU",
        "ZULU",
    )


class Facility(Type, Node):
    id = non_null(int)
    slug = non_null(str)
    name = non_null(str)
    address = str
    city = str
    state = str
    zip = str
    timezone = non_null(Timezone)


class FacilitiesConnection(Type, Node):
    nodes = list_of(Facility)


class FacilityInput(Input):
    name = non_null(str)
    slug = non_null(str)
    timezone = non_null(Timezone)


class CreateFacilityInput(Input):
    facility = Field(non_null("FacilityInput"), graphql_name="facility")


class CreateFacilityPayload(Type):
    facility = Field("Facility", graphql_name="facility")


class MetricLabel(Type):
    source_id = non_null(str)
    label = non_null(str)


class MetricDataAggregationMethod(Enum):
    __choices__ = ("AVG", "COUNT", "FIRST", "LAST", "MAX", "MEDIAN", "MIN", "SUM")


class MetricDataOrderBy(Enum):
    __choices__ = ("TIME_ASC", "TIME_DESC")


class MetricData(Type, Node):
    time = non_null(str)
    source_id = Field(non_null(str), graphql_name="sourceId")
    label = str
    data = str
    metadata = str


class MetricDataConnection(Type, Node):
    nodes = list_of(MetricData)


class Query(Type):
    facilities = Field(FacilitiesConnection)
    metric_labels = Field(non_null(list_of(non_null(MetricLabel))), graphql_name="metricLabels")
    metric_data = Field(
        MetricDataConnection,
        graphql_name="metricData",
        args={
            "source_id": Arg(non_null(str), graphql_name="sourceId", default=None),
            "label": Arg(non_null(str), graphql_name="label", default=None),
        },
    )


class Mutation(Type):
    create_facility = Field(
        CreateFacilityPayload,
        graphql_name="createFacility",
        args={"input": Arg(non_null(CreateFacilityInput))},
    )
