/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.PlainDiagram;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionBrotli;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.code.StringCompressorNone;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.version.PSystemVersion;

public class PSystemDonors
extends PlainDiagram {
    private static final int COLS = 6;
    private static final int FREE_LINES = 6;
    public static final String DONORS = "6sOE03mSS7Dt1Og5J5Uh3hcJits4ZufNcNRmsK-DFu8Mfx004WGrllMtt9JI0K46z1ewUipjEptkDz9VH5UwzqqpHgtN9kKCeleWw07lRWljG-b_VH3cB7aHt9aIN40AYEBeOlcHRkGuVL9bI2baDAVOxcNAl5uXbL9y_if7w1Ducpuwpvr6qQZ_14uVjNqKUr_pyskkhY4MYkLvWX8ewJ8XtKt-nzoQwNi_RQJZ9_3xf44LYw8jtPQiaJOTOzxNjG0TqwxLSYOVJMfMnRYhIB6FHXfsaKneoyNaS-H5dpJ-g9lm4VN8a8ow0ZhBwkZykRUlxudvbui-ucG9lg5eWH6m7bcBQ74UUj2mSC3GiejYR5NXo9DqIEH12tdpZy8KHahEBeERXbK38EpUWGeaEQXD3MSx3mEgJB55NmWtNUeFbixxibAgq9M6Pn8RAnErW2f5OeCkwCwSjw-cQlK0HwIdH2riFShdEFRI3olwffSImVhQEYnBy5UKiakfwRXzf_hTfmHmXBHyvyEO8fGJQCfW2cNyMe76LUYkjM2BZgiSBAH3rCSjDdtOt7XeHOHZCgL2hUENiPrgXJzqAS7693m95lAUzgNK0WussQf92-0BhKfwx7m1oL3mSj3ZE_w-TxYcKfAy8T56E4FIJy-p7SrG2D2nPSo6RgR0OjnbLM-n1H7iKJewG3j2qWbdyt7PctsGVkKd0Dv2GdIxJHpjuDzVkZ9rv29D97HJ6Yk0jQSLTT6mUGI3Mar5DsDACBsDSzpfex7F6SUQPT4cpriDniXlrEcAXUKo5PbkMAcdDnU-OzjBknJtoHYykjqdHrq5k9HxJzcuzuiCnBcQ35IAJ7Uy-vktB3C8YrdySxs2qhDc3suUkZFOpcBHCcQsClMG5S3WK99gVIGQIuYHtWx85lYr4Jq2oAznf0OFC_BWzMF9DTKSqx3OP14ZcuJ8jZQls3k7SXwmv-LFScIKIBduwb58oE_OM4IqojeeRTYOxmeyGr8KvEMyUrOzmRywC7K1rQcY82WjMAiajA-U3v21UsSzIos9CrvnOK7TwdPWcg3uIXHjFRc1OWhC314-CF14Cf2LiakV617uxe-xpIEb3ktusvTTZ8EakIG6gY3Xr3TK4mtM7k78Uel_VsxTO2V-_5zhskJKRi_UGn0zWOG0X7k18UC24E8fyFLcmnp0AIm9qK72bQlMdWUY6Ena37PHTompgZT-PxaPkMdjzKDLdffIL3Zf1x9V18lskgPKwJO4dMgoFxmHBd8mjd-9AhDItBlAQ4Tb97mIYZY-u_HoG3EM3j22DL17WNztVrOMQXfhlqAfF9m0-MP3KgcPheNLbjR6Gc2ZNDZVMxTJpipFoi0-XzM5uweUsWOfRgGOKVWsA2xF21CpYQI927PFoOa78tpZGRwe5afYQLkxdJbO8VzZFuOt4WxP8GrqwZ6bFDs07BP9zx5Le3-Gzn0UoCHYdQui5aebF90YAPYhM2Oof4sq6UVs1Z0e2iR_znQKAqmqFw7PfLOsahaCQpSf8FAX_iuIM-HihKZ7lhlciitJS_lM9XFisF_0ZvzlVrJTV1C1TKHt9NZTFiY76zjKLx15ovibtCTbiMuclunBqIvH3MpUTpPgA9k1Gaf2Y7WWL4XVutvDVyAMSu5yUlrbBWpKy3nH3JruRWPMa6qql4eQKBt8ujpwVijDtZcGEV7OuC8gOwU7EJrQPgXjDsssa44bSkUAiPx1x1ubLJwLCQYKhgaQ2sgMXDPbPmSw0-Cjv8hvlNrhOGQN-YNcCy4f1fgINXh8X0Pa4Kb13KHNoNxLYZEaPwPLuYrMjfA6gMvKGwFTO57SaIUUpER31W00";

    public PSystemDonors(UmlSource source) {
        super(source);
    }

    @Override
    protected UDrawable getRootDrawable(FileFormatOption fileFormatOption) throws IOException {
        final List<TextBlock> cols = PSystemDonors.getCols(this.getDonors(), 6, 6);
        return new UDrawable(){

            @Override
            public void drawU(UGraphic ug) {
                TextBlockBackcolored header = GraphicStrings.createBlackOnWhite(Arrays.asList("<b>Special thanks to our sponsors and donors !"));
                header.drawU(ug);
                StringBounder stringBounder = ug.getStringBounder();
                ug = ug.apply(UTranslate.dy(header.calculateDimension(stringBounder).getHeight()));
                double x = 0.0;
                double lastX = 0.0;
                double y = 0.0;
                for (TextBlock tb : cols) {
                    Dimension2D dim = tb.calculateDimension(stringBounder);
                    tb.drawU(ug.apply(UTranslate.dx(x)));
                    lastX = x;
                    x += dim.getWidth() + 10.0;
                    y = Math.max(y, dim.getHeight());
                }
                UImage logo = new UImage(new PixelImage(PSystemVersion.getPlantumlImage(), AffineTransformType.TYPE_BILINEAR));
                ug.apply(new UTranslate(lastX, y - (double)logo.getHeight())).draw(logo);
            }
        };
    }

    public static List<TextBlock> getCols(List<String> lines, int nbCol, int reserved) throws IOException {
        ArrayList<TextBlock> result = new ArrayList<TextBlock>();
        int maxLine = (lines.size() + (nbCol - 1) + reserved) / nbCol;
        for (int i = 0; i < lines.size(); i += maxLine) {
            List<String> current = lines.subList(i, Math.min(lines.size(), i + maxLine));
            result.add(GraphicStrings.createBlackOnWhite(current));
        }
        return result;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        Transcoder t = TranscoderImpl.utf8(new AsciiEncoder(), new StringCompressorNone(), new CompressionBrotli());
        try {
            String s = t.decode(DONORS).replace('*', '.');
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                lines.add(st.nextToken());
            }
        }
        catch (NoPlantumlCompressionException e) {
            e.printStackTrace();
        }
        return lines;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Donors)");
    }

    public static PSystemDonors create(UmlSource source) {
        return new PSystemDonors(source);
    }
}

