# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import Dict, List, Any


class AddVpcHoneyPotRequest(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
    ):
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AddVpcHoneyPotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddVpcHoneyPotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: AddVpcHoneyPotResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = AddVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckSecurityEventIdRequest(TeaModel):
    def __init__(
        self,
        security_event_ids: List[str] = None,
        uuid: str = None,
    ):
        self.security_event_ids = security_event_ids
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CheckSecurityEventIdResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckSecurityEventIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CheckSecurityEventIdResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CheckSecurityEventIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAntiBruteForceRuleRequest(TeaModel):
    def __init__(
        self,
        default_rule: bool = None,
        fail_count: int = None,
        forbidden_time: int = None,
        name: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        span: int = None,
        uuid_list: List[str] = None,
    ):
        self.default_rule = default_rule
        self.fail_count = fail_count
        self.forbidden_time = forbidden_time
        self.name = name
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip
        self.span = span
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
    ):
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(
        self,
        create_anti_brute_force_rule: CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule = None,
        request_id: str = None,
    ):
        self.create_anti_brute_force_rule = create_anti_brute_force_rule
        self.request_id = request_id

    def validate(self):
        if self.create_anti_brute_force_rule:
            self.create_anti_brute_force_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_anti_brute_force_rule is not None:
            result['CreateAntiBruteForceRule'] = self.create_anti_brute_force_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateAntiBruteForceRule') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule()
            self.create_anti_brute_force_rule = temp_model.from_map(m['CreateAntiBruteForceRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAntiBruteForceRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateAntiBruteForceRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        policy: Dict[str, Any] = None,
        policy_region_id: str = None,
        policy_version: str = None,
        uuid_list: List[str] = None,
    ):
        self.name = name
        self.policy = policy
        self.policy_region_id = policy_region_id
        self.policy_version = policy_version
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        policy_shrink: str = None,
        policy_region_id: str = None,
        policy_version: str = None,
        uuid_list: List[str] = None,
    ):
        self.name = name
        self.policy_shrink = policy_shrink
        self.policy_region_id = policy_region_id
        self.policy_version = policy_version
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_shrink is not None:
            result['Policy'] = self.policy_shrink
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy_shrink = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateAssetGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        group_name: str = None,
        uuids: str = None,
    ):
        self.group_id = group_id
        self.group_name = group_name
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class CreateOrUpdateAssetGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        request_id: str = None,
    ):
        self.group_id = group_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateAssetGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateOrUpdateAssetGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateAssetGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceLinkedRoleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateServiceLinkedRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateServiceLinkedRoleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateServiceLinkedRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSimilarSecurityEventsQueryTaskRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        security_event_id: int = None,
        similar_event_scenario_code: str = None,
        source_ip: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.security_event_id = security_event_id
        self.similar_event_scenario_code = similar_event_scenario_code
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.similar_event_scenario_code is not None:
            result['SimilarEventScenarioCode'] = self.similar_event_scenario_code
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('SimilarEventScenarioCode') is not None:
            self.similar_event_scenario_code = m.get('SimilarEventScenarioCode')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(
        self,
        status: str = None,
        task_id: int = None,
    ):
        self.status = status
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBody(TeaModel):
    def __init__(
        self,
        create_similar_security_events_query_task_response: CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse = None,
        request_id: str = None,
    ):
        self.create_similar_security_events_query_task_response = create_similar_security_events_query_task_response
        self.request_id = request_id

    def validate(self):
        if self.create_similar_security_events_query_task_response:
            self.create_similar_security_events_query_task_response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_similar_security_events_query_task_response is not None:
            result['CreateSimilarSecurityEventsQueryTaskResponse'] = self.create_similar_security_events_query_task_response.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateSimilarSecurityEventsQueryTaskResponse') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse()
            self.create_similar_security_events_query_task_response = temp_model.from_map(m['CreateSimilarSecurityEventsQueryTaskResponse'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateSimilarSecurityEventsQueryTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVulAutoRepairConfigRequestVulAutoRepairConfigList(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        name: str = None,
    ):
        # 漏洞别名
        self.alias_name = alias_name
        # 漏洞名称
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateVulAutoRepairConfigRequest(TeaModel):
    def __init__(
        self,
        reason: str = None,
        type: str = None,
        vul_auto_repair_config_list: List[CreateVulAutoRepairConfigRequestVulAutoRepairConfigList] = None,
    ):
        self.reason = reason
        # 漏洞类型
        self.type = type
        self.vul_auto_repair_config_list = vul_auto_repair_config_list

    def validate(self):
        if self.vul_auto_repair_config_list:
            for k in self.vul_auto_repair_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.type is not None:
            result['Type'] = self.type
        result['VulAutoRepairConfigList'] = []
        if self.vul_auto_repair_config_list is not None:
            for k in self.vul_auto_repair_config_list:
                result['VulAutoRepairConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        self.vul_auto_repair_config_list = []
        if m.get('VulAutoRepairConfigList') is not None:
            for k in m.get('VulAutoRepairConfigList'):
                temp_model = CreateVulAutoRepairConfigRequestVulAutoRepairConfigList()
                self.vul_auto_repair_config_list.append(temp_model.from_map(k))
        return self


class CreateVulAutoRepairConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateVulAutoRepairConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: CreateVulAutoRepairConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = CreateVulAutoRepairConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
        policy_version: str = None,
    ):
        self.id = id
        self.policy_version = policy_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        return self


class DeleteBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyMachineRequest(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
        policy_version: str = None,
        uuid: str = None,
        uuid_list: List[str] = None,
    ):
        self.policy_id = policy_id
        self.policy_version = policy_version
        self.uuid = uuid
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteBackupPolicyMachineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyMachineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteBackupPolicyMachineResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyMachineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        source_ip: str = None,
    ):
        self.group_id = group_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLoginBaseConfigRequest(TeaModel):
    def __init__(
        self,
        config: str = None,
        target: str = None,
        type: str = None,
    ):
        self.config = config
        self.target = target
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.target is not None:
            result['Target'] = self.target
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteLoginBaseConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLoginBaseConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteLoginBaseConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteLoginBaseConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStrategyRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        self.id = id
        self.lang = lang
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteStrategyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTagWithUuidRequest(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        uuid_list: str = None,
    ):
        self.tag_name = tag_name
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteTagWithUuidResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTagWithUuidResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteTagWithUuidResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteTagWithUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcHoneyPotRequest(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
    ):
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DeleteVpcHoneyPotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcHoneyPotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DeleteVpcHoneyPotResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DeleteVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccesskeyLeakListRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        query: str = None,
        start_ts: int = None,
        status: str = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.query = query
        self.start_ts = start_ts
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList(TeaModel):
    def __init__(
        self,
        accesskey_id: str = None,
        ali_user_name: str = None,
        asset: str = None,
        deal_time: str = None,
        deal_type: str = None,
        gmt_modified: int = None,
        id: int = None,
        status: str = None,
        type: str = None,
        url: str = None,
        user_type: str = None,
    ):
        self.accesskey_id = accesskey_id
        self.ali_user_name = ali_user_name
        self.asset = asset
        self.deal_time = deal_time
        self.deal_type = deal_type
        self.gmt_modified = gmt_modified
        self.id = id
        self.status = status
        self.type = type
        self.url = url
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accesskey_id is not None:
            result['AccesskeyId'] = self.accesskey_id
        if self.ali_user_name is not None:
            result['AliUserName'] = self.ali_user_name
        if self.asset is not None:
            result['Asset'] = self.asset
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_type is not None:
            result['DealType'] = self.deal_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccesskeyId') is not None:
            self.accesskey_id = m.get('AccesskeyId')
        if m.get('AliUserName') is not None:
            self.ali_user_name = m.get('AliUserName')
        if m.get('Asset') is not None:
            self.asset = m.get('Asset')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealType') is not None:
            self.deal_type = m.get('DealType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class DescribeAccesskeyLeakListResponseBody(TeaModel):
    def __init__(
        self,
        access_key_leak_list: List[DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList] = None,
        ak_leak_count: int = None,
        current_page: int = None,
        gmt_last: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.access_key_leak_list = access_key_leak_list
        self.ak_leak_count = ak_leak_count
        self.current_page = current_page
        self.gmt_last = gmt_last
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.access_key_leak_list:
            for k in self.access_key_leak_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccessKeyLeakList'] = []
        if self.access_key_leak_list is not None:
            for k in self.access_key_leak_list:
                result['AccessKeyLeakList'].append(k.to_map() if k else None)
        if self.ak_leak_count is not None:
            result['AkLeakCount'] = self.ak_leak_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.access_key_leak_list = []
        if m.get('AccessKeyLeakList') is not None:
            for k in m.get('AccessKeyLeakList'):
                temp_model = DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList()
                self.access_key_leak_list.append(temp_model.from_map(k))
        if m.get('AkLeakCount') is not None:
            self.ak_leak_count = m.get('AkLeakCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAccesskeyLeakListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAccesskeyLeakListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAccesskeyLeakListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAffectedMaliciousFileImagesRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        current_page: int = None,
        image_digest: str = None,
        image_layer: str = None,
        image_tag: str = None,
        lang: str = None,
        malicious_md_5: str = None,
        page_size: str = None,
        repo_id: str = None,
        repo_instance_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        repo_region_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.current_page = current_page
        self.image_digest = image_digest
        self.image_layer = image_layer
        self.image_tag = image_tag
        self.lang = lang
        self.malicious_md_5 = malicious_md_5
        self.page_size = page_size
        self.repo_id = repo_id
        self.repo_instance_id = repo_instance_id
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace
        self.repo_region_id = repo_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(
        self,
        digest: str = None,
        download_url: str = None,
        file_path: str = None,
        first_scan_timestamp: int = None,
        high_light: str = None,
        image_uuid: str = None,
        latest_scan_timestamp: int = None,
        latest_verify_timestamp: int = None,
        layer: str = None,
        level: str = None,
        malicious_md_5: str = None,
        namespace: str = None,
        repo_id: str = None,
        repo_instance_id: str = None,
        repo_name: str = None,
        repo_region_id: str = None,
        status: int = None,
        tag: str = None,
    ):
        self.digest = digest
        self.download_url = download_url
        self.file_path = file_path
        self.first_scan_timestamp = first_scan_timestamp
        self.high_light = high_light
        self.image_uuid = image_uuid
        self.latest_scan_timestamp = latest_scan_timestamp
        self.latest_verify_timestamp = latest_verify_timestamp
        self.layer = layer
        self.level = level
        self.malicious_md_5 = malicious_md_5
        self.namespace = namespace
        self.repo_id = repo_id
        self.repo_instance_id = repo_instance_id
        self.repo_name = repo_name
        self.repo_region_id = repo_region_id
        self.status = status
        self.tag = tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.first_scan_timestamp is not None:
            result['FirstScanTimestamp'] = self.first_scan_timestamp
        if self.high_light is not None:
            result['HighLight'] = self.high_light
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.latest_scan_timestamp is not None:
            result['LatestScanTimestamp'] = self.latest_scan_timestamp
        if self.latest_verify_timestamp is not None:
            result['LatestVerifyTimestamp'] = self.latest_verify_timestamp
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.level is not None:
            result['Level'] = self.level
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('FirstScanTimestamp') is not None:
            self.first_scan_timestamp = m.get('FirstScanTimestamp')
        if m.get('HighLight') is not None:
            self.high_light = m.get('HighLight')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('LatestScanTimestamp') is not None:
            self.latest_scan_timestamp = m.get('LatestScanTimestamp')
        if m.get('LatestVerifyTimestamp') is not None:
            self.latest_verify_timestamp = m.get('LatestVerifyTimestamp')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAffectedMaliciousFileImagesResponseBody(TeaModel):
    def __init__(
        self,
        affected_malicious_file_images_response: List[DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse] = None,
        page_info: DescribeAffectedMaliciousFileImagesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.affected_malicious_file_images_response = affected_malicious_file_images_response
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.affected_malicious_file_images_response:
            for k in self.affected_malicious_file_images_response:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AffectedMaliciousFileImagesResponse'] = []
        if self.affected_malicious_file_images_response is not None:
            for k in self.affected_malicious_file_images_response:
                result['AffectedMaliciousFileImagesResponse'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.affected_malicious_file_images_response = []
        if m.get('AffectedMaliciousFileImagesResponse') is not None:
            for k in m.get('AffectedMaliciousFileImagesResponse'):
                temp_model = DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse()
                self.affected_malicious_file_images_response.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAffectedMaliciousFileImagesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventDetailRequest(TeaModel):
    def __init__(
        self,
        alarm_unique_info: str = None,
        from_: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        self.alarm_unique_info = alarm_unique_info
        self.from_ = from_
        self.lang = lang
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        value: str = None,
    ):
        self.name = name
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetails(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue] = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        if self.value:
            for k in self.value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        self.value = []
        if m.get('Value') is not None:
            for k in m.get('Value'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue()
                self.value.append(temp_model.from_map(k))
        return self


class DescribeAlarmEventDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        alarm_event_alias_name: str = None,
        alarm_event_desc: str = None,
        alarm_unique_info: str = None,
        app_name: str = None,
        can_be_deal_on_line: bool = None,
        can_cancel_fault: bool = None,
        cause_details: List[DescribeAlarmEventDetailResponseBodyDataCauseDetails] = None,
        contain_hw_mode: bool = None,
        container_id: str = None,
        container_image_id: str = None,
        container_image_name: str = None,
        data_source: str = None,
        end_time: int = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        k_8s_cluster_id: str = None,
        k_8s_cluster_name: str = None,
        k_8s_namespace: str = None,
        k_8s_node_id: str = None,
        k_8s_node_name: str = None,
        k_8s_pod_name: str = None,
        level: str = None,
        solution: str = None,
        start_time: int = None,
        type: str = None,
        uuid: str = None,
    ):
        self.alarm_event_alias_name = alarm_event_alias_name
        self.alarm_event_desc = alarm_event_desc
        self.alarm_unique_info = alarm_unique_info
        self.app_name = app_name
        self.can_be_deal_on_line = can_be_deal_on_line
        self.can_cancel_fault = can_cancel_fault
        self.cause_details = cause_details
        self.contain_hw_mode = contain_hw_mode
        self.container_id = container_id
        self.container_image_id = container_image_id
        self.container_image_name = container_image_name
        self.data_source = data_source
        self.end_time = end_time
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.k_8s_cluster_id = k_8s_cluster_id
        self.k_8s_cluster_name = k_8s_cluster_name
        self.k_8s_namespace = k_8s_namespace
        self.k_8s_node_id = k_8s_node_id
        self.k_8s_node_name = k_8s_node_name
        self.k_8s_pod_name = k_8s_pod_name
        self.level = level
        self.solution = solution
        self.start_time = start_time
        self.type = type
        self.uuid = uuid

    def validate(self):
        if self.cause_details:
            for k in self.cause_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_alias_name is not None:
            result['AlarmEventAliasName'] = self.alarm_event_alias_name
        if self.alarm_event_desc is not None:
            result['AlarmEventDesc'] = self.alarm_event_desc
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        result['CauseDetails'] = []
        if self.cause_details is not None:
            for k in self.cause_details:
                result['CauseDetails'].append(k.to_map() if k else None)
        if self.contain_hw_mode is not None:
            result['ContainHwMode'] = self.contain_hw_mode
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.container_image_id is not None:
            result['ContainerImageId'] = self.container_image_id
        if self.container_image_name is not None:
            result['ContainerImageName'] = self.container_image_name
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.k_8s_cluster_name is not None:
            result['K8sClusterName'] = self.k_8s_cluster_name
        if self.k_8s_namespace is not None:
            result['K8sNamespace'] = self.k_8s_namespace
        if self.k_8s_node_id is not None:
            result['K8sNodeId'] = self.k_8s_node_id
        if self.k_8s_node_name is not None:
            result['K8sNodeName'] = self.k_8s_node_name
        if self.k_8s_pod_name is not None:
            result['K8sPodName'] = self.k_8s_pod_name
        if self.level is not None:
            result['Level'] = self.level
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmEventAliasName') is not None:
            self.alarm_event_alias_name = m.get('AlarmEventAliasName')
        if m.get('AlarmEventDesc') is not None:
            self.alarm_event_desc = m.get('AlarmEventDesc')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        self.cause_details = []
        if m.get('CauseDetails') is not None:
            for k in m.get('CauseDetails'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetails()
                self.cause_details.append(temp_model.from_map(k))
        if m.get('ContainHwMode') is not None:
            self.contain_hw_mode = m.get('ContainHwMode')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('ContainerImageId') is not None:
            self.container_image_id = m.get('ContainerImageId')
        if m.get('ContainerImageName') is not None:
            self.container_image_name = m.get('ContainerImageName')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('K8sClusterName') is not None:
            self.k_8s_cluster_name = m.get('K8sClusterName')
        if m.get('K8sNamespace') is not None:
            self.k_8s_namespace = m.get('K8sNamespace')
        if m.get('K8sNodeId') is not None:
            self.k_8s_node_id = m.get('K8sNodeId')
        if m.get('K8sNodeName') is not None:
            self.k_8s_node_name = m.get('K8sNodeName')
        if m.get('K8sPodName') is not None:
            self.k_8s_pod_name = m.get('K8sPodName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAlarmEventDetailResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeAlarmEventDetailResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeAlarmEventDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAlarmEventDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAlarmEventDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventListRequest(TeaModel):
    def __init__(
        self,
        alarm_event_name: str = None,
        alarm_event_type: str = None,
        current_page: int = None,
        dealed: str = None,
        from_: str = None,
        group_id: str = None,
        lang: str = None,
        levels: str = None,
        operate_error_code_list: List[str] = None,
        page_size: str = None,
        remark: str = None,
        source_ip: str = None,
        tactic_id: str = None,
    ):
        self.alarm_event_name = alarm_event_name
        self.alarm_event_type = alarm_event_type
        self.current_page = current_page
        self.dealed = dealed
        self.from_ = from_
        self.group_id = group_id
        self.lang = lang
        self.levels = levels
        self.operate_error_code_list = operate_error_code_list
        self.page_size = page_size
        self.remark = remark
        self.source_ip = source_ip
        self.tactic_id = tactic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.from_ is not None:
            result['From'] = self.from_
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.operate_error_code_list is not None:
            result['OperateErrorCodeList'] = self.operate_error_code_list
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.tactic_id is not None:
            result['TacticId'] = self.tactic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('OperateErrorCodeList') is not None:
            self.operate_error_code_list = m.get('OperateErrorCodeList')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TacticId') is not None:
            self.tactic_id = m.get('TacticId')
        return self


class DescribeAlarmEventListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAlarmEventListResponseBodySuspEventsTacticItems(TeaModel):
    def __init__(
        self,
        tactic_display_name: str = None,
        tactic_id: str = None,
    ):
        self.tactic_display_name = tactic_display_name
        self.tactic_id = tactic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tactic_display_name is not None:
            result['TacticDisplayName'] = self.tactic_display_name
        if self.tactic_id is not None:
            result['TacticId'] = self.tactic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TacticDisplayName') is not None:
            self.tactic_display_name = m.get('TacticDisplayName')
        if m.get('TacticId') is not None:
            self.tactic_id = m.get('TacticId')
        return self


class DescribeAlarmEventListResponseBodySuspEvents(TeaModel):
    def __init__(
        self,
        alarm_event_name: str = None,
        alarm_event_name_original: str = None,
        alarm_event_type: str = None,
        alarm_unique_info: str = None,
        can_be_deal_on_line: bool = None,
        can_cancel_fault: bool = None,
        data_source: str = None,
        dealed: bool = None,
        description: str = None,
        end_time: int = None,
        gmt_modified: int = None,
        has_trace_info: bool = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        level: str = None,
        operate_error_code: str = None,
        operate_time: int = None,
        sale_version: str = None,
        security_event_ids: str = None,
        solution: str = None,
        stages: str = None,
        start_time: int = None,
        suspicious_event_count: int = None,
        tactic_items: List[DescribeAlarmEventListResponseBodySuspEventsTacticItems] = None,
        uuid: str = None,
    ):
        self.alarm_event_name = alarm_event_name
        self.alarm_event_name_original = alarm_event_name_original
        self.alarm_event_type = alarm_event_type
        self.alarm_unique_info = alarm_unique_info
        self.can_be_deal_on_line = can_be_deal_on_line
        self.can_cancel_fault = can_cancel_fault
        self.data_source = data_source
        self.dealed = dealed
        self.description = description
        self.end_time = end_time
        self.gmt_modified = gmt_modified
        self.has_trace_info = has_trace_info
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.level = level
        self.operate_error_code = operate_error_code
        self.operate_time = operate_time
        self.sale_version = sale_version
        self.security_event_ids = security_event_ids
        self.solution = solution
        self.stages = stages
        self.start_time = start_time
        self.suspicious_event_count = suspicious_event_count
        # 攻击阶段展示名
        self.tactic_items = tactic_items
        self.uuid = uuid

    def validate(self):
        if self.tactic_items:
            for k in self.tactic_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.alarm_event_name_original is not None:
            result['AlarmEventNameOriginal'] = self.alarm_event_name_original
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.has_trace_info is not None:
            result['HasTraceInfo'] = self.has_trace_info
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.level is not None:
            result['Level'] = self.level
        if self.operate_error_code is not None:
            result['OperateErrorCode'] = self.operate_error_code
        if self.operate_time is not None:
            result['OperateTime'] = self.operate_time
        if self.sale_version is not None:
            result['SaleVersion'] = self.sale_version
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.stages is not None:
            result['Stages'] = self.stages
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.suspicious_event_count is not None:
            result['SuspiciousEventCount'] = self.suspicious_event_count
        result['TacticItems'] = []
        if self.tactic_items is not None:
            for k in self.tactic_items:
                result['TacticItems'].append(k.to_map() if k else None)
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('AlarmEventNameOriginal') is not None:
            self.alarm_event_name_original = m.get('AlarmEventNameOriginal')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HasTraceInfo') is not None:
            self.has_trace_info = m.get('HasTraceInfo')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('OperateErrorCode') is not None:
            self.operate_error_code = m.get('OperateErrorCode')
        if m.get('OperateTime') is not None:
            self.operate_time = m.get('OperateTime')
        if m.get('SaleVersion') is not None:
            self.sale_version = m.get('SaleVersion')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('Stages') is not None:
            self.stages = m.get('Stages')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SuspiciousEventCount') is not None:
            self.suspicious_event_count = m.get('SuspiciousEventCount')
        self.tactic_items = []
        if m.get('TacticItems') is not None:
            for k in m.get('TacticItems'):
                temp_model = DescribeAlarmEventListResponseBodySuspEventsTacticItems()
                self.tactic_items.append(temp_model.from_map(k))
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAlarmEventListResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeAlarmEventListResponseBodyPageInfo = None,
        request_id: str = None,
        susp_events: List[DescribeAlarmEventListResponseBodySuspEvents] = None,
    ):
        self.page_info = page_info
        self.request_id = request_id
        self.susp_events = susp_events

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.susp_events:
            for k in self.susp_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SuspEvents'] = []
        if self.susp_events is not None:
            for k in self.susp_events:
                result['SuspEvents'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeAlarmEventListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.susp_events = []
        if m.get('SuspEvents') is not None:
            for k in m.get('SuspEvents'):
                temp_model = DescribeAlarmEventListResponseBodySuspEvents()
                self.susp_events.append(temp_model.from_map(k))
        return self


class DescribeAlarmEventListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAlarmEventListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllEntityResponseBodyEntityList(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        os: str = None,
        uuid: str = None,
    ):
        self.group_id = group_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.ip = ip
        self.os = os
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAllEntityResponseBody(TeaModel):
    def __init__(
        self,
        entity_list: List[DescribeAllEntityResponseBodyEntityList] = None,
        request_id: str = None,
    ):
        self.entity_list = entity_list
        self.request_id = request_id

    def validate(self):
        if self.entity_list:
            for k in self.entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EntityList'] = []
        if self.entity_list is not None:
            for k in self.entity_list:
                result['EntityList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.entity_list = []
        if m.get('EntityList') is not None:
            for k in m.get('EntityList'):
                temp_model = DescribeAllEntityResponseBodyEntityList()
                self.entity_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAllEntityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAllEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllGroupsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAllGroupsResponseBodyGroups(TeaModel):
    def __init__(
        self,
        group_flag: int = None,
        group_id: int = None,
        group_name: str = None,
    ):
        self.group_flag = group_flag
        self.group_id = group_id
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DescribeAllGroupsResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        groups: List[DescribeAllGroupsResponseBodyGroups] = None,
        request_id: str = None,
    ):
        self.count = count
        self.groups = groups
        self.request_id = request_id

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = DescribeAllGroupsResponseBodyGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAllGroupsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAllGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAntiBruteForceRulesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAntiBruteForceRulesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAntiBruteForceRulesResponseBodyRules(TeaModel):
    def __init__(
        self,
        default_rule: bool = None,
        enable_smart_rule: bool = None,
        fail_count: int = None,
        forbidden_time: int = None,
        id: int = None,
        machine_count: int = None,
        name: str = None,
        span: int = None,
        uuid_list: List[str] = None,
    ):
        self.default_rule = default_rule
        self.enable_smart_rule = enable_smart_rule
        self.fail_count = fail_count
        self.forbidden_time = forbidden_time
        self.id = id
        self.machine_count = machine_count
        self.name = name
        self.span = span
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.enable_smart_rule is not None:
            result['EnableSmartRule'] = self.enable_smart_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.id is not None:
            result['Id'] = self.id
        if self.machine_count is not None:
            result['MachineCount'] = self.machine_count
        if self.name is not None:
            result['Name'] = self.name
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('EnableSmartRule') is not None:
            self.enable_smart_rule = m.get('EnableSmartRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MachineCount') is not None:
            self.machine_count = m.get('MachineCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeAntiBruteForceRulesResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeAntiBruteForceRulesResponseBodyPageInfo = None,
        request_id: str = None,
        rules: List[DescribeAntiBruteForceRulesResponseBodyRules] = None,
    ):
        self.page_info = page_info
        self.request_id = request_id
        self.rules = rules

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeAntiBruteForceRulesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeAntiBruteForceRulesResponseBodyRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeAntiBruteForceRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAntiBruteForceRulesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAntiBruteForceRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetDetailByUuidRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
        uuid: str = None,
    ):
        self.lang = lang
        self.source_ip = source_ip
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAssetDetailByUuidResponseBodyAssetDetail(TeaModel):
    def __init__(
        self,
        asset_type: str = None,
        auth_modify_time: int = None,
        auth_version: int = None,
        bind: bool = None,
        client_status: str = None,
        client_version: str = None,
        cpu: int = None,
        cpu_info: str = None,
        create_time: int = None,
        disk_info_list: List[str] = None,
        flag: int = None,
        group_trace: str = None,
        host_name: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        ip_list: List[str] = None,
        kernel: str = None,
        mac_list: List[str] = None,
        mem: int = None,
        memory: int = None,
        os: str = None,
        os_detail: str = None,
        os_name: str = None,
        region: str = None,
        region_id: str = None,
        region_name: str = None,
        sys_info: str = None,
        tag: str = None,
        uuid: str = None,
        vpc_instance_id: str = None,
    ):
        self.asset_type = asset_type
        self.auth_modify_time = auth_modify_time
        self.auth_version = auth_version
        self.bind = bind
        self.client_status = client_status
        self.client_version = client_version
        self.cpu = cpu
        self.cpu_info = cpu_info
        self.create_time = create_time
        self.disk_info_list = disk_info_list
        self.flag = flag
        self.group_trace = group_trace
        self.host_name = host_name
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.ip = ip
        self.ip_list = ip_list
        self.kernel = kernel
        self.mac_list = mac_list
        self.mem = mem
        self.memory = memory
        self.os = os
        self.os_detail = os_detail
        self.os_name = os_name
        self.region = region
        self.region_id = region_id
        self.region_name = region_name
        self.sys_info = sys_info
        self.tag = tag
        self.uuid = uuid
        self.vpc_instance_id = vpc_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.auth_modify_time is not None:
            result['AuthModifyTime'] = self.auth_modify_time
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.cpu_info is not None:
            result['CpuInfo'] = self.cpu_info
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.disk_info_list is not None:
            result['DiskInfoList'] = self.disk_info_list
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.group_trace is not None:
            result['GroupTrace'] = self.group_trace
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.ip_list is not None:
            result['IpList'] = self.ip_list
        if self.kernel is not None:
            result['Kernel'] = self.kernel
        if self.mac_list is not None:
            result['MacList'] = self.mac_list
        if self.mem is not None:
            result['Mem'] = self.mem
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.os is not None:
            result['Os'] = self.os
        if self.os_detail is not None:
            result['OsDetail'] = self.os_detail
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.sys_info is not None:
            result['SysInfo'] = self.sys_info
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('AuthModifyTime') is not None:
            self.auth_modify_time = m.get('AuthModifyTime')
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CpuInfo') is not None:
            self.cpu_info = m.get('CpuInfo')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DiskInfoList') is not None:
            self.disk_info_list = m.get('DiskInfoList')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('GroupTrace') is not None:
            self.group_trace = m.get('GroupTrace')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IpList') is not None:
            self.ip_list = m.get('IpList')
        if m.get('Kernel') is not None:
            self.kernel = m.get('Kernel')
        if m.get('MacList') is not None:
            self.mac_list = m.get('MacList')
        if m.get('Mem') is not None:
            self.mem = m.get('Mem')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsDetail') is not None:
            self.os_detail = m.get('OsDetail')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('SysInfo') is not None:
            self.sys_info = m.get('SysInfo')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        return self


class DescribeAssetDetailByUuidResponseBody(TeaModel):
    def __init__(
        self,
        asset_detail: DescribeAssetDetailByUuidResponseBodyAssetDetail = None,
        request_id: str = None,
    ):
        self.asset_detail = asset_detail
        self.request_id = request_id

    def validate(self):
        if self.asset_detail:
            self.asset_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_detail is not None:
            result['AssetDetail'] = self.asset_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetDetail') is not None:
            temp_model = DescribeAssetDetailByUuidResponseBodyAssetDetail()
            self.asset_detail = temp_model.from_map(m['AssetDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetDetailByUuidResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAssetDetailByUuidResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAssetDetailByUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetDetailByUuidsRequest(TeaModel):
    def __init__(
        self,
        uuids: str = None,
    ):
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeAssetDetailByUuidsResponseBodyAssetList(TeaModel):
    def __init__(
        self,
        asset_type: str = None,
        client_status: str = None,
        flag: int = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        os: str = None,
        os_name: str = None,
        region: str = None,
        region_id: str = None,
        region_name: str = None,
        uuid: str = None,
        vpc_instance_id: str = None,
    ):
        self.asset_type = asset_type
        self.client_status = client_status
        self.flag = flag
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.ip = ip
        self.os = os
        self.os_name = os_name
        self.region = region
        self.region_id = region_id
        self.region_name = region_name
        self.uuid = uuid
        self.vpc_instance_id = vpc_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        return self


class DescribeAssetDetailByUuidsResponseBody(TeaModel):
    def __init__(
        self,
        asset_list: List[DescribeAssetDetailByUuidsResponseBodyAssetList] = None,
        request_id: str = None,
    ):
        self.asset_list = asset_list
        self.request_id = request_id

    def validate(self):
        if self.asset_list:
            for k in self.asset_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssetList'] = []
        if self.asset_list is not None:
            for k in self.asset_list:
                result['AssetList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.asset_list = []
        if m.get('AssetList') is not None:
            for k in m.get('AssetList'):
                temp_model = DescribeAssetDetailByUuidsResponseBodyAssetList()
                self.asset_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetDetailByUuidsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAssetDetailByUuidsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAssetDetailByUuidsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetSummaryResponseBodyAssetsSummary(TeaModel):
    def __init__(
        self,
        total_core_num: int = None,
    ):
        self.total_core_num = total_core_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_core_num is not None:
            result['TotalCoreNum'] = self.total_core_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalCoreNum') is not None:
            self.total_core_num = m.get('TotalCoreNum')
        return self


class DescribeAssetSummaryResponseBody(TeaModel):
    def __init__(
        self,
        assets_summary: DescribeAssetSummaryResponseBodyAssetsSummary = None,
        request_id: str = None,
    ):
        self.assets_summary = assets_summary
        self.request_id = request_id

    def validate(self):
        if self.assets_summary:
            self.assets_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assets_summary is not None:
            result['AssetsSummary'] = self.assets_summary.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetsSummary') is not None:
            temp_model = DescribeAssetSummaryResponseBodyAssetsSummary()
            self.assets_summary = temp_model.from_map(m['AssetsSummary'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAssetSummaryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAssetSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAttackAnalysisDataRequest(TeaModel):
    def __init__(
        self,
        base_64: str = None,
        current_page: int = None,
        data: str = None,
        end_time: int = None,
        lang: str = None,
        page_size: int = None,
        start_time: int = None,
        type: str = None,
    ):
        self.base_64 = base_64
        self.current_page = current_page
        self.data = data
        self.end_time = end_time
        self.lang = lang
        self.page_size = page_size
        self.start_time = start_time
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_64 is not None:
            result['Base64'] = self.base_64
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Base64') is not None:
            self.base_64 = m.get('Base64')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeAttackAnalysisDataResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        page: int = None,
        page_size: int = None,
        request_id: str = None,
        total: int = None,
    ):
        self.data = data
        self.page = page
        self.page_size = page_size
        self.request_id = request_id
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeAttackAnalysisDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAttackAnalysisDataResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAttackAnalysisDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoDelConfigResponseBody(TeaModel):
    def __init__(
        self,
        days: int = None,
        request_id: str = None,
    ):
        self.days = days
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.days is not None:
            result['Days'] = self.days
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Days') is not None:
            self.days = m.get('Days')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAutoDelConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeAutoDelConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeAutoDelConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupClientsRequest(TeaModel):
    def __init__(
        self,
        support_region_id: str = None,
    ):
        self.support_region_id = support_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.support_region_id is not None:
            result['SupportRegionId'] = self.support_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SupportRegionId') is not None:
            self.support_region_id = m.get('SupportRegionId')
        return self


class DescribeBackupClientsResponseBodyClients(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        client_status: str = None,
        instance_id: str = None,
        uuid: str = None,
    ):
        self.client_id = client_id
        self.client_status = client_status
        self.instance_id = instance_id
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBackupClientsResponseBody(TeaModel):
    def __init__(
        self,
        clients: List[DescribeBackupClientsResponseBodyClients] = None,
        request_id: str = None,
    ):
        self.clients = clients
        self.request_id = request_id

    def validate(self):
        if self.clients:
            for k in self.clients:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clients'] = []
        if self.clients is not None:
            for k in self.clients:
                result['Clients'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clients = []
        if m.get('Clients') is not None:
            for k in m.get('Clients'):
                temp_model = DescribeBackupClientsResponseBodyClients()
                self.clients.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupClientsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupClientsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupClientsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupFilesRequest(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        page_size: str = None,
        path: str = None,
        snapshot_hash: str = None,
        uuid: str = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.path = path
        self.snapshot_hash = snapshot_hash
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.path is not None:
            result['Path'] = self.path
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBackupFilesResponseBodyBackupFiles(TeaModel):
    def __init__(
        self,
        name: str = None,
        size: int = None,
        subtree: str = None,
        type: str = None,
    ):
        self.name = name
        self.size = size
        self.subtree = subtree
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.subtree is not None:
            result['Subtree'] = self.subtree
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Subtree') is not None:
            self.subtree = m.get('Subtree')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeBackupFilesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackupFilesResponseBody(TeaModel):
    def __init__(
        self,
        backup_files: List[DescribeBackupFilesResponseBodyBackupFiles] = None,
        page_info: DescribeBackupFilesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.backup_files = backup_files
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.backup_files:
            for k in self.backup_files:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BackupFiles'] = []
        if self.backup_files is not None:
            for k in self.backup_files:
                result['BackupFiles'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.backup_files = []
        if m.get('BackupFiles') is not None:
            for k in m.get('BackupFiles'):
                temp_model = DescribeBackupFilesResponseBodyBackupFiles()
                self.backup_files.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackupFilesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPoliciesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        machine_remark: str = None,
        name: str = None,
        page_size: int = None,
        status: str = None,
    ):
        self.current_page = current_page
        self.machine_remark = machine_remark
        self.name = name
        self.page_size = page_size
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.machine_remark is not None:
            result['MachineRemark'] = self.machine_remark
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('MachineRemark') is not None:
            self.machine_remark = m.get('MachineRemark')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeBackupPoliciesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackupPoliciesResponseBodyPolicies(TeaModel):
    def __init__(
        self,
        client_error_count: int = None,
        client_error_uuid_list: List[str] = None,
        client_status: str = None,
        health_client_count: int = None,
        health_client_uuid_list: List[str] = None,
        id: int = None,
        name: str = None,
        policy: str = None,
        policy_region_id: str = None,
        policy_version: str = None,
        remarked_uuid_list: List[str] = None,
        service_error_count: int = None,
        service_error_uuid_list: List[str] = None,
        status: str = None,
        upgrade_status: str = None,
        uuid_list: List[str] = None,
    ):
        self.client_error_count = client_error_count
        self.client_error_uuid_list = client_error_uuid_list
        self.client_status = client_status
        self.health_client_count = health_client_count
        self.health_client_uuid_list = health_client_uuid_list
        self.id = id
        self.name = name
        self.policy = policy
        self.policy_region_id = policy_region_id
        self.policy_version = policy_version
        self.remarked_uuid_list = remarked_uuid_list
        self.service_error_count = service_error_count
        self.service_error_uuid_list = service_error_uuid_list
        self.status = status
        self.upgrade_status = upgrade_status
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_error_count is not None:
            result['ClientErrorCount'] = self.client_error_count
        if self.client_error_uuid_list is not None:
            result['ClientErrorUuidList'] = self.client_error_uuid_list
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.health_client_count is not None:
            result['HealthClientCount'] = self.health_client_count
        if self.health_client_uuid_list is not None:
            result['HealthClientUuidList'] = self.health_client_uuid_list
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.remarked_uuid_list is not None:
            result['RemarkedUuidList'] = self.remarked_uuid_list
        if self.service_error_count is not None:
            result['ServiceErrorCount'] = self.service_error_count
        if self.service_error_uuid_list is not None:
            result['ServiceErrorUuidList'] = self.service_error_uuid_list
        if self.status is not None:
            result['Status'] = self.status
        if self.upgrade_status is not None:
            result['UpgradeStatus'] = self.upgrade_status
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientErrorCount') is not None:
            self.client_error_count = m.get('ClientErrorCount')
        if m.get('ClientErrorUuidList') is not None:
            self.client_error_uuid_list = m.get('ClientErrorUuidList')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('HealthClientCount') is not None:
            self.health_client_count = m.get('HealthClientCount')
        if m.get('HealthClientUuidList') is not None:
            self.health_client_uuid_list = m.get('HealthClientUuidList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('RemarkedUuidList') is not None:
            self.remarked_uuid_list = m.get('RemarkedUuidList')
        if m.get('ServiceErrorCount') is not None:
            self.service_error_count = m.get('ServiceErrorCount')
        if m.get('ServiceErrorUuidList') is not None:
            self.service_error_uuid_list = m.get('ServiceErrorUuidList')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpgradeStatus') is not None:
            self.upgrade_status = m.get('UpgradeStatus')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeBackupPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeBackupPoliciesResponseBodyPageInfo = None,
        policies: List[DescribeBackupPoliciesResponseBodyPolicies] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.policies = policies
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackupPoliciesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = DescribeBackupPoliciesResponseBodyPolicies()
                self.policies.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupRestoreCountResponseBodyBackupRestoreCount(TeaModel):
    def __init__(
        self,
        recovering: int = None,
        total: int = None,
    ):
        self.recovering = recovering
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.recovering is not None:
            result['Recovering'] = self.recovering
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Recovering') is not None:
            self.recovering = m.get('Recovering')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeBackupRestoreCountResponseBody(TeaModel):
    def __init__(
        self,
        backup_restore_count: DescribeBackupRestoreCountResponseBodyBackupRestoreCount = None,
        request_id: str = None,
    ):
        self.backup_restore_count = backup_restore_count
        self.request_id = request_id

    def validate(self):
        if self.backup_restore_count:
            self.backup_restore_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_restore_count is not None:
            result['BackupRestoreCount'] = self.backup_restore_count.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupRestoreCount') is not None:
            temp_model = DescribeBackupRestoreCountResponseBodyBackupRestoreCount()
            self.backup_restore_count = temp_model.from_map(m['BackupRestoreCount'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupRestoreCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBackupRestoreCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBackupRestoreCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBruteForceSummaryRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeBruteForceSummaryResponseBodyBruteForceSummary(TeaModel):
    def __init__(
        self,
        all_strategy_count: int = None,
        effective_count: int = None,
    ):
        self.all_strategy_count = all_strategy_count
        self.effective_count = effective_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_strategy_count is not None:
            result['AllStrategyCount'] = self.all_strategy_count
        if self.effective_count is not None:
            result['EffectiveCount'] = self.effective_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllStrategyCount') is not None:
            self.all_strategy_count = m.get('AllStrategyCount')
        if m.get('EffectiveCount') is not None:
            self.effective_count = m.get('EffectiveCount')
        return self


class DescribeBruteForceSummaryResponseBody(TeaModel):
    def __init__(
        self,
        brute_force_summary: DescribeBruteForceSummaryResponseBodyBruteForceSummary = None,
        request_id: str = None,
    ):
        self.brute_force_summary = brute_force_summary
        self.request_id = request_id

    def validate(self):
        if self.brute_force_summary:
            self.brute_force_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.brute_force_summary is not None:
            result['BruteForceSummary'] = self.brute_force_summary.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BruteForceSummary') is not None:
            temp_model = DescribeBruteForceSummaryResponseBodyBruteForceSummary()
            self.brute_force_summary = temp_model.from_map(m['BruteForceSummary'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBruteForceSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeBruteForceSummaryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeBruteForceSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckEcsWarningsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
    ):
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeCheckEcsWarningsResponseBody(TeaModel):
    def __init__(
        self,
        can_try: str = None,
        request_id: str = None,
        sas_version: str = None,
        weak_password_count: str = None,
    ):
        self.can_try = can_try
        self.request_id = request_id
        self.sas_version = sas_version
        self.weak_password_count = weak_password_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_try is not None:
            result['CanTry'] = self.can_try
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sas_version is not None:
            result['SasVersion'] = self.sas_version
        if self.weak_password_count is not None:
            result['WeakPasswordCount'] = self.weak_password_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CanTry') is not None:
            self.can_try = m.get('CanTry')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SasVersion') is not None:
            self.sas_version = m.get('SasVersion')
        if m.get('WeakPasswordCount') is not None:
            self.weak_password_count = m.get('WeakPasswordCount')
        return self


class DescribeCheckEcsWarningsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCheckEcsWarningsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckEcsWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningDetailRequest(TeaModel):
    def __init__(
        self,
        check_warning_id: int = None,
        lang: str = None,
        source_ip: str = None,
    ):
        self.check_warning_id = check_warning_id
        self.lang = lang
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_warning_id is not None:
            result['CheckWarningId'] = self.check_warning_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckWarningId') is not None:
            self.check_warning_id = m.get('CheckWarningId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeCheckWarningDetailResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        check_id: int = None,
        description: str = None,
        item: str = None,
        level: str = None,
        prompt: str = None,
        request_id: str = None,
        type: str = None,
    ):
        self.advice = advice
        self.check_id = check_id
        self.description = description
        self.item = item
        self.level = level
        self.prompt = prompt
        self.request_id = request_id
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.description is not None:
            result['Description'] = self.description
        if self.item is not None:
            result['Item'] = self.item
        if self.level is not None:
            result['Level'] = self.level
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCheckWarningDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCheckWarningDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningSummaryRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        container_field_name: str = None,
        container_field_value: str = None,
        current_page: int = None,
        lang: str = None,
        page_size: int = None,
        risk_name: str = None,
        risk_status: int = None,
        source_ip: str = None,
        status: str = None,
        strategy_id: int = None,
        target_type: str = None,
        type_name: str = None,
        uuids: str = None,
    ):
        self.cluster_id = cluster_id
        self.container_field_name = container_field_name
        self.container_field_value = container_field_value
        self.current_page = current_page
        self.lang = lang
        self.page_size = page_size
        self.risk_name = risk_name
        self.risk_status = risk_status
        self.source_ip = source_ip
        self.status = status
        self.strategy_id = strategy_id
        self.target_type = target_type
        self.type_name = type_name
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeCheckWarningSummaryResponseBodyWarningSummarys(TeaModel):
    def __init__(
        self,
        check_count: int = None,
        high_warning_count: int = None,
        last_found_time: str = None,
        level: str = None,
        low_warning_count: int = None,
        medium_warning_count: int = None,
        risk_id: int = None,
        risk_name: str = None,
        sub_type_alias: str = None,
        type_alias: str = None,
        warning_machine_count: int = None,
    ):
        self.check_count = check_count
        self.high_warning_count = high_warning_count
        self.last_found_time = last_found_time
        self.level = level
        self.low_warning_count = low_warning_count
        self.medium_warning_count = medium_warning_count
        self.risk_id = risk_id
        self.risk_name = risk_name
        self.sub_type_alias = sub_type_alias
        self.type_alias = type_alias
        self.warning_machine_count = warning_machine_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_count is not None:
            result['CheckCount'] = self.check_count
        if self.high_warning_count is not None:
            result['HighWarningCount'] = self.high_warning_count
        if self.last_found_time is not None:
            result['LastFoundTime'] = self.last_found_time
        if self.level is not None:
            result['Level'] = self.level
        if self.low_warning_count is not None:
            result['LowWarningCount'] = self.low_warning_count
        if self.medium_warning_count is not None:
            result['MediumWarningCount'] = self.medium_warning_count
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.sub_type_alias is not None:
            result['SubTypeAlias'] = self.sub_type_alias
        if self.type_alias is not None:
            result['TypeAlias'] = self.type_alias
        if self.warning_machine_count is not None:
            result['WarningMachineCount'] = self.warning_machine_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckCount') is not None:
            self.check_count = m.get('CheckCount')
        if m.get('HighWarningCount') is not None:
            self.high_warning_count = m.get('HighWarningCount')
        if m.get('LastFoundTime') is not None:
            self.last_found_time = m.get('LastFoundTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LowWarningCount') is not None:
            self.low_warning_count = m.get('LowWarningCount')
        if m.get('MediumWarningCount') is not None:
            self.medium_warning_count = m.get('MediumWarningCount')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('SubTypeAlias') is not None:
            self.sub_type_alias = m.get('SubTypeAlias')
        if m.get('TypeAlias') is not None:
            self.type_alias = m.get('TypeAlias')
        if m.get('WarningMachineCount') is not None:
            self.warning_machine_count = m.get('WarningMachineCount')
        return self


class DescribeCheckWarningSummaryResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        warning_summarys: List[DescribeCheckWarningSummaryResponseBodyWarningSummarys] = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.warning_summarys = warning_summarys

    def validate(self):
        if self.warning_summarys:
            for k in self.warning_summarys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['WarningSummarys'] = []
        if self.warning_summarys is not None:
            for k in self.warning_summarys:
                result['WarningSummarys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.warning_summarys = []
        if m.get('WarningSummarys') is not None:
            for k in m.get('WarningSummarys'):
                temp_model = DescribeCheckWarningSummaryResponseBodyWarningSummarys()
                self.warning_summarys.append(temp_model.from_map(k))
        return self


class DescribeCheckWarningSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCheckWarningSummaryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningsRequest(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        current_page: int = None,
        lang: str = None,
        page_size: int = None,
        risk_id: int = None,
        source_ip: str = None,
        uuid: str = None,
    ):
        self.check_id = check_id
        self.current_page = current_page
        self.lang = lang
        self.page_size = page_size
        self.risk_id = risk_id
        self.source_ip = source_ip
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeCheckWarningsResponseBodyCheckWarnings(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        check_warning_id: int = None,
        item: str = None,
        level: str = None,
        status: int = None,
        type: str = None,
        uuid: str = None,
    ):
        self.check_id = check_id
        self.check_warning_id = check_warning_id
        self.item = item
        self.level = level
        self.status = status
        self.type = type
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.check_warning_id is not None:
            result['CheckWarningId'] = self.check_warning_id
        if self.item is not None:
            result['Item'] = self.item
        if self.level is not None:
            result['Level'] = self.level
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('CheckWarningId') is not None:
            self.check_warning_id = m.get('CheckWarningId')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeCheckWarningsResponseBody(TeaModel):
    def __init__(
        self,
        check_warnings: List[DescribeCheckWarningsResponseBodyCheckWarnings] = None,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.check_warnings = check_warnings
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.check_warnings:
            for k in self.check_warnings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CheckWarnings'] = []
        if self.check_warnings is not None:
            for k in self.check_warnings:
                result['CheckWarnings'].append(k.to_map() if k else None)
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.check_warnings = []
        if m.get('CheckWarnings') is not None:
            for k in m.get('CheckWarnings'):
                temp_model = DescribeCheckWarningsResponseBodyCheckWarnings()
                self.check_warnings.append(temp_model.from_map(k))
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCheckWarningsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCheckWarningsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudCenterInstancesRequest(TeaModel):
    def __init__(
        self,
        criteria: str = None,
        current_page: int = None,
        importance: int = None,
        logical_exp: str = None,
        machine_types: str = None,
        no_group_trace: bool = None,
        page_size: int = None,
        region_id: str = None,
    ):
        self.criteria = criteria
        self.current_page = current_page
        self.importance = importance
        self.logical_exp = logical_exp
        self.machine_types = machine_types
        self.no_group_trace = no_group_trace
        self.page_size = page_size
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.importance is not None:
            result['Importance'] = self.importance
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.no_group_trace is not None:
            result['NoGroupTrace'] = self.no_group_trace
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Importance') is not None:
            self.importance = m.get('Importance')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('NoGroupTrace') is not None:
            self.no_group_trace = m.get('NoGroupTrace')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCloudCenterInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        alarm_status: str = None,
        asset_type: str = None,
        auth_modify_time: int = None,
        auth_version: int = None,
        auth_version_name: str = None,
        bind: bool = None,
        client_status: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        cores: int = None,
        cpu_info: str = None,
        created_time: int = None,
        exposed_status: int = None,
        flag: int = None,
        group_id: int = None,
        group_trace: str = None,
        hc_status: str = None,
        health_check_count: int = None,
        importance: int = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        ip_list_string: str = None,
        kernel: str = None,
        last_login_timestamp: int = None,
        mac_list_string: str = None,
        mem: int = None,
        os: str = None,
        os_name: str = None,
        pod_count: int = None,
        region: str = None,
        region_id: str = None,
        region_name: str = None,
        risk_count: str = None,
        risk_status: str = None,
        safe_event_count: int = None,
        status: str = None,
        tag: str = None,
        tag_id: str = None,
        uuid: str = None,
        vendor: int = None,
        vendor_name: str = None,
        vpc_instance_id: str = None,
        vul_count: int = None,
        vul_status: str = None,
    ):
        self.alarm_status = alarm_status
        self.asset_type = asset_type
        self.auth_modify_time = auth_modify_time
        self.auth_version = auth_version
        self.auth_version_name = auth_version_name
        self.bind = bind
        self.client_status = client_status
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.cores = cores
        self.cpu_info = cpu_info
        self.created_time = created_time
        self.exposed_status = exposed_status
        self.flag = flag
        self.group_id = group_id
        self.group_trace = group_trace
        self.hc_status = hc_status
        self.health_check_count = health_check_count
        self.importance = importance
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.ip = ip
        self.ip_list_string = ip_list_string
        self.kernel = kernel
        self.last_login_timestamp = last_login_timestamp
        self.mac_list_string = mac_list_string
        self.mem = mem
        self.os = os
        self.os_name = os_name
        self.pod_count = pod_count
        self.region = region
        self.region_id = region_id
        self.region_name = region_name
        self.risk_count = risk_count
        self.risk_status = risk_status
        self.safe_event_count = safe_event_count
        self.status = status
        self.tag = tag
        self.tag_id = tag_id
        self.uuid = uuid
        self.vendor = vendor
        self.vendor_name = vendor_name
        self.vpc_instance_id = vpc_instance_id
        self.vul_count = vul_count
        self.vul_status = vul_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.auth_modify_time is not None:
            result['AuthModifyTime'] = self.auth_modify_time
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.auth_version_name is not None:
            result['AuthVersionName'] = self.auth_version_name
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.cpu_info is not None:
            result['CpuInfo'] = self.cpu_info
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.exposed_status is not None:
            result['ExposedStatus'] = self.exposed_status
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_trace is not None:
            result['GroupTrace'] = self.group_trace
        if self.hc_status is not None:
            result['HcStatus'] = self.hc_status
        if self.health_check_count is not None:
            result['HealthCheckCount'] = self.health_check_count
        if self.importance is not None:
            result['Importance'] = self.importance
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.ip_list_string is not None:
            result['IpListString'] = self.ip_list_string
        if self.kernel is not None:
            result['Kernel'] = self.kernel
        if self.last_login_timestamp is not None:
            result['LastLoginTimestamp'] = self.last_login_timestamp
        if self.mac_list_string is not None:
            result['MacListString'] = self.mac_list_string
        if self.mem is not None:
            result['Mem'] = self.mem
        if self.os is not None:
            result['Os'] = self.os
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.pod_count is not None:
            result['PodCount'] = self.pod_count
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.safe_event_count is not None:
            result['SafeEventCount'] = self.safe_event_count
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.vendor_name is not None:
            result['VendorName'] = self.vendor_name
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('AuthModifyTime') is not None:
            self.auth_modify_time = m.get('AuthModifyTime')
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('AuthVersionName') is not None:
            self.auth_version_name = m.get('AuthVersionName')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('CpuInfo') is not None:
            self.cpu_info = m.get('CpuInfo')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ExposedStatus') is not None:
            self.exposed_status = m.get('ExposedStatus')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupTrace') is not None:
            self.group_trace = m.get('GroupTrace')
        if m.get('HcStatus') is not None:
            self.hc_status = m.get('HcStatus')
        if m.get('HealthCheckCount') is not None:
            self.health_check_count = m.get('HealthCheckCount')
        if m.get('Importance') is not None:
            self.importance = m.get('Importance')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IpListString') is not None:
            self.ip_list_string = m.get('IpListString')
        if m.get('Kernel') is not None:
            self.kernel = m.get('Kernel')
        if m.get('LastLoginTimestamp') is not None:
            self.last_login_timestamp = m.get('LastLoginTimestamp')
        if m.get('MacListString') is not None:
            self.mac_list_string = m.get('MacListString')
        if m.get('Mem') is not None:
            self.mem = m.get('Mem')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('PodCount') is not None:
            self.pod_count = m.get('PodCount')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('SafeEventCount') is not None:
            self.safe_event_count = m.get('SafeEventCount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('VendorName') is not None:
            self.vendor_name = m.get('VendorName')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        return self


class DescribeCloudCenterInstancesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCloudCenterInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instances: List[DescribeCloudCenterInstancesResponseBodyInstances] = None,
        page_info: DescribeCloudCenterInstancesResponseBodyPageInfo = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.instances = instances
        self.page_info = page_info
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeCloudCenterInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeCloudCenterInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCloudCenterInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCloudCenterInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCloudCenterInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudProductFieldStatisticsResponseBodyGroupedFields(TeaModel):
    def __init__(
        self,
        category_count: str = None,
        instance_count: int = None,
        risk_instance_count: int = None,
    ):
        self.category_count = category_count
        self.instance_count = instance_count
        self.risk_instance_count = risk_instance_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_count is not None:
            result['CategoryCount'] = self.category_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryCount') is not None:
            self.category_count = m.get('CategoryCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        return self


class DescribeCloudProductFieldStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        grouped_fields: DescribeCloudProductFieldStatisticsResponseBodyGroupedFields = None,
        request_id: str = None,
    ):
        self.grouped_fields = grouped_fields
        self.request_id = request_id

    def validate(self):
        if self.grouped_fields:
            self.grouped_fields.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grouped_fields is not None:
            result['GroupedFields'] = self.grouped_fields.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupedFields') is not None:
            temp_model = DescribeCloudProductFieldStatisticsResponseBodyGroupedFields()
            self.grouped_fields = temp_model.from_map(m['GroupedFields'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCloudProductFieldStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCloudProductFieldStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCloudProductFieldStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeConcernNecessityRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeConcernNecessityResponseBody(TeaModel):
    def __init__(
        self,
        concern_necessity: List[str] = None,
        request_id: str = None,
    ):
        self.concern_necessity = concern_necessity
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concern_necessity is not None:
            result['ConcernNecessity'] = self.concern_necessity
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcernNecessity') is not None:
            self.concern_necessity = m.get('ConcernNecessity')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeConcernNecessityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeConcernNecessityResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeConcernNecessityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContainerStatisticsRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
    ):
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeContainerStatisticsResponseBodyData(TeaModel):
    def __init__(
        self,
        remind_alarm_count: int = None,
        serious_alarm_count: int = None,
        suspicious_alarm_count: int = None,
        total_alarm_count: int = None,
        total_node: int = None,
        has_risk_node: int = None,
    ):
        self.remind_alarm_count = remind_alarm_count
        self.serious_alarm_count = serious_alarm_count
        self.suspicious_alarm_count = suspicious_alarm_count
        self.total_alarm_count = total_alarm_count
        self.total_node = total_node
        self.has_risk_node = has_risk_node

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_alarm_count is not None:
            result['RemindAlarmCount'] = self.remind_alarm_count
        if self.serious_alarm_count is not None:
            result['SeriousAlarmCount'] = self.serious_alarm_count
        if self.suspicious_alarm_count is not None:
            result['SuspiciousAlarmCount'] = self.suspicious_alarm_count
        if self.total_alarm_count is not None:
            result['TotalAlarmCount'] = self.total_alarm_count
        if self.total_node is not None:
            result['TotalNode'] = self.total_node
        if self.has_risk_node is not None:
            result['hasRiskNode'] = self.has_risk_node
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemindAlarmCount') is not None:
            self.remind_alarm_count = m.get('RemindAlarmCount')
        if m.get('SeriousAlarmCount') is not None:
            self.serious_alarm_count = m.get('SeriousAlarmCount')
        if m.get('SuspiciousAlarmCount') is not None:
            self.suspicious_alarm_count = m.get('SuspiciousAlarmCount')
        if m.get('TotalAlarmCount') is not None:
            self.total_alarm_count = m.get('TotalAlarmCount')
        if m.get('TotalNode') is not None:
            self.total_node = m.get('TotalNode')
        if m.get('hasRiskNode') is not None:
            self.has_risk_node = m.get('hasRiskNode')
        return self


class DescribeContainerStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeContainerStatisticsResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeContainerStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeContainerStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeContainerStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeContainerStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCriteriaRequest(TeaModel):
    def __init__(
        self,
        machine_types: str = None,
        support_auto_tag: bool = None,
        value: str = None,
    ):
        self.machine_types = machine_types
        self.support_auto_tag = support_auto_tag
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.support_auto_tag is not None:
            result['SupportAutoTag'] = self.support_auto_tag
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('SupportAutoTag') is not None:
            self.support_auto_tag = m.get('SupportAutoTag')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        values: str = None,
    ):
        self.name = name
        self.type = type
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeCriteriaResponseBody(TeaModel):
    def __init__(
        self,
        criteria_list: List[DescribeCriteriaResponseBodyCriteriaList] = None,
        request_id: str = None,
    ):
        self.criteria_list = criteria_list
        self.request_id = request_id

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCriteriaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeCriteriaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDingTalkRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        rule_action_name: str = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.rule_action_name = rule_action_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rule_action_name is not None:
            result['RuleActionName'] = self.rule_action_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RuleActionName') is not None:
            self.rule_action_name = m.get('RuleActionName')
        return self


class DescribeDingTalkResponseBodyActionList(TeaModel):
    def __init__(
        self,
        action_name: str = None,
        ali_uid: int = None,
        config_list: str = None,
        ding_talk_lang: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        group_id_list: str = None,
        id: int = None,
        interval_time: int = None,
        status: int = None,
        url: str = None,
    ):
        self.action_name = action_name
        self.ali_uid = ali_uid
        self.config_list = config_list
        self.ding_talk_lang = ding_talk_lang
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.group_id_list = group_id_list
        self.id = id
        self.interval_time = interval_time
        self.status = status
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.config_list is not None:
            result['ConfigList'] = self.config_list
        if self.ding_talk_lang is not None:
            result['DingTalkLang'] = self.ding_talk_lang
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.id is not None:
            result['Id'] = self.id
        if self.interval_time is not None:
            result['IntervalTime'] = self.interval_time
        if self.status is not None:
            result['Status'] = self.status
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('ConfigList') is not None:
            self.config_list = m.get('ConfigList')
        if m.get('DingTalkLang') is not None:
            self.ding_talk_lang = m.get('DingTalkLang')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IntervalTime') is not None:
            self.interval_time = m.get('IntervalTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeDingTalkResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDingTalkResponseBody(TeaModel):
    def __init__(
        self,
        action_list: List[DescribeDingTalkResponseBodyActionList] = None,
        page_info: DescribeDingTalkResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.action_list = action_list
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.action_list:
            for k in self.action_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ActionList'] = []
        if self.action_list is not None:
            for k in self.action_list:
                result['ActionList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.action_list = []
        if m.get('ActionList') is not None:
            for k in m.get('ActionList'):
                temp_model = DescribeDingTalkResponseBodyActionList()
                self.action_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeDingTalkResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDingTalkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDingTalkResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDingTalkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainCountRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
    ):
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainCountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        root_domains_count: int = None,
        sub_domains_count: int = None,
        total_domains_count: int = None,
    ):
        self.request_id = request_id
        self.root_domains_count = root_domains_count
        self.sub_domains_count = sub_domains_count
        self.total_domains_count = total_domains_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.root_domains_count is not None:
            result['RootDomainsCount'] = self.root_domains_count
        if self.sub_domains_count is not None:
            result['SubDomainsCount'] = self.sub_domains_count
        if self.total_domains_count is not None:
            result['TotalDomainsCount'] = self.total_domains_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RootDomainsCount') is not None:
            self.root_domains_count = m.get('RootDomainsCount')
        if m.get('SubDomainsCount') is not None:
            self.sub_domains_count = m.get('SubDomainsCount')
        if m.get('TotalDomainsCount') is not None:
            self.total_domains_count = m.get('TotalDomainsCount')
        return self


class DescribeDomainCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDomainCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDomainCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainDetailRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        source_ip: str = None,
    ):
        self.domain_name = domain_name
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainDetailResponseBodyDomainDetailItems(TeaModel):
    def __init__(
        self,
        asset_type: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        uuid: str = None,
    ):
        self.asset_type = asset_type
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeDomainDetailResponseBody(TeaModel):
    def __init__(
        self,
        alarm_count: int = None,
        domain: str = None,
        domain_detail_items: List[DescribeDomainDetailResponseBodyDomainDetailItems] = None,
        request_id: str = None,
        root_domain: str = None,
        vul_count: int = None,
    ):
        self.alarm_count = alarm_count
        self.domain = domain
        self.domain_detail_items = domain_detail_items
        self.request_id = request_id
        self.root_domain = root_domain
        self.vul_count = vul_count

    def validate(self):
        if self.domain_detail_items:
            for k in self.domain_detail_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.domain is not None:
            result['Domain'] = self.domain
        result['DomainDetailItems'] = []
        if self.domain_detail_items is not None:
            for k in self.domain_detail_items:
                result['DomainDetailItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.root_domain is not None:
            result['RootDomain'] = self.root_domain
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        self.domain_detail_items = []
        if m.get('DomainDetailItems') is not None:
            for k in m.get('DomainDetailItems'):
                temp_model = DescribeDomainDetailResponseBodyDomainDetailItems()
                self.domain_detail_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RootDomain') is not None:
            self.root_domain = m.get('RootDomain')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        return self


class DescribeDomainDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDomainDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainListRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        domain_type: str = None,
        fuzzy_domain: str = None,
        page_size: int = None,
        source_ip: str = None,
    ):
        self.current_page = current_page
        self.domain_type = domain_type
        self.fuzzy_domain = fuzzy_domain
        self.page_size = page_size
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.fuzzy_domain is not None:
            result['FuzzyDomain'] = self.fuzzy_domain
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('FuzzyDomain') is not None:
            self.fuzzy_domain = m.get('FuzzyDomain')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainListResponseBodyDomainListResponseList(TeaModel):
    def __init__(
        self,
        domain: str = None,
        ip_list: str = None,
    ):
        self.domain = domain
        self.ip_list = ip_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.ip_list is not None:
            result['IpList'] = self.ip_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('IpList') is not None:
            self.ip_list = m.get('IpList')
        return self


class DescribeDomainListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDomainListResponseBody(TeaModel):
    def __init__(
        self,
        domain_list_response_list: List[DescribeDomainListResponseBodyDomainListResponseList] = None,
        page_info: DescribeDomainListResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.domain_list_response_list = domain_list_response_list
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.domain_list_response_list:
            for k in self.domain_list_response_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainListResponseList'] = []
        if self.domain_list_response_list is not None:
            for k in self.domain_list_response_list:
                result['DomainListResponseList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_list_response_list = []
        if m.get('DomainListResponseList') is not None:
            for k in m.get('DomainListResponseList'):
                temp_model = DescribeDomainListResponseBodyDomainListResponseList()
                self.domain_list_response_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeDomainListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDomainListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeDomainListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeDomainListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEmgVulItemRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        lang: str = None,
        page_size: int = None,
        risk_status: str = None,
        scan_type: str = None,
        vul_name: str = None,
    ):
        self.current_page = current_page
        self.lang = lang
        self.page_size = page_size
        self.risk_status = risk_status
        self.scan_type = scan_type
        self.vul_name = vul_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.scan_type is not None:
            result['ScanType'] = self.scan_type
        if self.vul_name is not None:
            result['VulName'] = self.vul_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('ScanType') is not None:
            self.scan_type = m.get('ScanType')
        if m.get('VulName') is not None:
            self.vul_name = m.get('VulName')
        return self


class DescribeEmgVulItemResponseBodyGroupedVulItems(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        gmt_last_check: int = None,
        gmt_publish: int = None,
        name: str = None,
        pending_count: int = None,
        progress: int = None,
        status: int = None,
        type: str = None,
    ):
        self.alias_name = alias_name
        self.gmt_last_check = gmt_last_check
        self.gmt_publish = gmt_publish
        self.name = name
        self.pending_count = pending_count
        self.progress = progress
        self.status = status
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.gmt_last_check is not None:
            result['GmtLastCheck'] = self.gmt_last_check
        if self.gmt_publish is not None:
            result['GmtPublish'] = self.gmt_publish
        if self.name is not None:
            result['Name'] = self.name
        if self.pending_count is not None:
            result['PendingCount'] = self.pending_count
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('GmtLastCheck') is not None:
            self.gmt_last_check = m.get('GmtLastCheck')
        if m.get('GmtPublish') is not None:
            self.gmt_publish = m.get('GmtPublish')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PendingCount') is not None:
            self.pending_count = m.get('PendingCount')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeEmgVulItemResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        grouped_vul_items: List[DescribeEmgVulItemResponseBodyGroupedVulItems] = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.current_page = current_page
        self.grouped_vul_items = grouped_vul_items
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeEmgVulItemResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeEmgVulItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeEmgVulItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeEmgVulItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExportInfoRequest(TeaModel):
    def __init__(
        self,
        export_id: int = None,
    ):
        self.export_id = export_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_id is not None:
            result['ExportId'] = self.export_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExportId') is not None:
            self.export_id = m.get('ExportId')
        return self


class DescribeExportInfoResponseBody(TeaModel):
    def __init__(
        self,
        current_count: int = None,
        export_status: str = None,
        file_name: str = None,
        id: int = None,
        link: str = None,
        message: str = None,
        progress: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.current_count = current_count
        self.export_status = export_status
        self.file_name = file_name
        self.id = id
        self.link = link
        self.message = message
        self.progress = progress
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.export_status is not None:
            result['ExportStatus'] = self.export_status
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        if self.link is not None:
            result['Link'] = self.link
        if self.message is not None:
            result['Message'] = self.message
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('ExportStatus') is not None:
            self.export_status = m.get('ExportStatus')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExportInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExportInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExportInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceCriteriaRequest(TeaModel):
    def __init__(
        self,
        value: str = None,
    ):
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeExposedInstanceCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        values: str = None,
    ):
        self.name = name
        self.type = type
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeExposedInstanceCriteriaResponseBody(TeaModel):
    def __init__(
        self,
        criteria_list: List[DescribeExposedInstanceCriteriaResponseBodyCriteriaList] = None,
        request_id: str = None,
    ):
        self.criteria_list = criteria_list
        self.request_id = request_id

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeExposedInstanceCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceCriteriaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExposedInstanceCriteriaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceDetailRequest(TeaModel):
    def __init__(
        self,
        uuid: str = None,
    ):
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        name: str = None,
        necessity: str = None,
        type: str = None,
        uuid: str = None,
    ):
        self.alias_name = alias_name
        self.name = name
        self.necessity = necessity
        self.type = type
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        name: str = None,
        necessity: str = None,
        type: str = None,
        uuid: str = None,
    ):
        self.alias_name = alias_name
        self.name = name
        self.necessity = necessity
        self.type = type
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChains(TeaModel):
    def __init__(
        self,
        all_vul_list: List[DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList] = None,
        exposure_component: str = None,
        exposure_ip: str = None,
        exposure_port: str = None,
        exposure_type: str = None,
        exposure_type_id: str = None,
        group_no: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        real_vul_list: List[DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList] = None,
        region_id: str = None,
        uuid: str = None,
    ):
        self.all_vul_list = all_vul_list
        self.exposure_component = exposure_component
        self.exposure_ip = exposure_ip
        self.exposure_port = exposure_port
        self.exposure_type = exposure_type
        self.exposure_type_id = exposure_type_id
        self.group_no = group_no
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.real_vul_list = real_vul_list
        self.region_id = region_id
        self.uuid = uuid

    def validate(self):
        if self.all_vul_list:
            for k in self.all_vul_list:
                if k:
                    k.validate()
        if self.real_vul_list:
            for k in self.real_vul_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AllVulList'] = []
        if self.all_vul_list is not None:
            for k in self.all_vul_list:
                result['AllVulList'].append(k.to_map() if k else None)
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.group_no is not None:
            result['GroupNo'] = self.group_no
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        result['RealVulList'] = []
        if self.real_vul_list is not None:
            for k in self.real_vul_list:
                result['RealVulList'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.all_vul_list = []
        if m.get('AllVulList') is not None:
            for k in m.get('AllVulList'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList()
                self.all_vul_list.append(temp_model.from_map(k))
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('GroupNo') is not None:
            self.group_no = m.get('GroupNo')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        self.real_vul_list = []
        if m.get('RealVulList') is not None:
            for k in m.get('RealVulList'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList()
                self.real_vul_list.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBody(TeaModel):
    def __init__(
        self,
        exposed_chains: List[DescribeExposedInstanceDetailResponseBodyExposedChains] = None,
        request_id: str = None,
    ):
        self.exposed_chains = exposed_chains
        self.request_id = request_id

    def validate(self):
        if self.exposed_chains:
            for k in self.exposed_chains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExposedChains'] = []
        if self.exposed_chains is not None:
            for k in self.exposed_chains:
                result['ExposedChains'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.exposed_chains = []
        if m.get('ExposedChains') is not None:
            for k in m.get('ExposedChains'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChains()
                self.exposed_chains.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExposedInstanceDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceListRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        exposure_component: str = None,
        exposure_ip: str = None,
        exposure_port: str = None,
        group_id: int = None,
        health_status: bool = None,
        instance_id: str = None,
        instance_name: str = None,
        page_size: int = None,
        vul_status: bool = None,
    ):
        self.current_page = current_page
        self.exposure_component = exposure_component
        self.exposure_ip = exposure_ip
        self.exposure_port = exposure_port
        self.group_id = group_id
        self.health_status = health_status
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.page_size = page_size
        self.vul_status = vul_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('HealthStatus') is not None:
            self.health_status = m.get('HealthStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        return self


class DescribeExposedInstanceListResponseBodyExposedInstances(TeaModel):
    def __init__(
        self,
        asap_vul_count: int = None,
        exploit_health_count: int = None,
        exposure_component: str = None,
        exposure_ip: str = None,
        exposure_port: str = None,
        exposure_type: str = None,
        exposure_type_id: str = None,
        group_id: int = None,
        group_name: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        later_vul_count: int = None,
        nntf_vul_count: int = None,
        region_id: str = None,
        total_vul_count: int = None,
        uuid: str = None,
    ):
        self.asap_vul_count = asap_vul_count
        self.exploit_health_count = exploit_health_count
        self.exposure_component = exposure_component
        self.exposure_ip = exposure_ip
        self.exposure_port = exposure_port
        self.exposure_type = exposure_type
        self.exposure_type_id = exposure_type_id
        self.group_id = group_id
        self.group_name = group_name
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.later_vul_count = later_vul_count
        self.nntf_vul_count = nntf_vul_count
        self.region_id = region_id
        self.total_vul_count = total_vul_count
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_vul_count is not None:
            result['AsapVulCount'] = self.asap_vul_count
        if self.exploit_health_count is not None:
            result['ExploitHealthCount'] = self.exploit_health_count
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.later_vul_count is not None:
            result['LaterVulCount'] = self.later_vul_count
        if self.nntf_vul_count is not None:
            result['NntfVulCount'] = self.nntf_vul_count
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.total_vul_count is not None:
            result['TotalVulCount'] = self.total_vul_count
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsapVulCount') is not None:
            self.asap_vul_count = m.get('AsapVulCount')
        if m.get('ExploitHealthCount') is not None:
            self.exploit_health_count = m.get('ExploitHealthCount')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LaterVulCount') is not None:
            self.later_vul_count = m.get('LaterVulCount')
        if m.get('NntfVulCount') is not None:
            self.nntf_vul_count = m.get('NntfVulCount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TotalVulCount') is not None:
            self.total_vul_count = m.get('TotalVulCount')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExposedInstanceListResponseBody(TeaModel):
    def __init__(
        self,
        exposed_instances: List[DescribeExposedInstanceListResponseBodyExposedInstances] = None,
        page_info: DescribeExposedInstanceListResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.exposed_instances = exposed_instances
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.exposed_instances:
            for k in self.exposed_instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExposedInstances'] = []
        if self.exposed_instances is not None:
            for k in self.exposed_instances:
                result['ExposedInstances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.exposed_instances = []
        if m.get('ExposedInstances') is not None:
            for k in m.get('ExposedInstances'):
                temp_model = DescribeExposedInstanceListResponseBodyExposedInstances()
                self.exposed_instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeExposedInstanceListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExposedInstanceListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        exposed_asap_vul_count: int = None,
        exposed_component_count: int = None,
        exposed_instance_count: int = None,
        exposed_ip_count: int = None,
        exposed_later_vul_count: int = None,
        exposed_nntf_vul_count: int = None,
        exposed_port_count: int = None,
        exposed_week_password_machine_count: int = None,
        gateway_asset_count: int = None,
        request_id: str = None,
    ):
        self.exposed_asap_vul_count = exposed_asap_vul_count
        self.exposed_component_count = exposed_component_count
        self.exposed_instance_count = exposed_instance_count
        self.exposed_ip_count = exposed_ip_count
        self.exposed_later_vul_count = exposed_later_vul_count
        self.exposed_nntf_vul_count = exposed_nntf_vul_count
        self.exposed_port_count = exposed_port_count
        self.exposed_week_password_machine_count = exposed_week_password_machine_count
        self.gateway_asset_count = gateway_asset_count
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exposed_asap_vul_count is not None:
            result['ExposedAsapVulCount'] = self.exposed_asap_vul_count
        if self.exposed_component_count is not None:
            result['ExposedComponentCount'] = self.exposed_component_count
        if self.exposed_instance_count is not None:
            result['ExposedInstanceCount'] = self.exposed_instance_count
        if self.exposed_ip_count is not None:
            result['ExposedIpCount'] = self.exposed_ip_count
        if self.exposed_later_vul_count is not None:
            result['ExposedLaterVulCount'] = self.exposed_later_vul_count
        if self.exposed_nntf_vul_count is not None:
            result['ExposedNntfVulCount'] = self.exposed_nntf_vul_count
        if self.exposed_port_count is not None:
            result['ExposedPortCount'] = self.exposed_port_count
        if self.exposed_week_password_machine_count is not None:
            result['ExposedWeekPasswordMachineCount'] = self.exposed_week_password_machine_count
        if self.gateway_asset_count is not None:
            result['GatewayAssetCount'] = self.gateway_asset_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExposedAsapVulCount') is not None:
            self.exposed_asap_vul_count = m.get('ExposedAsapVulCount')
        if m.get('ExposedComponentCount') is not None:
            self.exposed_component_count = m.get('ExposedComponentCount')
        if m.get('ExposedInstanceCount') is not None:
            self.exposed_instance_count = m.get('ExposedInstanceCount')
        if m.get('ExposedIpCount') is not None:
            self.exposed_ip_count = m.get('ExposedIpCount')
        if m.get('ExposedLaterVulCount') is not None:
            self.exposed_later_vul_count = m.get('ExposedLaterVulCount')
        if m.get('ExposedNntfVulCount') is not None:
            self.exposed_nntf_vul_count = m.get('ExposedNntfVulCount')
        if m.get('ExposedPortCount') is not None:
            self.exposed_port_count = m.get('ExposedPortCount')
        if m.get('ExposedWeekPasswordMachineCount') is not None:
            self.exposed_week_password_machine_count = m.get('ExposedWeekPasswordMachineCount')
        if m.get('GatewayAssetCount') is not None:
            self.gateway_asset_count = m.get('GatewayAssetCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExposedStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedStatisticsDetailRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        statistics_type: str = None,
        statistics_type_gateway_type: str = None,
        statistics_type_instance_value: str = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.statistics_type = statistics_type
        self.statistics_type_gateway_type = statistics_type_gateway_type
        self.statistics_type_instance_value = statistics_type_instance_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.statistics_type is not None:
            result['StatisticsType'] = self.statistics_type
        if self.statistics_type_gateway_type is not None:
            result['StatisticsTypeGatewayType'] = self.statistics_type_gateway_type
        if self.statistics_type_instance_value is not None:
            result['StatisticsTypeInstanceValue'] = self.statistics_type_instance_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatisticsType') is not None:
            self.statistics_type = m.get('StatisticsType')
        if m.get('StatisticsTypeGatewayType') is not None:
            self.statistics_type_gateway_type = m.get('StatisticsTypeGatewayType')
        if m.get('StatisticsTypeInstanceValue') is not None:
            self.statistics_type_instance_value = m.get('StatisticsTypeInstanceValue')
        return self


class DescribeExposedStatisticsDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExposedStatisticsDetailResponseBodyStatisticsDetails(TeaModel):
    def __init__(
        self,
        exposed_count: int = None,
        exposure_component: str = None,
        exposure_ip: str = None,
        exposure_port: str = None,
        exposure_type: str = None,
        exposure_type_id: str = None,
        exposure_type_instance_name: str = None,
        region_id: str = None,
    ):
        self.exposed_count = exposed_count
        self.exposure_component = exposure_component
        self.exposure_ip = exposure_ip
        self.exposure_port = exposure_port
        self.exposure_type = exposure_type
        self.exposure_type_id = exposure_type_id
        self.exposure_type_instance_name = exposure_type_instance_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exposed_count is not None:
            result['ExposedCount'] = self.exposed_count
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.exposure_type_instance_name is not None:
            result['ExposureTypeInstanceName'] = self.exposure_type_instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExposedCount') is not None:
            self.exposed_count = m.get('ExposedCount')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('ExposureTypeInstanceName') is not None:
            self.exposure_type_instance_name = m.get('ExposureTypeInstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeExposedStatisticsDetailResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeExposedStatisticsDetailResponseBodyPageInfo = None,
        request_id: str = None,
        statistics_details: List[DescribeExposedStatisticsDetailResponseBodyStatisticsDetails] = None,
    ):
        self.page_info = page_info
        self.request_id = request_id
        self.statistics_details = statistics_details

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.statistics_details:
            for k in self.statistics_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['StatisticsDetails'] = []
        if self.statistics_details is not None:
            for k in self.statistics_details:
                result['StatisticsDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeExposedStatisticsDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics_details = []
        if m.get('StatisticsDetails') is not None:
            for k in m.get('StatisticsDetails'):
                temp_model = DescribeExposedStatisticsDetailResponseBodyStatisticsDetails()
                self.statistics_details.append(temp_model.from_map(k))
        return self


class DescribeExposedStatisticsDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeExposedStatisticsDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeExposedStatisticsDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFieldStatisticsRequest(TeaModel):
    def __init__(
        self,
        machine_types: str = None,
        region_id: str = None,
    ):
        self.machine_types = machine_types
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFieldStatisticsResponseBodyGroupedFields(TeaModel):
    def __init__(
        self,
        ali_yun_instance_count: int = None,
        aws_instance_count: int = None,
        exposed_instance_count: int = None,
        general_asset_count: int = None,
        group_count: int = None,
        huawei_instance_count: int = None,
        idc_instance_count: int = None,
        important_asset_count: int = None,
        instance_count: int = None,
        instance_sync_task_count: int = None,
        new_instance_count: int = None,
        not_running_status_count: int = None,
        offline_instance_count: int = None,
        pause_instance_count: int = None,
        region_count: int = None,
        risk_instance_count: int = None,
        tencent_instance_count: int = None,
        test_asset_count: int = None,
        unprotected_instance_count: int = None,
        vpc_count: int = None,
    ):
        self.ali_yun_instance_count = ali_yun_instance_count
        self.aws_instance_count = aws_instance_count
        self.exposed_instance_count = exposed_instance_count
        self.general_asset_count = general_asset_count
        self.group_count = group_count
        self.huawei_instance_count = huawei_instance_count
        self.idc_instance_count = idc_instance_count
        self.important_asset_count = important_asset_count
        self.instance_count = instance_count
        self.instance_sync_task_count = instance_sync_task_count
        self.new_instance_count = new_instance_count
        self.not_running_status_count = not_running_status_count
        self.offline_instance_count = offline_instance_count
        self.pause_instance_count = pause_instance_count
        self.region_count = region_count
        self.risk_instance_count = risk_instance_count
        self.tencent_instance_count = tencent_instance_count
        self.test_asset_count = test_asset_count
        self.unprotected_instance_count = unprotected_instance_count
        self.vpc_count = vpc_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_yun_instance_count is not None:
            result['AliYunInstanceCount'] = self.ali_yun_instance_count
        if self.aws_instance_count is not None:
            result['AwsInstanceCount'] = self.aws_instance_count
        if self.exposed_instance_count is not None:
            result['ExposedInstanceCount'] = self.exposed_instance_count
        if self.general_asset_count is not None:
            result['GeneralAssetCount'] = self.general_asset_count
        if self.group_count is not None:
            result['GroupCount'] = self.group_count
        if self.huawei_instance_count is not None:
            result['HuaweiInstanceCount'] = self.huawei_instance_count
        if self.idc_instance_count is not None:
            result['IdcInstanceCount'] = self.idc_instance_count
        if self.important_asset_count is not None:
            result['ImportantAssetCount'] = self.important_asset_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_sync_task_count is not None:
            result['InstanceSyncTaskCount'] = self.instance_sync_task_count
        if self.new_instance_count is not None:
            result['NewInstanceCount'] = self.new_instance_count
        if self.not_running_status_count is not None:
            result['NotRunningStatusCount'] = self.not_running_status_count
        if self.offline_instance_count is not None:
            result['OfflineInstanceCount'] = self.offline_instance_count
        if self.pause_instance_count is not None:
            result['PauseInstanceCount'] = self.pause_instance_count
        if self.region_count is not None:
            result['RegionCount'] = self.region_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.tencent_instance_count is not None:
            result['TencentInstanceCount'] = self.tencent_instance_count
        if self.test_asset_count is not None:
            result['TestAssetCount'] = self.test_asset_count
        if self.unprotected_instance_count is not None:
            result['UnprotectedInstanceCount'] = self.unprotected_instance_count
        if self.vpc_count is not None:
            result['VpcCount'] = self.vpc_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliYunInstanceCount') is not None:
            self.ali_yun_instance_count = m.get('AliYunInstanceCount')
        if m.get('AwsInstanceCount') is not None:
            self.aws_instance_count = m.get('AwsInstanceCount')
        if m.get('ExposedInstanceCount') is not None:
            self.exposed_instance_count = m.get('ExposedInstanceCount')
        if m.get('GeneralAssetCount') is not None:
            self.general_asset_count = m.get('GeneralAssetCount')
        if m.get('GroupCount') is not None:
            self.group_count = m.get('GroupCount')
        if m.get('HuaweiInstanceCount') is not None:
            self.huawei_instance_count = m.get('HuaweiInstanceCount')
        if m.get('IdcInstanceCount') is not None:
            self.idc_instance_count = m.get('IdcInstanceCount')
        if m.get('ImportantAssetCount') is not None:
            self.important_asset_count = m.get('ImportantAssetCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceSyncTaskCount') is not None:
            self.instance_sync_task_count = m.get('InstanceSyncTaskCount')
        if m.get('NewInstanceCount') is not None:
            self.new_instance_count = m.get('NewInstanceCount')
        if m.get('NotRunningStatusCount') is not None:
            self.not_running_status_count = m.get('NotRunningStatusCount')
        if m.get('OfflineInstanceCount') is not None:
            self.offline_instance_count = m.get('OfflineInstanceCount')
        if m.get('PauseInstanceCount') is not None:
            self.pause_instance_count = m.get('PauseInstanceCount')
        if m.get('RegionCount') is not None:
            self.region_count = m.get('RegionCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('TencentInstanceCount') is not None:
            self.tencent_instance_count = m.get('TencentInstanceCount')
        if m.get('TestAssetCount') is not None:
            self.test_asset_count = m.get('TestAssetCount')
        if m.get('UnprotectedInstanceCount') is not None:
            self.unprotected_instance_count = m.get('UnprotectedInstanceCount')
        if m.get('VpcCount') is not None:
            self.vpc_count = m.get('VpcCount')
        return self


class DescribeFieldStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        grouped_fields: DescribeFieldStatisticsResponseBodyGroupedFields = None,
        request_id: str = None,
    ):
        self.grouped_fields = grouped_fields
        self.request_id = request_id

    def validate(self):
        if self.grouped_fields:
            self.grouped_fields.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grouped_fields is not None:
            result['GroupedFields'] = self.grouped_fields.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupedFields') is not None:
            temp_model = DescribeFieldStatisticsResponseBodyGroupedFields()
            self.grouped_fields = temp_model.from_map(m['GroupedFields'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFieldStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeFieldStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeFieldStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedContainerInstancesRequest(TeaModel):
    def __init__(
        self,
        criteria: str = None,
        current_page: int = None,
        field_value: str = None,
        group_field: str = None,
        logical_exp: str = None,
        page_size: int = None,
    ):
        self.criteria = criteria
        self.current_page = current_page
        self.field_value = field_value
        self.group_field = group_field
        self.logical_exp = logical_exp
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList(TeaModel):
    def __init__(
        self,
        alarm_count: int = None,
        app_name: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_type: str = None,
        create_time: int = None,
        custer_state: str = None,
        hc_count: int = None,
        host_ip: str = None,
        image: str = None,
        image_digest: str = None,
        image_repo_name: str = None,
        image_repo_namespace: str = None,
        image_repo_tag: str = None,
        image_uuid: str = None,
        instance_count: int = None,
        instance_id: str = None,
        namespace: str = None,
        pod: str = None,
        pod_ip: str = None,
        region_id: str = None,
        risk_instance_count: int = None,
        risk_level: str = None,
        risk_status: str = None,
        vul_count: int = None,
    ):
        self.alarm_count = alarm_count
        self.app_name = app_name
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.cluster_type = cluster_type
        self.create_time = create_time
        self.custer_state = custer_state
        self.hc_count = hc_count
        self.host_ip = host_ip
        self.image = image
        self.image_digest = image_digest
        self.image_repo_name = image_repo_name
        self.image_repo_namespace = image_repo_namespace
        self.image_repo_tag = image_repo_tag
        self.image_uuid = image_uuid
        self.instance_count = instance_count
        self.instance_id = instance_id
        self.namespace = namespace
        self.pod = pod
        self.pod_ip = pod_ip
        self.region_id = region_id
        self.risk_instance_count = risk_instance_count
        self.risk_level = risk_level
        self.risk_status = risk_status
        self.vul_count = vul_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.custer_state is not None:
            result['CusterState'] = self.custer_state
        if self.hc_count is not None:
            result['HcCount'] = self.hc_count
        if self.host_ip is not None:
            result['HostIp'] = self.host_ip
        if self.image is not None:
            result['Image'] = self.image
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_repo_name is not None:
            result['ImageRepoName'] = self.image_repo_name
        if self.image_repo_namespace is not None:
            result['ImageRepoNamespace'] = self.image_repo_namespace
        if self.image_repo_tag is not None:
            result['ImageRepoTag'] = self.image_repo_tag
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.pod_ip is not None:
            result['PodIp'] = self.pod_ip
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CusterState') is not None:
            self.custer_state = m.get('CusterState')
        if m.get('HcCount') is not None:
            self.hc_count = m.get('HcCount')
        if m.get('HostIp') is not None:
            self.host_ip = m.get('HostIp')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageRepoName') is not None:
            self.image_repo_name = m.get('ImageRepoName')
        if m.get('ImageRepoNamespace') is not None:
            self.image_repo_namespace = m.get('ImageRepoNamespace')
        if m.get('ImageRepoTag') is not None:
            self.image_repo_tag = m.get('ImageRepoTag')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('PodIp') is not None:
            self.pod_ip = m.get('PodIp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        return self


class DescribeGroupedContainerInstancesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedContainerInstancesResponseBody(TeaModel):
    def __init__(
        self,
        grouped_container_instance_list: List[DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList] = None,
        page_info: DescribeGroupedContainerInstancesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.grouped_container_instance_list = grouped_container_instance_list
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.grouped_container_instance_list:
            for k in self.grouped_container_instance_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GroupedContainerInstanceList'] = []
        if self.grouped_container_instance_list is not None:
            for k in self.grouped_container_instance_list:
                result['GroupedContainerInstanceList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.grouped_container_instance_list = []
        if m.get('GroupedContainerInstanceList') is not None:
            for k in m.get('GroupedContainerInstanceList'):
                temp_model = DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList()
                self.grouped_container_instance_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedContainerInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedContainerInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGroupedContainerInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedContainerInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedInstancesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        field_value: str = None,
        group_field: str = None,
        lang: str = None,
        machine_types: str = None,
        no_page: bool = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        self.field_value = field_value
        self.group_field = group_field
        self.lang = lang
        self.machine_types = machine_types
        self.no_page = no_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.no_page is not None:
            result['NoPage'] = self.no_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('NoPage') is not None:
            self.no_page = m.get('NoPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeGroupedInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        asap_vul_instance_count: int = None,
        field_alias_name: str = None,
        group_flag: int = None,
        instance_count: str = None,
        risk_instance_count: str = None,
        un_protected_instance_count: str = None,
    ):
        self.asap_vul_instance_count = asap_vul_instance_count
        self.field_alias_name = field_alias_name
        self.group_flag = group_flag
        self.instance_count = instance_count
        self.risk_instance_count = risk_instance_count
        self.un_protected_instance_count = un_protected_instance_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_vul_instance_count is not None:
            result['AsapVulInstanceCount'] = self.asap_vul_instance_count
        if self.field_alias_name is not None:
            result['FieldAliasName'] = self.field_alias_name
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.un_protected_instance_count is not None:
            result['UnProtectedInstanceCount'] = self.un_protected_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsapVulInstanceCount') is not None:
            self.asap_vul_instance_count = m.get('AsapVulInstanceCount')
        if m.get('FieldAliasName') is not None:
            self.field_alias_name = m.get('FieldAliasName')
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('UnProtectedInstanceCount') is not None:
            self.un_protected_instance_count = m.get('UnProtectedInstanceCount')
        return self


class DescribeGroupedInstancesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instances: List[DescribeGroupedInstancesResponseBodyInstances] = None,
        page_info: DescribeGroupedInstancesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.instances = instances
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeGroupedInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGroupedInstancesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedMaliciousFilesRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        current_page: int = None,
        fuzzy_malicious_name: str = None,
        image_digest: str = None,
        image_layer: str = None,
        image_tag: str = None,
        lang: str = None,
        levels: str = None,
        page_size: str = None,
        repo_id: str = None,
        repo_instance_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        repo_region_id: str = None,
    ):
        self.cluster_id = cluster_id
        self.current_page = current_page
        self.fuzzy_malicious_name = fuzzy_malicious_name
        self.image_digest = image_digest
        self.image_layer = image_layer
        self.image_tag = image_tag
        self.lang = lang
        self.levels = levels
        self.page_size = page_size
        self.repo_id = repo_id
        self.repo_instance_id = repo_instance_id
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace
        self.repo_region_id = repo_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.fuzzy_malicious_name is not None:
            result['FuzzyMaliciousName'] = self.fuzzy_malicious_name
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FuzzyMaliciousName') is not None:
            self.fuzzy_malicious_name = m.get('FuzzyMaliciousName')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        return self


class DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse(TeaModel):
    def __init__(
        self,
        first_scan_timestamp: int = None,
        image_count: int = None,
        latest_scan_timestamp: int = None,
        level: str = None,
        malicious_md_5: str = None,
        malicious_name: str = None,
        status: int = None,
    ):
        self.first_scan_timestamp = first_scan_timestamp
        self.image_count = image_count
        self.latest_scan_timestamp = latest_scan_timestamp
        self.level = level
        self.malicious_md_5 = malicious_md_5
        self.malicious_name = malicious_name
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.first_scan_timestamp is not None:
            result['FirstScanTimestamp'] = self.first_scan_timestamp
        if self.image_count is not None:
            result['ImageCount'] = self.image_count
        if self.latest_scan_timestamp is not None:
            result['LatestScanTimestamp'] = self.latest_scan_timestamp
        if self.level is not None:
            result['Level'] = self.level
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.malicious_name is not None:
            result['MaliciousName'] = self.malicious_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirstScanTimestamp') is not None:
            self.first_scan_timestamp = m.get('FirstScanTimestamp')
        if m.get('ImageCount') is not None:
            self.image_count = m.get('ImageCount')
        if m.get('LatestScanTimestamp') is not None:
            self.latest_scan_timestamp = m.get('LatestScanTimestamp')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('MaliciousName') is not None:
            self.malicious_name = m.get('MaliciousName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeGroupedMaliciousFilesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedMaliciousFilesResponseBody(TeaModel):
    def __init__(
        self,
        grouped_malicious_file_response: List[DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse] = None,
        page_info: DescribeGroupedMaliciousFilesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.grouped_malicious_file_response = grouped_malicious_file_response
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.grouped_malicious_file_response:
            for k in self.grouped_malicious_file_response:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GroupedMaliciousFileResponse'] = []
        if self.grouped_malicious_file_response is not None:
            for k in self.grouped_malicious_file_response:
                result['GroupedMaliciousFileResponse'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.grouped_malicious_file_response = []
        if m.get('GroupedMaliciousFileResponse') is not None:
            for k in m.get('GroupedMaliciousFileResponse'):
                temp_model = DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse()
                self.grouped_malicious_file_response.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedMaliciousFilesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedMaliciousFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGroupedMaliciousFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedMaliciousFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedTagsRequest(TeaModel):
    def __init__(
        self,
        machine_types: str = None,
    ):
        self.machine_types = machine_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        return self


class DescribeGroupedTagsResponseBodyGroupedFileds(TeaModel):
    def __init__(
        self,
        count: str = None,
        name: str = None,
        tag_id: int = None,
    ):
        self.count = count
        self.name = name
        self.tag_id = tag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.name is not None:
            result['Name'] = self.name
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class DescribeGroupedTagsResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        grouped_fileds: List[DescribeGroupedTagsResponseBodyGroupedFileds] = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.count = count
        self.grouped_fileds = grouped_fileds
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.grouped_fileds:
            for k in self.grouped_fileds:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['GroupedFileds'] = []
        if self.grouped_fileds is not None:
            for k in self.grouped_fileds:
                result['GroupedFileds'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.grouped_fileds = []
        if m.get('GroupedFileds') is not None:
            for k in m.get('GroupedFileds'):
                temp_model = DescribeGroupedTagsResponseBodyGroupedFileds()
                self.grouped_fileds.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeGroupedTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGroupedTagsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedVulRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        attach_types: str = None,
        current_page: int = None,
        dealed: str = None,
        group_id: str = None,
        lang: str = None,
        necessity: str = None,
        page_size: int = None,
        search_tags: str = None,
        type: str = None,
        uuids: str = None,
    ):
        self.alias_name = alias_name
        self.attach_types = attach_types
        self.current_page = current_page
        self.dealed = dealed
        self.group_id = group_id
        self.lang = lang
        self.necessity = necessity
        self.page_size = page_size
        self.search_tags = search_tags
        self.type = type
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.attach_types is not None:
            result['AttachTypes'] = self.attach_types
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_tags is not None:
            result['SearchTags'] = self.search_tags
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AttachTypes') is not None:
            self.attach_types = m.get('AttachTypes')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchTags') is not None:
            self.search_tags = m.get('SearchTags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeGroupedVulResponseBodyGroupedVulItems(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        asap_count: int = None,
        gmt_last: int = None,
        handled_count: int = None,
        later_count: int = None,
        name: str = None,
        nntf_count: int = None,
        tags: str = None,
        total_fix_count: int = None,
        type: str = None,
    ):
        self.alias_name = alias_name
        self.asap_count = asap_count
        self.gmt_last = gmt_last
        self.handled_count = handled_count
        self.later_count = later_count
        self.name = name
        self.nntf_count = nntf_count
        self.tags = tags
        self.total_fix_count = total_fix_count
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.handled_count is not None:
            result['HandledCount'] = self.handled_count
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.name is not None:
            result['Name'] = self.name
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.total_fix_count is not None:
            result['TotalFixCount'] = self.total_fix_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('HandledCount') is not None:
            self.handled_count = m.get('HandledCount')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TotalFixCount') is not None:
            self.total_fix_count = m.get('TotalFixCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeGroupedVulResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        grouped_vul_items: List[DescribeGroupedVulResponseBodyGroupedVulItems] = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.current_page = current_page
        self.grouped_vul_items = grouped_vul_items
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeGroupedVulResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedVulResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeGroupedVulResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeGroupedVulResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHoneyPotAuthResponseBody(TeaModel):
    def __init__(
        self,
        honey_pot_auth_count: int = None,
        honey_pot_count: int = None,
        request_id: str = None,
    ):
        self.honey_pot_auth_count = honey_pot_auth_count
        self.honey_pot_count = honey_pot_count
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honey_pot_auth_count is not None:
            result['HoneyPotAuthCount'] = self.honey_pot_auth_count
        if self.honey_pot_count is not None:
            result['HoneyPotCount'] = self.honey_pot_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneyPotAuthCount') is not None:
            self.honey_pot_auth_count = m.get('HoneyPotAuthCount')
        if m.get('HoneyPotCount') is not None:
            self.honey_pot_count = m.get('HoneyPotCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeHoneyPotAuthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHoneyPotAuthResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHoneyPotAuthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHoneyPotSuspStatisticsRequest(TeaModel):
    def __init__(
        self,
        from_: str = None,
        statistics_days: int = None,
        statistics_key_type: str = None,
    ):
        self.from_ = from_
        self.statistics_days = statistics_days
        self.statistics_key_type = statistics_key_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.statistics_days is not None:
            result['StatisticsDays'] = self.statistics_days
        if self.statistics_key_type is not None:
            result['StatisticsKeyType'] = self.statistics_key_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('StatisticsDays') is not None:
            self.statistics_days = m.get('StatisticsDays')
        if m.get('StatisticsKeyType') is not None:
            self.statistics_key_type = m.get('StatisticsKeyType')
        return self


class DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse(TeaModel):
    def __init__(
        self,
        count: int = None,
        instance_id: str = None,
        instance_name: str = None,
        type: str = None,
        vpc_id: str = None,
        vpc_name: str = None,
    ):
        self.count = count
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.type = type
        self.vpc_id = vpc_id
        self.vpc_name = vpc_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        return self


class DescribeHoneyPotSuspStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        susp_honey_pot_statistics_response: List[DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse] = None,
    ):
        self.request_id = request_id
        self.susp_honey_pot_statistics_response = susp_honey_pot_statistics_response

    def validate(self):
        if self.susp_honey_pot_statistics_response:
            for k in self.susp_honey_pot_statistics_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SuspHoneyPotStatisticsResponse'] = []
        if self.susp_honey_pot_statistics_response is not None:
            for k in self.susp_honey_pot_statistics_response:
                result['SuspHoneyPotStatisticsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.susp_honey_pot_statistics_response = []
        if m.get('SuspHoneyPotStatisticsResponse') is not None:
            for k in m.get('SuspHoneyPotStatisticsResponse'):
                temp_model = DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse()
                self.susp_honey_pot_statistics_response.append(temp_model.from_map(k))
        return self


class DescribeHoneyPotSuspStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeHoneyPotSuspStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeHoneyPotSuspStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageBaselineCheckSummaryRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        criteria: str = None,
        criteria_type: str = None,
        current_page: int = None,
        lang: str = None,
        page_size: int = None,
        risk_level: str = None,
    ):
        self.cluster_id = cluster_id
        self.criteria = criteria
        self.criteria_type = criteria_type
        self.current_page = current_page
        self.lang = lang
        self.page_size = page_size
        self.risk_level = risk_level

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.criteria_type is not None:
            result['CriteriaType'] = self.criteria_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CriteriaType') is not None:
            self.criteria_type = m.get('CriteriaType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        return self


class DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary(TeaModel):
    def __init__(
        self,
        baseline_class_alias: str = None,
        baseline_class_key: str = None,
        baseline_name_alias: str = None,
        baseline_name_key: str = None,
        baseline_name_level: str = None,
        first_scan_time: int = None,
        high_risk_image: int = None,
        last_scan_time: int = None,
        low_risk_image: int = None,
        middle_risk_image: int = None,
        status: int = None,
    ):
        self.baseline_class_alias = baseline_class_alias
        self.baseline_class_key = baseline_class_key
        self.baseline_name_alias = baseline_name_alias
        self.baseline_name_key = baseline_name_key
        self.baseline_name_level = baseline_name_level
        self.first_scan_time = first_scan_time
        self.high_risk_image = high_risk_image
        self.last_scan_time = last_scan_time
        self.low_risk_image = low_risk_image
        self.middle_risk_image = middle_risk_image
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_class_alias is not None:
            result['BaselineClassAlias'] = self.baseline_class_alias
        if self.baseline_class_key is not None:
            result['BaselineClassKey'] = self.baseline_class_key
        if self.baseline_name_alias is not None:
            result['BaselineNameAlias'] = self.baseline_name_alias
        if self.baseline_name_key is not None:
            result['BaselineNameKey'] = self.baseline_name_key
        if self.baseline_name_level is not None:
            result['BaselineNameLevel'] = self.baseline_name_level
        if self.first_scan_time is not None:
            result['FirstScanTime'] = self.first_scan_time
        if self.high_risk_image is not None:
            result['HighRiskImage'] = self.high_risk_image
        if self.last_scan_time is not None:
            result['LastScanTime'] = self.last_scan_time
        if self.low_risk_image is not None:
            result['LowRiskImage'] = self.low_risk_image
        if self.middle_risk_image is not None:
            result['MiddleRiskImage'] = self.middle_risk_image
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineClassAlias') is not None:
            self.baseline_class_alias = m.get('BaselineClassAlias')
        if m.get('BaselineClassKey') is not None:
            self.baseline_class_key = m.get('BaselineClassKey')
        if m.get('BaselineNameAlias') is not None:
            self.baseline_name_alias = m.get('BaselineNameAlias')
        if m.get('BaselineNameKey') is not None:
            self.baseline_name_key = m.get('BaselineNameKey')
        if m.get('BaselineNameLevel') is not None:
            self.baseline_name_level = m.get('BaselineNameLevel')
        if m.get('FirstScanTime') is not None:
            self.first_scan_time = m.get('FirstScanTime')
        if m.get('HighRiskImage') is not None:
            self.high_risk_image = m.get('HighRiskImage')
        if m.get('LastScanTime') is not None:
            self.last_scan_time = m.get('LastScanTime')
        if m.get('LowRiskImage') is not None:
            self.low_risk_image = m.get('LowRiskImage')
        if m.get('MiddleRiskImage') is not None:
            self.middle_risk_image = m.get('MiddleRiskImage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeImageBaselineCheckSummaryResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageBaselineCheckSummaryResponseBody(TeaModel):
    def __init__(
        self,
        baseline_result_summary: List[DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary] = None,
        page_info: DescribeImageBaselineCheckSummaryResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.baseline_result_summary = baseline_result_summary
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.baseline_result_summary:
            for k in self.baseline_result_summary:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaselineResultSummary'] = []
        if self.baseline_result_summary is not None:
            for k in self.baseline_result_summary:
                result['BaselineResultSummary'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baseline_result_summary = []
        if m.get('BaselineResultSummary') is not None:
            for k in m.get('BaselineResultSummary'):
                temp_model = DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary()
                self.baseline_result_summary.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeImageBaselineCheckSummaryResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageBaselineCheckSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeImageBaselineCheckSummaryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageBaselineCheckSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageFixTaskRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        end_time: int = None,
        page_size: int = None,
        start_time: int = None,
        status: str = None,
    ):
        self.current_page = current_page
        self.end_time = end_time
        self.page_size = page_size
        self.start_time = start_time
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeImageFixTaskResponseBodyBuildTasks(TeaModel):
    def __init__(
        self,
        build_task_id: str = None,
        finish_time: str = None,
        fix_time: str = None,
        new_tag: str = None,
        new_uuid: str = None,
        old_tag: str = None,
        old_uuid: str = None,
        region_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        status: int = None,
        task_type: str = None,
    ):
        self.build_task_id = build_task_id
        self.finish_time = finish_time
        self.fix_time = fix_time
        self.new_tag = new_tag
        self.new_uuid = new_uuid
        self.old_tag = old_tag
        self.old_uuid = old_uuid
        self.region_id = region_id
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace
        self.status = status
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.build_task_id is not None:
            result['BuildTaskId'] = self.build_task_id
        if self.finish_time is not None:
            result['FinishTime'] = self.finish_time
        if self.fix_time is not None:
            result['FixTime'] = self.fix_time
        if self.new_tag is not None:
            result['NewTag'] = self.new_tag
        if self.new_uuid is not None:
            result['NewUuid'] = self.new_uuid
        if self.old_tag is not None:
            result['OldTag'] = self.old_tag
        if self.old_uuid is not None:
            result['OldUuid'] = self.old_uuid
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.status is not None:
            result['Status'] = self.status
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuildTaskId') is not None:
            self.build_task_id = m.get('BuildTaskId')
        if m.get('FinishTime') is not None:
            self.finish_time = m.get('FinishTime')
        if m.get('FixTime') is not None:
            self.fix_time = m.get('FixTime')
        if m.get('NewTag') is not None:
            self.new_tag = m.get('NewTag')
        if m.get('NewUuid') is not None:
            self.new_uuid = m.get('NewUuid')
        if m.get('OldTag') is not None:
            self.old_tag = m.get('OldTag')
        if m.get('OldUuid') is not None:
            self.old_uuid = m.get('OldUuid')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeImageFixTaskResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageFixTaskResponseBody(TeaModel):
    def __init__(
        self,
        build_tasks: List[DescribeImageFixTaskResponseBodyBuildTasks] = None,
        page_info: DescribeImageFixTaskResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.build_tasks = build_tasks
        self.page_info = page_info
        # Id of the request
        self.request_id = request_id

    def validate(self):
        if self.build_tasks:
            for k in self.build_tasks:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BuildTasks'] = []
        if self.build_tasks is not None:
            for k in self.build_tasks:
                result['BuildTasks'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.build_tasks = []
        if m.get('BuildTasks') is not None:
            for k in m.get('BuildTasks'):
                temp_model = DescribeImageFixTaskResponseBodyBuildTasks()
                self.build_tasks.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeImageFixTaskResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageFixTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeImageFixTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageFixTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageGroupedVulListRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        cluster_id: str = None,
        current_page: int = None,
        cve_id: str = None,
        group_id: str = None,
        image_digest: str = None,
        image_layer: str = None,
        image_tag: str = None,
        is_latest: int = None,
        lang: str = None,
        name: str = None,
        necessity: str = None,
        page_size: int = None,
        patch_id: int = None,
        repo_id: str = None,
        repo_instance_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        repo_region_id: str = None,
        type: str = None,
        uuids: str = None,
    ):
        self.alias_name = alias_name
        self.cluster_id = cluster_id
        self.current_page = current_page
        self.cve_id = cve_id
        self.group_id = group_id
        self.image_digest = image_digest
        self.image_layer = image_layer
        self.image_tag = image_tag
        self.is_latest = is_latest
        self.lang = lang
        self.name = name
        self.necessity = necessity
        self.page_size = page_size
        self.patch_id = patch_id
        self.repo_id = repo_id
        self.repo_instance_id = repo_instance_id
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace
        self.repo_region_id = repo_region_id
        self.type = type
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.cve_id is not None:
            result['CveId'] = self.cve_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.is_latest is not None:
            result['IsLatest'] = self.is_latest
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.patch_id is not None:
            result['PatchId'] = self.patch_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('CveId') is not None:
            self.cve_id = m.get('CveId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('IsLatest') is not None:
            self.is_latest = m.get('IsLatest')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PatchId') is not None:
            self.patch_id = m.get('PatchId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeImageGroupedVulListResponseBodyGroupedVulItems(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        asap_count: int = None,
        gmt_last: int = None,
        last_scan_time: int = None,
        later_count: int = None,
        name: str = None,
        nntf_count: int = None,
        status: int = None,
        tags: str = None,
        type: str = None,
    ):
        self.alias_name = alias_name
        self.asap_count = asap_count
        self.gmt_last = gmt_last
        self.last_scan_time = last_scan_time
        self.later_count = later_count
        self.name = name
        self.nntf_count = nntf_count
        self.status = status
        self.tags = tags
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.last_scan_time is not None:
            result['LastScanTime'] = self.last_scan_time
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.name is not None:
            result['Name'] = self.name
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('LastScanTime') is not None:
            self.last_scan_time = m.get('LastScanTime')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeImageGroupedVulListResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        grouped_vul_items: List[DescribeImageGroupedVulListResponseBodyGroupedVulItems] = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.current_page = current_page
        self.grouped_vul_items = grouped_vul_items
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeImageGroupedVulListResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageGroupedVulListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeImageGroupedVulListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageGroupedVulListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageListWithBaselineNameRequest(TeaModel):
    def __init__(
        self,
        baseline_name_key: str = None,
        cluster_id: str = None,
        criteria: str = None,
        criteria_type: str = None,
        current_page: int = None,
        image_digest: str = None,
        lang: str = None,
        page_size: int = None,
        repo_instance_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
    ):
        self.baseline_name_key = baseline_name_key
        self.cluster_id = cluster_id
        self.criteria = criteria
        self.criteria_type = criteria_type
        self.current_page = current_page
        self.image_digest = image_digest
        self.lang = lang
        self.page_size = page_size
        self.repo_instance_id = repo_instance_id
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_name_key is not None:
            result['BaselineNameKey'] = self.baseline_name_key
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.criteria_type is not None:
            result['CriteriaType'] = self.criteria_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineNameKey') is not None:
            self.baseline_name_key = m.get('BaselineNameKey')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CriteriaType') is not None:
            self.criteria_type = m.get('CriteriaType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        return self


class DescribeImageListWithBaselineNameResponseBodyImageInfos(TeaModel):
    def __init__(
        self,
        digest: str = None,
        high_risk_image: int = None,
        image_create: int = None,
        image_id: str = None,
        image_size: int = None,
        image_update: int = None,
        instance_id: str = None,
        low_risk_image: int = None,
        middle_risk_image: int = None,
        no_risk_image: int = None,
        region_id: str = None,
        repo_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        repo_type: str = None,
        risk_status: str = None,
        tag: str = None,
        total_item_count: int = None,
        uuid: str = None,
    ):
        self.digest = digest
        self.high_risk_image = high_risk_image
        self.image_create = image_create
        self.image_id = image_id
        self.image_size = image_size
        self.image_update = image_update
        self.instance_id = instance_id
        self.low_risk_image = low_risk_image
        self.middle_risk_image = middle_risk_image
        self.no_risk_image = no_risk_image
        self.region_id = region_id
        self.repo_id = repo_id
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace
        self.repo_type = repo_type
        self.risk_status = risk_status
        self.tag = tag
        self.total_item_count = total_item_count
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.high_risk_image is not None:
            result['HighRiskImage'] = self.high_risk_image
        if self.image_create is not None:
            result['ImageCreate'] = self.image_create
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_size is not None:
            result['ImageSize'] = self.image_size
        if self.image_update is not None:
            result['ImageUpdate'] = self.image_update
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.low_risk_image is not None:
            result['LowRiskImage'] = self.low_risk_image
        if self.middle_risk_image is not None:
            result['MiddleRiskImage'] = self.middle_risk_image
        if self.no_risk_image is not None:
            result['NoRiskImage'] = self.no_risk_image
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_type is not None:
            result['RepoType'] = self.repo_type
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.total_item_count is not None:
            result['TotalItemCount'] = self.total_item_count
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('HighRiskImage') is not None:
            self.high_risk_image = m.get('HighRiskImage')
        if m.get('ImageCreate') is not None:
            self.image_create = m.get('ImageCreate')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageSize') is not None:
            self.image_size = m.get('ImageSize')
        if m.get('ImageUpdate') is not None:
            self.image_update = m.get('ImageUpdate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LowRiskImage') is not None:
            self.low_risk_image = m.get('LowRiskImage')
        if m.get('MiddleRiskImage') is not None:
            self.middle_risk_image = m.get('MiddleRiskImage')
        if m.get('NoRiskImage') is not None:
            self.no_risk_image = m.get('NoRiskImage')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoType') is not None:
            self.repo_type = m.get('RepoType')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TotalItemCount') is not None:
            self.total_item_count = m.get('TotalItemCount')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeImageListWithBaselineNameResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageListWithBaselineNameResponseBody(TeaModel):
    def __init__(
        self,
        image_infos: List[DescribeImageListWithBaselineNameResponseBodyImageInfos] = None,
        page_info: DescribeImageListWithBaselineNameResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.image_infos = image_infos
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.image_infos:
            for k in self.image_infos:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ImageInfos'] = []
        if self.image_infos is not None:
            for k in self.image_infos:
                result['ImageInfos'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.image_infos = []
        if m.get('ImageInfos') is not None:
            for k in m.get('ImageInfos'):
                temp_model = DescribeImageListWithBaselineNameResponseBodyImageInfos()
                self.image_infos.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeImageListWithBaselineNameResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageListWithBaselineNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeImageListWithBaselineNameResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageListWithBaselineNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageScanAuthCountResponseBodyImageScan(TeaModel):
    def __init__(
        self,
        image_scan_capacity: int = None,
        instance_id: str = None,
        scan_count: int = None,
    ):
        self.image_scan_capacity = image_scan_capacity
        self.instance_id = instance_id
        self.scan_count = scan_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_scan_capacity is not None:
            result['ImageScanCapacity'] = self.image_scan_capacity
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.scan_count is not None:
            result['ScanCount'] = self.scan_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageScanCapacity') is not None:
            self.image_scan_capacity = m.get('ImageScanCapacity')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ScanCount') is not None:
            self.scan_count = m.get('ScanCount')
        return self


class DescribeImageScanAuthCountResponseBody(TeaModel):
    def __init__(
        self,
        image_scan: DescribeImageScanAuthCountResponseBodyImageScan = None,
        request_id: str = None,
    ):
        self.image_scan = image_scan
        self.request_id = request_id

    def validate(self):
        if self.image_scan:
            self.image_scan.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_scan is not None:
            result['ImageScan'] = self.image_scan.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageScan') is not None:
            temp_model = DescribeImageScanAuthCountResponseBodyImageScan()
            self.image_scan = temp_model.from_map(m['ImageScan'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageScanAuthCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeImageScanAuthCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageScanAuthCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        instance_count: int = None,
        request_id: str = None,
        risk_instance_count: int = None,
    ):
        self.instance_count = instance_count
        self.request_id = request_id
        self.risk_instance_count = risk_instance_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        return self


class DescribeImageStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeImageStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageVulListRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        cluster_id: str = None,
        current_page: int = None,
        dealed: str = None,
        digest: str = None,
        instance_id: str = None,
        lang: str = None,
        name: str = None,
        necessity: str = None,
        page_size: int = None,
        region_id: str = None,
        repo_id: str = None,
        repo_instance_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        repo_region_id: str = None,
        status_list: str = None,
        tag: str = None,
        type: str = None,
        uuids: str = None,
    ):
        self.alias_name = alias_name
        self.cluster_id = cluster_id
        self.current_page = current_page
        self.dealed = dealed
        self.digest = digest
        self.instance_id = instance_id
        self.lang = lang
        self.name = name
        self.necessity = necessity
        self.page_size = page_size
        self.region_id = region_id
        self.repo_id = repo_id
        self.repo_instance_id = repo_instance_id
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace
        self.repo_region_id = repo_region_id
        self.status_list = status_list
        self.tag = tag
        self.type = type
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeImageVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList(TeaModel):
    def __init__(
        self,
        full_version: str = None,
        layer: str = None,
        match_detail: str = None,
        match_list: List[str] = None,
        name: str = None,
        path: str = None,
        update_cmd: str = None,
        version: str = None,
    ):
        self.full_version = full_version
        self.layer = layer
        self.match_detail = match_detail
        self.match_list = match_list
        self.name = name
        self.path = path
        self.update_cmd = update_cmd
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.full_version is not None:
            result['FullVersion'] = self.full_version
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.match_detail is not None:
            result['MatchDetail'] = self.match_detail
        if self.match_list is not None:
            result['MatchList'] = self.match_list
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.update_cmd is not None:
            result['UpdateCmd'] = self.update_cmd
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FullVersion') is not None:
            self.full_version = m.get('FullVersion')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('MatchDetail') is not None:
            self.match_detail = m.get('MatchDetail')
        if m.get('MatchList') is not None:
            self.match_list = m.get('MatchList')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('UpdateCmd') is not None:
            self.update_cmd = m.get('UpdateCmd')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeImageVulListResponseBodyVulRecordsExtendContentJson(TeaModel):
    def __init__(
        self,
        os: str = None,
        os_release: str = None,
        rpm_entity_list: List[DescribeImageVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList] = None,
    ):
        self.os = os
        self.os_release = os_release
        self.rpm_entity_list = rpm_entity_list

    def validate(self):
        if self.rpm_entity_list:
            for k in self.rpm_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.os is not None:
            result['Os'] = self.os
        if self.os_release is not None:
            result['OsRelease'] = self.os_release
        result['RpmEntityList'] = []
        if self.rpm_entity_list is not None:
            for k in self.rpm_entity_list:
                result['RpmEntityList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsRelease') is not None:
            self.os_release = m.get('OsRelease')
        self.rpm_entity_list = []
        if m.get('RpmEntityList') is not None:
            for k in m.get('RpmEntityList'):
                temp_model = DescribeImageVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList()
                self.rpm_entity_list.append(temp_model.from_map(k))
        return self


class DescribeImageVulListResponseBodyVulRecords(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        can_update: bool = None,
        extend_content_json: DescribeImageVulListResponseBodyVulRecordsExtendContentJson = None,
        first_ts: int = None,
        image_digest: str = None,
        last_ts: int = None,
        layers: List[str] = None,
        modify_ts: int = None,
        name: str = None,
        necessity: str = None,
        primary_id: int = None,
        related: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        status: int = None,
        tag: str = None,
        type: str = None,
        uuid: str = None,
    ):
        self.alias_name = alias_name
        self.can_update = can_update
        self.extend_content_json = extend_content_json
        self.first_ts = first_ts
        self.image_digest = image_digest
        self.last_ts = last_ts
        self.layers = layers
        self.modify_ts = modify_ts
        self.name = name
        self.necessity = necessity
        self.primary_id = primary_id
        self.related = related
        self.repo_name = repo_name
        self.repo_namespace = repo_namespace
        self.status = status
        self.tag = tag
        self.type = type
        self.uuid = uuid

    def validate(self):
        if self.extend_content_json:
            self.extend_content_json.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.can_update is not None:
            result['CanUpdate'] = self.can_update
        if self.extend_content_json is not None:
            result['ExtendContentJson'] = self.extend_content_json.to_map()
        if self.first_ts is not None:
            result['FirstTs'] = self.first_ts
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.last_ts is not None:
            result['LastTs'] = self.last_ts
        if self.layers is not None:
            result['Layers'] = self.layers
        if self.modify_ts is not None:
            result['ModifyTs'] = self.modify_ts
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.primary_id is not None:
            result['PrimaryId'] = self.primary_id
        if self.related is not None:
            result['Related'] = self.related
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('CanUpdate') is not None:
            self.can_update = m.get('CanUpdate')
        if m.get('ExtendContentJson') is not None:
            temp_model = DescribeImageVulListResponseBodyVulRecordsExtendContentJson()
            self.extend_content_json = temp_model.from_map(m['ExtendContentJson'])
        if m.get('FirstTs') is not None:
            self.first_ts = m.get('FirstTs')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('LastTs') is not None:
            self.last_ts = m.get('LastTs')
        if m.get('Layers') is not None:
            self.layers = m.get('Layers')
        if m.get('ModifyTs') is not None:
            self.modify_ts = m.get('ModifyTs')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PrimaryId') is not None:
            self.primary_id = m.get('PrimaryId')
        if m.get('Related') is not None:
            self.related = m.get('Related')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeImageVulListResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        vul_records: List[DescribeImageVulListResponseBodyVulRecords] = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.vul_records = vul_records

    def validate(self):
        if self.vul_records:
            for k in self.vul_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VulRecords'] = []
        if self.vul_records is not None:
            for k in self.vul_records:
                result['VulRecords'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vul_records = []
        if m.get('VulRecords') is not None:
            for k in m.get('VulRecords'):
                temp_model = DescribeImageVulListResponseBodyVulRecords()
                self.vul_records.append(temp_model.from_map(k))
        return self


class DescribeImageVulListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeImageVulListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeImageVulListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstallCaptchaRequest(TeaModel):
    def __init__(
        self,
        deadline: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        self.deadline = deadline
        self.lang = lang
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeInstallCaptchaResponseBody(TeaModel):
    def __init__(
        self,
        captcha_code: str = None,
        deadline: str = None,
        request_id: str = None,
    ):
        self.captcha_code = captcha_code
        self.deadline = deadline
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.captcha_code is not None:
            result['CaptchaCode'] = self.captcha_code
        if self.deadline is not None:
            result['Deadline'] = self.deadline
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CaptchaCode') is not None:
            self.captcha_code = m.get('CaptchaCode')
        if m.get('Deadline') is not None:
            self.deadline = m.get('Deadline')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstallCaptchaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeInstallCaptchaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstallCaptchaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstallCodesResponseBodyInstallCodes(TeaModel):
    def __init__(
        self,
        captcha_code: str = None,
        expired_date: int = None,
        group_id: int = None,
        group_name: str = None,
        only_image: bool = None,
        os: str = None,
        vendor_name: str = None,
    ):
        self.captcha_code = captcha_code
        self.expired_date = expired_date
        self.group_id = group_id
        self.group_name = group_name
        self.only_image = only_image
        self.os = os
        self.vendor_name = vendor_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.captcha_code is not None:
            result['CaptchaCode'] = self.captcha_code
        if self.expired_date is not None:
            result['ExpiredDate'] = self.expired_date
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.only_image is not None:
            result['OnlyImage'] = self.only_image
        if self.os is not None:
            result['Os'] = self.os
        if self.vendor_name is not None:
            result['VendorName'] = self.vendor_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CaptchaCode') is not None:
            self.captcha_code = m.get('CaptchaCode')
        if m.get('ExpiredDate') is not None:
            self.expired_date = m.get('ExpiredDate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('OnlyImage') is not None:
            self.only_image = m.get('OnlyImage')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('VendorName') is not None:
            self.vendor_name = m.get('VendorName')
        return self


class DescribeInstallCodesResponseBody(TeaModel):
    def __init__(
        self,
        install_codes: List[DescribeInstallCodesResponseBodyInstallCodes] = None,
        request_id: str = None,
    ):
        self.install_codes = install_codes
        self.request_id = request_id

    def validate(self):
        if self.install_codes:
            for k in self.install_codes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstallCodes'] = []
        if self.install_codes is not None:
            for k in self.install_codes:
                result['InstallCodes'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.install_codes = []
        if m.get('InstallCodes') is not None:
            for k in m.get('InstallCodes'):
                temp_model = DescribeInstallCodesResponseBodyInstallCodes()
                self.install_codes.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstallCodesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeInstallCodesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstallCodesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceAntiBruteForceRulesRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        source_ip: str = None,
        uuid_list: List[str] = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeInstanceAntiBruteForceRulesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeInstanceAntiBruteForceRulesResponseBodyRules(TeaModel):
    def __init__(
        self,
        id: int = None,
        name: str = None,
        uuid: str = None,
    ):
        self.id = id
        self.name = name
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeInstanceAntiBruteForceRulesResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeInstanceAntiBruteForceRulesResponseBodyPageInfo = None,
        request_id: str = None,
        rules: List[DescribeInstanceAntiBruteForceRulesResponseBodyRules] = None,
    ):
        self.page_info = page_info
        self.request_id = request_id
        self.rules = rules

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeInstanceAntiBruteForceRulesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeInstanceAntiBruteForceRulesResponseBodyRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeInstanceAntiBruteForceRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeInstanceAntiBruteForceRulesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceAntiBruteForceRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceStatisticsRequest(TeaModel):
    def __init__(
        self,
        from_: str = None,
        lang: str = None,
        source_ip: str = None,
        uuid: str = None,
    ):
        self.from_ = from_
        self.lang = lang
        self.source_ip = source_ip
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeInstanceStatisticsResponseBodyData(TeaModel):
    def __init__(
        self,
        account: int = None,
        app_num: int = None,
        cms_num: int = None,
        cve_num: int = None,
        emg_num: int = None,
        health: int = None,
        sca_num: int = None,
        suspicious: int = None,
        sys_num: int = None,
        trojan: int = None,
        uuid: str = None,
        vul: int = None,
    ):
        self.account = account
        self.app_num = app_num
        self.cms_num = cms_num
        self.cve_num = cve_num
        self.emg_num = emg_num
        self.health = health
        self.sca_num = sca_num
        self.suspicious = suspicious
        self.sys_num = sys_num
        self.trojan = trojan
        self.uuid = uuid
        self.vul = vul

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['Account'] = self.account
        if self.app_num is not None:
            result['AppNum'] = self.app_num
        if self.cms_num is not None:
            result['CmsNum'] = self.cms_num
        if self.cve_num is not None:
            result['CveNum'] = self.cve_num
        if self.emg_num is not None:
            result['EmgNum'] = self.emg_num
        if self.health is not None:
            result['Health'] = self.health
        if self.sca_num is not None:
            result['ScaNum'] = self.sca_num
        if self.suspicious is not None:
            result['Suspicious'] = self.suspicious
        if self.sys_num is not None:
            result['SysNum'] = self.sys_num
        if self.trojan is not None:
            result['Trojan'] = self.trojan
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vul is not None:
            result['Vul'] = self.vul
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Account') is not None:
            self.account = m.get('Account')
        if m.get('AppNum') is not None:
            self.app_num = m.get('AppNum')
        if m.get('CmsNum') is not None:
            self.cms_num = m.get('CmsNum')
        if m.get('CveNum') is not None:
            self.cve_num = m.get('CveNum')
        if m.get('EmgNum') is not None:
            self.emg_num = m.get('EmgNum')
        if m.get('Health') is not None:
            self.health = m.get('Health')
        if m.get('ScaNum') is not None:
            self.sca_num = m.get('ScaNum')
        if m.get('Suspicious') is not None:
            self.suspicious = m.get('Suspicious')
        if m.get('SysNum') is not None:
            self.sys_num = m.get('SysNum')
        if m.get('Trojan') is not None:
            self.trojan = m.get('Trojan')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Vul') is not None:
            self.vul = m.get('Vul')
        return self


class DescribeInstanceStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeInstanceStatisticsResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeInstanceStatisticsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeInstanceStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeInstanceStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeInstanceStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLoginBaseConfigsRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        target: str = None,
        type: str = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.target = target
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.target is not None:
            result['Target'] = self.target
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeLoginBaseConfigsResponseBodyBaseConfigsTargetList(TeaModel):
    def __init__(
        self,
        target: str = None,
        target_type: str = None,
    ):
        self.target = target
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeLoginBaseConfigsResponseBodyBaseConfigs(TeaModel):
    def __init__(
        self,
        account: str = None,
        end_time: str = None,
        ip: str = None,
        location: str = None,
        start_time: str = None,
        target_list: List[DescribeLoginBaseConfigsResponseBodyBaseConfigsTargetList] = None,
        total_count: int = None,
        uuid_count: int = None,
    ):
        self.account = account
        self.end_time = end_time
        self.ip = ip
        self.location = location
        self.start_time = start_time
        self.target_list = target_list
        self.total_count = total_count
        self.uuid_count = uuid_count

    def validate(self):
        if self.target_list:
            for k in self.target_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account is not None:
            result['Account'] = self.account
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.location is not None:
            result['Location'] = self.location
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        result['TargetList'] = []
        if self.target_list is not None:
            for k in self.target_list:
                result['TargetList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.uuid_count is not None:
            result['UuidCount'] = self.uuid_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Account') is not None:
            self.account = m.get('Account')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        self.target_list = []
        if m.get('TargetList') is not None:
            for k in m.get('TargetList'):
                temp_model = DescribeLoginBaseConfigsResponseBodyBaseConfigsTargetList()
                self.target_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UuidCount') is not None:
            self.uuid_count = m.get('UuidCount')
        return self


class DescribeLoginBaseConfigsResponseBody(TeaModel):
    def __init__(
        self,
        base_configs: List[DescribeLoginBaseConfigsResponseBodyBaseConfigs] = None,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.base_configs = base_configs
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.base_configs:
            for k in self.base_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaseConfigs'] = []
        if self.base_configs is not None:
            for k in self.base_configs:
                result['BaseConfigs'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.base_configs = []
        if m.get('BaseConfigs') is not None:
            for k in m.get('BaseConfigs'):
                temp_model = DescribeLoginBaseConfigsResponseBodyBaseConfigs()
                self.base_configs.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeLoginBaseConfigsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLoginBaseConfigsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLoginBaseConfigsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeLogstoreStorageRequest(TeaModel):
    def __init__(
        self,
        from_: str = None,
        lang: str = None,
    ):
        self.from_ = from_
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeLogstoreStorageResponseBody(TeaModel):
    def __init__(
        self,
        logstore: str = None,
        preserve: int = None,
        request_id: str = None,
        ttl: int = None,
        used: int = None,
    ):
        self.logstore = logstore
        self.preserve = preserve
        self.request_id = request_id
        self.ttl = ttl
        self.used = used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logstore is not None:
            result['Logstore'] = self.logstore
        if self.preserve is not None:
            result['Preserve'] = self.preserve
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.used is not None:
            result['Used'] = self.used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Logstore') is not None:
            self.logstore = m.get('Logstore')
        if m.get('Preserve') is not None:
            self.preserve = m.get('Preserve')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('Used') is not None:
            self.used = m.get('Used')
        return self


class DescribeLogstoreStorageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeLogstoreStorageResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeLogstoreStorageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeModuleConfigResponseBodyModuleConfigListItems(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        instance_id: str = None,
        instance_name: str = None,
        ip: str = None,
        region: str = None,
        uuid: str = None,
    ):
        self.group_id = group_id
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.ip = ip
        self.region = region
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.region is not None:
            result['Region'] = self.region
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeModuleConfigResponseBodyModuleConfigList(TeaModel):
    def __init__(
        self,
        config_name: str = None,
        items: List[DescribeModuleConfigResponseBodyModuleConfigListItems] = None,
        module_name: str = None,
    ):
        self.config_name = config_name
        self.items = items
        self.module_name = module_name

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_name is not None:
            result['ConfigName'] = self.config_name
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.module_name is not None:
            result['ModuleName'] = self.module_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigName') is not None:
            self.config_name = m.get('ConfigName')
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = DescribeModuleConfigResponseBodyModuleConfigListItems()
                self.items.append(temp_model.from_map(k))
        if m.get('ModuleName') is not None:
            self.module_name = m.get('ModuleName')
        return self


class DescribeModuleConfigResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        http_status_code: int = None,
        module_config_list: List[DescribeModuleConfigResponseBodyModuleConfigList] = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.count = count
        self.http_status_code = http_status_code
        self.module_config_list = module_config_list
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.module_config_list:
            for k in self.module_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        result['ModuleConfigList'] = []
        if self.module_config_list is not None:
            for k in self.module_config_list:
                result['ModuleConfigList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        self.module_config_list = []
        if m.get('ModuleConfigList') is not None:
            for k in m.get('ModuleConfigList'):
                temp_model = DescribeModuleConfigResponseBodyModuleConfigList()
                self.module_config_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeModuleConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeModuleConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeModuleConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNoticeConfigRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
    ):
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeNoticeConfigResponseBodyNoticeConfigList(TeaModel):
    def __init__(
        self,
        ali_uid: int = None,
        current_page: int = None,
        project: str = None,
        route: int = None,
        time_limit: int = None,
    ):
        self.ali_uid = ali_uid
        self.current_page = current_page
        self.project = project
        self.route = route
        self.time_limit = time_limit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.project is not None:
            result['Project'] = self.project
        if self.route is not None:
            result['Route'] = self.route
        if self.time_limit is not None:
            result['TimeLimit'] = self.time_limit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Project') is not None:
            self.project = m.get('Project')
        if m.get('Route') is not None:
            self.route = m.get('Route')
        if m.get('TimeLimit') is not None:
            self.time_limit = m.get('TimeLimit')
        return self


class DescribeNoticeConfigResponseBody(TeaModel):
    def __init__(
        self,
        notice_config_list: List[DescribeNoticeConfigResponseBodyNoticeConfigList] = None,
        request_id: str = None,
    ):
        self.notice_config_list = notice_config_list
        self.request_id = request_id

    def validate(self):
        if self.notice_config_list:
            for k in self.notice_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['NoticeConfigList'] = []
        if self.notice_config_list is not None:
            for k in self.notice_config_list:
                result['NoticeConfigList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.notice_config_list = []
        if m.get('NoticeConfigList') is not None:
            for k in m.get('NoticeConfigList'):
                temp_model = DescribeNoticeConfigResponseBodyNoticeConfigList()
                self.notice_config_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeNoticeConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeNoticeConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeNoticeConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyCountRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
        uuid_list: str = None,
    ):
        self.type = type
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribePropertyCountResponseBody(TeaModel):
    def __init__(
        self,
        autorun: int = None,
        cron: int = None,
        database: int = None,
        lkm: int = None,
        port: int = None,
        process: int = None,
        request_id: str = None,
        sca: int = None,
        software: int = None,
        user: int = None,
        web: int = None,
        webserver: int = None,
    ):
        self.autorun = autorun
        self.cron = cron
        self.database = database
        self.lkm = lkm
        self.port = port
        self.process = process
        self.request_id = request_id
        self.sca = sca
        self.software = software
        self.user = user
        self.web = web
        self.webserver = webserver

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.autorun is not None:
            result['Autorun'] = self.autorun
        if self.cron is not None:
            result['Cron'] = self.cron
        if self.database is not None:
            result['Database'] = self.database
        if self.lkm is not None:
            result['Lkm'] = self.lkm
        if self.port is not None:
            result['Port'] = self.port
        if self.process is not None:
            result['Process'] = self.process
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sca is not None:
            result['Sca'] = self.sca
        if self.software is not None:
            result['Software'] = self.software
        if self.user is not None:
            result['User'] = self.user
        if self.web is not None:
            result['Web'] = self.web
        if self.webserver is not None:
            result['Webserver'] = self.webserver
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Autorun') is not None:
            self.autorun = m.get('Autorun')
        if m.get('Cron') is not None:
            self.cron = m.get('Cron')
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('Lkm') is not None:
            self.lkm = m.get('Lkm')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Process') is not None:
            self.process = m.get('Process')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Sca') is not None:
            self.sca = m.get('Sca')
        if m.get('Software') is not None:
            self.software = m.get('Software')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Web') is not None:
            self.web = m.get('Web')
        if m.get('Webserver') is not None:
            self.webserver = m.get('Webserver')
        return self


class DescribePropertyCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyCronDetailRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        extend: str = None,
        page_size: int = None,
        remark: str = None,
        source: str = None,
        user: str = None,
        uuid: str = None,
    ):
        self.current_page = current_page
        self.extend = extend
        self.page_size = page_size
        self.remark = remark
        self.source = source
        self.user = user
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.extend is not None:
            result['Extend'] = self.extend
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.source is not None:
            result['Source'] = self.source
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Extend') is not None:
            self.extend = m.get('Extend')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyCronDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyCronDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        cmd: str = None,
        create_timestamp: int = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        md_5: str = None,
        period: str = None,
        source: str = None,
        user: str = None,
        uuid: str = None,
    ):
        self.cmd = cmd
        self.create_timestamp = create_timestamp
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.ip = ip
        self.md_5 = md_5
        self.period = period
        self.source = source
        self.user = user
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cmd is not None:
            result['Cmd'] = self.cmd
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.period is not None:
            result['Period'] = self.period
        if self.source is not None:
            result['Source'] = self.source
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cmd') is not None:
            self.cmd = m.get('Cmd')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyCronDetailResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribePropertyCronDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertyCronDetailResponseBodyPropertys] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.propertys = propertys
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyCronDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyCronDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyCronDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyCronDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyCronDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyPortDetailRequest(TeaModel):
    def __init__(
        self,
        bind_ip: str = None,
        current_page: int = None,
        extend: str = None,
        page_size: int = None,
        port: str = None,
        proc_name: str = None,
        remark: str = None,
        uuid: str = None,
    ):
        self.bind_ip = bind_ip
        self.current_page = current_page
        self.extend = extend
        self.page_size = page_size
        self.port = port
        self.proc_name = proc_name
        self.remark = remark
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_ip is not None:
            result['BindIp'] = self.bind_ip
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.extend is not None:
            result['Extend'] = self.extend
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.port is not None:
            result['Port'] = self.port
        if self.proc_name is not None:
            result['ProcName'] = self.proc_name
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindIp') is not None:
            self.bind_ip = m.get('BindIp')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Extend') is not None:
            self.extend = m.get('Extend')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProcName') is not None:
            self.proc_name = m.get('ProcName')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyPortDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyPortDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        bind_ip: str = None,
        create_timestamp: int = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        pid: str = None,
        port: str = None,
        proc_name: str = None,
        proto: str = None,
        uuid: str = None,
    ):
        self.bind_ip = bind_ip
        self.create_timestamp = create_timestamp
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.ip = ip
        self.pid = pid
        self.port = port
        self.proc_name = proc_name
        self.proto = proto
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_ip is not None:
            result['BindIp'] = self.bind_ip
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.port is not None:
            result['Port'] = self.port
        if self.proc_name is not None:
            result['ProcName'] = self.proc_name
        if self.proto is not None:
            result['Proto'] = self.proto
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindIp') is not None:
            self.bind_ip = m.get('BindIp')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProcName') is not None:
            self.proc_name = m.get('ProcName')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyPortDetailResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribePropertyPortDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertyPortDetailResponseBodyPropertys] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.propertys = propertys
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyPortDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyPortDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyPortDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyPortDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyPortDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyPortItemRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        force_flush: bool = None,
        page_size: int = None,
        port: str = None,
    ):
        self.current_page = current_page
        self.force_flush = force_flush
        self.page_size = page_size
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class DescribePropertyPortItemResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyPortItemResponseBodyPropertyItems(TeaModel):
    def __init__(
        self,
        count: int = None,
        port: str = None,
        proto: str = None,
    ):
        self.count = count
        self.port = port
        self.proto = proto

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.port is not None:
            result['Port'] = self.port
        if self.proto is not None:
            result['Proto'] = self.proto
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Proto') is not None:
            self.proto = m.get('Proto')
        return self


class DescribePropertyPortItemResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribePropertyPortItemResponseBodyPageInfo = None,
        property_items: List[DescribePropertyPortItemResponseBodyPropertyItems] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.property_items = property_items
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyPortItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertyPortItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyPortItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyPortItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyPortItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyProcDetailRequest(TeaModel):
    def __init__(
        self,
        cmdline: str = None,
        current_page: int = None,
        extend: str = None,
        name: str = None,
        page_size: int = None,
        proc_time_end: int = None,
        proc_time_start: int = None,
        remark: str = None,
        user: str = None,
        uuid: str = None,
    ):
        self.cmdline = cmdline
        self.current_page = current_page
        self.extend = extend
        self.name = name
        self.page_size = page_size
        self.proc_time_end = proc_time_end
        self.proc_time_start = proc_time_start
        self.remark = remark
        self.user = user
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.extend is not None:
            result['Extend'] = self.extend
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.proc_time_end is not None:
            result['ProcTimeEnd'] = self.proc_time_end
        if self.proc_time_start is not None:
            result['ProcTimeStart'] = self.proc_time_start
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Extend') is not None:
            self.extend = m.get('Extend')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProcTimeEnd') is not None:
            self.proc_time_end = m.get('ProcTimeEnd')
        if m.get('ProcTimeStart') is not None:
            self.proc_time_start = m.get('ProcTimeStart')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyProcDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyProcDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        cmdline: str = None,
        create_timestamp: int = None,
        euid_name: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        is_package: int = None,
        md_5: str = None,
        name: str = None,
        path: str = None,
        pid: str = None,
        pname: str = None,
        start_time: str = None,
        start_time_dt: int = None,
        state: str = None,
        user: str = None,
        uuid: str = None,
    ):
        self.cmdline = cmdline
        self.create_timestamp = create_timestamp
        self.euid_name = euid_name
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.is_package = is_package
        self.md_5 = md_5
        self.name = name
        self.path = path
        self.pid = pid
        self.pname = pname
        self.start_time = start_time
        self.start_time_dt = start_time_dt
        self.state = state
        self.user = user
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.euid_name is not None:
            result['EuidName'] = self.euid_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.is_package is not None:
            result['IsPackage'] = self.is_package
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.pname is not None:
            result['Pname'] = self.pname
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.start_time_dt is not None:
            result['StartTimeDt'] = self.start_time_dt
        if self.state is not None:
            result['State'] = self.state
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('EuidName') is not None:
            self.euid_name = m.get('EuidName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('IsPackage') is not None:
            self.is_package = m.get('IsPackage')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('Pname') is not None:
            self.pname = m.get('Pname')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StartTimeDt') is not None:
            self.start_time_dt = m.get('StartTimeDt')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyProcDetailResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribePropertyProcDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertyProcDetailResponseBodyPropertys] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.propertys = propertys
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyProcDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyProcDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyProcDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyProcDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyProcDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyProcItemRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        force_flush: bool = None,
        name: str = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        self.force_flush = force_flush
        self.name = name
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertyProcItemResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyProcItemResponseBodyPropertyItems(TeaModel):
    def __init__(
        self,
        count: int = None,
        name: str = None,
    ):
        self.count = count
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribePropertyProcItemResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribePropertyProcItemResponseBodyPageInfo = None,
        property_items: List[DescribePropertyProcItemResponseBodyPropertyItems] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.property_items = property_items
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyProcItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertyProcItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyProcItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyProcItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyProcItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyScaDetailRequest(TeaModel):
    def __init__(
        self,
        biz: str = None,
        biz_type: str = None,
        current_page: int = None,
        lang: str = None,
        name: int = None,
        page_size: int = None,
        pid: str = None,
        port: str = None,
        process_started_end: int = None,
        process_started_start: int = None,
        remark: str = None,
        sca_name: str = None,
        sca_name_pattern: str = None,
        sca_version: str = None,
        search_info: str = None,
        search_info_sub: str = None,
        search_item: str = None,
        search_item_sub: str = None,
        user: str = None,
        uuid: str = None,
    ):
        self.biz = biz
        self.biz_type = biz_type
        self.current_page = current_page
        self.lang = lang
        self.name = name
        self.page_size = page_size
        self.pid = pid
        self.port = port
        self.process_started_end = process_started_end
        self.process_started_start = process_started_start
        self.remark = remark
        self.sca_name = sca_name
        self.sca_name_pattern = sca_name_pattern
        self.sca_version = sca_version
        self.search_info = search_info
        self.search_info_sub = search_info_sub
        self.search_item = search_item
        self.search_item_sub = search_item_sub
        self.user = user
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz is not None:
            result['Biz'] = self.biz
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.port is not None:
            result['Port'] = self.port
        if self.process_started_end is not None:
            result['ProcessStartedEnd'] = self.process_started_end
        if self.process_started_start is not None:
            result['ProcessStartedStart'] = self.process_started_start
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.sca_name is not None:
            result['ScaName'] = self.sca_name
        if self.sca_name_pattern is not None:
            result['ScaNamePattern'] = self.sca_name_pattern
        if self.sca_version is not None:
            result['ScaVersion'] = self.sca_version
        if self.search_info is not None:
            result['SearchInfo'] = self.search_info
        if self.search_info_sub is not None:
            result['SearchInfoSub'] = self.search_info_sub
        if self.search_item is not None:
            result['SearchItem'] = self.search_item
        if self.search_item_sub is not None:
            result['SearchItemSub'] = self.search_item_sub
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Biz') is not None:
            self.biz = m.get('Biz')
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('ProcessStartedEnd') is not None:
            self.process_started_end = m.get('ProcessStartedEnd')
        if m.get('ProcessStartedStart') is not None:
            self.process_started_start = m.get('ProcessStartedStart')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('ScaName') is not None:
            self.sca_name = m.get('ScaName')
        if m.get('ScaNamePattern') is not None:
            self.sca_name_pattern = m.get('ScaNamePattern')
        if m.get('ScaVersion') is not None:
            self.sca_version = m.get('ScaVersion')
        if m.get('SearchInfo') is not None:
            self.search_info = m.get('SearchInfo')
        if m.get('SearchInfoSub') is not None:
            self.search_info_sub = m.get('SearchInfoSub')
        if m.get('SearchItem') is not None:
            self.search_item = m.get('SearchItem')
        if m.get('SearchItemSub') is not None:
            self.search_item_sub = m.get('SearchItemSub')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyScaDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyScaDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        biz_type: str = None,
        biz_type_dispaly: str = None,
        cmdline: str = None,
        config_path: str = None,
        container_name: str = None,
        create_timestamp: int = None,
        image_name: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        listen_ip: str = None,
        listen_protocol: str = None,
        listen_status: str = None,
        name: str = None,
        path: str = None,
        pid: str = None,
        port: str = None,
        ppid: str = None,
        process_started: int = None,
        process_user: str = None,
        proof: str = None,
        runtime_env_version: str = None,
        type: str = None,
        uuid: str = None,
        version: str = None,
        web_path: str = None,
    ):
        self.biz_type = biz_type
        self.biz_type_dispaly = biz_type_dispaly
        self.cmdline = cmdline
        self.config_path = config_path
        self.container_name = container_name
        self.create_timestamp = create_timestamp
        self.image_name = image_name
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.ip = ip
        self.listen_ip = listen_ip
        self.listen_protocol = listen_protocol
        self.listen_status = listen_status
        self.name = name
        self.path = path
        self.pid = pid
        self.port = port
        self.ppid = ppid
        self.process_started = process_started
        self.process_user = process_user
        self.proof = proof
        self.runtime_env_version = runtime_env_version
        self.type = type
        self.uuid = uuid
        self.version = version
        self.web_path = web_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_type is not None:
            result['BizType'] = self.biz_type
        if self.biz_type_dispaly is not None:
            result['BizTypeDispaly'] = self.biz_type_dispaly
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.config_path is not None:
            result['ConfigPath'] = self.config_path
        if self.container_name is not None:
            result['ContainerName'] = self.container_name
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.listen_ip is not None:
            result['ListenIp'] = self.listen_ip
        if self.listen_protocol is not None:
            result['ListenProtocol'] = self.listen_protocol
        if self.listen_status is not None:
            result['ListenStatus'] = self.listen_status
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.port is not None:
            result['Port'] = self.port
        if self.ppid is not None:
            result['Ppid'] = self.ppid
        if self.process_started is not None:
            result['ProcessStarted'] = self.process_started
        if self.process_user is not None:
            result['ProcessUser'] = self.process_user
        if self.proof is not None:
            result['Proof'] = self.proof
        if self.runtime_env_version is not None:
            result['RuntimeEnvVersion'] = self.runtime_env_version
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.version is not None:
            result['Version'] = self.version
        if self.web_path is not None:
            result['WebPath'] = self.web_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BizType') is not None:
            self.biz_type = m.get('BizType')
        if m.get('BizTypeDispaly') is not None:
            self.biz_type_dispaly = m.get('BizTypeDispaly')
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('ConfigPath') is not None:
            self.config_path = m.get('ConfigPath')
        if m.get('ContainerName') is not None:
            self.container_name = m.get('ContainerName')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('ListenIp') is not None:
            self.listen_ip = m.get('ListenIp')
        if m.get('ListenProtocol') is not None:
            self.listen_protocol = m.get('ListenProtocol')
        if m.get('ListenStatus') is not None:
            self.listen_status = m.get('ListenStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Ppid') is not None:
            self.ppid = m.get('Ppid')
        if m.get('ProcessStarted') is not None:
            self.process_started = m.get('ProcessStarted')
        if m.get('ProcessUser') is not None:
            self.process_user = m.get('ProcessUser')
        if m.get('Proof') is not None:
            self.proof = m.get('Proof')
        if m.get('RuntimeEnvVersion') is not None:
            self.runtime_env_version = m.get('RuntimeEnvVersion')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('WebPath') is not None:
            self.web_path = m.get('WebPath')
        return self


class DescribePropertyScaDetailResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribePropertyScaDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertyScaDetailResponseBodyPropertys] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.propertys = propertys
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyScaDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyScaDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyScaDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyScaDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyScaDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertySoftwareDetailRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        extend: str = None,
        install_time_end: int = None,
        install_time_start: int = None,
        name: str = None,
        page_size: int = None,
        path: str = None,
        remark: str = None,
        software_version: str = None,
        uuid: str = None,
    ):
        self.current_page = current_page
        self.extend = extend
        self.install_time_end = install_time_end
        self.install_time_start = install_time_start
        self.name = name
        self.page_size = page_size
        self.path = path
        self.remark = remark
        self.software_version = software_version
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.extend is not None:
            result['Extend'] = self.extend
        if self.install_time_end is not None:
            result['InstallTimeEnd'] = self.install_time_end
        if self.install_time_start is not None:
            result['InstallTimeStart'] = self.install_time_start
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.path is not None:
            result['Path'] = self.path
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.software_version is not None:
            result['SoftwareVersion'] = self.software_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Extend') is not None:
            self.extend = m.get('Extend')
        if m.get('InstallTimeEnd') is not None:
            self.install_time_end = m.get('InstallTimeEnd')
        if m.get('InstallTimeStart') is not None:
            self.install_time_start = m.get('InstallTimeStart')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SoftwareVersion') is not None:
            self.software_version = m.get('SoftwareVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertySoftwareDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertySoftwareDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        create_timestamp: int = None,
        install_time: str = None,
        install_time_dt: int = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        name: str = None,
        path: str = None,
        uuid: str = None,
        version: str = None,
    ):
        self.create_timestamp = create_timestamp
        self.install_time = install_time
        self.install_time_dt = install_time_dt
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.ip = ip
        self.name = name
        self.path = path
        self.uuid = uuid
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.install_time is not None:
            result['InstallTime'] = self.install_time
        if self.install_time_dt is not None:
            result['InstallTimeDt'] = self.install_time_dt
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('InstallTime') is not None:
            self.install_time = m.get('InstallTime')
        if m.get('InstallTimeDt') is not None:
            self.install_time_dt = m.get('InstallTimeDt')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribePropertySoftwareDetailResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribePropertySoftwareDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertySoftwareDetailResponseBodyPropertys] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.propertys = propertys
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertySoftwareDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertySoftwareDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertySoftwareDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertySoftwareDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertySoftwareDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertySoftwareItemRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        force_flush: bool = None,
        name: str = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        self.force_flush = force_flush
        self.name = name
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePropertySoftwareItemResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertySoftwareItemResponseBodyPropertyItems(TeaModel):
    def __init__(
        self,
        count: int = None,
        name: str = None,
    ):
        self.count = count
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribePropertySoftwareItemResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribePropertySoftwareItemResponseBodyPageInfo = None,
        property_items: List[DescribePropertySoftwareItemResponseBodyPropertyItems] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.property_items = property_items
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertySoftwareItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertySoftwareItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertySoftwareItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertySoftwareItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertySoftwareItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyUsageNewestRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
    ):
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePropertyUsageNewestResponseBodyNewestStatisticItems(TeaModel):
    def __init__(
        self,
        create: int = None,
        name: str = None,
    ):
        self.create = create
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create is not None:
            result['Create'] = self.create
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Create') is not None:
            self.create = m.get('Create')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribePropertyUsageNewestResponseBody(TeaModel):
    def __init__(
        self,
        item_count: int = None,
        newest_statistic_items: List[DescribePropertyUsageNewestResponseBodyNewestStatisticItems] = None,
        request_id: str = None,
        type: str = None,
    ):
        self.item_count = item_count
        self.newest_statistic_items = newest_statistic_items
        self.request_id = request_id
        self.type = type

    def validate(self):
        if self.newest_statistic_items:
            for k in self.newest_statistic_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_count is not None:
            result['ItemCount'] = self.item_count
        result['NewestStatisticItems'] = []
        if self.newest_statistic_items is not None:
            for k in self.newest_statistic_items:
                result['NewestStatisticItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemCount') is not None:
            self.item_count = m.get('ItemCount')
        self.newest_statistic_items = []
        if m.get('NewestStatisticItems') is not None:
            for k in m.get('NewestStatisticItems'):
                temp_model = DescribePropertyUsageNewestResponseBodyNewestStatisticItems()
                self.newest_statistic_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePropertyUsageNewestResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyUsageNewestResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyUsageNewestResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyUserDetailRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        extend: str = None,
        is_root: str = None,
        last_login_time_end: int = None,
        last_login_time_start: int = None,
        page_size: int = None,
        remark: str = None,
        user: str = None,
        uuid: str = None,
    ):
        self.current_page = current_page
        self.extend = extend
        self.is_root = is_root
        self.last_login_time_end = last_login_time_end
        self.last_login_time_start = last_login_time_start
        self.page_size = page_size
        self.remark = remark
        self.user = user
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.extend is not None:
            result['Extend'] = self.extend
        if self.is_root is not None:
            result['IsRoot'] = self.is_root
        if self.last_login_time_end is not None:
            result['LastLoginTimeEnd'] = self.last_login_time_end
        if self.last_login_time_start is not None:
            result['LastLoginTimeStart'] = self.last_login_time_start
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Extend') is not None:
            self.extend = m.get('Extend')
        if m.get('IsRoot') is not None:
            self.is_root = m.get('IsRoot')
        if m.get('LastLoginTimeEnd') is not None:
            self.last_login_time_end = m.get('LastLoginTimeEnd')
        if m.get('LastLoginTimeStart') is not None:
            self.last_login_time_start = m.get('LastLoginTimeStart')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyUserDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyUserDetailResponseBodyPropertys(TeaModel):
    def __init__(
        self,
        accounts_expiration_date: str = None,
        create_timestamp: int = None,
        group_names: List[str] = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        is_could_login: int = None,
        is_passwd_expired: int = None,
        is_passwd_locked: int = None,
        is_root: str = None,
        is_sudoer: int = None,
        is_user_expired: int = None,
        last_login_ip: str = None,
        last_login_time: str = None,
        last_login_time_dt: int = None,
        last_login_timestamp: int = None,
        password_expiration_date: str = None,
        status: str = None,
        user: str = None,
        uuid: str = None,
    ):
        self.accounts_expiration_date = accounts_expiration_date
        self.create_timestamp = create_timestamp
        self.group_names = group_names
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.ip = ip
        self.is_could_login = is_could_login
        self.is_passwd_expired = is_passwd_expired
        self.is_passwd_locked = is_passwd_locked
        self.is_root = is_root
        self.is_sudoer = is_sudoer
        self.is_user_expired = is_user_expired
        self.last_login_ip = last_login_ip
        self.last_login_time = last_login_time
        self.last_login_time_dt = last_login_time_dt
        self.last_login_timestamp = last_login_timestamp
        self.password_expiration_date = password_expiration_date
        self.status = status
        self.user = user
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accounts_expiration_date is not None:
            result['AccountsExpirationDate'] = self.accounts_expiration_date
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.group_names is not None:
            result['GroupNames'] = self.group_names
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.is_could_login is not None:
            result['IsCouldLogin'] = self.is_could_login
        if self.is_passwd_expired is not None:
            result['IsPasswdExpired'] = self.is_passwd_expired
        if self.is_passwd_locked is not None:
            result['IsPasswdLocked'] = self.is_passwd_locked
        if self.is_root is not None:
            result['IsRoot'] = self.is_root
        if self.is_sudoer is not None:
            result['IsSudoer'] = self.is_sudoer
        if self.is_user_expired is not None:
            result['IsUserExpired'] = self.is_user_expired
        if self.last_login_ip is not None:
            result['LastLoginIp'] = self.last_login_ip
        if self.last_login_time is not None:
            result['LastLoginTime'] = self.last_login_time
        if self.last_login_time_dt is not None:
            result['LastLoginTimeDt'] = self.last_login_time_dt
        if self.last_login_timestamp is not None:
            result['LastLoginTimestamp'] = self.last_login_timestamp
        if self.password_expiration_date is not None:
            result['PasswordExpirationDate'] = self.password_expiration_date
        if self.status is not None:
            result['Status'] = self.status
        if self.user is not None:
            result['User'] = self.user
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountsExpirationDate') is not None:
            self.accounts_expiration_date = m.get('AccountsExpirationDate')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('GroupNames') is not None:
            self.group_names = m.get('GroupNames')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IsCouldLogin') is not None:
            self.is_could_login = m.get('IsCouldLogin')
        if m.get('IsPasswdExpired') is not None:
            self.is_passwd_expired = m.get('IsPasswdExpired')
        if m.get('IsPasswdLocked') is not None:
            self.is_passwd_locked = m.get('IsPasswdLocked')
        if m.get('IsRoot') is not None:
            self.is_root = m.get('IsRoot')
        if m.get('IsSudoer') is not None:
            self.is_sudoer = m.get('IsSudoer')
        if m.get('IsUserExpired') is not None:
            self.is_user_expired = m.get('IsUserExpired')
        if m.get('LastLoginIp') is not None:
            self.last_login_ip = m.get('LastLoginIp')
        if m.get('LastLoginTime') is not None:
            self.last_login_time = m.get('LastLoginTime')
        if m.get('LastLoginTimeDt') is not None:
            self.last_login_time_dt = m.get('LastLoginTimeDt')
        if m.get('LastLoginTimestamp') is not None:
            self.last_login_timestamp = m.get('LastLoginTimestamp')
        if m.get('PasswordExpirationDate') is not None:
            self.password_expiration_date = m.get('PasswordExpirationDate')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('User') is not None:
            self.user = m.get('User')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribePropertyUserDetailResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribePropertyUserDetailResponseBodyPageInfo = None,
        propertys: List[DescribePropertyUserDetailResponseBodyPropertys] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.propertys = propertys
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.propertys:
            for k in self.propertys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Propertys'] = []
        if self.propertys is not None:
            for k in self.propertys:
                result['Propertys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyUserDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.propertys = []
        if m.get('Propertys') is not None:
            for k in m.get('Propertys'):
                temp_model = DescribePropertyUserDetailResponseBodyPropertys()
                self.propertys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyUserDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyUserDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyUserDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePropertyUserItemRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        force_flush: bool = None,
        page_size: int = None,
        user: str = None,
    ):
        self.current_page = current_page
        self.force_flush = force_flush
        self.page_size = page_size
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.force_flush is not None:
            result['ForceFlush'] = self.force_flush
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ForceFlush') is not None:
            self.force_flush = m.get('ForceFlush')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribePropertyUserItemResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePropertyUserItemResponseBodyPropertyItems(TeaModel):
    def __init__(
        self,
        count: int = None,
        user: str = None,
    ):
        self.count = count
        self.user = user

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.user is not None:
            result['User'] = self.user
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('User') is not None:
            self.user = m.get('User')
        return self


class DescribePropertyUserItemResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribePropertyUserItemResponseBodyPageInfo = None,
        property_items: List[DescribePropertyUserItemResponseBodyPropertyItems] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.property_items = property_items
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.property_items:
            for k in self.property_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['PropertyItems'] = []
        if self.property_items is not None:
            for k in self.property_items:
                result['PropertyItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribePropertyUserItemResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.property_items = []
        if m.get('PropertyItems') is not None:
            for k in m.get('PropertyItems'):
                temp_model = DescribePropertyUserItemResponseBodyPropertyItems()
                self.property_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePropertyUserItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribePropertyUserItemResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribePropertyUserItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRestoreJobsRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        machine_remark: str = None,
        page_size: int = None,
        status: str = None,
    ):
        self.current_page = current_page
        self.machine_remark = machine_remark
        self.page_size = page_size
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.machine_remark is not None:
            result['MachineRemark'] = self.machine_remark
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('MachineRemark') is not None:
            self.machine_remark = m.get('MachineRemark')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeRestoreJobsResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRestoreJobsResponseBodyRestoreJobs(TeaModel):
    def __init__(
        self,
        actual_bytes: int = None,
        bytes_done: int = None,
        bytes_total: int = None,
        client_id: str = None,
        complete_time: int = None,
        created_time: int = None,
        duration: int = None,
        error_count: int = None,
        error_file: str = None,
        error_file_url: str = None,
        error_type: str = None,
        eta: int = None,
        excludes: str = None,
        exit_code: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        includes: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        items_done: int = None,
        items_total: int = None,
        message: str = None,
        percentage: int = None,
        request_id: str = None,
        restore_id: str = None,
        restore_name: str = None,
        restore_type: str = None,
        snapshot_hash: str = None,
        snapshot_id: str = None,
        snapshot_version: str = None,
        source: str = None,
        source_client_id: str = None,
        speed: int = None,
        status: str = None,
        target: str = None,
        updated_time: int = None,
        uuid: str = None,
        vault_id: str = None,
    ):
        self.actual_bytes = actual_bytes
        self.bytes_done = bytes_done
        self.bytes_total = bytes_total
        self.client_id = client_id
        self.complete_time = complete_time
        self.created_time = created_time
        self.duration = duration
        self.error_count = error_count
        self.error_file = error_file
        self.error_file_url = error_file_url
        self.error_type = error_type
        self.eta = eta
        self.excludes = excludes
        self.exit_code = exit_code
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.includes = includes
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.items_done = items_done
        self.items_total = items_total
        self.message = message
        self.percentage = percentage
        self.request_id = request_id
        self.restore_id = restore_id
        self.restore_name = restore_name
        self.restore_type = restore_type
        self.snapshot_hash = snapshot_hash
        self.snapshot_id = snapshot_id
        self.snapshot_version = snapshot_version
        self.source = source
        self.source_client_id = source_client_id
        self.speed = speed
        self.status = status
        self.target = target
        self.updated_time = updated_time
        self.uuid = uuid
        self.vault_id = vault_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.actual_bytes is not None:
            result['ActualBytes'] = self.actual_bytes
        if self.bytes_done is not None:
            result['BytesDone'] = self.bytes_done
        if self.bytes_total is not None:
            result['BytesTotal'] = self.bytes_total
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.complete_time is not None:
            result['CompleteTime'] = self.complete_time
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.error_count is not None:
            result['ErrorCount'] = self.error_count
        if self.error_file is not None:
            result['ErrorFile'] = self.error_file
        if self.error_file_url is not None:
            result['ErrorFileUrl'] = self.error_file_url
        if self.error_type is not None:
            result['ErrorType'] = self.error_type
        if self.eta is not None:
            result['Eta'] = self.eta
        if self.excludes is not None:
            result['Excludes'] = self.excludes
        if self.exit_code is not None:
            result['ExitCode'] = self.exit_code
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.includes is not None:
            result['Includes'] = self.includes
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.items_done is not None:
            result['ItemsDone'] = self.items_done
        if self.items_total is not None:
            result['ItemsTotal'] = self.items_total
        if self.message is not None:
            result['Message'] = self.message
        if self.percentage is not None:
            result['Percentage'] = self.percentage
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.restore_id is not None:
            result['RestoreId'] = self.restore_id
        if self.restore_name is not None:
            result['RestoreName'] = self.restore_name
        if self.restore_type is not None:
            result['RestoreType'] = self.restore_type
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.snapshot_version is not None:
            result['SnapshotVersion'] = self.snapshot_version
        if self.source is not None:
            result['Source'] = self.source
        if self.source_client_id is not None:
            result['SourceClientId'] = self.source_client_id
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.status is not None:
            result['Status'] = self.status
        if self.target is not None:
            result['Target'] = self.target
        if self.updated_time is not None:
            result['UpdatedTime'] = self.updated_time
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActualBytes') is not None:
            self.actual_bytes = m.get('ActualBytes')
        if m.get('BytesDone') is not None:
            self.bytes_done = m.get('BytesDone')
        if m.get('BytesTotal') is not None:
            self.bytes_total = m.get('BytesTotal')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('CompleteTime') is not None:
            self.complete_time = m.get('CompleteTime')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('ErrorCount') is not None:
            self.error_count = m.get('ErrorCount')
        if m.get('ErrorFile') is not None:
            self.error_file = m.get('ErrorFile')
        if m.get('ErrorFileUrl') is not None:
            self.error_file_url = m.get('ErrorFileUrl')
        if m.get('ErrorType') is not None:
            self.error_type = m.get('ErrorType')
        if m.get('Eta') is not None:
            self.eta = m.get('Eta')
        if m.get('Excludes') is not None:
            self.excludes = m.get('Excludes')
        if m.get('ExitCode') is not None:
            self.exit_code = m.get('ExitCode')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Includes') is not None:
            self.includes = m.get('Includes')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('ItemsDone') is not None:
            self.items_done = m.get('ItemsDone')
        if m.get('ItemsTotal') is not None:
            self.items_total = m.get('ItemsTotal')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Percentage') is not None:
            self.percentage = m.get('Percentage')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RestoreId') is not None:
            self.restore_id = m.get('RestoreId')
        if m.get('RestoreName') is not None:
            self.restore_name = m.get('RestoreName')
        if m.get('RestoreType') is not None:
            self.restore_type = m.get('RestoreType')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SnapshotVersion') is not None:
            self.snapshot_version = m.get('SnapshotVersion')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceClientId') is not None:
            self.source_client_id = m.get('SourceClientId')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('UpdatedTime') is not None:
            self.updated_time = m.get('UpdatedTime')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        return self


class DescribeRestoreJobsResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeRestoreJobsResponseBodyPageInfo = None,
        request_id: str = None,
        restore_jobs: List[DescribeRestoreJobsResponseBodyRestoreJobs] = None,
    ):
        self.page_info = page_info
        self.request_id = request_id
        self.restore_jobs = restore_jobs

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.restore_jobs:
            for k in self.restore_jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['RestoreJobs'] = []
        if self.restore_jobs is not None:
            for k in self.restore_jobs:
                result['RestoreJobs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeRestoreJobsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.restore_jobs = []
        if m.get('RestoreJobs') is not None:
            for k in m.get('RestoreJobs'):
                temp_model = DescribeRestoreJobsResponseBodyRestoreJobs()
                self.restore_jobs.append(temp_model.from_map(k))
        return self


class DescribeRestoreJobsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRestoreJobsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRestoreJobsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskCheckItemResultRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        item_id: int = None,
        lang: str = None,
        page_size: int = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        self.current_page = current_page
        self.item_id = item_id
        self.lang = lang
        self.page_size = page_size
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeRiskCheckItemResultResponseBodyPageContentResource(TeaModel):
    def __init__(
        self,
        content_resource: str = None,
        count: int = None,
        current_page: int = None,
        page_count: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.content_resource = content_resource
        self.count = count
        self.current_page = current_page
        self.page_count = page_count
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_resource is not None:
            result['ContentResource'] = self.content_resource
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContentResource') is not None:
            self.content_resource = m.get('ContentResource')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRiskCheckItemResultResponseBody(TeaModel):
    def __init__(
        self,
        page_content_resource: DescribeRiskCheckItemResultResponseBodyPageContentResource = None,
        request_id: str = None,
    ):
        self.page_content_resource = page_content_resource
        self.request_id = request_id

    def validate(self):
        if self.page_content_resource:
            self.page_content_resource.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_content_resource is not None:
            result['PageContentResource'] = self.page_content_resource.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageContentResource') is not None:
            temp_model = DescribeRiskCheckItemResultResponseBodyPageContentResource()
            self.page_content_resource = temp_model.from_map(m['PageContentResource'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRiskCheckItemResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRiskCheckItemResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskCheckItemResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskCheckResultRequest(TeaModel):
    def __init__(
        self,
        asset_type: str = None,
        current_page: int = None,
        group_id: int = None,
        item_ids: List[str] = None,
        lang: str = None,
        name: str = None,
        page_size: int = None,
        query_flag: str = None,
        resource_owner_id: int = None,
        risk_level: str = None,
        source_ip: str = None,
        status: str = None,
    ):
        self.asset_type = asset_type
        self.current_page = current_page
        self.group_id = group_id
        self.item_ids = item_ids
        self.lang = lang
        self.name = name
        self.page_size = page_size
        self.query_flag = query_flag
        self.resource_owner_id = resource_owner_id
        self.risk_level = risk_level
        self.source_ip = source_ip
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.item_ids is not None:
            result['ItemIds'] = self.item_ids
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query_flag is not None:
            result['QueryFlag'] = self.query_flag
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ItemIds') is not None:
            self.item_ids = m.get('ItemIds')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueryFlag') is not None:
            self.query_flag = m.get('QueryFlag')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeRiskCheckResultResponseBodyListRiskItemResources(TeaModel):
    def __init__(
        self,
        content_resource: Dict[str, str] = None,
        resource_name: str = None,
    ):
        self.content_resource = content_resource
        self.resource_name = resource_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content_resource is not None:
            result['ContentResource'] = self.content_resource
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContentResource') is not None:
            self.content_resource = m.get('ContentResource')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        return self


class DescribeRiskCheckResultResponseBodyList(TeaModel):
    def __init__(
        self,
        affected_count: int = None,
        check_time: int = None,
        item_id: int = None,
        remaining_time: int = None,
        repair_status: str = None,
        risk_assert_type: str = None,
        risk_item_resources: List[DescribeRiskCheckResultResponseBodyListRiskItemResources] = None,
        risk_level: str = None,
        sort: int = None,
        start_status: str = None,
        status: str = None,
        task_id: int = None,
        title: str = None,
        type: str = None,
    ):
        self.affected_count = affected_count
        self.check_time = check_time
        self.item_id = item_id
        self.remaining_time = remaining_time
        self.repair_status = repair_status
        self.risk_assert_type = risk_assert_type
        self.risk_item_resources = risk_item_resources
        self.risk_level = risk_level
        self.sort = sort
        self.start_status = start_status
        self.status = status
        self.task_id = task_id
        self.title = title
        self.type = type

    def validate(self):
        if self.risk_item_resources:
            for k in self.risk_item_resources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.affected_count is not None:
            result['AffectedCount'] = self.affected_count
        if self.check_time is not None:
            result['CheckTime'] = self.check_time
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.repair_status is not None:
            result['RepairStatus'] = self.repair_status
        if self.risk_assert_type is not None:
            result['RiskAssertType'] = self.risk_assert_type
        result['RiskItemResources'] = []
        if self.risk_item_resources is not None:
            for k in self.risk_item_resources:
                result['RiskItemResources'].append(k.to_map() if k else None)
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.start_status is not None:
            result['StartStatus'] = self.start_status
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.title is not None:
            result['Title'] = self.title
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AffectedCount') is not None:
            self.affected_count = m.get('AffectedCount')
        if m.get('CheckTime') is not None:
            self.check_time = m.get('CheckTime')
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('RepairStatus') is not None:
            self.repair_status = m.get('RepairStatus')
        if m.get('RiskAssertType') is not None:
            self.risk_assert_type = m.get('RiskAssertType')
        self.risk_item_resources = []
        if m.get('RiskItemResources') is not None:
            for k in m.get('RiskItemResources'):
                temp_model = DescribeRiskCheckResultResponseBodyListRiskItemResources()
                self.risk_item_resources.append(temp_model.from_map(k))
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('StartStatus') is not None:
            self.start_status = m.get('StartStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeRiskCheckResultResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        list: List[DescribeRiskCheckResultResponseBodyList] = None,
        page_count: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.list = list
        self.page_count = page_count
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_count is not None:
            result['PageCount'] = self.page_count
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeRiskCheckResultResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageCount') is not None:
            self.page_count = m.get('PageCount')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRiskCheckResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRiskCheckResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskCheckSummaryRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        resource_directory_account_id: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.resource_directory_account_id = resource_directory_account_id
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroupsCountByStatus(TeaModel):
    def __init__(
        self,
        count: int = None,
        status: str = None,
    ):
        self.count = count
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroups(TeaModel):
    def __init__(
        self,
        count_by_status: List[DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroupsCountByStatus] = None,
        id: int = None,
        remaining_time: int = None,
        sort: int = None,
        status: str = None,
        title: str = None,
    ):
        self.count_by_status = count_by_status
        self.id = id
        self.remaining_time = remaining_time
        self.sort = sort
        self.status = status
        self.title = title

    def validate(self):
        if self.count_by_status:
            for k in self.count_by_status:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CountByStatus'] = []
        if self.count_by_status is not None:
            for k in self.count_by_status:
                result['CountByStatus'].append(k.to_map() if k else None)
        if self.id is not None:
            result['Id'] = self.id
        if self.remaining_time is not None:
            result['RemainingTime'] = self.remaining_time
        if self.sort is not None:
            result['Sort'] = self.sort
        if self.status is not None:
            result['Status'] = self.status
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.count_by_status = []
        if m.get('CountByStatus') is not None:
            for k in m.get('CountByStatus'):
                temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroupsCountByStatus()
                self.count_by_status.append(temp_model.from_map(k))
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RemainingTime') is not None:
            self.remaining_time = m.get('RemainingTime')
        if m.get('Sort') is not None:
            self.sort = m.get('Sort')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryRiskLevelCount(TeaModel):
    def __init__(
        self,
        count: int = None,
        key: str = None,
    ):
        self.count = count
        self.key = key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.key is not None:
            result['Key'] = self.key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        return self


class DescribeRiskCheckSummaryResponseBodyRiskCheckSummary(TeaModel):
    def __init__(
        self,
        affected_asset_count: int = None,
        disabled_risk_count: int = None,
        enabled_risk_count: int = None,
        groups: List[DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroups] = None,
        item_count: int = None,
        previous_count: int = None,
        previous_time: int = None,
        risk_count: int = None,
        risk_level_count: List[DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryRiskLevelCount] = None,
        risk_rate: float = None,
    ):
        self.affected_asset_count = affected_asset_count
        self.disabled_risk_count = disabled_risk_count
        self.enabled_risk_count = enabled_risk_count
        self.groups = groups
        self.item_count = item_count
        self.previous_count = previous_count
        self.previous_time = previous_time
        self.risk_count = risk_count
        self.risk_level_count = risk_level_count
        self.risk_rate = risk_rate

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()
        if self.risk_level_count:
            for k in self.risk_level_count:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.affected_asset_count is not None:
            result['AffectedAssetCount'] = self.affected_asset_count
        if self.disabled_risk_count is not None:
            result['DisabledRiskCount'] = self.disabled_risk_count
        if self.enabled_risk_count is not None:
            result['EnabledRiskCount'] = self.enabled_risk_count
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.item_count is not None:
            result['ItemCount'] = self.item_count
        if self.previous_count is not None:
            result['PreviousCount'] = self.previous_count
        if self.previous_time is not None:
            result['PreviousTime'] = self.previous_time
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        result['RiskLevelCount'] = []
        if self.risk_level_count is not None:
            for k in self.risk_level_count:
                result['RiskLevelCount'].append(k.to_map() if k else None)
        if self.risk_rate is not None:
            result['RiskRate'] = self.risk_rate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AffectedAssetCount') is not None:
            self.affected_asset_count = m.get('AffectedAssetCount')
        if m.get('DisabledRiskCount') is not None:
            self.disabled_risk_count = m.get('DisabledRiskCount')
        if m.get('EnabledRiskCount') is not None:
            self.enabled_risk_count = m.get('EnabledRiskCount')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('ItemCount') is not None:
            self.item_count = m.get('ItemCount')
        if m.get('PreviousCount') is not None:
            self.previous_count = m.get('PreviousCount')
        if m.get('PreviousTime') is not None:
            self.previous_time = m.get('PreviousTime')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        self.risk_level_count = []
        if m.get('RiskLevelCount') is not None:
            for k in m.get('RiskLevelCount'):
                temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummaryRiskLevelCount()
                self.risk_level_count.append(temp_model.from_map(k))
        if m.get('RiskRate') is not None:
            self.risk_rate = m.get('RiskRate')
        return self


class DescribeRiskCheckSummaryResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        risk_check_summary: DescribeRiskCheckSummaryResponseBodyRiskCheckSummary = None,
    ):
        self.request_id = request_id
        self.risk_check_summary = risk_check_summary

    def validate(self):
        if self.risk_check_summary:
            self.risk_check_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.risk_check_summary is not None:
            result['RiskCheckSummary'] = self.risk_check_summary.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RiskCheckSummary') is not None:
            temp_model = DescribeRiskCheckSummaryResponseBodyRiskCheckSummary()
            self.risk_check_summary = temp_model.from_map(m['RiskCheckSummary'])
        return self


class DescribeRiskCheckSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRiskCheckSummaryResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskCheckSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskItemTypeRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeRiskItemTypeResponseBodyList(TeaModel):
    def __init__(
        self,
        id: int = None,
        title: str = None,
    ):
        self.id = id
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class DescribeRiskItemTypeResponseBody(TeaModel):
    def __init__(
        self,
        list: List[DescribeRiskItemTypeResponseBodyList] = None,
        request_id: str = None,
    ):
        self.list = list
        self.request_id = request_id

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeRiskItemTypeResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRiskItemTypeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRiskItemTypeResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskItemTypeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRiskListCheckResultRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        instance_ids: List[str] = None,
        lang: str = None,
        page_size: int = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        self.current_page = current_page
        self.instance_ids = instance_ids
        self.lang = lang
        self.page_size = page_size
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeRiskListCheckResultResponseBodyList(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        risk_count: int = None,
    ):
        self.instance_id = instance_id
        self.risk_count = risk_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.risk_count is not None:
            result['riskCount'] = self.risk_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('riskCount') is not None:
            self.risk_count = m.get('riskCount')
        return self


class DescribeRiskListCheckResultResponseBody(TeaModel):
    def __init__(
        self,
        list: List[DescribeRiskListCheckResultResponseBodyList] = None,
        request_id: str = None,
    ):
        self.list = list
        self.request_id = request_id

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = DescribeRiskListCheckResultResponseBodyList()
                self.list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRiskListCheckResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeRiskListCheckResultResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeRiskListCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeScanTaskProgressRequest(TeaModel):
    def __init__(
        self,
        task_id: int = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeScanTaskProgressResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scan_task_progress: str = None,
        target_info: str = None,
    ):
        self.request_id = request_id
        self.scan_task_progress = scan_task_progress
        self.target_info = target_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scan_task_progress is not None:
            result['ScanTaskProgress'] = self.scan_task_progress
        if self.target_info is not None:
            result['TargetInfo'] = self.target_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScanTaskProgress') is not None:
            self.scan_task_progress = m.get('ScanTaskProgress')
        if m.get('TargetInfo') is not None:
            self.target_info = m.get('TargetInfo')
        return self


class DescribeScanTaskProgressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeScanTaskProgressResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeScanTaskProgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSearchConditionRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
        type: str = None,
    ):
        self.lang = lang
        self.source_ip = source_ip
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeSearchConditionResponseBodyConditionList(TeaModel):
    def __init__(
        self,
        condition_type: str = None,
        filter_conditions: str = None,
        name: str = None,
        name_key: str = None,
    ):
        self.condition_type = condition_type
        self.filter_conditions = filter_conditions
        self.name = name
        self.name_key = name_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition_type is not None:
            result['ConditionType'] = self.condition_type
        if self.filter_conditions is not None:
            result['FilterConditions'] = self.filter_conditions
        if self.name is not None:
            result['Name'] = self.name
        if self.name_key is not None:
            result['NameKey'] = self.name_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConditionType') is not None:
            self.condition_type = m.get('ConditionType')
        if m.get('FilterConditions') is not None:
            self.filter_conditions = m.get('FilterConditions')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NameKey') is not None:
            self.name_key = m.get('NameKey')
        return self


class DescribeSearchConditionResponseBody(TeaModel):
    def __init__(
        self,
        condition_list: List[DescribeSearchConditionResponseBodyConditionList] = None,
        request_id: str = None,
    ):
        self.condition_list = condition_list
        self.request_id = request_id

    def validate(self):
        if self.condition_list:
            for k in self.condition_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConditionList'] = []
        if self.condition_list is not None:
            for k in self.condition_list:
                result['ConditionList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.condition_list = []
        if m.get('ConditionList') is not None:
            for k in m.get('ConditionList'):
                temp_model = DescribeSearchConditionResponseBodyConditionList()
                self.condition_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeSearchConditionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSearchConditionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSearchConditionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecureSuggestionRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSecureSuggestionResponseBodySuggestionsDetail(TeaModel):
    def __init__(
        self,
        description: str = None,
        sub_type: str = None,
        title: str = None,
    ):
        self.description = description
        self.sub_type = sub_type
        self.title = title

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.sub_type is not None:
            result['SubType'] = self.sub_type
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('SubType') is not None:
            self.sub_type = m.get('SubType')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class DescribeSecureSuggestionResponseBodySuggestions(TeaModel):
    def __init__(
        self,
        detail: List[DescribeSecureSuggestionResponseBodySuggestionsDetail] = None,
        points: int = None,
        suggest_type: str = None,
    ):
        self.detail = detail
        self.points = points
        self.suggest_type = suggest_type

    def validate(self):
        if self.detail:
            for k in self.detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Detail'] = []
        if self.detail is not None:
            for k in self.detail:
                result['Detail'].append(k.to_map() if k else None)
        if self.points is not None:
            result['Points'] = self.points
        if self.suggest_type is not None:
            result['SuggestType'] = self.suggest_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.detail = []
        if m.get('Detail') is not None:
            for k in m.get('Detail'):
                temp_model = DescribeSecureSuggestionResponseBodySuggestionsDetail()
                self.detail.append(temp_model.from_map(k))
        if m.get('Points') is not None:
            self.points = m.get('Points')
        if m.get('SuggestType') is not None:
            self.suggest_type = m.get('SuggestType')
        return self


class DescribeSecureSuggestionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        suggestions: List[DescribeSecureSuggestionResponseBodySuggestions] = None,
        total_count: int = None,
    ):
        self.request_id = request_id
        self.suggestions = suggestions
        self.total_count = total_count

    def validate(self):
        if self.suggestions:
            for k in self.suggestions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Suggestions'] = []
        if self.suggestions is not None:
            for k in self.suggestions:
                result['Suggestions'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.suggestions = []
        if m.get('Suggestions') is not None:
            for k in m.get('Suggestions'):
                temp_model = DescribeSecureSuggestionResponseBodySuggestions()
                self.suggestions.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSecureSuggestionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecureSuggestionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecureSuggestionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityCheckScheduleConfigRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSecurityCheckScheduleConfigResponseBodyRiskCheckJobConfig(TeaModel):
    def __init__(
        self,
        days_of_week: str = None,
        end_time: int = None,
        start_time: int = None,
    ):
        self.days_of_week = days_of_week
        self.end_time = end_time
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.days_of_week is not None:
            result['DaysOfWeek'] = self.days_of_week
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DaysOfWeek') is not None:
            self.days_of_week = m.get('DaysOfWeek')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeSecurityCheckScheduleConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        risk_check_job_config: DescribeSecurityCheckScheduleConfigResponseBodyRiskCheckJobConfig = None,
    ):
        self.request_id = request_id
        self.risk_check_job_config = risk_check_job_config

    def validate(self):
        if self.risk_check_job_config:
            self.risk_check_job_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.risk_check_job_config is not None:
            result['RiskCheckJobConfig'] = self.risk_check_job_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RiskCheckJobConfig') is not None:
            temp_model = DescribeSecurityCheckScheduleConfigResponseBodyRiskCheckJobConfig()
            self.risk_check_job_config = temp_model.from_map(m['RiskCheckJobConfig'])
        return self


class DescribeSecurityCheckScheduleConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecurityCheckScheduleConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityCheckScheduleConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityEventOperationStatusRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        security_event_ids: List[str] = None,
        source_ip: str = None,
        task_id: int = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.security_event_ids = security_event_ids
        self.source_ip = source_ip
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponseSecurityEventOperationStatuses(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        security_event_id: str = None,
        status: str = None,
    ):
        self.error_code = error_code
        self.security_event_id = security_event_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponse(TeaModel):
    def __init__(
        self,
        security_event_operation_statuses: List[DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponseSecurityEventOperationStatuses] = None,
        task_status: str = None,
    ):
        self.security_event_operation_statuses = security_event_operation_statuses
        self.task_status = task_status

    def validate(self):
        if self.security_event_operation_statuses:
            for k in self.security_event_operation_statuses:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SecurityEventOperationStatuses'] = []
        if self.security_event_operation_statuses is not None:
            for k in self.security_event_operation_statuses:
                result['SecurityEventOperationStatuses'].append(k.to_map() if k else None)
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.security_event_operation_statuses = []
        if m.get('SecurityEventOperationStatuses') is not None:
            for k in m.get('SecurityEventOperationStatuses'):
                temp_model = DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponseSecurityEventOperationStatuses()
                self.security_event_operation_statuses.append(temp_model.from_map(k))
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class DescribeSecurityEventOperationStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_event_operation_status_response: DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponse = None,
    ):
        self.request_id = request_id
        self.security_event_operation_status_response = security_event_operation_status_response

    def validate(self):
        if self.security_event_operation_status_response:
            self.security_event_operation_status_response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_event_operation_status_response is not None:
            result['SecurityEventOperationStatusResponse'] = self.security_event_operation_status_response.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityEventOperationStatusResponse') is not None:
            temp_model = DescribeSecurityEventOperationStatusResponseBodySecurityEventOperationStatusResponse()
            self.security_event_operation_status_response = temp_model.from_map(m['SecurityEventOperationStatusResponse'])
        return self


class DescribeSecurityEventOperationStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecurityEventOperationStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityEventOperationStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityEventOperationsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        resource_owner_id: int = None,
        security_event_id: int = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.resource_owner_id = resource_owner_id
        self.security_event_id = security_event_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField(TeaModel):
    def __init__(
        self,
        filed_alias_name: str = None,
        filed_name: str = None,
        mark_mis_type: str = None,
        mark_mis_value: str = None,
        supported_mis_type: List[str] = None,
        uuid: str = None,
    ):
        self.filed_alias_name = filed_alias_name
        self.filed_name = filed_name
        self.mark_mis_type = mark_mis_type
        self.mark_mis_value = mark_mis_value
        self.supported_mis_type = supported_mis_type
        # 资产uuid
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.mark_mis_type is not None:
            result['MarkMisType'] = self.mark_mis_type
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('MarkMisType') is not None:
            self.mark_mis_type = m.get('MarkMisType')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource(TeaModel):
    def __init__(
        self,
        filed_alias_name: str = None,
        filed_name: str = None,
        mark_mis_value: str = None,
        supported_mis_type: List[str] = None,
    ):
        self.filed_alias_name = filed_alias_name
        self.filed_name = filed_name
        self.mark_mis_value = mark_mis_value
        self.supported_mis_type = supported_mis_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        return self


class DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponse(TeaModel):
    def __init__(
        self,
        mark_field: List[DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField] = None,
        mark_fields_source: List[DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource] = None,
        operation_code: str = None,
        operation_params: str = None,
        user_can_operate: bool = None,
    ):
        self.mark_field = mark_field
        self.mark_fields_source = mark_fields_source
        self.operation_code = operation_code
        self.operation_params = operation_params
        self.user_can_operate = user_can_operate

    def validate(self):
        if self.mark_field:
            for k in self.mark_field:
                if k:
                    k.validate()
        if self.mark_fields_source:
            for k in self.mark_fields_source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MarkField'] = []
        if self.mark_field is not None:
            for k in self.mark_field:
                result['MarkField'].append(k.to_map() if k else None)
        result['MarkFieldsSource'] = []
        if self.mark_fields_source is not None:
            for k in self.mark_fields_source:
                result['MarkFieldsSource'].append(k.to_map() if k else None)
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_params is not None:
            result['OperationParams'] = self.operation_params
        if self.user_can_operate is not None:
            result['UserCanOperate'] = self.user_can_operate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.mark_field = []
        if m.get('MarkField') is not None:
            for k in m.get('MarkField'):
                temp_model = DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField()
                self.mark_field.append(temp_model.from_map(k))
        self.mark_fields_source = []
        if m.get('MarkFieldsSource') is not None:
            for k in m.get('MarkFieldsSource'):
                temp_model = DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource()
                self.mark_fields_source.append(temp_model.from_map(k))
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationParams') is not None:
            self.operation_params = m.get('OperationParams')
        if m.get('UserCanOperate') is not None:
            self.user_can_operate = m.get('UserCanOperate')
        return self


class DescribeSecurityEventOperationsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_event_operations_response: List[DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponse] = None,
    ):
        self.request_id = request_id
        self.security_event_operations_response = security_event_operations_response

    def validate(self):
        if self.security_event_operations_response:
            for k in self.security_event_operations_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SecurityEventOperationsResponse'] = []
        if self.security_event_operations_response is not None:
            for k in self.security_event_operations_response:
                result['SecurityEventOperationsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.security_event_operations_response = []
        if m.get('SecurityEventOperationsResponse') is not None:
            for k in m.get('SecurityEventOperationsResponse'):
                temp_model = DescribeSecurityEventOperationsResponseBodySecurityEventOperationsResponse()
                self.security_event_operations_response.append(temp_model.from_map(k))
        return self


class DescribeSecurityEventOperationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecurityEventOperationsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityEventOperationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSecurityStatInfoRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        resource_directory_account_id: str = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.resource_directory_account_id = resource_directory_account_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSecurityStatInfoResponseBodyAttackEvent(TeaModel):
    def __init__(
        self,
        date_array: List[str] = None,
        total_count: int = None,
        value_array: List[str] = None,
    ):
        self.date_array = date_array
        self.total_count = total_count
        self.value_array = value_array

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        return self


class DescribeSecurityStatInfoResponseBodyHealthCheck(TeaModel):
    def __init__(
        self,
        date_array: List[str] = None,
        high_count: int = None,
        high_list: List[str] = None,
        levels_on: List[str] = None,
        low_count: int = None,
        low_list: List[str] = None,
        medium_count: int = None,
        medium_list: List[str] = None,
        time_array: List[str] = None,
        total_count: int = None,
        value_array: List[str] = None,
    ):
        self.date_array = date_array
        self.high_count = high_count
        self.high_list = high_list
        self.levels_on = levels_on
        self.low_count = low_count
        self.low_list = low_list
        self.medium_count = medium_count
        self.medium_list = medium_list
        self.time_array = time_array
        self.total_count = total_count
        self.value_array = value_array

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        if self.high_count is not None:
            result['HighCount'] = self.high_count
        if self.high_list is not None:
            result['HighList'] = self.high_list
        if self.levels_on is not None:
            result['LevelsOn'] = self.levels_on
        if self.low_count is not None:
            result['LowCount'] = self.low_count
        if self.low_list is not None:
            result['LowList'] = self.low_list
        if self.medium_count is not None:
            result['MediumCount'] = self.medium_count
        if self.medium_list is not None:
            result['MediumList'] = self.medium_list
        if self.time_array is not None:
            result['TimeArray'] = self.time_array
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        if m.get('HighCount') is not None:
            self.high_count = m.get('HighCount')
        if m.get('HighList') is not None:
            self.high_list = m.get('HighList')
        if m.get('LevelsOn') is not None:
            self.levels_on = m.get('LevelsOn')
        if m.get('LowCount') is not None:
            self.low_count = m.get('LowCount')
        if m.get('LowList') is not None:
            self.low_list = m.get('LowList')
        if m.get('MediumCount') is not None:
            self.medium_count = m.get('MediumCount')
        if m.get('MediumList') is not None:
            self.medium_list = m.get('MediumList')
        if m.get('TimeArray') is not None:
            self.time_array = m.get('TimeArray')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        return self


class DescribeSecurityStatInfoResponseBodySecurityEvent(TeaModel):
    def __init__(
        self,
        date_array: List[str] = None,
        levels_on: List[str] = None,
        remind_count: int = None,
        remind_list: List[str] = None,
        serious_count: int = None,
        serious_list: List[str] = None,
        suspicious_count: int = None,
        suspicious_list: List[str] = None,
        time_array: List[str] = None,
        total_count: int = None,
        value_array: List[str] = None,
    ):
        self.date_array = date_array
        self.levels_on = levels_on
        self.remind_count = remind_count
        self.remind_list = remind_list
        self.serious_count = serious_count
        self.serious_list = serious_list
        self.suspicious_count = suspicious_count
        self.suspicious_list = suspicious_list
        self.time_array = time_array
        self.total_count = total_count
        self.value_array = value_array

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        if self.levels_on is not None:
            result['LevelsOn'] = self.levels_on
        if self.remind_count is not None:
            result['RemindCount'] = self.remind_count
        if self.remind_list is not None:
            result['RemindList'] = self.remind_list
        if self.serious_count is not None:
            result['SeriousCount'] = self.serious_count
        if self.serious_list is not None:
            result['SeriousList'] = self.serious_list
        if self.suspicious_count is not None:
            result['SuspiciousCount'] = self.suspicious_count
        if self.suspicious_list is not None:
            result['SuspiciousList'] = self.suspicious_list
        if self.time_array is not None:
            result['TimeArray'] = self.time_array
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        if m.get('LevelsOn') is not None:
            self.levels_on = m.get('LevelsOn')
        if m.get('RemindCount') is not None:
            self.remind_count = m.get('RemindCount')
        if m.get('RemindList') is not None:
            self.remind_list = m.get('RemindList')
        if m.get('SeriousCount') is not None:
            self.serious_count = m.get('SeriousCount')
        if m.get('SeriousList') is not None:
            self.serious_list = m.get('SeriousList')
        if m.get('SuspiciousCount') is not None:
            self.suspicious_count = m.get('SuspiciousCount')
        if m.get('SuspiciousList') is not None:
            self.suspicious_list = m.get('SuspiciousList')
        if m.get('TimeArray') is not None:
            self.time_array = m.get('TimeArray')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        return self


class DescribeSecurityStatInfoResponseBodyVulnerability(TeaModel):
    def __init__(
        self,
        asap_count: int = None,
        asap_list: List[str] = None,
        date_array: List[str] = None,
        later_count: int = None,
        later_list: List[str] = None,
        levels_on: List[str] = None,
        nntf_count: int = None,
        nntf_list: List[str] = None,
        time_array: List[str] = None,
        total_count: int = None,
        value_array: List[str] = None,
    ):
        self.asap_count = asap_count
        self.asap_list = asap_list
        self.date_array = date_array
        self.later_count = later_count
        self.later_list = later_list
        self.levels_on = levels_on
        self.nntf_count = nntf_count
        self.nntf_list = nntf_list
        self.time_array = time_array
        self.total_count = total_count
        self.value_array = value_array

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.asap_list is not None:
            result['AsapList'] = self.asap_list
        if self.date_array is not None:
            result['DateArray'] = self.date_array
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.later_list is not None:
            result['LaterList'] = self.later_list
        if self.levels_on is not None:
            result['LevelsOn'] = self.levels_on
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.nntf_list is not None:
            result['NntfList'] = self.nntf_list
        if self.time_array is not None:
            result['TimeArray'] = self.time_array
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.value_array is not None:
            result['ValueArray'] = self.value_array
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('AsapList') is not None:
            self.asap_list = m.get('AsapList')
        if m.get('DateArray') is not None:
            self.date_array = m.get('DateArray')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('LaterList') is not None:
            self.later_list = m.get('LaterList')
        if m.get('LevelsOn') is not None:
            self.levels_on = m.get('LevelsOn')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('NntfList') is not None:
            self.nntf_list = m.get('NntfList')
        if m.get('TimeArray') is not None:
            self.time_array = m.get('TimeArray')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('ValueArray') is not None:
            self.value_array = m.get('ValueArray')
        return self


class DescribeSecurityStatInfoResponseBody(TeaModel):
    def __init__(
        self,
        attack_event: DescribeSecurityStatInfoResponseBodyAttackEvent = None,
        health_check: DescribeSecurityStatInfoResponseBodyHealthCheck = None,
        request_id: str = None,
        security_event: DescribeSecurityStatInfoResponseBodySecurityEvent = None,
        success: bool = None,
        vulnerability: DescribeSecurityStatInfoResponseBodyVulnerability = None,
    ):
        self.attack_event = attack_event
        self.health_check = health_check
        self.request_id = request_id
        self.security_event = security_event
        self.success = success
        self.vulnerability = vulnerability

    def validate(self):
        if self.attack_event:
            self.attack_event.validate()
        if self.health_check:
            self.health_check.validate()
        if self.security_event:
            self.security_event.validate()
        if self.vulnerability:
            self.vulnerability.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attack_event is not None:
            result['AttackEvent'] = self.attack_event.to_map()
        if self.health_check is not None:
            result['HealthCheck'] = self.health_check.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_event is not None:
            result['SecurityEvent'] = self.security_event.to_map()
        if self.success is not None:
            result['Success'] = self.success
        if self.vulnerability is not None:
            result['Vulnerability'] = self.vulnerability.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttackEvent') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodyAttackEvent()
            self.attack_event = temp_model.from_map(m['AttackEvent'])
        if m.get('HealthCheck') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodyHealthCheck()
            self.health_check = temp_model.from_map(m['HealthCheck'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityEvent') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodySecurityEvent()
            self.security_event = temp_model.from_map(m['SecurityEvent'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Vulnerability') is not None:
            temp_model = DescribeSecurityStatInfoResponseBodyVulnerability()
            self.vulnerability = temp_model.from_map(m['Vulnerability'])
        return self


class DescribeSecurityStatInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSecurityStatInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSecurityStatInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeServiceLinkedRoleStatusResponseBodyRoleStatus(TeaModel):
    def __init__(
        self,
        status: bool = None,
    ):
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeServiceLinkedRoleStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        role_status: DescribeServiceLinkedRoleStatusResponseBodyRoleStatus = None,
    ):
        self.request_id = request_id
        self.role_status = role_status

    def validate(self):
        if self.role_status:
            self.role_status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.role_status is not None:
            result['RoleStatus'] = self.role_status.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RoleStatus') is not None:
            temp_model = DescribeServiceLinkedRoleStatusResponseBodyRoleStatus()
            self.role_status = temp_model.from_map(m['RoleStatus'])
        return self


class DescribeServiceLinkedRoleStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeServiceLinkedRoleStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeServiceLinkedRoleStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSimilarEventScenariosRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        security_event_id: int = None,
        source_ip: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        self.security_event_id = security_event_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSimilarEventScenariosResponseBodyScenarios(TeaModel):
    def __init__(
        self,
        code: str = None,
    ):
        self.code = code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        return self


class DescribeSimilarEventScenariosResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scenarios: List[DescribeSimilarEventScenariosResponseBodyScenarios] = None,
    ):
        self.request_id = request_id
        self.scenarios = scenarios

    def validate(self):
        if self.scenarios:
            for k in self.scenarios:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Scenarios'] = []
        if self.scenarios is not None:
            for k in self.scenarios:
                result['Scenarios'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.scenarios = []
        if m.get('Scenarios') is not None:
            for k in m.get('Scenarios'):
                temp_model = DescribeSimilarEventScenariosResponseBodyScenarios()
                self.scenarios.append(temp_model.from_map(k))
        return self


class DescribeSimilarEventScenariosResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSimilarEventScenariosResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSimilarEventScenariosResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSimilarSecurityEventsRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        lang: str = None,
        page_size: int = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        task_id: int = None,
    ):
        self.current_page = current_page
        self.lang = lang
        self.page_size = page_size
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeSimilarSecurityEventsResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSimilarSecurityEventsResponseBodySecurityEventsResponse(TeaModel):
    def __init__(
        self,
        event_name: str = None,
        event_type: str = None,
        last_time: int = None,
        occurrence_time: int = None,
        security_event_id: int = None,
        uuid: str = None,
    ):
        self.event_name = event_name
        self.event_type = event_type
        self.last_time = last_time
        self.occurrence_time = occurrence_time
        self.security_event_id = security_event_id
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.occurrence_time is not None:
            result['OccurrenceTime'] = self.occurrence_time
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('OccurrenceTime') is not None:
            self.occurrence_time = m.get('OccurrenceTime')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeSimilarSecurityEventsResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeSimilarSecurityEventsResponseBodyPageInfo = None,
        request_id: str = None,
        security_events_response: List[DescribeSimilarSecurityEventsResponseBodySecurityEventsResponse] = None,
    ):
        self.page_info = page_info
        self.request_id = request_id
        self.security_events_response = security_events_response

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.security_events_response:
            for k in self.security_events_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SecurityEventsResponse'] = []
        if self.security_events_response is not None:
            for k in self.security_events_response:
                result['SecurityEventsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeSimilarSecurityEventsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.security_events_response = []
        if m.get('SecurityEventsResponse') is not None:
            for k in m.get('SecurityEventsResponse'):
                temp_model = DescribeSimilarSecurityEventsResponseBodySecurityEventsResponse()
                self.security_events_response.append(temp_model.from_map(k))
        return self


class DescribeSimilarSecurityEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSimilarSecurityEventsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSimilarSecurityEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStrategyRequest(TeaModel):
    def __init__(
        self,
        custom_type: str = None,
        lang: str = None,
        source_ip: str = None,
        strategy_ids: str = None,
    ):
        self.custom_type = custom_type
        self.lang = lang
        self.source_ip = source_ip
        self.strategy_ids = strategy_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.custom_type is not None:
            result['CustomType'] = self.custom_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.strategy_ids is not None:
            result['StrategyIds'] = self.strategy_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CustomType') is not None:
            self.custom_type = m.get('CustomType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StrategyIds') is not None:
            self.strategy_ids = m.get('StrategyIds')
        return self


class DescribeStrategyResponseBodyStrategiesConfigTargets(TeaModel):
    def __init__(
        self,
        flag: str = None,
        target: str = None,
        target_type: str = None,
    ):
        self.flag = flag
        self.target = target
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeStrategyResponseBodyStrategies(TeaModel):
    def __init__(
        self,
        config_targets: List[DescribeStrategyResponseBodyStrategiesConfigTargets] = None,
        custom_type: str = None,
        cycle_days: int = None,
        cycle_start_time: int = None,
        ecs_count: int = None,
        exec_status: int = None,
        id: int = None,
        name: str = None,
        pass_rate: int = None,
        process_rate: int = None,
        risk_count: int = None,
        type: int = None,
    ):
        self.config_targets = config_targets
        self.custom_type = custom_type
        self.cycle_days = cycle_days
        self.cycle_start_time = cycle_start_time
        self.ecs_count = ecs_count
        self.exec_status = exec_status
        self.id = id
        self.name = name
        self.pass_rate = pass_rate
        self.process_rate = process_rate
        self.risk_count = risk_count
        self.type = type

    def validate(self):
        if self.config_targets:
            for k in self.config_targets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigTargets'] = []
        if self.config_targets is not None:
            for k in self.config_targets:
                result['ConfigTargets'].append(k.to_map() if k else None)
        if self.custom_type is not None:
            result['CustomType'] = self.custom_type
        if self.cycle_days is not None:
            result['CycleDays'] = self.cycle_days
        if self.cycle_start_time is not None:
            result['CycleStartTime'] = self.cycle_start_time
        if self.ecs_count is not None:
            result['EcsCount'] = self.ecs_count
        if self.exec_status is not None:
            result['ExecStatus'] = self.exec_status
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.pass_rate is not None:
            result['PassRate'] = self.pass_rate
        if self.process_rate is not None:
            result['ProcessRate'] = self.process_rate
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_targets = []
        if m.get('ConfigTargets') is not None:
            for k in m.get('ConfigTargets'):
                temp_model = DescribeStrategyResponseBodyStrategiesConfigTargets()
                self.config_targets.append(temp_model.from_map(k))
        if m.get('CustomType') is not None:
            self.custom_type = m.get('CustomType')
        if m.get('CycleDays') is not None:
            self.cycle_days = m.get('CycleDays')
        if m.get('CycleStartTime') is not None:
            self.cycle_start_time = m.get('CycleStartTime')
        if m.get('EcsCount') is not None:
            self.ecs_count = m.get('EcsCount')
        if m.get('ExecStatus') is not None:
            self.exec_status = m.get('ExecStatus')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PassRate') is not None:
            self.pass_rate = m.get('PassRate')
        if m.get('ProcessRate') is not None:
            self.process_rate = m.get('ProcessRate')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        strategies: List[DescribeStrategyResponseBodyStrategies] = None,
    ):
        self.request_id = request_id
        self.strategies = strategies

    def validate(self):
        if self.strategies:
            for k in self.strategies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Strategies'] = []
        if self.strategies is not None:
            for k in self.strategies:
                result['Strategies'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.strategies = []
        if m.get('Strategies') is not None:
            for k in m.get('Strategies'):
                temp_model = DescribeStrategyResponseBodyStrategies()
                self.strategies.append(temp_model.from_map(k))
        return self


class DescribeStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeStrategyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStrategyExecDetailRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        source_ip: str = None,
        strategy_id: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.source_ip = source_ip
        self.strategy_id = strategy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        return self


class DescribeStrategyExecDetailResponseBodyFailedEcsList(TeaModel):
    def __init__(
        self,
        ip: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        reason: str = None,
    ):
        self.ip = ip
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.reason = reason

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['IP'] = self.ip
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.reason is not None:
            result['Reason'] = self.reason
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        return self


class DescribeStrategyExecDetailResponseBody(TeaModel):
    def __init__(
        self,
        end_time: str = None,
        fail_count: int = None,
        failed_ecs_list: List[DescribeStrategyExecDetailResponseBodyFailedEcsList] = None,
        in_process_count: int = None,
        percent: str = None,
        request_id: str = None,
        source: str = None,
        start_time: str = None,
        success_count: int = None,
    ):
        self.end_time = end_time
        self.fail_count = fail_count
        self.failed_ecs_list = failed_ecs_list
        self.in_process_count = in_process_count
        self.percent = percent
        self.request_id = request_id
        self.source = source
        self.start_time = start_time
        self.success_count = success_count

    def validate(self):
        if self.failed_ecs_list:
            for k in self.failed_ecs_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        result['FailedEcsList'] = []
        if self.failed_ecs_list is not None:
            for k in self.failed_ecs_list:
                result['FailedEcsList'].append(k.to_map() if k else None)
        if self.in_process_count is not None:
            result['InProcessCount'] = self.in_process_count
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source is not None:
            result['Source'] = self.source
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        self.failed_ecs_list = []
        if m.get('FailedEcsList') is not None:
            for k in m.get('FailedEcsList'):
                temp_model = DescribeStrategyExecDetailResponseBodyFailedEcsList()
                self.failed_ecs_list.append(temp_model.from_map(k))
        if m.get('InProcessCount') is not None:
            self.in_process_count = m.get('InProcessCount')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class DescribeStrategyExecDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeStrategyExecDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeStrategyExecDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeStrategyTargetRequest(TeaModel):
    def __init__(
        self,
        config: str = None,
        source_ip: str = None,
        type: str = None,
    ):
        self.config = config
        self.source_ip = source_ip
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeStrategyTargetResponseBodyStrategyTargets(TeaModel):
    def __init__(
        self,
        bind_uuid_count: int = None,
        flag: str = None,
        target: str = None,
        target_type: str = None,
    ):
        self.bind_uuid_count = bind_uuid_count
        self.flag = flag
        self.target = target
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_uuid_count is not None:
            result['BindUuidCount'] = self.bind_uuid_count
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindUuidCount') is not None:
            self.bind_uuid_count = m.get('BindUuidCount')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeStrategyTargetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        strategy_targets: List[DescribeStrategyTargetResponseBodyStrategyTargets] = None,
    ):
        self.request_id = request_id
        self.strategy_targets = strategy_targets

    def validate(self):
        if self.strategy_targets:
            for k in self.strategy_targets:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['StrategyTargets'] = []
        if self.strategy_targets is not None:
            for k in self.strategy_targets:
                result['StrategyTargets'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.strategy_targets = []
        if m.get('StrategyTargets') is not None:
            for k in m.get('StrategyTargets'):
                temp_model = DescribeStrategyTargetResponseBodyStrategyTargets()
                self.strategy_targets.append(temp_model.from_map(k))
        return self


class DescribeStrategyTargetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeStrategyTargetResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeStrategyTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSummaryInfoRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        resource_directory_account_id: str = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.resource_directory_account_id = resource_directory_account_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeSummaryInfoResponseBody(TeaModel):
    def __init__(
        self,
        aegis_client_offline_count: int = None,
        aegis_client_online_count: int = None,
        request_id: str = None,
        security_score: int = None,
        success: bool = None,
    ):
        self.aegis_client_offline_count = aegis_client_offline_count
        self.aegis_client_online_count = aegis_client_online_count
        self.request_id = request_id
        self.security_score = security_score
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.aegis_client_offline_count is not None:
            result['AegisClientOfflineCount'] = self.aegis_client_offline_count
        if self.aegis_client_online_count is not None:
            result['AegisClientOnlineCount'] = self.aegis_client_online_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_score is not None:
            result['SecurityScore'] = self.security_score
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AegisClientOfflineCount') is not None:
            self.aegis_client_offline_count = m.get('AegisClientOfflineCount')
        if m.get('AegisClientOnlineCount') is not None:
            self.aegis_client_online_count = m.get('AegisClientOnlineCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityScore') is not None:
            self.security_score = m.get('SecurityScore')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeSummaryInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSummaryInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSummaryInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSupportRegionResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        support_region: List[str] = None,
    ):
        self.request_id = request_id
        self.support_region = support_region

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.support_region is not None:
            result['SupportRegion'] = self.support_region
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SupportRegion') is not None:
            self.support_region = m.get('SupportRegion')
        return self


class DescribeSupportRegionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSupportRegionResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSupportRegionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventDetailRequest(TeaModel):
    def __init__(
        self,
        from_: str = None,
        lang: str = None,
        source_ip: str = None,
        suspicious_event_id: int = None,
    ):
        self.from_ = from_
        self.lang = lang
        self.source_ip = source_ip
        self.suspicious_event_id = suspicious_event_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.suspicious_event_id is not None:
            result['SuspiciousEventId'] = self.suspicious_event_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('SuspiciousEventId') is not None:
            self.suspicious_event_id = m.get('SuspiciousEventId')
        return self


class DescribeSuspEventDetailResponseBodyDetails(TeaModel):
    def __init__(
        self,
        name_display: str = None,
        type: str = None,
        value: str = None,
    ):
        self.name_display = name_display
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_display is not None:
            result['NameDisplay'] = self.name_display
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameDisplay') is not None:
            self.name_display = m.get('NameDisplay')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeSuspEventDetailResponseBody(TeaModel):
    def __init__(
        self,
        can_be_deal_on_line: bool = None,
        data_source: str = None,
        details: List[DescribeSuspEventDetailResponseBodyDetails] = None,
        event_desc: str = None,
        event_name: str = None,
        event_status: str = None,
        event_type_desc: str = None,
        id: int = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        last_time: str = None,
        level: str = None,
        operate_error_code: str = None,
        operate_msg: str = None,
        request_id: str = None,
        sale_version: str = None,
        uuid: str = None,
    ):
        self.can_be_deal_on_line = can_be_deal_on_line
        self.data_source = data_source
        self.details = details
        self.event_desc = event_desc
        self.event_name = event_name
        self.event_status = event_status
        self.event_type_desc = event_type_desc
        self.id = id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.last_time = last_time
        self.level = level
        self.operate_error_code = operate_error_code
        self.operate_msg = operate_msg
        self.request_id = request_id
        self.sale_version = sale_version
        self.uuid = uuid

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        if self.event_desc is not None:
            result['EventDesc'] = self.event_desc
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_status is not None:
            result['EventStatus'] = self.event_status
        if self.event_type_desc is not None:
            result['EventTypeDesc'] = self.event_type_desc
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.level is not None:
            result['Level'] = self.level
        if self.operate_error_code is not None:
            result['OperateErrorCode'] = self.operate_error_code
        if self.operate_msg is not None:
            result['OperateMsg'] = self.operate_msg
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sale_version is not None:
            result['SaleVersion'] = self.sale_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = DescribeSuspEventDetailResponseBodyDetails()
                self.details.append(temp_model.from_map(k))
        if m.get('EventDesc') is not None:
            self.event_desc = m.get('EventDesc')
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventStatus') is not None:
            self.event_status = m.get('EventStatus')
        if m.get('EventTypeDesc') is not None:
            self.event_type_desc = m.get('EventTypeDesc')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('OperateErrorCode') is not None:
            self.operate_error_code = m.get('OperateErrorCode')
        if m.get('OperateMsg') is not None:
            self.operate_msg = m.get('OperateMsg')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SaleVersion') is not None:
            self.sale_version = m.get('SaleVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeSuspEventDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSuspEventDetailResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventQuaraFilesRequest(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        from_: str = None,
        group_id: str = None,
        grouping_id: int = None,
        page_size: str = None,
        quara_tag: str = None,
        source_ip: str = None,
        status: str = None,
    ):
        self.current_page = current_page
        self.from_ = from_
        self.group_id = group_id
        self.grouping_id = grouping_id
        self.page_size = page_size
        self.quara_tag = quara_tag
        self.source_ip = source_ip
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.from_ is not None:
            result['From'] = self.from_
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.grouping_id is not None:
            result['GroupingId'] = self.grouping_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.quara_tag is not None:
            result['QuaraTag'] = self.quara_tag
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupingId') is not None:
            self.grouping_id = m.get('GroupingId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QuaraTag') is not None:
            self.quara_tag = m.get('QuaraTag')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeSuspEventQuaraFilesResponseBodyQuaraFiles(TeaModel):
    def __init__(
        self,
        event_name: str = None,
        event_type: str = None,
        id: int = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        ip: str = None,
        link: str = None,
        md_5: str = None,
        modify_time: str = None,
        path: str = None,
        status: str = None,
        tag: str = None,
        uuid: str = None,
    ):
        self.event_name = event_name
        self.event_type = event_type
        self.id = id
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.ip = ip
        self.link = link
        self.md_5 = md_5
        self.modify_time = modify_time
        self.path = path
        self.status = status
        self.tag = tag
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.link is not None:
            result['Link'] = self.link
        if self.md_5 is not None:
            result['Md5'] = self.md_5
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.path is not None:
            result['Path'] = self.path
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Md5') is not None:
            self.md_5 = m.get('Md5')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeSuspEventQuaraFilesResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        quara_files: List[DescribeSuspEventQuaraFilesResponseBodyQuaraFiles] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.quara_files = quara_files
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.quara_files:
            for k in self.quara_files:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QuaraFiles'] = []
        if self.quara_files is not None:
            for k in self.quara_files:
                result['QuaraFiles'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.quara_files = []
        if m.get('QuaraFiles') is not None:
            for k in m.get('QuaraFiles'):
                temp_model = DescribeSuspEventQuaraFilesResponseBodyQuaraFiles()
                self.quara_files.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSuspEventQuaraFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSuspEventQuaraFilesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventQuaraFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspEventsRequest(TeaModel):
    def __init__(
        self,
        alarm_unique_info: str = None,
        cluster_id: str = None,
        container_field_name: str = None,
        container_field_value: str = None,
        current_page: str = None,
        dealed: str = None,
        event_names: str = None,
        from_: str = None,
        group_id: int = None,
        lang: str = None,
        levels: str = None,
        name: str = None,
        operate_error_code_list: List[str] = None,
        page_size: str = None,
        parent_event_types: str = None,
        remark: str = None,
        source: str = None,
        source_ip: str = None,
        status: str = None,
        tactic_id: str = None,
        target_type: str = None,
        unique_info: str = None,
        uuids: str = None,
    ):
        self.alarm_unique_info = alarm_unique_info
        self.cluster_id = cluster_id
        self.container_field_name = container_field_name
        self.container_field_value = container_field_value
        self.current_page = current_page
        self.dealed = dealed
        self.event_names = event_names
        self.from_ = from_
        self.group_id = group_id
        self.lang = lang
        self.levels = levels
        self.name = name
        self.operate_error_code_list = operate_error_code_list
        self.page_size = page_size
        self.parent_event_types = parent_event_types
        self.remark = remark
        self.source = source
        self.source_ip = source_ip
        self.status = status
        self.tactic_id = tactic_id
        self.target_type = target_type
        self.unique_info = unique_info
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.event_names is not None:
            result['EventNames'] = self.event_names
        if self.from_ is not None:
            result['From'] = self.from_
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.name is not None:
            result['Name'] = self.name
        if self.operate_error_code_list is not None:
            result['OperateErrorCodeList'] = self.operate_error_code_list
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.parent_event_types is not None:
            result['ParentEventTypes'] = self.parent_event_types
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.source is not None:
            result['Source'] = self.source
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        if self.tactic_id is not None:
            result['TacticId'] = self.tactic_id
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('EventNames') is not None:
            self.event_names = m.get('EventNames')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OperateErrorCodeList') is not None:
            self.operate_error_code_list = m.get('OperateErrorCodeList')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ParentEventTypes') is not None:
            self.parent_event_types = m.get('ParentEventTypes')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TacticId') is not None:
            self.tactic_id = m.get('TacticId')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeSuspEventsResponseBodySuspEventsDetails(TeaModel):
    def __init__(
        self,
        name_display: str = None,
        type: str = None,
        value: str = None,
        value_display: str = None,
    ):
        self.name_display = name_display
        self.type = type
        self.value = value
        self.value_display = value_display

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_display is not None:
            result['NameDisplay'] = self.name_display
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        if self.value_display is not None:
            result['ValueDisplay'] = self.value_display
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameDisplay') is not None:
            self.name_display = m.get('NameDisplay')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('ValueDisplay') is not None:
            self.value_display = m.get('ValueDisplay')
        return self


class DescribeSuspEventsResponseBodySuspEventsEventNotes(TeaModel):
    def __init__(
        self,
        note: str = None,
        note_id: int = None,
        note_time: str = None,
    ):
        self.note = note
        self.note_id = note_id
        self.note_time = note_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note is not None:
            result['Note'] = self.note
        if self.note_id is not None:
            result['NoteId'] = self.note_id
        if self.note_time is not None:
            result['NoteTime'] = self.note_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Note') is not None:
            self.note = m.get('Note')
        if m.get('NoteId') is not None:
            self.note_id = m.get('NoteId')
        if m.get('NoteTime') is not None:
            self.note_time = m.get('NoteTime')
        return self


class DescribeSuspEventsResponseBodySuspEventsTacticItems(TeaModel):
    def __init__(
        self,
        tactic_display_name: str = None,
        tactic_id: str = None,
    ):
        self.tactic_display_name = tactic_display_name
        self.tactic_id = tactic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tactic_display_name is not None:
            result['TacticDisplayName'] = self.tactic_display_name
        if self.tactic_id is not None:
            result['TacticId'] = self.tactic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TacticDisplayName') is not None:
            self.tactic_display_name = m.get('TacticDisplayName')
        if m.get('TacticId') is not None:
            self.tactic_id = m.get('TacticId')
        return self


class DescribeSuspEventsResponseBodySuspEvents(TeaModel):
    def __init__(
        self,
        advanced: bool = None,
        alarm_event_name: str = None,
        alarm_event_name_display: str = None,
        alarm_event_type: str = None,
        alarm_event_type_display: str = None,
        alarm_unique_info: str = None,
        app_name: str = None,
        auto_breaking: bool = None,
        can_be_deal_on_line: bool = None,
        can_cancel_fault: bool = None,
        contain_hw_mode: bool = None,
        container_id: str = None,
        container_image_id: str = None,
        container_image_name: str = None,
        data_source: str = None,
        desc: str = None,
        details: List[DescribeSuspEventsResponseBodySuspEventsDetails] = None,
        event_notes: List[DescribeSuspEventsResponseBodySuspEventsEventNotes] = None,
        event_status: int = None,
        event_sub_type: str = None,
        has_trace_info: bool = None,
        id: int = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        k_8s_cluster_id: str = None,
        k_8s_cluster_name: str = None,
        k_8s_namespace: str = None,
        k_8s_node_id: str = None,
        k_8s_node_name: str = None,
        k_8s_pod_name: str = None,
        last_time: str = None,
        last_time_stamp: int = None,
        level: str = None,
        malicious_rule_status: str = None,
        mark_mis_rules: str = None,
        name: str = None,
        occurrence_time: str = None,
        occurrence_time_stamp: int = None,
        operate_error_code: str = None,
        operate_msg: str = None,
        operate_time: int = None,
        sale_version: str = None,
        security_event_ids: str = None,
        stages: str = None,
        tactic_items: List[DescribeSuspEventsResponseBodySuspEventsTacticItems] = None,
        unique_info: str = None,
        uuid: str = None,
    ):
        self.advanced = advanced
        self.alarm_event_name = alarm_event_name
        self.alarm_event_name_display = alarm_event_name_display
        self.alarm_event_type = alarm_event_type
        self.alarm_event_type_display = alarm_event_type_display
        self.alarm_unique_info = alarm_unique_info
        self.app_name = app_name
        self.auto_breaking = auto_breaking
        self.can_be_deal_on_line = can_be_deal_on_line
        self.can_cancel_fault = can_cancel_fault
        self.contain_hw_mode = contain_hw_mode
        self.container_id = container_id
        self.container_image_id = container_image_id
        self.container_image_name = container_image_name
        self.data_source = data_source
        self.desc = desc
        self.details = details
        self.event_notes = event_notes
        self.event_status = event_status
        self.event_sub_type = event_sub_type
        self.has_trace_info = has_trace_info
        self.id = id
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.k_8s_cluster_id = k_8s_cluster_id
        self.k_8s_cluster_name = k_8s_cluster_name
        self.k_8s_namespace = k_8s_namespace
        self.k_8s_node_id = k_8s_node_id
        self.k_8s_node_name = k_8s_node_name
        self.k_8s_pod_name = k_8s_pod_name
        self.last_time = last_time
        self.last_time_stamp = last_time_stamp
        self.level = level
        self.malicious_rule_status = malicious_rule_status
        self.mark_mis_rules = mark_mis_rules
        self.name = name
        self.occurrence_time = occurrence_time
        self.occurrence_time_stamp = occurrence_time_stamp
        self.operate_error_code = operate_error_code
        self.operate_msg = operate_msg
        self.operate_time = operate_time
        self.sale_version = sale_version
        self.security_event_ids = security_event_ids
        self.stages = stages
        # 攻击阶段展示名
        self.tactic_items = tactic_items
        self.unique_info = unique_info
        self.uuid = uuid

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()
        if self.event_notes:
            for k in self.event_notes:
                if k:
                    k.validate()
        if self.tactic_items:
            for k in self.tactic_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advanced is not None:
            result['Advanced'] = self.advanced
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.alarm_event_name_display is not None:
            result['AlarmEventNameDisplay'] = self.alarm_event_name_display
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.alarm_event_type_display is not None:
            result['AlarmEventTypeDisplay'] = self.alarm_event_type_display
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.auto_breaking is not None:
            result['AutoBreaking'] = self.auto_breaking
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        if self.contain_hw_mode is not None:
            result['ContainHwMode'] = self.contain_hw_mode
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.container_image_id is not None:
            result['ContainerImageId'] = self.container_image_id
        if self.container_image_name is not None:
            result['ContainerImageName'] = self.container_image_name
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.desc is not None:
            result['Desc'] = self.desc
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        result['EventNotes'] = []
        if self.event_notes is not None:
            for k in self.event_notes:
                result['EventNotes'].append(k.to_map() if k else None)
        if self.event_status is not None:
            result['EventStatus'] = self.event_status
        if self.event_sub_type is not None:
            result['EventSubType'] = self.event_sub_type
        if self.has_trace_info is not None:
            result['HasTraceInfo'] = self.has_trace_info
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.k_8s_cluster_name is not None:
            result['K8sClusterName'] = self.k_8s_cluster_name
        if self.k_8s_namespace is not None:
            result['K8sNamespace'] = self.k_8s_namespace
        if self.k_8s_node_id is not None:
            result['K8sNodeId'] = self.k_8s_node_id
        if self.k_8s_node_name is not None:
            result['K8sNodeName'] = self.k_8s_node_name
        if self.k_8s_pod_name is not None:
            result['K8sPodName'] = self.k_8s_pod_name
        if self.last_time is not None:
            result['LastTime'] = self.last_time
        if self.last_time_stamp is not None:
            result['LastTimeStamp'] = self.last_time_stamp
        if self.level is not None:
            result['Level'] = self.level
        if self.malicious_rule_status is not None:
            result['MaliciousRuleStatus'] = self.malicious_rule_status
        if self.mark_mis_rules is not None:
            result['MarkMisRules'] = self.mark_mis_rules
        if self.name is not None:
            result['Name'] = self.name
        if self.occurrence_time is not None:
            result['OccurrenceTime'] = self.occurrence_time
        if self.occurrence_time_stamp is not None:
            result['OccurrenceTimeStamp'] = self.occurrence_time_stamp
        if self.operate_error_code is not None:
            result['OperateErrorCode'] = self.operate_error_code
        if self.operate_msg is not None:
            result['OperateMsg'] = self.operate_msg
        if self.operate_time is not None:
            result['OperateTime'] = self.operate_time
        if self.sale_version is not None:
            result['SaleVersion'] = self.sale_version
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.stages is not None:
            result['Stages'] = self.stages
        result['TacticItems'] = []
        if self.tactic_items is not None:
            for k in self.tactic_items:
                result['TacticItems'].append(k.to_map() if k else None)
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advanced') is not None:
            self.advanced = m.get('Advanced')
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('AlarmEventNameDisplay') is not None:
            self.alarm_event_name_display = m.get('AlarmEventNameDisplay')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('AlarmEventTypeDisplay') is not None:
            self.alarm_event_type_display = m.get('AlarmEventTypeDisplay')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AutoBreaking') is not None:
            self.auto_breaking = m.get('AutoBreaking')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        if m.get('ContainHwMode') is not None:
            self.contain_hw_mode = m.get('ContainHwMode')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('ContainerImageId') is not None:
            self.container_image_id = m.get('ContainerImageId')
        if m.get('ContainerImageName') is not None:
            self.container_image_name = m.get('ContainerImageName')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('Desc') is not None:
            self.desc = m.get('Desc')
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = DescribeSuspEventsResponseBodySuspEventsDetails()
                self.details.append(temp_model.from_map(k))
        self.event_notes = []
        if m.get('EventNotes') is not None:
            for k in m.get('EventNotes'):
                temp_model = DescribeSuspEventsResponseBodySuspEventsEventNotes()
                self.event_notes.append(temp_model.from_map(k))
        if m.get('EventStatus') is not None:
            self.event_status = m.get('EventStatus')
        if m.get('EventSubType') is not None:
            self.event_sub_type = m.get('EventSubType')
        if m.get('HasTraceInfo') is not None:
            self.has_trace_info = m.get('HasTraceInfo')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('K8sClusterName') is not None:
            self.k_8s_cluster_name = m.get('K8sClusterName')
        if m.get('K8sNamespace') is not None:
            self.k_8s_namespace = m.get('K8sNamespace')
        if m.get('K8sNodeId') is not None:
            self.k_8s_node_id = m.get('K8sNodeId')
        if m.get('K8sNodeName') is not None:
            self.k_8s_node_name = m.get('K8sNodeName')
        if m.get('K8sPodName') is not None:
            self.k_8s_pod_name = m.get('K8sPodName')
        if m.get('LastTime') is not None:
            self.last_time = m.get('LastTime')
        if m.get('LastTimeStamp') is not None:
            self.last_time_stamp = m.get('LastTimeStamp')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MaliciousRuleStatus') is not None:
            self.malicious_rule_status = m.get('MaliciousRuleStatus')
        if m.get('MarkMisRules') is not None:
            self.mark_mis_rules = m.get('MarkMisRules')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OccurrenceTime') is not None:
            self.occurrence_time = m.get('OccurrenceTime')
        if m.get('OccurrenceTimeStamp') is not None:
            self.occurrence_time_stamp = m.get('OccurrenceTimeStamp')
        if m.get('OperateErrorCode') is not None:
            self.operate_error_code = m.get('OperateErrorCode')
        if m.get('OperateMsg') is not None:
            self.operate_msg = m.get('OperateMsg')
        if m.get('OperateTime') is not None:
            self.operate_time = m.get('OperateTime')
        if m.get('SaleVersion') is not None:
            self.sale_version = m.get('SaleVersion')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('Stages') is not None:
            self.stages = m.get('Stages')
        self.tactic_items = []
        if m.get('TacticItems') is not None:
            for k in m.get('TacticItems'):
                temp_model = DescribeSuspEventsResponseBodySuspEventsTacticItems()
                self.tactic_items.append(temp_model.from_map(k))
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeSuspEventsResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        susp_events: List[DescribeSuspEventsResponseBodySuspEvents] = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.susp_events = susp_events
        self.total_count = total_count

    def validate(self):
        if self.susp_events:
            for k in self.susp_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SuspEvents'] = []
        if self.susp_events is not None:
            for k in self.susp_events:
                result['SuspEvents'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.susp_events = []
        if m.get('SuspEvents') is not None:
            for k in m.get('SuspEvents'):
                temp_model = DescribeSuspEventsResponseBodySuspEvents()
                self.susp_events.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSuspEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSuspEventsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSuspEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSuspiciousUUIDConfigRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
    ):
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeSuspiciousUUIDConfigResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        request_id: str = None,
        uuidlist: List[str] = None,
    ):
        self.count = count
        self.request_id = request_id
        self.uuidlist = uuidlist

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.uuidlist is not None:
            result['UUIDList'] = self.uuidlist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UUIDList') is not None:
            self.uuidlist = m.get('UUIDList')
        return self


class DescribeSuspiciousUUIDConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeSuspiciousUUIDConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeSuspiciousUUIDConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserBackupMachinesResponseBodyMachines(TeaModel):
    def __init__(
        self,
        id: int = None,
        policy_name: str = None,
        uuid: str = None,
    ):
        self.id = id
        self.policy_name = policy_name
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeUserBackupMachinesResponseBody(TeaModel):
    def __init__(
        self,
        machines: List[DescribeUserBackupMachinesResponseBodyMachines] = None,
        request_id: str = None,
    ):
        self.machines = machines
        self.request_id = request_id

    def validate(self):
        if self.machines:
            for k in self.machines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Machines'] = []
        if self.machines is not None:
            for k in self.machines:
                result['Machines'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.machines = []
        if m.get('Machines') is not None:
            for k in m.get('Machines'):
                temp_model = DescribeUserBackupMachinesResponseBodyMachines()
                self.machines.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeUserBackupMachinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUserBackupMachinesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserBackupMachinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserBaselineAuthorizationRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeUserBaselineAuthorizationResponseBodyUserBaselineAuthorization(TeaModel):
    def __init__(
        self,
        status: int = None,
    ):
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeUserBaselineAuthorizationResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_baseline_authorization: DescribeUserBaselineAuthorizationResponseBodyUserBaselineAuthorization = None,
    ):
        self.request_id = request_id
        self.user_baseline_authorization = user_baseline_authorization

    def validate(self):
        if self.user_baseline_authorization:
            self.user_baseline_authorization.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_baseline_authorization is not None:
            result['UserBaselineAuthorization'] = self.user_baseline_authorization.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserBaselineAuthorization') is not None:
            temp_model = DescribeUserBaselineAuthorizationResponseBodyUserBaselineAuthorization()
            self.user_baseline_authorization = temp_model.from_map(m['UserBaselineAuthorization'])
        return self


class DescribeUserBaselineAuthorizationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUserBaselineAuthorizationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserBaselineAuthorizationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeUserLayoutAuthorizationRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        self.lang = lang
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeUserLayoutAuthorizationResponseBody(TeaModel):
    def __init__(
        self,
        authorized: bool = None,
        request_id: str = None,
    ):
        self.authorized = authorized
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.authorized is not None:
            result['Authorized'] = self.authorized
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Authorized') is not None:
            self.authorized = m.get('Authorized')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeUserLayoutAuthorizationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeUserLayoutAuthorizationResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeUserLayoutAuthorizationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVersionConfigRequest(TeaModel):
    def __init__(
        self,
        resource_directory_account_id: str = None,
        source_ip: str = None,
    ):
        self.resource_directory_account_id = resource_directory_account_id
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_directory_account_id is not None:
            result['ResourceDirectoryAccountId'] = self.resource_directory_account_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceDirectoryAccountId') is not None:
            self.resource_directory_account_id = m.get('ResourceDirectoryAccountId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeVersionConfigResponseBody(TeaModel):
    def __init__(
        self,
        allow_partial_buy: int = None,
        app_white_list: int = None,
        app_white_list_auth_count: int = None,
        asset_level: int = None,
        highest_version: int = None,
        honeypot_capacity: int = None,
        image_scan_capacity: int = None,
        instance_id: str = None,
        is_over_balance: bool = None,
        is_trial_version: int = None,
        last_trail_end_time: int = None,
        mvauth_count: int = None,
        mvunused_auth_count: int = None,
        release_time: int = None,
        request_id: str = None,
        sas_log: int = None,
        sas_screen: int = None,
        sls_capacity: int = None,
        user_defined_alarms: int = None,
        version: int = None,
        vm_cores: int = None,
        web_lock: int = None,
        web_lock_auth_count: int = None,
    ):
        self.allow_partial_buy = allow_partial_buy
        self.app_white_list = app_white_list
        self.app_white_list_auth_count = app_white_list_auth_count
        self.asset_level = asset_level
        self.highest_version = highest_version
        self.honeypot_capacity = honeypot_capacity
        self.image_scan_capacity = image_scan_capacity
        self.instance_id = instance_id
        self.is_over_balance = is_over_balance
        self.is_trial_version = is_trial_version
        self.last_trail_end_time = last_trail_end_time
        self.mvauth_count = mvauth_count
        self.mvunused_auth_count = mvunused_auth_count
        self.release_time = release_time
        self.request_id = request_id
        self.sas_log = sas_log
        self.sas_screen = sas_screen
        self.sls_capacity = sls_capacity
        self.user_defined_alarms = user_defined_alarms
        self.version = version
        self.vm_cores = vm_cores
        self.web_lock = web_lock
        self.web_lock_auth_count = web_lock_auth_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_partial_buy is not None:
            result['AllowPartialBuy'] = self.allow_partial_buy
        if self.app_white_list is not None:
            result['AppWhiteList'] = self.app_white_list
        if self.app_white_list_auth_count is not None:
            result['AppWhiteListAuthCount'] = self.app_white_list_auth_count
        if self.asset_level is not None:
            result['AssetLevel'] = self.asset_level
        if self.highest_version is not None:
            result['HighestVersion'] = self.highest_version
        if self.honeypot_capacity is not None:
            result['HoneypotCapacity'] = self.honeypot_capacity
        if self.image_scan_capacity is not None:
            result['ImageScanCapacity'] = self.image_scan_capacity
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_over_balance is not None:
            result['IsOverBalance'] = self.is_over_balance
        if self.is_trial_version is not None:
            result['IsTrialVersion'] = self.is_trial_version
        if self.last_trail_end_time is not None:
            result['LastTrailEndTime'] = self.last_trail_end_time
        if self.mvauth_count is not None:
            result['MVAuthCount'] = self.mvauth_count
        if self.mvunused_auth_count is not None:
            result['MVUnusedAuthCount'] = self.mvunused_auth_count
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sas_log is not None:
            result['SasLog'] = self.sas_log
        if self.sas_screen is not None:
            result['SasScreen'] = self.sas_screen
        if self.sls_capacity is not None:
            result['SlsCapacity'] = self.sls_capacity
        if self.user_defined_alarms is not None:
            result['UserDefinedAlarms'] = self.user_defined_alarms
        if self.version is not None:
            result['Version'] = self.version
        if self.vm_cores is not None:
            result['VmCores'] = self.vm_cores
        if self.web_lock is not None:
            result['WebLock'] = self.web_lock
        if self.web_lock_auth_count is not None:
            result['WebLockAuthCount'] = self.web_lock_auth_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowPartialBuy') is not None:
            self.allow_partial_buy = m.get('AllowPartialBuy')
        if m.get('AppWhiteList') is not None:
            self.app_white_list = m.get('AppWhiteList')
        if m.get('AppWhiteListAuthCount') is not None:
            self.app_white_list_auth_count = m.get('AppWhiteListAuthCount')
        if m.get('AssetLevel') is not None:
            self.asset_level = m.get('AssetLevel')
        if m.get('HighestVersion') is not None:
            self.highest_version = m.get('HighestVersion')
        if m.get('HoneypotCapacity') is not None:
            self.honeypot_capacity = m.get('HoneypotCapacity')
        if m.get('ImageScanCapacity') is not None:
            self.image_scan_capacity = m.get('ImageScanCapacity')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsOverBalance') is not None:
            self.is_over_balance = m.get('IsOverBalance')
        if m.get('IsTrialVersion') is not None:
            self.is_trial_version = m.get('IsTrialVersion')
        if m.get('LastTrailEndTime') is not None:
            self.last_trail_end_time = m.get('LastTrailEndTime')
        if m.get('MVAuthCount') is not None:
            self.mvauth_count = m.get('MVAuthCount')
        if m.get('MVUnusedAuthCount') is not None:
            self.mvunused_auth_count = m.get('MVUnusedAuthCount')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SasLog') is not None:
            self.sas_log = m.get('SasLog')
        if m.get('SasScreen') is not None:
            self.sas_screen = m.get('SasScreen')
        if m.get('SlsCapacity') is not None:
            self.sls_capacity = m.get('SlsCapacity')
        if m.get('UserDefinedAlarms') is not None:
            self.user_defined_alarms = m.get('UserDefinedAlarms')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        if m.get('VmCores') is not None:
            self.vm_cores = m.get('VmCores')
        if m.get('WebLock') is not None:
            self.web_lock = m.get('WebLock')
        if m.get('WebLockAuthCount') is not None:
            self.web_lock_auth_count = m.get('WebLockAuthCount')
        return self


class DescribeVersionConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVersionConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVersionConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVpcHoneyPotCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        values: str = None,
    ):
        self.name = name
        self.type = type
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeVpcHoneyPotCriteriaResponseBody(TeaModel):
    def __init__(
        self,
        criteria_list: List[DescribeVpcHoneyPotCriteriaResponseBodyCriteriaList] = None,
        request_id: str = None,
    ):
        self.criteria_list = criteria_list
        self.request_id = request_id

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeVpcHoneyPotCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVpcHoneyPotCriteriaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVpcHoneyPotCriteriaResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVpcHoneyPotCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVpcHoneyPotListRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        honey_pot_existence: bool = None,
        page_size: int = None,
        vpc_id: str = None,
        vpc_name: str = None,
        vpc_region_id: str = None,
    ):
        self.current_page = current_page
        self.honey_pot_existence = honey_pot_existence
        self.page_size = page_size
        self.vpc_id = vpc_id
        self.vpc_name = vpc_name
        self.vpc_region_id = vpc_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.honey_pot_existence is not None:
            result['HoneyPotExistence'] = self.honey_pot_existence
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        if self.vpc_region_id is not None:
            result['VpcRegionId'] = self.vpc_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('HoneyPotExistence') is not None:
            self.honey_pot_existence = m.get('HoneyPotExistence')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        if m.get('VpcRegionId') is not None:
            self.vpc_region_id = m.get('VpcRegionId')
        return self


class DescribeVpcHoneyPotListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOListVpcSwitchIdList(TeaModel):
    def __init__(
        self,
        vpc_switch_id: str = None,
        vpc_switch_name: str = None,
        zone_id: str = None,
    ):
        self.vpc_switch_id = vpc_switch_id
        self.vpc_switch_name = vpc_switch_name
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_switch_id is not None:
            result['VpcSwitchId'] = self.vpc_switch_id
        if self.vpc_switch_name is not None:
            result['VpcSwitchName'] = self.vpc_switch_name
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcSwitchId') is not None:
            self.vpc_switch_id = m.get('VpcSwitchId')
        if m.get('VpcSwitchName') is not None:
            self.vpc_switch_name = m.get('VpcSwitchName')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOList(TeaModel):
    def __init__(
        self,
        cidr_block: str = None,
        create_time: int = None,
        honey_pot_ecs_instance_status: str = None,
        honey_pot_eni_instance_id: str = None,
        honey_pot_existence: bool = None,
        honey_pot_instance_status: str = None,
        honey_pot_vpc_switch_id: str = None,
        vpc_id: str = None,
        vpc_name: str = None,
        vpc_region_id: str = None,
        vpc_status: str = None,
        vpc_switch_id_list: List[DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOListVpcSwitchIdList] = None,
    ):
        self.cidr_block = cidr_block
        self.create_time = create_time
        self.honey_pot_ecs_instance_status = honey_pot_ecs_instance_status
        self.honey_pot_eni_instance_id = honey_pot_eni_instance_id
        self.honey_pot_existence = honey_pot_existence
        self.honey_pot_instance_status = honey_pot_instance_status
        self.honey_pot_vpc_switch_id = honey_pot_vpc_switch_id
        self.vpc_id = vpc_id
        self.vpc_name = vpc_name
        self.vpc_region_id = vpc_region_id
        self.vpc_status = vpc_status
        self.vpc_switch_id_list = vpc_switch_id_list

    def validate(self):
        if self.vpc_switch_id_list:
            for k in self.vpc_switch_id_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.honey_pot_ecs_instance_status is not None:
            result['HoneyPotEcsInstanceStatus'] = self.honey_pot_ecs_instance_status
        if self.honey_pot_eni_instance_id is not None:
            result['HoneyPotEniInstanceId'] = self.honey_pot_eni_instance_id
        if self.honey_pot_existence is not None:
            result['HoneyPotExistence'] = self.honey_pot_existence
        if self.honey_pot_instance_status is not None:
            result['HoneyPotInstanceStatus'] = self.honey_pot_instance_status
        if self.honey_pot_vpc_switch_id is not None:
            result['HoneyPotVpcSwitchId'] = self.honey_pot_vpc_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        if self.vpc_region_id is not None:
            result['VpcRegionId'] = self.vpc_region_id
        if self.vpc_status is not None:
            result['VpcStatus'] = self.vpc_status
        result['VpcSwitchIdList'] = []
        if self.vpc_switch_id_list is not None:
            for k in self.vpc_switch_id_list:
                result['VpcSwitchIdList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('HoneyPotEcsInstanceStatus') is not None:
            self.honey_pot_ecs_instance_status = m.get('HoneyPotEcsInstanceStatus')
        if m.get('HoneyPotEniInstanceId') is not None:
            self.honey_pot_eni_instance_id = m.get('HoneyPotEniInstanceId')
        if m.get('HoneyPotExistence') is not None:
            self.honey_pot_existence = m.get('HoneyPotExistence')
        if m.get('HoneyPotInstanceStatus') is not None:
            self.honey_pot_instance_status = m.get('HoneyPotInstanceStatus')
        if m.get('HoneyPotVpcSwitchId') is not None:
            self.honey_pot_vpc_switch_id = m.get('HoneyPotVpcSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        if m.get('VpcRegionId') is not None:
            self.vpc_region_id = m.get('VpcRegionId')
        if m.get('VpcStatus') is not None:
            self.vpc_status = m.get('VpcStatus')
        self.vpc_switch_id_list = []
        if m.get('VpcSwitchIdList') is not None:
            for k in m.get('VpcSwitchIdList'):
                temp_model = DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOListVpcSwitchIdList()
                self.vpc_switch_id_list.append(temp_model.from_map(k))
        return self


class DescribeVpcHoneyPotListResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeVpcHoneyPotListResponseBodyPageInfo = None,
        request_id: str = None,
        vpc_honey_pot_dtolist: List[DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOList] = None,
    ):
        self.page_info = page_info
        self.request_id = request_id
        self.vpc_honey_pot_dtolist = vpc_honey_pot_dtolist

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.vpc_honey_pot_dtolist:
            for k in self.vpc_honey_pot_dtolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['VpcHoneyPotDTOList'] = []
        if self.vpc_honey_pot_dtolist is not None:
            for k in self.vpc_honey_pot_dtolist:
                result['VpcHoneyPotDTOList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeVpcHoneyPotListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.vpc_honey_pot_dtolist = []
        if m.get('VpcHoneyPotDTOList') is not None:
            for k in m.get('VpcHoneyPotDTOList'):
                temp_model = DescribeVpcHoneyPotListResponseBodyVpcHoneyPotDTOList()
                self.vpc_honey_pot_dtolist.append(temp_model.from_map(k))
        return self


class DescribeVpcHoneyPotListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVpcHoneyPotListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVpcHoneyPotListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVpcListResponseBodyVpcList(TeaModel):
    def __init__(
        self,
        ecs_count: int = None,
        instance_desc: str = None,
        instance_id: str = None,
        instance_name: str = None,
        region_id: str = None,
    ):
        self.ecs_count = ecs_count
        self.instance_desc = instance_desc
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ecs_count is not None:
            result['EcsCount'] = self.ecs_count
        if self.instance_desc is not None:
            result['InstanceDesc'] = self.instance_desc
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EcsCount') is not None:
            self.ecs_count = m.get('EcsCount')
        if m.get('InstanceDesc') is not None:
            self.instance_desc = m.get('InstanceDesc')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeVpcListResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        request_id: str = None,
        vpc_list: List[DescribeVpcListResponseBodyVpcList] = None,
    ):
        self.count = count
        self.request_id = request_id
        self.vpc_list = vpc_list

    def validate(self):
        if self.vpc_list:
            for k in self.vpc_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['VpcList'] = []
        if self.vpc_list is not None:
            for k in self.vpc_list:
                result['VpcList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.vpc_list = []
        if m.get('VpcList') is not None:
            for k in m.get('VpcList'):
                temp_model = DescribeVpcListResponseBodyVpcList()
                self.vpc_list.append(temp_model.from_map(k))
        return self


class DescribeVpcListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVpcListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVpcListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulDetailsRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        lang: str = None,
        name: str = None,
        type: str = None,
    ):
        self.alias_name = alias_name
        self.lang = lang
        self.name = name
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeVulDetailsResponseBodyCvesClassifys(TeaModel):
    def __init__(
        self,
        classify: str = None,
        demo_video_url: str = None,
        description: str = None,
    ):
        self.classify = classify
        self.demo_video_url = demo_video_url
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.classify is not None:
            result['Classify'] = self.classify
        if self.demo_video_url is not None:
            result['DemoVideoUrl'] = self.demo_video_url
        if self.description is not None:
            result['Description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Classify') is not None:
            self.classify = m.get('Classify')
        if m.get('DemoVideoUrl') is not None:
            self.demo_video_url = m.get('DemoVideoUrl')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        return self


class DescribeVulDetailsResponseBodyCves(TeaModel):
    def __init__(
        self,
        classify: str = None,
        classifys: List[DescribeVulDetailsResponseBodyCvesClassifys] = None,
        cnvd_id: str = None,
        complexity: str = None,
        content: str = None,
        cve_id: str = None,
        cvss_score: str = None,
        cvss_vector: str = None,
        poc: str = None,
        poc_create_time: int = None,
        poc_disclosure_time: int = None,
        product: str = None,
        reference: str = None,
        release_time: int = None,
        solution: str = None,
        summary: str = None,
        title: str = None,
        vendor: str = None,
        vul_level: str = None,
    ):
        self.classify = classify
        self.classifys = classifys
        self.cnvd_id = cnvd_id
        self.complexity = complexity
        self.content = content
        self.cve_id = cve_id
        self.cvss_score = cvss_score
        self.cvss_vector = cvss_vector
        self.poc = poc
        self.poc_create_time = poc_create_time
        self.poc_disclosure_time = poc_disclosure_time
        self.product = product
        self.reference = reference
        self.release_time = release_time
        self.solution = solution
        self.summary = summary
        self.title = title
        self.vendor = vendor
        self.vul_level = vul_level

    def validate(self):
        if self.classifys:
            for k in self.classifys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.classify is not None:
            result['Classify'] = self.classify
        result['Classifys'] = []
        if self.classifys is not None:
            for k in self.classifys:
                result['Classifys'].append(k.to_map() if k else None)
        if self.cnvd_id is not None:
            result['CnvdId'] = self.cnvd_id
        if self.complexity is not None:
            result['Complexity'] = self.complexity
        if self.content is not None:
            result['Content'] = self.content
        if self.cve_id is not None:
            result['CveId'] = self.cve_id
        if self.cvss_score is not None:
            result['CvssScore'] = self.cvss_score
        if self.cvss_vector is not None:
            result['CvssVector'] = self.cvss_vector
        if self.poc is not None:
            result['Poc'] = self.poc
        if self.poc_create_time is not None:
            result['PocCreateTime'] = self.poc_create_time
        if self.poc_disclosure_time is not None:
            result['PocDisclosureTime'] = self.poc_disclosure_time
        if self.product is not None:
            result['Product'] = self.product
        if self.reference is not None:
            result['Reference'] = self.reference
        if self.release_time is not None:
            result['ReleaseTime'] = self.release_time
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.summary is not None:
            result['Summary'] = self.summary
        if self.title is not None:
            result['Title'] = self.title
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.vul_level is not None:
            result['VulLevel'] = self.vul_level
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Classify') is not None:
            self.classify = m.get('Classify')
        self.classifys = []
        if m.get('Classifys') is not None:
            for k in m.get('Classifys'):
                temp_model = DescribeVulDetailsResponseBodyCvesClassifys()
                self.classifys.append(temp_model.from_map(k))
        if m.get('CnvdId') is not None:
            self.cnvd_id = m.get('CnvdId')
        if m.get('Complexity') is not None:
            self.complexity = m.get('Complexity')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CveId') is not None:
            self.cve_id = m.get('CveId')
        if m.get('CvssScore') is not None:
            self.cvss_score = m.get('CvssScore')
        if m.get('CvssVector') is not None:
            self.cvss_vector = m.get('CvssVector')
        if m.get('Poc') is not None:
            self.poc = m.get('Poc')
        if m.get('PocCreateTime') is not None:
            self.poc_create_time = m.get('PocCreateTime')
        if m.get('PocDisclosureTime') is not None:
            self.poc_disclosure_time = m.get('PocDisclosureTime')
        if m.get('Product') is not None:
            self.product = m.get('Product')
        if m.get('Reference') is not None:
            self.reference = m.get('Reference')
        if m.get('ReleaseTime') is not None:
            self.release_time = m.get('ReleaseTime')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('Summary') is not None:
            self.summary = m.get('Summary')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('VulLevel') is not None:
            self.vul_level = m.get('VulLevel')
        return self


class DescribeVulDetailsResponseBody(TeaModel):
    def __init__(
        self,
        cves: List[DescribeVulDetailsResponseBodyCves] = None,
        request_id: str = None,
    ):
        self.cves = cves
        self.request_id = request_id

    def validate(self):
        if self.cves:
            for k in self.cves:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Cves'] = []
        if self.cves is not None:
            for k in self.cves:
                result['Cves'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cves = []
        if m.get('Cves') is not None:
            for k in m.get('Cves'):
                temp_model = DescribeVulDetailsResponseBodyCves()
                self.cves.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeVulDetailsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVulDetailsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVulDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulExportInfoRequest(TeaModel):
    def __init__(
        self,
        export_id: int = None,
    ):
        self.export_id = export_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_id is not None:
            result['ExportId'] = self.export_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExportId') is not None:
            self.export_id = m.get('ExportId')
        return self


class DescribeVulExportInfoResponseBody(TeaModel):
    def __init__(
        self,
        current_count: int = None,
        export_status: str = None,
        file_name: str = None,
        id: int = None,
        link: str = None,
        message: str = None,
        progress: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.current_count = current_count
        self.export_status = export_status
        self.file_name = file_name
        self.id = id
        self.link = link
        self.message = message
        self.progress = progress
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.export_status is not None:
            result['ExportStatus'] = self.export_status
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        if self.link is not None:
            result['Link'] = self.link
        if self.message is not None:
            result['Message'] = self.message
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('ExportStatus') is not None:
            self.export_status = m.get('ExportStatus')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeVulExportInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVulExportInfoResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVulExportInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulListRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        attach_types: str = None,
        current_page: int = None,
        dealed: str = None,
        group_id: str = None,
        lang: str = None,
        necessity: str = None,
        page_size: int = None,
        remark: str = None,
        type: str = None,
        uuids: str = None,
        vpc_instance_ids: str = None,
    ):
        self.alias_name = alias_name
        self.attach_types = attach_types
        self.current_page = current_page
        self.dealed = dealed
        self.group_id = group_id
        self.lang = lang
        self.necessity = necessity
        self.page_size = page_size
        self.remark = remark
        self.type = type
        self.uuids = uuids
        self.vpc_instance_ids = vpc_instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.attach_types is not None:
            result['AttachTypes'] = self.attach_types
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.vpc_instance_ids is not None:
            result['VpcInstanceIds'] = self.vpc_instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AttachTypes') is not None:
            self.attach_types = m.get('AttachTypes')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('VpcInstanceIds') is not None:
            self.vpc_instance_ids = m.get('VpcInstanceIds')
        return self


class DescribeVulListResponseBodyVulRecordsExtendContentJsonNecessity(TeaModel):
    def __init__(
        self,
        assets_factor: str = None,
        cvss_factor: str = None,
        enviroment_factor: str = None,
        is_calc: str = None,
        status: str = None,
        time_factor: str = None,
        total_score: str = None,
    ):
        self.assets_factor = assets_factor
        self.cvss_factor = cvss_factor
        self.enviroment_factor = enviroment_factor
        self.is_calc = is_calc
        self.status = status
        self.time_factor = time_factor
        self.total_score = total_score

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assets_factor is not None:
            result['Assets_factor'] = self.assets_factor
        if self.cvss_factor is not None:
            result['Cvss_factor'] = self.cvss_factor
        if self.enviroment_factor is not None:
            result['Enviroment_factor'] = self.enviroment_factor
        if self.is_calc is not None:
            result['Is_calc'] = self.is_calc
        if self.status is not None:
            result['Status'] = self.status
        if self.time_factor is not None:
            result['Time_factor'] = self.time_factor
        if self.total_score is not None:
            result['Total_score'] = self.total_score
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Assets_factor') is not None:
            self.assets_factor = m.get('Assets_factor')
        if m.get('Cvss_factor') is not None:
            self.cvss_factor = m.get('Cvss_factor')
        if m.get('Enviroment_factor') is not None:
            self.enviroment_factor = m.get('Enviroment_factor')
        if m.get('Is_calc') is not None:
            self.is_calc = m.get('Is_calc')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Time_factor') is not None:
            self.time_factor = m.get('Time_factor')
        if m.get('Total_score') is not None:
            self.total_score = m.get('Total_score')
        return self


class DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList(TeaModel):
    def __init__(
        self,
        container_name: str = None,
        full_version: str = None,
        image_name: str = None,
        match_detail: str = None,
        match_list: List[str] = None,
        name: str = None,
        path: str = None,
        pid: str = None,
        update_cmd: str = None,
        version: str = None,
    ):
        self.container_name = container_name
        self.full_version = full_version
        self.image_name = image_name
        self.match_detail = match_detail
        self.match_list = match_list
        self.name = name
        self.path = path
        self.pid = pid
        self.update_cmd = update_cmd
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.container_name is not None:
            result['ContainerName'] = self.container_name
        if self.full_version is not None:
            result['FullVersion'] = self.full_version
        if self.image_name is not None:
            result['ImageName'] = self.image_name
        if self.match_detail is not None:
            result['MatchDetail'] = self.match_detail
        if self.match_list is not None:
            result['MatchList'] = self.match_list
        if self.name is not None:
            result['Name'] = self.name
        if self.path is not None:
            result['Path'] = self.path
        if self.pid is not None:
            result['Pid'] = self.pid
        if self.update_cmd is not None:
            result['UpdateCmd'] = self.update_cmd
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContainerName') is not None:
            self.container_name = m.get('ContainerName')
        if m.get('FullVersion') is not None:
            self.full_version = m.get('FullVersion')
        if m.get('ImageName') is not None:
            self.image_name = m.get('ImageName')
        if m.get('MatchDetail') is not None:
            self.match_detail = m.get('MatchDetail')
        if m.get('MatchList') is not None:
            self.match_list = m.get('MatchList')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Pid') is not None:
            self.pid = m.get('Pid')
        if m.get('UpdateCmd') is not None:
            self.update_cmd = m.get('UpdateCmd')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeVulListResponseBodyVulRecordsExtendContentJson(TeaModel):
    def __init__(
        self,
        absolute_path: str = None,
        alias_name: str = None,
        description: str = None,
        ip: str = None,
        last_ts: int = None,
        necessity: DescribeVulListResponseBodyVulRecordsExtendContentJsonNecessity = None,
        os: str = None,
        os_release: str = None,
        primary_id: int = None,
        rpm_entity_list: List[DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList] = None,
        status: str = None,
        tag: str = None,
        cve_list: List[str] = None,
    ):
        self.absolute_path = absolute_path
        self.alias_name = alias_name
        self.description = description
        self.ip = ip
        self.last_ts = last_ts
        self.necessity = necessity
        self.os = os
        self.os_release = os_release
        self.primary_id = primary_id
        self.rpm_entity_list = rpm_entity_list
        self.status = status
        self.tag = tag
        self.cve_list = cve_list

    def validate(self):
        if self.necessity:
            self.necessity.validate()
        if self.rpm_entity_list:
            for k in self.rpm_entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.absolute_path is not None:
            result['AbsolutePath'] = self.absolute_path
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.description is not None:
            result['Description'] = self.description
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.last_ts is not None:
            result['LastTs'] = self.last_ts
        if self.necessity is not None:
            result['Necessity'] = self.necessity.to_map()
        if self.os is not None:
            result['Os'] = self.os
        if self.os_release is not None:
            result['OsRelease'] = self.os_release
        if self.primary_id is not None:
            result['PrimaryId'] = self.primary_id
        result['RpmEntityList'] = []
        if self.rpm_entity_list is not None:
            for k in self.rpm_entity_list:
                result['RpmEntityList'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.cve_list is not None:
            result['cveList'] = self.cve_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AbsolutePath') is not None:
            self.absolute_path = m.get('AbsolutePath')
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('LastTs') is not None:
            self.last_ts = m.get('LastTs')
        if m.get('Necessity') is not None:
            temp_model = DescribeVulListResponseBodyVulRecordsExtendContentJsonNecessity()
            self.necessity = temp_model.from_map(m['Necessity'])
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsRelease') is not None:
            self.os_release = m.get('OsRelease')
        if m.get('PrimaryId') is not None:
            self.primary_id = m.get('PrimaryId')
        self.rpm_entity_list = []
        if m.get('RpmEntityList') is not None:
            for k in m.get('RpmEntityList'):
                temp_model = DescribeVulListResponseBodyVulRecordsExtendContentJsonRpmEntityList()
                self.rpm_entity_list.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('cveList') is not None:
            self.cve_list = m.get('cveList')
        return self


class DescribeVulListResponseBodyVulRecords(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        extend_content_json: DescribeVulListResponseBodyVulRecordsExtendContentJson = None,
        first_ts: int = None,
        group_id: int = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        last_ts: int = None,
        modify_ts: int = None,
        name: str = None,
        necessity: str = None,
        online: bool = None,
        os_version: str = None,
        primary_id: int = None,
        region_id: str = None,
        related: str = None,
        repair_ts: int = None,
        result_code: str = None,
        result_message: str = None,
        status: int = None,
        tag: str = None,
        type: str = None,
        uuid: str = None,
    ):
        self.alias_name = alias_name
        self.extend_content_json = extend_content_json
        self.first_ts = first_ts
        self.group_id = group_id
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.last_ts = last_ts
        self.modify_ts = modify_ts
        self.name = name
        self.necessity = necessity
        self.online = online
        self.os_version = os_version
        self.primary_id = primary_id
        self.region_id = region_id
        self.related = related
        self.repair_ts = repair_ts
        self.result_code = result_code
        self.result_message = result_message
        self.status = status
        self.tag = tag
        self.type = type
        self.uuid = uuid

    def validate(self):
        if self.extend_content_json:
            self.extend_content_json.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.extend_content_json is not None:
            result['ExtendContentJson'] = self.extend_content_json.to_map()
        if self.first_ts is not None:
            result['FirstTs'] = self.first_ts
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.last_ts is not None:
            result['LastTs'] = self.last_ts
        if self.modify_ts is not None:
            result['ModifyTs'] = self.modify_ts
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.online is not None:
            result['Online'] = self.online
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.primary_id is not None:
            result['PrimaryId'] = self.primary_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.related is not None:
            result['Related'] = self.related
        if self.repair_ts is not None:
            result['RepairTs'] = self.repair_ts
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        if self.result_message is not None:
            result['ResultMessage'] = self.result_message
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('ExtendContentJson') is not None:
            temp_model = DescribeVulListResponseBodyVulRecordsExtendContentJson()
            self.extend_content_json = temp_model.from_map(m['ExtendContentJson'])
        if m.get('FirstTs') is not None:
            self.first_ts = m.get('FirstTs')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LastTs') is not None:
            self.last_ts = m.get('LastTs')
        if m.get('ModifyTs') is not None:
            self.modify_ts = m.get('ModifyTs')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('PrimaryId') is not None:
            self.primary_id = m.get('PrimaryId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Related') is not None:
            self.related = m.get('Related')
        if m.get('RepairTs') is not None:
            self.repair_ts = m.get('RepairTs')
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        if m.get('ResultMessage') is not None:
            self.result_message = m.get('ResultMessage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeVulListResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        vul_records: List[DescribeVulListResponseBodyVulRecords] = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.vul_records = vul_records

    def validate(self):
        if self.vul_records:
            for k in self.vul_records:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VulRecords'] = []
        if self.vul_records is not None:
            for k in self.vul_records:
                result['VulRecords'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vul_records = []
        if m.get('VulRecords') is not None:
            for k in m.get('VulRecords'):
                temp_model = DescribeVulListResponseBodyVulRecords()
                self.vul_records.append(temp_model.from_map(k))
        return self


class DescribeVulListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVulListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVulListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeVulWhitelistRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeVulWhitelistResponseBodyVulWhitelists(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        id: str = None,
        name: str = None,
        reason: str = None,
        target_info: str = None,
        type: str = None,
    ):
        self.alias_name = alias_name
        self.id = id
        self.name = name
        self.reason = reason
        self.target_info = target_info
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.target_info is not None:
            result['TargetInfo'] = self.target_info
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('TargetInfo') is not None:
            self.target_info = m.get('TargetInfo')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeVulWhitelistResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        vul_whitelists: List[DescribeVulWhitelistResponseBodyVulWhitelists] = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.vul_whitelists = vul_whitelists

    def validate(self):
        if self.vul_whitelists:
            for k in self.vul_whitelists:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VulWhitelists'] = []
        if self.vul_whitelists is not None:
            for k in self.vul_whitelists:
                result['VulWhitelists'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.vul_whitelists = []
        if m.get('VulWhitelists') is not None:
            for k in m.get('VulWhitelists'):
                temp_model = DescribeVulWhitelistResponseBodyVulWhitelists()
                self.vul_whitelists.append(temp_model.from_map(k))
        return self


class DescribeVulWhitelistResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeVulWhitelistResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeVulWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWarningMachinesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        lang: str = None,
        machine_name: str = None,
        page_size: int = None,
        risk_id: int = None,
        source_ip: str = None,
        strategy_id: int = None,
        uuids: str = None,
    ):
        self.current_page = current_page
        self.lang = lang
        self.machine_name = machine_name
        self.page_size = page_size
        self.risk_id = risk_id
        self.source_ip = source_ip
        self.strategy_id = strategy_id
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.machine_name is not None:
            result['MachineName'] = self.machine_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MachineName') is not None:
            self.machine_name = m.get('MachineName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeWarningMachinesResponseBodyWarningMachines(TeaModel):
    def __init__(
        self,
        high_warning_count: int = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        low_warning_count: int = None,
        medium_warning_count: int = None,
        pass_count: int = None,
        port_open: bool = None,
        region_id: str = None,
        status: int = None,
        uuid: str = None,
    ):
        self.high_warning_count = high_warning_count
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.low_warning_count = low_warning_count
        self.medium_warning_count = medium_warning_count
        self.pass_count = pass_count
        self.port_open = port_open
        self.region_id = region_id
        self.status = status
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.high_warning_count is not None:
            result['HighWarningCount'] = self.high_warning_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.low_warning_count is not None:
            result['LowWarningCount'] = self.low_warning_count
        if self.medium_warning_count is not None:
            result['MediumWarningCount'] = self.medium_warning_count
        if self.pass_count is not None:
            result['PassCount'] = self.pass_count
        if self.port_open is not None:
            result['PortOpen'] = self.port_open
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HighWarningCount') is not None:
            self.high_warning_count = m.get('HighWarningCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LowWarningCount') is not None:
            self.low_warning_count = m.get('LowWarningCount')
        if m.get('MediumWarningCount') is not None:
            self.medium_warning_count = m.get('MediumWarningCount')
        if m.get('PassCount') is not None:
            self.pass_count = m.get('PassCount')
        if m.get('PortOpen') is not None:
            self.port_open = m.get('PortOpen')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeWarningMachinesResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        warning_machines: List[DescribeWarningMachinesResponseBodyWarningMachines] = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count
        self.warning_machines = warning_machines

    def validate(self):
        if self.warning_machines:
            for k in self.warning_machines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['WarningMachines'] = []
        if self.warning_machines is not None:
            for k in self.warning_machines:
                result['WarningMachines'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.warning_machines = []
        if m.get('WarningMachines') is not None:
            for k in m.get('WarningMachines'):
                temp_model = DescribeWarningMachinesResponseBodyWarningMachines()
                self.warning_machines.append(temp_model.from_map(k))
        return self


class DescribeWarningMachinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeWarningMachinesResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeWarningMachinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWebLockBindListRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        lang: str = None,
        page_size: int = None,
        remark: str = None,
        source_ip: str = None,
        status: str = None,
    ):
        self.current_page = current_page
        self.lang = lang
        self.page_size = page_size
        self.remark = remark
        self.source_ip = source_ip
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeWebLockBindListResponseBodyBindList(TeaModel):
    def __init__(
        self,
        audit_count: str = None,
        block_count: str = None,
        dir_count: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        os: str = None,
        percent: int = None,
        service_code: str = None,
        service_detail: str = None,
        service_status: str = None,
        status: str = None,
        uuid: str = None,
    ):
        self.audit_count = audit_count
        self.block_count = block_count
        self.dir_count = dir_count
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.os = os
        self.percent = percent
        self.service_code = service_code
        self.service_detail = service_detail
        self.service_status = service_status
        self.status = status
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.audit_count is not None:
            result['AuditCount'] = self.audit_count
        if self.block_count is not None:
            result['BlockCount'] = self.block_count
        if self.dir_count is not None:
            result['DirCount'] = self.dir_count
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.os is not None:
            result['Os'] = self.os
        if self.percent is not None:
            result['Percent'] = self.percent
        if self.service_code is not None:
            result['ServiceCode'] = self.service_code
        if self.service_detail is not None:
            result['ServiceDetail'] = self.service_detail
        if self.service_status is not None:
            result['ServiceStatus'] = self.service_status
        if self.status is not None:
            result['Status'] = self.status
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuditCount') is not None:
            self.audit_count = m.get('AuditCount')
        if m.get('BlockCount') is not None:
            self.block_count = m.get('BlockCount')
        if m.get('DirCount') is not None:
            self.dir_count = m.get('DirCount')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Percent') is not None:
            self.percent = m.get('Percent')
        if m.get('ServiceCode') is not None:
            self.service_code = m.get('ServiceCode')
        if m.get('ServiceDetail') is not None:
            self.service_detail = m.get('ServiceDetail')
        if m.get('ServiceStatus') is not None:
            self.service_status = m.get('ServiceStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeWebLockBindListResponseBody(TeaModel):
    def __init__(
        self,
        bind_list: List[DescribeWebLockBindListResponseBodyBindList] = None,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.bind_list = bind_list
        self.current_page = current_page
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.bind_list:
            for k in self.bind_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BindList'] = []
        if self.bind_list is not None:
            for k in self.bind_list:
                result['BindList'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bind_list = []
        if m.get('BindList') is not None:
            for k in m.get('BindList'):
                temp_model = DescribeWebLockBindListResponseBodyBindList()
                self.bind_list.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeWebLockBindListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeWebLockBindListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeWebLockBindListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeWebLockConfigListRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
        uuid: str = None,
    ):
        self.lang = lang
        self.source_ip = source_ip
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeWebLockConfigListResponseBodyConfigList(TeaModel):
    def __init__(
        self,
        defence_mode: str = None,
        dir: str = None,
        exclusive_dir: str = None,
        exclusive_file: str = None,
        exclusive_file_type: str = None,
        id: str = None,
        inclusive_file: str = None,
        inclusive_file_type: str = None,
        local_backup_dir: str = None,
        mode: str = None,
        uuid: str = None,
    ):
        self.defence_mode = defence_mode
        self.dir = dir
        self.exclusive_dir = exclusive_dir
        self.exclusive_file = exclusive_file
        self.exclusive_file_type = exclusive_file_type
        self.id = id
        self.inclusive_file = inclusive_file
        self.inclusive_file_type = inclusive_file_type
        self.local_backup_dir = local_backup_dir
        self.mode = mode
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.defence_mode is not None:
            result['DefenceMode'] = self.defence_mode
        if self.dir is not None:
            result['Dir'] = self.dir
        if self.exclusive_dir is not None:
            result['ExclusiveDir'] = self.exclusive_dir
        if self.exclusive_file is not None:
            result['ExclusiveFile'] = self.exclusive_file
        if self.exclusive_file_type is not None:
            result['ExclusiveFileType'] = self.exclusive_file_type
        if self.id is not None:
            result['Id'] = self.id
        if self.inclusive_file is not None:
            result['InclusiveFile'] = self.inclusive_file
        if self.inclusive_file_type is not None:
            result['InclusiveFileType'] = self.inclusive_file_type
        if self.local_backup_dir is not None:
            result['LocalBackupDir'] = self.local_backup_dir
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefenceMode') is not None:
            self.defence_mode = m.get('DefenceMode')
        if m.get('Dir') is not None:
            self.dir = m.get('Dir')
        if m.get('ExclusiveDir') is not None:
            self.exclusive_dir = m.get('ExclusiveDir')
        if m.get('ExclusiveFile') is not None:
            self.exclusive_file = m.get('ExclusiveFile')
        if m.get('ExclusiveFileType') is not None:
            self.exclusive_file_type = m.get('ExclusiveFileType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InclusiveFile') is not None:
            self.inclusive_file = m.get('InclusiveFile')
        if m.get('InclusiveFileType') is not None:
            self.inclusive_file_type = m.get('InclusiveFileType')
        if m.get('LocalBackupDir') is not None:
            self.local_backup_dir = m.get('LocalBackupDir')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeWebLockConfigListResponseBody(TeaModel):
    def __init__(
        self,
        config_list: List[DescribeWebLockConfigListResponseBodyConfigList] = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.config_list = config_list
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.config_list:
            for k in self.config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ConfigList'] = []
        if self.config_list is not None:
            for k in self.config_list:
                result['ConfigList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.config_list = []
        if m.get('ConfigList') is not None:
            for k in m.get('ConfigList'):
                temp_model = DescribeWebLockConfigListResponseBodyConfigList()
                self.config_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeWebLockConfigListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: DescribeWebLockConfigListResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = DescribeWebLockConfigListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportRecordRequest(TeaModel):
    def __init__(
        self,
        export_type: str = None,
        lang: str = None,
        params: str = None,
    ):
        self.export_type = export_type
        self.lang = lang
        self.params = params

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_type is not None:
            result['ExportType'] = self.export_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.params is not None:
            result['Params'] = self.params
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExportType') is not None:
            self.export_type = m.get('ExportType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        return self


class ExportRecordResponseBody(TeaModel):
    def __init__(
        self,
        file_name: str = None,
        id: int = None,
        request_id: str = None,
    ):
        self.file_name = file_name
        self.id = id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ExportRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ExportRecordResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportVulRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        attach_types: str = None,
        dealed: str = None,
        group_id: str = None,
        lang: str = None,
        necessity: str = None,
        search_tags: str = None,
        type: str = None,
        uuids: str = None,
        vpc_instance_ids: str = None,
    ):
        self.alias_name = alias_name
        self.attach_types = attach_types
        self.dealed = dealed
        self.group_id = group_id
        self.lang = lang
        self.necessity = necessity
        self.search_tags = search_tags
        self.type = type
        self.uuids = uuids
        self.vpc_instance_ids = vpc_instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.attach_types is not None:
            result['AttachTypes'] = self.attach_types
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.search_tags is not None:
            result['SearchTags'] = self.search_tags
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        if self.vpc_instance_ids is not None:
            result['VpcInstanceIds'] = self.vpc_instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AttachTypes') is not None:
            self.attach_types = m.get('AttachTypes')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('SearchTags') is not None:
            self.search_tags = m.get('SearchTags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        if m.get('VpcInstanceIds') is not None:
            self.vpc_instance_ids = m.get('VpcInstanceIds')
        return self


class ExportVulResponseBody(TeaModel):
    def __init__(
        self,
        file_name: str = None,
        id: int = None,
        request_id: str = None,
    ):
        self.file_name = file_name
        self.id = id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ExportVulResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ExportVulResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportVulResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExportWarningRequest(TeaModel):
    def __init__(
        self,
        dealed: str = None,
        export_type: str = None,
        is_cleartext_pwd: int = None,
        is_summary_export: int = None,
        lang: str = None,
        risk_ids: str = None,
        risk_levels: str = None,
        risk_name: str = None,
        source_ip: str = None,
        status_list: str = None,
        strategy_id: int = None,
        sub_type_names: str = None,
        type_name: str = None,
        type_names: str = None,
        uuids: str = None,
    ):
        self.dealed = dealed
        self.export_type = export_type
        self.is_cleartext_pwd = is_cleartext_pwd
        self.is_summary_export = is_summary_export
        self.lang = lang
        self.risk_ids = risk_ids
        self.risk_levels = risk_levels
        self.risk_name = risk_name
        self.source_ip = source_ip
        self.status_list = status_list
        self.strategy_id = strategy_id
        self.sub_type_names = sub_type_names
        self.type_name = type_name
        self.type_names = type_names
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.export_type is not None:
            result['ExportType'] = self.export_type
        if self.is_cleartext_pwd is not None:
            result['IsCleartextPwd'] = self.is_cleartext_pwd
        if self.is_summary_export is not None:
            result['IsSummaryExport'] = self.is_summary_export
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.risk_ids is not None:
            result['RiskIds'] = self.risk_ids
        if self.risk_levels is not None:
            result['RiskLevels'] = self.risk_levels
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.sub_type_names is not None:
            result['SubTypeNames'] = self.sub_type_names
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        if self.type_names is not None:
            result['TypeNames'] = self.type_names
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('ExportType') is not None:
            self.export_type = m.get('ExportType')
        if m.get('IsCleartextPwd') is not None:
            self.is_cleartext_pwd = m.get('IsCleartextPwd')
        if m.get('IsSummaryExport') is not None:
            self.is_summary_export = m.get('IsSummaryExport')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RiskIds') is not None:
            self.risk_ids = m.get('RiskIds')
        if m.get('RiskLevels') is not None:
            self.risk_levels = m.get('RiskLevels')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('SubTypeNames') is not None:
            self.sub_type_names = m.get('SubTypeNames')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        if m.get('TypeNames') is not None:
            self.type_names = m.get('TypeNames')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class ExportWarningResponseBody(TeaModel):
    def __init__(
        self,
        file_name: str = None,
        id: int = None,
        request_id: str = None,
    ):
        self.file_name = file_name
        self.id = id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ExportWarningResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ExportWarningResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ExportWarningResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FixCheckWarningsRequest(TeaModel):
    def __init__(
        self,
        check_params: str = None,
        lang: str = None,
        risk_id: int = None,
        source_ip: str = None,
        uuids: str = None,
    ):
        self.check_params = check_params
        self.lang = lang
        self.risk_id = risk_id
        self.source_ip = source_ip
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_params is not None:
            result['CheckParams'] = self.check_params
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckParams') is not None:
            self.check_params = m.get('CheckParams')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class FixCheckWarningsResponseBody(TeaModel):
    def __init__(
        self,
        batch_id: int = None,
        request_id: str = None,
    ):
        self.batch_id = batch_id
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_id is not None:
            result['BatchId'] = self.batch_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchId') is not None:
            self.batch_id = m.get('BatchId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class FixCheckWarningsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: FixCheckWarningsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = FixCheckWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetBackupStorageCountResponseBodyBackupStorageCount(TeaModel):
    def __init__(
        self,
        buy_storage_byte: int = None,
        ecs_usage_storage_byte: int = None,
        overflow: int = None,
        uni_usage_storage_byte: int = None,
        usage_storage_byte: int = None,
    ):
        self.buy_storage_byte = buy_storage_byte
        self.ecs_usage_storage_byte = ecs_usage_storage_byte
        self.overflow = overflow
        self.uni_usage_storage_byte = uni_usage_storage_byte
        self.usage_storage_byte = usage_storage_byte

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.buy_storage_byte is not None:
            result['BuyStorageByte'] = self.buy_storage_byte
        if self.ecs_usage_storage_byte is not None:
            result['EcsUsageStorageByte'] = self.ecs_usage_storage_byte
        if self.overflow is not None:
            result['Overflow'] = self.overflow
        if self.uni_usage_storage_byte is not None:
            result['UniUsageStorageByte'] = self.uni_usage_storage_byte
        if self.usage_storage_byte is not None:
            result['UsageStorageByte'] = self.usage_storage_byte
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuyStorageByte') is not None:
            self.buy_storage_byte = m.get('BuyStorageByte')
        if m.get('EcsUsageStorageByte') is not None:
            self.ecs_usage_storage_byte = m.get('EcsUsageStorageByte')
        if m.get('Overflow') is not None:
            self.overflow = m.get('Overflow')
        if m.get('UniUsageStorageByte') is not None:
            self.uni_usage_storage_byte = m.get('UniUsageStorageByte')
        if m.get('UsageStorageByte') is not None:
            self.usage_storage_byte = m.get('UsageStorageByte')
        return self


class GetBackupStorageCountResponseBody(TeaModel):
    def __init__(
        self,
        backup_storage_count: GetBackupStorageCountResponseBodyBackupStorageCount = None,
        request_id: str = None,
    ):
        self.backup_storage_count = backup_storage_count
        self.request_id = request_id

    def validate(self):
        if self.backup_storage_count:
            self.backup_storage_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_storage_count is not None:
            result['BackupStorageCount'] = self.backup_storage_count.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupStorageCount') is not None:
            temp_model = GetBackupStorageCountResponseBodyBackupStorageCount()
            self.backup_storage_count = temp_model.from_map(m['BackupStorageCount'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetBackupStorageCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetBackupStorageCountResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetBackupStorageCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSuspiciousStatisticsRequest(TeaModel):
    def __init__(
        self,
        group_id_list: str = None,
        source_ip: str = None,
    ):
        self.group_id_list = group_id_list
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class GetSuspiciousStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        remind_count: int = None,
        request_id: str = None,
        serious_count: int = None,
        suspicious_count: int = None,
        total_count: int = None,
    ):
        self.remind_count = remind_count
        self.request_id = request_id
        self.serious_count = serious_count
        self.suspicious_count = suspicious_count
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_count is not None:
            result['RemindCount'] = self.remind_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.serious_count is not None:
            result['SeriousCount'] = self.serious_count
        if self.suspicious_count is not None:
            result['SuspiciousCount'] = self.suspicious_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemindCount') is not None:
            self.remind_count = m.get('RemindCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SeriousCount') is not None:
            self.serious_count = m.get('SeriousCount')
        if m.get('SuspiciousCount') is not None:
            self.suspicious_count = m.get('SuspiciousCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetSuspiciousStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetSuspiciousStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetSuspiciousStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetVulStatisticsRequest(TeaModel):
    def __init__(
        self,
        group_id_list: str = None,
        source_ip: str = None,
        type_list: str = None,
    ):
        self.group_id_list = group_id_list
        self.source_ip = source_ip
        self.type_list = type_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type_list is not None:
            result['TypeList'] = self.type_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TypeList') is not None:
            self.type_list = m.get('TypeList')
        return self


class GetVulStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        vul_asap_sum: int = None,
        vul_later_sum: int = None,
        vul_nntf_sum: int = None,
    ):
        self.request_id = request_id
        self.vul_asap_sum = vul_asap_sum
        self.vul_later_sum = vul_later_sum
        self.vul_nntf_sum = vul_nntf_sum

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vul_asap_sum is not None:
            result['VulAsapSum'] = self.vul_asap_sum
        if self.vul_later_sum is not None:
            result['VulLaterSum'] = self.vul_later_sum
        if self.vul_nntf_sum is not None:
            result['VulNntfSum'] = self.vul_nntf_sum
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VulAsapSum') is not None:
            self.vul_asap_sum = m.get('VulAsapSum')
        if m.get('VulLaterSum') is not None:
            self.vul_later_sum = m.get('VulLaterSum')
        if m.get('VulNntfSum') is not None:
            self.vul_nntf_sum = m.get('VulNntfSum')
        return self


class GetVulStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: GetVulStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = GetVulStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HandleSecurityEventsRequest(TeaModel):
    def __init__(
        self,
        mark_batch: str = None,
        mark_miss_param: str = None,
        operation_code: str = None,
        operation_params: str = None,
        security_event_ids: List[str] = None,
        source_ip: str = None,
    ):
        self.mark_batch = mark_batch
        self.mark_miss_param = mark_miss_param
        self.operation_code = operation_code
        self.operation_params = operation_params
        self.security_event_ids = security_event_ids
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mark_batch is not None:
            result['MarkBatch'] = self.mark_batch
        if self.mark_miss_param is not None:
            result['MarkMissParam'] = self.mark_miss_param
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_params is not None:
            result['OperationParams'] = self.operation_params
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MarkBatch') is not None:
            self.mark_batch = m.get('MarkBatch')
        if m.get('MarkMissParam') is not None:
            self.mark_miss_param = m.get('MarkMissParam')
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationParams') is not None:
            self.operation_params = m.get('OperationParams')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class HandleSecurityEventsResponseBodyHandleSecurityEventsResponse(TeaModel):
    def __init__(
        self,
        task_id: int = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class HandleSecurityEventsResponseBody(TeaModel):
    def __init__(
        self,
        handle_security_events_response: HandleSecurityEventsResponseBodyHandleSecurityEventsResponse = None,
        request_id: str = None,
    ):
        self.handle_security_events_response = handle_security_events_response
        self.request_id = request_id

    def validate(self):
        if self.handle_security_events_response:
            self.handle_security_events_response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.handle_security_events_response is not None:
            result['HandleSecurityEventsResponse'] = self.handle_security_events_response.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HandleSecurityEventsResponse') is not None:
            temp_model = HandleSecurityEventsResponseBodyHandleSecurityEventsResponse()
            self.handle_security_events_response = temp_model.from_map(m['HandleSecurityEventsResponse'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class HandleSecurityEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: HandleSecurityEventsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = HandleSecurityEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HandleSimilarSecurityEventsRequest(TeaModel):
    def __init__(
        self,
        mark_miss_param: str = None,
        operation_code: str = None,
        operation_params: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        task_id: int = None,
    ):
        self.mark_miss_param = mark_miss_param
        self.operation_code = operation_code
        self.operation_params = operation_params
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mark_miss_param is not None:
            result['MarkMissParam'] = self.mark_miss_param
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_params is not None:
            result['OperationParams'] = self.operation_params
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MarkMissParam') is not None:
            self.mark_miss_param = m.get('MarkMissParam')
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationParams') is not None:
            self.operation_params = m.get('OperationParams')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class HandleSimilarSecurityEventsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class HandleSimilarSecurityEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: HandleSimilarSecurityEventsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = HandleSimilarSecurityEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class IgnoreHcCheckWarningsRequest(TeaModel):
    def __init__(
        self,
        check_ids: str = None,
        check_warning_ids: str = None,
        reason: str = None,
        risk_id: str = None,
        source_ip: str = None,
        type: int = None,
    ):
        self.check_ids = check_ids
        self.check_warning_ids = check_warning_ids
        self.reason = reason
        self.risk_id = risk_id
        self.source_ip = source_ip
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_ids is not None:
            result['CheckIds'] = self.check_ids
        if self.check_warning_ids is not None:
            result['CheckWarningIds'] = self.check_warning_ids
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckIds') is not None:
            self.check_ids = m.get('CheckIds')
        if m.get('CheckWarningIds') is not None:
            self.check_warning_ids = m.get('CheckWarningIds')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class IgnoreHcCheckWarningsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class IgnoreHcCheckWarningsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: IgnoreHcCheckWarningsResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = IgnoreHcCheckWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InstallBackupClientRequest(TeaModel):
    def __init__(
        self,
        policy_version: str = None,
        uuid: str = None,
        uuid_list: List[str] = None,
    ):
        self.policy_version = policy_version
        self.uuid = uuid
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class InstallBackupClientResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class InstallBackupClientResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: InstallBackupClientResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InstallBackupClientResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InstallCloudMonitorRequest(TeaModel):
    def __init__(
        self,
        agent_access_key: str = None,
        agent_secret_key: str = None,
        argus_version: str = None,
        instance_id_list: List[str] = None,
        uuid_list: List[str] = None,
    ):
        # 非阿里云主机安装云监控插件时所需要的AccessKey
        self.agent_access_key = agent_access_key
        # 非阿里云主机安装云监控插件时所需要的AccessSecret
        self.agent_secret_key = agent_secret_key
        # 云监控版本
        self.argus_version = argus_version
        # 实例 instanceId
        self.instance_id_list = instance_id_list
        # uuid 列表
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_access_key is not None:
            result['AgentAccessKey'] = self.agent_access_key
        if self.agent_secret_key is not None:
            result['AgentSecretKey'] = self.agent_secret_key
        if self.argus_version is not None:
            result['ArgusVersion'] = self.argus_version
        if self.instance_id_list is not None:
            result['InstanceIdList'] = self.instance_id_list
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentAccessKey') is not None:
            self.agent_access_key = m.get('AgentAccessKey')
        if m.get('AgentSecretKey') is not None:
            self.agent_secret_key = m.get('AgentSecretKey')
        if m.get('ArgusVersion') is not None:
            self.argus_version = m.get('ArgusVersion')
        if m.get('InstanceIdList') is not None:
            self.instance_id_list = m.get('InstanceIdList')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class InstallCloudMonitorResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InstallCloudMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: InstallCloudMonitorResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = InstallCloudMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyAntiBruteForceRuleRequest(TeaModel):
    def __init__(
        self,
        default_rule: bool = None,
        fail_count: int = None,
        forbidden_time: int = None,
        id: int = None,
        name: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        span: int = None,
        uuid_list: List[str] = None,
    ):
        self.default_rule = default_rule
        self.fail_count = fail_count
        self.forbidden_time = forbidden_time
        self.id = id
        self.name = name
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip
        self.span = span
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class ModifyAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyAntiBruteForceRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyAntiBruteForceRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyAssetGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        source_ip: str = None,
        uuids: str = None,
    ):
        self.group_id = group_id
        self.source_ip = source_ip
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class ModifyAssetGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyAssetGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyAssetGroupResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyAssetGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
        name: str = None,
        policy: Dict[str, Any] = None,
        policy_region_id: str = None,
        policy_version: str = None,
        uuid_list: List[str] = None,
    ):
        self.id = id
        self.name = name
        self.policy = policy
        self.policy_region_id = policy_region_id
        self.policy_version = policy_version
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class ModifyBackupPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
        name: str = None,
        policy_shrink: str = None,
        policy_region_id: str = None,
        policy_version: str = None,
        uuid_list: List[str] = None,
    ):
        self.id = id
        self.name = name
        self.policy_shrink = policy_shrink
        self.policy_region_id = policy_region_id
        self.policy_version = policy_version
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_shrink is not None:
            result['Policy'] = self.policy_shrink
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy_shrink = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class ModifyBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyBackupPolicyStatusRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
        policy_version: str = None,
        status: str = None,
    ):
        self.id = id
        self.policy_version = policy_version
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ModifyBackupPolicyStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyBackupPolicyStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyBackupPolicyStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyBackupPolicyStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyCreateVulWhitelistRequest(TeaModel):
    def __init__(
        self,
        reason: str = None,
        target_info: str = None,
        whitelist: str = None,
    ):
        self.reason = reason
        self.target_info = target_info
        self.whitelist = whitelist

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.target_info is not None:
            result['TargetInfo'] = self.target_info
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('TargetInfo') is not None:
            self.target_info = m.get('TargetInfo')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class ModifyCreateVulWhitelistResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyCreateVulWhitelistResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyCreateVulWhitelistResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyCreateVulWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyEmgVulSubmitRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        name: str = None,
        user_agreement: str = None,
    ):
        self.lang = lang
        self.name = name
        self.user_agreement = user_agreement

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.user_agreement is not None:
            result['UserAgreement'] = self.user_agreement
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('UserAgreement') is not None:
            self.user_agreement = m.get('UserAgreement')
        return self


class ModifyEmgVulSubmitResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyEmgVulSubmitResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyEmgVulSubmitResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyEmgVulSubmitResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyGroupPropertyRequest(TeaModel):
    def __init__(
        self,
        data: str = None,
    ):
        self.data = data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        return self


class ModifyGroupPropertyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyGroupPropertyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyGroupPropertyResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyGroupPropertyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyInstanceAntiBruteForceRuleRequest(TeaModel):
    def __init__(
        self,
        new_rule_id: int = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        uuid: str = None,
    ):
        self.new_rule_id = new_rule_id
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.new_rule_id is not None:
            result['NewRuleId'] = self.new_rule_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NewRuleId') is not None:
            self.new_rule_id = m.get('NewRuleId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class ModifyInstanceAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyInstanceAntiBruteForceRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyInstanceAntiBruteForceRuleResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyInstanceAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyLoginBaseConfigRequest(TeaModel):
    def __init__(
        self,
        config: str = None,
        target: str = None,
        type: str = None,
    ):
        self.config = config
        self.target = target
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.target is not None:
            result['Target'] = self.target
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ModifyLoginBaseConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyLoginBaseConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyLoginBaseConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyLoginBaseConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyLoginSwitchConfigRequest(TeaModel):
    def __init__(
        self,
        item: str = None,
        status: int = None,
    ):
        self.item = item
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item is not None:
            result['Item'] = self.item
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ModifyLoginSwitchConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyLoginSwitchConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyLoginSwitchConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyLoginSwitchConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyOpenLogShipperRequest(TeaModel):
    def __init__(
        self,
        from_: str = None,
    ):
        self.from_ = from_

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        return self


class ModifyOpenLogShipperResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyOpenLogShipperResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyOpenLogShipperResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyOpenLogShipperResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyOperateVulRequest(TeaModel):
    def __init__(
        self,
        info: str = None,
        operate_type: str = None,
        reason: str = None,
        type: str = None,
    ):
        self.info = info
        self.operate_type = operate_type
        self.reason = reason
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ModifyOperateVulResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyOperateVulResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyOperateVulResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyOperateVulResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyPropertyScheduleConfigRequest(TeaModel):
    def __init__(
        self,
        schedule_time: str = None,
        type: str = None,
    ):
        self.schedule_time = schedule_time
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.schedule_time is not None:
            result['ScheduleTime'] = self.schedule_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ScheduleTime') is not None:
            self.schedule_time = m.get('ScheduleTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class ModifyPropertyScheduleConfigResponseBody(TeaModel):
    def __init__(
        self,
        modify_result: bool = None,
        request_id: str = None,
    ):
        self.modify_result = modify_result
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.modify_result is not None:
            result['ModifyResult'] = self.modify_result
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ModifyResult') is not None:
            self.modify_result = m.get('ModifyResult')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyPropertyScheduleConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyPropertyScheduleConfigResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyPropertyScheduleConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyPushAllTaskRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        tasks: str = None,
        uuids: str = None,
    ):
        self.source_ip = source_ip
        self.tasks = tasks
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.tasks is not None:
            result['Tasks'] = self.tasks
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Tasks') is not None:
            self.tasks = m.get('Tasks')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class ModifyPushAllTaskResponseBodyPushTaskRspPushTaskResultList(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        instance_id: str = None,
        instance_name: str = None,
        ip: str = None,
        message: str = None,
        online: bool = None,
        os_version: str = None,
        region: str = None,
        success: bool = None,
        uuid: str = None,
    ):
        self.group_id = group_id
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.ip = ip
        self.message = message
        self.online = online
        self.os_version = os_version
        self.region = region
        self.success = success
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.message is not None:
            result['Message'] = self.message
        if self.online is not None:
            result['Online'] = self.online
        if self.os_version is not None:
            result['OsVersion'] = self.os_version
        if self.region is not None:
            result['Region'] = self.region
        if self.success is not None:
            result['Success'] = self.success
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Online') is not None:
            self.online = m.get('Online')
        if m.get('OsVersion') is not None:
            self.os_version = m.get('OsVersion')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class ModifyPushAllTaskResponseBodyPushTaskRsp(TeaModel):
    def __init__(
        self,
        push_task_result_list: List[ModifyPushAllTaskResponseBodyPushTaskRspPushTaskResultList] = None,
    ):
        self.push_task_result_list = push_task_result_list

    def validate(self):
        if self.push_task_result_list:
            for k in self.push_task_result_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PushTaskResultList'] = []
        if self.push_task_result_list is not None:
            for k in self.push_task_result_list:
                result['PushTaskResultList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.push_task_result_list = []
        if m.get('PushTaskResultList') is not None:
            for k in m.get('PushTaskResultList'):
                temp_model = ModifyPushAllTaskResponseBodyPushTaskRspPushTaskResultList()
                self.push_task_result_list.append(temp_model.from_map(k))
        return self


class ModifyPushAllTaskResponseBody(TeaModel):
    def __init__(
        self,
        push_task_rsp: ModifyPushAllTaskResponseBodyPushTaskRsp = None,
        request_id: str = None,
    ):
        self.push_task_rsp = push_task_rsp
        self.request_id = request_id

    def validate(self):
        if self.push_task_rsp:
            self.push_task_rsp.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.push_task_rsp is not None:
            result['PushTaskRsp'] = self.push_task_rsp.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PushTaskRsp') is not None:
            temp_model = ModifyPushAllTaskResponseBodyPushTaskRsp()
            self.push_task_rsp = temp_model.from_map(m['PushTaskRsp'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyPushAllTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyPushAllTaskResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyPushAllTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyRiskCheckStatusRequest(TeaModel):
    def __init__(
        self,
        item_id: int = None,
        lang: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        status: str = None,
        task_id: int = None,
    ):
        self.item_id = item_id
        self.lang = lang
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip
        self.status = status
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.item_id is not None:
            result['ItemId'] = self.item_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ItemId') is not None:
            self.item_id = m.get('ItemId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ModifyRiskCheckStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyRiskCheckStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyRiskCheckStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyRiskCheckStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyRiskSingleResultStatusRequest(TeaModel):
    def __init__(
        self,
        ids: List[str] = None,
        lang: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        status: str = None,
        task_id: int = None,
    ):
        self.ids = ids
        self.lang = lang
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip
        self.status = status
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ModifyRiskSingleResultStatusResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyRiskSingleResultStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        body: ModifyRiskSingleResultStatusResponseBody = None,
    ):
        self.headers = headers
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('body') is not None:
            temp_model = ModifyRiskSingleResultStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifySecurityCheckScheduleConfigRequest(TeaModel):
    def __init__(
        self,
        days_of_week: str = None,
        end_time: int = None,
        lang: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        start_time: int = None,
    ):
        self.days_of_week = days_of_week
        self.end_time = end_time
        self.lang = lang
        self.resource_owner_id = resource_owner_id
        self.source_ip = source_ip
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.days_of_week is not None:
            result['DaysOfWeek'] = self.days_of_week
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DaysOfWeek') is not None:
            self.days_of_week = m.get('DaysOfWeek')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ModifySecurityCheckScheduleConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,