/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.shaded.apache.http.message;

import com.amazon.redshift.shaded.apache.http.Header;
import com.amazon.redshift.shaded.apache.http.HeaderElement;
import com.amazon.redshift.shaded.apache.http.ParseException;
import com.amazon.redshift.shaded.apache.http.annotation.Immutable;
import com.amazon.redshift.shaded.apache.http.message.BasicHeaderValueParser;
import com.amazon.redshift.shaded.apache.http.message.BasicLineFormatter;
import com.amazon.redshift.shaded.apache.http.util.Args;
import java.io.Serializable;

@Immutable
public class BasicHeader
implements Header,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5427236326487562174L;
    private final String name;
    private final String value;

    public BasicHeader(String name, String value) {
        this.name = Args.notNull(name, "Name");
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return BasicLineFormatter.INSTANCE.formatHeader(null, this).toString();
    }

    @Override
    public HeaderElement[] getElements() throws ParseException {
        if (this.value != null) {
            return BasicHeaderValueParser.parseElements(this.value, null);
        }
        return new HeaderElement[0];
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

