/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.services.securitytoken;

import com.amazon.redshift.amazonaws.ClientConfiguration;
import com.amazon.redshift.amazonaws.annotation.ThreadSafe;
import com.amazon.redshift.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazon.redshift.amazonaws.client.AwsAsyncClientParams;
import com.amazon.redshift.amazonaws.handlers.AsyncHandler;
import com.amazon.redshift.amazonaws.services.securitytoken.AWSSecurityTokenServiceAsync;
import com.amazon.redshift.amazonaws.services.securitytoken.AWSSecurityTokenServiceAsyncClientBuilder;
import com.amazon.redshift.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazon.redshift.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazon.redshift.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazon.redshift.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import com.amazon.redshift.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLResult;
import com.amazon.redshift.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.amazon.redshift.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import com.amazon.redshift.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageRequest;
import com.amazon.redshift.amazonaws.services.securitytoken.model.DecodeAuthorizationMessageResult;
import com.amazon.redshift.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.amazon.redshift.amazonaws.services.securitytoken.model.GetCallerIdentityResult;
import com.amazon.redshift.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import com.amazon.redshift.amazonaws.services.securitytoken.model.GetFederationTokenResult;
import com.amazon.redshift.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.amazon.redshift.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSecurityTokenServiceAsyncClient
extends AWSSecurityTokenServiceClient
implements AWSSecurityTokenServiceAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSSecurityTokenServiceAsyncClientBuilder asyncBuilder() {
        return AWSSecurityTokenServiceAsyncClientBuilder.standard();
    }

    AWSSecurityTokenServiceAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssumeRoleResult> assumeRoleAsync(AssumeRoleRequest request) {
        return this.assumeRoleAsync(request, null);
    }

    @Override
    public Future<AssumeRoleResult> assumeRoleAsync(AssumeRoleRequest request, final AsyncHandler<AssumeRoleRequest, AssumeRoleResult> asyncHandler) {
        final AssumeRoleRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssumeRoleResult>(){

            @Override
            public AssumeRoleResult call() throws Exception {
                AssumeRoleResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeAssumeRole(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssumeRoleWithSAMLResult> assumeRoleWithSAMLAsync(AssumeRoleWithSAMLRequest request) {
        return this.assumeRoleWithSAMLAsync(request, null);
    }

    @Override
    public Future<AssumeRoleWithSAMLResult> assumeRoleWithSAMLAsync(AssumeRoleWithSAMLRequest request, final AsyncHandler<AssumeRoleWithSAMLRequest, AssumeRoleWithSAMLResult> asyncHandler) {
        final AssumeRoleWithSAMLRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssumeRoleWithSAMLResult>(){

            @Override
            public AssumeRoleWithSAMLResult call() throws Exception {
                AssumeRoleWithSAMLResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeAssumeRoleWithSAML(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssumeRoleWithWebIdentityResult> assumeRoleWithWebIdentityAsync(AssumeRoleWithWebIdentityRequest request) {
        return this.assumeRoleWithWebIdentityAsync(request, null);
    }

    @Override
    public Future<AssumeRoleWithWebIdentityResult> assumeRoleWithWebIdentityAsync(AssumeRoleWithWebIdentityRequest request, final AsyncHandler<AssumeRoleWithWebIdentityRequest, AssumeRoleWithWebIdentityResult> asyncHandler) {
        final AssumeRoleWithWebIdentityRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssumeRoleWithWebIdentityResult>(){

            @Override
            public AssumeRoleWithWebIdentityResult call() throws Exception {
                AssumeRoleWithWebIdentityResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeAssumeRoleWithWebIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DecodeAuthorizationMessageResult> decodeAuthorizationMessageAsync(DecodeAuthorizationMessageRequest request) {
        return this.decodeAuthorizationMessageAsync(request, null);
    }

    @Override
    public Future<DecodeAuthorizationMessageResult> decodeAuthorizationMessageAsync(DecodeAuthorizationMessageRequest request, final AsyncHandler<DecodeAuthorizationMessageRequest, DecodeAuthorizationMessageResult> asyncHandler) {
        final DecodeAuthorizationMessageRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DecodeAuthorizationMessageResult>(){

            @Override
            public DecodeAuthorizationMessageResult call() throws Exception {
                DecodeAuthorizationMessageResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeDecodeAuthorizationMessage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCallerIdentityResult> getCallerIdentityAsync(GetCallerIdentityRequest request) {
        return this.getCallerIdentityAsync(request, null);
    }

    @Override
    public Future<GetCallerIdentityResult> getCallerIdentityAsync(GetCallerIdentityRequest request, final AsyncHandler<GetCallerIdentityRequest, GetCallerIdentityResult> asyncHandler) {
        final GetCallerIdentityRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetCallerIdentityResult>(){

            @Override
            public GetCallerIdentityResult call() throws Exception {
                GetCallerIdentityResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeGetCallerIdentity(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(GetFederationTokenRequest request) {
        return this.getFederationTokenAsync(request, null);
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(GetFederationTokenRequest request, final AsyncHandler<GetFederationTokenRequest, GetFederationTokenResult> asyncHandler) {
        final GetFederationTokenRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFederationTokenResult>(){

            @Override
            public GetFederationTokenResult call() throws Exception {
                GetFederationTokenResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeGetFederationToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(GetSessionTokenRequest request) {
        return this.getSessionTokenAsync(request, null);
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(GetSessionTokenRequest request, final AsyncHandler<GetSessionTokenRequest, GetSessionTokenResult> asyncHandler) {
        final GetSessionTokenRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSessionTokenResult>(){

            @Override
            public GetSessionTokenResult call() throws Exception {
                GetSessionTokenResult result = null;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.executeGetSessionToken(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync() {
        return this.getSessionTokenAsync(new GetSessionTokenRequest());
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(AsyncHandler<GetSessionTokenRequest, GetSessionTokenResult> asyncHandler) {
        return this.getSessionTokenAsync(new GetSessionTokenRequest(), asyncHandler);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

