/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.googlebigquery.core;

import com.google.api.services.bigquery.model.ConnectionProperty;
import com.simba.googlebigquery.dsi.core.impl.DSILogger;
import com.simba.googlebigquery.dsi.core.interfaces.IStatement;
import com.simba.googlebigquery.dsi.core.utilities.ConnSettingRequestMap;
import com.simba.googlebigquery.dsi.core.utilities.ConnSettingResponseMap;
import com.simba.googlebigquery.dsi.core.utilities.Variant;
import com.simba.googlebigquery.dsi.exceptions.BadAttrValException;
import com.simba.googlebigquery.dsi.exceptions.BadAuthException;
import com.simba.googlebigquery.dsi.exceptions.IncorrectTypeException;
import com.simba.googlebigquery.dsi.exceptions.NumericOverflowException;
import com.simba.googlebigquery.dsi.exceptions.UtilsException;
import com.simba.googlebigquery.googlebigquery.client.BQClient;
import com.simba.googlebigquery.googlebigquery.client.BQServiceKey;
import com.simba.googlebigquery.googlebigquery.core.BQConnectionOptions;
import com.simba.googlebigquery.googlebigquery.core.BQDriver;
import com.simba.googlebigquery.googlebigquery.core.BQEnvironment;
import com.simba.googlebigquery.googlebigquery.core.BQStatement;
import com.simba.googlebigquery.googlebigquery.exceptions.BQMessageKey;
import com.simba.googlebigquery.googlebigquery.utils.BQCoreUtils;
import com.simba.googlebigquery.jdbc.common.ProductInfoHandler;
import com.simba.googlebigquery.jdbc.core.DSCommonConnection;
import com.simba.googlebigquery.support.ILogger;
import com.simba.googlebigquery.support.LogUtilities;
import com.simba.googlebigquery.support.Warning;
import com.simba.googlebigquery.support.WarningCode;
import com.simba.googlebigquery.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

public class BQConnection
extends DSCommonConnection {
    private static final String LOG_PREFIX_NAME = "BigQuery_connection_";
    private static AtomicInteger s_connectionID = new AtomicInteger(0);
    private static final long DEFAULT_MAX_RESULTS = 10000L;
    private static final long DEFAULT_TIMEOUT_MILLISECONDS = 10000L;
    private static final long MINIMUM_TIMEOUT = 1L;
    private static final int DEFAULT_METADATA_FETCH_THREAD_COUNT = 32;
    private BQClient m_client;
    private ILogger m_conn_logger = this.getConnectionLog();
    private ProductInfoHandler m_productInfoHandler;
    private BQConnectionOptions m_settings;

    protected BQConnection(BQEnvironment bQEnvironment) throws IncorrectTypeException, NumericOverflowException, ErrorException {
        super(bQEnvironment);
        LogUtilities.logFunctionEntrance(this.m_conn_logger, bQEnvironment);
        this.m_settings = new BQConnectionOptions();
        this.setDefaultProperties();
    }

    @Override
    protected void doReset() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        if ((this.m_settings.m_forceHTAPI || this.m_settings.m_enableHighThroughPutAPI) && !this.m_client.getBigQueryStorageClient().isTerminated()) {
            this.m_client.getBigQueryStorageClient().shutdown();
        }
    }

    @Override
    public void connect(ConnSettingRequestMap connSettingRequestMap) throws ErrorException, BadAuthException {
        LogUtilities.logFunctionEntrance(this.m_conn_logger, connSettingRequestMap);
        this.m_productInfoHandler = new ProductInfoHandler("SimbaJDBCDriverforGoogleBigQuery.lic", "Simba JDBC Driver for Google BigQuery", "1.2", BQDriver.class);
        this.m_productInfoHandler.validateLicense();
        this.m_client = new BQClient(this.m_conn_logger, this.m_settings);
        try {
            this.m_settings = this.getConnectionOptions(connSettingRequestMap);
        }
        catch (UtilsException utilsException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_OPTION_GET_ERR.name(), utilsException.getMessage());
        }
        String string = this.m_settings.m_largeResultDataset;
        String string2 = this.m_settings.m_largeResultTable;
        BQConnectionOptions.QueryDialect queryDialect = this.m_settings.m_queryDialect;
        boolean bl = this.m_settings.m_largeResultsEnabled = this.m_settings.m_allowLargeResults && BQConnectionOptions.QueryDialect.BIG_QUERY == queryDialect || BQConnectionOptions.QueryDialect.SQL == queryDialect && (null != string || null != string2);
        if (!this.m_settings.m_largeResultsEnabled) {
            this.m_settings.m_enableHighThroughPutAPI = true;
        }
        if (!BQCoreUtils.isTimestampFallbackSet()) {
            BQCoreUtils.setTimestampFallbackValue(this.m_settings.m_timestampFallback);
            if (this.m_settings.m_timestampFallback) {
                TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
            }
        } else if (BQCoreUtils.getTimestampFallbackValue() != this.m_settings.m_timestampFallback) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_TIMESTAMP_FALLBACK_MISMATCH.name());
        }
        switch (this.m_settings.m_OAuthType) {
            case SERVICE_ACCOUNT: {
                this.m_client.serviceAccountOAuth(this.m_settings.m_OAuthServiceAcctEmail, this.m_settings.m_OAuthServiceKey, this.m_settings.m_trustStoreSettings, this.m_settings.m_proxySettings);
                break;
            }
            case USER_ACCOUNT: {
                this.m_client.userAccountOAuth(this.m_settings.m_trustStoreSettings, this.m_settings.m_proxySettings);
                break;
            }
            case TOKEN: {
                this.m_client.tokenMethodOAuth(this.m_settings.m_OAuthAccessToken, this.m_settings.m_OAuthRefreshToken, this.m_settings.m_OAuthClientId, this.m_settings.m_OAuthClientSecret, this.m_settings.m_trustStoreSettings, this.m_settings.m_proxySettings);
                break;
            }
            case APPLICATION_DEFAULT_CREDENTIALS: {
                this.m_client.applicationDefaultOAuth(this.m_settings.m_trustStoreSettings, this.m_settings.m_proxySettings);
            }
        }
    }

    @Override
    public IStatement createStatement() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        return new BQStatement(this);
    }

    @Override
    public void disconnect() {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
    }

    public BQClient getClient() {
        return this.m_client;
    }

    @Override
    public ILogger getConnectionLog() {
        if (null == this.m_conn_logger) {
            this.m_conn_logger = new DSILogger(LOG_PREFIX_NAME + Integer.toString(s_connectionID.getAndIncrement()));
            this.m_conn_logger.setLocale(this.getLocale());
        }
        return this.m_conn_logger;
    }

    public BQConnectionOptions getSettings() {
        return this.m_settings;
    }

    @Override
    public ConnSettingResponseMap updateConnectionSettings(ConnSettingRequestMap connSettingRequestMap) throws BadAuthException, ErrorException {
        connSettingRequestMap.setHiddenKey("OAuthAccessToken", "OAuthRefreshToken", "OAuthClientId", "OAuthClientSecret", "OAuthPvtKeyPath");
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), connSettingRequestMap);
        ConnSettingResponseMap connSettingResponseMap = new ConnSettingResponseMap();
        this.verifyRequiredSetting("ProjectId", connSettingRequestMap, connSettingResponseMap);
        try {
            this.verifyOptionalSetting("OAuthType", connSettingRequestMap, connSettingResponseMap);
            if (connSettingRequestMap.containsKey("OAuthType") && BQConnectionOptions.OAuthMechanism.SERVICE_ACCOUNT.ordinal() == connSettingRequestMap.getProperty("OAuthType").getInt()) {
                this.verifyRequiredSetting("OAuthServiceAcctEmail", connSettingRequestMap, connSettingResponseMap);
                Variant variant = connSettingRequestMap.getProperty("OAuthPvtKey");
                if (null == variant || variant.getString().isEmpty()) {
                    this.verifyRequiredSetting("OAuthPvtKeyPath", connSettingRequestMap, connSettingResponseMap);
                } else {
                    this.verifyOptionalSetting("OAuthPvtKeyPath", connSettingRequestMap, connSettingResponseMap);
                }
            } else {
                this.verifyOptionalSetting("OAuthServiceAcctEmail", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("OAuthPvtKey", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("OAuthPvtKeyPath", connSettingRequestMap, connSettingResponseMap);
            }
            this.verifyOptionalSetting("AllowLargeResults", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("LargeResultDataset", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("LargeResultTable", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("AdditionalProjects", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("FetchThreadsPerResultSet", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("Language", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("MaxResults", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("StringColumnLength", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("Timeout", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("OAuthAccessToken", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("OAuthRefreshToken", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("OAuthClientId", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("OAuthClientSecret", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("TimestampFallback", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("useQueryCache", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("ProxyHost", connSettingRequestMap, connSettingResponseMap);
            if (connSettingRequestMap.containsKey("ProxyHost")) {
                this.verifyRequiredSetting("ProxyPort", connSettingRequestMap, connSettingResponseMap);
                this.verifyOptionalSetting("ProxyUid", connSettingRequestMap, connSettingResponseMap);
                if (connSettingRequestMap.containsKey("ProxyUid")) {
                    this.verifyOptionalSetting("ProxyPwd", connSettingRequestMap, connSettingResponseMap);
                }
            }
            this.verifyOptionalSetting("KMSKeyName", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("DefaultDataset", connSettingRequestMap, connSettingResponseMap);
            if (connSettingRequestMap.containsKey("DefaultDataset")) {
                this.verifyOptionalSetting("FilterTablesOnDefaultDataset", connSettingRequestMap, connSettingResponseMap);
            }
            this.verifyOptionalSetting("RequestGoogleDriveScope", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("EnableHighThroughPutAPI", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("HighThroughPutMinTableSize", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("ForceHTAPI", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("IgnoreTransactions", connSettingRequestMap, connSettingResponseMap);
            this.verifyOptionalSetting("LargeResultsDatasetExpirationTime", connSettingRequestMap, connSettingResponseMap);
        }
        catch (Exception exception) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_OPTION_GET_ERR, exception.getMessage());
        }
        return connSettingResponseMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BQConnectionOptions getConnectionOptions(ConnSettingRequestMap connSettingRequestMap) throws UtilsException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), connSettingRequestMap);
        this.m_settings.m_timeout = 10000L;
        this.m_settings.m_queryDialect = BQConnectionOptions.QueryDialect.SQL;
        this.m_settings.m_OAuthType = BQConnectionOptions.OAuthMechanism.SERVICE_ACCOUNT;
        this.m_settings.m_port = "443";
        this.m_settings.m_stringColumnLength = 65535L;
        this.m_settings.m_fetchThreadCount = 4;
        this.m_settings.m_allowLargeResults = false;
        this.m_settings.m_timestampFallback = false;
        this.m_settings.m_useQueryCache = true;
        this.m_settings.m_requestGoogleDriveScope = false;
        this.m_settings.m_enableHighThroughPutAPI = false;
        this.m_settings.m_highThroughPutMinTableSize = 100;
        this.m_settings.m_forceHTAPI = false;
        this.m_settings.m_highThroughPutTotalRowsToFirstPageRowsRatio = 3;
        this.m_settings.m_largeResultsDatasetExpirationTime = 3600000L;
        this.m_settings.m_rootURL = "";
        this.m_settings.m_highThroughPutRootURL = "";
        this.m_settings.m_metadataFetchThreadCount = 32;
        this.m_settings.m_projectId = this.getRequiredSetting("ProjectId", connSettingRequestMap).getString();
        try {
            Variant variant;
            Variant variant2;
            Object object;
            Object object2;
            Object object3;
            String[] stringArray;
            Variant variant3;
            Variant variant4;
            Variant variant5;
            Variant variant6;
            Variant variant7;
            Object object4;
            Variant variant8;
            Variant variant9;
            Variant variant10;
            Variant variant11;
            Variant variant12;
            Variant variant13;
            Variant variant14;
            Variant variant15;
            Variant variant16;
            Object object5;
            Variant variant17;
            Variant variant18;
            Variant variant19;
            Variant variant20;
            Variant variant21;
            Variant variant22 = this.getOptionalSetting("StringColumnLength", connSettingRequestMap);
            if (variant22 != null) {
                this.m_settings.m_stringColumnLength = variant22.getLong();
            }
            if ((variant21 = this.getOptionalSetting("Timeout", connSettingRequestMap)) != null) {
                try {
                    long l = variant21.getLong();
                    if (l < 1L) {
                        throw new Exception("Invalid timeout value.");
                    }
                    this.m_settings.m_timeout = l * 1000L;
                }
                catch (Exception exception) {
                    this.postOptionalValueChangedWarning("Timeout", String.valueOf(10000L));
                }
            }
            if ((variant20 = this.getOptionalSetting("MaxResults", connSettingRequestMap)) != null && variant20.getLong() > 0L) {
                this.m_settings.m_maxResults = variant20.getLong();
            } else {
                this.m_settings.m_maxResults = 10000L;
                this.postOptionalValueChangedWarning("MaxResults", String.valueOf(10000L));
            }
            Variant variant23 = this.getOptionalSetting("OAuthType", connSettingRequestMap);
            if (variant23 != null) {
                int n = variant23.getInt();
                if (n == 0) {
                    this.m_settings.m_OAuthType = BQConnectionOptions.OAuthMechanism.SERVICE_ACCOUNT;
                } else if (n == 1) {
                    this.m_settings.m_OAuthType = BQConnectionOptions.OAuthMechanism.USER_ACCOUNT;
                } else if (n == 2) {
                    this.m_settings.m_OAuthType = BQConnectionOptions.OAuthMechanism.TOKEN;
                } else {
                    if (n != 3) throw new IllegalArgumentException("OAuthType");
                    this.m_settings.m_OAuthType = BQConnectionOptions.OAuthMechanism.APPLICATION_DEFAULT_CREDENTIALS;
                }
            }
            if (BQConnectionOptions.OAuthMechanism.SERVICE_ACCOUNT == this.m_settings.m_OAuthType) {
                Variant variant24 = this.getRequiredSetting("OAuthServiceAcctEmail", connSettingRequestMap);
                if (variant24 != null) {
                    this.m_settings.m_OAuthServiceAcctEmail = variant24.getString();
                }
                if ((variant19 = this.getOptionalSetting("OAuthPvtKey", connSettingRequestMap)) != null) {
                    this.m_settings.m_OAuthServiceKey = new BQServiceKey(variant19.getString());
                    variant18 = this.getOptionalSetting("OAuthPvtKeyPath", connSettingRequestMap);
                    if (variant18 != null) {
                        this.getWarningListener().postWarning(new Warning(WarningCode.UNUSED, 101, BQMessageKey.CONN_PROP_VALUE_UNUSED.name(), new String[]{"OAuthPvtKeyPath"}));
                    }
                } else {
                    variant18 = this.getRequiredSetting("OAuthPvtKeyPath", connSettingRequestMap);
                    if (variant18 != null) {
                        this.m_settings.m_OAuthServiceKey = new BQServiceKey(variant18.getString());
                    }
                }
            }
            if ((variant17 = this.getOptionalSetting("OAuthAccessToken", connSettingRequestMap)) != null) {
                this.m_settings.m_OAuthAccessToken = variant17.getString();
            }
            if ((variant19 = this.getOptionalSetting("OAuthRefreshToken", connSettingRequestMap)) != null) {
                this.m_settings.m_OAuthRefreshToken = variant19.getString();
            }
            this.m_settings.m_OAuthClientId = (variant18 = this.getOptionalSetting("OAuthClientId", connSettingRequestMap)) != null ? variant18.getString() : "977385342095.apps.googleusercontent.com";
            Variant variant25 = this.getOptionalSetting("OAuthClientSecret", connSettingRequestMap);
            this.m_settings.m_OAuthClientSecret = variant25 != null ? variant25.getString() : "wbER7576mc_1YOII0dGk7jEE";
            Variant variant26 = this.getOptionalSetting("QueryDialect", connSettingRequestMap);
            if (variant26 != null) {
                object5 = variant26.getString();
                if (BQConnectionOptions.QueryDialect.BIG_QUERY.toString().equals(object5)) {
                    this.m_settings.m_queryDialect = BQConnectionOptions.QueryDialect.BIG_QUERY;
                } else {
                    if (!BQConnectionOptions.QueryDialect.SQL.toString().equals(object5)) throw new IllegalArgumentException("QueryDialect");
                    this.m_settings.m_queryDialect = BQConnectionOptions.QueryDialect.SQL;
                }
            }
            if ((object5 = this.getOptionalSetting("AllowLargeResults", connSettingRequestMap)) != null) {
                int n = ((Variant)object5).getInt();
                if (n == 0) {
                    this.m_settings.m_allowLargeResults = false;
                } else {
                    if (n != 1) throw new IllegalArgumentException("AllowLargeResults");
                    this.m_settings.m_allowLargeResults = true;
                }
            }
            if ((variant16 = this.getOptionalSetting("LargeResultDataset", connSettingRequestMap)) != null) {
                this.m_settings.m_largeResultDataset = variant16.getString();
            }
            if ((variant15 = this.getOptionalSetting("LargeResultTable", connSettingRequestMap)) != null) {
                this.m_settings.m_largeResultTable = variant15.getString();
            }
            if ((variant14 = this.getOptionalSetting("AdditionalProjects", connSettingRequestMap)) != null) {
                this.m_settings.m_additionalProjects = variant14.getString();
            }
            if ((variant13 = this.getOptionalSetting("FetchThreadsPerResultSet", connSettingRequestMap)) != null) {
                this.m_settings.m_fetchThreadCount = variant13.getInt();
            }
            if (null != (variant12 = this.getOptionalSetting("TimestampFallback", connSettingRequestMap))) {
                int n = variant12.getInt();
                if (0 == n) {
                    this.m_settings.m_timestampFallback = false;
                } else {
                    if (1 != n) throw new IllegalArgumentException("TimestampFallback");
                    this.m_settings.m_timestampFallback = true;
                }
            }
            if ((variant11 = this.getOptionalSetting("useQueryCache", connSettingRequestMap)) != null) {
                int n = variant11.getInt();
                if (n == 0) {
                    this.m_settings.m_useQueryCache = false;
                } else {
                    if (n != 1) throw new IllegalArgumentException("useQueryCache");
                    this.m_settings.m_useQueryCache = true;
                }
            }
            this.setProperty(22, new Variant(0, this.m_settings.m_projectId));
            if (BQConnectionOptions.QueryDialect.BIG_QUERY == this.m_settings.m_queryDialect) {
                this.setProperty(58, new Variant(""));
            }
            if ((variant10 = this.getOptionalSetting("DefaultDataset", connSettingRequestMap)) != null) {
                this.m_settings.m_defaultDataSet = variant10.getString();
            }
            if (null != this.m_settings.m_defaultDataSet) {
                variant9 = this.getOptionalSetting("FilterTablesOnDefaultDataset", connSettingRequestMap);
                if (variant9 != null) {
                    int n = variant9.getInt();
                    if (n == 0) {
                        this.m_settings.m_filterTablesOnDefaultDataset = false;
                    } else {
                        if (n != 1) throw new IllegalArgumentException("FilterTablesOnDefaultDataset");
                        this.m_settings.m_filterTablesOnDefaultDataset = true;
                    }
                }
            } else {
                this.m_settings.m_filterTablesOnDefaultDataset = false;
            }
            if ((variant9 = this.getOptionalSetting("KMSKeyName", connSettingRequestMap)) != null) {
                this.m_settings.m_KMSKeyName = variant9.getString();
            }
            if ((variant8 = this.getOptionalSetting("ProxyHost", connSettingRequestMap)) != null) {
                object4 = new BQConnectionOptions.ProxySettings();
                ((BQConnectionOptions.ProxySettings)object4).m_host = variant8.getString();
                variant7 = this.getRequiredSetting("ProxyPort", connSettingRequestMap);
                if (variant7 != null) {
                    ((BQConnectionOptions.ProxySettings)object4).m_port = variant7.getInt();
                }
                if ((variant6 = this.getOptionalSetting("ProxyUid", connSettingRequestMap)) != null) {
                    ((BQConnectionOptions.ProxySettings)object4).m_uid = variant6.getString();
                    variant5 = this.getOptionalSetting("ProxyPwd", connSettingRequestMap);
                    if (variant5 != null) {
                        ((BQConnectionOptions.ProxySettings)object4).m_pwd = variant5.getString();
                    }
                }
                this.m_settings.m_proxySettings = object4;
            }
            if ((object4 = this.getOptionalSetting("RequestGoogleDriveScope", connSettingRequestMap)) != null) {
                if (this.m_settings.m_OAuthType == BQConnectionOptions.OAuthMechanism.TOKEN) {
                    throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_GDRIVE_SCOPE_OPTION_ERR);
                }
                int n = ((Variant)object4).getInt();
                if (n == 0) {
                    this.m_settings.m_requestGoogleDriveScope = false;
                } else {
                    if (n != 1) throw new IllegalArgumentException("RequestGoogleDriveScope");
                    this.m_settings.m_requestGoogleDriveScope = true;
                }
            }
            if (null != (variant7 = this.getOptionalSetting("EnableHighThroughPutAPI", connSettingRequestMap))) {
                int n = variant7.getInt();
                if (n == 0) {
                    this.m_settings.m_enableHighThroughPutAPI = false;
                } else if (n == 1) {
                    this.m_settings.m_enableHighThroughPutAPI = true;
                }
            }
            if (null != (variant6 = this.getOptionalSetting("HighThroughPutMinTableSize", connSettingRequestMap))) {
                this.m_settings.m_highThroughPutMinTableSize = variant6.getInt();
            }
            if (null != (variant5 = this.getOptionalSetting("ForceHTAPI", connSettingRequestMap))) {
                int n = variant5.getInt();
                if (n == 0) {
                    this.m_settings.m_forceHTAPI = false;
                } else if (n == 1) {
                    this.m_settings.m_forceHTAPI = true;
                    this.m_settings.m_enableHighThroughPutAPI = true;
                }
            }
            if (null != (variant4 = this.getOptionalSetting("HighThroughPutActivationRatio", connSettingRequestMap))) {
                this.m_settings.m_highThroughPutTotalRowsToFirstPageRowsRatio = variant4.getInt();
            }
            if (null != (variant3 = this.getOptionalSetting("LargeResultsDatasetExpirationTime", connSettingRequestMap))) {
                this.m_settings.m_largeResultsDatasetExpirationTime = variant3.getLong();
            }
            this.m_settings.m_queryProperties = new ArrayList<ConnectionProperty>();
            Variant variant27 = this.getOptionalSetting("QueryProperties", connSettingRequestMap);
            if (null != variant27) {
                stringArray = variant27.getString().replaceAll("^\"|\"$", "").split(",");
                object3 = new HashSet();
                object2 = stringArray;
                int n = ((String[])object2).length;
                for (int i = 0; i < n; ++i) {
                    object = object2[i];
                    String[] stringArray2 = ((String)object).split("=");
                    if (stringArray2.length != 2) {
                        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BQ_QUERYPROPERTIES_MALFORMED.name(), "Each property must be of the form key=value, and properties must be separated by commas (,).");
                    }
                    if (object3.contains(stringArray2[0])) {
                        throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.BQ_QUERYPROPERTIES_DUPLICATEPROPERTY.name(), stringArray2[0]);
                    }
                    ConnectionProperty connectionProperty = new ConnectionProperty();
                    connectionProperty.setKey(stringArray2[0]);
                    connectionProperty.setValue(stringArray2[1]);
                    object3.add(stringArray2[0]);
                    this.m_settings.m_queryProperties.add(connectionProperty);
                }
            }
            this.m_settings.m_location = null != (stringArray = this.getOptionalSetting("Location", connSettingRequestMap)) ? stringArray.getString() : "";
            object3 = this.getOptionalSetting("SSLTrustStore", connSettingRequestMap);
            if (object3 != null) {
                object2 = new BQConnectionOptions.TrustStoreSettings();
                ((BQConnectionOptions.TrustStoreSettings)object2).m_trustStore = ((Variant)object3).getString();
                Variant variant28 = this.getRequiredSetting("SSLTrustStorePwd", connSettingRequestMap);
                ((BQConnectionOptions.TrustStoreSettings)object2).m_trustStorePwd = null != variant28 ? variant28.getString() : "";
                this.m_settings.m_trustStoreSettings = object2;
            }
            if (null != (object2 = this.getOptionalSetting("IgnoreTransactions", connSettingRequestMap)) && 1 == ((Variant)object2).getInt()) {
                this.fakeTransactionSupport('\u0002');
            }
            if ((variant2 = this.getOptionalSetting("RootURL", connSettingRequestMap)) != null) {
                this.m_settings.m_rootURL = variant2.getString();
            }
            if ((variant = this.getOptionalSetting("HighThroughputRootURL", connSettingRequestMap)) != null) {
                this.m_settings.m_highThroughPutRootURL = variant.getString();
            }
            if ((object = this.getOptionalSetting("MetaDataFetchThreadCount", connSettingRequestMap)) != null && 0 < ((Variant)object).getInt()) {
                this.m_settings.m_metadataFetchThreadCount = ((Variant)object).getInt();
                return this.m_settings;
            } else {
                this.m_settings.m_metadataFetchThreadCount = 32;
                this.postOptionalValueChangedWarning("MetaDataFetchThreadCount", String.valueOf(32));
            }
            return this.m_settings;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw BQDriver.s_BQMessages.createGeneralException(BQMessageKey.CONN_OPTION_GET_ERR, illegalArgumentException.getMessage());
        }
    }

    private void setDefaultProperties() throws BadAttrValException, IncorrectTypeException, NumericOverflowException, ErrorException {
        LogUtilities.logFunctionEntrance(this.getConnectionLog(), new Object[0]);
        this.setProperty(22, new Variant(0, this.m_settings.m_projectId));
        this.setProperty(1, new Variant(0, "N"));
        this.setProperty(40, new Variant(0, "N"));
        this.setProperty(16, new Variant(3, 0L));
        this.setProperty(11, new Variant(0, "Project"));
        this.setProperty(28, new Variant(2, Character.valueOf('\u0002')));
        this.setProperty(43, new Variant(3, 4L));
        this.setProperty(41, new Variant(0, "Google BigQuery"));
        this.setProperty(42, new Variant(0, "2.0"));
        this.setProperty(66, new Variant(2, Character.valueOf('\u0080')));
        this.setProperty(68, new Variant(2, Character.valueOf('\u0080')));
        this.setProperty(81, new Variant(2, Character.valueOf('\u0400')));
        this.setProperty(73, new Variant(2, Character.valueOf('\u2710')));
        this.setProperty(83, new Variant(2, Character.valueOf('\u0400')));
        this.setProperty(84, new Variant(2, Character.valueOf('\u03e8')));
        this.setProperty(58, new Variant(0, "`"));
        this.setProperty(99, new Variant(0, "Dataset"));
        this.setProperty(101, new Variant(0, "Google BigQuery"));
        this.setProperty(97, new Variant(0, "Y"));
        this.setProperty(27, new Variant(3, 2L));
        this.setProperty(92, new Variant(3, 39L));
        this.setProperty(106, new Variant(3, 20864L));
        this.setProperty(108, new Variant(3, 20736L));
        this.setProperty(127, new Variant(3, 153984L));
        this.setProperty(113, new Variant(3, 16768L));
        this.setProperty(124, new Variant(3, 33024L));
        this.setProperty(126, new Variant(3, 2304L));
        this.setProperty(111, new Variant(3, 0L));
        this.setProperty(123, new Variant(3, 0L));
        this.setProperty(107, new Variant(3, 0L));
        this.setProperty(109, new Variant(3, 0L));
        this.setProperty(110, new Variant(3, 0L));
        this.setProperty(112, new Variant(3, 0L));
        this.setProperty(114, new Variant(3, 0L));
        this.setProperty(115, new Variant(3, 0L));
        this.setProperty(116, new Variant(3, 0L));
        this.setProperty(117, new Variant(3, 0L));
        this.setProperty(118, new Variant(3, 0L));
        this.setProperty(119, new Variant(3, 0L));
        this.setProperty(120, new Variant(3, 0L));
        this.setProperty(121, new Variant(3, 0L));
        this.setProperty(122, new Variant(3, 0L));
        this.setProperty(125, new Variant(3, 0L));
        this.setProperty(128, new Variant(3, 0L));
        this.setProperty(129, new Variant(3, 0L));
        this.setProperty(130, new Variant(3, 0L));
        this.setProperty(104, new Variant(3, 0x7C7FFFL));
        this.setProperty(90, new Variant(3, 0x7FFFFFL));
        this.setProperty(135, new Variant(3, 0x1FFFFFL));
        this.setProperty(131, new Variant(3, 0L));
        this.setProperty(134, new Variant(3, 0L));
        this.setProperty(133, new Variant(3, 0L));
        this.setProperty(1012, new Variant(2, Character.valueOf('\u0001')));
        this.setProperty(86, new Variant(0, "Y"));
    }

    private void postOptionalValueChangedWarning(String string, String string2) {
        this.getWarningListener().postWarning(new Warning(WarningCode.OPTIONAL_VALUE_CHANGED, 101, BQMessageKey.CONN_PROP_OPTIONAL_VALUE_CHANGED.name(), new String[]{string, string2}));
        String string3 = "Invalid value provided for " + string + ", defaulting to " + string2 + ".";
        LogUtilities.logTrace(string3, this.getConnectionLog());
    }
}

