import { Duration } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { ICluster } from './cluster';
import { Construct as CoreConstruct } from '@aws-cdk/core';
/**
 * Properties for KubernetesObjectValue.
 *
 * @stability stable
 */
export interface KubernetesObjectValueProps {
    /**
     * The EKS cluster to fetch attributes from.
     *
     * [disable-awslint:ref-via-interface]
     *
     * @stability stable
     */
    readonly cluster: ICluster;
    /**
     * The object type to query.
     *
     * (e.g 'service', 'pod'...)
     *
     * @stability stable
     */
    readonly objectType: string;
    /**
     * The name of the object to query.
     *
     * @stability stable
     */
    readonly objectName: string;
    /**
     * The namespace the object belongs to.
     *
     * @default 'default'
     * @stability stable
     */
    readonly objectNamespace?: string;
    /**
     * JSONPath to the specific value.
     *
     * @see https://kubernetes.io/docs/reference/kubectl/jsonpath/
     * @stability stable
     */
    readonly jsonPath: string;
    /**
     * Timeout for waiting on a value.
     *
     * @default Duration.minutes(5)
     * @stability stable
     */
    readonly timeout?: Duration;
}
/**
 * Represents a value of a specific object deployed in the cluster.
 *
 * Use this to fetch any information available by the `kubectl get` command.
 *
 * @stability stable
 */
export declare class KubernetesObjectValue extends CoreConstruct {
    /**
     * The CloudFormation reosurce type.
     *
     * @stability stable
     */
    static readonly RESOURCE_TYPE = "Custom::AWSCDK-EKS-KubernetesObjectValue";
    private _resource;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: KubernetesObjectValueProps);
    /**
     * The value as a string token.
     *
     * @stability stable
     */
    get value(): string;
}
