"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const dms_generated_1 = require("./dms.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return dms_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::DMS::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::DMS::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new dms_generated_1.RosInstance(this, id, {
            instanceSource: props.instanceSource,
            databasePassword: props.databasePassword,
            port: props.port,
            host: props.host,
            exportTimeout: props.exportTimeout,
            safeRule: props.safeRule,
            ddlOnline: props.ddlOnline,
            envType: props.envType,
            tid: props.tid,
            useDsql: props.useDsql,
            sid: props.sid,
            ecsInstanceId: props.ecsInstanceId,
            vpcId: props.vpcId,
            instanceAlias: props.instanceAlias,
            dbaUid: props.dbaUid,
            ecsRegion: props.ecsRegion,
            networkType: props.networkType,
            databaseUser: props.databaseUser,
            instanceType: props.instanceType,
            dataLinkName: props.dataLinkName,
            queryTimeout: props.queryTimeout,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrHost = rosInstance.attrHost;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrPort = rosInstance.attrPort;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5zdGFuY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbnN0YW5jZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQThDO0FBRXRCLGlHQUZmLDJCQUFXLE9BRW9CO0FBZ0p4Qzs7R0FFRztBQUNILE1BQWEsUUFBUyxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBc0J0Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQW9CLEVBQUUsbUNBQTJDLElBQUk7UUFDL0csS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLFdBQVcsR0FBRyxJQUFJLDJCQUFXLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUMzQyxjQUFjLEVBQUUsS0FBSyxDQUFDLGNBQWM7WUFDcEMsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGdCQUFnQjtZQUN4QyxJQUFJLEVBQUUsS0FBSyxDQUFDLElBQUk7WUFDaEIsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTztZQUN0QixHQUFHLEVBQUUsS0FBSyxDQUFDLEdBQUc7WUFDZCxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87WUFDdEIsR0FBRyxFQUFFLEtBQUssQ0FBQyxHQUFHO1lBQ2QsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhO1lBQ2xDLEtBQUssRUFBRSxLQUFLLENBQUMsS0FBSztZQUNsQixhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7WUFDbEMsTUFBTSxFQUFFLEtBQUssQ0FBQyxNQUFNO1lBQ3BCLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQ2hDLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7WUFDaEMsWUFBWSxFQUFFLEtBQUssQ0FBQyxZQUFZO1NBQ25DLEVBQUUsZ0NBQWdDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUcsV0FBVyxDQUFDO1FBQzVCLElBQUksQ0FBQyxRQUFRLEdBQUcsV0FBVyxDQUFDLFFBQVEsQ0FBQztRQUNyQyxJQUFJLENBQUMsY0FBYyxHQUFHLFdBQVcsQ0FBQyxjQUFjLENBQUM7UUFDakQsSUFBSSxDQUFDLFFBQVEsR0FBRyxXQUFXLENBQUMsUUFBUSxDQUFDO0lBQ3pDLENBQUM7Q0FDSjtBQTVERCw0QkE0REMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XHJcbmltcG9ydCB7IFJvc0luc3RhbmNlIH0gZnJvbSAnLi9kbXMuZ2VuZXJhdGVkJztcclxuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXHJcbmV4cG9ydCB7IFJvc0luc3RhbmNlIGFzIEluc3RhbmNlUHJvcGVydHkgfTtcclxuXHJcbi8qKlxyXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46OkRNUzo6SW5zdGFuY2VgXHJcbiAqL1xyXG5leHBvcnQgaW50ZXJmYWNlIEluc3RhbmNlUHJvcHMge1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGRhdGFiYXNlUGFzc3dvcmQ6IFRoZSBsb2dvbiBwYXNzd29yZCBvZiB0aGUgZGF0YWJhc2UgaW5zdGFuY2UuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGRhdGFiYXNlUGFzc3dvcmQ6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBkYXRhYmFzZVVzZXI6IFRoZSBsb2dvbiB1c2VybmFtZSBvZiB0aGUgZGF0YWJhc2UgaW5zdGFuY2UuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGRhdGFiYXNlVXNlcjogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGRiYVVpZDogVGhlIEFsaWJhYmEgQ2xvdWQgdW5pcXVlIElEIChVSUQpIG9mIHRoZSBkYXRhYmFzZSBhZG1pbmlzdHJhdG9yIChEQkEpIG9mIHRoZSBkYXRhYmFzZVxyXG4gICAgICogaW5zdGFuY2UuXHJcbiAgICAgKiBOb3RlIFRvIHF1ZXJ5IHRoZSBVSUQsIGxvZyBvbiB0byB0aGUgRE1TIEVudGVycHJpc2UgY29uc29sZSBhbmQgY2hvb3NlIFN5c3RlbSBNYW5hZ2VtZW50XHJcbiAgICAgKiA+IFVzZXIgTWFuYWdlbWVudC5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgZGJhVWlkOiBudW1iZXI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZW52VHlwZTogVGhlIHR5cGUgb2YgdGhlIGVudmlyb25tZW50IHRvIHdoaWNoIHRoZSBkYXRhYmFzZSBpbnN0YW5jZSBiZWxvbmdzLiBWYWxpZCB2YWx1ZXM6XHJcbiAgICAgKiBwcm9kdWN0OiB0aGUgcHJvZHVjdGlvbiBlbnZpcm9ubWVudC5cclxuICAgICAqIGRldjogdGhlIHRlc3QgZW52aXJvbm1lbnQuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGVudlR5cGU6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBleHBvcnRUaW1lb3V0OiBUaGUgdGltZW91dCBwZXJpb2QgZm9yIGV4cG9ydGluZyB0aGUgZGF0YWJhc2UgaW5zdGFuY2UuIFVuaXQ6IHNlY29uZHMuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGV4cG9ydFRpbWVvdXQ6IG51bWJlcjtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBob3N0OiBUaGUgZW5kcG9pbnQgb2YgdGhlIGRhdGFiYXNlIGluc3RhbmNlLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBob3N0OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgaW5zdGFuY2VBbGlhczogVGhlIGFsaWFzIG9mIHRoZSBkYXRhYmFzZSBpbnN0YW5jZS4gVGhlIGFsaWFzIGhlbHBzIHlvdSBxdWlja2x5IGZpbmQgdGhlIHJlcXVpcmVkXHJcbiAgICAgKiBpbnN0YW5jZS5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgaW5zdGFuY2VBbGlhczogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGluc3RhbmNlU291cmNlOiBUaGUgc291cmNlIG9mIHRoZSBkYXRhYmFzZSBpbnN0YW5jZS4gVmFsaWQgdmFsdWVzOlxyXG4gICAgICogUFVCTElDX09XTjogYW4gb24tcHJlbWlzZXMgZGF0YWJhc2UgYnVpbHQgb24gdGhlIHB1YmxpYyBuZXR3b3JrLlxyXG4gICAgICogUkRTOiBhbiBBcHNhcmFEQiBmb3IgUkRTIChSRFMpIGluc3RhbmNlLlxyXG4gICAgICogRUNTX09XTjogYW4gb24tcHJlbWlzZXMgZGF0YWJhc2UgYnVpbHQgb24gYW4gRWxhc3RpYyBDb21wdXRlIFNlcnZpY2UgKEVDUykgaW5zdGFuY2UuXHJcbiAgICAgKiBWUENfSURDOiBhbiBvbi1wcmVtaXNlcyBkYXRhYmFzZSBidWlsdCBpbiBhbiBJbnRlcm5ldCBkYXRhIGNlbnRlciAoSURDKSBpbiBWaXJ0dWFsIFByaXZhdGVcclxuICAgICAqIENsb3VkIChWUEMpLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBpbnN0YW5jZVNvdXJjZTogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGluc3RhbmNlVHlwZTogVGhlIHR5cGUgb2YgdGhlIGRhdGFiYXNlIGluc3RhbmNlLiBWYWxpZCB2YWx1ZXM6IE15U1FMLCBTUUxTZXJ2ZXIsIFBvc3RncmVTUUwsIE9yYWNsZSwgRFJEUywgT2NlYW5CYXNlLCBNb25nbywgUmVkaXNcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgaW5zdGFuY2VUeXBlOiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgbmV0d29ya1R5cGU6IFRoZSBuZXR3b3JrIHR5cGUgb2YgdGhlIGRhdGFiYXNlIGluc3RhbmNlLiBWYWxpZCB2YWx1ZXM6XHJcbiAgICAgKiBDTEFTU0lDXHJcbiAgICAgKiBWUENcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgbmV0d29ya1R5cGU6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBwb3J0OiBUaGUgY29ubmVjdGlvbiBwb3J0IG9mIHRoZSBkYXRhYmFzZSBpbnN0YW5jZS5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgcG9ydDogbnVtYmVyO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHF1ZXJ5VGltZW91dDogVGhlIHRpbWVvdXQgcGVyaW9kIGZvciBxdWVyeWluZyB0aGUgZGF0YWJhc2UgaW5zdGFuY2UuIFVuaXQ6IHNlY29uZHMuXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHF1ZXJ5VGltZW91dDogbnVtYmVyO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHNhZmVSdWxlOiBUaGUgc2VjdXJpdHkgcnVsZSBvZiB0aGUgZGF0YWJhc2UgaW5zdGFuY2UuIEVudGVyIHRoZSBuYW1lIG9mIHRoZSBzZWN1cml0eSBydWxlIGZvclxyXG4gICAgICogeW91ciBlbnRlcnByaXNlLlxyXG4gICAgICogTm90ZSBUbyBxdWVyeSBhIHNwZWNpZmllZCBzZWN1cml0eSBydWxlLCBsb2cgb24gdG8gdGhlIERNUyBFbnRlcnByaXNlIGNvbnNvbGUgYW5kIGNob29zZVxyXG4gICAgICogU3lzdGVtIE1hbmFnZW1lbnQgPiBTZWN1cml0eSBSdWxlcy4gVGhlIHNlY3VyaXR5IHJ1bGUgYXBwZWFycyBpbiB0aGUgc2VjdXJpdHkgcnVsZVxyXG4gICAgICogbGlzdC5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgc2FmZVJ1bGU6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSB0aWQ6IFRoZSBJRCBvZiB0aGUgdGVuYW50LlxyXG4gICAgICogTm90ZSBUbyBxdWVyeSB0aGUgSUQsIGxvZyBvbiB0byB0aGUgRE1TIEVudGVycHJpc2UgY29uc29sZSBhbmQgY2hvb3NlIFN5c3RlbSBNYW5hZ2VtZW50XHJcbiAgICAgKiA+IEluc3RhbmNlIE1hbmFnZW1lbnQgb3IgU3lzdGVtIE1hbmFnZW1lbnQgPiBVc2VyIE1hbmFnZW1lbnQuIFRoZSBJRCBvZiB0aGUgdGVuYW50XHJcbiAgICAgKiBhcHBlYXJzIGluIHRoZSBTZXJ2aWNlIFNwZWNpZmljYXRpb24gc2VjdGlvbi5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgdGlkOiBudW1iZXI7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZGF0YUxpbmtOYW1lOiBUaGUgbmFtZSBvZiB0aGUgZGF0YSBsaW5rIGZvciBjcm9zcy1kYXRhYmFzZSBxdWVyeS5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgZGF0YUxpbmtOYW1lPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGRkbE9ubGluZTogW0ltcG9ydGFudF0gU3BlY2lmaWVzIHdoZXRoZXIgdG8gZW5hYmxlIHRoZSBvbmxpbmUgZGF0YSBkZXNjcmlwdGlvbiBsYW5ndWFnZSAoRERMKVxyXG4gICAgICogc2VydmljZS4gQ3VycmVudGx5LCB0aGlzIHNlcnZpY2UgaXMgYXZhaWxhYmxlIG9ubHkgZm9yIHRoZSBNeVNRTCBhbmQgUG9sYXJEQiBkYXRhYmFzZXMuXHJcbiAgICAgKiAwOiBUaGUgc2VydmljZSBpcyBkaXNhYmxlZC5cclxuICAgICAqIDE6IFRoZSBuYXRpdmUgb25saW5lIERETCBzZXJ2aWNlIHByZXZhaWxzLlxyXG4gICAgICogMjogRGF0YSBjaGFuZ2Ugd2l0aG91dCB0YWJsZSBsb2NraW5nIHByb3ZpZGVkIGJ5IERNUyBwcmV2YWlscy5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgZGRsT25saW5lPzogbnVtYmVyO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IGVjc0luc3RhbmNlSWQ6IFRoZSBJRCBvZiB0aGUgRUNTIGluc3RhbmNlIHRvIHdoaWNoIHRoZSBkYXRhYmFzZSBpbnN0YW5jZSBiZWxvbmdzLlxyXG4gICAgICogTm90ZSBZb3UgbXVzdCBzcGVjaWZ5IHRoaXMgcGFyYW1ldGVyIGlmIHRoZSBJbnN0YW5jZVNvdXJjZSBwYXJhbWV0ZXIgaXMgc2V0IHRvIEVDU19PV04uXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IGVjc0luc3RhbmNlSWQ/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgZWNzUmVnaW9uOiBUaGUgcmVnaW9uIHdoZXJlIHRoZSBkYXRhYmFzZSBpbnN0YW5jZSByZXNpZGVzLlxyXG4gICAgICogTm90ZSBZb3UgbXVzdCBzcGVjaWZ5IHRoaXMgcGFyYW1ldGVyIGlmIHRoZSBJbnN0YW5jZVNvdXJjZSBwYXJhbWV0ZXIgaXMgc2V0IHRvIEVDU19PV04gb3IgVlBDX0lEQy5cclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgZWNzUmVnaW9uPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHNpZDogVGhlIHN5c3RlbSBJRCAoU0lEKSBvZiB0aGUgZGF0YWJhc2UgaW5zdGFuY2UuXHJcbiAgICAgKiBOb3RlIFlvdSBtdXN0IHNwZWNpZnkgdGhpcyBwYXJhbWV0ZXIgaWYgdGhlIEluc3RhbmNlVHlwZSBwYXJhbWV0ZXIgaXMgc2V0IHRvIFBvc3RncmVTUUwgb3IgT3JhY2xlLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBzaWQ/OiBzdHJpbmc7XHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAUHJvcGVydHkgdXNlRHNxbDogU3BlY2lmaWVzIHdoZXRoZXIgdG8gZW5hYmxlIGNyb3NzLWRhdGFiYXNlIHF1ZXJ5IGZvciB0aGUgZGF0YWJhc2UgaW5zdGFuY2UuIFZhbGlkXHJcbiAgICAgKiB2YWx1ZXM6XHJcbiAgICAgKiAwOiBkaXNhYmxlZFxyXG4gICAgICogMTogZW5hYmxlZFxyXG4gICAgICovXHJcbiAgICByZWFkb25seSB1c2VEc3FsPzogbnVtYmVyO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHZwY0lkOiBUaGUgSUQgb2YgdGhlIFZQQyB0byB3aGljaCB0aGUgZGF0YWJhc2UgaW5zdGFuY2UgYmVsb25ncy5cclxuICAgICAqIE5vdGUgWW91IG11c3Qgc3BlY2lmeSB0aGlzIHBhcmFtZXRlciBpZiB0aGUgSW5zdGFuY2VTb3VyY2UgcGFyYW1ldGVyIGlzIHNldCB0byBWUENfSURDLlxyXG4gICAgICovXHJcbiAgICByZWFkb25seSB2cGNJZD86IHN0cmluZztcclxufVxyXG5cclxuLyoqXHJcbiAqIEEgUk9TIHJlc291cmNlIHR5cGU6ICBgQUxJWVVOOjpETVM6Okluc3RhbmNlYFxyXG4gKi9cclxuZXhwb3J0IGNsYXNzIEluc3RhbmNlIGV4dGVuZHMgcm9zLlJlc291cmNlIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEEgZmFjdG9yeSBtZXRob2QgdGhhdCBjcmVhdGVzIGEgbmV3IGluc3RhbmNlIG9mIHRoaXMgY2xhc3MgZnJvbSBhbiBvYmplY3RcclxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxyXG4gICAgICovXHJcblxyXG4gICAgLyoqXHJcbiAgICAgKiBAQXR0cmlidXRlIEhvc3Q6IFRoZSBlbmRwb2ludCBvZiB0aGUgZGF0YWJhc2UgaW5zdGFuY2UuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyByZWFkb25seSBhdHRySG9zdDogYW55O1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQEF0dHJpYnV0ZSBJbnN0YW5jZUlkOiBUaGUgSUQgb2YgdGhlIGRhdGFiYXNlIGluc3RhbmNlLlxyXG4gICAgICovXHJcbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ckluc3RhbmNlSWQ6IGFueTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBBdHRyaWJ1dGUgUG9ydDogVGhlIGNvbm5lY3Rpb24gcG9ydCBvZiB0aGUgZGF0YWJhc2UgaW5zdGFuY2UuXHJcbiAgICAgKi9cclxuICAgIHB1YmxpYyByZWFkb25seSBhdHRyUG9ydDogYW55O1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQ3JlYXRlIGEgbmV3IGBBTElZVU46OkRNUzo6SW5zdGFuY2VgLlxyXG4gICAgICpcclxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxyXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxyXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xyXG4gICAgICovXHJcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEluc3RhbmNlUHJvcHMsIGVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50OmJvb2xlYW4gPSB0cnVlKSB7XHJcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkKTtcclxuXHJcbiAgICAgICAgY29uc3Qgcm9zSW5zdGFuY2UgPSBuZXcgUm9zSW5zdGFuY2UodGhpcywgaWQsICB7XHJcbiAgICAgICAgICAgIGluc3RhbmNlU291cmNlOiBwcm9wcy5pbnN0YW5jZVNvdXJjZSxcclxuICAgICAgICAgICAgZGF0YWJhc2VQYXNzd29yZDogcHJvcHMuZGF0YWJhc2VQYXNzd29yZCxcclxuICAgICAgICAgICAgcG9ydDogcHJvcHMucG9ydCxcclxuICAgICAgICAgICAgaG9zdDogcHJvcHMuaG9zdCxcclxuICAgICAgICAgICAgZXhwb3J0VGltZW91dDogcHJvcHMuZXhwb3J0VGltZW91dCxcclxuICAgICAgICAgICAgc2FmZVJ1bGU6IHByb3BzLnNhZmVSdWxlLFxyXG4gICAgICAgICAgICBkZGxPbmxpbmU6IHByb3BzLmRkbE9ubGluZSxcclxuICAgICAgICAgICAgZW52VHlwZTogcHJvcHMuZW52VHlwZSxcclxuICAgICAgICAgICAgdGlkOiBwcm9wcy50aWQsXHJcbiAgICAgICAgICAgIHVzZURzcWw6IHByb3BzLnVzZURzcWwsXHJcbiAgICAgICAgICAgIHNpZDogcHJvcHMuc2lkLFxyXG4gICAgICAgICAgICBlY3NJbnN0YW5jZUlkOiBwcm9wcy5lY3NJbnN0YW5jZUlkLFxyXG4gICAgICAgICAgICB2cGNJZDogcHJvcHMudnBjSWQsXHJcbiAgICAgICAgICAgIGluc3RhbmNlQWxpYXM6IHByb3BzLmluc3RhbmNlQWxpYXMsXHJcbiAgICAgICAgICAgIGRiYVVpZDogcHJvcHMuZGJhVWlkLFxyXG4gICAgICAgICAgICBlY3NSZWdpb246IHByb3BzLmVjc1JlZ2lvbixcclxuICAgICAgICAgICAgbmV0d29ya1R5cGU6IHByb3BzLm5ldHdvcmtUeXBlLFxyXG4gICAgICAgICAgICBkYXRhYmFzZVVzZXI6IHByb3BzLmRhdGFiYXNlVXNlcixcclxuICAgICAgICAgICAgaW5zdGFuY2VUeXBlOiBwcm9wcy5pbnN0YW5jZVR5cGUsXHJcbiAgICAgICAgICAgIGRhdGFMaW5rTmFtZTogcHJvcHMuZGF0YUxpbmtOYW1lLFxyXG4gICAgICAgICAgICBxdWVyeVRpbWVvdXQ6IHByb3BzLnF1ZXJ5VGltZW91dCxcclxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcclxuICAgICAgICB0aGlzLnJlc291cmNlID0gcm9zSW5zdGFuY2U7XHJcbiAgICAgICAgdGhpcy5hdHRySG9zdCA9IHJvc0luc3RhbmNlLmF0dHJIb3N0O1xyXG4gICAgICAgIHRoaXMuYXR0ckluc3RhbmNlSWQgPSByb3NJbnN0YW5jZS5hdHRySW5zdGFuY2VJZDtcclxuICAgICAgICB0aGlzLmF0dHJQb3J0ID0gcm9zSW5zdGFuY2UuYXR0clBvcnQ7XHJcbiAgICB9XHJcbn1cclxuIl19