"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosUser = exports.RosInstance = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('instanceSource', ros.requiredValidator)(properties.instanceSource));
    errors.collect(ros.propertyValidator('instanceSource', ros.validateString)(properties.instanceSource));
    errors.collect(ros.propertyValidator('databasePassword', ros.requiredValidator)(properties.databasePassword));
    errors.collect(ros.propertyValidator('databasePassword', ros.validateString)(properties.databasePassword));
    errors.collect(ros.propertyValidator('port', ros.requiredValidator)(properties.port));
    errors.collect(ros.propertyValidator('port', ros.validateNumber)(properties.port));
    errors.collect(ros.propertyValidator('host', ros.requiredValidator)(properties.host));
    errors.collect(ros.propertyValidator('host', ros.validateString)(properties.host));
    errors.collect(ros.propertyValidator('exportTimeout', ros.requiredValidator)(properties.exportTimeout));
    errors.collect(ros.propertyValidator('exportTimeout', ros.validateNumber)(properties.exportTimeout));
    errors.collect(ros.propertyValidator('safeRule', ros.requiredValidator)(properties.safeRule));
    errors.collect(ros.propertyValidator('safeRule', ros.validateString)(properties.safeRule));
    errors.collect(ros.propertyValidator('ddlOnline', ros.validateNumber)(properties.ddlOnline));
    errors.collect(ros.propertyValidator('envType', ros.requiredValidator)(properties.envType));
    errors.collect(ros.propertyValidator('envType', ros.validateString)(properties.envType));
    errors.collect(ros.propertyValidator('tid', ros.requiredValidator)(properties.tid));
    errors.collect(ros.propertyValidator('tid', ros.validateNumber)(properties.tid));
    if (properties.useDsql && (typeof properties.useDsql) !== 'object') {
        errors.collect(ros.propertyValidator('useDsql', ros.validateAllowedValues)({
            data: properties.useDsql,
            allowedValues: [0, 1],
        }));
    }
    errors.collect(ros.propertyValidator('useDsql', ros.validateNumber)(properties.useDsql));
    errors.collect(ros.propertyValidator('sid', ros.validateString)(properties.sid));
    errors.collect(ros.propertyValidator('ecsInstanceId', ros.validateString)(properties.ecsInstanceId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('instanceAlias', ros.requiredValidator)(properties.instanceAlias));
    errors.collect(ros.propertyValidator('instanceAlias', ros.validateString)(properties.instanceAlias));
    errors.collect(ros.propertyValidator('dbaUid', ros.requiredValidator)(properties.dbaUid));
    errors.collect(ros.propertyValidator('dbaUid', ros.validateNumber)(properties.dbaUid));
    errors.collect(ros.propertyValidator('ecsRegion', ros.validateString)(properties.ecsRegion));
    errors.collect(ros.propertyValidator('networkType', ros.requiredValidator)(properties.networkType));
    if (properties.networkType && (typeof properties.networkType) !== 'object') {
        errors.collect(ros.propertyValidator('networkType', ros.validateAllowedValues)({
            data: properties.networkType,
            allowedValues: ["CLASSIC", "VPC"],
        }));
    }
    errors.collect(ros.propertyValidator('networkType', ros.validateString)(properties.networkType));
    errors.collect(ros.propertyValidator('databaseUser', ros.requiredValidator)(properties.databaseUser));
    errors.collect(ros.propertyValidator('databaseUser', ros.validateString)(properties.databaseUser));
    errors.collect(ros.propertyValidator('instanceType', ros.requiredValidator)(properties.instanceType));
    if (properties.instanceType && (typeof properties.instanceType) !== 'object') {
        errors.collect(ros.propertyValidator('instanceType', ros.validateAllowedValues)({
            data: properties.instanceType,
            allowedValues: ["MySQL", "SQLServer", "PostgreSQL", "Oracle", "DRDS", "OceanBase", "Mongo", "Redis"],
        }));
    }
    errors.collect(ros.propertyValidator('instanceType', ros.validateString)(properties.instanceType));
    errors.collect(ros.propertyValidator('dataLinkName', ros.validateString)(properties.dataLinkName));
    errors.collect(ros.propertyValidator('queryTimeout', ros.requiredValidator)(properties.queryTimeout));
    errors.collect(ros.propertyValidator('queryTimeout', ros.validateNumber)(properties.queryTimeout));
    return errors.wrap('supplied properties not correct for "RosInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DMS::Instance` resource
 *
 * @param properties - the TypeScript properties of a `RosInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DMS::Instance` resource.
 */
// @ts-ignore TS6133
function rosInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosInstancePropsValidator(properties).assertSuccess();
    }
    return {
        DatabasePassword: ros.stringToRosTemplate(properties.databasePassword),
        DatabaseUser: ros.stringToRosTemplate(properties.databaseUser),
        DbaUid: ros.numberToRosTemplate(properties.dbaUid),
        EnvType: ros.stringToRosTemplate(properties.envType),
        ExportTimeout: ros.numberToRosTemplate(properties.exportTimeout),
        Host: ros.stringToRosTemplate(properties.host),
        InstanceAlias: ros.stringToRosTemplate(properties.instanceAlias),
        InstanceSource: ros.stringToRosTemplate(properties.instanceSource),
        InstanceType: ros.stringToRosTemplate(properties.instanceType),
        NetworkType: ros.stringToRosTemplate(properties.networkType),
        Port: ros.numberToRosTemplate(properties.port),
        QueryTimeout: ros.numberToRosTemplate(properties.queryTimeout),
        SafeRule: ros.stringToRosTemplate(properties.safeRule),
        Tid: ros.numberToRosTemplate(properties.tid),
        DataLinkName: ros.stringToRosTemplate(properties.dataLinkName),
        DdlOnline: ros.numberToRosTemplate(properties.ddlOnline),
        EcsInstanceId: ros.stringToRosTemplate(properties.ecsInstanceId),
        EcsRegion: ros.stringToRosTemplate(properties.ecsRegion),
        Sid: ros.stringToRosTemplate(properties.sid),
        UseDsql: ros.numberToRosTemplate(properties.useDsql),
        VpcId: ros.stringToRosTemplate(properties.vpcId),
    };
}
/**
 * A ROS template type:  `ALIYUN::DMS::Instance`
 */
class RosInstance extends ros.RosResource {
    /**
     * Create a new `ALIYUN::DMS::Instance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrHost = ros.Token.asString(this.getAtt('Host'));
        this.attrInstanceId = ros.Token.asString(this.getAtt('InstanceId'));
        this.attrPort = ros.Token.asString(this.getAtt('Port'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.databasePassword = props.databasePassword;
        this.databaseUser = props.databaseUser;
        this.dbaUid = props.dbaUid;
        this.envType = props.envType;
        this.exportTimeout = props.exportTimeout;
        this.host = props.host;
        this.instanceAlias = props.instanceAlias;
        this.instanceSource = props.instanceSource;
        this.instanceType = props.instanceType;
        this.networkType = props.networkType;
        this.port = props.port;
        this.queryTimeout = props.queryTimeout;
        this.safeRule = props.safeRule;
        this.tid = props.tid;
        this.dataLinkName = props.dataLinkName;
        this.ddlOnline = props.ddlOnline;
        this.ecsInstanceId = props.ecsInstanceId;
        this.ecsRegion = props.ecsRegion;
        this.sid = props.sid;
        this.useDsql = props.useDsql;
        this.vpcId = props.vpcId;
    }
    get rosProperties() {
        return {
            databasePassword: this.databasePassword,
            databaseUser: this.databaseUser,
            dbaUid: this.dbaUid,
            envType: this.envType,
            exportTimeout: this.exportTimeout,
            host: this.host,
            instanceAlias: this.instanceAlias,
            instanceSource: this.instanceSource,
            instanceType: this.instanceType,
            networkType: this.networkType,
            port: this.port,
            queryTimeout: this.queryTimeout,
            safeRule: this.safeRule,
            tid: this.tid,
            dataLinkName: this.dataLinkName,
            ddlOnline: this.ddlOnline,
            ecsInstanceId: this.ecsInstanceId,
            ecsRegion: this.ecsRegion,
            sid: this.sid,
            useDsql: this.useDsql,
            vpcId: this.vpcId,
        };
    }
    renderProperties(props) {
        return rosInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosInstance = RosInstance;
/**
 * The resource type name for this resource class.
 */
RosInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DMS::Instance";
/**
 * Determine whether the given properties match those of a `RosUserProps`
 *
 * @param properties - the TypeScript properties of a `RosUserProps`
 *
 * @returns the result of the validation.
 */
function RosUserPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('status', ros.validateString)(properties.status));
    errors.collect(ros.propertyValidator('uid', ros.requiredValidator)(properties.uid));
    errors.collect(ros.propertyValidator('uid', ros.validateString)(properties.uid));
    errors.collect(ros.propertyValidator('userName', ros.validateString)(properties.userName));
    errors.collect(ros.propertyValidator('roleNames', ros.listValidator(ros.validateString))(properties.roleNames));
    errors.collect(ros.propertyValidator('mobile', ros.validateString)(properties.mobile));
    errors.collect(ros.propertyValidator('tid', ros.validateString)(properties.tid));
    return errors.wrap('supplied properties not correct for "RosUserProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DMS::User` resource
 *
 * @param properties - the TypeScript properties of a `RosUserProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DMS::User` resource.
 */
// @ts-ignore TS6133
function rosUserPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosUserPropsValidator(properties).assertSuccess();
    }
    return {
        Uid: ros.stringToRosTemplate(properties.uid),
        Mobile: ros.stringToRosTemplate(properties.mobile),
        RoleNames: ros.listMapper(ros.stringToRosTemplate)(properties.roleNames),
        Status: ros.stringToRosTemplate(properties.status),
        Tid: ros.stringToRosTemplate(properties.tid),
        UserName: ros.stringToRosTemplate(properties.userName),
    };
}
/**
 * A ROS template type:  `ALIYUN::DMS::User`
 */
class RosUser extends ros.RosResource {
    /**
     * Create a new `ALIYUN::DMS::User`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosUser.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrMobile = ros.Token.asString(this.getAtt('Mobile'));
        this.attrParentUid = ros.Token.asString(this.getAtt('ParentUid'));
        this.attrRoleIds = ros.Token.asString(this.getAtt('RoleIds'));
        this.attrRoleNames = ros.Token.asString(this.getAtt('RoleNames'));
        this.attrUid = ros.Token.asString(this.getAtt('Uid'));
        this.attrUserId = ros.Token.asString(this.getAtt('UserId'));
        this.attrUserName = ros.Token.asString(this.getAtt('UserName'));
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.uid = props.uid;
        this.mobile = props.mobile;
        this.roleNames = props.roleNames;
        this.status = props.status;
        this.tid = props.tid;
        this.userName = props.userName;
    }
    get rosProperties() {
        return {
            uid: this.uid,
            mobile: this.mobile,
            roleNames: this.roleNames,
            status: this.status,
            tid: this.tid,
            userName: this.userName,
        };
    }
    renderProperties(props) {
        return rosUserPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosUser = RosUser;
/**
 * The resource type name for this resource class.
 */
RosUser.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DMS::User";
//# sourceMappingURL=data:application/json;base64,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