"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupLdapLink = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/group_ldap_link gitlab_group_ldap_link}
*/
class GroupLdapLink extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/group_ldap_link gitlab_group_ldap_link} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupLdapLinkConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'gitlab_group_ldap_link',
            terraformGeneratorMetadata: {
                providerName: 'gitlab',
                providerVersion: '3.14.0',
                providerVersionConstraint: '~> 3.14.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._accessLevel = config.accessLevel;
        this._cn = config.cn;
        this._force = config.force;
        this._groupAccess = config.groupAccess;
        this._groupId = config.groupId;
        this._ldapProvider = config.ldapProvider;
    }
    get accessLevel() {
        return this.getStringAttribute('access_level');
    }
    set accessLevel(value) {
        this._accessLevel = value;
    }
    resetAccessLevel() {
        this._accessLevel = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accessLevelInput() {
        return this._accessLevel;
    }
    get cn() {
        return this.getStringAttribute('cn');
    }
    set cn(value) {
        this._cn = value;
    }
    // Temporarily expose input value. Use with caution.
    get cnInput() {
        return this._cn;
    }
    get force() {
        return this.getBooleanAttribute('force');
    }
    set force(value) {
        this._force = value;
    }
    resetForce() {
        this._force = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get forceInput() {
        return this._force;
    }
    get groupAccess() {
        return this.getStringAttribute('group_access');
    }
    set groupAccess(value) {
        this._groupAccess = value;
    }
    resetGroupAccess() {
        this._groupAccess = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get groupAccessInput() {
        return this._groupAccess;
    }
    get groupId() {
        return this.getStringAttribute('group_id');
    }
    set groupId(value) {
        this._groupId = value;
    }
    // Temporarily expose input value. Use with caution.
    get groupIdInput() {
        return this._groupId;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get ldapProvider() {
        return this.getStringAttribute('ldap_provider');
    }
    set ldapProvider(value) {
        this._ldapProvider = value;
    }
    // Temporarily expose input value. Use with caution.
    get ldapProviderInput() {
        return this._ldapProvider;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_level: cdktf.stringToTerraform(this._accessLevel),
            cn: cdktf.stringToTerraform(this._cn),
            force: cdktf.booleanToTerraform(this._force),
            group_access: cdktf.stringToTerraform(this._groupAccess),
            group_id: cdktf.stringToTerraform(this._groupId),
            ldap_provider: cdktf.stringToTerraform(this._ldapProvider),
        };
    }
}
exports.GroupLdapLink = GroupLdapLink;
_a = JSII_RTTI_SYMBOL_1;
GroupLdapLink[_a] = { fqn: "@cdktf/provider-gitlab.GroupLdapLink", version: "0.0.14" };
// =================
// STATIC PROPERTIES
// =================
GroupLdapLink.tfResourceType = "gitlab_group_ldap_link";
//# sourceMappingURL=data:application/json;base64,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