# Installation Instructions for Qiskit Dell Runtime

## Requirements

The following installation guide presumes that the user has at least the following installed:

* Python version 3.7+
* Pip3

## Client Quick Start Guide

The client (and local execution) features of the Qiskit Dell Runtime can be installed and used quickly. 

If you do not need to modify the client code, you may run:
`pip3 install qiskit-dell-runtime`

If you plan on making changes to the code, the steps to install the package are:

* Download the Qiskit Dell Runtime directory
* From inside the top-level directory, run:
  * `pip3 install .`

At this point, the `dell_runtime` package will have been installed on the machine and can be used in Python programs.

To use the Qiskit Dell Runtime Client with a remote server deployment, you will need at least one environment variable set:
* `SERVER_URL` should be set to the location on which the server is deployed (either URL or IP)
* (optional) `TOKEN` may be set to a valid OAuth authentication token that was generated by your SSO integration if you wish to avoid authenticating through a web browser
* (optional) `QDR_ID` may be set to a valid identification number provided to you from a QDR server deployed without SSO enabled if you wish to access previously-uploaded programs.

## Server Quick Start Guide

The server deployment of the Qiskit Dell Runtime requirements are:
* A running Kubernetes cluster and `kubectl` installed and configured to manage that cluster
* Kubernetes Secret Generator installed on the cluster via `helm`. Instructions for installing this chart can be found at: https://github.com/mittwald/kubernetes-secret-generator

To deploy the Qiskit Dell Runtime Server, perform the following steps beginning in the `qiskit-dell-runtime` directory:
* Edit `./server/deployments/env.sh`:
  * Replace `<cluster IP/URL>` with the IP Address or DNS name of your running Kubernetes cluster
* `cd server`
* `source deployments/env.sh`
* `make deploy_no_sso`

At this point the deployment will be created in a new namespace named `qdr`. You can view the status of the database and orchestrator pods using `kubectl get pods -n qdr`.

When both pods are `Running` the deployment is ready to be used via the `DellRuntimeProvider`'s remote runtime interface.

If you need to remove your deployment, you can run `make clean` from the `server` directory assuming that the environnment variables set in `server/deployments/env.sh` are still active in your shell.

## Deploying the Server After Making Changes

If you choose to modify the Qiskit Dell Runtime Server in any way, you must have:
* Docker installation capable of making and pushing images and a repository to which `mysql`, `qiskit`, `qdr-base`, `orchestrator`, and `executor` images can be pushed

Since your container images will not be stored in the `dellemctrigr` Dockerhub repository, you will also need to:
* Replace `dellemctrigr` with the root repository for your Docker images
* Replace `mysql:5.6` with the name of the location in your docker repository that contains a working `mysql` image.

All images are pulled from the same repository by default, but you may modify the YAML files describing the deployment if you would like to pull images from different repositories in the same deployment.

When you are ready to deploy your changes, you can run:
* `cd server`
* `source deployments/env.sh`
* `make && make push` - make sure you have tagged your images correctly!
* `make deploy_no_sso`

## Configuring Custom SSO

The Qiskit Dell Runtime Server can be run in conjunction with SSO if desired. To do so, you must already have an identity provider available - this project does not provide one. If you do have an identity provider like Google, Facebook, or a company SSO available, you can configure the server to authenticate users with that provider.

To do so, make the following changes to `server/deployments/env.sh`:
* Replace `<auth url>` with the URL your identity provider offers to users to obtain credentials.
* Replace `<token url>` with hte URL your identity provider offers to users to obtain a token once they have logged in.
* Replace `<info url>` with the URL your identity provider offers to obtain information about a user using a valid token.
* Replace `<client id>` with the client ID provided for your registered application with your identity provider.
* Replace `<client secret>` with the client secret provided for your registered application with your identity provider.
* Replace `<sso scope>` with the appropriate/enabled scopes on your identity provider. We only take a name from the user info response so these can be largely minimal with the current configuration.

Once these variables are set in your script, run the following from the `server` directory:
* `source deployments/env.sh`
* `make && make push`
* `make deploy_with_sso`

The code on the server that interfaces with the SSO provider has occasionally needed certificates uploaded to the pod to function. Should you run into an SSL error let us know - we have been able to make it work for some providers but not all.

## Configuring Custom Database

If you'd prefer to use a different database in conjunction with the Qiskit Dell Runtime Server, you may edit `server/deployment/env.sh` with the necessary parameters. The server has been tested with `PostgreSQL` and `MySQL`; other databases may require further configuration.

Generally, you may follow these steps to configure a custom database in `server/deployments/env.sh`:
* Update `DB_IMAGE` with the database image you would prefer to use
* Update `DB_TYPE` and `DB_NAME` with the kind of database you are using; worthy of note is that for `PostgreSQL` `DB_TYPE` should contain "postgresql" while `DB_NAME` should contain "postgres"
* Make any other changes to `DB_DATABASE`, `DB_USER`, or `DB_PORT` that are required.

