# coding: utf-8

"""
    pymetrics API

    ### This is pymetrics's public API. The API can be used to get information on candidates as part of a job application workflow, or for employee career pathing and development. The typical use case for this is to support an externally initiated assessment for a candidate job application. This is often done \"inline\" with the candidate's application, or asynchronously after the candidate submits their application. This data can then be used for career pathing and employee development in subsequent stages.  The expected sequence of API calls is: * `Generate OAuth Token` with the OAuth Client ID and Secret you've been provided * `Get Assessment Configurations` to determine which configured assessment templates are available * `Create Assessment Order` for a selected Assessment and candidate job application * `Get Assessment Order` to receive the recommendation results and reports, once they are available  # noqa: E501

    The version of the OpenAPI document: 2.2.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from pymetrics_soft_skills_sdk.configuration import Configuration


class MercuryResult(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'assessment': 'MercuryAssessment',
        'create_date': 'datetime',
        'description': 'str',
        'score': 'float',
        'band': 'str'
    }

    attribute_map = {
        'assessment': 'assessment',
        'create_date': 'create_date',
        'description': 'description',
        'score': 'score',
        'band': 'band'
    }

    def __init__(self, assessment=None, create_date=None, description=None, score=None, band=None, local_vars_configuration=None):  # noqa: E501
        """MercuryResult - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._assessment = None
        self._create_date = None
        self._description = None
        self._score = None
        self._band = None
        self.discriminator = None

        self.assessment = assessment
        self.create_date = create_date
        if description is not None:
            self.description = description
        if score is not None:
            self.score = score
        if band is not None:
            self.band = band

    @property
    def assessment(self):
        """Gets the assessment of this MercuryResult.  # noqa: E501


        :return: The assessment of this MercuryResult.  # noqa: E501
        :rtype: MercuryAssessment
        """
        return self._assessment

    @assessment.setter
    def assessment(self, assessment):
        """Sets the assessment of this MercuryResult.


        :param assessment: The assessment of this MercuryResult.  # noqa: E501
        :type assessment: MercuryAssessment
        """
        if self.local_vars_configuration.client_side_validation and assessment is None:  # noqa: E501
            raise ValueError("Invalid value for `assessment`, must not be `None`")  # noqa: E501

        self._assessment = assessment

    @property
    def create_date(self):
        """Gets the create_date of this MercuryResult.  # noqa: E501


        :return: The create_date of this MercuryResult.  # noqa: E501
        :rtype: datetime
        """
        return self._create_date

    @create_date.setter
    def create_date(self, create_date):
        """Sets the create_date of this MercuryResult.


        :param create_date: The create_date of this MercuryResult.  # noqa: E501
        :type create_date: datetime
        """
        if self.local_vars_configuration.client_side_validation and create_date is None:  # noqa: E501
            raise ValueError("Invalid value for `create_date`, must not be `None`")  # noqa: E501

        self._create_date = create_date

    @property
    def description(self):
        """Gets the description of this MercuryResult.  # noqa: E501


        :return: The description of this MercuryResult.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this MercuryResult.


        :param description: The description of this MercuryResult.  # noqa: E501
        :type description: str
        """

        self._description = description

    @property
    def score(self):
        """Gets the score of this MercuryResult.  # noqa: E501


        :return: The score of this MercuryResult.  # noqa: E501
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """Sets the score of this MercuryResult.


        :param score: The score of this MercuryResult.  # noqa: E501
        :type score: float
        """

        self._score = score

    @property
    def band(self):
        """Gets the band of this MercuryResult.  # noqa: E501


        :return: The band of this MercuryResult.  # noqa: E501
        :rtype: str
        """
        return self._band

    @band.setter
    def band(self, band):
        """Sets the band of this MercuryResult.


        :param band: The band of this MercuryResult.  # noqa: E501
        :type band: str
        """

        self._band = band

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MercuryResult):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MercuryResult):
            return True

        return self.to_dict() != other.to_dict()
