# coding: utf-8

"""
    pymetrics API

    ### This is pymetrics's public API. The API can be used to get information on candidates as part of a job application workflow, or for employee career pathing and development. The typical use case for this is to support an externally initiated assessment for a candidate job application. This is often done \"inline\" with the candidate's application, or asynchronously after the candidate submits their application. This data can then be used for career pathing and employee development in subsequent stages.  The expected sequence of API calls is: * `Generate OAuth Token` with the OAuth Client ID and Secret you've been provided * `Get Assessment Configurations` to determine which configured assessment templates are available * `Create Assessment Order` for a selected Assessment and candidate job application * `Get Assessment Order` to receive the recommendation results and reports, once they are available  # noqa: E501

    The version of the OpenAPI document: 2.2.0
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from openapi_client.configuration import Configuration


class MercuryOrderMetadata(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'status': 'PontemOrderStatuses',
        'assessment_id': 'str',
        'implementation_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'status': 'status',
        'assessment_id': 'assessment_id',
        'implementation_id': 'implementation_id'
    }

    def __init__(self, id=None, status=None, assessment_id=None, implementation_id=None, local_vars_configuration=None):  # noqa: E501
        """MercuryOrderMetadata - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._status = None
        self._assessment_id = None
        self._implementation_id = None
        self.discriminator = None

        self.id = id
        self.status = status
        self.assessment_id = assessment_id
        self.implementation_id = implementation_id

    @property
    def id(self):
        """Gets the id of this MercuryOrderMetadata.  # noqa: E501


        :return: The id of this MercuryOrderMetadata.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this MercuryOrderMetadata.


        :param id: The id of this MercuryOrderMetadata.  # noqa: E501
        :type id: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def status(self):
        """Gets the status of this MercuryOrderMetadata.  # noqa: E501


        :return: The status of this MercuryOrderMetadata.  # noqa: E501
        :rtype: PontemOrderStatuses
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this MercuryOrderMetadata.


        :param status: The status of this MercuryOrderMetadata.  # noqa: E501
        :type status: PontemOrderStatuses
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501

        self._status = status

    @property
    def assessment_id(self):
        """Gets the assessment_id of this MercuryOrderMetadata.  # noqa: E501


        :return: The assessment_id of this MercuryOrderMetadata.  # noqa: E501
        :rtype: str
        """
        return self._assessment_id

    @assessment_id.setter
    def assessment_id(self, assessment_id):
        """Sets the assessment_id of this MercuryOrderMetadata.


        :param assessment_id: The assessment_id of this MercuryOrderMetadata.  # noqa: E501
        :type assessment_id: str
        """
        if self.local_vars_configuration.client_side_validation and assessment_id is None:  # noqa: E501
            raise ValueError("Invalid value for `assessment_id`, must not be `None`")  # noqa: E501

        self._assessment_id = assessment_id

    @property
    def implementation_id(self):
        """Gets the implementation_id of this MercuryOrderMetadata.  # noqa: E501


        :return: The implementation_id of this MercuryOrderMetadata.  # noqa: E501
        :rtype: str
        """
        return self._implementation_id

    @implementation_id.setter
    def implementation_id(self, implementation_id):
        """Sets the implementation_id of this MercuryOrderMetadata.


        :param implementation_id: The implementation_id of this MercuryOrderMetadata.  # noqa: E501
        :type implementation_id: str
        """
        if self.local_vars_configuration.client_side_validation and implementation_id is None:  # noqa: E501
            raise ValueError("Invalid value for `implementation_id`, must not be `None`")  # noqa: E501

        self._implementation_id = implementation_id

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MercuryOrderMetadata):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MercuryOrderMetadata):
            return True

        return self.to_dict() != other.to_dict()
